/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.MessageReflection;
import com.google.protobuf.TextFormatEscaper;
import com.google.protobuf.TextFormatParseInfoTree;
import com.google.protobuf.TextFormatParseLocation;
import com.google.protobuf.UnknownFieldSet;
import com.google.protobuf.WireFormat;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class TextFormat {
    private static final Logger logger = Logger.getLogger(TextFormat.class.getName());
    private static final Parser PARSER = Parser.newBuilder().build();

    private TextFormat() {
    }

    public static void print(MessageOrBuilder message2, Appendable output) throws IOException {
        Printer.DEFAULT.print(message2, TextFormat.multiLineOutput(output));
    }

    public static void print(UnknownFieldSet fields2, Appendable output) throws IOException {
        Printer.DEFAULT.printUnknownFields(fields2, TextFormat.multiLineOutput(output));
    }

    public static void printUnicode(MessageOrBuilder message2, Appendable output) throws IOException {
        Printer.UNICODE.print(message2, TextFormat.multiLineOutput(output));
    }

    public static void printUnicode(UnknownFieldSet fields2, Appendable output) throws IOException {
        Printer.UNICODE.printUnknownFields(fields2, TextFormat.multiLineOutput(output));
    }

    public static String shortDebugString(MessageOrBuilder message2) {
        try {
            StringBuilder text2 = new StringBuilder();
            Printer.DEFAULT.print(message2, TextFormat.singleLineOutput(text2));
            return text2.toString();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static String shortDebugString(Descriptors.FieldDescriptor field2, Object value2) {
        try {
            StringBuilder text2 = new StringBuilder();
            Printer.DEFAULT.printField(field2, value2, TextFormat.singleLineOutput(text2));
            return text2.toString();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static String shortDebugString(UnknownFieldSet fields2) {
        try {
            StringBuilder text2 = new StringBuilder();
            Printer.DEFAULT.printUnknownFields(fields2, TextFormat.singleLineOutput(text2));
            return text2.toString();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static String printToString(MessageOrBuilder message2) {
        try {
            StringBuilder text2 = new StringBuilder();
            TextFormat.print(message2, (Appendable)text2);
            return text2.toString();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static String printToString(UnknownFieldSet fields2) {
        try {
            StringBuilder text2 = new StringBuilder();
            TextFormat.print(fields2, (Appendable)text2);
            return text2.toString();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static String printToUnicodeString(MessageOrBuilder message2) {
        try {
            StringBuilder text2 = new StringBuilder();
            Printer.UNICODE.print(message2, TextFormat.multiLineOutput(text2));
            return text2.toString();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static String printToUnicodeString(UnknownFieldSet fields2) {
        try {
            StringBuilder text2 = new StringBuilder();
            Printer.UNICODE.printUnknownFields(fields2, TextFormat.multiLineOutput(text2));
            return text2.toString();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static void printField(Descriptors.FieldDescriptor field2, Object value2, Appendable output) throws IOException {
        Printer.DEFAULT.printField(field2, value2, TextFormat.multiLineOutput(output));
    }

    public static String printFieldToString(Descriptors.FieldDescriptor field2, Object value2) {
        try {
            StringBuilder text2 = new StringBuilder();
            TextFormat.printField(field2, value2, text2);
            return text2.toString();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static void printUnicodeFieldValue(Descriptors.FieldDescriptor field2, Object value2, Appendable output) throws IOException {
        Printer.UNICODE.printFieldValue(field2, value2, TextFormat.multiLineOutput(output));
    }

    public static void printFieldValue(Descriptors.FieldDescriptor field2, Object value2, Appendable output) throws IOException {
        Printer.DEFAULT.printFieldValue(field2, value2, TextFormat.multiLineOutput(output));
    }

    public static void printUnknownFieldValue(int tag, Object value2, Appendable output) throws IOException {
        TextFormat.printUnknownFieldValue(tag, value2, TextFormat.multiLineOutput(output));
    }

    private static void printUnknownFieldValue(int tag, Object value2, TextGenerator generator) throws IOException {
        switch (WireFormat.getTagWireType(tag)) {
            case 0: {
                generator.print(TextFormat.unsignedToString((Long)value2));
                break;
            }
            case 5: {
                generator.print(String.format((Locale)null, "0x%08x", (Integer)value2));
                break;
            }
            case 1: {
                generator.print(String.format((Locale)null, "0x%016x", (Long)value2));
                break;
            }
            case 2: {
                try {
                    UnknownFieldSet message2 = UnknownFieldSet.parseFrom((ByteString)value2);
                    generator.print("{");
                    generator.eol();
                    generator.indent();
                    Printer.DEFAULT.printUnknownFields(message2, generator);
                    generator.outdent();
                    generator.print("}");
                }
                catch (InvalidProtocolBufferException e) {
                    generator.print("\"");
                    generator.print(TextFormat.escapeBytes((ByteString)value2));
                    generator.print("\"");
                }
                break;
            }
            case 3: {
                Printer.DEFAULT.printUnknownFields((UnknownFieldSet)value2, generator);
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad tag: " + tag);
            }
        }
    }

    public static String unsignedToString(int value2) {
        if (value2 >= 0) {
            return Integer.toString(value2);
        }
        return Long.toString((long)value2 & 0xFFFFFFFFL);
    }

    public static String unsignedToString(long value2) {
        if (value2 >= 0L) {
            return Long.toString(value2);
        }
        return BigInteger.valueOf(value2 & Long.MAX_VALUE).setBit(63).toString();
    }

    private static TextGenerator multiLineOutput(Appendable output) {
        return new TextGenerator(output, false);
    }

    private static TextGenerator singleLineOutput(Appendable output) {
        return new TextGenerator(output, true);
    }

    public static Parser getParser() {
        return PARSER;
    }

    public static void merge(Readable input, Message.Builder builder) throws IOException {
        PARSER.merge(input, builder);
    }

    public static void merge(CharSequence input, Message.Builder builder) throws ParseException {
        PARSER.merge(input, builder);
    }

    public static void merge(Readable input, ExtensionRegistry extensionRegistry, Message.Builder builder) throws IOException {
        PARSER.merge(input, extensionRegistry, builder);
    }

    public static void merge(CharSequence input, ExtensionRegistry extensionRegistry, Message.Builder builder) throws ParseException {
        PARSER.merge(input, extensionRegistry, builder);
    }

    public static String escapeBytes(ByteString input) {
        return TextFormatEscaper.escapeBytes(input);
    }

    public static String escapeBytes(byte[] input) {
        return TextFormatEscaper.escapeBytes(input);
    }

    public static ByteString unescapeBytes(CharSequence charString) throws InvalidEscapeSequenceException {
        ByteString input = ByteString.copyFromUtf8(charString.toString());
        byte[] result2 = new byte[input.size()];
        int pos2 = 0;
        block13: for (int i = 0; i < input.size(); ++i) {
            byte c = input.byteAt(i);
            if (c == 92) {
                if (i + 1 < input.size()) {
                    int code;
                    if (TextFormat.isOctal(c = input.byteAt(++i))) {
                        code = TextFormat.digitValue(c);
                        if (i + 1 < input.size() && TextFormat.isOctal(input.byteAt(i + 1))) {
                            code = code * 8 + TextFormat.digitValue(input.byteAt(++i));
                        }
                        if (i + 1 < input.size() && TextFormat.isOctal(input.byteAt(i + 1))) {
                            code = code * 8 + TextFormat.digitValue(input.byteAt(++i));
                        }
                        result2[pos2++] = (byte)code;
                        continue;
                    }
                    switch (c) {
                        case 97: {
                            result2[pos2++] = 7;
                            continue block13;
                        }
                        case 98: {
                            result2[pos2++] = 8;
                            continue block13;
                        }
                        case 102: {
                            result2[pos2++] = 12;
                            continue block13;
                        }
                        case 110: {
                            result2[pos2++] = 10;
                            continue block13;
                        }
                        case 114: {
                            result2[pos2++] = 13;
                            continue block13;
                        }
                        case 116: {
                            result2[pos2++] = 9;
                            continue block13;
                        }
                        case 118: {
                            result2[pos2++] = 11;
                            continue block13;
                        }
                        case 92: {
                            result2[pos2++] = 92;
                            continue block13;
                        }
                        case 39: {
                            result2[pos2++] = 39;
                            continue block13;
                        }
                        case 34: {
                            result2[pos2++] = 34;
                            continue block13;
                        }
                        case 120: {
                            code = 0;
                            if (i + 1 >= input.size() || !TextFormat.isHex(input.byteAt(i + 1))) {
                                throw new InvalidEscapeSequenceException("Invalid escape sequence: '\\x' with no digits");
                            }
                            code = TextFormat.digitValue(input.byteAt(++i));
                            if (i + 1 < input.size() && TextFormat.isHex(input.byteAt(i + 1))) {
                                code = code * 16 + TextFormat.digitValue(input.byteAt(++i));
                            }
                            result2[pos2++] = (byte)code;
                            continue block13;
                        }
                        default: {
                            throw new InvalidEscapeSequenceException("Invalid escape sequence: '\\" + (char)c + '\'');
                        }
                    }
                }
                throw new InvalidEscapeSequenceException("Invalid escape sequence: '\\' at end of string.");
            }
            result2[pos2++] = c;
        }
        return result2.length == pos2 ? ByteString.wrap(result2) : ByteString.copyFrom(result2, 0, pos2);
    }

    static String escapeText(String input) {
        return TextFormat.escapeBytes(ByteString.copyFromUtf8(input));
    }

    public static String escapeDoubleQuotesAndBackslashes(String input) {
        return TextFormatEscaper.escapeDoubleQuotesAndBackslashes(input);
    }

    static String unescapeText(String input) throws InvalidEscapeSequenceException {
        return TextFormat.unescapeBytes(input).toStringUtf8();
    }

    private static boolean isOctal(byte c) {
        return 48 <= c && c <= 55;
    }

    private static boolean isHex(byte c) {
        return 48 <= c && c <= 57 || 97 <= c && c <= 102 || 65 <= c && c <= 70;
    }

    private static int digitValue(byte c) {
        if (48 <= c && c <= 57) {
            return c - 48;
        }
        if (97 <= c && c <= 122) {
            return c - 97 + 10;
        }
        return c - 65 + 10;
    }

    static int parseInt32(String text2) throws NumberFormatException {
        return (int)TextFormat.parseInteger(text2, true, false);
    }

    static int parseUInt32(String text2) throws NumberFormatException {
        return (int)TextFormat.parseInteger(text2, false, false);
    }

    static long parseInt64(String text2) throws NumberFormatException {
        return TextFormat.parseInteger(text2, true, true);
    }

    static long parseUInt64(String text2) throws NumberFormatException {
        return TextFormat.parseInteger(text2, false, true);
    }

    private static long parseInteger(String text2, boolean isSigned, boolean isLong) throws NumberFormatException {
        int pos2 = 0;
        boolean negative = false;
        if (text2.startsWith("-", pos2)) {
            if (!isSigned) {
                throw new NumberFormatException("Number must be positive: " + text2);
            }
            ++pos2;
            negative = true;
        }
        int radix = 10;
        if (text2.startsWith("0x", pos2)) {
            pos2 += 2;
            radix = 16;
        } else if (text2.startsWith("0", pos2)) {
            radix = 8;
        }
        String numberText = text2.substring(pos2);
        long result2 = 0L;
        if (numberText.length() < 16) {
            result2 = Long.parseLong(numberText, radix);
            if (negative) {
                result2 = -result2;
            }
            if (!isLong) {
                if (isSigned) {
                    if (result2 > Integer.MAX_VALUE || result2 < Integer.MIN_VALUE) {
                        throw new NumberFormatException("Number out of range for 32-bit signed integer: " + text2);
                    }
                } else if (result2 >= 0x100000000L || result2 < 0L) {
                    throw new NumberFormatException("Number out of range for 32-bit unsigned integer: " + text2);
                }
            }
        } else {
            BigInteger bigValue = new BigInteger(numberText, radix);
            if (negative) {
                bigValue = bigValue.negate();
            }
            if (!isLong) {
                if (isSigned) {
                    if (bigValue.bitLength() > 31) {
                        throw new NumberFormatException("Number out of range for 32-bit signed integer: " + text2);
                    }
                } else if (bigValue.bitLength() > 32) {
                    throw new NumberFormatException("Number out of range for 32-bit unsigned integer: " + text2);
                }
            } else if (isSigned) {
                if (bigValue.bitLength() > 63) {
                    throw new NumberFormatException("Number out of range for 64-bit signed integer: " + text2);
                }
            } else if (bigValue.bitLength() > 64) {
                throw new NumberFormatException("Number out of range for 64-bit unsigned integer: " + text2);
            }
            result2 = bigValue.longValue();
        }
        return result2;
    }

    public static class InvalidEscapeSequenceException
    extends IOException {
        private static final long serialVersionUID = -8164033650142593304L;

        InvalidEscapeSequenceException(String description) {
            super(description);
        }
    }

    public static class Parser {
        private final boolean allowUnknownFields;
        private final SingularOverwritePolicy singularOverwritePolicy;
        private TextFormatParseInfoTree.Builder parseInfoTreeBuilder;
        private static final int BUFFER_SIZE = 4096;

        private Parser(boolean allowUnknownFields, SingularOverwritePolicy singularOverwritePolicy, TextFormatParseInfoTree.Builder parseInfoTreeBuilder) {
            this.allowUnknownFields = allowUnknownFields;
            this.singularOverwritePolicy = singularOverwritePolicy;
            this.parseInfoTreeBuilder = parseInfoTreeBuilder;
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public void merge(Readable input, Message.Builder builder) throws IOException {
            this.merge(input, ExtensionRegistry.getEmptyRegistry(), builder);
        }

        public void merge(CharSequence input, Message.Builder builder) throws ParseException {
            this.merge(input, ExtensionRegistry.getEmptyRegistry(), builder);
        }

        public void merge(Readable input, ExtensionRegistry extensionRegistry, Message.Builder builder) throws IOException {
            this.merge(Parser.toStringBuilder(input), extensionRegistry, builder);
        }

        private static StringBuilder toStringBuilder(Readable input) throws IOException {
            int n;
            StringBuilder text2 = new StringBuilder();
            CharBuffer buffer = CharBuffer.allocate(4096);
            while ((n = input.read(buffer)) != -1) {
                buffer.flip();
                text2.append(buffer, 0, n);
            }
            return text2;
        }

        private void checkUnknownFields(List<String> unknownFields) throws ParseException {
            if (unknownFields.isEmpty()) {
                return;
            }
            StringBuilder msg = new StringBuilder("Input contains unknown fields and/or extensions:");
            for (String field2 : unknownFields) {
                msg.append('\n').append(field2);
            }
            if (!this.allowUnknownFields) {
                String[] lineColumn = unknownFields.get(0).split(":");
                throw new ParseException(Integer.valueOf(lineColumn[0]), Integer.valueOf(lineColumn[1]), msg.toString());
            }
            logger.warning(msg.toString());
        }

        public void merge(CharSequence input, ExtensionRegistry extensionRegistry, Message.Builder builder) throws ParseException {
            Tokenizer tokenizer = new Tokenizer(input);
            MessageReflection.BuilderAdapter target = new MessageReflection.BuilderAdapter(builder);
            ArrayList<String> unknownFields = new ArrayList<String>();
            while (!tokenizer.atEnd()) {
                this.mergeField(tokenizer, extensionRegistry, target, unknownFields);
            }
            this.checkUnknownFields(unknownFields);
        }

        private void mergeField(Tokenizer tokenizer, ExtensionRegistry extensionRegistry, MessageReflection.MergeTarget target, List<String> unknownFields) throws ParseException {
            this.mergeField(tokenizer, extensionRegistry, target, this.parseInfoTreeBuilder, unknownFields);
        }

        private void mergeField(Tokenizer tokenizer, ExtensionRegistry extensionRegistry, MessageReflection.MergeTarget target, TextFormatParseInfoTree.Builder parseTreeBuilder, List<String> unknownFields) throws ParseException {
            CharSequence name2;
            Descriptors.FieldDescriptor field2 = null;
            int startLine2 = tokenizer.getLine();
            int startColumn = tokenizer.getColumn();
            Descriptors.Descriptor type2 = target.getDescriptorForType();
            ExtensionRegistry.ExtensionInfo extension2 = null;
            if (tokenizer.tryConsume("[")) {
                name2 = new StringBuilder(tokenizer.consumeIdentifier());
                while (tokenizer.tryConsume(".")) {
                    ((StringBuilder)name2).append('.');
                    ((StringBuilder)name2).append(tokenizer.consumeIdentifier());
                }
                extension2 = target.findExtensionByName(extensionRegistry, ((StringBuilder)name2).toString());
                if (extension2 == null) {
                    unknownFields.add(tokenizer.getPreviousLine() + 1 + ":" + (tokenizer.getPreviousColumn() + 1) + ":\t" + type2.getFullName() + ".[" + name2 + "]");
                } else {
                    if (extension2.descriptor.getContainingType() != type2) {
                        throw tokenizer.parseExceptionPreviousToken("Extension \"" + name2 + "\" does not extend message type \"" + type2.getFullName() + "\".");
                    }
                    field2 = extension2.descriptor;
                }
                tokenizer.consume("]");
            } else {
                String lowerName;
                name2 = tokenizer.consumeIdentifier();
                field2 = type2.findFieldByName((String)name2);
                if (field2 == null && (field2 = type2.findFieldByName(lowerName = ((String)name2).toLowerCase(Locale.US))) != null && field2.getType() != Descriptors.FieldDescriptor.Type.GROUP) {
                    field2 = null;
                }
                if (field2 != null && field2.getType() == Descriptors.FieldDescriptor.Type.GROUP && !field2.getMessageType().getName().equals(name2)) {
                    field2 = null;
                }
                if (field2 == null) {
                    unknownFields.add(tokenizer.getPreviousLine() + 1 + ":" + (tokenizer.getPreviousColumn() + 1) + ":\t" + type2.getFullName() + "." + (String)name2);
                }
            }
            if (field2 == null) {
                if (tokenizer.tryConsume(":") && !tokenizer.lookingAt("{") && !tokenizer.lookingAt("<")) {
                    this.skipFieldValue(tokenizer);
                } else {
                    this.skipFieldMessage(tokenizer);
                }
                return;
            }
            if (field2.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                tokenizer.tryConsume(":");
                if (parseTreeBuilder != null) {
                    TextFormatParseInfoTree.Builder childParseTreeBuilder = parseTreeBuilder.getBuilderForSubMessageField(field2);
                    this.consumeFieldValues(tokenizer, extensionRegistry, target, field2, extension2, childParseTreeBuilder, unknownFields);
                } else {
                    this.consumeFieldValues(tokenizer, extensionRegistry, target, field2, extension2, parseTreeBuilder, unknownFields);
                }
            } else {
                tokenizer.consume(":");
                this.consumeFieldValues(tokenizer, extensionRegistry, target, field2, extension2, parseTreeBuilder, unknownFields);
            }
            if (parseTreeBuilder != null) {
                parseTreeBuilder.setLocation(field2, TextFormatParseLocation.create(startLine2, startColumn));
            }
            if (!tokenizer.tryConsume(";")) {
                tokenizer.tryConsume(",");
            }
        }

        private void consumeFieldValues(Tokenizer tokenizer, ExtensionRegistry extensionRegistry, MessageReflection.MergeTarget target, Descriptors.FieldDescriptor field2, ExtensionRegistry.ExtensionInfo extension2, TextFormatParseInfoTree.Builder parseTreeBuilder, List<String> unknownFields) throws ParseException {
            if (field2.isRepeated() && tokenizer.tryConsume("[")) {
                if (!tokenizer.tryConsume("]")) {
                    while (true) {
                        this.consumeFieldValue(tokenizer, extensionRegistry, target, field2, extension2, parseTreeBuilder, unknownFields);
                        if (!tokenizer.tryConsume("]")) {
                            tokenizer.consume(",");
                            continue;
                        }
                        break;
                    }
                }
            } else {
                this.consumeFieldValue(tokenizer, extensionRegistry, target, field2, extension2, parseTreeBuilder, unknownFields);
            }
        }

        private void consumeFieldValue(Tokenizer tokenizer, ExtensionRegistry extensionRegistry, MessageReflection.MergeTarget target, Descriptors.FieldDescriptor field2, ExtensionRegistry.ExtensionInfo extension2, TextFormatParseInfoTree.Builder parseTreeBuilder, List<String> unknownFields) throws ParseException {
            Object value2 = null;
            if (field2.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                String endToken;
                if (tokenizer.tryConsume("<")) {
                    endToken = ">";
                } else {
                    tokenizer.consume("{");
                    endToken = "}";
                }
                MessageReflection.MergeTarget subField = target.newMergeTargetForField(field2, extension2 == null ? null : extension2.defaultInstance);
                while (!tokenizer.tryConsume(endToken)) {
                    if (tokenizer.atEnd()) {
                        throw tokenizer.parseException("Expected \"" + endToken + "\".");
                    }
                    this.mergeField(tokenizer, extensionRegistry, subField, parseTreeBuilder, unknownFields);
                }
                value2 = subField.finish();
            } else {
                switch (field2.getType()) {
                    case INT32: 
                    case SINT32: 
                    case SFIXED32: {
                        value2 = tokenizer.consumeInt32();
                        break;
                    }
                    case INT64: 
                    case SINT64: 
                    case SFIXED64: {
                        value2 = tokenizer.consumeInt64();
                        break;
                    }
                    case UINT32: 
                    case FIXED32: {
                        value2 = tokenizer.consumeUInt32();
                        break;
                    }
                    case UINT64: 
                    case FIXED64: {
                        value2 = tokenizer.consumeUInt64();
                        break;
                    }
                    case FLOAT: {
                        value2 = Float.valueOf(tokenizer.consumeFloat());
                        break;
                    }
                    case DOUBLE: {
                        value2 = tokenizer.consumeDouble();
                        break;
                    }
                    case BOOL: {
                        value2 = tokenizer.consumeBoolean();
                        break;
                    }
                    case STRING: {
                        value2 = tokenizer.consumeString();
                        break;
                    }
                    case BYTES: {
                        value2 = tokenizer.consumeByteString();
                        break;
                    }
                    case ENUM: {
                        Descriptors.EnumDescriptor enumType2 = field2.getEnumType();
                        if (tokenizer.lookingAtInteger()) {
                            int number2 = tokenizer.consumeInt32();
                            value2 = enumType2.findValueByNumber(number2);
                            if (value2 != null) break;
                            throw tokenizer.parseExceptionPreviousToken("Enum type \"" + enumType2.getFullName() + "\" has no value with number " + number2 + '.');
                        }
                        String id2 = tokenizer.consumeIdentifier();
                        value2 = enumType2.findValueByName(id2);
                        if (value2 != null) break;
                        throw tokenizer.parseExceptionPreviousToken("Enum type \"" + enumType2.getFullName() + "\" has no value named \"" + id2 + "\".");
                    }
                    case MESSAGE: 
                    case GROUP: {
                        throw new RuntimeException("Can't get here.");
                    }
                }
            }
            if (field2.isRepeated()) {
                target.addRepeatedField(field2, value2);
            } else {
                if (this.singularOverwritePolicy == SingularOverwritePolicy.FORBID_SINGULAR_OVERWRITES && target.hasField(field2)) {
                    throw tokenizer.parseExceptionPreviousToken("Non-repeated field \"" + field2.getFullName() + "\" cannot be overwritten.");
                }
                if (this.singularOverwritePolicy == SingularOverwritePolicy.FORBID_SINGULAR_OVERWRITES && field2.getContainingOneof() != null && target.hasOneof(field2.getContainingOneof())) {
                    Descriptors.OneofDescriptor oneof = field2.getContainingOneof();
                    throw tokenizer.parseExceptionPreviousToken("Field \"" + field2.getFullName() + "\" is specified along with field \"" + target.getOneofFieldDescriptor(oneof).getFullName() + "\", another member of oneof \"" + oneof.getName() + "\".");
                }
                target.setField(field2, value2);
            }
        }

        private void skipField(Tokenizer tokenizer) throws ParseException {
            if (tokenizer.tryConsume("[")) {
                do {
                    tokenizer.consumeIdentifier();
                } while (tokenizer.tryConsume("."));
                tokenizer.consume("]");
            } else {
                tokenizer.consumeIdentifier();
            }
            if (tokenizer.tryConsume(":") && !tokenizer.lookingAt("<") && !tokenizer.lookingAt("{")) {
                this.skipFieldValue(tokenizer);
            } else {
                this.skipFieldMessage(tokenizer);
            }
            if (!tokenizer.tryConsume(";")) {
                tokenizer.tryConsume(",");
            }
        }

        private void skipFieldMessage(Tokenizer tokenizer) throws ParseException {
            String delimiter;
            if (tokenizer.tryConsume("<")) {
                delimiter = ">";
            } else {
                tokenizer.consume("{");
                delimiter = "}";
            }
            while (!tokenizer.lookingAt(">") && !tokenizer.lookingAt("}")) {
                this.skipField(tokenizer);
            }
            tokenizer.consume(delimiter);
        }

        private void skipFieldValue(Tokenizer tokenizer) throws ParseException {
            if (tokenizer.tryConsumeString()) {
                while (tokenizer.tryConsumeString()) {
                }
                return;
            }
            if (!(tokenizer.tryConsumeIdentifier() || tokenizer.tryConsumeInt64() || tokenizer.tryConsumeUInt64() || tokenizer.tryConsumeDouble() || tokenizer.tryConsumeFloat())) {
                throw tokenizer.parseException("Invalid field value: " + tokenizer.currentToken);
            }
        }

        public static class Builder {
            private boolean allowUnknownFields = false;
            private SingularOverwritePolicy singularOverwritePolicy = SingularOverwritePolicy.ALLOW_SINGULAR_OVERWRITES;
            private TextFormatParseInfoTree.Builder parseInfoTreeBuilder = null;

            public Builder setSingularOverwritePolicy(SingularOverwritePolicy p) {
                this.singularOverwritePolicy = p;
                return this;
            }

            public Builder setParseInfoTreeBuilder(TextFormatParseInfoTree.Builder parseInfoTreeBuilder) {
                this.parseInfoTreeBuilder = parseInfoTreeBuilder;
                return this;
            }

            public Parser build() {
                return new Parser(this.allowUnknownFields, this.singularOverwritePolicy, this.parseInfoTreeBuilder);
            }
        }

        public static enum SingularOverwritePolicy {
            ALLOW_SINGULAR_OVERWRITES,
            FORBID_SINGULAR_OVERWRITES;

        }
    }

    public static class UnknownFieldParseException
    extends ParseException {
        private final String unknownField;

        public UnknownFieldParseException(String message2) {
            this(-1, -1, "", message2);
        }

        public UnknownFieldParseException(int line, int column, String unknownField, String message2) {
            super(line, column, message2);
            this.unknownField = unknownField;
        }

        public String getUnknownField() {
            return this.unknownField;
        }
    }

    public static class ParseException
    extends IOException {
        private static final long serialVersionUID = 3196188060225107702L;
        private final int line;
        private final int column;

        public ParseException(String message2) {
            this(-1, -1, message2);
        }

        public ParseException(int line, int column, String message2) {
            super(Integer.toString(line) + ":" + column + ": " + message2);
            this.line = line;
            this.column = column;
        }

        public int getLine() {
            return this.line;
        }

        public int getColumn() {
            return this.column;
        }
    }

    private static final class Tokenizer {
        private final CharSequence text;
        private final Matcher matcher;
        private String currentToken;
        private int pos = 0;
        private int line = 0;
        private int column = 0;
        private int previousLine = 0;
        private int previousColumn = 0;
        private static final Pattern WHITESPACE = Pattern.compile("(\\s|(#.*$))++", 8);
        private static final Pattern TOKEN = Pattern.compile("[a-zA-Z_][0-9a-zA-Z_+-]*+|[.]?[0-9+-][0-9a-zA-Z_.+-]*+|\"([^\"\n\\\\]|\\\\.)*+(\"|\\\\?$)|'([^'\n\\\\]|\\\\.)*+('|\\\\?$)", 8);
        private static final Pattern DOUBLE_INFINITY = Pattern.compile("-?inf(inity)?", 2);
        private static final Pattern FLOAT_INFINITY = Pattern.compile("-?inf(inity)?f?", 2);
        private static final Pattern FLOAT_NAN = Pattern.compile("nanf?", 2);

        private Tokenizer(CharSequence text2) {
            this.text = text2;
            this.matcher = WHITESPACE.matcher(text2);
            this.skipWhitespace();
            this.nextToken();
        }

        int getPreviousLine() {
            return this.previousLine;
        }

        int getPreviousColumn() {
            return this.previousColumn;
        }

        int getLine() {
            return this.line;
        }

        int getColumn() {
            return this.column;
        }

        public boolean atEnd() {
            return this.currentToken.length() == 0;
        }

        public void nextToken() {
            this.previousLine = this.line;
            this.previousColumn = this.column;
            while (this.pos < this.matcher.regionStart()) {
                if (this.text.charAt(this.pos) == '\n') {
                    ++this.line;
                    this.column = 0;
                } else {
                    ++this.column;
                }
                ++this.pos;
            }
            if (this.matcher.regionStart() == this.matcher.regionEnd()) {
                this.currentToken = "";
            } else {
                this.matcher.usePattern(TOKEN);
                if (this.matcher.lookingAt()) {
                    this.currentToken = this.matcher.group();
                    this.matcher.region(this.matcher.end(), this.matcher.regionEnd());
                } else {
                    this.currentToken = String.valueOf(this.text.charAt(this.pos));
                    this.matcher.region(this.pos + 1, this.matcher.regionEnd());
                }
                this.skipWhitespace();
            }
        }

        private void skipWhitespace() {
            this.matcher.usePattern(WHITESPACE);
            if (this.matcher.lookingAt()) {
                this.matcher.region(this.matcher.end(), this.matcher.regionEnd());
            }
        }

        public boolean tryConsume(String token) {
            if (this.currentToken.equals(token)) {
                this.nextToken();
                return true;
            }
            return false;
        }

        public void consume(String token) throws ParseException {
            if (!this.tryConsume(token)) {
                throw this.parseException("Expected \"" + token + "\".");
            }
        }

        public boolean lookingAtInteger() {
            if (this.currentToken.length() == 0) {
                return false;
            }
            char c = this.currentToken.charAt(0);
            return '0' <= c && c <= '9' || c == '-' || c == '+';
        }

        public boolean lookingAt(String text2) {
            return this.currentToken.equals(text2);
        }

        public String consumeIdentifier() throws ParseException {
            for (int i = 0; i < this.currentToken.length(); ++i) {
                char c = this.currentToken.charAt(i);
                if ('a' <= c && c <= 'z' || 'A' <= c && c <= 'Z' || '0' <= c && c <= '9' || c == '_' || c == '.') continue;
                throw this.parseException("Expected identifier. Found '" + this.currentToken + "'");
            }
            String result2 = this.currentToken;
            this.nextToken();
            return result2;
        }

        public boolean tryConsumeIdentifier() {
            try {
                this.consumeIdentifier();
                return true;
            }
            catch (ParseException e) {
                return false;
            }
        }

        public int consumeInt32() throws ParseException {
            try {
                int result2 = TextFormat.parseInt32(this.currentToken);
                this.nextToken();
                return result2;
            }
            catch (NumberFormatException e) {
                throw this.integerParseException(e);
            }
        }

        public int consumeUInt32() throws ParseException {
            try {
                int result2 = TextFormat.parseUInt32(this.currentToken);
                this.nextToken();
                return result2;
            }
            catch (NumberFormatException e) {
                throw this.integerParseException(e);
            }
        }

        public long consumeInt64() throws ParseException {
            try {
                long result2 = TextFormat.parseInt64(this.currentToken);
                this.nextToken();
                return result2;
            }
            catch (NumberFormatException e) {
                throw this.integerParseException(e);
            }
        }

        public boolean tryConsumeInt64() {
            try {
                this.consumeInt64();
                return true;
            }
            catch (ParseException e) {
                return false;
            }
        }

        public long consumeUInt64() throws ParseException {
            try {
                long result2 = TextFormat.parseUInt64(this.currentToken);
                this.nextToken();
                return result2;
            }
            catch (NumberFormatException e) {
                throw this.integerParseException(e);
            }
        }

        public boolean tryConsumeUInt64() {
            try {
                this.consumeUInt64();
                return true;
            }
            catch (ParseException e) {
                return false;
            }
        }

        public double consumeDouble() throws ParseException {
            if (DOUBLE_INFINITY.matcher(this.currentToken).matches()) {
                boolean negative = this.currentToken.startsWith("-");
                this.nextToken();
                return negative ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
            }
            if (this.currentToken.equalsIgnoreCase("nan")) {
                this.nextToken();
                return Double.NaN;
            }
            try {
                double result2 = Double.parseDouble(this.currentToken);
                this.nextToken();
                return result2;
            }
            catch (NumberFormatException e) {
                throw this.floatParseException(e);
            }
        }

        public boolean tryConsumeDouble() {
            try {
                this.consumeDouble();
                return true;
            }
            catch (ParseException e) {
                return false;
            }
        }

        public float consumeFloat() throws ParseException {
            if (FLOAT_INFINITY.matcher(this.currentToken).matches()) {
                boolean negative = this.currentToken.startsWith("-");
                this.nextToken();
                return negative ? Float.NEGATIVE_INFINITY : Float.POSITIVE_INFINITY;
            }
            if (FLOAT_NAN.matcher(this.currentToken).matches()) {
                this.nextToken();
                return Float.NaN;
            }
            try {
                float result2 = Float.parseFloat(this.currentToken);
                this.nextToken();
                return result2;
            }
            catch (NumberFormatException e) {
                throw this.floatParseException(e);
            }
        }

        public boolean tryConsumeFloat() {
            try {
                this.consumeFloat();
                return true;
            }
            catch (ParseException e) {
                return false;
            }
        }

        public boolean consumeBoolean() throws ParseException {
            if (this.currentToken.equals("true") || this.currentToken.equals("True") || this.currentToken.equals("t") || this.currentToken.equals("1")) {
                this.nextToken();
                return true;
            }
            if (this.currentToken.equals("false") || this.currentToken.equals("False") || this.currentToken.equals("f") || this.currentToken.equals("0")) {
                this.nextToken();
                return false;
            }
            throw this.parseException("Expected \"true\" or \"false\".");
        }

        public String consumeString() throws ParseException {
            return this.consumeByteString().toStringUtf8();
        }

        public boolean tryConsumeString() {
            try {
                this.consumeString();
                return true;
            }
            catch (ParseException e) {
                return false;
            }
        }

        public ByteString consumeByteString() throws ParseException {
            ArrayList<ByteString> list = new ArrayList<ByteString>();
            this.consumeByteString(list);
            while (this.currentToken.startsWith("'") || this.currentToken.startsWith("\"")) {
                this.consumeByteString(list);
            }
            return ByteString.copyFrom(list);
        }

        private void consumeByteString(List<ByteString> list) throws ParseException {
            char quote;
            char c = quote = this.currentToken.length() > 0 ? this.currentToken.charAt(0) : (char)'\u0000';
            if (quote != '\"' && quote != '\'') {
                throw this.parseException("Expected string.");
            }
            if (this.currentToken.length() < 2 || this.currentToken.charAt(this.currentToken.length() - 1) != quote) {
                throw this.parseException("String missing ending quote.");
            }
            try {
                String escaped = this.currentToken.substring(1, this.currentToken.length() - 1);
                ByteString result2 = TextFormat.unescapeBytes(escaped);
                this.nextToken();
                list.add(result2);
            }
            catch (InvalidEscapeSequenceException e) {
                throw this.parseException(e.getMessage());
            }
        }

        public ParseException parseException(String description) {
            return new ParseException(this.line + 1, this.column + 1, description);
        }

        public ParseException parseExceptionPreviousToken(String description) {
            return new ParseException(this.previousLine + 1, this.previousColumn + 1, description);
        }

        private ParseException integerParseException(NumberFormatException e) {
            return this.parseException("Couldn't parse integer: " + e.getMessage());
        }

        private ParseException floatParseException(NumberFormatException e) {
            return this.parseException("Couldn't parse number: " + e.getMessage());
        }

        public UnknownFieldParseException unknownFieldParseExceptionPreviousToken(String unknownField, String description) {
            return new UnknownFieldParseException(this.previousLine + 1, this.previousColumn + 1, unknownField, description);
        }
    }

    private static final class TextGenerator {
        private final Appendable output;
        private final StringBuilder indent = new StringBuilder();
        private final boolean singleLineMode;
        private boolean atStartOfLine = false;

        private TextGenerator(Appendable output, boolean singleLineMode) {
            this.output = output;
            this.singleLineMode = singleLineMode;
        }

        public void indent() {
            this.indent.append("  ");
        }

        public void outdent() {
            int length = this.indent.length();
            if (length == 0) {
                throw new IllegalArgumentException(" Outdent() without matching Indent().");
            }
            this.indent.setLength(length - 2);
        }

        public void print(CharSequence text2) throws IOException {
            if (this.atStartOfLine) {
                this.atStartOfLine = false;
                this.output.append(this.singleLineMode ? " " : this.indent);
            }
            this.output.append(text2);
        }

        public void eol() throws IOException {
            if (!this.singleLineMode) {
                this.output.append("\n");
            }
            this.atStartOfLine = true;
        }
    }

    private static final class Printer {
        static final Printer DEFAULT = new Printer(true);
        static final Printer UNICODE = new Printer(false);
        private final boolean escapeNonAscii;

        private Printer(boolean escapeNonAscii) {
            this.escapeNonAscii = escapeNonAscii;
        }

        private void print(MessageOrBuilder message2, TextGenerator generator) throws IOException {
            for (Map.Entry<Descriptors.FieldDescriptor, Object> field2 : message2.getAllFields().entrySet()) {
                this.printField(field2.getKey(), field2.getValue(), generator);
            }
            this.printUnknownFields(message2.getUnknownFields(), generator);
        }

        private void printField(Descriptors.FieldDescriptor field2, Object value2, TextGenerator generator) throws IOException {
            if (field2.isRepeated()) {
                for (Object element : (List)value2) {
                    this.printSingleField(field2, element, generator);
                }
            } else {
                this.printSingleField(field2, value2, generator);
            }
        }

        private void printSingleField(Descriptors.FieldDescriptor field2, Object value2, TextGenerator generator) throws IOException {
            if (field2.isExtension()) {
                generator.print("[");
                if (field2.getContainingType().getOptions().getMessageSetWireFormat() && field2.getType() == Descriptors.FieldDescriptor.Type.MESSAGE && field2.isOptional() && field2.getExtensionScope() == field2.getMessageType()) {
                    generator.print(field2.getMessageType().getFullName());
                } else {
                    generator.print(field2.getFullName());
                }
                generator.print("]");
            } else if (field2.getType() == Descriptors.FieldDescriptor.Type.GROUP) {
                generator.print(field2.getMessageType().getName());
            } else {
                generator.print(field2.getName());
            }
            if (field2.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                generator.print(" {");
                generator.eol();
                generator.indent();
            } else {
                generator.print(": ");
            }
            this.printFieldValue(field2, value2, generator);
            if (field2.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                generator.outdent();
                generator.print("}");
            }
            generator.eol();
        }

        private void printFieldValue(Descriptors.FieldDescriptor field2, Object value2, TextGenerator generator) throws IOException {
            switch (field2.getType()) {
                case INT32: 
                case SINT32: 
                case SFIXED32: {
                    generator.print(((Integer)value2).toString());
                    break;
                }
                case INT64: 
                case SINT64: 
                case SFIXED64: {
                    generator.print(((Long)value2).toString());
                    break;
                }
                case BOOL: {
                    generator.print(((Boolean)value2).toString());
                    break;
                }
                case FLOAT: {
                    generator.print(((Float)value2).toString());
                    break;
                }
                case DOUBLE: {
                    generator.print(((Double)value2).toString());
                    break;
                }
                case UINT32: 
                case FIXED32: {
                    generator.print(TextFormat.unsignedToString((Integer)value2));
                    break;
                }
                case UINT64: 
                case FIXED64: {
                    generator.print(TextFormat.unsignedToString((Long)value2));
                    break;
                }
                case STRING: {
                    generator.print("\"");
                    generator.print(this.escapeNonAscii ? TextFormatEscaper.escapeText((String)value2) : TextFormat.escapeDoubleQuotesAndBackslashes((String)value2).replace("\n", "\\n"));
                    generator.print("\"");
                    break;
                }
                case BYTES: {
                    generator.print("\"");
                    if (value2 instanceof ByteString) {
                        generator.print(TextFormat.escapeBytes((ByteString)value2));
                    } else {
                        generator.print(TextFormat.escapeBytes((byte[])value2));
                    }
                    generator.print("\"");
                    break;
                }
                case ENUM: {
                    generator.print(((Descriptors.EnumValueDescriptor)value2).getName());
                    break;
                }
                case MESSAGE: 
                case GROUP: {
                    this.print((Message)value2, generator);
                }
            }
        }

        private void printUnknownFields(UnknownFieldSet unknownFields, TextGenerator generator) throws IOException {
            for (Map.Entry<Integer, UnknownFieldSet.Field> entry2 : unknownFields.asMap().entrySet()) {
                int number2 = entry2.getKey();
                UnknownFieldSet.Field field2 = entry2.getValue();
                this.printUnknownField(number2, 0, field2.getVarintList(), generator);
                this.printUnknownField(number2, 5, field2.getFixed32List(), generator);
                this.printUnknownField(number2, 1, field2.getFixed64List(), generator);
                this.printUnknownField(number2, 2, field2.getLengthDelimitedList(), generator);
                for (UnknownFieldSet value2 : field2.getGroupList()) {
                    generator.print(entry2.getKey().toString());
                    generator.print(" {");
                    generator.eol();
                    generator.indent();
                    this.printUnknownFields(value2, generator);
                    generator.outdent();
                    generator.print("}");
                    generator.eol();
                }
            }
        }

        private void printUnknownField(int number2, int wireType, List<?> values2, TextGenerator generator) throws IOException {
            for (Object value2 : values2) {
                generator.print(String.valueOf(number2));
                generator.print(": ");
                TextFormat.printUnknownFieldValue(wireType, value2, generator);
                generator.eol();
            }
        }
    }
}

