/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.classpath;

import java.io.File;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map$;
import scala.meta.internal.classpath.Classdir;
import scala.meta.internal.classpath.Classfile;
import scala.meta.internal.classpath.ClasspathElement;
import scala.meta.internal.classpath.ClasspathIndex$;
import scala.meta.internal.classpath.ClasspathIndex$Builder$;
import scala.meta.internal.classpath.CompressedClassfile;
import scala.meta.internal.classpath.UncompressedClassfile;
import scala.meta.internal.io.PathIO$;
import scala.meta.io.AbsolutePath;
import scala.meta.io.AbsolutePath$;
import scala.meta.io.Classpath;
import scala.meta.io.Classpath$;
import scala.meta.io.RelativePath;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.sys.package$;
import scala.util.Properties$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015c\u0001B\u0001\u0003\u0005-\u0011ab\u00117bgN\u0004\u0018\r\u001e5J]\u0012,\u0007P\u0003\u0002\u0004\t\u0005I1\r\\1tgB\fG\u000f\u001b\u0006\u0003\u000b\u0019\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003\u000f!\tA!\\3uC*\t\u0011\"A\u0003tG\u0006d\u0017m\u0001\u0001\u0014\u0005\u0001a\u0001CA\u0007\u000f\u001b\u0005A\u0011BA\b\t\u0005\u0019\te.\u001f*fM\"A1\u0001\u0001B\u0001B\u0003%\u0011\u0003\u0005\u0002\u0013+5\t1C\u0003\u0002\u0015\r\u0005\u0011\u0011n\\\u0005\u0003-M\u0011\u0011b\u00117bgN\u0004\u0018\r\u001e5\t\u0011a\u0001!Q1A\u0005\u0002e\tA\u0001Z5sgV\t!\u0004\u0005\u0003\u001c=\u0001ZS\"\u0001\u000f\u000b\u0005uA\u0011AC2pY2,7\r^5p]&\u0011q\u0004\b\u0002\u0004\u001b\u0006\u0004\bCA\u0011)\u001d\t\u0011c\u0005\u0005\u0002$\u00115\tAE\u0003\u0002&\u0015\u00051AH]8pizJ!a\n\u0005\u0002\rA\u0013X\rZ3g\u0013\tI#F\u0001\u0004TiJLgn\u001a\u0006\u0003O!\u0001\"\u0001L\u0017\u000e\u0003\tI!A\f\u0002\u0003\u0011\rc\u0017m]:eSJD\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006IAG\u0001\u0006I&\u00148\u000f\t\u0005\u0006e\u0001!IaM\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007Q*d\u0007\u0005\u0002-\u0001!)1!\ra\u0001#!)\u0001$\ra\u00015!)\u0001\b\u0001C\u0001s\u0005aq-\u001a;DY\u0006\u001c8OZ5mKR\u0011!\b\u0011\t\u0004\u001bmj\u0014B\u0001\u001f\t\u0005\u0019y\u0005\u000f^5p]B\u0011AFP\u0005\u0003\u007f\t\u0011\u0011b\u00117bgN4\u0017\u000e\\3\t\u000b\u0005;\u0004\u0019\u0001\u0011\u0002\tA\fG\u000f\u001b\u0005\u0006q\u0001!\ta\u0011\u000b\u0004u\u00113\u0005\"B#C\u0001\u0004\u0001\u0013!\u00033je\u0016\u001cGo\u001c:z\u0011\u00159%\t1\u0001!\u0003!1\u0017\u000e\\3oC6,\u0007\"B%\u0001\t\u0003Q\u0015AC5t\u00072\f7o\u001d3jeR\u00111J\u0014\t\u0003\u001b1K!!\u0014\u0005\u0003\u000f\t{w\u000e\\3b]\")\u0011\t\u0013a\u0001A!)\u0001\u000b\u0001C!#\u0006AAo\\*ue&tw\rF\u0001!\u000f\u0015\u0019&\u0001#\u0001U\u00039\u0019E.Y:ta\u0006$\b.\u00138eKb\u0004\"\u0001L+\u0007\u000b\u0005\u0011\u0001\u0012\u0001,\u0014\u0005Uc\u0001\"\u0002\u001aV\t\u0003AF#\u0001+\t\u000bi+F\u0011A.\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0005Qb\u0006\"B\u0002Z\u0001\u0004\t\u0002\"\u0002.V\t\u0003qFc\u0001\u001b`A\")1!\u0018a\u0001#!)\u0011-\u0018a\u0001\u0017\u0006Q\u0011N\\2mk\u0012,'\nZ6\u0007\t\r,f\u0001\u001a\u0002\b\u0005VLG\u000eZ3s'\t\u0011G\u0002\u0003\u0005\u0004E\n\u0005\t\u0015!\u0003\u0012\u0011!\t'M!A!\u0002\u0013Y\u0005\"\u0002\u001ac\t\u0003AGcA5lYB\u0011!NY\u0007\u0002+\")1a\u001aa\u0001#!)\u0011m\u001aa\u0001\u0017\"9\u0001D\u0019b\u0001\n\u0013qW#A8\u0011\tA\u001c\beK\u0007\u0002c*\u0011!\u000fH\u0001\b[V$\u0018M\u00197f\u0013\ty\u0012\u000f\u0003\u00041E\u0002\u0006Ia\u001c\u0005\u0006m\n$\ta^\u0001\u0007e\u0016\u001cX\u000f\u001c;\u0015\u0003QBQ!\u001f2\u0005\u0002i\f!#\u001a=qC:$'\nZ6DY\u0006\u001c8\u000f]1uQR\t1\u0010\u0005\u0002\u000ey&\u0011Q\u0010\u0003\u0002\u0005+:LG\u000fC\u0003\u0000E\u0012%!0\u0001\nfqB\fg\u000e\u001a&si\u000ec\u0017m]:qCRD\u0007bBA\u0002E\u0012%\u0011QA\u0001\fKb\u0004\u0018M\u001c3F]R\u0014\u0018\u0010F\u0002|\u0003\u000fAq!QA\u0001\u0001\u0004\tI\u0001E\u0002\u0013\u0003\u0017I1!!\u0004\u0014\u00051\t%m]8mkR,\u0007+\u0019;i\u0011\u001d\t\tB\u0019C\u0005\u0003'\t\u0011\"\u00193e\u001b\u0016l'-\u001a:\u0015\u000fm\f)\"!\u0007\u0002\u001e!9\u0011qCA\b\u0001\u0004Y\u0013A\u00029be\u0016tG\u000fC\u0004\u0002\u001c\u0005=\u0001\u0019\u0001\u0011\u0002\u0011\t\f7/\u001a8b[\u0016D\u0001\"a\b\u0002\u0010\u0001\u0007\u0011\u0011E\u0001\bK2,W.\u001a8u!\ra\u00131E\u0005\u0004\u0003K\u0011!\u0001E\"mCN\u001c\b/\u0019;i\u000b2,W.\u001a8u\u0011\u001d\tIC\u0019C\u0005\u0003W\t1bZ3u\u00072\f7o\u001d3jeR\u00191&!\f\t\u000f\u0005=\u0012q\u0005a\u0001A\u0005!a.Y7f\u0011\u001d\t\u0019D\u0019C\u0005\u0003k\ta\"\u001a=qC:$'*\u0019:F]R\u0014\u0018\u0010F\u0002|\u0003oA\u0001\"!\u000f\u00022\u0001\u0007\u0011\u0011B\u0001\bU\u0006\u0014\b/\u0019;i\u0011\u001d\tiD\u0019C\u0005\u0003\u007f\ta\"\u001a=qC:$G)\u001b:F]R\u0014\u0018\u0010F\u0002|\u0003\u0003B\u0001\"a\u0011\u0002<\u0001\u0007\u0011\u0011B\u0001\u0005e>|G\u000f")
public final class ClasspathIndex {
    private final Classpath classpath;
    private final Map<String, Classdir> dirs;

    public static ClasspathIndex apply(Classpath classpath, boolean bl) {
        return ClasspathIndex$.MODULE$.apply(classpath, bl);
    }

    public static ClasspathIndex apply(Classpath classpath) {
        return ClasspathIndex$.MODULE$.apply(classpath);
    }

    public Map<String, Classdir> dirs() {
        return this.dirs;
    }

    public Option<Classfile> getClassfile(String path) {
        return this.getClassfile(PathIO$.MODULE$.dirname(path), PathIO$.MODULE$.basename(path));
    }

    public Option<Classfile> getClassfile(String directory, String filename) {
        None$ none$;
        Option option = this.dirs().get((Object)directory);
        if (option instanceof Some) {
            Some some = (Some)option;
            Classdir pkg = (Classdir)some.value();
            none$ = pkg.resolve(filename).collect((PartialFunction)new Serializable(null){
                public static final long serialVersionUID = 0L;

                public final <A1 extends ClasspathElement, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x1;
                    if (A1 instanceof Classfile) {
                        Classfile classfile = (Classfile)A1;
                        object = classfile;
                    } else {
                        object = function1.apply(x1);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(ClasspathElement x1) {
                    ClasspathElement classpathElement = x1;
                    boolean bl = classpathElement instanceof Classfile;
                    return bl;
                }
            });
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public boolean isClassdir(String path) {
        return this.dirs().contains((Object)path);
    }

    public String toString() {
        return new StringBuilder(16).append("ClasspathIndex(").append(this.classpath).append(")").toString();
    }

    public ClasspathIndex(Classpath classpath, Map<String, Classdir> dirs) {
        this.classpath = classpath;
        this.dirs = dirs;
    }

    public static final class Builder {
        private final Classpath classpath;
        private final boolean includeJdk;
        private final scala.collection.mutable.Map<String, Classdir> dirs;

        private scala.collection.mutable.Map<String, Classdir> dirs() {
            return this.dirs;
        }

        public ClasspathIndex result() {
            Classdir root2 = new Classdir("/");
            this.dirs().update((Object)root2.relativeUri(), (Object)root2);
            if (this.includeJdk) {
                this.expandJdkClasspath();
            }
            this.classpath.entries().foreach((Function1 & java.io.Serializable & Serializable)path -> {
                this.expandEntry(path);
                return BoxedUnit.UNIT;
            });
            return new ClasspathIndex(this.classpath, (Map<String, Classdir>)this.dirs());
        }

        public void expandJdkClasspath() {
            if (Properties$.MODULE$.isJavaAtLeast("9")) {
                this.expandJrtClasspath();
            } else {
                package$.MODULE$.props().collectFirst((PartialFunction)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ Builder $outer;

                    /*
                     * Enabled aggressive block sorting
                     */
                    public final <A1 extends Tuple2<String, String>, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x2;
                        if (A1 != null) {
                            String k = (String)A1._1();
                            String v = (String)A1._2();
                            if (k.endsWith(".boot.class.path")) {
                                ((List)Classpath$.MODULE$.apply(v).entries().filter((Function1 & java.io.Serializable & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)Builder$$anonfun$expandJdkClasspath$2.$anonfun$applyOrElse$1(x$1)))).foreach((Function1 & java.io.Serializable & Serializable)jarpath -> {
                                    Builder$$anonfun$expandJdkClasspath$2.$anonfun$applyOrElse$2(this, jarpath);
                                    return BoxedUnit.UNIT;
                                });
                                object = BoxedUnit.UNIT;
                                return (B1)object;
                            }
                        }
                        object = function1.apply(x2);
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(Tuple2<String, String> x2) {
                        String k;
                        Tuple2<String, String> tuple2 = x2;
                        boolean bl = tuple2 != null && (k = (String)tuple2._1()).endsWith(".boot.class.path");
                        return bl;
                    }

                    public static final /* synthetic */ boolean $anonfun$applyOrElse$1(AbsolutePath x$1) {
                        return x$1.isFile();
                    }

                    public static final /* synthetic */ void $anonfun$applyOrElse$2(Builder$$anonfun$expandJdkClasspath$2 $this, AbsolutePath jarpath) {
                        $this.$outer.scala$meta$internal$classpath$ClasspathIndex$Builder$$expandJarEntry(jarpath);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1$adapted(scala.meta.io.AbsolutePath ), $anonfun$applyOrElse$2$adapted(scala.meta.internal.classpath.ClasspathIndex$Builder$$anonfun$expandJdkClasspath$2 scala.meta.io.AbsolutePath )}, serializedLambda);
                    }
                }).getOrElse((Function0 & java.io.Serializable & Serializable)() -> {
                    throw new IllegalStateException("Unable to detect bootclasspath");
                });
            }
        }

        private void expandJrtClasspath() {
            FileSystem fs = FileSystems.getFileSystem(URI.create("jrt:/"));
            Path dir = fs.getPath("/packages", new String[0]);
            ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(Files.newDirectoryStream(dir).iterator()).asScala()).map((Function1 & java.io.Serializable & Serializable)pkg -> {
                String symbol = new StringBuilder(1).append(new StringOps(Predef$.MODULE$.augmentString(((Object)pkg).toString())).stripPrefix("/packages/").replace('.', '/')).append("/").toString();
                Classdir classdir = this.scala$meta$internal$classpath$ClasspathIndex$Builder$$getClassdir(symbol);
                return new Tuple3(pkg, (Object)symbol, (Object)classdir);
            }).foreach((Function1 & java.io.Serializable & Serializable)x$2 -> {
                Builder.$anonfun$expandJrtClasspath$2(x$2);
                return BoxedUnit.UNIT;
            });
        }

        private void expandEntry(AbsolutePath path) {
            block1: {
                block0: {
                    if (!path.isFile()) break block0;
                    this.scala$meta$internal$classpath$ClasspathIndex$Builder$$expandJarEntry(path);
                    break block1;
                }
                if (!path.isDirectory()) break block1;
                this.expandDirEntry(path);
            }
        }

        public void scala$meta$internal$classpath$ClasspathIndex$Builder$$addMember(Classdir parent, String basename, ClasspathElement element) {
            block0: {
                if (parent.members().contains((Object)basename)) break block0;
                parent.members().update((Object)basename, (Object)element);
            }
        }

        public Classdir scala$meta$internal$classpath$ClasspathIndex$Builder$$getClassdir(String name) {
            Classdir classdir;
            Option option = this.dirs().get((Object)name);
            if (option instanceof Some) {
                Classdir dir;
                Some some = (Some)option;
                classdir = dir = (Classdir)some.value();
            } else {
                Classdir parent = this.scala$meta$internal$classpath$ClasspathIndex$Builder$$getClassdir(PathIO$.MODULE$.dirname(name));
                Classdir element = new Classdir(name);
                parent.members().update((Object)PathIO$.MODULE$.basename(name), (Object)element);
                this.dirs().update((Object)name, (Object)element);
                classdir = element;
            }
            return classdir;
        }

        public void scala$meta$internal$classpath$ClasspathIndex$Builder$$expandJarEntry(AbsolutePath jarpath) {
            File file = jarpath.toFile();
            try (JarFile jar = new JarFile(file);){
                String classpathAttr;
                Enumeration<JarEntry> entries = jar.entries();
                while (entries.hasMoreElements()) {
                    JarEntry element = entries.nextElement();
                    if (element.getName().startsWith("META-INF")) continue;
                    Classdir parent = this.scala$meta$internal$classpath$ClasspathIndex$Builder$$getClassdir(element.isDirectory() ? element.getName() : PathIO$.MODULE$.dirname(element.getName()));
                    CompressedClassfile inJar = new CompressedClassfile(element, file);
                    this.scala$meta$internal$classpath$ClasspathIndex$Builder$$addMember(parent, PathIO$.MODULE$.basename(element.getName()), inJar);
                }
                Manifest manifest = jar.getManifest();
                if (manifest != null && (classpathAttr = manifest.getMainAttributes().getValue("Class-Path")) != null) {
                    new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])classpathAttr.split(" "))).foreach((Function1 & java.io.Serializable & Serializable)relpath -> {
                        Builder.$anonfun$expandJarEntry$1(this, jarpath, relpath);
                        return BoxedUnit.UNIT;
                    });
                }
            }
        }

        private void expandDirEntry(AbsolutePath root2) {
            Files.walkFileTree(root2.toNIO(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(this, root2){
                private final /* synthetic */ Builder $outer;
                private final AbsolutePath root$1;

                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    block0: {
                        String name = ((Object)file.getFileName()).toString();
                        if (!name.endsWith(".class")) break block0;
                        RelativePath relpath = AbsolutePath$.MODULE$.apply(file, AbsolutePath$.MODULE$.workingDirectory()).toRelative(this.root$1);
                        String reluri = relpath.toURI(false).toString();
                        String basename = PathIO$.MODULE$.basename(reluri);
                        String dirname = PathIO$.MODULE$.dirname(reluri);
                        Classdir classdir = this.$outer.scala$meta$internal$classpath$ClasspathIndex$Builder$$getClassdir(dirname);
                        UncompressedClassfile element = new UncompressedClassfile(reluri, AbsolutePath$.MODULE$.apply(file, AbsolutePath$.MODULE$.workingDirectory()));
                        this.$outer.scala$meta$internal$classpath$ClasspathIndex$Builder$$addMember(classdir, basename, element);
                    }
                    return super.visitFile(file, attrs);
                }

                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                    return dir.endsWith("META-INF") ? FileVisitResult.SKIP_SUBTREE : FileVisitResult.CONTINUE;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.root$1 = root$1;
                }
            });
        }

        public static final /* synthetic */ void $anonfun$expandJrtClasspath$3(Classdir classdir$1, Path moduleLink) {
            Path module = !Files.isSymbolicLink(moduleLink) ? moduleLink : Files.readSymbolicLink(moduleLink);
            classdir$1.modules_$eq((List<Path>)classdir$1.modules().$colon$colon((Object)module));
        }

        public static final /* synthetic */ void $anonfun$expandJrtClasspath$2(Tuple3 x$2) {
            Tuple3 tuple3 = x$2;
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            Path pkg = (Path)tuple3._1();
            Classdir classdir = (Classdir)tuple3._3();
            ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(Files.list(pkg).iterator()).asScala()).foreach((Function1 & java.io.Serializable & Serializable)moduleLink -> {
                Builder.$anonfun$expandJrtClasspath$3(classdir, moduleLink);
                return BoxedUnit.UNIT;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }

        public static final /* synthetic */ void $anonfun$expandJarEntry$1(Builder $this, AbsolutePath jarpath$1, String relpath) {
            block0: {
                AbsolutePath abspath = AbsolutePath$.MODULE$.apply(jarpath$1.toNIO().getParent(), AbsolutePath$.MODULE$.workingDirectory()).resolve(relpath);
                if (!abspath.isFile() && !abspath.isDirectory()) break block0;
                $this.expandEntry(abspath);
            }
        }

        public Builder(Classpath classpath, boolean includeJdk) {
            this.classpath = classpath;
            this.includeJdk = includeJdk;
            this.dirs = Map$.MODULE$.empty();
        }
    }
}

