/*
 * Decompiled with CFR 0.152.
 */
package scalapb.textformat;

import com.google.protobuf.descriptor.FieldDescriptorProto;
import com.google.protobuf.descriptor.FieldDescriptorProto$Type$TYPE_BOOL$;
import com.google.protobuf.descriptor.FieldDescriptorProto$Type$TYPE_BYTES$;
import com.google.protobuf.descriptor.FieldDescriptorProto$Type$TYPE_DOUBLE$;
import com.google.protobuf.descriptor.FieldDescriptorProto$Type$TYPE_ENUM$;
import com.google.protobuf.descriptor.FieldDescriptorProto$Type$TYPE_FIXED32$;
import com.google.protobuf.descriptor.FieldDescriptorProto$Type$TYPE_FIXED64$;
import com.google.protobuf.descriptor.FieldDescriptorProto$Type$TYPE_FLOAT$;
import com.google.protobuf.descriptor.FieldDescriptorProto$Type$TYPE_GROUP$;
import com.google.protobuf.descriptor.FieldDescriptorProto$Type$TYPE_INT32$;
import com.google.protobuf.descriptor.FieldDescriptorProto$Type$TYPE_INT64$;
import com.google.protobuf.descriptor.FieldDescriptorProto$Type$TYPE_SFIXED32$;
import com.google.protobuf.descriptor.FieldDescriptorProto$Type$TYPE_SFIXED64$;
import com.google.protobuf.descriptor.FieldDescriptorProto$Type$TYPE_SINT32$;
import com.google.protobuf.descriptor.FieldDescriptorProto$Type$TYPE_SINT64$;
import com.google.protobuf.descriptor.FieldDescriptorProto$Type$TYPE_STRING$;
import com.google.protobuf.descriptor.FieldDescriptorProto$Type$TYPE_UINT32$;
import com.google.protobuf.descriptor.FieldDescriptorProto$Type$TYPE_UINT64$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.math.BigInt;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try$;
import scalapb.GeneratedMessage;
import scalapb.GeneratedMessageCompanion;
import scalapb.Message;
import scalapb.descriptors.EnumDescriptor;
import scalapb.descriptors.EnumValueDescriptor;
import scalapb.descriptors.FieldDescriptor;
import scalapb.descriptors.PBoolean;
import scalapb.descriptors.PByteString$;
import scalapb.descriptors.PDouble;
import scalapb.descriptors.PEnum$;
import scalapb.descriptors.PFloat;
import scalapb.descriptors.PInt;
import scalapb.descriptors.PLong;
import scalapb.descriptors.PMessage;
import scalapb.descriptors.PRepeated;
import scalapb.descriptors.PRepeated$;
import scalapb.descriptors.PString$;
import scalapb.descriptors.PValue;
import scalapb.textformat.AstUtils;
import scalapb.textformat.TArray;
import scalapb.textformat.TBytes;
import scalapb.textformat.TField;
import scalapb.textformat.TIntLiteral;
import scalapb.textformat.TLiteral;
import scalapb.textformat.TMessage;
import scalapb.textformat.TPrimitive;
import scalapb.textformat.TValue;
import scalapb.textformat.TextFormatUtils$;

public final class AstUtils$ {
    public static AstUtils$ MODULE$;

    static {
        new AstUtils$();
    }

    private <T> Either<AstUtils.AstError, Vector<T>> flatten(Seq<Either<AstUtils.AstError, T>> s) {
        Right right;
        Some some;
        Either either;
        Option option = s.find((Function1 & java.io.Serializable & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isLeft()));
        if (option instanceof Some && (either = (Either)(some = (Some)option).value()) instanceof Left) {
            Left left = (Left)either;
            AstUtils.AstError e = (AstUtils.AstError)left.value();
            right = package$.MODULE$.Left().apply((Object)e);
        } else {
            right = package$.MODULE$.Right().apply(s.map((Function1 & java.io.Serializable & Serializable)x$2 -> x$2.right().get(), scala.collection.package$.MODULE$.breakOut(Vector$.MODULE$.canBuildFrom())));
        }
        return right;
    }

    public <T extends GeneratedMessage & Message<T>> Either<AstUtils.AstError, T> parseMessage(GeneratedMessageCompanion<T> v, TMessage ast2) {
        return this.parseUnsafe(v, ast2).right().map(v.messageReads().read());
    }

    public Either<AstUtils.AstError, BigInt> checkBigInt(TPrimitive p, boolean isSigned, boolean isLong) {
        Left left;
        TPrimitive tPrimitive = p;
        if (tPrimitive instanceof TIntLiteral) {
            int maxBits;
            boolean negative;
            TIntLiteral tIntLiteral = (TIntLiteral)tPrimitive;
            int index = tIntLiteral.index();
            BigInt v = tIntLiteral.value();
            boolean bl = negative = v.signum() == -1;
            int n = isLong ? (isSigned ? 63 : 64) : (maxBits = isSigned ? 31 : 32);
            left = !isSigned && negative ? package$.MODULE$.Left().apply((Object)new AstUtils.AstError(index, new StringBuilder(25).append("Number must be positive: ").append(v).toString())) : (v.bitLength() > maxBits ? package$.MODULE$.Left().apply((Object)new AstUtils.AstError(index, new StringBuilder(39).append("Number out of range for ").append(isLong ? BoxesRunTime.boxToInteger((int)64) : BoxesRunTime.boxToInteger((int)32)).append("-bit ").append((Object)(isSigned ? "signed" : "unsigned")).append(" integer: ").append(v).toString())) : package$.MODULE$.Right().apply((Object)v));
        } else {
            left = package$.MODULE$.Left().apply((Object)new AstUtils.AstError(tPrimitive.index(), new StringBuilder(16).append("Invalid input '").append(tPrimitive.asString()).append("'").toString()));
        }
        return left;
    }

    public boolean checkBigInt$default$2() {
        return true;
    }

    public Either<AstUtils.AstError, PInt> parseInt32(TPrimitive p) {
        return this.checkBigInt(p, true, false).right().map((Function1 & java.io.Serializable & Serializable)t -> new PInt(t.intValue()));
    }

    public Either<AstUtils.AstError, PInt> parseUint32(TPrimitive p) {
        return this.checkBigInt(p, false, false).right().map((Function1 & java.io.Serializable & Serializable)t -> new PInt(t.intValue()));
    }

    public Either<AstUtils.AstError, PLong> parseInt64(TPrimitive p) {
        return this.checkBigInt(p, true, true).right().map((Function1 & java.io.Serializable & Serializable)t -> new PLong(t.longValue()));
    }

    public Either<AstUtils.AstError, PLong> parseUint64(TPrimitive p) {
        return this.checkBigInt(p, false, true).right().map((Function1 & java.io.Serializable & Serializable)t -> new PLong(t.longValue()));
    }

    private Either<AstUtils.AstError, Map<FieldDescriptor, PValue>> parseUnsafe(GeneratedMessageCompanion<?> v, TMessage ast2) {
        Left left;
        Map fieldMap = ((TraversableOnce)v.scalaDescriptor().fields().map((Function1 & java.io.Serializable & Serializable)f -> new Tuple2((Object)f.name(), f), Vector$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Map fields = ast2.fields().groupBy((Function1 & java.io.Serializable & Serializable)x$7 -> x$7.name());
        Option option = ast2.fields().find((Function1 & java.io.Serializable & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)AstUtils$.$anonfun$parseUnsafe$20(fieldMap, f)));
        if (option instanceof Some) {
            Some some = (Some)option;
            TField f2 = (TField)some.value();
            left = package$.MODULE$.Left().apply((Object)new AstUtils.AstError(f2.index(), new StringBuilder(21).append("Unknown field name '").append(f2.name()).append("'").toString()));
        } else if (None$.MODULE$.equals(option)) {
            left = this.flatten((Seq)((TraversableOnce)fields.map(((Function2 & java.io.Serializable & Serializable)(Function2 & java.io.Serializable & Serializable)(name, group) -> this.fieldGroupToValue$1((String)name, (Seq)group, v, fieldMap)).tupled(), Iterable$.MODULE$.canBuildFrom())).toVector());
        } else {
            throw new MatchError((Object)option);
        }
        Left maybeMap = left;
        return maybeMap.right().map((Function1 & java.io.Serializable & Serializable)t -> new PMessage((Map<FieldDescriptor, PValue>)t.toMap(Predef$.MODULE$.$conforms())));
    }

    public static final /* synthetic */ double $anonfun$parseUnsafe$1(String value$1) {
        return new StringOps(Predef$.MODULE$.augmentString(value$1)).toDouble();
    }

    private static final Either parseDouble$1(TPrimitive p) {
        Right right;
        TPrimitive tPrimitive = p;
        if (tPrimitive instanceof TLiteral) {
            Object object;
            TLiteral tLiteral = (TLiteral)tPrimitive;
            String value = tLiteral.value();
            String low = value.toLowerCase();
            String string = low;
            boolean bl = "inf".equals(string) ? true : "infinity".equals(string);
            if (bl) {
                object = package$.MODULE$.Right().apply((Object)new PDouble(Double.POSITIVE_INFINITY));
            } else {
                boolean bl2 = "-inf".equals(string) ? true : "-infinity".equals(string);
                object = bl2 ? package$.MODULE$.Right().apply((Object)new PDouble(Double.NEGATIVE_INFINITY)) : ("nan".equals(string) ? package$.MODULE$.Right().apply((Object)new PDouble(Double.NaN)) : Try$.MODULE$.apply((Function0 & java.io.Serializable & Serializable)() -> new PDouble(AstUtils$.$anonfun$parseUnsafe$1(value))).toOption().toRight((Function0 & java.io.Serializable & Serializable)() -> new AstUtils.AstError(p.index(), new StringBuilder(28).append("Invalid value for double: '").append(value).append("'").toString())));
            }
            right = object;
        } else if (tPrimitive instanceof TIntLiteral) {
            TIntLiteral tIntLiteral = (TIntLiteral)tPrimitive;
            BigInt value = tIntLiteral.value();
            right = package$.MODULE$.Right().apply((Object)new PDouble(value.toDouble()));
        } else {
            right = package$.MODULE$.Left().apply((Object)new AstUtils.AstError(tPrimitive.index(), new StringBuilder(32).append("Invalid input '").append(tPrimitive.asString()).append("', expected float").toString()));
        }
        return right;
    }

    public static final /* synthetic */ float $anonfun$parseUnsafe$3(String value$2) {
        return new StringOps(Predef$.MODULE$.augmentString(value$2)).toFloat();
    }

    private static final Either parseFloat$1(TPrimitive p) {
        Right right;
        TPrimitive tPrimitive = p;
        if (tPrimitive instanceof TLiteral) {
            Object object;
            TLiteral tLiteral = (TLiteral)tPrimitive;
            String value = tLiteral.value();
            String low = value.toLowerCase();
            String string = low;
            boolean bl = "inf".equals(string) ? true : ("inff".equals(string) ? true : ("infinity".equals(string) ? true : "infinityf".equals(string)));
            if (bl) {
                object = package$.MODULE$.Right().apply((Object)new PFloat(Float.POSITIVE_INFINITY));
            } else {
                boolean bl2 = "-inf".equals(string) ? true : ("-inff".equals(string) ? true : ("-infinity".equals(string) ? true : "-infinityf".equals(string)));
                if (bl2) {
                    object = package$.MODULE$.Right().apply((Object)new PFloat(Float.NEGATIVE_INFINITY));
                } else {
                    boolean bl3 = "nan".equals(string) ? true : "nanf".equals(string);
                    object = bl3 ? package$.MODULE$.Right().apply((Object)new PFloat(Float.NaN)) : Try$.MODULE$.apply((Function0 & java.io.Serializable & Serializable)() -> new PFloat(AstUtils$.$anonfun$parseUnsafe$3(value))).toOption().toRight((Function0 & java.io.Serializable & Serializable)() -> new AstUtils.AstError(p.index(), new StringBuilder(27).append("Invalid value for float: '").append(value).append("'").toString()));
                }
            }
            right = object;
        } else if (tPrimitive instanceof TIntLiteral) {
            TIntLiteral tIntLiteral = (TIntLiteral)tPrimitive;
            BigInt value = tIntLiteral.value();
            right = package$.MODULE$.Right().apply((Object)new PFloat(value.toFloat()));
        } else {
            right = package$.MODULE$.Left().apply((Object)new AstUtils.AstError(tPrimitive.index(), new StringBuilder(32).append("Invalid input '").append(tPrimitive.asString()).append("', expected float").toString()));
        }
        return right;
    }

    private static final String invalidInput$1(String v) {
        return new StringBuilder(44).append("Invalid input '").append(v).append("', expected 'true' or 'false'").toString();
    }

    private static final Either parseBoolean$1(TPrimitive p) {
        Right right;
        TPrimitive tPrimitive = p;
        if (tPrimitive instanceof TIntLiteral) {
            TIntLiteral tIntLiteral = (TIntLiteral)tPrimitive;
            int index = tIntLiteral.index();
            BigInt v = tIntLiteral.value();
            right = BoxesRunTime.equalsNumObject((Number)v, (Object)BoxesRunTime.boxToInteger((int)0)) ? package$.MODULE$.Right().apply((Object)new PBoolean(false)) : (BoxesRunTime.equalsNumObject((Number)v, (Object)BoxesRunTime.boxToInteger((int)1)) ? package$.MODULE$.Right().apply((Object)new PBoolean(true)) : package$.MODULE$.Left().apply((Object)new AstUtils.AstError(index, AstUtils$.invalidInput$1(v.toString()))));
        } else if (tPrimitive instanceof TLiteral) {
            Object object;
            TLiteral tLiteral = (TLiteral)tPrimitive;
            int index = tLiteral.index();
            String v = tLiteral.value();
            String string = v.toLowerCase();
            boolean bl = "t".equals(string) ? true : "true".equals(string);
            if (bl) {
                object = package$.MODULE$.Right().apply((Object)new PBoolean(true));
            } else {
                boolean bl2 = "f".equals(string) ? true : "false".equals(string);
                object = bl2 ? package$.MODULE$.Right().apply((Object)new PBoolean(false)) : package$.MODULE$.Left().apply((Object)new AstUtils.AstError(index, AstUtils$.invalidInput$1(v.toString())));
            }
            right = object;
        } else if (tPrimitive instanceof TBytes) {
            TBytes tBytes = (TBytes)tPrimitive;
            String v = tBytes.value();
            right = package$.MODULE$.Left().apply((Object)new AstUtils.AstError(p.index(), AstUtils$.invalidInput$1(v)));
        } else {
            throw new MatchError((Object)tPrimitive);
        }
        return right;
    }

    private static final Either parseString$1(TPrimitive p) {
        Either either;
        TPrimitive tPrimitive = p;
        if (tPrimitive instanceof TBytes) {
            TBytes tBytes = (TBytes)tPrimitive;
            String value = tBytes.value();
            either = TextFormatUtils$.MODULE$.unescapeText(value).right().map((Function1)PString$.MODULE$).left().map((Function1 & java.io.Serializable & Serializable)error -> new AstUtils.AstError(p.index(), error.msg()));
        } else {
            either = package$.MODULE$.Left().apply((Object)new AstUtils.AstError(tPrimitive.index(), new StringBuilder(33).append("Invalid input '").append(tPrimitive.asString()).append("', expected string").toString()));
        }
        return either;
    }

    private static final Either parseBytes$1(TPrimitive p) {
        Left left;
        TPrimitive tPrimitive = p;
        if (tPrimitive instanceof TBytes) {
            TBytes tBytes = (TBytes)tPrimitive;
            String value = tBytes.value();
            left = TextFormatUtils$.MODULE$.unescapeBytes(value).right().map((Function1)PByteString$.MODULE$).left().map((Function1 & java.io.Serializable & Serializable)error -> new AstUtils.AstError(p.index(), error.msg()));
        } else {
            left = package$.MODULE$.Left().apply((Object)new AstUtils.AstError(p.index(), "Unexpected input"));
        }
        return left;
    }

    public static final /* synthetic */ boolean $anonfun$parseUnsafe$7(BigInt num$1, EnumValueDescriptor x$3) {
        return x$3.number() == num$1.toInt();
    }

    public static final /* synthetic */ boolean $anonfun$parseUnsafe$9(String name$1, EnumValueDescriptor x$4) {
        String string = x$4.name();
        String string2 = name$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private final Either parsePrimitive$1(FieldDescriptor field, TPrimitive p, GeneratedMessageCompanion v$1) {
        Left left;
        FieldDescriptorProto.Type type = field.protoType();
        if (FieldDescriptorProto$Type$TYPE_DOUBLE$.MODULE$.equals(type)) {
            left = AstUtils$.parseDouble$1(p);
        } else if (FieldDescriptorProto$Type$TYPE_FLOAT$.MODULE$.equals(type)) {
            left = AstUtils$.parseFloat$1(p);
        } else if (FieldDescriptorProto$Type$TYPE_INT64$.MODULE$.equals(type)) {
            left = this.parseInt64(p);
        } else if (FieldDescriptorProto$Type$TYPE_UINT64$.MODULE$.equals(type)) {
            left = this.parseUint64(p);
        } else if (FieldDescriptorProto$Type$TYPE_INT32$.MODULE$.equals(type)) {
            left = this.parseInt32(p);
        } else if (FieldDescriptorProto$Type$TYPE_FIXED64$.MODULE$.equals(type)) {
            left = this.parseUint64(p);
        } else if (FieldDescriptorProto$Type$TYPE_FIXED32$.MODULE$.equals(type)) {
            left = this.parseUint32(p);
        } else if (FieldDescriptorProto$Type$TYPE_BOOL$.MODULE$.equals(type)) {
            left = AstUtils$.parseBoolean$1(p);
        } else if (FieldDescriptorProto$Type$TYPE_STRING$.MODULE$.equals(type)) {
            left = AstUtils$.parseString$1(p);
        } else if (FieldDescriptorProto$Type$TYPE_BYTES$.MODULE$.equals(type)) {
            left = AstUtils$.parseBytes$1(p);
        } else if (FieldDescriptorProto$Type$TYPE_UINT32$.MODULE$.equals(type)) {
            left = this.parseUint32(p);
        } else if (FieldDescriptorProto$Type$TYPE_SFIXED32$.MODULE$.equals(type)) {
            left = this.parseInt32(p);
        } else if (FieldDescriptorProto$Type$TYPE_SFIXED64$.MODULE$.equals(type)) {
            left = this.parseInt64(p);
        } else if (FieldDescriptorProto$Type$TYPE_SINT32$.MODULE$.equals(type)) {
            left = this.parseInt32(p);
        } else if (FieldDescriptorProto$Type$TYPE_SINT64$.MODULE$.equals(type)) {
            left = this.parseInt64(p);
        } else if (FieldDescriptorProto$Type$TYPE_GROUP$.MODULE$.equals(type)) {
            left = package$.MODULE$.Left().apply((Object)new AstUtils.AstError(p.index(), "groups are not supported"));
        } else if (FieldDescriptorProto$Type$TYPE_ENUM$.MODULE$.equals(type)) {
            Either either;
            EnumDescriptor enumDesc = v$1.enumCompanionForFieldNumber(field.number()).scalaDescriptor();
            TPrimitive tPrimitive = p;
            if (tPrimitive instanceof TIntLiteral) {
                TIntLiteral tIntLiteral = (TIntLiteral)tPrimitive;
                int index = tIntLiteral.index();
                BigInt num = tIntLiteral.value();
                either = enumDesc.values().find((Function1 & java.io.Serializable & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)AstUtils$.$anonfun$parseUnsafe$7(num, x$3))).map((Function1)PEnum$.MODULE$).toRight((Function0 & java.io.Serializable & Serializable)() -> new AstUtils.AstError(index, new StringBuilder(47).append("Expected Enum type \"").append(enumDesc.asProto().getName()).append("\" has no value with number ").append(num.toString()).toString()));
            } else if (tPrimitive instanceof TLiteral) {
                TLiteral tLiteral = (TLiteral)tPrimitive;
                int index = tLiteral.index();
                String name = tLiteral.value();
                either = enumDesc.values().find((Function1 & java.io.Serializable & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)AstUtils$.$anonfun$parseUnsafe$9(name, x$4))).map((Function1)PEnum$.MODULE$).toRight((Function0 & java.io.Serializable & Serializable)() -> new AstUtils.AstError(index, new StringBuilder(43).append("Expected Enum type \"").append(enumDesc.asProto().getName()).append("\" has no value named \"").append(name).append("\"").toString()));
            } else {
                either = package$.MODULE$.Left().apply((Object)new AstUtils.AstError(tPrimitive.index(), new StringBuilder(38).append("Invalid value '").append(tPrimitive.asString()).append(", expected Enum type \"").append(enumDesc.asProto().getName()).append("\"").toString()));
            }
            left = either;
        } else {
            left = package$.MODULE$.Left().apply((Object)new AstUtils.AstError(p.index(), "This should not happen."));
        }
        return left;
    }

    public static final /* synthetic */ boolean $anonfun$parseUnsafe$11(TValue x$5) {
        return !(x$5 instanceof TMessage);
    }

    public static final /* synthetic */ boolean $anonfun$parseUnsafe$13(TValue x$6) {
        return !(x$6 instanceof TPrimitive);
    }

    private final Either pfieldToValue$1(FieldDescriptor fd, TField pfield, GeneratedMessageCompanion v$1) {
        Left left;
        TValue tValue = pfield.value();
        if (tValue instanceof TArray) {
            int idx;
            int idx2;
            TArray tArray = (TArray)tValue;
            Object object = !fd.isRepeated() ? package$.MODULE$.Left().apply((Object)new AstUtils.AstError(tArray.index(), new StringBuilder(28).append("Invalid input '[', expected ").append(fd.protoType().toString().toLowerCase()).toString())) : (fd.protoType().isTypeMessage() ? ((idx2 = tArray.values().indexWhere((Function1 & java.io.Serializable & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)AstUtils$.$anonfun$parseUnsafe$11(x$5)))) != -1 ? package$.MODULE$.Left().apply((Object)new AstUtils.AstError(tArray.index(), new StringBuilder(43).append("Array contain a non-message value at index ").append(idx2).toString())) : this.flatten((Seq)((TraversableOnce)tArray.values().map((Function1 & java.io.Serializable & Serializable)t -> MODULE$.parseUnsafe(v$1.messageCompanionForFieldNumber(fd.number()), (TMessage)t), Seq$.MODULE$.canBuildFrom())).toVector()).right().map((Function1)PRepeated$.MODULE$)) : ((idx = tArray.values().indexWhere((Function1 & java.io.Serializable & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)AstUtils$.$anonfun$parseUnsafe$13(x$6)))) != -1 ? package$.MODULE$.Left().apply((Object)new AstUtils.AstError(tArray.index(), new StringBuilder(26).append("Unexpected value at index ").append(idx).toString())) : this.flatten((Seq)((TraversableOnce)tArray.values().map((Function1 & java.io.Serializable & Serializable)t -> this.parsePrimitive$1(fd, (TPrimitive)t, v$1), Seq$.MODULE$.canBuildFrom())).toVector()).right().map((Function1)PRepeated$.MODULE$)));
            left = object;
        } else if (tValue instanceof TPrimitive) {
            TPrimitive tPrimitive = (TPrimitive)tValue;
            left = fd.protoType().isTypeMessage() ? package$.MODULE$.Left().apply((Object)new AstUtils.AstError(tPrimitive.index(), "invalid value for message")) : this.parsePrimitive$1(fd, tPrimitive, v$1);
        } else if (tValue instanceof TMessage) {
            TMessage tMessage = (TMessage)tValue;
            left = !fd.protoType().isTypeMessage() ? package$.MODULE$.Left().apply((Object)new AstUtils.AstError(tMessage.index(), "invalid value for message")) : this.parseUnsafe(v$1.messageCompanionForFieldNumber(fd.number()), tMessage);
        } else {
            throw new MatchError((Object)tValue);
        }
        return left;
    }

    private final Either fieldGroupToValue$1(String name, Seq group, GeneratedMessageCompanion v$1, Map fieldMap$1) {
        FieldDescriptor fd = (FieldDescriptor)fieldMap$1.apply((Object)name);
        Either values = this.flatten((Seq)group.map((Function1 & java.io.Serializable & Serializable)x$8 -> this.pfieldToValue$1(fd, (TField)x$8, v$1), Seq$.MODULE$.canBuildFrom()));
        return values.right().map((Function1 & java.io.Serializable & Serializable)t -> !fd.isRepeated() ? Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)fd), t.last()) : Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)fd), (Object)new PRepeated((Vector<PValue>)((Vector)t.foldLeft((Object)package$.MODULE$.Vector().apply((Seq)Nil$.MODULE$), (Function2 & java.io.Serializable & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                Vector xs = (Vector)tuple2._1();
                PValue pValue = (PValue)tuple2._2();
                if (pValue instanceof PRepeated) {
                    Vector<PValue> vector;
                    Vector<PValue> ys = vector = pValue == null ? null : ((PRepeated)pValue).value();
                    return (Vector)xs.$plus$plus(ys, Vector$.MODULE$.canBuildFrom());
                }
            }
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            Vector xs = (Vector)tuple2._1();
            PValue t = (PValue)tuple2._2();
            if (!(t instanceof PValue)) throw new MatchError((Object)tuple2);
            PValue pValue = t;
            return (Vector)xs.$colon$plus((Object)pValue, Vector$.MODULE$.canBuildFrom());
        })))));
    }

    public static final /* synthetic */ boolean $anonfun$parseUnsafe$20(Map fieldMap$1, TField f) {
        return !fieldMap$1.contains((Object)f.name());
    }

    private AstUtils$() {
        MODULE$ = this;
    }
}

