/*
 * Decompiled with CFR 0.152.
 */
package scalapb.textformat;

import com.google.protobuf.ByteString;
import scala.Function1;
import scala.MatchError;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.Vector;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scalapb.GeneratedMessage;
import scalapb.descriptors.EnumValueDescriptor;
import scalapb.descriptors.FieldDescriptor;
import scalapb.descriptors.PBoolean;
import scalapb.descriptors.PByteString;
import scalapb.descriptors.PDouble;
import scalapb.descriptors.PEmpty$;
import scalapb.descriptors.PEnum;
import scalapb.descriptors.PFloat;
import scalapb.descriptors.PInt;
import scalapb.descriptors.PLong;
import scalapb.descriptors.PMessage;
import scalapb.descriptors.PRepeated;
import scalapb.descriptors.PString;
import scalapb.descriptors.PValue;
import scalapb.textformat.TextFormatUtils$;
import scalapb.textformat.TextGenerator;

public final class Printer$ {
    public static Printer$ MODULE$;

    static {
        new Printer$();
    }

    public void print(GeneratedMessage t, TextGenerator out) {
        this.print(t.toPMessage(), out);
    }

    public void print(Map p, TextGenerator out) {
        ((IterableLike)p.toSeq().sortBy((Function1 & java.io.Serializable & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)Printer$.$anonfun$print$1(x$1)), (Ordering)Ordering.Int$.MODULE$)).foreach((Function1 & java.io.Serializable & Serializable)x0$1 -> {
            Printer$.$anonfun$print$2(out, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public String printToString(GeneratedMessage t, boolean singleLineMode, boolean escapeNonAscii) {
        TextGenerator out = new TextGenerator(singleLineMode, escapeNonAscii);
        this.print(t, out);
        return out.result();
    }

    public void printField(FieldDescriptor fd, PValue value, TextGenerator out) {
        PValue pValue = value;
        if (pValue instanceof PRepeated) {
            Vector<PValue> vector;
            Vector<PValue> values = vector = pValue == null ? null : ((PRepeated)pValue).value();
            values.foreach((Function1 & java.io.Serializable & Serializable)v -> MODULE$.printSingleField(fd, (PValue)v, out));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (PEmpty$.MODULE$.equals(pValue)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            this.printSingleField(fd, value, out);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public TextGenerator printSingleField(FieldDescriptor fd, PValue value, TextGenerator out) {
        TextGenerator textGenerator;
        out.add(fd.name());
        PValue pValue = value;
        if (pValue instanceof PMessage) {
            out.addNewLine(" {").indent();
            this.printFieldValue(fd, value, out);
            textGenerator = out.outdent().addNewLine("}");
        } else {
            out.add(": ");
            this.printFieldValue(fd, value, out);
            textGenerator = out.addNewLine("");
        }
        return textGenerator;
    }

    public void printFieldValue(FieldDescriptor fd, PValue value, TextGenerator out) {
        PValue pValue = value;
        if (pValue instanceof PInt) {
            BoxedUnit boxedUnit;
            int n;
            int v = n = ((PInt)pValue).value();
            if (fd.protoType().isTypeUint32() || fd.protoType().isTypeFixed32()) {
                out.add(TextFormatUtils$.MODULE$.unsignedToString(v));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                out.add(((Object)BoxesRunTime.boxToInteger((int)v)).toString());
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else if (pValue instanceof PLong) {
            BoxedUnit boxedUnit;
            long l;
            long v = l = ((PLong)pValue).value();
            if (fd.protoType().isTypeUint64() || fd.protoType().isTypeFixed64()) {
                out.add(TextFormatUtils$.MODULE$.unsignedToString(v));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                out.add(((Object)BoxesRunTime.boxToLong((long)v)).toString());
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit3 = boxedUnit;
        } else if (pValue instanceof PBoolean) {
            boolean bl;
            boolean v = bl = ((PBoolean)pValue).value();
            out.add(((Object)BoxesRunTime.boxToBoolean((boolean)v)).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (pValue instanceof PFloat) {
            float f;
            float v = f = ((PFloat)pValue).value();
            out.add(((Object)BoxesRunTime.boxToFloat((float)v)).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (pValue instanceof PDouble) {
            double d;
            double v = d = ((PDouble)pValue).value();
            out.add(((Object)BoxesRunTime.boxToDouble((double)v)).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (pValue instanceof PEnum) {
            BoxedUnit boxedUnit;
            EnumValueDescriptor enumValueDescriptor = pValue == null ? null : ((PEnum)pValue).value();
            EnumValueDescriptor v = enumValueDescriptor;
            if (!v.isUnrecognized()) {
                out.add(v.name());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                out.add(((Object)BoxesRunTime.boxToInteger((int)v.number())).toString());
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit4 = boxedUnit;
        } else if (pValue instanceof PMessage) {
            Map<FieldDescriptor, PValue> map = pValue == null ? null : ((PMessage)pValue).value();
            this.print(map, out);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (pValue instanceof PString) {
            String string;
            String v = string = pValue == null ? null : ((PString)pValue).value();
            out.add("\"").addMaybeEscape(v).add("\"");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (pValue instanceof PByteString) {
            ByteString byteString;
            ByteString v = byteString = pValue == null ? null : ((PByteString)pValue).value();
            out.add("\"").add(TextFormatUtils$.MODULE$.escapeBytes(v)).add("\"");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            if (pValue instanceof PRepeated) {
                throw new RuntimeException("Should not happen.");
            }
            if (PEmpty$.MODULE$.equals(pValue)) {
                throw new RuntimeException("Should not happen.");
            }
            throw new MatchError((Object)pValue);
        }
    }

    public static final /* synthetic */ int $anonfun$print$1(Tuple2 x$1) {
        return ((FieldDescriptor)x$1._1()).number();
    }

    public static final /* synthetic */ void $anonfun$print$2(TextGenerator out$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        FieldDescriptor fd = (FieldDescriptor)tuple2._1();
        PValue value = (PValue)tuple2._2();
        MODULE$.printField(fd, value, out$1);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private Printer$() {
        MODULE$ = this;
    }
}

