/*
 * Decompiled with CFR 0.152.
 */
package scalapb.textformat;

import com.google.protobuf.descriptor.FieldDescriptorProto;
import com.google.protobuf.descriptor.FieldDescriptorProto$Type$TYPE_BOOL$;
import com.google.protobuf.descriptor.FieldDescriptorProto$Type$TYPE_BYTES$;
import com.google.protobuf.descriptor.FieldDescriptorProto$Type$TYPE_DOUBLE$;
import com.google.protobuf.descriptor.FieldDescriptorProto$Type$TYPE_ENUM$;
import com.google.protobuf.descriptor.FieldDescriptorProto$Type$TYPE_FIXED32$;
import com.google.protobuf.descriptor.FieldDescriptorProto$Type$TYPE_FIXED64$;
import com.google.protobuf.descriptor.FieldDescriptorProto$Type$TYPE_FLOAT$;
import com.google.protobuf.descriptor.FieldDescriptorProto$Type$TYPE_GROUP$;
import com.google.protobuf.descriptor.FieldDescriptorProto$Type$TYPE_INT32$;
import com.google.protobuf.descriptor.FieldDescriptorProto$Type$TYPE_INT64$;
import com.google.protobuf.descriptor.FieldDescriptorProto$Type$TYPE_SFIXED32$;
import com.google.protobuf.descriptor.FieldDescriptorProto$Type$TYPE_SFIXED64$;
import com.google.protobuf.descriptor.FieldDescriptorProto$Type$TYPE_SINT32$;
import com.google.protobuf.descriptor.FieldDescriptorProto$Type$TYPE_SINT64$;
import com.google.protobuf.descriptor.FieldDescriptorProto$Type$TYPE_STRING$;
import com.google.protobuf.descriptor.FieldDescriptorProto$Type$TYPE_UINT32$;
import com.google.protobuf.descriptor.FieldDescriptorProto$Type$TYPE_UINT64$;
import java.io.Serializable;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.math.BigInt;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try$;
import scalapb.GeneratedMessage;
import scalapb.GeneratedMessageCompanion;
import scalapb.descriptors.EnumDescriptor;
import scalapb.descriptors.EnumValueDescriptor;
import scalapb.descriptors.FieldDescriptor;
import scalapb.descriptors.PBoolean;
import scalapb.descriptors.PByteString$;
import scalapb.descriptors.PDouble;
import scalapb.descriptors.PEnum$;
import scalapb.descriptors.PFloat;
import scalapb.descriptors.PInt;
import scalapb.descriptors.PLong;
import scalapb.descriptors.PMessage;
import scalapb.descriptors.PRepeated;
import scalapb.descriptors.PRepeated$;
import scalapb.descriptors.PString$;
import scalapb.descriptors.PValue;
import scalapb.textformat.AstUtils;
import scalapb.textformat.TArray;
import scalapb.textformat.TBytes;
import scalapb.textformat.TField;
import scalapb.textformat.TIntLiteral;
import scalapb.textformat.TLiteral;
import scalapb.textformat.TMessage;
import scalapb.textformat.TPrimitive;
import scalapb.textformat.TValue;
import scalapb.textformat.TextFormatUtils$;

public final class AstUtils$ {
    public static final AstUtils$ MODULE$ = new AstUtils$();

    private <T> Either<AstUtils.AstError, Vector<T>> flatten(Seq<Either<AstUtils.AstError, T>> s) {
        return (Either)s.foldLeft((Object)package$.MODULE$.Right().apply((Object)package$.MODULE$.Vector().empty()), (Function2 & Serializable)(x0$1, x1$1) -> {
            Either either;
            Either either2;
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null && (either2 = (Either)tuple2._1()) instanceof Left) {
                Left left = (Left)either2;
                AstUtils.AstError l = (AstUtils.AstError)left.value();
                return package$.MODULE$.Left().apply((Object)l);
            }
            if (tuple2 != null && (either = (Either)tuple2._2()) instanceof Left) {
                Left left = (Left)either;
                AstUtils.AstError l = (AstUtils.AstError)left.value();
                return package$.MODULE$.Left().apply((Object)l);
            }
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            Either either3 = (Either)tuple2._1();
            Either either4 = (Either)tuple2._2();
            if (!(either3 instanceof Right)) throw new MatchError((Object)tuple2);
            Right right = (Right)either3;
            Vector xs = (Vector)right.value();
            if (!(either4 instanceof Right)) throw new MatchError((Object)tuple2);
            Right right2 = (Right)either4;
            Object x = right2.value();
            return package$.MODULE$.Right().apply(xs.$colon$plus(x));
        });
    }

    public <T extends GeneratedMessage> Either<AstUtils.AstError, T> parseMessage(GeneratedMessageCompanion<T> v, TMessage ast2) {
        return this.parseUnsafe(v, ast2).right().map(v.messageReads().read());
    }

    public Either<AstUtils.AstError, BigInt> checkBigInt(TPrimitive p, boolean isSigned, boolean isLong) {
        Left left;
        TPrimitive tPrimitive = p;
        if (tPrimitive instanceof TIntLiteral) {
            int maxBits;
            boolean negative;
            TIntLiteral tIntLiteral = (TIntLiteral)tPrimitive;
            int index = tIntLiteral.index();
            BigInt v = tIntLiteral.value();
            boolean bl = negative = v.signum() == -1;
            int n = isLong ? (isSigned ? 63 : 64) : (maxBits = isSigned ? 31 : 32);
            left = !isSigned && negative ? package$.MODULE$.Left().apply((Object)new AstUtils.AstError(index, new StringBuilder(25).append("Number must be positive: ").append(v).toString())) : (v.bitLength() > maxBits ? package$.MODULE$.Left().apply((Object)new AstUtils.AstError(index, new StringBuilder(39).append("Number out of range for ").append(isLong ? BoxesRunTime.boxToInteger((int)64) : BoxesRunTime.boxToInteger((int)32)).append("-bit ").append((Object)(isSigned ? "signed" : "unsigned")).append(" integer: ").append(v).toString())) : package$.MODULE$.Right().apply((Object)v));
        } else {
            left = package$.MODULE$.Left().apply((Object)new AstUtils.AstError(tPrimitive.index(), new StringBuilder(16).append("Invalid input '").append(tPrimitive.asString()).append("'").toString()));
        }
        return left;
    }

    public boolean checkBigInt$default$2() {
        return true;
    }

    public Either<AstUtils.AstError, PInt> parseInt32(TPrimitive p) {
        return this.checkBigInt(p, true, false).right().map((Function1 & Serializable)t -> new PInt(t.intValue()));
    }

    public Either<AstUtils.AstError, PInt> parseUint32(TPrimitive p) {
        return this.checkBigInt(p, false, false).right().map((Function1 & Serializable)t -> new PInt(t.intValue()));
    }

    public Either<AstUtils.AstError, PLong> parseInt64(TPrimitive p) {
        return this.checkBigInt(p, true, true).right().map((Function1 & Serializable)t -> new PLong(t.longValue()));
    }

    public Either<AstUtils.AstError, PLong> parseUint64(TPrimitive p) {
        return this.checkBigInt(p, false, true).right().map((Function1 & Serializable)t -> new PLong(t.longValue()));
    }

    private Either<AstUtils.AstError, PMessage> parseUnsafe(GeneratedMessageCompanion<?> v, TMessage ast2) {
        Left left;
        Map fieldMap = ((IterableOnceOps)v.scalaDescriptor().fields().map((Function1 & Serializable)f -> new Tuple2((Object)f.name(), f))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Map fields = ast2.fields().groupBy((Function1 & Serializable)x$5 -> x$5.name());
        Option option = ast2.fields().find((Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)AstUtils$.$anonfun$parseUnsafe$20(fieldMap, f)));
        if (option instanceof Some) {
            Some some = (Some)option;
            TField f2 = (TField)some.value();
            left = package$.MODULE$.Left().apply((Object)new AstUtils.AstError(f2.index(), new StringBuilder(21).append("Unknown field name '").append(f2.name()).append("'").toString()));
        } else if (None$.MODULE$.equals(option)) {
            left = this.flatten((Seq)((IterableOnceOps)fields.map(((Function2 & Serializable)(Function2 & Serializable)(name, group) -> this.fieldGroupToValue$1((String)name, (Seq)group, fieldMap, v)).tupled())).toVector());
        } else {
            throw new MatchError((Object)option);
        }
        Left maybeMap = left;
        return maybeMap.right().map((Function1 & Serializable)t -> new PMessage((Map<FieldDescriptor, PValue>)t.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())));
    }

    private static final Either parseDouble$1(TPrimitive p) {
        Right right;
        block16: {
            TPrimitive tPrimitive;
            block11: {
                Either either;
                block15: {
                    String value;
                    block12: {
                        block13: {
                            block14: {
                                tPrimitive = p;
                                if (!(tPrimitive instanceof TLiteral)) break block11;
                                TLiteral tLiteral = (TLiteral)tPrimitive;
                                value = tLiteral.value();
                                String low = value.toLowerCase();
                                String string = low;
                                switch (string == null ? 0 : string.hashCode()) {
                                    case 104417: {
                                        if ("inf".equals(string)) {
                                            break;
                                        }
                                        break block12;
                                    }
                                    case 108827: {
                                        if (!"nan".equals(string)) break block12;
                                        break block13;
                                    }
                                    case 1445012: {
                                        if (!"-inf".equals(string)) break block12;
                                        break block14;
                                    }
                                    case 173173288: {
                                        if ("infinity".equals(string)) {
                                            break;
                                        }
                                        break block12;
                                    }
                                    case 442101077: {
                                        if (!"-infinity".equals(string)) break block12;
                                        break block14;
                                    }
                                    default: {
                                        break block12;
                                    }
                                }
                                either = package$.MODULE$.Right().apply((Object)new PDouble(Double.POSITIVE_INFINITY));
                                break block15;
                            }
                            either = package$.MODULE$.Right().apply((Object)new PDouble(Double.NEGATIVE_INFINITY));
                            break block15;
                        }
                        either = package$.MODULE$.Right().apply((Object)new PDouble(Double.NaN));
                        break block15;
                    }
                    either = Try$.MODULE$.apply((Function0 & Serializable)() -> new PDouble(StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(value)))).toOption().toRight((Function0 & Serializable)() -> new AstUtils.AstError(p.index(), new StringBuilder(28).append("Invalid value for double: '").append(value).append("'").toString()));
                }
                right = either;
                break block16;
            }
            if (tPrimitive instanceof TIntLiteral) {
                TIntLiteral tIntLiteral = (TIntLiteral)tPrimitive;
                BigInt value = tIntLiteral.value();
                right = package$.MODULE$.Right().apply((Object)new PDouble(value.toDouble()));
            } else {
                right = package$.MODULE$.Left().apply((Object)new AstUtils.AstError(tPrimitive.index(), new StringBuilder(32).append("Invalid input '").append(tPrimitive.asString()).append("', expected float").toString()));
            }
        }
        return right;
    }

    private static final Either parseFloat$1(TPrimitive p) {
        Right right;
        block23: {
            TPrimitive tPrimitive;
            block18: {
                Either either;
                block22: {
                    String value;
                    block19: {
                        block20: {
                            block21: {
                                tPrimitive = p;
                                if (!(tPrimitive instanceof TLiteral)) break block18;
                                TLiteral tLiteral = (TLiteral)tPrimitive;
                                value = tLiteral.value();
                                String low = value.toLowerCase();
                                String string = low;
                                switch (string == null ? 0 : string.hashCode()) {
                                    case 104417: {
                                        if ("inf".equals(string)) {
                                            break;
                                        }
                                        break block19;
                                    }
                                    case 108827: {
                                        if (!"nan".equals(string)) break block19;
                                        break block20;
                                    }
                                    case 1445012: {
                                        if (!"-inf".equals(string)) break block19;
                                        break block21;
                                    }
                                    case 3237029: {
                                        if ("inff".equals(string)) {
                                            break;
                                        }
                                        break block19;
                                    }
                                    case 3373739: {
                                        if (!"nanf".equals(string)) break block19;
                                        break block20;
                                    }
                                    case 44795474: {
                                        if (!"-inff".equals(string)) break block19;
                                        break block21;
                                    }
                                    case 173173288: {
                                        if ("infinity".equals(string)) {
                                            break;
                                        }
                                        break block19;
                                    }
                                    case 442101077: {
                                        if (!"-infinity".equals(string)) break block19;
                                        break block21;
                                    }
                                    case 820231601: {
                                        if (!"-infinityf".equals(string)) break block19;
                                        break block21;
                                    }
                                    case 1073404734: {
                                        if ("infinityf".equals(string)) {
                                            break;
                                        }
                                        break block19;
                                    }
                                    default: {
                                        break block19;
                                    }
                                }
                                either = package$.MODULE$.Right().apply((Object)new PFloat(Float.POSITIVE_INFINITY));
                                break block22;
                            }
                            either = package$.MODULE$.Right().apply((Object)new PFloat(Float.NEGATIVE_INFINITY));
                            break block22;
                        }
                        either = package$.MODULE$.Right().apply((Object)new PFloat(Float.NaN));
                        break block22;
                    }
                    either = Try$.MODULE$.apply((Function0 & Serializable)() -> new PFloat(StringOps$.MODULE$.toFloat$extension(Predef$.MODULE$.augmentString(value)))).toOption().toRight((Function0 & Serializable)() -> new AstUtils.AstError(p.index(), new StringBuilder(27).append("Invalid value for float: '").append(value).append("'").toString()));
                }
                right = either;
                break block23;
            }
            if (tPrimitive instanceof TIntLiteral) {
                TIntLiteral tIntLiteral = (TIntLiteral)tPrimitive;
                BigInt value = tIntLiteral.value();
                right = package$.MODULE$.Right().apply((Object)new PFloat(value.toFloat()));
            } else {
                right = package$.MODULE$.Left().apply((Object)new AstUtils.AstError(tPrimitive.index(), new StringBuilder(32).append("Invalid input '").append(tPrimitive.asString()).append("', expected float").toString()));
            }
        }
        return right;
    }

    private static final String invalidInput$1(String v) {
        return new StringBuilder(44).append("Invalid input '").append(v).append("', expected 'true' or 'false'").toString();
    }

    private static final Either parseBoolean$1(TPrimitive p) {
        Right right;
        block11: {
            TPrimitive tPrimitive;
            block12: {
                Left left;
                block15: {
                    String v;
                    int index;
                    block13: {
                        block14: {
                            block10: {
                                tPrimitive = p;
                                if (!(tPrimitive instanceof TIntLiteral)) break block10;
                                TIntLiteral tIntLiteral = (TIntLiteral)tPrimitive;
                                int index2 = tIntLiteral.index();
                                BigInt v2 = tIntLiteral.value();
                                right = BoxesRunTime.equalsNumObject((Number)v2, (Object)BoxesRunTime.boxToInteger((int)0)) ? package$.MODULE$.Right().apply((Object)new PBoolean(false)) : (BoxesRunTime.equalsNumObject((Number)v2, (Object)BoxesRunTime.boxToInteger((int)1)) ? package$.MODULE$.Right().apply((Object)new PBoolean(true)) : package$.MODULE$.Left().apply((Object)new AstUtils.AstError(index2, AstUtils$.invalidInput$1(v2.toString()))));
                                break block11;
                            }
                            if (!(tPrimitive instanceof TLiteral)) break block12;
                            TLiteral tLiteral = (TLiteral)tPrimitive;
                            index = tLiteral.index();
                            v = tLiteral.value();
                            String string = v.toLowerCase();
                            switch (string == null ? 0 : string.hashCode()) {
                                case 102: {
                                    if (!"f".equals(string)) break block13;
                                    break block14;
                                }
                                case 116: {
                                    if ("t".equals(string)) {
                                        break;
                                    }
                                    break block13;
                                }
                                case 3569038: {
                                    if ("true".equals(string)) {
                                        break;
                                    }
                                    break block13;
                                }
                                case 97196323: {
                                    if (!"false".equals(string)) break block13;
                                    break block14;
                                }
                                default: {
                                    break block13;
                                }
                            }
                            left = package$.MODULE$.Right().apply((Object)new PBoolean(true));
                            break block15;
                        }
                        left = package$.MODULE$.Right().apply((Object)new PBoolean(false));
                        break block15;
                    }
                    left = package$.MODULE$.Left().apply((Object)new AstUtils.AstError(index, AstUtils$.invalidInput$1(v.toString())));
                }
                right = left;
                break block11;
            }
            if (tPrimitive instanceof TBytes) {
                TBytes tBytes = (TBytes)tPrimitive;
                String v = tBytes.value();
                right = package$.MODULE$.Left().apply((Object)new AstUtils.AstError(p.index(), AstUtils$.invalidInput$1(v)));
            } else {
                throw new MatchError((Object)tPrimitive);
            }
        }
        return right;
    }

    private static final Either parseString$1(TPrimitive p) {
        Either either;
        TPrimitive tPrimitive = p;
        if (tPrimitive instanceof TBytes) {
            TBytes tBytes = (TBytes)tPrimitive;
            String value = tBytes.value();
            either = TextFormatUtils$.MODULE$.unescapeText(value).right().map((Function1)PString$.MODULE$).left().map((Function1 & Serializable)error -> new AstUtils.AstError(p.index(), error.msg()));
        } else {
            either = package$.MODULE$.Left().apply((Object)new AstUtils.AstError(tPrimitive.index(), new StringBuilder(33).append("Invalid input '").append(tPrimitive.asString()).append("', expected string").toString()));
        }
        return either;
    }

    private static final Either parseBytes$1(TPrimitive p) {
        Left left;
        TPrimitive tPrimitive = p;
        if (tPrimitive instanceof TBytes) {
            TBytes tBytes = (TBytes)tPrimitive;
            String value = tBytes.value();
            left = TextFormatUtils$.MODULE$.unescapeBytes(value).right().map((Function1)PByteString$.MODULE$).left().map((Function1 & Serializable)error -> new AstUtils.AstError(p.index(), error.msg()));
        } else {
            left = package$.MODULE$.Left().apply((Object)new AstUtils.AstError(p.index(), "Unexpected input"));
        }
        return left;
    }

    public static final /* synthetic */ boolean $anonfun$parseUnsafe$7(BigInt num$1, EnumValueDescriptor x$1) {
        return x$1.number() == num$1.toInt();
    }

    public static final /* synthetic */ boolean $anonfun$parseUnsafe$9(String name$1, EnumValueDescriptor x$2) {
        String string = x$2.name();
        String string2 = name$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private final Either parsePrimitive$1(FieldDescriptor field, TPrimitive p, GeneratedMessageCompanion v$1) {
        Left left;
        FieldDescriptorProto.Type type = field.protoType();
        if (FieldDescriptorProto$Type$TYPE_DOUBLE$.MODULE$.equals(type)) {
            left = AstUtils$.parseDouble$1(p);
        } else if (FieldDescriptorProto$Type$TYPE_FLOAT$.MODULE$.equals(type)) {
            left = AstUtils$.parseFloat$1(p);
        } else if (FieldDescriptorProto$Type$TYPE_INT64$.MODULE$.equals(type)) {
            left = this.parseInt64(p);
        } else if (FieldDescriptorProto$Type$TYPE_UINT64$.MODULE$.equals(type)) {
            left = this.parseUint64(p);
        } else if (FieldDescriptorProto$Type$TYPE_INT32$.MODULE$.equals(type)) {
            left = this.parseInt32(p);
        } else if (FieldDescriptorProto$Type$TYPE_FIXED64$.MODULE$.equals(type)) {
            left = this.parseUint64(p);
        } else if (FieldDescriptorProto$Type$TYPE_FIXED32$.MODULE$.equals(type)) {
            left = this.parseUint32(p);
        } else if (FieldDescriptorProto$Type$TYPE_BOOL$.MODULE$.equals(type)) {
            left = AstUtils$.parseBoolean$1(p);
        } else if (FieldDescriptorProto$Type$TYPE_STRING$.MODULE$.equals(type)) {
            left = AstUtils$.parseString$1(p);
        } else if (FieldDescriptorProto$Type$TYPE_BYTES$.MODULE$.equals(type)) {
            left = AstUtils$.parseBytes$1(p);
        } else if (FieldDescriptorProto$Type$TYPE_UINT32$.MODULE$.equals(type)) {
            left = this.parseUint32(p);
        } else if (FieldDescriptorProto$Type$TYPE_SFIXED32$.MODULE$.equals(type)) {
            left = this.parseInt32(p);
        } else if (FieldDescriptorProto$Type$TYPE_SFIXED64$.MODULE$.equals(type)) {
            left = this.parseInt64(p);
        } else if (FieldDescriptorProto$Type$TYPE_SINT32$.MODULE$.equals(type)) {
            left = this.parseInt32(p);
        } else if (FieldDescriptorProto$Type$TYPE_SINT64$.MODULE$.equals(type)) {
            left = this.parseInt64(p);
        } else if (FieldDescriptorProto$Type$TYPE_GROUP$.MODULE$.equals(type)) {
            left = package$.MODULE$.Left().apply((Object)new AstUtils.AstError(p.index(), "groups are not supported"));
        } else if (FieldDescriptorProto$Type$TYPE_ENUM$.MODULE$.equals(type)) {
            Either either;
            EnumDescriptor enumDesc = v$1.enumCompanionForFieldNumber(field.number()).scalaDescriptor();
            TPrimitive tPrimitive = p;
            if (tPrimitive instanceof TIntLiteral) {
                TIntLiteral tIntLiteral = (TIntLiteral)tPrimitive;
                int index = tIntLiteral.index();
                BigInt num = tIntLiteral.value();
                either = enumDesc.values().find((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)AstUtils$.$anonfun$parseUnsafe$7(num, x$1))).map((Function1)PEnum$.MODULE$).toRight((Function0 & Serializable)() -> new AstUtils.AstError(index, new StringBuilder(47).append("Expected Enum type \"").append(enumDesc.asProto().getName()).append("\" has no value with number ").append(num.toString()).toString()));
            } else if (tPrimitive instanceof TLiteral) {
                TLiteral tLiteral = (TLiteral)tPrimitive;
                int index = tLiteral.index();
                String name = tLiteral.value();
                either = enumDesc.values().find((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)AstUtils$.$anonfun$parseUnsafe$9(name, x$2))).map((Function1)PEnum$.MODULE$).toRight((Function0 & Serializable)() -> new AstUtils.AstError(index, new StringBuilder(43).append("Expected Enum type \"").append(enumDesc.asProto().getName()).append("\" has no value named \"").append(name).append("\"").toString()));
            } else {
                either = package$.MODULE$.Left().apply((Object)new AstUtils.AstError(tPrimitive.index(), new StringBuilder(38).append("Invalid value '").append(tPrimitive.asString()).append(", expected Enum type \"").append(enumDesc.asProto().getName()).append("\"").toString()));
            }
            left = either;
        } else {
            left = package$.MODULE$.Left().apply((Object)new AstUtils.AstError(p.index(), "This should not happen."));
        }
        return left;
    }

    public static final /* synthetic */ boolean $anonfun$parseUnsafe$11(TValue x$3) {
        return !(x$3 instanceof TMessage);
    }

    public static final /* synthetic */ boolean $anonfun$parseUnsafe$13(TValue x$4) {
        return !(x$4 instanceof TPrimitive);
    }

    private final Either pfieldToValue$1(FieldDescriptor fd, TField pfield, GeneratedMessageCompanion v$1) {
        Left left;
        TValue tValue = pfield.value();
        if (tValue instanceof TArray) {
            int idx;
            int idx2;
            TArray tArray = (TArray)tValue;
            Object object = !fd.isRepeated() ? package$.MODULE$.Left().apply((Object)new AstUtils.AstError(tArray.index(), new StringBuilder(28).append("Invalid input '[', expected ").append(fd.protoType().toString().toLowerCase()).toString())) : (fd.protoType().isTypeMessage() ? ((idx2 = tArray.values().indexWhere((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)AstUtils$.$anonfun$parseUnsafe$11(x$3)))) != -1 ? package$.MODULE$.Left().apply((Object)new AstUtils.AstError(tArray.index(), new StringBuilder(43).append("Array contain a non-message value at index ").append(idx2).toString())) : this.flatten((Seq)((IterableOnceOps)tArray.values().map((Function1 & Serializable)t -> MODULE$.parseUnsafe(v$1.messageCompanionForFieldNumber(fd.number()), (TMessage)t))).toVector()).right().map((Function1)PRepeated$.MODULE$)) : ((idx = tArray.values().indexWhere((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)AstUtils$.$anonfun$parseUnsafe$13(x$4)))) != -1 ? package$.MODULE$.Left().apply((Object)new AstUtils.AstError(tArray.index(), new StringBuilder(26).append("Unexpected value at index ").append(idx).toString())) : this.flatten((Seq)((IterableOnceOps)tArray.values().map((Function1 & Serializable)t -> this.parsePrimitive$1(fd, (TPrimitive)t, v$1))).toVector()).right().map((Function1)PRepeated$.MODULE$)));
            left = object;
        } else if (tValue instanceof TPrimitive) {
            TPrimitive tPrimitive = (TPrimitive)tValue;
            left = fd.protoType().isTypeMessage() ? package$.MODULE$.Left().apply((Object)new AstUtils.AstError(tPrimitive.index(), "invalid value for message")) : this.parsePrimitive$1(fd, tPrimitive, v$1);
        } else if (tValue instanceof TMessage) {
            TMessage tMessage = (TMessage)tValue;
            left = !fd.protoType().isTypeMessage() ? package$.MODULE$.Left().apply((Object)new AstUtils.AstError(tMessage.index(), "invalid value for message")) : this.parseUnsafe(v$1.messageCompanionForFieldNumber(fd.number()), tMessage);
        } else {
            throw new MatchError((Object)tValue);
        }
        return left;
    }

    private final Either fieldGroupToValue$1(String name, Seq group, Map fieldMap$1, GeneratedMessageCompanion v$1) {
        FieldDescriptor fd = (FieldDescriptor)fieldMap$1.apply((Object)name);
        Either values = this.flatten((Seq)group.map((Function1 & Serializable)x$6 -> this.pfieldToValue$1(fd, (TField)x$6, v$1)));
        return values.right().map((Function1 & Serializable)t -> !fd.isRepeated() ? Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)fd), t.last()) : Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)fd), (Object)new PRepeated((Vector<PValue>)((Vector)t.foldLeft(package$.MODULE$.Vector().apply((Seq)Nil$.MODULE$), (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                Vector xs = (Vector)tuple2._1();
                PValue pValue = (PValue)tuple2._2();
                if (pValue instanceof PRepeated) {
                    Vector<PValue> vector;
                    Vector<PValue> ys = vector = pValue == null ? null : ((PRepeated)pValue).value();
                    return (Vector)xs.$plus$plus(ys);
                }
            }
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            Vector xs = (Vector)tuple2._1();
            PValue t = (PValue)tuple2._2();
            if (!(t instanceof PValue)) throw new MatchError((Object)tuple2);
            PValue pValue = t;
            return (Vector)xs.$colon$plus((Object)pValue);
        })))));
    }

    public static final /* synthetic */ boolean $anonfun$parseUnsafe$20(Map fieldMap$1, TField f) {
        return !fieldMap$1.contains((Object)f.name());
    }

    private AstUtils$() {
    }
}

