/*
 * Decompiled with CFR 0.152.
 */
package org.jline.builtins;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jline.builtins.Completers;
import org.jline.builtins.Less;
import org.jline.builtins.Nano;
import org.jline.builtins.Options;
import org.jline.builtins.Source;
import org.jline.builtins.Tmux;
import org.jline.keymap.KeyMap;
import org.jline.reader.Binding;
import org.jline.reader.ConfigurationPath;
import org.jline.reader.Highlighter;
import org.jline.reader.History;
import org.jline.reader.LineReader;
import org.jline.reader.Macro;
import org.jline.reader.Reference;
import org.jline.reader.Widget;
import org.jline.terminal.Terminal;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;

public class Commands {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tmux(Terminal terminal, PrintStream out, PrintStream err, Supplier<Object> getter, Consumer<Object> setter, Consumer<Terminal> runner, String[] argv) throws Exception {
        String[] usage = new String[]{"tmux -  terminal multiplexer", "Usage: tmux [command]", "  -? --help                    Show help"};
        Options opt = Options.compile(usage).parse(argv);
        if (opt.isSet("help")) {
            throw new Options.HelpException(opt.usage());
        }
        if (argv.length == 0) {
            Object instance = getter.get();
            if (instance != null) {
                err.println("tmux: can't run tmux inside itself");
            } else {
                Tmux tmux = new Tmux(terminal, err, runner);
                setter.accept(tmux);
                try {
                    tmux.run();
                }
                finally {
                    setter.accept(null);
                }
            }
        } else {
            Object instance = getter.get();
            if (instance != null) {
                ((Tmux)instance).execute(out, err, Arrays.asList(argv));
            } else {
                err.println("tmux: no instance running");
            }
        }
    }

    public static void nano(Terminal terminal, PrintStream out, PrintStream err, Path currentDir, String[] argv) throws Exception {
        Commands.nano(terminal, out, err, currentDir, argv, null);
    }

    public static void nano(Terminal terminal, PrintStream out, PrintStream err, Path currentDir, String[] argv, ConfigurationPath configPath) throws Exception {
        Options opt = Options.compile(Nano.usage()).parse(argv);
        if (opt.isSet("help")) {
            throw new Options.HelpException(opt.usage());
        }
        Nano edit = new Nano(terminal, currentDir, opt, configPath);
        edit.open(opt.args());
        edit.run();
    }

    public static void less(Terminal terminal, InputStream in, PrintStream out, PrintStream err, Path currentDir, String[] argv) throws Exception {
        Commands.less(terminal, in, out, err, currentDir, argv, null);
    }

    public static void less(Terminal terminal, InputStream in, PrintStream out, PrintStream err, Path currentDir, String[] argv, ConfigurationPath configPath) throws Exception {
        Options opt = Options.compile(Less.usage()).parse(argv);
        if (opt.isSet("help")) {
            throw new Options.HelpException(opt.usage());
        }
        Less less2 = new Less(terminal, currentDir, opt, configPath);
        ArrayList<Source> sources = new ArrayList<Source>();
        if (opt.args().isEmpty()) {
            opt.args().add("-");
        }
        for (String arg : opt.args()) {
            String string = arg = arg.startsWith("~") ? arg.replace("~", System.getProperty("user.home")) : arg;
            if ("-".equals(arg)) {
                sources.add(new Source.StdInSource(in));
                continue;
            }
            if (arg.contains("*") || arg.contains("?")) {
                for (Path p : Commands.findFiles(currentDir, arg)) {
                    sources.add(new Source.URLSource(p.toUri().toURL(), p.toString()));
                }
                continue;
            }
            sources.add(new Source.URLSource(currentDir.resolve(arg).toUri().toURL(), arg));
        }
        less2.run(sources);
    }

    protected static List<Path> findFiles(Path root2, String files) throws IOException {
        String regex = files = files.startsWith("~") ? files.replace("~", System.getProperty("user.home")) : files;
        Path searchRoot = Paths.get("/", new String[0]);
        if (new File(files).isAbsolute()) {
            if ((regex = regex.replaceAll("\\\\", "/").replaceAll("//", "/")).contains("/")) {
                String sr = regex.substring(0, regex.lastIndexOf("/") + 1);
                while (sr.contains("*") || sr.contains("?")) {
                    sr = sr.substring(0, sr.lastIndexOf("/"));
                }
                searchRoot = Paths.get(sr + "/", new String[0]);
            }
        } else {
            regex = (root2.toString().length() == 0 ? "" : root2.toString() + "/") + files;
            regex = regex.replaceAll("\\\\", "/").replaceAll("//", "/");
            searchRoot = root2;
        }
        PathMatcher pathMatcher = FileSystems.getDefault().getPathMatcher("glob:" + regex);
        return Files.find(searchRoot, Integer.MAX_VALUE, (path, f) -> pathMatcher.matches((Path)path), new FileVisitOption[0]).collect(Collectors.toList());
    }

    public static void history(LineReader reader, PrintStream out, PrintStream err, Path currentDir, String[] argv) throws Exception {
        Path file;
        String[] usage = new String[]{"history -  list history of commands", "Usage: history [-dnrfEie] [-m match] [first] [last]", "       history -ARWI [filename]", "       history -s [old=new] [command]", "       history --clear", "       history --save", "  -? --help                       Displays command help", "     --clear                      Clear history", "     --save                       Save history", "  -m match                        If option -m is present the first argument is taken as a pattern", "                                  and only the history events matching the pattern will be shown", "  -d                              Print timestamps for each event", "  -f                              Print full time date stamps in the US format", "  -E                              Print full time date stamps in the European format", "  -i                              Print full time date stamps in ISO8601 format", "  -n                              Suppresses command numbers", "  -r                              Reverses the order of the commands", "  -A                              Appends the history out to the given file", "  -R                              Reads the history from the given file", "  -W                              Writes the history out to the given file", "  -I                              If added to -R, only the events that are not contained within the internal list are added", "                                  If added to -W or -A, only the events that are new since the last incremental operation", "                                  to the file are added", "  [first] [last]                  These optional arguments may be specified as a number or as a string. A negative number", "                                  is used as an offset to the current history event number. A string specifies the most", "                                  recent event beginning with the given string.", "  -e                              Uses the nano editor to edit the commands before executing", "  -s                              Re-executes the command without invoking an editor"};
        Options opt = Options.compile(usage).parse(argv);
        if (opt.isSet("help")) {
            throw new Options.HelpException(opt.usage());
        }
        History history = reader.getHistory();
        boolean done = true;
        boolean increment = opt.isSet("I");
        if (opt.isSet("clear")) {
            history.purge();
        } else if (opt.isSet("save")) {
            history.save();
        } else if (opt.isSet("A")) {
            file = opt.args().size() > 0 ? currentDir.resolve(opt.args().get(0)) : null;
            history.append(file, increment);
        } else if (opt.isSet("R")) {
            file = opt.args().size() > 0 ? currentDir.resolve(opt.args().get(0)) : null;
            history.read(file, increment);
        } else if (opt.isSet("W")) {
            file = opt.args().size() > 0 ? currentDir.resolve(opt.args().get(0)) : null;
            history.write(file, increment);
        } else {
            done = false;
        }
        if (done) {
            return;
        }
        ReExecute execute = new ReExecute(history, opt);
        int argId = execute.getArgId();
        Pattern pattern = null;
        if (opt.isSet("m") && opt.args().size() > argId) {
            StringBuilder sb = new StringBuilder();
            int prev = 48;
            for (int n : opt.args().get(argId++).toCharArray()) {
                if (n == 42 && prev != 92 && prev != 46) {
                    sb.append('.');
                }
                sb.append((char)n);
                prev = n;
            }
            pattern = Pattern.compile(sb.toString(), 32);
        }
        boolean reverse = opt.isSet("r") || opt.isSet("s") && opt.args().size() <= argId;
        int firstId = opt.args().size() > argId ? Commands.retrieveHistoryId(history, opt.args().get(argId++)) : -17;
        int lastId = opt.args().size() > argId ? Commands.retrieveHistoryId(history, opt.args().get(argId++)) : -1;
        if ((firstId = Commands.historyId(firstId, history.first(), history.last())) > (lastId = Commands.historyId(lastId, history.first(), history.last()))) {
            int tmpId = firstId;
            firstId = lastId;
            lastId = tmpId;
            reverse = !reverse;
        }
        int tot = lastId - firstId + 1;
        int listed = 0;
        Highlighter highlighter = reader.getHighlighter();
        Iterator<History.Entry> iter = null;
        iter = reverse ? history.reverseIterator(lastId) : history.iterator(firstId);
        while (iter.hasNext() && listed < tot) {
            History.Entry entry = iter.next();
            ++listed;
            if (pattern != null && !pattern.matcher(entry.line()).matches()) continue;
            if (execute.isExecute()) {
                if (execute.isEdit()) {
                    execute.addCommandInFile(entry.line());
                    continue;
                }
                execute.addCommandInBuffer(reader, entry.line());
                break;
            }
            AttributedStringBuilder sb = new AttributedStringBuilder();
            if (!opt.isSet("n")) {
                sb.append("  ");
                sb.styled(AttributedStyle::bold, (CharSequence)String.format("%3d", entry.index()));
            }
            if (opt.isSet("d") || opt.isSet("f") || opt.isSet("E") || opt.isSet("i")) {
                Comparable<LocalTime> lt;
                sb.append("  ");
                if (opt.isSet("d")) {
                    lt = LocalTime.from(entry.time().atZone(ZoneId.systemDefault())).truncatedTo(ChronoUnit.SECONDS);
                    DateTimeFormatter.ISO_LOCAL_TIME.formatTo((TemporalAccessor)((Object)lt), sb);
                } else {
                    lt = LocalDateTime.from(entry.time().atZone(ZoneId.systemDefault()).truncatedTo(ChronoUnit.MINUTES));
                    String format = "yyyy-MM-dd hh:mm";
                    if (opt.isSet("f")) {
                        format = "MM/dd/yy hh:mm";
                    } else if (opt.isSet("E")) {
                        format = "dd.MM.yyyy hh:mm";
                    }
                    DateTimeFormatter.ofPattern(format).formatTo((TemporalAccessor)((Object)lt), sb);
                }
            }
            sb.append("  ");
            sb.append(highlighter.highlight(reader, entry.line()));
            out.println(sb.toAnsi(reader.getTerminal()));
        }
        execute.editCommandsAndClose(reader);
    }

    private static int historyId(int id, int minId, int maxId) {
        int out = id;
        if (id < 0) {
            out = maxId + id + 1;
        }
        if (out < minId) {
            out = minId;
        } else if (out > maxId) {
            out = maxId;
        }
        return out;
    }

    private static int retrieveHistoryId(History history, String s) throws IllegalArgumentException {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException ex) {
            for (History.Entry entry : history) {
                if (!entry.line().startsWith(s)) continue;
                return entry.index();
            }
            throw new IllegalArgumentException("history: event not found: " + s);
        }
    }

    public static void complete(LineReader reader, PrintStream out, PrintStream err, Map<String, List<Completers.CompletionData>> completions, String[] argv) throws Options.HelpException {
        String[] usage = new String[]{"complete -  edit command specific tab-completions", "Usage: complete", "  -? --help                       Displays command help", "  -c --command=COMMAND            Command to add completion to", "  -d --description=DESCRIPTION    Description of this completions", "  -e --erase                      Erase the completions", "  -s --short-option=SHORT_OPTION  Posix-style option to complete", "  -l --long-option=LONG_OPTION    GNU-style option to complete", "  -a --argument=ARGUMENTS         A list of possible arguments", "  -n --condition=CONDITION        The completion should only be used if the", "                                  specified command has a zero exit status"};
        Options opt = Options.compile(usage).parse(argv);
        if (opt.isSet("help")) {
            throw new Options.HelpException(opt.usage());
        }
        String command = opt.get("command");
        if (opt.isSet("erase")) {
            completions.remove(command);
            return;
        }
        List cmdCompletions = completions.computeIfAbsent(command, s -> new ArrayList());
        ArrayList<String> options = null;
        if (opt.isSet("short-option")) {
            for (String op : opt.getList("short-option")) {
                if (options == null) {
                    options = new ArrayList<String>();
                }
                options.add("-" + op);
            }
        }
        if (opt.isSet("long-option")) {
            for (String op : opt.getList("long-option")) {
                if (options == null) {
                    options = new ArrayList();
                }
                options.add("--" + op);
            }
        }
        String description = opt.isSet("description") ? opt.get("description") : null;
        String argument = opt.isSet("argument") ? opt.get("argument") : null;
        String condition = opt.isSet("condition") ? opt.get("condition") : null;
        cmdCompletions.add(new Completers.CompletionData(options, description, argument, condition));
    }

    public static void widget(LineReader reader, PrintStream out, PrintStream err, Function<String, Widget> widgetCreator, String[] argv) throws Exception {
        String[] usage = new String[]{"widget -  manipulate widgets", "Usage: widget -N new-widget [function-name]", "       widget -D widget ...", "       widget -A old-widget new-widget", "       widget -U string ...", "       widget -l [options]", "  -? --help                       Displays command help", "  -A                              Create alias to widget", "  -N                              Create new widget", "  -D                              Delete widgets", "  -U                              Push characters to the stack", "  -l                              List user-defined widgets", "  -a                              With -l, list all widgets"};
        Options opt = Options.compile(usage).parse(argv);
        if (opt.isSet("help")) {
            throw new Options.HelpException(opt.usage());
        }
        int actions = (opt.isSet("N") ? 1 : 0) + (opt.isSet("D") ? 1 : 0) + (opt.isSet("U") ? 1 : 0) + (opt.isSet("l") ? 1 : 0) + (opt.isSet("A") ? 1 : 0);
        if (actions > 1) {
            err.println("widget: incompatible operation selection options");
            return;
        }
        if (opt.isSet("l")) {
            TreeSet<String> ws = new TreeSet<String>(reader.getWidgets().keySet());
            if (opt.isSet("a")) {
                HashSet<String> temp = new HashSet<String>(ws);
                Iterator iterator = temp.iterator();
                while (iterator.hasNext()) {
                    String s = (String)iterator.next();
                    ws.add(reader.getWidgets().get(s).toString());
                }
            }
            for (String s : ws) {
                if (opt.isSet("a")) {
                    out.println(s);
                    continue;
                }
                if (reader.getWidgets().get(s).toString().startsWith(".")) continue;
                out.println(s + " (" + reader.getWidgets().get(s) + ")");
            }
        } else if (opt.isSet("N")) {
            if (opt.args().size() < 1) {
                err.println("widget: not enough arguments for -N");
                return;
            }
            if (opt.args().size() > 2) {
                err.println("widget: too many arguments for -N");
                return;
            }
            String name = opt.args().get(0);
            String func = opt.args().size() == 2 ? opt.args().get(1) : name;
            reader.getWidgets().put(name, widgetCreator.apply(func));
        } else if (opt.isSet("D")) {
            for (String name : opt.args()) {
                reader.getWidgets().remove(name);
            }
        } else if (opt.isSet("A")) {
            if (opt.args().size() < 2) {
                err.println("widget: not enough arguments for -A");
                return;
            }
            if (opt.args().size() > 2) {
                err.println("widget: too many arguments for -A");
                return;
            }
            Widget org = null;
            org = opt.args().get(0).startsWith(".") ? reader.getBuiltinWidgets().get(opt.args().get(0).substring(1)) : reader.getWidgets().get(opt.args().get(0));
            if (org == null) {
                err.println("widget: no such widget `" + opt.args().get(0) + "'");
                return;
            }
            reader.getWidgets().put(opt.args().get(1), org);
        } else if (opt.isSet("U")) {
            for (String arg : opt.args()) {
                reader.runMacro(KeyMap.translate(arg));
            }
        } else if (opt.args().size() == 1) {
            reader.callWidget(opt.args().get(0));
        }
    }

    public static void keymap(LineReader reader, PrintStream out, PrintStream err, String[] argv) throws Options.HelpException {
        String[] usage = new String[]{"keymap -  manipulate keymaps", "Usage: keymap [options] -l [-L] [keymap ...]", "       keymap [options] -d", "       keymap [options] -D keymap ...", "       keymap [options] -A old-keymap new-keymap", "       keymap [options] -N new-keymap [old-keymap]", "       keymap [options] -m", "       keymap [options] -r in-string ...", "       keymap [options] -s in-string out-string ...", "       keymap [options] in-string command ...", "       keymap [options] [in-string]", "  -? --help                       Displays command help", "  -A                              Create alias to keymap", "  -D                              Delete named keymaps", "  -L                              Output in form of keymap commands", "  -M (default=main)               Specify keymap to select", "  -N                              Create new keymap", "  -R                              Interpret in-strings as ranges", "  -a                              Select vicmd keymap", "  -d                              Delete existing keymaps and reset to default state", "  -e                              Select emacs keymap and bind it to main", "  -l                              List existing keymap names", "  -p                              List bindings which have given key sequence as a a prefix", "  -r                              Unbind specified in-strings ", "  -s                              Bind each in-string to each out-string ", "  -v                              Select viins keymap and bind it to main"};
        Options opt = Options.compile(usage).parse(argv);
        if (opt.isSet("help")) {
            throw new Options.HelpException(opt.usage());
        }
        Map<String, KeyMap<Binding>> keyMaps = reader.getKeyMaps();
        int actions = (opt.isSet("N") ? 1 : 0) + (opt.isSet("d") ? 1 : 0) + (opt.isSet("D") ? 1 : 0) + (opt.isSet("l") ? 1 : 0) + (opt.isSet("r") ? 1 : 0) + (opt.isSet("s") ? 1 : 0) + (opt.isSet("A") ? 1 : 0);
        if (actions > 1) {
            err.println("keymap: incompatible operation selection options");
            return;
        }
        if (opt.isSet("l")) {
            boolean commands = opt.isSet("L");
            if (opt.args().size() > 0) {
                for (String arg : opt.args()) {
                    KeyMap<Binding> map = keyMaps.get(arg);
                    if (map == null) {
                        err.println("keymap: no such keymap: `" + arg + "'");
                        continue;
                    }
                    out.println(arg);
                }
            } else {
                keyMaps.keySet().forEach(out::println);
            }
        } else if (opt.isSet("N")) {
            if (opt.isSet("e") || opt.isSet("v") || opt.isSet("a") || opt.isSet("M")) {
                err.println("keymap: keymap can not be selected with -N");
                return;
            }
            if (opt.args().size() < 1) {
                err.println("keymap: not enough arguments for -N");
                return;
            }
            if (opt.args().size() > 2) {
                err.println("keymap: too many arguments for -N");
                return;
            }
            KeyMap<Binding> org = null;
            if (opt.args().size() == 2 && (org = keyMaps.get(opt.args().get(1))) == null) {
                err.println("keymap: no such keymap `" + opt.args().get(1) + "'");
                return;
            }
            KeyMap<Binding> map = new KeyMap<Binding>();
            if (org != null) {
                for (Map.Entry<String, Binding> bound : org.getBoundKeys().entrySet()) {
                    map.bind(bound.getValue(), (CharSequence)bound.getKey());
                }
            }
            keyMaps.put(opt.args().get(0), map);
        } else if (opt.isSet("A")) {
            if (opt.isSet("e") || opt.isSet("v") || opt.isSet("a") || opt.isSet("M")) {
                err.println("keymap: keymap can not be selected with -N");
                return;
            }
            if (opt.args().size() < 2) {
                err.println("keymap: not enough arguments for -A");
                return;
            }
            if (opt.args().size() > 2) {
                err.println("keymap: too many arguments for -A");
                return;
            }
            KeyMap<Binding> org = keyMaps.get(opt.args().get(0));
            if (org == null) {
                err.println("keymap: no such keymap `" + opt.args().get(0) + "'");
                return;
            }
            keyMaps.put(opt.args().get(1), org);
        } else if (opt.isSet("d")) {
            if (opt.isSet("e") || opt.isSet("v") || opt.isSet("a") || opt.isSet("M")) {
                err.println("keymap: keymap can not be selected with -N");
                return;
            }
            if (opt.args().size() > 0) {
                err.println("keymap: too many arguments for -d");
                return;
            }
            keyMaps.clear();
            keyMaps.putAll(reader.defaultKeyMaps());
        } else if (opt.isSet("D")) {
            if (opt.isSet("e") || opt.isSet("v") || opt.isSet("a") || opt.isSet("M")) {
                err.println("keymap: keymap can not be selected with -N");
                return;
            }
            if (opt.args().size() < 1) {
                err.println("keymap: not enough arguments for -A");
                return;
            }
            for (String name : opt.args()) {
                if (keyMaps.remove(name) != null) continue;
                err.println("keymap: no such keymap `" + name + "'");
                return;
            }
        } else if (opt.isSet("r")) {
            String keyMapName = "main";
            int sel = (opt.isSet("a") ? 1 : 0) + (opt.isSet("e") ? 1 : 0) + (opt.isSet("v") ? 1 : 0) + (opt.isSet("M") ? 1 : 0);
            if (sel > 1) {
                err.println("keymap: incompatible keymap selection options");
                return;
            }
            if (opt.isSet("a")) {
                keyMapName = "vicmd";
            } else if (opt.isSet("e")) {
                keyMapName = "emacs";
            } else if (opt.isSet("v")) {
                keyMapName = "viins";
            } else if (opt.isSet("M")) {
                if (opt.args().isEmpty()) {
                    err.println("keymap: argument expected: -M");
                    return;
                }
                keyMapName = opt.args().remove(0);
            }
            KeyMap<Binding> map = keyMaps.get(keyMapName);
            if (map == null) {
                err.println("keymap: no such keymap `" + keyMapName + "'");
                return;
            }
            boolean range = opt.isSet("R");
            boolean prefix = opt.isSet("p");
            HashSet<String> toRemove = new HashSet<String>();
            Map<String, Binding> bound = map.getBoundKeys();
            for (String arg : opt.args()) {
                if (range) {
                    Collection<String> r = KeyMap.range(opt.args().get(0));
                    if (r == null) {
                        err.println("keymap: malformed key range `" + opt.args().get(0) + "'");
                        return;
                    }
                    toRemove.addAll(r);
                    continue;
                }
                String seq = KeyMap.translate(arg);
                for (String k : bound.keySet()) {
                    if ((!prefix || !k.startsWith(seq) || k.length() <= seq.length()) && (prefix || !k.equals(seq))) continue;
                    toRemove.add(k);
                }
            }
            for (String seq : toRemove) {
                map.unbind((CharSequence)seq);
            }
            if (opt.isSet("e") || opt.isSet("v")) {
                keyMaps.put("main", map);
            }
        } else if (opt.isSet("s") || opt.args().size() > 1) {
            String keyMapName = "main";
            int sel = (opt.isSet("a") ? 1 : 0) + (opt.isSet("e") ? 1 : 0) + (opt.isSet("v") ? 1 : 0) + (opt.isSet("M") ? 1 : 0);
            if (sel > 1) {
                err.println("keymap: incompatible keymap selection options");
                return;
            }
            if (opt.isSet("a")) {
                keyMapName = "vicmd";
            } else if (opt.isSet("e")) {
                keyMapName = "emacs";
            } else if (opt.isSet("v")) {
                keyMapName = "viins";
            } else if (opt.isSet("M")) {
                if (opt.args().isEmpty()) {
                    err.println("keymap: argument expected: -M");
                    return;
                }
                keyMapName = opt.args().remove(0);
            }
            KeyMap<Binding> map = keyMaps.get(keyMapName);
            if (map == null) {
                err.println("keymap: no such keymap `" + keyMapName + "'");
                return;
            }
            boolean range = opt.isSet("R");
            if (opt.args().size() % 2 == 1) {
                err.println("keymap: even number of arguments required");
                return;
            }
            for (int i = 0; i < opt.args().size(); i += 2) {
                Binding bout;
                Binding binding = bout = opt.isSet("s") ? new Macro(KeyMap.translate(opt.args().get(i + 1))) : new Reference(opt.args().get(i + 1));
                if (range) {
                    Collection<String> r = KeyMap.range(opt.args().get(i));
                    if (r == null) {
                        err.println("keymap: malformed key range `" + opt.args().get(i) + "'");
                        return;
                    }
                    map.bind(bout, r);
                    continue;
                }
                String in = KeyMap.translate(opt.args().get(i));
                map.bind(bout, (CharSequence)in);
            }
            if (opt.isSet("e") || opt.isSet("v")) {
                keyMaps.put("main", map);
            }
        } else {
            String keyMapName = "main";
            int sel = (opt.isSet("a") ? 1 : 0) + (opt.isSet("e") ? 1 : 0) + (opt.isSet("v") ? 1 : 0) + (opt.isSet("M") ? 1 : 0);
            if (sel > 1) {
                err.println("keymap: incompatible keymap selection options");
                return;
            }
            if (opt.isSet("a")) {
                keyMapName = "vicmd";
            } else if (opt.isSet("e")) {
                keyMapName = "emacs";
            } else if (opt.isSet("v")) {
                keyMapName = "viins";
            } else if (opt.isSet("M")) {
                if (opt.args().isEmpty()) {
                    err.println("keymap: argument expected: -M");
                    return;
                }
                keyMapName = opt.args().remove(0);
            }
            KeyMap<Binding> map = keyMaps.get(keyMapName);
            if (map == null) {
                err.println("keymap: no such keymap `" + keyMapName + "'");
                return;
            }
            boolean prefix = opt.isSet("p");
            boolean commands = opt.isSet("L");
            if (prefix && opt.args().isEmpty()) {
                err.println("keymap: option -p requires a prefix string");
                return;
            }
            if (opt.args().size() > 0 || !opt.isSet("e") && !opt.isSet("v")) {
                Map<String, Binding> bound = map.getBoundKeys();
                String seq = opt.args().size() > 0 ? KeyMap.translate(opt.args().get(0)) : null;
                Map.Entry<String, Binding> begin = null;
                String last = null;
                Iterator<Map.Entry<String, Binding>> iterator = bound.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, Binding> entry = iterator.next();
                    String key = entry.getKey();
                    if (seq != null && (!prefix || !key.startsWith(seq) || key.equals(seq)) && (prefix || !key.equals(seq))) continue;
                    if (begin != null || !iterator.hasNext()) {
                        String n = (last.length() > 1 ? last.substring(0, last.length() - 1) : "") + (char)(last.charAt(last.length() - 1) + '\u0001');
                        if (key.equals(n) && entry.getValue().equals(begin.getValue())) {
                            last = key;
                            continue;
                        }
                        StringBuilder sb = new StringBuilder();
                        if (commands) {
                            sb.append("keymap -M ");
                            sb.append(keyMapName);
                            sb.append(" ");
                        }
                        if (begin.getKey().equals(last)) {
                            sb.append(KeyMap.display(last));
                            sb.append(" ");
                            Commands.displayValue(sb, begin.getValue());
                            out.println(sb.toString());
                        } else {
                            if (commands) {
                                sb.append("-R ");
                            }
                            sb.append(KeyMap.display(begin.getKey()));
                            sb.append("-");
                            sb.append(KeyMap.display(last));
                            sb.append(" ");
                            Commands.displayValue(sb, begin.getValue());
                            out.println(sb.toString());
                        }
                        begin = entry;
                        last = key;
                        continue;
                    }
                    begin = entry;
                    last = key;
                }
            }
            if (opt.isSet("e") || opt.isSet("v")) {
                keyMaps.put("main", map);
            }
        }
    }

    public static void setopt(LineReader reader, PrintStream out, PrintStream err, String[] argv) throws Options.HelpException {
        String[] usage = new String[]{"setopt -  set options", "Usage: setopt [-m] option ...", "       setopt", "  -? --help                       Displays command help", "  -m                              Use pattern matching"};
        Options opt = Options.compile(usage).parse(argv);
        if (opt.isSet("help")) {
            throw new Options.HelpException(opt.usage());
        }
        if (opt.args().isEmpty()) {
            for (LineReader.Option option : LineReader.Option.values()) {
                if (reader.isSet(option) == option.isDef()) continue;
                out.println((option.isDef() ? "no-" : "") + option.toString().toLowerCase().replace('_', '-'));
            }
        } else {
            boolean match = opt.isSet("m");
            Commands.doSetOpts(reader, out, err, opt.args(), match, true);
        }
    }

    public static void unsetopt(LineReader reader, PrintStream out, PrintStream err, String[] argv) throws Options.HelpException {
        String[] usage = new String[]{"unsetopt -  unset options", "Usage: unsetopt [-m] option ...", "       unsetopt", "  -? --help                       Displays command help", "  -m                              Use pattern matching"};
        Options opt = Options.compile(usage).parse(argv);
        if (opt.isSet("help")) {
            throw new Options.HelpException(opt.usage());
        }
        if (opt.args().isEmpty()) {
            for (LineReader.Option option : LineReader.Option.values()) {
                if (reader.isSet(option) != option.isDef()) continue;
                out.println((option.isDef() ? "no-" : "") + option.toString().toLowerCase().replace('_', '-'));
            }
        } else {
            boolean match = opt.isSet("m");
            Commands.doSetOpts(reader, out, err, opt.args(), match, false);
        }
    }

    private static void doSetOpts(LineReader reader, PrintStream out, PrintStream err, List<String> options, boolean match, boolean set) {
        for (String name : options) {
            String tname = name.toLowerCase().replaceAll("[-_]", "");
            if (match) {
                tname = tname.replaceAll("\\*", "[a-z]*");
                tname = tname.replaceAll("\\?", "[a-z]");
            }
            boolean found = false;
            for (LineReader.Option option : LineReader.Option.values()) {
                String optName = option.name().toLowerCase().replaceAll("[-_]", "");
                if (match ? optName.matches(tname) : optName.equals(tname)) {
                    if (set) {
                        reader.setOpt(option);
                    } else {
                        reader.unsetOpt(option);
                    }
                    found = true;
                    if (match) continue;
                    break;
                }
                if (!(match ? ("no" + optName).matches(tname) : ("no" + optName).equals(tname))) continue;
                if (set) {
                    reader.unsetOpt(option);
                } else {
                    reader.setOpt(option);
                }
                if (match) break;
                found = true;
                break;
            }
            if (found) continue;
            err.println("No matching option: " + name);
        }
    }

    private static void displayValue(StringBuilder sb, Object value) {
        if (value == null) {
            sb.append("undefined-key");
        } else if (value instanceof Macro) {
            sb.append(KeyMap.display(((Macro)value).getSequence()));
        } else if (value instanceof Reference) {
            sb.append(((Reference)value).name());
        } else {
            sb.append(value.toString());
        }
    }

    public static void setvar(LineReader lineReader, PrintStream out, PrintStream err, String[] argv) throws Options.HelpException {
        String[] usage = new String[]{"setvar -  set lineReader variable value", "Usage: setvar [variable] [value]", "  -? --help                    Show help"};
        Options opt = Options.compile(usage).parse(argv);
        if (opt.isSet("help")) {
            throw new Options.HelpException(opt.usage());
        }
        if (opt.args().isEmpty()) {
            for (Map.Entry<String, Object> entry : lineReader.getVariables().entrySet()) {
                out.println(entry.getKey() + ": " + entry.getValue());
            }
        } else if (opt.args().size() == 1) {
            out.println(lineReader.getVariable(opt.args().get(0)));
        } else {
            lineReader.setVariable(opt.args().get(0), opt.args().get(1));
        }
    }

    private static class ReExecute {
        private final boolean execute;
        private final boolean edit;
        private String oldParam;
        private String newParam;
        private FileWriter cmdWriter;
        private File cmdFile;
        private int argId = 0;

        public ReExecute(History history, Options opt) throws IOException {
            this.execute = opt.isSet("e") || opt.isSet("s");
            this.edit = opt.isSet("e");
            if (this.execute) {
                String[] s;
                Iterator<History.Entry> iter = history.reverseIterator(history.last());
                if (iter.hasNext()) {
                    iter.next();
                    iter.remove();
                }
                if (this.edit) {
                    this.cmdFile = File.createTempFile("jline-history-", null);
                    this.cmdWriter = new FileWriter(this.cmdFile);
                } else if (opt.args().size() > 0 && (s = opt.args().get(this.argId).split("=")).length == 2) {
                    ++this.argId;
                    this.oldParam = s[0];
                    this.newParam = s[1];
                }
            }
        }

        public int getArgId() {
            return this.argId;
        }

        public boolean isEdit() {
            return this.edit;
        }

        public boolean isExecute() {
            return this.execute;
        }

        public void addCommandInFile(String command) throws IOException {
            this.cmdWriter.write(command + "\n");
        }

        public void addCommandInBuffer(LineReader reader, String command) {
            reader.addCommandsInBuffer(Arrays.asList(this.replaceParam(command)));
        }

        private String replaceParam(String command) {
            String out = command;
            if (this.oldParam != null && this.newParam != null) {
                out = command.replaceAll(this.oldParam, this.newParam);
            }
            return out;
        }

        public void editCommandsAndClose(LineReader reader) throws Exception {
            if (this.edit) {
                this.cmdWriter.close();
                try {
                    reader.editAndAddInBuffer(this.cmdFile);
                }
                finally {
                    this.cmdFile.delete();
                }
            }
        }
    }
}

