/*
 * Decompiled with CFR 0.152.
 */
package scalapb.textformat;

import com.google.protobuf.ByteString;
import java.io.Serializable;
import java.math.BigInteger;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scalapb.TextFormatError;
import scalapb.textformat.Constants$;
import scalapb.textformat.TextFormatUtils;
import scalapb.textformat.TextFormatUtils$Default$;
import scalapb.textformat.TextFormatUtils$EscapeMode$;
import scalapb.textformat.TextFormatUtils$Hex0$;
import scalapb.textformat.TextFormatUtils$JavaConversions$;

public final class TextFormatUtils$ {
    public static final TextFormatUtils$ MODULE$ = new TextFormatUtils$();
    private static final String HEXDIGIT = "0123456789abcdefABCDEF";

    private String HEXDIGIT() {
        return HEXDIGIT;
    }

    public boolean isHexDigit(char c) {
        return StringOps$.MODULE$.contains$extension(Predef$.MODULE$.augmentString(this.HEXDIGIT()), c);
    }

    private int digitValue(byte c) {
        return 48 <= c && c <= 57 ? c - 48 : (97 <= c && c <= 122 ? c - 97 + 10 : c - 65 + 10);
    }

    public String escapeBytes(ByteString bytes) {
        scala.collection.mutable.StringBuilder sb = new scala.collection.mutable.StringBuilder();
        TextFormatUtils$JavaConversions$.MODULE$.foreach$extension(this.JavaConversions(bytes), (Function1 & Serializable)x0$1 -> {
            scala.collection.mutable.StringBuilder stringBuilder;
            Byte by = x0$1;
            Byte by2 = Constants$.MODULE$.CH_SLASH_A();
            Byte by3 = by;
            if (!(by2 != null ? !((Object)by2).equals(by3) : by3 != null)) {
                stringBuilder = sb.append("\\a");
            } else {
                Byte by4 = Constants$.MODULE$.CH_SLASH_B();
                Byte by5 = by;
                if (!(by4 != null ? !((Object)by4).equals(by5) : by5 != null)) {
                    stringBuilder = sb.append("\\b");
                } else {
                    Byte by6 = Constants$.MODULE$.CH_SLASH_F();
                    Byte by7 = by;
                    if (!(by6 != null ? !((Object)by6).equals(by7) : by7 != null)) {
                        stringBuilder = sb.append("\\f");
                    } else {
                        Byte by8 = Constants$.MODULE$.CH_SLASH_N();
                        Byte by9 = by;
                        if (!(by8 != null ? !((Object)by8).equals(by9) : by9 != null)) {
                            stringBuilder = sb.append("\\n");
                        } else {
                            Byte by10 = Constants$.MODULE$.CH_SLASH_R();
                            Byte by11 = by;
                            if (!(by10 != null ? !((Object)by10).equals(by11) : by11 != null)) {
                                stringBuilder = sb.append("\\r");
                            } else {
                                Byte by12 = Constants$.MODULE$.CH_SLASH_T();
                                Byte by13 = by;
                                if (!(by12 != null ? !((Object)by12).equals(by13) : by13 != null)) {
                                    stringBuilder = sb.append("\\t");
                                } else {
                                    Byte by14 = Constants$.MODULE$.CH_SLASH_V();
                                    Byte by15 = by;
                                    if (!(by14 != null ? !((Object)by14).equals(by15) : by15 != null)) {
                                        stringBuilder = sb.append("\\v");
                                    } else {
                                        Byte by16 = Constants$.MODULE$.CH_SLASH();
                                        Byte by17 = by;
                                        if (!(by16 != null ? !((Object)by16).equals(by17) : by17 != null)) {
                                            stringBuilder = sb.append("\\\\");
                                        } else {
                                            Byte by18 = Constants$.MODULE$.CH_SQ();
                                            Byte by19 = by;
                                            if (!(by18 != null ? !((Object)by18).equals(by19) : by19 != null)) {
                                                stringBuilder = sb.append("\\'");
                                            } else {
                                                Byte by20 = Constants$.MODULE$.CH_DQ();
                                                Byte by21 = by;
                                                if (!(by20 != null ? !((Object)by20).equals(by21) : by21 != null)) {
                                                    stringBuilder = sb.append("\\\"");
                                                } else if (Predef$.MODULE$.Byte2byte(by) >= 32) {
                                                    stringBuilder = sb.append((char)Predef$.MODULE$.Byte2byte(by));
                                                } else {
                                                    sb.append('\\');
                                                    sb.append((char)(48 + (Predef$.MODULE$.Byte2byte(by) >>> 6 & 3)));
                                                    sb.append((char)(48 + (Predef$.MODULE$.Byte2byte(by) >>> 3 & 7)));
                                                    stringBuilder = sb.append((char)(48 + (Predef$.MODULE$.Byte2byte(by) & 7)));
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            return stringBuilder;
        });
        return sb.result();
    }

    public Iterable<Byte> JavaConversions(Iterable<Byte> iter) {
        return iter;
    }

    public Either<TextFormatError, ByteString> unescapeBytes(String charString) {
        Left left;
        TextFormatUtils.ByteParsingState endState;
        ByteString input = ByteString.copyFromUtf8(charString);
        ArrayBuilder result = ArrayBuilder$.MODULE$.make((ClassTag)ClassTag$.MODULE$.Byte());
        result.sizeHint(input.size());
        TextFormatUtils.ByteParsingState byteParsingState = endState = (TextFormatUtils.ByteParsingState)TextFormatUtils$JavaConversions$.MODULE$.foldLeft$extension(this.JavaConversions(input), TextFormatUtils$Default$.MODULE$, (Function2 & Serializable)(state, b) -> {
            int n;
            TextFormatUtils.ByteParsingState byteParsingState;
            TextFormatUtils.ByteParsingState byteParsingState2;
            void var3_29;
            TextFormatUtils.ByteParsingState e;
            Tuple2 tuple2 = new Tuple2(state, b);
            if (tuple2 != null && (e = (TextFormatUtils.ByteParsingState)tuple2._1()) instanceof TextFormatUtils.Error) {
                String string = e == null ? null : ((TextFormatUtils.Error)e).s();
                TextFormatUtils.Error error = new TextFormatUtils.Error(string);
                return var3_29;
            }
            if (tuple2 != null) {
                TextFormatUtils.ByteParsingState byteParsingState3 = (TextFormatUtils.ByteParsingState)tuple2._1();
                Byte b2 = (Byte)tuple2._2();
                if (TextFormatUtils$Default$.MODULE$.equals(byteParsingState3)) {
                    TextFormatUtils.ByteParsingState byteParsingState4 = (TextFormatUtils.ByteParsingState)TextFormatUtils$.defaultHandle$1(Predef$.MODULE$.Byte2byte(b2), result);
                    return var3_29;
                }
            }
            if (tuple2 != null) {
                TextFormatUtils.ByteParsingState byteParsingState5 = (TextFormatUtils.ByteParsingState)tuple2._1();
                Byte b3 = (Byte)tuple2._2();
                if (TextFormatUtils$EscapeMode$.MODULE$.equals(byteParsingState5) && Predef$.MODULE$.Byte2byte(b3) >= 48 && Predef$.MODULE$.Byte2byte(b3) <= 55) {
                    TextFormatUtils.Octal1 octal1 = new TextFormatUtils.Octal1(MODULE$.digitValue(Predef$.MODULE$.Byte2byte(b3)));
                    return var3_29;
                }
            }
            if (tuple2 != null) {
                TextFormatUtils.ByteParsingState byteParsingState6 = (TextFormatUtils.ByteParsingState)tuple2._1();
                Byte by = (Byte)tuple2._2();
                if (TextFormatUtils$EscapeMode$.MODULE$.equals(byteParsingState6)) {
                    Byte by2 = Constants$.MODULE$.CH_A();
                    Byte by3 = by;
                    if (!(by2 != null ? !((Object)by2).equals(by3) : by3 != null)) {
                        result.$plus$eq((Object)BoxesRunTime.boxToByte((byte)7));
                        TextFormatUtils$Default$ textFormatUtils$Default$ = TextFormatUtils$Default$.MODULE$;
                        return var3_29;
                    }
                }
            }
            if (tuple2 != null) {
                TextFormatUtils.ByteParsingState byteParsingState7 = (TextFormatUtils.ByteParsingState)tuple2._1();
                Byte by = (Byte)tuple2._2();
                if (TextFormatUtils$EscapeMode$.MODULE$.equals(byteParsingState7)) {
                    Byte by4 = Constants$.MODULE$.CH_B();
                    Byte by5 = by;
                    if (!(by4 != null ? !((Object)by4).equals(by5) : by5 != null)) {
                        result.$plus$eq((Object)BoxesRunTime.boxToByte((byte)8));
                        TextFormatUtils$Default$ textFormatUtils$Default$ = TextFormatUtils$Default$.MODULE$;
                        return var3_29;
                    }
                }
            }
            if (tuple2 != null) {
                TextFormatUtils.ByteParsingState byteParsingState8 = (TextFormatUtils.ByteParsingState)tuple2._1();
                Byte by = (Byte)tuple2._2();
                if (TextFormatUtils$EscapeMode$.MODULE$.equals(byteParsingState8)) {
                    Byte by6 = Constants$.MODULE$.CH_F();
                    Byte by7 = by;
                    if (!(by6 != null ? !((Object)by6).equals(by7) : by7 != null)) {
                        result.$plus$eq((Object)BoxesRunTime.boxToByte((byte)12));
                        TextFormatUtils$Default$ textFormatUtils$Default$ = TextFormatUtils$Default$.MODULE$;
                        return var3_29;
                    }
                }
            }
            if (tuple2 != null) {
                TextFormatUtils.ByteParsingState byteParsingState9 = (TextFormatUtils.ByteParsingState)tuple2._1();
                Byte by = (Byte)tuple2._2();
                if (TextFormatUtils$EscapeMode$.MODULE$.equals(byteParsingState9)) {
                    Byte by8 = Constants$.MODULE$.CH_N();
                    Byte by9 = by;
                    if (!(by8 != null ? !((Object)by8).equals(by9) : by9 != null)) {
                        result.$plus$eq((Object)BoxesRunTime.boxToByte((byte)10));
                        TextFormatUtils$Default$ textFormatUtils$Default$ = TextFormatUtils$Default$.MODULE$;
                        return var3_29;
                    }
                }
            }
            if (tuple2 != null) {
                TextFormatUtils.ByteParsingState byteParsingState10 = (TextFormatUtils.ByteParsingState)tuple2._1();
                Byte by = (Byte)tuple2._2();
                if (TextFormatUtils$EscapeMode$.MODULE$.equals(byteParsingState10)) {
                    Byte by10 = Constants$.MODULE$.CH_R();
                    Byte by11 = by;
                    if (!(by10 != null ? !((Object)by10).equals(by11) : by11 != null)) {
                        result.$plus$eq((Object)BoxesRunTime.boxToByte((byte)13));
                        TextFormatUtils$Default$ textFormatUtils$Default$ = TextFormatUtils$Default$.MODULE$;
                        return var3_29;
                    }
                }
            }
            if (tuple2 != null) {
                TextFormatUtils.ByteParsingState byteParsingState11 = (TextFormatUtils.ByteParsingState)tuple2._1();
                Byte by = (Byte)tuple2._2();
                if (TextFormatUtils$EscapeMode$.MODULE$.equals(byteParsingState11)) {
                    Byte by12 = Constants$.MODULE$.CH_T();
                    Byte by13 = by;
                    if (!(by12 != null ? !((Object)by12).equals(by13) : by13 != null)) {
                        result.$plus$eq((Object)BoxesRunTime.boxToByte((byte)9));
                        TextFormatUtils$Default$ textFormatUtils$Default$ = TextFormatUtils$Default$.MODULE$;
                        return var3_29;
                    }
                }
            }
            if (tuple2 != null) {
                TextFormatUtils.ByteParsingState byteParsingState12 = (TextFormatUtils.ByteParsingState)tuple2._1();
                Byte by = (Byte)tuple2._2();
                if (TextFormatUtils$EscapeMode$.MODULE$.equals(byteParsingState12)) {
                    Byte by14 = Constants$.MODULE$.CH_V();
                    Byte by15 = by;
                    if (!(by14 != null ? !((Object)by14).equals(by15) : by15 != null)) {
                        result.$plus$eq((Object)BoxesRunTime.boxToByte((byte)11));
                        TextFormatUtils$Default$ textFormatUtils$Default$ = TextFormatUtils$Default$.MODULE$;
                        return var3_29;
                    }
                }
            }
            if (tuple2 != null) {
                TextFormatUtils.ByteParsingState byteParsingState13 = (TextFormatUtils.ByteParsingState)tuple2._1();
                Byte by = (Byte)tuple2._2();
                if (TextFormatUtils$EscapeMode$.MODULE$.equals(byteParsingState13)) {
                    Byte by16 = Constants$.MODULE$.CH_SLASH();
                    Byte by17 = by;
                    if (!(by16 != null ? !((Object)by16).equals(by17) : by17 != null)) {
                        result.$plus$eq((Object)BoxesRunTime.boxToByte((byte)92));
                        TextFormatUtils$Default$ textFormatUtils$Default$ = TextFormatUtils$Default$.MODULE$;
                        return var3_29;
                    }
                }
            }
            if (tuple2 != null) {
                TextFormatUtils.ByteParsingState byteParsingState14 = (TextFormatUtils.ByteParsingState)tuple2._1();
                Byte by = (Byte)tuple2._2();
                if (TextFormatUtils$EscapeMode$.MODULE$.equals(byteParsingState14)) {
                    Byte by18 = Constants$.MODULE$.CH_SQ();
                    Byte by19 = by;
                    if (!(by18 != null ? !((Object)by18).equals(by19) : by19 != null)) {
                        result.$plus$eq((Object)BoxesRunTime.boxToByte((byte)39));
                        TextFormatUtils$Default$ textFormatUtils$Default$ = TextFormatUtils$Default$.MODULE$;
                        return var3_29;
                    }
                }
            }
            if (tuple2 != null) {
                TextFormatUtils.ByteParsingState byteParsingState15 = (TextFormatUtils.ByteParsingState)tuple2._1();
                Byte by = (Byte)tuple2._2();
                if (TextFormatUtils$EscapeMode$.MODULE$.equals(byteParsingState15)) {
                    Byte by20 = Constants$.MODULE$.CH_DQ();
                    Byte by21 = by;
                    if (!(by20 != null ? !((Object)by20).equals(by21) : by21 != null)) {
                        result.$plus$eq((Object)BoxesRunTime.boxToByte((byte)34));
                        TextFormatUtils$Default$ textFormatUtils$Default$ = TextFormatUtils$Default$.MODULE$;
                        return var3_29;
                    }
                }
            }
            if (tuple2 != null) {
                TextFormatUtils.ByteParsingState byteParsingState16 = (TextFormatUtils.ByteParsingState)tuple2._1();
                Byte by = (Byte)tuple2._2();
                if (TextFormatUtils$EscapeMode$.MODULE$.equals(byteParsingState16)) {
                    Byte by22 = Constants$.MODULE$.CH_X();
                    Byte by23 = by;
                    if (!(by22 != null ? !((Object)by22).equals(by23) : by23 != null)) {
                        TextFormatUtils$Hex0$ textFormatUtils$Hex0$ = TextFormatUtils$Hex0$.MODULE$;
                        return var3_29;
                    }
                }
            }
            if (tuple2 != null && TextFormatUtils$EscapeMode$.MODULE$.equals(byteParsingState2 = (TextFormatUtils.ByteParsingState)tuple2._1())) {
                TextFormatUtils.Error error = new TextFormatUtils.Error(new StringBuilder(25).append("Invalid escape sequence: ").append((char)Predef$.MODULE$.Byte2byte(b)).toString());
                return var3_29;
            }
            if (tuple2 != null) {
                TextFormatUtils.ByteParsingState byteParsingState17 = (TextFormatUtils.ByteParsingState)tuple2._1();
                Byte b4 = (Byte)tuple2._2();
                if (byteParsingState17 instanceof TextFormatUtils.Octal1) {
                    int n2;
                    int i = n2 = ((TextFormatUtils.Octal1)byteParsingState17).b();
                    if (Predef$.MODULE$.Byte2byte(b4) >= 48 && Predef$.MODULE$.Byte2byte(b4) <= 55) {
                        TextFormatUtils.Octal2 octal2 = new TextFormatUtils.Octal2(i * 8 + MODULE$.digitValue(Predef$.MODULE$.Byte2byte(b4)));
                        return var3_29;
                    }
                }
            }
            if (tuple2 != null) {
                TextFormatUtils.ByteParsingState byteParsingState18 = (TextFormatUtils.ByteParsingState)tuple2._1();
                Byte b5 = (Byte)tuple2._2();
                if (byteParsingState18 instanceof TextFormatUtils.Octal1) {
                    int n3;
                    int i = n3 = ((TextFormatUtils.Octal1)byteParsingState18).b();
                    result.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)i)));
                    TextFormatUtils.ByteParsingState byteParsingState19 = (TextFormatUtils.ByteParsingState)TextFormatUtils$.defaultHandle$1(Predef$.MODULE$.Byte2byte(b5), result);
                    return var3_29;
                }
            }
            if (tuple2 != null) {
                TextFormatUtils.ByteParsingState byteParsingState20 = (TextFormatUtils.ByteParsingState)tuple2._1();
                Byte b6 = (Byte)tuple2._2();
                if (byteParsingState20 instanceof TextFormatUtils.Octal2) {
                    int n4;
                    int i = n4 = ((TextFormatUtils.Octal2)byteParsingState20).b();
                    if (Predef$.MODULE$.Byte2byte(b6) >= 48 && Predef$.MODULE$.Byte2byte(b6) <= 55) {
                        result.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)(i * 8 + MODULE$.digitValue(Predef$.MODULE$.Byte2byte(b6))))));
                        TextFormatUtils$Default$ textFormatUtils$Default$ = TextFormatUtils$Default$.MODULE$;
                        return var3_29;
                    }
                }
            }
            if (tuple2 != null) {
                TextFormatUtils.ByteParsingState byteParsingState21 = (TextFormatUtils.ByteParsingState)tuple2._1();
                Byte b7 = (Byte)tuple2._2();
                if (byteParsingState21 instanceof TextFormatUtils.Octal2) {
                    int n5;
                    int i = n5 = ((TextFormatUtils.Octal2)byteParsingState21).b();
                    result.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)i)));
                    TextFormatUtils.ByteParsingState byteParsingState22 = (TextFormatUtils.ByteParsingState)TextFormatUtils$.defaultHandle$1(Predef$.MODULE$.Byte2byte(b7), result);
                    return var3_29;
                }
            }
            if (tuple2 != null) {
                TextFormatUtils.ByteParsingState byteParsingState23 = (TextFormatUtils.ByteParsingState)tuple2._1();
                Byte b8 = (Byte)tuple2._2();
                if (TextFormatUtils$Hex0$.MODULE$.equals(byteParsingState23) && MODULE$.isHexDigit((char)Predef$.MODULE$.Byte2byte(b8))) {
                    TextFormatUtils.Hex1 hex1 = new TextFormatUtils.Hex1(MODULE$.digitValue(Predef$.MODULE$.Byte2byte(b8)));
                    return var3_29;
                }
            }
            if (tuple2 != null && TextFormatUtils$Hex0$.MODULE$.equals(byteParsingState = (TextFormatUtils.ByteParsingState)tuple2._1())) {
                TextFormatUtils.Error error = new TextFormatUtils.Error("'\\x' with no digits");
                return var3_29;
            }
            if (tuple2 != null) {
                TextFormatUtils.ByteParsingState byteParsingState24 = (TextFormatUtils.ByteParsingState)tuple2._1();
                Byte b9 = (Byte)tuple2._2();
                if (byteParsingState24 instanceof TextFormatUtils.Hex1) {
                    int n6;
                    int i = n6 = ((TextFormatUtils.Hex1)byteParsingState24).b();
                    if (MODULE$.isHexDigit((char)Predef$.MODULE$.Byte2byte(b9))) {
                        result.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)(16 * i + MODULE$.digitValue(Predef$.MODULE$.Byte2byte(b9))))));
                        TextFormatUtils$Default$ textFormatUtils$Default$ = TextFormatUtils$Default$.MODULE$;
                        return var3_29;
                    }
                }
            }
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            TextFormatUtils.ByteParsingState byteParsingState25 = (TextFormatUtils.ByteParsingState)tuple2._1();
            Byte b10 = (Byte)tuple2._2();
            if (!(byteParsingState25 instanceof TextFormatUtils.Hex1)) throw new MatchError((Object)tuple2);
            int i = n = ((TextFormatUtils.Hex1)byteParsingState25).b();
            result.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)i)));
            TextFormatUtils.ByteParsingState byteParsingState26 = (TextFormatUtils.ByteParsingState)TextFormatUtils$.defaultHandle$1(Predef$.MODULE$.Byte2byte(b10), result);
            return var3_29;
        });
        if (byteParsingState instanceof TextFormatUtils.Error) {
            String string;
            String e = string = byteParsingState == null ? null : ((TextFormatUtils.Error)byteParsingState).s();
            left = package$.MODULE$.Left().apply((Object)new TextFormatError(e));
        } else if (TextFormatUtils$Hex0$.MODULE$.equals(byteParsingState)) {
            left = package$.MODULE$.Left().apply((Object)new TextFormatError("'\\x' with no digits"));
        } else if (TextFormatUtils$EscapeMode$.MODULE$.equals(byteParsingState)) {
            left = package$.MODULE$.Left().apply((Object)new TextFormatError("Invalid escape sequence '\\' at end of string."));
        } else if (byteParsingState instanceof TextFormatUtils.Hex1) {
            int n;
            int i = n = ((TextFormatUtils.Hex1)byteParsingState).b();
            result.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)i)));
            left = package$.MODULE$.Right().apply((Object)ByteString.copyFrom((byte[])result.result()));
        } else if (byteParsingState instanceof TextFormatUtils.Octal1) {
            int n;
            int i = n = ((TextFormatUtils.Octal1)byteParsingState).b();
            result.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)i)));
            left = package$.MODULE$.Right().apply((Object)ByteString.copyFrom((byte[])result.result()));
        } else if (byteParsingState instanceof TextFormatUtils.Octal2) {
            int n;
            int i = n = ((TextFormatUtils.Octal2)byteParsingState).b();
            result.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)i)));
            left = package$.MODULE$.Right().apply((Object)ByteString.copyFrom((byte[])result.result()));
        } else if (TextFormatUtils$Default$.MODULE$.equals(byteParsingState)) {
            left = package$.MODULE$.Right().apply((Object)ByteString.copyFrom((byte[])result.result()));
        } else {
            throw new MatchError((Object)byteParsingState);
        }
        return left;
    }

    public String escapeText(String input) {
        return this.escapeBytes(ByteString.copyFromUtf8(input));
    }

    public Either<TextFormatError, String> unescapeText(String input) {
        return this.unescapeBytes(input).right().map((Function1 & Serializable)x$1 -> x$1.toStringUtf8());
    }

    public String unsignedToString(int value) {
        return value >= 0 ? Integer.toString(value) : Long.toString((long)value & 0xFFFFFFFFL);
    }

    public String unsignedToString(long value) {
        return value >= 0L ? Long.toString(value) : BigInteger.valueOf(value & Long.MAX_VALUE).setBit(63).toString();
    }

    public String escapeDoubleQuotesAndBackslashes(String input) {
        return input.replace("\\", "\\\\").replace("\"", "\\\"");
    }

    private static final Object defaultHandle$1(byte b, ArrayBuilder result$1) {
        TextFormatUtils.ByteParsingState byteParsingState;
        if (BoxesRunTime.equals((Object)BoxesRunTime.boxToByte((byte)b), (Object)Constants$.MODULE$.CH_SLASH())) {
            byteParsingState = TextFormatUtils$EscapeMode$.MODULE$;
        } else {
            result$1.$plus$eq((Object)BoxesRunTime.boxToByte((byte)b));
            byteParsingState = TextFormatUtils$Default$.MODULE$;
        }
        return byteParsingState;
    }

    private TextFormatUtils$() {
    }
}

