package molecule.core.composition

import molecule.core.boilerplate.base._
import molecule.core.composition.Composite._
import molecule.core.composition.Composite_In_1._
import molecule.core.composition.Composite_In_2._
import molecule.core.composition.Composite_In_3._
import scala.language.higherKinds


/** Build composite molecule.
  * <br><br>
  * Composite molecules model entities with attributes from different namespaces that are
  * not necessarily related. Each group of attributes is modelled by a molecule and the
  * "sub-molecules" are tied together with `+` methods to form a composite molecule.
  * <br><br>
  * The attributes of the first sub-molecule are tied
  * together in a tuple of its own before being merged with the tuple of attribute values
  * of the second sub-molecule. If any of the sub-molecules are of arity-1, then no tuple is created:
  * {{{
  *   // Arity 1 + 1
  *   m(Article.name + Tag.category).get === List(
  *     ("Battle of Waterloo", "History")
  *   )
  *
  *   // Arity 1 + 2
  *   m(Article.name + Tag.category.weight).get === List(
  *     ("Battle of Waterloo", ("History", 5))
  *   )
  *
  *   // Arity 2 + 1
  *   m(Article.name.author + Tag.category).get === List(
  *     (("Battle of Waterloo", "Ben Bridge"), "History")
  *   )
  *
  *   // Arity 2 + 2
  *   m(Article.name.author + Tag.category.weight).get === List(
  *     (("Battle of Waterloo", "Ben Bridge"), ("History", 5))
  *   )
  *
  *   // Arity 3 + 2 etc...
  *   m(Article.name.author.editor + Tag.category.weight).get === List(
  *     (("Battle of Waterloo", "Ben Bridge", "Joe Moe"), ("History", 5))
  *   )
  * }}}
  */
trait CompositeInit extends NS


/** Initial `+` methods on first sub-molecule to merge with second sub-molecule into composite molecule. */
object CompositeInit {

  trait CompositeInit00 extends CompositeInit {
    final def +[x                                                               ] (nextMolecule: NS00[x                                                               ]): Composite00                                                                     = ???
    final def +[a                                                               ] (nextMolecule: NS01[a                                                               ]): Composite01[a                                                                 ] = ???
    final def +[a, b                                                            ] (nextMolecule: NS02[a, b                                                            ]): Composite01[(a, b                                                            )] = ???
    final def +[a, b, c                                                         ] (nextMolecule: NS03[a, b, c                                                         ]): Composite01[(a, b, c                                                         )] = ???
    final def +[a, b, c, d                                                      ] (nextMolecule: NS04[a, b, c, d                                                      ]): Composite01[(a, b, c, d                                                      )] = ???
    final def +[a, b, c, d, e                                                   ] (nextMolecule: NS05[a, b, c, d, e                                                   ]): Composite01[(a, b, c, d, e                                                   )] = ???
    final def +[a, b, c, d, e, f                                                ] (nextMolecule: NS06[a, b, c, d, e, f                                                ]): Composite01[(a, b, c, d, e, f                                                )] = ???
    final def +[a, b, c, d, e, f, g                                             ] (nextMolecule: NS07[a, b, c, d, e, f, g                                             ]): Composite01[(a, b, c, d, e, f, g                                             )] = ???
    final def +[a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS08[a, b, c, d, e, f, g, h                                          ]): Composite01[(a, b, c, d, e, f, g, h                                          )] = ???
    final def +[a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS09[a, b, c, d, e, f, g, h, i                                       ]): Composite01[(a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite01[(a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite01[(a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite01[(a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite01[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite01[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite01[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite01[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite01[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite01[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite01[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite01[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite01[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite01[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    final def +[I1                                                                  ] (nextMolecule: IN1_00[I1                                                                  ]): Composite_In_1_00[I1                                                                    ] = ???
    final def +[I1, a                                                               ] (nextMolecule: IN1_01[I1, a                                                               ]): Composite_In_1_01[I1, a                                                                 ] = ???
    final def +[I1, a, b                                                            ] (nextMolecule: IN1_02[I1, a, b                                                            ]): Composite_In_1_01[I1, (a, b                                                            )] = ???
    final def +[I1, a, b, c                                                         ] (nextMolecule: IN1_03[I1, a, b, c                                                         ]): Composite_In_1_01[I1, (a, b, c                                                         )] = ???
    final def +[I1, a, b, c, d                                                      ] (nextMolecule: IN1_04[I1, a, b, c, d                                                      ]): Composite_In_1_01[I1, (a, b, c, d                                                      )] = ???
    final def +[I1, a, b, c, d, e                                                   ] (nextMolecule: IN1_05[I1, a, b, c, d, e                                                   ]): Composite_In_1_01[I1, (a, b, c, d, e                                                   )] = ???
    final def +[I1, a, b, c, d, e, f                                                ] (nextMolecule: IN1_06[I1, a, b, c, d, e, f                                                ]): Composite_In_1_01[I1, (a, b, c, d, e, f                                                )] = ???
    final def +[I1, a, b, c, d, e, f, g                                             ] (nextMolecule: IN1_07[I1, a, b, c, d, e, f, g                                             ]): Composite_In_1_01[I1, (a, b, c, d, e, f, g                                             )] = ???
    final def +[I1, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN1_08[I1, a, b, c, d, e, f, g, h                                          ]): Composite_In_1_01[I1, (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN1_09[I1, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_1_01[I1, (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN1_10[I1, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_1_01[I1, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN1_11[I1, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_1_01[I1, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN1_12[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_1_01[I1, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN1_13[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_1_01[I1, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN1_14[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_1_01[I1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN1_15[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_1_01[I1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN1_16[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_1_01[I1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN1_17[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_1_01[I1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN1_18[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_1_01[I1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN1_19[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_1_01[I1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN1_20[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_1_01[I1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN1_21[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_1_01[I1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN1_22[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_1_01[I1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    final def +[I1, I2                                                                  ] (nextMolecule: IN2_00[I1, I2                                                                  ]): Composite_In_2_00[I1, I2                                                                    ] = ???
    final def +[I1, I2, a                                                               ] (nextMolecule: IN2_01[I1, I2, a                                                               ]): Composite_In_2_01[I1, I2, a                                                                 ] = ???
    final def +[I1, I2, a, b                                                            ] (nextMolecule: IN2_02[I1, I2, a, b                                                            ]): Composite_In_2_01[I1, I2, (a, b                                                            )] = ???
    final def +[I1, I2, a, b, c                                                         ] (nextMolecule: IN2_03[I1, I2, a, b, c                                                         ]): Composite_In_2_01[I1, I2, (a, b, c                                                         )] = ???
    final def +[I1, I2, a, b, c, d                                                      ] (nextMolecule: IN2_04[I1, I2, a, b, c, d                                                      ]): Composite_In_2_01[I1, I2, (a, b, c, d                                                      )] = ???
    final def +[I1, I2, a, b, c, d, e                                                   ] (nextMolecule: IN2_05[I1, I2, a, b, c, d, e                                                   ]): Composite_In_2_01[I1, I2, (a, b, c, d, e                                                   )] = ???
    final def +[I1, I2, a, b, c, d, e, f                                                ] (nextMolecule: IN2_06[I1, I2, a, b, c, d, e, f                                                ]): Composite_In_2_01[I1, I2, (a, b, c, d, e, f                                                )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g                                             ] (nextMolecule: IN2_07[I1, I2, a, b, c, d, e, f, g                                             ]): Composite_In_2_01[I1, I2, (a, b, c, d, e, f, g                                             )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN2_08[I1, I2, a, b, c, d, e, f, g, h                                          ]): Composite_In_2_01[I1, I2, (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN2_09[I1, I2, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_2_01[I1, I2, (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN2_10[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_2_01[I1, I2, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN2_11[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_2_01[I1, I2, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN2_12[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_2_01[I1, I2, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN2_13[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_2_01[I1, I2, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN2_14[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_2_01[I1, I2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN2_15[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_2_01[I1, I2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN2_16[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_2_01[I1, I2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN2_17[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_2_01[I1, I2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN2_18[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_2_01[I1, I2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN2_19[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_2_01[I1, I2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN2_20[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_2_01[I1, I2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN2_21[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_2_01[I1, I2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN2_22[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_2_01[I1, I2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    final def +[I1, I2, I3                                                                  ] (nextMolecule: IN3_00[I1, I2, I3                                                                  ]): Composite_In_3_00[I1, I2, I3                                                                    ] = ???
    final def +[I1, I2, I3, a                                                               ] (nextMolecule: IN3_01[I1, I2, I3, a                                                               ]): Composite_In_3_01[I1, I2, I3, a                                                                 ] = ???
    final def +[I1, I2, I3, a, b                                                            ] (nextMolecule: IN3_02[I1, I2, I3, a, b                                                            ]): Composite_In_3_01[I1, I2, I3, (a, b                                                            )] = ???
    final def +[I1, I2, I3, a, b, c                                                         ] (nextMolecule: IN3_03[I1, I2, I3, a, b, c                                                         ]): Composite_In_3_01[I1, I2, I3, (a, b, c                                                         )] = ???
    final def +[I1, I2, I3, a, b, c, d                                                      ] (nextMolecule: IN3_04[I1, I2, I3, a, b, c, d                                                      ]): Composite_In_3_01[I1, I2, I3, (a, b, c, d                                                      )] = ???
    final def +[I1, I2, I3, a, b, c, d, e                                                   ] (nextMolecule: IN3_05[I1, I2, I3, a, b, c, d, e                                                   ]): Composite_In_3_01[I1, I2, I3, (a, b, c, d, e                                                   )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f                                                ] (nextMolecule: IN3_06[I1, I2, I3, a, b, c, d, e, f                                                ]): Composite_In_3_01[I1, I2, I3, (a, b, c, d, e, f                                                )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g                                             ] (nextMolecule: IN3_07[I1, I2, I3, a, b, c, d, e, f, g                                             ]): Composite_In_3_01[I1, I2, I3, (a, b, c, d, e, f, g                                             )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN3_08[I1, I2, I3, a, b, c, d, e, f, g, h                                          ]): Composite_In_3_01[I1, I2, I3, (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN3_09[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_3_01[I1, I2, I3, (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN3_10[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_3_01[I1, I2, I3, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN3_11[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_3_01[I1, I2, I3, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN3_12[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_3_01[I1, I2, I3, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN3_13[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_3_01[I1, I2, I3, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN3_14[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_3_01[I1, I2, I3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN3_15[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_3_01[I1, I2, I3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN3_16[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_3_01[I1, I2, I3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN3_17[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_3_01[I1, I2, I3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN3_18[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_3_01[I1, I2, I3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN3_19[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_3_01[I1, I2, I3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN3_20[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_3_01[I1, I2, I3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN3_21[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_3_01[I1, I2, I3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN3_22[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_3_01[I1, I2, I3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait CompositeInit01[A] extends CompositeInit {
    final def +[x                                                               ] (nextMolecule: NS00[x                                                               ]): Composite01[A                                                                    ] = ???
    final def +[a                                                               ] (nextMolecule: NS01[a                                                               ]): Composite02[A, a                                                                 ] = ???
    final def +[a, b                                                            ] (nextMolecule: NS02[a, b                                                            ]): Composite02[A, (a, b                                                            )] = ???
    final def +[a, b, c                                                         ] (nextMolecule: NS03[a, b, c                                                         ]): Composite02[A, (a, b, c                                                         )] = ???
    final def +[a, b, c, d                                                      ] (nextMolecule: NS04[a, b, c, d                                                      ]): Composite02[A, (a, b, c, d                                                      )] = ???
    final def +[a, b, c, d, e                                                   ] (nextMolecule: NS05[a, b, c, d, e                                                   ]): Composite02[A, (a, b, c, d, e                                                   )] = ???
    final def +[a, b, c, d, e, f                                                ] (nextMolecule: NS06[a, b, c, d, e, f                                                ]): Composite02[A, (a, b, c, d, e, f                                                )] = ???
    final def +[a, b, c, d, e, f, g                                             ] (nextMolecule: NS07[a, b, c, d, e, f, g                                             ]): Composite02[A, (a, b, c, d, e, f, g                                             )] = ???
    final def +[a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS08[a, b, c, d, e, f, g, h                                          ]): Composite02[A, (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS09[a, b, c, d, e, f, g, h, i                                       ]): Composite02[A, (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite02[A, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite02[A, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite02[A, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite02[A, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite02[A, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite02[A, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite02[A, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite02[A, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite02[A, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite02[A, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite02[A, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite02[A, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite02[A, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    final def +[I1                                                                  ] (nextMolecule: IN1_00[I1                                                                  ]): Composite_In_1_01[I1, A                                                                    ] = ???
    final def +[I1, a                                                               ] (nextMolecule: IN1_01[I1, a                                                               ]): Composite_In_1_02[I1, A, a                                                                 ] = ???
    final def +[I1, a, b                                                            ] (nextMolecule: IN1_02[I1, a, b                                                            ]): Composite_In_1_02[I1, A, (a, b                                                            )] = ???
    final def +[I1, a, b, c                                                         ] (nextMolecule: IN1_03[I1, a, b, c                                                         ]): Composite_In_1_02[I1, A, (a, b, c                                                         )] = ???
    final def +[I1, a, b, c, d                                                      ] (nextMolecule: IN1_04[I1, a, b, c, d                                                      ]): Composite_In_1_02[I1, A, (a, b, c, d                                                      )] = ???
    final def +[I1, a, b, c, d, e                                                   ] (nextMolecule: IN1_05[I1, a, b, c, d, e                                                   ]): Composite_In_1_02[I1, A, (a, b, c, d, e                                                   )] = ???
    final def +[I1, a, b, c, d, e, f                                                ] (nextMolecule: IN1_06[I1, a, b, c, d, e, f                                                ]): Composite_In_1_02[I1, A, (a, b, c, d, e, f                                                )] = ???
    final def +[I1, a, b, c, d, e, f, g                                             ] (nextMolecule: IN1_07[I1, a, b, c, d, e, f, g                                             ]): Composite_In_1_02[I1, A, (a, b, c, d, e, f, g                                             )] = ???
    final def +[I1, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN1_08[I1, a, b, c, d, e, f, g, h                                          ]): Composite_In_1_02[I1, A, (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN1_09[I1, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_1_02[I1, A, (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN1_10[I1, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_1_02[I1, A, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN1_11[I1, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_1_02[I1, A, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN1_12[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_1_02[I1, A, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN1_13[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_1_02[I1, A, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN1_14[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_1_02[I1, A, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN1_15[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_1_02[I1, A, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN1_16[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_1_02[I1, A, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN1_17[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_1_02[I1, A, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN1_18[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_1_02[I1, A, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN1_19[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_1_02[I1, A, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN1_20[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_1_02[I1, A, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN1_21[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_1_02[I1, A, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN1_22[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_1_02[I1, A, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    final def +[I1, I2                                                                  ] (nextMolecule: IN2_00[I1, I2                                                                  ]): Composite_In_2_01[I1, I2, A                                                                    ] = ???
    final def +[I1, I2, a                                                               ] (nextMolecule: IN2_01[I1, I2, a                                                               ]): Composite_In_2_02[I1, I2, A, a                                                                 ] = ???
    final def +[I1, I2, a, b                                                            ] (nextMolecule: IN2_02[I1, I2, a, b                                                            ]): Composite_In_2_02[I1, I2, A, (a, b                                                            )] = ???
    final def +[I1, I2, a, b, c                                                         ] (nextMolecule: IN2_03[I1, I2, a, b, c                                                         ]): Composite_In_2_02[I1, I2, A, (a, b, c                                                         )] = ???
    final def +[I1, I2, a, b, c, d                                                      ] (nextMolecule: IN2_04[I1, I2, a, b, c, d                                                      ]): Composite_In_2_02[I1, I2, A, (a, b, c, d                                                      )] = ???
    final def +[I1, I2, a, b, c, d, e                                                   ] (nextMolecule: IN2_05[I1, I2, a, b, c, d, e                                                   ]): Composite_In_2_02[I1, I2, A, (a, b, c, d, e                                                   )] = ???
    final def +[I1, I2, a, b, c, d, e, f                                                ] (nextMolecule: IN2_06[I1, I2, a, b, c, d, e, f                                                ]): Composite_In_2_02[I1, I2, A, (a, b, c, d, e, f                                                )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g                                             ] (nextMolecule: IN2_07[I1, I2, a, b, c, d, e, f, g                                             ]): Composite_In_2_02[I1, I2, A, (a, b, c, d, e, f, g                                             )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN2_08[I1, I2, a, b, c, d, e, f, g, h                                          ]): Composite_In_2_02[I1, I2, A, (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN2_09[I1, I2, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_2_02[I1, I2, A, (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN2_10[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_2_02[I1, I2, A, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN2_11[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_2_02[I1, I2, A, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN2_12[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_2_02[I1, I2, A, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN2_13[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_2_02[I1, I2, A, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN2_14[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_2_02[I1, I2, A, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN2_15[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_2_02[I1, I2, A, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN2_16[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_2_02[I1, I2, A, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN2_17[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_2_02[I1, I2, A, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN2_18[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_2_02[I1, I2, A, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN2_19[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_2_02[I1, I2, A, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN2_20[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_2_02[I1, I2, A, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN2_21[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_2_02[I1, I2, A, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN2_22[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_2_02[I1, I2, A, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    final def +[I1, I2, I3                                                                  ] (nextMolecule: IN3_00[I1, I2, I3                                                                  ]): Composite_In_3_01[I1, I2, I3, A                                                                    ] = ???
    final def +[I1, I2, I3, a                                                               ] (nextMolecule: IN3_01[I1, I2, I3, a                                                               ]): Composite_In_3_02[I1, I2, I3, A, a                                                                 ] = ???
    final def +[I1, I2, I3, a, b                                                            ] (nextMolecule: IN3_02[I1, I2, I3, a, b                                                            ]): Composite_In_3_02[I1, I2, I3, A, (a, b                                                            )] = ???
    final def +[I1, I2, I3, a, b, c                                                         ] (nextMolecule: IN3_03[I1, I2, I3, a, b, c                                                         ]): Composite_In_3_02[I1, I2, I3, A, (a, b, c                                                         )] = ???
    final def +[I1, I2, I3, a, b, c, d                                                      ] (nextMolecule: IN3_04[I1, I2, I3, a, b, c, d                                                      ]): Composite_In_3_02[I1, I2, I3, A, (a, b, c, d                                                      )] = ???
    final def +[I1, I2, I3, a, b, c, d, e                                                   ] (nextMolecule: IN3_05[I1, I2, I3, a, b, c, d, e                                                   ]): Composite_In_3_02[I1, I2, I3, A, (a, b, c, d, e                                                   )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f                                                ] (nextMolecule: IN3_06[I1, I2, I3, a, b, c, d, e, f                                                ]): Composite_In_3_02[I1, I2, I3, A, (a, b, c, d, e, f                                                )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g                                             ] (nextMolecule: IN3_07[I1, I2, I3, a, b, c, d, e, f, g                                             ]): Composite_In_3_02[I1, I2, I3, A, (a, b, c, d, e, f, g                                             )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN3_08[I1, I2, I3, a, b, c, d, e, f, g, h                                          ]): Composite_In_3_02[I1, I2, I3, A, (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN3_09[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_3_02[I1, I2, I3, A, (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN3_10[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_3_02[I1, I2, I3, A, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN3_11[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_3_02[I1, I2, I3, A, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN3_12[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_3_02[I1, I2, I3, A, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN3_13[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_3_02[I1, I2, I3, A, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN3_14[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_3_02[I1, I2, I3, A, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN3_15[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_3_02[I1, I2, I3, A, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN3_16[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_3_02[I1, I2, I3, A, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN3_17[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_3_02[I1, I2, I3, A, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN3_18[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_3_02[I1, I2, I3, A, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN3_19[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_3_02[I1, I2, I3, A, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN3_20[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_3_02[I1, I2, I3, A, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN3_21[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_3_02[I1, I2, I3, A, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN3_22[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_3_02[I1, I2, I3, A, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait CompositeInit02[A, B] extends CompositeInit {
    final def +[x                                                               ] (nextMolecule: NS00[x                                                               ]): Composite01[(A, B)                                                                    ] = ???
    final def +[a                                                               ] (nextMolecule: NS01[a                                                               ]): Composite02[(A, B), a                                                                 ] = ???
    final def +[a, b                                                            ] (nextMolecule: NS02[a, b                                                            ]): Composite02[(A, B), (a, b                                                            )] = ???
    final def +[a, b, c                                                         ] (nextMolecule: NS03[a, b, c                                                         ]): Composite02[(A, B), (a, b, c                                                         )] = ???
    final def +[a, b, c, d                                                      ] (nextMolecule: NS04[a, b, c, d                                                      ]): Composite02[(A, B), (a, b, c, d                                                      )] = ???
    final def +[a, b, c, d, e                                                   ] (nextMolecule: NS05[a, b, c, d, e                                                   ]): Composite02[(A, B), (a, b, c, d, e                                                   )] = ???
    final def +[a, b, c, d, e, f                                                ] (nextMolecule: NS06[a, b, c, d, e, f                                                ]): Composite02[(A, B), (a, b, c, d, e, f                                                )] = ???
    final def +[a, b, c, d, e, f, g                                             ] (nextMolecule: NS07[a, b, c, d, e, f, g                                             ]): Composite02[(A, B), (a, b, c, d, e, f, g                                             )] = ???
    final def +[a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS08[a, b, c, d, e, f, g, h                                          ]): Composite02[(A, B), (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS09[a, b, c, d, e, f, g, h, i                                       ]): Composite02[(A, B), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite02[(A, B), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite02[(A, B), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite02[(A, B), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite02[(A, B), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite02[(A, B), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite02[(A, B), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite02[(A, B), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite02[(A, B), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite02[(A, B), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite02[(A, B), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite02[(A, B), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite02[(A, B), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite02[(A, B), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    final def +[I1                                                                  ] (nextMolecule: IN1_00[I1                                                                  ]): Composite_In_1_01[I1, (A, B)                                                                    ] = ???
    final def +[I1, a                                                               ] (nextMolecule: IN1_01[I1, a                                                               ]): Composite_In_1_02[I1, (A, B), a                                                                 ] = ???
    final def +[I1, a, b                                                            ] (nextMolecule: IN1_02[I1, a, b                                                            ]): Composite_In_1_02[I1, (A, B), (a, b                                                            )] = ???
    final def +[I1, a, b, c                                                         ] (nextMolecule: IN1_03[I1, a, b, c                                                         ]): Composite_In_1_02[I1, (A, B), (a, b, c                                                         )] = ???
    final def +[I1, a, b, c, d                                                      ] (nextMolecule: IN1_04[I1, a, b, c, d                                                      ]): Composite_In_1_02[I1, (A, B), (a, b, c, d                                                      )] = ???
    final def +[I1, a, b, c, d, e                                                   ] (nextMolecule: IN1_05[I1, a, b, c, d, e                                                   ]): Composite_In_1_02[I1, (A, B), (a, b, c, d, e                                                   )] = ???
    final def +[I1, a, b, c, d, e, f                                                ] (nextMolecule: IN1_06[I1, a, b, c, d, e, f                                                ]): Composite_In_1_02[I1, (A, B), (a, b, c, d, e, f                                                )] = ???
    final def +[I1, a, b, c, d, e, f, g                                             ] (nextMolecule: IN1_07[I1, a, b, c, d, e, f, g                                             ]): Composite_In_1_02[I1, (A, B), (a, b, c, d, e, f, g                                             )] = ???
    final def +[I1, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN1_08[I1, a, b, c, d, e, f, g, h                                          ]): Composite_In_1_02[I1, (A, B), (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN1_09[I1, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_1_02[I1, (A, B), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN1_10[I1, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_1_02[I1, (A, B), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN1_11[I1, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_1_02[I1, (A, B), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN1_12[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_1_02[I1, (A, B), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN1_13[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_1_02[I1, (A, B), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN1_14[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_1_02[I1, (A, B), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN1_15[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_1_02[I1, (A, B), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN1_16[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_1_02[I1, (A, B), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN1_17[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_1_02[I1, (A, B), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN1_18[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_1_02[I1, (A, B), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN1_19[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_1_02[I1, (A, B), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN1_20[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_1_02[I1, (A, B), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN1_21[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_1_02[I1, (A, B), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN1_22[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_1_02[I1, (A, B), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    final def +[I1, I2                                                                  ] (nextMolecule: IN2_00[I1, I2                                                                  ]): Composite_In_2_01[I1, I2, (A, B)                                                                    ] = ???
    final def +[I1, I2, a                                                               ] (nextMolecule: IN2_01[I1, I2, a                                                               ]): Composite_In_2_02[I1, I2, (A, B), a                                                                 ] = ???
    final def +[I1, I2, a, b                                                            ] (nextMolecule: IN2_02[I1, I2, a, b                                                            ]): Composite_In_2_02[I1, I2, (A, B), (a, b                                                            )] = ???
    final def +[I1, I2, a, b, c                                                         ] (nextMolecule: IN2_03[I1, I2, a, b, c                                                         ]): Composite_In_2_02[I1, I2, (A, B), (a, b, c                                                         )] = ???
    final def +[I1, I2, a, b, c, d                                                      ] (nextMolecule: IN2_04[I1, I2, a, b, c, d                                                      ]): Composite_In_2_02[I1, I2, (A, B), (a, b, c, d                                                      )] = ???
    final def +[I1, I2, a, b, c, d, e                                                   ] (nextMolecule: IN2_05[I1, I2, a, b, c, d, e                                                   ]): Composite_In_2_02[I1, I2, (A, B), (a, b, c, d, e                                                   )] = ???
    final def +[I1, I2, a, b, c, d, e, f                                                ] (nextMolecule: IN2_06[I1, I2, a, b, c, d, e, f                                                ]): Composite_In_2_02[I1, I2, (A, B), (a, b, c, d, e, f                                                )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g                                             ] (nextMolecule: IN2_07[I1, I2, a, b, c, d, e, f, g                                             ]): Composite_In_2_02[I1, I2, (A, B), (a, b, c, d, e, f, g                                             )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN2_08[I1, I2, a, b, c, d, e, f, g, h                                          ]): Composite_In_2_02[I1, I2, (A, B), (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN2_09[I1, I2, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_2_02[I1, I2, (A, B), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN2_10[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_2_02[I1, I2, (A, B), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN2_11[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_2_02[I1, I2, (A, B), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN2_12[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_2_02[I1, I2, (A, B), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN2_13[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_2_02[I1, I2, (A, B), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN2_14[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_2_02[I1, I2, (A, B), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN2_15[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_2_02[I1, I2, (A, B), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN2_16[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_2_02[I1, I2, (A, B), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN2_17[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_2_02[I1, I2, (A, B), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN2_18[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_2_02[I1, I2, (A, B), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN2_19[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_2_02[I1, I2, (A, B), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN2_20[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_2_02[I1, I2, (A, B), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN2_21[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_2_02[I1, I2, (A, B), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN2_22[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_2_02[I1, I2, (A, B), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    final def +[I1, I2, I3                                                                  ] (nextMolecule: IN3_00[I1, I2, I3                                                                  ]): Composite_In_3_01[I1, I2, I3, (A, B)                                                                    ] = ???
    final def +[I1, I2, I3, a                                                               ] (nextMolecule: IN3_01[I1, I2, I3, a                                                               ]): Composite_In_3_02[I1, I2, I3, (A, B), a                                                                 ] = ???
    final def +[I1, I2, I3, a, b                                                            ] (nextMolecule: IN3_02[I1, I2, I3, a, b                                                            ]): Composite_In_3_02[I1, I2, I3, (A, B), (a, b                                                            )] = ???
    final def +[I1, I2, I3, a, b, c                                                         ] (nextMolecule: IN3_03[I1, I2, I3, a, b, c                                                         ]): Composite_In_3_02[I1, I2, I3, (A, B), (a, b, c                                                         )] = ???
    final def +[I1, I2, I3, a, b, c, d                                                      ] (nextMolecule: IN3_04[I1, I2, I3, a, b, c, d                                                      ]): Composite_In_3_02[I1, I2, I3, (A, B), (a, b, c, d                                                      )] = ???
    final def +[I1, I2, I3, a, b, c, d, e                                                   ] (nextMolecule: IN3_05[I1, I2, I3, a, b, c, d, e                                                   ]): Composite_In_3_02[I1, I2, I3, (A, B), (a, b, c, d, e                                                   )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f                                                ] (nextMolecule: IN3_06[I1, I2, I3, a, b, c, d, e, f                                                ]): Composite_In_3_02[I1, I2, I3, (A, B), (a, b, c, d, e, f                                                )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g                                             ] (nextMolecule: IN3_07[I1, I2, I3, a, b, c, d, e, f, g                                             ]): Composite_In_3_02[I1, I2, I3, (A, B), (a, b, c, d, e, f, g                                             )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN3_08[I1, I2, I3, a, b, c, d, e, f, g, h                                          ]): Composite_In_3_02[I1, I2, I3, (A, B), (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN3_09[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_3_02[I1, I2, I3, (A, B), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN3_10[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_3_02[I1, I2, I3, (A, B), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN3_11[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_3_02[I1, I2, I3, (A, B), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN3_12[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_3_02[I1, I2, I3, (A, B), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN3_13[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_3_02[I1, I2, I3, (A, B), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN3_14[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_3_02[I1, I2, I3, (A, B), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN3_15[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_3_02[I1, I2, I3, (A, B), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN3_16[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_3_02[I1, I2, I3, (A, B), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN3_17[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_3_02[I1, I2, I3, (A, B), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN3_18[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_3_02[I1, I2, I3, (A, B), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN3_19[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_3_02[I1, I2, I3, (A, B), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN3_20[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_3_02[I1, I2, I3, (A, B), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN3_21[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_3_02[I1, I2, I3, (A, B), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN3_22[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_3_02[I1, I2, I3, (A, B), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait CompositeInit03[A, B, C] extends CompositeInit {
    final def +[x                                                               ] (nextMolecule: NS00[x                                                               ]): Composite01[(A, B, C)                                                                    ] = ???
    final def +[a                                                               ] (nextMolecule: NS01[a                                                               ]): Composite02[(A, B, C), a                                                                 ] = ???
    final def +[a, b                                                            ] (nextMolecule: NS02[a, b                                                            ]): Composite02[(A, B, C), (a, b                                                            )] = ???
    final def +[a, b, c                                                         ] (nextMolecule: NS03[a, b, c                                                         ]): Composite02[(A, B, C), (a, b, c                                                         )] = ???
    final def +[a, b, c, d                                                      ] (nextMolecule: NS04[a, b, c, d                                                      ]): Composite02[(A, B, C), (a, b, c, d                                                      )] = ???
    final def +[a, b, c, d, e                                                   ] (nextMolecule: NS05[a, b, c, d, e                                                   ]): Composite02[(A, B, C), (a, b, c, d, e                                                   )] = ???
    final def +[a, b, c, d, e, f                                                ] (nextMolecule: NS06[a, b, c, d, e, f                                                ]): Composite02[(A, B, C), (a, b, c, d, e, f                                                )] = ???
    final def +[a, b, c, d, e, f, g                                             ] (nextMolecule: NS07[a, b, c, d, e, f, g                                             ]): Composite02[(A, B, C), (a, b, c, d, e, f, g                                             )] = ???
    final def +[a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS08[a, b, c, d, e, f, g, h                                          ]): Composite02[(A, B, C), (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS09[a, b, c, d, e, f, g, h, i                                       ]): Composite02[(A, B, C), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite02[(A, B, C), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite02[(A, B, C), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite02[(A, B, C), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite02[(A, B, C), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite02[(A, B, C), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite02[(A, B, C), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite02[(A, B, C), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite02[(A, B, C), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite02[(A, B, C), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite02[(A, B, C), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite02[(A, B, C), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite02[(A, B, C), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite02[(A, B, C), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    final def +[I1                                                                  ] (nextMolecule: IN1_00[I1                                                                  ]): Composite_In_1_01[I1, (A, B, C)                                                                    ] = ???
    final def +[I1, a                                                               ] (nextMolecule: IN1_01[I1, a                                                               ]): Composite_In_1_02[I1, (A, B, C), a                                                                 ] = ???
    final def +[I1, a, b                                                            ] (nextMolecule: IN1_02[I1, a, b                                                            ]): Composite_In_1_02[I1, (A, B, C), (a, b                                                            )] = ???
    final def +[I1, a, b, c                                                         ] (nextMolecule: IN1_03[I1, a, b, c                                                         ]): Composite_In_1_02[I1, (A, B, C), (a, b, c                                                         )] = ???
    final def +[I1, a, b, c, d                                                      ] (nextMolecule: IN1_04[I1, a, b, c, d                                                      ]): Composite_In_1_02[I1, (A, B, C), (a, b, c, d                                                      )] = ???
    final def +[I1, a, b, c, d, e                                                   ] (nextMolecule: IN1_05[I1, a, b, c, d, e                                                   ]): Composite_In_1_02[I1, (A, B, C), (a, b, c, d, e                                                   )] = ???
    final def +[I1, a, b, c, d, e, f                                                ] (nextMolecule: IN1_06[I1, a, b, c, d, e, f                                                ]): Composite_In_1_02[I1, (A, B, C), (a, b, c, d, e, f                                                )] = ???
    final def +[I1, a, b, c, d, e, f, g                                             ] (nextMolecule: IN1_07[I1, a, b, c, d, e, f, g                                             ]): Composite_In_1_02[I1, (A, B, C), (a, b, c, d, e, f, g                                             )] = ???
    final def +[I1, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN1_08[I1, a, b, c, d, e, f, g, h                                          ]): Composite_In_1_02[I1, (A, B, C), (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN1_09[I1, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_1_02[I1, (A, B, C), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN1_10[I1, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_1_02[I1, (A, B, C), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN1_11[I1, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_1_02[I1, (A, B, C), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN1_12[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_1_02[I1, (A, B, C), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN1_13[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_1_02[I1, (A, B, C), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN1_14[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_1_02[I1, (A, B, C), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN1_15[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_1_02[I1, (A, B, C), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN1_16[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_1_02[I1, (A, B, C), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN1_17[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_1_02[I1, (A, B, C), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN1_18[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_1_02[I1, (A, B, C), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN1_19[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_1_02[I1, (A, B, C), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN1_20[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_1_02[I1, (A, B, C), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN1_21[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_1_02[I1, (A, B, C), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN1_22[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_1_02[I1, (A, B, C), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    final def +[I1, I2                                                                  ] (nextMolecule: IN2_00[I1, I2                                                                  ]): Composite_In_2_01[I1, I2, (A, B, C)                                                                    ] = ???
    final def +[I1, I2, a                                                               ] (nextMolecule: IN2_01[I1, I2, a                                                               ]): Composite_In_2_02[I1, I2, (A, B, C), a                                                                 ] = ???
    final def +[I1, I2, a, b                                                            ] (nextMolecule: IN2_02[I1, I2, a, b                                                            ]): Composite_In_2_02[I1, I2, (A, B, C), (a, b                                                            )] = ???
    final def +[I1, I2, a, b, c                                                         ] (nextMolecule: IN2_03[I1, I2, a, b, c                                                         ]): Composite_In_2_02[I1, I2, (A, B, C), (a, b, c                                                         )] = ???
    final def +[I1, I2, a, b, c, d                                                      ] (nextMolecule: IN2_04[I1, I2, a, b, c, d                                                      ]): Composite_In_2_02[I1, I2, (A, B, C), (a, b, c, d                                                      )] = ???
    final def +[I1, I2, a, b, c, d, e                                                   ] (nextMolecule: IN2_05[I1, I2, a, b, c, d, e                                                   ]): Composite_In_2_02[I1, I2, (A, B, C), (a, b, c, d, e                                                   )] = ???
    final def +[I1, I2, a, b, c, d, e, f                                                ] (nextMolecule: IN2_06[I1, I2, a, b, c, d, e, f                                                ]): Composite_In_2_02[I1, I2, (A, B, C), (a, b, c, d, e, f                                                )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g                                             ] (nextMolecule: IN2_07[I1, I2, a, b, c, d, e, f, g                                             ]): Composite_In_2_02[I1, I2, (A, B, C), (a, b, c, d, e, f, g                                             )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN2_08[I1, I2, a, b, c, d, e, f, g, h                                          ]): Composite_In_2_02[I1, I2, (A, B, C), (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN2_09[I1, I2, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_2_02[I1, I2, (A, B, C), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN2_10[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_2_02[I1, I2, (A, B, C), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN2_11[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_2_02[I1, I2, (A, B, C), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN2_12[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_2_02[I1, I2, (A, B, C), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN2_13[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_2_02[I1, I2, (A, B, C), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN2_14[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_2_02[I1, I2, (A, B, C), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN2_15[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_2_02[I1, I2, (A, B, C), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN2_16[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_2_02[I1, I2, (A, B, C), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN2_17[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_2_02[I1, I2, (A, B, C), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN2_18[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_2_02[I1, I2, (A, B, C), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN2_19[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_2_02[I1, I2, (A, B, C), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN2_20[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_2_02[I1, I2, (A, B, C), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN2_21[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_2_02[I1, I2, (A, B, C), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN2_22[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_2_02[I1, I2, (A, B, C), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    final def +[I1, I2, I3                                                                  ] (nextMolecule: IN3_00[I1, I2, I3                                                                  ]): Composite_In_3_01[I1, I2, I3, (A, B, C)                                                                    ] = ???
    final def +[I1, I2, I3, a                                                               ] (nextMolecule: IN3_01[I1, I2, I3, a                                                               ]): Composite_In_3_02[I1, I2, I3, (A, B, C), a                                                                 ] = ???
    final def +[I1, I2, I3, a, b                                                            ] (nextMolecule: IN3_02[I1, I2, I3, a, b                                                            ]): Composite_In_3_02[I1, I2, I3, (A, B, C), (a, b                                                            )] = ???
    final def +[I1, I2, I3, a, b, c                                                         ] (nextMolecule: IN3_03[I1, I2, I3, a, b, c                                                         ]): Composite_In_3_02[I1, I2, I3, (A, B, C), (a, b, c                                                         )] = ???
    final def +[I1, I2, I3, a, b, c, d                                                      ] (nextMolecule: IN3_04[I1, I2, I3, a, b, c, d                                                      ]): Composite_In_3_02[I1, I2, I3, (A, B, C), (a, b, c, d                                                      )] = ???
    final def +[I1, I2, I3, a, b, c, d, e                                                   ] (nextMolecule: IN3_05[I1, I2, I3, a, b, c, d, e                                                   ]): Composite_In_3_02[I1, I2, I3, (A, B, C), (a, b, c, d, e                                                   )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f                                                ] (nextMolecule: IN3_06[I1, I2, I3, a, b, c, d, e, f                                                ]): Composite_In_3_02[I1, I2, I3, (A, B, C), (a, b, c, d, e, f                                                )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g                                             ] (nextMolecule: IN3_07[I1, I2, I3, a, b, c, d, e, f, g                                             ]): Composite_In_3_02[I1, I2, I3, (A, B, C), (a, b, c, d, e, f, g                                             )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN3_08[I1, I2, I3, a, b, c, d, e, f, g, h                                          ]): Composite_In_3_02[I1, I2, I3, (A, B, C), (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN3_09[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_3_02[I1, I2, I3, (A, B, C), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN3_10[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_3_02[I1, I2, I3, (A, B, C), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN3_11[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_3_02[I1, I2, I3, (A, B, C), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN3_12[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_3_02[I1, I2, I3, (A, B, C), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN3_13[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_3_02[I1, I2, I3, (A, B, C), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN3_14[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_3_02[I1, I2, I3, (A, B, C), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN3_15[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_3_02[I1, I2, I3, (A, B, C), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN3_16[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_3_02[I1, I2, I3, (A, B, C), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN3_17[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_3_02[I1, I2, I3, (A, B, C), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN3_18[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_3_02[I1, I2, I3, (A, B, C), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN3_19[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_3_02[I1, I2, I3, (A, B, C), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN3_20[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_3_02[I1, I2, I3, (A, B, C), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN3_21[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_3_02[I1, I2, I3, (A, B, C), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN3_22[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_3_02[I1, I2, I3, (A, B, C), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait CompositeInit04[A, B, C, D] extends CompositeInit {
    final def +[x                                                               ] (nextMolecule: NS00[x                                                               ]): Composite01[(A, B, C, D)                                                                    ] = ???
    final def +[a                                                               ] (nextMolecule: NS01[a                                                               ]): Composite02[(A, B, C, D), a                                                                 ] = ???
    final def +[a, b                                                            ] (nextMolecule: NS02[a, b                                                            ]): Composite02[(A, B, C, D), (a, b                                                            )] = ???
    final def +[a, b, c                                                         ] (nextMolecule: NS03[a, b, c                                                         ]): Composite02[(A, B, C, D), (a, b, c                                                         )] = ???
    final def +[a, b, c, d                                                      ] (nextMolecule: NS04[a, b, c, d                                                      ]): Composite02[(A, B, C, D), (a, b, c, d                                                      )] = ???
    final def +[a, b, c, d, e                                                   ] (nextMolecule: NS05[a, b, c, d, e                                                   ]): Composite02[(A, B, C, D), (a, b, c, d, e                                                   )] = ???
    final def +[a, b, c, d, e, f                                                ] (nextMolecule: NS06[a, b, c, d, e, f                                                ]): Composite02[(A, B, C, D), (a, b, c, d, e, f                                                )] = ???
    final def +[a, b, c, d, e, f, g                                             ] (nextMolecule: NS07[a, b, c, d, e, f, g                                             ]): Composite02[(A, B, C, D), (a, b, c, d, e, f, g                                             )] = ???
    final def +[a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS08[a, b, c, d, e, f, g, h                                          ]): Composite02[(A, B, C, D), (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS09[a, b, c, d, e, f, g, h, i                                       ]): Composite02[(A, B, C, D), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite02[(A, B, C, D), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite02[(A, B, C, D), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite02[(A, B, C, D), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite02[(A, B, C, D), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite02[(A, B, C, D), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite02[(A, B, C, D), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite02[(A, B, C, D), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite02[(A, B, C, D), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite02[(A, B, C, D), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite02[(A, B, C, D), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite02[(A, B, C, D), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite02[(A, B, C, D), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite02[(A, B, C, D), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    final def +[I1                                                                  ] (nextMolecule: IN1_00[I1                                                                  ]): Composite_In_1_01[I1, (A, B, C, D)                                                                    ] = ???
    final def +[I1, a                                                               ] (nextMolecule: IN1_01[I1, a                                                               ]): Composite_In_1_02[I1, (A, B, C, D), a                                                                 ] = ???
    final def +[I1, a, b                                                            ] (nextMolecule: IN1_02[I1, a, b                                                            ]): Composite_In_1_02[I1, (A, B, C, D), (a, b                                                            )] = ???
    final def +[I1, a, b, c                                                         ] (nextMolecule: IN1_03[I1, a, b, c                                                         ]): Composite_In_1_02[I1, (A, B, C, D), (a, b, c                                                         )] = ???
    final def +[I1, a, b, c, d                                                      ] (nextMolecule: IN1_04[I1, a, b, c, d                                                      ]): Composite_In_1_02[I1, (A, B, C, D), (a, b, c, d                                                      )] = ???
    final def +[I1, a, b, c, d, e                                                   ] (nextMolecule: IN1_05[I1, a, b, c, d, e                                                   ]): Composite_In_1_02[I1, (A, B, C, D), (a, b, c, d, e                                                   )] = ???
    final def +[I1, a, b, c, d, e, f                                                ] (nextMolecule: IN1_06[I1, a, b, c, d, e, f                                                ]): Composite_In_1_02[I1, (A, B, C, D), (a, b, c, d, e, f                                                )] = ???
    final def +[I1, a, b, c, d, e, f, g                                             ] (nextMolecule: IN1_07[I1, a, b, c, d, e, f, g                                             ]): Composite_In_1_02[I1, (A, B, C, D), (a, b, c, d, e, f, g                                             )] = ???
    final def +[I1, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN1_08[I1, a, b, c, d, e, f, g, h                                          ]): Composite_In_1_02[I1, (A, B, C, D), (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN1_09[I1, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_1_02[I1, (A, B, C, D), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN1_10[I1, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_1_02[I1, (A, B, C, D), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN1_11[I1, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_1_02[I1, (A, B, C, D), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN1_12[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_1_02[I1, (A, B, C, D), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN1_13[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_1_02[I1, (A, B, C, D), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN1_14[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_1_02[I1, (A, B, C, D), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN1_15[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_1_02[I1, (A, B, C, D), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN1_16[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_1_02[I1, (A, B, C, D), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN1_17[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_1_02[I1, (A, B, C, D), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN1_18[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_1_02[I1, (A, B, C, D), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN1_19[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_1_02[I1, (A, B, C, D), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN1_20[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_1_02[I1, (A, B, C, D), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN1_21[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_1_02[I1, (A, B, C, D), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN1_22[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_1_02[I1, (A, B, C, D), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    final def +[I1, I2                                                                  ] (nextMolecule: IN2_00[I1, I2                                                                  ]): Composite_In_2_01[I1, I2, (A, B, C, D)                                                                    ] = ???
    final def +[I1, I2, a                                                               ] (nextMolecule: IN2_01[I1, I2, a                                                               ]): Composite_In_2_02[I1, I2, (A, B, C, D), a                                                                 ] = ???
    final def +[I1, I2, a, b                                                            ] (nextMolecule: IN2_02[I1, I2, a, b                                                            ]): Composite_In_2_02[I1, I2, (A, B, C, D), (a, b                                                            )] = ???
    final def +[I1, I2, a, b, c                                                         ] (nextMolecule: IN2_03[I1, I2, a, b, c                                                         ]): Composite_In_2_02[I1, I2, (A, B, C, D), (a, b, c                                                         )] = ???
    final def +[I1, I2, a, b, c, d                                                      ] (nextMolecule: IN2_04[I1, I2, a, b, c, d                                                      ]): Composite_In_2_02[I1, I2, (A, B, C, D), (a, b, c, d                                                      )] = ???
    final def +[I1, I2, a, b, c, d, e                                                   ] (nextMolecule: IN2_05[I1, I2, a, b, c, d, e                                                   ]): Composite_In_2_02[I1, I2, (A, B, C, D), (a, b, c, d, e                                                   )] = ???
    final def +[I1, I2, a, b, c, d, e, f                                                ] (nextMolecule: IN2_06[I1, I2, a, b, c, d, e, f                                                ]): Composite_In_2_02[I1, I2, (A, B, C, D), (a, b, c, d, e, f                                                )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g                                             ] (nextMolecule: IN2_07[I1, I2, a, b, c, d, e, f, g                                             ]): Composite_In_2_02[I1, I2, (A, B, C, D), (a, b, c, d, e, f, g                                             )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN2_08[I1, I2, a, b, c, d, e, f, g, h                                          ]): Composite_In_2_02[I1, I2, (A, B, C, D), (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN2_09[I1, I2, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_2_02[I1, I2, (A, B, C, D), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN2_10[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_2_02[I1, I2, (A, B, C, D), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN2_11[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_2_02[I1, I2, (A, B, C, D), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN2_12[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_2_02[I1, I2, (A, B, C, D), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN2_13[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_2_02[I1, I2, (A, B, C, D), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN2_14[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_2_02[I1, I2, (A, B, C, D), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN2_15[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_2_02[I1, I2, (A, B, C, D), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN2_16[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_2_02[I1, I2, (A, B, C, D), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN2_17[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_2_02[I1, I2, (A, B, C, D), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN2_18[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_2_02[I1, I2, (A, B, C, D), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN2_19[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_2_02[I1, I2, (A, B, C, D), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN2_20[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_2_02[I1, I2, (A, B, C, D), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN2_21[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_2_02[I1, I2, (A, B, C, D), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN2_22[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_2_02[I1, I2, (A, B, C, D), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    final def +[I1, I2, I3                                                                  ] (nextMolecule: IN3_00[I1, I2, I3                                                                  ]): Composite_In_3_01[I1, I2, I3, (A, B, C, D)                                                                    ] = ???
    final def +[I1, I2, I3, a                                                               ] (nextMolecule: IN3_01[I1, I2, I3, a                                                               ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D), a                                                                 ] = ???
    final def +[I1, I2, I3, a, b                                                            ] (nextMolecule: IN3_02[I1, I2, I3, a, b                                                            ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D), (a, b                                                            )] = ???
    final def +[I1, I2, I3, a, b, c                                                         ] (nextMolecule: IN3_03[I1, I2, I3, a, b, c                                                         ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D), (a, b, c                                                         )] = ???
    final def +[I1, I2, I3, a, b, c, d                                                      ] (nextMolecule: IN3_04[I1, I2, I3, a, b, c, d                                                      ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D), (a, b, c, d                                                      )] = ???
    final def +[I1, I2, I3, a, b, c, d, e                                                   ] (nextMolecule: IN3_05[I1, I2, I3, a, b, c, d, e                                                   ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D), (a, b, c, d, e                                                   )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f                                                ] (nextMolecule: IN3_06[I1, I2, I3, a, b, c, d, e, f                                                ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D), (a, b, c, d, e, f                                                )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g                                             ] (nextMolecule: IN3_07[I1, I2, I3, a, b, c, d, e, f, g                                             ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D), (a, b, c, d, e, f, g                                             )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN3_08[I1, I2, I3, a, b, c, d, e, f, g, h                                          ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D), (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN3_09[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN3_10[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN3_11[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN3_12[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN3_13[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN3_14[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN3_15[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN3_16[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN3_17[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN3_18[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN3_19[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN3_20[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN3_21[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN3_22[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_3_02[I1, I2, I3, (A, B, C, D), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait CompositeInit05[A, B, C, D, E] extends CompositeInit {
    final def +[x                                                               ] (nextMolecule: NS00[x                                                               ]): Composite01[(A, B, C, D, E)                                                                    ] = ???
    final def +[a                                                               ] (nextMolecule: NS01[a                                                               ]): Composite02[(A, B, C, D, E), a                                                                 ] = ???
    final def +[a, b                                                            ] (nextMolecule: NS02[a, b                                                            ]): Composite02[(A, B, C, D, E), (a, b                                                            )] = ???
    final def +[a, b, c                                                         ] (nextMolecule: NS03[a, b, c                                                         ]): Composite02[(A, B, C, D, E), (a, b, c                                                         )] = ???
    final def +[a, b, c, d                                                      ] (nextMolecule: NS04[a, b, c, d                                                      ]): Composite02[(A, B, C, D, E), (a, b, c, d                                                      )] = ???
    final def +[a, b, c, d, e                                                   ] (nextMolecule: NS05[a, b, c, d, e                                                   ]): Composite02[(A, B, C, D, E), (a, b, c, d, e                                                   )] = ???
    final def +[a, b, c, d, e, f                                                ] (nextMolecule: NS06[a, b, c, d, e, f                                                ]): Composite02[(A, B, C, D, E), (a, b, c, d, e, f                                                )] = ???
    final def +[a, b, c, d, e, f, g                                             ] (nextMolecule: NS07[a, b, c, d, e, f, g                                             ]): Composite02[(A, B, C, D, E), (a, b, c, d, e, f, g                                             )] = ???
    final def +[a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS08[a, b, c, d, e, f, g, h                                          ]): Composite02[(A, B, C, D, E), (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS09[a, b, c, d, e, f, g, h, i                                       ]): Composite02[(A, B, C, D, E), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite02[(A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite02[(A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite02[(A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite02[(A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite02[(A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite02[(A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite02[(A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite02[(A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite02[(A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite02[(A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite02[(A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite02[(A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite02[(A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    final def +[I1                                                                  ] (nextMolecule: IN1_00[I1                                                                  ]): Composite_In_1_01[I1, (A, B, C, D, E)                                                                    ] = ???
    final def +[I1, a                                                               ] (nextMolecule: IN1_01[I1, a                                                               ]): Composite_In_1_02[I1, (A, B, C, D, E), a                                                                 ] = ???
    final def +[I1, a, b                                                            ] (nextMolecule: IN1_02[I1, a, b                                                            ]): Composite_In_1_02[I1, (A, B, C, D, E), (a, b                                                            )] = ???
    final def +[I1, a, b, c                                                         ] (nextMolecule: IN1_03[I1, a, b, c                                                         ]): Composite_In_1_02[I1, (A, B, C, D, E), (a, b, c                                                         )] = ???
    final def +[I1, a, b, c, d                                                      ] (nextMolecule: IN1_04[I1, a, b, c, d                                                      ]): Composite_In_1_02[I1, (A, B, C, D, E), (a, b, c, d                                                      )] = ???
    final def +[I1, a, b, c, d, e                                                   ] (nextMolecule: IN1_05[I1, a, b, c, d, e                                                   ]): Composite_In_1_02[I1, (A, B, C, D, E), (a, b, c, d, e                                                   )] = ???
    final def +[I1, a, b, c, d, e, f                                                ] (nextMolecule: IN1_06[I1, a, b, c, d, e, f                                                ]): Composite_In_1_02[I1, (A, B, C, D, E), (a, b, c, d, e, f                                                )] = ???
    final def +[I1, a, b, c, d, e, f, g                                             ] (nextMolecule: IN1_07[I1, a, b, c, d, e, f, g                                             ]): Composite_In_1_02[I1, (A, B, C, D, E), (a, b, c, d, e, f, g                                             )] = ???
    final def +[I1, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN1_08[I1, a, b, c, d, e, f, g, h                                          ]): Composite_In_1_02[I1, (A, B, C, D, E), (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN1_09[I1, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_1_02[I1, (A, B, C, D, E), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN1_10[I1, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_1_02[I1, (A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN1_11[I1, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_1_02[I1, (A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN1_12[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_1_02[I1, (A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN1_13[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_1_02[I1, (A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN1_14[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_1_02[I1, (A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN1_15[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_1_02[I1, (A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN1_16[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_1_02[I1, (A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN1_17[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_1_02[I1, (A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN1_18[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_1_02[I1, (A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN1_19[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_1_02[I1, (A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN1_20[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_1_02[I1, (A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN1_21[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_1_02[I1, (A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN1_22[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_1_02[I1, (A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    final def +[I1, I2                                                                  ] (nextMolecule: IN2_00[I1, I2                                                                  ]): Composite_In_2_01[I1, I2, (A, B, C, D, E)                                                                    ] = ???
    final def +[I1, I2, a                                                               ] (nextMolecule: IN2_01[I1, I2, a                                                               ]): Composite_In_2_02[I1, I2, (A, B, C, D, E), a                                                                 ] = ???
    final def +[I1, I2, a, b                                                            ] (nextMolecule: IN2_02[I1, I2, a, b                                                            ]): Composite_In_2_02[I1, I2, (A, B, C, D, E), (a, b                                                            )] = ???
    final def +[I1, I2, a, b, c                                                         ] (nextMolecule: IN2_03[I1, I2, a, b, c                                                         ]): Composite_In_2_02[I1, I2, (A, B, C, D, E), (a, b, c                                                         )] = ???
    final def +[I1, I2, a, b, c, d                                                      ] (nextMolecule: IN2_04[I1, I2, a, b, c, d                                                      ]): Composite_In_2_02[I1, I2, (A, B, C, D, E), (a, b, c, d                                                      )] = ???
    final def +[I1, I2, a, b, c, d, e                                                   ] (nextMolecule: IN2_05[I1, I2, a, b, c, d, e                                                   ]): Composite_In_2_02[I1, I2, (A, B, C, D, E), (a, b, c, d, e                                                   )] = ???
    final def +[I1, I2, a, b, c, d, e, f                                                ] (nextMolecule: IN2_06[I1, I2, a, b, c, d, e, f                                                ]): Composite_In_2_02[I1, I2, (A, B, C, D, E), (a, b, c, d, e, f                                                )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g                                             ] (nextMolecule: IN2_07[I1, I2, a, b, c, d, e, f, g                                             ]): Composite_In_2_02[I1, I2, (A, B, C, D, E), (a, b, c, d, e, f, g                                             )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN2_08[I1, I2, a, b, c, d, e, f, g, h                                          ]): Composite_In_2_02[I1, I2, (A, B, C, D, E), (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN2_09[I1, I2, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_2_02[I1, I2, (A, B, C, D, E), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN2_10[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_2_02[I1, I2, (A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN2_11[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_2_02[I1, I2, (A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN2_12[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_2_02[I1, I2, (A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN2_13[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_2_02[I1, I2, (A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN2_14[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_2_02[I1, I2, (A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN2_15[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_2_02[I1, I2, (A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN2_16[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_2_02[I1, I2, (A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN2_17[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_2_02[I1, I2, (A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN2_18[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_2_02[I1, I2, (A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN2_19[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_2_02[I1, I2, (A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN2_20[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_2_02[I1, I2, (A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN2_21[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_2_02[I1, I2, (A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN2_22[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_2_02[I1, I2, (A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    final def +[I1, I2, I3                                                                  ] (nextMolecule: IN3_00[I1, I2, I3                                                                  ]): Composite_In_3_01[I1, I2, I3, (A, B, C, D, E)                                                                    ] = ???
    final def +[I1, I2, I3, a                                                               ] (nextMolecule: IN3_01[I1, I2, I3, a                                                               ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E), a                                                                 ] = ???
    final def +[I1, I2, I3, a, b                                                            ] (nextMolecule: IN3_02[I1, I2, I3, a, b                                                            ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E), (a, b                                                            )] = ???
    final def +[I1, I2, I3, a, b, c                                                         ] (nextMolecule: IN3_03[I1, I2, I3, a, b, c                                                         ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E), (a, b, c                                                         )] = ???
    final def +[I1, I2, I3, a, b, c, d                                                      ] (nextMolecule: IN3_04[I1, I2, I3, a, b, c, d                                                      ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E), (a, b, c, d                                                      )] = ???
    final def +[I1, I2, I3, a, b, c, d, e                                                   ] (nextMolecule: IN3_05[I1, I2, I3, a, b, c, d, e                                                   ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E), (a, b, c, d, e                                                   )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f                                                ] (nextMolecule: IN3_06[I1, I2, I3, a, b, c, d, e, f                                                ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E), (a, b, c, d, e, f                                                )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g                                             ] (nextMolecule: IN3_07[I1, I2, I3, a, b, c, d, e, f, g                                             ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E), (a, b, c, d, e, f, g                                             )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN3_08[I1, I2, I3, a, b, c, d, e, f, g, h                                          ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E), (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN3_09[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN3_10[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN3_11[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN3_12[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN3_13[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN3_14[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN3_15[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN3_16[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN3_17[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN3_18[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN3_19[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN3_20[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN3_21[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN3_22[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait CompositeInit06[A, B, C, D, E, F] extends CompositeInit {
    final def +[x                                                               ] (nextMolecule: NS00[x                                                               ]): Composite01[(A, B, C, D, E, F)                                                                    ] = ???
    final def +[a                                                               ] (nextMolecule: NS01[a                                                               ]): Composite02[(A, B, C, D, E, F), a                                                                 ] = ???
    final def +[a, b                                                            ] (nextMolecule: NS02[a, b                                                            ]): Composite02[(A, B, C, D, E, F), (a, b                                                            )] = ???
    final def +[a, b, c                                                         ] (nextMolecule: NS03[a, b, c                                                         ]): Composite02[(A, B, C, D, E, F), (a, b, c                                                         )] = ???
    final def +[a, b, c, d                                                      ] (nextMolecule: NS04[a, b, c, d                                                      ]): Composite02[(A, B, C, D, E, F), (a, b, c, d                                                      )] = ???
    final def +[a, b, c, d, e                                                   ] (nextMolecule: NS05[a, b, c, d, e                                                   ]): Composite02[(A, B, C, D, E, F), (a, b, c, d, e                                                   )] = ???
    final def +[a, b, c, d, e, f                                                ] (nextMolecule: NS06[a, b, c, d, e, f                                                ]): Composite02[(A, B, C, D, E, F), (a, b, c, d, e, f                                                )] = ???
    final def +[a, b, c, d, e, f, g                                             ] (nextMolecule: NS07[a, b, c, d, e, f, g                                             ]): Composite02[(A, B, C, D, E, F), (a, b, c, d, e, f, g                                             )] = ???
    final def +[a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS08[a, b, c, d, e, f, g, h                                          ]): Composite02[(A, B, C, D, E, F), (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS09[a, b, c, d, e, f, g, h, i                                       ]): Composite02[(A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite02[(A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite02[(A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite02[(A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite02[(A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite02[(A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite02[(A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite02[(A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite02[(A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite02[(A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite02[(A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite02[(A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite02[(A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite02[(A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    final def +[I1                                                                  ] (nextMolecule: IN1_00[I1                                                                  ]): Composite_In_1_01[I1, (A, B, C, D, E, F)                                                                    ] = ???
    final def +[I1, a                                                               ] (nextMolecule: IN1_01[I1, a                                                               ]): Composite_In_1_02[I1, (A, B, C, D, E, F), a                                                                 ] = ???
    final def +[I1, a, b                                                            ] (nextMolecule: IN1_02[I1, a, b                                                            ]): Composite_In_1_02[I1, (A, B, C, D, E, F), (a, b                                                            )] = ???
    final def +[I1, a, b, c                                                         ] (nextMolecule: IN1_03[I1, a, b, c                                                         ]): Composite_In_1_02[I1, (A, B, C, D, E, F), (a, b, c                                                         )] = ???
    final def +[I1, a, b, c, d                                                      ] (nextMolecule: IN1_04[I1, a, b, c, d                                                      ]): Composite_In_1_02[I1, (A, B, C, D, E, F), (a, b, c, d                                                      )] = ???
    final def +[I1, a, b, c, d, e                                                   ] (nextMolecule: IN1_05[I1, a, b, c, d, e                                                   ]): Composite_In_1_02[I1, (A, B, C, D, E, F), (a, b, c, d, e                                                   )] = ???
    final def +[I1, a, b, c, d, e, f                                                ] (nextMolecule: IN1_06[I1, a, b, c, d, e, f                                                ]): Composite_In_1_02[I1, (A, B, C, D, E, F), (a, b, c, d, e, f                                                )] = ???
    final def +[I1, a, b, c, d, e, f, g                                             ] (nextMolecule: IN1_07[I1, a, b, c, d, e, f, g                                             ]): Composite_In_1_02[I1, (A, B, C, D, E, F), (a, b, c, d, e, f, g                                             )] = ???
    final def +[I1, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN1_08[I1, a, b, c, d, e, f, g, h                                          ]): Composite_In_1_02[I1, (A, B, C, D, E, F), (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN1_09[I1, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_1_02[I1, (A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN1_10[I1, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_1_02[I1, (A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN1_11[I1, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_1_02[I1, (A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN1_12[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_1_02[I1, (A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN1_13[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_1_02[I1, (A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN1_14[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_1_02[I1, (A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN1_15[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_1_02[I1, (A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN1_16[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_1_02[I1, (A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN1_17[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_1_02[I1, (A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN1_18[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_1_02[I1, (A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN1_19[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_1_02[I1, (A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN1_20[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_1_02[I1, (A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN1_21[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_1_02[I1, (A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN1_22[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_1_02[I1, (A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    final def +[I1, I2                                                                  ] (nextMolecule: IN2_00[I1, I2                                                                  ]): Composite_In_2_01[I1, I2, (A, B, C, D, E, F)                                                                    ] = ???
    final def +[I1, I2, a                                                               ] (nextMolecule: IN2_01[I1, I2, a                                                               ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F), a                                                                 ] = ???
    final def +[I1, I2, a, b                                                            ] (nextMolecule: IN2_02[I1, I2, a, b                                                            ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F), (a, b                                                            )] = ???
    final def +[I1, I2, a, b, c                                                         ] (nextMolecule: IN2_03[I1, I2, a, b, c                                                         ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F), (a, b, c                                                         )] = ???
    final def +[I1, I2, a, b, c, d                                                      ] (nextMolecule: IN2_04[I1, I2, a, b, c, d                                                      ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F), (a, b, c, d                                                      )] = ???
    final def +[I1, I2, a, b, c, d, e                                                   ] (nextMolecule: IN2_05[I1, I2, a, b, c, d, e                                                   ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F), (a, b, c, d, e                                                   )] = ???
    final def +[I1, I2, a, b, c, d, e, f                                                ] (nextMolecule: IN2_06[I1, I2, a, b, c, d, e, f                                                ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F), (a, b, c, d, e, f                                                )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g                                             ] (nextMolecule: IN2_07[I1, I2, a, b, c, d, e, f, g                                             ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F), (a, b, c, d, e, f, g                                             )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN2_08[I1, I2, a, b, c, d, e, f, g, h                                          ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F), (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN2_09[I1, I2, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN2_10[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN2_11[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN2_12[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN2_13[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN2_14[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN2_15[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN2_16[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN2_17[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN2_18[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN2_19[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN2_20[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN2_21[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN2_22[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    final def +[I1, I2, I3                                                                  ] (nextMolecule: IN3_00[I1, I2, I3                                                                  ]): Composite_In_3_01[I1, I2, I3, (A, B, C, D, E, F)                                                                    ] = ???
    final def +[I1, I2, I3, a                                                               ] (nextMolecule: IN3_01[I1, I2, I3, a                                                               ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F), a                                                                 ] = ???
    final def +[I1, I2, I3, a, b                                                            ] (nextMolecule: IN3_02[I1, I2, I3, a, b                                                            ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F), (a, b                                                            )] = ???
    final def +[I1, I2, I3, a, b, c                                                         ] (nextMolecule: IN3_03[I1, I2, I3, a, b, c                                                         ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F), (a, b, c                                                         )] = ???
    final def +[I1, I2, I3, a, b, c, d                                                      ] (nextMolecule: IN3_04[I1, I2, I3, a, b, c, d                                                      ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F), (a, b, c, d                                                      )] = ???
    final def +[I1, I2, I3, a, b, c, d, e                                                   ] (nextMolecule: IN3_05[I1, I2, I3, a, b, c, d, e                                                   ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F), (a, b, c, d, e                                                   )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f                                                ] (nextMolecule: IN3_06[I1, I2, I3, a, b, c, d, e, f                                                ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F), (a, b, c, d, e, f                                                )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g                                             ] (nextMolecule: IN3_07[I1, I2, I3, a, b, c, d, e, f, g                                             ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F), (a, b, c, d, e, f, g                                             )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN3_08[I1, I2, I3, a, b, c, d, e, f, g, h                                          ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F), (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN3_09[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN3_10[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN3_11[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN3_12[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN3_13[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN3_14[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN3_15[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN3_16[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN3_17[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN3_18[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN3_19[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN3_20[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN3_21[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN3_22[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait CompositeInit07[A, B, C, D, E, F, G] extends CompositeInit {
    final def +[x                                                               ] (nextMolecule: NS00[x                                                               ]): Composite01[(A, B, C, D, E, F, G)                                                                    ] = ???
    final def +[a                                                               ] (nextMolecule: NS01[a                                                               ]): Composite02[(A, B, C, D, E, F, G), a                                                                 ] = ???
    final def +[a, b                                                            ] (nextMolecule: NS02[a, b                                                            ]): Composite02[(A, B, C, D, E, F, G), (a, b                                                            )] = ???
    final def +[a, b, c                                                         ] (nextMolecule: NS03[a, b, c                                                         ]): Composite02[(A, B, C, D, E, F, G), (a, b, c                                                         )] = ???
    final def +[a, b, c, d                                                      ] (nextMolecule: NS04[a, b, c, d                                                      ]): Composite02[(A, B, C, D, E, F, G), (a, b, c, d                                                      )] = ???
    final def +[a, b, c, d, e                                                   ] (nextMolecule: NS05[a, b, c, d, e                                                   ]): Composite02[(A, B, C, D, E, F, G), (a, b, c, d, e                                                   )] = ???
    final def +[a, b, c, d, e, f                                                ] (nextMolecule: NS06[a, b, c, d, e, f                                                ]): Composite02[(A, B, C, D, E, F, G), (a, b, c, d, e, f                                                )] = ???
    final def +[a, b, c, d, e, f, g                                             ] (nextMolecule: NS07[a, b, c, d, e, f, g                                             ]): Composite02[(A, B, C, D, E, F, G), (a, b, c, d, e, f, g                                             )] = ???
    final def +[a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS08[a, b, c, d, e, f, g, h                                          ]): Composite02[(A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS09[a, b, c, d, e, f, g, h, i                                       ]): Composite02[(A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite02[(A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite02[(A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite02[(A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite02[(A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite02[(A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite02[(A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite02[(A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite02[(A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite02[(A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite02[(A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite02[(A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite02[(A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite02[(A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    final def +[I1                                                                  ] (nextMolecule: IN1_00[I1                                                                  ]): Composite_In_1_01[I1, (A, B, C, D, E, F, G)                                                                    ] = ???
    final def +[I1, a                                                               ] (nextMolecule: IN1_01[I1, a                                                               ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G), a                                                                 ] = ???
    final def +[I1, a, b                                                            ] (nextMolecule: IN1_02[I1, a, b                                                            ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G), (a, b                                                            )] = ???
    final def +[I1, a, b, c                                                         ] (nextMolecule: IN1_03[I1, a, b, c                                                         ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G), (a, b, c                                                         )] = ???
    final def +[I1, a, b, c, d                                                      ] (nextMolecule: IN1_04[I1, a, b, c, d                                                      ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G), (a, b, c, d                                                      )] = ???
    final def +[I1, a, b, c, d, e                                                   ] (nextMolecule: IN1_05[I1, a, b, c, d, e                                                   ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G), (a, b, c, d, e                                                   )] = ???
    final def +[I1, a, b, c, d, e, f                                                ] (nextMolecule: IN1_06[I1, a, b, c, d, e, f                                                ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G), (a, b, c, d, e, f                                                )] = ???
    final def +[I1, a, b, c, d, e, f, g                                             ] (nextMolecule: IN1_07[I1, a, b, c, d, e, f, g                                             ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G), (a, b, c, d, e, f, g                                             )] = ???
    final def +[I1, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN1_08[I1, a, b, c, d, e, f, g, h                                          ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN1_09[I1, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN1_10[I1, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN1_11[I1, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN1_12[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN1_13[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN1_14[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN1_15[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN1_16[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN1_17[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN1_18[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN1_19[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN1_20[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN1_21[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN1_22[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_1_02[I1, (A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    final def +[I1, I2                                                                  ] (nextMolecule: IN2_00[I1, I2                                                                  ]): Composite_In_2_01[I1, I2, (A, B, C, D, E, F, G)                                                                    ] = ???
    final def +[I1, I2, a                                                               ] (nextMolecule: IN2_01[I1, I2, a                                                               ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G), a                                                                 ] = ???
    final def +[I1, I2, a, b                                                            ] (nextMolecule: IN2_02[I1, I2, a, b                                                            ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G), (a, b                                                            )] = ???
    final def +[I1, I2, a, b, c                                                         ] (nextMolecule: IN2_03[I1, I2, a, b, c                                                         ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G), (a, b, c                                                         )] = ???
    final def +[I1, I2, a, b, c, d                                                      ] (nextMolecule: IN2_04[I1, I2, a, b, c, d                                                      ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G), (a, b, c, d                                                      )] = ???
    final def +[I1, I2, a, b, c, d, e                                                   ] (nextMolecule: IN2_05[I1, I2, a, b, c, d, e                                                   ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G), (a, b, c, d, e                                                   )] = ???
    final def +[I1, I2, a, b, c, d, e, f                                                ] (nextMolecule: IN2_06[I1, I2, a, b, c, d, e, f                                                ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G), (a, b, c, d, e, f                                                )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g                                             ] (nextMolecule: IN2_07[I1, I2, a, b, c, d, e, f, g                                             ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G), (a, b, c, d, e, f, g                                             )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN2_08[I1, I2, a, b, c, d, e, f, g, h                                          ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN2_09[I1, I2, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN2_10[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN2_11[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN2_12[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN2_13[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN2_14[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN2_15[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN2_16[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN2_17[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN2_18[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN2_19[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN2_20[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN2_21[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN2_22[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    final def +[I1, I2, I3                                                                  ] (nextMolecule: IN3_00[I1, I2, I3                                                                  ]): Composite_In_3_01[I1, I2, I3, (A, B, C, D, E, F, G)                                                                    ] = ???
    final def +[I1, I2, I3, a                                                               ] (nextMolecule: IN3_01[I1, I2, I3, a                                                               ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G), a                                                                 ] = ???
    final def +[I1, I2, I3, a, b                                                            ] (nextMolecule: IN3_02[I1, I2, I3, a, b                                                            ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G), (a, b                                                            )] = ???
    final def +[I1, I2, I3, a, b, c                                                         ] (nextMolecule: IN3_03[I1, I2, I3, a, b, c                                                         ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G), (a, b, c                                                         )] = ???
    final def +[I1, I2, I3, a, b, c, d                                                      ] (nextMolecule: IN3_04[I1, I2, I3, a, b, c, d                                                      ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G), (a, b, c, d                                                      )] = ???
    final def +[I1, I2, I3, a, b, c, d, e                                                   ] (nextMolecule: IN3_05[I1, I2, I3, a, b, c, d, e                                                   ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G), (a, b, c, d, e                                                   )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f                                                ] (nextMolecule: IN3_06[I1, I2, I3, a, b, c, d, e, f                                                ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G), (a, b, c, d, e, f                                                )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g                                             ] (nextMolecule: IN3_07[I1, I2, I3, a, b, c, d, e, f, g                                             ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G), (a, b, c, d, e, f, g                                             )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN3_08[I1, I2, I3, a, b, c, d, e, f, g, h                                          ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN3_09[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN3_10[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN3_11[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN3_12[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN3_13[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN3_14[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN3_15[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN3_16[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN3_17[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN3_18[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN3_19[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN3_20[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN3_21[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN3_22[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait CompositeInit08[A, B, C, D, E, F, G, H] extends CompositeInit {
    final def +[x                                                               ] (nextMolecule: NS00[x                                                               ]): Composite01[(A, B, C, D, E, F, G, H)                                                                    ] = ???
    final def +[a                                                               ] (nextMolecule: NS01[a                                                               ]): Composite02[(A, B, C, D, E, F, G, H), a                                                                 ] = ???
    final def +[a, b                                                            ] (nextMolecule: NS02[a, b                                                            ]): Composite02[(A, B, C, D, E, F, G, H), (a, b                                                            )] = ???
    final def +[a, b, c                                                         ] (nextMolecule: NS03[a, b, c                                                         ]): Composite02[(A, B, C, D, E, F, G, H), (a, b, c                                                         )] = ???
    final def +[a, b, c, d                                                      ] (nextMolecule: NS04[a, b, c, d                                                      ]): Composite02[(A, B, C, D, E, F, G, H), (a, b, c, d                                                      )] = ???
    final def +[a, b, c, d, e                                                   ] (nextMolecule: NS05[a, b, c, d, e                                                   ]): Composite02[(A, B, C, D, E, F, G, H), (a, b, c, d, e                                                   )] = ???
    final def +[a, b, c, d, e, f                                                ] (nextMolecule: NS06[a, b, c, d, e, f                                                ]): Composite02[(A, B, C, D, E, F, G, H), (a, b, c, d, e, f                                                )] = ???
    final def +[a, b, c, d, e, f, g                                             ] (nextMolecule: NS07[a, b, c, d, e, f, g                                             ]): Composite02[(A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g                                             )] = ???
    final def +[a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS08[a, b, c, d, e, f, g, h                                          ]): Composite02[(A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS09[a, b, c, d, e, f, g, h, i                                       ]): Composite02[(A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite02[(A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite02[(A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite02[(A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite02[(A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite02[(A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite02[(A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite02[(A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite02[(A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite02[(A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite02[(A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite02[(A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite02[(A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite02[(A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    final def +[I1                                                                  ] (nextMolecule: IN1_00[I1                                                                  ]): Composite_In_1_01[I1, (A, B, C, D, E, F, G, H)                                                                    ] = ???
    final def +[I1, a                                                               ] (nextMolecule: IN1_01[I1, a                                                               ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H), a                                                                 ] = ???
    final def +[I1, a, b                                                            ] (nextMolecule: IN1_02[I1, a, b                                                            ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H), (a, b                                                            )] = ???
    final def +[I1, a, b, c                                                         ] (nextMolecule: IN1_03[I1, a, b, c                                                         ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H), (a, b, c                                                         )] = ???
    final def +[I1, a, b, c, d                                                      ] (nextMolecule: IN1_04[I1, a, b, c, d                                                      ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H), (a, b, c, d                                                      )] = ???
    final def +[I1, a, b, c, d, e                                                   ] (nextMolecule: IN1_05[I1, a, b, c, d, e                                                   ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H), (a, b, c, d, e                                                   )] = ???
    final def +[I1, a, b, c, d, e, f                                                ] (nextMolecule: IN1_06[I1, a, b, c, d, e, f                                                ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f                                                )] = ???
    final def +[I1, a, b, c, d, e, f, g                                             ] (nextMolecule: IN1_07[I1, a, b, c, d, e, f, g                                             ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g                                             )] = ???
    final def +[I1, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN1_08[I1, a, b, c, d, e, f, g, h                                          ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN1_09[I1, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN1_10[I1, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN1_11[I1, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN1_12[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN1_13[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN1_14[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN1_15[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN1_16[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN1_17[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN1_18[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN1_19[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN1_20[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN1_21[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN1_22[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    final def +[I1, I2                                                                  ] (nextMolecule: IN2_00[I1, I2                                                                  ]): Composite_In_2_01[I1, I2, (A, B, C, D, E, F, G, H)                                                                    ] = ???
    final def +[I1, I2, a                                                               ] (nextMolecule: IN2_01[I1, I2, a                                                               ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H), a                                                                 ] = ???
    final def +[I1, I2, a, b                                                            ] (nextMolecule: IN2_02[I1, I2, a, b                                                            ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H), (a, b                                                            )] = ???
    final def +[I1, I2, a, b, c                                                         ] (nextMolecule: IN2_03[I1, I2, a, b, c                                                         ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H), (a, b, c                                                         )] = ???
    final def +[I1, I2, a, b, c, d                                                      ] (nextMolecule: IN2_04[I1, I2, a, b, c, d                                                      ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H), (a, b, c, d                                                      )] = ???
    final def +[I1, I2, a, b, c, d, e                                                   ] (nextMolecule: IN2_05[I1, I2, a, b, c, d, e                                                   ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H), (a, b, c, d, e                                                   )] = ???
    final def +[I1, I2, a, b, c, d, e, f                                                ] (nextMolecule: IN2_06[I1, I2, a, b, c, d, e, f                                                ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f                                                )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g                                             ] (nextMolecule: IN2_07[I1, I2, a, b, c, d, e, f, g                                             ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g                                             )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN2_08[I1, I2, a, b, c, d, e, f, g, h                                          ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN2_09[I1, I2, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN2_10[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN2_11[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN2_12[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN2_13[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN2_14[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN2_15[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN2_16[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN2_17[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN2_18[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN2_19[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN2_20[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN2_21[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN2_22[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    final def +[I1, I2, I3                                                                  ] (nextMolecule: IN3_00[I1, I2, I3                                                                  ]): Composite_In_3_01[I1, I2, I3, (A, B, C, D, E, F, G, H)                                                                    ] = ???
    final def +[I1, I2, I3, a                                                               ] (nextMolecule: IN3_01[I1, I2, I3, a                                                               ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H), a                                                                 ] = ???
    final def +[I1, I2, I3, a, b                                                            ] (nextMolecule: IN3_02[I1, I2, I3, a, b                                                            ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H), (a, b                                                            )] = ???
    final def +[I1, I2, I3, a, b, c                                                         ] (nextMolecule: IN3_03[I1, I2, I3, a, b, c                                                         ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H), (a, b, c                                                         )] = ???
    final def +[I1, I2, I3, a, b, c, d                                                      ] (nextMolecule: IN3_04[I1, I2, I3, a, b, c, d                                                      ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H), (a, b, c, d                                                      )] = ???
    final def +[I1, I2, I3, a, b, c, d, e                                                   ] (nextMolecule: IN3_05[I1, I2, I3, a, b, c, d, e                                                   ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H), (a, b, c, d, e                                                   )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f                                                ] (nextMolecule: IN3_06[I1, I2, I3, a, b, c, d, e, f                                                ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f                                                )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g                                             ] (nextMolecule: IN3_07[I1, I2, I3, a, b, c, d, e, f, g                                             ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g                                             )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN3_08[I1, I2, I3, a, b, c, d, e, f, g, h                                          ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN3_09[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN3_10[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN3_11[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN3_12[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN3_13[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN3_14[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN3_15[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN3_16[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN3_17[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN3_18[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN3_19[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN3_20[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN3_21[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN3_22[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait CompositeInit09[A, B, C, D, E, F, G, H, I] extends CompositeInit {
    final def +[x                                                               ] (nextMolecule: NS00[x                                                               ]): Composite01[(A, B, C, D, E, F, G, H, I)                                                                    ] = ???
    final def +[a                                                               ] (nextMolecule: NS01[a                                                               ]): Composite02[(A, B, C, D, E, F, G, H, I), a                                                                 ] = ???
    final def +[a, b                                                            ] (nextMolecule: NS02[a, b                                                            ]): Composite02[(A, B, C, D, E, F, G, H, I), (a, b                                                            )] = ???
    final def +[a, b, c                                                         ] (nextMolecule: NS03[a, b, c                                                         ]): Composite02[(A, B, C, D, E, F, G, H, I), (a, b, c                                                         )] = ???
    final def +[a, b, c, d                                                      ] (nextMolecule: NS04[a, b, c, d                                                      ]): Composite02[(A, B, C, D, E, F, G, H, I), (a, b, c, d                                                      )] = ???
    final def +[a, b, c, d, e                                                   ] (nextMolecule: NS05[a, b, c, d, e                                                   ]): Composite02[(A, B, C, D, E, F, G, H, I), (a, b, c, d, e                                                   )] = ???
    final def +[a, b, c, d, e, f                                                ] (nextMolecule: NS06[a, b, c, d, e, f                                                ]): Composite02[(A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f                                                )] = ???
    final def +[a, b, c, d, e, f, g                                             ] (nextMolecule: NS07[a, b, c, d, e, f, g                                             ]): Composite02[(A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g                                             )] = ???
    final def +[a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS08[a, b, c, d, e, f, g, h                                          ]): Composite02[(A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS09[a, b, c, d, e, f, g, h, i                                       ]): Composite02[(A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite02[(A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite02[(A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite02[(A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite02[(A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite02[(A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite02[(A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite02[(A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite02[(A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite02[(A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite02[(A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite02[(A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite02[(A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite02[(A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    final def +[I1                                                                  ] (nextMolecule: IN1_00[I1                                                                  ]): Composite_In_1_01[I1, (A, B, C, D, E, F, G, H, I)                                                                    ] = ???
    final def +[I1, a                                                               ] (nextMolecule: IN1_01[I1, a                                                               ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I), a                                                                 ] = ???
    final def +[I1, a, b                                                            ] (nextMolecule: IN1_02[I1, a, b                                                            ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I), (a, b                                                            )] = ???
    final def +[I1, a, b, c                                                         ] (nextMolecule: IN1_03[I1, a, b, c                                                         ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I), (a, b, c                                                         )] = ???
    final def +[I1, a, b, c, d                                                      ] (nextMolecule: IN1_04[I1, a, b, c, d                                                      ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I), (a, b, c, d                                                      )] = ???
    final def +[I1, a, b, c, d, e                                                   ] (nextMolecule: IN1_05[I1, a, b, c, d, e                                                   ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e                                                   )] = ???
    final def +[I1, a, b, c, d, e, f                                                ] (nextMolecule: IN1_06[I1, a, b, c, d, e, f                                                ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f                                                )] = ???
    final def +[I1, a, b, c, d, e, f, g                                             ] (nextMolecule: IN1_07[I1, a, b, c, d, e, f, g                                             ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g                                             )] = ???
    final def +[I1, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN1_08[I1, a, b, c, d, e, f, g, h                                          ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN1_09[I1, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN1_10[I1, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN1_11[I1, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN1_12[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN1_13[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN1_14[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN1_15[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN1_16[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN1_17[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN1_18[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN1_19[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN1_20[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN1_21[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN1_22[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    final def +[I1, I2                                                                  ] (nextMolecule: IN2_00[I1, I2                                                                  ]): Composite_In_2_01[I1, I2, (A, B, C, D, E, F, G, H, I)                                                                    ] = ???
    final def +[I1, I2, a                                                               ] (nextMolecule: IN2_01[I1, I2, a                                                               ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I), a                                                                 ] = ???
    final def +[I1, I2, a, b                                                            ] (nextMolecule: IN2_02[I1, I2, a, b                                                            ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I), (a, b                                                            )] = ???
    final def +[I1, I2, a, b, c                                                         ] (nextMolecule: IN2_03[I1, I2, a, b, c                                                         ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I), (a, b, c                                                         )] = ???
    final def +[I1, I2, a, b, c, d                                                      ] (nextMolecule: IN2_04[I1, I2, a, b, c, d                                                      ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I), (a, b, c, d                                                      )] = ???
    final def +[I1, I2, a, b, c, d, e                                                   ] (nextMolecule: IN2_05[I1, I2, a, b, c, d, e                                                   ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e                                                   )] = ???
    final def +[I1, I2, a, b, c, d, e, f                                                ] (nextMolecule: IN2_06[I1, I2, a, b, c, d, e, f                                                ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f                                                )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g                                             ] (nextMolecule: IN2_07[I1, I2, a, b, c, d, e, f, g                                             ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g                                             )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN2_08[I1, I2, a, b, c, d, e, f, g, h                                          ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN2_09[I1, I2, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN2_10[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN2_11[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN2_12[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN2_13[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN2_14[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN2_15[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN2_16[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN2_17[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN2_18[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN2_19[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN2_20[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN2_21[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN2_22[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    final def +[I1, I2, I3                                                                  ] (nextMolecule: IN3_00[I1, I2, I3                                                                  ]): Composite_In_3_01[I1, I2, I3, (A, B, C, D, E, F, G, H, I)                                                                    ] = ???
    final def +[I1, I2, I3, a                                                               ] (nextMolecule: IN3_01[I1, I2, I3, a                                                               ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I), a                                                                 ] = ???
    final def +[I1, I2, I3, a, b                                                            ] (nextMolecule: IN3_02[I1, I2, I3, a, b                                                            ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I), (a, b                                                            )] = ???
    final def +[I1, I2, I3, a, b, c                                                         ] (nextMolecule: IN3_03[I1, I2, I3, a, b, c                                                         ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I), (a, b, c                                                         )] = ???
    final def +[I1, I2, I3, a, b, c, d                                                      ] (nextMolecule: IN3_04[I1, I2, I3, a, b, c, d                                                      ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I), (a, b, c, d                                                      )] = ???
    final def +[I1, I2, I3, a, b, c, d, e                                                   ] (nextMolecule: IN3_05[I1, I2, I3, a, b, c, d, e                                                   ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e                                                   )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f                                                ] (nextMolecule: IN3_06[I1, I2, I3, a, b, c, d, e, f                                                ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f                                                )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g                                             ] (nextMolecule: IN3_07[I1, I2, I3, a, b, c, d, e, f, g                                             ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g                                             )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN3_08[I1, I2, I3, a, b, c, d, e, f, g, h                                          ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN3_09[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN3_10[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN3_11[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN3_12[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN3_13[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN3_14[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN3_15[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN3_16[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN3_17[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN3_18[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN3_19[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN3_20[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN3_21[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN3_22[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait CompositeInit10[A, B, C, D, E, F, G, H, I, J] extends CompositeInit {
    final def +[x                                                               ] (nextMolecule: NS00[x                                                               ]): Composite01[(A, B, C, D, E, F, G, H, I, J)                                                                    ] = ???
    final def +[a                                                               ] (nextMolecule: NS01[a                                                               ]): Composite02[(A, B, C, D, E, F, G, H, I, J), a                                                                 ] = ???
    final def +[a, b                                                            ] (nextMolecule: NS02[a, b                                                            ]): Composite02[(A, B, C, D, E, F, G, H, I, J), (a, b                                                            )] = ???
    final def +[a, b, c                                                         ] (nextMolecule: NS03[a, b, c                                                         ]): Composite02[(A, B, C, D, E, F, G, H, I, J), (a, b, c                                                         )] = ???
    final def +[a, b, c, d                                                      ] (nextMolecule: NS04[a, b, c, d                                                      ]): Composite02[(A, B, C, D, E, F, G, H, I, J), (a, b, c, d                                                      )] = ???
    final def +[a, b, c, d, e                                                   ] (nextMolecule: NS05[a, b, c, d, e                                                   ]): Composite02[(A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e                                                   )] = ???
    final def +[a, b, c, d, e, f                                                ] (nextMolecule: NS06[a, b, c, d, e, f                                                ]): Composite02[(A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f                                                )] = ???
    final def +[a, b, c, d, e, f, g                                             ] (nextMolecule: NS07[a, b, c, d, e, f, g                                             ]): Composite02[(A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g                                             )] = ???
    final def +[a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS08[a, b, c, d, e, f, g, h                                          ]): Composite02[(A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS09[a, b, c, d, e, f, g, h, i                                       ]): Composite02[(A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite02[(A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite02[(A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite02[(A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite02[(A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite02[(A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite02[(A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite02[(A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite02[(A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite02[(A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite02[(A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite02[(A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite02[(A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite02[(A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    final def +[I1                                                                  ] (nextMolecule: IN1_00[I1                                                                  ]): Composite_In_1_01[I1, (A, B, C, D, E, F, G, H, I, J)                                                                    ] = ???
    final def +[I1, a                                                               ] (nextMolecule: IN1_01[I1, a                                                               ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J), a                                                                 ] = ???
    final def +[I1, a, b                                                            ] (nextMolecule: IN1_02[I1, a, b                                                            ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J), (a, b                                                            )] = ???
    final def +[I1, a, b, c                                                         ] (nextMolecule: IN1_03[I1, a, b, c                                                         ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J), (a, b, c                                                         )] = ???
    final def +[I1, a, b, c, d                                                      ] (nextMolecule: IN1_04[I1, a, b, c, d                                                      ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d                                                      )] = ???
    final def +[I1, a, b, c, d, e                                                   ] (nextMolecule: IN1_05[I1, a, b, c, d, e                                                   ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e                                                   )] = ???
    final def +[I1, a, b, c, d, e, f                                                ] (nextMolecule: IN1_06[I1, a, b, c, d, e, f                                                ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f                                                )] = ???
    final def +[I1, a, b, c, d, e, f, g                                             ] (nextMolecule: IN1_07[I1, a, b, c, d, e, f, g                                             ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g                                             )] = ???
    final def +[I1, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN1_08[I1, a, b, c, d, e, f, g, h                                          ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN1_09[I1, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN1_10[I1, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN1_11[I1, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN1_12[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN1_13[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN1_14[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN1_15[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN1_16[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN1_17[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN1_18[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN1_19[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN1_20[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN1_21[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN1_22[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    final def +[I1, I2                                                                  ] (nextMolecule: IN2_00[I1, I2                                                                  ]): Composite_In_2_01[I1, I2, (A, B, C, D, E, F, G, H, I, J)                                                                    ] = ???
    final def +[I1, I2, a                                                               ] (nextMolecule: IN2_01[I1, I2, a                                                               ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J), a                                                                 ] = ???
    final def +[I1, I2, a, b                                                            ] (nextMolecule: IN2_02[I1, I2, a, b                                                            ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J), (a, b                                                            )] = ???
    final def +[I1, I2, a, b, c                                                         ] (nextMolecule: IN2_03[I1, I2, a, b, c                                                         ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J), (a, b, c                                                         )] = ???
    final def +[I1, I2, a, b, c, d                                                      ] (nextMolecule: IN2_04[I1, I2, a, b, c, d                                                      ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d                                                      )] = ???
    final def +[I1, I2, a, b, c, d, e                                                   ] (nextMolecule: IN2_05[I1, I2, a, b, c, d, e                                                   ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e                                                   )] = ???
    final def +[I1, I2, a, b, c, d, e, f                                                ] (nextMolecule: IN2_06[I1, I2, a, b, c, d, e, f                                                ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f                                                )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g                                             ] (nextMolecule: IN2_07[I1, I2, a, b, c, d, e, f, g                                             ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g                                             )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN2_08[I1, I2, a, b, c, d, e, f, g, h                                          ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN2_09[I1, I2, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN2_10[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN2_11[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN2_12[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN2_13[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN2_14[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN2_15[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN2_16[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN2_17[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN2_18[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN2_19[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN2_20[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN2_21[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN2_22[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    final def +[I1, I2, I3                                                                  ] (nextMolecule: IN3_00[I1, I2, I3                                                                  ]): Composite_In_3_01[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J)                                                                    ] = ???
    final def +[I1, I2, I3, a                                                               ] (nextMolecule: IN3_01[I1, I2, I3, a                                                               ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J), a                                                                 ] = ???
    final def +[I1, I2, I3, a, b                                                            ] (nextMolecule: IN3_02[I1, I2, I3, a, b                                                            ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J), (a, b                                                            )] = ???
    final def +[I1, I2, I3, a, b, c                                                         ] (nextMolecule: IN3_03[I1, I2, I3, a, b, c                                                         ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J), (a, b, c                                                         )] = ???
    final def +[I1, I2, I3, a, b, c, d                                                      ] (nextMolecule: IN3_04[I1, I2, I3, a, b, c, d                                                      ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d                                                      )] = ???
    final def +[I1, I2, I3, a, b, c, d, e                                                   ] (nextMolecule: IN3_05[I1, I2, I3, a, b, c, d, e                                                   ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e                                                   )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f                                                ] (nextMolecule: IN3_06[I1, I2, I3, a, b, c, d, e, f                                                ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f                                                )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g                                             ] (nextMolecule: IN3_07[I1, I2, I3, a, b, c, d, e, f, g                                             ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g                                             )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN3_08[I1, I2, I3, a, b, c, d, e, f, g, h                                          ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN3_09[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN3_10[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN3_11[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN3_12[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN3_13[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN3_14[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN3_15[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN3_16[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN3_17[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN3_18[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN3_19[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN3_20[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN3_21[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN3_22[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait CompositeInit11[A, B, C, D, E, F, G, H, I, J, K] extends CompositeInit {
    final def +[x                                                               ] (nextMolecule: NS00[x                                                               ]): Composite01[(A, B, C, D, E, F, G, H, I, J, K)                                                                    ] = ???
    final def +[a                                                               ] (nextMolecule: NS01[a                                                               ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K), a                                                                 ] = ???
    final def +[a, b                                                            ] (nextMolecule: NS02[a, b                                                            ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K), (a, b                                                            )] = ???
    final def +[a, b, c                                                         ] (nextMolecule: NS03[a, b, c                                                         ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K), (a, b, c                                                         )] = ???
    final def +[a, b, c, d                                                      ] (nextMolecule: NS04[a, b, c, d                                                      ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d                                                      )] = ???
    final def +[a, b, c, d, e                                                   ] (nextMolecule: NS05[a, b, c, d, e                                                   ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e                                                   )] = ???
    final def +[a, b, c, d, e, f                                                ] (nextMolecule: NS06[a, b, c, d, e, f                                                ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f                                                )] = ???
    final def +[a, b, c, d, e, f, g                                             ] (nextMolecule: NS07[a, b, c, d, e, f, g                                             ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g                                             )] = ???
    final def +[a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS08[a, b, c, d, e, f, g, h                                          ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS09[a, b, c, d, e, f, g, h, i                                       ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite02[(A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    final def +[I1                                                                  ] (nextMolecule: IN1_00[I1                                                                  ]): Composite_In_1_01[I1, (A, B, C, D, E, F, G, H, I, J, K)                                                                    ] = ???
    final def +[I1, a                                                               ] (nextMolecule: IN1_01[I1, a                                                               ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K), a                                                                 ] = ???
    final def +[I1, a, b                                                            ] (nextMolecule: IN1_02[I1, a, b                                                            ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K), (a, b                                                            )] = ???
    final def +[I1, a, b, c                                                         ] (nextMolecule: IN1_03[I1, a, b, c                                                         ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c                                                         )] = ???
    final def +[I1, a, b, c, d                                                      ] (nextMolecule: IN1_04[I1, a, b, c, d                                                      ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d                                                      )] = ???
    final def +[I1, a, b, c, d, e                                                   ] (nextMolecule: IN1_05[I1, a, b, c, d, e                                                   ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e                                                   )] = ???
    final def +[I1, a, b, c, d, e, f                                                ] (nextMolecule: IN1_06[I1, a, b, c, d, e, f                                                ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f                                                )] = ???
    final def +[I1, a, b, c, d, e, f, g                                             ] (nextMolecule: IN1_07[I1, a, b, c, d, e, f, g                                             ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g                                             )] = ???
    final def +[I1, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN1_08[I1, a, b, c, d, e, f, g, h                                          ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN1_09[I1, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN1_10[I1, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN1_11[I1, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN1_12[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN1_13[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN1_14[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN1_15[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN1_16[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN1_17[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN1_18[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN1_19[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN1_20[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN1_21[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN1_22[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    final def +[I1, I2                                                                  ] (nextMolecule: IN2_00[I1, I2                                                                  ]): Composite_In_2_01[I1, I2, (A, B, C, D, E, F, G, H, I, J, K)                                                                    ] = ???
    final def +[I1, I2, a                                                               ] (nextMolecule: IN2_01[I1, I2, a                                                               ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K), a                                                                 ] = ???
    final def +[I1, I2, a, b                                                            ] (nextMolecule: IN2_02[I1, I2, a, b                                                            ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K), (a, b                                                            )] = ???
    final def +[I1, I2, a, b, c                                                         ] (nextMolecule: IN2_03[I1, I2, a, b, c                                                         ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c                                                         )] = ???
    final def +[I1, I2, a, b, c, d                                                      ] (nextMolecule: IN2_04[I1, I2, a, b, c, d                                                      ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d                                                      )] = ???
    final def +[I1, I2, a, b, c, d, e                                                   ] (nextMolecule: IN2_05[I1, I2, a, b, c, d, e                                                   ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e                                                   )] = ???
    final def +[I1, I2, a, b, c, d, e, f                                                ] (nextMolecule: IN2_06[I1, I2, a, b, c, d, e, f                                                ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f                                                )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g                                             ] (nextMolecule: IN2_07[I1, I2, a, b, c, d, e, f, g                                             ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g                                             )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN2_08[I1, I2, a, b, c, d, e, f, g, h                                          ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN2_09[I1, I2, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN2_10[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN2_11[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN2_12[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN2_13[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN2_14[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN2_15[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN2_16[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN2_17[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN2_18[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN2_19[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN2_20[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN2_21[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN2_22[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    final def +[I1, I2, I3                                                                  ] (nextMolecule: IN3_00[I1, I2, I3                                                                  ]): Composite_In_3_01[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K)                                                                    ] = ???
    final def +[I1, I2, I3, a                                                               ] (nextMolecule: IN3_01[I1, I2, I3, a                                                               ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K), a                                                                 ] = ???
    final def +[I1, I2, I3, a, b                                                            ] (nextMolecule: IN3_02[I1, I2, I3, a, b                                                            ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K), (a, b                                                            )] = ???
    final def +[I1, I2, I3, a, b, c                                                         ] (nextMolecule: IN3_03[I1, I2, I3, a, b, c                                                         ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c                                                         )] = ???
    final def +[I1, I2, I3, a, b, c, d                                                      ] (nextMolecule: IN3_04[I1, I2, I3, a, b, c, d                                                      ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d                                                      )] = ???
    final def +[I1, I2, I3, a, b, c, d, e                                                   ] (nextMolecule: IN3_05[I1, I2, I3, a, b, c, d, e                                                   ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e                                                   )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f                                                ] (nextMolecule: IN3_06[I1, I2, I3, a, b, c, d, e, f                                                ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f                                                )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g                                             ] (nextMolecule: IN3_07[I1, I2, I3, a, b, c, d, e, f, g                                             ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g                                             )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN3_08[I1, I2, I3, a, b, c, d, e, f, g, h                                          ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN3_09[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN3_10[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN3_11[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN3_12[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN3_13[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN3_14[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN3_15[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN3_16[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN3_17[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN3_18[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN3_19[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN3_20[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN3_21[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN3_22[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait CompositeInit12[A, B, C, D, E, F, G, H, I, J, K, L] extends CompositeInit {
    final def +[x                                                               ] (nextMolecule: NS00[x                                                               ]): Composite01[(A, B, C, D, E, F, G, H, I, J, K, L)                                                                    ] = ???
    final def +[a                                                               ] (nextMolecule: NS01[a                                                               ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L), a                                                                 ] = ???
    final def +[a, b                                                            ] (nextMolecule: NS02[a, b                                                            ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L), (a, b                                                            )] = ???
    final def +[a, b, c                                                         ] (nextMolecule: NS03[a, b, c                                                         ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c                                                         )] = ???
    final def +[a, b, c, d                                                      ] (nextMolecule: NS04[a, b, c, d                                                      ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d                                                      )] = ???
    final def +[a, b, c, d, e                                                   ] (nextMolecule: NS05[a, b, c, d, e                                                   ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e                                                   )] = ???
    final def +[a, b, c, d, e, f                                                ] (nextMolecule: NS06[a, b, c, d, e, f                                                ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f                                                )] = ???
    final def +[a, b, c, d, e, f, g                                             ] (nextMolecule: NS07[a, b, c, d, e, f, g                                             ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g                                             )] = ???
    final def +[a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS08[a, b, c, d, e, f, g, h                                          ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS09[a, b, c, d, e, f, g, h, i                                       ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    final def +[I1                                                                  ] (nextMolecule: IN1_00[I1                                                                  ]): Composite_In_1_01[I1, (A, B, C, D, E, F, G, H, I, J, K, L)                                                                    ] = ???
    final def +[I1, a                                                               ] (nextMolecule: IN1_01[I1, a                                                               ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L), a                                                                 ] = ???
    final def +[I1, a, b                                                            ] (nextMolecule: IN1_02[I1, a, b                                                            ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b                                                            )] = ???
    final def +[I1, a, b, c                                                         ] (nextMolecule: IN1_03[I1, a, b, c                                                         ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c                                                         )] = ???
    final def +[I1, a, b, c, d                                                      ] (nextMolecule: IN1_04[I1, a, b, c, d                                                      ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d                                                      )] = ???
    final def +[I1, a, b, c, d, e                                                   ] (nextMolecule: IN1_05[I1, a, b, c, d, e                                                   ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e                                                   )] = ???
    final def +[I1, a, b, c, d, e, f                                                ] (nextMolecule: IN1_06[I1, a, b, c, d, e, f                                                ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f                                                )] = ???
    final def +[I1, a, b, c, d, e, f, g                                             ] (nextMolecule: IN1_07[I1, a, b, c, d, e, f, g                                             ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g                                             )] = ???
    final def +[I1, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN1_08[I1, a, b, c, d, e, f, g, h                                          ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN1_09[I1, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN1_10[I1, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN1_11[I1, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN1_12[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN1_13[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN1_14[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN1_15[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN1_16[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN1_17[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN1_18[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN1_19[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN1_20[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN1_21[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN1_22[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    final def +[I1, I2                                                                  ] (nextMolecule: IN2_00[I1, I2                                                                  ]): Composite_In_2_01[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L)                                                                    ] = ???
    final def +[I1, I2, a                                                               ] (nextMolecule: IN2_01[I1, I2, a                                                               ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L), a                                                                 ] = ???
    final def +[I1, I2, a, b                                                            ] (nextMolecule: IN2_02[I1, I2, a, b                                                            ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b                                                            )] = ???
    final def +[I1, I2, a, b, c                                                         ] (nextMolecule: IN2_03[I1, I2, a, b, c                                                         ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c                                                         )] = ???
    final def +[I1, I2, a, b, c, d                                                      ] (nextMolecule: IN2_04[I1, I2, a, b, c, d                                                      ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d                                                      )] = ???
    final def +[I1, I2, a, b, c, d, e                                                   ] (nextMolecule: IN2_05[I1, I2, a, b, c, d, e                                                   ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e                                                   )] = ???
    final def +[I1, I2, a, b, c, d, e, f                                                ] (nextMolecule: IN2_06[I1, I2, a, b, c, d, e, f                                                ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f                                                )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g                                             ] (nextMolecule: IN2_07[I1, I2, a, b, c, d, e, f, g                                             ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g                                             )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN2_08[I1, I2, a, b, c, d, e, f, g, h                                          ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN2_09[I1, I2, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN2_10[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN2_11[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN2_12[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN2_13[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN2_14[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN2_15[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN2_16[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN2_17[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN2_18[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN2_19[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN2_20[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN2_21[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN2_22[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    final def +[I1, I2, I3                                                                  ] (nextMolecule: IN3_00[I1, I2, I3                                                                  ]): Composite_In_3_01[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L)                                                                    ] = ???
    final def +[I1, I2, I3, a                                                               ] (nextMolecule: IN3_01[I1, I2, I3, a                                                               ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L), a                                                                 ] = ???
    final def +[I1, I2, I3, a, b                                                            ] (nextMolecule: IN3_02[I1, I2, I3, a, b                                                            ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b                                                            )] = ???
    final def +[I1, I2, I3, a, b, c                                                         ] (nextMolecule: IN3_03[I1, I2, I3, a, b, c                                                         ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c                                                         )] = ???
    final def +[I1, I2, I3, a, b, c, d                                                      ] (nextMolecule: IN3_04[I1, I2, I3, a, b, c, d                                                      ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d                                                      )] = ???
    final def +[I1, I2, I3, a, b, c, d, e                                                   ] (nextMolecule: IN3_05[I1, I2, I3, a, b, c, d, e                                                   ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e                                                   )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f                                                ] (nextMolecule: IN3_06[I1, I2, I3, a, b, c, d, e, f                                                ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f                                                )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g                                             ] (nextMolecule: IN3_07[I1, I2, I3, a, b, c, d, e, f, g                                             ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g                                             )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN3_08[I1, I2, I3, a, b, c, d, e, f, g, h                                          ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN3_09[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN3_10[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN3_11[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN3_12[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN3_13[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN3_14[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN3_15[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN3_16[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN3_17[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN3_18[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN3_19[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN3_20[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN3_21[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN3_22[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait CompositeInit13[A, B, C, D, E, F, G, H, I, J, K, L, M] extends CompositeInit {
    final def +[x                                                               ] (nextMolecule: NS00[x                                                               ]): Composite01[(A, B, C, D, E, F, G, H, I, J, K, L, M)                                                                    ] = ???
    final def +[a                                                               ] (nextMolecule: NS01[a                                                               ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M), a                                                                 ] = ???
    final def +[a, b                                                            ] (nextMolecule: NS02[a, b                                                            ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b                                                            )] = ???
    final def +[a, b, c                                                         ] (nextMolecule: NS03[a, b, c                                                         ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c                                                         )] = ???
    final def +[a, b, c, d                                                      ] (nextMolecule: NS04[a, b, c, d                                                      ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d                                                      )] = ???
    final def +[a, b, c, d, e                                                   ] (nextMolecule: NS05[a, b, c, d, e                                                   ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e                                                   )] = ???
    final def +[a, b, c, d, e, f                                                ] (nextMolecule: NS06[a, b, c, d, e, f                                                ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f                                                )] = ???
    final def +[a, b, c, d, e, f, g                                             ] (nextMolecule: NS07[a, b, c, d, e, f, g                                             ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g                                             )] = ???
    final def +[a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS08[a, b, c, d, e, f, g, h                                          ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS09[a, b, c, d, e, f, g, h, i                                       ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    final def +[I1                                                                  ] (nextMolecule: IN1_00[I1                                                                  ]): Composite_In_1_01[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M)                                                                    ] = ???
    final def +[I1, a                                                               ] (nextMolecule: IN1_01[I1, a                                                               ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M), a                                                                 ] = ???
    final def +[I1, a, b                                                            ] (nextMolecule: IN1_02[I1, a, b                                                            ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b                                                            )] = ???
    final def +[I1, a, b, c                                                         ] (nextMolecule: IN1_03[I1, a, b, c                                                         ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c                                                         )] = ???
    final def +[I1, a, b, c, d                                                      ] (nextMolecule: IN1_04[I1, a, b, c, d                                                      ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d                                                      )] = ???
    final def +[I1, a, b, c, d, e                                                   ] (nextMolecule: IN1_05[I1, a, b, c, d, e                                                   ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e                                                   )] = ???
    final def +[I1, a, b, c, d, e, f                                                ] (nextMolecule: IN1_06[I1, a, b, c, d, e, f                                                ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f                                                )] = ???
    final def +[I1, a, b, c, d, e, f, g                                             ] (nextMolecule: IN1_07[I1, a, b, c, d, e, f, g                                             ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g                                             )] = ???
    final def +[I1, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN1_08[I1, a, b, c, d, e, f, g, h                                          ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN1_09[I1, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN1_10[I1, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN1_11[I1, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN1_12[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN1_13[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN1_14[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN1_15[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN1_16[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN1_17[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN1_18[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN1_19[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN1_20[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN1_21[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN1_22[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    final def +[I1, I2                                                                  ] (nextMolecule: IN2_00[I1, I2                                                                  ]): Composite_In_2_01[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M)                                                                    ] = ???
    final def +[I1, I2, a                                                               ] (nextMolecule: IN2_01[I1, I2, a                                                               ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M), a                                                                 ] = ???
    final def +[I1, I2, a, b                                                            ] (nextMolecule: IN2_02[I1, I2, a, b                                                            ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b                                                            )] = ???
    final def +[I1, I2, a, b, c                                                         ] (nextMolecule: IN2_03[I1, I2, a, b, c                                                         ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c                                                         )] = ???
    final def +[I1, I2, a, b, c, d                                                      ] (nextMolecule: IN2_04[I1, I2, a, b, c, d                                                      ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d                                                      )] = ???
    final def +[I1, I2, a, b, c, d, e                                                   ] (nextMolecule: IN2_05[I1, I2, a, b, c, d, e                                                   ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e                                                   )] = ???
    final def +[I1, I2, a, b, c, d, e, f                                                ] (nextMolecule: IN2_06[I1, I2, a, b, c, d, e, f                                                ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f                                                )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g                                             ] (nextMolecule: IN2_07[I1, I2, a, b, c, d, e, f, g                                             ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g                                             )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN2_08[I1, I2, a, b, c, d, e, f, g, h                                          ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN2_09[I1, I2, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN2_10[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN2_11[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN2_12[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN2_13[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN2_14[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN2_15[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN2_16[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN2_17[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN2_18[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN2_19[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN2_20[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN2_21[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN2_22[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    final def +[I1, I2, I3                                                                  ] (nextMolecule: IN3_00[I1, I2, I3                                                                  ]): Composite_In_3_01[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M)                                                                    ] = ???
    final def +[I1, I2, I3, a                                                               ] (nextMolecule: IN3_01[I1, I2, I3, a                                                               ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M), a                                                                 ] = ???
    final def +[I1, I2, I3, a, b                                                            ] (nextMolecule: IN3_02[I1, I2, I3, a, b                                                            ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b                                                            )] = ???
    final def +[I1, I2, I3, a, b, c                                                         ] (nextMolecule: IN3_03[I1, I2, I3, a, b, c                                                         ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c                                                         )] = ???
    final def +[I1, I2, I3, a, b, c, d                                                      ] (nextMolecule: IN3_04[I1, I2, I3, a, b, c, d                                                      ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d                                                      )] = ???
    final def +[I1, I2, I3, a, b, c, d, e                                                   ] (nextMolecule: IN3_05[I1, I2, I3, a, b, c, d, e                                                   ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e                                                   )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f                                                ] (nextMolecule: IN3_06[I1, I2, I3, a, b, c, d, e, f                                                ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f                                                )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g                                             ] (nextMolecule: IN3_07[I1, I2, I3, a, b, c, d, e, f, g                                             ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g                                             )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN3_08[I1, I2, I3, a, b, c, d, e, f, g, h                                          ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN3_09[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN3_10[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN3_11[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN3_12[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN3_13[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN3_14[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN3_15[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN3_16[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN3_17[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN3_18[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN3_19[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN3_20[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN3_21[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN3_22[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait CompositeInit14[A, B, C, D, E, F, G, H, I, J, K, L, M, N] extends CompositeInit {
    final def +[x                                                               ] (nextMolecule: NS00[x                                                               ]): Composite01[(A, B, C, D, E, F, G, H, I, J, K, L, M, N)                                                                    ] = ???
    final def +[a                                                               ] (nextMolecule: NS01[a                                                               ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N), a                                                                 ] = ???
    final def +[a, b                                                            ] (nextMolecule: NS02[a, b                                                            ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b                                                            )] = ???
    final def +[a, b, c                                                         ] (nextMolecule: NS03[a, b, c                                                         ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c                                                         )] = ???
    final def +[a, b, c, d                                                      ] (nextMolecule: NS04[a, b, c, d                                                      ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d                                                      )] = ???
    final def +[a, b, c, d, e                                                   ] (nextMolecule: NS05[a, b, c, d, e                                                   ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e                                                   )] = ???
    final def +[a, b, c, d, e, f                                                ] (nextMolecule: NS06[a, b, c, d, e, f                                                ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f                                                )] = ???
    final def +[a, b, c, d, e, f, g                                             ] (nextMolecule: NS07[a, b, c, d, e, f, g                                             ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g                                             )] = ???
    final def +[a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS08[a, b, c, d, e, f, g, h                                          ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS09[a, b, c, d, e, f, g, h, i                                       ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    final def +[I1                                                                  ] (nextMolecule: IN1_00[I1                                                                  ]): Composite_In_1_01[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N)                                                                    ] = ???
    final def +[I1, a                                                               ] (nextMolecule: IN1_01[I1, a                                                               ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), a                                                                 ] = ???
    final def +[I1, a, b                                                            ] (nextMolecule: IN1_02[I1, a, b                                                            ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b                                                            )] = ???
    final def +[I1, a, b, c                                                         ] (nextMolecule: IN1_03[I1, a, b, c                                                         ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c                                                         )] = ???
    final def +[I1, a, b, c, d                                                      ] (nextMolecule: IN1_04[I1, a, b, c, d                                                      ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d                                                      )] = ???
    final def +[I1, a, b, c, d, e                                                   ] (nextMolecule: IN1_05[I1, a, b, c, d, e                                                   ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e                                                   )] = ???
    final def +[I1, a, b, c, d, e, f                                                ] (nextMolecule: IN1_06[I1, a, b, c, d, e, f                                                ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f                                                )] = ???
    final def +[I1, a, b, c, d, e, f, g                                             ] (nextMolecule: IN1_07[I1, a, b, c, d, e, f, g                                             ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g                                             )] = ???
    final def +[I1, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN1_08[I1, a, b, c, d, e, f, g, h                                          ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN1_09[I1, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN1_10[I1, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN1_11[I1, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN1_12[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN1_13[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN1_14[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN1_15[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN1_16[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN1_17[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN1_18[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN1_19[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN1_20[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN1_21[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN1_22[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    final def +[I1, I2                                                                  ] (nextMolecule: IN2_00[I1, I2                                                                  ]): Composite_In_2_01[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N)                                                                    ] = ???
    final def +[I1, I2, a                                                               ] (nextMolecule: IN2_01[I1, I2, a                                                               ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), a                                                                 ] = ???
    final def +[I1, I2, a, b                                                            ] (nextMolecule: IN2_02[I1, I2, a, b                                                            ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b                                                            )] = ???
    final def +[I1, I2, a, b, c                                                         ] (nextMolecule: IN2_03[I1, I2, a, b, c                                                         ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c                                                         )] = ???
    final def +[I1, I2, a, b, c, d                                                      ] (nextMolecule: IN2_04[I1, I2, a, b, c, d                                                      ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d                                                      )] = ???
    final def +[I1, I2, a, b, c, d, e                                                   ] (nextMolecule: IN2_05[I1, I2, a, b, c, d, e                                                   ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e                                                   )] = ???
    final def +[I1, I2, a, b, c, d, e, f                                                ] (nextMolecule: IN2_06[I1, I2, a, b, c, d, e, f                                                ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f                                                )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g                                             ] (nextMolecule: IN2_07[I1, I2, a, b, c, d, e, f, g                                             ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g                                             )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN2_08[I1, I2, a, b, c, d, e, f, g, h                                          ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN2_09[I1, I2, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN2_10[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN2_11[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN2_12[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN2_13[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN2_14[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN2_15[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN2_16[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN2_17[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN2_18[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN2_19[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN2_20[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN2_21[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN2_22[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    final def +[I1, I2, I3                                                                  ] (nextMolecule: IN3_00[I1, I2, I3                                                                  ]): Composite_In_3_01[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N)                                                                    ] = ???
    final def +[I1, I2, I3, a                                                               ] (nextMolecule: IN3_01[I1, I2, I3, a                                                               ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), a                                                                 ] = ???
    final def +[I1, I2, I3, a, b                                                            ] (nextMolecule: IN3_02[I1, I2, I3, a, b                                                            ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b                                                            )] = ???
    final def +[I1, I2, I3, a, b, c                                                         ] (nextMolecule: IN3_03[I1, I2, I3, a, b, c                                                         ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c                                                         )] = ???
    final def +[I1, I2, I3, a, b, c, d                                                      ] (nextMolecule: IN3_04[I1, I2, I3, a, b, c, d                                                      ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d                                                      )] = ???
    final def +[I1, I2, I3, a, b, c, d, e                                                   ] (nextMolecule: IN3_05[I1, I2, I3, a, b, c, d, e                                                   ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e                                                   )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f                                                ] (nextMolecule: IN3_06[I1, I2, I3, a, b, c, d, e, f                                                ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f                                                )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g                                             ] (nextMolecule: IN3_07[I1, I2, I3, a, b, c, d, e, f, g                                             ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g                                             )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN3_08[I1, I2, I3, a, b, c, d, e, f, g, h                                          ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN3_09[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN3_10[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN3_11[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN3_12[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN3_13[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN3_14[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN3_15[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN3_16[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN3_17[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN3_18[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN3_19[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN3_20[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN3_21[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN3_22[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait CompositeInit15[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O] extends CompositeInit {
    final def +[x                                                               ] (nextMolecule: NS00[x                                                               ]): Composite01[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O)                                                                    ] = ???
    final def +[a                                                               ] (nextMolecule: NS01[a                                                               ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), a                                                                 ] = ???
    final def +[a, b                                                            ] (nextMolecule: NS02[a, b                                                            ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b                                                            )] = ???
    final def +[a, b, c                                                         ] (nextMolecule: NS03[a, b, c                                                         ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c                                                         )] = ???
    final def +[a, b, c, d                                                      ] (nextMolecule: NS04[a, b, c, d                                                      ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d                                                      )] = ???
    final def +[a, b, c, d, e                                                   ] (nextMolecule: NS05[a, b, c, d, e                                                   ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e                                                   )] = ???
    final def +[a, b, c, d, e, f                                                ] (nextMolecule: NS06[a, b, c, d, e, f                                                ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f                                                )] = ???
    final def +[a, b, c, d, e, f, g                                             ] (nextMolecule: NS07[a, b, c, d, e, f, g                                             ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g                                             )] = ???
    final def +[a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS08[a, b, c, d, e, f, g, h                                          ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS09[a, b, c, d, e, f, g, h, i                                       ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    final def +[I1                                                                  ] (nextMolecule: IN1_00[I1                                                                  ]): Composite_In_1_01[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O)                                                                    ] = ???
    final def +[I1, a                                                               ] (nextMolecule: IN1_01[I1, a                                                               ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), a                                                                 ] = ???
    final def +[I1, a, b                                                            ] (nextMolecule: IN1_02[I1, a, b                                                            ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b                                                            )] = ???
    final def +[I1, a, b, c                                                         ] (nextMolecule: IN1_03[I1, a, b, c                                                         ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c                                                         )] = ???
    final def +[I1, a, b, c, d                                                      ] (nextMolecule: IN1_04[I1, a, b, c, d                                                      ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d                                                      )] = ???
    final def +[I1, a, b, c, d, e                                                   ] (nextMolecule: IN1_05[I1, a, b, c, d, e                                                   ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e                                                   )] = ???
    final def +[I1, a, b, c, d, e, f                                                ] (nextMolecule: IN1_06[I1, a, b, c, d, e, f                                                ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f                                                )] = ???
    final def +[I1, a, b, c, d, e, f, g                                             ] (nextMolecule: IN1_07[I1, a, b, c, d, e, f, g                                             ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g                                             )] = ???
    final def +[I1, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN1_08[I1, a, b, c, d, e, f, g, h                                          ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN1_09[I1, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN1_10[I1, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN1_11[I1, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN1_12[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN1_13[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN1_14[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN1_15[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN1_16[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN1_17[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN1_18[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN1_19[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN1_20[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN1_21[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN1_22[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    final def +[I1, I2                                                                  ] (nextMolecule: IN2_00[I1, I2                                                                  ]): Composite_In_2_01[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O)                                                                    ] = ???
    final def +[I1, I2, a                                                               ] (nextMolecule: IN2_01[I1, I2, a                                                               ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), a                                                                 ] = ???
    final def +[I1, I2, a, b                                                            ] (nextMolecule: IN2_02[I1, I2, a, b                                                            ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b                                                            )] = ???
    final def +[I1, I2, a, b, c                                                         ] (nextMolecule: IN2_03[I1, I2, a, b, c                                                         ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c                                                         )] = ???
    final def +[I1, I2, a, b, c, d                                                      ] (nextMolecule: IN2_04[I1, I2, a, b, c, d                                                      ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d                                                      )] = ???
    final def +[I1, I2, a, b, c, d, e                                                   ] (nextMolecule: IN2_05[I1, I2, a, b, c, d, e                                                   ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e                                                   )] = ???
    final def +[I1, I2, a, b, c, d, e, f                                                ] (nextMolecule: IN2_06[I1, I2, a, b, c, d, e, f                                                ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f                                                )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g                                             ] (nextMolecule: IN2_07[I1, I2, a, b, c, d, e, f, g                                             ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g                                             )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN2_08[I1, I2, a, b, c, d, e, f, g, h                                          ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN2_09[I1, I2, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN2_10[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN2_11[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN2_12[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN2_13[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN2_14[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN2_15[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN2_16[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN2_17[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN2_18[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN2_19[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN2_20[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN2_21[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN2_22[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    final def +[I1, I2, I3                                                                  ] (nextMolecule: IN3_00[I1, I2, I3                                                                  ]): Composite_In_3_01[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O)                                                                    ] = ???
    final def +[I1, I2, I3, a                                                               ] (nextMolecule: IN3_01[I1, I2, I3, a                                                               ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), a                                                                 ] = ???
    final def +[I1, I2, I3, a, b                                                            ] (nextMolecule: IN3_02[I1, I2, I3, a, b                                                            ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b                                                            )] = ???
    final def +[I1, I2, I3, a, b, c                                                         ] (nextMolecule: IN3_03[I1, I2, I3, a, b, c                                                         ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c                                                         )] = ???
    final def +[I1, I2, I3, a, b, c, d                                                      ] (nextMolecule: IN3_04[I1, I2, I3, a, b, c, d                                                      ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d                                                      )] = ???
    final def +[I1, I2, I3, a, b, c, d, e                                                   ] (nextMolecule: IN3_05[I1, I2, I3, a, b, c, d, e                                                   ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e                                                   )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f                                                ] (nextMolecule: IN3_06[I1, I2, I3, a, b, c, d, e, f                                                ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f                                                )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g                                             ] (nextMolecule: IN3_07[I1, I2, I3, a, b, c, d, e, f, g                                             ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g                                             )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN3_08[I1, I2, I3, a, b, c, d, e, f, g, h                                          ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN3_09[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN3_10[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN3_11[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN3_12[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN3_13[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN3_14[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN3_15[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN3_16[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN3_17[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN3_18[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN3_19[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN3_20[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN3_21[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN3_22[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait CompositeInit16[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P] extends CompositeInit {
    final def +[x                                                               ] (nextMolecule: NS00[x                                                               ]): Composite01[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P)                                                                    ] = ???
    final def +[a                                                               ] (nextMolecule: NS01[a                                                               ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), a                                                                 ] = ???
    final def +[a, b                                                            ] (nextMolecule: NS02[a, b                                                            ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b                                                            )] = ???
    final def +[a, b, c                                                         ] (nextMolecule: NS03[a, b, c                                                         ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c                                                         )] = ???
    final def +[a, b, c, d                                                      ] (nextMolecule: NS04[a, b, c, d                                                      ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d                                                      )] = ???
    final def +[a, b, c, d, e                                                   ] (nextMolecule: NS05[a, b, c, d, e                                                   ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e                                                   )] = ???
    final def +[a, b, c, d, e, f                                                ] (nextMolecule: NS06[a, b, c, d, e, f                                                ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f                                                )] = ???
    final def +[a, b, c, d, e, f, g                                             ] (nextMolecule: NS07[a, b, c, d, e, f, g                                             ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g                                             )] = ???
    final def +[a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS08[a, b, c, d, e, f, g, h                                          ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS09[a, b, c, d, e, f, g, h, i                                       ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    final def +[I1                                                                  ] (nextMolecule: IN1_00[I1                                                                  ]): Composite_In_1_01[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P)                                                                    ] = ???
    final def +[I1, a                                                               ] (nextMolecule: IN1_01[I1, a                                                               ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), a                                                                 ] = ???
    final def +[I1, a, b                                                            ] (nextMolecule: IN1_02[I1, a, b                                                            ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b                                                            )] = ???
    final def +[I1, a, b, c                                                         ] (nextMolecule: IN1_03[I1, a, b, c                                                         ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c                                                         )] = ???
    final def +[I1, a, b, c, d                                                      ] (nextMolecule: IN1_04[I1, a, b, c, d                                                      ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d                                                      )] = ???
    final def +[I1, a, b, c, d, e                                                   ] (nextMolecule: IN1_05[I1, a, b, c, d, e                                                   ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e                                                   )] = ???
    final def +[I1, a, b, c, d, e, f                                                ] (nextMolecule: IN1_06[I1, a, b, c, d, e, f                                                ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f                                                )] = ???
    final def +[I1, a, b, c, d, e, f, g                                             ] (nextMolecule: IN1_07[I1, a, b, c, d, e, f, g                                             ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g                                             )] = ???
    final def +[I1, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN1_08[I1, a, b, c, d, e, f, g, h                                          ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN1_09[I1, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN1_10[I1, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN1_11[I1, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN1_12[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN1_13[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN1_14[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN1_15[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN1_16[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN1_17[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN1_18[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN1_19[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN1_20[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN1_21[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN1_22[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    final def +[I1, I2                                                                  ] (nextMolecule: IN2_00[I1, I2                                                                  ]): Composite_In_2_01[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P)                                                                    ] = ???
    final def +[I1, I2, a                                                               ] (nextMolecule: IN2_01[I1, I2, a                                                               ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), a                                                                 ] = ???
    final def +[I1, I2, a, b                                                            ] (nextMolecule: IN2_02[I1, I2, a, b                                                            ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b                                                            )] = ???
    final def +[I1, I2, a, b, c                                                         ] (nextMolecule: IN2_03[I1, I2, a, b, c                                                         ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c                                                         )] = ???
    final def +[I1, I2, a, b, c, d                                                      ] (nextMolecule: IN2_04[I1, I2, a, b, c, d                                                      ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d                                                      )] = ???
    final def +[I1, I2, a, b, c, d, e                                                   ] (nextMolecule: IN2_05[I1, I2, a, b, c, d, e                                                   ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e                                                   )] = ???
    final def +[I1, I2, a, b, c, d, e, f                                                ] (nextMolecule: IN2_06[I1, I2, a, b, c, d, e, f                                                ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f                                                )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g                                             ] (nextMolecule: IN2_07[I1, I2, a, b, c, d, e, f, g                                             ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g                                             )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN2_08[I1, I2, a, b, c, d, e, f, g, h                                          ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN2_09[I1, I2, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN2_10[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN2_11[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN2_12[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN2_13[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN2_14[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN2_15[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN2_16[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN2_17[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN2_18[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN2_19[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN2_20[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN2_21[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN2_22[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    final def +[I1, I2, I3                                                                  ] (nextMolecule: IN3_00[I1, I2, I3                                                                  ]): Composite_In_3_01[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P)                                                                    ] = ???
    final def +[I1, I2, I3, a                                                               ] (nextMolecule: IN3_01[I1, I2, I3, a                                                               ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), a                                                                 ] = ???
    final def +[I1, I2, I3, a, b                                                            ] (nextMolecule: IN3_02[I1, I2, I3, a, b                                                            ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b                                                            )] = ???
    final def +[I1, I2, I3, a, b, c                                                         ] (nextMolecule: IN3_03[I1, I2, I3, a, b, c                                                         ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c                                                         )] = ???
    final def +[I1, I2, I3, a, b, c, d                                                      ] (nextMolecule: IN3_04[I1, I2, I3, a, b, c, d                                                      ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d                                                      )] = ???
    final def +[I1, I2, I3, a, b, c, d, e                                                   ] (nextMolecule: IN3_05[I1, I2, I3, a, b, c, d, e                                                   ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e                                                   )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f                                                ] (nextMolecule: IN3_06[I1, I2, I3, a, b, c, d, e, f                                                ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f                                                )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g                                             ] (nextMolecule: IN3_07[I1, I2, I3, a, b, c, d, e, f, g                                             ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g                                             )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN3_08[I1, I2, I3, a, b, c, d, e, f, g, h                                          ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN3_09[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN3_10[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN3_11[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN3_12[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN3_13[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN3_14[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN3_15[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN3_16[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN3_17[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN3_18[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN3_19[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN3_20[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN3_21[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN3_22[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait CompositeInit17[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q] extends CompositeInit {
    final def +[x                                                               ] (nextMolecule: NS00[x                                                               ]): Composite01[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q)                                                                    ] = ???
    final def +[a                                                               ] (nextMolecule: NS01[a                                                               ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), a                                                                 ] = ???
    final def +[a, b                                                            ] (nextMolecule: NS02[a, b                                                            ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b                                                            )] = ???
    final def +[a, b, c                                                         ] (nextMolecule: NS03[a, b, c                                                         ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c                                                         )] = ???
    final def +[a, b, c, d                                                      ] (nextMolecule: NS04[a, b, c, d                                                      ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d                                                      )] = ???
    final def +[a, b, c, d, e                                                   ] (nextMolecule: NS05[a, b, c, d, e                                                   ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e                                                   )] = ???
    final def +[a, b, c, d, e, f                                                ] (nextMolecule: NS06[a, b, c, d, e, f                                                ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f                                                )] = ???
    final def +[a, b, c, d, e, f, g                                             ] (nextMolecule: NS07[a, b, c, d, e, f, g                                             ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g                                             )] = ???
    final def +[a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS08[a, b, c, d, e, f, g, h                                          ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS09[a, b, c, d, e, f, g, h, i                                       ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    final def +[I1                                                                  ] (nextMolecule: IN1_00[I1                                                                  ]): Composite_In_1_01[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q)                                                                    ] = ???
    final def +[I1, a                                                               ] (nextMolecule: IN1_01[I1, a                                                               ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), a                                                                 ] = ???
    final def +[I1, a, b                                                            ] (nextMolecule: IN1_02[I1, a, b                                                            ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b                                                            )] = ???
    final def +[I1, a, b, c                                                         ] (nextMolecule: IN1_03[I1, a, b, c                                                         ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c                                                         )] = ???
    final def +[I1, a, b, c, d                                                      ] (nextMolecule: IN1_04[I1, a, b, c, d                                                      ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d                                                      )] = ???
    final def +[I1, a, b, c, d, e                                                   ] (nextMolecule: IN1_05[I1, a, b, c, d, e                                                   ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e                                                   )] = ???
    final def +[I1, a, b, c, d, e, f                                                ] (nextMolecule: IN1_06[I1, a, b, c, d, e, f                                                ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f                                                )] = ???
    final def +[I1, a, b, c, d, e, f, g                                             ] (nextMolecule: IN1_07[I1, a, b, c, d, e, f, g                                             ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g                                             )] = ???
    final def +[I1, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN1_08[I1, a, b, c, d, e, f, g, h                                          ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN1_09[I1, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN1_10[I1, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN1_11[I1, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN1_12[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN1_13[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN1_14[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN1_15[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN1_16[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN1_17[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN1_18[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN1_19[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN1_20[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN1_21[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN1_22[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    final def +[I1, I2                                                                  ] (nextMolecule: IN2_00[I1, I2                                                                  ]): Composite_In_2_01[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q)                                                                    ] = ???
    final def +[I1, I2, a                                                               ] (nextMolecule: IN2_01[I1, I2, a                                                               ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), a                                                                 ] = ???
    final def +[I1, I2, a, b                                                            ] (nextMolecule: IN2_02[I1, I2, a, b                                                            ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b                                                            )] = ???
    final def +[I1, I2, a, b, c                                                         ] (nextMolecule: IN2_03[I1, I2, a, b, c                                                         ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c                                                         )] = ???
    final def +[I1, I2, a, b, c, d                                                      ] (nextMolecule: IN2_04[I1, I2, a, b, c, d                                                      ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d                                                      )] = ???
    final def +[I1, I2, a, b, c, d, e                                                   ] (nextMolecule: IN2_05[I1, I2, a, b, c, d, e                                                   ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e                                                   )] = ???
    final def +[I1, I2, a, b, c, d, e, f                                                ] (nextMolecule: IN2_06[I1, I2, a, b, c, d, e, f                                                ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f                                                )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g                                             ] (nextMolecule: IN2_07[I1, I2, a, b, c, d, e, f, g                                             ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g                                             )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN2_08[I1, I2, a, b, c, d, e, f, g, h                                          ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN2_09[I1, I2, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN2_10[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN2_11[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN2_12[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN2_13[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN2_14[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN2_15[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN2_16[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN2_17[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN2_18[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN2_19[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN2_20[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN2_21[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN2_22[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    final def +[I1, I2, I3                                                                  ] (nextMolecule: IN3_00[I1, I2, I3                                                                  ]): Composite_In_3_01[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q)                                                                    ] = ???
    final def +[I1, I2, I3, a                                                               ] (nextMolecule: IN3_01[I1, I2, I3, a                                                               ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), a                                                                 ] = ???
    final def +[I1, I2, I3, a, b                                                            ] (nextMolecule: IN3_02[I1, I2, I3, a, b                                                            ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b                                                            )] = ???
    final def +[I1, I2, I3, a, b, c                                                         ] (nextMolecule: IN3_03[I1, I2, I3, a, b, c                                                         ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c                                                         )] = ???
    final def +[I1, I2, I3, a, b, c, d                                                      ] (nextMolecule: IN3_04[I1, I2, I3, a, b, c, d                                                      ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d                                                      )] = ???
    final def +[I1, I2, I3, a, b, c, d, e                                                   ] (nextMolecule: IN3_05[I1, I2, I3, a, b, c, d, e                                                   ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e                                                   )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f                                                ] (nextMolecule: IN3_06[I1, I2, I3, a, b, c, d, e, f                                                ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f                                                )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g                                             ] (nextMolecule: IN3_07[I1, I2, I3, a, b, c, d, e, f, g                                             ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g                                             )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN3_08[I1, I2, I3, a, b, c, d, e, f, g, h                                          ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN3_09[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN3_10[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN3_11[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN3_12[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN3_13[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN3_14[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN3_15[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN3_16[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN3_17[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN3_18[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN3_19[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN3_20[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN3_21[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN3_22[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait CompositeInit18[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R] extends CompositeInit {
    final def +[x                                                               ] (nextMolecule: NS00[x                                                               ]): Composite01[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R)                                                                    ] = ???
    final def +[a                                                               ] (nextMolecule: NS01[a                                                               ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), a                                                                 ] = ???
    final def +[a, b                                                            ] (nextMolecule: NS02[a, b                                                            ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b                                                            )] = ???
    final def +[a, b, c                                                         ] (nextMolecule: NS03[a, b, c                                                         ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c                                                         )] = ???
    final def +[a, b, c, d                                                      ] (nextMolecule: NS04[a, b, c, d                                                      ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d                                                      )] = ???
    final def +[a, b, c, d, e                                                   ] (nextMolecule: NS05[a, b, c, d, e                                                   ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e                                                   )] = ???
    final def +[a, b, c, d, e, f                                                ] (nextMolecule: NS06[a, b, c, d, e, f                                                ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f                                                )] = ???
    final def +[a, b, c, d, e, f, g                                             ] (nextMolecule: NS07[a, b, c, d, e, f, g                                             ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g                                             )] = ???
    final def +[a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS08[a, b, c, d, e, f, g, h                                          ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS09[a, b, c, d, e, f, g, h, i                                       ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    final def +[I1                                                                  ] (nextMolecule: IN1_00[I1                                                                  ]): Composite_In_1_01[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R)                                                                    ] = ???
    final def +[I1, a                                                               ] (nextMolecule: IN1_01[I1, a                                                               ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), a                                                                 ] = ???
    final def +[I1, a, b                                                            ] (nextMolecule: IN1_02[I1, a, b                                                            ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b                                                            )] = ???
    final def +[I1, a, b, c                                                         ] (nextMolecule: IN1_03[I1, a, b, c                                                         ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c                                                         )] = ???
    final def +[I1, a, b, c, d                                                      ] (nextMolecule: IN1_04[I1, a, b, c, d                                                      ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d                                                      )] = ???
    final def +[I1, a, b, c, d, e                                                   ] (nextMolecule: IN1_05[I1, a, b, c, d, e                                                   ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e                                                   )] = ???
    final def +[I1, a, b, c, d, e, f                                                ] (nextMolecule: IN1_06[I1, a, b, c, d, e, f                                                ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f                                                )] = ???
    final def +[I1, a, b, c, d, e, f, g                                             ] (nextMolecule: IN1_07[I1, a, b, c, d, e, f, g                                             ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g                                             )] = ???
    final def +[I1, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN1_08[I1, a, b, c, d, e, f, g, h                                          ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN1_09[I1, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN1_10[I1, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN1_11[I1, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN1_12[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN1_13[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN1_14[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN1_15[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN1_16[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN1_17[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN1_18[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN1_19[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN1_20[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN1_21[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN1_22[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    final def +[I1, I2                                                                  ] (nextMolecule: IN2_00[I1, I2                                                                  ]): Composite_In_2_01[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R)                                                                    ] = ???
    final def +[I1, I2, a                                                               ] (nextMolecule: IN2_01[I1, I2, a                                                               ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), a                                                                 ] = ???
    final def +[I1, I2, a, b                                                            ] (nextMolecule: IN2_02[I1, I2, a, b                                                            ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b                                                            )] = ???
    final def +[I1, I2, a, b, c                                                         ] (nextMolecule: IN2_03[I1, I2, a, b, c                                                         ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c                                                         )] = ???
    final def +[I1, I2, a, b, c, d                                                      ] (nextMolecule: IN2_04[I1, I2, a, b, c, d                                                      ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d                                                      )] = ???
    final def +[I1, I2, a, b, c, d, e                                                   ] (nextMolecule: IN2_05[I1, I2, a, b, c, d, e                                                   ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e                                                   )] = ???
    final def +[I1, I2, a, b, c, d, e, f                                                ] (nextMolecule: IN2_06[I1, I2, a, b, c, d, e, f                                                ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f                                                )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g                                             ] (nextMolecule: IN2_07[I1, I2, a, b, c, d, e, f, g                                             ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g                                             )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN2_08[I1, I2, a, b, c, d, e, f, g, h                                          ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN2_09[I1, I2, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN2_10[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN2_11[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN2_12[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN2_13[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN2_14[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN2_15[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN2_16[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN2_17[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN2_18[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN2_19[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN2_20[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN2_21[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN2_22[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    final def +[I1, I2, I3                                                                  ] (nextMolecule: IN3_00[I1, I2, I3                                                                  ]): Composite_In_3_01[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R)                                                                    ] = ???
    final def +[I1, I2, I3, a                                                               ] (nextMolecule: IN3_01[I1, I2, I3, a                                                               ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), a                                                                 ] = ???
    final def +[I1, I2, I3, a, b                                                            ] (nextMolecule: IN3_02[I1, I2, I3, a, b                                                            ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b                                                            )] = ???
    final def +[I1, I2, I3, a, b, c                                                         ] (nextMolecule: IN3_03[I1, I2, I3, a, b, c                                                         ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c                                                         )] = ???
    final def +[I1, I2, I3, a, b, c, d                                                      ] (nextMolecule: IN3_04[I1, I2, I3, a, b, c, d                                                      ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d                                                      )] = ???
    final def +[I1, I2, I3, a, b, c, d, e                                                   ] (nextMolecule: IN3_05[I1, I2, I3, a, b, c, d, e                                                   ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e                                                   )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f                                                ] (nextMolecule: IN3_06[I1, I2, I3, a, b, c, d, e, f                                                ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f                                                )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g                                             ] (nextMolecule: IN3_07[I1, I2, I3, a, b, c, d, e, f, g                                             ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g                                             )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN3_08[I1, I2, I3, a, b, c, d, e, f, g, h                                          ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN3_09[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN3_10[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN3_11[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN3_12[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN3_13[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN3_14[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN3_15[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN3_16[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN3_17[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN3_18[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN3_19[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN3_20[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN3_21[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN3_22[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait CompositeInit19[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S] extends CompositeInit {
    final def +[x                                                               ] (nextMolecule: NS00[x                                                               ]): Composite01[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S)                                                                    ] = ???
    final def +[a                                                               ] (nextMolecule: NS01[a                                                               ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), a                                                                 ] = ???
    final def +[a, b                                                            ] (nextMolecule: NS02[a, b                                                            ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b                                                            )] = ???
    final def +[a, b, c                                                         ] (nextMolecule: NS03[a, b, c                                                         ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c                                                         )] = ???
    final def +[a, b, c, d                                                      ] (nextMolecule: NS04[a, b, c, d                                                      ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d                                                      )] = ???
    final def +[a, b, c, d, e                                                   ] (nextMolecule: NS05[a, b, c, d, e                                                   ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e                                                   )] = ???
    final def +[a, b, c, d, e, f                                                ] (nextMolecule: NS06[a, b, c, d, e, f                                                ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f                                                )] = ???
    final def +[a, b, c, d, e, f, g                                             ] (nextMolecule: NS07[a, b, c, d, e, f, g                                             ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g                                             )] = ???
    final def +[a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS08[a, b, c, d, e, f, g, h                                          ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS09[a, b, c, d, e, f, g, h, i                                       ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    final def +[I1                                                                  ] (nextMolecule: IN1_00[I1                                                                  ]): Composite_In_1_01[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S)                                                                    ] = ???
    final def +[I1, a                                                               ] (nextMolecule: IN1_01[I1, a                                                               ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), a                                                                 ] = ???
    final def +[I1, a, b                                                            ] (nextMolecule: IN1_02[I1, a, b                                                            ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b                                                            )] = ???
    final def +[I1, a, b, c                                                         ] (nextMolecule: IN1_03[I1, a, b, c                                                         ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c                                                         )] = ???
    final def +[I1, a, b, c, d                                                      ] (nextMolecule: IN1_04[I1, a, b, c, d                                                      ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d                                                      )] = ???
    final def +[I1, a, b, c, d, e                                                   ] (nextMolecule: IN1_05[I1, a, b, c, d, e                                                   ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e                                                   )] = ???
    final def +[I1, a, b, c, d, e, f                                                ] (nextMolecule: IN1_06[I1, a, b, c, d, e, f                                                ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f                                                )] = ???
    final def +[I1, a, b, c, d, e, f, g                                             ] (nextMolecule: IN1_07[I1, a, b, c, d, e, f, g                                             ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g                                             )] = ???
    final def +[I1, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN1_08[I1, a, b, c, d, e, f, g, h                                          ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN1_09[I1, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN1_10[I1, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN1_11[I1, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN1_12[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN1_13[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN1_14[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN1_15[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN1_16[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN1_17[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN1_18[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN1_19[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN1_20[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN1_21[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN1_22[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    final def +[I1, I2                                                                  ] (nextMolecule: IN2_00[I1, I2                                                                  ]): Composite_In_2_01[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S)                                                                    ] = ???
    final def +[I1, I2, a                                                               ] (nextMolecule: IN2_01[I1, I2, a                                                               ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), a                                                                 ] = ???
    final def +[I1, I2, a, b                                                            ] (nextMolecule: IN2_02[I1, I2, a, b                                                            ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b                                                            )] = ???
    final def +[I1, I2, a, b, c                                                         ] (nextMolecule: IN2_03[I1, I2, a, b, c                                                         ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c                                                         )] = ???
    final def +[I1, I2, a, b, c, d                                                      ] (nextMolecule: IN2_04[I1, I2, a, b, c, d                                                      ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d                                                      )] = ???
    final def +[I1, I2, a, b, c, d, e                                                   ] (nextMolecule: IN2_05[I1, I2, a, b, c, d, e                                                   ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e                                                   )] = ???
    final def +[I1, I2, a, b, c, d, e, f                                                ] (nextMolecule: IN2_06[I1, I2, a, b, c, d, e, f                                                ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f                                                )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g                                             ] (nextMolecule: IN2_07[I1, I2, a, b, c, d, e, f, g                                             ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g                                             )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN2_08[I1, I2, a, b, c, d, e, f, g, h                                          ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN2_09[I1, I2, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN2_10[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN2_11[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN2_12[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN2_13[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN2_14[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN2_15[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN2_16[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN2_17[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN2_18[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN2_19[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN2_20[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN2_21[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN2_22[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    final def +[I1, I2, I3                                                                  ] (nextMolecule: IN3_00[I1, I2, I3                                                                  ]): Composite_In_3_01[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S)                                                                    ] = ???
    final def +[I1, I2, I3, a                                                               ] (nextMolecule: IN3_01[I1, I2, I3, a                                                               ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), a                                                                 ] = ???
    final def +[I1, I2, I3, a, b                                                            ] (nextMolecule: IN3_02[I1, I2, I3, a, b                                                            ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b                                                            )] = ???
    final def +[I1, I2, I3, a, b, c                                                         ] (nextMolecule: IN3_03[I1, I2, I3, a, b, c                                                         ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c                                                         )] = ???
    final def +[I1, I2, I3, a, b, c, d                                                      ] (nextMolecule: IN3_04[I1, I2, I3, a, b, c, d                                                      ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d                                                      )] = ???
    final def +[I1, I2, I3, a, b, c, d, e                                                   ] (nextMolecule: IN3_05[I1, I2, I3, a, b, c, d, e                                                   ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e                                                   )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f                                                ] (nextMolecule: IN3_06[I1, I2, I3, a, b, c, d, e, f                                                ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f                                                )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g                                             ] (nextMolecule: IN3_07[I1, I2, I3, a, b, c, d, e, f, g                                             ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g                                             )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN3_08[I1, I2, I3, a, b, c, d, e, f, g, h                                          ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN3_09[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN3_10[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN3_11[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN3_12[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN3_13[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN3_14[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN3_15[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN3_16[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN3_17[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN3_18[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN3_19[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN3_20[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN3_21[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN3_22[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait CompositeInit20[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T] extends CompositeInit {
    final def +[x                                                               ] (nextMolecule: NS00[x                                                               ]): Composite01[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T)                                                                    ] = ???
    final def +[a                                                               ] (nextMolecule: NS01[a                                                               ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), a                                                                 ] = ???
    final def +[a, b                                                            ] (nextMolecule: NS02[a, b                                                            ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b                                                            )] = ???
    final def +[a, b, c                                                         ] (nextMolecule: NS03[a, b, c                                                         ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c                                                         )] = ???
    final def +[a, b, c, d                                                      ] (nextMolecule: NS04[a, b, c, d                                                      ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d                                                      )] = ???
    final def +[a, b, c, d, e                                                   ] (nextMolecule: NS05[a, b, c, d, e                                                   ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e                                                   )] = ???
    final def +[a, b, c, d, e, f                                                ] (nextMolecule: NS06[a, b, c, d, e, f                                                ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f                                                )] = ???
    final def +[a, b, c, d, e, f, g                                             ] (nextMolecule: NS07[a, b, c, d, e, f, g                                             ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g                                             )] = ???
    final def +[a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS08[a, b, c, d, e, f, g, h                                          ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS09[a, b, c, d, e, f, g, h, i                                       ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    final def +[I1                                                                  ] (nextMolecule: IN1_00[I1                                                                  ]): Composite_In_1_01[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T)                                                                    ] = ???
    final def +[I1, a                                                               ] (nextMolecule: IN1_01[I1, a                                                               ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), a                                                                 ] = ???
    final def +[I1, a, b                                                            ] (nextMolecule: IN1_02[I1, a, b                                                            ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b                                                            )] = ???
    final def +[I1, a, b, c                                                         ] (nextMolecule: IN1_03[I1, a, b, c                                                         ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c                                                         )] = ???
    final def +[I1, a, b, c, d                                                      ] (nextMolecule: IN1_04[I1, a, b, c, d                                                      ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d                                                      )] = ???
    final def +[I1, a, b, c, d, e                                                   ] (nextMolecule: IN1_05[I1, a, b, c, d, e                                                   ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e                                                   )] = ???
    final def +[I1, a, b, c, d, e, f                                                ] (nextMolecule: IN1_06[I1, a, b, c, d, e, f                                                ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f                                                )] = ???
    final def +[I1, a, b, c, d, e, f, g                                             ] (nextMolecule: IN1_07[I1, a, b, c, d, e, f, g                                             ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g                                             )] = ???
    final def +[I1, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN1_08[I1, a, b, c, d, e, f, g, h                                          ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN1_09[I1, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN1_10[I1, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN1_11[I1, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN1_12[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN1_13[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN1_14[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN1_15[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN1_16[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN1_17[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN1_18[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN1_19[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN1_20[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN1_21[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN1_22[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    final def +[I1, I2                                                                  ] (nextMolecule: IN2_00[I1, I2                                                                  ]): Composite_In_2_01[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T)                                                                    ] = ???
    final def +[I1, I2, a                                                               ] (nextMolecule: IN2_01[I1, I2, a                                                               ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), a                                                                 ] = ???
    final def +[I1, I2, a, b                                                            ] (nextMolecule: IN2_02[I1, I2, a, b                                                            ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b                                                            )] = ???
    final def +[I1, I2, a, b, c                                                         ] (nextMolecule: IN2_03[I1, I2, a, b, c                                                         ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c                                                         )] = ???
    final def +[I1, I2, a, b, c, d                                                      ] (nextMolecule: IN2_04[I1, I2, a, b, c, d                                                      ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d                                                      )] = ???
    final def +[I1, I2, a, b, c, d, e                                                   ] (nextMolecule: IN2_05[I1, I2, a, b, c, d, e                                                   ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e                                                   )] = ???
    final def +[I1, I2, a, b, c, d, e, f                                                ] (nextMolecule: IN2_06[I1, I2, a, b, c, d, e, f                                                ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f                                                )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g                                             ] (nextMolecule: IN2_07[I1, I2, a, b, c, d, e, f, g                                             ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g                                             )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN2_08[I1, I2, a, b, c, d, e, f, g, h                                          ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN2_09[I1, I2, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN2_10[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN2_11[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN2_12[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN2_13[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN2_14[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN2_15[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN2_16[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN2_17[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN2_18[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN2_19[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN2_20[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN2_21[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN2_22[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    final def +[I1, I2, I3                                                                  ] (nextMolecule: IN3_00[I1, I2, I3                                                                  ]): Composite_In_3_01[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T)                                                                    ] = ???
    final def +[I1, I2, I3, a                                                               ] (nextMolecule: IN3_01[I1, I2, I3, a                                                               ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), a                                                                 ] = ???
    final def +[I1, I2, I3, a, b                                                            ] (nextMolecule: IN3_02[I1, I2, I3, a, b                                                            ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b                                                            )] = ???
    final def +[I1, I2, I3, a, b, c                                                         ] (nextMolecule: IN3_03[I1, I2, I3, a, b, c                                                         ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c                                                         )] = ???
    final def +[I1, I2, I3, a, b, c, d                                                      ] (nextMolecule: IN3_04[I1, I2, I3, a, b, c, d                                                      ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d                                                      )] = ???
    final def +[I1, I2, I3, a, b, c, d, e                                                   ] (nextMolecule: IN3_05[I1, I2, I3, a, b, c, d, e                                                   ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e                                                   )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f                                                ] (nextMolecule: IN3_06[I1, I2, I3, a, b, c, d, e, f                                                ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f                                                )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g                                             ] (nextMolecule: IN3_07[I1, I2, I3, a, b, c, d, e, f, g                                             ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g                                             )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN3_08[I1, I2, I3, a, b, c, d, e, f, g, h                                          ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN3_09[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN3_10[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN3_11[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN3_12[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN3_13[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN3_14[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN3_15[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN3_16[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN3_17[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN3_18[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN3_19[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN3_20[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN3_21[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN3_22[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait CompositeInit21[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U] extends CompositeInit {
    final def +[x                                                               ] (nextMolecule: NS00[x                                                               ]): Composite01[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U)                                                                    ] = ???
    final def +[a                                                               ] (nextMolecule: NS01[a                                                               ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), a                                                                 ] = ???
    final def +[a, b                                                            ] (nextMolecule: NS02[a, b                                                            ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b                                                            )] = ???
    final def +[a, b, c                                                         ] (nextMolecule: NS03[a, b, c                                                         ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c                                                         )] = ???
    final def +[a, b, c, d                                                      ] (nextMolecule: NS04[a, b, c, d                                                      ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d                                                      )] = ???
    final def +[a, b, c, d, e                                                   ] (nextMolecule: NS05[a, b, c, d, e                                                   ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e                                                   )] = ???
    final def +[a, b, c, d, e, f                                                ] (nextMolecule: NS06[a, b, c, d, e, f                                                ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f                                                )] = ???
    final def +[a, b, c, d, e, f, g                                             ] (nextMolecule: NS07[a, b, c, d, e, f, g                                             ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g                                             )] = ???
    final def +[a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS08[a, b, c, d, e, f, g, h                                          ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS09[a, b, c, d, e, f, g, h, i                                       ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    final def +[I1                                                                  ] (nextMolecule: IN1_00[I1                                                                  ]): Composite_In_1_01[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U)                                                                    ] = ???
    final def +[I1, a                                                               ] (nextMolecule: IN1_01[I1, a                                                               ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), a                                                                 ] = ???
    final def +[I1, a, b                                                            ] (nextMolecule: IN1_02[I1, a, b                                                            ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b                                                            )] = ???
    final def +[I1, a, b, c                                                         ] (nextMolecule: IN1_03[I1, a, b, c                                                         ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c                                                         )] = ???
    final def +[I1, a, b, c, d                                                      ] (nextMolecule: IN1_04[I1, a, b, c, d                                                      ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d                                                      )] = ???
    final def +[I1, a, b, c, d, e                                                   ] (nextMolecule: IN1_05[I1, a, b, c, d, e                                                   ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e                                                   )] = ???
    final def +[I1, a, b, c, d, e, f                                                ] (nextMolecule: IN1_06[I1, a, b, c, d, e, f                                                ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f                                                )] = ???
    final def +[I1, a, b, c, d, e, f, g                                             ] (nextMolecule: IN1_07[I1, a, b, c, d, e, f, g                                             ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g                                             )] = ???
    final def +[I1, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN1_08[I1, a, b, c, d, e, f, g, h                                          ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN1_09[I1, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN1_10[I1, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN1_11[I1, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN1_12[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN1_13[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN1_14[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN1_15[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN1_16[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN1_17[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN1_18[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN1_19[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN1_20[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN1_21[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN1_22[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    final def +[I1, I2                                                                  ] (nextMolecule: IN2_00[I1, I2                                                                  ]): Composite_In_2_01[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U)                                                                    ] = ???
    final def +[I1, I2, a                                                               ] (nextMolecule: IN2_01[I1, I2, a                                                               ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), a                                                                 ] = ???
    final def +[I1, I2, a, b                                                            ] (nextMolecule: IN2_02[I1, I2, a, b                                                            ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b                                                            )] = ???
    final def +[I1, I2, a, b, c                                                         ] (nextMolecule: IN2_03[I1, I2, a, b, c                                                         ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c                                                         )] = ???
    final def +[I1, I2, a, b, c, d                                                      ] (nextMolecule: IN2_04[I1, I2, a, b, c, d                                                      ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d                                                      )] = ???
    final def +[I1, I2, a, b, c, d, e                                                   ] (nextMolecule: IN2_05[I1, I2, a, b, c, d, e                                                   ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e                                                   )] = ???
    final def +[I1, I2, a, b, c, d, e, f                                                ] (nextMolecule: IN2_06[I1, I2, a, b, c, d, e, f                                                ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f                                                )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g                                             ] (nextMolecule: IN2_07[I1, I2, a, b, c, d, e, f, g                                             ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g                                             )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN2_08[I1, I2, a, b, c, d, e, f, g, h                                          ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN2_09[I1, I2, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN2_10[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN2_11[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN2_12[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN2_13[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN2_14[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN2_15[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN2_16[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN2_17[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN2_18[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN2_19[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN2_20[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN2_21[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN2_22[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    final def +[I1, I2, I3                                                                  ] (nextMolecule: IN3_00[I1, I2, I3                                                                  ]): Composite_In_3_01[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U)                                                                    ] = ???
    final def +[I1, I2, I3, a                                                               ] (nextMolecule: IN3_01[I1, I2, I3, a                                                               ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), a                                                                 ] = ???
    final def +[I1, I2, I3, a, b                                                            ] (nextMolecule: IN3_02[I1, I2, I3, a, b                                                            ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b                                                            )] = ???
    final def +[I1, I2, I3, a, b, c                                                         ] (nextMolecule: IN3_03[I1, I2, I3, a, b, c                                                         ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c                                                         )] = ???
    final def +[I1, I2, I3, a, b, c, d                                                      ] (nextMolecule: IN3_04[I1, I2, I3, a, b, c, d                                                      ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d                                                      )] = ???
    final def +[I1, I2, I3, a, b, c, d, e                                                   ] (nextMolecule: IN3_05[I1, I2, I3, a, b, c, d, e                                                   ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e                                                   )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f                                                ] (nextMolecule: IN3_06[I1, I2, I3, a, b, c, d, e, f                                                ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f                                                )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g                                             ] (nextMolecule: IN3_07[I1, I2, I3, a, b, c, d, e, f, g                                             ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g                                             )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN3_08[I1, I2, I3, a, b, c, d, e, f, g, h                                          ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN3_09[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN3_10[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN3_11[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN3_12[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN3_13[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN3_14[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN3_15[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN3_16[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN3_17[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN3_18[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN3_19[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN3_20[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN3_21[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN3_22[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait CompositeInit22[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V] extends CompositeInit {
    final def +[x                                                               ] (nextMolecule: NS00[x                                                               ]): Composite01[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V)                                                                    ] = ???
    final def +[a                                                               ] (nextMolecule: NS01[a                                                               ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), a                                                                 ] = ???
    final def +[a, b                                                            ] (nextMolecule: NS02[a, b                                                            ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b                                                            )] = ???
    final def +[a, b, c                                                         ] (nextMolecule: NS03[a, b, c                                                         ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c                                                         )] = ???
    final def +[a, b, c, d                                                      ] (nextMolecule: NS04[a, b, c, d                                                      ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d                                                      )] = ???
    final def +[a, b, c, d, e                                                   ] (nextMolecule: NS05[a, b, c, d, e                                                   ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e                                                   )] = ???
    final def +[a, b, c, d, e, f                                                ] (nextMolecule: NS06[a, b, c, d, e, f                                                ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f                                                )] = ???
    final def +[a, b, c, d, e, f, g                                             ] (nextMolecule: NS07[a, b, c, d, e, f, g                                             ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g                                             )] = ???
    final def +[a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS08[a, b, c, d, e, f, g, h                                          ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS09[a, b, c, d, e, f, g, h, i                                       ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    final def +[I1                                                                  ] (nextMolecule: IN1_00[I1                                                                  ]): Composite_In_1_01[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V)                                                                    ] = ???
    final def +[I1, a                                                               ] (nextMolecule: IN1_01[I1, a                                                               ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), a                                                                 ] = ???
    final def +[I1, a, b                                                            ] (nextMolecule: IN1_02[I1, a, b                                                            ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b                                                            )] = ???
    final def +[I1, a, b, c                                                         ] (nextMolecule: IN1_03[I1, a, b, c                                                         ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c                                                         )] = ???
    final def +[I1, a, b, c, d                                                      ] (nextMolecule: IN1_04[I1, a, b, c, d                                                      ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d                                                      )] = ???
    final def +[I1, a, b, c, d, e                                                   ] (nextMolecule: IN1_05[I1, a, b, c, d, e                                                   ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e                                                   )] = ???
    final def +[I1, a, b, c, d, e, f                                                ] (nextMolecule: IN1_06[I1, a, b, c, d, e, f                                                ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f                                                )] = ???
    final def +[I1, a, b, c, d, e, f, g                                             ] (nextMolecule: IN1_07[I1, a, b, c, d, e, f, g                                             ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g                                             )] = ???
    final def +[I1, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN1_08[I1, a, b, c, d, e, f, g, h                                          ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN1_09[I1, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN1_10[I1, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN1_11[I1, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN1_12[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN1_13[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN1_14[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN1_15[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN1_16[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN1_17[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN1_18[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN1_19[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN1_20[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN1_21[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN1_22[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_1_02[I1, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    final def +[I1, I2                                                                  ] (nextMolecule: IN2_00[I1, I2                                                                  ]): Composite_In_2_01[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V)                                                                    ] = ???
    final def +[I1, I2, a                                                               ] (nextMolecule: IN2_01[I1, I2, a                                                               ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), a                                                                 ] = ???
    final def +[I1, I2, a, b                                                            ] (nextMolecule: IN2_02[I1, I2, a, b                                                            ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b                                                            )] = ???
    final def +[I1, I2, a, b, c                                                         ] (nextMolecule: IN2_03[I1, I2, a, b, c                                                         ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c                                                         )] = ???
    final def +[I1, I2, a, b, c, d                                                      ] (nextMolecule: IN2_04[I1, I2, a, b, c, d                                                      ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d                                                      )] = ???
    final def +[I1, I2, a, b, c, d, e                                                   ] (nextMolecule: IN2_05[I1, I2, a, b, c, d, e                                                   ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e                                                   )] = ???
    final def +[I1, I2, a, b, c, d, e, f                                                ] (nextMolecule: IN2_06[I1, I2, a, b, c, d, e, f                                                ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f                                                )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g                                             ] (nextMolecule: IN2_07[I1, I2, a, b, c, d, e, f, g                                             ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g                                             )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN2_08[I1, I2, a, b, c, d, e, f, g, h                                          ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN2_09[I1, I2, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN2_10[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN2_11[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN2_12[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN2_13[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN2_14[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN2_15[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN2_16[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN2_17[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN2_18[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN2_19[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN2_20[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN2_21[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN2_22[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    final def +[I1, I2, I3                                                                  ] (nextMolecule: IN3_00[I1, I2, I3                                                                  ]): Composite_In_3_01[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V)                                                                    ] = ???
    final def +[I1, I2, I3, a                                                               ] (nextMolecule: IN3_01[I1, I2, I3, a                                                               ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), a                                                                 ] = ???
    final def +[I1, I2, I3, a, b                                                            ] (nextMolecule: IN3_02[I1, I2, I3, a, b                                                            ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b                                                            )] = ???
    final def +[I1, I2, I3, a, b, c                                                         ] (nextMolecule: IN3_03[I1, I2, I3, a, b, c                                                         ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c                                                         )] = ???
    final def +[I1, I2, I3, a, b, c, d                                                      ] (nextMolecule: IN3_04[I1, I2, I3, a, b, c, d                                                      ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d                                                      )] = ???
    final def +[I1, I2, I3, a, b, c, d, e                                                   ] (nextMolecule: IN3_05[I1, I2, I3, a, b, c, d, e                                                   ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e                                                   )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f                                                ] (nextMolecule: IN3_06[I1, I2, I3, a, b, c, d, e, f                                                ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f                                                )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g                                             ] (nextMolecule: IN3_07[I1, I2, I3, a, b, c, d, e, f, g                                             ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g                                             )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN3_08[I1, I2, I3, a, b, c, d, e, f, g, h                                          ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN3_09[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN3_10[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN3_11[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN3_12[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN3_13[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN3_14[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN3_15[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN3_16[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN3_17[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN3_18[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN3_19[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN3_20[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN3_21[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN3_22[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }
}