/*
 * Decompiled with CFR 0.152.
 */
package scalariform.lexer;

import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scalariform.ScalaVersions$;
import scalariform.lexer.Chars$;
import scalariform.lexer.Keywords$;
import scalariform.lexer.ScalaLexer;
import scalariform.lexer.ScalaLexerException;
import scalariform.lexer.ScalaOnlyLexer$;
import scalariform.lexer.TokenType;
import scalariform.lexer.Tokens$;
import scalariform.utils.Utils$;

public abstract class ScalaOnlyLexer$class {
    private static /* synthetic */ Option getStringLitOrBackquotedIdent$default$4(ScalaLexer $this) {
        return None$.MODULE$;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void fetchScalaToken(ScalaLexer $this) {
        var1_1 = $this.ch();
        switch (var1_1) {
            default: {
                if ($this.ch() == '\u21d2') {
                    $this.nextChar();
                    $this.token(Tokens$.MODULE$.ARROW());
                    return;
                }
                if ($this.ch() == '\u2190') {
                    $this.nextChar();
                    $this.token(Tokens$.MODULE$.LARROW());
                    return;
                }
                if (Character.isUnicodeIdentifierStart($this.ch())) {
                    $this.nextChar();
                    ScalaOnlyLexer$class.scalariform$lexer$ScalaOnlyLexer$$getIdentRest($this);
                    return;
                }
                if (Chars$.MODULE$.isSpecial($this.ch())) {
                    $this.nextChar();
                    ScalaOnlyLexer$class.scalariform$lexer$ScalaOnlyLexer$$getOperatorRest($this);
                    return;
                }
                if ($this.forgiveErrors() == false) throw new ScalaLexerException(new StringBuilder().append((Object)"illegal character: ").append((Object)BoxesRunTime.boxToCharacter((char)$this.ch())).toString());
                $this.nextChar();
                ScalaOnlyLexer$class.getWhitespaceRest($this);
                return;
            }
            case '}': {
                $this.nextChar();
                $this.token(Tokens$.MODULE$.RBRACE());
                nestingLevel = $this.scalaMode().unnestBrace();
                if (nestingLevel != 0) return;
                if ($this.isRootMode() != false) return;
                $this.popMode();
                return;
            }
            case '{': {
                $this.nextChar();
                $this.token(Tokens$.MODULE$.LBRACE());
                $this.scalaMode().nestBrace();
                return;
            }
            case '`': {
                ScalaOnlyLexer$class.getBackquotedIdent($this);
                return;
            }
            case ']': {
                $this.nextChar();
                $this.token(Tokens$.MODULE$.RBRACKET());
                return;
            }
            case '[': {
                $this.nextChar();
                $this.token(Tokens$.MODULE$.LBRACKET());
                return;
            }
            case '<': {
                var4_3 = $this.lastCh();
                switch (var4_3) {
                    case '{': {
                        if (ScalaOnlyLexer$class.gd1$1($this)) ** GOTO lbl71
                        break;
                    }
                    case '>': {
                        if (ScalaOnlyLexer$class.gd1$1($this)) ** GOTO lbl71
                        break;
                    }
                    case '(': {
                        if (ScalaOnlyLexer$class.gd1$1($this)) ** GOTO lbl71
                        break;
                    }
                    case ' ': {
                        if (ScalaOnlyLexer$class.gd1$1($this)) ** GOTO lbl71
                        break;
                    }
                    case '\u001a': {
                        if (ScalaOnlyLexer$class.gd1$1($this)) ** GOTO lbl71
                        break;
                    }
                    case '\n': {
                        if (ScalaOnlyLexer$class.gd1$1($this)) ** GOTO lbl71
                        break;
                    }
                    case '\t': {
                        if (!ScalaOnlyLexer$class.gd1$1($this)) break;
lbl71:
                        // 7 sources

                        $this.switchToXmlModeAndFetchToken();
                        return;
                    }
                }
                $this.nextChar();
                ScalaOnlyLexer$class.scalariform$lexer$ScalaOnlyLexer$$getOperatorRest($this);
                return;
            }
            case ';': {
                $this.nextChar();
                $this.token(Tokens$.MODULE$.SEMI());
                return;
            }
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                ScalaOnlyLexer$class.getNumber($this, 10);
                return;
            }
            case '0': {
                if ($this.ch(1) != 'x' && $this.ch(1) != 'X') {
                    $this.nextChar();
                    ScalaOnlyLexer$class.getNumber($this, 8);
                    return;
                }
                ScalaOnlyLexer$class.getHexNumber($this);
                return;
            }
            case '/': {
                var3_4 = $this.ch(1);
                switch (var3_4) {
                    default: {
                        $this.nextChar();
                        ScalaOnlyLexer$class.scalariform$lexer$ScalaOnlyLexer$$getOperatorRest($this);
                        return;
                    }
                    case '/': {
                        ScalaOnlyLexer$class.getSingleLineComment($this);
                        return;
                    }
                    case '*': 
                }
                ScalaOnlyLexer$class.getMultilineComment($this);
                return;
            }
            case '.': {
                $this.nextChar();
                if ('0' <= $this.ch() && $this.ch() <= '9') {
                    ScalaOnlyLexer$class.getFraction($this);
                    return;
                }
                $this.token(Tokens$.MODULE$.DOT());
                return;
            }
            case ',': {
                $this.nextChar();
                $this.token(Tokens$.MODULE$.COMMA());
                return;
            }
            case ')': {
                $this.nextChar();
                $this.token(Tokens$.MODULE$.RPAREN());
                return;
            }
            case '(': {
                $this.nextChar();
                $this.token(Tokens$.MODULE$.LPAREN());
                return;
            }
            case '\'': {
                $this.nextChar();
                if (Chars$.MODULE$.isIdentifierStart($this.ch())) {
                    ScalaOnlyLexer$class.charLitOr($this, (Function0)new ScalaOnlyLexer$.anonfun.fetchScalaToken.1($this));
                    return;
                }
                if (Chars$.MODULE$.isOperatorPart($this.ch()) && $this.ch() != '\\') {
                    ScalaOnlyLexer$class.charLitOr($this, (Function0)new ScalaOnlyLexer$.anonfun.fetchScalaToken.2($this));
                    return;
                }
                ScalaOnlyLexer$class.getLitChar($this);
                if ($this.ch() != '\'') {
                    if ($this.forgiveErrors() == false) throw new ScalaLexerException("unclosed character literal");
                }
                $this.nextChar();
                $this.token(Tokens$.MODULE$.CHARACTER_LITERAL());
                return;
            }
            case '$': 
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'E': 
            case 'F': 
            case 'G': 
            case 'H': 
            case 'I': 
            case 'J': 
            case 'K': 
            case 'L': 
            case 'M': 
            case 'N': 
            case 'O': 
            case 'P': 
            case 'Q': 
            case 'R': 
            case 'S': 
            case 'T': 
            case 'U': 
            case 'V': 
            case 'W': 
            case 'X': 
            case 'Y': 
            case 'Z': 
            case '_': 
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': 
            case 'g': 
            case 'h': 
            case 'i': 
            case 'j': 
            case 'k': 
            case 'l': 
            case 'm': 
            case 'n': 
            case 'o': 
            case 'p': 
            case 'q': 
            case 'r': 
            case 's': 
            case 't': 
            case 'u': 
            case 'v': 
            case 'w': 
            case 'x': 
            case 'y': 
            case 'z': {
                $this.nextChar();
                $this.scalariform$lexer$ScalaOnlyLexer$$possibleInterpolationId_$eq(true);
                ScalaOnlyLexer$class.scalariform$lexer$ScalaOnlyLexer$$getIdentRest($this);
                return;
            }
            case '\"': {
                if ($this.ch(1) == '\"' && $this.ch(2) == '\"') {
                    ScalaOnlyLexer$class.getMultiLineStringLit($this);
                    return;
                }
                ScalaOnlyLexer$class.getStringLit($this);
                return;
            }
            case '!': 
            case '#': 
            case '%': 
            case '&': 
            case '*': 
            case '+': 
            case '-': 
            case ':': 
            case '=': 
            case '>': 
            case '?': 
            case '@': 
            case '\\': 
            case '^': 
            case '|': 
            case '~': {
                $this.nextChar();
                ScalaOnlyLexer$class.scalariform$lexer$ScalaOnlyLexer$$getOperatorRest($this);
                return;
            }
            case '\u001a': {
                $this.token(Tokens$.MODULE$.EOF());
                return;
            }
            case '\t': 
            case '\n': 
            case '\r': 
            case ' ': 
        }
        $this.nextChar();
        ScalaOnlyLexer$class.getWhitespaceRest($this);
        return;
        finally {
            $this.scalariform$lexer$ScalaOnlyLexer$$possibleInterpolationId_$eq(false);
        }
    }

    private static void getWhitespaceRest(ScalaLexer $this) {
        while (true) {
            char c = $this.ch();
            switch (c) {
                default: {
                    $this.token(Tokens$.MODULE$.WS());
                    return;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': 
            }
            $this.nextChar();
        }
    }

    private static void getStringLit(ScalaLexer $this) {
        ScalaOnlyLexer$class.getStringLitOrBackquotedIdent($this, '\"', "unclosed string literal", Tokens$.MODULE$.STRING_LITERAL(), ScalaOnlyLexer$class.getStringLitOrBackquotedIdent$default$4($this));
    }

    private static void getBackquotedIdent(ScalaLexer $this) {
        ScalaOnlyLexer$class.getStringLitOrBackquotedIdent($this, '`', "unclosed quoted identifer", Tokens$.MODULE$.VARID(), (Option)new Some((Object)"empty quoted identifier"));
    }

    private static void getStringLitOrBackquotedIdent(ScalaLexer $this, char delimiter$1, String errorMsg$1, TokenType tokenType$1, Option errorMsgOnEmpty$1) {
        $this.nextChar();
        ScalaOnlyLexer$class.scanForClosingQuotes$1($this, true, delimiter$1, errorMsg$1, tokenType$1, errorMsgOnEmpty$1);
    }

    private static void getLitChar(ScalaLexer $this) {
        if ($this.ch() == '\\') {
            $this.nextChar();
            if ('0' <= $this.ch() && $this.ch() <= '7') {
                char leadch = $this.ch();
                $this.nextChar();
                if ('0' <= $this.ch() && $this.ch() <= '7') {
                    $this.nextChar();
                    if (leadch <= '3' && '0' <= $this.ch() && $this.ch() <= '7') {
                        $this.nextChar();
                    }
                }
            } else {
                char c = $this.ch();
                switch (c) {
                    default: {
                        if ($this.forgiveErrors()) {
                            $this.nextChar();
                            break;
                        }
                        throw new ScalaLexerException("invalid escape character");
                    }
                    case '\"': 
                    case '\'': 
                    case '\\': 
                    case 'b': 
                    case 'f': 
                    case 'n': 
                    case 'r': 
                    case 't': {
                        $this.nextChar();
                        break;
                    }
                }
            }
        } else {
            $this.nextChar();
        }
    }

    private static void getMultiLineStringLit(ScalaLexer $this) {
        $this.munch("\"\"\"");
        ScalaOnlyLexer$class.scanForClosingTripleQuotes$1($this);
    }

    public static final void getStringPart(ScalaLexer $this, boolean multiLine) {
        while (true) {
            block14: {
                block15: {
                    block10: {
                        boolean isUnclosedLiteral;
                        block11: {
                            block13: {
                                block12: {
                                    block9: {
                                        if ($this.ch() != '\"') break block9;
                                        if (multiLine) {
                                            $this.nextChar();
                                            if (!ScalaOnlyLexer$class.isTripleQuote($this)) continue;
                                            $this.token(Tokens$.MODULE$.STRING_LITERAL());
                                            $this.popMode();
                                        } else {
                                            $this.nextChar();
                                            $this.token(Tokens$.MODULE$.STRING_LITERAL());
                                            $this.popMode();
                                        }
                                        break block10;
                                    }
                                    if ($this.ch() != '$') break block11;
                                    $this.nextChar();
                                    if ($this.ch() == '$') {
                                        $this.nextChar();
                                        continue;
                                    }
                                    if ($this.ch() != '{') break block12;
                                    $this.token(Tokens$.MODULE$.STRING_PART());
                                    $this.switchToScalaMode();
                                    break block10;
                                }
                                if (!Character.isUnicodeIdentifierStart($this.ch())) break block13;
                                $this.token(Tokens$.MODULE$.STRING_PART());
                                $this.stringInterpolationMode().interpolationVariable_$eq(true);
                                break block10;
                            }
                            if ($this.forgiveErrors()) {
                                $this.nextChar();
                                continue;
                            }
                            throw new ScalaLexerException("invalid string interpolation");
                        }
                        boolean bl = isUnclosedLiteral = !$this.isUnicodeEscape() && ($this.ch() == '\u001a' || !multiLine && ($this.ch() == '\r' || $this.ch() == '\n'));
                        if (!isUnclosedLiteral) break block14;
                        if (!$this.forgiveErrors()) break block15;
                        $this.token(Tokens$.MODULE$.STRING_LITERAL());
                        $this.popMode();
                    }
                    return;
                }
                throw new ScalaLexerException(multiLine ? "unclosed multi-line string literal" : "unclosed string literal");
            }
            $this.nextChar();
        }
    }

    private static boolean isTripleQuote(ScalaLexer $this) {
        boolean bl;
        if ($this.ch() == '\"') {
            $this.nextChar();
            if ($this.ch() == '\"') {
                $this.nextChar();
                while ($this.ch() == '\"') {
                    $this.nextChar();
                }
                bl = true;
            } else {
                bl = false;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final void scalariform$lexer$ScalaOnlyLexer$$getIdentRest(ScalaLexer $this) {
        block4: while (true) {
            char c = $this.ch();
            switch (c) {
                default: {
                    if (Character.isUnicodeIdentifierPart($this.ch()) && $this.ch() != '\u001a') {
                        $this.nextChar();
                        continue block4;
                    }
                    ScalaOnlyLexer$class.finishNamed($this);
                    return;
                }
                case '_': {
                    $this.nextChar();
                    ScalaOnlyLexer$class.getIdentOrOperatorRest($this);
                    return;
                }
                case '$': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'G': 
                case 'H': 
                case 'I': 
                case 'J': 
                case 'K': 
                case 'L': 
                case 'M': 
                case 'N': 
                case 'O': 
                case 'P': 
                case 'Q': 
                case 'R': 
                case 'S': 
                case 'T': 
                case 'U': 
                case 'V': 
                case 'W': 
                case 'X': 
                case 'Y': 
                case 'Z': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'g': 
                case 'h': 
                case 'i': 
                case 'j': 
                case 'k': 
                case 'l': 
                case 'm': 
                case 'n': 
                case 'o': 
                case 'p': 
                case 'q': 
                case 'r': 
                case 's': 
                case 't': 
                case 'u': 
                case 'v': 
                case 'w': 
                case 'x': 
                case 'y': 
                case 'z': 
            }
            $this.nextChar();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final void scalariform$lexer$ScalaOnlyLexer$$getOperatorRest(ScalaLexer $this) {
        block7: while (true) {
            char c = $this.ch();
            switch (c) {
                default: {
                    if (Chars$.MODULE$.isSpecial($this.ch())) {
                        $this.nextChar();
                        continue block7;
                    }
                    ScalaOnlyLexer$class.finishNamed($this);
                    return;
                }
                case '/': {
                    char c2 = $this.ch(1);
                    switch (c2) {
                        default: {
                            $this.nextChar();
                            continue block7;
                        }
                        case '*': 
                        case '/': 
                    }
                    ScalaOnlyLexer$class.finishNamed($this);
                    return;
                }
                case '!': 
                case '#': 
                case '%': 
                case '&': 
                case '*': 
                case '+': 
                case '-': 
                case ':': 
                case '<': 
                case '=': 
                case '>': 
                case '?': 
                case '@': 
                case '\\': 
                case '^': 
                case '|': 
                case '~': 
            }
            $this.nextChar();
        }
    }

    private static void getIdentOrOperatorRest(ScalaLexer $this) {
        if (Chars$.MODULE$.isIdentifierPart($this.ch())) {
            ScalaOnlyLexer$class.scalariform$lexer$ScalaOnlyLexer$$getIdentRest($this);
        } else {
            char c = $this.ch();
            switch (c) {
                default: {
                    if (Chars$.MODULE$.isSpecial($this.ch())) {
                        ScalaOnlyLexer$class.scalariform$lexer$ScalaOnlyLexer$$getOperatorRest($this);
                        break;
                    }
                    ScalaOnlyLexer$class.finishNamed($this);
                    break;
                }
                case '!': 
                case '#': 
                case '%': 
                case '&': 
                case '*': 
                case '+': 
                case '-': 
                case '/': 
                case ':': 
                case '<': 
                case '=': 
                case '>': 
                case '?': 
                case '@': 
                case '\\': 
                case '^': 
                case '|': 
                case '~': {
                    ScalaOnlyLexer$class.scalariform$lexer$ScalaOnlyLexer$$getOperatorRest($this);
                }
            }
        }
    }

    private static void finishNamed(ScalaLexer $this) {
        TokenType tokenType;
        if ($this.scalariform$lexer$ScalaOnlyLexer$$processingSymbol()) {
            tokenType = Tokens$.MODULE$.SYMBOL_LITERAL();
        } else if ($this.scalariform$lexer$ScalaOnlyLexer$$possibleInterpolationId() && $this.ch() == '\"' && $this.scalaVersion().$greater$eq(ScalaVersions$.MODULE$.Scala_2_10())) {
            $this.switchToStringInterpolationMode($this.lookaheadIs("\"\"\""));
            tokenType = Tokens$.MODULE$.INTERPOLATION_ID();
        } else {
            tokenType = (TokenType)Keywords$.MODULE$.apply($this.getTokenText()).getOrElse((Function0)new ScalaOnlyLexer$.anonfun.1($this));
        }
        TokenType tokenType2 = tokenType;
        $this.token(tokenType2);
    }

    private static void getSingleLineComment(ScalaLexer $this) {
        $this.nextChar();
        $this.nextChar();
        ScalaOnlyLexer$class.consumeUntilNewline$1($this);
    }

    private static void getMultilineComment(ScalaLexer $this) {
        $this.munch("/*");
        ScalaOnlyLexer$class.consumeUntilSplatSlash$1($this, 1);
    }

    private static void getFraction(ScalaLexer $this) {
        while ('0' <= $this.ch() && $this.ch() <= '9') {
            $this.nextChar();
        }
        if ($this.ch() == 'e' || $this.ch() == 'E') {
            $this.nextChar();
            if ($this.ch() == '+' || $this.ch() == '-') {
                $this.nextChar();
            }
            while ('0' <= $this.ch() && $this.ch() <= '9') {
                $this.nextChar();
            }
        }
        if ($this.ch() == 'd' || $this.ch() == 'D' || $this.ch() == 'f' || $this.ch() == 'F') {
            $this.nextChar();
        }
        ScalaOnlyLexer$class.checkNoLetter($this);
        $this.token(Tokens$.MODULE$.FLOATING_POINT_LITERAL());
    }

    private static void getHexNumber(ScalaLexer $this) {
        $this.nextChar();
        $this.nextChar();
        ScalaOnlyLexer$class.munchHexDigits$1($this);
    }

    private static void getNumber(ScalaLexer $this, int base) {
        int base1;
        int n = base1 = base < 10 ? 10 : base;
        while (Utils$.MODULE$.digit2int($this.ch(), base1) >= 0) {
            $this.nextChar();
        }
        if ($this.ch() == '.') {
            boolean isDefinitelyNumber;
            char c = $this.ch(1);
            if ($this.scalaVersion().$greater$eq(ScalaVersions$.MODULE$.Scala_2_11()) && !ScalaOnlyLexer$class.isDigit$1($this, c)) {
                $this.token(Tokens$.MODULE$.INTEGER_LITERAL());
                return;
            }
            char c2 = c;
            switch (c2) {
                default: {
                    boolean bl;
                    if (Chars$.MODULE$.isIdentifierStart(c2)) {
                        bl = false;
                        break;
                    }
                    bl = true;
                    break;
                }
                case '`': {
                    $this.token(Tokens$.MODULE$.INTEGER_LITERAL());
                    return;
                }
                case 'E': 
                case 'e': {
                    boolean bl;
                    char ch2 = $this.ch(2);
                    if (Chars$.MODULE$.isIdentifierPart(ch2) && !ScalaOnlyLexer$class.isDigit$1($this, ch2) && ch2 != '+' && ch2 != '-') {
                        bl = false;
                        break;
                    }
                    bl = true;
                    break;
                }
                case 'D': 
                case 'F': 
                case 'd': 
                case 'f': {
                    boolean bl;
                    if (Chars$.MODULE$.isIdentifierPart($this.ch(2))) {
                        bl = false;
                        break;
                    }
                    bl = true;
                    break;
                }
                case '9': {
                    boolean bl = true;
                    break;
                }
                case '8': {
                    boolean bl = true;
                    break;
                }
                case '7': {
                    boolean bl = true;
                    break;
                }
                case '6': {
                    boolean bl = true;
                    break;
                }
                case '5': {
                    boolean bl = true;
                    break;
                }
                case '4': {
                    boolean bl = true;
                    break;
                }
                case '3': {
                    boolean bl = true;
                    break;
                }
                case '2': {
                    boolean bl = true;
                    break;
                }
                case '1': {
                    boolean bl = true;
                    break;
                }
                case '0': {
                    boolean bl = isDefinitelyNumber = true;
                }
            }
            if (isDefinitelyNumber) {
                $this.nextChar();
                ScalaOnlyLexer$class.getFraction($this);
            } else {
                ScalaOnlyLexer$class.restOfUncertainToken$1($this);
            }
        } else {
            ScalaOnlyLexer$class.restOfUncertainToken$1($this);
        }
    }

    private static void checkNoLetter(ScalaLexer $this) {
        if (Chars$.MODULE$.isIdentifierPart($this.ch()) && $this.ch() >= ' ' && !$this.forgiveErrors()) {
            throw new ScalaLexerException(new StringBuilder().append((Object)"Invalid literal number: ").append((Object)BoxesRunTime.boxToCharacter((char)$this.ch())).toString());
        }
    }

    private static void charLitOr(ScalaLexer $this, Function0 op) {
        $this.nextChar();
        if ($this.ch() == '\'') {
            $this.nextChar();
            $this.token(Tokens$.MODULE$.CHARACTER_LITERAL());
        } else {
            $this.scalariform$lexer$ScalaOnlyLexer$$processingSymbol_$eq(true);
            op.apply$mcV$sp();
            $this.scalariform$lexer$ScalaOnlyLexer$$processingSymbol_$eq(false);
        }
    }

    private static final /* synthetic */ boolean gd1$1(ScalaLexer $this) {
        return $this.ch(1) != '\u001a' && ($this.isNameStart($this.ch(1)) || $this.ch(1) == '!' || $this.ch(1) == '?');
    }

    private static final /* synthetic */ boolean gd3$1(ScalaLexer $this) {
        return !$this.isUnicodeEscape();
    }

    private static final /* synthetic */ boolean gd4$1(ScalaLexer $this, Option option, boolean bl) {
        return bl && option.isDefined();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final void scanForClosingQuotes$1(ScalaLexer $this, boolean firstTime$1, char c, String string, TokenType tokenType, Option option) {
        while (true) {
            block10: {
                char c2;
                block11: {
                    block9: {
                        block8: {
                            c2 = $this.ch();
                            if ($this.eof()) {
                                if (!$this.forgiveErrors()) throw new ScalaLexerException(string);
                                $this.token(tokenType);
                                return;
                            }
                            if (c2 != '\r') break block8;
                            if (ScalaOnlyLexer$class.gd3$1($this)) break block9;
                            break block10;
                        }
                        if (c2 != '\n') break block11;
                        if (!ScalaOnlyLexer$class.gd3$1($this)) break block10;
                    }
                    if (!$this.forgiveErrors()) throw new ScalaLexerException(string);
                    $this.token(tokenType);
                    return;
                }
                if (c == c2) {
                    if (ScalaOnlyLexer$class.gd4$1($this, option, firstTime$1)) {
                        if (!$this.forgiveErrors()) throw new ScalaLexerException((String)option.get());
                        $this.token(tokenType);
                        return;
                    } else {
                        $this.nextChar();
                        $this.token(tokenType);
                    }
                    return;
                }
            }
            ScalaOnlyLexer$class.getLitChar($this);
            firstTime$1 = false;
        }
    }

    private static final void scanForClosingTripleQuotes$1(ScalaLexer $this) {
        while (true) {
            block6: {
                block7: {
                    block5: {
                        block4: {
                            if (!$this.lookaheadIs("\"\"\"")) break block4;
                            $this.munch("\"\"\"");
                            while ($this.ch() == '\"') {
                                $this.nextChar();
                            }
                            $this.token(Tokens$.MODULE$.STRING_LITERAL());
                            break block5;
                        }
                        if (!$this.eof()) break block6;
                        if (!$this.forgiveErrors()) break block7;
                        $this.token(Tokens$.MODULE$.STRING_LITERAL());
                    }
                    return;
                }
                throw new ScalaLexerException("unclosed multi-line string literal");
            }
            $this.nextChar();
        }
    }

    private static final /* synthetic */ boolean gd5$1(ScalaLexer $this) {
        return $this.ch(1) != '\n';
    }

    private static final /* synthetic */ boolean gd6$1(ScalaLexer $this) {
        return $this.eof();
    }

    /*
     * Unable to fully structure code
     */
    private static final void consumeUntilNewline$1(ScalaLexer $this) {
        block5: while (true) {
            var2_1 = $this.ch();
            switch (var2_1) {
                case '\u001a': {
                    if (ScalaOnlyLexer$class.gd6$1($this)) {
                        $this.token(Tokens$.MODULE$.LINE_COMMENT());
                        break block5;
                    }
                    ** GOTO lbl14
                }
                case '\r': {
                    if (ScalaOnlyLexer$class.gd5$1($this)) {
                        $this.nextChar();
                        $this.token(Tokens$.MODULE$.LINE_COMMENT());
                        break block5;
                    }
                }
lbl14:
                // 4 sources

                default: {
                    $this.nextChar();
                    continue block5;
                }
                case '\n': {
                    $this.nextChar();
                    $this.token(Tokens$.MODULE$.LINE_COMMENT());
                }
            }
            break;
        }
    }

    private static final /* synthetic */ boolean gd7$1(ScalaLexer $this) {
        return $this.ch(1) == '/';
    }

    private static final /* synthetic */ boolean gd8$1(ScalaLexer $this) {
        return $this.ch(1) == '*';
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final void consumeUntilSplatSlash$1(ScalaLexer $this, int nesting) {
        block5: while (true) {
            if (nesting == 0) {
                $this.token(Tokens$.MODULE$.MULTILINE_COMMENT());
                return;
            }
            char c = $this.ch();
            switch (c) {
                case '/': {
                    if (!ScalaOnlyLexer$class.gd8$1($this)) break;
                    $this.nextChar();
                    $this.nextChar();
                    ++nesting;
                    continue block5;
                }
                case '*': {
                    if (!ScalaOnlyLexer$class.gd7$1($this)) break;
                    $this.nextChar();
                    $this.nextChar();
                    --nesting;
                    continue block5;
                }
                case '\u001a': {
                    if (!$this.eof()) break;
                    if (!$this.forgiveErrors()) throw new ScalaLexerException("Unterminated comment");
                    $this.token(Tokens$.MODULE$.MULTILINE_COMMENT());
                    return;
                }
            }
            $this.nextChar();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final void munchHexDigits$1(ScalaLexer $this) {
        while (true) {
            char c = $this.ch();
            switch (c) {
                default: {
                    $this.token(Tokens$.MODULE$.INTEGER_LITERAL());
                    ScalaOnlyLexer$class.checkNoLetter($this);
                    return;
                }
                case 'L': 
                case 'l': {
                    $this.nextChar();
                    $this.token(Tokens$.MODULE$.INTEGER_LITERAL());
                    return;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': 
            }
            $this.nextChar();
        }
    }

    private static final boolean isDigit$1(ScalaLexer $this, char c) {
        return c == '\u001a' ? false : Character.isDigit(c);
    }

    private static final boolean isEfd$1(ScalaLexer $this) {
        boolean bl;
        char c = $this.ch();
        switch (c) {
            default: {
                bl = false;
                break;
            }
            case 'f': {
                bl = true;
                break;
            }
            case 'e': {
                bl = true;
                break;
            }
            case 'd': {
                bl = true;
                break;
            }
            case 'F': {
                bl = true;
                break;
            }
            case 'E': {
                bl = true;
                break;
            }
            case 'D': {
                bl = true;
            }
        }
        return bl;
    }

    private static final boolean isL$1(ScalaLexer $this) {
        boolean bl;
        char c = $this.ch();
        switch (c) {
            default: {
                bl = false;
                break;
            }
            case 'l': {
                bl = true;
                break;
            }
            case 'L': {
                bl = true;
            }
        }
        return bl;
    }

    private static final void restOfUncertainToken$1(ScalaLexer $this) {
        if (ScalaOnlyLexer$class.isEfd$1($this)) {
            ScalaOnlyLexer$class.getFraction($this);
        } else {
            if (ScalaOnlyLexer$class.isL$1($this)) {
                $this.nextChar();
            } else {
                ScalaOnlyLexer$class.checkNoLetter($this);
            }
            $this.token(Tokens$.MODULE$.INTEGER_LITERAL());
        }
    }

    public static void $init$(ScalaLexer $this) {
        $this.scalariform$lexer$ScalaOnlyLexer$$processingSymbol_$eq(false);
        $this.scalariform$lexer$ScalaOnlyLexer$$possibleInterpolationId_$eq(false);
    }
}

