/*
 * Decompiled with CFR 0.152.
 */
package scalariform.lexer;

import scala.MatchError;
import scala.PartialFunction;
import scala.PartialFunction$;
import scala.Predef$;
import scala.collection.BufferedIterator;
import scala.runtime.BoxesRunTime;
import scalariform.lexer.InEndTag$;
import scalariform.lexer.InStartTag$;
import scalariform.lexer.Normal$;
import scalariform.lexer.ScalaLexer;
import scalariform.lexer.ScalaLexerException;
import scalariform.lexer.TagState;
import scalariform.lexer.Tokens$;
import scalariform.lexer.XmlLexer$;

public abstract class XmlLexer$class {
    private static boolean tagMode(ScalaLexer $this) {
        return $this.xmlMode().isTagMode();
    }

    private static void tagMode_$eq(ScalaLexer $this, boolean isTagMode) {
        $this.xmlMode().isTagMode_$eq(isTagMode);
    }

    private static boolean moreXmlToCome(ScalaLexer $this) {
        BufferedIterator newReader = $this.reader().copy().buffered();
        while (BoxesRunTime.unboxToChar((Object)newReader.head()) != '\u001a' && $this.isSpace(BoxesRunTime.unboxToChar((Object)newReader.head()))) {
            newReader.next();
        }
        return PartialFunction$.MODULE$.cond((Object)newReader.take(2).toList(), (PartialFunction)new XmlLexer$.anonfun.moreXmlToCome.1($this));
    }

    public static void fetchXmlToken(ScalaLexer $this) {
        char c = $this.ch();
        switch (c) {
            default: {
                if (XmlLexer$class.tagMode($this) && $this.isNameStart($this.ch())) {
                    XmlLexer$class.getXmlName($this);
                    break;
                }
                if (XmlLexer$class.tagMode($this) && $this.isSpace($this.ch())) {
                    XmlLexer$class.getXmlSpace($this);
                    break;
                }
                XmlLexer$class.getXmlCharData($this);
                break;
            }
            case '{': {
                if ($this.ch(1) != '{') {
                    $this.switchToScalaModeAndFetchToken();
                    break;
                }
                XmlLexer$class.getXmlCharData($this);
                break;
            }
            case '>': {
                if (XmlLexer$class.tagMode($this)) {
                    $this.nextChar();
                    $this.token(Tokens$.MODULE$.XML_TAG_CLOSE());
                    $this.xmlMode().isTagMode_$eq(false);
                    TagState tagState = $this.xmlMode().tagState();
                    InStartTag$ inStartTag$ = InStartTag$.MODULE$;
                    TagState tagState2 = tagState;
                    if (!(inStartTag$ != null ? !inStartTag$.equals(tagState2) : tagState2 != null)) {
                        $this.xmlMode().nestTag();
                        break;
                    }
                    InEndTag$ inEndTag$ = InEndTag$.MODULE$;
                    TagState tagState3 = tagState;
                    if (!(inEndTag$ != null ? !inEndTag$.equals(tagState3) : tagState3 != null)) {
                        int nestingLevel = $this.xmlMode().unnestTag();
                        if (nestingLevel != 0 || XmlLexer$class.moreXmlToCome($this)) break;
                        $this.popMode();
                        break;
                    }
                    Normal$ normal$ = Normal$.MODULE$;
                    TagState tagState4 = tagState;
                    if (!(normal$ != null ? !normal$.equals(tagState4) : tagState4 != null)) {
                        throw new AssertionError((Object)"shouldn't reach here");
                    }
                    throw new MatchError((Object)tagState);
                }
                XmlLexer$class.getXmlCharData($this);
                break;
            }
            case '=': {
                if (XmlLexer$class.tagMode($this)) {
                    $this.nextChar();
                    $this.token(Tokens$.MODULE$.XML_ATTR_EQ());
                    break;
                }
                XmlLexer$class.getXmlCharData($this);
                break;
            }
            case '<': {
                if ($this.ch(1) == '/') {
                    $this.nextChar();
                    $this.nextChar();
                    $this.token(Tokens$.MODULE$.XML_END_OPEN());
                    $this.xmlMode().isTagMode_$eq(true);
                    $this.xmlMode().tagState_$eq(InEndTag$.MODULE$);
                    break;
                }
                if ($this.ch(1) == '!') {
                    if ($this.ch(2) == '-') {
                        XmlLexer$class.getXmlComment($this);
                        if ($this.xmlMode().nestingLevel() != 0 || XmlLexer$class.moreXmlToCome($this)) break;
                        $this.popMode();
                        break;
                    }
                    if ($this.ch(2) == '[') {
                        XmlLexer$class.getXmlCDATA($this);
                        if ($this.xmlMode().nestingLevel() != 0 || XmlLexer$class.moreXmlToCome($this)) break;
                        $this.popMode();
                        break;
                    }
                    if ($this.forgiveErrors()) {
                        $this.munch("<!");
                        $this.token(Tokens$.MODULE$.XML_COMMENT());
                        break;
                    }
                    throw new ScalaLexerException("Bad XML");
                }
                if ($this.ch(1) == '?') {
                    XmlLexer$class.getXmlProcessingInstruction($this);
                    if ($this.xmlMode().nestingLevel() != 0 || XmlLexer$class.moreXmlToCome($this)) break;
                    $this.popMode();
                    break;
                }
                if ($this.lookaheadIs("<xml:unparsed")) {
                    XmlLexer$class.getXmlUnparsed($this);
                    if ($this.xmlMode().nestingLevel() != 0 || XmlLexer$class.moreXmlToCome($this)) break;
                    $this.popMode();
                    break;
                }
                $this.nextChar();
                $this.token(Tokens$.MODULE$.XML_START_OPEN());
                $this.xmlMode().isTagMode_$eq(true);
                $this.xmlMode().tagState_$eq(InStartTag$.MODULE$);
                break;
            }
            case '/': {
                if (XmlLexer$class.tagMode($this)) {
                    if ($this.ch(1) == '>') {
                        $this.nextChar();
                        $this.nextChar();
                        $this.token(Tokens$.MODULE$.XML_EMPTY_CLOSE());
                        $this.xmlMode().isTagMode_$eq(false);
                        $this.xmlMode().tagState_$eq(Normal$.MODULE$);
                        if ($this.xmlMode().nestingLevel() != 0 || XmlLexer$class.moreXmlToCome($this)) break;
                        $this.popMode();
                        break;
                    }
                    XmlLexer$class.getXmlCharData($this);
                    break;
                }
                XmlLexer$class.getXmlCharData($this);
                break;
            }
            case '\'': {
                if (XmlLexer$class.tagMode($this)) {
                    XmlLexer$class.getXmlAttributeValue($this, '\'');
                    break;
                }
                XmlLexer$class.getXmlCharData($this);
                break;
            }
            case '\"': {
                if (XmlLexer$class.tagMode($this)) {
                    XmlLexer$class.getXmlAttributeValue($this, '\"');
                    break;
                }
                XmlLexer$class.getXmlCharData($this);
                break;
            }
            case '\u001a': {
                $this.token(Tokens$.MODULE$.EOF());
            }
        }
    }

    private static void getXmlCDATA(ScalaLexer $this) {
        $this.munch("<![CDATA[");
        boolean bl = true;
        while (bl) {
            if ($this.lookaheadIs("]]>")) {
                $this.munch("]]>");
                bl = false;
                continue;
            }
            if ($this.ch() == '\u001a') {
                if ($this.forgiveErrors()) {
                    bl = false;
                    continue;
                }
                throw new ScalaLexerException("Malformed XML CDATA");
            }
            $this.nextChar();
        }
        $this.token(Tokens$.MODULE$.XML_CDATA());
    }

    private static void getXmlComment(ScalaLexer $this) {
        $this.munch("<!--");
        boolean bl = true;
        while (bl) {
            if ($this.ch() == '-' && $this.ch(1) == '-') {
                $this.nextChar();
                $this.nextChar();
                if ($this.ch() != '>') {
                    if ($this.forgiveErrors()) {
                        bl = false;
                    } else {
                        throw new ScalaLexerException("Malformed XML comment");
                    }
                }
                $this.nextChar();
                bl = false;
                continue;
            }
            if ($this.ch() == '\u001a') {
                if ($this.forgiveErrors()) {
                    bl = false;
                    continue;
                }
                throw new ScalaLexerException("Malformed XML comment");
            }
            $this.nextChar();
        }
        $this.token(Tokens$.MODULE$.XML_COMMENT());
    }

    private static void getXmlCharData(ScalaLexer $this) {
        boolean bl = true;
        while (bl) {
            if ($this.ch() == '\u001a' || $this.ch() == '<') {
                bl = false;
                continue;
            }
            if ($this.ch() == '{') {
                if ($this.ch(1) == '{') {
                    $this.nextChar();
                    $this.nextChar();
                    continue;
                }
                bl = false;
                continue;
            }
            $this.nextChar();
        }
        $this.token(Tokens$.MODULE$.XML_PCDATA());
    }

    private static void getXmlSpace(ScalaLexer $this) {
        Predef$.MODULE$.require($this.isSpace($this.ch()));
        $this.nextChar();
        while ($this.ch() != '\u001a' && $this.isSpace($this.ch())) {
            $this.nextChar();
        }
        $this.token(Tokens$.MODULE$.XML_WHITESPACE());
    }

    private static void getXmlName(ScalaLexer $this) {
        Predef$.MODULE$.require($this.isNameStart($this.ch()));
        $this.nextChar();
        while ($this.ch() != '\u001a' && $this.isNameChar($this.ch())) {
            $this.nextChar();
        }
        $this.token(Tokens$.MODULE$.XML_NAME());
    }

    private static void getXmlAttributeValue(ScalaLexer $this, char quote) {
        Predef$.MODULE$.require(quote == '\'' || quote == '\"');
        Predef$.MODULE$.require($this.ch() == quote);
        $this.nextChar();
        while ($this.ch() != quote) {
            if ($this.ch() == '\u001a') {
                if ($this.forgiveErrors()) {
                    $this.token(Tokens$.MODULE$.XML_ATTR_VALUE());
                    return;
                }
                throw new ScalaLexerException("Unterminated attribute value");
            }
            $this.nextChar();
        }
        Predef$.MODULE$.require($this.ch() == quote);
        $this.nextChar();
        $this.token(Tokens$.MODULE$.XML_ATTR_VALUE());
    }

    private static void getXmlUnparsed(ScalaLexer $this) {
        $this.munch("<xml:unparsed");
        boolean bl = true;
        while (bl) {
            if ($this.lookaheadIs("</xml:unparsed>")) {
                $this.munch("</xml:unparsed>");
                bl = false;
                continue;
            }
            if ($this.ch() == '\u001a') {
                if ($this.forgiveErrors()) {
                    bl = false;
                    continue;
                }
                throw new ScalaLexerException("Malformed Unparsed XML");
            }
            $this.nextChar();
        }
        $this.token(Tokens$.MODULE$.XML_UNPARSED());
    }

    private static void getXmlProcessingInstruction(ScalaLexer $this) {
        $this.munch("<?");
        boolean bl = true;
        while (bl) {
            if ($this.lookaheadIs("?>")) {
                $this.munch("?>");
                bl = false;
                continue;
            }
            if ($this.ch() == '\u001a') {
                if ($this.forgiveErrors()) {
                    bl = false;
                    continue;
                }
                throw new ScalaLexerException("Malformed XML processing instruction");
            }
            $this.nextChar();
        }
        $this.token(Tokens$.MODULE$.XML_PROCESSING_INSTRUCTION());
    }

    public static void $init$(ScalaLexer $this) {
    }
}

