/*
 * Decompiled with CFR 0.152.
 */
package org.scalatest;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;
import org.scalatest.CompositeStatus$;
import org.scalatest.CompositeStatus$Bundle$;
import org.scalatest.ConcurrentLinkedQueue;
import org.scalatest.CountDownLatch;
import org.scalatest.Status;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.collection.immutable.Set;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Failure;
import scala.util.Failure$;
import scala.util.Success$;
import scala.util.Try;

public final class CompositeStatus
implements Status,
Serializable {
    private final Set<Status> statuses;
    private final Object mutex;
    private final ConcurrentLinkedQueue<Function1<Try<Object>, BoxedUnit>> queue;
    private final CountDownLatch latch;
    private final AtomicReference<Bundle> bundleRef;

    public static void intializeBundle(Set<Status> set, Object object, ConcurrentLinkedQueue<Function1<Try<Object>, BoxedUnit>> concurrentLinkedQueue, CountDownLatch countDownLatch, AtomicReference<Bundle> atomicReference) {
        CompositeStatus$.MODULE$.intializeBundle(set, object, concurrentLinkedQueue, countDownLatch, atomicReference);
    }

    public CompositeStatus(Set<Status> statuses) {
        this.statuses = statuses;
        this.mutex = new Object();
        this.queue = new ConcurrentLinkedQueue();
        this.latch = new CountDownLatch(statuses.size());
        this.bundleRef = new AtomicReference<Bundle>(CompositeStatus$Bundle$.MODULE$.apply(true, (Option<Throwable>)None$.MODULE$));
        CompositeStatus$.MODULE$.intializeBundle(statuses, this.mutex, this.queue, this.latch, this.bundleRef);
    }

    @Override
    public boolean succeeds() {
        this.latch.await();
        return this.statuses.forall((Function1 & Serializable)_$2 -> _$2.succeeds());
    }

    @Override
    public boolean isCompleted() {
        return this.latch.getCount() == 0L;
    }

    @Override
    public void waitUntilCompleted() {
        this.latch.await();
    }

    @Override
    public void whenCompleted(Function1<Try<Object>, BoxedUnit> f) {
        boolean bl;
        Object object = this.mutex;
        synchronized (object) {
            boolean bl2;
            if (!this.isCompleted()) {
                this.queue.add(f);
                bl2 = false;
            } else {
                bl2 = true;
            }
            bl = bl2;
        }
        boolean executeLocally = bl;
        if (executeLocally) {
            Failure failure;
            Bundle bundle = this.bundleRef.get();
            Option<Throwable> option = bundle.asyncException();
            if (option instanceof Some) {
                Throwable ex = (Throwable)((Some)option).value();
                failure = Failure$.MODULE$.apply(ex);
            } else if (None$.MODULE$.equals(option)) {
                failure = Success$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)bundle.succeeded()));
            } else {
                throw new MatchError(option);
            }
            Failure tri = failure;
            f.apply((Object)tri);
        }
    }

    @Override
    public Option<Throwable> unreportedException() {
        Option option;
        Object object = this.mutex;
        synchronized (object) {
            Option option2;
            Bundle bundle = this.bundleRef.get();
            if (bundle.asyncException().isDefined()) {
                option2 = bundle.asyncException();
            } else {
                Option optStatusWithUnrepEx = this.statuses.find((Function1 & Serializable)_$3 -> _$3.unreportedException().isDefined());
                option2 = optStatusWithUnrepEx.flatMap((Function1 & Serializable)status -> status.unreportedException().map((Function1 & Serializable)unrepEx -> unrepEx));
            }
            option = option2;
        }
        return option;
    }

    public static class Bundle
    implements Product,
    Serializable {
        private final boolean succeeded;
        private final Option asyncException;

        public static Bundle apply(boolean bl, Option<Throwable> option) {
            return CompositeStatus$Bundle$.MODULE$.apply(bl, option);
        }

        public static Bundle fromProduct(Product product) {
            return CompositeStatus$Bundle$.MODULE$.fromProduct(product);
        }

        public static Bundle unapply(Bundle bundle) {
            return CompositeStatus$Bundle$.MODULE$.unapply(bundle);
        }

        public Bundle(boolean succeeded, Option<Throwable> asyncException) {
            this.succeeded = succeeded;
            this.asyncException = asyncException;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)(this.succeeded() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.asyncException()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Bundle)) return false;
            Bundle bundle = (Bundle)object;
            if (this.succeeded() != bundle.succeeded()) return false;
            Option<Throwable> option = this.asyncException();
            Option<Throwable> option2 = bundle.asyncException();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            if (!bundle.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Bundle;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Bundle";
        }

        public Object productElement(int n) {
            Option<Throwable> option;
            int n2 = n;
            if (0 == n2) {
                option = BoxesRunTime.boxToBoolean((boolean)this._1());
            } else if (1 == n2) {
                option = this._2();
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return option;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            if (0 == n2) {
                string = "succeeded";
            } else if (1 == n2) {
                string = "asyncException";
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return string;
        }

        public boolean succeeded() {
            return this.succeeded;
        }

        public Option<Throwable> asyncException() {
            return this.asyncException;
        }

        public Bundle copy(boolean succeeded, Option<Throwable> asyncException) {
            return new Bundle(succeeded, asyncException);
        }

        public boolean copy$default$1() {
            return this.succeeded();
        }

        public Option<Throwable> copy$default$2() {
            return this.asyncException();
        }

        public boolean _1() {
            return this.succeeded();
        }

        public Option<Throwable> _2() {
            return this.asyncException();
        }
    }
}

