/*
 * Decompiled with CFR 0.152.
 */
package org.scalatest;

import java.io.Serializable;
import java.util.concurrent.ExecutionException;
import org.scalactic.source.Position;
import org.scalatest.Resources$;
import org.scalatest.Succeeded$;
import org.scalatest.compatible.Assertion;
import org.scalatest.exceptions.StackDepthException$;
import org.scalatest.exceptions.TestFailedException;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.reflect.ClassTag;

public interface RecoverMethods {
    public static Future recoverToExceptionIf$(RecoverMethods $this, Future future, ClassTag classTag, ExecutionContext exCtx, Position pos) {
        return $this.recoverToExceptionIf((Future<Object>)future, classTag, exCtx, pos);
    }

    default public <T> Future<T> recoverToExceptionIf(Future<Object> future, ClassTag<T> classTag, ExecutionContext exCtx, Position pos) {
        Class clazz = classTag.runtimeClass();
        return future.failed().transform((Function1 & Serializable)ex -> {
            if (!clazz.isAssignableFrom(ex.getClass())) {
                String message = Resources$.MODULE$.wrongException(clazz.getName(), ex.getClass().getName());
                throw this.newAssertionFailedExceptionForRecover((Option<String>)Some$.MODULE$.apply((Object)message), (Option<Throwable>)Some$.MODULE$.apply(ex), pos);
            }
            return ex;
        }, (Function1 & Serializable)ex -> {
            String message = Resources$.MODULE$.exceptionExpected(clazz.getName());
            throw this.newAssertionFailedExceptionForRecover((Option<String>)Some$.MODULE$.apply((Object)message), (Option<Throwable>)None$.MODULE$, pos);
        }, exCtx);
    }

    public static Future recoverToSucceededIf$(RecoverMethods $this, Future future, ClassTag classTag, ExecutionContext exCtx, Position pos) {
        return $this.recoverToSucceededIf((Future<Object>)future, classTag, exCtx, pos);
    }

    default public <T> Future<Assertion> recoverToSucceededIf(Future<Object> future, ClassTag<T> classTag, ExecutionContext exCtx, Position pos) {
        Class clazz = classTag.runtimeClass();
        return future.failed().transform((Function1 & Serializable)rawEx -> {
            Throwable ex;
            Throwable throwable;
            Throwable throwable2 = rawEx;
            if (throwable2 instanceof ExecutionException) {
                ExecutionException execEx = (ExecutionException)throwable2;
                throwable = execEx.getCause();
            } else {
                Throwable other;
                throwable = ex = (other = throwable2);
            }
            if (!clazz.isAssignableFrom(ex.getClass())) {
                String message = Resources$.MODULE$.wrongException(clazz.getName(), ex.getClass().getName());
                throw this.newAssertionFailedExceptionForRecover((Option<String>)Some$.MODULE$.apply((Object)message), (Option<Throwable>)Some$.MODULE$.apply((Object)ex), pos);
            }
            return Succeeded$.MODULE$;
        }, (Function1 & Serializable)ex -> {
            String message = Resources$.MODULE$.exceptionExpected(clazz.getName());
            throw this.newAssertionFailedExceptionForRecover((Option<String>)Some$.MODULE$.apply((Object)message), (Option<Throwable>)None$.MODULE$, pos);
        }, exCtx);
    }

    public static Throwable newAssertionFailedExceptionForRecover$(RecoverMethods $this, Option optionalMessage, Option optionalCause, Position pos) {
        return $this.newAssertionFailedExceptionForRecover((Option<String>)optionalMessage, (Option<Throwable>)optionalCause, pos);
    }

    default public Throwable newAssertionFailedExceptionForRecover(Option<String> optionalMessage, Option<Throwable> optionalCause, Position pos) {
        return new TestFailedException(StackDepthException$.MODULE$.toExceptionFunction(optionalMessage), optionalCause, pos);
    }
}

