/*
 * Decompiled with CFR 0.152.
 */
package org.scalatest;

import java.io.PrintStream;
import java.io.Serializable;
import java.util.concurrent.ConcurrentSkipListSet;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.Requirements$;
import org.scalactic.source.Position;
import org.scalactic.source.Position$;
import org.scalatest.Resources$;
import org.scalatest.RunningTest;
import org.scalatest.Slowpoke;
import org.scalatest.SlowpokeDetector$;
import scala.Function1;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.collection.SeqOps;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

public class SlowpokeDetector {
    private final long timeout;
    private final PrintStream out;
    private final ConcurrentSkipListSet<RunningTest> runningTests;

    public static long $lessinit$greater$default$1() {
        return SlowpokeDetector$.MODULE$.$lessinit$greater$default$1();
    }

    public static PrintStream $lessinit$greater$default$2() {
        return SlowpokeDetector$.MODULE$.$lessinit$greater$default$2();
    }

    public SlowpokeDetector(long timeout, PrintStream out) {
        this.timeout = timeout;
        this.out = out;
        this.runningTests = new ConcurrentSkipListSet();
    }

    public void testStarting(String suiteName, String suiteId, String testName, long timeStamp) {
        ArraySeq arguments$proxy1 = ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{suiteName, suiteId, testName});
        Position pos$proxy1 = Position$.MODULE$.apply("SlowpokeDetector.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 32);
        String string = "suiteName";
        String string2 = "suiteId";
        String string3 = "testName";
        Requirements$.MODULE$.requirementsHelper().macroRequireNonNull((String[])((IterableOnceOps)((SeqOps)((SeqOps)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0]))).$plus$colon((Object)string3)).$plus$colon((Object)string2)).$plus$colon((Object)string)).toArray(ClassTag$.MODULE$.apply(String.class)), (Object[])arguments$proxy1.toArray(ClassTag$.MODULE$.Any()), Prettifier$.MODULE$.default(), pos$proxy1);
        long l = timeStamp;
        int n = 0;
        boolean bl = l >= (long)n;
        Requirements$.MODULE$.requirementsHelper().macroRequire(Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)l), ">=", (Object)BoxesRunTime.boxToInteger((int)n), bl, Prettifier$.MODULE$.default()), "timeStamp must be >= 0");
        this.runningTests.add(new RunningTest(suiteName, suiteId, testName, timeStamp));
    }

    public void testFinished(String suiteName, String suiteId, String testName) {
        ArraySeq arguments$proxy2 = ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{suiteName, suiteId, testName});
        Position pos$proxy2 = Position$.MODULE$.apply("SlowpokeDetector.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 44);
        String string = "suiteName";
        String string2 = "suiteId";
        String string3 = "testName";
        Requirements$.MODULE$.requirementsHelper().macroRequireNonNull((String[])((IterableOnceOps)((SeqOps)((SeqOps)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0]))).$plus$colon((Object)string3)).$plus$colon((Object)string2)).$plus$colon((Object)string)).toArray(ClassTag$.MODULE$.apply(String.class)), (Object[])arguments$proxy2.toArray(ClassTag$.MODULE$.Any()), Prettifier$.MODULE$.default(), pos$proxy2);
        boolean wasRemoved = this.runningTests.remove(new RunningTest(suiteName, suiteId, testName, 0L));
        if (!wasRemoved) {
            String stringToPrint = Resources$.MODULE$.slowpokeDetectorEventNotFound(suiteName, suiteId, testName);
            this.out.println(stringToPrint);
        }
    }

    public IndexedSeq<Slowpoke> detectSlowpokes(long currentTimeStamp) {
        Vector rts = ((IterableOnceOps)JavaConverters$.MODULE$.asScalaIteratorConverter(this.runningTests.iterator()).asScala()).toVector();
        Vector slowTests = (Vector)rts.filter((Function1 & Serializable)_$1 -> currentTimeStamp - _$1.startTimeStamp() > this.timeout);
        return (IndexedSeq)((StrictOptimizedIterableOps)slowTests.sortBy((Function1 & Serializable)_$2 -> _$2.startTimeStamp(), (Ordering)Ordering.Long$.MODULE$)).map((Function1 & Serializable)_$3 -> _$3.toSlowpoke(currentTimeStamp));
    }
}

