/*
 * Decompiled with CFR 0.152.
 */
package org.scalatest;

import java.io.Serializable;
import org.scalatest.ConcurrentLinkedQueue;
import org.scalatest.CountDownLatch;
import org.scalatest.Status;
import org.scalatest.Status$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Failure$;
import scala.util.Success$;
import scala.util.Try;

public final class StatefulStatus
implements Status,
Serializable {
    private final transient CountDownLatch latch = new CountDownLatch(1);
    private boolean succeeded = true;
    private final ConcurrentLinkedQueue<Function1<Try<Object>, BoxedUnit>> queue = new ConcurrentLinkedQueue();
    private Option<Throwable> asyncException = None$.MODULE$;
    private final Object setCompletedMutex = new Serializable(){};

    @Override
    public Option<Throwable> unreportedException() {
        Option<Throwable> option;
        StatefulStatus statefulStatus = this;
        synchronized (statefulStatus) {
            option = this.asyncException;
        }
        return option;
    }

    @Override
    public boolean succeeds() {
        boolean bl;
        this.waitUntilCompleted();
        StatefulStatus statefulStatus = this;
        synchronized (statefulStatus) {
            bl = this.succeeded;
        }
        return bl;
    }

    @Override
    public boolean isCompleted() {
        return this.latch.getCount() == 0L;
    }

    @Override
    public void waitUntilCompleted() {
        this.latch.await();
        Option<Throwable> option = this.unreportedException();
        if (option instanceof Some) {
            Throwable ue = (Throwable)((Some)option).value();
            throw ue;
        }
        if (!None$.MODULE$.equals(option)) {
            throw new MatchError(option);
        }
    }

    public void setFailed() {
        StatefulStatus statefulStatus = this;
        synchronized (statefulStatus) {
            if (this.isCompleted()) {
                throw new IllegalStateException("status is already completed");
            }
            this.succeeded = false;
        }
    }

    public void setFailedWith(Throwable ex) {
        StatefulStatus statefulStatus = this;
        synchronized (statefulStatus) {
            BoxedUnit boxedUnit;
            if (this.isCompleted()) {
                throw new IllegalStateException("status is already completed");
            }
            this.succeeded = false;
            if (this.asyncException.isEmpty()) {
                this.asyncException = Some$.MODULE$.apply((Object)ex);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                Predef$.MODULE$.println((Object)"ScalaTest can't report this exception because another preceded it, so printing its stack trace:");
                ex.printStackTrace();
                boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    public void setCompleted() {
        Failure failure;
        Option<Throwable> option = this.unreportedException();
        if (option instanceof Some) {
            Throwable ex = (Throwable)((Some)option).value();
            failure = Failure$.MODULE$.apply(ex);
        } else if (None$.MODULE$.equals(option)) {
            failure = Success$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)this.succeeded));
        } else {
            throw new MatchError(option);
        }
        Failure tri = failure;
        Object object = this.setCompletedMutex;
        synchronized (object) {
            Status$.MODULE$.executeQueue(this.queue, (Try<Object>)tri);
            StatefulStatus statefulStatus = this;
            synchronized (statefulStatus) {
                this.latch.countDown();
            }
            Status$.MODULE$.executeQueue(this.queue, (Try<Object>)tri);
        }
    }

    @Override
    public void whenCompleted(Function1<Try<Object>, BoxedUnit> f) {
        boolean bl;
        StatefulStatus statefulStatus = this;
        synchronized (statefulStatus) {
            boolean bl2;
            if (!this.isCompleted()) {
                this.queue.add(f);
                bl2 = false;
            } else {
                bl2 = true;
            }
            bl = bl2;
        }
        boolean executeLocally = bl;
        if (executeLocally) {
            Failure failure;
            Option<Throwable> option = this.unreportedException();
            if (option instanceof Some) {
                Throwable ex = (Throwable)((Some)option).value();
                failure = Failure$.MODULE$.apply(ex);
            } else if (None$.MODULE$.equals(option)) {
                failure = Success$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)this.succeeded));
            } else {
                throw new MatchError(option);
            }
            Failure tri = failure;
            f.apply((Object)tri);
        }
    }
}

