/*
 * Decompiled with CFR 0.152.
 */
package org.scalatest;

import java.io.Serializable;
import org.scalactic.Prettifier$;
import org.scalactic.Requirements$;
import org.scalactic.source.Position;
import org.scalactic.source.Position$;
import org.scalatest.Args$;
import org.scalatest.ConfigMap;
import org.scalatest.Distributor;
import org.scalatest.Filter;
import org.scalatest.Reporter;
import org.scalatest.Rerunner;
import org.scalatest.Resources$;
import org.scalatest.Stopper;
import org.scalatest.Suite;
import org.scalatest.Suite$;
import org.scalatest.Tracker;
import org.scalatest.events.Formatter;
import org.scalatest.events.Location;
import org.scalatest.events.RunAborted$;
import org.scalatest.events.RunCompleted$;
import org.scalatest.events.RunStarting$;
import org.scalatest.events.RunStopped$;
import org.scalatest.events.SeeStackDepthException$;
import org.scalatest.events.SuiteAborted$;
import org.scalatest.events.SuiteCompleted$;
import org.scalatest.events.SuiteStarting$;
import org.scalatest.events.TopOfClass$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

public class SuiteRerunner
implements Rerunner,
Serializable {
    private final String suiteClassName;

    public SuiteRerunner(String suiteClassName) {
        this.suiteClassName = suiteClassName;
        ArraySeq arguments$proxy1 = ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{suiteClassName});
        Position pos$proxy1 = Position$.MODULE$.apply("SuiteRerunner.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 33);
        String string = "SuiteRerunner.this.suiteClassName";
        Requirements$.MODULE$.requirementsHelper().macroRequireNonNull((String[])((IterableOnceOps)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0]))).$plus$colon((Object)string)).toArray(ClassTag$.MODULE$.apply(String.class)), (Object[])arguments$proxy1.toArray(ClassTag$.MODULE$.Any()), Prettifier$.MODULE$.default(), pos$proxy1);
    }

    @Override
    public void apply(Reporter report, Stopper stopper, Filter filter, ConfigMap configMap, Option<Distributor> distributor, Tracker tracker, ClassLoader loader) {
        block14: {
            Set set;
            Option<Set<String>> option = filter.tagsToInclude();
            if (None$.MODULE$.equals(option)) {
                set = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
            } else if (option instanceof Some) {
                Set tti;
                set = tti = (Set)((Some)option).value();
            } else {
                throw new MatchError(option);
            }
            Set tagsToInclude = set;
            Set<String> tagsToExclude = filter.tagsToExclude();
            long runStartTime = System.currentTimeMillis();
            try {
                Class<?> suiteClass = loader.loadClass(this.suiteClassName);
                Suite suite = (Suite)suiteClass.newInstance();
                int expectedTestCount = suite.expectedTestCount(filter);
                None$ rerunnable = Suite$.MODULE$.checkForPublicNoArgConstructor(suite.getClass()) ? Some$.MODULE$.apply((Object)new SuiteRerunner(suite.getClass().getName())) : None$.MODULE$;
                report.apply(RunStarting$.MODULE$.apply(tracker.nextOrdinal(), expectedTestCount, configMap, RunStarting$.MODULE$.$lessinit$greater$default$4(), RunStarting$.MODULE$.$lessinit$greater$default$5(), RunStarting$.MODULE$.$lessinit$greater$default$6(), RunStarting$.MODULE$.$lessinit$greater$default$7(), RunStarting$.MODULE$.$lessinit$greater$default$8()));
                long suiteStartTime = System.currentTimeMillis();
                try {
                    String rawString = Resources$.MODULE$.suiteExecutionStarting();
                    Option<Formatter> formatter = Suite$.MODULE$.formatterForSuiteStarting(suite);
                    report.apply(SuiteStarting$.MODULE$.apply(tracker.nextOrdinal(), suite.suiteName(), suite.suiteId(), (Option<String>)Some$.MODULE$.apply((Object)this.suiteClassName), formatter, (Option<Location>)Some$.MODULE$.apply((Object)TopOfClass$.MODULE$.apply(suite.getClass().getName())), suite.rerunner(), SuiteStarting$.MODULE$.$lessinit$greater$default$8(), SuiteStarting$.MODULE$.$lessinit$greater$default$9(), SuiteStarting$.MODULE$.$lessinit$greater$default$10()));
                    suite.run((Option<String>)None$.MODULE$, Args$.MODULE$.apply(report, stopper, filter, configMap, distributor, tracker, (Set<String>)Predef$.MODULE$.Set().empty(), Args$.MODULE$.$lessinit$greater$default$8(), Args$.MODULE$.$lessinit$greater$default$9(), Args$.MODULE$.$lessinit$greater$default$10()));
                    String rawString2 = Resources$.MODULE$.suiteCompletedNormally();
                    Option<Formatter> formatter2 = Suite$.MODULE$.formatterForSuiteCompleted(suite);
                    long duration = System.currentTimeMillis() - suiteStartTime;
                    report.apply(SuiteCompleted$.MODULE$.apply(tracker.nextOrdinal(), suite.suiteName(), suite.suiteId(), (Option<String>)Some$.MODULE$.apply((Object)this.suiteClassName), (Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)duration)), formatter2, (Option<Location>)Some$.MODULE$.apply((Object)TopOfClass$.MODULE$.apply(suite.getClass().getName())), suite.rerunner(), SuiteCompleted$.MODULE$.$lessinit$greater$default$9(), SuiteCompleted$.MODULE$.$lessinit$greater$default$10(), SuiteCompleted$.MODULE$.$lessinit$greater$default$11()));
                }
                catch (RuntimeException e) {
                    String eMessage = e.getMessage();
                    String rawString3 = eMessage != null && eMessage.length() > 0 ? Resources$.MODULE$.executeExceptionWithMessage(eMessage) : Resources$.MODULE$.executeException();
                    Option<Formatter> formatter3 = Suite$.MODULE$.formatterForSuiteAborted(suite, rawString3);
                    long duration = System.currentTimeMillis() - suiteStartTime;
                    report.apply(SuiteAborted$.MODULE$.apply(tracker.nextOrdinal(), rawString3, suite.suiteName(), suite.suiteId(), (Option<String>)Some$.MODULE$.apply((Object)this.suiteClassName), (Option<Throwable>)Some$.MODULE$.apply((Object)e), (Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)duration)), formatter3, (Option<Location>)Some$.MODULE$.apply((Object)SeeStackDepthException$.MODULE$), suite.rerunner(), SuiteAborted$.MODULE$.$lessinit$greater$default$11(), SuiteAborted$.MODULE$.$lessinit$greater$default$12(), SuiteAborted$.MODULE$.$lessinit$greater$default$13()));
                }
                long duration = System.currentTimeMillis() - runStartTime;
                if (stopper.stopRequested()) {
                    report.apply(RunStopped$.MODULE$.apply(tracker.nextOrdinal(), (Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)duration)), RunStopped$.MODULE$.$lessinit$greater$default$3(), RunStopped$.MODULE$.$lessinit$greater$default$4(), RunStopped$.MODULE$.$lessinit$greater$default$5(), RunStopped$.MODULE$.$lessinit$greater$default$6(), RunStopped$.MODULE$.$lessinit$greater$default$7(), RunStopped$.MODULE$.$lessinit$greater$default$8()));
                    break block14;
                }
                report.apply(RunCompleted$.MODULE$.apply(tracker.nextOrdinal(), (Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)duration)), RunCompleted$.MODULE$.$lessinit$greater$default$3(), RunCompleted$.MODULE$.$lessinit$greater$default$4(), RunCompleted$.MODULE$.$lessinit$greater$default$5(), RunCompleted$.MODULE$.$lessinit$greater$default$6(), RunCompleted$.MODULE$.$lessinit$greater$default$7(), RunCompleted$.MODULE$.$lessinit$greater$default$8()));
            }
            catch (ClassNotFoundException e) {
                long duration = System.currentTimeMillis() - runStartTime;
                report.apply(RunAborted$.MODULE$.apply(tracker.nextOrdinal(), Resources$.MODULE$.cannotLoadSuite(e.getMessage()), (Option<Throwable>)Some$.MODULE$.apply((Object)e), (Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)duration)), RunAborted$.MODULE$.$lessinit$greater$default$5(), RunAborted$.MODULE$.$lessinit$greater$default$6(), RunAborted$.MODULE$.$lessinit$greater$default$7(), RunAborted$.MODULE$.$lessinit$greater$default$8(), RunAborted$.MODULE$.$lessinit$greater$default$9(), RunAborted$.MODULE$.$lessinit$greater$default$10()));
            }
            catch (InstantiationException e) {
                long duration = System.currentTimeMillis() - runStartTime;
                report.apply(RunAborted$.MODULE$.apply(tracker.nextOrdinal(), Resources$.MODULE$.cannotInstantiateSuite(e.getMessage()), (Option<Throwable>)Some$.MODULE$.apply((Object)e), (Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)duration)), RunAborted$.MODULE$.$lessinit$greater$default$5(), RunAborted$.MODULE$.$lessinit$greater$default$6(), RunAborted$.MODULE$.$lessinit$greater$default$7(), RunAborted$.MODULE$.$lessinit$greater$default$8(), RunAborted$.MODULE$.$lessinit$greater$default$9(), RunAborted$.MODULE$.$lessinit$greater$default$10()));
            }
            catch (IllegalAccessException e) {
                long duration = System.currentTimeMillis() - runStartTime;
                report.apply(RunAborted$.MODULE$.apply(tracker.nextOrdinal(), Resources$.MODULE$.cannotInstantiateSuite(e.getMessage()), (Option<Throwable>)Some$.MODULE$.apply((Object)e), (Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)duration)), RunAborted$.MODULE$.$lessinit$greater$default$5(), RunAborted$.MODULE$.$lessinit$greater$default$6(), RunAborted$.MODULE$.$lessinit$greater$default$7(), RunAborted$.MODULE$.$lessinit$greater$default$8(), RunAborted$.MODULE$.$lessinit$greater$default$9(), RunAborted$.MODULE$.$lessinit$greater$default$10()));
            }
            catch (SecurityException e) {
                long duration = System.currentTimeMillis() - runStartTime;
                report.apply(RunAborted$.MODULE$.apply(tracker.nextOrdinal(), Resources$.MODULE$.securityWhenRerunning(e.getMessage()), (Option<Throwable>)Some$.MODULE$.apply((Object)e), (Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)duration)), RunAborted$.MODULE$.$lessinit$greater$default$5(), RunAborted$.MODULE$.$lessinit$greater$default$6(), RunAborted$.MODULE$.$lessinit$greater$default$7(), RunAborted$.MODULE$.$lessinit$greater$default$8(), RunAborted$.MODULE$.$lessinit$greater$default$9(), RunAborted$.MODULE$.$lessinit$greater$default$10()));
            }
            catch (NoClassDefFoundError e) {
                long duration = System.currentTimeMillis() - runStartTime;
                report.apply(RunAborted$.MODULE$.apply(tracker.nextOrdinal(), Resources$.MODULE$.cannotLoadClass(e.getMessage()), (Option<Throwable>)Some$.MODULE$.apply((Object)e), (Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)duration)), RunAborted$.MODULE$.$lessinit$greater$default$5(), RunAborted$.MODULE$.$lessinit$greater$default$6(), RunAborted$.MODULE$.$lessinit$greater$default$7(), RunAborted$.MODULE$.$lessinit$greater$default$8(), RunAborted$.MODULE$.$lessinit$greater$default$9(), RunAborted$.MODULE$.$lessinit$greater$default$10()));
            }
            catch (Throwable e) {
                long duration = System.currentTimeMillis() - runStartTime;
                report.apply(RunAborted$.MODULE$.apply(tracker.nextOrdinal(), Resources$.MODULE$.bigProblems(e), (Option<Throwable>)Some$.MODULE$.apply((Object)e), (Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)duration)), RunAborted$.MODULE$.$lessinit$greater$default$5(), RunAborted$.MODULE$.$lessinit$greater$default$6(), RunAborted$.MODULE$.$lessinit$greater$default$7(), RunAborted$.MODULE$.$lessinit$greater$default$8(), RunAborted$.MODULE$.$lessinit$greater$default$9(), RunAborted$.MODULE$.$lessinit$greater$default$10()));
            }
        }
    }
}

