/*
 * Decompiled with CFR 0.152.
 */
package org.scalatest.concurrent;

import java.io.Serializable;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.scalactic.source.Position;
import org.scalactic.source.Position$;
import org.scalatest.CountDownLatch;
import org.scalatest.Resources$;
import org.scalatest.Succeeded$;
import org.scalatest.compatible.Assertion;
import org.scalatest.concurrent.AbstractPatienceConfiguration;
import org.scalatest.concurrent.Conductors$Conductor$ClockThread$;
import org.scalatest.concurrent.Conductors$Conductor$Setup$;
import org.scalatest.concurrent.Conductors$Conductor$TestFinished$;
import org.scalatest.concurrent.Conductors$Conductor$TestStarted$;
import org.scalatest.concurrent.Conductors$Conductor$TestThread$;
import org.scalatest.concurrent.PatienceConfiguration;
import org.scalatest.concurrent.PimpedReadWriteLock$;
import org.scalatest.concurrent.PimpedThreadGroup$;
import org.scalatest.concurrent.TestThreadsStartingCounter;
import org.scalatest.exceptions.NotAllowedException;
import org.scalatest.time.Span;
import scala.Function0;
import scala.Function1;
import scala.Int$;
import scala.Product;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction0;

public interface Conductors
extends PatienceConfiguration {
    public static Object org$scalatest$concurrent$Conductors$Conductor$$_$thread$$anonfun$1(Function0 fun$1) {
        return fun$1.apply();
    }

    public static /* synthetic */ void org$scalatest$concurrent$Conductors$Conductor$$_$_$$anonfun$1(Function0 fun$2) {
        fun$2.apply();
    }

    public static /* synthetic */ void org$scalatest$concurrent$Conductors$Conductor$ClockThread$$_$run$$anonfun$1(Thread t) {
        block2: {
            if (!t.isAlive()) break block2;
            try {
                t.stop();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                t.interrupt();
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public final class Conductor {
        public static final long OFFSET$0 = LazyVals$.MODULE$.getOffset(Conductor.class, "0bitmap$1");
        public long 0bitmap$1;
        public final Clock org$scalatest$concurrent$Conductors$Conductor$$clock;
        public final ThreadGroup org$scalatest$concurrent$Conductors$Conductor$$threadGroup;
        private final CopyOnWriteArrayList<Thread> threads;
        private final CopyOnWriteArrayList<String> threadNames;
        public final Thread org$scalatest$concurrent$Conductors$Conductor$$mainThread;
        public final Conductors$Conductor$TestThread$ TestThread$lzy1;
        public final ArrayBlockingQueue<Throwable> org$scalatest$concurrent$Conductors$Conductor$$firstExceptionThrown;
        public final TestThreadsStartingCounter org$scalatest$concurrent$Conductors$Conductor$$testThreadsStartingCounter;
        public final CountDownLatch org$scalatest$concurrent$Conductors$Conductor$$greenLightForTestThreads;
        private final AtomicReference<ConductorState> currentState;
        public final Conductors$Conductor$ClockThread$ ClockThread$lzy1;
        private Conductors$Conductor$Setup$ Setup$lzy1;
        private Conductors$Conductor$TestStarted$ TestStarted$lzy1;
        private Conductors$Conductor$TestFinished$ TestFinished$lzy1;

        public Conductor() {
            if (Conductors.this == null) {
                throw new NullPointerException();
            }
            this.TestThread$lzy1 = new Conductors$Conductor$TestThread$(this);
            this.ClockThread$lzy1 = new Conductors$Conductor$ClockThread$(this);
            this.org$scalatest$concurrent$Conductors$Conductor$$clock = new Clock();
            this.org$scalatest$concurrent$Conductors$Conductor$$threadGroup = new ThreadGroup("Orchestra");
            this.threads = new CopyOnWriteArrayList();
            this.threadNames = new CopyOnWriteArrayList();
            this.org$scalatest$concurrent$Conductors$Conductor$$mainThread = Thread.currentThread();
            this.org$scalatest$concurrent$Conductors$Conductor$$firstExceptionThrown = new ArrayBlockingQueue(1);
            this.org$scalatest$concurrent$Conductors$Conductor$$testThreadsStartingCounter = new TestThreadsStartingCounter();
            this.org$scalatest$concurrent$Conductors$Conductor$$greenLightForTestThreads = new CountDownLatch(1);
            this.currentState = new AtomicReference<Conductors$Conductor$Setup$>(this.Setup());
        }

        public Thread thread(Function0<Object> fun) {
            return this.threadNamed(new StringBuilder(17).append("Conductor-Thread-").append(this.threads.size()).toString(), (Function0<Object>)((Function0 & Serializable)() -> Conductors.org$scalatest$concurrent$Conductors$Conductor$$_$thread$$anonfun$1(fun)), Position$.MODULE$.apply("Conductors.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 525));
        }

        public Thread threadNamed(String name, Function0<Object> fun, Position pos) {
            ConductorState conductorState = this.currentState.get();
            if (this.TestFinished().equals(conductorState)) {
                throw new NotAllowedException(Resources$.MODULE$.threadCalledAfterConductingHasCompleted(), pos);
            }
            if (this.threadNames.contains(name)) {
                throw new NotAllowedException(Resources$.MODULE$.cantRegisterThreadsWithSameName(name), pos);
            }
            TestThread t = this.TestThread().apply(name, (Function0<BoxedUnit>)((JFunction0.mcV.sp & Serializable)() -> Conductors.org$scalatest$concurrent$Conductors$Conductor$$_$_$$anonfun$1(fun)));
            this.threads.add(t);
            this.threadNames.add(name);
            t.start();
            return t;
        }

        public ThreadGroup org$scalatest$concurrent$Conductors$Conductor$$TestThread$superArg$1(String name, Function0<BoxedUnit> f) {
            return this.org$scalatest$concurrent$Conductors$Conductor$$threadGroup;
        }

        private final Conductors$Conductor$TestThread$ TestThread() {
            return this.TestThread$lzy1;
        }

        public Assertion whenFinished(Function0<Assertion> fun, Position pos) {
            Thread thread = Thread.currentThread();
            Thread thread2 = this.org$scalatest$concurrent$Conductors$Conductor$$mainThread;
            if (thread == null ? thread2 != null : !thread.equals(thread2)) {
                throw new NotAllowedException(Resources$.MODULE$.whenFinishedCanOnlyBeCalledByMainThread(), pos);
            }
            if (this.conductingHasBegun()) {
                throw new NotAllowedException(Resources$.MODULE$.cannotInvokeWhenFinishedAfterConduct(), pos);
            }
            this.conduct(Conductors.this.patienceConfig(), pos);
            return (Assertion)fun.apply();
        }

        public Succeeded$ waitForBeat(int beat, Position pos) {
            if (beat == 0) {
                throw new NotAllowedException(Resources$.MODULE$.cannotWaitForBeatZero(), pos);
            }
            if (beat < 0) {
                throw new NotAllowedException(Resources$.MODULE$.cannotWaitForNegativeBeat(), pos);
            }
            return this.org$scalatest$concurrent$Conductors$Conductor$$clock.waitForBeat(beat);
        }

        public int beat() {
            return this.org$scalatest$concurrent$Conductors$Conductor$$clock.currentBeat();
        }

        public <T> T withConductorFrozen(Function0<T> fun) {
            return this.org$scalatest$concurrent$Conductors$Conductor$$clock.withClockFrozen(fun);
        }

        public boolean isConductorFrozen() {
            return this.org$scalatest$concurrent$Conductors$Conductor$$clock.isFrozen();
        }

        public Assertion conduct(AbstractPatienceConfiguration.PatienceConfig config, Position pos) {
            return this.conductImpl(config.timeout(), config.interval(), pos);
        }

        public Assertion conduct(PatienceConfiguration.Timeout timeout, PatienceConfiguration.Interval interval, Position pos) {
            return this.conductImpl(timeout.value(), interval.value(), pos);
        }

        public Assertion conduct(PatienceConfiguration.Timeout timeout, AbstractPatienceConfiguration.PatienceConfig config, Position pos) {
            return this.conductImpl(timeout.value(), config.interval(), pos);
        }

        public Assertion conduct(PatienceConfiguration.Interval interval, AbstractPatienceConfiguration.PatienceConfig config, Position pos) {
            return this.conductImpl(config.timeout(), interval.value(), pos);
        }

        public boolean conductingHasBegun() {
            return this.currentState.get().testWasStarted();
        }

        private Assertion conductImpl(Span timeout, Span clockInterval, Position pos) {
            if (this.conductingHasBegun()) {
                throw new NotAllowedException(Resources$.MODULE$.cannotCallConductTwice(), pos);
            }
            this.currentState.set(this.TestStarted());
            if (this.threads.size() > 0) {
                this.org$scalatest$concurrent$Conductors$Conductor$$testThreadsStartingCounter.waitUntilAllTestThreadsHaveStarted();
            }
            this.org$scalatest$concurrent$Conductors$Conductor$$greenLightForTestThreads.countDown();
            ClockThread clockThread = this.ClockThread().apply(timeout, clockInterval);
            clockThread.start();
            this.waitForThreads();
            this.currentState.set(this.TestFinished());
            if (!this.org$scalatest$concurrent$Conductors$Conductor$$firstExceptionThrown.isEmpty()) {
                throw this.org$scalatest$concurrent$Conductors$Conductor$$firstExceptionThrown.peek();
            }
            return Succeeded$.MODULE$;
        }

        private Succeeded$ waitForThreads() {
            BooleanRef interrupted = BooleanRef.create((boolean)false);
            while (!interrupted.elem && PimpedThreadGroup$.MODULE$.threadGroupToPimpedThreadGroup(this.org$scalatest$concurrent$Conductors$Conductor$$threadGroup).areAnyThreadsAlive()) {
                PimpedThreadGroup$.MODULE$.threadGroupToPimpedThreadGroup(this.org$scalatest$concurrent$Conductors$Conductor$$threadGroup).getThreads().foreach((Function1)(JProcedure1 & Serializable)t -> {
                    block2: {
                        if (interrupted$1.elem || !t.isAlive() || !this.org$scalatest$concurrent$Conductors$Conductor$$firstExceptionThrown.isEmpty()) break block2;
                        try {
                            t.join();
                        }
                        catch (InterruptedException e) {
                            boolean bl;
                            interrupted$1.elem = bl = true;
                        }
                    }
                });
            }
            return Succeeded$.MODULE$;
        }

        private final Conductors$Conductor$ClockThread$ ClockThread() {
            return this.ClockThread$lzy1;
        }

        private final Conductors$Conductor$Setup$ Setup() {
            long l;
            long l2;
            while ((l2 = LazyVals$.MODULE$.STATE(l = LazyVals$.MODULE$.get((Object)this, OFFSET$0), 0)) != 3L) {
                if (l2 == 0L) {
                    if (!LazyVals$.MODULE$.CAS((Object)this, OFFSET$0, l, 1, 0)) continue;
                    try {
                        Conductors$Conductor$Setup$ conductors$Conductor$Setup$;
                        this.Setup$lzy1 = conductors$Conductor$Setup$ = new Conductors$Conductor$Setup$(this);
                        LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 3, 0);
                        return conductors$Conductor$Setup$;
                    }
                    catch (Throwable throwable) {
                        LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 0, 0);
                        throw throwable;
                    }
                }
                LazyVals$.MODULE$.wait4Notification((Object)this, OFFSET$0, l, 0);
            }
            return this.Setup$lzy1;
        }

        private final Conductors$Conductor$TestStarted$ TestStarted() {
            long l;
            long l2;
            while ((l2 = LazyVals$.MODULE$.STATE(l = LazyVals$.MODULE$.get((Object)this, OFFSET$0), 1)) != 3L) {
                if (l2 == 0L) {
                    if (!LazyVals$.MODULE$.CAS((Object)this, OFFSET$0, l, 1, 1)) continue;
                    try {
                        Conductors$Conductor$TestStarted$ conductors$Conductor$TestStarted$;
                        this.TestStarted$lzy1 = conductors$Conductor$TestStarted$ = new Conductors$Conductor$TestStarted$(this);
                        LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 3, 1);
                        return conductors$Conductor$TestStarted$;
                    }
                    catch (Throwable throwable) {
                        LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 0, 1);
                        throw throwable;
                    }
                }
                LazyVals$.MODULE$.wait4Notification((Object)this, OFFSET$0, l, 1);
            }
            return this.TestStarted$lzy1;
        }

        private final Conductors$Conductor$TestFinished$ TestFinished() {
            long l;
            long l2;
            while ((l2 = LazyVals$.MODULE$.STATE(l = LazyVals$.MODULE$.get((Object)this, OFFSET$0), 2)) != 3L) {
                if (l2 == 0L) {
                    if (!LazyVals$.MODULE$.CAS((Object)this, OFFSET$0, l, 1, 2)) continue;
                    try {
                        Conductors$Conductor$TestFinished$ conductors$Conductor$TestFinished$;
                        this.TestFinished$lzy1 = conductors$Conductor$TestFinished$ = new Conductors$Conductor$TestFinished$(this);
                        LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 3, 2);
                        return conductors$Conductor$TestFinished$;
                    }
                    catch (Throwable throwable) {
                        LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 0, 2);
                        throw throwable;
                    }
                }
                LazyVals$.MODULE$.wait4Notification((Object)this, OFFSET$0, l, 2);
            }
            return this.TestFinished$lzy1;
        }

        public final /* synthetic */ Conductors org$scalatest$concurrent$Conductors$Conductor$$$outer() {
            return Conductors.this;
        }

        public class Clock {
            private int currentTime = 0;
            private final Object lock = new Object();
            private final ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
            private int highestBeatBeingWaitedOn = 0;

            public Succeeded$ advance() {
                Object object = this.lock;
                synchronized (object) {
                    PimpedReadWriteLock$.MODULE$.pimpMyReadWriteLock(this.rwLock).write((Function0 & Serializable)() -> {
                        this.advance$$anonfun$1();
                        return BoxedUnit.UNIT;
                    });
                    this.lock.notifyAll();
                }
                return Succeeded$.MODULE$;
            }

            public int currentBeat() {
                int n;
                Object object = this.lock;
                synchronized (object) {
                    n = BoxesRunTime.unboxToInt(PimpedReadWriteLock$.MODULE$.pimpMyReadWriteLock(this.rwLock).read(this::currentBeat$$anonfun$1));
                }
                return n;
            }

            public Succeeded$ waitForBeat(int beat) {
                Object object = this.lock;
                synchronized (object) {
                    if (beat > this.highestBeatBeingWaitedOn) {
                        this.highestBeatBeingWaitedOn = beat;
                    }
                    while (this.currentBeat() < beat) {
                        this.liftedTree1$1();
                    }
                }
                return Succeeded$.MODULE$;
            }

            public boolean isAnyThreadWaitingForABeat() {
                boolean bl;
                Object object = this.lock;
                synchronized (object) {
                    bl = this.highestBeatBeingWaitedOn > this.currentTime;
                }
                return bl;
            }

            public <T> T withClockFrozen(Function0<T> fun) {
                return PimpedReadWriteLock$.MODULE$.pimpMyReadWriteLock(this.rwLock).read(fun);
            }

            public boolean isFrozen() {
                return this.rwLock.getReadLockCount() > 0;
            }

            private final void advance$$anonfun$1() {
                ++this.currentTime;
            }

            private final int currentBeat$$anonfun$1() {
                return this.currentTime;
            }

            private final void liftedTree1$1() {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException e) {
                    throw new AssertionError((Object)e);
                }
            }
        }

        public class ClockThread
        extends Thread
        implements Product,
        Serializable {
            private final Span timeout;
            private final Span clockInterval;
            private volatile long lastProgress;
            private volatile int deadlockCount;
            private final int MaxDeadlockDetectionsBeforeDeadlock;
            private final /* synthetic */ Conductor $outer;

            public ClockThread(Conductor $outer, Span timeout, Span clockInterval) {
                this.timeout = timeout;
                this.clockInterval = clockInterval;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                super("Conductor-Clock");
                this.setDaemon(true);
                this.lastProgress = System.nanoTime();
                this.deadlockCount = 0;
                this.MaxDeadlockDetectionsBeforeDeadlock = 50;
            }

            public int hashCode() {
                return ScalaRunTime$.MODULE$._hashCode((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$0) {
                if (this == x$0) return true;
                Object object = x$0;
                if (!(object instanceof ClockThread)) return false;
                if (((ClockThread)object).org$scalatest$concurrent$Conductors$Conductor$ClockThread$$$outer() != this.$outer) return false;
                ClockThread clockThread = (ClockThread)object;
                Span span = this.timeout();
                Span span2 = clockThread.timeout();
                if (span == null) {
                    if (span2 != null) {
                        return false;
                    }
                } else if (!((Object)span).equals(span2)) return false;
                Span span3 = this.clockInterval();
                Span span4 = clockThread.clockInterval();
                if (span3 == null) {
                    if (span4 != null) {
                        return false;
                    }
                } else if (!((Object)span3).equals(span4)) return false;
                if (!clockThread.canEqual(this)) return false;
                return true;
            }

            public boolean canEqual(Object that) {
                return that instanceof ClockThread;
            }

            public int productArity() {
                return 2;
            }

            public String productPrefix() {
                return "ClockThread";
            }

            public Object productElement(int n) {
                Span span;
                int n2 = n;
                if (0 == n2) {
                    span = this._1();
                } else if (1 == n2) {
                    span = this._2();
                } else {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
                return span;
            }

            public String productElementName(int n) {
                String string;
                int n2 = n;
                if (0 == n2) {
                    string = "timeout";
                } else if (1 == n2) {
                    string = "clockInterval";
                } else {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
                return string;
            }

            public Span timeout() {
                return this.timeout;
            }

            public Span clockInterval() {
                return this.clockInterval;
            }

            @Override
            public void run() {
                while (PimpedThreadGroup$.MODULE$.threadGroupToPimpedThreadGroup(this.$outer.org$scalatest$concurrent$Conductors$Conductor$$threadGroup).areAnyThreadsAlive()) {
                    if (!this.$outer.org$scalatest$concurrent$Conductors$Conductor$$firstExceptionThrown.isEmpty()) {
                        PimpedThreadGroup$.MODULE$.threadGroupToPimpedThreadGroup(this.$outer.org$scalatest$concurrent$Conductors$Conductor$$threadGroup).getThreads().foreach((Function1)((JProcedure1 & Serializable)Conductors::org$scalatest$concurrent$Conductors$Conductor$ClockThread$$_$run$$anonfun$1));
                    } else if (PimpedThreadGroup$.MODULE$.threadGroupToPimpedThreadGroup(this.$outer.org$scalatest$concurrent$Conductors$Conductor$$threadGroup).areAnyThreadsRunning()) {
                        if (this.runningTooLong()) {
                            this.stopDueToTimeout();
                        }
                    } else if (this.$outer.org$scalatest$concurrent$Conductors$Conductor$$clock.isAnyThreadWaitingForABeat()) {
                        this.$outer.org$scalatest$concurrent$Conductors$Conductor$$clock.advance();
                        this.deadlockCount = 0;
                        this.lastProgress = System.nanoTime();
                    } else if (!PimpedThreadGroup$.MODULE$.threadGroupToPimpedThreadGroup(this.$outer.org$scalatest$concurrent$Conductors$Conductor$$threadGroup).areAnyThreadsInTimedWaiting()) {
                        this.detectDeadlock();
                    }
                    Thread.sleep(this.clockInterval().millisPart(), this.clockInterval().nanosPart());
                }
            }

            private boolean runningTooLong() {
                return System.nanoTime() - this.lastProgress > this.timeout().totalNanos();
            }

            private void stopDueToTimeout() {
                String errorMessage = Resources$.MODULE$.testTimedOut(this.timeout().prettyString());
                this.$outer.org$scalatest$concurrent$Conductors$Conductor$$firstExceptionThrown.offer(new RuntimeException(errorMessage));
                this.$outer.org$scalatest$concurrent$Conductors$Conductor$$mainThread.interrupt();
            }

            private void detectDeadlock() {
                if (this.deadlockCount >= this.MaxDeadlockDetectionsBeforeDeadlock) {
                    String errorMessage = Resources$.MODULE$.suspectedDeadlock(BoxesRunTime.boxToInteger((int)this.MaxDeadlockDetectionsBeforeDeadlock).toString(), this.clockInterval().scaledBy(Int$.MODULE$.int2double(this.MaxDeadlockDetectionsBeforeDeadlock)).prettyString());
                    this.$outer.org$scalatest$concurrent$Conductors$Conductor$$firstExceptionThrown.offer(new RuntimeException(errorMessage));
                    this.$outer.org$scalatest$concurrent$Conductors$Conductor$$mainThread.interrupt();
                } else {
                    ++this.deadlockCount;
                }
            }

            public ClockThread copy(Span timeout, Span clockInterval) {
                return new ClockThread(this.$outer, timeout, clockInterval);
            }

            public Span copy$default$1() {
                return this.timeout();
            }

            public Span copy$default$2() {
                return this.clockInterval();
            }

            public Span _1() {
                return this.timeout();
            }

            public Span _2() {
                return this.clockInterval();
            }

            public final /* synthetic */ Conductor org$scalatest$concurrent$Conductors$Conductor$ClockThread$$$outer() {
                return this.$outer;
            }
        }

        public abstract class ConductorState
        implements Product,
        Serializable {
            private final boolean testWasStarted;
            private final boolean testIsFinished;

            public ConductorState(boolean testWasStarted, boolean testIsFinished) {
                this.testWasStarted = testWasStarted;
                this.testIsFinished = testIsFinished;
            }

            public boolean testWasStarted() {
                return this.testWasStarted;
            }

            public boolean testIsFinished() {
                return this.testIsFinished;
            }
        }

        public class TestThread
        extends Thread
        implements Product,
        Serializable {
            private final String name;
            private final Function0 f;
            private final /* synthetic */ Conductor $outer;

            public TestThread(Conductor $outer, String name, Function0<BoxedUnit> f) {
                this.name = name;
                this.f = f;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                super($outer.org$scalatest$concurrent$Conductors$Conductor$$TestThread$superArg$1(name, f), name);
                $outer.org$scalatest$concurrent$Conductors$Conductor$$testThreadsStartingCounter.increment();
            }

            public int hashCode() {
                return ScalaRunTime$.MODULE$._hashCode((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$0) {
                if (this == x$0) return true;
                Object object = x$0;
                if (!(object instanceof TestThread)) return false;
                if (((TestThread)object).org$scalatest$concurrent$Conductors$Conductor$TestThread$$$outer() != this.$outer) return false;
                TestThread testThread = (TestThread)object;
                String string = this.name();
                String string2 = testThread.name();
                if (string == null) {
                    if (string2 != null) {
                        return false;
                    }
                } else if (!string.equals(string2)) return false;
                Function0<BoxedUnit> function0 = this.f();
                Function0<BoxedUnit> function02 = testThread.f();
                if (function0 == null) {
                    if (function02 != null) {
                        return false;
                    }
                } else if (!function0.equals(function02)) return false;
                if (!testThread.canEqual(this)) return false;
                return true;
            }

            public boolean canEqual(Object that) {
                return that instanceof TestThread;
            }

            public int productArity() {
                return 2;
            }

            public String productPrefix() {
                return "TestThread";
            }

            public Object productElement(int n) {
                Function0<BoxedUnit> function0;
                int n2 = n;
                if (0 == n2) {
                    function0 = this._1();
                } else if (1 == n2) {
                    function0 = this._2();
                } else {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
                return function0;
            }

            public String productElementName(int n) {
                String string;
                int n2 = n;
                if (0 == n2) {
                    string = "name";
                } else if (1 == n2) {
                    string = "f";
                } else {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
                return string;
            }

            public String name() {
                return this.name;
            }

            public Function0<BoxedUnit> f() {
                return this.f;
            }

            @Override
            public void run() {
                block2: {
                    try {
                        this.$outer.org$scalatest$concurrent$Conductors$Conductor$$testThreadsStartingCounter.decrement();
                        this.$outer.org$scalatest$concurrent$Conductors$Conductor$$greenLightForTestThreads.await();
                        this.f().apply$mcV$sp();
                    }
                    catch (Throwable t) {
                        if (!this.$outer.org$scalatest$concurrent$Conductors$Conductor$$firstExceptionThrown.isEmpty()) break block2;
                        this.$outer.org$scalatest$concurrent$Conductors$Conductor$$firstExceptionThrown.offer(t);
                    }
                }
            }

            public TestThread copy(String name, Function0<BoxedUnit> f) {
                return new TestThread(this.$outer, name, f);
            }

            public String copy$default$1() {
                return this.name();
            }

            public Function0<BoxedUnit> copy$default$2() {
                return this.f();
            }

            public String _1() {
                return this.name();
            }

            public Function0<BoxedUnit> _2() {
                return this.f();
            }

            public final /* synthetic */ Conductor org$scalatest$concurrent$Conductors$Conductor$TestThread$$$outer() {
                return this.$outer;
            }
        }
    }
}

