/*
 * Decompiled with CFR 0.152.
 */
package org.scalatest.concurrent;

import org.scalatest.LinkedBlockingQueue;
import org.scalatest.Outcome;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;

public class SerialExecutionContext
implements ExecutionContext {
    private final LinkedBlockingQueue<Runnable> queue;

    public SerialExecutionContext() {
        ExecutionContext.$init$((ExecutionContext)this);
        this.queue = new LinkedBlockingQueue();
    }

    public void execute(Runnable runnable) {
        this.queue.put(runnable);
    }

    public void reportFailure(Throwable t) {
        t.printStackTrace();
    }

    public void runNow(Future<Outcome> future) {
        this.recRunNow(future);
    }

    private void recRunNow(Future<Outcome> future) {
        SerialExecutionContext serialExecutionContext = this;
        while (!future.isCompleted() || serialExecutionContext.queue.size() != 0) {
            Runnable task = serialExecutionContext.queue.take();
            task.run();
        }
    }
}

