/*
 * Decompiled with CFR 0.152.
 */
package org.scalatest.concurrent;

import java.util.concurrent.CountDownLatch;

public class TestThreadsStartingCounter {
    private int count = 0;
    private final CountDownLatch latch = new CountDownLatch(1);

    public void increment() {
        TestThreadsStartingCounter testThreadsStartingCounter = this;
        synchronized (testThreadsStartingCounter) {
            ++this.count;
        }
        this.latch.countDown();
    }

    public void decrement() {
        TestThreadsStartingCounter testThreadsStartingCounter = this;
        synchronized (testThreadsStartingCounter) {
            --this.count;
            this.notifyAll();
        }
    }

    public void waitUntilAllTestThreadsHaveStarted() {
        this.latch.await();
        TestThreadsStartingCounter testThreadsStartingCounter = this;
        synchronized (testThreadsStartingCounter) {
            while (this.count != 0) {
                this.wait();
            }
        }
    }
}

