/*
 * Decompiled with CFR 0.152.
 */
package org.scalatest.tools;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import javax.swing.JPanel;

public class ColorBar
extends JPanel {
    private final Color HANDSOME_GREEN = new Color(85, 238, 102);
    private final Color DEEP_RED = new Color(238, 85, 102);
    private final Color SENSIBLE_GRAY = new Color(238, 238, 238);
    private int max = 0;
    private int value = 0;
    private Color barColor = this.HANDSOME_GREEN;
    private Image offscreenImage;

    public ColorBar() {
        this.setBackground(this.SENSIBLE_GRAY);
    }

    public void setGreen() {
        this.barColor = this.HANDSOME_GREEN;
        this.repaint();
    }

    public void setRed() {
        this.barColor = this.DEEP_RED;
        this.repaint();
    }

    public void setGray() {
        this.barColor = this.SENSIBLE_GRAY;
        this.repaint();
    }

    public void setValue(int value) {
        if (value < 0) {
            throw new IllegalArgumentException();
        }
        this.value = value;
        if (value > this.max) {
            this.max = value;
        }
        this.repaint();
    }

    public void setMax(int max) {
        if (max < 0) {
            throw new IllegalArgumentException();
        }
        this.max = max;
        if (this.value > max) {
            this.value = max;
        }
        this.repaint();
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    @Override
    public void paint(Graphics g) {
        int extent;
        int n;
        Dimension dim = this.getSize();
        if (this.offscreenImage == null) {
            this.offscreenImage = this.createImage(dim.width, dim.height);
        } else {
            int offWidth = this.offscreenImage.getWidth(null);
            int offHeight = this.offscreenImage.getHeight(null);
            if (offWidth != dim.width || offHeight != dim.height) {
                this.offscreenImage = this.createImage(dim.width, dim.height);
            }
        }
        Graphics og = this.offscreenImage.getGraphics();
        og.setColor(this.SENSIBLE_GRAY);
        og.fillRect(0, 0, dim.width, dim.height);
        int localVal = this.value;
        int localMax = this.max;
        if (localVal >= localMax) {
            n = dim.width + 1;
        } else if (localVal != 0) {
            float floatExtent = (float)dim.width * (float)localVal / (float)localMax;
            n = (int)floatExtent;
        } else {
            n = extent = 0;
        }
        if (this.max != 0) {
            og.setColor(this.barColor);
            og.fillRect(0, 0, extent, dim.height + 1);
        }
        g.drawImage(this.offscreenImage, 0, 0, this);
    }
}

