/*
 * Decompiled with CFR 0.152.
 */
package org.scalatest.tools;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.regex.Matcher;
import org.scalatest.Reporter;
import org.scalatest.events.AlertProvided;
import org.scalatest.events.DiscoveryCompleted;
import org.scalatest.events.DiscoveryStarting;
import org.scalatest.events.Event;
import org.scalatest.events.Formatter;
import org.scalatest.events.IndentedText;
import org.scalatest.events.IndentedText$;
import org.scalatest.events.InfoProvided;
import org.scalatest.events.MarkupProvided;
import org.scalatest.events.NoteProvided;
import org.scalatest.events.RunAborted;
import org.scalatest.events.RunCompleted;
import org.scalatest.events.RunStarting;
import org.scalatest.events.RunStopped;
import org.scalatest.events.ScopeClosed;
import org.scalatest.events.ScopeOpened;
import org.scalatest.events.ScopePending;
import org.scalatest.events.SuiteAborted;
import org.scalatest.events.SuiteCompleted;
import org.scalatest.events.SuiteStarting;
import org.scalatest.events.Summary;
import org.scalatest.events.Summary$;
import org.scalatest.events.TestCanceled;
import org.scalatest.events.TestFailed;
import org.scalatest.events.TestIgnored;
import org.scalatest.events.TestPending;
import org.scalatest.events.TestStarting;
import org.scalatest.events.TestSucceeded;
import org.scalatest.exceptions.StackDepthException;
import org.scalatest.tools.DashboardReporter;
import org.scalatest.tools.DashboardReporter$SlowRecord$3$;
import org.scalatest.tools.DashboardReporter$TestRecord$Duration$;
import org.scalatest.tools.Durations;
import org.scalatest.tools.Durations$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Stack;
import scala.collection.mutable.Stack$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LazyRef;
import scala.runtime.LazyVals$;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.Node;
import scala.xml.NodeBuffer;
import scala.xml.NodeSeq;
import scala.xml.NodeSeq$;
import scala.xml.Null$;
import scala.xml.PCData$;
import scala.xml.Text;
import scala.xml.TopScope$;
import scala.xml.Utility$;
import scala.xml.XML$;

public class DashboardReporter
implements Reporter {
    private final String directory;
    private final int numOldFilesToKeep;
    private final ListBuffer<Event> events;
    private int index;
    private String timestamp;
    private final File runsDir;
    private final File durationsDir;
    private final File summariesDir;
    private final File summaryFile;
    private final File durationsFile;

    public DashboardReporter(String directory, int numOldFilesToKeep) {
        this.directory = directory;
        this.numOldFilesToKeep = numOldFilesToKeep;
        this.events = (ListBuffer)ListBuffer$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Event[0]));
        this.index = 0;
        this.timestamp = "";
        String TimestampPattern = "\\d{4}-\\d{2}-\\d{2}-\\d{6}-\\d{3}";
        this.runsDir = new File(new java.lang.StringBuilder(5).append(directory).append("/runs").toString());
        this.durationsDir = new File(new java.lang.StringBuilder(10).append(directory).append("/durations").toString());
        this.summariesDir = new File(new java.lang.StringBuilder(10).append(directory).append("/summaries").toString());
        this.summaryFile = new File(new java.lang.StringBuilder(12).append(directory).append("/summary.xml").toString());
        this.durationsFile = new File(new java.lang.StringBuilder(14).append(directory).append("/durations.xml").toString());
        this.runsDir.mkdir();
        this.durationsDir.mkdir();
        this.summariesDir.mkdir();
    }

    public final int BufferSize() {
        return 4096;
    }

    @Override
    public void apply(Event event) {
        block6: {
            Event event2;
            block7: {
                event2 = event;
                if (event2 instanceof DiscoveryStarting || event2 instanceof DiscoveryCompleted) break block6;
                if (!(event2 instanceof RunStarting)) break block7;
                this.timestamp = this.formatCurrentTime();
                break block6;
            }
            if (event2 instanceof InfoProvided || event2 instanceof AlertProvided || event2 instanceof NoteProvided || event2 instanceof ScopeOpened || event2 instanceof ScopeClosed || event2 instanceof ScopePending || event2 instanceof MarkupProvided) break block6;
            if (event2 instanceof RunCompleted) {
                this.writeFiles(event);
            } else if (event2 instanceof RunStopped) {
                this.writeFiles(event);
            } else if (event2 instanceof RunAborted) {
                this.writeFiles(event);
            } else {
                this.events.$plus$eq((Object)event);
            }
        }
    }

    public String formatCurrentTime() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd-HHmmss-SSS");
        df.setTimeZone(TimeZone.getTimeZone("GMT"));
        return df.format(new Date());
    }

    public int nextIndex() {
        ++this.index;
        return this.index;
    }

    public void unexpectedEvent(Event e) {
        throw new RuntimeException(new java.lang.StringBuilder(19).append("unexpected event [").append(e).append("]").toString());
    }

    public String escape(String s) {
        return Utility$.MODULE$.escape(s).replaceAll("\\{", "\\\\{").replaceAll("\\}", "\\\\}");
    }

    public String formatDate(long timeStamp) {
        SimpleDateFormat df = new SimpleDateFormat("EEE MMM d kk:mm:ss zzz yyyy");
        return df.format(new Date(timeStamp));
    }

    public Elem getOldSummaryXml() {
        Elem elem;
        if (this.summaryFile.exists()) {
            elem = (Elem)XML$.MODULE$.loadFile(this.summaryFile);
        } else {
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)new Text("\n        "));
            $buf.$amp$plus((Object)new Elem(null, "runs", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, true, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Node[0])));
            $buf.$amp$plus((Object)new Text("\n        "));
            $buf.$amp$plus((Object)new Elem(null, "regressions", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, true, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Node[0])));
            $buf.$amp$plus((Object)new Text("\n        "));
            $buf.$amp$plus((Object)new Elem(null, "recentlySlower", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, true, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Node[0])));
            $buf.$amp$plus((Object)new Text("\n      "));
            Elem elem2 = new Elem(null, "summary", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf));
            elem = elem2;
        }
        return elem;
    }

    public void archiveOldFiles(NodeSeq oldRunsXml) {
        None$ previousRunTimestamp;
        Object object = previousRunTimestamp = oldRunsXml.size() > 0 ? Some$.MODULE$.apply((Object)String.valueOf(oldRunsXml.apply(0).$bslash("@id"))) : None$.MODULE$;
        if (previousRunTimestamp.isDefined()) {
            if (this.summaryFile.exists()) {
                this.summaryFile.renameTo(new File(new java.lang.StringBuilder(13).append(this.summariesDir.toString()).append("/summary-").append(previousRunTimestamp.get()).append(".xml").toString()));
            }
            if (this.durationsFile.exists()) {
                this.durationsFile.renameTo(new File(new java.lang.StringBuilder(14).append(this.durationsDir.toString()).append("/duration-").append(previousRunTimestamp.get()).append(".xml").toString()));
            }
            this.purgeDir(this.summariesDir, "summary-");
            this.purgeDir(this.durationsDir, "duration-");
        }
    }

    public void purgeDir(File directory, String prefix) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])directory.listFiles());
        Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(object, (Function1 & Serializable)_$1 -> _$1.getName().matches(new java.lang.StringBuilder(34).append(prefix).append("\\d{4}-\\d{2}-\\d{2}-\\d{6}-\\d{3}").append("\\.xml").toString())));
        Object object3 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.sorted$extension(object2, Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms())));
        Object object4 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.dropRight$extension(object3, this.numOldFilesToKeep));
        ArrayOps$.MODULE$.foreach$extension(object4, (Function1 & Serializable)_$2 -> _$2.delete());
    }

    public void writeFiles(Event terminatingEvent) {
        Durations durations = Durations$.MODULE$.apply(this.durationsFile);
        Elem oldSummaryXml = this.getOldSummaryXml();
        NodeSeq oldRunsXml = oldSummaryXml.$bslash$bslash("run");
        this.archiveOldFiles(oldRunsXml);
        File thisRunFile = new File(this.runsDir, new java.lang.StringBuilder(8).append("run-").append(this.timestamp).append(".xml").toString());
        this.writeRunFile(terminatingEvent, thisRunFile);
        Elem thisRunXml = (Elem)XML$.MODULE$.loadFile(thisRunFile);
        durations.addTests(this.timestamp, (NodeSeq)thisRunXml);
        this.writeDurationsFile(durations);
        this.writeSummaryFile(terminatingEvent, (NodeSeq)oldSummaryXml, oldRunsXml, (NodeSeq)thisRunXml, durations);
    }

    public void writeDurationsFile(Durations durations) {
        this.writeFile("durations.xml", durations.toXml());
    }

    public void writeSummaryFile(Event terminatingEvent, NodeSeq oldSummaryXml, NodeSeq oldRunsXml, NodeSeq thisRunXml, Durations durations) {
        String SummaryTemplate = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|<summary>\n         |  <runs>\n         |$runs$  </runs>\n         |  <regressions>\n         |$regressions$  </regressions>\n         |  <recentlySlower>\n         |$recentlySlower$  </recentlySlower>\n         |</summary>\n         |"));
        String thisRun = this.genThisRun$1(terminatingEvent);
        String oldRuns = DashboardReporter.formatOldRuns$1(oldRunsXml);
        String regressions = this.genRegressions$1(oldSummaryXml, thisRunXml);
        String recentlySlower = this.genRecentlySlower$1(durations);
        String summaryText = SummaryTemplate.replaceFirst("\\$runs\\$", Matcher.quoteReplacement(new java.lang.StringBuilder(0).append(thisRun).append(oldRuns).toString())).replaceFirst("\\$regressions\\$", Matcher.quoteReplacement(regressions)).replaceFirst("\\$recentlySlower\\$", Matcher.quoteReplacement(recentlySlower));
        this.writeFile("summary.xml", summaryText);
    }

    public void writeFile(String filename, String text) {
        PrintWriter out = new PrintWriter(new java.lang.StringBuilder(1).append(this.directory).append("/").append(filename).toString());
        out.print(text);
        out.close();
    }

    public void writeRunFile(Event event2, File thisRunFile) {
        this.index = 0;
        ObjectRef suiteRecord = ObjectRef.create(null);
        Stack stack = new Stack(Stack$.MODULE$.$lessinit$greater$default$1());
        PrintWriter pw = new PrintWriter(new BufferedOutputStream(new FileOutputStream(thisRunFile), 4096));
        pw.println("<doc>");
        pw.print(this.formatSummary$1(event2));
        ((IterableOnceOps)this.events.sorted(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()))).foreach((Function1)(JProcedure1 & Serializable)event -> {
            Event event2 = event;
            if (event2 instanceof SuiteStarting) {
                SuiteStarting e = (SuiteStarting)event2;
                stack.push((Object)((SuiteRecord)suiteRecord$2.elem));
                SuiteRecord suiteRecord = new SuiteRecord(this, e);
                suiteRecord$2.elem = suiteRecord;
                suiteRecord = null;
            } else if (event2 instanceof TestStarting) {
                TestStarting e = (TestStarting)event2;
                ((SuiteRecord)suiteRecord$2.elem).addNestedElement(e);
            } else if (event2 instanceof TestSucceeded) {
                TestSucceeded e = (TestSucceeded)event2;
                ((SuiteRecord)suiteRecord$2.elem).addNestedElement(e);
            } else if (event2 instanceof TestIgnored) {
                TestIgnored e = (TestIgnored)event2;
                ((SuiteRecord)suiteRecord$2.elem).addNestedElement(e);
            } else if (event2 instanceof TestFailed) {
                TestFailed e = (TestFailed)event2;
                ((SuiteRecord)suiteRecord$2.elem).addNestedElement(e);
            } else if (event2 instanceof TestPending) {
                TestPending e = (TestPending)event2;
                ((SuiteRecord)suiteRecord$2.elem).addNestedElement(e);
            } else if (event2 instanceof TestCanceled) {
                TestCanceled e = (TestCanceled)event2;
                ((SuiteRecord)suiteRecord$2.elem).addNestedElement(e);
            } else if (event2 instanceof SuiteCompleted) {
                SuiteCompleted e = (SuiteCompleted)event2;
                DashboardReporter.endSuite$1(suiteRecord, stack, pw, e);
            } else if (event2 instanceof SuiteAborted) {
                SuiteAborted e = (SuiteAborted)event2;
                DashboardReporter.endSuite$1(suiteRecord, stack, pw, e);
            } else if (event2 instanceof DiscoveryStarting) {
                DiscoveryStarting e = (DiscoveryStarting)event2;
                this.unexpectedEvent(e);
            } else if (event2 instanceof DiscoveryCompleted) {
                DiscoveryCompleted e = (DiscoveryCompleted)event2;
                this.unexpectedEvent(e);
            } else if (event2 instanceof RunStarting) {
                RunStarting e = (RunStarting)event2;
                this.unexpectedEvent(e);
            } else if (event2 instanceof RunCompleted) {
                RunCompleted e = (RunCompleted)event2;
                this.unexpectedEvent(e);
            } else if (event2 instanceof RunStopped) {
                RunStopped e = (RunStopped)event2;
                this.unexpectedEvent(e);
            } else if (event2 instanceof RunAborted) {
                RunAborted e = (RunAborted)event2;
                this.unexpectedEvent(e);
            } else if (event2 instanceof InfoProvided) {
                InfoProvided e = (InfoProvided)event2;
                this.unexpectedEvent(e);
            } else if (event2 instanceof AlertProvided) {
                AlertProvided e = (AlertProvided)event2;
                this.unexpectedEvent(e);
            } else if (event2 instanceof NoteProvided) {
                NoteProvided e = (NoteProvided)event2;
                this.unexpectedEvent(e);
            } else if (event2 instanceof ScopeOpened) {
                ScopeOpened e = (ScopeOpened)event2;
                this.unexpectedEvent(e);
            } else if (event2 instanceof ScopeClosed) {
                ScopeClosed e = (ScopeClosed)event2;
                this.unexpectedEvent(e);
            } else if (event2 instanceof ScopePending) {
                ScopePending e = (ScopePending)event2;
                this.unexpectedEvent(e);
            } else if (event2 instanceof MarkupProvided) {
                MarkupProvided e = (MarkupProvided)event2;
                this.unexpectedEvent(e);
            } else {
                throw new MatchError((Object)event2);
            }
        });
        pw.println("</doc>");
        pw.flush();
        pw.close();
    }

    public String formatTestIgnored(TestIgnored event) {
        return new java.lang.StringBuilder(60).append("<test index=\"").append(this.nextIndex()).append("\" ").append("result=\"ignored\" ").append("text=\"").append(this.testMessage(event.testName(), event.formatter())).append("\" ").append("name=\"").append(this.escape(event.testName())).append("\" ").append("thread=\"").append(event.threadName()).append("\"").append("/>\n").toString();
    }

    public String testMessage(String testName, Option<Formatter> formatter) {
        String string;
        Formatter formatter2;
        Option<Formatter> option = formatter;
        if (option instanceof Some && (formatter2 = (Formatter)((Some)option).value()) instanceof IndentedText) {
            String rawText;
            IndentedText indentedText = IndentedText$.MODULE$.unapply((IndentedText)formatter2);
            String string2 = indentedText._1();
            String string3 = indentedText._2();
            int n = indentedText._3();
            string = rawText = string3;
        } else {
            string = testName;
        }
        String message = string;
        return this.escape(message);
    }

    private static final String formatRun$1(String id, String succeeded, String failed, String ignored, String canceled, String pending) {
        return new java.lang.StringBuilder(75).append("    <run id=\"").append(id).append("\" ").append("succeeded=\"").append(succeeded).append("\" ").append("failed=\"").append(failed).append("\" ").append("ignored=\"").append(ignored).append("\" ").append("canceled=\"").append(canceled).append("\" ").append("pending=\"").append(pending).append("\" ").append("/>\n").toString();
    }

    private static final Summary $anonfun$1() {
        return Summary$.MODULE$.apply(0, 0, 0, 0, 0, 0, 0, 0);
    }

    private final String genThisRun$1(Event terminatingEvent) {
        Option<Summary> option;
        Event event = terminatingEvent;
        if (event instanceof RunCompleted) {
            RunCompleted e = (RunCompleted)event;
            option = e.summary();
        } else if (event instanceof RunAborted) {
            RunAborted e = (RunAborted)event;
            option = e.summary();
        } else if (event instanceof RunStopped) {
            RunStopped e = (RunStopped)event;
            option = e.summary();
        } else {
            this.unexpectedEvent(terminatingEvent);
            option = None$.MODULE$;
        }
        Option<Summary> summaryOption = option;
        Summary summary = (Summary)summaryOption.getOrElse(DashboardReporter::$anonfun$1);
        return DashboardReporter.formatRun$1(this.timestamp, String.valueOf(BoxesRunTime.boxToInteger((int)summary.testsSucceededCount())), String.valueOf(BoxesRunTime.boxToInteger((int)summary.testsFailedCount())), String.valueOf(BoxesRunTime.boxToInteger((int)summary.testsIgnoredCount())), String.valueOf(BoxesRunTime.boxToInteger((int)summary.testsCanceledCount())), String.valueOf(BoxesRunTime.boxToInteger((int)summary.testsPendingCount())));
    }

    private static final String formatOldRuns$1(NodeSeq oldRunsXml) {
        StringBuilder buf = new StringBuilder();
        oldRunsXml.foreach((Function1 & Serializable)run2 -> {
            String id = String.valueOf(run2.$bslash("@id"));
            String succeeded = String.valueOf(run2.$bslash("@succeeded"));
            String failed = String.valueOf(run2.$bslash("@failed"));
            String ignored = String.valueOf(run2.$bslash("@ignored"));
            String canceled = String.valueOf(run2.$bslash("@canceled"));
            String pending = String.valueOf(run2.$bslash("@pending"));
            return buf.append(DashboardReporter.formatRun$1(id, succeeded, failed, ignored, canceled, pending));
        });
        return buf.toString();
    }

    private static final Option getOldRegression$1(Node suite, Node test, NodeSeq oldRegressionsXml) {
        return oldRegressionsXml.find((Function1 & Serializable)node -> {
            NodeSeq nodeSeq = node.$bslash("@testName");
            NodeSeq nodeSeq2 = test.$bslash("@name");
            if (nodeSeq == null) {
                if (nodeSeq2 != null) {
                    return false;
                }
            } else if (!nodeSeq.equals(nodeSeq2)) return false;
            NodeSeq nodeSeq3 = node.$bslash("@suiteId");
            NodeSeq nodeSeq4 = suite.$bslash("@id");
            if (nodeSeq3 == null) {
                if (nodeSeq4 == null) return true;
                return false;
            } else {
                if (!nodeSeq3.equals(nodeSeq4)) return false;
                return true;
            }
        });
    }

    private static final String formatRegression$1(Node suite, Node test, String result, String lastSucceeded, String firstRegressed) {
        return new java.lang.StringBuilder(102).append("    <regressedTest suiteId=\"").append(suite.$bslash("@id")).append("\" ").append("suiteName=\"").append(suite.$bslash("@name")).append("\" ").append("testName=\"").append(test.$bslash("@name")).append("\" ").append("status=\"").append(result).append("\" ").append("firstRegressed=\"").append(firstRegressed).append("\" ").append("lastSucceeded=\"").append(lastSucceeded).append("\"/>\n").toString();
    }

    private static final Option getLastRunId$1(NodeSeq oldSummaryXml$1) {
        NodeSeq previousRuns = oldSummaryXml$1.$bslash$bslash("run");
        return previousRuns.size() > 0 ? Some$.MODULE$.apply((Object)String.valueOf(previousRuns.apply(0).$bslash("@id"))) : None$.MODULE$;
    }

    private final NodeSeq getLastRunXml$1(Option lastRunId) {
        return lastRunId.isDefined() ? XML$.MODULE$.loadFile(new java.lang.StringBuilder(14).append(this.directory).append("/runs/run-").append(lastRunId.get()).append(".xml").toString()) : NodeSeq$.MODULE$.Empty();
    }

    private static final boolean lastRunSucceeded$1(Node suite, Node test, NodeSeq lastRunXml) {
        boolean found = false;
        boolean succeeded = false;
        Iterator oldSuitesIt = lastRunXml.$bslash$bslash("suite").iterator();
        while (!found && oldSuitesIt.hasNext()) {
            String result;
            NodeSeq oldTests;
            Option matchingTest;
            Node oldSuite = (Node)oldSuitesIt.next();
            NodeSeq nodeSeq = oldSuite.$bslash("@id");
            NodeSeq nodeSeq2 = suite.$bslash("@id");
            if ((nodeSeq != null ? !nodeSeq.equals(nodeSeq2) : nodeSeq2 != null) || !(matchingTest = (oldTests = oldSuite.$bslash("test")).find((Function1 & Serializable)node -> {
                NodeSeq nodeSeq = node.$bslash("@name");
                NodeSeq nodeSeq2 = test.$bslash("@name");
                return !(nodeSeq != null ? !nodeSeq.equals(nodeSeq2) : nodeSeq2 != null);
            })).isDefined()) continue;
            found = true;
            String string = result = String.valueOf(((NodeSeq)matchingTest.get()).$bslash("@result"));
            String string2 = "succeeded";
            succeeded = !(string != null ? !string.equals(string2) : string2 != null);
        }
        return succeeded;
    }

    private final String genRegressions$1(NodeSeq oldSummaryXml, NodeSeq thisRunXml) {
        StringBuilder buf = new StringBuilder();
        NodeSeq suites = thisRunXml.$bslash$bslash("suite");
        NodeSeq oldRegressionsXml = oldSummaryXml.$bslash$bslash("regressedTest");
        Option lastRunId = DashboardReporter.getLastRunId$1(oldSummaryXml);
        NodeSeq lastRunXml = this.getLastRunXml$1(lastRunId);
        suites.foreach((Function1)(JProcedure1 & Serializable)suite -> suite.$bslash("test").foreach((Function1)(JProcedure1 & Serializable)test -> {
            block2: {
                String firstRegressed;
                String lastSucceeded;
                String result;
                block3: {
                    String string = result = String.valueOf(test.$bslash("@result"));
                    String string2 = "succeeded";
                    if (!(string == null ? string2 != null : !string.equals(string2))) break block2;
                    Option oldRegression = DashboardReporter.getOldRegression$1(suite, test, oldRegressionsXml);
                    lastSucceeded = oldRegression.isDefined() ? String.valueOf(((NodeSeq)oldRegression.get()).$bslash("@lastSucceeded")) : (DashboardReporter.lastRunSucceeded$1(suite, test, lastRunXml) ? (String)lastRunId.get() : "never");
                    firstRegressed = oldRegression.isDefined() ? String.valueOf(((NodeSeq)oldRegression.get()).$bslash("@firstRegressed")) : this.timestamp;
                    String string3 = result;
                    String string4 = "pending";
                    if (string3 != null ? !string3.equals(string4) : string4 != null) break block3;
                    String string5 = lastSucceeded;
                    String string6 = "never";
                    if (!(string5 == null ? string6 != null : !string5.equals(string6))) break block2;
                }
                buf.append(DashboardReporter.formatRegression$1(suite, test, result, lastSucceeded, firstRegressed));
            }
        }));
        return buf.toString();
    }

    private final DashboardReporter$SlowRecord$3$ SlowRecord$lzyINIT1$1(LazyRef SlowRecord$lzy1$1) {
        DashboardReporter$SlowRecord$3$ dashboardReporter$SlowRecord$3$;
        LazyRef lazyRef = SlowRecord$lzy1$1;
        synchronized (lazyRef) {
            dashboardReporter$SlowRecord$3$ = (DashboardReporter$SlowRecord$3$)(SlowRecord$lzy1$1.initialized() ? SlowRecord$lzy1$1.value() : SlowRecord$lzy1$1.initialize((Object)new DashboardReporter$SlowRecord$3$(this)));
        }
        return dashboardReporter$SlowRecord$3$;
    }

    private final DashboardReporter$SlowRecord$3$ SlowRecord$2(LazyRef SlowRecord$lzy1$2) {
        return (DashboardReporter$SlowRecord$3$)(SlowRecord$lzy1$2.initialized() ? SlowRecord$lzy1$2.value() : this.SlowRecord$lzyINIT1$1(SlowRecord$lzy1$2));
    }

    private static final String toXml$1(ObjectRef slowRecords$1) {
        StringBuilder buf = new StringBuilder();
        ((List)slowRecords$1.elem).foreach((Function1 & Serializable)slowRecord -> buf.append(slowRecord.toXml()));
        return buf.toString();
    }

    private final String genRecentlySlower$1(Durations durations) {
        LazyRef lazyRef = new LazyRef();
        public class Org_scalatest_tools_DashboardReporter$SlowRecord$1
        implements Product,
        Serializable {
            private final Durations.Suite suite;
            private final Durations.Test test;
            private final int oldAvg;
            private final int newAvg;
            private final int percentSlower;
            private final /* synthetic */ DashboardReporter $outer;

            public Org_scalatest_tools_DashboardReporter$SlowRecord$1(DashboardReporter $outer, Durations.Suite suite, Durations.Test test, int oldAvg, int newAvg, int percentSlower) {
                this.suite = suite;
                this.test = test;
                this.oldAvg = oldAvg;
                this.newAvg = newAvg;
                this.percentSlower = percentSlower;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public int hashCode() {
                int n = -889275714;
                n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
                n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.suite()));
                n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.test()));
                n = Statics.mix((int)n, (int)this.oldAvg());
                n = Statics.mix((int)n, (int)this.newAvg());
                n = Statics.mix((int)n, (int)this.percentSlower());
                return Statics.finalizeHash((int)n, (int)5);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$0) {
                if (this == x$0) return true;
                Object object = x$0;
                if (!(object instanceof Org_scalatest_tools_DashboardReporter$SlowRecord$1)) return false;
                Org_scalatest_tools_DashboardReporter$SlowRecord$1 var3_3 = (Org_scalatest_tools_DashboardReporter$SlowRecord$1)object;
                if (this.oldAvg() != var3_3.oldAvg()) return false;
                if (this.newAvg() != var3_3.newAvg()) return false;
                if (this.percentSlower() != var3_3.percentSlower()) return false;
                Durations.Suite suite = this.suite();
                Durations.Suite suite2 = var3_3.suite();
                if (suite == null) {
                    if (suite2 != null) {
                        return false;
                    }
                } else if (!((Object)suite).equals(suite2)) return false;
                Durations.Test test = this.test();
                Durations.Test test2 = var3_3.test();
                if (test == null) {
                    if (test2 != null) {
                        return false;
                    }
                } else if (!((Object)test).equals(test2)) return false;
                if (!var3_3.canEqual(this)) return false;
                return true;
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            public boolean canEqual(Object that) {
                return that instanceof Org_scalatest_tools_DashboardReporter$SlowRecord$1;
            }

            public int productArity() {
                return 5;
            }

            public String productPrefix() {
                return "SlowRecord";
            }

            public Object productElement(int n) {
                Serializable serializable;
                int n2 = n;
                switch (n2) {
                    case 0: {
                        serializable = this._1();
                        break;
                    }
                    case 1: {
                        serializable = this._2();
                        break;
                    }
                    case 2: {
                        serializable = BoxesRunTime.boxToInteger((int)this._3());
                        break;
                    }
                    case 3: {
                        serializable = BoxesRunTime.boxToInteger((int)this._4());
                        break;
                    }
                    case 4: {
                        serializable = BoxesRunTime.boxToInteger((int)this._5());
                        break;
                    }
                    default: {
                        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                    }
                }
                return serializable;
            }

            public String productElementName(int n) {
                String string;
                int n2 = n;
                switch (n2) {
                    case 0: {
                        string = "suite";
                        break;
                    }
                    case 1: {
                        string = "test";
                        break;
                    }
                    case 2: {
                        string = "oldAvg";
                        break;
                    }
                    case 3: {
                        string = "newAvg";
                        break;
                    }
                    case 4: {
                        string = "percentSlower";
                        break;
                    }
                    default: {
                        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                    }
                }
                return string;
            }

            public Durations.Suite suite() {
                return this.suite;
            }

            public Durations.Test test() {
                return this.test;
            }

            public int oldAvg() {
                return this.oldAvg;
            }

            public int newAvg() {
                return this.newAvg;
            }

            public int percentSlower() {
                return this.percentSlower;
            }

            public String toXml() {
                String SlowerTestTemplate = new java.lang.StringBuilder(84).append("      <slowerTest suiteId=\"$suiteId$\" suiteName=\"$suiteName$\" testName=\"$testName$\" ").append(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|oldAvg=\"$oldAvg$\" newAvg=\"$newAvg$\"/>\n               |"))).toString();
                return SlowerTestTemplate.replaceFirst("\\$suiteId\\$", Matcher.quoteReplacement(this.suite().suiteId())).replaceFirst("\\$suiteName\\$", Matcher.quoteReplacement(this.suite().suiteName())).replaceFirst("\\$testName\\$", Matcher.quoteReplacement(this.test().name())).replaceFirst("\\$oldAvg\\$", String.valueOf(BoxesRunTime.boxToInteger((int)this.oldAvg()))).replaceFirst("\\$newAvg\\$", String.valueOf(BoxesRunTime.boxToInteger((int)this.newAvg())));
            }

            public Org_scalatest_tools_DashboardReporter$SlowRecord$1 copy(Durations.Suite suite, Durations.Test test, int oldAvg, int newAvg, int percentSlower) {
                return new Org_scalatest_tools_DashboardReporter$SlowRecord$1(this.$outer, suite, test, oldAvg, newAvg, percentSlower);
            }

            public Durations.Suite copy$default$1() {
                return this.suite();
            }

            public Durations.Test copy$default$2() {
                return this.test();
            }

            public int copy$default$3() {
                return this.oldAvg();
            }

            public int copy$default$4() {
                return this.newAvg();
            }

            public int copy$default$5() {
                return this.percentSlower();
            }

            public Durations.Suite _1() {
                return this.suite();
            }

            public Durations.Test _2() {
                return this.test();
            }

            public int _3() {
                return this.oldAvg();
            }

            public int _4() {
                return this.newAvg();
            }

            public int _5() {
                return this.percentSlower();
            }

            public final /* synthetic */ DashboardReporter org$scalatest$tools$DashboardReporter$_$_$SlowRecord$$$outer() {
                return this.$outer;
            }
        }
        ObjectRef slowRecords = ObjectRef.create((Object)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Org_scalatest_tools_DashboardReporter$SlowRecord$1[0]))));
        durations.suites().foreach((Function1)(JProcedure1 & Serializable)suite -> suite.tests().foreach((Function1)(JProcedure1 & Serializable)test -> {
            if (test.runCount() > 10) {
                int percentSlower;
                int oldAvg = test.previousAverage();
                int newAvg = test.computeNewAvg();
                if (newAvg - oldAvg > 1 && oldAvg > 0 && (percentSlower = (int)((double)(newAvg - oldAvg) / (double)oldAvg * (double)100)) > 10) {
                    List list = ((List)slowRecords$3.elem).$colon$colon((Object)this.SlowRecord$2(lazyRef).apply((Durations.Suite)suite, (Durations.Test)test, oldAvg, newAvg, percentSlower));
                    slowRecords$3.elem = list;
                    list = null;
                }
            }
        }));
        List list = ((List)((List)slowRecords.elem).sortBy((Function1 & Serializable)r -> r.percentSlower(), (Ordering)Ordering.Int$.MODULE$)).take(20);
        slowRecords.elem = list;
        list = null;
        return DashboardReporter.toXml$1(slowRecords);
    }

    private static final Summary $anonfun$3() {
        return Summary$.MODULE$.apply(0, 0, 0, 0, 0, 0, 0, 0);
    }

    private static final int $anonfun$4() {
        return 0;
    }

    private final String formatSummary$1(Event event) {
        Tuple2 tuple2;
        Event event2 = event;
        if (event2 instanceof RunCompleted) {
            RunCompleted e = (RunCompleted)event2;
            tuple2 = Tuple2$.MODULE$.apply(e.summary(), e.duration());
        } else if (event2 instanceof RunAborted) {
            RunAborted e = (RunAborted)event2;
            tuple2 = Tuple2$.MODULE$.apply(e.summary(), e.duration());
        } else if (event2 instanceof RunStopped) {
            RunStopped e = (RunStopped)event2;
            tuple2 = Tuple2$.MODULE$.apply(e.summary(), e.duration());
        } else {
            this.unexpectedEvent(event);
            tuple2 = Tuple2$.MODULE$.apply((Object)None$.MODULE$, (Object)None$.MODULE$);
        }
        Tuple2 tuple22 = tuple2;
        Option summaryOption = (Option)tuple22._1();
        Option durationOption = (Option)tuple22._2();
        Summary summary = (Summary)summaryOption.getOrElse(DashboardReporter::$anonfun$3);
        Object duration = durationOption.getOrElse(DashboardReporter::$anonfun$4);
        return new java.lang.StringBuilder(212).append("<summary index=\"").append(this.nextIndex()).append("\" text=\"\" ").append("duration=\"").append(duration).append("\" ").append("testsSucceededCount=\"").append(summary.testsSucceededCount()).append("\" ").append("testsFailedCount=\"").append(summary.testsFailedCount()).append("\" ").append("testsIgnoredCount=\"").append(summary.testsIgnoredCount()).append("\" ").append("testsPendingCount=\"").append(summary.testsPendingCount()).append("\" ").append("testsCancelledCount=\"").append(summary.testsCanceledCount()).append("\" ").append("suitesCompletedCount=\"").append(summary.suitesCompletedCount()).append("\" ").append("suitesAbortedCount=\"").append(summary.suitesAbortedCount()).append("\" ").append("date=\"").append(this.formatDate(event.timeStamp())).append("\" ").append("thread=\"").append(event.threadName()).append("\"/>\n").toString();
    }

    private static final void endSuite$1(ObjectRef suiteRecord$1, Stack stack$1, PrintWriter pw$1, Event e) {
        ((SuiteRecord)suiteRecord$1.elem).addEndEvent(e);
        SuiteRecord prevRecord = (SuiteRecord)stack$1.pop();
        if (prevRecord != null) {
            prevRecord.addNestedElement((SuiteRecord)suiteRecord$1.elem);
        } else {
            pw$1.print(((SuiteRecord)suiteRecord$1.elem).toXml());
        }
        SuiteRecord suiteRecord = prevRecord;
        suiteRecord$1.elem = suiteRecord;
        suiteRecord = null;
    }

    public static final boolean org$scalatest$tools$DashboardReporter$SuiteRecord$$_$isEndEvent$1(Event e) {
        Event event = e;
        return event instanceof SuiteCompleted ? true : event instanceof SuiteAborted;
    }

    public static final boolean org$scalatest$tools$DashboardReporter$SuiteRecord$$_$inATest$1(ObjectRef testRecord$1) {
        return (TestRecord)testRecord$1.elem != null && ((TestRecord)testRecord$1.elem).endEvent() == null;
    }

    public static final boolean org$scalatest$tools$DashboardReporter$TestRecord$$_$isEndEvent$2(Event event$1) {
        Event event = event$1;
        return event instanceof TestSucceeded ? true : (event instanceof TestFailed ? true : (event instanceof TestPending ? true : event instanceof TestCanceled));
    }

    private static final int nextDepth$1(IntRef depth$1) {
        int n;
        depth$1.elem = n = depth$1.elem + 1;
        return depth$1.elem;
    }

    public static final /* synthetic */ StringBuilder org$scalatest$tools$DashboardReporter$TestRecord$$_$formatException$$anonfun$1(StringBuilder buf$6, IntRef depth$2, StackTraceElement frame) {
        return buf$6.append(new java.lang.StringBuilder(38).append("<stackFrame depth=\"").append(DashboardReporter.nextDepth$1(depth$2)).append("\">").append(frame.getClassName()).append("(").append(frame.getFileName()).append(":").append(frame.getLineNumber()).append(")").append("</stackFrame>\n").toString());
    }

    public class SuiteRecord {
        private final SuiteStarting startEvent;
        private List nestedElements;
        private Event endEvent;
        private final /* synthetic */ DashboardReporter $outer;

        public SuiteRecord(DashboardReporter $outer, SuiteStarting startEvent) {
            this.startEvent = startEvent;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            this.nestedElements = (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
            this.endEvent = null;
        }

        public List<Object> nestedElements() {
            return this.nestedElements;
        }

        public void nestedElements_$eq(List<Object> x$1) {
            this.nestedElements = x$1;
        }

        public Event endEvent() {
            return this.endEvent;
        }

        public void endEvent_$eq(Event x$1) {
            this.endEvent = x$1;
        }

        public void addNestedElement(Object element) {
            this.nestedElements_$eq((List<Object>)this.nestedElements().$colon$colon(element));
        }

        public void addEndEvent(Event event) {
            Predef$.MODULE$.require(this.endEvent() == null);
            Predef$.MODULE$.require(DashboardReporter.org$scalatest$tools$DashboardReporter$SuiteRecord$$_$isEndEvent$1(event));
            this.endEvent_$eq(event);
        }

        public String result() {
            String string;
            Event event = this.endEvent();
            if (event instanceof SuiteCompleted) {
                string = "completed";
            } else if (event instanceof SuiteAborted) {
                string = "aborted";
            } else {
                this.$outer.unexpectedEvent(this.endEvent());
                string = "";
            }
            return string;
        }

        public String toXml() {
            StringBuilder buf = new StringBuilder();
            ObjectRef testRecord = ObjectRef.create(null);
            String string = this.startEvent.suiteName();
            String string2 = "DiscoverySuite";
            if (string == null ? string2 != null : !string.equals(string2)) {
                buf.append(this.formatStartOfSuite$1());
            }
            this.nestedElements().reverse().foreach((Function1 & Serializable)element -> {
                BoxedUnit boxedUnit;
                if (DashboardReporter.org$scalatest$tools$DashboardReporter$SuiteRecord$$_$inATest$1(testRecord)) {
                    ((TestRecord)testRecord$2.elem).addEvent((Event)element);
                    if (((TestRecord)testRecord$2.elem).isComplete()) {
                        buf.append(((TestRecord)testRecord$2.elem).toXml());
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                } else {
                    Object object = element;
                    if (object instanceof TestIgnored) {
                        TestIgnored e = (TestIgnored)object;
                        boxedUnit = buf.append(this.$outer.formatTestIgnored(e));
                    } else if (object instanceof SuiteRecord && ((SuiteRecord)object).org$scalatest$tools$DashboardReporter$SuiteRecord$$$outer() == this.$outer) {
                        SuiteRecord e = (SuiteRecord)object;
                        boxedUnit = buf.append(e.toXml());
                    } else if (object instanceof TestStarting) {
                        TestStarting e = (TestStarting)object;
                        TestRecord testRecord = new TestRecord(this.$outer, e);
                        testRecord$2.elem = testRecord;
                        testRecord = null;
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        throw new RuntimeException(new java.lang.StringBuilder(13).append("unexpected [").append(element).append("]").toString());
                    }
                }
                return boxedUnit;
            });
            String string3 = this.startEvent.suiteName();
            String string4 = "DiscoverySuite";
            if (string3 == null ? string4 != null : !string3.equals(string4)) {
                buf.append("</suite>\n");
            }
            return buf.toString();
        }

        public final /* synthetic */ DashboardReporter org$scalatest$tools$DashboardReporter$SuiteRecord$$$outer() {
            return this.$outer;
        }

        private final String formatStartOfSuite$1() {
            long duration = this.endEvent().timeStamp() - this.startEvent.timeStamp();
            return new java.lang.StringBuilder(64).append("\n<suite index=\"").append(this.$outer.nextIndex()).append("\" ").append("id=\"").append(this.startEvent.suiteId()).append("\" ").append("result=\"").append(this.result()).append("\" ").append("name=\"").append(this.$outer.escape(this.startEvent.suiteName())).append("\" ").append("duration=\"").append(duration).append("\" ").append("thread=\"").append(this.startEvent.threadName()).append("\">\n").toString();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class TestRecord {
        public static final long OFFSET$0 = LazyVals$.MODULE$.getOffset(TestRecord.class, "0bitmap$1");
        public long 0bitmap$1;
        private final TestStarting startEvent;
        private Event endEvent;
        public DashboardReporter$TestRecord$Duration$ Duration$lzy1;
        private final /* synthetic */ DashboardReporter $outer;

        public TestRecord(DashboardReporter $outer, TestStarting startEvent) {
            this.startEvent = startEvent;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            this.endEvent = null;
        }

        public Event endEvent() {
            return this.endEvent;
        }

        public void endEvent_$eq(Event x$1) {
            this.endEvent = x$1;
        }

        public void addEvent(Event event) {
            if (DashboardReporter.org$scalatest$tools$DashboardReporter$TestRecord$$_$isEndEvent$2(event)) {
                this.endEvent_$eq(event);
            } else {
                this.$outer.unexpectedEvent(event);
            }
        }

        public boolean isComplete() {
            return this.endEvent() != null;
        }

        public String result() {
            String string;
            Event event = this.endEvent();
            if (event instanceof TestSucceeded) {
                string = "succeeded";
            } else if (event instanceof TestFailed) {
                string = "failed";
            } else if (event instanceof TestPending) {
                string = "pending";
            } else if (event instanceof TestCanceled) {
                string = "canceled";
            } else {
                this.$outer.unexpectedEvent(this.endEvent());
                string = "";
            }
            return string;
        }

        public final DashboardReporter$TestRecord$Duration$ Duration() {
            long l;
            long l2;
            while ((l2 = LazyVals$.MODULE$.STATE(l = LazyVals$.MODULE$.get((Object)this, OFFSET$0), 0)) != 3L) {
                if (l2 == 0L) {
                    if (!LazyVals$.MODULE$.CAS((Object)this, OFFSET$0, l, 1, 0)) continue;
                    try {
                        DashboardReporter$TestRecord$Duration$ dashboardReporter$TestRecord$Duration$;
                        this.Duration$lzy1 = dashboardReporter$TestRecord$Duration$ = new DashboardReporter$TestRecord$Duration$();
                        LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 3, 0);
                        return dashboardReporter$TestRecord$Duration$;
                    }
                    catch (Throwable throwable) {
                        LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 0, 0);
                        throw throwable;
                    }
                }
                LazyVals$.MODULE$.wait4Notification((Object)this, OFFSET$0, l, 0);
            }
            return this.Duration$lzy1;
        }

        public String formatTestStart() {
            long l;
            long d;
            Option<Object> option;
            Event event = this.endEvent();
            long duration = event != null && !(option = this.Duration().unapply(event)).isEmpty() ? (d = (l = BoxesRunTime.unboxToLong((Object)option.get()))) : this.endEvent().timeStamp() - this.startEvent.timeStamp();
            return new java.lang.StringBuilder(64).append("<test index=\"").append(this.$outer.nextIndex()).append("\" ").append("result=\"").append(this.result()).append("\" ").append("text=\"").append(this.$outer.testMessage(this.startEvent.testName(), this.endEvent().formatter())).append("\" ").append("name=\"").append(this.$outer.escape(this.startEvent.testName())).append("\" ").append("duration=\"").append(duration).append("\" ").append("thread=\"").append(this.startEvent.threadName()).append("\"").append(">\n").toString();
        }

        public String formatException(TestFailed event) {
            StringBuilder buf = new StringBuilder();
            IntRef depth = IntRef.create((int)-1);
            buf.append("<exception ");
            if (event.suiteClassName().isDefined()) {
                buf.append(new java.lang.StringBuilder(12).append("className=\"").append(event.suiteClassName().get()).append("\"").toString());
            }
            buf.append(">\n");
            if (event.throwable().isDefined()) {
                StackDepthException sde;
                Throwable throwable = (Throwable)event.throwable().get();
                Object[] stackTrace = throwable.getStackTrace();
                Object object = Predef$.MODULE$.refArrayOps(stackTrace);
                Predef$.MODULE$.require(ArrayOps$.MODULE$.size$extension(object) > 0);
                buf.append(new java.lang.StringBuilder(20).append("<message>").append(PCData$.MODULE$.apply(event.message())).append("</message>\n").toString());
                if (throwable instanceof StackDepthException && (sde = (StackDepthException)throwable).failedCodeFileName().isDefined() && sde.failedCodeLineNumber().isDefined()) {
                    buf.append(new java.lang.StringBuilder(91).append("<stackDepth>\n<depth>").append(sde.failedCodeStackDepth()).append("</depth>\n").append("<fileName>").append(sde.failedCodeFileName().get()).append("</fileName>\n").append("<lineNumber>").append(sde.failedCodeLineNumber().get()).append("</lineNumber>\n").append("</stackDepth>\n").toString());
                }
                buf.append("<stackTrace>\n");
                Object object2 = Predef$.MODULE$.refArrayOps(stackTrace);
                ArrayOps$.MODULE$.foreach$extension(object2, arg_0 -> DashboardReporter.org$scalatest$tools$DashboardReporter$TestRecord$$_$formatException$$anonfun$1(buf, depth, arg_0));
                buf.append("</stackTrace>\n");
            }
            buf.append("</exception>\n");
            return buf.toString();
        }

        public String toXml() {
            StringBuilder buf = new StringBuilder();
            if (this.endEvent() == null) {
                throw new IllegalStateException("toXml called without endEvent");
            }
            buf.append(this.formatTestStart());
            if (this.endEvent() instanceof TestFailed) {
                buf.append(this.formatException((TestFailed)this.endEvent()));
            }
            buf.append("</test>\n");
            return buf.toString();
        }

        public final /* synthetic */ DashboardReporter org$scalatest$tools$DashboardReporter$TestRecord$$$outer() {
            return this.$outer;
        }
    }
}

