/*
 * Decompiled with CFR 0.152.
 */
package org.scalatest.tools;

import java.io.File;
import java.io.Serializable;
import java.util.regex.Matcher;
import org.scalatest.tools.Durations$;
import org.scalatest.tools.Durations$Duration$;
import org.scalatest.tools.Durations$Suite$;
import org.scalatest.tools.Durations$Test$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.xml.Elem;
import scala.xml.NodeSeq;
import scala.xml.XML$;

public class Durations
implements Product,
Serializable {
    private final File file;
    private final Set suites;
    public final Durations$Suite$ Suite$lzy1;
    public final Durations$Test$ Test$lzy1;
    public final Durations$Duration$ Duration$lzy1;

    public static Durations apply(File file) {
        return Durations$.MODULE$.apply(file);
    }

    public static Durations fromProduct(Product product) {
        return Durations$.MODULE$.fromProduct(product);
    }

    public static Durations unapply(Durations durations) {
        return Durations$.MODULE$.unapply(durations);
    }

    public Durations(File file) {
        this.file = file;
        this.Suite$lzy1 = new Durations$Suite$(this);
        this.Test$lzy1 = new Durations$Test$(this);
        this.Duration$lzy1 = new Durations$Duration$(this);
        this.suites = (Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Suite[0]));
        if (file.exists()) {
            Elem durationsXml = (Elem)XML$.MODULE$.loadFile(file);
            durationsXml.$bslash("suite").foreach((Function1)(JProcedure1 & Serializable)suiteXml -> {
                Suite suite = this.Suite().apply(String.valueOf(suiteXml.$bslash("@suiteId")), String.valueOf(suiteXml.$bslash("@suiteName")));
                this.suites().$plus$eq((Object)suite);
                suiteXml.$bslash("test").foreach((Function1)(JProcedure1 & Serializable)testXml -> {
                    Test test = this.Test().apply(String.valueOf(testXml.$bslash("@testName")));
                    suite.tests().$plus$eq((Object)test);
                    NodeSeq previous = testXml.$bslash("previous");
                    test.previousNum_$eq(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(previous.$bslash("@num").toString())));
                    test.previousAverage_$eq(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(previous.$bslash("@average").toString())));
                    testXml.$bslash("duration").foreach((Function1)(JProcedure1 & Serializable)durationXml -> {
                        Duration duration = this.Duration().apply(durationXml.$bslash("@run").toString(), StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(durationXml.$bslash("@millis").toString())));
                        test.durations_$eq((List<Duration>)test.durations().$colon$colon((Object)duration));
                    });
                    test.durations_$eq((List<Duration>)test.durations().reverse());
                });
            });
        }
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof Durations)) return false;
        Durations durations = (Durations)object;
        File file = this.file();
        File file2 = durations.file();
        if (file == null) {
            if (file2 != null) {
                return false;
            }
        } else if (!((Object)file).equals(file2)) return false;
        if (!durations.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof Durations;
    }

    public int productArity() {
        return 1;
    }

    public String productPrefix() {
        return "Durations";
    }

    public Object productElement(int n) {
        int n2 = n;
        if (0 != n2) {
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }
        return this._1();
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 != n2) {
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }
        return "file";
    }

    public File file() {
        return this.file;
    }

    public Set<Suite> suites() {
        return this.suites;
    }

    public void addTests(String run2, NodeSeq runXml) {
        runXml.$bslash$bslash("suite").foreach((Function1)(JProcedure1 & Serializable)suite -> {
            String suiteId = suite.$bslash("@id").toString();
            String suiteName = suite.$bslash("@name").toString();
            suite.$bslash("test").foreach((Function1)(JProcedure1 & Serializable)test -> {
                String result;
                String string = result = test.$bslash("@result").toString();
                String string2 = "succeeded";
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    String testName = test.$bslash("@name").toString();
                    int millis = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(test.$bslash("@duration").toString()));
                    this.addDuration(suiteId, suiteName, testName, run2, millis);
                }
            });
        });
    }

    public String toXml() {
        String DurationsTemplate = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|<durations>\n         |$suites$</durations>\n         |"));
        StringBuilder buf = new StringBuilder();
        this.suites().foreach((Function1 & Serializable)suite -> buf.append(suite.toXml()));
        return DurationsTemplate.replaceFirst("\\$suites\\$", Matcher.quoteReplacement(buf.toString()));
    }

    public void addDuration(String suiteId, String suiteName, String testName, String run2, int millis) {
        Test test = this.getTest$1(suiteId, suiteName, testName);
        test.durations_$eq((List<Duration>)test.durations().$colon$colon((Object)new Duration(this, run2, millis)));
        if ((double)test.numberOfDurations() * 0.8 > (double)test.previousNum()) {
            Durations.archiveOldestDuration$1(test);
        }
    }

    public final Durations$Suite$ Suite() {
        return this.Suite$lzy1;
    }

    public final Durations$Test$ Test() {
        return this.Test$lzy1;
    }

    public final Durations$Duration$ Duration() {
        return this.Duration$lzy1;
    }

    public Durations copy(File file) {
        return new Durations(file);
    }

    public File copy$default$1() {
        return this.file();
    }

    public File _1() {
        return this.file();
    }

    private final Suite getSuite$1(String suiteId$2, String suiteName$2) {
        Suite suite2;
        Option suiteOption = this.suites().find((Function1 & Serializable)suite -> {
            String string = suite.suiteId();
            String string2 = suiteId$2;
            return !(string != null ? !string.equals(string2) : string2 != null);
        });
        if (suiteOption.isDefined()) {
            suite2 = (Suite)suiteOption.get();
        } else {
            Suite newSuite = this.Suite().apply(suiteId$2, suiteName$2);
            this.suites().$plus$eq((Object)newSuite);
            suite2 = newSuite;
        }
        return suite2;
    }

    private final Test getTest$1(String suiteId$4, String suiteName$3, String testName$1) {
        Test test2;
        Suite suite = this.getSuite$1(suiteId$4, suiteName$3);
        Option testOption = suite.tests().find((Function1 & Serializable)test -> {
            String string = test.name();
            String string2 = testName$1;
            return !(string != null ? !string.equals(string2) : string2 != null);
        });
        if (testOption.isDefined()) {
            test2 = (Test)testOption.get();
        } else {
            Test newTest = this.Test().apply(testName$1);
            suite.tests().$plus$eq((Object)newTest);
            test2 = newTest;
        }
        return test2;
    }

    private static final void archiveOldestDuration$1(Test test) {
        Duration oldestDuration = (Duration)test.durations().last();
        test.durations_$eq((List<Duration>)((List)test.durations().dropRight(1)));
        test.previousAverage_$eq((test.previousAverage() * test.previousNum() + oldestDuration.millis()) / (test.previousNum() + 1));
        test.previousNum_$eq(test.previousNum() + 1);
    }

    public static final /* synthetic */ StringBuilder org$scalatest$tools$Durations$Suite$$_$toXml$$anonfun$2(StringBuilder buf$2, Test test) {
        return buf$2.append(test.toXml());
    }

    public static final /* synthetic */ StringBuilder org$scalatest$tools$Durations$Test$$_$toXml$$anonfun$3(StringBuilder buf$3, Duration duration) {
        return buf$3.append(duration.toXml());
    }

    private static final /* synthetic */ int computeNewAvg$$anonfun$1(int _$1, Duration _$2) {
        return _$1 + _$2.millis();
    }

    public static /* bridge */ /* synthetic */ int org$scalatest$tools$Durations$Test$$_$computeNewAvg$$anonfun$adapted$1(Object _$1, Object _$2) {
        return Durations.computeNewAvg$$anonfun$1(BoxesRunTime.unboxToInt((Object)_$1), (Duration)_$2);
    }

    public class Duration
    implements Product,
    Serializable {
        private final String run;
        private final int millis;
        private final /* synthetic */ Durations $outer;

        public Duration(Durations $outer, String run2, int millis) {
            this.run = run2;
            this.millis = millis;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.run()));
            n = Statics.mix((int)n, (int)this.millis());
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Duration)) return false;
            if (((Duration)object).org$scalatest$tools$Durations$Duration$$$outer() != this.$outer) return false;
            Duration duration = (Duration)object;
            if (this.millis() != duration.millis()) return false;
            String string = this.run();
            String string2 = duration.run();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!duration.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Duration;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Duration";
        }

        public Object productElement(int n) {
            Object object;
            int n2 = n;
            if (0 == n2) {
                object = this._1();
            } else if (1 == n2) {
                object = BoxesRunTime.boxToInteger((int)this._2());
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return object;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            if (0 == n2) {
                string = "run";
            } else if (1 == n2) {
                string = "millis";
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return string;
        }

        public String run() {
            return this.run;
        }

        public int millis() {
            return this.millis;
        }

        public String toXml() {
            String DurationTemplate = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|      <duration run=\"$run$\" millis=\"$millis$\"/>\n           |"));
            return DurationTemplate.replaceFirst("\\$run\\$", this.run()).replaceFirst("\\$millis\\$", BoxesRunTime.boxToInteger((int)this.millis()).toString());
        }

        public Duration copy(String run2, int millis) {
            return new Duration(this.$outer, run2, millis);
        }

        public String copy$default$1() {
            return this.run();
        }

        public int copy$default$2() {
            return this.millis();
        }

        public String _1() {
            return this.run();
        }

        public int _2() {
            return this.millis();
        }

        public final /* synthetic */ Durations org$scalatest$tools$Durations$Duration$$$outer() {
            return this.$outer;
        }
    }

    public class Suite
    implements Product,
    Serializable {
        private final String suiteId;
        private final String suiteName;
        private final Set tests;
        private final /* synthetic */ Durations $outer;

        public Suite(Durations $outer, String suiteId, String suiteName) {
            this.suiteId = suiteId;
            this.suiteName = suiteName;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            this.tests = (Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Test[0]));
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Suite)) return false;
            if (((Suite)object).org$scalatest$tools$Durations$Suite$$$outer() != this.$outer) return false;
            Suite suite = (Suite)object;
            String string = this.suiteId();
            String string2 = suite.suiteId();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.suiteName();
            String string4 = suite.suiteName();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            if (!suite.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Suite;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Suite";
        }

        public Object productElement(int n) {
            String string;
            int n2 = n;
            if (0 == n2) {
                string = this._1();
            } else if (1 == n2) {
                string = this._2();
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return string;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            if (0 == n2) {
                string = "suiteId";
            } else if (1 == n2) {
                string = "suiteName";
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return string;
        }

        public String suiteId() {
            return this.suiteId;
        }

        public String suiteName() {
            return this.suiteName;
        }

        public Set<Test> tests() {
            return this.tests;
        }

        public String toXml() {
            String SuiteTemplate = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|  <suite suiteId=\"$suiteId$\" suiteName=\"$suiteName$\">\n           |$tests$  </suite>\n           |"));
            StringBuilder buf = new StringBuilder();
            this.tests().foreach(arg_0 -> Durations.org$scalatest$tools$Durations$Suite$$_$toXml$$anonfun$2(buf, arg_0));
            return SuiteTemplate.replaceFirst("\\$suiteId\\$", Matcher.quoteReplacement(this.suiteId())).replaceFirst("\\$suiteName\\$", Matcher.quoteReplacement(this.suiteName())).replaceFirst("\\$tests\\$", Matcher.quoteReplacement(buf.toString()));
        }

        public Suite copy(String suiteId, String suiteName) {
            return new Suite(this.$outer, suiteId, suiteName);
        }

        public String copy$default$1() {
            return this.suiteId();
        }

        public String copy$default$2() {
            return this.suiteName();
        }

        public String _1() {
            return this.suiteId();
        }

        public String _2() {
            return this.suiteName();
        }

        public final /* synthetic */ Durations org$scalatest$tools$Durations$Suite$$$outer() {
            return this.$outer;
        }
    }

    public class Test
    implements Product,
    Serializable {
        private final String name;
        private int previousNum;
        private int previousAverage;
        private List durations;
        private final /* synthetic */ Durations $outer;

        public Test(Durations $outer, String name) {
            this.name = name;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            this.previousNum = 0;
            this.previousAverage = 0;
            this.durations = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Duration[0]));
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Test)) return false;
            if (((Test)object).org$scalatest$tools$Durations$Test$$$outer() != this.$outer) return false;
            Test test = (Test)object;
            String string = this.name();
            String string2 = test.name();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!test.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Test;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Test";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return this._1();
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return "name";
        }

        public String name() {
            return this.name;
        }

        public int previousNum() {
            return this.previousNum;
        }

        public void previousNum_$eq(int x$1) {
            this.previousNum = x$1;
        }

        public int previousAverage() {
            return this.previousAverage;
        }

        public void previousAverage_$eq(int x$1) {
            this.previousAverage = x$1;
        }

        public List<Duration> durations() {
            return this.durations;
        }

        public void durations_$eq(List<Duration> x$1) {
            this.durations = x$1;
        }

        public int numberOfDurations() {
            return this.previousNum() + this.durations().size();
        }

        public String toXml() {
            String TestTemplate = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|    <test testName=\"$testName$\">\n           |      <previous num=\"$previousNum$\" average=\"$previousAverage$\"/>\n           |$durations$    </test>\n           |"));
            StringBuilder buf = new StringBuilder();
            this.durations().foreach(arg_0 -> Durations.org$scalatest$tools$Durations$Test$$_$toXml$$anonfun$3(buf, arg_0));
            return TestTemplate.replaceFirst("\\$testName\\$", Matcher.quoteReplacement(this.name())).replaceFirst("\\$previousNum\\$", BoxesRunTime.boxToInteger((int)this.previousNum()).toString()).replaceFirst("\\$previousAverage\\$", BoxesRunTime.boxToInteger((int)this.previousAverage()).toString()).replaceFirst("\\$durations\\$", Matcher.quoteReplacement(buf.toString()));
        }

        public int runCount() {
            return this.previousNum() + this.durations().size();
        }

        public int computeNewAvg() {
            return BoxesRunTime.unboxToInt((Object)this.durations().foldLeft((Object)BoxesRunTime.boxToInteger((int)0), Durations::org$scalatest$tools$Durations$Test$$_$computeNewAvg$$anonfun$adapted$1)) / this.durations().size();
        }

        public Test copy(String name) {
            return new Test(this.$outer, name);
        }

        public String copy$default$1() {
            return this.name();
        }

        public String _1() {
            return this.name();
        }

        public final /* synthetic */ Durations org$scalatest$tools$Durations$Test$$$outer() {
            return this.$outer;
        }
    }
}

