/*
 * Decompiled with CFR 0.152.
 */
package org.scalatest.tools;

import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.profile.pegdown.PegdownOptionsAdapter;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.misc.Extension;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.net.URL;
import java.nio.channels.Channels;
import java.text.DecimalFormat;
import java.util.UUID;
import org.scalatest.ConfigMap;
import org.scalatest.ResourcefulReporter;
import org.scalatest.Resources$;
import org.scalatest.Suite;
import org.scalatest.Suite$;
import org.scalatest.events.AlertProvided;
import org.scalatest.events.DiscoveryCompleted;
import org.scalatest.events.DiscoveryStarting;
import org.scalatest.events.Event;
import org.scalatest.events.Formatter;
import org.scalatest.events.IndentedText;
import org.scalatest.events.IndentedText$;
import org.scalatest.events.InfoProvided;
import org.scalatest.events.InfoProvided$;
import org.scalatest.events.Location;
import org.scalatest.events.MarkupProvided;
import org.scalatest.events.MarkupProvided$;
import org.scalatest.events.MotionToSuppress$;
import org.scalatest.events.NameInfo;
import org.scalatest.events.NameInfo$;
import org.scalatest.events.NoteProvided;
import org.scalatest.events.Ordinal;
import org.scalatest.events.RecordableEvent;
import org.scalatest.events.RunAborted;
import org.scalatest.events.RunAborted$;
import org.scalatest.events.RunCompleted;
import org.scalatest.events.RunCompleted$;
import org.scalatest.events.RunStarting;
import org.scalatest.events.RunStarting$;
import org.scalatest.events.RunStopped;
import org.scalatest.events.RunStopped$;
import org.scalatest.events.ScopeClosed;
import org.scalatest.events.ScopeClosed$;
import org.scalatest.events.ScopeOpened;
import org.scalatest.events.ScopeOpened$;
import org.scalatest.events.ScopePending;
import org.scalatest.events.ScopePending$;
import org.scalatest.events.SuiteAborted;
import org.scalatest.events.SuiteAborted$;
import org.scalatest.events.SuiteCompleted;
import org.scalatest.events.SuiteCompleted$;
import org.scalatest.events.SuiteStarting;
import org.scalatest.events.Summary;
import org.scalatest.events.TestCanceled;
import org.scalatest.events.TestCanceled$;
import org.scalatest.events.TestFailed;
import org.scalatest.events.TestFailed$;
import org.scalatest.events.TestIgnored;
import org.scalatest.events.TestIgnored$;
import org.scalatest.events.TestPending;
import org.scalatest.events.TestPending$;
import org.scalatest.events.TestStarting;
import org.scalatest.events.TestSucceeded;
import org.scalatest.events.TestSucceeded$;
import org.scalatest.exceptions.StackDepth;
import org.scalatest.exceptions.StackDepthException;
import org.scalatest.exceptions.TestFailedException;
import org.scalatest.tools.HtmlReporter$;
import org.scalatest.tools.StringReporter$;
import org.scalatest.tools.SuiteResult;
import org.scalatest.tools.SuiteResult$;
import org.scalatest.tools.SuiteResultHolder;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.AbstractSeq;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.Stack;
import scala.collection.mutable.Stack$;
import scala.math.Ordering$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.NodeBuffer;
import scala.xml.NodeSeq;
import scala.xml.NodeSeq$;
import scala.xml.Null$;
import scala.xml.PrefixedAttribute;
import scala.xml.Text;
import scala.xml.TopScope$;
import scala.xml.UnprefixedAttribute;
import scala.xml.XML$;

public class HtmlReporter
implements ResourcefulReporter {
    private final boolean presentAllDurations;
    private final Option<URL> cssUrl;
    private final int specIndent;
    private final File targetDir;
    private final File cssDir;
    private final SuiteResultHolder results;
    private final Parser markdownParser;
    private final HtmlRenderer htmlRenderer;
    private final HashMap tagMap;
    private ListBuffer<Event> eventList;
    private Option<Event> runEndEvent;

    public static int CANCELED_BIT() {
        return HtmlReporter$.MODULE$.CANCELED_BIT();
    }

    public static int FAILED_BIT() {
        return HtmlReporter$.MODULE$.FAILED_BIT();
    }

    public static int IGNORED_BIT() {
        return HtmlReporter$.MODULE$.IGNORED_BIT();
    }

    public static int PENDING_BIT() {
        return HtmlReporter$.MODULE$.PENDING_BIT();
    }

    public static int SUCCEEDED_BIT() {
        return HtmlReporter$.MODULE$.SUCCEEDED_BIT();
    }

    public static String convertAmpersand(String string) {
        return HtmlReporter$.MODULE$.convertAmpersand(string);
    }

    public static String convertSingleParaToDefinition(String string) {
        return HtmlReporter$.MODULE$.convertSingleParaToDefinition(string);
    }

    public HtmlReporter(String directoryPath, boolean presentAllDurations, Option<URL> cssUrl, Option<SuiteResultHolder> resultHolder) {
        this.presentAllDurations = presentAllDurations;
        this.cssUrl = cssUrl;
        this.specIndent = 15;
        this.targetDir = new File(directoryPath);
        File imagesDir = new File(this.targetDir, "images");
        File jsDir = new File(this.targetDir, "js");
        this.cssDir = new File(this.targetDir, "css");
        if (!this.targetDir.exists()) {
            this.targetDir.mkdirs();
        }
        if (!imagesDir.exists()) {
            imagesDir.mkdirs();
        }
        if (!jsDir.exists()) {
            jsDir.mkdirs();
        }
        if (!this.cssDir.exists()) {
            this.cssDir.mkdirs();
        }
        cssUrl.foreach((Function1)(JProcedure1 & Serializable)_$1 -> this.copyResource((URL)_$1, this.cssDir, "custom.css"));
        this.copyResource(this.getResource("org/scalatest/HtmlReporter.css"), this.cssDir, "styles.css");
        this.copyResource(this.getResource("org/scalatest/sorttable.js"), jsDir, "sorttable.js");
        this.copyResource(this.getResource("org/scalatest/d3.v2.min.js"), jsDir, "d3.v2.min.js");
        this.copyResource(this.getResource("images/greenbullet.gif"), imagesDir, "testsucceeded.gif");
        this.copyResource(this.getResource("images/redbullet.gif"), imagesDir, "testfailed.gif");
        this.copyResource(this.getResource("images/yellowbullet.gif"), imagesDir, "testignored.gif");
        this.copyResource(this.getResource("images/yellowbullet.gif"), imagesDir, "testcanceled.gif");
        this.copyResource(this.getResource("images/yellowbullet.gif"), imagesDir, "testpending.gif");
        this.copyResource(this.getResource("images/graybullet.gif"), imagesDir, "infoprovided.gif");
        this.results = (SuiteResultHolder)resultHolder.getOrElse(HtmlReporter::$init$$$anonfun$2);
        try {
            Class.forName("com.vladsch.flexmark.profile.pegdown.PegdownOptionsAdapter");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ClassNotFoundException(Resources$.MODULE$.flexmarkClassNotFound());
        }
        DataHolder pegdownOptions = PegdownOptionsAdapter.flexmarkOptions((int)65535, (Extension[])new Extension[0]);
        this.markdownParser = Parser.builder((DataHolder)pegdownOptions).build();
        this.htmlRenderer = HtmlRenderer.builder((DataHolder)pegdownOptions).build();
        this.tagMap = (HashMap)HashMap$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        this.eventList = new ListBuffer();
        this.runEndEvent = None$.MODULE$;
    }

    private void copyResource(URL url, File toDir, String targetFileName) {
        try (InputStream inputStream = url.openStream();){
            FileOutputStream outputStream = new FileOutputStream(new File(toDir, targetFileName));
            try {
                outputStream.getChannel().transferFrom(Channels.newChannel(inputStream), 0L, Long.MAX_VALUE);
            }
            finally {
                outputStream.flush();
                outputStream.close();
            }
        }
    }

    private URL getResource(String resourceName) {
        return Suite.class.getClassLoader().getResource(resourceName);
    }

    private String markdownToHtml(String s) {
        return this.htmlRenderer.render((Node)this.markdownParser.parse(s));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String withPossibleLineNumber(String stringToPrint, Option<Throwable> throwable) {
        String string;
        Throwable throwable2;
        Option<Throwable> option = throwable;
        if (option instanceof Some && (throwable2 = (Throwable)((Some)option).value()) instanceof TestFailedException) {
            TestFailedException testFailedException = (TestFailedException)throwable2;
            Option option2 = testFailedException.failedCodeFileNameAndLineNumberString();
            if (option2 instanceof Some) {
                String lineNumberString = (String)((Some)option2).value();
                string = Resources$.MODULE$.printedReportPlusLineNumber(stringToPrint, lineNumberString);
                return string;
            } else {
                if (!None$.MODULE$.equals(option2)) throw new MatchError((Object)option2);
                string = stringToPrint;
            }
            return string;
        } else {
            string = stringToPrint;
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String stringsToPrintOnError(Function0<String> noteMessageFun, Function1<Object, String> errorMessageFun, String message, Option<Throwable> throwable, Option<Formatter> formatter, Option<String> suiteName, Option<String> testName, Option<Object> duration) {
        String string;
        Formatter formatter2;
        Option<Formatter> option = formatter;
        if (option instanceof Some && (formatter2 = (Formatter)((Some)option).value()) instanceof IndentedText) {
            IndentedText indentedText = IndentedText$.MODULE$.unapply((IndentedText)formatter2);
            String string2 = indentedText._1();
            String string3 = indentedText._2();
            int n = indentedText._3();
            String rawText = string3;
            string = Resources$.MODULE$.specTextAndNote(rawText, noteMessageFun.apply());
            return string;
        } else {
            Option<String> option2 = suiteName;
            if (option2 instanceof Some) {
                String sn = (String)((Some)option2).value();
                Option<String> option3 = testName;
                if (option3 instanceof Some) {
                    String tn = (String)((Some)option3).value();
                    string = (String)errorMessageFun.apply((Object)new StringBuilder(2).append(sn).append(": ").append(tn).toString());
                    return string;
                } else {
                    if (!None$.MODULE$.equals(option3)) throw new MatchError(option3);
                    string = (String)errorMessageFun.apply((Object)sn);
                }
                return string;
            } else {
                if (!None$.MODULE$.equals(option2)) throw new MatchError(option2);
                string = (String)errorMessageFun.apply((Object)Resources$.MODULE$.noNameSpecified());
            }
        }
        return string;
    }

    private Option<String> stringToPrintWhenNoError(Function1<Object, String> messageFun, Option<Formatter> formatter, String suiteName, Option<String> testName) {
        return this.stringToPrintWhenNoError(messageFun, formatter, suiteName, testName, (Option<Object>)None$.MODULE$);
    }

    /*
     * Enabled aggressive block sorting
     */
    private Option<String> stringToPrintWhenNoError(Function1<Object, String> messageFun, Option<Formatter> formatter, String suiteName, Option<String> testName, Option<Object> duration) {
        String string;
        Option<String> option;
        None$ none$;
        Option<Formatter> option2 = formatter;
        if (option2 instanceof Some) {
            Formatter formatter2 = (Formatter)((Some)option2).value();
            if (formatter2 instanceof IndentedText) {
                IndentedText indentedText = IndentedText$.MODULE$.unapply((IndentedText)formatter2);
                String string2 = indentedText._1();
                String string3 = indentedText._2();
                int n = indentedText._3();
                String rawText = string3;
                Option<Object> option3 = duration;
                if (!(option3 instanceof Some)) {
                    if (!None$.MODULE$.equals(option3)) throw new MatchError(option3);
                    none$ = Some$.MODULE$.apply((Object)rawText);
                    return none$;
                }
                long milliseconds = BoxesRunTime.unboxToLong((Object)((Some)option3).value());
                if (this.presentAllDurations) {
                    none$ = Some$.MODULE$.apply((Object)Resources$.MODULE$.withDuration(rawText, StringReporter$.MODULE$.makeDurationString(milliseconds)));
                    return none$;
                }
                none$ = Some$.MODULE$.apply((Object)rawText);
                return none$;
            }
            if (MotionToSuppress$.MODULE$.equals(formatter2)) {
                none$ = None$.MODULE$;
                return none$;
            }
        }
        if ((option = testName) instanceof Some) {
            String tn = (String)((Some)option).value();
            string = new StringBuilder(2).append(suiteName).append(": ").append(tn).toString();
        } else {
            if (!None$.MODULE$.equals(option)) throw new MatchError(option);
            string = suiteName;
        }
        String arg = string;
        String unformattedText = (String)messageFun.apply((Object)arg);
        Option<Object> option4 = duration;
        if (!(option4 instanceof Some)) {
            if (!None$.MODULE$.equals(option4)) throw new MatchError(option4);
            none$ = Some$.MODULE$.apply((Object)unformattedText);
            return none$;
        }
        long milliseconds = BoxesRunTime.unboxToLong((Object)((Some)option4).value());
        if (this.presentAllDurations) {
            none$ = Some$.MODULE$.apply((Object)Resources$.MODULE$.withDuration(unformattedText, StringReporter$.MODULE$.makeDurationString(milliseconds)));
            return none$;
        }
        none$ = Some$.MODULE$.apply((Object)unformattedText);
        return none$;
    }

    private int getIndentLevel(Option<Formatter> formatter) {
        int n;
        Formatter formatter2;
        Option<Formatter> option = formatter;
        if (option instanceof Some && (formatter2 = (Formatter)((Some)option).value()) instanceof IndentedText) {
            int indentationLevel;
            IndentedText indentedText = IndentedText$.MODULE$.unapply((IndentedText)formatter2);
            String string = indentedText._1();
            String string2 = indentedText._2();
            int n2 = indentedText._3();
            String formattedText = string;
            String rawText = string2;
            n = indentationLevel = n2;
        } else {
            n = 0;
        }
        return n;
    }

    private String getSuiteFileName(SuiteResult suiteResult) {
        return (String)suiteResult.suiteClassName().getOrElse(() -> HtmlReporter.getSuiteFileName$$anonfun$1(suiteResult));
    }

    private void makeSuiteFile(SuiteResult suiteResult) {
        String name = this.getSuiteFileName(suiteResult);
        PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(new File(this.targetDir, new StringBuilder(5).append(name).append(".html").toString())), 4096), "UTF-8"));
        try {
            pw.println(new StringBuilder(153).append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE html\n  PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\"\n  \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">\n").append(this.getSuiteHtml(name, suiteResult)).toString());
        }
        finally {
            pw.flush();
            pw.close();
        }
    }

    private String appendCombinedStatus(String name, SuiteResult r) {
        return r.testsFailedCount() > 0 ? new StringBuilder(12).append(name).append("_with_failed").toString() : (r.testsIgnoredCount() > 0 || r.testsPendingCount() > 0 || r.testsCanceledCount() > 0 ? new StringBuilder(7).append(name).append("_passed").toString() : new StringBuilder(11).append(name).append("_passed_all").toString());
    }

    private String transformStringForResult(String s, SuiteResult suiteResult) {
        return new StringBuilder(0).append(s).append(suiteResult.testsFailedCount() > 0 ? "_failed" : "_passed").toString();
    }

    private Elem getSuiteHtml(String name, SuiteResult suiteResult) {
        String string;
        NodeSeq nodeSeq;
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("ScalaTest Suite "));
        $buf3.$amp$plus((Object)name);
        $buf3.$amp$plus((Object)new Text(" Results"));
        $buf2.$amp$plus((Object)new Elem(null, "title", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf3)));
        $buf2.$amp$plus((Object)new Text("\n        "));
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("content", (Seq)new Text("text/html; charset=utf-8"), (MetaData)$md);
        $md = new UnprefixedAttribute("http-equiv", (Seq)new Text("Content-Type"), (MetaData)$md);
        $buf2.$amp$plus((Object)new Elem(null, "meta", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, true, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new scala.xml.Node[0])));
        $buf2.$amp$plus((Object)new Text("\n        "));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("content", (Seq)new Text("-1"), (MetaData)$md2);
        $md2 = new UnprefixedAttribute("http-equiv", (Seq)new Text("Expires"), (MetaData)$md2);
        $buf2.$amp$plus((Object)new Elem(null, "meta", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, true, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new scala.xml.Node[0])));
        $buf2.$amp$plus((Object)new Text("\n        "));
        Null$ $md3 = Null$.MODULE$;
        $md3 = new UnprefixedAttribute("content", (Seq)new Text("no-cache"), (MetaData)$md3);
        $md3 = new UnprefixedAttribute("http-equiv", (Seq)new Text("Pragma"), (MetaData)$md3);
        $buf2.$amp$plus((Object)new Elem(null, "meta", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, true, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new scala.xml.Node[0])));
        $buf2.$amp$plus((Object)new Text("\n        "));
        Null$ $md4 = Null$.MODULE$;
        $md4 = new UnprefixedAttribute("rel", (Seq)new Text("stylesheet"), (MetaData)$md4);
        $md4 = new UnprefixedAttribute("href", (Seq)new Text("css/styles.css"), (MetaData)$md4);
        $buf2.$amp$plus((Object)new Elem(null, "link", (MetaData)$md4, (NamespaceBinding)TopScope$.MODULE$, true, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new scala.xml.Node[0])));
        $buf2.$amp$plus((Object)new Text("\n        "));
        Option<URL> option = this.cssUrl;
        if (option instanceof Some) {
            URL cssUrl = (URL)((Some)option).value();
            Null$ $md5 = Null$.MODULE$;
            $md5 = new UnprefixedAttribute("rel", (Seq)new Text("stylesheet"), (MetaData)$md5);
            $md5 = new UnprefixedAttribute("href", (Seq)new Text("css/custom.css"), (MetaData)$md5);
            nodeSeq = new Elem(null, "link", (MetaData)$md5, (NamespaceBinding)TopScope$.MODULE$, true, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new scala.xml.Node[0]));
        } else if (None$.MODULE$.equals(option)) {
            nodeSeq = NodeSeq$.MODULE$.Empty();
        } else {
            throw new MatchError(option);
        }
        $buf2.$amp$plus((Object)nodeSeq);
        $buf2.$amp$plus((Object)new Text("\n        "));
        Null$ $md6 = Null$.MODULE$;
        $md6 = new UnprefixedAttribute("type", (Seq)new Text("text/javascript"), (MetaData)$md6);
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)new Text("\n          "));
        $buf4.$amp$plus((Object)Suite$.MODULE$.unparsedXml("\n              function toggleDetails(contentId, linkId) { \n                var ele = document.getElementById(contentId); \n                var text = document.getElementById(linkId); \n                if(ele.style.display == \"block\") { \n                  ele.style.display = \"none\"; \n                  text.innerHTML = \"(Show Details)\"; \n                } \n                else { \n                  ele.style.display = \"block\"; \n                  text.innerHTML = \"(Hide Details)\";\n                }\n              } \n              function hideOpenInNewTabIfRequired() { \n                if (top === self) { document.getElementById('printlink').style.display = 'none'; } \n              }\n              "));
        $buf4.$amp$plus((Object)new Text("\n        "));
        $buf2.$amp$plus((Object)new Elem(null, "script", (MetaData)$md6, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf4)));
        $buf2.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "head", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf2)));
        $buf.$amp$plus((Object)new Text("\n      "));
        Null$ $md7 = Null$.MODULE$;
        $md7 = new UnprefixedAttribute("class", (Seq)new Text("specification"), (MetaData)$md7);
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("\n        "));
        Null$ $md8 = Null$.MODULE$;
        $md8 = new UnprefixedAttribute("id", (Seq)new Text("suite_header_name"), (MetaData)$md8);
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)suiteResult.suiteName());
        $buf5.$amp$plus((Object)new Elem(null, "div", (MetaData)$md8, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf6)));
        $buf5.$amp$plus((Object)new Text("\n        "));
        Null$ $md9 = Null$.MODULE$;
        $md9 = new UnprefixedAttribute("id", this.transformStringForResult("suite_header_statistic", suiteResult), (MetaData)$md9);
        NodeBuffer $buf7 = new NodeBuffer();
        $buf7.$amp$plus((Object)new Text("\n          "));
        $buf7.$amp$plus((Object)new StringBuilder(65).append("Tests: total ").append(suiteResult.testsSucceededCount() + suiteResult.testsFailedCount() + suiteResult.testsCanceledCount() + suiteResult.testsIgnoredCount() + suiteResult.testsPendingCount()).append(", succeeded ").append(suiteResult.testsSucceededCount()).append(", failed ").append(suiteResult.testsFailedCount()).append(", canceled ").append(suiteResult.testsCanceledCount()).append(", ignored ").append(suiteResult.testsIgnoredCount()).append(", pending ").append(suiteResult.testsPendingCount()).toString());
        $buf7.$amp$plus((Object)new Text("\n        "));
        $buf5.$amp$plus((Object)new Elem(null, "div", (MetaData)$md9, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf7)));
        $buf5.$amp$plus((Object)new Text("\n        "));
        Stack scopeStack = new Stack(Stack$.MODULE$.$lessinit$greater$default$1());
        $buf5.$amp$plus(suiteResult.eventList().map(arg_0 -> this.getSuiteHtml$$anonfun$1(scopeStack, arg_0)));
        $buf5.$amp$plus((Object)new Text("\n        "));
        Null$ $md10 = Null$.MODULE$;
        $md10 = new UnprefixedAttribute("id", (Seq)new Text("suite_footer"), (MetaData)$md10);
        NodeBuffer $buf8 = new NodeBuffer();
        $buf8.$amp$plus((Object)new Text("\n          "));
        Null$ $md11 = Null$.MODULE$;
        $md11 = new UnprefixedAttribute("id", (Seq)new Text("suite_footer_id"), (MetaData)$md11);
        NodeBuffer $buf9 = new NodeBuffer();
        $buf9.$amp$plus((Object)new Text("\n            "));
        Null$ $md12 = Null$.MODULE$;
        $md12 = new UnprefixedAttribute("id", this.transformStringForResult("suite_footer_id_label", suiteResult), (MetaData)$md12);
        NodeBuffer $buf10 = new NodeBuffer();
        $buf10.$amp$plus((Object)new Text("Suite ID"));
        $buf9.$amp$plus((Object)new Elem(null, "td", (MetaData)$md12, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf10)));
        $buf9.$amp$plus((Object)new Text("\n            "));
        Null$ $md13 = Null$.MODULE$;
        $md13 = new UnprefixedAttribute("colspan", (Seq)new Text("5"), (MetaData)$md13);
        $md13 = new UnprefixedAttribute("id", (Seq)new Text("suite_footer_id_value"), (MetaData)$md13);
        NodeBuffer $buf11 = new NodeBuffer();
        $buf11.$amp$plus((Object)suiteResult.suiteId());
        $buf9.$amp$plus((Object)new Elem(null, "td", (MetaData)$md13, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf11)));
        $buf9.$amp$plus((Object)new Text("\n          "));
        $buf8.$amp$plus((Object)new Elem(null, "tr", (MetaData)$md11, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf9)));
        $buf8.$amp$plus((Object)new Text("\n          "));
        Null$ $md14 = Null$.MODULE$;
        $md14 = new UnprefixedAttribute("id", (Seq)new Text("suite_footer_class"), (MetaData)$md14);
        NodeBuffer $buf12 = new NodeBuffer();
        $buf12.$amp$plus((Object)new Text("\n            "));
        Null$ $md15 = Null$.MODULE$;
        $md15 = new UnprefixedAttribute("id", this.transformStringForResult("suite_footer_class_label", suiteResult), (MetaData)$md15);
        NodeBuffer $buf13 = new NodeBuffer();
        $buf13.$amp$plus((Object)new Text("Class name"));
        $buf12.$amp$plus((Object)new Elem(null, "td", (MetaData)$md15, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf13)));
        $buf12.$amp$plus((Object)new Text("\n            "));
        Null$ $md16 = Null$.MODULE$;
        $md16 = new UnprefixedAttribute("colspan", (Seq)new Text("5"), (MetaData)$md16);
        $md16 = new UnprefixedAttribute("id", (Seq)new Text("suite_footer_class_value"), (MetaData)$md16);
        NodeBuffer $buf14 = new NodeBuffer();
        $buf14.$amp$plus(suiteResult.suiteClassName().getOrElse(HtmlReporter::getSuiteHtml$$anonfun$2));
        $buf12.$amp$plus((Object)new Elem(null, "td", (MetaData)$md16, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf14)));
        $buf12.$amp$plus((Object)new Text("\n          "));
        $buf8.$amp$plus((Object)new Elem(null, "tr", (MetaData)$md14, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf12)));
        $buf8.$amp$plus((Object)new Text("\n          "));
        Null$ $md17 = Null$.MODULE$;
        $md17 = new UnprefixedAttribute("id", (Seq)new Text("suite_footer_duration"), (MetaData)$md17);
        NodeBuffer $buf15 = new NodeBuffer();
        $buf15.$amp$plus((Object)new Text("\n            "));
        Null$ $md18 = Null$.MODULE$;
        $md18 = new UnprefixedAttribute("id", this.transformStringForResult("suite_footer_duration_label", suiteResult), (MetaData)$md18);
        NodeBuffer $buf16 = new NodeBuffer();
        $buf16.$amp$plus((Object)new Text("Total duration"));
        $buf15.$amp$plus((Object)new Elem(null, "td", (MetaData)$md18, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf16)));
        $buf15.$amp$plus((Object)new Text("\n            "));
        Null$ $md19 = Null$.MODULE$;
        $md19 = new UnprefixedAttribute("colspan", (Seq)new Text("2"), (MetaData)$md19);
        $md19 = new UnprefixedAttribute("id", (Seq)new Text("suite_footer_duration_value"), (MetaData)$md19);
        NodeBuffer $buf17 = new NodeBuffer();
        $buf17.$amp$plus((Object)new Text("\n              "));
        Option<Object> option2 = suiteResult.duration();
        if (option2 instanceof Some) {
            long duration = BoxesRunTime.unboxToLong((Object)((Some)option2).value());
            string = StringReporter$.MODULE$.makeDurationString(duration);
        } else if (None$.MODULE$.equals(option2)) {
            string = "-";
        } else {
            throw new MatchError(option2);
        }
        $buf17.$amp$plus((Object)string);
        $buf17.$amp$plus((Object)new Text("\n              "));
        $buf15.$amp$plus((Object)new Elem(null, "td", (MetaData)$md19, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf17)));
        $buf15.$amp$plus((Object)new Text("\n          "));
        $buf8.$amp$plus((Object)new Elem(null, "tr", (MetaData)$md17, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf15)));
        $buf8.$amp$plus((Object)new Text("\n        "));
        $buf5.$amp$plus((Object)new Elem(null, "table", (MetaData)$md10, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf8)));
        $buf5.$amp$plus((Object)new Text("\n           "));
        Null$ $md20 = Null$.MODULE$;
        $md20 = new UnprefixedAttribute("id", (Seq)new Text("printlink"), (MetaData)$md20);
        NodeBuffer $buf18 = new NodeBuffer();
        $buf18.$amp$plus((Object)new Text("("));
        Null$ $md21 = Null$.MODULE$;
        $md21 = new UnprefixedAttribute("target", (Seq)new Text("_blank"), (MetaData)$md21);
        $md21 = new UnprefixedAttribute("href", new StringBuilder(5).append(this.getSuiteFileName(suiteResult)).append(".html").toString(), (MetaData)$md21);
        NodeBuffer $buf19 = new NodeBuffer();
        $buf19.$amp$plus((Object)new Text("Open "));
        $buf19.$amp$plus((Object)suiteResult.suiteName());
        $buf19.$amp$plus((Object)new Text(" in new tab"));
        $buf18.$amp$plus((Object)new Elem(null, "a", (MetaData)$md21, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf19)));
        $buf18.$amp$plus((Object)new Text(")"));
        $buf5.$amp$plus((Object)new Elem(null, "div", (MetaData)$md20, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf18)));
        $buf5.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "body", (MetaData)$md7, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf5)));
        $buf.$amp$plus((Object)new Text("\n      "));
        Null$ $md22 = Null$.MODULE$;
        $md22 = new UnprefixedAttribute("type", (Seq)new Text("text/javascript"), (MetaData)$md22);
        NodeBuffer $buf20 = new NodeBuffer();
        $buf20.$amp$plus((Object)new Text("\n        //"));
        $buf20.$amp$plus((Object)new Text("\n          hideOpenInNewTabIfRequired();\n        //"));
        $buf20.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "script", (MetaData)$md22, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf20)));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "html", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf));
    }

    private NodeSeq processInfoMarkupProvided(Event event, String theClass) {
        NodeSeq nodeSeq;
        Event event2 = event;
        if (event2 instanceof InfoProvided) {
            Tuple2 tuple2;
            NameInfo nameInfo;
            InfoProvided infoProvided = InfoProvided$.MODULE$.unapply((InfoProvided)event2);
            Ordinal ordinal = infoProvided._1();
            String string = infoProvided._2();
            Option<NameInfo> option = infoProvided._3();
            Option<Throwable> option2 = infoProvided._4();
            Option<Formatter> option3 = infoProvided._5();
            Option<Location> option4 = infoProvided._6();
            Option<Object> option5 = infoProvided._7();
            String string2 = infoProvided._8();
            long l = infoProvided._9();
            Ordinal ordinal2 = ordinal;
            String message = string;
            Option<NameInfo> nameInfo2 = option;
            Option<Throwable> throwable = option2;
            Option<Formatter> formatter = option3;
            Option<Location> location = option4;
            Option<Object> payload = option5;
            String threadName = string2;
            long timeStamp = l;
            Option<NameInfo> option6 = nameInfo2;
            if (option6 instanceof Some && (nameInfo = (NameInfo)((Some)option6).value()) != null) {
                NameInfo nameInfo3 = NameInfo$.MODULE$.unapply(nameInfo);
                String string3 = nameInfo3._1();
                String string4 = nameInfo3._2();
                Option<String> option7 = nameInfo3._3();
                Option<String> option8 = nameInfo3._4();
                String suiteName = string3;
                Option<String> testName = option8;
                tuple2 = Tuple2$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)suiteName), testName);
            } else if (None$.MODULE$.equals(option6)) {
                tuple2 = Tuple2$.MODULE$.apply((Object)None$.MODULE$, (Object)None$.MODULE$);
            } else {
                throw new MatchError(option6);
            }
            Tuple2 tuple22 = tuple2;
            Option suiteName = (Option)tuple22._1();
            Option testName = (Option)tuple22._2();
            String infoContent = this.stringsToPrintOnError((Function0<String>)((Function0 & Serializable)HtmlReporter::$anonfun$8), (Function1<Object, String>)(Function1 & Serializable)param0 -> Resources$.MODULE$.infoProvided(param0), message, throwable, formatter, (Option<String>)suiteName, (Option<String>)testName, (Option<Object>)None$.MODULE$);
            String elementId = this.generateElementId();
            nodeSeq = this.test(elementId, (List<String>)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{infoContent}))), this.getIndentLevel(formatter) + 1, theClass);
        } else if (event2 instanceof MarkupProvided) {
            Tuple2 tuple2;
            NameInfo nameInfo;
            MarkupProvided markupProvided = MarkupProvided$.MODULE$.unapply((MarkupProvided)event2);
            Ordinal ordinal = markupProvided._1();
            String string = markupProvided._2();
            Option<NameInfo> option = markupProvided._3();
            Option<Formatter> option9 = markupProvided._4();
            Option<Location> option10 = markupProvided._5();
            Option<Object> option11 = markupProvided._6();
            String string5 = markupProvided._7();
            long l = markupProvided._8();
            Ordinal ordinal3 = ordinal;
            String text = string;
            Option<NameInfo> nameInfo4 = option;
            Option<Formatter> formatter = option9;
            Option<Location> location = option10;
            Option<Object> payload = option11;
            String threadName = string5;
            long timeStamp = l;
            Option<NameInfo> option12 = nameInfo4;
            if (option12 instanceof Some && (nameInfo = (NameInfo)((Some)option12).value()) != null) {
                NameInfo nameInfo5 = NameInfo$.MODULE$.unapply(nameInfo);
                String string6 = nameInfo5._1();
                String string7 = nameInfo5._2();
                Option<String> option13 = nameInfo5._3();
                Option<String> option14 = nameInfo5._4();
                String suiteName = string6;
                Option<String> testName = option14;
                tuple2 = Tuple2$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)suiteName), testName);
            } else if (None$.MODULE$.equals(option12)) {
                tuple2 = Tuple2$.MODULE$.apply((Object)None$.MODULE$, (Object)None$.MODULE$);
            } else {
                throw new MatchError(option12);
            }
            Tuple2 tuple23 = tuple2;
            Option suiteName = (Option)tuple23._1();
            Option testName = (Option)tuple23._2();
            String elementId = this.generateElementId();
            nodeSeq = this.markup(elementId, text, this.getIndentLevel(formatter) + 1, theClass);
        } else {
            nodeSeq = NodeSeq$.MODULE$.Empty();
        }
        return nodeSeq;
    }

    private void makeIndexFile(Function0<String> completeMessageFun, Function1<String, String> completeInMessageFun, Option<Object> duration) {
        PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(new File(this.targetDir, "index.html")), 4096), "UTF-8"));
        try {
            pw.println(new StringBuilder(149).append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE html\nPUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\"\n\"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">\n").append(this.getIndexHtml(completeMessageFun, completeInMessageFun, duration)).toString());
        }
        finally {
            pw.flush();
            pw.close();
        }
    }

    private String getHeaderStatusColor(Summary summary) {
        return summary.testsFailedCount() == 0 ? "scalatest-header-passed" : "scalatest-header-failed";
    }

    private String getPieChartScript(Summary summary) {
        return new StringBuilder(1642).append("/* modified from http://www.permadi.com/tutorial/cssGettingBackgroundColor/index.html - */\nfunction getBgColor(elementId)\n{\n  var element = document.getElementById(elementId);\n  if (element.currentStyle)\n    return element.currentStyle.backgroundColor;\n  if (window.getComputedStyle)\n  {\n    var elementStyle=window.getComputedStyle(element,\"\");\n    if (elementStyle)\n      return elementStyle.getPropertyValue(\"background-color\");\n  }\n  // Return 0 if both methods failed.\n  return 0;\n}\nvar data = [").append(summary.testsSucceededCount()).append(", ").append(summary.testsFailedCount()).append(", ").append(summary.testsIgnoredCount()).append(", ").append(summary.testsPendingCount()).append(", ").append(summary.testsCanceledCount()).append("];").append("\n").append("var color = [getBgColor('summary_view_row_1_legend_succeeded_label'), ").append("\n").append("             getBgColor('summary_view_row_1_legend_failed_label'), ").append("\n").append("             getBgColor('summary_view_row_1_legend_ignored_label'), ").append("\n").append("             getBgColor('summary_view_row_1_legend_pending_label'), ").append("\n").append("             getBgColor('summary_view_row_1_legend_canceled_label')").append("\n").append("            ];").append("\n").append("var width = document.getElementById('chart_div').offsetWidth,").append("\n").append("    height = document.getElementById('chart_div').offsetHeight,").append("\n").append("    outerRadius = Math.min(width, height) / 2,").append("\n").append("    innerRadius = 0,").append("\n").append("    donut = d3.layout.pie(),").append("\n").append("    arc = d3.svg.arc().innerRadius(innerRadius).outerRadius(outerRadius);").append("\n").append("var vis = d3.select(\"#chart_div\")").append("\n").append("            .append(\"svg\")").append("\n").append("            .data([data])").append("\n").append("            .attr(\"width\", width)").append("\n").append("            .attr(\"height\", height);").append("\n").append("var arcs = vis.selectAll(\"g.arc\")").append("\n").append("              .data(donut)").append("\n").append("              .enter().append(\"g\")").append("\n").append("              .attr(\"class\", \"arc\")").append("\n").append("              .attr(\"transform\", \"translate(\" + outerRadius + \",\" + outerRadius + \")\");").append("\n").append("arcs.append(\"path\")").append("\n").append("    .attr(\"fill\", function(d, i) { return color[i]; })").append("\n").append("    .attr(\"d\", arc);\n").toString();
    }

    private Elem getIndexHtml(Function0<String> completeMessageFun, Function1<String, String> completeInMessageFun, Option<Object> duration) {
        NodeSeq nodeSeq;
        Summary summary = this.results.summary();
        DecimalFormat decimalFormat = new DecimalFormat("#.##");
        TopScope$ $tmpscope = TopScope$.MODULE$;
        TopScope$ $scope = $tmpscope = new NamespaceBinding(null, "http://www.w3.org/1999/xhtml", (NamespaceBinding)$tmpscope);
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("lang", (Seq)new Text("en"), (MetaData)$md);
        $md = new PrefixedAttribute("xml", "lang", (Seq)new Text("en"), (MetaData)$md);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("ScalaTest Results"));
        $buf2.$amp$plus((Object)new Elem(null, "title", (MetaData)Null$.MODULE$, (NamespaceBinding)$scope, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf3)));
        $buf2.$amp$plus((Object)new Text("\n        "));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("content", (Seq)new Text("text/html; charset=utf-8"), (MetaData)$md2);
        $md2 = new UnprefixedAttribute("http-equiv", (Seq)new Text("Content-Type"), (MetaData)$md2);
        $buf2.$amp$plus((Object)new Elem(null, "meta", (MetaData)$md2, (NamespaceBinding)$scope, true, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new scala.xml.Node[0])));
        $buf2.$amp$plus((Object)new Text("\n        "));
        Null$ $md3 = Null$.MODULE$;
        $md3 = new UnprefixedAttribute("content", (Seq)new Text("-1"), (MetaData)$md3);
        $md3 = new UnprefixedAttribute("http-equiv", (Seq)new Text("Expires"), (MetaData)$md3);
        $buf2.$amp$plus((Object)new Elem(null, "meta", (MetaData)$md3, (NamespaceBinding)$scope, true, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new scala.xml.Node[0])));
        $buf2.$amp$plus((Object)new Text("\n        "));
        Null$ $md4 = Null$.MODULE$;
        $md4 = new UnprefixedAttribute("content", (Seq)new Text("no-cache"), (MetaData)$md4);
        $md4 = new UnprefixedAttribute("http-equiv", (Seq)new Text("Pragma"), (MetaData)$md4);
        $buf2.$amp$plus((Object)new Elem(null, "meta", (MetaData)$md4, (NamespaceBinding)$scope, true, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new scala.xml.Node[0])));
        $buf2.$amp$plus((Object)new Text("\n        "));
        Null$ $md5 = Null$.MODULE$;
        $md5 = new UnprefixedAttribute("rel", (Seq)new Text("stylesheet"), (MetaData)$md5);
        $md5 = new UnprefixedAttribute("href", (Seq)new Text("css/styles.css"), (MetaData)$md5);
        $buf2.$amp$plus((Object)new Elem(null, "link", (MetaData)$md5, (NamespaceBinding)$scope, true, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new scala.xml.Node[0])));
        $buf2.$amp$plus((Object)new Text("\n        "));
        Option<URL> option = this.cssUrl;
        if (option instanceof Some) {
            URL cssUrl = (URL)((Some)option).value();
            Null$ $md6 = Null$.MODULE$;
            $md6 = new UnprefixedAttribute("rel", (Seq)new Text("stylesheet"), (MetaData)$md6);
            $md6 = new UnprefixedAttribute("href", (Seq)new Text("css/custom.css"), (MetaData)$md6);
            nodeSeq = new Elem(null, "link", (MetaData)$md6, (NamespaceBinding)$scope, true, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new scala.xml.Node[0]));
        } else if (None$.MODULE$.equals(option)) {
            nodeSeq = NodeSeq$.MODULE$.Empty();
        } else {
            throw new MatchError(option);
        }
        $buf2.$amp$plus((Object)nodeSeq);
        $buf2.$amp$plus((Object)new Text("\n        "));
        Null$ $md7 = Null$.MODULE$;
        $md7 = new UnprefixedAttribute("src", (Seq)new Text("js/d3.v2.min.js"), (MetaData)$md7);
        $md7 = new UnprefixedAttribute("type", (Seq)new Text("text/javascript"), (MetaData)$md7);
        $buf2.$amp$plus((Object)new Elem(null, "script", (MetaData)$md7, (NamespaceBinding)$scope, false, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new scala.xml.Node[0])));
        $buf2.$amp$plus((Object)new Text("\n        "));
        Null$ $md8 = Null$.MODULE$;
        $md8 = new UnprefixedAttribute("src", (Seq)new Text("js/sorttable.js"), (MetaData)$md8);
        $md8 = new UnprefixedAttribute("type", (Seq)new Text("text/javascript"), (MetaData)$md8);
        $buf2.$amp$plus((Object)new Elem(null, "script", (MetaData)$md8, (NamespaceBinding)$scope, false, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new scala.xml.Node[0])));
        $buf2.$amp$plus((Object)new Text("\n        "));
        Null$ $md9 = Null$.MODULE$;
        $md9 = new UnprefixedAttribute("type", (Seq)new Text("text/javascript"), (MetaData)$md9);
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)new Text("\n          "));
        $buf4.$amp$plus((Object)Suite$.MODULE$.unparsedXml("\n            var tagMap = {};     \n            var SUCCEEDED_BIT = 1; \n            var FAILED_BIT = 2; \n            var IGNORED_BIT = 4; \n            var PENDING_BIT = 8;\n            var CANCELED_BIT = 16;\n            function applyFilter() {\n              var mask = 0;\n              if (document.getElementById('succeeded_checkbox').checked) \n                mask |= SUCCEEDED_BIT;  \n              if (document.getElementById('failed_checkbox').checked) \n                mask |= FAILED_BIT; \n              if (document.getElementById('ignored_checkbox').checked) \n                mask |= IGNORED_BIT; \n              if (document.getElementById('pending_checkbox').checked) \n                mask |= PENDING_BIT; \n              if (document.getElementById('canceled_checkbox').checked)\n                mask |= CANCELED_BIT;\n              for (var key in tagMap) { \n                if (tagMap.hasOwnProperty(key)) { \n                  var bitSet = tagMap[key]; \n                  var element = document.getElementById(key);\n                  if ((bitSet & mask) != 0) \n                    element.style.display = \"table-row\"; \n                  else  \n                    element.style.display = \"none\";\n                }\n              }\n            }\n            function showDetails(suiteName) {\n              document.getElementById('details_view').innerHTML = \"<iframe src='\" + suiteName + \".html' width='100%' height='100%'></iframe>\";\n            }\n            function resizeDetailsView() {\n              var headerView = document.getElementById('scalatest-header'); \n              var detailsView = document.getElementById('details_view'); \n              var summaryView = document.getElementById('summary_view');\n              var left = summaryView.offsetWidth + 30;\n              detailsView.style.left = left + \"px\"; \n              detailsView.style.width = (window.innerWidth - left - 30) + \"px\";\n              detailsView.style.height = (window.innerHeight - headerView.offsetHeight - 20) + \"px\";\n            }"));
        $buf4.$amp$plus((Object)new Text("\n        "));
        $buf2.$amp$plus((Object)new Elem(null, "script", (MetaData)$md9, (NamespaceBinding)$scope, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf4)));
        $buf2.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "head", (MetaData)Null$.MODULE$, (NamespaceBinding)$scope, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf2)));
        $buf.$amp$plus((Object)new Text("\n      "));
        Null$ $md10 = Null$.MODULE$;
        $md10 = new UnprefixedAttribute("onresize", (Seq)new Text("resizeDetailsView()"), (MetaData)$md10);
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("\n        "));
        Null$ $md11 = Null$.MODULE$;
        $md11 = new UnprefixedAttribute("class", (Seq)new Text("scalatest-report"), (MetaData)$md11);
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)new Text(" \n          "));
        $buf6.$amp$plus((Object)this.header(completeMessageFun, completeInMessageFun, duration, summary));
        $buf6.$amp$plus((Object)new Text("\n          "));
        Null$ $md12 = Null$.MODULE$;
        $md12 = new UnprefixedAttribute("id", (Seq)new Text("summary_view"), (MetaData)$md12);
        NodeBuffer $buf7 = new NodeBuffer();
        $buf7.$amp$plus((Object)new Text("\n            "));
        Null$ $md13 = Null$.MODULE$;
        $md13 = new UnprefixedAttribute("id", (Seq)new Text("summary_view_row_1"), (MetaData)$md13);
        NodeBuffer $buf8 = new NodeBuffer();
        $buf8.$amp$plus((Object)new Text("\n              "));
        Null$ $md14 = Null$.MODULE$;
        $md14 = new UnprefixedAttribute("id", (Seq)new Text("summary_view_row_1_chart"), (MetaData)$md14);
        NodeBuffer $buf9 = new NodeBuffer();
        $buf9.$amp$plus((Object)new Text("\n                "));
        Null$ $md15 = Null$.MODULE$;
        $md15 = new UnprefixedAttribute("id", (Seq)new Text("chart_div"), (MetaData)$md15);
        $buf9.$amp$plus((Object)new Elem(null, "div", (MetaData)$md15, (NamespaceBinding)$scope, false, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new scala.xml.Node[0])));
        $buf9.$amp$plus((Object)new Text("\n              "));
        $buf8.$amp$plus((Object)new Elem(null, "td", (MetaData)$md14, (NamespaceBinding)$scope, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf9)));
        $buf8.$amp$plus((Object)new Text("\n              "));
        Null$ $md16 = Null$.MODULE$;
        $md16 = new UnprefixedAttribute("id", (Seq)new Text("summary_view_row_1_legend"), (MetaData)$md16);
        NodeBuffer $buf10 = new NodeBuffer();
        $buf10.$amp$plus((Object)new Text("\n                "));
        Null$ $md17 = Null$.MODULE$;
        $md17 = new UnprefixedAttribute("id", (Seq)new Text("summary_view_row_1_legend_table"), (MetaData)$md17);
        NodeBuffer $buf11 = new NodeBuffer();
        $buf11.$amp$plus((Object)new Text("\n                  "));
        Null$ $md18 = Null$.MODULE$;
        $md18 = new UnprefixedAttribute("id", (Seq)new Text("summary_view_row_1_legend_table_row_succeeded"), (MetaData)$md18);
        NodeBuffer $buf12 = new NodeBuffer();
        $buf12.$amp$plus((Object)new Text("\n                    "));
        Null$ $md19 = Null$.MODULE$;
        $md19 = new UnprefixedAttribute("id", (Seq)new Text("summary_view_row_1_legend_succeeded_label"), (MetaData)$md19);
        NodeBuffer $buf13 = new NodeBuffer();
        $buf13.$amp$plus((Object)new Text("Succeeded"));
        $buf12.$amp$plus((Object)new Elem(null, "td", (MetaData)$md19, (NamespaceBinding)$scope, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf13)));
        $buf12.$amp$plus((Object)new Text("\n                    "));
        Null$ $md20 = Null$.MODULE$;
        $md20 = new UnprefixedAttribute("id", (Seq)new Text("summary_view_row_1_legend_succeeded_count"), (MetaData)$md20);
        NodeBuffer $buf14 = new NodeBuffer();
        $buf14.$amp$plus((Object)BoxesRunTime.boxToInteger((int)summary.testsSucceededCount()));
        $buf12.$amp$plus((Object)new Elem(null, "td", (MetaData)$md20, (NamespaceBinding)$scope, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf14)));
        $buf12.$amp$plus((Object)new Text("\n                    "));
        Null$ $md21 = Null$.MODULE$;
        $md21 = new UnprefixedAttribute("id", (Seq)new Text("summary_view_row_1_legend_succeeded_percent"), (MetaData)$md21);
        NodeBuffer $buf15 = new NodeBuffer();
        $buf15.$amp$plus((Object)new Text("("));
        $buf15.$amp$plus((Object)decimalFormat.format((double)summary.testsSucceededCount() * 100.0 / (double)summary.totalTestsCount()));
        $buf15.$amp$plus((Object)new Text("%)"));
        $buf12.$amp$plus((Object)new Elem(null, "td", (MetaData)$md21, (NamespaceBinding)$scope, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf15)));
        $buf12.$amp$plus((Object)new Text("\n                  "));
        $buf11.$amp$plus((Object)new Elem(null, "tr", (MetaData)$md18, (NamespaceBinding)$scope, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf12)));
        $buf11.$amp$plus((Object)new Text("\n                  "));
        Null$ $md22 = Null$.MODULE$;
        $md22 = new UnprefixedAttribute("id", (Seq)new Text("summary_view_row_1_legend_table_row_failed"), (MetaData)$md22);
        NodeBuffer $buf16 = new NodeBuffer();
        $buf16.$amp$plus((Object)new Text("\n                    "));
        Null$ $md23 = Null$.MODULE$;
        $md23 = new UnprefixedAttribute("id", (Seq)new Text("summary_view_row_1_legend_failed_label"), (MetaData)$md23);
        NodeBuffer $buf17 = new NodeBuffer();
        $buf17.$amp$plus((Object)new Text("Failed"));
        $buf16.$amp$plus((Object)new Elem(null, "td", (MetaData)$md23, (NamespaceBinding)$scope, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf17)));
        $buf16.$amp$plus((Object)new Text("\n                    "));
        Null$ $md24 = Null$.MODULE$;
        $md24 = new UnprefixedAttribute("id", (Seq)new Text("summary_view_row_1_legend_failed_count"), (MetaData)$md24);
        NodeBuffer $buf18 = new NodeBuffer();
        $buf18.$amp$plus((Object)BoxesRunTime.boxToInteger((int)summary.testsFailedCount()));
        $buf16.$amp$plus((Object)new Elem(null, "td", (MetaData)$md24, (NamespaceBinding)$scope, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf18)));
        $buf16.$amp$plus((Object)new Text("\n                    "));
        Null$ $md25 = Null$.MODULE$;
        $md25 = new UnprefixedAttribute("id", (Seq)new Text("summary_view_row_1_legend_failed_percent"), (MetaData)$md25);
        NodeBuffer $buf19 = new NodeBuffer();
        $buf19.$amp$plus((Object)new Text("("));
        $buf19.$amp$plus((Object)decimalFormat.format((double)summary.testsFailedCount() * 100.0 / (double)summary.totalTestsCount()));
        $buf19.$amp$plus((Object)new Text("%)"));
        $buf16.$amp$plus((Object)new Elem(null, "td", (MetaData)$md25, (NamespaceBinding)$scope, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf19)));
        $buf16.$amp$plus((Object)new Text("\n                  "));
        $buf11.$amp$plus((Object)new Elem(null, "tr", (MetaData)$md22, (NamespaceBinding)$scope, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf16)));
        $buf11.$amp$plus((Object)new Text("\n                  "));
        Null$ $md26 = Null$.MODULE$;
        $md26 = new UnprefixedAttribute("id", (Seq)new Text("summary_view_row_1_legend_table_row_canceled"), (MetaData)$md26);
        NodeBuffer $buf20 = new NodeBuffer();
        $buf20.$amp$plus((Object)new Text("\n                    "));
        Null$ $md27 = Null$.MODULE$;
        $md27 = new UnprefixedAttribute("id", (Seq)new Text("summary_view_row_1_legend_canceled_label"), (MetaData)$md27);
        NodeBuffer $buf21 = new NodeBuffer();
        $buf21.$amp$plus((Object)new Text("Canceled"));
        $buf20.$amp$plus((Object)new Elem(null, "td", (MetaData)$md27, (NamespaceBinding)$scope, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf21)));
        $buf20.$amp$plus((Object)new Text("\n                    "));
        Null$ $md28 = Null$.MODULE$;
        $md28 = new UnprefixedAttribute("id", (Seq)new Text("summary_view_row_1_legend_canceled_count"), (MetaData)$md28);
        NodeBuffer $buf22 = new NodeBuffer();
        $buf22.$amp$plus((Object)BoxesRunTime.boxToInteger((int)summary.testsCanceledCount()));
        $buf20.$amp$plus((Object)new Elem(null, "td", (MetaData)$md28, (NamespaceBinding)$scope, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf22)));
        $buf20.$amp$plus((Object)new Text("\n                    "));
        Null$ $md29 = Null$.MODULE$;
        $md29 = new UnprefixedAttribute("id", (Seq)new Text("summary_view_row_1_legend_canceled_percent"), (MetaData)$md29);
        NodeBuffer $buf23 = new NodeBuffer();
        $buf23.$amp$plus((Object)new Text("("));
        $buf23.$amp$plus((Object)decimalFormat.format((double)summary.testsCanceledCount() * 100.0 / (double)summary.totalTestsCount()));
        $buf23.$amp$plus((Object)new Text("%)"));
        $buf20.$amp$plus((Object)new Elem(null, "td", (MetaData)$md29, (NamespaceBinding)$scope, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf23)));
        $buf20.$amp$plus((Object)new Text("\n                  "));
        $buf11.$amp$plus((Object)new Elem(null, "tr", (MetaData)$md26, (NamespaceBinding)$scope, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf20)));
        $buf11.$amp$plus((Object)new Text("\n                  "));
        Null$ $md30 = Null$.MODULE$;
        $md30 = new UnprefixedAttribute("id", (Seq)new Text("summary_view_row_1_legend_table_row_ignored"), (MetaData)$md30);
        NodeBuffer $buf24 = new NodeBuffer();
        $buf24.$amp$plus((Object)new Text("\n                    "));
        Null$ $md31 = Null$.MODULE$;
        $md31 = new UnprefixedAttribute("id", (Seq)new Text("summary_view_row_1_legend_ignored_label"), (MetaData)$md31);
        NodeBuffer $buf25 = new NodeBuffer();
        $buf25.$amp$plus((Object)new Text("Ignored"));
        $buf24.$amp$plus((Object)new Elem(null, "td", (MetaData)$md31, (NamespaceBinding)$scope, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf25)));
        $buf24.$amp$plus((Object)new Text("\n                    "));
        Null$ $md32 = Null$.MODULE$;
        $md32 = new UnprefixedAttribute("id", (Seq)new Text("summary_view_row_1_legend_ignored_count"), (MetaData)$md32);
        NodeBuffer $buf26 = new NodeBuffer();
        $buf26.$amp$plus((Object)BoxesRunTime.boxToInteger((int)summary.testsIgnoredCount()));
        $buf24.$amp$plus((Object)new Elem(null, "td", (MetaData)$md32, (NamespaceBinding)$scope, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf26)));
        $buf24.$amp$plus((Object)new Text("\n                    "));
        Null$ $md33 = Null$.MODULE$;
        $md33 = new UnprefixedAttribute("id", (Seq)new Text("summary_view_row_1_legend_ignored_percent"), (MetaData)$md33);
        NodeBuffer $buf27 = new NodeBuffer();
        $buf27.$amp$plus((Object)new Text("("));
        $buf27.$amp$plus((Object)decimalFormat.format((double)summary.testsIgnoredCount() * 100.0 / (double)summary.totalTestsCount()));
        $buf27.$amp$plus((Object)new Text("%)"));
        $buf24.$amp$plus((Object)new Elem(null, "td", (MetaData)$md33, (NamespaceBinding)$scope, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf27)));
        $buf24.$amp$plus((Object)new Text("\n                  "));
        $buf11.$amp$plus((Object)new Elem(null, "tr", (MetaData)$md30, (NamespaceBinding)$scope, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf24)));
        $buf11.$amp$plus((Object)new Text("\n                  "));
        Null$ $md34 = Null$.MODULE$;
        $md34 = new UnprefixedAttribute("id", (Seq)new Text("summary_view_row_1_legend_table_row_pending"), (MetaData)$md34);
        NodeBuffer $buf28 = new NodeBuffer();
        $buf28.$amp$plus((Object)new Text("\n                    "));
        Null$ $md35 = Null$.MODULE$;
        $md35 = new UnprefixedAttribute("id", (Seq)new Text("summary_view_row_1_legend_pending_label"), (MetaData)$md35);
        NodeBuffer $buf29 = new NodeBuffer();
        $buf29.$amp$plus((Object)new Text("Pending"));
        $buf28.$amp$plus((Object)new Elem(null, "td", (MetaData)$md35, (NamespaceBinding)$scope, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf29)));
        $buf28.$amp$plus((Object)new Text("\n                    "));
        Null$ $md36 = Null$.MODULE$;
        $md36 = new UnprefixedAttribute("id", (Seq)new Text("summary_view_row_1_legend_pending_count"), (MetaData)$md36);
        NodeBuffer $buf30 = new NodeBuffer();
        $buf30.$amp$plus((Object)BoxesRunTime.boxToInteger((int)summary.testsPendingCount()));
        $buf28.$amp$plus((Object)new Elem(null, "td", (MetaData)$md36, (NamespaceBinding)$scope, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf30)));
        $buf28.$amp$plus((Object)new Text("\n                    "));
        Null$ $md37 = Null$.MODULE$;
        $md37 = new UnprefixedAttribute("id", (Seq)new Text("summary_view_row_1_legend_pending_percent"), (MetaData)$md37);
        NodeBuffer $buf31 = new NodeBuffer();
        $buf31.$amp$plus((Object)new Text("("));
        $buf31.$amp$plus((Object)decimalFormat.format((double)summary.testsPendingCount() * 100.0 / (double)summary.totalTestsCount()));
        $buf31.$amp$plus((Object)new Text("%)"));
        $buf28.$amp$plus((Object)new Elem(null, "td", (MetaData)$md37, (NamespaceBinding)$scope, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf31)));
        $buf28.$amp$plus((Object)new Text("\n                  "));
        $buf11.$amp$plus((Object)new Elem(null, "tr", (MetaData)$md34, (NamespaceBinding)$scope, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf28)));
        $buf11.$amp$plus((Object)new Text("\n                "));
        $buf10.$amp$plus((Object)new Elem(null, "table", (MetaData)$md17, (NamespaceBinding)$scope, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf11)));
        $buf10.$amp$plus((Object)new Text("\n              "));
        $buf8.$amp$plus((Object)new Elem(null, "td", (MetaData)$md16, (NamespaceBinding)$scope, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf10)));
        $buf8.$amp$plus((Object)new Text("\n            "));
        $buf7.$amp$plus((Object)new Elem(null, "tr", (MetaData)$md13, (NamespaceBinding)$scope, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf8)));
        $buf7.$amp$plus((Object)new Text("\n            "));
        Null$ $md38 = Null$.MODULE$;
        $md38 = new UnprefixedAttribute("id", (Seq)new Text("summary_view_row_2"), (MetaData)$md38);
        NodeBuffer $buf32 = new NodeBuffer();
        $buf32.$amp$plus((Object)new Text("\n              "));
        Null$ $md39 = Null$.MODULE$;
        $md39 = new UnprefixedAttribute("colspan", (Seq)new Text("2"), (MetaData)$md39);
        $md39 = new UnprefixedAttribute("id", (Seq)new Text("summary_view_row_2_results"), (MetaData)$md39);
        NodeBuffer $buf33 = new NodeBuffer();
        $buf33.$amp$plus((Object)new Text("\n                "));
        $buf33.$amp$plus((Object)this.getStatistic(summary));
        $buf33.$amp$plus((Object)new Text("\n                "));
        $buf33.$amp$plus((Object)this.suiteResults());
        $buf33.$amp$plus((Object)new Text("\n              "));
        $buf32.$amp$plus((Object)new Elem(null, "td", (MetaData)$md39, (NamespaceBinding)$scope, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf33)));
        $buf32.$amp$plus((Object)new Text("\n            "));
        $buf7.$amp$plus((Object)new Elem(null, "tr", (MetaData)$md38, (NamespaceBinding)$scope, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf32)));
        $buf7.$amp$plus((Object)new Text("\n          "));
        $buf6.$amp$plus((Object)new Elem(null, "table", (MetaData)$md12, (NamespaceBinding)$scope, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf7)));
        $buf6.$amp$plus((Object)new Text("\n          "));
        Null$ $md40 = Null$.MODULE$;
        $md40 = new UnprefixedAttribute("id", (Seq)new Text("details_view"), (MetaData)$md40);
        NodeBuffer $buf34 = new NodeBuffer();
        $buf34.$amp$plus((Object)new Text("\n            "));
        Null$ $md41 = Null$.MODULE$;
        $md41 = new UnprefixedAttribute("id", (Seq)new Text("click_suite_hint"), (MetaData)$md41);
        NodeBuffer $buf35 = new NodeBuffer();
        $buf35.$amp$plus((Object)new Text("Click on suite name to view details."));
        $buf34.$amp$plus((Object)new Elem(null, "span", (MetaData)$md41, (NamespaceBinding)$scope, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf35)));
        $buf34.$amp$plus((Object)new Text(" "));
        $buf34.$amp$plus((Object)new Elem(null, "br", (MetaData)Null$.MODULE$, (NamespaceBinding)$scope, true, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new scala.xml.Node[0])));
        $buf34.$amp$plus((Object)new Text("\n            "));
        Null$ $md42 = Null$.MODULE$;
        $md42 = new UnprefixedAttribute("id", (Seq)new Text("click_column_hint"), (MetaData)$md42);
        NodeBuffer $buf36 = new NodeBuffer();
        $buf36.$amp$plus((Object)new Text("Click on column name to sort."));
        $buf34.$amp$plus((Object)new Elem(null, "span", (MetaData)$md42, (NamespaceBinding)$scope, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf36)));
        $buf34.$amp$plus((Object)new Text("\n          "));
        $buf6.$amp$plus((Object)new Elem(null, "div", (MetaData)$md40, (NamespaceBinding)$scope, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf34)));
        $buf6.$amp$plus((Object)new Text("\n        "));
        $buf5.$amp$plus((Object)new Elem(null, "div", (MetaData)$md11, (NamespaceBinding)$scope, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf6)));
        $buf5.$amp$plus((Object)new Text("\n        "));
        Null$ $md43 = Null$.MODULE$;
        $md43 = new UnprefixedAttribute("type", (Seq)new Text("text/javascript"), (MetaData)$md43);
        NodeBuffer $buf37 = new NodeBuffer();
        $buf37.$amp$plus((Object)new Text("\n          "));
        $buf37.$amp$plus((Object)Suite$.MODULE$.unparsedXml(this.getPieChartScript(summary)));
        $buf37.$amp$plus((Object)new Text("\n        "));
        $buf5.$amp$plus((Object)new Elem(null, "script", (MetaData)$md43, (NamespaceBinding)$scope, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf37)));
        $buf5.$amp$plus((Object)new Text("\n        "));
        Null$ $md44 = Null$.MODULE$;
        $md44 = new UnprefixedAttribute("type", (Seq)new Text("text/javascript"), (MetaData)$md44);
        NodeBuffer $buf38 = new NodeBuffer();
        $buf38.$amp$plus((Object)new Text("\n          "));
        $buf38.$amp$plus((Object)Suite$.MODULE$.unparsedXml(this.tagMapScript()));
        $buf38.$amp$plus((Object)new Text("\n        "));
        $buf5.$amp$plus((Object)new Elem(null, "script", (MetaData)$md44, (NamespaceBinding)$scope, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf38)));
        $buf5.$amp$plus((Object)new Text("\n        "));
        Null$ $md45 = Null$.MODULE$;
        $md45 = new UnprefixedAttribute("type", (Seq)new Text("text/javascript"), (MetaData)$md45);
        NodeBuffer $buf39 = new NodeBuffer();
        $buf39.$amp$plus((Object)new Text("\n          resizeDetailsView();\n        "));
        $buf5.$amp$plus((Object)new Elem(null, "script", (MetaData)$md45, (NamespaceBinding)$scope, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf39)));
        $buf5.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "body", (MetaData)$md10, (NamespaceBinding)$scope, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf5)));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "html", (MetaData)$md, (NamespaceBinding)$scope, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf));
    }

    private Elem getStatistic(Summary summary) {
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("id", (Seq)new Text("display-filters"), (MetaData)$md);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("onchange", (Seq)new Text("applyFilter()"), (MetaData)$md2);
        $md2 = new UnprefixedAttribute("checked", (Seq)new Text("checked"), (MetaData)$md2);
        $md2 = new UnprefixedAttribute("type", (Seq)new Text("checkbox"), (MetaData)$md2);
        $md2 = new UnprefixedAttribute("name", (Seq)new Text("succeeded_checkbox"), (MetaData)$md2);
        $md2 = new UnprefixedAttribute("id", (Seq)new Text("succeeded_checkbox"), (MetaData)$md2);
        $buf.$amp$plus((Object)new Elem(null, "input", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, true, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new scala.xml.Node[0])));
        $buf.$amp$plus((Object)new Text(" "));
        Null$ $md3 = Null$.MODULE$;
        $md3 = new UnprefixedAttribute("for", (Seq)new Text("passed_checkbox"), (MetaData)$md3);
        $md3 = new UnprefixedAttribute("id", (Seq)new Text("succeeded_checkbox_label"), (MetaData)$md3);
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("Succeeded"));
        $buf.$amp$plus((Object)new Elem(null, "label", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf2)));
        $buf.$amp$plus((Object)new Text("\n      "));
        Null$ $md4 = Null$.MODULE$;
        $md4 = new UnprefixedAttribute("onchange", (Seq)new Text("applyFilter()"), (MetaData)$md4);
        $md4 = new UnprefixedAttribute("checked", (Seq)new Text("checked"), (MetaData)$md4);
        $md4 = new UnprefixedAttribute("type", (Seq)new Text("checkbox"), (MetaData)$md4);
        $md4 = new UnprefixedAttribute("name", (Seq)new Text("failed_checkbox"), (MetaData)$md4);
        $md4 = new UnprefixedAttribute("id", (Seq)new Text("failed_checkbox"), (MetaData)$md4);
        $buf.$amp$plus((Object)new Elem(null, "input", (MetaData)$md4, (NamespaceBinding)TopScope$.MODULE$, true, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new scala.xml.Node[0])));
        $buf.$amp$plus((Object)new Text(" "));
        Null$ $md5 = Null$.MODULE$;
        $md5 = new UnprefixedAttribute("for", (Seq)new Text("failed_checkbox"), (MetaData)$md5);
        $md5 = new UnprefixedAttribute("id", (Seq)new Text("failed_checkbox_label"), (MetaData)$md5);
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("Failed"));
        $buf.$amp$plus((Object)new Elem(null, "label", (MetaData)$md5, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf3)));
        $buf.$amp$plus((Object)new Text("\n      "));
        Null$ $md6 = Null$.MODULE$;
        $md6 = new UnprefixedAttribute("onchange", (Seq)new Text("applyFilter()"), (MetaData)$md6);
        $md6 = new UnprefixedAttribute("checked", (Seq)new Text("checked"), (MetaData)$md6);
        $md6 = new UnprefixedAttribute("type", (Seq)new Text("checkbox"), (MetaData)$md6);
        $md6 = new UnprefixedAttribute("name", (Seq)new Text("canceled_checkbox"), (MetaData)$md6);
        $md6 = new UnprefixedAttribute("id", (Seq)new Text("canceled_checkbox"), (MetaData)$md6);
        $buf.$amp$plus((Object)new Elem(null, "input", (MetaData)$md6, (NamespaceBinding)TopScope$.MODULE$, true, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new scala.xml.Node[0])));
        $buf.$amp$plus((Object)new Text(" "));
        Null$ $md7 = Null$.MODULE$;
        $md7 = new UnprefixedAttribute("for", (Seq)new Text("canceled_checkbox"), (MetaData)$md7);
        $md7 = new UnprefixedAttribute("id", (Seq)new Text("canceled_checkbox_label"), (MetaData)$md7);
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)new Text("Canceled"));
        $buf.$amp$plus((Object)new Elem(null, "label", (MetaData)$md7, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf4)));
        $buf.$amp$plus((Object)new Text("\n      "));
        Null$ $md8 = Null$.MODULE$;
        $md8 = new UnprefixedAttribute("onchange", (Seq)new Text("applyFilter()"), (MetaData)$md8);
        $md8 = new UnprefixedAttribute("checked", (Seq)new Text("checked"), (MetaData)$md8);
        $md8 = new UnprefixedAttribute("type", (Seq)new Text("checkbox"), (MetaData)$md8);
        $md8 = new UnprefixedAttribute("name", (Seq)new Text("ignored_checkbox"), (MetaData)$md8);
        $md8 = new UnprefixedAttribute("id", (Seq)new Text("ignored_checkbox"), (MetaData)$md8);
        $buf.$amp$plus((Object)new Elem(null, "input", (MetaData)$md8, (NamespaceBinding)TopScope$.MODULE$, true, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new scala.xml.Node[0])));
        $buf.$amp$plus((Object)new Text(" "));
        Null$ $md9 = Null$.MODULE$;
        $md9 = new UnprefixedAttribute("for", (Seq)new Text("ignored_checkbox"), (MetaData)$md9);
        $md9 = new UnprefixedAttribute("id", (Seq)new Text("ignored_checkbox_label"), (MetaData)$md9);
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("Ignored"));
        $buf.$amp$plus((Object)new Elem(null, "label", (MetaData)$md9, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf5)));
        $buf.$amp$plus((Object)new Text("\n      "));
        Null$ $md10 = Null$.MODULE$;
        $md10 = new UnprefixedAttribute("onchange", (Seq)new Text("applyFilter()"), (MetaData)$md10);
        $md10 = new UnprefixedAttribute("checked", (Seq)new Text("checked"), (MetaData)$md10);
        $md10 = new UnprefixedAttribute("type", (Seq)new Text("checkbox"), (MetaData)$md10);
        $md10 = new UnprefixedAttribute("name", (Seq)new Text("pending_checkbox"), (MetaData)$md10);
        $md10 = new UnprefixedAttribute("id", (Seq)new Text("pending_checkbox"), (MetaData)$md10);
        $buf.$amp$plus((Object)new Elem(null, "input", (MetaData)$md10, (NamespaceBinding)TopScope$.MODULE$, true, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new scala.xml.Node[0])));
        $buf.$amp$plus((Object)new Text(" "));
        Null$ $md11 = Null$.MODULE$;
        $md11 = new UnprefixedAttribute("for", (Seq)new Text("pending_checkbox"), (MetaData)$md11);
        $md11 = new UnprefixedAttribute("id", (Seq)new Text("pending_checkbox_label"), (MetaData)$md11);
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)new Text("Pending"));
        $buf.$amp$plus((Object)new Elem(null, "label", (MetaData)$md11, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf6)));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "div", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf));
    }

    private Elem header(Function0<String> completeMessageFun, Function1<String, String> completeInMessageFun, Option<Object> duration, Summary summary) {
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("class", this.getHeaderStatusColor(summary), (MetaData)$md);
        $md = new UnprefixedAttribute("id", (Seq)new Text("scalatest-header"), (MetaData)$md);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("id", (Seq)new Text("title"), (MetaData)$md2);
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n        ScalaTest Results\n      "));
        $buf.$amp$plus((Object)new Elem(null, "div", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf2)));
        $buf.$amp$plus((Object)new Text("\n\n      "));
        Null$ $md3 = Null$.MODULE$;
        $md3 = new UnprefixedAttribute("id", (Seq)new Text("summary"), (MetaData)$md3);
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("\n        "));
        Null$ $md4 = Null$.MODULE$;
        $md4 = new UnprefixedAttribute("id", (Seq)new Text("duration"), (MetaData)$md4);
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)this.getDuration(completeMessageFun, completeInMessageFun, duration));
        $buf3.$amp$plus((Object)new Elem(null, "p", (MetaData)$md4, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf4)));
        $buf3.$amp$plus((Object)new Text("\n        "));
        Null$ $md5 = Null$.MODULE$;
        $md5 = new UnprefixedAttribute("id", (Seq)new Text("totalTests"), (MetaData)$md5);
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)this.getTotalTests(summary));
        $buf3.$amp$plus((Object)new Elem(null, "p", (MetaData)$md5, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf5)));
        $buf3.$amp$plus((Object)new Text("\n        "));
        Null$ $md6 = Null$.MODULE$;
        $md6 = new UnprefixedAttribute("id", (Seq)new Text("suiteSummary"), (MetaData)$md6);
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)this.getSuiteSummary(summary));
        $buf3.$amp$plus((Object)new Elem(null, "p", (MetaData)$md6, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf6)));
        $buf3.$amp$plus((Object)new Text("\n        "));
        Null$ $md7 = Null$.MODULE$;
        $md7 = new UnprefixedAttribute("id", (Seq)new Text("testSummary"), (MetaData)$md7);
        NodeBuffer $buf7 = new NodeBuffer();
        $buf7.$amp$plus((Object)this.getTestSummary(summary));
        $buf3.$amp$plus((Object)new Elem(null, "p", (MetaData)$md7, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf7)));
        $buf3.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "div", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf3)));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "div", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf));
    }

    private String generateElementId() {
        return UUID.randomUUID().toString();
    }

    private void setBit(Stack<String> stack, HashMap<String, Object> tagMap, int bit) {
        stack.foreach((Function1 & Serializable)scopeElementId -> {
            int currentBits = BoxesRunTime.unboxToInt((Object)tagMap.apply(scopeElementId));
            return tagMap.put(scopeElementId, (Object)BoxesRunTime.boxToInteger((int)(currentBits | bit)));
        });
    }

    public HashMap<String, Object> tagMap() {
        return this.tagMap;
    }

    private Elem suiteResults() {
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("class", (Seq)new Text("sortable"), (MetaData)$md);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("Suite"));
        $buf2.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf3)));
        $buf2.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)new Text("Duration (ms.)"));
        $buf2.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf4)));
        $buf2.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("Succeeded"));
        $buf2.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf5)));
        $buf2.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)new Text("Failed"));
        $buf2.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf6)));
        $buf2.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf7 = new NodeBuffer();
        $buf7.$amp$plus((Object)new Text("Canceled"));
        $buf2.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf7)));
        $buf2.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf8 = new NodeBuffer();
        $buf8.$amp$plus((Object)new Text("Ignored"));
        $buf2.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf8)));
        $buf2.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf9 = new NodeBuffer();
        $buf9.$amp$plus((Object)new Text("Pending"));
        $buf2.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf9)));
        $buf2.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf10 = new NodeBuffer();
        $buf10.$amp$plus((Object)new Text("Total"));
        $buf2.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf10)));
        $buf2.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf2)));
        $buf.$amp$plus((Object)new Text("\n    "));
        Object[] sortedSuiteList = (SuiteResult[])((IterableOnceOps)this.results.suiteList().sortWith((Function2 & Serializable)(a, b) -> a.testsFailedCount() == b.testsFailedCount() ? (a.testsCanceledCount() == b.testsCanceledCount() ? (a.testsIgnoredCount() == b.testsIgnoredCount() ? (a.testsPendingCount() == b.testsPendingCount() ? StringOps$.MODULE$.$less$extension(Predef$.MODULE$.augmentString(a.startEvent().suiteName()), b.startEvent().suiteName()) : a.testsPendingCount() > b.testsPendingCount()) : a.testsIgnoredCount() > b.testsIgnoredCount()) : a.testsCanceledCount() > b.testsCanceledCount()) : a.testsFailedCount() > b.testsFailedCount())).toArray(ClassTag$.MODULE$.apply(SuiteResult.class));
        Object object = Predef$.MODULE$.refArrayOps(sortedSuiteList);
        $buf.$amp$plus(ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)r -> {
            String elementId = this.generateElementId();
            boolean suiteAborted = r.endEvent() instanceof SuiteAborted;
            int totalTestsCount = r.testsSucceededCount() + r.testsFailedCount() + r.testsIgnoredCount() + r.testsPendingCount() + r.testsCanceledCount();
            int bits = (r.testsSucceededCount() > 0 || totalTestsCount == 0 && !suiteAborted ? 1 : 0) + (r.testsFailedCount() > 0 || suiteAborted ? 2 : 0) + (r.testsIgnoredCount() > 0 ? 4 : 0) + (r.testsPendingCount() > 0 ? 8 : 0) + (r.testsCanceledCount() > 0 ? 16 : 0);
            this.tagMap().put((Object)elementId, (Object)BoxesRunTime.boxToInteger((int)bits));
            return this.suiteSummary(elementId, this.getSuiteFileName((SuiteResult)r), (SuiteResult)r);
        }, ClassTag$.MODULE$.apply(Elem.class)));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "table", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf));
    }

    private String countStyle(String prefix, int count) {
        return count == 0 ? new StringBuilder(5).append(prefix).append("_zero").toString() : prefix;
    }

    private Object durationDisplay(Option<Object> duration) {
        return duration.getOrElse(HtmlReporter::durationDisplay$$anonfun$1);
    }

    private Elem suiteSummary(String elementId, String suiteFileName, SuiteResult suiteResult) {
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("id", elementId, (MetaData)$md);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("class", this.appendCombinedStatus("suite_name", suiteResult), (MetaData)$md2);
        NodeBuffer $buf2 = new NodeBuffer();
        Null$ $md3 = Null$.MODULE$;
        $md3 = new UnprefixedAttribute("href", new StringBuilder(27).append("javascript: showDetails('").append(suiteFileName).append("')").toString(), (MetaData)$md3);
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)suiteResult.suiteName());
        $buf2.$amp$plus((Object)new Elem(null, "a", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf3)));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf2)));
        $buf.$amp$plus((Object)new Text("\n      "));
        Null$ $md4 = Null$.MODULE$;
        $md4 = new UnprefixedAttribute("class", this.appendCombinedStatus("duration", suiteResult), (MetaData)$md4);
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus(this.durationDisplay(suiteResult.duration()));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)$md4, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf4)));
        $buf.$amp$plus((Object)new Text("\n      "));
        Null$ $md5 = Null$.MODULE$;
        $md5 = new UnprefixedAttribute("class", this.countStyle("succeeded", suiteResult.testsSucceededCount()), (MetaData)$md5);
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)BoxesRunTime.boxToInteger((int)suiteResult.testsSucceededCount()));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)$md5, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf5)));
        $buf.$amp$plus((Object)new Text("\n      "));
        Null$ $md6 = Null$.MODULE$;
        $md6 = new UnprefixedAttribute("class", this.countStyle("failed", suiteResult.testsFailedCount()), (MetaData)$md6);
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)BoxesRunTime.boxToInteger((int)suiteResult.testsFailedCount()));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)$md6, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf6)));
        $buf.$amp$plus((Object)new Text("\n      "));
        Null$ $md7 = Null$.MODULE$;
        $md7 = new UnprefixedAttribute("class", this.countStyle("canceled", suiteResult.testsCanceledCount()), (MetaData)$md7);
        NodeBuffer $buf7 = new NodeBuffer();
        $buf7.$amp$plus((Object)BoxesRunTime.boxToInteger((int)suiteResult.testsCanceledCount()));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)$md7, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf7)));
        $buf.$amp$plus((Object)new Text("\n      "));
        Null$ $md8 = Null$.MODULE$;
        $md8 = new UnprefixedAttribute("class", this.countStyle("ignored", suiteResult.testsIgnoredCount()), (MetaData)$md8);
        NodeBuffer $buf8 = new NodeBuffer();
        $buf8.$amp$plus((Object)BoxesRunTime.boxToInteger((int)suiteResult.testsIgnoredCount()));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)$md8, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf8)));
        $buf.$amp$plus((Object)new Text("\n      "));
        Null$ $md9 = Null$.MODULE$;
        $md9 = new UnprefixedAttribute("class", this.countStyle("pending", suiteResult.testsPendingCount()), (MetaData)$md9);
        NodeBuffer $buf9 = new NodeBuffer();
        $buf9.$amp$plus((Object)BoxesRunTime.boxToInteger((int)suiteResult.testsPendingCount()));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)$md9, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf9)));
        $buf.$amp$plus((Object)new Text("\n      "));
        Null$ $md10 = Null$.MODULE$;
        $md10 = new UnprefixedAttribute("class", this.appendCombinedStatus("total", suiteResult), (MetaData)$md10);
        NodeBuffer $buf10 = new NodeBuffer();
        $buf10.$amp$plus((Object)BoxesRunTime.boxToInteger((int)(suiteResult.testsSucceededCount() + suiteResult.testsFailedCount() + suiteResult.testsIgnoredCount() + suiteResult.testsPendingCount() + suiteResult.testsCanceledCount())));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)$md10, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf10)));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "tr", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf));
    }

    private int twoLess(int indentLevel) {
        int lev;
        int n = indentLevel - 2;
        int lev2 = n;
        int n2 = lev2 < 0 ? 0 : (lev = n);
        return n2;
    }

    private int oneLess(int indentLevel) {
        int lev;
        int n = indentLevel - 1;
        int lev2 = n;
        int n2 = lev2 < 0 ? 0 : (lev = n);
        return n2;
    }

    private Elem scope(String elementId, String message, int indentLevel) {
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("style", new StringBuilder(16).append("margin-left: ").append(this.specIndent * this.oneLess(indentLevel)).append("px;").toString(), (MetaData)$md);
        $md = new UnprefixedAttribute("class", (Seq)new Text("scope"), (MetaData)$md);
        $md = new UnprefixedAttribute("id", elementId, (MetaData)$md);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)message);
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "div", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf));
    }

    private Elem test(String elementId, List<String> lines, int indentLevel, String styleName) {
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("style", new StringBuilder(16).append("margin-left: ").append(this.specIndent * this.twoLess(indentLevel)).append("px;").toString(), (MetaData)$md);
        $md = new UnprefixedAttribute("class", styleName, (MetaData)$md);
        $md = new UnprefixedAttribute("id", elementId, (MetaData)$md);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n        "));
        $buf2.$amp$plus((Object)lines.map((Function1 & Serializable)line -> {
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus(line);
            return new Elem(null, "dt", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf));
        }));
        $buf2.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "dl", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf2)));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "div", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf));
    }

    private Elem testWithDetails(String elementId, List<String> lines, String message, Option<Throwable> throwable, int indentLevel, String styleName) {
        BoxedUnit boxedUnit;
        NodeBuffer nodeBuffer;
        BoxedUnit boxedUnit2;
        Option<String> option;
        Tuple2 tuple2;
        Option<Throwable> option2 = throwable;
        if (option2 instanceof Some) {
            Throwable throwable2 = (Throwable)((Some)option2).value();
            List stackTraceElements = Predef$.MODULE$.wrapRefArray((Object[])throwable2.getStackTrace()).toList();
            Throwable throwable3 = throwable2;
            if (throwable3 instanceof StackDepthException) {
                StackDepthException sde = (StackDepthException)throwable3;
                tuple2 = Tuple2$.MODULE$.apply((Object)stackTraceElements.take(sde.failedCodeStackDepth()), (Object)stackTraceElements.drop(sde.failedCodeStackDepth()));
            } else {
                tuple2 = Tuple2$.MODULE$.apply(package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0])), (Object)stackTraceElements);
            }
        } else if (None$.MODULE$.equals(option2)) {
            tuple2 = Tuple2$.MODULE$.apply(package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0])), package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0])));
        } else {
            throw new MatchError(option2);
        }
        Tuple2 tuple22 = tuple2;
        List grayStackTraceElements = (List)tuple22._1();
        List blackStackTraceElements = (List)tuple22._2();
        Option throwableTitle = throwable.map((Function1 & Serializable)_$6 -> _$6.getClass().getName());
        Option<Throwable> option3 = throwable;
        if (option3 instanceof Some) {
            Throwable throwable4 = (Throwable)((Some)option3).value();
            Throwable throwable5 = throwable4;
            if (throwable5 instanceof StackDepth) {
                Throwable stackDepth = (Throwable)((Object)((StackDepth)((Object)throwable5)));
                option = ((StackDepth)((Object)stackDepth)).failedCodeFileNameAndLineNumberString();
            } else {
                option = None$.MODULE$;
            }
        } else if (None$.MODULE$.equals(option3)) {
            option = None$.MODULE$;
        } else {
            throw new MatchError(option3);
        }
        Option<String> fileAndLineOption = option;
        String linkId = UUID.randomUUID().toString();
        String contentId = UUID.randomUUID().toString();
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("style", new StringBuilder(16).append("margin-left: ").append(this.specIndent * this.twoLess(indentLevel)).append("px;").toString(), (MetaData)$md);
        $md = new UnprefixedAttribute("class", styleName, (MetaData)$md);
        $md = new UnprefixedAttribute("id", elementId, (MetaData)$md);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n        "));
        $buf2.$amp$plus((Object)lines.map((Function1 & Serializable)line -> {
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus(line);
            return new Elem(null, "dt", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf));
        }));
        $buf2.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "dl", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf2)));
        $buf.$amp$plus((Object)new Text("\n      "));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("class", (Seq)new Text("detailstoggle"), (MetaData)$md2);
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("\n      "));
        Null$ $md3 = Null$.MODULE$;
        $md3 = new UnprefixedAttribute("href", new StringBuilder(33).append("javascript:toggleDetails('").append(contentId).append("', '").append(linkId).append("');").toString(), (MetaData)$md3);
        $md3 = new UnprefixedAttribute("id", linkId, (MetaData)$md3);
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)new Text("(Show Details)"));
        $buf3.$amp$plus((Object)new Elem(null, "a", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf4)));
        $buf3.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "div", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf3)));
        $buf.$amp$plus((Object)new Text("\n      "));
        Null$ $md4 = Null$.MODULE$;
        $md4 = new UnprefixedAttribute("style", (Seq)new Text("display: none"), (MetaData)$md4);
        $md4 = new UnprefixedAttribute("id", contentId, (MetaData)$md4);
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)new Text("\n          "));
        Null$ $md5 = Null$.MODULE$;
        $md5 = new UnprefixedAttribute("valign", (Seq)new Text("top"), (MetaData)$md5);
        NodeBuffer $buf7 = new NodeBuffer();
        $buf7.$amp$plus((Object)new Text("\n              "));
        Null$ $md6 = Null$.MODULE$;
        $md6 = new UnprefixedAttribute("align", (Seq)new Text("left"), (MetaData)$md6);
        NodeBuffer $buf8 = new NodeBuffer();
        Null$ $md7 = Null$.MODULE$;
        $md7 = new UnprefixedAttribute("class", (Seq)new Text("label"), (MetaData)$md7);
        NodeBuffer $buf9 = new NodeBuffer();
        $buf9.$amp$plus((Object)new StringBuilder(1).append(Resources$.MODULE$.DetailsMessage()).append(":").toString());
        $buf8.$amp$plus((Object)new Elem(null, "span", (MetaData)$md7, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf9)));
        $buf7.$amp$plus((Object)new Elem(null, "td", (MetaData)$md6, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf8)));
        $buf7.$amp$plus((Object)new Text("\n              "));
        Null$ $md8 = Null$.MODULE$;
        $md8 = new UnprefixedAttribute("align", (Seq)new Text("left"), (MetaData)$md8);
        NodeBuffer $buf10 = new NodeBuffer();
        $buf10.$amp$plus(HtmlReporter.displayErrorMessage$1(message, message));
        $buf7.$amp$plus((Object)new Elem(null, "td", (MetaData)$md8, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf10)));
        $buf7.$amp$plus((Object)new Text("\n            "));
        $buf6.$amp$plus((Object)new Elem(null, "tr", (MetaData)$md5, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf7)));
        $buf6.$amp$plus((Object)new Text("\n          "));
        Option<String> option4 = fileAndLineOption;
        if (option4 instanceof Some) {
            String fileAndLine = (String)((Some)option4).value();
            Null$ $md9 = Null$.MODULE$;
            $md9 = new UnprefixedAttribute("valign", (Seq)new Text("top"), (MetaData)$md9);
            NodeBuffer $buf11 = new NodeBuffer();
            Null$ $md10 = Null$.MODULE$;
            $md10 = new UnprefixedAttribute("align", (Seq)new Text("left"), (MetaData)$md10);
            NodeBuffer $buf12 = new NodeBuffer();
            Null$ $md11 = Null$.MODULE$;
            $md11 = new UnprefixedAttribute("class", (Seq)new Text("label"), (MetaData)$md11);
            NodeBuffer $buf13 = new NodeBuffer();
            $buf13.$amp$plus((Object)new StringBuilder(1).append(Resources$.MODULE$.LineNumber()).append(":").toString());
            $buf12.$amp$plus((Object)new Elem(null, "span", (MetaData)$md11, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf13)));
            $buf11.$amp$plus((Object)new Elem(null, "td", (MetaData)$md10, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf12)));
            Null$ $md12 = Null$.MODULE$;
            $md12 = new UnprefixedAttribute("align", (Seq)new Text("left"), (MetaData)$md12);
            NodeBuffer $buf14 = new NodeBuffer();
            NodeBuffer $buf15 = new NodeBuffer();
            $buf15.$amp$plus((Object)new StringBuilder(2).append("(").append(fileAndLine).append(")").toString());
            $buf14.$amp$plus((Object)new Elem(null, "span", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf15)));
            $buf11.$amp$plus((Object)new Elem(null, "td", (MetaData)$md12, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf14)));
            Elem elem = new Elem(null, "tr", (MetaData)$md9, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf11));
            boxedUnit2 = elem;
        } else if (None$.MODULE$.equals(option4)) {
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option4);
        }
        $buf6.$amp$plus((Object)boxedUnit2);
        $buf6.$amp$plus((Object)new Text("\n          "));
        Option option5 = throwableTitle;
        if (option5 instanceof Some) {
            String title = (String)((Some)option5).value();
            Null$ $md13 = Null$.MODULE$;
            $md13 = new UnprefixedAttribute("valign", (Seq)new Text("top"), (MetaData)$md13);
            NodeBuffer $buf16 = new NodeBuffer();
            Null$ $md14 = Null$.MODULE$;
            $md14 = new UnprefixedAttribute("align", (Seq)new Text("right"), (MetaData)$md14);
            NodeBuffer $buf17 = new NodeBuffer();
            Null$ $md15 = Null$.MODULE$;
            $md15 = new UnprefixedAttribute("class", (Seq)new Text("label"), (MetaData)$md15);
            NodeBuffer $buf18 = new NodeBuffer();
            $buf18.$amp$plus((Object)new StringBuilder(1).append(Resources$.MODULE$.DetailsThrowable()).append(":").toString());
            $buf17.$amp$plus((Object)new Elem(null, "span", (MetaData)$md15, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf18)));
            $buf16.$amp$plus((Object)new Elem(null, "td", (MetaData)$md14, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf17)));
            Null$ $md16 = Null$.MODULE$;
            $md16 = new UnprefixedAttribute("align", (Seq)new Text("left"), (MetaData)$md16);
            NodeBuffer $buf19 = new NodeBuffer();
            $buf19.$amp$plus((Object)title);
            $buf16.$amp$plus((Object)new Elem(null, "td", (MetaData)$md16, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf19)));
            Elem elem = new Elem(null, "tr", (MetaData)$md13, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf16));
            nodeBuffer = elem;
        } else if (None$.MODULE$.equals(option5)) {
            nodeBuffer = new NodeBuffer();
        } else {
            throw new MatchError((Object)option5);
        }
        $buf6.$amp$plus((Object)nodeBuffer);
        $buf6.$amp$plus((Object)new Text("\n        "));
        $buf5.$amp$plus((Object)new Elem(null, "table", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf6)));
        $buf5.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf20 = new NodeBuffer();
        $buf20.$amp$plus((Object)new Text("\n          "));
        Null$ $md17 = Null$.MODULE$;
        $md17 = new UnprefixedAttribute("valign", (Seq)new Text("top"), (MetaData)$md17);
        NodeBuffer $buf21 = new NodeBuffer();
        Null$ $md18 = Null$.MODULE$;
        $md18 = new UnprefixedAttribute("colspan", (Seq)new Text("2"), (MetaData)$md18);
        $md18 = new UnprefixedAttribute("align", (Seq)new Text("left"), (MetaData)$md18);
        NodeBuffer $buf22 = new NodeBuffer();
        $buf22.$amp$plus((Object)new Text("\n            "));
        $buf22.$amp$plus((Object)grayStackTraceElements.map((Function1 & Serializable)ste -> {
            Null$ $md = Null$.MODULE$;
            $md = new UnprefixedAttribute("class", (Seq)new Text("gray"), (MetaData)$md);
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)ste.toString());
            return new Elem(null, "div", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf));
        }));
        $buf22.$amp$plus((Object)new Text("\n            "));
        $buf22.$amp$plus((Object)blackStackTraceElements.map((Function1 & Serializable)ste -> {
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)ste.toString());
            return new Elem(null, "div", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf));
        }));
        $buf22.$amp$plus((Object)new Text("\n            "));
        $buf21.$amp$plus((Object)new Elem(null, "td", (MetaData)$md18, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf22)));
        $buf21.$amp$plus((Object)new Text("\n          "));
        $buf20.$amp$plus((Object)new Elem(null, "tr", (MetaData)$md17, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf21)));
        $buf20.$amp$plus((Object)new Text("\n        "));
        $buf5.$amp$plus((Object)new Elem(null, "table", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf20)));
        $buf5.$amp$plus((Object)new Text("\n        "));
        Option<Throwable> option6 = throwable;
        if (option6 instanceof Some) {
            Throwable t = (Throwable)((Some)option6).value();
            boxedUnit = HtmlReporter.getHTMLForCause$1(message, t);
        } else if (None$.MODULE$.equals(option6)) {
            boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option6);
        }
        $buf5.$amp$plus((Object)boxedUnit);
        $buf5.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "div", (MetaData)$md4, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf5)));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "div", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf));
    }

    private Elem markup(String elementId, String text, int indentLevel, String styleName) {
        String htmlString = HtmlReporter$.MODULE$.convertAmpersand(HtmlReporter$.MODULE$.convertSingleParaToDefinition(this.markdownToHtml(text)));
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("style", new StringBuilder(16).append("margin-left: ").append(this.specIndent * this.twoLess(indentLevel)).append("px;").toString(), (MetaData)$md);
        $md = new UnprefixedAttribute("class", styleName, (MetaData)$md);
        $md = new UnprefixedAttribute("id", elementId, (MetaData)$md);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n       "));
        $buf.$amp$plus((Object)HtmlReporter.liftedTree1$1(htmlString));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "div", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf));
    }

    private String tagMapScript() {
        return new StringBuilder(29).append("tagMap = { \n").append(((IterableOnceOps)this.tagMap().map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String elementId = (String)tuple2._1();
            int bitSet = BoxesRunTime.unboxToInt((Object)tuple2._2());
            return new StringBuilder(4).append("\"").append(elementId).append("\": ").append(bitSet).toString();
        })).mkString(", \n")).append("};\n").append("applyFilter();").toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void apply(Event event) {
        ListBuffer otherEvents;
        Event event2 = event;
        if (event2 instanceof DiscoveryStarting) {
            return;
        }
        if (event2 instanceof DiscoveryCompleted) {
            return;
        }
        if (event2 instanceof RunStarting) {
            RunStarting runStarting = RunStarting$.MODULE$.unapply((RunStarting)event2);
            Ordinal ordinal = runStarting._1();
            int n = runStarting._2();
            ConfigMap configMap = runStarting._3();
            Option<Formatter> option = runStarting._4();
            Option<Location> option2 = runStarting._5();
            Option<Object> option3 = runStarting._6();
            String string = runStarting._7();
            long l = runStarting._8();
            Ordinal ordinal2 = ordinal;
            int testCount = n;
            ConfigMap configMap2 = configMap;
            Option<Formatter> formatter = option;
            Option<Location> location = option2;
            Option<Object> payload = option3;
            String threadName = string;
            long timeStamp = l;
            return;
        }
        if (event2 instanceof RunCompleted) {
            RunCompleted runCompleted = RunCompleted$.MODULE$.unapply((RunCompleted)event2);
            Ordinal ordinal = runCompleted._1();
            Option<Object> option = runCompleted._2();
            Option<Summary> option4 = runCompleted._3();
            Option<Formatter> option5 = runCompleted._4();
            Option<Location> option6 = runCompleted._5();
            Option<Object> option7 = runCompleted._6();
            String string = runCompleted._7();
            long l = runCompleted._8();
            Ordinal ordinal3 = ordinal;
            Option<Object> duration = option;
            Option<Summary> summary = option4;
            Option<Formatter> formatter = option5;
            Option<Location> location = option6;
            Option<Object> payload = option7;
            String threadName = string;
            long timeStamp = l;
            this.runEndEvent = Some$.MODULE$.apply((Object)event);
            return;
        }
        if (event2 instanceof RunStopped) {
            RunStopped runStopped = RunStopped$.MODULE$.unapply((RunStopped)event2);
            Ordinal ordinal = runStopped._1();
            Option<Object> option = runStopped._2();
            Option<Summary> option8 = runStopped._3();
            Option<Formatter> option9 = runStopped._4();
            Option<Location> option10 = runStopped._5();
            Option<Object> option11 = runStopped._6();
            String string = runStopped._7();
            long l = runStopped._8();
            Ordinal ordinal4 = ordinal;
            Option<Object> duration = option;
            Option<Summary> summary = option8;
            Option<Formatter> formatter = option9;
            Option<Location> location = option10;
            Option<Object> payload = option11;
            String threadName = string;
            long timeStamp = l;
            this.runEndEvent = Some$.MODULE$.apply((Object)event);
            return;
        }
        if (event2 instanceof RunAborted) {
            RunAborted runAborted = RunAborted$.MODULE$.unapply((RunAborted)event2);
            Ordinal ordinal = runAborted._1();
            String string = runAborted._2();
            Option<Throwable> option = runAborted._3();
            Option<Object> option12 = runAborted._4();
            Option<Summary> option13 = runAborted._5();
            Option<Formatter> option14 = runAborted._6();
            Option<Location> option15 = runAborted._7();
            Option<Object> option16 = runAborted._8();
            String string2 = runAborted._9();
            long l = runAborted._10();
            Ordinal ordinal5 = ordinal;
            String message = string;
            Option<Throwable> throwable = option;
            Option<Object> duration = option12;
            Option<Summary> summary = option13;
            Option<Formatter> formatter = option14;
            Option<Location> location = option15;
            Option<Object> payload = option16;
            String threadName = string2;
            long timeStamp = l;
            this.runEndEvent = Some$.MODULE$.apply((Object)event);
            return;
        }
        if (event2 instanceof SuiteCompleted) {
            ListBuffer otherEvents2;
            SuiteCompleted suiteCompleted = SuiteCompleted$.MODULE$.unapply((SuiteCompleted)event2);
            Ordinal ordinal = suiteCompleted._1();
            String string = suiteCompleted._2();
            String string3 = suiteCompleted._3();
            Option<String> option = suiteCompleted._4();
            Option<Object> option17 = suiteCompleted._5();
            Option<Formatter> option18 = suiteCompleted._6();
            Option<Location> option19 = suiteCompleted._7();
            Option<String> option20 = suiteCompleted._8();
            Option<Object> option21 = suiteCompleted._9();
            String string4 = suiteCompleted._10();
            long l = suiteCompleted._11();
            Ordinal ordinal6 = ordinal;
            String suiteName = string;
            String suiteId = string3;
            Option<String> suiteClassName = option;
            Option<Object> duration = option17;
            Option<Formatter> formatter = option18;
            Option<Location> location = option19;
            Option<String> rerunner = option20;
            Option<Object> payload = option21;
            String threadName = string4;
            long timeStamp = l;
            Tuple2<ListBuffer<Event>, ListBuffer<Event>> tuple2 = this.extractSuiteEvents(suiteId);
            if (tuple2 == null) throw new MatchError(tuple2);
            ListBuffer suiteEvents = (ListBuffer)tuple2._1();
            ListBuffer otherEvents3 = (ListBuffer)tuple2._2();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)suiteEvents, (Object)otherEvents3);
            ListBuffer suiteEvents2 = (ListBuffer)tuple22._1();
            this.eventList = otherEvents2 = (ListBuffer)tuple22._2();
            ListBuffer sortedSuiteEvents = (ListBuffer)suiteEvents2.sorted(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
            if (sortedSuiteEvents.isEmpty()) {
                throw new IllegalStateException(new StringBuilder(107).append("Expected SuiteStarting for completion event: ").append(event).append(" in the head of suite events, but we got no suite event at all").toString());
            }
            Event event3 = (Event)sortedSuiteEvents.head();
            if (!(event3 instanceof SuiteStarting)) {
                Event other = event3;
                throw new IllegalStateException(new StringBuilder(87).append("Expected SuiteStarting for completion event: ").append(event).append(" in the head of suite events, but we got: ").append(other).toString());
            }
            SuiteStarting suiteStarting = (SuiteStarting)event3;
            SuiteResult suiteResult = (SuiteResult)sortedSuiteEvents.foldLeft((Object)SuiteResult$.MODULE$.apply(suiteId, suiteName, suiteClassName, duration, suiteStarting, event, (IndexedSeq<Event>)((IndexedSeq)package$.MODULE$.Vector().empty().$plus$plus((IterableOnce)sortedSuiteEvents.tail())), 0, 0, 0, 0, 0, 0, true), (Function2 & Serializable)(x$1, x$2) -> {
                SuiteResult suiteResult;
                Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
                if (tuple2 != null) {
                    SuiteResult r = (SuiteResult)tuple2._1();
                    Event e = (Event)tuple2._2();
                    Event event = e;
                    if (event instanceof TestSucceeded) {
                        TestSucceeded testSucceeded = (TestSucceeded)event;
                        int n = r.testsSucceededCount() + 1;
                        String string = r.copy$default$1();
                        String string2 = r.copy$default$2();
                        Option<String> option = r.copy$default$3();
                        Option<Object> option2 = r.copy$default$4();
                        SuiteStarting suiteStarting = r.copy$default$5();
                        Event event2 = r.copy$default$6();
                        IndexedSeq<Event> indexedSeq = r.copy$default$7();
                        int n2 = r.copy$default$9();
                        int n3 = r.copy$default$10();
                        int n4 = r.copy$default$11();
                        int n5 = r.copy$default$12();
                        int n6 = r.copy$default$13();
                        boolean bl = r.copy$default$14();
                        suiteResult = r.copy(string, string2, option, option2, suiteStarting, event2, indexedSeq, n, n2, n3, n4, n5, n6, bl);
                    } else if (event instanceof TestFailed) {
                        TestFailed testFailed = (TestFailed)event;
                        int n = r.testsFailedCount() + 1;
                        String string = r.copy$default$1();
                        String string3 = r.copy$default$2();
                        Option<String> option = r.copy$default$3();
                        Option<Object> option3 = r.copy$default$4();
                        SuiteStarting suiteStarting = r.copy$default$5();
                        Event event3 = r.copy$default$6();
                        IndexedSeq<Event> indexedSeq = r.copy$default$7();
                        int n7 = r.copy$default$8();
                        int n8 = r.copy$default$10();
                        int n9 = r.copy$default$11();
                        int n10 = r.copy$default$12();
                        int n11 = r.copy$default$13();
                        boolean bl = r.copy$default$14();
                        suiteResult = r.copy(string, string3, option, option3, suiteStarting, event3, indexedSeq, n7, n, n8, n9, n10, n11, bl);
                    } else if (event instanceof TestIgnored) {
                        TestIgnored testIgnored = (TestIgnored)event;
                        int n = r.testsIgnoredCount() + 1;
                        String string = r.copy$default$1();
                        String string4 = r.copy$default$2();
                        Option<String> option = r.copy$default$3();
                        Option<Object> option4 = r.copy$default$4();
                        SuiteStarting suiteStarting = r.copy$default$5();
                        Event event4 = r.copy$default$6();
                        IndexedSeq<Event> indexedSeq = r.copy$default$7();
                        int n12 = r.copy$default$8();
                        int n13 = r.copy$default$9();
                        int n14 = r.copy$default$11();
                        int n15 = r.copy$default$12();
                        int n16 = r.copy$default$13();
                        boolean bl = r.copy$default$14();
                        suiteResult = r.copy(string, string4, option, option4, suiteStarting, event4, indexedSeq, n12, n13, n, n14, n15, n16, bl);
                    } else if (event instanceof TestPending) {
                        TestPending testPending = (TestPending)event;
                        int n = r.testsPendingCount() + 1;
                        String string = r.copy$default$1();
                        String string5 = r.copy$default$2();
                        Option<String> option = r.copy$default$3();
                        Option<Object> option5 = r.copy$default$4();
                        SuiteStarting suiteStarting = r.copy$default$5();
                        Event event5 = r.copy$default$6();
                        IndexedSeq<Event> indexedSeq = r.copy$default$7();
                        int n17 = r.copy$default$8();
                        int n18 = r.copy$default$9();
                        int n19 = r.copy$default$10();
                        int n20 = r.copy$default$12();
                        int n21 = r.copy$default$13();
                        boolean bl = r.copy$default$14();
                        suiteResult = r.copy(string, string5, option, option5, suiteStarting, event5, indexedSeq, n17, n18, n19, n, n20, n21, bl);
                    } else if (event instanceof TestCanceled) {
                        TestCanceled testCanceled = (TestCanceled)event;
                        int n = r.testsCanceledCount() + 1;
                        String string = r.copy$default$1();
                        String string6 = r.copy$default$2();
                        Option<String> option = r.copy$default$3();
                        Option<Object> option6 = r.copy$default$4();
                        SuiteStarting suiteStarting = r.copy$default$5();
                        Event event6 = r.copy$default$6();
                        IndexedSeq<Event> indexedSeq = r.copy$default$7();
                        int n22 = r.copy$default$8();
                        int n23 = r.copy$default$9();
                        int n24 = r.copy$default$10();
                        int n25 = r.copy$default$11();
                        int n26 = r.copy$default$13();
                        boolean bl = r.copy$default$14();
                        suiteResult = r.copy(string, string6, option, option6, suiteStarting, event6, indexedSeq, n22, n23, n24, n25, n, n26, bl);
                    } else if (event instanceof ScopePending) {
                        ScopePending scopePending = (ScopePending)event;
                        int n = r.scopesPendingCount() + 1;
                        String string = r.copy$default$1();
                        String string7 = r.copy$default$2();
                        Option<String> option = r.copy$default$3();
                        Option<Object> option7 = r.copy$default$4();
                        SuiteStarting suiteStarting = r.copy$default$5();
                        Event event7 = r.copy$default$6();
                        IndexedSeq<Event> indexedSeq = r.copy$default$7();
                        int n27 = r.copy$default$8();
                        int n28 = r.copy$default$9();
                        int n29 = r.copy$default$10();
                        int n30 = r.copy$default$11();
                        int n31 = r.copy$default$12();
                        boolean bl = r.copy$default$14();
                        suiteResult = r.copy(string, string7, option, option7, suiteStarting, event7, indexedSeq, n27, n28, n29, n30, n31, n, bl);
                    } else {
                        suiteResult = r;
                    }
                } else {
                    throw new MatchError((Object)tuple2);
                }
                return suiteResult;
            });
            SuiteStarting suiteStartingEvent = (SuiteStarting)sortedSuiteEvents.head();
            Option<Formatter> option22 = suiteStartingEvent.formatter();
            Some some = Some$.MODULE$.apply((Object)MotionToSuppress$.MODULE$);
            if (option22 == null) {
                if (some == null) return;
            } else if (option22.equals((Object)some)) return;
            this.results.$plus$eq(suiteResult);
            this.makeSuiteFile(suiteResult);
            return;
        }
        if (!(event2 instanceof SuiteAborted)) {
            this.eventList.$plus$eq((Object)event);
            return;
        }
        SuiteAborted suiteAborted = SuiteAborted$.MODULE$.unapply((SuiteAborted)event2);
        Ordinal ordinal = suiteAborted._1();
        String string = suiteAborted._2();
        String string5 = suiteAborted._3();
        String string6 = suiteAborted._4();
        Option<String> option = suiteAborted._5();
        Option<Throwable> option23 = suiteAborted._6();
        Option<Object> option24 = suiteAborted._7();
        Option<Formatter> option25 = suiteAborted._8();
        Option<Location> option26 = suiteAborted._9();
        Option<String> option27 = suiteAborted._10();
        Option<Object> option28 = suiteAborted._11();
        String string7 = suiteAborted._12();
        long l = suiteAborted._13();
        Ordinal ordinal7 = ordinal;
        String message = string;
        String suiteName = string5;
        String suiteId = string6;
        Option<String> suiteClassName = option;
        Option<Throwable> throwable = option23;
        Option<Object> duration = option24;
        Option<Formatter> formatter = option25;
        Option<Location> location = option26;
        Option<String> rerunner = option27;
        Option<Object> payload = option28;
        String threadName = string7;
        long timeStamp = l;
        Tuple2<ListBuffer<Event>, ListBuffer<Event>> tuple2 = this.extractSuiteEvents(suiteId);
        if (tuple2 == null) throw new MatchError(tuple2);
        ListBuffer suiteEvents = (ListBuffer)tuple2._1();
        ListBuffer otherEvents4 = (ListBuffer)tuple2._2();
        Tuple2 tuple23 = Tuple2$.MODULE$.apply((Object)suiteEvents, (Object)otherEvents4);
        ListBuffer suiteEvents3 = (ListBuffer)tuple23._1();
        this.eventList = otherEvents = (ListBuffer)tuple23._2();
        ListBuffer sortedSuiteEvents = (ListBuffer)suiteEvents3.sorted(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
        if (sortedSuiteEvents.isEmpty()) {
            throw new IllegalStateException(new StringBuilder(107).append("Expected SuiteStarting for completion event: ").append(event).append(" in the head of suite events, but we got no suite event at all").toString());
        }
        Event event4 = (Event)sortedSuiteEvents.head();
        if (event4 instanceof SuiteStarting) {
            SuiteStarting suiteStarting = (SuiteStarting)event4;
            SuiteResult suiteResult = (SuiteResult)sortedSuiteEvents.foldLeft((Object)SuiteResult$.MODULE$.apply(suiteId, suiteName, suiteClassName, duration, suiteStarting, event, (IndexedSeq<Event>)((IndexedSeq)package$.MODULE$.Vector().empty().$plus$plus((IterableOnce)sortedSuiteEvents.tail())), 0, 0, 0, 0, 0, 0, false), (Function2 & Serializable)(x$1, x$2) -> {
                SuiteResult suiteResult;
                Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
                if (tuple2 != null) {
                    SuiteResult r = (SuiteResult)tuple2._1();
                    Event e = (Event)tuple2._2();
                    Event event = e;
                    if (event instanceof TestSucceeded) {
                        TestSucceeded testSucceeded = (TestSucceeded)event;
                        int n = r.testsSucceededCount() + 1;
                        String string = r.copy$default$1();
                        String string2 = r.copy$default$2();
                        Option<String> option = r.copy$default$3();
                        Option<Object> option2 = r.copy$default$4();
                        SuiteStarting suiteStarting = r.copy$default$5();
                        Event event2 = r.copy$default$6();
                        IndexedSeq<Event> indexedSeq = r.copy$default$7();
                        int n2 = r.copy$default$9();
                        int n3 = r.copy$default$10();
                        int n4 = r.copy$default$11();
                        int n5 = r.copy$default$12();
                        int n6 = r.copy$default$13();
                        boolean bl = r.copy$default$14();
                        suiteResult = r.copy(string, string2, option, option2, suiteStarting, event2, indexedSeq, n, n2, n3, n4, n5, n6, bl);
                    } else if (event instanceof TestFailed) {
                        TestFailed testFailed = (TestFailed)event;
                        int n = r.testsFailedCount() + 1;
                        String string = r.copy$default$1();
                        String string3 = r.copy$default$2();
                        Option<String> option = r.copy$default$3();
                        Option<Object> option3 = r.copy$default$4();
                        SuiteStarting suiteStarting = r.copy$default$5();
                        Event event3 = r.copy$default$6();
                        IndexedSeq<Event> indexedSeq = r.copy$default$7();
                        int n7 = r.copy$default$8();
                        int n8 = r.copy$default$10();
                        int n9 = r.copy$default$11();
                        int n10 = r.copy$default$12();
                        int n11 = r.copy$default$13();
                        boolean bl = r.copy$default$14();
                        suiteResult = r.copy(string, string3, option, option3, suiteStarting, event3, indexedSeq, n7, n, n8, n9, n10, n11, bl);
                    } else if (event instanceof TestIgnored) {
                        TestIgnored testIgnored = (TestIgnored)event;
                        int n = r.testsIgnoredCount() + 1;
                        String string = r.copy$default$1();
                        String string4 = r.copy$default$2();
                        Option<String> option = r.copy$default$3();
                        Option<Object> option4 = r.copy$default$4();
                        SuiteStarting suiteStarting = r.copy$default$5();
                        Event event4 = r.copy$default$6();
                        IndexedSeq<Event> indexedSeq = r.copy$default$7();
                        int n12 = r.copy$default$8();
                        int n13 = r.copy$default$9();
                        int n14 = r.copy$default$11();
                        int n15 = r.copy$default$12();
                        int n16 = r.copy$default$13();
                        boolean bl = r.copy$default$14();
                        suiteResult = r.copy(string, string4, option, option4, suiteStarting, event4, indexedSeq, n12, n13, n, n14, n15, n16, bl);
                    } else if (event instanceof TestPending) {
                        TestPending testPending = (TestPending)event;
                        int n = r.testsPendingCount() + 1;
                        String string = r.copy$default$1();
                        String string5 = r.copy$default$2();
                        Option<String> option = r.copy$default$3();
                        Option<Object> option5 = r.copy$default$4();
                        SuiteStarting suiteStarting = r.copy$default$5();
                        Event event5 = r.copy$default$6();
                        IndexedSeq<Event> indexedSeq = r.copy$default$7();
                        int n17 = r.copy$default$8();
                        int n18 = r.copy$default$9();
                        int n19 = r.copy$default$10();
                        int n20 = r.copy$default$12();
                        int n21 = r.copy$default$13();
                        boolean bl = r.copy$default$14();
                        suiteResult = r.copy(string, string5, option, option5, suiteStarting, event5, indexedSeq, n17, n18, n19, n, n20, n21, bl);
                    } else if (event instanceof TestCanceled) {
                        TestCanceled testCanceled = (TestCanceled)event;
                        int n = r.testsCanceledCount() + 1;
                        String string = r.copy$default$1();
                        String string6 = r.copy$default$2();
                        Option<String> option = r.copy$default$3();
                        Option<Object> option6 = r.copy$default$4();
                        SuiteStarting suiteStarting = r.copy$default$5();
                        Event event6 = r.copy$default$6();
                        IndexedSeq<Event> indexedSeq = r.copy$default$7();
                        int n22 = r.copy$default$8();
                        int n23 = r.copy$default$9();
                        int n24 = r.copy$default$10();
                        int n25 = r.copy$default$11();
                        int n26 = r.copy$default$13();
                        boolean bl = r.copy$default$14();
                        suiteResult = r.copy(string, string6, option, option6, suiteStarting, event6, indexedSeq, n22, n23, n24, n25, n, n26, bl);
                    } else if (event instanceof ScopePending) {
                        ScopePending scopePending = (ScopePending)event;
                        int n = r.scopesPendingCount() + 1;
                        String string = r.copy$default$1();
                        String string7 = r.copy$default$2();
                        Option<String> option = r.copy$default$3();
                        Option<Object> option7 = r.copy$default$4();
                        SuiteStarting suiteStarting = r.copy$default$5();
                        Event event7 = r.copy$default$6();
                        IndexedSeq<Event> indexedSeq = r.copy$default$7();
                        int n27 = r.copy$default$8();
                        int n28 = r.copy$default$9();
                        int n29 = r.copy$default$10();
                        int n30 = r.copy$default$11();
                        int n31 = r.copy$default$12();
                        boolean bl = r.copy$default$14();
                        suiteResult = r.copy(string, string7, option, option7, suiteStarting, event7, indexedSeq, n27, n28, n29, n30, n31, n, bl);
                    } else {
                        suiteResult = r;
                    }
                } else {
                    throw new MatchError((Object)tuple2);
                }
                return suiteResult;
            });
            this.results.$plus$eq(suiteResult);
            this.makeSuiteFile(suiteResult);
            return;
        }
        Event other = event4;
        throw new IllegalStateException(new StringBuilder(87).append("Expected SuiteStarting for completion event: ").append(event).append(" in the head of suite events, but we got: ").append(other).toString());
    }

    public Tuple2<ListBuffer<Event>, ListBuffer<Event>> extractSuiteEvents(String suiteId) {
        return this.eventList.partition((Function1 & Serializable)e -> {
            boolean bl;
            Event event = e;
            if (event instanceof TestStarting) {
                TestStarting e2 = (TestStarting)event;
                String string = e2.suiteId();
                String string2 = suiteId;
                bl = !(string != null ? !string.equals(string2) : string2 != null);
            } else if (event instanceof TestSucceeded) {
                TestSucceeded e3 = (TestSucceeded)event;
                String string = e3.suiteId();
                String string3 = suiteId;
                bl = !(string != null ? !string.equals(string3) : string3 != null);
            } else if (event instanceof TestIgnored) {
                TestIgnored e4 = (TestIgnored)event;
                String string = e4.suiteId();
                String string4 = suiteId;
                bl = !(string != null ? !string.equals(string4) : string4 != null);
            } else if (event instanceof TestFailed) {
                TestFailed e5 = (TestFailed)event;
                String string = e5.suiteId();
                String string5 = suiteId;
                bl = !(string != null ? !string.equals(string5) : string5 != null);
            } else if (event instanceof TestPending) {
                TestPending e6 = (TestPending)event;
                String string = e6.suiteId();
                String string6 = suiteId;
                bl = !(string != null ? !string.equals(string6) : string6 != null);
            } else if (event instanceof TestCanceled) {
                TestCanceled e7 = (TestCanceled)event;
                String string = e7.suiteId();
                String string7 = suiteId;
                bl = !(string != null ? !string.equals(string7) : string7 != null);
            } else if (event instanceof InfoProvided) {
                InfoProvided e8 = (InfoProvided)event;
                bl = e8.nameInfo().exists((Function1 & Serializable)_$7 -> {
                    String string = _$7.suiteId();
                    String string2 = suiteId;
                    return !(string != null ? !string.equals(string2) : string2 != null);
                });
            } else if (event instanceof AlertProvided) {
                AlertProvided e9 = (AlertProvided)event;
                bl = e9.nameInfo().exists((Function1 & Serializable)_$8 -> {
                    String string = _$8.suiteId();
                    String string2 = suiteId;
                    return !(string != null ? !string.equals(string2) : string2 != null);
                });
            } else if (event instanceof NoteProvided) {
                NoteProvided e10 = (NoteProvided)event;
                bl = e10.nameInfo().exists((Function1 & Serializable)_$9 -> {
                    String string = _$9.suiteId();
                    String string2 = suiteId;
                    return !(string != null ? !string.equals(string2) : string2 != null);
                });
            } else if (event instanceof MarkupProvided) {
                MarkupProvided e11 = (MarkupProvided)event;
                bl = e11.nameInfo().exists((Function1 & Serializable)_$10 -> {
                    String string = _$10.suiteId();
                    String string2 = suiteId;
                    return !(string != null ? !string.equals(string2) : string2 != null);
                });
            } else if (event instanceof ScopeOpened) {
                ScopeOpened e12 = (ScopeOpened)event;
                String string = e12.nameInfo().suiteId();
                String string8 = suiteId;
                bl = !(string != null ? !string.equals(string8) : string8 != null);
            } else if (event instanceof ScopeClosed) {
                ScopeClosed e13 = (ScopeClosed)event;
                String string = e13.nameInfo().suiteId();
                String string9 = suiteId;
                bl = !(string != null ? !string.equals(string9) : string9 != null);
            } else if (event instanceof ScopePending) {
                ScopePending e14 = (ScopePending)event;
                String string = e14.nameInfo().suiteId();
                String string10 = suiteId;
                bl = !(string != null ? !string.equals(string10) : string10 != null);
            } else if (event instanceof SuiteStarting) {
                SuiteStarting e15 = (SuiteStarting)event;
                String string = e15.suiteId();
                String string11 = suiteId;
                bl = !(string != null ? !string.equals(string11) : string11 != null);
            } else {
                bl = false;
            }
            return bl;
        });
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void dispose() {
        Option<Event> option = this.runEndEvent;
        if (!(option instanceof Some)) {
            if (!None$.MODULE$.equals(option)) throw new MatchError(option);
            this.makeIndexFile((Function0<String>)((Function0 & Serializable)HtmlReporter::dispose$$anonfun$7), (Function1<String, String>)(Function1 & Serializable)param0 -> Resources$.MODULE$.runCompletedIn(param0), (Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)this.results.totalDuration())));
            return;
        }
        Event event = (Event)((Some)option).value();
        Event event2 = event;
        if (event2 instanceof RunCompleted) {
            RunCompleted runCompleted = RunCompleted$.MODULE$.unapply((RunCompleted)event2);
            Ordinal ordinal = runCompleted._1();
            Option<Object> option2 = runCompleted._2();
            Option<Summary> option3 = runCompleted._3();
            Option<Formatter> option4 = runCompleted._4();
            Option<Location> option5 = runCompleted._5();
            Option<Object> option6 = runCompleted._6();
            String string = runCompleted._7();
            long l = runCompleted._8();
            Ordinal ordinal2 = ordinal;
            Option<Object> duration = option2;
            Option<Summary> summary = option3;
            Option<Formatter> formatter = option4;
            Option<Location> location = option5;
            Option<Object> payload = option6;
            String threadName = string;
            long timeStamp = l;
            this.makeIndexFile((Function0<String>)((Function0 & Serializable)HtmlReporter::dispose$$anonfun$1), (Function1<String, String>)(Function1 & Serializable)param0 -> Resources$.MODULE$.runCompletedIn(param0), duration);
            return;
        }
        if (event2 instanceof RunStopped) {
            RunStopped runStopped = RunStopped$.MODULE$.unapply((RunStopped)event2);
            Ordinal ordinal = runStopped._1();
            Option<Object> option7 = runStopped._2();
            Option<Summary> option8 = runStopped._3();
            Option<Formatter> option9 = runStopped._4();
            Option<Location> option10 = runStopped._5();
            Option<Object> option11 = runStopped._6();
            String string = runStopped._7();
            long l = runStopped._8();
            Ordinal ordinal3 = ordinal;
            Option<Object> duration = option7;
            Option<Summary> summary = option8;
            Option<Formatter> formatter = option9;
            Option<Location> location = option10;
            Option<Object> payload = option11;
            String threadName = string;
            long timeStamp = l;
            this.makeIndexFile((Function0<String>)((Function0 & Serializable)HtmlReporter::dispose$$anonfun$3), (Function1<String, String>)(Function1 & Serializable)param0 -> Resources$.MODULE$.runStoppedIn(param0), duration);
            return;
        }
        if (event2 instanceof RunAborted) {
            RunAborted runAborted = RunAborted$.MODULE$.unapply((RunAborted)event2);
            Ordinal ordinal = runAborted._1();
            String string = runAborted._2();
            Option<Throwable> option12 = runAborted._3();
            Option<Object> option13 = runAborted._4();
            Option<Summary> option14 = runAborted._5();
            Option<Formatter> option15 = runAborted._6();
            Option<Location> option16 = runAborted._7();
            Option<Object> option17 = runAborted._8();
            String string2 = runAborted._9();
            long l = runAborted._10();
            Ordinal ordinal4 = ordinal;
            String message = string;
            Option<Throwable> throwable = option12;
            Option<Object> duration = option13;
            Option<Summary> summary = option14;
            Option<Formatter> formatter = option15;
            Option<Location> location = option16;
            Option<Object> payload = option17;
            String threadName = string2;
            long timeStamp = l;
            this.makeIndexFile((Function0<String>)((Function0 & Serializable)HtmlReporter::dispose$$anonfun$5), (Function1<String, String>)(Function1 & Serializable)param0 -> Resources$.MODULE$.runAbortedIn(param0), duration);
            return;
        }
        Event other = event2;
        throw new IllegalStateException(new StringBuilder(41).append("Expected run ending event only, but got: ").append(other.getClass().getName()).toString());
    }

    private String getDuration(Function0<String> completeMessageFun, Function1<String, String> completeInMessageFun, Option<Object> duration) {
        String string;
        Option<Object> option = duration;
        if (option instanceof Some) {
            long msSinceEpoch = BoxesRunTime.unboxToLong((Object)((Some)option).value());
            string = (String)completeInMessageFun.apply((Object)StringReporter$.MODULE$.makeDurationString(msSinceEpoch));
        } else if (None$.MODULE$.equals(option)) {
            string = (String)completeMessageFun.apply();
        } else {
            throw new MatchError(option);
        }
        return string;
    }

    private String getTotalTests(Summary summary) {
        return Resources$.MODULE$.totalNumberOfTestsRun(BoxesRunTime.boxToInteger((int)summary.testsCompletedCount()).toString());
    }

    private String getSuiteSummary(Summary summary) {
        return summary.scopesPendingCount() > 0 ? Resources$.MODULE$.suiteScopeSummary(BoxesRunTime.boxToInteger((int)summary.suitesCompletedCount()).toString(), BoxesRunTime.boxToInteger((int)summary.suitesAbortedCount()).toString(), BoxesRunTime.boxToInteger((int)summary.scopesPendingCount()).toString()) : Resources$.MODULE$.suiteSummary(BoxesRunTime.boxToInteger((int)summary.suitesCompletedCount()).toString(), BoxesRunTime.boxToInteger((int)summary.suitesAbortedCount()).toString());
    }

    private String getTestSummary(Summary summary) {
        return Resources$.MODULE$.testSummary(BoxesRunTime.boxToInteger((int)summary.testsSucceededCount()).toString(), BoxesRunTime.boxToInteger((int)summary.testsFailedCount()).toString(), BoxesRunTime.boxToInteger((int)summary.testsCanceledCount()).toString(), BoxesRunTime.boxToInteger((int)summary.testsIgnoredCount()).toString(), BoxesRunTime.boxToInteger((int)summary.testsPendingCount()).toString());
    }

    private static final SuiteResultHolder $init$$$anonfun$2() {
        return new SuiteResultHolder();
    }

    private static final String getSuiteFileName$$anonfun$1(SuiteResult suiteResult$1) {
        return suiteResult$1.suiteName();
    }

    private static final /* synthetic */ String $anonfun$1(Object param0) {
        return Resources$.MODULE$.scopeOpened(param0);
    }

    private static final /* synthetic */ String $anonfun$2(Object param0) {
        return Resources$.MODULE$.scopePending(param0);
    }

    private static final /* synthetic */ String $anonfun$3(Object param0) {
        return Resources$.MODULE$.testSucceeded(param0);
    }

    private final /* synthetic */ NodeSeq getSuiteHtml$$anonfun$1$$anonfun$1(RecordableEvent _$2) {
        return this.processInfoMarkupProvided((Event)((Object)_$2), "test_passed");
    }

    private static final String $anonfun$4() {
        return Resources$.MODULE$.failedNote();
    }

    private static final /* synthetic */ String $anonfun$5(Object param0) {
        return Resources$.MODULE$.testFailed(param0);
    }

    private final /* synthetic */ NodeSeq getSuiteHtml$$anonfun$1$$anonfun$2(RecordableEvent _$3) {
        return this.processInfoMarkupProvided((Event)((Object)_$3), "test_failed");
    }

    private final /* synthetic */ NodeSeq getSuiteHtml$$anonfun$1$$anonfun$3(RecordableEvent _$4) {
        return this.processInfoMarkupProvided((Event)((Object)_$4), "test_pending");
    }

    private static final String $anonfun$6() {
        return Resources$.MODULE$.canceledNote();
    }

    private static final /* synthetic */ String $anonfun$7(Object param0) {
        return Resources$.MODULE$.testCanceled(param0);
    }

    private final /* synthetic */ NodeSeq getSuiteHtml$$anonfun$1$$anonfun$4(RecordableEvent _$5) {
        return this.processInfoMarkupProvided((Event)((Object)_$5), "test_canceled");
    }

    /*
     * Unable to fully structure code
     */
    private final /* synthetic */ AbstractSeq getSuiteHtml$$anonfun$1(Stack scopeStack$1, Event e) {
        block24: {
            block35: {
                block32: {
                    block34: {
                        block33: {
                            block31: {
                                block30: {
                                    block27: {
                                        block29: {
                                            block28: {
                                                block26: {
                                                    block22: {
                                                        block25: {
                                                            block23: {
                                                                var3_3 = e;
                                                                if (!(var3_3 instanceof ScopeOpened)) break block22;
                                                                var4_4 = ScopeOpened$.MODULE$.unapply((ScopeOpened)var3_3);
                                                                var5_5 = var4_4._1();
                                                                var6_6 = var4_4._2();
                                                                var7_7 = var4_4._3();
                                                                var8_8 = var4_4._4();
                                                                var9_9 = var4_4._5();
                                                                var10_10 = var4_4._6();
                                                                var11_11 = var4_4._7();
                                                                var12_12 = var4_4._8();
                                                                ordinal = var5_5;
                                                                message = var6_6;
                                                                nameInfo = var7_7;
                                                                formatter = var8_8;
                                                                location = var9_9;
                                                                payload = var10_10;
                                                                threadName = var11_11;
                                                                timeStamp = var12_12;
                                                                testNameInfo = nameInfo.testName();
                                                                stringToPrint = this.stringToPrintWhenNoError((Function1<Object, String>)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$1(java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/String;)(), formatter, nameInfo.suiteName(), nameInfo.testName());
                                                                var25_23 = stringToPrint;
                                                                if (!(var25_23 instanceof Some)) break block23;
                                                                string = (String)((Some)var25_23).value();
                                                                elementId = this.generateElementId();
                                                                scopeStack$1.push((Object)elementId);
                                                                v0 = this.scope(elementId, string, this.getIndentLevel(formatter) + 1);
                                                                break block24;
                                                            }
                                                            if (!None$.MODULE$.equals(var25_23)) break block25;
                                                            v0 = NodeSeq$.MODULE$.Empty();
                                                            break block24;
                                                        }
                                                        throw new MatchError(var25_23);
                                                    }
                                                    if (!(var3_3 instanceof ScopeClosed)) break block26;
                                                    var28_26 = ScopeClosed$.MODULE$.unapply((ScopeClosed)var3_3);
                                                    var29_27 = var28_26._1();
                                                    var30_28 = var28_26._2();
                                                    var31_29 = var28_26._3();
                                                    var32_30 = var28_26._4();
                                                    var33_31 = var28_26._5();
                                                    var34_32 = var28_26._6();
                                                    var35_33 = var28_26._7();
                                                    var36_34 = var28_26._8();
                                                    ordinal = var29_27;
                                                    message = var30_28;
                                                    nameInfo = var31_29;
                                                    formatter = var32_30;
                                                    location = var33_31;
                                                    payload = var34_32;
                                                    threadName = var35_33;
                                                    timeStamp = var36_34;
                                                    scopeStack$1.pop();
                                                    v0 = NodeSeq$.MODULE$.Empty();
                                                    break block24;
                                                }
                                                if (!(var3_3 instanceof ScopePending)) break block27;
                                                var47_43 = ScopePending$.MODULE$.unapply((ScopePending)var3_3);
                                                var48_44 = var47_43._1();
                                                var49_45 = var47_43._2();
                                                var50_46 = var47_43._3();
                                                var51_47 = var47_43._4();
                                                var52_48 = var47_43._5();
                                                var53_49 = var47_43._6();
                                                var54_50 = var47_43._7();
                                                var55_51 = var47_43._8();
                                                ordinal = var48_44;
                                                message = var49_45;
                                                nameInfo = var50_46;
                                                formatter = var51_47;
                                                location = var52_48;
                                                payload = var53_49;
                                                threadName = var54_50;
                                                timeStamp = var55_51;
                                                testNameInfo = nameInfo.testName();
                                                stringToPrint = this.stringToPrintWhenNoError((Function1<Object, String>)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$2(java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/String;)(), formatter, nameInfo.suiteName(), nameInfo.testName());
                                                var68_62 = stringToPrint;
                                                if (!(var68_62 instanceof Some)) break block28;
                                                string = (String)((Some)var68_62).value();
                                                elementId = this.generateElementId();
                                                v0 = this.scope(elementId, string, this.getIndentLevel(formatter) + 1);
                                                break block24;
                                            }
                                            if (!None$.MODULE$.equals(var68_62)) break block29;
                                            v0 = NodeSeq$.MODULE$.Empty();
                                            break block24;
                                        }
                                        throw new MatchError(var68_62);
                                    }
                                    if (!(var3_3 instanceof TestSucceeded)) break block30;
                                    var71_65 = TestSucceeded$.MODULE$.unapply((TestSucceeded)var3_3);
                                    var72_66 = var71_65._1();
                                    var73_67 = var71_65._2();
                                    var74_68 = var71_65._3();
                                    var75_69 = var71_65._4();
                                    var76_70 = var71_65._5();
                                    var77_71 = var71_65._6();
                                    var78_72 = var71_65._7();
                                    var79_73 = var71_65._8();
                                    var80_74 = var71_65._9();
                                    var81_75 = var71_65._10();
                                    var82_76 = var71_65._11();
                                    var83_77 = var71_65._12();
                                    var84_78 = var71_65._13();
                                    var85_79 = var71_65._14();
                                    ordinal = var72_66;
                                    suiteName = var73_67;
                                    suiteId = var74_68;
                                    suiteClassName = var75_69;
                                    testName = var76_70;
                                    testText = var77_71;
                                    recordedEvents = var78_72;
                                    duration = var79_73;
                                    formatter = var80_74;
                                    location = var81_75;
                                    rerunnable = var82_76;
                                    payload = var83_77;
                                    threadName = var84_78;
                                    timeStamp = var85_79;
                                    stringToPrint = this.stringToPrintWhenNoError((Function1<Object, String>)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$3(java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/String;)(), formatter, suiteName, (Option<String>)Some$.MODULE$.apply((Object)testName), duration);
                                    var104_95 = stringToPrint;
                                    if (var104_95 instanceof Some) {
                                        string = (String)((Some)var104_95).value();
                                        elementId = this.generateElementId();
                                        v1 = this.test(elementId, (List<String>)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{string}))), this.getIndentLevel(formatter) + 1, "test_passed");
                                    } else if (None$.MODULE$.equals(var104_95)) {
                                        v1 = NodeSeq$.MODULE$.Empty();
                                    } else {
                                        throw new MatchError(var104_95);
                                    }
                                    nodeSeq = v1;
                                    v0 = ((IterableOnceOps)recordedEvents.map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getSuiteHtml$$anonfun$1$$anonfun$1(org.scalatest.events.RecordableEvent ), (Lorg/scalatest/events/RecordableEvent;)Lscala/xml/NodeSeq;)((HtmlReporter)this))).toList().$colon$colon((Object)nodeSeq);
                                    break block24;
                                }
                                if (!(var3_3 instanceof TestFailed)) break block31;
                                var107_99 = TestFailed$.MODULE$.unapply((TestFailed)var3_3);
                                var108_100 = var107_99._1();
                                var109_101 = var107_99._2();
                                var110_102 = var107_99._3();
                                var111_103 = var107_99._4();
                                var112_104 = var107_99._5();
                                var113_105 = var107_99._6();
                                var114_106 = var107_99._7();
                                var115_107 = var107_99._8();
                                var116_108 = var107_99._9();
                                var117_109 = var107_99._10();
                                var118_110 = var107_99._11();
                                var119_111 = var107_99._12();
                                var120_112 = var107_99._13();
                                var121_113 = var107_99._14();
                                var122_114 = var107_99._15();
                                var123_115 = var107_99._16();
                                var124_116 = var107_99._17();
                                ordinal = var108_100;
                                message = var109_101;
                                suiteName = var110_102;
                                suiteId = var111_103;
                                suiteClassName = var112_104;
                                testName = var113_105;
                                testText = var114_106;
                                recordedEvents = var115_107;
                                analysis = var116_108;
                                throwable = var117_109;
                                duration = var118_110;
                                formatter = var119_111;
                                location = var120_112;
                                rerunnable = var121_113;
                                payload = var122_114;
                                threadName = var123_115;
                                timeStamp = var124_116;
                                stringToPrint = this.stringsToPrintOnError((Function0<String>)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$4(), ()Ljava/lang/String;)(), (Function1<Object, String>)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$5(java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/String;)(), message, throwable, formatter, (Option<String>)Some$.MODULE$.apply((Object)suiteName), (Option<String>)Some$.MODULE$.apply((Object)testName), duration);
                                elementId = this.generateElementId();
                                nodeSeq = this.testWithDetails(elementId, (List<String>)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{stringToPrint}))), message, throwable, this.getIndentLevel(formatter) + 1, "test_failed");
                                v0 = ((IterableOnceOps)recordedEvents.map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getSuiteHtml$$anonfun$1$$anonfun$2(org.scalatest.events.RecordableEvent ), (Lorg/scalatest/events/RecordableEvent;)Lscala/xml/NodeSeq;)((HtmlReporter)this))).toList().$colon$colon((Object)nodeSeq);
                                break block24;
                            }
                            if (!(var3_3 instanceof TestIgnored)) break block32;
                            var147_137 = TestIgnored$.MODULE$.unapply((TestIgnored)var3_3);
                            var148_138 = var147_137._1();
                            var149_139 = var147_137._2();
                            var150_140 = var147_137._3();
                            var151_141 = var147_137._4();
                            var152_142 = var147_137._5();
                            var153_143 = var147_137._6();
                            var154_144 = var147_137._7();
                            var155_145 = var147_137._8();
                            var156_146 = var147_137._9();
                            var157_147 = var147_137._10();
                            var158_148 = var147_137._11();
                            ordinal = var148_138;
                            suiteName = var149_139;
                            suiteId = var150_140;
                            suiteClassName = var151_141;
                            testName = var152_142;
                            testText = var153_143;
                            formatter = var154_144;
                            location = var155_145;
                            payload = var156_146;
                            threadName = var157_147;
                            timeStamp = var158_148;
                            var173_160 = formatter;
                            if (!(var173_160 instanceof Some)) ** GOTO lbl-1000
                            var174_161 = (Formatter)((Some)var173_160).value();
                            if (var174_161 instanceof IndentedText) {
                                var175_162 = IndentedText$.MODULE$.unapply((IndentedText)var174_161);
                                var176_163 = var175_162._1();
                                var177_164 = var175_162._2();
                                var178_165 = var175_162._3();
                                rawText = var177_164;
                                v2 = Some$.MODULE$.apply((Object)Resources$.MODULE$.specTextAndNote(rawText, Resources$.MODULE$.ignoredNote()));
                            } else if (MotionToSuppress$.MODULE$.equals(var174_161)) {
                                v2 = None$.MODULE$;
                            } else lbl-1000:
                            // 2 sources

                            {
                                v2 = Some$.MODULE$.apply((Object)Resources$.MODULE$.testIgnored(new StringBuilder(2).append(suiteName).append(": ").append(testName).toString()));
                            }
                            var180_168 = stringToPrint = v2;
                            if (!(var180_168 instanceof Some)) break block33;
                            string = (String)((Some)var180_168).value();
                            elementId = this.generateElementId();
                            v0 = this.test(elementId, (List<String>)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{string}))), this.getIndentLevel(formatter) + 1, "test_ignored");
                            break block24;
                        }
                        if (!None$.MODULE$.equals(var180_168)) break block34;
                        v0 = NodeSeq$.MODULE$.Empty();
                        break block24;
                    }
                    throw new MatchError((Object)var180_168);
                }
                if (!(var3_3 instanceof TestPending)) break block35;
                var183_171 = TestPending$.MODULE$.unapply((TestPending)var3_3);
                var184_172 = var183_171._1();
                var185_173 = var183_171._2();
                var186_174 = var183_171._3();
                var187_175 = var183_171._4();
                var188_176 = var183_171._5();
                var189_177 = var183_171._6();
                var190_178 = var183_171._7();
                var191_179 = var183_171._8();
                var192_180 = var183_171._9();
                var193_181 = var183_171._10();
                var194_182 = var183_171._11();
                var195_183 = var183_171._12();
                var196_184 = var183_171._13();
                ordinal = var184_172;
                suiteName = var185_173;
                suiteId = var186_174;
                suiteClassName = var187_175;
                testName = var188_176;
                testText = var189_177;
                recordedEvents = var190_178;
                duration = var191_179;
                formatter = var192_180;
                location = var193_181;
                payload = var194_182;
                threadName = var195_183;
                timeStamp = var196_184;
                var213_198 = formatter;
                if (!(var213_198 instanceof Some)) ** GOTO lbl-1000
                var214_199 = (Formatter)((Some)var213_198).value();
                if (var214_199 instanceof IndentedText) {
                    var215_200 = IndentedText$.MODULE$.unapply((IndentedText)var214_199);
                    var216_201 = var215_200._1();
                    var217_202 = var215_200._2();
                    var218_203 = var215_200._3();
                    rawText = var217_202;
                    v3 = Some$.MODULE$.apply((Object)Resources$.MODULE$.specTextAndNote(rawText, Resources$.MODULE$.pendingNote()));
                } else if (MotionToSuppress$.MODULE$.equals(var214_199)) {
                    v3 = None$.MODULE$;
                } else lbl-1000:
                // 2 sources

                {
                    v3 = Some$.MODULE$.apply((Object)Resources$.MODULE$.testPending(new StringBuilder(2).append(suiteName).append(": ").append(testName).toString()));
                }
                var221_206 = stringToPrint = v3;
                if (var221_206 instanceof Some) {
                    string = (String)((Some)var221_206).value();
                    elementId = this.generateElementId();
                    v4 = this.test(elementId, (List<String>)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{string}))), this.getIndentLevel(formatter) + 1, "test_pending");
                } else if (None$.MODULE$.equals(var221_206)) {
                    v4 = NodeSeq$.MODULE$.Empty();
                } else {
                    throw new MatchError((Object)var221_206);
                }
                nodeSeq = v4;
                v0 = ((IterableOnceOps)recordedEvents.map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getSuiteHtml$$anonfun$1$$anonfun$3(org.scalatest.events.RecordableEvent ), (Lorg/scalatest/events/RecordableEvent;)Lscala/xml/NodeSeq;)((HtmlReporter)this))).toList().$colon$colon((Object)nodeSeq);
                break block24;
            }
            if (var3_3 instanceof TestCanceled) {
                var224_210 = TestCanceled$.MODULE$.unapply((TestCanceled)var3_3);
                var225_211 = var224_210._1();
                var226_212 = var224_210._2();
                var227_213 = var224_210._3();
                var228_214 = var224_210._4();
                var229_215 = var224_210._5();
                var230_216 = var224_210._6();
                var231_217 = var224_210._7();
                var232_218 = var224_210._8();
                var233_219 = var224_210._9();
                var234_220 = var224_210._10();
                var235_221 = var224_210._11();
                var236_222 = var224_210._12();
                var237_223 = var224_210._13();
                var238_224 = var224_210._14();
                var239_225 = var224_210._15();
                var240_226 = var224_210._16();
                ordinal = var225_211;
                message = var226_212;
                suiteName = var227_213;
                suiteId = var228_214;
                suiteClassName = var229_215;
                testName = var230_216;
                testText = var231_217;
                recordedEvents = var232_218;
                throwable = var233_219;
                duration = var234_220;
                formatter = var235_221;
                location = var236_222;
                rerunner = var237_223;
                payload = var238_224;
                var256_241 = var239_225;
                var257_242 = var240_226;
                var259_243 = this.stringsToPrintOnError((Function0<String>)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$6(), ()Ljava/lang/String;)(), (Function1<Object, String>)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$7(java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/String;)(), message, throwable, formatter, (Option<String>)Some$.MODULE$.apply((Object)suiteName), (Option<String>)Some$.MODULE$.apply((Object)testName), duration);
                var260_244 = this.generateElementId();
                var261_245 = this.testWithDetails((String)elementId, (List<String>)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{stringToPrint}))), message, throwable, this.getIndentLevel(formatter) + 1, "test_canceled");
                v0 = ((IterableOnceOps)recordedEvents.map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getSuiteHtml$$anonfun$1$$anonfun$4(org.scalatest.events.RecordableEvent ), (Lorg/scalatest/events/RecordableEvent;)Lscala/xml/NodeSeq;)((HtmlReporter)this))).toList().$colon$colon((Object)nodeSeq);
            } else if (var3_3 instanceof InfoProvided) {
                var262_246 = (InfoProvided)var3_3;
                v0 = this.processInfoMarkupProvided((Event)infoProvided, "info");
            } else if (var3_3 instanceof MarkupProvided) {
                var263_247 = (MarkupProvided)var3_3;
                v0 = this.processInfoMarkupProvided((Event)markupProvided, "markup");
            } else {
                v0 = NodeSeq$.MODULE$.Empty();
            }
        }
        return (AbstractSeq)v0;
    }

    private static final String getSuiteHtml$$anonfun$2() {
        return "-";
    }

    private static final String $anonfun$8() {
        return Resources$.MODULE$.infoProvidedNote();
    }

    private static final String durationDisplay$$anonfun$1() {
        return "-";
    }

    private static final List getHTMLForStackTrace$1(List stackTraceList) {
        return stackTraceList.map((Function1 & Serializable)ste -> {
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)ste.toString());
            return new Elem(null, "div", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf));
        });
    }

    private static final Object displayErrorMessage$1(String message$1, String errorMessage) {
        Object object;
        Object[] messageLines = errorMessage.split("\n");
        Object object2 = Predef$.MODULE$.refArrayOps(messageLines);
        if (ArrayOps$.MODULE$.size$extension(object2) > 1) {
            Object object3 = Predef$.MODULE$.refArrayOps(messageLines);
            object = ArrayOps$.MODULE$.map$extension(object3, (Function1 & Serializable)line -> {
                NodeBuffer $buf = new NodeBuffer();
                $buf.$amp$plus((Object)Suite$.MODULE$.xmlContent((String)line));
                $buf.$amp$plus((Object)Suite$.MODULE$.unparsedXml("<br />"));
                return new Elem(null, "span", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf));
            }, ClassTag$.MODULE$.apply(Elem.class));
        } else {
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)message$1);
            Elem elem = new Elem(null, "span", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf));
            object = elem;
        }
        return object;
    }

    private static final NodeBuffer getHTMLForCause$1(String message$2, Throwable throwable) {
        NodeBuffer nodeBuffer;
        Throwable cause = throwable.getCause();
        if (cause != null) {
            Object object;
            NodeBuffer $buf = new NodeBuffer();
            NodeBuffer $buf2 = new NodeBuffer();
            $buf2.$amp$plus((Object)new Text("\n          "));
            Null$ $md = Null$.MODULE$;
            $md = new UnprefixedAttribute("valign", (Seq)new Text("top"), (MetaData)$md);
            NodeBuffer $buf3 = new NodeBuffer();
            $buf3.$amp$plus((Object)new Text("\n            "));
            Null$ $md2 = Null$.MODULE$;
            $md2 = new UnprefixedAttribute("align", (Seq)new Text("right"), (MetaData)$md2);
            NodeBuffer $buf4 = new NodeBuffer();
            Null$ $md3 = Null$.MODULE$;
            $md3 = new UnprefixedAttribute("class", (Seq)new Text("label"), (MetaData)$md3);
            NodeBuffer $buf5 = new NodeBuffer();
            $buf5.$amp$plus((Object)new StringBuilder(1).append(Resources$.MODULE$.DetailsCause()).append(":").toString());
            $buf4.$amp$plus((Object)new Elem(null, "span", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf5)));
            $buf3.$amp$plus((Object)new Elem(null, "td", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf4)));
            $buf3.$amp$plus((Object)new Text("\n            "));
            Null$ $md4 = Null$.MODULE$;
            $md4 = new UnprefixedAttribute("align", (Seq)new Text("left"), (MetaData)$md4);
            NodeBuffer $buf6 = new NodeBuffer();
            $buf6.$amp$plus((Object)cause.getClass().getName());
            $buf3.$amp$plus((Object)new Elem(null, "td", (MetaData)$md4, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf6)));
            $buf3.$amp$plus((Object)new Text("\n          "));
            $buf2.$amp$plus((Object)new Elem(null, "tr", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf3)));
            $buf2.$amp$plus((Object)new Text("\n          "));
            Null$ $md5 = Null$.MODULE$;
            $md5 = new UnprefixedAttribute("valign", (Seq)new Text("top"), (MetaData)$md5);
            NodeBuffer $buf7 = new NodeBuffer();
            $buf7.$amp$plus((Object)new Text("\n            "));
            Null$ $md6 = Null$.MODULE$;
            $md6 = new UnprefixedAttribute("align", (Seq)new Text("right"), (MetaData)$md6);
            NodeBuffer $buf8 = new NodeBuffer();
            Null$ $md7 = Null$.MODULE$;
            $md7 = new UnprefixedAttribute("class", (Seq)new Text("label"), (MetaData)$md7);
            NodeBuffer $buf9 = new NodeBuffer();
            $buf9.$amp$plus((Object)new StringBuilder(1).append(Resources$.MODULE$.DetailsMessage()).append(":").toString());
            $buf8.$amp$plus((Object)new Elem(null, "span", (MetaData)$md7, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf9)));
            $buf7.$amp$plus((Object)new Elem(null, "td", (MetaData)$md6, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf8)));
            $buf7.$amp$plus((Object)new Text("\n            "));
            Null$ $md8 = Null$.MODULE$;
            $md8 = new UnprefixedAttribute("align", (Seq)new Text("left"), (MetaData)$md8);
            NodeBuffer $buf10 = new NodeBuffer();
            $buf10.$amp$plus((Object)new Text("\n              "));
            if (cause.getMessage() != null) {
                object = HtmlReporter.displayErrorMessage$1(message$2, cause.getMessage());
            } else {
                NodeBuffer $buf11 = new NodeBuffer();
                $buf11.$amp$plus((Object)Resources$.MODULE$.None());
                Elem elem = new Elem(null, "span", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf11));
                object = elem;
            }
            $buf10.$amp$plus(object);
            $buf10.$amp$plus((Object)new Text("\n            "));
            $buf7.$amp$plus((Object)new Elem(null, "td", (MetaData)$md8, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf10)));
            $buf7.$amp$plus((Object)new Text("\n          "));
            $buf2.$amp$plus((Object)new Elem(null, "tr", (MetaData)$md5, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf7)));
            $buf2.$amp$plus((Object)new Text("\n        "));
            $buf.$amp$plus((Object)new Elem(null, "table", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf2)));
            NodeBuffer $buf12 = new NodeBuffer();
            $buf12.$amp$plus((Object)new Text("\n          "));
            Null$ $md9 = Null$.MODULE$;
            $md9 = new UnprefixedAttribute("valign", (Seq)new Text("top"), (MetaData)$md9);
            NodeBuffer $buf13 = new NodeBuffer();
            $buf13.$amp$plus((Object)new Text("\n            "));
            Null$ $md10 = Null$.MODULE$;
            $md10 = new UnprefixedAttribute("colspan", (Seq)new Text("2"), (MetaData)$md10);
            $md10 = new UnprefixedAttribute("align", (Seq)new Text("left"), (MetaData)$md10);
            NodeBuffer $buf14 = new NodeBuffer();
            $buf14.$amp$plus((Object)HtmlReporter.getHTMLForStackTrace$1(Predef$.MODULE$.wrapRefArray((Object[])cause.getStackTrace()).toList()));
            $buf13.$amp$plus((Object)new Elem(null, "td", (MetaData)$md10, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf14)));
            $buf13.$amp$plus((Object)new Text("\n          "));
            $buf12.$amp$plus((Object)new Elem(null, "tr", (MetaData)$md9, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf13)));
            $buf12.$amp$plus((Object)new Text("\n        "));
            $buf.$amp$plus((Object)new Elem(null, "table", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf12)));
            nodeBuffer = $buf.$amp$plus((Object)HtmlReporter.getHTMLForCause$1(message$2, cause));
        } else {
            nodeBuffer = new NodeBuffer();
        }
        return nodeBuffer;
    }

    private static final Elem liftedTree1$1(String htmlString$1) {
        Elem elem;
        try {
            elem = (Elem)XML$.MODULE$.loadString(htmlString$1);
        }
        catch (Exception e) {
            elem = (Elem)XML$.MODULE$.loadString(new StringBuilder(11).append("<div>").append(htmlString$1).append("</div>").toString());
        }
        return elem;
    }

    private static final String dispose$$anonfun$1() {
        return Resources$.MODULE$.runCompleted();
    }

    private static final String dispose$$anonfun$3() {
        return Resources$.MODULE$.runStopped();
    }

    private static final String dispose$$anonfun$5() {
        return Resources$.MODULE$.runAborted();
    }

    private static final String dispose$$anonfun$7() {
        return Resources$.MODULE$.runCompleted();
    }
}

