/*
 * Decompiled with CFR 0.152.
 */
package org.scalatest.tools;

import java.io.PrintWriter;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Enumeration;
import java.util.Properties;
import org.scalatest.Reporter;
import org.scalatest.events.AlertProvided;
import org.scalatest.events.DiscoveryCompleted;
import org.scalatest.events.DiscoveryStarting;
import org.scalatest.events.Event;
import org.scalatest.events.InfoProvided;
import org.scalatest.events.MarkupProvided;
import org.scalatest.events.NameInfo;
import org.scalatest.events.NoteProvided;
import org.scalatest.events.RecordableEvent;
import org.scalatest.events.RunAborted;
import org.scalatest.events.RunCompleted;
import org.scalatest.events.RunStarting;
import org.scalatest.events.RunStopped;
import org.scalatest.events.ScopeClosed;
import org.scalatest.events.ScopeOpened;
import org.scalatest.events.ScopePending;
import org.scalatest.events.SuiteAborted;
import org.scalatest.events.SuiteCompleted;
import org.scalatest.events.SuiteStarting;
import org.scalatest.events.TestCanceled;
import org.scalatest.events.TestFailed;
import org.scalatest.events.TestIgnored;
import org.scalatest.events.TestPending;
import org.scalatest.events.TestStarting;
import org.scalatest.events.TestSucceeded;
import org.scalatest.tools.JUnitXmlReporter$Testcase$;
import org.scalatest.tools.JUnitXmlReporter$Testsuite$;
import org.scalatest.tools.PrettyPrinter;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;
import scala.runtime.Scala3RunTime$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.Node;
import scala.xml.NodeBuffer;
import scala.xml.NodeSeq;
import scala.xml.NodeSeq$;
import scala.xml.Null$;
import scala.xml.Text;
import scala.xml.TopScope$;
import scala.xml.Unparsed$;
import scala.xml.UnprefixedAttribute;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class JUnitXmlReporter
implements Reporter {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffset(JUnitXmlReporter.class, "0bitmap$1");
    public long 0bitmap$1;
    private final String directory;
    private final Set<Event> events;
    private final Elem propertiesXml;
    public String hostname$lzy1;
    public final JUnitXmlReporter$Testsuite$ Testsuite$lzy1;
    public final JUnitXmlReporter$Testcase$ Testcase$lzy1;

    public JUnitXmlReporter(String directory) {
        this.directory = directory;
        this.Testsuite$lzy1 = new JUnitXmlReporter$Testsuite$(this);
        this.Testcase$lzy1 = new JUnitXmlReporter$Testcase$(this);
        this.events = (Set)Set$.MODULE$.empty();
        this.propertiesXml = this.genPropertiesXml();
    }

    @Override
    public void apply(Event event) {
        block1: {
            Event event2;
            block0: {
                this.events.$plus$eq((Object)event);
                event2 = event;
                if (!(event2 instanceof SuiteCompleted)) break block0;
                SuiteCompleted e = (SuiteCompleted)event2;
                this.writeSuiteFile(e, e.suiteId());
                break block1;
            }
            if (!(event2 instanceof SuiteAborted)) break block1;
            SuiteAborted e = (SuiteAborted)event2;
            this.writeSuiteFile(e, e.suiteId());
        }
    }

    private void writeSuiteFile(Event endEvent, String suiteId) {
        Predef$.MODULE$.require(endEvent instanceof SuiteCompleted || endEvent instanceof SuiteAborted);
        Testsuite testsuite = this.getTestsuite(endEvent, suiteId);
        String xmlStr = this.xmlify(testsuite);
        String filespec = new StringBuilder(10).append(this.directory).append("/TEST-").append(suiteId).append(".xml").toString();
        PrintWriter out = new PrintWriter(filespec, "UTF-8");
        out.print(xmlStr);
        out.close();
    }

    private Testsuite getTestsuite(Event endEvent, String suiteId) {
        String string;
        Predef$.MODULE$.require(endEvent instanceof SuiteCompleted || endEvent instanceof SuiteAborted);
        Event[] orderedEvents = (Event[])((IterableOnceOps)this.events.toList().filter((Function1 & Serializable)e -> {
            Event event = e;
            if (event instanceof TestStarting) {
                TestStarting e2 = (TestStarting)event;
                String string = e2.suiteId();
                String string2 = suiteId;
                if (string != null) {
                    if (!string.equals(string2)) return false;
                    return true;
                }
                if (string2 == null) return true;
                return false;
            }
            if (event instanceof TestSucceeded) {
                TestSucceeded e3 = (TestSucceeded)event;
                String string = e3.suiteId();
                String string3 = suiteId;
                if (string != null) {
                    if (!string.equals(string3)) return false;
                    return true;
                }
                if (string3 == null) return true;
                return false;
            }
            if (event instanceof TestIgnored) {
                TestIgnored e4 = (TestIgnored)event;
                String string = e4.suiteId();
                String string4 = suiteId;
                if (string != null) {
                    if (!string.equals(string4)) return false;
                    return true;
                }
                if (string4 == null) return true;
                return false;
            }
            if (event instanceof TestFailed) {
                TestFailed e5 = (TestFailed)event;
                String string = e5.suiteId();
                String string5 = suiteId;
                if (string != null) {
                    if (!string.equals(string5)) return false;
                    return true;
                }
                if (string5 == null) return true;
                return false;
            }
            if (event instanceof TestPending) {
                TestPending e6 = (TestPending)event;
                String string = e6.suiteId();
                String string6 = suiteId;
                if (string != null) {
                    if (!string.equals(string6)) return false;
                    return true;
                }
                if (string6 == null) return true;
                return false;
            }
            if (event instanceof TestCanceled) {
                TestCanceled e7 = (TestCanceled)event;
                String string = e7.suiteId();
                String string7 = suiteId;
                if (string != null) {
                    if (!string.equals(string7)) return false;
                    return true;
                }
                if (string7 == null) return true;
                return false;
            }
            if (event instanceof InfoProvided) {
                InfoProvided e8 = (InfoProvided)event;
                Option<NameInfo> option = e8.nameInfo();
                if (option instanceof Some) {
                    NameInfo nameInfo = (NameInfo)((Some)option).value();
                    String string = nameInfo.suiteId();
                    String string8 = suiteId;
                    if (string != null) {
                        if (!string.equals(string8)) return false;
                        return true;
                    }
                    if (string8 == null) return true;
                    return false;
                }
                if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                return false;
            }
            if (event instanceof AlertProvided) {
                AlertProvided e9 = (AlertProvided)event;
                Option<NameInfo> option = e9.nameInfo();
                if (option instanceof Some) {
                    NameInfo nameInfo = (NameInfo)((Some)option).value();
                    String string = nameInfo.suiteId();
                    String string9 = suiteId;
                    if (string != null) {
                        if (!string.equals(string9)) return false;
                        return true;
                    }
                    if (string9 == null) return true;
                    return false;
                }
                if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                return false;
            }
            if (event instanceof NoteProvided) {
                NoteProvided e10 = (NoteProvided)event;
                Option<NameInfo> option = e10.nameInfo();
                if (option instanceof Some) {
                    NameInfo nameInfo = (NameInfo)((Some)option).value();
                    String string = nameInfo.suiteId();
                    String string10 = suiteId;
                    if (string != null) {
                        if (!string.equals(string10)) return false;
                        return true;
                    }
                    if (string10 == null) return true;
                    return false;
                }
                if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                return false;
            }
            if (event instanceof MarkupProvided) {
                MarkupProvided e11 = (MarkupProvided)event;
                Option<NameInfo> option = e11.nameInfo();
                if (option instanceof Some) {
                    NameInfo nameInfo = (NameInfo)((Some)option).value();
                    String string = nameInfo.suiteId();
                    String string11 = suiteId;
                    if (string != null) {
                        if (!string.equals(string11)) return false;
                        return true;
                    }
                    if (string11 == null) return true;
                    return false;
                }
                if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                return false;
            }
            if (event instanceof ScopeOpened) {
                ScopeOpened e12 = (ScopeOpened)event;
                String string = e12.nameInfo().suiteId();
                String string12 = suiteId;
                if (string != null) {
                    if (!string.equals(string12)) return false;
                    return true;
                }
                if (string12 == null) return true;
                return false;
            }
            if (event instanceof ScopeClosed) {
                ScopeClosed e13 = (ScopeClosed)event;
                String string = e13.nameInfo().suiteId();
                String string13 = suiteId;
                if (string != null) {
                    if (!string.equals(string13)) return false;
                    return true;
                }
                if (string13 == null) return true;
                return false;
            }
            if (event instanceof SuiteStarting) {
                SuiteStarting e14 = (SuiteStarting)event;
                String string = e14.suiteId();
                String string14 = suiteId;
                if (string != null) {
                    if (!string.equals(string14)) return false;
                    return true;
                }
                if (string14 == null) return true;
                return false;
            }
            if (event instanceof SuiteAborted) {
                SuiteAborted e15 = (SuiteAborted)event;
                String string = e15.suiteId();
                String string15 = suiteId;
                if (string != null) {
                    if (!string.equals(string15)) return false;
                    return true;
                }
                if (string15 == null) return true;
                return false;
            }
            if (!(event instanceof SuiteCompleted)) return false;
            SuiteCompleted e16 = (SuiteCompleted)event;
            String string = e16.suiteId();
            String string16 = suiteId;
            if (string != null) {
                if (!string.equals(string16)) return false;
                return true;
            }
            if (string16 == null) return true;
            return false;
        }).sortWith((Function2 & Serializable)(a, b) -> a.$less(b))).toArray(ClassTag$.MODULE$.apply(Event.class));
        Tuple2<Object, Object> tuple2 = this.locateSuite(orderedEvents, endEvent);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int startIndex = BoxesRunTime.unboxToInt((Object)tuple2._1());
        int endIndex = BoxesRunTime.unboxToInt((Object)tuple2._2());
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)startIndex), (Object)BoxesRunTime.boxToInteger((int)endIndex));
        int startIndex2 = BoxesRunTime.unboxToInt((Object)tuple22._1());
        int endIndex2 = BoxesRunTime.unboxToInt((Object)tuple22._2());
        SuiteStarting startEvent = (SuiteStarting)orderedEvents[startIndex2];
        this.events.$minus$eq((Object)startEvent);
        Option<String> option = startEvent.suiteClassName();
        if (option instanceof Some) {
            String className;
            string = className = (String)((Some)option).value();
        } else if (None$.MODULE$.equals(option)) {
            string = startEvent.suiteName();
        } else {
            throw new MatchError(option);
        }
        String name = string;
        Testsuite testsuite = this.Testsuite().apply(name, startEvent.timeStamp());
        int idx = startIndex2 + 1;
        while (idx <= endIndex2) {
            Event event = orderedEvents[idx];
            this.events.$minus$eq((Object)event);
            Event event2 = event;
            if (event2 instanceof TestStarting) {
                TestStarting e2 = (TestStarting)event2;
                Tuple2<Object, Testcase> tuple23 = this.processTest(orderedEvents, e2, idx);
                if (tuple23 == null) {
                    throw new MatchError(tuple23);
                }
                int testEndIndex = BoxesRunTime.unboxToInt((Object)tuple23._1());
                Testcase testcase = (Testcase)tuple23._2();
                Tuple2 tuple24 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)testEndIndex), (Object)testcase);
                int testEndIndex2 = BoxesRunTime.unboxToInt((Object)tuple24._1());
                Testcase testcase2 = (Testcase)tuple24._2();
                testsuite.testcases().$plus$eq((Object)testcase2);
                Option<Throwable> option2 = testcase2.failure();
                None$ none$ = None$.MODULE$;
                if (option2 == null ? none$ != null : !option2.equals((Object)none$)) {
                    testsuite.failures_$eq(testsuite.failures() + 1);
                }
                idx = testEndIndex2 + 1;
                continue;
            }
            if (event2 instanceof SuiteAborted) {
                SuiteAborted e3 = (SuiteAborted)event2;
                if (endIndex2 != idx) {
                    throw Scala3RunTime$.MODULE$.assertFailed();
                }
                testsuite.errors_$eq(testsuite.errors() + 1);
                testsuite.abortedError_$eq(e3.throwable());
                testsuite.time_$eq(e3.timeStamp() - testsuite.timeStamp());
                ++idx;
                continue;
            }
            if (event2 instanceof SuiteCompleted) {
                SuiteCompleted e4 = (SuiteCompleted)event2;
                if (endIndex2 != idx) {
                    throw Scala3RunTime$.MODULE$.assertFailed();
                }
                testsuite.time_$eq(e4.timeStamp() - testsuite.timeStamp());
                ++idx;
                continue;
            }
            if (event2 instanceof TestIgnored) {
                TestIgnored e5 = (TestIgnored)event2;
                Testcase testcase = this.Testcase().apply(e5.testName(), e5.suiteClassName(), e5.timeStamp());
                testcase.ignored_$eq(true);
                testsuite.testcases().$plus$eq((Object)testcase);
                ++idx;
                continue;
            }
            if (event2 instanceof InfoProvided) {
                InfoProvided e6 = (InfoProvided)event2;
                ++idx;
                continue;
            }
            if (event2 instanceof AlertProvided) {
                AlertProvided e7 = (AlertProvided)event2;
                ++idx;
                continue;
            }
            if (event2 instanceof NoteProvided) {
                NoteProvided e8 = (NoteProvided)event2;
                ++idx;
                continue;
            }
            if (event2 instanceof MarkupProvided) {
                MarkupProvided e9 = (MarkupProvided)event2;
                ++idx;
                continue;
            }
            if (event2 instanceof ScopeOpened) {
                ScopeOpened e10 = (ScopeOpened)event2;
                ++idx;
                continue;
            }
            if (event2 instanceof ScopeClosed) {
                ScopeClosed e11 = (ScopeClosed)event2;
                ++idx;
                continue;
            }
            if (event2 instanceof ScopePending) {
                ScopePending e12 = (ScopePending)event2;
                ++idx;
                continue;
            }
            if (event2 instanceof TestPending) {
                TestPending e13 = (TestPending)event2;
                this.unexpected(e13);
                continue;
            }
            if (event2 instanceof TestCanceled) {
                TestCanceled e14 = (TestCanceled)event2;
                this.unexpected(e14);
                continue;
            }
            if (event2 instanceof RunStarting) {
                RunStarting e15 = (RunStarting)event2;
                this.unexpected(e15);
                continue;
            }
            if (event2 instanceof RunCompleted) {
                RunCompleted e16 = (RunCompleted)event2;
                this.unexpected(e16);
                continue;
            }
            if (event2 instanceof RunStopped) {
                RunStopped e17 = (RunStopped)event2;
                this.unexpected(e17);
                continue;
            }
            if (event2 instanceof RunAborted) {
                RunAborted e18 = (RunAborted)event2;
                this.unexpected(e18);
                continue;
            }
            if (event2 instanceof TestSucceeded) {
                TestSucceeded e19 = (TestSucceeded)event2;
                this.unexpected(e19);
                continue;
            }
            if (event2 instanceof TestFailed) {
                TestFailed e20 = (TestFailed)event2;
                this.unexpected(e20);
                continue;
            }
            if (event2 instanceof SuiteStarting) {
                SuiteStarting e21 = (SuiteStarting)event2;
                this.unexpected(e21);
                continue;
            }
            if (event2 instanceof DiscoveryStarting) {
                DiscoveryStarting e22 = (DiscoveryStarting)event2;
                this.unexpected(e22);
                continue;
            }
            if (event2 instanceof DiscoveryCompleted) {
                DiscoveryCompleted e23 = (DiscoveryCompleted)event2;
                this.unexpected(e23);
                continue;
            }
            throw new MatchError((Object)event2);
        }
        return testsuite;
    }

    private Tuple2<Object, Object> locateSuite(Event[] orderedEvents, Event endEvent) {
        Object object;
        Object object2 = Predef$.MODULE$.refArrayOps((Object[])orderedEvents);
        Predef$.MODULE$.require(ArrayOps$.MODULE$.size$extension(object2) > 0);
        Predef$.MODULE$.require(endEvent instanceof SuiteCompleted || endEvent instanceof SuiteAborted);
        int startIndex = 0;
        int endIndex = 0;
        for (int idx = 0; idx < ArrayOps$.MODULE$.size$extension(object = Predef$.MODULE$.refArrayOps((Object[])orderedEvents)) && endIndex == 0; ++idx) {
            Event event = orderedEvents[idx];
            Event event2 = event;
            if (event2 instanceof SuiteStarting) {
                SuiteStarting e = (SuiteStarting)event2;
                startIndex = idx;
                continue;
            }
            if (event2 instanceof SuiteCompleted) {
                SuiteCompleted e = (SuiteCompleted)event2;
                Event event3 = event;
                Event event4 = endEvent;
                if (event3 != null ? !event3.equals(event4) : event4 != null) continue;
                endIndex = idx;
                String string = e.suiteName();
                String string2 = ((SuiteStarting)orderedEvents[startIndex]).suiteName();
                if (!(string == null ? string2 != null : !string.equals(string2))) continue;
                throw Scala3RunTime$.MODULE$.assertFailed();
            }
            if (!(event2 instanceof SuiteAborted)) continue;
            SuiteAborted e = (SuiteAborted)event2;
            Event event5 = event;
            Event event6 = endEvent;
            if (event5 != null ? !event5.equals(event6) : event6 != null) continue;
            endIndex = idx;
            String string = e.suiteName();
            String string3 = ((SuiteStarting)orderedEvents[startIndex]).suiteName();
            if (!(string == null ? string3 != null : !string.equals(string3))) continue;
            throw Scala3RunTime$.MODULE$.assertFailed();
        }
        if (endIndex <= 0) {
            throw Scala3RunTime$.MODULE$.assertFailed();
        }
        if (!(orderedEvents[startIndex] instanceof SuiteStarting)) {
            throw Scala3RunTime$.MODULE$.assertFailed();
        }
        return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)startIndex), (Object)BoxesRunTime.boxToInteger((int)endIndex));
    }

    private int idxAdjustmentForRecordedEvents(IndexedSeq<RecordableEvent> recordedEvents) {
        return ((SeqOps)recordedEvents.filter((Function1 & Serializable)e -> e instanceof InfoProvided || e instanceof MarkupProvided)).size();
    }

    private Tuple2<Object, Testcase> processTest(Event[] orderedEvents, TestStarting startEvent, int startIndex) {
        Object object;
        Testcase testcase = this.Testcase().apply(startEvent.testName(), startEvent.suiteClassName(), startEvent.timeStamp());
        int endIndex = 0;
        int idx = startIndex + 1;
        while (idx < ArrayOps$.MODULE$.size$extension(object = Predef$.MODULE$.refArrayOps((Object[])orderedEvents)) && endIndex == 0) {
            Event event = orderedEvents[idx];
            this.events.$minus$eq((Object)event);
            Event event2 = event;
            if (event2 instanceof TestSucceeded) {
                TestSucceeded e = (TestSucceeded)event2;
                endIndex = idx;
                testcase.time_$eq(e.timeStamp() - testcase.timeStamp());
                idx += this.idxAdjustmentForRecordedEvents(e.recordedEvents());
                continue;
            }
            if (event2 instanceof TestFailed) {
                TestFailed e = (TestFailed)event2;
                endIndex = idx;
                testcase.failed_$eq(true);
                testcase.failure_$eq(e.throwable());
                testcase.time_$eq(e.timeStamp() - testcase.timeStamp());
                idx += this.idxAdjustmentForRecordedEvents(e.recordedEvents());
                continue;
            }
            if (event2 instanceof TestPending) {
                TestPending e = (TestPending)event2;
                endIndex = idx;
                testcase.pending_$eq(true);
                idx += this.idxAdjustmentForRecordedEvents(e.recordedEvents());
                continue;
            }
            if (event2 instanceof TestCanceled) {
                TestCanceled e = (TestCanceled)event2;
                endIndex = idx;
                testcase.canceled_$eq(true);
                idx += this.idxAdjustmentForRecordedEvents(e.recordedEvents());
                continue;
            }
            if (event2 instanceof ScopeOpened) {
                ScopeOpened e = (ScopeOpened)event2;
                ++idx;
                continue;
            }
            if (event2 instanceof ScopeClosed) {
                ScopeClosed e = (ScopeClosed)event2;
                ++idx;
                continue;
            }
            if (event2 instanceof ScopePending) {
                ScopePending e = (ScopePending)event2;
                ++idx;
                continue;
            }
            if (event2 instanceof InfoProvided) {
                InfoProvided e = (InfoProvided)event2;
                ++idx;
                continue;
            }
            if (event2 instanceof MarkupProvided) {
                MarkupProvided e = (MarkupProvided)event2;
                ++idx;
                continue;
            }
            if (event2 instanceof AlertProvided) {
                AlertProvided e = (AlertProvided)event2;
                ++idx;
                continue;
            }
            if (event2 instanceof NoteProvided) {
                NoteProvided e = (NoteProvided)event2;
                ++idx;
                continue;
            }
            if (event2 instanceof SuiteCompleted) {
                SuiteCompleted e = (SuiteCompleted)event2;
                this.unexpected(e);
                continue;
            }
            if (event2 instanceof TestStarting) {
                TestStarting e = (TestStarting)event2;
                this.unexpected(e);
                continue;
            }
            if (event2 instanceof TestIgnored) {
                TestIgnored e = (TestIgnored)event2;
                this.unexpected(e);
                continue;
            }
            if (event2 instanceof SuiteStarting) {
                SuiteStarting e = (SuiteStarting)event2;
                this.unexpected(e);
                continue;
            }
            if (event2 instanceof RunStarting) {
                RunStarting e = (RunStarting)event2;
                this.unexpected(e);
                continue;
            }
            if (event2 instanceof RunCompleted) {
                RunCompleted e = (RunCompleted)event2;
                this.unexpected(e);
                continue;
            }
            if (event2 instanceof RunStopped) {
                RunStopped e = (RunStopped)event2;
                this.unexpected(e);
                continue;
            }
            if (event2 instanceof RunAborted) {
                RunAborted e = (RunAborted)event2;
                this.unexpected(e);
                continue;
            }
            if (event2 instanceof SuiteAborted) {
                SuiteAborted e = (SuiteAborted)event2;
                endIndex = idx;
                testcase.failed_$eq(true);
                testcase.failure_$eq(e.throwable());
                testcase.time_$eq(e.timeStamp() - testcase.timeStamp());
                idx += this.idxAdjustmentForRecordedEvents((IndexedSeq<RecordableEvent>)((IndexedSeq)IndexedSeq$.MODULE$.empty()));
                continue;
            }
            if (event2 instanceof DiscoveryStarting) {
                DiscoveryStarting e = (DiscoveryStarting)event2;
                this.unexpected(e);
                continue;
            }
            if (event2 instanceof DiscoveryCompleted) {
                DiscoveryCompleted e = (DiscoveryCompleted)event2;
                this.unexpected(e);
                continue;
            }
            throw new MatchError((Object)event2);
        }
        return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)endIndex), (Object)testcase);
    }

    public String xmlify(Testsuite testsuite) {
        String errMsg = (String)testsuite.abortedError().map((Function1 & Serializable)_$1 -> this.getStackTrace((Throwable)_$1)).getOrElse(JUnitXmlReporter::$anonfun$4);
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("timestamp", String.valueOf(this.formatTimeStamp(testsuite.timeStamp())), (MetaData)$md);
        $md = new UnprefixedAttribute("time", String.valueOf(BoxesRunTime.boxToDouble((double)((double)testsuite.time() / 1000.0))), (MetaData)$md);
        $md = new UnprefixedAttribute("tests", String.valueOf(BoxesRunTime.boxToInteger((int)testsuite.testcases().size())), (MetaData)$md);
        $md = new UnprefixedAttribute("name", String.valueOf(testsuite.name()), (MetaData)$md);
        $md = new UnprefixedAttribute("hostname", String.valueOf(this.hostname()), (MetaData)$md);
        $md = new UnprefixedAttribute("failures", String.valueOf(BoxesRunTime.boxToInteger((int)testsuite.failures())), (MetaData)$md);
        $md = new UnprefixedAttribute("errors", String.valueOf(BoxesRunTime.boxToInteger((int)testsuite.errors())), (MetaData)$md);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)this.propertiesXml);
        $buf.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus(testsuite.testcases().map((Function1 & Serializable)testcase -> {
            Null$ $md = Null$.MODULE$;
            $md = new UnprefixedAttribute("time", String.valueOf(BoxesRunTime.boxToDouble((double)((double)testcase.time() / 1000.0))), (MetaData)$md);
            $md = new UnprefixedAttribute("classname", String.valueOf(this.strVal(testcase.className())), (MetaData)$md);
            $md = new UnprefixedAttribute("name", String.valueOf(testcase.name()), (MetaData)$md);
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)new Text("\n          "));
            $buf.$amp$plus(testcase.ignored() || testcase.pending() || testcase.canceled() ? new Elem(null, "skipped", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, true, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Node[0])) : this.failureXml(testcase.failed(), testcase.failure()));
            $buf.$amp$plus((Object)new Text("\n          "));
            return new Elem(null, "testcase", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf));
        }));
        $buf.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text(""));
        $buf.$amp$plus((Object)new Elem(null, "system-out", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf2)));
        $buf.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)Unparsed$.MODULE$.apply(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("<![CDATA[%s]]>"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{errMsg}))));
        $buf.$amp$plus((Object)new Elem(null, "system-err", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf3)));
        $buf.$amp$plus((Object)new Text("\n      "));
        Elem xmlVal = new Elem(null, "testsuite", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf));
        PrettyPrinter prettyPrinter = new PrettyPrinter(76, 2, true);
        String prettified = prettyPrinter.format((Node)xmlVal, prettyPrinter.format$default$2());
        return new StringBuilder(40).append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n").append(prettified).toString();
    }

    public String getStackTrace(Throwable throwable) {
        return new StringBuilder(0).append(throwable).append(Predef$.MODULE$.wrapRefArray((Object[])Array$.MODULE$.concat((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StackTraceElement[][]{throwable.getStackTrace()}), ClassTag$.MODULE$.apply(StackTraceElement.class))).mkString("\n      at ", "\n      at ", "\n")).append(throwable.getCause() != null ? new StringBuilder(13).append("      Cause: ").append(this.getStackTrace(throwable.getCause())).toString() : "").toString();
    }

    private NodeSeq failureXml(boolean failed, Option<Throwable> failureOption) {
        NodeSeq nodeSeq;
        if (failed) {
            Tuple3 tuple3;
            Option<Throwable> option = failureOption;
            if (None$.MODULE$.equals(option)) {
                tuple3 = Tuple3$.MODULE$.apply((Object)"", (Object)"", (Object)"");
            } else if (option instanceof Some) {
                Throwable failure = (Throwable)((Some)option).value();
                String throwableType = String.valueOf(failure.getClass());
                String throwableMessage = failure.getMessage();
                String throwableText = this.getStackTrace(failure);
                tuple3 = Tuple3$.MODULE$.apply((Object)throwableType, (Object)throwableMessage, (Object)throwableText);
            } else {
                throw new MatchError(option);
            }
            Tuple3 tuple32 = tuple3;
            String throwableType = (String)tuple32._1();
            String throwableMessage = (String)tuple32._2();
            String throwableText = (String)tuple32._3();
            Null$ $md = Null$.MODULE$;
            $md = new UnprefixedAttribute("type", throwableType, (MetaData)$md);
            $md = new UnprefixedAttribute("message", throwableMessage, (MetaData)$md);
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)new Text("\n        "));
            $buf.$amp$plus((Object)throwableText);
            $buf.$amp$plus((Object)new Text("\n      "));
            Elem elem = new Elem(null, "failure", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf));
            nodeSeq = elem;
        } else {
            nodeSeq = NodeSeq$.MODULE$.Empty();
        }
        return nodeSeq;
    }

    private String strVal(Option<Object> option) {
        String string;
        Option<Object> option2 = option;
        if (option2 instanceof Some) {
            Object x = ((Some)option2).value();
            string = String.valueOf(x);
        } else if (None$.MODULE$.equals(option2)) {
            string = "";
        } else {
            throw new MatchError(option2);
        }
        return string;
    }

    public String hostname() {
        long l;
        long l2;
        while ((l2 = LazyVals$.MODULE$.STATE(l = LazyVals$.MODULE$.get((Object)this, OFFSET$0), 0)) != 3L) {
            if (l2 == 0L) {
                if (!LazyVals$.MODULE$.CAS((Object)this, OFFSET$0, l, 1, 0)) continue;
                try {
                    String string;
                    this.hostname$lzy1 = string = JUnitXmlReporter.liftedTree1$1();
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 3, 0);
                    return string;
                }
                catch (Throwable throwable) {
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 0, 0);
                    throw throwable;
                }
            }
            LazyVals$.MODULE$.wait4Notification((Object)this, OFFSET$0, l, 0);
        }
        return this.hostname$lzy1;
    }

    private Elem genPropertiesXml() {
        Properties sysprops = System.getProperties();
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text(" "));
        $buf.$amp$plus((Object)this.propertyNames(sysprops).map((Function1 & Serializable)name -> {
            Null$ $md = Null$.MODULE$;
            $md = new UnprefixedAttribute("value", sysprops.getProperty((String)name), (MetaData)$md);
            $md = new UnprefixedAttribute("name", name, (MetaData)$md);
            return new Elem(null, "property", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, true, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Node[0]));
        }));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "properties", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf));
    }

    private List<String> propertyNames(Properties props) {
        ListBuffer listBuf = new ListBuffer();
        Enumeration<?> enumeration = props.propertyNames();
        while (enumeration.hasMoreElements()) {
            listBuf.$plus$eq((Object)String.valueOf(enumeration.nextElement()));
        }
        return listBuf.toList();
    }

    private String formatTimeStamp(long timeStamp) {
        SimpleDateFormat dateFmt = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat timeFmt = new SimpleDateFormat("HH:mm:ss");
        return new StringBuilder(1).append(dateFmt.format(BoxesRunTime.boxToLong((long)timeStamp))).append("T").append(timeFmt.format(BoxesRunTime.boxToLong((long)timeStamp))).toString();
    }

    public void unexpected(Event event) {
        throw new RuntimeException(new StringBuilder(19).append("unexpected event [").append(event).append("]").toString());
    }

    public final JUnitXmlReporter$Testsuite$ Testsuite() {
        return this.Testsuite$lzy1;
    }

    public final JUnitXmlReporter$Testcase$ Testcase() {
        return this.Testcase$lzy1;
    }

    private static final String $anonfun$4() {
        return "";
    }

    private static final String liftedTree1$1() {
        String string;
        try {
            InetAddress localMachine = InetAddress.getLocalHost();
            string = localMachine.getHostName();
        }
        catch (UnknownHostException e) {
            string = "unknown";
        }
        return string;
    }

    public class Testcase
    implements Product,
    Serializable {
        private final String name;
        private final Option className;
        private final long timeStamp;
        private long time;
        private boolean pending;
        private boolean canceled;
        private boolean ignored;
        private boolean failed;
        private Option failure;
        private final /* synthetic */ JUnitXmlReporter $outer;

        public Testcase(JUnitXmlReporter $outer, String name, Option<String> className, long timeStamp) {
            this.name = name;
            this.className = className;
            this.timeStamp = timeStamp;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            this.time = 0L;
            this.pending = false;
            this.canceled = false;
            this.ignored = false;
            this.failed = false;
            this.failure = None$.MODULE$;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.name()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.className()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.timeStamp()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Testcase)) return false;
            if (((Testcase)object).org$scalatest$tools$JUnitXmlReporter$Testcase$$$outer() != this.$outer) return false;
            Testcase testcase = (Testcase)object;
            if (this.timeStamp() != testcase.timeStamp()) return false;
            String string = this.name();
            String string2 = testcase.name();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            Option<String> option = this.className();
            Option<String> option2 = testcase.className();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            if (!testcase.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Testcase;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "Testcase";
        }

        public Object productElement(int n) {
            Object object;
            int n2 = n;
            switch (n2) {
                case 0: {
                    object = this._1();
                    break;
                }
                case 1: {
                    object = this._2();
                    break;
                }
                case 2: {
                    object = BoxesRunTime.boxToLong((long)this._3());
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return object;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            switch (n2) {
                case 0: {
                    string = "name";
                    break;
                }
                case 1: {
                    string = "className";
                    break;
                }
                case 2: {
                    string = "timeStamp";
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return string;
        }

        public String name() {
            return this.name;
        }

        public Option<String> className() {
            return this.className;
        }

        public long timeStamp() {
            return this.timeStamp;
        }

        public long time() {
            return this.time;
        }

        public void time_$eq(long x$1) {
            this.time = x$1;
        }

        public boolean pending() {
            return this.pending;
        }

        public void pending_$eq(boolean x$1) {
            this.pending = x$1;
        }

        public boolean canceled() {
            return this.canceled;
        }

        public void canceled_$eq(boolean x$1) {
            this.canceled = x$1;
        }

        public boolean ignored() {
            return this.ignored;
        }

        public void ignored_$eq(boolean x$1) {
            this.ignored = x$1;
        }

        public boolean failed() {
            return this.failed;
        }

        public void failed_$eq(boolean x$1) {
            this.failed = x$1;
        }

        public Option<Throwable> failure() {
            return this.failure;
        }

        public void failure_$eq(Option<Throwable> x$1) {
            this.failure = x$1;
        }

        public Testcase copy(String name, Option<String> className, long timeStamp) {
            return new Testcase(this.$outer, name, className, timeStamp);
        }

        public String copy$default$1() {
            return this.name();
        }

        public Option<String> copy$default$2() {
            return this.className();
        }

        public long copy$default$3() {
            return this.timeStamp();
        }

        public String _1() {
            return this.name();
        }

        public Option<String> _2() {
            return this.className();
        }

        public long _3() {
            return this.timeStamp();
        }

        public final /* synthetic */ JUnitXmlReporter org$scalatest$tools$JUnitXmlReporter$Testcase$$$outer() {
            return this.$outer;
        }
    }

    public class Testsuite
    implements Product,
    Serializable {
        private final String name;
        private final long timeStamp;
        private int errors;
        private int failures;
        private long time;
        private Option abortedError;
        private final ListBuffer testcases;
        private final /* synthetic */ JUnitXmlReporter $outer;

        public Testsuite(JUnitXmlReporter $outer, String name, long timeStamp) {
            this.name = name;
            this.timeStamp = timeStamp;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            this.errors = 0;
            this.failures = 0;
            this.time = 0L;
            this.abortedError = None$.MODULE$;
            this.testcases = new ListBuffer();
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.name()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.timeStamp()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Testsuite)) return false;
            if (((Testsuite)object).org$scalatest$tools$JUnitXmlReporter$Testsuite$$$outer() != this.$outer) return false;
            Testsuite testsuite = (Testsuite)object;
            if (this.timeStamp() != testsuite.timeStamp()) return false;
            String string = this.name();
            String string2 = testsuite.name();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!testsuite.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Testsuite;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Testsuite";
        }

        public Object productElement(int n) {
            Object object;
            int n2 = n;
            if (0 == n2) {
                object = this._1();
            } else if (1 == n2) {
                object = BoxesRunTime.boxToLong((long)this._2());
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return object;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            if (0 == n2) {
                string = "name";
            } else if (1 == n2) {
                string = "timeStamp";
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return string;
        }

        public String name() {
            return this.name;
        }

        public long timeStamp() {
            return this.timeStamp;
        }

        public int errors() {
            return this.errors;
        }

        public void errors_$eq(int x$1) {
            this.errors = x$1;
        }

        public int failures() {
            return this.failures;
        }

        public void failures_$eq(int x$1) {
            this.failures = x$1;
        }

        public long time() {
            return this.time;
        }

        public void time_$eq(long x$1) {
            this.time = x$1;
        }

        public Option<Throwable> abortedError() {
            return this.abortedError;
        }

        public void abortedError_$eq(Option<Throwable> x$1) {
            this.abortedError = x$1;
        }

        public ListBuffer<Testcase> testcases() {
            return this.testcases;
        }

        public Testsuite copy(String name, long timeStamp) {
            return new Testsuite(this.$outer, name, timeStamp);
        }

        public String copy$default$1() {
            return this.name();
        }

        public long copy$default$2() {
            return this.timeStamp();
        }

        public String _1() {
            return this.name();
        }

        public long _2() {
            return this.timeStamp();
        }

        public final /* synthetic */ JUnitXmlReporter org$scalatest$tools$JUnitXmlReporter$Testsuite$$$outer() {
            return this.$outer;
        }
    }
}

