/*
 * Decompiled with CFR 0.152.
 */
package org.scalatest.tools;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.BevelBorder;
import org.scalatest.Resources$;
import org.scalatest.tools.ColorBar;

public class ProgressBarPanel
extends JPanel {
    private final ColorBar progressBar = new ColorBar();
    private final JPanel discoPanel = new JPanel();
    private final JLabel discoJLabel = new JLabel();

    public ProgressBarPanel() {
        URL discoImageURL = this.getClass().getClassLoader().getResource("images/inProgress.gif");
        this.setLayout(new BorderLayout());
        this.setBorder(new BevelBorder(1));
        this.add((Component)this.progressBar, "Center");
        this.discoJLabel.setIcon(new ImageIcon(discoImageURL));
        this.discoPanel.add(this.discoJLabel);
        this.setPreferredSize(new Dimension((int)this.getPreferredSize().getWidth(), (int)this.discoPanel.getPreferredSize().getHeight() + 4));
    }

    public void discoveryStarting() {
        this.remove(this.progressBar);
        this.add((Component)this.discoPanel, "West");
        this.discoJLabel.setText("");
        this.discoJLabel.setText(Resources$.MODULE$.doingDiscovery());
    }

    private void showProgressBar() {
        this.remove(this.discoPanel);
        this.add((Component)this.progressBar, "Center");
    }

    public void runAborted() {
        this.showProgressBar();
        this.progressBar.setRed();
    }

    public void discoveryCompleted() {
        this.showProgressBar();
    }

    public void runStarting(int testCount) {
        this.progressBar.setMax(testCount);
        this.progressBar.setValue(0);
        this.progressBar.setGreen();
    }

    public void setTestsRun(int testsCompletedCount) {
        this.progressBar.setValue(testsCompletedCount);
    }

    public void suiteAborted() {
        this.progressBar.setRed();
    }

    public void testFailed(int testsCompletedCount) {
        this.progressBar.setRed();
        this.setTestsRun(testsCompletedCount);
    }

    public void reset() {
        this.showProgressBar();
        this.progressBar.setGray();
    }
}

