/*
 * Decompiled with CFR 0.152.
 */
package org.scalatest.tools;

import java.io.Serializable;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.Path;
import org.scalatest.tools.JvmArg;
import org.scalatest.tools.NameValuePair;
import org.scalatest.tools.PackageElement;
import org.scalatest.tools.ReporterElement;
import org.scalatest.tools.Runner$;
import org.scalatest.tools.RunpathUrl;
import org.scalatest.tools.StyleElement;
import org.scalatest.tools.SuiteElement;
import org.scalatest.tools.TestElement;
import org.scalatest.tools.TestsfileElement;
import org.scalatest.tools.TextElement;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.List;
import scala.collection.mutable.ListBuffer;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.function.JProcedure1;

public class ScalaTestAntTask
extends Task {
    private String includes = "";
    private String excludes = "";
    private String maxMemory = null;
    private String suffixes = null;
    private boolean parallel = false;
    private boolean sortSuites = false;
    private boolean haltonfailure = false;
    private boolean fork = false;
    private double spanScaleFactor = 1.0;
    private int numthreads = 0;
    private final ListBuffer<String> runpath = new ListBuffer();
    private final ListBuffer<String> jvmArgs = new ListBuffer();
    private final ListBuffer<SuiteElement> suites = new ListBuffer();
    private final ListBuffer<TestElement> tests = new ListBuffer();
    private final ListBuffer<String> membersonlys = new ListBuffer();
    private final ListBuffer<String> wildcards = new ListBuffer();
    private final ListBuffer<String> testNGSuites = new ListBuffer();
    private final ListBuffer<String> chosenStyles = new ListBuffer();
    private final ListBuffer<String> testsfiles = new ListBuffer();
    private final ListBuffer<ReporterElement> reporters = new ListBuffer();
    private final ListBuffer<NameValuePair> properties = new ListBuffer();

    public void execute() {
        boolean success;
        List<String> argsList = this.buildArgsList();
        boolean bl = success = this.fork ? this.javaTaskRunner(argsList) : Runner$.MODULE$.run((String[])argsList.toArray(ClassTag$.MODULE$.apply(String.class)));
        if (!success && this.haltonfailure) {
            throw new BuildException("ScalaTest run failed.");
        }
    }

    public List<String> buildArgsList() {
        ListBuffer args = new ListBuffer();
        this.addSuiteArgs((ListBuffer<String>)args);
        this.addTestArgs((ListBuffer<String>)args);
        this.addReporterArgs((ListBuffer<String>)args);
        this.addPropertyArgs((ListBuffer<String>)args);
        this.addIncludesArgs((ListBuffer<String>)args);
        this.addExcludesArgs((ListBuffer<String>)args);
        this.addRunpathArgs((ListBuffer<String>)args);
        this.addTestNGSuiteArgs((ListBuffer<String>)args);
        this.addParallelArg((ListBuffer<String>)args);
        this.addSuffixesArg((ListBuffer<String>)args);
        this.addTestsfileArgs((ListBuffer<String>)args);
        this.addChosenStyles((ListBuffer<String>)args);
        this.addSpanScaleFactorArg((ListBuffer<String>)args);
        return args.toList();
    }

    private boolean javaTaskRunner(List<String> args) {
        Java java = new Java();
        java.bindToOwner((Task)this);
        java.init();
        java.setFork(true);
        java.setClassname("org.scalatest.tools.Runner");
        AntClassLoader classLoader = (AntClassLoader)this.getClass().getClassLoader();
        java.setClasspath(new Path(this.getProject(), classLoader.getClasspath()));
        if (this.maxMemory != null) {
            java.createJvmarg().setValue(new StringBuilder(4).append("-Xmx").append(this.maxMemory).toString());
        }
        this.jvmArgs.foreach((Function1)(JProcedure1 & Serializable)jvmArg -> java.createJvmarg().setValue(jvmArg));
        args.foreach((Function1)(JProcedure1 & Serializable)arg -> java.createArg().setValue(arg));
        int result = java.executeJava();
        return result == 0;
    }

    private void addRunpathArgs(ListBuffer<String> args) {
        if (this.runpath.size() > 0) {
            args.$plus$eq((Object)"-R");
            args.$plus$eq((Object)this.getSpacedOutPathStr((List<String>)this.runpath.toList()));
        }
    }

    private void addTestNGSuiteArgs(ListBuffer<String> args) {
        if (this.testNGSuites.size() > 0) {
            args.$plus$eq((Object)"-b");
            args.$plus$eq((Object)this.getSpacedOutPathStr((List<String>)this.testNGSuites.toList()));
        }
    }

    private void addChosenStyles(ListBuffer<String> args) {
        this.chosenStyles.foreach((Function1 & Serializable)style -> {
            args.$plus$eq((Object)"-y");
            return (ListBuffer)args.$plus$eq(style);
        });
    }

    private void addParallelArg(ListBuffer<String> args) {
        if (this.parallel) {
            args.$plus$eq((Object)new StringBuilder(0).append(this.sortSuites ? "-PS" : "-P").append(this.numthreads > 0 ? String.valueOf(BoxesRunTime.boxToInteger((int)this.numthreads)) : "").toString());
        }
    }

    private void addSpanScaleFactorArg(ListBuffer<String> args) {
        args.$plus$eq((Object)"-F");
        args.$plus$eq((Object)BoxesRunTime.boxToDouble((double)this.spanScaleFactor).toString());
    }

    private void addSuffixesArg(ListBuffer<String> args) {
        if (this.suffixes != null) {
            args.$plus$eq((Object)"-q");
            args.$plus$eq((Object)this.suffixes);
        }
    }

    private void addTestsfileArgs(ListBuffer<String> args) {
        this.testsfiles.foreach((Function1 & Serializable)testsfile -> {
            args.$plus$eq((Object)"-A");
            return (ListBuffer)args.$plus$eq(testsfile);
        });
    }

    private void addIncludesArgs(ListBuffer<String> args) {
        if (this.includes != null) {
            String string = this.includes.trim();
            String string2 = "";
            if (string == null ? string2 != null : !string.equals(string2)) {
                args.$plus$eq((Object)"-n");
                args.$plus$eq((Object)this.singleSpace(this.includes));
            }
        }
    }

    private void addExcludesArgs(ListBuffer<String> args) {
        if (this.excludes != null) {
            String string = this.excludes.trim();
            String string2 = "";
            if (string == null ? string2 != null : !string.equals(string2)) {
                args.$plus$eq((Object)"-l");
                args.$plus$eq((Object)this.singleSpace(this.excludes));
            }
        }
    }

    private void addPropertyArgs(ListBuffer<String> args) {
        this.properties.foreach((Function1 & Serializable)pair -> (ListBuffer)args.$plus$eq((Object)new StringBuilder(3).append("-D").append(pair.getName()).append("=").append(pair.getValue()).toString()));
    }

    private void addSuiteArgs(ListBuffer<String> args) {
        this.suites.foreach((Function1)(JProcedure1 & Serializable)suite -> {
            if (suite == null) {
                throw new BuildException("missing classname attribute for <suite> element");
            }
            args.$plus$eq((Object)"-s");
            args.$plus$eq((Object)suite.getClassName());
            Object object = Predef$.MODULE$.refArrayOps((Object[])suite.getTestNames());
            ArrayOps$.MODULE$.foreach$extension(object, (Function1 & Serializable)tn -> {
                if (tn == null) {
                    throw new BuildException("missing name attribute for <test> element");
                }
                args.$plus$eq((Object)"-t");
                return (ListBuffer)args.$plus$eq(tn);
            });
            Object object2 = Predef$.MODULE$.refArrayOps((Object[])suite.getNestedSuites());
            ArrayOps$.MODULE$.foreach$extension(object2, (Function1)(JProcedure1 & Serializable)ns -> {
                if (ns.getSuiteId() == null) {
                    throw new BuildException("missing suiteId attribute for <nested> element");
                }
                args.$plus$eq((Object)"-i");
                args.$plus$eq((Object)ns.getSuiteId());
                Object object = Predef$.MODULE$.refArrayOps((Object[])ns.getTestNames());
                ArrayOps$.MODULE$.foreach$extension(object, (Function1 & Serializable)tn -> {
                    if (tn == null) {
                        throw new BuildException("missing name attribute for <test> element");
                    }
                    args.$plus$eq((Object)"-t");
                    return (ListBuffer)args.$plus$eq(tn);
                });
            });
        });
        this.membersonlys.foreach((Function1 & Serializable)packageName -> {
            if (packageName == null) {
                throw new BuildException("missing package attribute for <membersonly> element");
            }
            args.$plus$eq((Object)"-m");
            return (ListBuffer)args.$plus$eq(packageName);
        });
        this.wildcards.foreach((Function1 & Serializable)packageName -> {
            if (packageName == null) {
                throw new BuildException("missing package attribute for <wildcard> element");
            }
            args.$plus$eq((Object)"-w");
            return (ListBuffer)args.$plus$eq(packageName);
        });
    }

    private void addTestArgs(ListBuffer<String> args) {
        this.tests.foreach((Function1 & Serializable)test -> {
            ListBuffer listBuffer;
            if (test.getName() != null) {
                args.$plus$eq((Object)"-t");
                listBuffer = (ListBuffer)args.$plus$eq((Object)test.getName());
            } else if (test.getSubstring() != null) {
                args.$plus$eq((Object)"-z");
                listBuffer = (ListBuffer)args.$plus$eq((Object)test.getSubstring());
            } else {
                throw new BuildException("missing name or substring attribute for <test> element");
            }
            return listBuffer;
        });
    }

    private void addReporterArgs(ListBuffer<String> args) {
        if (this.reporters.size() == 0) {
            args.$plus$eq((Object)"-o");
        }
        this.reporters.foreach((Function1)(JProcedure1 & Serializable)reporter -> {
            String string = reporter.getType();
            switch (string == null ? 0 : string.hashCode()) {
                case -1077756671: {
                    if (!"memory".equals(string)) break;
                    this.addMemoryReporter(args, (ReporterElement)reporter);
                    return;
                }
                case -1047860588: {
                    if (!"dashboard".equals(string)) break;
                    this.addDashboardReporter(args, (ReporterElement)reporter);
                    return;
                }
                case -892406686: {
                    if (!"stderr".equals(string)) break;
                    this.addReporterOption(args, (ReporterElement)reporter, "-e");
                    return;
                }
                case -892396981: {
                    if (!"stdout".equals(string)) break;
                    this.addReporterOption(args, (ReporterElement)reporter, "-o");
                    return;
                }
                case -232199063: {
                    if (!"junitxml".equals(string)) break;
                    this.addJunitXmlReporter(args, (ReporterElement)reporter);
                    return;
                }
                case 118807: {
                    if (!"xml".equals(string)) break;
                    this.addXmlReporter(args, (ReporterElement)reporter);
                    return;
                }
                case 3143036: {
                    if (!"file".equals(string)) break;
                    this.addFileReporter(args, (ReporterElement)reporter);
                    return;
                }
                case 3213227: {
                    if (!"html".equals(string)) break;
                    this.addHtmlReporter(args, (ReporterElement)reporter);
                    return;
                }
                case 249211191: {
                    if (!"reporterclass".equals(string)) break;
                    this.addReporterClass(args, (ReporterElement)reporter);
                    return;
                }
                case 280343272: {
                    if (!"graphic".equals(string)) break;
                    this.addReporterOption(args, (ReporterElement)reporter, "-g");
                    return;
                }
            }
            String t = string;
            throw new BuildException(new StringBuilder(27).append("unexpected reporter type [").append(t).append("]").toString());
        });
    }

    private void addReporterOption(ListBuffer<String> args, ReporterElement reporter, String option) {
        String config = reporter.getConfig();
        if (config == null) {
            args.$plus$eq((Object)option);
        } else {
            args.$plus$eq((Object)new StringBuilder(0).append(option).append(config).toString());
        }
    }

    private void addFileReporter(ListBuffer<String> args, ReporterElement reporter) {
        this.addReporterOption(args, reporter, "-f");
        if (reporter.getFilename() == null) {
            throw new BuildException("reporter type 'file' requires 'filename' attribute");
        }
        args.$plus$eq((Object)reporter.getFilename());
    }

    private void addMemoryReporter(ListBuffer<String> args, ReporterElement reporter) {
        this.addReporterOption(args, reporter, "-M");
        if (reporter.getFilename() == null) {
            throw new BuildException("reporter type 'memory' requires 'filename' attribute");
        }
        args.$plus$eq((Object)reporter.getFilename());
    }

    private void addXmlReporter(ListBuffer<String> args, ReporterElement reporter) {
        this.addReporterOption(args, reporter, "-x");
        if (reporter.getDirectory() == null) {
            throw new BuildException("reporter type 'xml' requires 'directory' attribute");
        }
        args.$plus$eq((Object)reporter.getDirectory());
    }

    private void addJunitXmlReporter(ListBuffer<String> args, ReporterElement reporter) {
        this.addReporterOption(args, reporter, "-u");
        if (reporter.getDirectory() == null) {
            throw new BuildException("reporter type 'junitxml' requires 'directory' attribute");
        }
        args.$plus$eq((Object)reporter.getDirectory());
    }

    private void addDashboardReporter(ListBuffer<String> args, ReporterElement reporter) {
        this.addReporterOption(args, reporter, "-d");
        if (reporter.getDirectory() == null) {
            throw new BuildException("reporter type 'dashboard' requires 'directory' attribute");
        }
        args.$plus$eq((Object)reporter.getDirectory());
        if (reporter.getNumfiles() >= 0) {
            args.$plus$eq((Object)"-a");
            args.$plus$eq((Object)BoxesRunTime.boxToInteger((int)reporter.getNumfiles()).toString());
        }
    }

    private void addHtmlReporter(ListBuffer<String> args, ReporterElement reporter) {
        this.addReporterOption(args, reporter, "-h");
        if (reporter.getDirectory() == null) {
            throw new BuildException("reporter type 'html' requires 'directory' attribute");
        }
        args.$plus$eq((Object)reporter.getDirectory());
        if (reporter.getCss() != null) {
            args.$plus$eq((Object)"-Y");
            args.$plus$eq((Object)reporter.getCss());
        }
    }

    private void addReporterClass(ListBuffer<String> args, ReporterElement reporter) {
        this.addReporterOption(args, reporter, "-C");
        if (reporter.getClassName() == null) {
            throw new BuildException("reporter type 'reporterclass' requires 'classname' attribute");
        }
        args.$plus$eq((Object)reporter.getClassName());
    }

    public void setRunpath(Path runpath) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])runpath.list());
        ArrayOps$.MODULE$.foreach$extension(object, (Function1 & Serializable)element -> (ListBuffer)this.runpath.$plus$eq(element));
    }

    public void setTagsToExclude(String tagsToExclude) {
        this.excludes = new StringBuilder(0).append(this.excludes).append(new StringBuilder(1).append(" ").append(tagsToExclude).toString()).toString();
    }

    public void setTagsToInclude(String tagsToInclude) {
        this.includes = new StringBuilder(0).append(this.includes).append(new StringBuilder(1).append(" ").append(tagsToInclude).toString()).toString();
    }

    public void setHaltonfailure(boolean haltonfailure) {
        this.haltonfailure = haltonfailure;
    }

    public void setFork(boolean fork) {
        this.fork = fork;
    }

    public void setSuffixes(String suffixes) {
        this.suffixes = suffixes;
    }

    public void setTestsfile(String testsfile) {
        this.testsfiles.$plus$eq((Object)testsfile);
    }

    public void setMaxmemory(String max) {
        this.maxMemory = max;
    }

    public void setTestNGSuites(Path testNGSuitePath) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])testNGSuitePath.list());
        ArrayOps$.MODULE$.foreach$extension(object, (Function1 & Serializable)element -> (ListBuffer)this.testNGSuites.$plus$eq(element));
    }

    public void setNumthreads(int numthreads) {
        this.numthreads = numthreads;
    }

    public void setParallel(boolean parallel) {
        this.parallel = parallel;
    }

    public void setSortSuites(boolean sortSuites) {
        this.sortSuites = sortSuites;
    }

    public void setSpanScaleFactor(double spanScaleFactor) {
        this.spanScaleFactor = spanScaleFactor;
    }

    public void addConfiguredRunpath(Path runpath) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])runpath.list());
        ArrayOps$.MODULE$.foreach$extension(object, (Function1 & Serializable)element -> (ListBuffer)this.runpath.$plus$eq(element));
    }

    public void addConfiguredTestNGSuites(Path testNGSuitePath) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])testNGSuitePath.list());
        ArrayOps$.MODULE$.foreach$extension(object, (Function1 & Serializable)element -> (ListBuffer)this.testNGSuites.$plus$eq(element));
    }

    public void addConfiguredRunpathUrl(RunpathUrl runpathurl) {
        this.runpath.$plus$eq((Object)runpathurl.getUrl());
    }

    public void addConfiguredJvmArg(JvmArg arg) {
        this.jvmArgs.$plus$eq((Object)arg.getValue());
    }

    public void addConfiguredConfig(NameValuePair config) {
        this.properties.$plus$eq((Object)config);
    }

    public void setSuite(SuiteElement suite) {
        this.suites.$plus$eq((Object)suite);
    }

    public void setMembersonly(String packageName) {
        this.membersonlys.$plus$eq((Object)packageName);
    }

    public void setWildcard(String packageName) {
        this.wildcards.$plus$eq((Object)packageName);
    }

    public void setStyle(String style) {
        this.chosenStyles.$plus$eq((Object)style);
    }

    public void addConfiguredSuite(SuiteElement suite) {
        this.suites.$plus$eq((Object)suite);
    }

    public void addConfiguredTest(TestElement test) {
        this.tests.$plus$eq((Object)test);
    }

    public void addConfiguredMembersOnly(PackageElement membersonly) {
        this.membersonlys.$plus$eq((Object)membersonly.getPackage());
    }

    public void addConfiguredWildcard(PackageElement wildcard) {
        this.wildcards.$plus$eq((Object)wildcard.getPackage());
    }

    public void addConfiguredReporter(ReporterElement reporter) {
        this.reporters.$plus$eq((Object)reporter);
    }

    public void addConfiguredTagsToInclude(TextElement tagsToInclude) {
        this.includes = new StringBuilder(0).append(this.includes).append(new StringBuilder(1).append(" ").append(tagsToInclude.getText()).toString()).toString();
    }

    public void addConfiguredStyle(StyleElement style) {
        this.chosenStyles.$plus$eq((Object)style.getName());
    }

    public void addConfiguredTestsfile(TestsfileElement testsfile) {
        this.testsfiles.$plus$eq((Object)testsfile.getFilename());
    }

    public void addConfiguredTagsToExclude(TextElement tagsToExclude) {
        this.excludes = new StringBuilder(0).append(this.excludes).append(new StringBuilder(1).append(" ").append(tagsToExclude.getText()).toString()).toString();
    }

    private String getSpacedOutPathStr(List<String> path) {
        return path.map((Function1 & Serializable)_$1 -> _$1.replaceAll(" ", "\\\\ ")).mkString("", " ", "");
    }

    private String singleSpace(String str) {
        return str.trim().replaceAll("\\s+", " ");
    }
}

