/*
 * Decompiled with CFR 0.152.
 */
package org.scalatest.tools;

import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.util.concurrent.atomic.AtomicReference;
import org.scalatest.ResourcefulReporter;
import org.scalatest.Suite$;
import org.scalatest.events.Event;

public class SocketReporter
implements ResourcefulReporter {
    private final String host;
    private final int port;
    private final AtomicReference<Socket> socket;
    private final AtomicReference<ObjectOutputStream> out;

    public SocketReporter(String host, int port) {
        this.host = host;
        this.port = port;
        this.socket = new AtomicReference<Socket>(new Socket(host, port));
        this.out = new AtomicReference<ObjectOutputStream>(new ObjectOutputStream(this.socket.get().getOutputStream()));
    }

    public void refresh() {
        block2: {
            try {
                this.out.get().close();
                this.socket.get().close();
            }
            catch (Throwable throwable) {
                Throwable t;
                Throwable throwable2 = throwable;
                if (throwable2 != null && Suite$.MODULE$.anExceptionThatShouldCauseAnAbort(t = throwable2)) break block2;
                throw throwable;
            }
        }
        this.socket.set(new Socket(this.host, this.port));
        this.out.set(new ObjectOutputStream(this.socket.get().getOutputStream()));
    }

    @Override
    public void apply(Event event) {
        SocketReporter socketReporter = this;
        synchronized (socketReporter) {
            this.liftedTree1$1(event);
        }
    }

    @Override
    public void dispose() {
        this.out.get().flush();
        this.out.get().close();
        this.socket.get().close();
    }

    private final void liftedTree1$1(Event event$1) {
        try {
            this.out.get().writeObject(event$1);
            this.out.get().flush();
        }
        catch (NotSerializableException e) {
            this.refresh();
            this.out.get().writeObject(event$1.ensureSerializable());
        }
        catch (Throwable throwable) {
            Throwable e;
            Throwable throwable2 = throwable;
            if (throwable2 != null && Suite$.MODULE$.anExceptionThatShouldCauseAnAbort(e = throwable2)) {
                this.refresh();
            }
            throw throwable;
        }
    }
}

