/*
 * Decompiled with CFR 0.152.
 */
package org.scalatest.tools;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import org.scalatest.DoNotDiscover;
import org.scalatest.Suite;
import org.scalatest.WrapWith;
import org.scalatest.tools.DiscoverySuite$;
import org.scalatest.tools.NestedSuiteParam;
import org.scalatest.tools.SuiteDiscoveryHelper;
import org.scalatest.tools.SuiteParam;
import org.scalatest.tools.SuiteParam$;
import org.scalatest.tools.TestSpec;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnce$;
import scala.collection.IterableOnceExtensionMethods$;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.SetOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.ListBuffer;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public final class SuiteDiscoveryHelper$
implements Serializable {
    private static final Class<?>[] emptyClassArray;
    public static final SuiteDiscoveryHelper$ MODULE$;

    private SuiteDiscoveryHelper$() {
    }

    static {
        MODULE$ = new SuiteDiscoveryHelper$();
        emptyClassArray = new Class[0];
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(SuiteDiscoveryHelper$.class);
    }

    public List<SuiteParam> discoverTests(List<TestSpec> testSpecs, Set<String> accessibleSuites, ClassLoader loader) {
        ListBuffer buf = new ListBuffer();
        if (!testSpecs.isEmpty()) {
            Set names = testSpecs.filter((Function1 & Serializable)_$1 -> !_$1.isSubstring()).map((Function1 & Serializable)_$2 -> _$2.spec()).toSet();
            Set substrings = testSpecs.filter((Function1 & Serializable)_$3 -> _$3.isSubstring()).map((Function1 & Serializable)_$4 -> _$4.spec()).toSet();
            accessibleSuites.foreach((Function1)(JProcedure1 & Serializable)suiteName -> {
                Suite suiteInstance = DiscoverySuite$.MODULE$.getSuiteInstance((String)suiteName, loader);
                Set nameMatches = (Set)names.intersect(suiteInstance.testNames());
                Set substringMatches = (Set)substrings.filter((Function1 & Serializable)substring -> suiteInstance.testNames().exists((Function1 & Serializable)_$5 -> _$5.contains((CharSequence)substring)));
                if (nameMatches.size() > 0 || substringMatches.size() > 0) {
                    buf.$plus$eq((Object)SuiteParam$.MODULE$.apply((String)suiteName, (String[])((IterableOnceOps)nameMatches.toList().sortWith((Function2 & Serializable)(_$6, _$7) -> StringOps$.MODULE$.$less$extension(Predef$.MODULE$.augmentString(_$6), _$7))).toArray(ClassTag$.MODULE$.apply(String.class)), (String[])((IterableOnceOps)substringMatches.toList().sortWith((Function2 & Serializable)(_$8, _$9) -> StringOps$.MODULE$.$less$extension(Predef$.MODULE$.augmentString(_$8), _$9))).toArray(ClassTag$.MODULE$.apply(String.class)), (NestedSuiteParam[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(NestedSuiteParam.class))));
                }
            });
        }
        return (List)buf.toList().sortWith((Function2 & Serializable)(_$10, _$11) -> StringOps$.MODULE$.$less$extension(Predef$.MODULE$.augmentString(_$10.className()), _$11.className()));
    }

    public Set<String> discoverSuiteNames(List<String> runpath, ClassLoader loader, Option<Pattern> suffixes) {
        String fileSeparatorString = System.getProperty("path.separator");
        char fileSeparator = !fileSeparatorString.isEmpty() ? (char)StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(fileSeparatorString), 0) : (char)':';
        List listOfSets = runpath.map((Function1 & Serializable)path -> {
            Set<String> set;
            None$ none$;
            try {
                none$ = Some$.MODULE$.apply((Object)new URL((String)path));
            }
            catch (MalformedURLException e) {
                none$ = None$.MODULE$;
            }
            None$ urlOption = none$;
            boolean endsWithDotJar = path.endsWith(".jar");
            if (endsWithDotJar) {
                Option jarFileOption;
                Option option;
                None$ none$2 = urlOption;
                if (none$2 instanceof Some) {
                    URL url = (URL)((Some)none$2).value();
                    option = this.getJarFileFromURL$1(url);
                } else {
                    if (!None$.MODULE$.equals(none$2)) throw new MatchError((Object)none$2);
                    option = this.getJarFileFromFileSystem$1((String)path);
                }
                Option option2 = jarFileOption = option;
                if (option2 instanceof Some) {
                    JarFile jf = (JarFile)((Some)option2).value();
                    set = this.processFileNames(this.getFileNamesIteratorFromJar(jf), '/', loader, suffixes);
                    return set;
                } else {
                    if (!None$.MODULE$.equals(option2)) throw new MatchError((Object)option2);
                    set = (Set<String>)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
                }
                return set;
            } else {
                set = this.processFileNames((Iterator<String>)this.getFileNamesSetFromFile(new File((String)path), fileSeparator).iterator(), fileSeparator, loader, suffixes);
            }
            return set;
        });
        return (Set)((SetOps)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]))).$plus$plus((IterableOnce)listOfSets.flatMap((Function1 & Serializable)_$12 -> _$12.iterator().toList()));
    }

    /*
     * Enabled aggressive block sorting
     */
    private Option<String> transformToClassName(String fileName, char fileSeparator) {
        None$ none$;
        String fn;
        String string = fn = !fileName.isEmpty() && StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(fileName), 0) == fileSeparator ? fileName.substring(1) : fileName;
        if (fn.endsWith(".class")) {
            String string2 = fn;
            String string3 = ".class";
            if (string2 == null ? string3 != null : !string2.equals(string3)) {
                none$ = Some$.MODULE$.apply((Object)fn.substring(0, fn.length() - 6).replace(fileSeparator, '.'));
                return none$;
            }
        }
        none$ = None$.MODULE$;
        return none$;
    }

    public boolean isAccessibleSuite(Class<?> clazz) {
        boolean bl;
        block4: {
            try {
                if (Suite.class.isAssignableFrom(clazz) && Modifier.isPublic(clazz.getModifiers()) && !Modifier.isAbstract(clazz.getModifiers()) && Modifier.isPublic(clazz.getConstructor(emptyClassArray).getModifiers())) {
                    bl = true;
                    break block4;
                }
                bl = false;
            }
            catch (NoSuchMethodException nsme) {
                bl = false;
            }
            catch (SecurityException se) {
                bl = false;
            }
        }
        return bl;
    }

    public boolean isAccessibleSuite(String className, ClassLoader loader) {
        boolean bl;
        try {
            bl = this.isAccessibleSuite(loader.loadClass(className));
        }
        catch (ClassNotFoundException e) {
            bl = false;
        }
        catch (NoClassDefFoundError e) {
            bl = false;
        }
        return bl;
    }

    public boolean isDiscoverableSuite(Class<?> clazz) {
        return !clazz.isAnnotationPresent(DoNotDiscover.class);
    }

    private boolean isDiscoverableSuite(String className, ClassLoader loader) {
        boolean bl;
        try {
            bl = this.isDiscoverableSuite(loader.loadClass(className));
        }
        catch (ClassNotFoundException e) {
            bl = false;
        }
        catch (NoClassDefFoundError e) {
            bl = false;
        }
        return bl;
    }

    public boolean isRunnable(Class<?> clazz) {
        boolean bl;
        WrapWith wrapWithAnnotation = clazz.getAnnotation(WrapWith.class);
        if (wrapWithAnnotation != null) {
            Class<? extends Suite> wrapperSuiteClazz = wrapWithAnnotation.value();
            Object[] constructorList = wrapperSuiteClazz.getDeclaredConstructors();
            Object object = Predef$.MODULE$.refArrayOps(constructorList);
            bl = ArrayOps$.MODULE$.exists$extension(object, (Function1 & Serializable)c -> {
                Class<?>[] types = c.getParameterTypes();
                if (types.length != 1) return false;
                Class<?> clazz = types[0];
                Class<Class> clazz2 = Class.class;
                if (clazz != null) {
                    if (!clazz.equals(clazz2)) return false;
                    return true;
                }
                if (clazz2 == null) return true;
                return false;
            });
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean isRunnable(String className, ClassLoader loader) {
        boolean bl;
        try {
            bl = this.isRunnable(loader.loadClass(className));
        }
        catch (ClassNotFoundException e) {
            bl = false;
        }
        catch (NoClassDefFoundError e) {
            bl = false;
        }
        return bl;
    }

    private Option<String> processClassName(String className, ClassLoader loader, Option<Pattern> suffixes) {
        return this.classNameSuffixOkay(className, suffixes) && this.isDiscoverableSuite(className, loader) && (this.isAccessibleSuite(className, loader) || this.isRunnable(className, loader)) ? Some$.MODULE$.apply((Object)className) : None$.MODULE$;
    }

    private boolean classNameSuffixOkay(String className, Option<Pattern> suffixes) {
        Option<Pattern> option = suffixes;
        None$ none$ = None$.MODULE$;
        return !(option == null ? none$ != null : !option.equals((Object)none$)) || ((Pattern)suffixes.get()).matcher(className).matches();
    }

    private Set<String> processFileNames(Iterator<String> fileNames, char fileSeparator, ClassLoader loader, Option<Pattern> suffixes) {
        Iterator classNameOptions = this.extractClassNames(fileNames, fileSeparator).map((Function1 & Serializable)className -> this.processClassName((String)className, loader, suffixes));
        Iterator classNames = classNameOptions.withFilter((Function1 & Serializable)x$1 -> {
            boolean bl;
            Option option = x$1;
            if (option instanceof Some) {
                String className = (String)((Some)option).value();
                bl = true;
            } else {
                bl = false;
            }
            return bl;
        }).map((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (!(option instanceof Some)) {
                throw new MatchError((Object)option);
            }
            String className = (String)((Some)option).value();
            return className;
        });
        IterableOnce iterableOnce = IterableOnce$.MODULE$.iterableOnceExtensionMethods((IterableOnce)classNames);
        return (Set)((SetOps)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]))).$plus$plus((IterableOnce)IterableOnceExtensionMethods$.MODULE$.toIterable$extension(iterableOnce));
    }

    private Set<String> getFileNamesSetFromFile(File file, char fileSeparator) {
        List allFiles = file.isDirectory() ? this.listFilesInDir$1(fileSeparator, file, "") : (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{file.getName()}));
        return (Set)((SetOps)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]))).$plus$plus((IterableOnce)allFiles.map((Function1 & Serializable)fn -> !fn.isEmpty() && StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(fn), 0) == fileSeparator ? fn.substring(1) : fn));
    }

    private Iterator<String> getFileNamesIteratorFromJar(JarFile file) {
        public class Org_scalatest_tools_SuiteDiscoveryHelper$EnumerationWrapper$1<T>
        implements Iterator<T> {
            private final Enumeration e;

            public Org_scalatest_tools_SuiteDiscoveryHelper$EnumerationWrapper$1(Enumeration e) {
                this.e = e;
                IterableOnce.$init$((IterableOnce)this);
                IterableOnceOps.$init$((IterableOnceOps)this);
                Iterator.$init$((Iterator)this);
            }

            public Object next() {
                return this.e.nextElement();
            }

            public boolean hasNext() {
                return this.e.hasMoreElements();
            }
        }
        return new Org_scalatest_tools_SuiteDiscoveryHelper$EnumerationWrapper$1(file.entries()).map((Function1 & Serializable)_$13 -> _$13.getName());
    }

    private Iterator<String> extractClassNames(Iterator<String> fileNames, char fileSeparator) {
        Iterator options = fileNames.map((Function1 & Serializable)fileName -> this.transformToClassName((String)fileName, fileSeparator));
        return options.withFilter((Function1 & Serializable)x$1 -> {
            boolean bl;
            Option option = x$1;
            if (option instanceof Some) {
                String className = (String)((Some)option).value();
                bl = true;
            } else {
                bl = false;
            }
            return bl;
        }).map((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (!(option instanceof Some)) {
                throw new MatchError((Object)option);
            }
            String className = (String)((Some)option).value();
            return className;
        });
    }

    private final Option getJarFileFromURL$1(URL url) {
        None$ none$;
        Object o = url.openConnection().getContent();
        if (o != null) {
            try {
                none$ = Some$.MODULE$.apply((Object)((JarFile)o));
            }
            catch (ClassCastException e) {
                none$ = None$.MODULE$;
            }
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private final Option getJarFileFromFileSystem$1(String path) {
        None$ none$;
        try {
            none$ = Some$.MODULE$.apply((Object)new JarFile(path));
        }
        catch (IOException e) {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private final String prependPrevName$1(char fileSeparator$2, String prevName, String fileName) {
        return new StringBuilder(0).append(prevName).append(fileSeparator$2).append(fileName).toString();
    }

    private final List listFilesInDir$1(char fileSeparator$7, File dir, String prevName) {
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException();
        }
        List subDirs = (List)Predef$.MODULE$.wrapRefArray((Object[])dir.listFiles()).toList().withFilter((Function1 & Serializable)entry -> entry.isDirectory()).map((Function1 & Serializable)entry -> entry);
        List fileLists = subDirs.map((Function1 & Serializable)subDir -> this.listFilesInDir$1(fileSeparator$7, (File)subDir, this.prependPrevName$1(fileSeparator$7, prevName, subDir.getName())));
        List files = (List)Predef$.MODULE$.wrapRefArray((Object[])dir.listFiles()).toList().withFilter((Function1 & Serializable)entry -> !entry.isDirectory()).map((Function1 & Serializable)entry -> this.prependPrevName$1(fileSeparator$7, prevName, entry.getName()));
        return fileLists.flatMap((Function1 & Serializable)e -> e).$colon$colon$colon(files);
    }
}

