/*
 * Decompiled with CFR 0.152.
 */
package org.scalatest.tools;

import java.io.Serializable;
import org.scalatest.Args;
import org.scalatest.Reporter;
import org.scalatest.Resources$;
import org.scalatest.ScalaTestStatefulStatus;
import org.scalatest.Status;
import org.scalatest.Suite;
import org.scalatest.Suite$;
import org.scalatest.Tracker;
import org.scalatest.events.Formatter;
import org.scalatest.events.Location;
import org.scalatest.events.SeeStackDepthException$;
import org.scalatest.events.SuiteAborted$;
import org.scalatest.events.SuiteCompleted$;
import org.scalatest.events.SuiteStarting$;
import org.scalatest.events.TopOfClass$;
import org.scalatest.exceptions.NotAllowedException;
import org.scalatest.tools.ConcurrentDistributor;
import org.scalatest.tools.DistributedTestRunnerSuite;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.function.JProcedure1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

public class SuiteRunner
implements Runnable {
    private final Suite suite;
    private final Args args;
    private final ScalaTestStatefulStatus status;

    public SuiteRunner(Suite suite, Args args, ScalaTestStatefulStatus status) {
        this.suite = suite;
        this.args = args;
        this.status = status;
    }

    @Override
    public void run() {
        if (!this.args.stopper().stopRequested()) {
            String rawString = Resources$.MODULE$.suiteExecutionStarting();
            Option<Formatter> formatter = Suite$.MODULE$.formatterForSuiteStarting(this.suite);
            String suiteClassName = Suite$.MODULE$.getSuiteClassName(this.suite);
            Reporter dispatch = this.args.reporter();
            Tracker tracker = this.args.tracker();
            long suiteStartTime = System.currentTimeMillis();
            if (!(this.suite instanceof DistributedTestRunnerSuite)) {
                dispatch.apply(SuiteStarting$.MODULE$.apply(tracker.nextOrdinal(), this.suite.suiteName(), this.suite.suiteId(), (Option<String>)Some$.MODULE$.apply((Object)suiteClassName), formatter, (Option<Location>)Some$.MODULE$.apply((Object)TopOfClass$.MODULE$.apply(this.suite.getClass().getName())), this.suite.rerunner(), SuiteStarting$.MODULE$.$lessinit$greater$default$8(), SuiteStarting$.MODULE$.$lessinit$greater$default$9(), SuiteStarting$.MODULE$.$lessinit$greater$default$10()));
            }
            try {
                Status runStatus = this.suite.run((Option<String>)None$.MODULE$, this.args);
                runStatus.whenCompleted((Function1<Try<Object>, BoxedUnit>)(JProcedure1 & Serializable)tri -> {
                    block8: {
                        Option<Formatter> formatter = Suite$.MODULE$.formatterForSuiteCompleted(this.suite);
                        long duration = System.currentTimeMillis() - suiteStartTime;
                        try {
                            Try try_ = tri;
                            if (try_ instanceof Success) {
                                boolean succeeded = BoxesRunTime.unboxToBoolean((Object)((Success)try_).value());
                                if (!succeeded) {
                                    this.status.setFailed();
                                }
                                if (!(this.suite instanceof DistributedTestRunnerSuite)) {
                                    dispatch.apply(SuiteCompleted$.MODULE$.apply(tracker.nextOrdinal(), this.suite.suiteName(), this.suite.suiteId(), (Option<String>)Some$.MODULE$.apply((Object)suiteClassName), (Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)duration)), formatter, (Option<Location>)Some$.MODULE$.apply((Object)TopOfClass$.MODULE$.apply(suiteClassName)), this.suite.rerunner(), SuiteCompleted$.MODULE$.$lessinit$greater$default$9(), SuiteCompleted$.MODULE$.$lessinit$greater$default$10(), SuiteCompleted$.MODULE$.$lessinit$greater$default$11()));
                                }
                                break block8;
                            }
                            if (try_ instanceof Failure) {
                                Throwable ue = ((Failure)try_).exception();
                                this.status.setFailed();
                                if (!(this.suite instanceof DistributedTestRunnerSuite)) {
                                    dispatch.apply(SuiteAborted$.MODULE$.apply(tracker.nextOrdinal(), String.valueOf(ue.getMessage()), this.suite.suiteName(), this.suite.suiteId(), (Option<String>)Some$.MODULE$.apply((Object)suiteClassName), (Option<Throwable>)Some$.MODULE$.apply((Object)ue), (Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)duration)), formatter, (Option<Location>)Some$.MODULE$.apply((Object)SeeStackDepthException$.MODULE$), this.suite.rerunner(), SuiteAborted$.MODULE$.$lessinit$greater$default$11(), SuiteAborted$.MODULE$.$lessinit$greater$default$12(), SuiteAborted$.MODULE$.$lessinit$greater$default$13()));
                                }
                                break block8;
                            }
                            throw new MatchError((Object)try_);
                        }
                        finally {
                            this.status.setCompleted();
                        }
                    }
                });
            }
            catch (NotAllowedException e) {
                Option<Formatter> formatter2 = Suite$.MODULE$.formatterForSuiteAborted(this.suite, e.getMessage());
                long duration = System.currentTimeMillis() - suiteStartTime;
                dispatch.apply(SuiteAborted$.MODULE$.apply(tracker.nextOrdinal(), e.getMessage(), this.suite.suiteName(), this.suite.suiteId(), (Option<String>)Some$.MODULE$.apply((Object)this.suite.getClass().getName()), (Option<Throwable>)Some$.MODULE$.apply((Object)e), (Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)duration)), formatter2, (Option<Location>)Some$.MODULE$.apply((Object)SeeStackDepthException$.MODULE$), this.suite.rerunner(), SuiteAborted$.MODULE$.$lessinit$greater$default$11(), SuiteAborted$.MODULE$.$lessinit$greater$default$12(), SuiteAborted$.MODULE$.$lessinit$greater$default$13()));
                this.status.setFailed();
                this.status.setCompleted();
            }
            catch (RuntimeException e) {
                String eMessage = e.getMessage();
                String rawString3 = eMessage != null && eMessage.length() > 0 ? Resources$.MODULE$.executeExceptionWithMessage(eMessage) : Resources$.MODULE$.executeException();
                Option<Formatter> formatter3 = Suite$.MODULE$.formatterForSuiteAborted(this.suite, rawString3);
                long duration = System.currentTimeMillis() - suiteStartTime;
                dispatch.apply(SuiteAborted$.MODULE$.apply(tracker.nextOrdinal(), rawString3, this.suite.suiteName(), this.suite.suiteId(), (Option<String>)Some$.MODULE$.apply((Object)this.suite.getClass().getName()), (Option<Throwable>)Some$.MODULE$.apply((Object)e), (Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)duration)), formatter3, (Option<Location>)Some$.MODULE$.apply((Object)SeeStackDepthException$.MODULE$), this.suite.rerunner(), SuiteAborted$.MODULE$.$lessinit$greater$default$11(), SuiteAborted$.MODULE$.$lessinit$greater$default$12(), SuiteAborted$.MODULE$.$lessinit$greater$default$13()));
                this.status.setFailed();
                this.status.setCompleted();
            }
            catch (Throwable e) {
                if (Suite$.MODULE$.anExceptionThatShouldCauseAnAbort(e) && this.args.distributor().isDefined() && this.args.distributor().get() instanceof ConcurrentDistributor) {
                    this.status.setFailedWith(e);
                } else {
                    this.status.setFailed();
                }
                this.status.setCompleted();
                throw e;
            }
        }
    }
}

