/*
 * Decompiled with CFR 0.152.
 */
package org.scalatest.tools;

import java.io.PrintStream;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;
import org.scalatest.CatchReporter;
import org.scalatest.DistributedSuiteSorter;
import org.scalatest.Reporter;
import org.scalatest.Timer;
import org.scalatest.TimerTask;
import org.scalatest.events.AlertProvided;
import org.scalatest.events.Event;
import org.scalatest.events.InfoProvided;
import org.scalatest.events.MarkupProvided;
import org.scalatest.events.NameInfo;
import org.scalatest.events.NoteProvided;
import org.scalatest.events.ScopeClosed;
import org.scalatest.events.ScopeOpened;
import org.scalatest.events.ScopePending;
import org.scalatest.events.SuiteAborted;
import org.scalatest.events.SuiteCompleted;
import org.scalatest.events.SuiteStarting;
import org.scalatest.events.TestCanceled;
import org.scalatest.events.TestFailed;
import org.scalatest.events.TestIgnored;
import org.scalatest.events.TestPending;
import org.scalatest.events.TestStarting;
import org.scalatest.events.TestSucceeded;
import org.scalatest.time.Span;
import org.scalatest.tools.SuiteSortingReporter$Slot$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.ListBuffer;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public class SuiteSortingReporter
implements CatchReporter,
DistributedSuiteSorter {
    private final Reporter dispatch;
    private final Span testSortingTimeout;
    private final PrintStream out;
    public final SuiteSortingReporter$Slot$ Slot$lzy1;
    private volatile ListBuffer<Slot> slotListBuf;
    private final HashMap<String, Slot> slotMap;
    private final HashMap<String, Vector<Event>> suiteEventMap;
    private final HashMap<String, Reporter> suiteReporterMap;
    private Option<Tuple2<TimeoutTask, Timer>> timeoutTask;

    public SuiteSortingReporter(Reporter dispatch, Span testSortingTimeout, PrintStream out) {
        this.dispatch = dispatch;
        this.testSortingTimeout = testSortingTimeout;
        this.out = out;
        this.Slot$lzy1 = new SuiteSortingReporter$Slot$(this);
        this.slotListBuf = new ListBuffer();
        this.slotMap = (HashMap)HashMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        this.suiteEventMap = (HashMap)HashMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        this.suiteReporterMap = (HashMap)HashMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        this.timeoutTask = None$.MODULE$;
    }

    public Span testSortingTimeout() {
        return this.testSortingTimeout;
    }

    @Override
    public PrintStream out() {
        return this.out;
    }

    public final SuiteSortingReporter$Slot$ Slot() {
        return this.Slot$lzy1;
    }

    public void registerReporter(String suiteId, Reporter reporter) {
        SuiteSortingReporter suiteSortingReporter = this;
        synchronized (suiteSortingReporter) {
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)suiteId);
            HashMap cfr_ignored_0 = (HashMap)this.suiteReporterMap.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)reporter));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void doApply(Event event) {
        SuiteSortingReporter suiteSortingReporter = this;
        synchronized (suiteSortingReporter) {
            Event event2 = event;
            if (event2 instanceof SuiteStarting) {
                Slot slot;
                SuiteStarting suiteStarting = (SuiteStarting)event2;
                Option option = this.slotMap.get((Object)suiteStarting.suiteId());
                if (option instanceof Some) {
                    Slot s;
                    slot = s = (Slot)((Some)option).value();
                } else {
                    if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
                    Slot newSlot = this.Slot().apply(suiteStarting.suiteId(), (Option<Event>)None$.MODULE$, false, false, false);
                    this.slotMap.put((Object)suiteStarting.suiteId(), (Object)newSlot);
                    slot = newSlot;
                }
                Slot slot2 = slot;
                this.slotListBuf.$plus$eq((Object)slot2);
                if (this.slotListBuf.size() == 1) {
                    this.scheduleTimeoutTask();
                }
                this.handleTestEvents(suiteStarting.suiteId(), suiteStarting);
            } else if (event2 instanceof SuiteCompleted) {
                SuiteCompleted suiteCompleted = (SuiteCompleted)event2;
                this.handleSuiteEvents(suiteCompleted.suiteId(), suiteCompleted);
            } else if (event2 instanceof SuiteAborted) {
                SuiteAborted suiteAborted = (SuiteAborted)event2;
                this.handleSuiteEvents(suiteAborted.suiteId(), suiteAborted);
            } else if (event2 instanceof TestStarting) {
                TestStarting testStarting = (TestStarting)event2;
                this.handleTestEvents(testStarting.suiteId(), testStarting);
            } else if (event2 instanceof TestIgnored) {
                TestIgnored testIgnored = (TestIgnored)event2;
                this.handleTestEvents(testIgnored.suiteId(), testIgnored);
            } else if (event2 instanceof TestSucceeded) {
                TestSucceeded testSucceeded = (TestSucceeded)event2;
                this.handleTestEvents(testSucceeded.suiteId(), testSucceeded);
            } else if (event2 instanceof TestFailed) {
                TestFailed testFailed = (TestFailed)event2;
                this.handleTestEvents(testFailed.suiteId(), testFailed);
            } else if (event2 instanceof TestPending) {
                TestPending testPending = (TestPending)event2;
                this.handleTestEvents(testPending.suiteId(), testPending);
            } else if (event2 instanceof TestCanceled) {
                TestCanceled testCanceled = (TestCanceled)event2;
                this.handleTestEvents(testCanceled.suiteId(), testCanceled);
            } else if (event2 instanceof InfoProvided) {
                InfoProvided infoProvided = (InfoProvided)event2;
                Option<NameInfo> option = infoProvided.nameInfo();
                if (option instanceof Some) {
                    NameInfo nameInfo = (NameInfo)((Some)option).value();
                    this.handleTestEvents(nameInfo.suiteId(), infoProvided);
                } else {
                    if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                    this.dispatch.apply(infoProvided);
                }
            } else if (event2 instanceof AlertProvided) {
                AlertProvided alertProvided = (AlertProvided)event2;
                Option<NameInfo> option = alertProvided.nameInfo();
                if (option instanceof Some) {
                    NameInfo nameInfo = (NameInfo)((Some)option).value();
                    this.handleTestEvents(nameInfo.suiteId(), alertProvided);
                } else {
                    if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                    this.dispatch.apply(alertProvided);
                }
            } else if (event2 instanceof NoteProvided) {
                NoteProvided noteProvided = (NoteProvided)event2;
                Option<NameInfo> option = noteProvided.nameInfo();
                if (option instanceof Some) {
                    NameInfo nameInfo = (NameInfo)((Some)option).value();
                    this.handleTestEvents(nameInfo.suiteId(), noteProvided);
                } else {
                    if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                    this.dispatch.apply(noteProvided);
                }
            } else if (event2 instanceof MarkupProvided) {
                MarkupProvided markupProvided = (MarkupProvided)event2;
                Option<NameInfo> option = markupProvided.nameInfo();
                if (option instanceof Some) {
                    NameInfo nameInfo = (NameInfo)((Some)option).value();
                    this.handleTestEvents(nameInfo.suiteId(), markupProvided);
                } else {
                    if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                    this.dispatch.apply(markupProvided);
                }
            } else if (event2 instanceof ScopeOpened) {
                ScopeOpened scopeOpened = (ScopeOpened)event2;
                this.handleTestEvents(scopeOpened.nameInfo().suiteId(), scopeOpened);
            } else if (event2 instanceof ScopeClosed) {
                ScopeClosed scopeClosed = (ScopeClosed)event2;
                this.handleTestEvents(scopeClosed.nameInfo().suiteId(), scopeClosed);
            } else if (event2 instanceof ScopePending) {
                ScopePending scopePending = (ScopePending)event2;
                this.handleTestEvents(scopePending.nameInfo().suiteId(), scopePending);
            } else {
                this.dispatch.apply(event);
            }
            this.fireReadyEvents();
            return;
        }
    }

    private void dispatchToRegisteredSuiteReporter(String suiteId, Event event) {
        Option option;
        SuiteSortingReporter suiteSortingReporter = this;
        synchronized (suiteSortingReporter) {
            option = this.suiteReporterMap.get((Object)suiteId);
        }
        Option option2 = option;
        if (option2 instanceof Some) {
            Reporter rep = (Reporter)((Some)option2).value();
            rep.apply(event);
        } else if (!None$.MODULE$.equals(option2)) {
            throw new MatchError((Object)option2);
        }
    }

    private void handleSuiteEvents(String suiteId, Event event) {
        Slot slot = (Slot)this.slotMap.apply((Object)suiteId);
        Some some = Some$.MODULE$.apply((Object)event);
        boolean bl = slot.includesDistributedTests() ? slot.testsCompleted() : true;
        String string = slot.copy$default$1();
        boolean bl2 = slot.copy$default$3();
        boolean bl3 = slot.copy$default$4();
        Slot newSlot = slot.copy(string, (Option<Event>)some, bl2, bl3, bl);
        this.slotMap.put((Object)suiteId, (Object)newSlot);
        int slotIdx = this.slotListBuf.indexOf((Object)slot);
        if (slotIdx >= 0) {
            this.slotListBuf.update(slotIdx, (Object)newSlot);
        } else {
            this.dispatch.apply(event);
            this.dispatchToRegisteredSuiteReporter(suiteId, event);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleTestEvents(String suiteId, Event event) {
        Slot slot = (Slot)this.slotMap.apply((Object)suiteId);
        int slotIdx = this.slotListBuf.indexOf((Object)slot);
        if (slotIdx >= 0) {
            Option option = this.suiteEventMap.get((Object)suiteId);
            if (option instanceof Some) {
                Vector eventList = (Vector)((Some)option).value();
                this.suiteEventMap.put((Object)suiteId, eventList.$colon$plus((Object)event));
                return;
            } else {
                if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
                this.suiteEventMap.put((Object)suiteId, package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Event[]{event})));
            }
            return;
        } else {
            this.dispatch.apply(event);
            this.dispatchToRegisteredSuiteReporter(suiteId, event);
        }
    }

    private void fireReadyEvents() {
        if (this.slotListBuf.size() > 0) {
            Slot head = (Slot)this.slotListBuf.head();
            this.fireSuiteEvents(head.suiteId());
            if (head.ready()) {
                head.doneEvent().foreach((Function1 & Serializable)doneEvent -> {
                    this.dispatch.apply((Event)doneEvent);
                    this.dispatchToRegisteredSuiteReporter(head.suiteId(), (Event)doneEvent);
                    return (HashMap)this.suiteReporterMap.$minus$eq((Object)head.suiteId());
                });
                this.slotListBuf = this.fireReadySuiteEvents((ListBuffer<Slot>)((ListBuffer)this.slotListBuf.tail()));
                if (this.slotListBuf.size() > 0) {
                    this.scheduleTimeoutTask();
                } else {
                    this.cancelTimeoutTask();
                }
            }
        }
    }

    private void fireSuiteEvents(String suiteId) {
        block4: {
            Option option;
            SuiteSortingReporter suiteSortingReporter = this;
            while ((option = suiteSortingReporter.suiteEventMap.get((Object)suiteId)) instanceof Some) {
                Vector eventList = (Vector)((Some)option).value();
                if (eventList.length() > 1) {
                    Event head = (Event)eventList.head();
                    suiteSortingReporter.suiteEventMap.put((Object)suiteId, (Object)eventList.tail());
                    suiteSortingReporter.dispatch.apply(head);
                    suiteSortingReporter.dispatchToRegisteredSuiteReporter(suiteId, head);
                    continue;
                }
                if (eventList.length() == 1) {
                    Event head = (Event)eventList.head();
                    suiteSortingReporter.suiteEventMap.put((Object)suiteId, (Object)package$.MODULE$.Vector().empty());
                    suiteSortingReporter.dispatch.apply(head);
                    suiteSortingReporter.dispatchToRegisteredSuiteReporter(suiteId, head);
                }
                break block4;
            }
            if (!None$.MODULE$.equals(option)) {
                throw new MatchError((Object)option);
            }
        }
    }

    private ListBuffer<Slot> fireReadySuiteEvents(ListBuffer<Slot> remainingSlotList) {
        Tuple2 tuple2 = remainingSlotList.span((Function1 & Serializable)_$1 -> _$1.ready());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        ListBuffer done = (ListBuffer)tuple2._1();
        ListBuffer undone = (ListBuffer)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)done, (Object)undone);
        ListBuffer done2 = (ListBuffer)tuple22._1();
        ListBuffer undone2 = (ListBuffer)tuple22._2();
        done2.foreach((Function1 & Serializable)slot -> {
            this.fireSuiteEvents(slot.suiteId());
            this.dispatch.apply((Event)slot.doneEvent().get());
            this.dispatchToRegisteredSuiteReporter(slot.suiteId(), (Event)slot.doneEvent().get());
            return (HashMap)this.suiteReporterMap.$minus$eq((Object)slot.suiteId());
        });
        return undone2;
    }

    @Override
    public void completedTests(String suiteId) {
        SuiteSortingReporter suiteSortingReporter = this;
        synchronized (suiteSortingReporter) {
            Slot slot = (Slot)this.slotMap.apply((Object)suiteId);
            boolean bl = slot.doneEvent().isDefined();
            String string = slot.copy$default$1();
            Option<Event> option = slot.copy$default$2();
            boolean bl2 = slot.copy$default$3();
            Slot newSlot = slot.copy(string, option, bl2, true, bl);
            this.slotMap.put((Object)suiteId, (Object)newSlot);
            int slotIdx = this.slotListBuf.indexOf((Object)slot);
            if (slotIdx >= 0) {
                this.slotListBuf.update(slotIdx, (Object)newSlot);
            }
            this.fireReadyEvents();
        }
    }

    public void slowpokeEvent(AlertProvided event) {
        SuiteSortingReporter suiteSortingReporter = this;
        synchronized (suiteSortingReporter) {
            Option option;
            SuiteSortingReporter suiteSortingReporter2 = this;
            synchronized (suiteSortingReporter2) {
                option = this.suiteReporterMap.values().headOption();
            }
            Option option2 = option;
            if (option2 instanceof Some) {
                Reporter rep = (Reporter)((Some)option2).value();
                rep.apply(event);
            } else if (!None$.MODULE$.equals(option2)) {
                throw new MatchError((Object)option2);
            }
        }
    }

    @Override
    public void distributingTests(String suiteId) {
        SuiteSortingReporter suiteSortingReporter = this;
        synchronized (suiteSortingReporter) {
            Option option;
            Option option2 = this.slotMap.get((Object)suiteId);
            if (option2 instanceof Some) {
                Slot slot = (Slot)((Some)option2).value();
                Slot newSlot = slot.copy(slot.copy$default$1(), slot.copy$default$2(), true, slot.copy$default$4(), slot.copy$default$5());
                this.slotMap.put((Object)suiteId, (Object)newSlot);
                int slotIdx = this.slotListBuf.indexOf((Object)slot);
                if (slotIdx >= 0) {
                    this.slotListBuf.update(slotIdx, (Object)newSlot);
                    option = BoxedUnit.UNIT;
                } else {
                    option = BoxedUnit.UNIT;
                }
            } else if (None$.MODULE$.equals(option2)) {
                option = this.slotMap.put((Object)suiteId, (Object)this.Slot().apply(suiteId, (Option<Event>)None$.MODULE$, true, false, false));
            } else {
                throw new MatchError((Object)option2);
            }
        }
    }

    @Override
    public void doDispose() {
        this.fireReadyEvents();
    }

    private void scheduleTimeoutTask() {
        Tuple2 tuple2;
        Slot head = (Slot)this.slotListBuf.head();
        Option<Tuple2<TimeoutTask, Timer>> option = this.timeoutTask;
        if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
            TimeoutTask oldTask = (TimeoutTask)tuple2._1();
            Timer oldTimer = (Timer)tuple2._2();
            String string = head.suiteId();
            String string2 = oldTask.slot().suiteId();
            if (string == null ? string2 != null : !string.equals(string2)) {
                oldTask.cancel();
                oldTimer.cancel();
                Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)new TimeoutTask(this, head), (Object)new Timer());
                TimeoutTask task = (TimeoutTask)tuple22._1();
                Timer timer = (Timer)tuple22._2();
                this.timeoutTask = Some$.MODULE$.apply((Object)Tuple2$.MODULE$.apply((Object)task, (Object)timer));
                timer.schedule(task, this.testSortingTimeout().millisPart());
            }
        } else if (None$.MODULE$.equals(option)) {
            Tuple2 tuple23 = Tuple2$.MODULE$.apply((Object)new TimeoutTask(this, head), (Object)new Timer());
            TimeoutTask task = (TimeoutTask)tuple23._1();
            Timer timer = (Timer)tuple23._2();
            this.timeoutTask = Some$.MODULE$.apply((Object)Tuple2$.MODULE$.apply((Object)task, (Object)timer));
            timer.schedule(task, this.testSortingTimeout().millisPart());
        } else {
            throw new MatchError(option);
        }
    }

    private void cancelTimeoutTask() {
        Tuple2 tuple2;
        Option<Tuple2<TimeoutTask, Timer>> option = this.timeoutTask;
        if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
            TimeoutTask task = (TimeoutTask)tuple2._1();
            Timer timer = (Timer)tuple2._2();
            task.cancel();
            timer.cancel();
            this.timeoutTask = None$.MODULE$;
        } else if (!None$.MODULE$.equals(option)) {
            throw new MatchError(option);
        }
    }

    public void org$scalatest$tools$SuiteSortingReporter$$timeout() {
        SuiteSortingReporter suiteSortingReporter = this;
        synchronized (suiteSortingReporter) {
            BoxedUnit boxedUnit;
            if (this.slotListBuf.size() > 0) {
                Slot head = (Slot)this.slotListBuf.head();
                Tuple2 tuple2 = (Tuple2)this.timeoutTask.get();
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                TimeoutTask task = (TimeoutTask)tuple2._1();
                TimeoutTask task2 = task;
                String string = task2.slot().suiteId();
                String string2 = head.suiteId();
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    Slot newSlot = head.copy(head.copy$default$1(), head.copy$default$2(), head.copy$default$3(), head.copy$default$4(), true);
                    this.slotListBuf.update(0, (Object)newSlot);
                }
                this.fireReadyEvents();
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    public class Slot
    implements Product,
    Serializable {
        private final String suiteId;
        private final Option doneEvent;
        private final boolean includesDistributedTests;
        private final boolean testsCompleted;
        private final boolean ready;
        private final /* synthetic */ SuiteSortingReporter $outer;

        public Slot(SuiteSortingReporter $outer, String suiteId, Option<Event> doneEvent, boolean includesDistributedTests, boolean testsCompleted, boolean ready) {
            this.suiteId = suiteId;
            this.doneEvent = doneEvent;
            this.includesDistributedTests = includesDistributedTests;
            this.testsCompleted = testsCompleted;
            this.ready = ready;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.suiteId()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.doneEvent()));
            n = Statics.mix((int)n, (int)(this.includesDistributedTests() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)(this.testsCompleted() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)(this.ready() ? 1231 : 1237));
            return Statics.finalizeHash((int)n, (int)5);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Slot)) return false;
            if (((Slot)object).org$scalatest$tools$SuiteSortingReporter$Slot$$$outer() != this.$outer) return false;
            Slot slot = (Slot)object;
            if (this.includesDistributedTests() != slot.includesDistributedTests()) return false;
            if (this.testsCompleted() != slot.testsCompleted()) return false;
            if (this.ready() != slot.ready()) return false;
            String string = this.suiteId();
            String string2 = slot.suiteId();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            Option<Event> option = this.doneEvent();
            Option<Event> option2 = slot.doneEvent();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            if (!slot.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Slot;
        }

        public int productArity() {
            return 5;
        }

        public String productPrefix() {
            return "Slot";
        }

        public Object productElement(int n) {
            Object object;
            int n2 = n;
            switch (n2) {
                case 0: {
                    object = this._1();
                    break;
                }
                case 1: {
                    object = this._2();
                    break;
                }
                case 2: {
                    object = BoxesRunTime.boxToBoolean((boolean)this._3());
                    break;
                }
                case 3: {
                    object = BoxesRunTime.boxToBoolean((boolean)this._4());
                    break;
                }
                case 4: {
                    object = BoxesRunTime.boxToBoolean((boolean)this._5());
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return object;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            switch (n2) {
                case 0: {
                    string = "suiteId";
                    break;
                }
                case 1: {
                    string = "doneEvent";
                    break;
                }
                case 2: {
                    string = "includesDistributedTests";
                    break;
                }
                case 3: {
                    string = "testsCompleted";
                    break;
                }
                case 4: {
                    string = "ready";
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return string;
        }

        public String suiteId() {
            return this.suiteId;
        }

        public Option<Event> doneEvent() {
            return this.doneEvent;
        }

        public boolean includesDistributedTests() {
            return this.includesDistributedTests;
        }

        public boolean testsCompleted() {
            return this.testsCompleted;
        }

        public boolean ready() {
            return this.ready;
        }

        public Slot copy(String suiteId, Option<Event> doneEvent, boolean includesDistributedTests, boolean testsCompleted, boolean ready) {
            return new Slot(this.$outer, suiteId, doneEvent, includesDistributedTests, testsCompleted, ready);
        }

        public String copy$default$1() {
            return this.suiteId();
        }

        public Option<Event> copy$default$2() {
            return this.doneEvent();
        }

        public boolean copy$default$3() {
            return this.includesDistributedTests();
        }

        public boolean copy$default$4() {
            return this.testsCompleted();
        }

        public boolean copy$default$5() {
            return this.ready();
        }

        public String _1() {
            return this.suiteId();
        }

        public Option<Event> _2() {
            return this.doneEvent();
        }

        public boolean _3() {
            return this.includesDistributedTests();
        }

        public boolean _4() {
            return this.testsCompleted();
        }

        public boolean _5() {
            return this.ready();
        }

        public final /* synthetic */ SuiteSortingReporter org$scalatest$tools$SuiteSortingReporter$Slot$$$outer() {
            return this.$outer;
        }
    }

    public class TimeoutTask
    implements TimerTask {
        private AtomicReference timerTaskRef;
        private final Slot slot;
        private final /* synthetic */ SuiteSortingReporter $outer;

        public TimeoutTask(SuiteSortingReporter $outer, Slot slot) {
            this.slot = slot;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            TimerTask.$init$(this);
            Statics.releaseFence();
        }

        public AtomicReference timerTaskRef() {
            return this.timerTaskRef;
        }

        @Override
        public void org$scalatest$TimerTask$_setter_$timerTaskRef_$eq(AtomicReference x$0) {
            this.timerTaskRef = x$0;
        }

        public Slot slot() {
            return this.slot;
        }

        @Override
        public void run() {
            this.$outer.org$scalatest$tools$SuiteSortingReporter$$timeout();
        }

        public final /* synthetic */ SuiteSortingReporter org$scalatest$tools$SuiteSortingReporter$TimeoutTask$$$outer() {
            return this.$outer;
        }
    }
}

