/*
 * Decompiled with CFR 0.152.
 */
package org.scalatest.tools;

import java.io.PrintWriter;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Enumeration;
import java.util.Properties;
import org.scalatest.Reporter;
import org.scalatest.Suite$;
import org.scalatest.events.AlertProvided;
import org.scalatest.events.DiscoveryCompleted;
import org.scalatest.events.DiscoveryStarting;
import org.scalatest.events.Event;
import org.scalatest.events.InfoProvided;
import org.scalatest.events.MarkupProvided;
import org.scalatest.events.NoteProvided;
import org.scalatest.events.RunAborted;
import org.scalatest.events.RunCompleted;
import org.scalatest.events.RunStarting;
import org.scalatest.events.RunStopped;
import org.scalatest.events.ScopeClosed;
import org.scalatest.events.ScopeOpened;
import org.scalatest.events.ScopePending;
import org.scalatest.events.SuiteAborted;
import org.scalatest.events.SuiteCompleted;
import org.scalatest.events.SuiteStarting;
import org.scalatest.events.TestCanceled;
import org.scalatest.events.TestFailed;
import org.scalatest.events.TestIgnored;
import org.scalatest.events.TestPending;
import org.scalatest.events.TestStarting;
import org.scalatest.events.TestSucceeded;
import org.scalatest.tools.XmlReporter$Testcase$;
import org.scalatest.tools.XmlReporter$Testsuite$;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Scala3RunTime$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.Node;
import scala.xml.NodeBuffer;
import scala.xml.NodeSeq;
import scala.xml.NodeSeq$;
import scala.xml.Null$;
import scala.xml.PrettyPrinter;
import scala.xml.Text;
import scala.xml.TopScope$;
import scala.xml.UnprefixedAttribute;

public class XmlReporter
implements Reporter {
    private final String directory;
    private final Set<Event> events;
    private final Elem propertiesXml;
    public final XmlReporter$Testsuite$ Testsuite$lzy1;
    public final XmlReporter$Testcase$ Testcase$lzy1;

    public XmlReporter(String directory) {
        this.directory = directory;
        this.Testsuite$lzy1 = new XmlReporter$Testsuite$(this);
        this.Testcase$lzy1 = new XmlReporter$Testcase$(this);
        this.events = (Set)Set$.MODULE$.empty();
        this.propertiesXml = this.genPropertiesXml();
    }

    @Override
    public void apply(Event event) {
        block1: {
            Event event2;
            block0: {
                this.events.$plus$eq((Object)event);
                event2 = event;
                if (!(event2 instanceof SuiteCompleted)) break block0;
                SuiteCompleted e = (SuiteCompleted)event2;
                this.writeSuiteFile(e);
                break block1;
            }
            if (!(event2 instanceof SuiteAborted)) break block1;
            SuiteAborted e = (SuiteAborted)event2;
            this.writeSuiteFile(e);
        }
    }

    private void writeSuiteFile(Event endEvent) {
        Predef$.MODULE$.require(endEvent instanceof SuiteCompleted || endEvent instanceof SuiteAborted);
        Testsuite testsuite = this.getTestsuite(endEvent);
        String xmlStr = this.xmlify(testsuite);
        String filespec = new StringBuilder(5).append(this.directory).append("/").append(testsuite.name()).append(".xml").toString();
        PrintWriter out = new PrintWriter(filespec, "UTF-8");
        out.print(xmlStr);
        out.close();
    }

    private Testsuite getTestsuite(Event endEvent) {
        String string;
        Predef$.MODULE$.require(endEvent instanceof SuiteCompleted || endEvent instanceof SuiteAborted);
        List ordinalPrefix = (List)endEvent.ordinal().toList().dropRight(1);
        List samePrefixEvents = this.events.toList().filter((Function1 & Serializable)e -> {
            Object object = e.ordinal().toList().dropRight(1);
            List list = ordinalPrefix;
            return !(object != null ? !object.equals(list) : list != null);
        });
        Event[] orderedEvents = (Event[])((IterableOnceOps)samePrefixEvents.sortWith((Function2 & Serializable)(a, b) -> a.$less(b))).toArray(ClassTag$.MODULE$.apply(Event.class));
        Tuple2<Object, Object> tuple2 = this.locateSuite(orderedEvents, endEvent);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int startIndex = BoxesRunTime.unboxToInt((Object)tuple2._1());
        int endIndex = BoxesRunTime.unboxToInt((Object)tuple2._2());
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)startIndex), (Object)BoxesRunTime.boxToInteger((int)endIndex));
        int startIndex2 = BoxesRunTime.unboxToInt((Object)tuple22._1());
        int endIndex2 = BoxesRunTime.unboxToInt((Object)tuple22._2());
        SuiteStarting startEvent = (SuiteStarting)orderedEvents[startIndex2];
        this.events.$minus$eq((Object)startEvent);
        Option<String> option = startEvent.suiteClassName();
        if (option instanceof Some) {
            String className;
            string = className = (String)((Some)option).value();
        } else if (None$.MODULE$.equals(option)) {
            string = startEvent.suiteName();
        } else {
            throw new MatchError(option);
        }
        String name = string;
        Testsuite testsuite = this.Testsuite().apply(name, startEvent.timeStamp());
        int idx = startIndex2 + 1;
        while (idx <= endIndex2) {
            Event event = orderedEvents[idx];
            this.events.$minus$eq((Object)event);
            Event event2 = event;
            if (event2 instanceof TestStarting) {
                TestStarting e2 = (TestStarting)event2;
                Tuple2<Object, Testcase> tuple23 = this.processTest(orderedEvents, e2, idx);
                if (tuple23 == null) {
                    throw new MatchError(tuple23);
                }
                int testEndIndex = BoxesRunTime.unboxToInt((Object)tuple23._1());
                Testcase testcase = (Testcase)tuple23._2();
                Tuple2 tuple24 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)testEndIndex), (Object)testcase);
                int testEndIndex2 = BoxesRunTime.unboxToInt((Object)tuple24._1());
                Testcase testcase2 = (Testcase)tuple24._2();
                if (!testcase2.pending() && !testcase2.canceled()) {
                    testsuite.testcases().$plus$eq((Object)testcase2);
                    Option<TestFailed> option2 = testcase2.failure();
                    None$ none$ = None$.MODULE$;
                    if (option2 == null ? none$ != null : !option2.equals((Object)none$)) {
                        testsuite.failures_$eq(testsuite.failures() + 1);
                    }
                }
                idx = testEndIndex2 + 1;
                continue;
            }
            if (event2 instanceof TestIgnored) {
                TestIgnored e3 = (TestIgnored)event2;
                Testcase testcase = this.ignoreTest(e3);
                testsuite.testcases().$plus$eq((Object)testcase);
                ++idx;
                continue;
            }
            if (event2 instanceof SuiteAborted) {
                SuiteAborted e4 = (SuiteAborted)event2;
                if (endIndex2 != idx) {
                    throw Scala3RunTime$.MODULE$.assertFailed();
                }
                testsuite.errors_$eq(testsuite.errors() + 1);
                testsuite.time_$eq(e4.timeStamp() - testsuite.timeStamp());
                ++idx;
                continue;
            }
            if (event2 instanceof SuiteCompleted) {
                SuiteCompleted e5 = (SuiteCompleted)event2;
                if (endIndex2 != idx) {
                    throw Scala3RunTime$.MODULE$.assertFailed();
                }
                testsuite.time_$eq(e5.timeStamp() - testsuite.timeStamp());
                ++idx;
                continue;
            }
            if (event2 instanceof InfoProvided) {
                InfoProvided e6 = (InfoProvided)event2;
                ++idx;
                continue;
            }
            if (event2 instanceof AlertProvided) {
                AlertProvided e7 = (AlertProvided)event2;
                ++idx;
                continue;
            }
            if (event2 instanceof NoteProvided) {
                NoteProvided e8 = (NoteProvided)event2;
                ++idx;
                continue;
            }
            if (event2 instanceof ScopeOpened) {
                ScopeOpened e9 = (ScopeOpened)event2;
                ++idx;
                continue;
            }
            if (event2 instanceof ScopeClosed) {
                ScopeClosed e10 = (ScopeClosed)event2;
                ++idx;
                continue;
            }
            if (event2 instanceof ScopePending) {
                ScopePending e11 = (ScopePending)event2;
                ++idx;
                continue;
            }
            if (event2 instanceof MarkupProvided) {
                MarkupProvided e12 = (MarkupProvided)event2;
                ++idx;
                continue;
            }
            if (event2 instanceof TestPending) {
                TestPending e13 = (TestPending)event2;
                this.unexpected(e13);
                continue;
            }
            if (event2 instanceof TestCanceled) {
                TestCanceled e14 = (TestCanceled)event2;
                this.unexpected(e14);
                continue;
            }
            if (event2 instanceof RunStarting) {
                RunStarting e15 = (RunStarting)event2;
                this.unexpected(e15);
                continue;
            }
            if (event2 instanceof RunCompleted) {
                RunCompleted e16 = (RunCompleted)event2;
                this.unexpected(e16);
                continue;
            }
            if (event2 instanceof RunStopped) {
                RunStopped e17 = (RunStopped)event2;
                this.unexpected(e17);
                continue;
            }
            if (event2 instanceof RunAborted) {
                RunAborted e18 = (RunAborted)event2;
                this.unexpected(e18);
                continue;
            }
            if (event2 instanceof TestSucceeded) {
                TestSucceeded e19 = (TestSucceeded)event2;
                this.unexpected(e19);
                continue;
            }
            if (event2 instanceof TestFailed) {
                TestFailed e20 = (TestFailed)event2;
                this.unexpected(e20);
                continue;
            }
            if (event2 instanceof SuiteStarting) {
                SuiteStarting e21 = (SuiteStarting)event2;
                this.unexpected(e21);
                continue;
            }
            if (event2 instanceof DiscoveryStarting) {
                DiscoveryStarting e22 = (DiscoveryStarting)event2;
                this.unexpected(e22);
                continue;
            }
            if (event2 instanceof DiscoveryCompleted) {
                DiscoveryCompleted e23 = (DiscoveryCompleted)event2;
                this.unexpected(e23);
                continue;
            }
            throw new MatchError((Object)event2);
        }
        return testsuite;
    }

    private Tuple2<Object, Object> locateSuite(Event[] orderedEvents, Event endEvent) {
        Object object;
        Object object2 = Predef$.MODULE$.refArrayOps((Object[])orderedEvents);
        Predef$.MODULE$.require(ArrayOps$.MODULE$.size$extension(object2) > 0);
        Predef$.MODULE$.require(endEvent instanceof SuiteCompleted || endEvent instanceof SuiteAborted);
        int startIndex = 0;
        int endIndex = 0;
        for (int idx = 0; idx < ArrayOps$.MODULE$.size$extension(object = Predef$.MODULE$.refArrayOps((Object[])orderedEvents)) && endIndex == 0; ++idx) {
            Event event = orderedEvents[idx];
            Event event2 = event;
            if (event2 instanceof SuiteStarting) {
                SuiteStarting e = (SuiteStarting)event2;
                startIndex = idx;
                continue;
            }
            if (event2 instanceof SuiteCompleted) {
                SuiteCompleted e = (SuiteCompleted)event2;
                Event event3 = event;
                Event event4 = endEvent;
                if (event3 != null ? !event3.equals(event4) : event4 != null) continue;
                endIndex = idx;
                String string = e.suiteName();
                String string2 = ((SuiteStarting)orderedEvents[startIndex]).suiteName();
                if (!(string == null ? string2 != null : !string.equals(string2))) continue;
                throw Scala3RunTime$.MODULE$.assertFailed();
            }
            if (!(event2 instanceof SuiteAborted)) continue;
            SuiteAborted e = (SuiteAborted)event2;
            Event event5 = event;
            Event event6 = endEvent;
            if (event5 != null ? !event5.equals(event6) : event6 != null) continue;
            endIndex = idx;
            String string = e.suiteName();
            String string3 = ((SuiteStarting)orderedEvents[startIndex]).suiteName();
            if (!(string == null ? string3 != null : !string.equals(string3))) continue;
            throw Scala3RunTime$.MODULE$.assertFailed();
        }
        if (endIndex <= 0) {
            throw Scala3RunTime$.MODULE$.assertFailed();
        }
        if (!(orderedEvents[startIndex] instanceof SuiteStarting)) {
            throw Scala3RunTime$.MODULE$.assertFailed();
        }
        return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)startIndex), (Object)BoxesRunTime.boxToInteger((int)endIndex));
    }

    private Tuple2<Object, Testcase> processTest(Event[] orderedEvents, TestStarting startEvent, int startIndex) {
        Object object;
        Testcase testcase = this.Testcase().apply(startEvent.testName(), startEvent.suiteClassName(), startEvent.timeStamp());
        int endIndex = 0;
        int idx = startIndex + 1;
        while (idx < ArrayOps$.MODULE$.size$extension(object = Predef$.MODULE$.refArrayOps((Object[])orderedEvents)) && endIndex == 0) {
            Event event = orderedEvents[idx];
            this.events.$minus$eq((Object)event);
            Event event2 = event;
            if (event2 instanceof TestSucceeded) {
                TestSucceeded e = (TestSucceeded)event2;
                endIndex = idx;
                testcase.time_$eq(e.timeStamp() - testcase.timeStamp());
                continue;
            }
            if (event2 instanceof TestFailed) {
                TestFailed e = (TestFailed)event2;
                endIndex = idx;
                testcase.failure_$eq((Option<TestFailed>)Some$.MODULE$.apply((Object)e));
                testcase.time_$eq(e.timeStamp() - testcase.timeStamp());
                continue;
            }
            if (event2 instanceof TestPending) {
                TestPending e = (TestPending)event2;
                endIndex = idx;
                testcase.pending_$eq(true);
                continue;
            }
            if (event2 instanceof TestCanceled) {
                TestCanceled e = (TestCanceled)event2;
                endIndex = idx;
                testcase.canceled_$eq(true);
                continue;
            }
            if (event2 instanceof SuiteCompleted) {
                SuiteCompleted e = (SuiteCompleted)event2;
                this.unexpected(e);
                continue;
            }
            if (event2 instanceof TestStarting) {
                TestStarting e = (TestStarting)event2;
                this.unexpected(e);
                continue;
            }
            if (event2 instanceof TestIgnored) {
                TestIgnored e = (TestIgnored)event2;
                this.unexpected(e);
                continue;
            }
            if (event2 instanceof InfoProvided) {
                InfoProvided e = (InfoProvided)event2;
                this.unexpected(e);
                continue;
            }
            if (event2 instanceof AlertProvided) {
                AlertProvided e = (AlertProvided)event2;
                this.unexpected(e);
                continue;
            }
            if (event2 instanceof NoteProvided) {
                NoteProvided e = (NoteProvided)event2;
                this.unexpected(e);
                continue;
            }
            if (event2 instanceof ScopeOpened) {
                ScopeOpened e = (ScopeOpened)event2;
                this.unexpected(e);
                continue;
            }
            if (event2 instanceof ScopeClosed) {
                ScopeClosed e = (ScopeClosed)event2;
                this.unexpected(e);
                continue;
            }
            if (event2 instanceof ScopePending) {
                ScopePending e = (ScopePending)event2;
                this.unexpected(e);
                continue;
            }
            if (event2 instanceof MarkupProvided) {
                MarkupProvided e = (MarkupProvided)event2;
                this.unexpected(e);
                continue;
            }
            if (event2 instanceof SuiteStarting) {
                SuiteStarting e = (SuiteStarting)event2;
                this.unexpected(e);
                continue;
            }
            if (event2 instanceof RunStarting) {
                RunStarting e = (RunStarting)event2;
                this.unexpected(e);
                continue;
            }
            if (event2 instanceof RunCompleted) {
                RunCompleted e = (RunCompleted)event2;
                this.unexpected(e);
                continue;
            }
            if (event2 instanceof RunStopped) {
                RunStopped e = (RunStopped)event2;
                this.unexpected(e);
                continue;
            }
            if (event2 instanceof RunAborted) {
                RunAborted e = (RunAborted)event2;
                this.unexpected(e);
                continue;
            }
            if (event2 instanceof SuiteAborted) {
                SuiteAborted e = (SuiteAborted)event2;
                this.unexpected(e);
                continue;
            }
            if (event2 instanceof DiscoveryStarting) {
                DiscoveryStarting e = (DiscoveryStarting)event2;
                this.unexpected(e);
                continue;
            }
            if (event2 instanceof DiscoveryCompleted) {
                DiscoveryCompleted e = (DiscoveryCompleted)event2;
                this.unexpected(e);
                continue;
            }
            throw new MatchError((Object)event2);
        }
        return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)endIndex), (Object)testcase);
    }

    /*
     * WARNING - void declaration
     */
    private Testcase ignoreTest(TestIgnored testIgnoredEvent) {
        void var2_2;
        Testcase testcase = this.Testcase().apply(testIgnoredEvent.testName(), testIgnoredEvent.suiteClassName(), testIgnoredEvent.timeStamp());
        testcase.time_$eq(0L);
        testcase.ignored_$eq(true);
        return var2_2;
    }

    private String xmlify(Testsuite testsuite) {
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("timestamp", String.valueOf(this.formatTimeStamp(testsuite.timeStamp())), (MetaData)$md);
        $md = new UnprefixedAttribute("time", String.valueOf(BoxesRunTime.boxToDouble((double)((double)testsuite.time() / 1000.0))), (MetaData)$md);
        $md = new UnprefixedAttribute("tests", String.valueOf(BoxesRunTime.boxToInteger((int)testsuite.testcases().size())), (MetaData)$md);
        $md = new UnprefixedAttribute("name", String.valueOf(testsuite.name()), (MetaData)$md);
        $md = new UnprefixedAttribute("hostname", String.valueOf(this.findHostname()), (MetaData)$md);
        $md = new UnprefixedAttribute("failures", String.valueOf(BoxesRunTime.boxToInteger((int)testsuite.failures())), (MetaData)$md);
        $md = new UnprefixedAttribute("errors", String.valueOf(BoxesRunTime.boxToInteger((int)testsuite.errors())), (MetaData)$md);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)this.propertiesXml);
        $buf.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus(testsuite.testcases().map((Function1 & Serializable)testcase -> {
            Null$ $md = Null$.MODULE$;
            $md = new UnprefixedAttribute("ignored", String.valueOf(BoxesRunTime.boxToBoolean((boolean)testcase.ignored())), (MetaData)$md);
            $md = new UnprefixedAttribute("pending", String.valueOf(BoxesRunTime.boxToBoolean((boolean)testcase.pending())), (MetaData)$md);
            $md = new UnprefixedAttribute("time", String.valueOf(BoxesRunTime.boxToDouble((double)((double)testcase.time() / 1000.0))), (MetaData)$md);
            $md = new UnprefixedAttribute("classname", String.valueOf(this.strVal(testcase.className())), (MetaData)$md);
            $md = new UnprefixedAttribute("name", String.valueOf(testcase.name()), (MetaData)$md);
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)new Text("\n          "));
            $buf.$amp$plus((Object)this.failureXml(testcase.failure()));
            $buf.$amp$plus((Object)new Text("\n          "));
            return new Elem(null, "testcase", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf));
        }));
        $buf.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text(""));
        $buf.$amp$plus((Object)new Elem(null, "system-out", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf2)));
        $buf.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text(""));
        $buf.$amp$plus((Object)new Elem(null, "system-err", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf3)));
        $buf.$amp$plus((Object)new Text("\n      "));
        Elem xmlVal = new Elem(null, "testsuite", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf));
        PrettyPrinter prettyPrinter = new PrettyPrinter(76, 2);
        String prettified = prettyPrinter.format((Node)xmlVal, prettyPrinter.format$default$2());
        String withCDATA = prettified.replace("<system-out></system-out>", "<system-out><![CDATA[]]></system-out>").replace("<system-err></system-err>", "<system-err><![CDATA[]]></system-err>");
        return new StringBuilder(40).append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n").append(withCDATA).toString();
    }

    public String getStackTrace(Throwable throwable) {
        return new StringBuilder(0).append(throwable).append(Predef$.MODULE$.wrapRefArray((Object[])Array$.MODULE$.concat((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StackTraceElement[][]{throwable.getStackTrace()}), ClassTag$.MODULE$.apply(StackTraceElement.class))).mkString("\n      at ", "\n      at ", "\n")).append(throwable.getCause() != null ? new StringBuilder(13).append("      Cause: ").append(this.getStackTrace(throwable.getCause())).toString() : "").toString();
    }

    private NodeSeq failureXml(Option<TestFailed> failureOption) {
        NodeSeq nodeSeq;
        Option<TestFailed> option = failureOption;
        if (None$.MODULE$.equals(option)) {
            nodeSeq = NodeSeq$.MODULE$.Empty();
        } else if (option instanceof Some) {
            Tuple2 tuple2;
            TestFailed failure = (TestFailed)((Some)option).value();
            Option<Throwable> option2 = failure.throwable();
            if (None$.MODULE$.equals(option2)) {
                tuple2 = Tuple2$.MODULE$.apply((Object)"", (Object)"");
            } else if (option2 instanceof Some) {
                Throwable throwable = (Throwable)((Some)option2).value();
                String throwableType = String.valueOf(throwable.getClass());
                String throwableText = this.getStackTrace(throwable);
                tuple2 = Tuple2$.MODULE$.apply((Object)throwableType, (Object)throwableText);
            } else {
                throw new MatchError(option2);
            }
            Tuple2 tuple22 = tuple2;
            String throwableType = (String)tuple22._1();
            String throwableText = (String)tuple22._2();
            Null$ $md = Null$.MODULE$;
            $md = new UnprefixedAttribute("type", throwableType, (MetaData)$md);
            $md = new UnprefixedAttribute("message", (Seq)Suite$.MODULE$.unparsedXml(failure.message().replaceAll("\n", "&#010;")), (MetaData)$md);
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)new Text("\n          "));
            $buf.$amp$plus((Object)throwableText);
            $buf.$amp$plus((Object)new Text("\n        "));
            Elem elem = new Elem(null, "failure", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf));
            nodeSeq = elem;
        } else {
            throw new MatchError(option);
        }
        return nodeSeq;
    }

    private String strVal(Option<Object> option) {
        String string;
        Option<Object> option2 = option;
        if (option2 instanceof Some) {
            Object x = ((Some)option2).value();
            string = String.valueOf(x);
        } else if (None$.MODULE$.equals(option2)) {
            string = "";
        } else {
            throw new MatchError(option2);
        }
        return string;
    }

    private String findHostname() {
        InetAddress inetAddress;
        try {
            inetAddress = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("unexpected unknown host");
        }
        InetAddress localMachine = inetAddress;
        return localMachine.getHostName();
    }

    private Elem genPropertiesXml() {
        Properties sysprops = System.getProperties();
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text(" "));
        $buf.$amp$plus((Object)this.propertyNames(sysprops).map((Function1 & Serializable)name -> {
            Null$ $md = Null$.MODULE$;
            $md = new UnprefixedAttribute("value", sysprops.getProperty((String)name), (MetaData)$md);
            $md = new UnprefixedAttribute("name", name, (MetaData)$md);
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)new Text("\n          "));
            return new Elem(null, "property", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf));
        }));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "properties", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf));
    }

    private List<String> propertyNames(Properties props) {
        ListBuffer listBuf = new ListBuffer();
        Enumeration<?> enumeration = props.propertyNames();
        while (enumeration.hasMoreElements()) {
            listBuf.$plus$eq((Object)String.valueOf(enumeration.nextElement()));
        }
        return listBuf.toList();
    }

    private String formatTimeStamp(long timeStamp) {
        SimpleDateFormat dateFmt = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat timeFmt = new SimpleDateFormat("HH:mm:ss");
        return new StringBuilder(1).append(dateFmt.format(BoxesRunTime.boxToLong((long)timeStamp))).append("T").append(timeFmt.format(BoxesRunTime.boxToLong((long)timeStamp))).toString();
    }

    public void unexpected(Event event) {
        throw new RuntimeException(new StringBuilder(19).append("unexpected event [").append(event).append("]").toString());
    }

    private final XmlReporter$Testsuite$ Testsuite() {
        return this.Testsuite$lzy1;
    }

    private final XmlReporter$Testcase$ Testcase() {
        return this.Testcase$lzy1;
    }

    public class Testcase
    implements Product,
    Serializable {
        private final String name;
        private final Option className;
        private final long timeStamp;
        private long time;
        private boolean pending;
        private boolean canceled;
        private boolean ignored;
        private Option failure;
        private final /* synthetic */ XmlReporter $outer;

        public Testcase(XmlReporter $outer, String name, Option<String> className, long timeStamp) {
            this.name = name;
            this.className = className;
            this.timeStamp = timeStamp;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            this.time = 0L;
            this.pending = false;
            this.canceled = false;
            this.ignored = false;
            this.failure = None$.MODULE$;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.name()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.className()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.timeStamp()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Testcase)) return false;
            if (((Testcase)object).org$scalatest$tools$XmlReporter$Testcase$$$outer() != this.$outer) return false;
            Testcase testcase = (Testcase)object;
            if (this.timeStamp() != testcase.timeStamp()) return false;
            String string = this.name();
            String string2 = testcase.name();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            Option<String> option = this.className();
            Option<String> option2 = testcase.className();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            if (!testcase.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Testcase;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "Testcase";
        }

        public Object productElement(int n) {
            Object object;
            int n2 = n;
            switch (n2) {
                case 0: {
                    object = this._1();
                    break;
                }
                case 1: {
                    object = this._2();
                    break;
                }
                case 2: {
                    object = BoxesRunTime.boxToLong((long)this._3());
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return object;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            switch (n2) {
                case 0: {
                    string = "name";
                    break;
                }
                case 1: {
                    string = "className";
                    break;
                }
                case 2: {
                    string = "timeStamp";
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return string;
        }

        public String name() {
            return this.name;
        }

        public Option<String> className() {
            return this.className;
        }

        public long timeStamp() {
            return this.timeStamp;
        }

        public long time() {
            return this.time;
        }

        public void time_$eq(long x$1) {
            this.time = x$1;
        }

        public boolean pending() {
            return this.pending;
        }

        public void pending_$eq(boolean x$1) {
            this.pending = x$1;
        }

        public boolean canceled() {
            return this.canceled;
        }

        public void canceled_$eq(boolean x$1) {
            this.canceled = x$1;
        }

        public boolean ignored() {
            return this.ignored;
        }

        public void ignored_$eq(boolean x$1) {
            this.ignored = x$1;
        }

        public Option<TestFailed> failure() {
            return this.failure;
        }

        public void failure_$eq(Option<TestFailed> x$1) {
            this.failure = x$1;
        }

        public Testcase copy(String name, Option<String> className, long timeStamp) {
            return new Testcase(this.$outer, name, className, timeStamp);
        }

        public String copy$default$1() {
            return this.name();
        }

        public Option<String> copy$default$2() {
            return this.className();
        }

        public long copy$default$3() {
            return this.timeStamp();
        }

        public String _1() {
            return this.name();
        }

        public Option<String> _2() {
            return this.className();
        }

        public long _3() {
            return this.timeStamp();
        }

        public final /* synthetic */ XmlReporter org$scalatest$tools$XmlReporter$Testcase$$$outer() {
            return this.$outer;
        }
    }

    public class Testsuite
    implements Product,
    Serializable {
        private final String name;
        private final long timeStamp;
        private int errors;
        private int failures;
        private long time;
        private final ListBuffer testcases;
        private final /* synthetic */ XmlReporter $outer;

        public Testsuite(XmlReporter $outer, String name, long timeStamp) {
            this.name = name;
            this.timeStamp = timeStamp;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            this.errors = 0;
            this.failures = 0;
            this.time = 0L;
            this.testcases = new ListBuffer();
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.name()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.timeStamp()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Testsuite)) return false;
            if (((Testsuite)object).org$scalatest$tools$XmlReporter$Testsuite$$$outer() != this.$outer) return false;
            Testsuite testsuite = (Testsuite)object;
            if (this.timeStamp() != testsuite.timeStamp()) return false;
            String string = this.name();
            String string2 = testsuite.name();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!testsuite.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Testsuite;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Testsuite";
        }

        public Object productElement(int n) {
            Object object;
            int n2 = n;
            if (0 == n2) {
                object = this._1();
            } else if (1 == n2) {
                object = BoxesRunTime.boxToLong((long)this._2());
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return object;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            if (0 == n2) {
                string = "name";
            } else if (1 == n2) {
                string = "timeStamp";
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return string;
        }

        public String name() {
            return this.name;
        }

        public long timeStamp() {
            return this.timeStamp;
        }

        public int errors() {
            return this.errors;
        }

        public void errors_$eq(int x$1) {
            this.errors = x$1;
        }

        public int failures() {
            return this.failures;
        }

        public void failures_$eq(int x$1) {
            this.failures = x$1;
        }

        public long time() {
            return this.time;
        }

        public void time_$eq(long x$1) {
            this.time = x$1;
        }

        public ListBuffer<Testcase> testcases() {
            return this.testcases;
        }

        public Testsuite copy(String name, long timeStamp) {
            return new Testsuite(this.$outer, name, timeStamp);
        }

        public String copy$default$1() {
            return this.name();
        }

        public long copy$default$2() {
            return this.timeStamp();
        }

        public String _1() {
            return this.name();
        }

        public long _2() {
            return this.timeStamp();
        }

        public final /* synthetic */ XmlReporter org$scalatest$tools$XmlReporter$Testsuite$$$outer() {
            return this.$outer;
        }
    }
}

