/*
 * Decompiled with CFR 0.152.
 */
package org.scalatest;

import org.scalactic.Prettifier$;
import org.scalactic.Requirements$;
import org.scalactic.source.Position;
import org.scalatest.Args;
import org.scalatest.Args$;
import org.scalatest.CompositeStatus;
import org.scalatest.Distributor;
import org.scalatest.FailedStatus$;
import org.scalatest.Reporter;
import org.scalatest.Resources$;
import org.scalatest.Status;
import org.scalatest.StepwiseNestedSuiteExecution;
import org.scalatest.Suite;
import org.scalatest.Suite$;
import org.scalatest.events.Formatter;
import org.scalatest.events.Location;
import org.scalatest.events.SeeStackDepthException$;
import org.scalatest.events.SuiteAborted;
import org.scalatest.events.SuiteAborted$;
import org.scalatest.events.SuiteCompleted;
import org.scalatest.events.SuiteCompleted$;
import org.scalatest.events.SuiteStarting;
import org.scalatest.events.SuiteStarting$;
import org.scalatest.events.TopOfClass;
import org.scalatest.tools.Utils$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.ListBuffer;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public abstract class StepwiseNestedSuiteExecution$class {
    public static Status runNestedSuites(StepwiseNestedSuiteExecution $this, Args args) {
        Requirements$.MODULE$.requirementsHelper().macroRequireNonNull((String[])((Object[])new String[]{"args"}), (Object[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{args}), ClassTag$.MODULE$.Any()), Prettifier$.MODULE$.default(), new Position("StepwiseNestedSuiteExecution.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 48));
        Reporter report = Utils$.MODULE$.wrapReporterIfNecessary((Suite)((Object)$this), args.reporter());
        ListBuffer statusBuffer = new ListBuffer();
        if (!args.filter().excludeNestedSuites()) {
            ((Suite)((Object)$this)).nestedSuites().foreach((Function1)new Serializable($this, report, statusBuffer, args){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ StepwiseNestedSuiteExecution $outer;
                private final Reporter report$1;
                private final ListBuffer statusBuffer$1;
                private final Args args$1;

                public final Object apply(Suite nestedSuite) {
                    BoxedUnit boxedUnit;
                    if (this.args$1.stopper().stopRequested()) {
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        Status st = StepwiseNestedSuiteExecution$class.callExecuteOnSuite$1(this.$outer, nestedSuite, this.report$1, this.args$1);
                        boxedUnit = this.statusBuffer$1.$plus$eq((Object)st);
                    }
                    return boxedUnit;
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.report$1 = report$1;
                    this.statusBuffer$1 = statusBuffer$1;
                    this.args$1 = args$1;
                }
            });
        }
        return new CompositeStatus((Set<Status>)((Set)Predef$.MODULE$.Set().empty().$plus$plus((GenTraversableOnce)statusBuffer)));
    }

    public static final Status callExecuteOnSuite$1(StepwiseNestedSuiteExecution $this, Suite nestedSuite, Reporter report$1, Args args$1) {
        Status status;
        if (args$1.stopper().stopRequested()) {
            status = FailedStatus$.MODULE$;
        } else {
            String rawString = "The run method of a nested suite is about to be invoked.";
            Option<Formatter> formatter = Suite$.MODULE$.formatterForSuiteStarting(nestedSuite);
            String suiteClassName = Suite$.MODULE$.getSuiteClassName(nestedSuite);
            long suiteStartTime = System.currentTimeMillis();
            report$1.apply(new SuiteStarting(args$1.tracker().nextOrdinal(), nestedSuite.suiteName(), nestedSuite.suiteId(), (Option<String>)new Some((Object)suiteClassName), formatter, (Option<Location>)new Some((Object)new TopOfClass(nestedSuite.getClass().getName())), nestedSuite.rerunner(), SuiteStarting$.MODULE$.apply$default$8(), SuiteStarting$.MODULE$.apply$default$9(), SuiteStarting$.MODULE$.apply$default$10()));
            try {
                Status status2;
                Status status3 = nestedSuite.run((Option<String>)None$.MODULE$, new Args(report$1, args$1.stopper(), args$1.filter(), args$1.configMap(), args$1.distributor(), args$1.tracker(), (Set<String>)Predef$.MODULE$.Set().empty(), Args$.MODULE$.apply$default$8(), Args$.MODULE$.apply$default$9(), Args$.MODULE$.apply$default$10()));
                String rawString2 = "The run method of a nested suite returned normally.";
                Option<Formatter> formatter2 = Suite$.MODULE$.formatterForSuiteCompleted(nestedSuite);
                Option<Distributor> option = args$1.distributor();
                if (option instanceof Some) {
                    status2 = status3.withAfterEffect((Function0<BoxedUnit>)new Serializable($this, report$1, nestedSuite, suiteClassName, suiteStartTime, formatter2, args$1){
                        public static final long serialVersionUID = 0L;
                        private final Reporter report$1;
                        private final Suite nestedSuite$1;
                        private final String suiteClassName$1;
                        private final long suiteStartTime$1;
                        private final Option formatter$1;
                        private final Args args$1;

                        public final void apply() {
                            this.apply$mcV$sp();
                        }

                        public void apply$mcV$sp() {
                            long duration = System.currentTimeMillis() - this.suiteStartTime$1;
                            this.report$1.apply(new SuiteCompleted(this.args$1.tracker().nextOrdinal(), this.nestedSuite$1.suiteName(), this.nestedSuite$1.suiteId(), (Option<String>)new Some((Object)this.suiteClassName$1), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)duration)), (Option<Formatter>)this.formatter$1, (Option<Location>)new Some((Object)new TopOfClass(this.nestedSuite$1.getClass().getName())), this.nestedSuite$1.rerunner(), SuiteCompleted$.MODULE$.apply$default$9(), SuiteCompleted$.MODULE$.apply$default$10(), SuiteCompleted$.MODULE$.apply$default$11()));
                        }
                        {
                            this.report$1 = report$1;
                            this.nestedSuite$1 = nestedSuite$1;
                            this.suiteClassName$1 = suiteClassName$1;
                            this.suiteStartTime$1 = suiteStartTime$1;
                            this.formatter$1 = formatter$1;
                            this.args$1 = args$1;
                        }
                    });
                } else {
                    None$ none$ = None$.MODULE$;
                    Option<Distributor> option2 = option;
                    if (!(none$ != null ? !none$.equals(option2) : option2 != null)) {
                        long duration = System.currentTimeMillis() - suiteStartTime;
                        report$1.apply(new SuiteCompleted(args$1.tracker().nextOrdinal(), nestedSuite.suiteName(), nestedSuite.suiteId(), (Option<String>)new Some((Object)suiteClassName), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)duration)), formatter2, (Option<Location>)new Some((Object)new TopOfClass(nestedSuite.getClass().getName())), nestedSuite.rerunner(), SuiteCompleted$.MODULE$.apply$default$9(), SuiteCompleted$.MODULE$.apply$default$10(), SuiteCompleted$.MODULE$.apply$default$11()));
                        status2 = BoxedUnit.UNIT;
                    } else {
                        throw new MatchError(option);
                    }
                }
                status = status3;
            }
            catch (RuntimeException runtimeException) {
                String eMessage = runtimeException.getMessage();
                String rawString3 = eMessage != null && eMessage.length() > 0 ? Resources$.MODULE$.executeExceptionWithMessage(eMessage) : "Exception encountered when invoking run on a nested suite.";
                Option<Formatter> formatter3 = Suite$.MODULE$.formatterForSuiteAborted(nestedSuite, rawString3);
                long duration = System.currentTimeMillis() - suiteStartTime;
                report$1.apply(new SuiteAborted(args$1.tracker().nextOrdinal(), rawString3, nestedSuite.suiteName(), nestedSuite.suiteId(), (Option<String>)new Some((Object)suiteClassName), (Option<Throwable>)new Some((Object)runtimeException), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)duration)), formatter3, (Option<Location>)new Some((Object)SeeStackDepthException$.MODULE$), nestedSuite.rerunner(), SuiteAborted$.MODULE$.apply$default$11(), SuiteAborted$.MODULE$.apply$default$12(), SuiteAborted$.MODULE$.apply$default$13()));
                status = FailedStatus$.MODULE$;
            }
        }
        return status;
    }

    public static void $init$(StepwiseNestedSuiteExecution $this) {
    }
}

