package org.scalactic

private[scalactic] object FailureMessages {

def decorateToStringValue(prettifier: org.scalactic.Prettifier, o: Any): String = prettifier.apply(o)

final val bigProblems = Resources.bigProblems

object bigProblemsWithMessage { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.bigProblemsWithMessage(decorateToStringValue(prettifier, param0))
}

object didNotEqual { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.didNotEqual(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object equaled { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.equaled(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object wasPlusOrMinus { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any, param2: Any): String = 
  Resources.wasPlusOrMinus(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1), decorateToStringValue(prettifier, param2))
}

object wasNotPlusOrMinus { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any, param2: Any): String = 
  Resources.wasNotPlusOrMinus(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1), decorateToStringValue(prettifier, param2))
}

final val expressionWasFalse = Resources.expressionWasFalse

final val expressionWasTrue = Resources.expressionWasTrue

object wasNull { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.wasNull(decorateToStringValue(prettifier, param0))
}

object wereNull { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.wereNull(decorateToStringValue(prettifier, param0))
}

final val comma = Resources.comma

object and { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.and(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object wasTrue { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.wasTrue(decorateToStringValue(prettifier, param0))
}

object wasFalse { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.wasFalse(decorateToStringValue(prettifier, param0))
}

object wasLessThan { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.wasLessThan(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object wasNotLessThan { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.wasNotLessThan(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object wasGreaterThan { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.wasGreaterThan(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object wasNotGreaterThan { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.wasNotGreaterThan(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object wasLessThanOrEqualTo { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.wasLessThanOrEqualTo(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object wasNotLessThanOrEqualTo { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.wasNotLessThanOrEqualTo(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object wasGreaterThanOrEqualTo { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.wasGreaterThanOrEqualTo(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object wasNotGreaterThanOrEqualTo { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.wasNotGreaterThanOrEqualTo(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object didNotStartWith { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.didNotStartWith(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object startedWith { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.startedWith(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object didNotEndWith { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.didNotEndWith(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object endedWith { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.endedWith(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object didNotContain { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.didNotContain(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object contained { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.contained(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object didNotContainKey { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.didNotContainKey(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object containedKey { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.containedKey(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object wasTheSameInstanceAs { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.wasTheSameInstanceAs(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object wasNotTheSameInstanceAs { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.wasNotTheSameInstanceAs(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object wasNotEmpty { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.wasNotEmpty(decorateToStringValue(prettifier, param0))
}

object wasEmpty { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.wasEmpty(decorateToStringValue(prettifier, param0))
}

object wasNotInstanceOf { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.wasNotInstanceOf(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object wasInstanceOf { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.wasInstanceOf(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object hadLengthInsteadOfExpectedLength { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any, param2: Any): String = 
  Resources.hadLengthInsteadOfExpectedLength(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1), decorateToStringValue(prettifier, param2))
}

object hadLength { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.hadLength(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object hadSizeInsteadOfExpectedSize { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any, param2: Any): String = 
  Resources.hadSizeInsteadOfExpectedSize(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1), decorateToStringValue(prettifier, param2))
}

object hadSize { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.hadSize(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object commaBut { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.commaBut(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object commaAnd { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.commaAnd(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object variableWasValue { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.variableWasValue(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

final val notValidPosInt = Resources.notValidPosInt

final val notLiteralPosInt = Resources.notLiteralPosInt

final val notValidPosLong = Resources.notValidPosLong

final val notLiteralPosLong = Resources.notLiteralPosLong

final val notValidPosFloat = Resources.notValidPosFloat

final val notLiteralPosFloat = Resources.notLiteralPosFloat

final val notValidPosDouble = Resources.notValidPosDouble

final val notLiteralPosDouble = Resources.notLiteralPosDouble

final val notValidPosZInt = Resources.notValidPosZInt

final val notLiteralPosZInt = Resources.notLiteralPosZInt

final val notValidPosZLong = Resources.notValidPosZLong

final val notLiteralPosZLong = Resources.notLiteralPosZLong

final val notValidPosZFloat = Resources.notValidPosZFloat

final val notLiteralPosZFloat = Resources.notLiteralPosZFloat

final val notValidPosZDouble = Resources.notValidPosZDouble

final val notLiteralPosZDouble = Resources.notLiteralPosZDouble

final val pleaseDefineScalacticFillFilePathnameEnvVar = Resources.pleaseDefineScalacticFillFilePathnameEnvVar

final val notValidNonZeroInt = Resources.notValidNonZeroInt

final val notLiteralNonZeroInt = Resources.notLiteralNonZeroInt

final val notValidNonZeroLong = Resources.notValidNonZeroLong

final val notLiteralNonZeroLong = Resources.notLiteralNonZeroLong

final val notValidNonZeroFloat = Resources.notValidNonZeroFloat

final val notLiteralNonZeroFloat = Resources.notLiteralNonZeroFloat

final val notValidNonZeroDouble = Resources.notValidNonZeroDouble

final val notLiteralNonZeroDouble = Resources.notLiteralNonZeroDouble

final val notValidNegInt = Resources.notValidNegInt

final val notLiteralNegInt = Resources.notLiteralNegInt

final val notValidNegLong = Resources.notValidNegLong

final val notLiteralNegLong = Resources.notLiteralNegLong

final val notValidNegFloat = Resources.notValidNegFloat

final val notLiteralNegFloat = Resources.notLiteralNegFloat

final val notValidNegDouble = Resources.notValidNegDouble

final val notLiteralNegDouble = Resources.notLiteralNegDouble

final val notValidNegZInt = Resources.notValidNegZInt

final val notLiteralNegZInt = Resources.notLiteralNegZInt

final val notValidNegZLong = Resources.notValidNegZLong

final val notLiteralNegZLong = Resources.notLiteralNegZLong

final val notValidNegZFloat = Resources.notValidNegZFloat

final val notLiteralNegZFloat = Resources.notLiteralNegZFloat

final val notValidNegZDouble = Resources.notValidNegZDouble

final val notLiteralNegZDouble = Resources.notLiteralNegZDouble

final val notValidPosFiniteFloat = Resources.notValidPosFiniteFloat

final val notLiteralPosFiniteFloat = Resources.notLiteralPosFiniteFloat

final val notValidPosFiniteDouble = Resources.notValidPosFiniteDouble

final val notLiteralPosFiniteDouble = Resources.notLiteralPosFiniteDouble

final val notValidPosZFiniteFloat = Resources.notValidPosZFiniteFloat

final val notLiteralPosZFiniteFloat = Resources.notLiteralPosZFiniteFloat

final val notValidPosZFiniteDouble = Resources.notValidPosZFiniteDouble

final val notLiteralPosZFiniteDouble = Resources.notLiteralPosZFiniteDouble

final val notValidNegFiniteFloat = Resources.notValidNegFiniteFloat

final val notLiteralNegFiniteFloat = Resources.notLiteralNegFiniteFloat

final val notValidNegFiniteDouble = Resources.notValidNegFiniteDouble

final val notLiteralNegFiniteDouble = Resources.notLiteralNegFiniteDouble

final val notValidNegZFiniteFloat = Resources.notValidNegZFiniteFloat

final val notLiteralNegZFiniteFloat = Resources.notLiteralNegZFiniteFloat

final val notValidNegZFiniteDouble = Resources.notValidNegZFiniteDouble

final val notLiteralNegZFiniteDouble = Resources.notLiteralNegZFiniteDouble

final val notValidNonZeroFiniteFloat = Resources.notValidNonZeroFiniteFloat

final val notLiteralNonZeroFiniteFloat = Resources.notLiteralNonZeroFiniteFloat

final val notValidNonZeroFiniteDouble = Resources.notValidNonZeroFiniteDouble

final val notLiteralNonZeroFiniteDouble = Resources.notLiteralNonZeroFiniteDouble

final val notValidFiniteFloat = Resources.notValidFiniteFloat

final val notLiteralFiniteFloat = Resources.notLiteralFiniteFloat

final val notValidFiniteDouble = Resources.notValidFiniteDouble

final val notLiteralFiniteDouble = Resources.notLiteralFiniteDouble

final val notValidNumericChar = Resources.notValidNumericChar

final val notLiteralNumericChar = Resources.notLiteralNumericChar

object invalidSize { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.invalidSize(decorateToStringValue(prettifier, param0))
}

}
    