package org.scalatest

private[scalatest] object FailureMessages {

def decorateToStringValue(prettifier: org.scalactic.Prettifier, o: Any): String = prettifier.apply(o)

object factExceptionWasThrown { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.factExceptionWasThrown(decorateToStringValue(prettifier, param0))
}

final val factNoExceptionWasThrown = Resources.factNoExceptionWasThrown

object midSentenceFactExceptionWasThrown { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.midSentenceFactExceptionWasThrown(decorateToStringValue(prettifier, param0))
}

final val midSentenceFactNoExceptionWasThrown = Resources.midSentenceFactNoExceptionWasThrown

object exceptionExpected { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.exceptionExpected(decorateToStringValue(prettifier, param0))
}

object expectedExceptionWasThrown { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.expectedExceptionWasThrown(decorateToStringValue(prettifier, param0))
}

object midSentenceExceptionExpected { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.midSentenceExceptionExpected(decorateToStringValue(prettifier, param0))
}

object midSentenceExpectedExceptionWasThrown { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.midSentenceExpectedExceptionWasThrown(decorateToStringValue(prettifier, param0))
}

final val noExceptionWasThrown = Resources.noExceptionWasThrown

object resultWas { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.resultWas(decorateToStringValue(prettifier, param0))
}

object exceptionThrown { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.exceptionThrown(decorateToStringValue(prettifier, param0))
}

object didNotEqual { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.didNotEqual(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object wrongException { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.wrongException(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object midSentenceWrongException { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.midSentenceWrongException(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object anException { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.anException(decorateToStringValue(prettifier, param0))
}

object exceptionNotExpected { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.exceptionNotExpected(decorateToStringValue(prettifier, param0))
}

object expectedButGot { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.expectedButGot(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object expectedAndGot { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.expectedAndGot(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object midSentenceExpectedButGot { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.midSentenceExpectedButGot(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object midSentenceExpectedAndGot { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.midSentenceExpectedAndGot(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

final val conditionFalse = Resources.conditionFalse

final val refNotNull = Resources.refNotNull

final val refNull = Resources.refNull

object floatInfinite { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any, param2: Any): String = 
  Resources.floatInfinite(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1), decorateToStringValue(prettifier, param2))
}

object floatNaN { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any, param2: Any): String = 
  Resources.floatNaN(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1), decorateToStringValue(prettifier, param2))
}

object doubleInfinite { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any, param2: Any): String = 
  Resources.doubleInfinite(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1), decorateToStringValue(prettifier, param2))
}

object doubleNaN { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any, param2: Any): String = 
  Resources.doubleNaN(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1), decorateToStringValue(prettifier, param2))
}

object testEvent { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.testEvent(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object expressionFailed { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.expressionFailed(decorateToStringValue(prettifier, param0))
}

object testFailed { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.testFailed(decorateToStringValue(prettifier, param0))
}

object testStarting { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.testStarting(decorateToStringValue(prettifier, param0))
}

object testSucceeded { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.testSucceeded(decorateToStringValue(prettifier, param0))
}

object testIgnored { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.testIgnored(decorateToStringValue(prettifier, param0))
}

object testPending { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.testPending(decorateToStringValue(prettifier, param0))
}

object testCanceled { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.testCanceled(decorateToStringValue(prettifier, param0))
}

object suiteStarting { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.suiteStarting(decorateToStringValue(prettifier, param0))
}

object suiteCompleted { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.suiteCompleted(decorateToStringValue(prettifier, param0))
}

object suiteAborted { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.suiteAborted(decorateToStringValue(prettifier, param0))
}

final val runAborted = Resources.runAborted

object infoProvided { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.infoProvided(decorateToStringValue(prettifier, param0))
}

object alertProvided { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.alertProvided(decorateToStringValue(prettifier, param0))
}

object noteProvided { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.noteProvided(decorateToStringValue(prettifier, param0))
}

object markupProvided { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.markupProvided(decorateToStringValue(prettifier, param0))
}

object scopeOpened { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.scopeOpened(decorateToStringValue(prettifier, param0))
}

object scopeClosed { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.scopeClosed(decorateToStringValue(prettifier, param0))
}

object scopePending { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.scopePending(decorateToStringValue(prettifier, param0))
}

object payloadToString { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.payloadToString(decorateToStringValue(prettifier, param0))
}

final val noNameSpecified = Resources.noNameSpecified

object runStarting { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.runStarting(decorateToStringValue(prettifier, param0))
}

object rerunStarting { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.rerunStarting(decorateToStringValue(prettifier, param0))
}

object rerunCompleted { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.rerunCompleted(decorateToStringValue(prettifier, param0))
}

object rerunStopped { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.rerunStopped(decorateToStringValue(prettifier, param0))
}

final val friendlyFailure = Resources.friendlyFailure

final val showStackTraceOption = Resources.showStackTraceOption

final val suitebeforeclass = Resources.suitebeforeclass

final val reportTestsStarting = Resources.reportTestsStarting

final val reportTestsSucceeded = Resources.reportTestsSucceeded

final val reportTestsFailed = Resources.reportTestsFailed

final val reportAlerts = Resources.reportAlerts

final val reportInfo = Resources.reportInfo

final val reportStackTraces = Resources.reportStackTraces

final val reportRunStarting = Resources.reportRunStarting

final val reportRunCompleted = Resources.reportRunCompleted

final val reportSummary = Resources.reportSummary

object probarg { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.probarg(decorateToStringValue(prettifier, param0))
}

final val errBuildingDispatchReporter = Resources.errBuildingDispatchReporter

final val missingFileName = Resources.missingFileName

final val missingReporterClassName = Resources.missingReporterClassName

final val errParsingArgs = Resources.errParsingArgs

object invalidConfigOption { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.invalidConfigOption(decorateToStringValue(prettifier, param0))
}

final val cantOpenFile = Resources.cantOpenFile

object reporterThrew { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.reporterThrew(decorateToStringValue(prettifier, param0))
}

final val reporterDisposeThrew = Resources.reporterDisposeThrew

object slowpokeDetectorEventNotFound { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any, param2: Any): String = 
  Resources.slowpokeDetectorEventNotFound(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1), decorateToStringValue(prettifier, param2))
}

final val suiteExecutionStarting = Resources.suiteExecutionStarting

final val executeException = Resources.executeException

object executeExceptionWithMessage { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.executeExceptionWithMessage(decorateToStringValue(prettifier, param0))
}

final val runOnSuiteException = Resources.runOnSuiteException

object runOnSuiteExceptionWithMessage { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.runOnSuiteExceptionWithMessage(decorateToStringValue(prettifier, param0))
}

final val suiteCompletedNormally = Resources.suiteCompletedNormally

object notOneOfTheChosenStyles { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.notOneOfTheChosenStyles(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object notTheChosenStyle { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.notTheChosenStyle(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

final val Rerun = Resources.Rerun

final val executeStopping = Resources.executeStopping

object illegalReporterArg { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.illegalReporterArg(decorateToStringValue(prettifier, param0))
}

object cantLoadReporterClass { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.cantLoadReporterClass(decorateToStringValue(prettifier, param0))
}

object cantInstantiateReporter { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.cantInstantiateReporter(decorateToStringValue(prettifier, param0))
}

object overwriteExistingFile { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.overwriteExistingFile(decorateToStringValue(prettifier, param0))
}

object cannotLoadSuite { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.cannotLoadSuite(decorateToStringValue(prettifier, param0))
}

object cannotLoadDiscoveredSuite { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.cannotLoadDiscoveredSuite(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

final val nonSuite = Resources.nonSuite

object cannotInstantiateSuite { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.cannotInstantiateSuite(decorateToStringValue(prettifier, param0))
}

object cannotLoadClass { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.cannotLoadClass(decorateToStringValue(prettifier, param0))
}

final val bigProblems = Resources.bigProblems

object bigProblemsWithMessage { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.bigProblemsWithMessage(decorateToStringValue(prettifier, param0))
}

final val bigProblemsMaybeCustomReporter = Resources.bigProblemsMaybeCustomReporter

object cannotFindMethod { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.cannotFindMethod(decorateToStringValue(prettifier, param0))
}

object securityWhenRerunning { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.securityWhenRerunning(decorateToStringValue(prettifier, param0))
}

final val overwriteDialogTitle = Resources.overwriteDialogTitle

final val openPrefs = Resources.openPrefs

final val savePrefs = Resources.savePrefs

final val runsFailures = Resources.runsFailures

final val allEvents = Resources.allEvents

final val needFileNameTitle = Resources.needFileNameTitle

final val needFileNameMessage = Resources.needFileNameMessage

final val needClassNameTitle = Resources.needClassNameTitle

final val needClassNameMessage = Resources.needClassNameMessage

final val NoSuitesFoundText = Resources.NoSuitesFoundText

final val cantInvokeExceptionText = Resources.cantInvokeExceptionText

object multipleTestsFailed { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.multipleTestsFailed(decorateToStringValue(prettifier, param0))
}

final val oneTestFailed = Resources.oneTestFailed

final val oneSuiteAborted = Resources.oneSuiteAborted

object multipleSuitesAborted { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.multipleSuitesAborted(decorateToStringValue(prettifier, param0))
}

final val allTestsPassed = Resources.allTestsPassed

final val noTestsWereExecuted = Resources.noTestsWereExecuted

final val eventsLabel = Resources.eventsLabel

final val detailsLabel = Resources.detailsLabel

final val testsRun = Resources.testsRun

final val testsFailed = Resources.testsFailed

final val testsExpected = Resources.testsExpected

final val testsIgnored = Resources.testsIgnored

final val testsPending = Resources.testsPending

final val testsCanceled = Resources.testsCanceled

final val ScalaTestTitle = Resources.ScalaTestTitle

final val ScalaTestMenu = Resources.ScalaTestMenu

final val Run = Resources.Run

final val Stop = Resources.Stop

final val Exit = Resources.Exit

final val About = Resources.About

final val AboutBoxTitle = Resources.AboutBoxTitle

final val AppName = Resources.AppName

final val AppCopyright = Resources.AppCopyright

final val AppURL = Resources.AppURL

final val Reason = Resources.Reason

final val Trademarks = Resources.Trademarks

final val ArtimaInc = Resources.ArtimaInc

final val MoreInfo = Resources.MoreInfo

final val ViewMenu = Resources.ViewMenu

final val JavaSuiteRunnerFile = Resources.JavaSuiteRunnerFile

final val JavaSuiteRunnerFileDescription = Resources.JavaSuiteRunnerFileDescription

final val defaultConfiguration = Resources.defaultConfiguration

final val reporterTypeLabel = Resources.reporterTypeLabel

final val graphicReporterType = Resources.graphicReporterType

final val customReporterType = Resources.customReporterType

final val stdoutReporterType = Resources.stdoutReporterType

final val stderrReporterType = Resources.stderrReporterType

final val fileReporterType = Resources.fileReporterType

object reporterConfigLabel { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.reporterConfigLabel(decorateToStringValue(prettifier, param0))
}

final val unusedField = Resources.unusedField

final val couldntRun = Resources.couldntRun

final val couldntRerun = Resources.couldntRerun

final val MENU_PRESENT_DISCOVERY_STARTING = Resources.MENU_PRESENT_DISCOVERY_STARTING

final val MENU_PRESENT_DISCOVERY_COMPLETED = Resources.MENU_PRESENT_DISCOVERY_COMPLETED

final val MENU_PRESENT_RUN_STARTING = Resources.MENU_PRESENT_RUN_STARTING

final val MENU_PRESENT_TEST_STARTING = Resources.MENU_PRESENT_TEST_STARTING

final val MENU_PRESENT_TEST_FAILED = Resources.MENU_PRESENT_TEST_FAILED

final val MENU_PRESENT_TEST_SUCCEEDED = Resources.MENU_PRESENT_TEST_SUCCEEDED

final val MENU_PRESENT_TEST_IGNORED = Resources.MENU_PRESENT_TEST_IGNORED

final val MENU_PRESENT_TEST_PENDING = Resources.MENU_PRESENT_TEST_PENDING

final val MENU_PRESENT_TEST_CANCELED = Resources.MENU_PRESENT_TEST_CANCELED

final val MENU_PRESENT_SUITE_STARTING = Resources.MENU_PRESENT_SUITE_STARTING

final val MENU_PRESENT_SUITE_ABORTED = Resources.MENU_PRESENT_SUITE_ABORTED

final val MENU_PRESENT_SUITE_COMPLETED = Resources.MENU_PRESENT_SUITE_COMPLETED

final val MENU_PRESENT_INFO_PROVIDED = Resources.MENU_PRESENT_INFO_PROVIDED

final val MENU_PRESENT_ALERT_PROVIDED = Resources.MENU_PRESENT_ALERT_PROVIDED

final val MENU_PRESENT_NOTE_PROVIDED = Resources.MENU_PRESENT_NOTE_PROVIDED

final val MENU_PRESENT_SCOPE_OPENED = Resources.MENU_PRESENT_SCOPE_OPENED

final val MENU_PRESENT_SCOPE_CLOSED = Resources.MENU_PRESENT_SCOPE_CLOSED

final val MENU_PRESENT_SCOPE_PENDING = Resources.MENU_PRESENT_SCOPE_PENDING

final val MENU_PRESENT_MARKUP_PROVIDED = Resources.MENU_PRESENT_MARKUP_PROVIDED

final val MENU_PRESENT_RUN_STOPPED = Resources.MENU_PRESENT_RUN_STOPPED

final val MENU_PRESENT_RUN_ABORTED = Resources.MENU_PRESENT_RUN_ABORTED

final val MENU_PRESENT_RUN_COMPLETED = Resources.MENU_PRESENT_RUN_COMPLETED

final val RUN_STARTING = Resources.RUN_STARTING

final val TEST_STARTING = Resources.TEST_STARTING

final val TEST_FAILED = Resources.TEST_FAILED

final val TEST_SUCCEEDED = Resources.TEST_SUCCEEDED

final val TEST_IGNORED = Resources.TEST_IGNORED

final val TEST_PENDING = Resources.TEST_PENDING

final val TEST_CANCELED = Resources.TEST_CANCELED

final val SUITE_STARTING = Resources.SUITE_STARTING

final val SUITE_ABORTED = Resources.SUITE_ABORTED

final val SUITE_COMPLETED = Resources.SUITE_COMPLETED

final val INFO_PROVIDED = Resources.INFO_PROVIDED

final val ALERT_PROVIDED = Resources.ALERT_PROVIDED

final val NOTE_PROVIDED = Resources.NOTE_PROVIDED

final val SCOPE_OPENED = Resources.SCOPE_OPENED

final val SCOPE_CLOSED = Resources.SCOPE_CLOSED

final val SCOPE_PENDING = Resources.SCOPE_PENDING

final val MARKUP_PROVIDED = Resources.MARKUP_PROVIDED

final val RUN_STOPPED = Resources.RUN_STOPPED

final val RUN_ABORTED = Resources.RUN_ABORTED

final val RUN_COMPLETED = Resources.RUN_COMPLETED

final val DISCOVERY_STARTING = Resources.DISCOVERY_STARTING

final val DISCOVERY_COMPLETED = Resources.DISCOVERY_COMPLETED

final val RERUN_DISCOVERY_STARTING = Resources.RERUN_DISCOVERY_STARTING

final val RERUN_DISCOVERY_COMPLETED = Resources.RERUN_DISCOVERY_COMPLETED

final val RERUN_RUN_STARTING = Resources.RERUN_RUN_STARTING

final val RERUN_TEST_STARTING = Resources.RERUN_TEST_STARTING

final val RERUN_TEST_FAILED = Resources.RERUN_TEST_FAILED

final val RERUN_TEST_SUCCEEDED = Resources.RERUN_TEST_SUCCEEDED

final val RERUN_TEST_IGNORED = Resources.RERUN_TEST_IGNORED

final val RERUN_TEST_PENDING = Resources.RERUN_TEST_PENDING

final val RERUN_TEST_CANCELED = Resources.RERUN_TEST_CANCELED

final val RERUN_SUITE_STARTING = Resources.RERUN_SUITE_STARTING

final val RERUN_SUITE_ABORTED = Resources.RERUN_SUITE_ABORTED

final val RERUN_SUITE_COMPLETED = Resources.RERUN_SUITE_COMPLETED

final val RERUN_INFO_PROVIDED = Resources.RERUN_INFO_PROVIDED

final val RERUN_ALERT_PROVIDED = Resources.RERUN_ALERT_PROVIDED

final val RERUN_NOTE_PROVIDED = Resources.RERUN_NOTE_PROVIDED

final val RERUN_MARKUP_PROVIDED = Resources.RERUN_MARKUP_PROVIDED

final val RERUN_RUN_STOPPED = Resources.RERUN_RUN_STOPPED

final val RERUN_RUN_ABORTED = Resources.RERUN_RUN_ABORTED

final val RERUN_RUN_COMPLETED = Resources.RERUN_RUN_COMPLETED

final val RERUN_SCOPE_OPENED = Resources.RERUN_SCOPE_OPENED

final val RERUN_SCOPE_CLOSED = Resources.RERUN_SCOPE_CLOSED

final val RERUN_SCOPE_PENDING = Resources.RERUN_SCOPE_PENDING

final val DetailsEvent = Resources.DetailsEvent

final val DetailsSuiteId = Resources.DetailsSuiteId

final val DetailsName = Resources.DetailsName

final val DetailsMessage = Resources.DetailsMessage

final val LineNumber = Resources.LineNumber

final val DetailsDate = Resources.DetailsDate

final val DetailsThread = Resources.DetailsThread

final val DetailsThrowable = Resources.DetailsThrowable

final val DetailsCause = Resources.DetailsCause

final val None = Resources.None

final val DetailsDuration = Resources.DetailsDuration

final val DetailsSummary = Resources.DetailsSummary

object should { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.should(decorateToStringValue(prettifier, param0))
}

object itShould { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.itShould(decorateToStringValue(prettifier, param0))
}

object prefixSuffix { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.prefixSuffix(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object prefixShouldSuffix { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.prefixShouldSuffix(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

final val testSucceededIconChar = Resources.testSucceededIconChar

final val testFailedIconChar = Resources.testFailedIconChar

object iconPlusShortName { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.iconPlusShortName(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object iconPlusShortNameAndNote { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any, param2: Any): String = 
  Resources.iconPlusShortNameAndNote(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1), decorateToStringValue(prettifier, param2))
}

final val infoProvidedIconChar = Resources.infoProvidedIconChar

final val markupProvidedIconChar = Resources.markupProvidedIconChar

final val failedNote = Resources.failedNote

final val abortedNote = Resources.abortedNote

object specTextAndNote { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.specTextAndNote(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

final val ignoredNote = Resources.ignoredNote

final val pendingNote = Resources.pendingNote

final val canceledNote = Resources.canceledNote

final val infoProvidedNote = Resources.infoProvidedNote

final val alertProvidedNote = Resources.alertProvidedNote

final val noteProvidedNote = Resources.noteProvidedNote

final val scopeOpenedNote = Resources.scopeOpenedNote

final val scopeClosedNote = Resources.scopeClosedNote

object givenMessage { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.givenMessage(decorateToStringValue(prettifier, param0))
}

object whenMessage { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.whenMessage(decorateToStringValue(prettifier, param0))
}

object thenMessage { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.thenMessage(decorateToStringValue(prettifier, param0))
}

object andMessage { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.andMessage(decorateToStringValue(prettifier, param0))
}

object scenario { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.scenario(decorateToStringValue(prettifier, param0))
}

object commaBut { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.commaBut(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object commaAnd { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.commaAnd(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object commaDoubleAmpersand { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.commaDoubleAmpersand(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object commaDoublePipe { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.commaDoublePipe(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object unaryBang { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.unaryBang(decorateToStringValue(prettifier, param0))
}

object equaled { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.equaled(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object was { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.was(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object wasNot { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.wasNot(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object wasA { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.wasA(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object wasNotA { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.wasNotA(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object wasAn { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.wasAn(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object wasNotAn { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.wasNotAn(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object wasDefinedAt { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.wasDefinedAt(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object wasNotDefinedAt { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.wasNotDefinedAt(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object equaledPlusOrMinus { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any, param2: Any): String = 
  Resources.equaledPlusOrMinus(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1), decorateToStringValue(prettifier, param2))
}

object didNotEqualPlusOrMinus { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any, param2: Any): String = 
  Resources.didNotEqualPlusOrMinus(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1), decorateToStringValue(prettifier, param2))
}

object wasPlusOrMinus { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any, param2: Any): String = 
  Resources.wasPlusOrMinus(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1), decorateToStringValue(prettifier, param2))
}

object wasNotPlusOrMinus { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any, param2: Any): String = 
  Resources.wasNotPlusOrMinus(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1), decorateToStringValue(prettifier, param2))
}

object wasLessThan { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.wasLessThan(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object wasNotLessThan { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.wasNotLessThan(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object wasGreaterThan { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.wasGreaterThan(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object wasNotGreaterThan { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.wasNotGreaterThan(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object wasLessThanOrEqualTo { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.wasLessThanOrEqualTo(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object wasNotLessThanOrEqualTo { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.wasNotLessThanOrEqualTo(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object wasGreaterThanOrEqualTo { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.wasGreaterThanOrEqualTo(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object wasNotGreaterThanOrEqualTo { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.wasNotGreaterThanOrEqualTo(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object wasSameInstanceAs { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.wasSameInstanceAs(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object wasNotSameInstanceAs { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.wasNotSameInstanceAs(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object booleanExpressionWas { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.booleanExpressionWas(decorateToStringValue(prettifier, param0))
}

object booleanExpressionWasNot { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.booleanExpressionWasNot(decorateToStringValue(prettifier, param0))
}

object wasAnInstanceOf { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.wasAnInstanceOf(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object wasNotAnInstanceOf { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any, param2: Any): String = 
  Resources.wasNotAnInstanceOf(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1), decorateToStringValue(prettifier, param2))
}

object wasEmpty { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.wasEmpty(decorateToStringValue(prettifier, param0))
}

object wasNotEmpty { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.wasNotEmpty(decorateToStringValue(prettifier, param0))
}

final val wasNull = Resources.wasNull

final val midSentenceWasNull = Resources.midSentenceWasNull

object wasNotNull { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.wasNotNull(decorateToStringValue(prettifier, param0))
}

final val equaledNull = Resources.equaledNull

final val midSentenceEqualedNull = Resources.midSentenceEqualedNull

object didNotEqualNull { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.didNotEqualNull(decorateToStringValue(prettifier, param0))
}

object wasNone { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.wasNone(decorateToStringValue(prettifier, param0))
}

object wasNotNone { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.wasNotNone(decorateToStringValue(prettifier, param0))
}

object wasNil { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.wasNil(decorateToStringValue(prettifier, param0))
}

object wasNotNil { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.wasNotNil(decorateToStringValue(prettifier, param0))
}

object wasSome { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.wasSome(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object wasNotSome { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.wasNotSome(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object hasNeitherAOrAnMethod { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any, param2: Any): String = 
  Resources.hasNeitherAOrAnMethod(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1), decorateToStringValue(prettifier, param2))
}

object hasNeitherAnOrAnMethod { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any, param2: Any): String = 
  Resources.hasNeitherAnOrAnMethod(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1), decorateToStringValue(prettifier, param2))
}

object hasBothAAndAnMethod { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any, param2: Any): String = 
  Resources.hasBothAAndAnMethod(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1), decorateToStringValue(prettifier, param2))
}

object hasBothAnAndAnMethod { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any, param2: Any): String = 
  Resources.hasBothAnAndAnMethod(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1), decorateToStringValue(prettifier, param2))
}

object didNotEndWith { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.didNotEndWith(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object endedWith { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.endedWith(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object didNotStartWith { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.didNotStartWith(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object startedWith { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.startedWith(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object didNotStartWithRegex { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.didNotStartWithRegex(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object startedWithRegex { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.startedWithRegex(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object startedWithRegexButNotGroup { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any, param2: Any, param3: Any): String = 
  Resources.startedWithRegexButNotGroup(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1), decorateToStringValue(prettifier, param2), decorateToStringValue(prettifier, param3))
}

object startedWithRegexButNotGroupAtIndex { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any, param2: Any, param3: Any, param4: Any): String = 
  Resources.startedWithRegexButNotGroupAtIndex(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1), decorateToStringValue(prettifier, param2), decorateToStringValue(prettifier, param3), decorateToStringValue(prettifier, param4))
}

object startedWithRegexAndGroup { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any, param2: Any): String = 
  Resources.startedWithRegexAndGroup(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1), decorateToStringValue(prettifier, param2))
}

object didNotEndWithRegex { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.didNotEndWithRegex(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object endedWithRegex { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.endedWithRegex(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object endedWithRegexButNotGroup { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any, param2: Any, param3: Any): String = 
  Resources.endedWithRegexButNotGroup(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1), decorateToStringValue(prettifier, param2), decorateToStringValue(prettifier, param3))
}

object endedWithRegexButNotGroupAtIndex { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any, param2: Any, param3: Any, param4: Any): String = 
  Resources.endedWithRegexButNotGroupAtIndex(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1), decorateToStringValue(prettifier, param2), decorateToStringValue(prettifier, param3), decorateToStringValue(prettifier, param4))
}

object endedWithRegexAndGroup { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any, param2: Any): String = 
  Resources.endedWithRegexAndGroup(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1), decorateToStringValue(prettifier, param2))
}

object didNotContainNull { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.didNotContainNull(decorateToStringValue(prettifier, param0))
}

object containedNull { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.containedNull(decorateToStringValue(prettifier, param0))
}

object didNotContainKey { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.didNotContainKey(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object containedKey { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.containedKey(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object didNotContainValue { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.didNotContainValue(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object containedValue { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.containedValue(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object hadSizeInsteadOfExpectedSize { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any, param2: Any): String = 
  Resources.hadSizeInsteadOfExpectedSize(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1), decorateToStringValue(prettifier, param2))
}

object hadSize { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.hadSize(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object hadMessageInsteadOfExpectedMessage { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any, param2: Any): String = 
  Resources.hadMessageInsteadOfExpectedMessage(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1), decorateToStringValue(prettifier, param2))
}

object hadExpectedMessage { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.hadExpectedMessage(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object didNotContainExpectedElement { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.didNotContainExpectedElement(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object containedExpectedElement { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.containedExpectedElement(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object didNotIncludeSubstring { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.didNotIncludeSubstring(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object includedSubstring { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.includedSubstring(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object didNotIncludeRegex { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.didNotIncludeRegex(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object includedRegex { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.includedRegex(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object includedRegexButNotGroup { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any, param2: Any, param3: Any): String = 
  Resources.includedRegexButNotGroup(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1), decorateToStringValue(prettifier, param2), decorateToStringValue(prettifier, param3))
}

object includedRegexButNotGroupAtIndex { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any, param2: Any, param3: Any, param4: Any): String = 
  Resources.includedRegexButNotGroupAtIndex(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1), decorateToStringValue(prettifier, param2), decorateToStringValue(prettifier, param3), decorateToStringValue(prettifier, param4))
}

object includedRegexAndGroup { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any, param2: Any): String = 
  Resources.includedRegexAndGroup(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1), decorateToStringValue(prettifier, param2))
}

object hadLengthInsteadOfExpectedLength { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any, param2: Any): String = 
  Resources.hadLengthInsteadOfExpectedLength(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1), decorateToStringValue(prettifier, param2))
}

object hadLength { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.hadLength(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object didNotFullyMatchRegex { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.didNotFullyMatchRegex(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object fullyMatchedRegex { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.fullyMatchedRegex(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object fullyMatchedRegexButNotGroup { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any, param2: Any, param3: Any): String = 
  Resources.fullyMatchedRegexButNotGroup(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1), decorateToStringValue(prettifier, param2), decorateToStringValue(prettifier, param3))
}

object fullyMatchedRegexButNotGroupAtIndex { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any, param2: Any, param3: Any, param4: Any): String = 
  Resources.fullyMatchedRegexButNotGroupAtIndex(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1), decorateToStringValue(prettifier, param2), decorateToStringValue(prettifier, param3), decorateToStringValue(prettifier, param4))
}

object fullyMatchedRegexAndGroup { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any, param2: Any): String = 
  Resources.fullyMatchedRegexAndGroup(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1), decorateToStringValue(prettifier, param2))
}

object matchResultedInFalse { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.matchResultedInFalse(decorateToStringValue(prettifier, param0))
}

object didNotMatch { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.didNotMatch(decorateToStringValue(prettifier, param0))
}

object matchResultedInTrue { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.matchResultedInTrue(decorateToStringValue(prettifier, param0))
}

object noLengthStructure { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.noLengthStructure(decorateToStringValue(prettifier, param0))
}

object noSizeStructure { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.noSizeStructure(decorateToStringValue(prettifier, param0))
}

object sizeAndGetSize { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.sizeAndGetSize(decorateToStringValue(prettifier, param0))
}

object negativeOrZeroRange { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.negativeOrZeroRange(decorateToStringValue(prettifier, param0))
}

object didNotContainSameElements { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.didNotContainSameElements(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object containedSameElements { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.containedSameElements(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object didNotContainSameElementsInOrder { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.didNotContainSameElementsInOrder(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object containedSameElementsInOrder { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.containedSameElementsInOrder(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object didNotContainAllOfElements { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.didNotContainAllOfElements(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object containedAllOfElements { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.containedAllOfElements(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

final val allOfDuplicate = Resources.allOfDuplicate

object didNotContainAllElementsOf { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.didNotContainAllElementsOf(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object containedAllElementsOf { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.containedAllElementsOf(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object didNotContainAllOfElementsInOrder { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.didNotContainAllOfElementsInOrder(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object containedAllOfElementsInOrder { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.containedAllOfElementsInOrder(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object didNotContainAllElementsOfInOrder { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.didNotContainAllElementsOfInOrder(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object containedAllElementsOfInOrder { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.containedAllElementsOfInOrder(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

final val inOrderDuplicate = Resources.inOrderDuplicate

object didNotContainOneOfElements { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.didNotContainOneOfElements(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object containedOneOfElements { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.containedOneOfElements(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object didNotContainOneElementOf { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.didNotContainOneElementOf(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object containedOneElementOf { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.containedOneElementOf(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object didNotContainAtLeastOneOf { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.didNotContainAtLeastOneOf(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object containedAtLeastOneOf { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.containedAtLeastOneOf(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

final val atLeastOneOfDuplicate = Resources.atLeastOneOfDuplicate

object didNotContainAtLeastOneElementOf { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.didNotContainAtLeastOneElementOf(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object containedAtLeastOneElementOf { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.containedAtLeastOneElementOf(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

final val oneOfDuplicate = Resources.oneOfDuplicate

object didNotContainOnlyElements { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.didNotContainOnlyElements(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object containedOnlyElements { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.containedOnlyElements(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object didNotContainOnlyElementsWithFriendlyReminder { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.didNotContainOnlyElementsWithFriendlyReminder(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object containedOnlyElementsWithFriendlyReminder { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.containedOnlyElementsWithFriendlyReminder(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

final val onlyDuplicate = Resources.onlyDuplicate

final val onlyEmpty = Resources.onlyEmpty

object didNotContainInOrderOnlyElements { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.didNotContainInOrderOnlyElements(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object containedInOrderOnlyElements { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.containedInOrderOnlyElements(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

final val inOrderOnlyDuplicate = Resources.inOrderOnlyDuplicate

final val atMostOneOfDuplicate = Resources.atMostOneOfDuplicate

object didNotContainAtMostOneOf { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.didNotContainAtMostOneOf(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object containedAtMostOneOf { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.containedAtMostOneOf(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

final val atMostOneElementOfDuplicate = Resources.atMostOneElementOfDuplicate

object didNotContainAtMostOneElementOf { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.didNotContainAtMostOneElementOf(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object containedAtMostOneElementOf { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.containedAtMostOneElementOf(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

final val noneOfDuplicate = Resources.noneOfDuplicate

object didNotContainA { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.didNotContainA(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object containedA { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any, param2: Any): String = 
  Resources.containedA(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1), decorateToStringValue(prettifier, param2))
}

object didNotContainAn { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.didNotContainAn(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object containedAn { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any, param2: Any): String = 
  Resources.containedAn(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1), decorateToStringValue(prettifier, param2))
}

object wasNotSorted { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.wasNotSorted(decorateToStringValue(prettifier, param0))
}

object wasSorted { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.wasSorted(decorateToStringValue(prettifier, param0))
}

object wasNotDefined { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.wasNotDefined(decorateToStringValue(prettifier, param0))
}

object wasDefined { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.wasDefined(decorateToStringValue(prettifier, param0))
}

object doesNotExist { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.doesNotExist(decorateToStringValue(prettifier, param0))
}

object exists { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.exists(decorateToStringValue(prettifier, param0))
}

object wasNotReadable { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.wasNotReadable(decorateToStringValue(prettifier, param0))
}

object wasReadable { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.wasReadable(decorateToStringValue(prettifier, param0))
}

object wasNotWritable { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.wasNotWritable(decorateToStringValue(prettifier, param0))
}

object wasWritable { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.wasWritable(decorateToStringValue(prettifier, param0))
}

object didNotMatchTheGivenPattern { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.didNotMatchTheGivenPattern(decorateToStringValue(prettifier, param0))
}

object matchedTheGivenPattern { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.matchedTheGivenPattern(decorateToStringValue(prettifier, param0))
}

object duplicateTestName { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.duplicateTestName(decorateToStringValue(prettifier, param0))
}

final val cantNestFeatureClauses = Resources.cantNestFeatureClauses

final val itCannotAppearInsideAnotherIt = Resources.itCannotAppearInsideAnotherIt

final val itCannotAppearInsideAnotherItOrThey = Resources.itCannotAppearInsideAnotherItOrThey

final val theyCannotAppearInsideAnotherItOrThey = Resources.theyCannotAppearInsideAnotherItOrThey

final val describeCannotAppearInsideAnIt = Resources.describeCannotAppearInsideAnIt

final val ignoreCannotAppearInsideAnIt = Resources.ignoreCannotAppearInsideAnIt

final val ignoreCannotAppearInsideAnItOrAThey = Resources.ignoreCannotAppearInsideAnItOrAThey

final val scenarioCannotAppearInsideAnotherScenario = Resources.scenarioCannotAppearInsideAnotherScenario

final val featureCannotAppearInsideAScenario = Resources.featureCannotAppearInsideAScenario

final val ignoreCannotAppearInsideAScenario = Resources.ignoreCannotAppearInsideAScenario

final val testCannotAppearInsideAnotherTest = Resources.testCannotAppearInsideAnotherTest

final val propertyCannotAppearInsideAnotherProperty = Resources.propertyCannotAppearInsideAnotherProperty

final val ignoreCannotAppearInsideATest = Resources.ignoreCannotAppearInsideATest

final val ignoreCannotAppearInsideAProperty = Resources.ignoreCannotAppearInsideAProperty

final val shouldCannotAppearInsideAnIn = Resources.shouldCannotAppearInsideAnIn

final val mustCannotAppearInsideAnIn = Resources.mustCannotAppearInsideAnIn

final val whenCannotAppearInsideAnIn = Resources.whenCannotAppearInsideAnIn

final val thatCannotAppearInsideAnIn = Resources.thatCannotAppearInsideAnIn

final val whichCannotAppearInsideAnIn = Resources.whichCannotAppearInsideAnIn

final val canCannotAppearInsideAnIn = Resources.canCannotAppearInsideAnIn

final val behaviorOfCannotAppearInsideAnIn = Resources.behaviorOfCannotAppearInsideAnIn

final val dashCannotAppearInsideAnIn = Resources.dashCannotAppearInsideAnIn

final val inCannotAppearInsideAnotherIn = Resources.inCannotAppearInsideAnotherIn

final val inCannotAppearInsideAnotherInOrIs = Resources.inCannotAppearInsideAnotherInOrIs

final val isCannotAppearInsideAnotherInOrIs = Resources.isCannotAppearInsideAnotherInOrIs

final val ignoreCannotAppearInsideAnIn = Resources.ignoreCannotAppearInsideAnIn

final val ignoreCannotAppearInsideAnInOrAnIs = Resources.ignoreCannotAppearInsideAnInOrAnIs

final val registrationAlreadyClosed = Resources.registrationAlreadyClosed

final val itMustAppearAfterTopLevelSubject = Resources.itMustAppearAfterTopLevelSubject

final val theyMustAppearAfterTopLevelSubject = Resources.theyMustAppearAfterTopLevelSubject

object allPropertiesHadExpectedValues { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.allPropertiesHadExpectedValues(decorateToStringValue(prettifier, param0))
}

object midSentenceAllPropertiesHadExpectedValues { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.midSentenceAllPropertiesHadExpectedValues(decorateToStringValue(prettifier, param0))
}

object propertyHadExpectedValue { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any, param2: Any): String = 
  Resources.propertyHadExpectedValue(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1), decorateToStringValue(prettifier, param2))
}

object midSentencePropertyHadExpectedValue { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any, param2: Any): String = 
  Resources.midSentencePropertyHadExpectedValue(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1), decorateToStringValue(prettifier, param2))
}

object propertyDidNotHaveExpectedValue { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any, param2: Any, param3: Any): String = 
  Resources.propertyDidNotHaveExpectedValue(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1), decorateToStringValue(prettifier, param2), decorateToStringValue(prettifier, param3))
}

object midSentencePropertyDidNotHaveExpectedValue { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any, param2: Any, param3: Any): String = 
  Resources.midSentencePropertyDidNotHaveExpectedValue(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1), decorateToStringValue(prettifier, param2), decorateToStringValue(prettifier, param3))
}

object propertyNotFound { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any, param2: Any): String = 
  Resources.propertyNotFound(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1), decorateToStringValue(prettifier, param2))
}

final val propertyCheckSucceeded = Resources.propertyCheckSucceeded

final val lengthPropertyNotAnInteger = Resources.lengthPropertyNotAnInteger

final val sizePropertyNotAnInteger = Resources.sizePropertyNotAnInteger

object wasEqualTo { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.wasEqualTo(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object wasNotEqualTo { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.wasNotEqualTo(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object printedReportPlusLineNumber { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.printedReportPlusLineNumber(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object printedReportPlusPath { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.printedReportPlusPath(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object propertyFailed { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.propertyFailed(decorateToStringValue(prettifier, param0))
}

object propertyExhausted { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.propertyExhausted(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

final val undecoratedPropertyCheckFailureMessage = Resources.undecoratedPropertyCheckFailureMessage

object propertyException { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.propertyException(decorateToStringValue(prettifier, param0))
}

object generatorException { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.generatorException(decorateToStringValue(prettifier, param0))
}

object thrownExceptionsMessage { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.thrownExceptionsMessage(decorateToStringValue(prettifier, param0))
}

object thrownExceptionsLocation { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.thrownExceptionsLocation(decorateToStringValue(prettifier, param0))
}

object propCheckExhausted { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.propCheckExhausted(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object propCheckExhaustedAfterOne { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.propCheckExhaustedAfterOne(decorateToStringValue(prettifier, param0))
}

object occurredAtRow { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.occurredAtRow(decorateToStringValue(prettifier, param0))
}

final val occurredOnValues = Resources.occurredOnValues

final val propCheckLabel = Resources.propCheckLabel

final val propCheckLabels = Resources.propCheckLabels

object suiteAndTestNamesFormattedForDisplay { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.suiteAndTestNamesFormattedForDisplay(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object initSeed { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.initSeed(decorateToStringValue(prettifier, param0))
}

object notLoneElement { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.notLoneElement(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object testSummary { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any, param2: Any, param3: Any, param4: Any): String = 
  Resources.testSummary(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1), decorateToStringValue(prettifier, param2), decorateToStringValue(prettifier, param3), decorateToStringValue(prettifier, param4))
}

object suiteSummary { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.suiteSummary(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object suiteScopeSummary { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any, param2: Any): String = 
  Resources.suiteScopeSummary(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1), decorateToStringValue(prettifier, param2))
}

object runCompletedIn { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.runCompletedIn(decorateToStringValue(prettifier, param0))
}

final val runCompleted = Resources.runCompleted

object runAbortedIn { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.runAbortedIn(decorateToStringValue(prettifier, param0))
}

object runStoppedIn { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.runStoppedIn(decorateToStringValue(prettifier, param0))
}

final val runStopped = Resources.runStopped

object totalNumberOfTestsRun { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.totalNumberOfTestsRun(decorateToStringValue(prettifier, param0))
}

final val oneMillisecond = Resources.oneMillisecond

object milliseconds { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.milliseconds(decorateToStringValue(prettifier, param0))
}

final val oneSecond = Resources.oneSecond

final val oneSecondOneMillisecond = Resources.oneSecondOneMillisecond

object oneSecondMilliseconds { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.oneSecondMilliseconds(decorateToStringValue(prettifier, param0))
}

object seconds { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.seconds(decorateToStringValue(prettifier, param0))
}

object secondsMilliseconds { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.secondsMilliseconds(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

final val oneMinute = Resources.oneMinute

final val oneMinuteOneSecond = Resources.oneMinuteOneSecond

object oneMinuteSeconds { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.oneMinuteSeconds(decorateToStringValue(prettifier, param0))
}

object minutes { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.minutes(decorateToStringValue(prettifier, param0))
}

object minutesOneSecond { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.minutesOneSecond(decorateToStringValue(prettifier, param0))
}

object minutesSeconds { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.minutesSeconds(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

final val oneHour = Resources.oneHour

final val oneHourOneSecond = Resources.oneHourOneSecond

object oneHourSeconds { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.oneHourSeconds(decorateToStringValue(prettifier, param0))
}

final val oneHourOneMinute = Resources.oneHourOneMinute

final val oneHourOneMinuteOneSecond = Resources.oneHourOneMinuteOneSecond

object oneHourOneMinuteSeconds { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.oneHourOneMinuteSeconds(decorateToStringValue(prettifier, param0))
}

object oneHourMinutes { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.oneHourMinutes(decorateToStringValue(prettifier, param0))
}

object oneHourMinutesOneSecond { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.oneHourMinutesOneSecond(decorateToStringValue(prettifier, param0))
}

object oneHourMinutesSeconds { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.oneHourMinutesSeconds(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object hours { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.hours(decorateToStringValue(prettifier, param0))
}

object hoursOneSecond { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.hoursOneSecond(decorateToStringValue(prettifier, param0))
}

object hoursSeconds { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.hoursSeconds(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object hoursOneMinute { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.hoursOneMinute(decorateToStringValue(prettifier, param0))
}

object hoursOneMinuteOneSecond { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.hoursOneMinuteOneSecond(decorateToStringValue(prettifier, param0))
}

object hoursOneMinuteSeconds { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.hoursOneMinuteSeconds(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object hoursMinutes { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.hoursMinutes(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object hoursMinutesOneSecond { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.hoursMinutesOneSecond(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object hoursMinutesSeconds { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any, param2: Any): String = 
  Resources.hoursMinutesSeconds(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1), decorateToStringValue(prettifier, param2))
}

object withDuration { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.withDuration(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object feature { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.feature(decorateToStringValue(prettifier, param0))
}

object needFixtureInTestName { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.needFixtureInTestName(decorateToStringValue(prettifier, param0))
}

object testNotFound { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.testNotFound(decorateToStringValue(prettifier, param0))
}

final val pendingUntilFixed = Resources.pendingUntilFixed

final val dashXDeprecated = Resources.dashXDeprecated

final val threadCalledAfterConductingHasCompleted = Resources.threadCalledAfterConductingHasCompleted

final val cannotInvokeWhenFinishedAfterConduct = Resources.cannotInvokeWhenFinishedAfterConduct

object cantRegisterThreadsWithSameName { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.cantRegisterThreadsWithSameName(decorateToStringValue(prettifier, param0))
}

final val cannotCallConductTwice = Resources.cannotCallConductTwice

final val cannotWaitForBeatZero = Resources.cannotWaitForBeatZero

final val cannotWaitForNegativeBeat = Resources.cannotWaitForNegativeBeat

object cannotPassNonPositiveClockPeriod { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.cannotPassNonPositiveClockPeriod(decorateToStringValue(prettifier, param0))
}

object cannotPassNonPositiveTimeout { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.cannotPassNonPositiveTimeout(decorateToStringValue(prettifier, param0))
}

final val whenFinishedCanOnlyBeCalledByMainThread = Resources.whenFinishedCanOnlyBeCalledByMainThread

object suspectedDeadlock { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.suspectedDeadlock(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object testTimedOut { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.testTimedOut(decorateToStringValue(prettifier, param0))
}

object suspectedDeadlockDEPRECATED { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.suspectedDeadlockDEPRECATED(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object testTimedOutDEPRECATED { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.testTimedOutDEPRECATED(decorateToStringValue(prettifier, param0))
}

object concurrentInformerMod { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.concurrentInformerMod(decorateToStringValue(prettifier, param0))
}

object concurrentNotifierMod { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.concurrentNotifierMod(decorateToStringValue(prettifier, param0))
}

object concurrentAlerterMod { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.concurrentAlerterMod(decorateToStringValue(prettifier, param0))
}

object concurrentDocumenterMod { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.concurrentDocumenterMod(decorateToStringValue(prettifier, param0))
}

object cantCallInfoNow { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.cantCallInfoNow(decorateToStringValue(prettifier, param0))
}

object cantCallMarkupNow { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.cantCallMarkupNow(decorateToStringValue(prettifier, param0))
}

final val concurrentFunSuiteMod = Resources.concurrentFunSuiteMod

final val concurrentPropSpecMod = Resources.concurrentPropSpecMod

final val concurrentFixtureFunSuiteMod = Resources.concurrentFixtureFunSuiteMod

final val concurrentFixturePropSpecMod = Resources.concurrentFixturePropSpecMod

final val concurrentSpecMod = Resources.concurrentSpecMod

final val concurrentFreeSpecMod = Resources.concurrentFreeSpecMod

final val concurrentFixtureSpecMod = Resources.concurrentFixtureSpecMod

final val concurrentFlatSpecMod = Resources.concurrentFlatSpecMod

final val concurrentFixtureFlatSpecMod = Resources.concurrentFixtureFlatSpecMod

final val concurrentWordSpecMod = Resources.concurrentWordSpecMod

final val concurrentFixtureWordSpecMod = Resources.concurrentFixtureWordSpecMod

final val concurrentFixtureFreeSpecMod = Resources.concurrentFixtureFreeSpecMod

final val concurrentFeatureSpecMod = Resources.concurrentFeatureSpecMod

final val concurrentFixtureFeatureSpecMod = Resources.concurrentFixtureFeatureSpecMod

final val concurrentDocSpecMod = Resources.concurrentDocSpecMod

object tryNotAFailure { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.tryNotAFailure(decorateToStringValue(prettifier, param0))
}

object tryNotASuccess { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.tryNotASuccess(decorateToStringValue(prettifier, param0))
}

final val optionValueNotDefined = Resources.optionValueNotDefined

object eitherLeftValueNotDefined { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.eitherLeftValueNotDefined(decorateToStringValue(prettifier, param0))
}

object eitherRightValueNotDefined { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.eitherRightValueNotDefined(decorateToStringValue(prettifier, param0))
}

object eitherValueNotDefined { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.eitherValueNotDefined(decorateToStringValue(prettifier, param0))
}

object partialFunctionValueNotDefined { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.partialFunctionValueNotDefined(decorateToStringValue(prettifier, param0))
}

object insidePartialFunctionNotDefined { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.insidePartialFunctionNotDefined(decorateToStringValue(prettifier, param0))
}

object insidePartialFunctionAppendSomeMsg { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any, param2: Any): String = 
  Resources.insidePartialFunctionAppendSomeMsg(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1), decorateToStringValue(prettifier, param2))
}

object insidePartialFunctionAppendNone { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.insidePartialFunctionAppendNone(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object didNotEventuallySucceed { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.didNotEventuallySucceed(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object didNotEventuallySucceedBecause { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any, param2: Any): String = 
  Resources.didNotEventuallySucceedBecause(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1), decorateToStringValue(prettifier, param2))
}

object didNotUltimatelySucceed { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.didNotUltimatelySucceed(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object didNotUltimatelySucceedBecause { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any, param2: Any): String = 
  Resources.didNotUltimatelySucceedBecause(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1), decorateToStringValue(prettifier, param2))
}

object wasNeverReady { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.wasNeverReady(decorateToStringValue(prettifier, param0))
}

final val awaitMustBeCalledOnCreatingThread = Resources.awaitMustBeCalledOnCreatingThread

final val awaitTimedOut = Resources.awaitTimedOut

object futureReturnedAnException { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.futureReturnedAnException(decorateToStringValue(prettifier, param0))
}

object futureReturnedAnExceptionWithMessage { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.futureReturnedAnExceptionWithMessage(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

final val futureWasCanceled = Resources.futureWasCanceled

object futureExpired { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.futureExpired(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object timeoutFailedAfter { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.timeoutFailedAfter(decorateToStringValue(prettifier, param0))
}

object timeoutFailingAfter { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.timeoutFailingAfter(decorateToStringValue(prettifier, param0))
}

object timeoutCanceledAfter { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.timeoutCanceledAfter(decorateToStringValue(prettifier, param0))
}

object timeoutCancelingAfter { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.timeoutCancelingAfter(decorateToStringValue(prettifier, param0))
}

object testTimeLimitExceeded { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.testTimeLimitExceeded(decorateToStringValue(prettifier, param0))
}

object singularNanosecondUnits { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.singularNanosecondUnits(decorateToStringValue(prettifier, param0))
}

object pluralNanosecondUnits { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.pluralNanosecondUnits(decorateToStringValue(prettifier, param0))
}

object singularMicrosecondUnits { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.singularMicrosecondUnits(decorateToStringValue(prettifier, param0))
}

object pluralMicrosecondUnits { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.pluralMicrosecondUnits(decorateToStringValue(prettifier, param0))
}

object singularMillisecondUnits { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.singularMillisecondUnits(decorateToStringValue(prettifier, param0))
}

object pluralMillisecondUnits { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.pluralMillisecondUnits(decorateToStringValue(prettifier, param0))
}

object singularSecondUnits { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.singularSecondUnits(decorateToStringValue(prettifier, param0))
}

object pluralSecondUnits { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.pluralSecondUnits(decorateToStringValue(prettifier, param0))
}

object singularMinuteUnits { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.singularMinuteUnits(decorateToStringValue(prettifier, param0))
}

object pluralMinuteUnits { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.pluralMinuteUnits(decorateToStringValue(prettifier, param0))
}

object singularHourUnits { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.singularHourUnits(decorateToStringValue(prettifier, param0))
}

object pluralHourUnits { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.pluralHourUnits(decorateToStringValue(prettifier, param0))
}

object singularDayUnits { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.singularDayUnits(decorateToStringValue(prettifier, param0))
}

object pluralDayUnits { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.pluralDayUnits(decorateToStringValue(prettifier, param0))
}

object leftAndRight { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.leftAndRight(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object leftCommaAndRight { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.leftCommaAndRight(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object configMapEntryNotFound { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.configMapEntryNotFound(decorateToStringValue(prettifier, param0))
}

object configMapEntryHadUnexpectedType { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any, param2: Any, param3: Any): String = 
  Resources.configMapEntryHadUnexpectedType(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1), decorateToStringValue(prettifier, param2), decorateToStringValue(prettifier, param3))
}

object forAssertionsMoreThanZero { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.forAssertionsMoreThanZero(decorateToStringValue(prettifier, param0))
}

object forAssertionsMoreThanEqualZero { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.forAssertionsMoreThanEqualZero(decorateToStringValue(prettifier, param0))
}

object forAssertionsMoreThan { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.forAssertionsMoreThan(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object forAssertionsGenTraversableMessageWithStackDepth { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any, param2: Any): String = 
  Resources.forAssertionsGenTraversableMessageWithStackDepth(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1), decorateToStringValue(prettifier, param2))
}

object forAssertionsGenTraversableMessageWithoutStackDepth { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.forAssertionsGenTraversableMessageWithoutStackDepth(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object forAssertionsGenMapMessageWithStackDepth { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any, param2: Any): String = 
  Resources.forAssertionsGenMapMessageWithStackDepth(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1), decorateToStringValue(prettifier, param2))
}

object forAssertionsGenMapMessageWithoutStackDepth { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.forAssertionsGenMapMessageWithoutStackDepth(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

final val forAssertionsNoElement = Resources.forAssertionsNoElement

object forAssertionsElement { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.forAssertionsElement(decorateToStringValue(prettifier, param0))
}

object forAssertionsElements { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.forAssertionsElements(decorateToStringValue(prettifier, param0))
}

object forAssertionsIndexLabel { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.forAssertionsIndexLabel(decorateToStringValue(prettifier, param0))
}

object forAssertionsIndexAndLabel { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.forAssertionsIndexAndLabel(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object forAssertionsKeyLabel { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.forAssertionsKeyLabel(decorateToStringValue(prettifier, param0))
}

object forAssertionsKeyAndLabel { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.forAssertionsKeyAndLabel(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object forAllFailed { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.forAllFailed(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object allShorthandFailed { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.allShorthandFailed(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object forAtLeastFailedNoElement { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any, param2: Any): String = 
  Resources.forAtLeastFailedNoElement(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1), decorateToStringValue(prettifier, param2))
}

object forAtLeastFailed { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any, param2: Any, param3: Any): String = 
  Resources.forAtLeastFailed(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1), decorateToStringValue(prettifier, param2), decorateToStringValue(prettifier, param3))
}

object atLeastShorthandFailedNoElement { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any, param2: Any): String = 
  Resources.atLeastShorthandFailedNoElement(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1), decorateToStringValue(prettifier, param2))
}

object atLeastShorthandFailed { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any, param2: Any, param3: Any): String = 
  Resources.atLeastShorthandFailed(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1), decorateToStringValue(prettifier, param2), decorateToStringValue(prettifier, param3))
}

object forAtMostFailed { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any, param2: Any, param3: Any): String = 
  Resources.forAtMostFailed(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1), decorateToStringValue(prettifier, param2), decorateToStringValue(prettifier, param3))
}

object atMostShorthandFailed { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any, param2: Any, param3: Any): String = 
  Resources.atMostShorthandFailed(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1), decorateToStringValue(prettifier, param2), decorateToStringValue(prettifier, param3))
}

object forExactlyFailedNoElement { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any, param2: Any): String = 
  Resources.forExactlyFailedNoElement(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1), decorateToStringValue(prettifier, param2))
}

object forExactlyFailedLess { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any, param2: Any, param3: Any, param4: Any): String = 
  Resources.forExactlyFailedLess(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1), decorateToStringValue(prettifier, param2), decorateToStringValue(prettifier, param3), decorateToStringValue(prettifier, param4))
}

object forExactlyFailedMore { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any, param2: Any, param3: Any): String = 
  Resources.forExactlyFailedMore(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1), decorateToStringValue(prettifier, param2), decorateToStringValue(prettifier, param3))
}

object exactlyShorthandFailedNoElement { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any, param2: Any): String = 
  Resources.exactlyShorthandFailedNoElement(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1), decorateToStringValue(prettifier, param2))
}

object exactlyShorthandFailedLess { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any, param2: Any, param3: Any, param4: Any): String = 
  Resources.exactlyShorthandFailedLess(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1), decorateToStringValue(prettifier, param2), decorateToStringValue(prettifier, param3), decorateToStringValue(prettifier, param4))
}

object exactlyShorthandFailedMore { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any, param2: Any, param3: Any): String = 
  Resources.exactlyShorthandFailedMore(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1), decorateToStringValue(prettifier, param2), decorateToStringValue(prettifier, param3))
}

object forNoFailed { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.forNoFailed(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object noShorthandFailed { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.noShorthandFailed(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object forBetweenFailedNoElement { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any, param2: Any, param3: Any): String = 
  Resources.forBetweenFailedNoElement(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1), decorateToStringValue(prettifier, param2), decorateToStringValue(prettifier, param3))
}

object forBetweenFailedLess { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any, param2: Any, param3: Any, param4: Any, param5: Any): String = 
  Resources.forBetweenFailedLess(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1), decorateToStringValue(prettifier, param2), decorateToStringValue(prettifier, param3), decorateToStringValue(prettifier, param4), decorateToStringValue(prettifier, param5))
}

object forBetweenFailedMore { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any, param2: Any, param3: Any, param4: Any): String = 
  Resources.forBetweenFailedMore(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1), decorateToStringValue(prettifier, param2), decorateToStringValue(prettifier, param3), decorateToStringValue(prettifier, param4))
}

object betweenShorthandFailedNoElement { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any, param2: Any, param3: Any): String = 
  Resources.betweenShorthandFailedNoElement(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1), decorateToStringValue(prettifier, param2), decorateToStringValue(prettifier, param3))
}

object betweenShorthandFailedLess { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any, param2: Any, param3: Any, param4: Any, param5: Any): String = 
  Resources.betweenShorthandFailedLess(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1), decorateToStringValue(prettifier, param2), decorateToStringValue(prettifier, param3), decorateToStringValue(prettifier, param4), decorateToStringValue(prettifier, param5))
}

object betweenShorthandFailedMore { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any, param2: Any, param3: Any, param4: Any): String = 
  Resources.betweenShorthandFailedMore(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1), decorateToStringValue(prettifier, param2), decorateToStringValue(prettifier, param3), decorateToStringValue(prettifier, param4))
}

object forEveryFailed { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.forEveryFailed(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object everyShorthandFailed { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.everyShorthandFailed(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

final val discoveryStarting = Resources.discoveryStarting

final val discoveryCompleted = Resources.discoveryCompleted

object discoveryCompletedIn { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.discoveryCompletedIn(decorateToStringValue(prettifier, param0))
}

final val doingDiscovery = Resources.doingDiscovery

final val atCheckpointAt = Resources.atCheckpointAt

object slowpokeDetected { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any, param2: Any): String = 
  Resources.slowpokeDetected(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1), decorateToStringValue(prettifier, param2))
}

object alertFormattedText { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.alertFormattedText(decorateToStringValue(prettifier, param0))
}

object noteFormattedText { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.noteFormattedText(decorateToStringValue(prettifier, param0))
}

final val testFlickered = Resources.testFlickered

object cannotRerun { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any, param2: Any): String = 
  Resources.cannotRerun(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1), decorateToStringValue(prettifier, param2))
}

final val testCannotBeNestedInsideAnotherTest = Resources.testCannotBeNestedInsideAnotherTest

final val nonEmptyMatchPatternCase = Resources.nonEmptyMatchPatternCase

object expectedTypeErrorButGotNone { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.expectedTypeErrorButGotNone(decorateToStringValue(prettifier, param0))
}

object gotTypeErrorAsExpected { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.gotTypeErrorAsExpected(decorateToStringValue(prettifier, param0))
}

object expectedCompileErrorButGotNone { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.expectedCompileErrorButGotNone(decorateToStringValue(prettifier, param0))
}

object didNotCompile { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.didNotCompile(decorateToStringValue(prettifier, param0))
}

object compiledSuccessfully { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.compiledSuccessfully(decorateToStringValue(prettifier, param0))
}

object expectedTypeErrorButGotParseError { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.expectedTypeErrorButGotParseError(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object expectedNoErrorButGotTypeError { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.expectedNoErrorButGotTypeError(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object expectedNoErrorButGotParseError { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.expectedNoErrorButGotParseError(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

final val anExpressionOfTypeNullIsIneligibleForImplicitConversion = Resources.anExpressionOfTypeNullIsIneligibleForImplicitConversion

final val beTripleEqualsNotAllowed = Resources.beTripleEqualsNotAllowed

final val assertionShouldBePutInsideItOrTheyClauseNotDescribeClause = Resources.assertionShouldBePutInsideItOrTheyClauseNotDescribeClause

object exceptionWasThrownInDescribeClause { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any, param2: Any): String = 
  Resources.exceptionWasThrownInDescribeClause(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1), decorateToStringValue(prettifier, param2))
}

final val assertionShouldBePutInsideInClauseNotDashClause = Resources.assertionShouldBePutInsideInClauseNotDashClause

object exceptionWasThrownInDashClause { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any, param2: Any): String = 
  Resources.exceptionWasThrownInDashClause(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1), decorateToStringValue(prettifier, param2))
}

final val assertionShouldBePutInsideScenarioClauseNotFeatureClause = Resources.assertionShouldBePutInsideScenarioClauseNotFeatureClause

object exceptionWasThrownInFeatureClause { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any, param2: Any): String = 
  Resources.exceptionWasThrownInFeatureClause(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1), decorateToStringValue(prettifier, param2))
}

final val assertionShouldBePutInsideItOrTheyClauseNotShouldMustWhenThatWhichOrCanClause = Resources.assertionShouldBePutInsideItOrTheyClauseNotShouldMustWhenThatWhichOrCanClause

object exceptionWasThrownInShouldClause { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any, param2: Any): String = 
  Resources.exceptionWasThrownInShouldClause(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1), decorateToStringValue(prettifier, param2))
}

object exceptionWasThrownInMustClause { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any, param2: Any): String = 
  Resources.exceptionWasThrownInMustClause(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1), decorateToStringValue(prettifier, param2))
}

object exceptionWasThrownInWhenClause { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any, param2: Any): String = 
  Resources.exceptionWasThrownInWhenClause(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1), decorateToStringValue(prettifier, param2))
}

object exceptionWasThrownInThatClause { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any, param2: Any): String = 
  Resources.exceptionWasThrownInThatClause(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1), decorateToStringValue(prettifier, param2))
}

object exceptionWasThrownInWhichClause { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any, param2: Any): String = 
  Resources.exceptionWasThrownInWhichClause(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1), decorateToStringValue(prettifier, param2))
}

object exceptionWasThrownInCanClause { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any, param2: Any): String = 
  Resources.exceptionWasThrownInCanClause(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1), decorateToStringValue(prettifier, param2))
}

final val assertionShouldBePutInsideDefNotObject = Resources.assertionShouldBePutInsideDefNotObject

object exceptionWasThrownInObject { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.exceptionWasThrownInObject(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object tableDrivenForEveryFailed { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.tableDrivenForEveryFailed(decorateToStringValue(prettifier, param0))
}

object tableDrivenExistsFailed { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.tableDrivenExistsFailed(decorateToStringValue(prettifier, param0))
}

final val withFixtureNotAllowedInAsyncFixtures = Resources.withFixtureNotAllowedInAsyncFixtures

object leftParensCommaBut { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.leftParensCommaBut(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object rightParensCommaBut { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.rightParensCommaBut(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object bothParensCommaBut { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.bothParensCommaBut(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object leftParensCommaAnd { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.leftParensCommaAnd(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object rightParensCommaAnd { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.rightParensCommaAnd(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object bothParensCommaAnd { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.bothParensCommaAnd(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

final val assertionWasTrue = Resources.assertionWasTrue

object fromEqualToToHavingLengthsBetween { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.fromEqualToToHavingLengthsBetween(decorateToStringValue(prettifier, param0))
}

object fromGreaterThanToHavingLengthsBetween { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.fromGreaterThanToHavingLengthsBetween(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object fromEqualToToHavingSizesBetween { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any): String = 
  Resources.fromEqualToToHavingSizesBetween(decorateToStringValue(prettifier, param0))
}

object fromGreaterThanToHavingSizesBetween { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.fromGreaterThanToHavingSizesBetween(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

final val analysis = Resources.analysis

final val deprecatedChosenStyleWarning = Resources.deprecatedChosenStyleWarning

final val flexmarkClassNotFound = Resources.flexmarkClassNotFound

object unableToSerializePayload { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.unableToSerializePayload(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

object unableToSerializeThrowable { 
def apply(prettifier: org.scalactic.Prettifier, param0: Any, param1: Any): String = 
  Resources.unableToSerializeThrowable(decorateToStringValue(prettifier, param0), decorateToStringValue(prettifier, param1))
}

final val unableToReadSerializedEvent = Resources.unableToReadSerializedEvent

final val unableToContinueRun = Resources.unableToContinueRun

}
    