/*
 * Copyright 2001-2008 Artima, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.scalatest

class OperatorNames {

  def op_21_! : Boolean = true
  def op_23_# : Boolean = true
  def op_25_% : Boolean = true
  def op_26_& : Boolean = true
  def op_2a_* : Boolean = true
  def op_2b_+ : Boolean = true
  def op_2d_-  : Boolean = true
  def op_2f_/ : Boolean = true
  def op_3a_: : Boolean = true
  def op_3c_< : Boolean = true
  def op_3d_= : Boolean = true
  def op_3e_> : Boolean = true
  def op_3f_? : Boolean = true
  def op_40_@ : Boolean = true
  def op_5c_\ : Boolean = true
  def op_5e_^ : Boolean = true
  def op_7c_| : Boolean = true
  def op_7e_~ : Boolean = true
  def op_7f_\u007f : Boolean = true

  def !!! : Boolean = true
  def ### : Boolean = true
  def %%% : Boolean = true
  def &&& : Boolean = true
  def *** : Boolean = true
  def +++ : Boolean = true
  def ---  : Boolean = true
  def / : Boolean = true
  def ::: : Boolean = true
  def <<< : Boolean = true
  def === : Boolean = true
  def >>> : Boolean = true
  def ??? : Boolean = true
  def @@@ : Boolean = true
  def \\\ : Boolean = true
  def ^^^ : Boolean = true
  def ||| : Boolean = true
  def ~~~ : Boolean = true
  // def \u007f\u007f\u007f : Boolean = true

/*
  21  !
  23  #
  25  %
  26  &
  2a  *
  2b  +
  2d  - 
  2f  /
  3a  :
  3c  <
  3d  =
  3e  >
  3f  ?
  40  @
  5c  \
  5e  ^
  7c  |
  7e  ~
  7f del

  javap OperatorNames
  Compiled from "OperatorNames.scala"
  public class org.scalatest.OperatorNames extends java.lang.Object implements scala.ScalaObject{
      public org.scalatest.OperatorNames();
      public boolean op_7e_$tilde();
      public boolean op_7c_$bar();
      public boolean op_5e_$up();
      public boolean op_5c_$bslash();
      public boolean op_40_$at();
      public boolean op_3f_$qmark();
      public boolean op_3e_$greater();
      public boolean op_3d_$eq();
      public boolean op_3c_$less();
      public boolean op_3a_$colon();
      public boolean op_2f_$div();
      public boolean op_2d_$minus();
      public boolean op_2b_$plus();
      public boolean op_2a_$times();
      public boolean op_26_$amp();
      public boolean op_25_$percent();
      public boolean op_23_$hash();
      public boolean op_21_$bang();
      public int $tag()       throws java.rmi.RemoteException;
  }

javap OperatorNames
Compiled from "OperatorNames.scala"
public class org.scalatest.OperatorNames extends java.lang.Object implements scala.ScalaObject{
    public org.scalatest.OperatorNames();
    public boolean $tilde$tilde$tilde();
    public boolean $bar$bar$bar();
    public boolean $up$up$up();
    public boolean $bslash$bslash$bslash();
    public boolean $at$at$at();
    public boolean $qmark$qmark$qmark();
    public boolean $greater$greater$greater();
    public boolean $eq$eq$eq();
    public boolean $less$less$less();
    public boolean $colon$colon$colon();
    public boolean $div();
    public boolean $minus$minus$minus();
    public boolean $plus$plus$plus();
    public boolean $times$times$times();
    public boolean $amp$amp$amp();
    public boolean $percent$percent$percent();
    public boolean $hash$hash$hash();
    public boolean $bang$bang$bang();
    public boolean op_7f_();
    public boolean op_7e_$tilde();
    public boolean op_7c_$bar();
    public boolean op_5e_$up();
    public boolean op_5c_$bslash();
    public boolean op_40_$at();
    public boolean op_3f_$qmark();
    public boolean op_3e_$greater();
    public boolean op_3d_$eq();
    public boolean op_3c_$less();
    public boolean op_3a_$colon();
    public boolean op_2f_$div();
    public boolean op_2d_$minus();
    public boolean op_2b_$plus();
    public boolean op_2a_$times();
    public boolean op_26_$amp();
    public boolean op_25_$percent();
    public boolean op_23_$hash();
    public boolean op_21_$bang();
    public int $tag()       throws java.rmi.RemoteException;
}

*/
} 
