package org.scalatest.inspectors.all

import org.scalatest._
import SharedHelpers._
import org.scalatest.matchers.{BePropertyMatcher, BePropertyMatchResult, HavePropertyMatcher, HavePropertyMatchResult}
import collection.GenTraversable
import collection.GenMap
class InspectorShorthandsForAllFailedSpec1 extends Spec with Matchers {
  class EmptyBePropertyMatcher extends BePropertyMatcher[String] {
    def apply(left: String) = BePropertyMatchResult(left.isEmpty, "empty")
  }
  class StringLengthMatcher(expectedValue: Int) extends HavePropertyMatcher[String, Int] {
    def apply(value: String) = {
      new HavePropertyMatchResult(value.length == expectedValue, "length", expectedValue, value.length)
    }
  }
  val empty = new EmptyBePropertyMatcher()
  def plength(expectedValue: Int) = new StringLengthMatcher(expectedValue)
  val theInstance = "2"
  def arrayToString(xs: GenTraversable[_]): String = xs.toString
  def checkErrorAndCause(e: exceptions.TestFailedException, assertLineNumber: Int, fileName: String, errorMessage: String, causeErrorMessage: String) {
    assert(e.failedCodeFileName == Some(fileName), e.failedCodeFileName + " did not equal " + Some(fileName))
    assert(e.failedCodeLineNumber == Some(assertLineNumber), e.failedCodeLineNumber + " did not equal " + Some(assertLineNumber))
    assert(e.message == Some(errorMessage), e.message + " did not equal " + Some(
  errorMessage))
    e.getCause match {
      case tfe: exceptions.TestFailedException =>
        assert(tfe.failedCodeFileName == Some(fileName), tfe.failedCodeFileName + " did not equal " + Some(fileName))
        assert(tfe.failedCodeLineNumber == Some(assertLineNumber), tfe.failedCodeLineNumber + " did not equal " + Some(assertLineNumber))
        assert(tfe.message == Some(causeErrorMessage), tfe.message + " did not equal " + Some(causeErrorMessage))
        assert(tfe.getCause == null, tfe.getCause + " was not null")
      case other => fail("Expected cause to be TestFailedException, but got: " + other)
    }
  }
  def checkError(e: exceptions.TestFailedException, assertLineNumber: Int, fileName: String, errorMessage: String) {
    assert(e.failedCodeFileName == Some(fileName), e.failedCodeFileName + " did not equal " + Some(fileName))
    assert(e.failedCodeLineNumber == Some(assertLineNumber), e.failedCodeLineNumber + " did not equal " + Some(assertLineNumber))
    assert(e.message == Some(errorMessage), e.message + " did not equal " + Some(
  errorMessage))
  }
  def equal[T](left: T, right: T): Boolean = left == right
  def javaArrayList[T](valueList: List[T]): java.util.ArrayList[T] = {
    val col = new java.util.ArrayList[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaHashSet[T](valueList: List[T]): java.util.HashSet[T] = {
    val col = new java.util.HashSet[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaLinkedList[T](valueList: List[T]): java.util.LinkedList[T] = {
    val col = new java.util.LinkedList[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaStack[T](valueList: List[T]): java.util.Stack[T] = {
    val col = new java.util.Stack[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaTreeSet[T](valueList: List[T]): java.util.TreeSet[T] = {
    val col = new java.util.TreeSet[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaVector[T](valueList: List[T]): java.util.Vector[T] = {
    val col = new java.util.Vector[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaArrayBlockingQueue[T](valueList: List[T], size: Int): java.util.concurrent.ArrayBlockingQueue[T] = {
    val col = new java.util.concurrent.ArrayBlockingQueue[T](size)
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaArrayDeque[T](valueList: List[T]): java.util.ArrayDeque[T] = {
    val col = new java.util.ArrayDeque[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaConcurrentLinkedQueue[T](valueList: List[T]): java.util.concurrent.ConcurrentLinkedQueue[T] = {
    val col = new java.util.concurrent.ConcurrentLinkedQueue[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaConcurrentSkipListSet[T](valueList: List[T]): java.util.concurrent.ConcurrentSkipListSet[T] = {
    val col = new java.util.concurrent.ConcurrentSkipListSet[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaCopyOnWriteArrayList[T](valueList: List[T]): java.util.concurrent.CopyOnWriteArrayList[T] = {
    val col = new java.util.concurrent.CopyOnWriteArrayList[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaCopyOnWriteArraySet[T](valueList: List[T]): java.util.concurrent.CopyOnWriteArraySet[T] = {
    val col = new java.util.concurrent.CopyOnWriteArraySet[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaLinkedBlockingDeque[T](valueList: List[T]): java.util.concurrent.LinkedBlockingDeque[T] = {
    val col = new java.util.concurrent.LinkedBlockingDeque[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaLinkedBlockingQueue[T](valueList: List[T]): java.util.concurrent.LinkedBlockingQueue[T] = {
    val col = new java.util.concurrent.LinkedBlockingQueue[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaLinkedHashSet[T](valueList: List[T]): java.util.LinkedHashSet[T] = {
    val col = new java.util.LinkedHashSet[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaPriorityBlockingQueue[T](valueList: List[T]): java.util.concurrent.PriorityBlockingQueue[T] = {
    val col = new java.util.concurrent.PriorityBlockingQueue[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaPriorityQueue[T](valueList: List[T]): java.util.PriorityQueue[T] = {
    val col = new java.util.PriorityQueue[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaHashMap[K, V](valueMap: Map[K, V]): java.util.HashMap[K, V] = {
    val map = new java.util.HashMap[K, V]()
    for ((key, value) <- valueMap)
      map.put(key, value)
    map
  }
  def javaTreeMap[K, V](valueMap: Map[K, V]): java.util.TreeMap[K, V] = {
    val map = new java.util.TreeMap[K, V]()
    for ((key, value) <- valueMap)
      map.put(key, value)
    map
  }
  def javaHashtable[K, V](valueMap: Map[K, V]): java.util.Hashtable[K, V] = {
    val map = new java.util.Hashtable[K, V]()
    for ((key, value) <- valueMap)
      map.put(key, value)
    map
  }
  def javaConcurrentHashMap[K, V](valueMap: Map[K, V]): java.util.concurrent.ConcurrentHashMap[K, V] = {
    val map = new java.util.concurrent.ConcurrentHashMap[K, V]()
    for ((key, value) <- valueMap)
      map.put(key, value)
    map
  }
  def javaConcurrentSkipListMap[K, V](valueMap: Map[K, V]): java.util.concurrent.ConcurrentSkipListMap[K, V] = {
    val map = new java.util.concurrent.ConcurrentSkipListMap[K, V]()
    for ((key, value) <- valueMap)
      map.put(key, value)
    map
  }
  def javaLinkedHashMap[K, V](valueMap: Map[K, V]): java.util.LinkedHashMap[K, V] = {
    val map = new java.util.LinkedHashMap[K, V]()
    for ((key, value) <- valueMap)
      map.put(key, value)
    map
  }
  def javaWeakHashMap[K, V](valueMap: Map[K, V]): java.util.WeakHashMap[K, V] = {
    val map = new java.util.WeakHashMap[K, V]()
    for ((key, value) <- valueMap)
      map.put(key, value)
    map
  }
  def javaProperties(valueMap: Map[String, String]): java.util.Properties = {
    val map = new java.util.Properties()
    for ((key, value) <- valueMap)
      map.put(key, value)
    map
  }
  def `collection.mutable.Seq("", "boom!", "") should throw TestFailedException with correct stack depth and message when 'should have property' failed` {
    val xs = collection.mutable.Seq("", "boom!", "")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should have (plength(0))
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstLengthNotEqualLength(xs, 0)) + ", The length property had value " + getFirstLengthNotEqualLength(xs, 0).length + ", instead of its expected value 0, on object \"" + getFirstLengthNotEqualLength(xs, 0) + "\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "The length property had value " + getFirstLengthNotEqualLength(xs, 0).length + ", instead of its expected value 0, on object \"" + getFirstLengthNotEqualLength(xs, 0) + "\"")
  }
  def `collection.mutable.Seq("", "boom!", "") should throw TestFailedException with correct stack depth and message when 'should not have property' failed` {
    val xs = collection.mutable.Seq("", "boom!", "")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not have plength(0)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstLengthEqual(xs, 0)) + ", The length property had its expected value 0, on object \"" + getFirstLengthEqual(xs, 0) + "\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "The length property had its expected value 0, on object \"" + getFirstLengthEqual(xs, 0) + "\"")
  }
  def `collection.mutable.IndexedSeq("", "boom!", "") should throw TestFailedException with correct stack depth and message when 'should be symbol' failed` {
    val xs = collection.mutable.IndexedSeq("", "boom!", "")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should be ('empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstIsNotEmpty(xs, "")) + ", \"" + getFirstIsNotEmpty(xs, "") + "\" was not empty (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstIsNotEmpty(xs, "") + "\" was not empty")
  }
  def `collection.mutable.IndexedSeq("", "boom!", "") should throw TestFailedException with correct stack depth and message when 'should not be symbol' failed` {
    val xs = collection.mutable.IndexedSeq("", "boom!", "")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not be 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstIsEmpty(xs, "")) + ", \"" + getFirstIsEmpty(xs, "") + "\" was empty (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstIsEmpty(xs, "") + "\" was empty")
  }
  def `collection.mutable.IndexedSeq("", "boom!", "") should throw TestFailedException with correct stack depth and message when 'should be property' failed` {
    val xs = collection.mutable.IndexedSeq("", "boom!", "")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should be (empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstIsNotEmpty(xs, "")) + ", \"" + getFirstIsNotEmpty(xs, "") + "\" was not empty (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstIsNotEmpty(xs, "") + "\" was not empty")
  }
  def `collection.mutable.IndexedSeq("", "boom!", "") should throw TestFailedException with correct stack depth and message when 'should not be property' failed` {
    val xs = collection.mutable.IndexedSeq("", "boom!", "")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not be empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstIsEmpty(xs, "")) + ", \"" + getFirstIsEmpty(xs, "") + "\" was empty (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstIsEmpty(xs, "") + "\" was empty")
  }
  def `collection.mutable.IndexedSeq("", "boom!", "") should throw TestFailedException with correct stack depth and message when 'should be a symbol' failed` {
    val xs = collection.mutable.IndexedSeq("", "boom!", "")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should be a 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstIsNotEmpty(xs, "")) + ", \"" + getFirstIsNotEmpty(xs, "") + "\" was not a empty (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstIsNotEmpty(xs, "") + "\" was not a empty")
  }
  def `collection.mutable.IndexedSeq("", "boom!", "") should throw TestFailedException with correct stack depth and message when 'should not be a symbol' failed` {
    val xs = collection.mutable.IndexedSeq("", "boom!", "")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not be a ('empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstIsEmpty(xs, "")) + ", \"" + getFirstIsEmpty(xs, "") + "\" was a empty (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstIsEmpty(xs, "") + "\" was a empty")
  }
  def `collection.mutable.IndexedSeq("", "boom!", "") should throw TestFailedException with correct stack depth and message when 'should be a property' failed` {
    val xs = collection.mutable.IndexedSeq("", "boom!", "")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should be a empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstIsNotEmpty(xs, "")) + ", \"" + getFirstIsNotEmpty(xs, "") + "\" was not a empty (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstIsNotEmpty(xs, "") + "\" was not a empty")
  }
  def `collection.mutable.IndexedSeq("", "boom!", "") should throw TestFailedException with correct stack depth and message when 'should not be a property' failed` {
    val xs = collection.mutable.IndexedSeq("", "boom!", "")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not be a (empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstIsEmpty(xs, "")) + ", \"" + getFirstIsEmpty(xs, "") + "\" was a empty (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstIsEmpty(xs, "") + "\" was a empty")
  }
  def `collection.mutable.IndexedSeq("", "boom!", "") should throw TestFailedException with correct stack depth and message when 'should be an symbol' failed` {
    val xs = collection.mutable.IndexedSeq("", "boom!", "")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should be an 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstIsNotEmpty(xs, "")) + ", \"" + getFirstIsNotEmpty(xs, "") + "\" was not an empty (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstIsNotEmpty(xs, "") + "\" was not an empty")
  }
  def `collection.mutable.IndexedSeq("", "boom!", "") should throw TestFailedException with correct stack depth and message when 'should not be an symbol' failed` {
    val xs = collection.mutable.IndexedSeq("", "boom!", "")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not be an ('empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstIsEmpty(xs, "")) + ", \"" + getFirstIsEmpty(xs, "") + "\" was an empty (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstIsEmpty(xs, "") + "\" was an empty")
  }
  def `collection.mutable.IndexedSeq("", "boom!", "") should throw TestFailedException with correct stack depth and message when 'should be an property' failed` {
    val xs = collection.mutable.IndexedSeq("", "boom!", "")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should be an empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstIsNotEmpty(xs, "")) + ", \"" + getFirstIsNotEmpty(xs, "") + "\" was not an empty (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstIsNotEmpty(xs, "") + "\" was not an empty")
  }
  def `collection.mutable.IndexedSeq("", "boom!", "") should throw TestFailedException with correct stack depth and message when 'should not be an property' failed` {
    val xs = collection.mutable.IndexedSeq("", "boom!", "")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not be an (empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstIsEmpty(xs, "")) + ", \"" + getFirstIsEmpty(xs, "") + "\" was an empty (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstIsEmpty(xs, "") + "\" was an empty")
  }
  def `collection.mutable.IndexedSeq("", "boom!", "") should throw TestFailedException with correct stack depth and message when 'should have property' failed` {
    val xs = collection.mutable.IndexedSeq("", "boom!", "")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should have (plength(0))
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstLengthNotEqualLength(xs, 0)) + ", The length property had value " + getFirstLengthNotEqualLength(xs, 0).length + ", instead of its expected value 0, on object \"" + getFirstLengthNotEqualLength(xs, 0) + "\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "The length property had value " + getFirstLengthNotEqualLength(xs, 0).length + ", instead of its expected value 0, on object \"" + getFirstLengthNotEqualLength(xs, 0) + "\"")
  }
  def `collection.mutable.IndexedSeq("", "boom!", "") should throw TestFailedException with correct stack depth and message when 'should not have property' failed` {
    val xs = collection.mutable.IndexedSeq("", "boom!", "")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not have plength(0)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstLengthEqual(xs, 0)) + ", The length property had its expected value 0, on object \"" + getFirstLengthEqual(xs, 0) + "\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "The length property had its expected value 0, on object \"" + getFirstLengthEqual(xs, 0) + "\"")
  }
  def `collection.mutable.Set("", "boom!", "").par should throw TestFailedException with correct stack depth and message when 'should be symbol' failed` {
    val xs = collection.mutable.Set("", "boom!", "").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should be ('empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstIsNotEmpty(xs, "")) + ", \"" + getFirstIsNotEmpty(xs, "") + "\" was not empty (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstIsNotEmpty(xs, "") + "\" was not empty")
  }
  def `collection.mutable.Set("", "boom!", "").par should throw TestFailedException with correct stack depth and message when 'should not be symbol' failed` {
    val xs = collection.mutable.Set("", "boom!", "").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not be 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstIsEmpty(xs, "")) + ", \"" + getFirstIsEmpty(xs, "") + "\" was empty (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstIsEmpty(xs, "") + "\" was empty")
  }
  def `collection.mutable.Set("", "boom!", "").par should throw TestFailedException with correct stack depth and message when 'should be property' failed` {
    val xs = collection.mutable.Set("", "boom!", "").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should be (empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstIsNotEmpty(xs, "")) + ", \"" + getFirstIsNotEmpty(xs, "") + "\" was not empty (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstIsNotEmpty(xs, "") + "\" was not empty")
  }
  def `collection.mutable.Set("", "boom!", "").par should throw TestFailedException with correct stack depth and message when 'should not be property' failed` {
    val xs = collection.mutable.Set("", "boom!", "").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not be empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstIsEmpty(xs, "")) + ", \"" + getFirstIsEmpty(xs, "") + "\" was empty (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstIsEmpty(xs, "") + "\" was empty")
  }
  def `collection.mutable.Set("", "boom!", "").par should throw TestFailedException with correct stack depth and message when 'should be a symbol' failed` {
    val xs = collection.mutable.Set("", "boom!", "").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should be a 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstIsNotEmpty(xs, "")) + ", \"" + getFirstIsNotEmpty(xs, "") + "\" was not a empty (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstIsNotEmpty(xs, "") + "\" was not a empty")
  }
  def `collection.mutable.Set("", "boom!", "").par should throw TestFailedException with correct stack depth and message when 'should not be a symbol' failed` {
    val xs = collection.mutable.Set("", "boom!", "").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not be a ('empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstIsEmpty(xs, "")) + ", \"" + getFirstIsEmpty(xs, "") + "\" was a empty (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstIsEmpty(xs, "") + "\" was a empty")
  }
  def `collection.mutable.Set("", "boom!", "").par should throw TestFailedException with correct stack depth and message when 'should be a property' failed` {
    val xs = collection.mutable.Set("", "boom!", "").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should be a empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstIsNotEmpty(xs, "")) + ", \"" + getFirstIsNotEmpty(xs, "") + "\" was not a empty (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstIsNotEmpty(xs, "") + "\" was not a empty")
  }
  def `collection.mutable.Set("", "boom!", "").par should throw TestFailedException with correct stack depth and message when 'should not be a property' failed` {
    val xs = collection.mutable.Set("", "boom!", "").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not be a (empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstIsEmpty(xs, "")) + ", \"" + getFirstIsEmpty(xs, "") + "\" was a empty (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstIsEmpty(xs, "") + "\" was a empty")
  }
  def `collection.mutable.Set("", "boom!", "").par should throw TestFailedException with correct stack depth and message when 'should be an symbol' failed` {
    val xs = collection.mutable.Set("", "boom!", "").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should be an 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstIsNotEmpty(xs, "")) + ", \"" + getFirstIsNotEmpty(xs, "") + "\" was not an empty (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstIsNotEmpty(xs, "") + "\" was not an empty")
  }
  def `collection.mutable.Set("", "boom!", "").par should throw TestFailedException with correct stack depth and message when 'should not be an symbol' failed` {
    val xs = collection.mutable.Set("", "boom!", "").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not be an ('empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstIsEmpty(xs, "")) + ", \"" + getFirstIsEmpty(xs, "") + "\" was an empty (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstIsEmpty(xs, "") + "\" was an empty")
  }
  def `collection.mutable.Set("", "boom!", "").par should throw TestFailedException with correct stack depth and message when 'should be an property' failed` {
    val xs = collection.mutable.Set("", "boom!", "").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should be an empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstIsNotEmpty(xs, "")) + ", \"" + getFirstIsNotEmpty(xs, "") + "\" was not an empty (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstIsNotEmpty(xs, "") + "\" was not an empty")
  }
  def `collection.mutable.Set("", "boom!", "").par should throw TestFailedException with correct stack depth and message when 'should not be an property' failed` {
    val xs = collection.mutable.Set("", "boom!", "").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not be an (empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstIsEmpty(xs, "")) + ", \"" + getFirstIsEmpty(xs, "") + "\" was an empty (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstIsEmpty(xs, "") + "\" was an empty")
  }
  def `collection.mutable.Set("", "boom!", "").par should throw TestFailedException with correct stack depth and message when 'should have property' failed` {
    val xs = collection.mutable.Set("", "boom!", "").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should have (plength(0))
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstLengthNotEqualLength(xs, 0)) + ", The length property had value " + getFirstLengthNotEqualLength(xs, 0).length + ", instead of its expected value 0, on object \"" + getFirstLengthNotEqualLength(xs, 0) + "\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "The length property had value " + getFirstLengthNotEqualLength(xs, 0).length + ", instead of its expected value 0, on object \"" + getFirstLengthNotEqualLength(xs, 0) + "\"")
  }
  def `collection.mutable.Set("", "boom!", "").par should throw TestFailedException with correct stack depth and message when 'should not have property' failed` {
    val xs = collection.mutable.Set("", "boom!", "").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not have plength(0)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstLengthEqual(xs, 0)) + ", The length property had its expected value 0, on object \"" + getFirstLengthEqual(xs, 0) + "\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "The length property had its expected value 0, on object \"" + getFirstLengthEqual(xs, 0) + "\"")
  }
  def `(new collection.mutable.ListBuffer() ++ List("", "boom!", "")).par should throw TestFailedException with correct stack depth and message when 'should be symbol' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List("", "boom!", "")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should be ('empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstIsNotEmpty(xs, "")) + ", \"" + getFirstIsNotEmpty(xs, "") + "\" was not empty (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstIsNotEmpty(xs, "") + "\" was not empty")
  }
  def `(new collection.mutable.ListBuffer() ++ List("", "boom!", "")).par should throw TestFailedException with correct stack depth and message when 'should not be symbol' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List("", "boom!", "")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not be 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstIsEmpty(xs, "")) + ", \"" + getFirstIsEmpty(xs, "") + "\" was empty (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstIsEmpty(xs, "") + "\" was empty")
  }
  def `(new collection.mutable.ListBuffer() ++ List("", "boom!", "")).par should throw TestFailedException with correct stack depth and message when 'should be property' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List("", "boom!", "")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should be (empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstIsNotEmpty(xs, "")) + ", \"" + getFirstIsNotEmpty(xs, "") + "\" was not empty (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstIsNotEmpty(xs, "") + "\" was not empty")
  }
  def `(new collection.mutable.ListBuffer() ++ List("", "boom!", "")).par should throw TestFailedException with correct stack depth and message when 'should not be property' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List("", "boom!", "")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not be empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstIsEmpty(xs, "")) + ", \"" + getFirstIsEmpty(xs, "") + "\" was empty (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstIsEmpty(xs, "") + "\" was empty")
  }
  def `(new collection.mutable.ListBuffer() ++ List("", "boom!", "")).par should throw TestFailedException with correct stack depth and message when 'should be a symbol' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List("", "boom!", "")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should be a 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstIsNotEmpty(xs, "")) + ", \"" + getFirstIsNotEmpty(xs, "") + "\" was not a empty (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstIsNotEmpty(xs, "") + "\" was not a empty")
  }
  def `(new collection.mutable.ListBuffer() ++ List("", "boom!", "")).par should throw TestFailedException with correct stack depth and message when 'should not be a symbol' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List("", "boom!", "")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not be a ('empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstIsEmpty(xs, "")) + ", \"" + getFirstIsEmpty(xs, "") + "\" was a empty (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstIsEmpty(xs, "") + "\" was a empty")
  }
  def `(new collection.mutable.ListBuffer() ++ List("", "boom!", "")).par should throw TestFailedException with correct stack depth and message when 'should be a property' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List("", "boom!", "")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should be a empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstIsNotEmpty(xs, "")) + ", \"" + getFirstIsNotEmpty(xs, "") + "\" was not a empty (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstIsNotEmpty(xs, "") + "\" was not a empty")
  }
  def `(new collection.mutable.ListBuffer() ++ List("", "boom!", "")).par should throw TestFailedException with correct stack depth and message when 'should not be a property' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List("", "boom!", "")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not be a (empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstIsEmpty(xs, "")) + ", \"" + getFirstIsEmpty(xs, "") + "\" was a empty (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstIsEmpty(xs, "") + "\" was a empty")
  }
  def `(new collection.mutable.ListBuffer() ++ List("", "boom!", "")).par should throw TestFailedException with correct stack depth and message when 'should be an symbol' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List("", "boom!", "")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should be an 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstIsNotEmpty(xs, "")) + ", \"" + getFirstIsNotEmpty(xs, "") + "\" was not an empty (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstIsNotEmpty(xs, "") + "\" was not an empty")
  }
  def `(new collection.mutable.ListBuffer() ++ List("", "boom!", "")).par should throw TestFailedException with correct stack depth and message when 'should not be an symbol' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List("", "boom!", "")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not be an ('empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstIsEmpty(xs, "")) + ", \"" + getFirstIsEmpty(xs, "") + "\" was an empty (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstIsEmpty(xs, "") + "\" was an empty")
  }
  def `(new collection.mutable.ListBuffer() ++ List("", "boom!", "")).par should throw TestFailedException with correct stack depth and message when 'should be an property' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List("", "boom!", "")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should be an empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstIsNotEmpty(xs, "")) + ", \"" + getFirstIsNotEmpty(xs, "") + "\" was not an empty (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstIsNotEmpty(xs, "") + "\" was not an empty")
  }
  def `(new collection.mutable.ListBuffer() ++ List("", "boom!", "")).par should throw TestFailedException with correct stack depth and message when 'should not be an property' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List("", "boom!", "")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not be an (empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstIsEmpty(xs, "")) + ", \"" + getFirstIsEmpty(xs, "") + "\" was an empty (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstIsEmpty(xs, "") + "\" was an empty")
  }
  def `(new collection.mutable.ListBuffer() ++ List("", "boom!", "")).par should throw TestFailedException with correct stack depth and message when 'should have property' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List("", "boom!", "")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should have (plength(0))
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstLengthNotEqualLength(xs, 0)) + ", The length property had value " + getFirstLengthNotEqualLength(xs, 0).length + ", instead of its expected value 0, on object \"" + getFirstLengthNotEqualLength(xs, 0) + "\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "The length property had value " + getFirstLengthNotEqualLength(xs, 0).length + ", instead of its expected value 0, on object \"" + getFirstLengthNotEqualLength(xs, 0) + "\"")
  }
  def `(new collection.mutable.ListBuffer() ++ List("", "boom!", "")).par should throw TestFailedException with correct stack depth and message when 'should not have property' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List("", "boom!", "")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not have plength(0)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstLengthEqual(xs, 0)) + ", The length property had its expected value 0, on object \"" + getFirstLengthEqual(xs, 0) + "\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "The length property had its expected value 0, on object \"" + getFirstLengthEqual(xs, 0) + "\"")
  }
  def `collection.mutable.Seq("", "boom!", "").par should throw TestFailedException with correct stack depth and message when 'should be symbol' failed` {
    val xs = collection.mutable.Seq("", "boom!", "").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should be ('empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstIsNotEmpty(xs, "")) + ", \"" + getFirstIsNotEmpty(xs, "") + "\" was not empty (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstIsNotEmpty(xs, "") + "\" was not empty")
  }
  def `collection.mutable.Seq("", "boom!", "").par should throw TestFailedException with correct stack depth and message when 'should not be symbol' failed` {
    val xs = collection.mutable.Seq("", "boom!", "").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not be 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstIsEmpty(xs, "")) + ", \"" + getFirstIsEmpty(xs, "") + "\" was empty (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstIsEmpty(xs, "") + "\" was empty")
  }
  def `collection.mutable.Seq("", "boom!", "").par should throw TestFailedException with correct stack depth and message when 'should be property' failed` {
    val xs = collection.mutable.Seq("", "boom!", "").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should be (empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstIsNotEmpty(xs, "")) + ", \"" + getFirstIsNotEmpty(xs, "") + "\" was not empty (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstIsNotEmpty(xs, "") + "\" was not empty")
  }
  def `collection.mutable.Seq("", "boom!", "").par should throw TestFailedException with correct stack depth and message when 'should not be property' failed` {
    val xs = collection.mutable.Seq("", "boom!", "").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not be empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstIsEmpty(xs, "")) + ", \"" + getFirstIsEmpty(xs, "") + "\" was empty (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstIsEmpty(xs, "") + "\" was empty")
  }
  def `collection.mutable.Seq("", "boom!", "").par should throw TestFailedException with correct stack depth and message when 'should be a symbol' failed` {
    val xs = collection.mutable.Seq("", "boom!", "").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should be a 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstIsNotEmpty(xs, "")) + ", \"" + getFirstIsNotEmpty(xs, "") + "\" was not a empty (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstIsNotEmpty(xs, "") + "\" was not a empty")
  }
  def `collection.mutable.Seq("", "boom!", "").par should throw TestFailedException with correct stack depth and message when 'should not be a symbol' failed` {
    val xs = collection.mutable.Seq("", "boom!", "").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not be a ('empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstIsEmpty(xs, "")) + ", \"" + getFirstIsEmpty(xs, "") + "\" was a empty (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstIsEmpty(xs, "") + "\" was a empty")
  }
  def `collection.mutable.Seq("", "boom!", "").par should throw TestFailedException with correct stack depth and message when 'should be a property' failed` {
    val xs = collection.mutable.Seq("", "boom!", "").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should be a empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstIsNotEmpty(xs, "")) + ", \"" + getFirstIsNotEmpty(xs, "") + "\" was not a empty (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstIsNotEmpty(xs, "") + "\" was not a empty")
  }
  def `collection.mutable.Seq("", "boom!", "").par should throw TestFailedException with correct stack depth and message when 'should not be a property' failed` {
    val xs = collection.mutable.Seq("", "boom!", "").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not be a (empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstIsEmpty(xs, "")) + ", \"" + getFirstIsEmpty(xs, "") + "\" was a empty (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstIsEmpty(xs, "") + "\" was a empty")
  }
  def `collection.mutable.Seq("", "boom!", "").par should throw TestFailedException with correct stack depth and message when 'should be an symbol' failed` {
    val xs = collection.mutable.Seq("", "boom!", "").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should be an 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstIsNotEmpty(xs, "")) + ", \"" + getFirstIsNotEmpty(xs, "") + "\" was not an empty (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstIsNotEmpty(xs, "") + "\" was not an empty")
  }
  def `collection.mutable.Seq("", "boom!", "").par should throw TestFailedException with correct stack depth and message when 'should not be an symbol' failed` {
    val xs = collection.mutable.Seq("", "boom!", "").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not be an ('empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstIsEmpty(xs, "")) + ", \"" + getFirstIsEmpty(xs, "") + "\" was an empty (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstIsEmpty(xs, "") + "\" was an empty")
  }
  def `collection.mutable.Seq("", "boom!", "").par should throw TestFailedException with correct stack depth and message when 'should be an property' failed` {
    val xs = collection.mutable.Seq("", "boom!", "").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should be an empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstIsNotEmpty(xs, "")) + ", \"" + getFirstIsNotEmpty(xs, "") + "\" was not an empty (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstIsNotEmpty(xs, "") + "\" was not an empty")
  }
  def `collection.mutable.Seq("", "boom!", "").par should throw TestFailedException with correct stack depth and message when 'should not be an property' failed` {
    val xs = collection.mutable.Seq("", "boom!", "").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not be an (empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstIsEmpty(xs, "")) + ", \"" + getFirstIsEmpty(xs, "") + "\" was an empty (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstIsEmpty(xs, "") + "\" was an empty")
  }
  def `collection.mutable.Seq("", "boom!", "").par should throw TestFailedException with correct stack depth and message when 'should have property' failed` {
    val xs = collection.mutable.Seq("", "boom!", "").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should have (plength(0))
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstLengthNotEqualLength(xs, 0)) + ", The length property had value " + getFirstLengthNotEqualLength(xs, 0).length + ", instead of its expected value 0, on object \"" + getFirstLengthNotEqualLength(xs, 0) + "\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "The length property had value " + getFirstLengthNotEqualLength(xs, 0).length + ", instead of its expected value 0, on object \"" + getFirstLengthNotEqualLength(xs, 0) + "\"")
  }
  def `collection.mutable.Seq("", "boom!", "").par should throw TestFailedException with correct stack depth and message when 'should not have property' failed` {
    val xs = collection.mutable.Seq("", "boom!", "").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not have plength(0)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstLengthEqual(xs, 0)) + ", The length property had its expected value 0, on object \"" + getFirstLengthEqual(xs, 0) + "\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "The length property had its expected value 0, on object \"" + getFirstLengthEqual(xs, 0) + "\"")
  }
  def `collection.mutable.IndexedSeq("", "boom!", "").par should throw TestFailedException with correct stack depth and message when 'should be symbol' failed` {
    val xs = collection.mutable.IndexedSeq("", "boom!", "").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should be ('empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstIsNotEmpty(xs, "")) + ", \"" + getFirstIsNotEmpty(xs, "") + "\" was not empty (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstIsNotEmpty(xs, "") + "\" was not empty")
  }
  def `collection.mutable.IndexedSeq("", "boom!", "").par should throw TestFailedException with correct stack depth and message when 'should not be symbol' failed` {
    val xs = collection.mutable.IndexedSeq("", "boom!", "").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not be 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstIsEmpty(xs, "")) + ", \"" + getFirstIsEmpty(xs, "") + "\" was empty (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstIsEmpty(xs, "") + "\" was empty")
  }
  def `collection.mutable.IndexedSeq("", "boom!", "").par should throw TestFailedException with correct stack depth and message when 'should be property' failed` {
    val xs = collection.mutable.IndexedSeq("", "boom!", "").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should be (empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstIsNotEmpty(xs, "")) + ", \"" + getFirstIsNotEmpty(xs, "") + "\" was not empty (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstIsNotEmpty(xs, "") + "\" was not empty")
  }
  def `collection.mutable.IndexedSeq("", "boom!", "").par should throw TestFailedException with correct stack depth and message when 'should not be property' failed` {
    val xs = collection.mutable.IndexedSeq("", "boom!", "").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not be empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstIsEmpty(xs, "")) + ", \"" + getFirstIsEmpty(xs, "") + "\" was empty (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstIsEmpty(xs, "") + "\" was empty")
  }
  def `collection.mutable.IndexedSeq("", "boom!", "").par should throw TestFailedException with correct stack depth and message when 'should be a symbol' failed` {
    val xs = collection.mutable.IndexedSeq("", "boom!", "").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should be a 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstIsNotEmpty(xs, "")) + ", \"" + getFirstIsNotEmpty(xs, "") + "\" was not a empty (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstIsNotEmpty(xs, "") + "\" was not a empty")
  }
  def `collection.mutable.IndexedSeq("", "boom!", "").par should throw TestFailedException with correct stack depth and message when 'should not be a symbol' failed` {
    val xs = collection.mutable.IndexedSeq("", "boom!", "").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not be a ('empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstIsEmpty(xs, "")) + ", \"" + getFirstIsEmpty(xs, "") + "\" was a empty (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstIsEmpty(xs, "") + "\" was a empty")
  }
  def `collection.mutable.IndexedSeq("", "boom!", "").par should throw TestFailedException with correct stack depth and message when 'should be a property' failed` {
    val xs = collection.mutable.IndexedSeq("", "boom!", "").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should be a empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstIsNotEmpty(xs, "")) + ", \"" + getFirstIsNotEmpty(xs, "") + "\" was not a empty (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstIsNotEmpty(xs, "") + "\" was not a empty")
  }
  def `collection.mutable.IndexedSeq("", "boom!", "").par should throw TestFailedException with correct stack depth and message when 'should not be a property' failed` {
    val xs = collection.mutable.IndexedSeq("", "boom!", "").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not be a (empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstIsEmpty(xs, "")) + ", \"" + getFirstIsEmpty(xs, "") + "\" was a empty (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstIsEmpty(xs, "") + "\" was a empty")
  }
  def `collection.mutable.IndexedSeq("", "boom!", "").par should throw TestFailedException with correct stack depth and message when 'should be an symbol' failed` {
    val xs = collection.mutable.IndexedSeq("", "boom!", "").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should be an 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstIsNotEmpty(xs, "")) + ", \"" + getFirstIsNotEmpty(xs, "") + "\" was not an empty (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstIsNotEmpty(xs, "") + "\" was not an empty")
  }
  def `collection.mutable.IndexedSeq("", "boom!", "").par should throw TestFailedException with correct stack depth and message when 'should not be an symbol' failed` {
    val xs = collection.mutable.IndexedSeq("", "boom!", "").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not be an ('empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstIsEmpty(xs, "")) + ", \"" + getFirstIsEmpty(xs, "") + "\" was an empty (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstIsEmpty(xs, "") + "\" was an empty")
  }
  def `collection.mutable.IndexedSeq("", "boom!", "").par should throw TestFailedException with correct stack depth and message when 'should be an property' failed` {
    val xs = collection.mutable.IndexedSeq("", "boom!", "").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should be an empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstIsNotEmpty(xs, "")) + ", \"" + getFirstIsNotEmpty(xs, "") + "\" was not an empty (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstIsNotEmpty(xs, "") + "\" was not an empty")
  }
  def `collection.mutable.IndexedSeq("", "boom!", "").par should throw TestFailedException with correct stack depth and message when 'should not be an property' failed` {
    val xs = collection.mutable.IndexedSeq("", "boom!", "").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not be an (empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstIsEmpty(xs, "")) + ", \"" + getFirstIsEmpty(xs, "") + "\" was an empty (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstIsEmpty(xs, "") + "\" was an empty")
  }
  def `collection.mutable.IndexedSeq("", "boom!", "").par should throw TestFailedException with correct stack depth and message when 'should have property' failed` {
    val xs = collection.mutable.IndexedSeq("", "boom!", "").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should have (plength(0))
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstLengthNotEqualLength(xs, 0)) + ", The length property had value " + getFirstLengthNotEqualLength(xs, 0).length + ", instead of its expected value 0, on object \"" + getFirstLengthNotEqualLength(xs, 0) + "\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "The length property had value " + getFirstLengthNotEqualLength(xs, 0).length + ", instead of its expected value 0, on object \"" + getFirstLengthNotEqualLength(xs, 0) + "\"")
  }
  def `collection.mutable.IndexedSeq("", "boom!", "").par should throw TestFailedException with correct stack depth and message when 'should not have property' failed` {
    val xs = collection.mutable.IndexedSeq("", "boom!", "").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not have plength(0)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstLengthEqual(xs, 0)) + ", The length property had its expected value 0, on object \"" + getFirstLengthEqual(xs, 0) + "\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "The length property had its expected value 0, on object \"" + getFirstLengthEqual(xs, 0) + "\"")
  }
  def `Set("", "boom!", "") should throw TestFailedException with correct stack depth and message when 'should have size' failed` {
    val xs = Set("", "boom!", "")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should have size 0
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeNotEqual(xs, 0)) + ", \"" + getFirstSizeNotEqual(xs, 0) + "\" had size " + getFirstSizeNotEqual(xs, 0).length + " instead of expected size 0 (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstSizeNotEqual(xs, 0) + "\" had size " + getFirstSizeNotEqual(xs, 0).length + " instead of expected size 0")
  }
  def `Set("", "boom!", "") should throw TestFailedException with correct stack depth and message when 'should not have size' failed` {
    val xs = Set("", "boom!", "")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not have size (0)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeEqual(xs, 0)) + ", \"" + getFirstSizeEqual(xs, 0) + "\" had size 0 (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstSizeEqual(xs, 0) + "\" had size 0")
  }
  def `List("", "boom!", "") should throw TestFailedException with correct stack depth and message when 'should have length' failed` {
    val xs = List("", "boom!", "")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should have length 0
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstLengthNotEqual(xs, 0)) + ", \"" + getFirstLengthNotEqual(xs, 0) + "\" had length " + getFirstLengthNotEqual(xs, 0).length + " instead of expected length 0 (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstLengthNotEqual(xs, 0) + "\" had length " + getFirstLengthNotEqual(xs, 0).length + " instead of expected length 0")
  }
  def `List("", "boom!", "") should throw TestFailedException with correct stack depth and message when 'should not have length' failed` {
    val xs = List("", "boom!", "")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not have length (0)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstLengthEqual(xs, 0)) + ", \"" + getFirstLengthEqual(xs, 0) + "\" had length 0 (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstLengthEqual(xs, 0) + "\" had length 0")
  }
  def `List("", "boom!", "") should throw TestFailedException with correct stack depth and message when 'should have size' failed` {
    val xs = List("", "boom!", "")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should have size 0
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeNotEqual(xs, 0)) + ", \"" + getFirstSizeNotEqual(xs, 0) + "\" had size " + getFirstSizeNotEqual(xs, 0).length + " instead of expected size 0 (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstSizeNotEqual(xs, 0) + "\" had size " + getFirstSizeNotEqual(xs, 0).length + " instead of expected size 0")
  }
  def `List("", "boom!", "") should throw TestFailedException with correct stack depth and message when 'should not have size' failed` {
    val xs = List("", "boom!", "")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not have size (0)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeEqual(xs, 0)) + ", \"" + getFirstSizeEqual(xs, 0) + "\" had size 0 (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstSizeEqual(xs, 0) + "\" had size 0")
  }
  def `Seq("", "boom!", "") should throw TestFailedException with correct stack depth and message when 'should have length' failed` {
    val xs = Seq("", "boom!", "")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should have length 0
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstLengthNotEqual(xs, 0)) + ", \"" + getFirstLengthNotEqual(xs, 0) + "\" had length " + getFirstLengthNotEqual(xs, 0).length + " instead of expected length 0 (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstLengthNotEqual(xs, 0) + "\" had length " + getFirstLengthNotEqual(xs, 0).length + " instead of expected length 0")
  }
  def `Seq("", "boom!", "") should throw TestFailedException with correct stack depth and message when 'should not have length' failed` {
    val xs = Seq("", "boom!", "")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not have length (0)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstLengthEqual(xs, 0)) + ", \"" + getFirstLengthEqual(xs, 0) + "\" had length 0 (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstLengthEqual(xs, 0) + "\" had length 0")
  }
  def `Seq("", "boom!", "") should throw TestFailedException with correct stack depth and message when 'should have size' failed` {
    val xs = Seq("", "boom!", "")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should have size 0
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeNotEqual(xs, 0)) + ", \"" + getFirstSizeNotEqual(xs, 0) + "\" had size " + getFirstSizeNotEqual(xs, 0).length + " instead of expected size 0 (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstSizeNotEqual(xs, 0) + "\" had size " + getFirstSizeNotEqual(xs, 0).length + " instead of expected size 0")
  }
  def `Seq("", "boom!", "") should throw TestFailedException with correct stack depth and message when 'should not have size' failed` {
    val xs = Seq("", "boom!", "")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not have size (0)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeEqual(xs, 0)) + ", \"" + getFirstSizeEqual(xs, 0) + "\" had size 0 (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstSizeEqual(xs, 0) + "\" had size 0")
  }
  def `Array("", "boom!", "") should throw TestFailedException with correct stack depth and message when 'should have length' failed` {
    val xs = Array("", "boom!", "")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should have length 0
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstLengthNotEqual(xs, 0)) + ", \"" + getFirstLengthNotEqual(xs, 0) + "\" had length " + getFirstLengthNotEqual(xs, 0).length + " instead of expected length 0 (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + "WrappedArray(, boom!, )", "\"" + getFirstLengthNotEqual(xs, 0) + "\" had length " + getFirstLengthNotEqual(xs, 0).length + " instead of expected length 0")
  }
  def `Array("", "boom!", "") should throw TestFailedException with correct stack depth and message when 'should not have length' failed` {
    val xs = Array("", "boom!", "")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not have length (0)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstLengthEqual(xs, 0)) + ", \"" + getFirstLengthEqual(xs, 0) + "\" had length 0 (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + "WrappedArray(, boom!, )", "\"" + getFirstLengthEqual(xs, 0) + "\" had length 0")
  }
  def `Array("", "boom!", "") should throw TestFailedException with correct stack depth and message when 'should have size' failed` {
    val xs = Array("", "boom!", "")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should have size 0
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeNotEqual(xs, 0)) + ", \"" + getFirstSizeNotEqual(xs, 0) + "\" had size " + getFirstSizeNotEqual(xs, 0).length + " instead of expected size 0 (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + "WrappedArray(, boom!, )", "\"" + getFirstSizeNotEqual(xs, 0) + "\" had size " + getFirstSizeNotEqual(xs, 0).length + " instead of expected size 0")
  }
  def `Array("", "boom!", "") should throw TestFailedException with correct stack depth and message when 'should not have size' failed` {
    val xs = Array("", "boom!", "")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not have size (0)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeEqual(xs, 0)) + ", \"" + getFirstSizeEqual(xs, 0) + "\" had size 0 (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + "WrappedArray(, boom!, )", "\"" + getFirstSizeEqual(xs, 0) + "\" had size 0")
  }
  def `IndexedSeq("", "boom!", "") should throw TestFailedException with correct stack depth and message when 'should have length' failed` {
    val xs = IndexedSeq("", "boom!", "")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should have length 0
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstLengthNotEqual(xs, 0)) + ", \"" + getFirstLengthNotEqual(xs, 0) + "\" had length " + getFirstLengthNotEqual(xs, 0).length + " instead of expected length 0 (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstLengthNotEqual(xs, 0) + "\" had length " + getFirstLengthNotEqual(xs, 0).length + " instead of expected length 0")
  }
  def `IndexedSeq("", "boom!", "") should throw TestFailedException with correct stack depth and message when 'should not have length' failed` {
    val xs = IndexedSeq("", "boom!", "")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not have length (0)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstLengthEqual(xs, 0)) + ", \"" + getFirstLengthEqual(xs, 0) + "\" had length 0 (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstLengthEqual(xs, 0) + "\" had length 0")
  }
  def `IndexedSeq("", "boom!", "") should throw TestFailedException with correct stack depth and message when 'should have size' failed` {
    val xs = IndexedSeq("", "boom!", "")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should have size 0
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeNotEqual(xs, 0)) + ", \"" + getFirstSizeNotEqual(xs, 0) + "\" had size " + getFirstSizeNotEqual(xs, 0).length + " instead of expected size 0 (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstSizeNotEqual(xs, 0) + "\" had size " + getFirstSizeNotEqual(xs, 0).length + " instead of expected size 0")
  }
  def `IndexedSeq("", "boom!", "") should throw TestFailedException with correct stack depth and message when 'should not have size' failed` {
    val xs = IndexedSeq("", "boom!", "")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not have size (0)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeEqual(xs, 0)) + ", \"" + getFirstSizeEqual(xs, 0) + "\" had size 0 (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstSizeEqual(xs, 0) + "\" had size 0")
  }
  def `Vector("", "boom!", "") should throw TestFailedException with correct stack depth and message when 'should have length' failed` {
    val xs = Vector("", "boom!", "")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should have length 0
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstLengthNotEqual(xs, 0)) + ", \"" + getFirstLengthNotEqual(xs, 0) + "\" had length " + getFirstLengthNotEqual(xs, 0).length + " instead of expected length 0 (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstLengthNotEqual(xs, 0) + "\" had length " + getFirstLengthNotEqual(xs, 0).length + " instead of expected length 0")
  }
  def `Vector("", "boom!", "") should throw TestFailedException with correct stack depth and message when 'should not have length' failed` {
    val xs = Vector("", "boom!", "")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not have length (0)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstLengthEqual(xs, 0)) + ", \"" + getFirstLengthEqual(xs, 0) + "\" had length 0 (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstLengthEqual(xs, 0) + "\" had length 0")
  }
  def `Vector("", "boom!", "") should throw TestFailedException with correct stack depth and message when 'should have size' failed` {
    val xs = Vector("", "boom!", "")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should have size 0
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeNotEqual(xs, 0)) + ", \"" + getFirstSizeNotEqual(xs, 0) + "\" had size " + getFirstSizeNotEqual(xs, 0).length + " instead of expected size 0 (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstSizeNotEqual(xs, 0) + "\" had size " + getFirstSizeNotEqual(xs, 0).length + " instead of expected size 0")
  }
  def `Vector("", "boom!", "") should throw TestFailedException with correct stack depth and message when 'should not have size' failed` {
    val xs = Vector("", "boom!", "")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not have size (0)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeEqual(xs, 0)) + ", \"" + getFirstSizeEqual(xs, 0) + "\" had size 0 (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstSizeEqual(xs, 0) + "\" had size 0")
  }
  def `Set("", "boom!", "").par should throw TestFailedException with correct stack depth and message when 'should have size' failed` {
    val xs = Set("", "boom!", "").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should have size 0
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeNotEqual(xs, 0)) + ", \"" + getFirstSizeNotEqual(xs, 0) + "\" had size " + getFirstSizeNotEqual(xs, 0).length + " instead of expected size 0 (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstSizeNotEqual(xs, 0) + "\" had size " + getFirstSizeNotEqual(xs, 0).length + " instead of expected size 0")
  }
  def `Set("", "boom!", "").par should throw TestFailedException with correct stack depth and message when 'should not have size' failed` {
    val xs = Set("", "boom!", "").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not have size (0)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeEqual(xs, 0)) + ", \"" + getFirstSizeEqual(xs, 0) + "\" had size 0 (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstSizeEqual(xs, 0) + "\" had size 0")
  }
  def `List("", "boom!", "").par should throw TestFailedException with correct stack depth and message when 'should have length' failed` {
    val xs = List("", "boom!", "").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should have length 0
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstLengthNotEqual(xs, 0)) + ", \"" + getFirstLengthNotEqual(xs, 0) + "\" had length " + getFirstLengthNotEqual(xs, 0).length + " instead of expected length 0 (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstLengthNotEqual(xs, 0) + "\" had length " + getFirstLengthNotEqual(xs, 0).length + " instead of expected length 0")
  }
  def `List("", "boom!", "").par should throw TestFailedException with correct stack depth and message when 'should not have length' failed` {
    val xs = List("", "boom!", "").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not have length (0)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstLengthEqual(xs, 0)) + ", \"" + getFirstLengthEqual(xs, 0) + "\" had length 0 (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstLengthEqual(xs, 0) + "\" had length 0")
  }
  def `List("", "boom!", "").par should throw TestFailedException with correct stack depth and message when 'should have size' failed` {
    val xs = List("", "boom!", "").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should have size 0
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeNotEqual(xs, 0)) + ", \"" + getFirstSizeNotEqual(xs, 0) + "\" had size " + getFirstSizeNotEqual(xs, 0).length + " instead of expected size 0 (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstSizeNotEqual(xs, 0) + "\" had size " + getFirstSizeNotEqual(xs, 0).length + " instead of expected size 0")
  }
  def `List("", "boom!", "").par should throw TestFailedException with correct stack depth and message when 'should not have size' failed` {
    val xs = List("", "boom!", "").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not have size (0)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeEqual(xs, 0)) + ", \"" + getFirstSizeEqual(xs, 0) + "\" had size 0 (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstSizeEqual(xs, 0) + "\" had size 0")
  }
  def `Seq("", "boom!", "").par should throw TestFailedException with correct stack depth and message when 'should have length' failed` {
    val xs = Seq("", "boom!", "").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should have length 0
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstLengthNotEqual(xs, 0)) + ", \"" + getFirstLengthNotEqual(xs, 0) + "\" had length " + getFirstLengthNotEqual(xs, 0).length + " instead of expected length 0 (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstLengthNotEqual(xs, 0) + "\" had length " + getFirstLengthNotEqual(xs, 0).length + " instead of expected length 0")
  }
  def `Seq("", "boom!", "").par should throw TestFailedException with correct stack depth and message when 'should not have length' failed` {
    val xs = Seq("", "boom!", "").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not have length (0)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstLengthEqual(xs, 0)) + ", \"" + getFirstLengthEqual(xs, 0) + "\" had length 0 (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstLengthEqual(xs, 0) + "\" had length 0")
  }
  def `Seq("", "boom!", "").par should throw TestFailedException with correct stack depth and message when 'should have size' failed` {
    val xs = Seq("", "boom!", "").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should have size 0
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeNotEqual(xs, 0)) + ", \"" + getFirstSizeNotEqual(xs, 0) + "\" had size " + getFirstSizeNotEqual(xs, 0).length + " instead of expected size 0 (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstSizeNotEqual(xs, 0) + "\" had size " + getFirstSizeNotEqual(xs, 0).length + " instead of expected size 0")
  }
  def `Seq("", "boom!", "").par should throw TestFailedException with correct stack depth and message when 'should not have size' failed` {
    val xs = Seq("", "boom!", "").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not have size (0)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeEqual(xs, 0)) + ", \"" + getFirstSizeEqual(xs, 0) + "\" had size 0 (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstSizeEqual(xs, 0) + "\" had size 0")
  }
  def `IndexedSeq("", "boom!", "").par should throw TestFailedException with correct stack depth and message when 'should have length' failed` {
    val xs = IndexedSeq("", "boom!", "").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should have length 0
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstLengthNotEqual(xs, 0)) + ", \"" + getFirstLengthNotEqual(xs, 0) + "\" had length " + getFirstLengthNotEqual(xs, 0).length + " instead of expected length 0 (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstLengthNotEqual(xs, 0) + "\" had length " + getFirstLengthNotEqual(xs, 0).length + " instead of expected length 0")
  }
  def `IndexedSeq("", "boom!", "").par should throw TestFailedException with correct stack depth and message when 'should not have length' failed` {
    val xs = IndexedSeq("", "boom!", "").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not have length (0)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstLengthEqual(xs, 0)) + ", \"" + getFirstLengthEqual(xs, 0) + "\" had length 0 (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstLengthEqual(xs, 0) + "\" had length 0")
  }
  def `IndexedSeq("", "boom!", "").par should throw TestFailedException with correct stack depth and message when 'should have size' failed` {
    val xs = IndexedSeq("", "boom!", "").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should have size 0
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeNotEqual(xs, 0)) + ", \"" + getFirstSizeNotEqual(xs, 0) + "\" had size " + getFirstSizeNotEqual(xs, 0).length + " instead of expected size 0 (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstSizeNotEqual(xs, 0) + "\" had size " + getFirstSizeNotEqual(xs, 0).length + " instead of expected size 0")
  }
  def `IndexedSeq("", "boom!", "").par should throw TestFailedException with correct stack depth and message when 'should not have size' failed` {
    val xs = IndexedSeq("", "boom!", "").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not have size (0)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeEqual(xs, 0)) + ", \"" + getFirstSizeEqual(xs, 0) + "\" had size 0 (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstSizeEqual(xs, 0) + "\" had size 0")
  }
  def `collection.mutable.Set("", "boom!", "") should throw TestFailedException with correct stack depth and message when 'should have size' failed` {
    val xs = collection.mutable.Set("", "boom!", "")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should have size 0
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeNotEqual(xs, 0)) + ", \"" + getFirstSizeNotEqual(xs, 0) + "\" had size " + getFirstSizeNotEqual(xs, 0).length + " instead of expected size 0 (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstSizeNotEqual(xs, 0) + "\" had size " + getFirstSizeNotEqual(xs, 0).length + " instead of expected size 0")
  }
  def `collection.mutable.Set("", "boom!", "") should throw TestFailedException with correct stack depth and message when 'should not have size' failed` {
    val xs = collection.mutable.Set("", "boom!", "")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not have size (0)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeEqual(xs, 0)) + ", \"" + getFirstSizeEqual(xs, 0) + "\" had size 0 (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstSizeEqual(xs, 0) + "\" had size 0")
  }
  def `new collection.mutable.ListBuffer() ++ List("", "boom!", "") should throw TestFailedException with correct stack depth and message when 'should have length' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List("", "boom!", "")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should have length 0
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstLengthNotEqual(xs, 0)) + ", \"" + getFirstLengthNotEqual(xs, 0) + "\" had length " + getFirstLengthNotEqual(xs, 0).length + " instead of expected length 0 (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstLengthNotEqual(xs, 0) + "\" had length " + getFirstLengthNotEqual(xs, 0).length + " instead of expected length 0")
  }
  def `new collection.mutable.ListBuffer() ++ List("", "boom!", "") should throw TestFailedException with correct stack depth and message when 'should not have length' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List("", "boom!", "")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not have length (0)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstLengthEqual(xs, 0)) + ", \"" + getFirstLengthEqual(xs, 0) + "\" had length 0 (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstLengthEqual(xs, 0) + "\" had length 0")
  }
  def `new collection.mutable.ListBuffer() ++ List("", "boom!", "") should throw TestFailedException with correct stack depth and message when 'should have size' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List("", "boom!", "")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should have size 0
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeNotEqual(xs, 0)) + ", \"" + getFirstSizeNotEqual(xs, 0) + "\" had size " + getFirstSizeNotEqual(xs, 0).length + " instead of expected size 0 (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstSizeNotEqual(xs, 0) + "\" had size " + getFirstSizeNotEqual(xs, 0).length + " instead of expected size 0")
  }
  def `new collection.mutable.ListBuffer() ++ List("", "boom!", "") should throw TestFailedException with correct stack depth and message when 'should not have size' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List("", "boom!", "")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not have size (0)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeEqual(xs, 0)) + ", \"" + getFirstSizeEqual(xs, 0) + "\" had size 0 (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstSizeEqual(xs, 0) + "\" had size 0")
  }
  def `collection.mutable.Seq("", "boom!", "") should throw TestFailedException with correct stack depth and message when 'should have length' failed` {
    val xs = collection.mutable.Seq("", "boom!", "")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should have length 0
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstLengthNotEqual(xs, 0)) + ", \"" + getFirstLengthNotEqual(xs, 0) + "\" had length " + getFirstLengthNotEqual(xs, 0).length + " instead of expected length 0 (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstLengthNotEqual(xs, 0) + "\" had length " + getFirstLengthNotEqual(xs, 0).length + " instead of expected length 0")
  }
  def `collection.mutable.Seq("", "boom!", "") should throw TestFailedException with correct stack depth and message when 'should not have length' failed` {
    val xs = collection.mutable.Seq("", "boom!", "")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not have length (0)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstLengthEqual(xs, 0)) + ", \"" + getFirstLengthEqual(xs, 0) + "\" had length 0 (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstLengthEqual(xs, 0) + "\" had length 0")
  }
  def `collection.mutable.Seq("", "boom!", "") should throw TestFailedException with correct stack depth and message when 'should have size' failed` {
    val xs = collection.mutable.Seq("", "boom!", "")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should have size 0
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeNotEqual(xs, 0)) + ", \"" + getFirstSizeNotEqual(xs, 0) + "\" had size " + getFirstSizeNotEqual(xs, 0).length + " instead of expected size 0 (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstSizeNotEqual(xs, 0) + "\" had size " + getFirstSizeNotEqual(xs, 0).length + " instead of expected size 0")
  }
  def `collection.mutable.Seq("", "boom!", "") should throw TestFailedException with correct stack depth and message when 'should not have size' failed` {
    val xs = collection.mutable.Seq("", "boom!", "")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not have size (0)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeEqual(xs, 0)) + ", \"" + getFirstSizeEqual(xs, 0) + "\" had size 0 (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstSizeEqual(xs, 0) + "\" had size 0")
  }
  def `collection.mutable.IndexedSeq("", "boom!", "") should throw TestFailedException with correct stack depth and message when 'should have length' failed` {
    val xs = collection.mutable.IndexedSeq("", "boom!", "")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should have length 0
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstLengthNotEqual(xs, 0)) + ", \"" + getFirstLengthNotEqual(xs, 0) + "\" had length " + getFirstLengthNotEqual(xs, 0).length + " instead of expected length 0 (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstLengthNotEqual(xs, 0) + "\" had length " + getFirstLengthNotEqual(xs, 0).length + " instead of expected length 0")
  }
  def `collection.mutable.IndexedSeq("", "boom!", "") should throw TestFailedException with correct stack depth and message when 'should not have length' failed` {
    val xs = collection.mutable.IndexedSeq("", "boom!", "")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not have length (0)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstLengthEqual(xs, 0)) + ", \"" + getFirstLengthEqual(xs, 0) + "\" had length 0 (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstLengthEqual(xs, 0) + "\" had length 0")
  }
  def `collection.mutable.IndexedSeq("", "boom!", "") should throw TestFailedException with correct stack depth and message when 'should have size' failed` {
    val xs = collection.mutable.IndexedSeq("", "boom!", "")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should have size 0
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeNotEqual(xs, 0)) + ", \"" + getFirstSizeNotEqual(xs, 0) + "\" had size " + getFirstSizeNotEqual(xs, 0).length + " instead of expected size 0 (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstSizeNotEqual(xs, 0) + "\" had size " + getFirstSizeNotEqual(xs, 0).length + " instead of expected size 0")
  }
  def `collection.mutable.IndexedSeq("", "boom!", "") should throw TestFailedException with correct stack depth and message when 'should not have size' failed` {
    val xs = collection.mutable.IndexedSeq("", "boom!", "")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not have size (0)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeEqual(xs, 0)) + ", \"" + getFirstSizeEqual(xs, 0) + "\" had size 0 (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstSizeEqual(xs, 0) + "\" had size 0")
  }
  def `collection.mutable.Set("", "boom!", "").par should throw TestFailedException with correct stack depth and message when 'should have size' failed` {
    val xs = collection.mutable.Set("", "boom!", "").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should have size 0
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeNotEqual(xs, 0)) + ", \"" + getFirstSizeNotEqual(xs, 0) + "\" had size " + getFirstSizeNotEqual(xs, 0).length + " instead of expected size 0 (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstSizeNotEqual(xs, 0) + "\" had size " + getFirstSizeNotEqual(xs, 0).length + " instead of expected size 0")
  }
  def `collection.mutable.Set("", "boom!", "").par should throw TestFailedException with correct stack depth and message when 'should not have size' failed` {
    val xs = collection.mutable.Set("", "boom!", "").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not have size (0)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeEqual(xs, 0)) + ", \"" + getFirstSizeEqual(xs, 0) + "\" had size 0 (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstSizeEqual(xs, 0) + "\" had size 0")
  }
  def `(new collection.mutable.ListBuffer() ++ List("", "boom!", "")).par should throw TestFailedException with correct stack depth and message when 'should have length' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List("", "boom!", "")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should have length 0
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstLengthNotEqual(xs, 0)) + ", \"" + getFirstLengthNotEqual(xs, 0) + "\" had length " + getFirstLengthNotEqual(xs, 0).length + " instead of expected length 0 (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstLengthNotEqual(xs, 0) + "\" had length " + getFirstLengthNotEqual(xs, 0).length + " instead of expected length 0")
  }
  def `(new collection.mutable.ListBuffer() ++ List("", "boom!", "")).par should throw TestFailedException with correct stack depth and message when 'should not have length' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List("", "boom!", "")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not have length (0)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstLengthEqual(xs, 0)) + ", \"" + getFirstLengthEqual(xs, 0) + "\" had length 0 (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstLengthEqual(xs, 0) + "\" had length 0")
  }
  def `(new collection.mutable.ListBuffer() ++ List("", "boom!", "")).par should throw TestFailedException with correct stack depth and message when 'should have size' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List("", "boom!", "")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should have size 0
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeNotEqual(xs, 0)) + ", \"" + getFirstSizeNotEqual(xs, 0) + "\" had size " + getFirstSizeNotEqual(xs, 0).length + " instead of expected size 0 (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstSizeNotEqual(xs, 0) + "\" had size " + getFirstSizeNotEqual(xs, 0).length + " instead of expected size 0")
  }
  def `(new collection.mutable.ListBuffer() ++ List("", "boom!", "")).par should throw TestFailedException with correct stack depth and message when 'should not have size' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List("", "boom!", "")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not have size (0)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeEqual(xs, 0)) + ", \"" + getFirstSizeEqual(xs, 0) + "\" had size 0 (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstSizeEqual(xs, 0) + "\" had size 0")
  }
  def `collection.mutable.Seq("", "boom!", "").par should throw TestFailedException with correct stack depth and message when 'should have length' failed` {
    val xs = collection.mutable.Seq("", "boom!", "").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should have length 0
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstLengthNotEqual(xs, 0)) + ", \"" + getFirstLengthNotEqual(xs, 0) + "\" had length " + getFirstLengthNotEqual(xs, 0).length + " instead of expected length 0 (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstLengthNotEqual(xs, 0) + "\" had length " + getFirstLengthNotEqual(xs, 0).length + " instead of expected length 0")
  }
  def `collection.mutable.Seq("", "boom!", "").par should throw TestFailedException with correct stack depth and message when 'should not have length' failed` {
    val xs = collection.mutable.Seq("", "boom!", "").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not have length (0)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstLengthEqual(xs, 0)) + ", \"" + getFirstLengthEqual(xs, 0) + "\" had length 0 (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstLengthEqual(xs, 0) + "\" had length 0")
  }
  def `collection.mutable.Seq("", "boom!", "").par should throw TestFailedException with correct stack depth and message when 'should have size' failed` {
    val xs = collection.mutable.Seq("", "boom!", "").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should have size 0
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeNotEqual(xs, 0)) + ", \"" + getFirstSizeNotEqual(xs, 0) + "\" had size " + getFirstSizeNotEqual(xs, 0).length + " instead of expected size 0 (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstSizeNotEqual(xs, 0) + "\" had size " + getFirstSizeNotEqual(xs, 0).length + " instead of expected size 0")
  }
  def `collection.mutable.Seq("", "boom!", "").par should throw TestFailedException with correct stack depth and message when 'should not have size' failed` {
    val xs = collection.mutable.Seq("", "boom!", "").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not have size (0)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeEqual(xs, 0)) + ", \"" + getFirstSizeEqual(xs, 0) + "\" had size 0 (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstSizeEqual(xs, 0) + "\" had size 0")
  }
  def `collection.mutable.IndexedSeq("", "boom!", "").par should throw TestFailedException with correct stack depth and message when 'should have length' failed` {
    val xs = collection.mutable.IndexedSeq("", "boom!", "").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should have length 0
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstLengthNotEqual(xs, 0)) + ", \"" + getFirstLengthNotEqual(xs, 0) + "\" had length " + getFirstLengthNotEqual(xs, 0).length + " instead of expected length 0 (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstLengthNotEqual(xs, 0) + "\" had length " + getFirstLengthNotEqual(xs, 0).length + " instead of expected length 0")
  }
  def `collection.mutable.IndexedSeq("", "boom!", "").par should throw TestFailedException with correct stack depth and message when 'should not have length' failed` {
    val xs = collection.mutable.IndexedSeq("", "boom!", "").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not have length (0)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstLengthEqual(xs, 0)) + ", \"" + getFirstLengthEqual(xs, 0) + "\" had length 0 (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstLengthEqual(xs, 0) + "\" had length 0")
  }
  def `collection.mutable.IndexedSeq("", "boom!", "").par should throw TestFailedException with correct stack depth and message when 'should have size' failed` {
    val xs = collection.mutable.IndexedSeq("", "boom!", "").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should have size 0
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeNotEqual(xs, 0)) + ", \"" + getFirstSizeNotEqual(xs, 0) + "\" had size " + getFirstSizeNotEqual(xs, 0).length + " instead of expected size 0 (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstSizeNotEqual(xs, 0) + "\" had size " + getFirstSizeNotEqual(xs, 0).length + " instead of expected size 0")
  }
  def `collection.mutable.IndexedSeq("", "boom!", "").par should throw TestFailedException with correct stack depth and message when 'should not have size' failed` {
    val xs = collection.mutable.IndexedSeq("", "boom!", "").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not have size (0)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeEqual(xs, 0)) + ", \"" + getFirstSizeEqual(xs, 0) + "\" had size 0 (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstSizeEqual(xs, 0) + "\" had size 0")
  }
  def `Set("1", theInstance, "3") should throw TestFailedException with correct stack depth and message when 'should be theSameInstanceAs' failed` {
    val xs = Set("1", theInstance, "3")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should be theSameInstanceAs theInstance
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotRefEqual[String](xs, theInstance)) + ", \"" + getFirstNotRefEqual[String](xs, theInstance) + "\" was not the same instance as \"2\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotRefEqual[String](xs, theInstance) + "\" was not the same instance as \"2\"")
  }
  def `Set("1", theInstance, "3") should throw TestFailedException with correct stack depth and message when 'should not be theSameInstanceAs' failed` {
    val xs = Set("1", theInstance, "3")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not be theSameInstanceAs (theInstance)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstRefEqual[String](xs, theInstance)) + ", \"" + getFirstRefEqual[String](xs, theInstance) + "\" was the same instance as \"2\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstRefEqual[String](xs, theInstance) + "\" was the same instance as \"2\"")
  }
  def `List("1", theInstance, "3") should throw TestFailedException with correct stack depth and message when 'should be theSameInstanceAs' failed` {
    val xs = List("1", theInstance, "3")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should be theSameInstanceAs theInstance
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotRefEqual[String](xs, theInstance)) + ", \"" + getFirstNotRefEqual[String](xs, theInstance) + "\" was not the same instance as \"2\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotRefEqual[String](xs, theInstance) + "\" was not the same instance as \"2\"")
  }
  def `List("1", theInstance, "3") should throw TestFailedException with correct stack depth and message when 'should not be theSameInstanceAs' failed` {
    val xs = List("1", theInstance, "3")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not be theSameInstanceAs (theInstance)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstRefEqual[String](xs, theInstance)) + ", \"" + getFirstRefEqual[String](xs, theInstance) + "\" was the same instance as \"2\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstRefEqual[String](xs, theInstance) + "\" was the same instance as \"2\"")
  }
  def `Seq("1", theInstance, "3") should throw TestFailedException with correct stack depth and message when 'should be theSameInstanceAs' failed` {
    val xs = Seq("1", theInstance, "3")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should be theSameInstanceAs theInstance
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotRefEqual[String](xs, theInstance)) + ", \"" + getFirstNotRefEqual[String](xs, theInstance) + "\" was not the same instance as \"2\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotRefEqual[String](xs, theInstance) + "\" was not the same instance as \"2\"")
  }
  def `Seq("1", theInstance, "3") should throw TestFailedException with correct stack depth and message when 'should not be theSameInstanceAs' failed` {
    val xs = Seq("1", theInstance, "3")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not be theSameInstanceAs (theInstance)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstRefEqual[String](xs, theInstance)) + ", \"" + getFirstRefEqual[String](xs, theInstance) + "\" was the same instance as \"2\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstRefEqual[String](xs, theInstance) + "\" was the same instance as \"2\"")
  }
  def `Array("1", theInstance, "3") should throw TestFailedException with correct stack depth and message when 'should be theSameInstanceAs' failed` {
    val xs = Array("1", theInstance, "3")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should be theSameInstanceAs theInstance
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotRefEqual[String](xs, theInstance)) + ", \"" + getFirstNotRefEqual[String](xs, theInstance) + "\" was not the same instance as \"2\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + "WrappedArray(1, 2, 3)", "\"" + getFirstNotRefEqual[String](xs, theInstance) + "\" was not the same instance as \"2\"")
  }
  def `Array("1", theInstance, "3") should throw TestFailedException with correct stack depth and message when 'should not be theSameInstanceAs' failed` {
    val xs = Array("1", theInstance, "3")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not be theSameInstanceAs (theInstance)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstRefEqual[String](xs, theInstance)) + ", \"" + getFirstRefEqual[String](xs, theInstance) + "\" was the same instance as \"2\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + "WrappedArray(1, 2, 3)", "\"" + getFirstRefEqual[String](xs, theInstance) + "\" was the same instance as \"2\"")
  }
  def `IndexedSeq("1", theInstance, "3") should throw TestFailedException with correct stack depth and message when 'should be theSameInstanceAs' failed` {
    val xs = IndexedSeq("1", theInstance, "3")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should be theSameInstanceAs theInstance
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotRefEqual[String](xs, theInstance)) + ", \"" + getFirstNotRefEqual[String](xs, theInstance) + "\" was not the same instance as \"2\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotRefEqual[String](xs, theInstance) + "\" was not the same instance as \"2\"")
  }
  def `IndexedSeq("1", theInstance, "3") should throw TestFailedException with correct stack depth and message when 'should not be theSameInstanceAs' failed` {
    val xs = IndexedSeq("1", theInstance, "3")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not be theSameInstanceAs (theInstance)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstRefEqual[String](xs, theInstance)) + ", \"" + getFirstRefEqual[String](xs, theInstance) + "\" was the same instance as \"2\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstRefEqual[String](xs, theInstance) + "\" was the same instance as \"2\"")
  }
  def `Vector("1", theInstance, "3") should throw TestFailedException with correct stack depth and message when 'should be theSameInstanceAs' failed` {
    val xs = Vector("1", theInstance, "3")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should be theSameInstanceAs theInstance
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotRefEqual[String](xs, theInstance)) + ", \"" + getFirstNotRefEqual[String](xs, theInstance) + "\" was not the same instance as \"2\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotRefEqual[String](xs, theInstance) + "\" was not the same instance as \"2\"")
  }
  def `Vector("1", theInstance, "3") should throw TestFailedException with correct stack depth and message when 'should not be theSameInstanceAs' failed` {
    val xs = Vector("1", theInstance, "3")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not be theSameInstanceAs (theInstance)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstRefEqual[String](xs, theInstance)) + ", \"" + getFirstRefEqual[String](xs, theInstance) + "\" was the same instance as \"2\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstRefEqual[String](xs, theInstance) + "\" was the same instance as \"2\"")
  }
  def `Set("1", theInstance, "3").par should throw TestFailedException with correct stack depth and message when 'should be theSameInstanceAs' failed` {
    val xs = Set("1", theInstance, "3").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should be theSameInstanceAs theInstance
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotRefEqual[String](xs, theInstance)) + ", \"" + getFirstNotRefEqual[String](xs, theInstance) + "\" was not the same instance as \"2\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotRefEqual[String](xs, theInstance) + "\" was not the same instance as \"2\"")
  }
  def `Set("1", theInstance, "3").par should throw TestFailedException with correct stack depth and message when 'should not be theSameInstanceAs' failed` {
    val xs = Set("1", theInstance, "3").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not be theSameInstanceAs (theInstance)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstRefEqual[String](xs, theInstance)) + ", \"" + getFirstRefEqual[String](xs, theInstance) + "\" was the same instance as \"2\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstRefEqual[String](xs, theInstance) + "\" was the same instance as \"2\"")
  }
  def `List("1", theInstance, "3").par should throw TestFailedException with correct stack depth and message when 'should be theSameInstanceAs' failed` {
    val xs = List("1", theInstance, "3").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should be theSameInstanceAs theInstance
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotRefEqual[String](xs, theInstance)) + ", \"" + getFirstNotRefEqual[String](xs, theInstance) + "\" was not the same instance as \"2\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotRefEqual[String](xs, theInstance) + "\" was not the same instance as \"2\"")
  }
  def `List("1", theInstance, "3").par should throw TestFailedException with correct stack depth and message when 'should not be theSameInstanceAs' failed` {
    val xs = List("1", theInstance, "3").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not be theSameInstanceAs (theInstance)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstRefEqual[String](xs, theInstance)) + ", \"" + getFirstRefEqual[String](xs, theInstance) + "\" was the same instance as \"2\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstRefEqual[String](xs, theInstance) + "\" was the same instance as \"2\"")
  }
  def `Seq("1", theInstance, "3").par should throw TestFailedException with correct stack depth and message when 'should be theSameInstanceAs' failed` {
    val xs = Seq("1", theInstance, "3").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should be theSameInstanceAs theInstance
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotRefEqual[String](xs, theInstance)) + ", \"" + getFirstNotRefEqual[String](xs, theInstance) + "\" was not the same instance as \"2\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotRefEqual[String](xs, theInstance) + "\" was not the same instance as \"2\"")
  }
  def `Seq("1", theInstance, "3").par should throw TestFailedException with correct stack depth and message when 'should not be theSameInstanceAs' failed` {
    val xs = Seq("1", theInstance, "3").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not be theSameInstanceAs (theInstance)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstRefEqual[String](xs, theInstance)) + ", \"" + getFirstRefEqual[String](xs, theInstance) + "\" was the same instance as \"2\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstRefEqual[String](xs, theInstance) + "\" was the same instance as \"2\"")
  }
  def `IndexedSeq("1", theInstance, "3").par should throw TestFailedException with correct stack depth and message when 'should be theSameInstanceAs' failed` {
    val xs = IndexedSeq("1", theInstance, "3").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should be theSameInstanceAs theInstance
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotRefEqual[String](xs, theInstance)) + ", \"" + getFirstNotRefEqual[String](xs, theInstance) + "\" was not the same instance as \"2\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotRefEqual[String](xs, theInstance) + "\" was not the same instance as \"2\"")
  }
  def `IndexedSeq("1", theInstance, "3").par should throw TestFailedException with correct stack depth and message when 'should not be theSameInstanceAs' failed` {
    val xs = IndexedSeq("1", theInstance, "3").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not be theSameInstanceAs (theInstance)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstRefEqual[String](xs, theInstance)) + ", \"" + getFirstRefEqual[String](xs, theInstance) + "\" was the same instance as \"2\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstRefEqual[String](xs, theInstance) + "\" was the same instance as \"2\"")
  }
  def `collection.mutable.Set("1", theInstance, "3") should throw TestFailedException with correct stack depth and message when 'should be theSameInstanceAs' failed` {
    val xs = collection.mutable.Set("1", theInstance, "3")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should be theSameInstanceAs theInstance
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotRefEqual[String](xs, theInstance)) + ", \"" + getFirstNotRefEqual[String](xs, theInstance) + "\" was not the same instance as \"2\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotRefEqual[String](xs, theInstance) + "\" was not the same instance as \"2\"")
  }
  def `collection.mutable.Set("1", theInstance, "3") should throw TestFailedException with correct stack depth and message when 'should not be theSameInstanceAs' failed` {
    val xs = collection.mutable.Set("1", theInstance, "3")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not be theSameInstanceAs (theInstance)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstRefEqual[String](xs, theInstance)) + ", \"" + getFirstRefEqual[String](xs, theInstance) + "\" was the same instance as \"2\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstRefEqual[String](xs, theInstance) + "\" was the same instance as \"2\"")
  }
  def `new collection.mutable.ListBuffer() ++ List("1", theInstance, "3") should throw TestFailedException with correct stack depth and message when 'should be theSameInstanceAs' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List("1", theInstance, "3")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should be theSameInstanceAs theInstance
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotRefEqual[String](xs, theInstance)) + ", \"" + getFirstNotRefEqual[String](xs, theInstance) + "\" was not the same instance as \"2\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotRefEqual[String](xs, theInstance) + "\" was not the same instance as \"2\"")
  }
  def `new collection.mutable.ListBuffer() ++ List("1", theInstance, "3") should throw TestFailedException with correct stack depth and message when 'should not be theSameInstanceAs' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List("1", theInstance, "3")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not be theSameInstanceAs (theInstance)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstRefEqual[String](xs, theInstance)) + ", \"" + getFirstRefEqual[String](xs, theInstance) + "\" was the same instance as \"2\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstRefEqual[String](xs, theInstance) + "\" was the same instance as \"2\"")
  }
  def `collection.mutable.Seq("1", theInstance, "3") should throw TestFailedException with correct stack depth and message when 'should be theSameInstanceAs' failed` {
    val xs = collection.mutable.Seq("1", theInstance, "3")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should be theSameInstanceAs theInstance
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotRefEqual[String](xs, theInstance)) + ", \"" + getFirstNotRefEqual[String](xs, theInstance) + "\" was not the same instance as \"2\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotRefEqual[String](xs, theInstance) + "\" was not the same instance as \"2\"")
  }
  def `collection.mutable.Seq("1", theInstance, "3") should throw TestFailedException with correct stack depth and message when 'should not be theSameInstanceAs' failed` {
    val xs = collection.mutable.Seq("1", theInstance, "3")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not be theSameInstanceAs (theInstance)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstRefEqual[String](xs, theInstance)) + ", \"" + getFirstRefEqual[String](xs, theInstance) + "\" was the same instance as \"2\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstRefEqual[String](xs, theInstance) + "\" was the same instance as \"2\"")
  }
  def `collection.mutable.IndexedSeq("1", theInstance, "3") should throw TestFailedException with correct stack depth and message when 'should be theSameInstanceAs' failed` {
    val xs = collection.mutable.IndexedSeq("1", theInstance, "3")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should be theSameInstanceAs theInstance
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotRefEqual[String](xs, theInstance)) + ", \"" + getFirstNotRefEqual[String](xs, theInstance) + "\" was not the same instance as \"2\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotRefEqual[String](xs, theInstance) + "\" was not the same instance as \"2\"")
  }
  def `collection.mutable.IndexedSeq("1", theInstance, "3") should throw TestFailedException with correct stack depth and message when 'should not be theSameInstanceAs' failed` {
    val xs = collection.mutable.IndexedSeq("1", theInstance, "3")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not be theSameInstanceAs (theInstance)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstRefEqual[String](xs, theInstance)) + ", \"" + getFirstRefEqual[String](xs, theInstance) + "\" was the same instance as \"2\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstRefEqual[String](xs, theInstance) + "\" was the same instance as \"2\"")
  }
  def `collection.mutable.Set("1", theInstance, "3").par should throw TestFailedException with correct stack depth and message when 'should be theSameInstanceAs' failed` {
    val xs = collection.mutable.Set("1", theInstance, "3").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should be theSameInstanceAs theInstance
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotRefEqual[String](xs, theInstance)) + ", \"" + getFirstNotRefEqual[String](xs, theInstance) + "\" was not the same instance as \"2\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotRefEqual[String](xs, theInstance) + "\" was not the same instance as \"2\"")
  }
  def `collection.mutable.Set("1", theInstance, "3").par should throw TestFailedException with correct stack depth and message when 'should not be theSameInstanceAs' failed` {
    val xs = collection.mutable.Set("1", theInstance, "3").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not be theSameInstanceAs (theInstance)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstRefEqual[String](xs, theInstance)) + ", \"" + getFirstRefEqual[String](xs, theInstance) + "\" was the same instance as \"2\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstRefEqual[String](xs, theInstance) + "\" was the same instance as \"2\"")
  }
  def `(new collection.mutable.ListBuffer() ++ List("1", theInstance, "3")).par should throw TestFailedException with correct stack depth and message when 'should be theSameInstanceAs' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List("1", theInstance, "3")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should be theSameInstanceAs theInstance
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotRefEqual[String](xs, theInstance)) + ", \"" + getFirstNotRefEqual[String](xs, theInstance) + "\" was not the same instance as \"2\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotRefEqual[String](xs, theInstance) + "\" was not the same instance as \"2\"")
  }
  def `(new collection.mutable.ListBuffer() ++ List("1", theInstance, "3")).par should throw TestFailedException with correct stack depth and message when 'should not be theSameInstanceAs' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List("1", theInstance, "3")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not be theSameInstanceAs (theInstance)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstRefEqual[String](xs, theInstance)) + ", \"" + getFirstRefEqual[String](xs, theInstance) + "\" was the same instance as \"2\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstRefEqual[String](xs, theInstance) + "\" was the same instance as \"2\"")
  }
  def `collection.mutable.Seq("1", theInstance, "3").par should throw TestFailedException with correct stack depth and message when 'should be theSameInstanceAs' failed` {
    val xs = collection.mutable.Seq("1", theInstance, "3").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should be theSameInstanceAs theInstance
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotRefEqual[String](xs, theInstance)) + ", \"" + getFirstNotRefEqual[String](xs, theInstance) + "\" was not the same instance as \"2\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotRefEqual[String](xs, theInstance) + "\" was not the same instance as \"2\"")
  }
  def `collection.mutable.Seq("1", theInstance, "3").par should throw TestFailedException with correct stack depth and message when 'should not be theSameInstanceAs' failed` {
    val xs = collection.mutable.Seq("1", theInstance, "3").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not be theSameInstanceAs (theInstance)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstRefEqual[String](xs, theInstance)) + ", \"" + getFirstRefEqual[String](xs, theInstance) + "\" was the same instance as \"2\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstRefEqual[String](xs, theInstance) + "\" was the same instance as \"2\"")
  }
  def `collection.mutable.IndexedSeq("1", theInstance, "3").par should throw TestFailedException with correct stack depth and message when 'should be theSameInstanceAs' failed` {
    val xs = collection.mutable.IndexedSeq("1", theInstance, "3").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should be theSameInstanceAs theInstance
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotRefEqual[String](xs, theInstance)) + ", \"" + getFirstNotRefEqual[String](xs, theInstance) + "\" was not the same instance as \"2\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotRefEqual[String](xs, theInstance) + "\" was not the same instance as \"2\"")
  }
  def `collection.mutable.IndexedSeq("1", theInstance, "3").par should throw TestFailedException with correct stack depth and message when 'should not be theSameInstanceAs' failed` {
    val xs = collection.mutable.IndexedSeq("1", theInstance, "3").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not be theSameInstanceAs (theInstance)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstRefEqual[String](xs, theInstance)) + ", \"" + getFirstRefEqual[String](xs, theInstance) + "\" was the same instance as \"2\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstRefEqual[String](xs, theInstance) + "\" was the same instance as \"2\"")
  }
  def `Set("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should startWith' failed` {
    val xs = Set("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should startWith ("hello")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotStartsWith(xs, "hello")) + ", \"" + getFirstNotStartsWith(xs, "hello") + "\" did not start with substring \"hello\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotStartsWith(xs, "hello") + "\" did not start with substring \"hello\"")
  }
  def `Set("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not startWith' failed` {
    val xs = Set("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not startWith ("hello")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstStartsWith(xs, "hello")) + ", \"" + getFirstStartsWith(xs, "hello") + "\" started with substring \"hello\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstStartsWith(xs, "hello") + "\" started with substring \"hello\"")
  }
  def `Set("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should endWith' failed` {
    val xs = Set("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should endWith ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotEndsWith(xs, "!")) + ", \"" + getFirstNotEndsWith(xs, "!") + "\" did not end with substring \"!\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotEndsWith(xs, "!") + "\" did not end with substring \"!\"")
  }
  def `Set("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not endWith' failed` {
    val xs = Set("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not endWith ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstEndsWith(xs, "!")) + ", \"" + getFirstEndsWith(xs, "!") + "\" ended with substring \"!\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstEndsWith(xs, "!") + "\" ended with substring \"!\"")
  }
  def `Set("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should include' failed` {
    val xs = Set("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should include ("ell")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotInclude(xs, "ell")) + ", \"" + getFirstNotInclude(xs, "ell") + "\" did not include substring \"ell\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotInclude(xs, "ell") + "\" did not include substring \"ell\"")
  }
  def `Set("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not include' failed` {
    val xs = Set("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not include "ell"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstInclude(xs, "ell")) + ", \"" + getFirstInclude(xs, "ell") + "\" included substring \"ell\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstInclude(xs, "ell") + "\" included substring \"ell\"")
  }
  def `Set("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should startWith regex' failed` {
    val xs = Set("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should startWith regex "hel*o"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotStartsWith(xs, "hello")) + ", \"" + getFirstNotStartsWith(xs, "hello") + "\" did not start with a substring that matched the regular expression hel*o (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotStartsWith(xs, "hello") + "\" did not start with a substring that matched the regular expression hel*o")
  }
  def `Set("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not startWith regex' failed` {
    val xs = Set("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not startWith regex ("hel*o")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstStartsWith(xs, "hello")) + ", \"" + getFirstStartsWith(xs, "hello") + "\" started with a substring that matched the regular expression hel*o (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstStartsWith(xs, "hello") + "\" started with a substring that matched the regular expression hel*o")
  }
  def `Set("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should endWith regex' failed` {
    val xs = Set("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should endWith regex "!"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotEndsWith(xs, "!")) + ", \"" + getFirstNotEndsWith(xs, "!") + "\" did not end with a substring that matched the regular expression ! (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotEndsWith(xs, "!") + "\" did not end with a substring that matched the regular expression !")
  }
  def `Set("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not endWith regex' failed` {
    val xs = Set("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not endWith regex ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstEndsWith(xs, "!")) + ", \"" + getFirstEndsWith(xs, "!") + "\" ended with a substring that matched the regular expression ! (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstEndsWith(xs, "!") + "\" ended with a substring that matched the regular expression !")
  }
  def `Set("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should include regex' failed` {
    val xs = Set("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should include regex "ell"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotInclude(xs, "ell")) + ", \"" + getFirstNotInclude(xs, "ell") + "\" did not include substring that matched regex ell (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotInclude(xs, "ell") + "\" did not include substring that matched regex ell")
  }
  def `Set("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not include regex' failed` {
    val xs = Set("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not include regex ("ell")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstInclude(xs, "ell")) + ", \"" + getFirstInclude(xs, "ell") + "\" included substring that matched regex ell (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstInclude(xs, "ell") + "\" included substring that matched regex ell")
  }
  def `Set("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should fullyMatch regex' failed` {
    val xs = Set("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should fullyMatch regex "h.*!"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotMatches(xs, "h.*!")) + ", \"" + getFirstNotMatches(xs, "h.*!") + "\" did not fully match the regular expression h.*! (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotMatches(xs, "h.*!") + "\" did not fully match the regular expression h.*!")
  }
  def `Set("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not fullyMatch regex' failed` {
    val xs = Set("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not fullyMatch regex ("h.*!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstMatches(xs, "h.*!")) + ", \"" + getFirstMatches(xs, "h.*!") + "\" fully matched the regular expression h.*! (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstMatches(xs, "h.*!") + "\" fully matched the regular expression h.*!")
  }
  def `List("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should startWith' failed` {
    val xs = List("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should startWith ("hello")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotStartsWith(xs, "hello")) + ", \"" + getFirstNotStartsWith(xs, "hello") + "\" did not start with substring \"hello\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotStartsWith(xs, "hello") + "\" did not start with substring \"hello\"")
  }
  def `List("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not startWith' failed` {
    val xs = List("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not startWith ("hello")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstStartsWith(xs, "hello")) + ", \"" + getFirstStartsWith(xs, "hello") + "\" started with substring \"hello\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstStartsWith(xs, "hello") + "\" started with substring \"hello\"")
  }
  def `List("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should endWith' failed` {
    val xs = List("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should endWith ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotEndsWith(xs, "!")) + ", \"" + getFirstNotEndsWith(xs, "!") + "\" did not end with substring \"!\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotEndsWith(xs, "!") + "\" did not end with substring \"!\"")
  }
  def `List("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not endWith' failed` {
    val xs = List("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not endWith ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstEndsWith(xs, "!")) + ", \"" + getFirstEndsWith(xs, "!") + "\" ended with substring \"!\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstEndsWith(xs, "!") + "\" ended with substring \"!\"")
  }
  def `List("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should include' failed` {
    val xs = List("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should include ("ell")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotInclude(xs, "ell")) + ", \"" + getFirstNotInclude(xs, "ell") + "\" did not include substring \"ell\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotInclude(xs, "ell") + "\" did not include substring \"ell\"")
  }
  def `List("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not include' failed` {
    val xs = List("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not include "ell"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstInclude(xs, "ell")) + ", \"" + getFirstInclude(xs, "ell") + "\" included substring \"ell\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstInclude(xs, "ell") + "\" included substring \"ell\"")
  }
  def `List("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should startWith regex' failed` {
    val xs = List("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should startWith regex "hel*o"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotStartsWith(xs, "hello")) + ", \"" + getFirstNotStartsWith(xs, "hello") + "\" did not start with a substring that matched the regular expression hel*o (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotStartsWith(xs, "hello") + "\" did not start with a substring that matched the regular expression hel*o")
  }
  def `List("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not startWith regex' failed` {
    val xs = List("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not startWith regex ("hel*o")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstStartsWith(xs, "hello")) + ", \"" + getFirstStartsWith(xs, "hello") + "\" started with a substring that matched the regular expression hel*o (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstStartsWith(xs, "hello") + "\" started with a substring that matched the regular expression hel*o")
  }
  def `List("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should endWith regex' failed` {
    val xs = List("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should endWith regex "!"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotEndsWith(xs, "!")) + ", \"" + getFirstNotEndsWith(xs, "!") + "\" did not end with a substring that matched the regular expression ! (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotEndsWith(xs, "!") + "\" did not end with a substring that matched the regular expression !")
  }
  def `List("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not endWith regex' failed` {
    val xs = List("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not endWith regex ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstEndsWith(xs, "!")) + ", \"" + getFirstEndsWith(xs, "!") + "\" ended with a substring that matched the regular expression ! (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstEndsWith(xs, "!") + "\" ended with a substring that matched the regular expression !")
  }
  def `List("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should include regex' failed` {
    val xs = List("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should include regex "ell"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotInclude(xs, "ell")) + ", \"" + getFirstNotInclude(xs, "ell") + "\" did not include substring that matched regex ell (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotInclude(xs, "ell") + "\" did not include substring that matched regex ell")
  }
  def `List("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not include regex' failed` {
    val xs = List("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not include regex ("ell")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstInclude(xs, "ell")) + ", \"" + getFirstInclude(xs, "ell") + "\" included substring that matched regex ell (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstInclude(xs, "ell") + "\" included substring that matched regex ell")
  }
  def `List("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should fullyMatch regex' failed` {
    val xs = List("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should fullyMatch regex "h.*!"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotMatches(xs, "h.*!")) + ", \"" + getFirstNotMatches(xs, "h.*!") + "\" did not fully match the regular expression h.*! (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotMatches(xs, "h.*!") + "\" did not fully match the regular expression h.*!")
  }
  def `List("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not fullyMatch regex' failed` {
    val xs = List("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not fullyMatch regex ("h.*!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstMatches(xs, "h.*!")) + ", \"" + getFirstMatches(xs, "h.*!") + "\" fully matched the regular expression h.*! (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstMatches(xs, "h.*!") + "\" fully matched the regular expression h.*!")
  }
  def `Seq("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should startWith' failed` {
    val xs = Seq("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should startWith ("hello")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotStartsWith(xs, "hello")) + ", \"" + getFirstNotStartsWith(xs, "hello") + "\" did not start with substring \"hello\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotStartsWith(xs, "hello") + "\" did not start with substring \"hello\"")
  }
  def `Seq("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not startWith' failed` {
    val xs = Seq("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not startWith ("hello")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstStartsWith(xs, "hello")) + ", \"" + getFirstStartsWith(xs, "hello") + "\" started with substring \"hello\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstStartsWith(xs, "hello") + "\" started with substring \"hello\"")
  }
  def `Seq("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should endWith' failed` {
    val xs = Seq("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should endWith ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotEndsWith(xs, "!")) + ", \"" + getFirstNotEndsWith(xs, "!") + "\" did not end with substring \"!\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotEndsWith(xs, "!") + "\" did not end with substring \"!\"")
  }
  def `Seq("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not endWith' failed` {
    val xs = Seq("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not endWith ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstEndsWith(xs, "!")) + ", \"" + getFirstEndsWith(xs, "!") + "\" ended with substring \"!\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstEndsWith(xs, "!") + "\" ended with substring \"!\"")
  }
  def `Seq("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should include' failed` {
    val xs = Seq("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should include ("ell")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotInclude(xs, "ell")) + ", \"" + getFirstNotInclude(xs, "ell") + "\" did not include substring \"ell\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotInclude(xs, "ell") + "\" did not include substring \"ell\"")
  }
  def `Seq("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not include' failed` {
    val xs = Seq("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not include "ell"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstInclude(xs, "ell")) + ", \"" + getFirstInclude(xs, "ell") + "\" included substring \"ell\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstInclude(xs, "ell") + "\" included substring \"ell\"")
  }
  def `Seq("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should startWith regex' failed` {
    val xs = Seq("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should startWith regex "hel*o"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotStartsWith(xs, "hello")) + ", \"" + getFirstNotStartsWith(xs, "hello") + "\" did not start with a substring that matched the regular expression hel*o (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotStartsWith(xs, "hello") + "\" did not start with a substring that matched the regular expression hel*o")
  }
  def `Seq("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not startWith regex' failed` {
    val xs = Seq("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not startWith regex ("hel*o")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstStartsWith(xs, "hello")) + ", \"" + getFirstStartsWith(xs, "hello") + "\" started with a substring that matched the regular expression hel*o (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstStartsWith(xs, "hello") + "\" started with a substring that matched the regular expression hel*o")
  }
  def `Seq("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should endWith regex' failed` {
    val xs = Seq("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should endWith regex "!"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotEndsWith(xs, "!")) + ", \"" + getFirstNotEndsWith(xs, "!") + "\" did not end with a substring that matched the regular expression ! (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotEndsWith(xs, "!") + "\" did not end with a substring that matched the regular expression !")
  }
  def `Seq("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not endWith regex' failed` {
    val xs = Seq("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not endWith regex ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstEndsWith(xs, "!")) + ", \"" + getFirstEndsWith(xs, "!") + "\" ended with a substring that matched the regular expression ! (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstEndsWith(xs, "!") + "\" ended with a substring that matched the regular expression !")
  }
  def `Seq("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should include regex' failed` {
    val xs = Seq("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should include regex "ell"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotInclude(xs, "ell")) + ", \"" + getFirstNotInclude(xs, "ell") + "\" did not include substring that matched regex ell (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotInclude(xs, "ell") + "\" did not include substring that matched regex ell")
  }
  def `Seq("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not include regex' failed` {
    val xs = Seq("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not include regex ("ell")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstInclude(xs, "ell")) + ", \"" + getFirstInclude(xs, "ell") + "\" included substring that matched regex ell (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstInclude(xs, "ell") + "\" included substring that matched regex ell")
  }
  def `Seq("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should fullyMatch regex' failed` {
    val xs = Seq("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should fullyMatch regex "h.*!"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotMatches(xs, "h.*!")) + ", \"" + getFirstNotMatches(xs, "h.*!") + "\" did not fully match the regular expression h.*! (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotMatches(xs, "h.*!") + "\" did not fully match the regular expression h.*!")
  }
  def `Seq("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not fullyMatch regex' failed` {
    val xs = Seq("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not fullyMatch regex ("h.*!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstMatches(xs, "h.*!")) + ", \"" + getFirstMatches(xs, "h.*!") + "\" fully matched the regular expression h.*! (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstMatches(xs, "h.*!") + "\" fully matched the regular expression h.*!")
  }
  def `Array("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should startWith' failed` {
    val xs = Array("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should startWith ("hello")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotStartsWith(xs, "hello")) + ", \"" + getFirstNotStartsWith(xs, "hello") + "\" did not start with substring \"hello\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + "WrappedArray(hello A!, hi B, hello C!)", "\"" + getFirstNotStartsWith(xs, "hello") + "\" did not start with substring \"hello\"")
  }
  def `Array("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not startWith' failed` {
    val xs = Array("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not startWith ("hello")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstStartsWith(xs, "hello")) + ", \"" + getFirstStartsWith(xs, "hello") + "\" started with substring \"hello\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + "WrappedArray(hello A!, hi B, hello C!)", "\"" + getFirstStartsWith(xs, "hello") + "\" started with substring \"hello\"")
  }
  def `Array("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should endWith' failed` {
    val xs = Array("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should endWith ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotEndsWith(xs, "!")) + ", \"" + getFirstNotEndsWith(xs, "!") + "\" did not end with substring \"!\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + "WrappedArray(hello A!, hi B, hello C!)", "\"" + getFirstNotEndsWith(xs, "!") + "\" did not end with substring \"!\"")
  }
  def `Array("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not endWith' failed` {
    val xs = Array("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not endWith ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstEndsWith(xs, "!")) + ", \"" + getFirstEndsWith(xs, "!") + "\" ended with substring \"!\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + "WrappedArray(hello A!, hi B, hello C!)", "\"" + getFirstEndsWith(xs, "!") + "\" ended with substring \"!\"")
  }
  def `Array("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should include' failed` {
    val xs = Array("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should include ("ell")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotInclude(xs, "ell")) + ", \"" + getFirstNotInclude(xs, "ell") + "\" did not include substring \"ell\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + "WrappedArray(hello A!, hi B, hello C!)", "\"" + getFirstNotInclude(xs, "ell") + "\" did not include substring \"ell\"")
  }
  def `Array("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not include' failed` {
    val xs = Array("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not include "ell"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstInclude(xs, "ell")) + ", \"" + getFirstInclude(xs, "ell") + "\" included substring \"ell\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + "WrappedArray(hello A!, hi B, hello C!)", "\"" + getFirstInclude(xs, "ell") + "\" included substring \"ell\"")
  }
  def `Array("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should startWith regex' failed` {
    val xs = Array("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should startWith regex "hel*o"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotStartsWith(xs, "hello")) + ", \"" + getFirstNotStartsWith(xs, "hello") + "\" did not start with a substring that matched the regular expression hel*o (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + "WrappedArray(hello A!, hi B, hello C!)", "\"" + getFirstNotStartsWith(xs, "hello") + "\" did not start with a substring that matched the regular expression hel*o")
  }
  def `Array("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not startWith regex' failed` {
    val xs = Array("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not startWith regex ("hel*o")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstStartsWith(xs, "hello")) + ", \"" + getFirstStartsWith(xs, "hello") + "\" started with a substring that matched the regular expression hel*o (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + "WrappedArray(hello A!, hi B, hello C!)", "\"" + getFirstStartsWith(xs, "hello") + "\" started with a substring that matched the regular expression hel*o")
  }
  def `Array("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should endWith regex' failed` {
    val xs = Array("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should endWith regex "!"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotEndsWith(xs, "!")) + ", \"" + getFirstNotEndsWith(xs, "!") + "\" did not end with a substring that matched the regular expression ! (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + "WrappedArray(hello A!, hi B, hello C!)", "\"" + getFirstNotEndsWith(xs, "!") + "\" did not end with a substring that matched the regular expression !")
  }
  def `Array("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not endWith regex' failed` {
    val xs = Array("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not endWith regex ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstEndsWith(xs, "!")) + ", \"" + getFirstEndsWith(xs, "!") + "\" ended with a substring that matched the regular expression ! (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + "WrappedArray(hello A!, hi B, hello C!)", "\"" + getFirstEndsWith(xs, "!") + "\" ended with a substring that matched the regular expression !")
  }
  def `Array("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should include regex' failed` {
    val xs = Array("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should include regex "ell"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotInclude(xs, "ell")) + ", \"" + getFirstNotInclude(xs, "ell") + "\" did not include substring that matched regex ell (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + "WrappedArray(hello A!, hi B, hello C!)", "\"" + getFirstNotInclude(xs, "ell") + "\" did not include substring that matched regex ell")
  }
  def `Array("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not include regex' failed` {
    val xs = Array("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not include regex ("ell")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstInclude(xs, "ell")) + ", \"" + getFirstInclude(xs, "ell") + "\" included substring that matched regex ell (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + "WrappedArray(hello A!, hi B, hello C!)", "\"" + getFirstInclude(xs, "ell") + "\" included substring that matched regex ell")
  }
  def `Array("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should fullyMatch regex' failed` {
    val xs = Array("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should fullyMatch regex "h.*!"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotMatches(xs, "h.*!")) + ", \"" + getFirstNotMatches(xs, "h.*!") + "\" did not fully match the regular expression h.*! (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + "WrappedArray(hello A!, hi B, hello C!)", "\"" + getFirstNotMatches(xs, "h.*!") + "\" did not fully match the regular expression h.*!")
  }
  def `Array("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not fullyMatch regex' failed` {
    val xs = Array("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not fullyMatch regex ("h.*!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstMatches(xs, "h.*!")) + ", \"" + getFirstMatches(xs, "h.*!") + "\" fully matched the regular expression h.*! (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + "WrappedArray(hello A!, hi B, hello C!)", "\"" + getFirstMatches(xs, "h.*!") + "\" fully matched the regular expression h.*!")
  }
  def `IndexedSeq("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should startWith' failed` {
    val xs = IndexedSeq("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should startWith ("hello")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotStartsWith(xs, "hello")) + ", \"" + getFirstNotStartsWith(xs, "hello") + "\" did not start with substring \"hello\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotStartsWith(xs, "hello") + "\" did not start with substring \"hello\"")
  }
  def `IndexedSeq("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not startWith' failed` {
    val xs = IndexedSeq("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not startWith ("hello")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstStartsWith(xs, "hello")) + ", \"" + getFirstStartsWith(xs, "hello") + "\" started with substring \"hello\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstStartsWith(xs, "hello") + "\" started with substring \"hello\"")
  }
  def `IndexedSeq("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should endWith' failed` {
    val xs = IndexedSeq("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should endWith ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotEndsWith(xs, "!")) + ", \"" + getFirstNotEndsWith(xs, "!") + "\" did not end with substring \"!\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotEndsWith(xs, "!") + "\" did not end with substring \"!\"")
  }
  def `IndexedSeq("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not endWith' failed` {
    val xs = IndexedSeq("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not endWith ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstEndsWith(xs, "!")) + ", \"" + getFirstEndsWith(xs, "!") + "\" ended with substring \"!\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstEndsWith(xs, "!") + "\" ended with substring \"!\"")
  }
  def `IndexedSeq("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should include' failed` {
    val xs = IndexedSeq("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should include ("ell")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotInclude(xs, "ell")) + ", \"" + getFirstNotInclude(xs, "ell") + "\" did not include substring \"ell\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotInclude(xs, "ell") + "\" did not include substring \"ell\"")
  }
  def `IndexedSeq("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not include' failed` {
    val xs = IndexedSeq("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not include "ell"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstInclude(xs, "ell")) + ", \"" + getFirstInclude(xs, "ell") + "\" included substring \"ell\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstInclude(xs, "ell") + "\" included substring \"ell\"")
  }
  def `IndexedSeq("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should startWith regex' failed` {
    val xs = IndexedSeq("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should startWith regex "hel*o"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotStartsWith(xs, "hello")) + ", \"" + getFirstNotStartsWith(xs, "hello") + "\" did not start with a substring that matched the regular expression hel*o (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotStartsWith(xs, "hello") + "\" did not start with a substring that matched the regular expression hel*o")
  }
  def `IndexedSeq("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not startWith regex' failed` {
    val xs = IndexedSeq("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not startWith regex ("hel*o")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstStartsWith(xs, "hello")) + ", \"" + getFirstStartsWith(xs, "hello") + "\" started with a substring that matched the regular expression hel*o (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstStartsWith(xs, "hello") + "\" started with a substring that matched the regular expression hel*o")
  }
  def `IndexedSeq("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should endWith regex' failed` {
    val xs = IndexedSeq("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should endWith regex "!"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotEndsWith(xs, "!")) + ", \"" + getFirstNotEndsWith(xs, "!") + "\" did not end with a substring that matched the regular expression ! (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotEndsWith(xs, "!") + "\" did not end with a substring that matched the regular expression !")
  }
  def `IndexedSeq("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not endWith regex' failed` {
    val xs = IndexedSeq("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not endWith regex ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstEndsWith(xs, "!")) + ", \"" + getFirstEndsWith(xs, "!") + "\" ended with a substring that matched the regular expression ! (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstEndsWith(xs, "!") + "\" ended with a substring that matched the regular expression !")
  }
  def `IndexedSeq("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should include regex' failed` {
    val xs = IndexedSeq("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should include regex "ell"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotInclude(xs, "ell")) + ", \"" + getFirstNotInclude(xs, "ell") + "\" did not include substring that matched regex ell (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotInclude(xs, "ell") + "\" did not include substring that matched regex ell")
  }
  def `IndexedSeq("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not include regex' failed` {
    val xs = IndexedSeq("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not include regex ("ell")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstInclude(xs, "ell")) + ", \"" + getFirstInclude(xs, "ell") + "\" included substring that matched regex ell (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstInclude(xs, "ell") + "\" included substring that matched regex ell")
  }
  def `IndexedSeq("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should fullyMatch regex' failed` {
    val xs = IndexedSeq("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should fullyMatch regex "h.*!"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotMatches(xs, "h.*!")) + ", \"" + getFirstNotMatches(xs, "h.*!") + "\" did not fully match the regular expression h.*! (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotMatches(xs, "h.*!") + "\" did not fully match the regular expression h.*!")
  }
  def `IndexedSeq("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not fullyMatch regex' failed` {
    val xs = IndexedSeq("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not fullyMatch regex ("h.*!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstMatches(xs, "h.*!")) + ", \"" + getFirstMatches(xs, "h.*!") + "\" fully matched the regular expression h.*! (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstMatches(xs, "h.*!") + "\" fully matched the regular expression h.*!")
  }
  def `Vector("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should startWith' failed` {
    val xs = Vector("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should startWith ("hello")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotStartsWith(xs, "hello")) + ", \"" + getFirstNotStartsWith(xs, "hello") + "\" did not start with substring \"hello\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotStartsWith(xs, "hello") + "\" did not start with substring \"hello\"")
  }
  def `Vector("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not startWith' failed` {
    val xs = Vector("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not startWith ("hello")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstStartsWith(xs, "hello")) + ", \"" + getFirstStartsWith(xs, "hello") + "\" started with substring \"hello\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstStartsWith(xs, "hello") + "\" started with substring \"hello\"")
  }
  def `Vector("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should endWith' failed` {
    val xs = Vector("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should endWith ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotEndsWith(xs, "!")) + ", \"" + getFirstNotEndsWith(xs, "!") + "\" did not end with substring \"!\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotEndsWith(xs, "!") + "\" did not end with substring \"!\"")
  }
  def `Vector("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not endWith' failed` {
    val xs = Vector("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not endWith ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstEndsWith(xs, "!")) + ", \"" + getFirstEndsWith(xs, "!") + "\" ended with substring \"!\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstEndsWith(xs, "!") + "\" ended with substring \"!\"")
  }
  def `Vector("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should include' failed` {
    val xs = Vector("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should include ("ell")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotInclude(xs, "ell")) + ", \"" + getFirstNotInclude(xs, "ell") + "\" did not include substring \"ell\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotInclude(xs, "ell") + "\" did not include substring \"ell\"")
  }
  def `Vector("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not include' failed` {
    val xs = Vector("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not include "ell"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstInclude(xs, "ell")) + ", \"" + getFirstInclude(xs, "ell") + "\" included substring \"ell\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstInclude(xs, "ell") + "\" included substring \"ell\"")
  }
  def `Vector("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should startWith regex' failed` {
    val xs = Vector("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should startWith regex "hel*o"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotStartsWith(xs, "hello")) + ", \"" + getFirstNotStartsWith(xs, "hello") + "\" did not start with a substring that matched the regular expression hel*o (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotStartsWith(xs, "hello") + "\" did not start with a substring that matched the regular expression hel*o")
  }
  def `Vector("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not startWith regex' failed` {
    val xs = Vector("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not startWith regex ("hel*o")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstStartsWith(xs, "hello")) + ", \"" + getFirstStartsWith(xs, "hello") + "\" started with a substring that matched the regular expression hel*o (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstStartsWith(xs, "hello") + "\" started with a substring that matched the regular expression hel*o")
  }
  def `Vector("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should endWith regex' failed` {
    val xs = Vector("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should endWith regex "!"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotEndsWith(xs, "!")) + ", \"" + getFirstNotEndsWith(xs, "!") + "\" did not end with a substring that matched the regular expression ! (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotEndsWith(xs, "!") + "\" did not end with a substring that matched the regular expression !")
  }
  def `Vector("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not endWith regex' failed` {
    val xs = Vector("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not endWith regex ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstEndsWith(xs, "!")) + ", \"" + getFirstEndsWith(xs, "!") + "\" ended with a substring that matched the regular expression ! (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstEndsWith(xs, "!") + "\" ended with a substring that matched the regular expression !")
  }
  def `Vector("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should include regex' failed` {
    val xs = Vector("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should include regex "ell"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotInclude(xs, "ell")) + ", \"" + getFirstNotInclude(xs, "ell") + "\" did not include substring that matched regex ell (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotInclude(xs, "ell") + "\" did not include substring that matched regex ell")
  }
  def `Vector("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not include regex' failed` {
    val xs = Vector("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not include regex ("ell")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstInclude(xs, "ell")) + ", \"" + getFirstInclude(xs, "ell") + "\" included substring that matched regex ell (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstInclude(xs, "ell") + "\" included substring that matched regex ell")
  }
  def `Vector("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should fullyMatch regex' failed` {
    val xs = Vector("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should fullyMatch regex "h.*!"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotMatches(xs, "h.*!")) + ", \"" + getFirstNotMatches(xs, "h.*!") + "\" did not fully match the regular expression h.*! (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotMatches(xs, "h.*!") + "\" did not fully match the regular expression h.*!")
  }
  def `Vector("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not fullyMatch regex' failed` {
    val xs = Vector("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not fullyMatch regex ("h.*!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstMatches(xs, "h.*!")) + ", \"" + getFirstMatches(xs, "h.*!") + "\" fully matched the regular expression h.*! (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstMatches(xs, "h.*!") + "\" fully matched the regular expression h.*!")
  }
  def `Set("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should startWith' failed` {
    val xs = Set("hello A!", "hi B", "hello C!").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should startWith ("hello")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotStartsWith(xs, "hello")) + ", \"" + getFirstNotStartsWith(xs, "hello") + "\" did not start with substring \"hello\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotStartsWith(xs, "hello") + "\" did not start with substring \"hello\"")
  }
  def `Set("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should not startWith' failed` {
    val xs = Set("hello A!", "hi B", "hello C!").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not startWith ("hello")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstStartsWith(xs, "hello")) + ", \"" + getFirstStartsWith(xs, "hello") + "\" started with substring \"hello\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstStartsWith(xs, "hello") + "\" started with substring \"hello\"")
  }
  def `Set("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should endWith' failed` {
    val xs = Set("hello A!", "hi B", "hello C!").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should endWith ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotEndsWith(xs, "!")) + ", \"" + getFirstNotEndsWith(xs, "!") + "\" did not end with substring \"!\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotEndsWith(xs, "!") + "\" did not end with substring \"!\"")
  }
  def `Set("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should not endWith' failed` {
    val xs = Set("hello A!", "hi B", "hello C!").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not endWith ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstEndsWith(xs, "!")) + ", \"" + getFirstEndsWith(xs, "!") + "\" ended with substring \"!\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstEndsWith(xs, "!") + "\" ended with substring \"!\"")
  }
  def `Set("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should include' failed` {
    val xs = Set("hello A!", "hi B", "hello C!").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should include ("ell")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotInclude(xs, "ell")) + ", \"" + getFirstNotInclude(xs, "ell") + "\" did not include substring \"ell\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotInclude(xs, "ell") + "\" did not include substring \"ell\"")
  }
  def `Set("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should not include' failed` {
    val xs = Set("hello A!", "hi B", "hello C!").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not include "ell"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstInclude(xs, "ell")) + ", \"" + getFirstInclude(xs, "ell") + "\" included substring \"ell\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstInclude(xs, "ell") + "\" included substring \"ell\"")
  }
  def `Set("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should startWith regex' failed` {
    val xs = Set("hello A!", "hi B", "hello C!").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should startWith regex "hel*o"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotStartsWith(xs, "hello")) + ", \"" + getFirstNotStartsWith(xs, "hello") + "\" did not start with a substring that matched the regular expression hel*o (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotStartsWith(xs, "hello") + "\" did not start with a substring that matched the regular expression hel*o")
  }
  def `Set("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should not startWith regex' failed` {
    val xs = Set("hello A!", "hi B", "hello C!").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not startWith regex ("hel*o")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstStartsWith(xs, "hello")) + ", \"" + getFirstStartsWith(xs, "hello") + "\" started with a substring that matched the regular expression hel*o (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstStartsWith(xs, "hello") + "\" started with a substring that matched the regular expression hel*o")
  }
  def `Set("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should endWith regex' failed` {
    val xs = Set("hello A!", "hi B", "hello C!").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should endWith regex "!"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotEndsWith(xs, "!")) + ", \"" + getFirstNotEndsWith(xs, "!") + "\" did not end with a substring that matched the regular expression ! (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotEndsWith(xs, "!") + "\" did not end with a substring that matched the regular expression !")
  }
  def `Set("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should not endWith regex' failed` {
    val xs = Set("hello A!", "hi B", "hello C!").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not endWith regex ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstEndsWith(xs, "!")) + ", \"" + getFirstEndsWith(xs, "!") + "\" ended with a substring that matched the regular expression ! (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstEndsWith(xs, "!") + "\" ended with a substring that matched the regular expression !")
  }
  def `Set("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should include regex' failed` {
    val xs = Set("hello A!", "hi B", "hello C!").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should include regex "ell"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotInclude(xs, "ell")) + ", \"" + getFirstNotInclude(xs, "ell") + "\" did not include substring that matched regex ell (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotInclude(xs, "ell") + "\" did not include substring that matched regex ell")
  }
  def `Set("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should not include regex' failed` {
    val xs = Set("hello A!", "hi B", "hello C!").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not include regex ("ell")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstInclude(xs, "ell")) + ", \"" + getFirstInclude(xs, "ell") + "\" included substring that matched regex ell (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstInclude(xs, "ell") + "\" included substring that matched regex ell")
  }
  def `Set("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should fullyMatch regex' failed` {
    val xs = Set("hello A!", "hi B", "hello C!").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should fullyMatch regex "h.*!"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotMatches(xs, "h.*!")) + ", \"" + getFirstNotMatches(xs, "h.*!") + "\" did not fully match the regular expression h.*! (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotMatches(xs, "h.*!") + "\" did not fully match the regular expression h.*!")
  }
  def `Set("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should not fullyMatch regex' failed` {
    val xs = Set("hello A!", "hi B", "hello C!").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not fullyMatch regex ("h.*!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstMatches(xs, "h.*!")) + ", \"" + getFirstMatches(xs, "h.*!") + "\" fully matched the regular expression h.*! (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstMatches(xs, "h.*!") + "\" fully matched the regular expression h.*!")
  }
  def `List("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should startWith' failed` {
    val xs = List("hello A!", "hi B", "hello C!").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should startWith ("hello")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotStartsWith(xs, "hello")) + ", \"" + getFirstNotStartsWith(xs, "hello") + "\" did not start with substring \"hello\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotStartsWith(xs, "hello") + "\" did not start with substring \"hello\"")
  }
  def `List("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should not startWith' failed` {
    val xs = List("hello A!", "hi B", "hello C!").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not startWith ("hello")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstStartsWith(xs, "hello")) + ", \"" + getFirstStartsWith(xs, "hello") + "\" started with substring \"hello\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstStartsWith(xs, "hello") + "\" started with substring \"hello\"")
  }
  def `List("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should endWith' failed` {
    val xs = List("hello A!", "hi B", "hello C!").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should endWith ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotEndsWith(xs, "!")) + ", \"" + getFirstNotEndsWith(xs, "!") + "\" did not end with substring \"!\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotEndsWith(xs, "!") + "\" did not end with substring \"!\"")
  }
  def `List("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should not endWith' failed` {
    val xs = List("hello A!", "hi B", "hello C!").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not endWith ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstEndsWith(xs, "!")) + ", \"" + getFirstEndsWith(xs, "!") + "\" ended with substring \"!\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstEndsWith(xs, "!") + "\" ended with substring \"!\"")
  }
  def `List("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should include' failed` {
    val xs = List("hello A!", "hi B", "hello C!").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should include ("ell")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotInclude(xs, "ell")) + ", \"" + getFirstNotInclude(xs, "ell") + "\" did not include substring \"ell\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotInclude(xs, "ell") + "\" did not include substring \"ell\"")
  }
  def `List("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should not include' failed` {
    val xs = List("hello A!", "hi B", "hello C!").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not include "ell"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstInclude(xs, "ell")) + ", \"" + getFirstInclude(xs, "ell") + "\" included substring \"ell\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstInclude(xs, "ell") + "\" included substring \"ell\"")
  }
  def `List("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should startWith regex' failed` {
    val xs = List("hello A!", "hi B", "hello C!").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should startWith regex "hel*o"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotStartsWith(xs, "hello")) + ", \"" + getFirstNotStartsWith(xs, "hello") + "\" did not start with a substring that matched the regular expression hel*o (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotStartsWith(xs, "hello") + "\" did not start with a substring that matched the regular expression hel*o")
  }
  def `List("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should not startWith regex' failed` {
    val xs = List("hello A!", "hi B", "hello C!").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not startWith regex ("hel*o")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstStartsWith(xs, "hello")) + ", \"" + getFirstStartsWith(xs, "hello") + "\" started with a substring that matched the regular expression hel*o (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstStartsWith(xs, "hello") + "\" started with a substring that matched the regular expression hel*o")
  }
  def `List("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should endWith regex' failed` {
    val xs = List("hello A!", "hi B", "hello C!").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should endWith regex "!"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotEndsWith(xs, "!")) + ", \"" + getFirstNotEndsWith(xs, "!") + "\" did not end with a substring that matched the regular expression ! (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotEndsWith(xs, "!") + "\" did not end with a substring that matched the regular expression !")
  }
  def `List("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should not endWith regex' failed` {
    val xs = List("hello A!", "hi B", "hello C!").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not endWith regex ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstEndsWith(xs, "!")) + ", \"" + getFirstEndsWith(xs, "!") + "\" ended with a substring that matched the regular expression ! (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstEndsWith(xs, "!") + "\" ended with a substring that matched the regular expression !")
  }
  def `List("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should include regex' failed` {
    val xs = List("hello A!", "hi B", "hello C!").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should include regex "ell"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotInclude(xs, "ell")) + ", \"" + getFirstNotInclude(xs, "ell") + "\" did not include substring that matched regex ell (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotInclude(xs, "ell") + "\" did not include substring that matched regex ell")
  }
  def `List("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should not include regex' failed` {
    val xs = List("hello A!", "hi B", "hello C!").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not include regex ("ell")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstInclude(xs, "ell")) + ", \"" + getFirstInclude(xs, "ell") + "\" included substring that matched regex ell (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstInclude(xs, "ell") + "\" included substring that matched regex ell")
  }
  def `List("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should fullyMatch regex' failed` {
    val xs = List("hello A!", "hi B", "hello C!").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should fullyMatch regex "h.*!"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotMatches(xs, "h.*!")) + ", \"" + getFirstNotMatches(xs, "h.*!") + "\" did not fully match the regular expression h.*! (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotMatches(xs, "h.*!") + "\" did not fully match the regular expression h.*!")
  }
  def `List("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should not fullyMatch regex' failed` {
    val xs = List("hello A!", "hi B", "hello C!").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not fullyMatch regex ("h.*!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstMatches(xs, "h.*!")) + ", \"" + getFirstMatches(xs, "h.*!") + "\" fully matched the regular expression h.*! (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstMatches(xs, "h.*!") + "\" fully matched the regular expression h.*!")
  }
  def `Seq("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should startWith' failed` {
    val xs = Seq("hello A!", "hi B", "hello C!").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should startWith ("hello")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotStartsWith(xs, "hello")) + ", \"" + getFirstNotStartsWith(xs, "hello") + "\" did not start with substring \"hello\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotStartsWith(xs, "hello") + "\" did not start with substring \"hello\"")
  }
  def `Seq("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should not startWith' failed` {
    val xs = Seq("hello A!", "hi B", "hello C!").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not startWith ("hello")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstStartsWith(xs, "hello")) + ", \"" + getFirstStartsWith(xs, "hello") + "\" started with substring \"hello\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstStartsWith(xs, "hello") + "\" started with substring \"hello\"")
  }
  def `Seq("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should endWith' failed` {
    val xs = Seq("hello A!", "hi B", "hello C!").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should endWith ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotEndsWith(xs, "!")) + ", \"" + getFirstNotEndsWith(xs, "!") + "\" did not end with substring \"!\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotEndsWith(xs, "!") + "\" did not end with substring \"!\"")
  }
  def `Seq("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should not endWith' failed` {
    val xs = Seq("hello A!", "hi B", "hello C!").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not endWith ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstEndsWith(xs, "!")) + ", \"" + getFirstEndsWith(xs, "!") + "\" ended with substring \"!\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstEndsWith(xs, "!") + "\" ended with substring \"!\"")
  }
  def `Seq("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should include' failed` {
    val xs = Seq("hello A!", "hi B", "hello C!").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should include ("ell")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotInclude(xs, "ell")) + ", \"" + getFirstNotInclude(xs, "ell") + "\" did not include substring \"ell\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotInclude(xs, "ell") + "\" did not include substring \"ell\"")
  }
  def `Seq("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should not include' failed` {
    val xs = Seq("hello A!", "hi B", "hello C!").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not include "ell"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstInclude(xs, "ell")) + ", \"" + getFirstInclude(xs, "ell") + "\" included substring \"ell\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstInclude(xs, "ell") + "\" included substring \"ell\"")
  }
  def `Seq("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should startWith regex' failed` {
    val xs = Seq("hello A!", "hi B", "hello C!").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should startWith regex "hel*o"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotStartsWith(xs, "hello")) + ", \"" + getFirstNotStartsWith(xs, "hello") + "\" did not start with a substring that matched the regular expression hel*o (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotStartsWith(xs, "hello") + "\" did not start with a substring that matched the regular expression hel*o")
  }
  def `Seq("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should not startWith regex' failed` {
    val xs = Seq("hello A!", "hi B", "hello C!").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not startWith regex ("hel*o")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstStartsWith(xs, "hello")) + ", \"" + getFirstStartsWith(xs, "hello") + "\" started with a substring that matched the regular expression hel*o (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstStartsWith(xs, "hello") + "\" started with a substring that matched the regular expression hel*o")
  }
  def `Seq("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should endWith regex' failed` {
    val xs = Seq("hello A!", "hi B", "hello C!").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should endWith regex "!"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotEndsWith(xs, "!")) + ", \"" + getFirstNotEndsWith(xs, "!") + "\" did not end with a substring that matched the regular expression ! (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotEndsWith(xs, "!") + "\" did not end with a substring that matched the regular expression !")
  }
  def `Seq("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should not endWith regex' failed` {
    val xs = Seq("hello A!", "hi B", "hello C!").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not endWith regex ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstEndsWith(xs, "!")) + ", \"" + getFirstEndsWith(xs, "!") + "\" ended with a substring that matched the regular expression ! (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstEndsWith(xs, "!") + "\" ended with a substring that matched the regular expression !")
  }
  def `Seq("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should include regex' failed` {
    val xs = Seq("hello A!", "hi B", "hello C!").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should include regex "ell"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotInclude(xs, "ell")) + ", \"" + getFirstNotInclude(xs, "ell") + "\" did not include substring that matched regex ell (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotInclude(xs, "ell") + "\" did not include substring that matched regex ell")
  }
  def `Seq("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should not include regex' failed` {
    val xs = Seq("hello A!", "hi B", "hello C!").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not include regex ("ell")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstInclude(xs, "ell")) + ", \"" + getFirstInclude(xs, "ell") + "\" included substring that matched regex ell (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstInclude(xs, "ell") + "\" included substring that matched regex ell")
  }
  def `Seq("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should fullyMatch regex' failed` {
    val xs = Seq("hello A!", "hi B", "hello C!").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should fullyMatch regex "h.*!"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotMatches(xs, "h.*!")) + ", \"" + getFirstNotMatches(xs, "h.*!") + "\" did not fully match the regular expression h.*! (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotMatches(xs, "h.*!") + "\" did not fully match the regular expression h.*!")
  }
  def `Seq("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should not fullyMatch regex' failed` {
    val xs = Seq("hello A!", "hi B", "hello C!").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not fullyMatch regex ("h.*!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstMatches(xs, "h.*!")) + ", \"" + getFirstMatches(xs, "h.*!") + "\" fully matched the regular expression h.*! (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstMatches(xs, "h.*!") + "\" fully matched the regular expression h.*!")
  }
  def `IndexedSeq("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should startWith' failed` {
    val xs = IndexedSeq("hello A!", "hi B", "hello C!").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should startWith ("hello")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotStartsWith(xs, "hello")) + ", \"" + getFirstNotStartsWith(xs, "hello") + "\" did not start with substring \"hello\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotStartsWith(xs, "hello") + "\" did not start with substring \"hello\"")
  }
  def `IndexedSeq("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should not startWith' failed` {
    val xs = IndexedSeq("hello A!", "hi B", "hello C!").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not startWith ("hello")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstStartsWith(xs, "hello")) + ", \"" + getFirstStartsWith(xs, "hello") + "\" started with substring \"hello\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstStartsWith(xs, "hello") + "\" started with substring \"hello\"")
  }
  def `IndexedSeq("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should endWith' failed` {
    val xs = IndexedSeq("hello A!", "hi B", "hello C!").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should endWith ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotEndsWith(xs, "!")) + ", \"" + getFirstNotEndsWith(xs, "!") + "\" did not end with substring \"!\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotEndsWith(xs, "!") + "\" did not end with substring \"!\"")
  }
  def `IndexedSeq("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should not endWith' failed` {
    val xs = IndexedSeq("hello A!", "hi B", "hello C!").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not endWith ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstEndsWith(xs, "!")) + ", \"" + getFirstEndsWith(xs, "!") + "\" ended with substring \"!\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstEndsWith(xs, "!") + "\" ended with substring \"!\"")
  }
  def `IndexedSeq("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should include' failed` {
    val xs = IndexedSeq("hello A!", "hi B", "hello C!").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should include ("ell")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotInclude(xs, "ell")) + ", \"" + getFirstNotInclude(xs, "ell") + "\" did not include substring \"ell\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotInclude(xs, "ell") + "\" did not include substring \"ell\"")
  }
  def `IndexedSeq("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should not include' failed` {
    val xs = IndexedSeq("hello A!", "hi B", "hello C!").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not include "ell"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstInclude(xs, "ell")) + ", \"" + getFirstInclude(xs, "ell") + "\" included substring \"ell\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstInclude(xs, "ell") + "\" included substring \"ell\"")
  }
  def `IndexedSeq("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should startWith regex' failed` {
    val xs = IndexedSeq("hello A!", "hi B", "hello C!").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should startWith regex "hel*o"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotStartsWith(xs, "hello")) + ", \"" + getFirstNotStartsWith(xs, "hello") + "\" did not start with a substring that matched the regular expression hel*o (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotStartsWith(xs, "hello") + "\" did not start with a substring that matched the regular expression hel*o")
  }
  def `IndexedSeq("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should not startWith regex' failed` {
    val xs = IndexedSeq("hello A!", "hi B", "hello C!").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not startWith regex ("hel*o")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstStartsWith(xs, "hello")) + ", \"" + getFirstStartsWith(xs, "hello") + "\" started with a substring that matched the regular expression hel*o (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstStartsWith(xs, "hello") + "\" started with a substring that matched the regular expression hel*o")
  }
  def `IndexedSeq("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should endWith regex' failed` {
    val xs = IndexedSeq("hello A!", "hi B", "hello C!").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should endWith regex "!"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotEndsWith(xs, "!")) + ", \"" + getFirstNotEndsWith(xs, "!") + "\" did not end with a substring that matched the regular expression ! (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotEndsWith(xs, "!") + "\" did not end with a substring that matched the regular expression !")
  }
  def `IndexedSeq("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should not endWith regex' failed` {
    val xs = IndexedSeq("hello A!", "hi B", "hello C!").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not endWith regex ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstEndsWith(xs, "!")) + ", \"" + getFirstEndsWith(xs, "!") + "\" ended with a substring that matched the regular expression ! (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstEndsWith(xs, "!") + "\" ended with a substring that matched the regular expression !")
  }
  def `IndexedSeq("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should include regex' failed` {
    val xs = IndexedSeq("hello A!", "hi B", "hello C!").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should include regex "ell"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotInclude(xs, "ell")) + ", \"" + getFirstNotInclude(xs, "ell") + "\" did not include substring that matched regex ell (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotInclude(xs, "ell") + "\" did not include substring that matched regex ell")
  }
  def `IndexedSeq("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should not include regex' failed` {
    val xs = IndexedSeq("hello A!", "hi B", "hello C!").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not include regex ("ell")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstInclude(xs, "ell")) + ", \"" + getFirstInclude(xs, "ell") + "\" included substring that matched regex ell (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstInclude(xs, "ell") + "\" included substring that matched regex ell")
  }
  def `IndexedSeq("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should fullyMatch regex' failed` {
    val xs = IndexedSeq("hello A!", "hi B", "hello C!").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should fullyMatch regex "h.*!"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotMatches(xs, "h.*!")) + ", \"" + getFirstNotMatches(xs, "h.*!") + "\" did not fully match the regular expression h.*! (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotMatches(xs, "h.*!") + "\" did not fully match the regular expression h.*!")
  }
  def `IndexedSeq("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should not fullyMatch regex' failed` {
    val xs = IndexedSeq("hello A!", "hi B", "hello C!").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not fullyMatch regex ("h.*!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstMatches(xs, "h.*!")) + ", \"" + getFirstMatches(xs, "h.*!") + "\" fully matched the regular expression h.*! (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstMatches(xs, "h.*!") + "\" fully matched the regular expression h.*!")
  }
  def `collection.mutable.Set("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should startWith' failed` {
    val xs = collection.mutable.Set("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should startWith ("hello")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotStartsWith(xs, "hello")) + ", \"" + getFirstNotStartsWith(xs, "hello") + "\" did not start with substring \"hello\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotStartsWith(xs, "hello") + "\" did not start with substring \"hello\"")
  }
  def `collection.mutable.Set("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not startWith' failed` {
    val xs = collection.mutable.Set("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not startWith ("hello")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstStartsWith(xs, "hello")) + ", \"" + getFirstStartsWith(xs, "hello") + "\" started with substring \"hello\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstStartsWith(xs, "hello") + "\" started with substring \"hello\"")
  }
  def `collection.mutable.Set("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should endWith' failed` {
    val xs = collection.mutable.Set("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should endWith ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotEndsWith(xs, "!")) + ", \"" + getFirstNotEndsWith(xs, "!") + "\" did not end with substring \"!\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotEndsWith(xs, "!") + "\" did not end with substring \"!\"")
  }
  def `collection.mutable.Set("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not endWith' failed` {
    val xs = collection.mutable.Set("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not endWith ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstEndsWith(xs, "!")) + ", \"" + getFirstEndsWith(xs, "!") + "\" ended with substring \"!\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstEndsWith(xs, "!") + "\" ended with substring \"!\"")
  }
  def `collection.mutable.Set("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should include' failed` {
    val xs = collection.mutable.Set("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should include ("ell")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotInclude(xs, "ell")) + ", \"" + getFirstNotInclude(xs, "ell") + "\" did not include substring \"ell\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotInclude(xs, "ell") + "\" did not include substring \"ell\"")
  }
  def `collection.mutable.Set("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not include' failed` {
    val xs = collection.mutable.Set("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not include "ell"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstInclude(xs, "ell")) + ", \"" + getFirstInclude(xs, "ell") + "\" included substring \"ell\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstInclude(xs, "ell") + "\" included substring \"ell\"")
  }
  def `collection.mutable.Set("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should startWith regex' failed` {
    val xs = collection.mutable.Set("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should startWith regex "hel*o"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotStartsWith(xs, "hello")) + ", \"" + getFirstNotStartsWith(xs, "hello") + "\" did not start with a substring that matched the regular expression hel*o (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotStartsWith(xs, "hello") + "\" did not start with a substring that matched the regular expression hel*o")
  }
  def `collection.mutable.Set("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not startWith regex' failed` {
    val xs = collection.mutable.Set("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not startWith regex ("hel*o")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstStartsWith(xs, "hello")) + ", \"" + getFirstStartsWith(xs, "hello") + "\" started with a substring that matched the regular expression hel*o (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstStartsWith(xs, "hello") + "\" started with a substring that matched the regular expression hel*o")
  }
  def `collection.mutable.Set("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should endWith regex' failed` {
    val xs = collection.mutable.Set("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should endWith regex "!"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotEndsWith(xs, "!")) + ", \"" + getFirstNotEndsWith(xs, "!") + "\" did not end with a substring that matched the regular expression ! (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotEndsWith(xs, "!") + "\" did not end with a substring that matched the regular expression !")
  }
  def `collection.mutable.Set("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not endWith regex' failed` {
    val xs = collection.mutable.Set("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not endWith regex ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstEndsWith(xs, "!")) + ", \"" + getFirstEndsWith(xs, "!") + "\" ended with a substring that matched the regular expression ! (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstEndsWith(xs, "!") + "\" ended with a substring that matched the regular expression !")
  }
  def `collection.mutable.Set("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should include regex' failed` {
    val xs = collection.mutable.Set("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should include regex "ell"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotInclude(xs, "ell")) + ", \"" + getFirstNotInclude(xs, "ell") + "\" did not include substring that matched regex ell (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotInclude(xs, "ell") + "\" did not include substring that matched regex ell")
  }
  def `collection.mutable.Set("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not include regex' failed` {
    val xs = collection.mutable.Set("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not include regex ("ell")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstInclude(xs, "ell")) + ", \"" + getFirstInclude(xs, "ell") + "\" included substring that matched regex ell (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstInclude(xs, "ell") + "\" included substring that matched regex ell")
  }
  def `collection.mutable.Set("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should fullyMatch regex' failed` {
    val xs = collection.mutable.Set("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should fullyMatch regex "h.*!"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotMatches(xs, "h.*!")) + ", \"" + getFirstNotMatches(xs, "h.*!") + "\" did not fully match the regular expression h.*! (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotMatches(xs, "h.*!") + "\" did not fully match the regular expression h.*!")
  }
  def `collection.mutable.Set("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not fullyMatch regex' failed` {
    val xs = collection.mutable.Set("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not fullyMatch regex ("h.*!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstMatches(xs, "h.*!")) + ", \"" + getFirstMatches(xs, "h.*!") + "\" fully matched the regular expression h.*! (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstMatches(xs, "h.*!") + "\" fully matched the regular expression h.*!")
  }
  def `new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should startWith' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should startWith ("hello")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotStartsWith(xs, "hello")) + ", \"" + getFirstNotStartsWith(xs, "hello") + "\" did not start with substring \"hello\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotStartsWith(xs, "hello") + "\" did not start with substring \"hello\"")
  }
  def `new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not startWith' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not startWith ("hello")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstStartsWith(xs, "hello")) + ", \"" + getFirstStartsWith(xs, "hello") + "\" started with substring \"hello\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstStartsWith(xs, "hello") + "\" started with substring \"hello\"")
  }
  def `new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should endWith' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should endWith ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotEndsWith(xs, "!")) + ", \"" + getFirstNotEndsWith(xs, "!") + "\" did not end with substring \"!\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotEndsWith(xs, "!") + "\" did not end with substring \"!\"")
  }
  def `new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not endWith' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not endWith ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstEndsWith(xs, "!")) + ", \"" + getFirstEndsWith(xs, "!") + "\" ended with substring \"!\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstEndsWith(xs, "!") + "\" ended with substring \"!\"")
  }
  def `new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should include' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should include ("ell")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotInclude(xs, "ell")) + ", \"" + getFirstNotInclude(xs, "ell") + "\" did not include substring \"ell\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotInclude(xs, "ell") + "\" did not include substring \"ell\"")
  }
  def `new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not include' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not include "ell"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstInclude(xs, "ell")) + ", \"" + getFirstInclude(xs, "ell") + "\" included substring \"ell\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstInclude(xs, "ell") + "\" included substring \"ell\"")
  }
  def `new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should startWith regex' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should startWith regex "hel*o"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotStartsWith(xs, "hello")) + ", \"" + getFirstNotStartsWith(xs, "hello") + "\" did not start with a substring that matched the regular expression hel*o (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotStartsWith(xs, "hello") + "\" did not start with a substring that matched the regular expression hel*o")
  }
  def `new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not startWith regex' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not startWith regex ("hel*o")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstStartsWith(xs, "hello")) + ", \"" + getFirstStartsWith(xs, "hello") + "\" started with a substring that matched the regular expression hel*o (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstStartsWith(xs, "hello") + "\" started with a substring that matched the regular expression hel*o")
  }
  def `new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should endWith regex' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should endWith regex "!"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotEndsWith(xs, "!")) + ", \"" + getFirstNotEndsWith(xs, "!") + "\" did not end with a substring that matched the regular expression ! (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotEndsWith(xs, "!") + "\" did not end with a substring that matched the regular expression !")
  }
  def `new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not endWith regex' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not endWith regex ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstEndsWith(xs, "!")) + ", \"" + getFirstEndsWith(xs, "!") + "\" ended with a substring that matched the regular expression ! (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstEndsWith(xs, "!") + "\" ended with a substring that matched the regular expression !")
  }
  def `new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should include regex' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should include regex "ell"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotInclude(xs, "ell")) + ", \"" + getFirstNotInclude(xs, "ell") + "\" did not include substring that matched regex ell (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotInclude(xs, "ell") + "\" did not include substring that matched regex ell")
  }
  def `new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not include regex' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not include regex ("ell")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstInclude(xs, "ell")) + ", \"" + getFirstInclude(xs, "ell") + "\" included substring that matched regex ell (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstInclude(xs, "ell") + "\" included substring that matched regex ell")
  }
  def `new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should fullyMatch regex' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should fullyMatch regex "h.*!"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotMatches(xs, "h.*!")) + ", \"" + getFirstNotMatches(xs, "h.*!") + "\" did not fully match the regular expression h.*! (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotMatches(xs, "h.*!") + "\" did not fully match the regular expression h.*!")
  }
  def `new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not fullyMatch regex' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not fullyMatch regex ("h.*!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstMatches(xs, "h.*!")) + ", \"" + getFirstMatches(xs, "h.*!") + "\" fully matched the regular expression h.*! (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstMatches(xs, "h.*!") + "\" fully matched the regular expression h.*!")
  }
  def `collection.mutable.Seq("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should startWith' failed` {
    val xs = collection.mutable.Seq("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should startWith ("hello")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotStartsWith(xs, "hello")) + ", \"" + getFirstNotStartsWith(xs, "hello") + "\" did not start with substring \"hello\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotStartsWith(xs, "hello") + "\" did not start with substring \"hello\"")
  }
  def `collection.mutable.Seq("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not startWith' failed` {
    val xs = collection.mutable.Seq("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not startWith ("hello")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstStartsWith(xs, "hello")) + ", \"" + getFirstStartsWith(xs, "hello") + "\" started with substring \"hello\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstStartsWith(xs, "hello") + "\" started with substring \"hello\"")
  }
  def `collection.mutable.Seq("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should endWith' failed` {
    val xs = collection.mutable.Seq("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should endWith ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotEndsWith(xs, "!")) + ", \"" + getFirstNotEndsWith(xs, "!") + "\" did not end with substring \"!\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotEndsWith(xs, "!") + "\" did not end with substring \"!\"")
  }
  def `collection.mutable.Seq("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not endWith' failed` {
    val xs = collection.mutable.Seq("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not endWith ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstEndsWith(xs, "!")) + ", \"" + getFirstEndsWith(xs, "!") + "\" ended with substring \"!\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstEndsWith(xs, "!") + "\" ended with substring \"!\"")
  }
  def `collection.mutable.Seq("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should include' failed` {
    val xs = collection.mutable.Seq("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should include ("ell")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotInclude(xs, "ell")) + ", \"" + getFirstNotInclude(xs, "ell") + "\" did not include substring \"ell\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotInclude(xs, "ell") + "\" did not include substring \"ell\"")
  }
  def `collection.mutable.Seq("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not include' failed` {
    val xs = collection.mutable.Seq("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not include "ell"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstInclude(xs, "ell")) + ", \"" + getFirstInclude(xs, "ell") + "\" included substring \"ell\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstInclude(xs, "ell") + "\" included substring \"ell\"")
  }
  def `collection.mutable.Seq("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should startWith regex' failed` {
    val xs = collection.mutable.Seq("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should startWith regex "hel*o"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotStartsWith(xs, "hello")) + ", \"" + getFirstNotStartsWith(xs, "hello") + "\" did not start with a substring that matched the regular expression hel*o (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotStartsWith(xs, "hello") + "\" did not start with a substring that matched the regular expression hel*o")
  }
  def `collection.mutable.Seq("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not startWith regex' failed` {
    val xs = collection.mutable.Seq("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not startWith regex ("hel*o")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstStartsWith(xs, "hello")) + ", \"" + getFirstStartsWith(xs, "hello") + "\" started with a substring that matched the regular expression hel*o (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstStartsWith(xs, "hello") + "\" started with a substring that matched the regular expression hel*o")
  }
  def `collection.mutable.Seq("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should endWith regex' failed` {
    val xs = collection.mutable.Seq("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should endWith regex "!"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotEndsWith(xs, "!")) + ", \"" + getFirstNotEndsWith(xs, "!") + "\" did not end with a substring that matched the regular expression ! (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotEndsWith(xs, "!") + "\" did not end with a substring that matched the regular expression !")
  }
  def `collection.mutable.Seq("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not endWith regex' failed` {
    val xs = collection.mutable.Seq("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not endWith regex ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstEndsWith(xs, "!")) + ", \"" + getFirstEndsWith(xs, "!") + "\" ended with a substring that matched the regular expression ! (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstEndsWith(xs, "!") + "\" ended with a substring that matched the regular expression !")
  }
  def `collection.mutable.Seq("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should include regex' failed` {
    val xs = collection.mutable.Seq("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should include regex "ell"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotInclude(xs, "ell")) + ", \"" + getFirstNotInclude(xs, "ell") + "\" did not include substring that matched regex ell (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotInclude(xs, "ell") + "\" did not include substring that matched regex ell")
  }
  def `collection.mutable.Seq("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not include regex' failed` {
    val xs = collection.mutable.Seq("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not include regex ("ell")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstInclude(xs, "ell")) + ", \"" + getFirstInclude(xs, "ell") + "\" included substring that matched regex ell (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstInclude(xs, "ell") + "\" included substring that matched regex ell")
  }
  def `collection.mutable.Seq("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should fullyMatch regex' failed` {
    val xs = collection.mutable.Seq("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should fullyMatch regex "h.*!"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotMatches(xs, "h.*!")) + ", \"" + getFirstNotMatches(xs, "h.*!") + "\" did not fully match the regular expression h.*! (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotMatches(xs, "h.*!") + "\" did not fully match the regular expression h.*!")
  }
  def `collection.mutable.Seq("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not fullyMatch regex' failed` {
    val xs = collection.mutable.Seq("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not fullyMatch regex ("h.*!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstMatches(xs, "h.*!")) + ", \"" + getFirstMatches(xs, "h.*!") + "\" fully matched the regular expression h.*! (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstMatches(xs, "h.*!") + "\" fully matched the regular expression h.*!")
  }
  def `collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should startWith' failed` {
    val xs = collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should startWith ("hello")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotStartsWith(xs, "hello")) + ", \"" + getFirstNotStartsWith(xs, "hello") + "\" did not start with substring \"hello\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotStartsWith(xs, "hello") + "\" did not start with substring \"hello\"")
  }
  def `collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not startWith' failed` {
    val xs = collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not startWith ("hello")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstStartsWith(xs, "hello")) + ", \"" + getFirstStartsWith(xs, "hello") + "\" started with substring \"hello\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstStartsWith(xs, "hello") + "\" started with substring \"hello\"")
  }
  def `collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should endWith' failed` {
    val xs = collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should endWith ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotEndsWith(xs, "!")) + ", \"" + getFirstNotEndsWith(xs, "!") + "\" did not end with substring \"!\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotEndsWith(xs, "!") + "\" did not end with substring \"!\"")
  }
  def `collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not endWith' failed` {
    val xs = collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not endWith ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstEndsWith(xs, "!")) + ", \"" + getFirstEndsWith(xs, "!") + "\" ended with substring \"!\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstEndsWith(xs, "!") + "\" ended with substring \"!\"")
  }
  def `collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should include' failed` {
    val xs = collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should include ("ell")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotInclude(xs, "ell")) + ", \"" + getFirstNotInclude(xs, "ell") + "\" did not include substring \"ell\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotInclude(xs, "ell") + "\" did not include substring \"ell\"")
  }
  def `collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not include' failed` {
    val xs = collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not include "ell"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstInclude(xs, "ell")) + ", \"" + getFirstInclude(xs, "ell") + "\" included substring \"ell\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstInclude(xs, "ell") + "\" included substring \"ell\"")
  }
  def `collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should startWith regex' failed` {
    val xs = collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should startWith regex "hel*o"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotStartsWith(xs, "hello")) + ", \"" + getFirstNotStartsWith(xs, "hello") + "\" did not start with a substring that matched the regular expression hel*o (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotStartsWith(xs, "hello") + "\" did not start with a substring that matched the regular expression hel*o")
  }
  def `collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not startWith regex' failed` {
    val xs = collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not startWith regex ("hel*o")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstStartsWith(xs, "hello")) + ", \"" + getFirstStartsWith(xs, "hello") + "\" started with a substring that matched the regular expression hel*o (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstStartsWith(xs, "hello") + "\" started with a substring that matched the regular expression hel*o")
  }
  def `collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should endWith regex' failed` {
    val xs = collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should endWith regex "!"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotEndsWith(xs, "!")) + ", \"" + getFirstNotEndsWith(xs, "!") + "\" did not end with a substring that matched the regular expression ! (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotEndsWith(xs, "!") + "\" did not end with a substring that matched the regular expression !")
  }
  def `collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not endWith regex' failed` {
    val xs = collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not endWith regex ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstEndsWith(xs, "!")) + ", \"" + getFirstEndsWith(xs, "!") + "\" ended with a substring that matched the regular expression ! (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstEndsWith(xs, "!") + "\" ended with a substring that matched the regular expression !")
  }
  def `collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should include regex' failed` {
    val xs = collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should include regex "ell"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotInclude(xs, "ell")) + ", \"" + getFirstNotInclude(xs, "ell") + "\" did not include substring that matched regex ell (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotInclude(xs, "ell") + "\" did not include substring that matched regex ell")
  }
  def `collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not include regex' failed` {
    val xs = collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not include regex ("ell")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstInclude(xs, "ell")) + ", \"" + getFirstInclude(xs, "ell") + "\" included substring that matched regex ell (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstInclude(xs, "ell") + "\" included substring that matched regex ell")
  }
  def `collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should fullyMatch regex' failed` {
    val xs = collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should fullyMatch regex "h.*!"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotMatches(xs, "h.*!")) + ", \"" + getFirstNotMatches(xs, "h.*!") + "\" did not fully match the regular expression h.*! (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotMatches(xs, "h.*!") + "\" did not fully match the regular expression h.*!")
  }
  def `collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not fullyMatch regex' failed` {
    val xs = collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!")
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not fullyMatch regex ("h.*!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstMatches(xs, "h.*!")) + ", \"" + getFirstMatches(xs, "h.*!") + "\" fully matched the regular expression h.*! (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstMatches(xs, "h.*!") + "\" fully matched the regular expression h.*!")
  }
  def `collection.mutable.Set("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should startWith' failed` {
    val xs = collection.mutable.Set("hello A!", "hi B", "hello C!").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should startWith ("hello")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotStartsWith(xs, "hello")) + ", \"" + getFirstNotStartsWith(xs, "hello") + "\" did not start with substring \"hello\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotStartsWith(xs, "hello") + "\" did not start with substring \"hello\"")
  }
  def `collection.mutable.Set("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should not startWith' failed` {
    val xs = collection.mutable.Set("hello A!", "hi B", "hello C!").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not startWith ("hello")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstStartsWith(xs, "hello")) + ", \"" + getFirstStartsWith(xs, "hello") + "\" started with substring \"hello\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstStartsWith(xs, "hello") + "\" started with substring \"hello\"")
  }
  def `collection.mutable.Set("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should endWith' failed` {
    val xs = collection.mutable.Set("hello A!", "hi B", "hello C!").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should endWith ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotEndsWith(xs, "!")) + ", \"" + getFirstNotEndsWith(xs, "!") + "\" did not end with substring \"!\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotEndsWith(xs, "!") + "\" did not end with substring \"!\"")
  }
  def `collection.mutable.Set("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should not endWith' failed` {
    val xs = collection.mutable.Set("hello A!", "hi B", "hello C!").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not endWith ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstEndsWith(xs, "!")) + ", \"" + getFirstEndsWith(xs, "!") + "\" ended with substring \"!\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstEndsWith(xs, "!") + "\" ended with substring \"!\"")
  }
  def `collection.mutable.Set("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should include' failed` {
    val xs = collection.mutable.Set("hello A!", "hi B", "hello C!").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should include ("ell")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotInclude(xs, "ell")) + ", \"" + getFirstNotInclude(xs, "ell") + "\" did not include substring \"ell\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotInclude(xs, "ell") + "\" did not include substring \"ell\"")
  }
  def `collection.mutable.Set("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should not include' failed` {
    val xs = collection.mutable.Set("hello A!", "hi B", "hello C!").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not include "ell"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstInclude(xs, "ell")) + ", \"" + getFirstInclude(xs, "ell") + "\" included substring \"ell\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstInclude(xs, "ell") + "\" included substring \"ell\"")
  }
  def `collection.mutable.Set("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should startWith regex' failed` {
    val xs = collection.mutable.Set("hello A!", "hi B", "hello C!").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should startWith regex "hel*o"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotStartsWith(xs, "hello")) + ", \"" + getFirstNotStartsWith(xs, "hello") + "\" did not start with a substring that matched the regular expression hel*o (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotStartsWith(xs, "hello") + "\" did not start with a substring that matched the regular expression hel*o")
  }
  def `collection.mutable.Set("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should not startWith regex' failed` {
    val xs = collection.mutable.Set("hello A!", "hi B", "hello C!").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not startWith regex ("hel*o")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstStartsWith(xs, "hello")) + ", \"" + getFirstStartsWith(xs, "hello") + "\" started with a substring that matched the regular expression hel*o (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstStartsWith(xs, "hello") + "\" started with a substring that matched the regular expression hel*o")
  }
  def `collection.mutable.Set("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should endWith regex' failed` {
    val xs = collection.mutable.Set("hello A!", "hi B", "hello C!").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should endWith regex "!"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotEndsWith(xs, "!")) + ", \"" + getFirstNotEndsWith(xs, "!") + "\" did not end with a substring that matched the regular expression ! (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotEndsWith(xs, "!") + "\" did not end with a substring that matched the regular expression !")
  }
  def `collection.mutable.Set("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should not endWith regex' failed` {
    val xs = collection.mutable.Set("hello A!", "hi B", "hello C!").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not endWith regex ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstEndsWith(xs, "!")) + ", \"" + getFirstEndsWith(xs, "!") + "\" ended with a substring that matched the regular expression ! (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstEndsWith(xs, "!") + "\" ended with a substring that matched the regular expression !")
  }
  def `collection.mutable.Set("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should include regex' failed` {
    val xs = collection.mutable.Set("hello A!", "hi B", "hello C!").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should include regex "ell"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotInclude(xs, "ell")) + ", \"" + getFirstNotInclude(xs, "ell") + "\" did not include substring that matched regex ell (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotInclude(xs, "ell") + "\" did not include substring that matched regex ell")
  }
  def `collection.mutable.Set("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should not include regex' failed` {
    val xs = collection.mutable.Set("hello A!", "hi B", "hello C!").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not include regex ("ell")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstInclude(xs, "ell")) + ", \"" + getFirstInclude(xs, "ell") + "\" included substring that matched regex ell (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstInclude(xs, "ell") + "\" included substring that matched regex ell")
  }
  def `collection.mutable.Set("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should fullyMatch regex' failed` {
    val xs = collection.mutable.Set("hello A!", "hi B", "hello C!").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should fullyMatch regex "h.*!"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotMatches(xs, "h.*!")) + ", \"" + getFirstNotMatches(xs, "h.*!") + "\" did not fully match the regular expression h.*! (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotMatches(xs, "h.*!") + "\" did not fully match the regular expression h.*!")
  }
  def `collection.mutable.Set("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should not fullyMatch regex' failed` {
    val xs = collection.mutable.Set("hello A!", "hi B", "hello C!").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not fullyMatch regex ("h.*!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstMatches(xs, "h.*!")) + ", \"" + getFirstMatches(xs, "h.*!") + "\" fully matched the regular expression h.*! (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstMatches(xs, "h.*!") + "\" fully matched the regular expression h.*!")
  }
  def `(new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!")).par should throw TestFailedException with correct stack depth and message when 'should startWith' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should startWith ("hello")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotStartsWith(xs, "hello")) + ", \"" + getFirstNotStartsWith(xs, "hello") + "\" did not start with substring \"hello\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotStartsWith(xs, "hello") + "\" did not start with substring \"hello\"")
  }
  def `(new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!")).par should throw TestFailedException with correct stack depth and message when 'should not startWith' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not startWith ("hello")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstStartsWith(xs, "hello")) + ", \"" + getFirstStartsWith(xs, "hello") + "\" started with substring \"hello\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstStartsWith(xs, "hello") + "\" started with substring \"hello\"")
  }
  def `(new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!")).par should throw TestFailedException with correct stack depth and message when 'should endWith' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should endWith ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotEndsWith(xs, "!")) + ", \"" + getFirstNotEndsWith(xs, "!") + "\" did not end with substring \"!\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotEndsWith(xs, "!") + "\" did not end with substring \"!\"")
  }
  def `(new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!")).par should throw TestFailedException with correct stack depth and message when 'should not endWith' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not endWith ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstEndsWith(xs, "!")) + ", \"" + getFirstEndsWith(xs, "!") + "\" ended with substring \"!\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstEndsWith(xs, "!") + "\" ended with substring \"!\"")
  }
  def `(new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!")).par should throw TestFailedException with correct stack depth and message when 'should include' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should include ("ell")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotInclude(xs, "ell")) + ", \"" + getFirstNotInclude(xs, "ell") + "\" did not include substring \"ell\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotInclude(xs, "ell") + "\" did not include substring \"ell\"")
  }
  def `(new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!")).par should throw TestFailedException with correct stack depth and message when 'should not include' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not include "ell"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstInclude(xs, "ell")) + ", \"" + getFirstInclude(xs, "ell") + "\" included substring \"ell\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstInclude(xs, "ell") + "\" included substring \"ell\"")
  }
  def `(new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!")).par should throw TestFailedException with correct stack depth and message when 'should startWith regex' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should startWith regex "hel*o"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotStartsWith(xs, "hello")) + ", \"" + getFirstNotStartsWith(xs, "hello") + "\" did not start with a substring that matched the regular expression hel*o (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotStartsWith(xs, "hello") + "\" did not start with a substring that matched the regular expression hel*o")
  }
  def `(new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!")).par should throw TestFailedException with correct stack depth and message when 'should not startWith regex' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not startWith regex ("hel*o")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstStartsWith(xs, "hello")) + ", \"" + getFirstStartsWith(xs, "hello") + "\" started with a substring that matched the regular expression hel*o (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstStartsWith(xs, "hello") + "\" started with a substring that matched the regular expression hel*o")
  }
  def `(new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!")).par should throw TestFailedException with correct stack depth and message when 'should endWith regex' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should endWith regex "!"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotEndsWith(xs, "!")) + ", \"" + getFirstNotEndsWith(xs, "!") + "\" did not end with a substring that matched the regular expression ! (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotEndsWith(xs, "!") + "\" did not end with a substring that matched the regular expression !")
  }
  def `(new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!")).par should throw TestFailedException with correct stack depth and message when 'should not endWith regex' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not endWith regex ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstEndsWith(xs, "!")) + ", \"" + getFirstEndsWith(xs, "!") + "\" ended with a substring that matched the regular expression ! (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstEndsWith(xs, "!") + "\" ended with a substring that matched the regular expression !")
  }
  def `(new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!")).par should throw TestFailedException with correct stack depth and message when 'should include regex' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should include regex "ell"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotInclude(xs, "ell")) + ", \"" + getFirstNotInclude(xs, "ell") + "\" did not include substring that matched regex ell (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotInclude(xs, "ell") + "\" did not include substring that matched regex ell")
  }
  def `(new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!")).par should throw TestFailedException with correct stack depth and message when 'should not include regex' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not include regex ("ell")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstInclude(xs, "ell")) + ", \"" + getFirstInclude(xs, "ell") + "\" included substring that matched regex ell (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstInclude(xs, "ell") + "\" included substring that matched regex ell")
  }
  def `(new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!")).par should throw TestFailedException with correct stack depth and message when 'should fullyMatch regex' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should fullyMatch regex "h.*!"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotMatches(xs, "h.*!")) + ", \"" + getFirstNotMatches(xs, "h.*!") + "\" did not fully match the regular expression h.*! (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotMatches(xs, "h.*!") + "\" did not fully match the regular expression h.*!")
  }
  def `(new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!")).par should throw TestFailedException with correct stack depth and message when 'should not fullyMatch regex' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not fullyMatch regex ("h.*!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstMatches(xs, "h.*!")) + ", \"" + getFirstMatches(xs, "h.*!") + "\" fully matched the regular expression h.*! (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstMatches(xs, "h.*!") + "\" fully matched the regular expression h.*!")
  }
  def `collection.mutable.Seq("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should startWith' failed` {
    val xs = collection.mutable.Seq("hello A!", "hi B", "hello C!").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should startWith ("hello")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotStartsWith(xs, "hello")) + ", \"" + getFirstNotStartsWith(xs, "hello") + "\" did not start with substring \"hello\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotStartsWith(xs, "hello") + "\" did not start with substring \"hello\"")
  }
  def `collection.mutable.Seq("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should not startWith' failed` {
    val xs = collection.mutable.Seq("hello A!", "hi B", "hello C!").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not startWith ("hello")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstStartsWith(xs, "hello")) + ", \"" + getFirstStartsWith(xs, "hello") + "\" started with substring \"hello\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstStartsWith(xs, "hello") + "\" started with substring \"hello\"")
  }
  def `collection.mutable.Seq("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should endWith' failed` {
    val xs = collection.mutable.Seq("hello A!", "hi B", "hello C!").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should endWith ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotEndsWith(xs, "!")) + ", \"" + getFirstNotEndsWith(xs, "!") + "\" did not end with substring \"!\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotEndsWith(xs, "!") + "\" did not end with substring \"!\"")
  }
  def `collection.mutable.Seq("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should not endWith' failed` {
    val xs = collection.mutable.Seq("hello A!", "hi B", "hello C!").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not endWith ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstEndsWith(xs, "!")) + ", \"" + getFirstEndsWith(xs, "!") + "\" ended with substring \"!\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstEndsWith(xs, "!") + "\" ended with substring \"!\"")
  }
  def `collection.mutable.Seq("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should include' failed` {
    val xs = collection.mutable.Seq("hello A!", "hi B", "hello C!").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should include ("ell")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotInclude(xs, "ell")) + ", \"" + getFirstNotInclude(xs, "ell") + "\" did not include substring \"ell\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotInclude(xs, "ell") + "\" did not include substring \"ell\"")
  }
  def `collection.mutable.Seq("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should not include' failed` {
    val xs = collection.mutable.Seq("hello A!", "hi B", "hello C!").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not include "ell"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstInclude(xs, "ell")) + ", \"" + getFirstInclude(xs, "ell") + "\" included substring \"ell\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstInclude(xs, "ell") + "\" included substring \"ell\"")
  }
  def `collection.mutable.Seq("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should startWith regex' failed` {
    val xs = collection.mutable.Seq("hello A!", "hi B", "hello C!").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should startWith regex "hel*o"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotStartsWith(xs, "hello")) + ", \"" + getFirstNotStartsWith(xs, "hello") + "\" did not start with a substring that matched the regular expression hel*o (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotStartsWith(xs, "hello") + "\" did not start with a substring that matched the regular expression hel*o")
  }
  def `collection.mutable.Seq("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should not startWith regex' failed` {
    val xs = collection.mutable.Seq("hello A!", "hi B", "hello C!").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not startWith regex ("hel*o")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstStartsWith(xs, "hello")) + ", \"" + getFirstStartsWith(xs, "hello") + "\" started with a substring that matched the regular expression hel*o (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstStartsWith(xs, "hello") + "\" started with a substring that matched the regular expression hel*o")
  }
  def `collection.mutable.Seq("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should endWith regex' failed` {
    val xs = collection.mutable.Seq("hello A!", "hi B", "hello C!").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should endWith regex "!"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotEndsWith(xs, "!")) + ", \"" + getFirstNotEndsWith(xs, "!") + "\" did not end with a substring that matched the regular expression ! (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotEndsWith(xs, "!") + "\" did not end with a substring that matched the regular expression !")
  }
  def `collection.mutable.Seq("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should not endWith regex' failed` {
    val xs = collection.mutable.Seq("hello A!", "hi B", "hello C!").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not endWith regex ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstEndsWith(xs, "!")) + ", \"" + getFirstEndsWith(xs, "!") + "\" ended with a substring that matched the regular expression ! (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstEndsWith(xs, "!") + "\" ended with a substring that matched the regular expression !")
  }
  def `collection.mutable.Seq("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should include regex' failed` {
    val xs = collection.mutable.Seq("hello A!", "hi B", "hello C!").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should include regex "ell"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotInclude(xs, "ell")) + ", \"" + getFirstNotInclude(xs, "ell") + "\" did not include substring that matched regex ell (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotInclude(xs, "ell") + "\" did not include substring that matched regex ell")
  }
  def `collection.mutable.Seq("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should not include regex' failed` {
    val xs = collection.mutable.Seq("hello A!", "hi B", "hello C!").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not include regex ("ell")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstInclude(xs, "ell")) + ", \"" + getFirstInclude(xs, "ell") + "\" included substring that matched regex ell (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstInclude(xs, "ell") + "\" included substring that matched regex ell")
  }
  def `collection.mutable.Seq("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should fullyMatch regex' failed` {
    val xs = collection.mutable.Seq("hello A!", "hi B", "hello C!").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should fullyMatch regex "h.*!"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotMatches(xs, "h.*!")) + ", \"" + getFirstNotMatches(xs, "h.*!") + "\" did not fully match the regular expression h.*! (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotMatches(xs, "h.*!") + "\" did not fully match the regular expression h.*!")
  }
  def `collection.mutable.Seq("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should not fullyMatch regex' failed` {
    val xs = collection.mutable.Seq("hello A!", "hi B", "hello C!").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not fullyMatch regex ("h.*!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstMatches(xs, "h.*!")) + ", \"" + getFirstMatches(xs, "h.*!") + "\" fully matched the regular expression h.*! (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstMatches(xs, "h.*!") + "\" fully matched the regular expression h.*!")
  }
  def `collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should startWith' failed` {
    val xs = collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should startWith ("hello")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotStartsWith(xs, "hello")) + ", \"" + getFirstNotStartsWith(xs, "hello") + "\" did not start with substring \"hello\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotStartsWith(xs, "hello") + "\" did not start with substring \"hello\"")
  }
  def `collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should not startWith' failed` {
    val xs = collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not startWith ("hello")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstStartsWith(xs, "hello")) + ", \"" + getFirstStartsWith(xs, "hello") + "\" started with substring \"hello\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstStartsWith(xs, "hello") + "\" started with substring \"hello\"")
  }
  def `collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should endWith' failed` {
    val xs = collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should endWith ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotEndsWith(xs, "!")) + ", \"" + getFirstNotEndsWith(xs, "!") + "\" did not end with substring \"!\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotEndsWith(xs, "!") + "\" did not end with substring \"!\"")
  }
  def `collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should not endWith' failed` {
    val xs = collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not endWith ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstEndsWith(xs, "!")) + ", \"" + getFirstEndsWith(xs, "!") + "\" ended with substring \"!\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstEndsWith(xs, "!") + "\" ended with substring \"!\"")
  }
  def `collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should include' failed` {
    val xs = collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should include ("ell")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotInclude(xs, "ell")) + ", \"" + getFirstNotInclude(xs, "ell") + "\" did not include substring \"ell\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotInclude(xs, "ell") + "\" did not include substring \"ell\"")
  }
  def `collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should not include' failed` {
    val xs = collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not include "ell"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstInclude(xs, "ell")) + ", \"" + getFirstInclude(xs, "ell") + "\" included substring \"ell\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstInclude(xs, "ell") + "\" included substring \"ell\"")
  }
  def `collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should startWith regex' failed` {
    val xs = collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should startWith regex "hel*o"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotStartsWith(xs, "hello")) + ", \"" + getFirstNotStartsWith(xs, "hello") + "\" did not start with a substring that matched the regular expression hel*o (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotStartsWith(xs, "hello") + "\" did not start with a substring that matched the regular expression hel*o")
  }
  def `collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should not startWith regex' failed` {
    val xs = collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not startWith regex ("hel*o")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstStartsWith(xs, "hello")) + ", \"" + getFirstStartsWith(xs, "hello") + "\" started with a substring that matched the regular expression hel*o (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstStartsWith(xs, "hello") + "\" started with a substring that matched the regular expression hel*o")
  }
  def `collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should endWith regex' failed` {
    val xs = collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should endWith regex "!"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotEndsWith(xs, "!")) + ", \"" + getFirstNotEndsWith(xs, "!") + "\" did not end with a substring that matched the regular expression ! (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotEndsWith(xs, "!") + "\" did not end with a substring that matched the regular expression !")
  }
  def `collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should not endWith regex' failed` {
    val xs = collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not endWith regex ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstEndsWith(xs, "!")) + ", \"" + getFirstEndsWith(xs, "!") + "\" ended with a substring that matched the regular expression ! (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstEndsWith(xs, "!") + "\" ended with a substring that matched the regular expression !")
  }
  def `collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should include regex' failed` {
    val xs = collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should include regex "ell"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotInclude(xs, "ell")) + ", \"" + getFirstNotInclude(xs, "ell") + "\" did not include substring that matched regex ell (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotInclude(xs, "ell") + "\" did not include substring that matched regex ell")
  }
  def `collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should not include regex' failed` {
    val xs = collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not include regex ("ell")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstInclude(xs, "ell")) + ", \"" + getFirstInclude(xs, "ell") + "\" included substring that matched regex ell (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstInclude(xs, "ell") + "\" included substring that matched regex ell")
  }
  def `collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should fullyMatch regex' failed` {
    val xs = collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should fullyMatch regex "h.*!"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotMatches(xs, "h.*!")) + ", \"" + getFirstNotMatches(xs, "h.*!") + "\" did not fully match the regular expression h.*! (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstNotMatches(xs, "h.*!") + "\" did not fully match the regular expression h.*!")
  }
  def `collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should not fullyMatch regex' failed` {
    val xs = collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!").par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not fullyMatch regex ("h.*!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstMatches(xs, "h.*!")) + ", \"" + getFirstMatches(xs, "h.*!") + "\" fully matched the regular expression h.*! (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "\"" + getFirstMatches(xs, "h.*!") + "\" fully matched the regular expression h.*!")
  }
  def `Set(Set[String]("hi"), Set[String]("boom!"), Set[String]()) should throw TestFailedException with correct stack depth and message when 'traversable should not be symbol' failed` {
    val xs = Set(Set[String]("hi"), Set[String]("boom!"), Set[String]())
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not be 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeEqualGenTraversable[String](xs, 0)) + ", " + getFirstSizeEqualGenTraversable[String](xs, 0) + " was empty (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstSizeEqualGenTraversable[String](xs, 0) + " was empty")
  }
  def `List(List[String]("hi"), List[String]("boom!"), List[String]()) should throw TestFailedException with correct stack depth and message when 'traversable should not be symbol' failed` {
    val xs = List(List[String]("hi"), List[String]("boom!"), List[String]())
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not be 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeEqualGenTraversable[String](xs, 0)) + ", " + getFirstSizeEqualGenTraversable[String](xs, 0) + " was empty (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstSizeEqualGenTraversable[String](xs, 0) + " was empty")
  }
  def `Seq(Seq[String]("hi"), Seq[String]("boom!"), Seq[String]()) should throw TestFailedException with correct stack depth and message when 'traversable should not be symbol' failed` {
    val xs = Seq(Seq[String]("hi"), Seq[String]("boom!"), Seq[String]())
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not be 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeEqualGenTraversable[String](xs, 0)) + ", " + getFirstSizeEqualGenTraversable[String](xs, 0) + " was empty (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstSizeEqualGenTraversable[String](xs, 0) + " was empty")
  }
  def `Array[Array[String]](Array[String]("hi"), Array[String]("boom!"), Array[String]()) should throw TestFailedException with correct stack depth and message when 'traversable should not be symbol' failed` {
    val xs = Array[Array[String]](Array[String]("hi"), Array[String]("boom!"), Array[String]())
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not be 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeEqualGenTraversableArray[String](xs, 0)) + ", " + getFirstSizeEqualGenTraversableArray[String](xs, 0).deep + " was empty (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + arrayToString(xs), "" + getFirstSizeEqualGenTraversableArray[String](xs, 0).deep + " was empty")
  }
  def `IndexedSeq(IndexedSeq[String]("hi"), IndexedSeq[String]("boom!"), IndexedSeq[String]()) should throw TestFailedException with correct stack depth and message when 'traversable should not be symbol' failed` {
    val xs = IndexedSeq(IndexedSeq[String]("hi"), IndexedSeq[String]("boom!"), IndexedSeq[String]())
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not be 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeEqualGenTraversable[String](xs, 0)) + ", " + getFirstSizeEqualGenTraversable[String](xs, 0) + " was empty (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstSizeEqualGenTraversable[String](xs, 0) + " was empty")
  }
  def `Vector(Vector[String]("hi"), Vector[String]("boom!"), Vector[String]()) should throw TestFailedException with correct stack depth and message when 'traversable should not be symbol' failed` {
    val xs = Vector(Vector[String]("hi"), Vector[String]("boom!"), Vector[String]())
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not be 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeEqualGenTraversable[String](xs, 0)) + ", " + getFirstSizeEqualGenTraversable[String](xs, 0) + " was empty (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstSizeEqualGenTraversable[String](xs, 0) + " was empty")
  }
  def `Set(Set[String]("hi").par, Set[String]("boom!").par, Set[String]().par).par should throw TestFailedException with correct stack depth and message when 'traversable should not be symbol' failed` {
    val xs = Set(Set[String]("hi").par, Set[String]("boom!").par, Set[String]().par).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not be 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeEqualGenTraversable[String](xs, 0)) + ", " + getFirstSizeEqualGenTraversable[String](xs, 0) + " was empty (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstSizeEqualGenTraversable[String](xs, 0) + " was empty")
  }
  def `List(List[String]("hi").par, List[String]("boom!").par, List[String]().par).par should throw TestFailedException with correct stack depth and message when 'traversable should not be symbol' failed` {
    val xs = List(List[String]("hi").par, List[String]("boom!").par, List[String]().par).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not be 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeEqualGenTraversable[String](xs, 0)) + ", " + getFirstSizeEqualGenTraversable[String](xs, 0) + " was empty (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstSizeEqualGenTraversable[String](xs, 0) + " was empty")
  }
  def `Seq(Seq[String]("hi").par, Seq[String]("boom!").par, Seq[String]().par).par should throw TestFailedException with correct stack depth and message when 'traversable should not be symbol' failed` {
    val xs = Seq(Seq[String]("hi").par, Seq[String]("boom!").par, Seq[String]().par).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not be 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeEqualGenTraversable[String](xs, 0)) + ", " + getFirstSizeEqualGenTraversable[String](xs, 0) + " was empty (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstSizeEqualGenTraversable[String](xs, 0) + " was empty")
  }
  def `IndexedSeq(IndexedSeq[String]("hi").par, IndexedSeq[String]("boom!").par, IndexedSeq[String]().par).par should throw TestFailedException with correct stack depth and message when 'traversable should not be symbol' failed` {
    val xs = IndexedSeq(IndexedSeq[String]("hi").par, IndexedSeq[String]("boom!").par, IndexedSeq[String]().par).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not be 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeEqualGenTraversable[String](xs, 0)) + ", " + getFirstSizeEqualGenTraversable[String](xs, 0) + " was empty (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstSizeEqualGenTraversable[String](xs, 0) + " was empty")
  }
  def `collection.mutable.Set(collection.mutable.Set[String]("hi"), collection.mutable.Set[String]("boom!"), collection.mutable.Set[String]()) should throw TestFailedException with correct stack depth and message when 'traversable should not be symbol' failed` {
    val xs = collection.mutable.Set(collection.mutable.Set[String]("hi"), collection.mutable.Set[String]("boom!"), collection.mutable.Set[String]())
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not be 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeEqualGenTraversable[String](xs, 0)) + ", " + getFirstSizeEqualGenTraversable[String](xs, 0) + " was empty (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstSizeEqualGenTraversable[String](xs, 0) + " was empty")
  }
  def `new collection.mutable.ListBuffer() ++ List(new collection.mutable.ListBuffer[String]() ++ List[String]("hi"), new collection.mutable.ListBuffer[String]() ++ List[String]("boom!"), new collection.mutable.ListBuffer[String]() ++ List[String]()) should throw TestFailedException with correct stack depth and message when 'traversable should not be symbol' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List(new collection.mutable.ListBuffer[String]() ++ List[String]("hi"), new collection.mutable.ListBuffer[String]() ++ List[String]("boom!"), new collection.mutable.ListBuffer[String]() ++ List[String]())
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not be 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeEqualGenTraversable[String](xs, 0)) + ", " + getFirstSizeEqualGenTraversable[String](xs, 0) + " was empty (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstSizeEqualGenTraversable[String](xs, 0) + " was empty")
  }
  def `collection.mutable.Seq(collection.mutable.Seq[String]("hi"), collection.mutable.Seq[String]("boom!"), collection.mutable.Seq[String]()) should throw TestFailedException with correct stack depth and message when 'traversable should not be symbol' failed` {
    val xs = collection.mutable.Seq(collection.mutable.Seq[String]("hi"), collection.mutable.Seq[String]("boom!"), collection.mutable.Seq[String]())
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not be 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeEqualGenTraversable[String](xs, 0)) + ", " + getFirstSizeEqualGenTraversable[String](xs, 0) + " was empty (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstSizeEqualGenTraversable[String](xs, 0) + " was empty")
  }
  def `collection.mutable.IndexedSeq(collection.mutable.IndexedSeq[String]("hi"), collection.mutable.IndexedSeq[String]("boom!"), collection.mutable.IndexedSeq[String]()) should throw TestFailedException with correct stack depth and message when 'traversable should not be symbol' failed` {
    val xs = collection.mutable.IndexedSeq(collection.mutable.IndexedSeq[String]("hi"), collection.mutable.IndexedSeq[String]("boom!"), collection.mutable.IndexedSeq[String]())
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not be 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeEqualGenTraversable[String](xs, 0)) + ", " + getFirstSizeEqualGenTraversable[String](xs, 0) + " was empty (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstSizeEqualGenTraversable[String](xs, 0) + " was empty")
  }
  def `collection.mutable.Set(collection.mutable.Set[String]("hi").par, collection.mutable.Set[String]("boom!").par, collection.mutable.Set[String]().par).par should throw TestFailedException with correct stack depth and message when 'traversable should not be symbol' failed` {
    val xs = collection.mutable.Set(collection.mutable.Set[String]("hi").par, collection.mutable.Set[String]("boom!").par, collection.mutable.Set[String]().par).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not be 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeEqualGenTraversable[String](xs, 0)) + ", " + getFirstSizeEqualGenTraversable[String](xs, 0) + " was empty (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstSizeEqualGenTraversable[String](xs, 0) + " was empty")
  }
  def `(new collection.mutable.ListBuffer() ++ List((new collection.mutable.ListBuffer[String]() ++ List[String]("hi")).par, (new collection.mutable.ListBuffer[String]() ++ List[String]("boom!")).par, (new collection.mutable.ListBuffer[String]() ++ List[String]()).par)).par should throw TestFailedException with correct stack depth and message when 'traversable should not be symbol' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List((new collection.mutable.ListBuffer[String]() ++ List[String]("hi")).par, (new collection.mutable.ListBuffer[String]() ++ List[String]("boom!")).par, (new collection.mutable.ListBuffer[String]() ++ List[String]()).par)).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not be 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeEqualGenTraversable[String](xs, 0)) + ", " + getFirstSizeEqualGenTraversable[String](xs, 0) + " was empty (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstSizeEqualGenTraversable[String](xs, 0) + " was empty")
  }
  def `collection.mutable.Seq(collection.mutable.Seq[String]("hi").par, collection.mutable.Seq[String]("boom!").par, collection.mutable.Seq[String]().par).par should throw TestFailedException with correct stack depth and message when 'traversable should not be symbol' failed` {
    val xs = collection.mutable.Seq(collection.mutable.Seq[String]("hi").par, collection.mutable.Seq[String]("boom!").par, collection.mutable.Seq[String]().par).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not be 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeEqualGenTraversable[String](xs, 0)) + ", " + getFirstSizeEqualGenTraversable[String](xs, 0) + " was empty (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstSizeEqualGenTraversable[String](xs, 0) + " was empty")
  }
  def `collection.mutable.IndexedSeq(collection.mutable.IndexedSeq[String]("hi").par, collection.mutable.IndexedSeq[String]("boom!").par, collection.mutable.IndexedSeq[String]().par).par should throw TestFailedException with correct stack depth and message when 'traversable should not be symbol' failed` {
    val xs = collection.mutable.IndexedSeq(collection.mutable.IndexedSeq[String]("hi").par, collection.mutable.IndexedSeq[String]("boom!").par, collection.mutable.IndexedSeq[String]().par).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not be 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeEqualGenTraversable[String](xs, 0)) + ", " + getFirstSizeEqualGenTraversable[String](xs, 0) + " was empty (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstSizeEqualGenTraversable[String](xs, 0) + " was empty")
  }
  def `Set(Set[String]("hi"), Set[String]("boom!"), Set[String]("hello")) should throw TestFailedException with correct stack depth and message when 'traversable should have size' failed` {
    val xs = Set(Set[String]("hi"), Set[String]("boom!"), Set[String]("hello"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should have size 0
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeNotEqualGenTraversable[String](xs, 0)) + ", " + getFirstSizeNotEqualGenTraversable[String](xs, 0) + " had size " + getFirstSizeNotEqualGenTraversable[String](xs, 0).size + " instead of expected size 0 (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstSizeNotEqualGenTraversable[String](xs, 0) + " had size " + getFirstSizeNotEqualGenTraversable[String](xs, 0).size + " instead of expected size 0")
  }
  def `Set(Set[String]("hi"), Set[String]("boom!"), Set[String]("hello")) should throw TestFailedException with correct stack depth and message when 'traversable should not have size' failed` {
    val xs = Set(Set[String]("hi"), Set[String]("boom!"), Set[String]("hello"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not have size (1)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeEqualGenTraversable[String](xs, 1)) + ", " + getFirstSizeEqualGenTraversable[String](xs, 1) + " had size 1 (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstSizeEqualGenTraversable[String](xs, 1) + " had size 1")
  }
  def `Set(Set[String]("hi"), Set[String]("boom!"), Set[String]("hello")) should throw TestFailedException with correct stack depth and message when 'traversable should contain' failed` {
    val xs = Set(Set[String]("hi"), Set[String]("boom!"), Set[String]("hello"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain ("hi")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainGenTraversable[String](xs, "hi")) + ", " + getFirstNotContainGenTraversable[String](xs, "hi") + " did not contain element \"hi\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainGenTraversable[String](xs, "hi") + " did not contain element \"hi\"")
  }
  def `Set(Set[String]("hi"), Set[String]("boom!"), Set[String]("hello")) should throw TestFailedException with correct stack depth and message when 'traversable should not contain' failed` {
    val xs = Set(Set[String]("hi"), Set[String]("boom!"), Set[String]("hello"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain "hi"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainGenTraversable[String](xs, "hi")) + ", " + getFirstContainGenTraversable[String](xs, "hi") + " contained element \"hi\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainGenTraversable[String](xs, "hi") + " contained element \"hi\"")
  }
  def `List(List[String]("hi"), List[String]("boom!"), List[String]("hello")) should throw TestFailedException with correct stack depth and message when 'traversable should have size' failed` {
    val xs = List(List[String]("hi"), List[String]("boom!"), List[String]("hello"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should have size 0
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeNotEqualGenTraversable[String](xs, 0)) + ", " + getFirstSizeNotEqualGenTraversable[String](xs, 0) + " had size " + getFirstSizeNotEqualGenTraversable[String](xs, 0).size + " instead of expected size 0 (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstSizeNotEqualGenTraversable[String](xs, 0) + " had size " + getFirstSizeNotEqualGenTraversable[String](xs, 0).size + " instead of expected size 0")
  }
  def `List(List[String]("hi"), List[String]("boom!"), List[String]("hello")) should throw TestFailedException with correct stack depth and message when 'traversable should not have size' failed` {
    val xs = List(List[String]("hi"), List[String]("boom!"), List[String]("hello"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not have size (1)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeEqualGenTraversable[String](xs, 1)) + ", " + getFirstSizeEqualGenTraversable[String](xs, 1) + " had size 1 (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstSizeEqualGenTraversable[String](xs, 1) + " had size 1")
  }
  def `List(List[String]("hi"), List[String]("boom!"), List[String]("hello")) should throw TestFailedException with correct stack depth and message when 'traversable should have length' failed` {
    val xs = List(List[String]("hi"), List[String]("boom!"), List[String]("hello"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should have length 0
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeNotEqualGenTraversable[String](xs, 0)) + ", " + getFirstSizeNotEqualGenTraversable[String](xs, 0) + " had length " + getFirstSizeNotEqualGenTraversable[String](xs, 0).size + " instead of expected length 0 (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstSizeNotEqualGenTraversable[String](xs, 0) + " had length " + getFirstSizeNotEqualGenTraversable[String](xs, 0).size + " instead of expected length 0")
  }
  def `List(List[String]("hi"), List[String]("boom!"), List[String]("hello")) should throw TestFailedException with correct stack depth and message when 'traversable should not have length' failed` {
    val xs = List(List[String]("hi"), List[String]("boom!"), List[String]("hello"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not have length (1)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeEqualGenTraversable[String](xs, 1)) + ", " + getFirstSizeEqualGenTraversable[String](xs, 1) + " had length 1 (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstSizeEqualGenTraversable[String](xs, 1) + " had length 1")
  }
  def `List(List[String]("hi"), List[String]("boom!"), List[String]("hello")) should throw TestFailedException with correct stack depth and message when 'traversable should contain' failed` {
    val xs = List(List[String]("hi"), List[String]("boom!"), List[String]("hello"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain ("hi")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainGenTraversable[String](xs, "hi")) + ", " + getFirstNotContainGenTraversable[String](xs, "hi") + " did not contain element \"hi\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainGenTraversable[String](xs, "hi") + " did not contain element \"hi\"")
  }
  def `List(List[String]("hi"), List[String]("boom!"), List[String]("hello")) should throw TestFailedException with correct stack depth and message when 'traversable should not contain' failed` {
    val xs = List(List[String]("hi"), List[String]("boom!"), List[String]("hello"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain "hi"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainGenTraversable[String](xs, "hi")) + ", " + getFirstContainGenTraversable[String](xs, "hi") + " contained element \"hi\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainGenTraversable[String](xs, "hi") + " contained element \"hi\"")
  }
  def `Seq(Seq[String]("hi"), Seq[String]("boom!"), Seq[String]("hello")) should throw TestFailedException with correct stack depth and message when 'traversable should have size' failed` {
    val xs = Seq(Seq[String]("hi"), Seq[String]("boom!"), Seq[String]("hello"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should have size 0
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeNotEqualGenTraversable[String](xs, 0)) + ", " + getFirstSizeNotEqualGenTraversable[String](xs, 0) + " had size " + getFirstSizeNotEqualGenTraversable[String](xs, 0).size + " instead of expected size 0 (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstSizeNotEqualGenTraversable[String](xs, 0) + " had size " + getFirstSizeNotEqualGenTraversable[String](xs, 0).size + " instead of expected size 0")
  }
  def `Seq(Seq[String]("hi"), Seq[String]("boom!"), Seq[String]("hello")) should throw TestFailedException with correct stack depth and message when 'traversable should not have size' failed` {
    val xs = Seq(Seq[String]("hi"), Seq[String]("boom!"), Seq[String]("hello"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not have size (1)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeEqualGenTraversable[String](xs, 1)) + ", " + getFirstSizeEqualGenTraversable[String](xs, 1) + " had size 1 (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstSizeEqualGenTraversable[String](xs, 1) + " had size 1")
  }
  def `Seq(Seq[String]("hi"), Seq[String]("boom!"), Seq[String]("hello")) should throw TestFailedException with correct stack depth and message when 'traversable should have length' failed` {
    val xs = Seq(Seq[String]("hi"), Seq[String]("boom!"), Seq[String]("hello"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should have length 0
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeNotEqualGenTraversable[String](xs, 0)) + ", " + getFirstSizeNotEqualGenTraversable[String](xs, 0) + " had length " + getFirstSizeNotEqualGenTraversable[String](xs, 0).size + " instead of expected length 0 (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstSizeNotEqualGenTraversable[String](xs, 0) + " had length " + getFirstSizeNotEqualGenTraversable[String](xs, 0).size + " instead of expected length 0")
  }
  def `Seq(Seq[String]("hi"), Seq[String]("boom!"), Seq[String]("hello")) should throw TestFailedException with correct stack depth and message when 'traversable should not have length' failed` {
    val xs = Seq(Seq[String]("hi"), Seq[String]("boom!"), Seq[String]("hello"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not have length (1)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeEqualGenTraversable[String](xs, 1)) + ", " + getFirstSizeEqualGenTraversable[String](xs, 1) + " had length 1 (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstSizeEqualGenTraversable[String](xs, 1) + " had length 1")
  }
  def `Seq(Seq[String]("hi"), Seq[String]("boom!"), Seq[String]("hello")) should throw TestFailedException with correct stack depth and message when 'traversable should contain' failed` {
    val xs = Seq(Seq[String]("hi"), Seq[String]("boom!"), Seq[String]("hello"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain ("hi")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainGenTraversable[String](xs, "hi")) + ", " + getFirstNotContainGenTraversable[String](xs, "hi") + " did not contain element \"hi\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainGenTraversable[String](xs, "hi") + " did not contain element \"hi\"")
  }
  def `Seq(Seq[String]("hi"), Seq[String]("boom!"), Seq[String]("hello")) should throw TestFailedException with correct stack depth and message when 'traversable should not contain' failed` {
    val xs = Seq(Seq[String]("hi"), Seq[String]("boom!"), Seq[String]("hello"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain "hi"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainGenTraversable[String](xs, "hi")) + ", " + getFirstContainGenTraversable[String](xs, "hi") + " contained element \"hi\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainGenTraversable[String](xs, "hi") + " contained element \"hi\"")
  }
  def `Array[Array[String]](Array[String]("hi"), Array[String]("boom!"), Array[String]("hello")) should throw TestFailedException with correct stack depth and message when 'traversable should have size' failed` {
    val xs = Array[Array[String]](Array[String]("hi"), Array[String]("boom!"), Array[String]("hello"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should have size 0
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeNotEqualGenTraversableArray[String](xs, 0)) + ", " + getFirstSizeNotEqualGenTraversableArray[String](xs, 0).deep + " had size " + getFirstSizeNotEqualGenTraversableArray[String](xs, 0).size + " instead of expected size 0 (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + arrayToString(xs), "" + getFirstSizeNotEqualGenTraversableArray[String](xs, 0).deep + " had size " + getFirstSizeNotEqualGenTraversableArray[String](xs, 0).size + " instead of expected size 0")
  }
  def `Array[Array[String]](Array[String]("hi"), Array[String]("boom!"), Array[String]("hello")) should throw TestFailedException with correct stack depth and message when 'traversable should not have size' failed` {
    val xs = Array[Array[String]](Array[String]("hi"), Array[String]("boom!"), Array[String]("hello"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not have size (1)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeEqualGenTraversableArray[String](xs, 1)) + ", " + getFirstSizeEqualGenTraversableArray[String](xs, 1).deep + " had size 1 (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + arrayToString(xs), "" + getFirstSizeEqualGenTraversableArray[String](xs, 1).deep + " had size 1")
  }
  def `Array[Array[String]](Array[String]("hi"), Array[String]("boom!"), Array[String]("hello")) should throw TestFailedException with correct stack depth and message when 'traversable should have length' failed` {
    val xs = Array[Array[String]](Array[String]("hi"), Array[String]("boom!"), Array[String]("hello"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should have length 0
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeNotEqualGenTraversableArray[String](xs, 0)) + ", " + getFirstSizeNotEqualGenTraversableArray[String](xs, 0).deep + " had length " + getFirstSizeNotEqualGenTraversableArray[String](xs, 0).size + " instead of expected length 0 (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + arrayToString(xs), "" + getFirstSizeNotEqualGenTraversableArray[String](xs, 0).deep + " had length " + getFirstSizeNotEqualGenTraversableArray[String](xs, 0).size + " instead of expected length 0")
  }
  def `Array[Array[String]](Array[String]("hi"), Array[String]("boom!"), Array[String]("hello")) should throw TestFailedException with correct stack depth and message when 'traversable should not have length' failed` {
    val xs = Array[Array[String]](Array[String]("hi"), Array[String]("boom!"), Array[String]("hello"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not have length (1)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeEqualGenTraversableArray[String](xs, 1)) + ", " + getFirstSizeEqualGenTraversableArray[String](xs, 1).deep + " had length 1 (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + arrayToString(xs), "" + getFirstSizeEqualGenTraversableArray[String](xs, 1).deep + " had length 1")
  }
  def `Array[Array[String]](Array[String]("hi"), Array[String]("boom!"), Array[String]("hello")) should throw TestFailedException with correct stack depth and message when 'traversable should contain' failed` {
    val xs = Array[Array[String]](Array[String]("hi"), Array[String]("boom!"), Array[String]("hello"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain ("hi")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainGenTraversableArray[String](xs, "hi")) + ", " + getFirstNotContainGenTraversableArray[String](xs, "hi").deep + " did not contain element \"hi\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + arrayToString(xs), "" + getFirstNotContainGenTraversableArray[String](xs, "hi").deep + " did not contain element \"hi\"")
  }
  def `Array[Array[String]](Array[String]("hi"), Array[String]("boom!"), Array[String]("hello")) should throw TestFailedException with correct stack depth and message when 'traversable should not contain' failed` {
    val xs = Array[Array[String]](Array[String]("hi"), Array[String]("boom!"), Array[String]("hello"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain "hi"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainGenTraversableArray[String](xs, "hi")) + ", " + getFirstContainGenTraversableArray[String](xs, "hi").deep + " contained element \"hi\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + arrayToString(xs), "" + getFirstContainGenTraversableArray[String](xs, "hi").deep + " contained element \"hi\"")
  }
  def `IndexedSeq(IndexedSeq[String]("hi"), IndexedSeq[String]("boom!"), IndexedSeq[String]("hello")) should throw TestFailedException with correct stack depth and message when 'traversable should have size' failed` {
    val xs = IndexedSeq(IndexedSeq[String]("hi"), IndexedSeq[String]("boom!"), IndexedSeq[String]("hello"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should have size 0
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeNotEqualGenTraversable[String](xs, 0)) + ", " + getFirstSizeNotEqualGenTraversable[String](xs, 0) + " had size " + getFirstSizeNotEqualGenTraversable[String](xs, 0).size + " instead of expected size 0 (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstSizeNotEqualGenTraversable[String](xs, 0) + " had size " + getFirstSizeNotEqualGenTraversable[String](xs, 0).size + " instead of expected size 0")
  }
  def `IndexedSeq(IndexedSeq[String]("hi"), IndexedSeq[String]("boom!"), IndexedSeq[String]("hello")) should throw TestFailedException with correct stack depth and message when 'traversable should not have size' failed` {
    val xs = IndexedSeq(IndexedSeq[String]("hi"), IndexedSeq[String]("boom!"), IndexedSeq[String]("hello"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not have size (1)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeEqualGenTraversable[String](xs, 1)) + ", " + getFirstSizeEqualGenTraversable[String](xs, 1) + " had size 1 (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstSizeEqualGenTraversable[String](xs, 1) + " had size 1")
  }
  def `IndexedSeq(IndexedSeq[String]("hi"), IndexedSeq[String]("boom!"), IndexedSeq[String]("hello")) should throw TestFailedException with correct stack depth and message when 'traversable should have length' failed` {
    val xs = IndexedSeq(IndexedSeq[String]("hi"), IndexedSeq[String]("boom!"), IndexedSeq[String]("hello"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should have length 0
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeNotEqualGenTraversable[String](xs, 0)) + ", " + getFirstSizeNotEqualGenTraversable[String](xs, 0) + " had length " + getFirstSizeNotEqualGenTraversable[String](xs, 0).size + " instead of expected length 0 (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstSizeNotEqualGenTraversable[String](xs, 0) + " had length " + getFirstSizeNotEqualGenTraversable[String](xs, 0).size + " instead of expected length 0")
  }
  def `IndexedSeq(IndexedSeq[String]("hi"), IndexedSeq[String]("boom!"), IndexedSeq[String]("hello")) should throw TestFailedException with correct stack depth and message when 'traversable should not have length' failed` {
    val xs = IndexedSeq(IndexedSeq[String]("hi"), IndexedSeq[String]("boom!"), IndexedSeq[String]("hello"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not have length (1)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeEqualGenTraversable[String](xs, 1)) + ", " + getFirstSizeEqualGenTraversable[String](xs, 1) + " had length 1 (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstSizeEqualGenTraversable[String](xs, 1) + " had length 1")
  }
  def `IndexedSeq(IndexedSeq[String]("hi"), IndexedSeq[String]("boom!"), IndexedSeq[String]("hello")) should throw TestFailedException with correct stack depth and message when 'traversable should contain' failed` {
    val xs = IndexedSeq(IndexedSeq[String]("hi"), IndexedSeq[String]("boom!"), IndexedSeq[String]("hello"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain ("hi")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainGenTraversable[String](xs, "hi")) + ", " + getFirstNotContainGenTraversable[String](xs, "hi") + " did not contain element \"hi\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainGenTraversable[String](xs, "hi") + " did not contain element \"hi\"")
  }
  def `IndexedSeq(IndexedSeq[String]("hi"), IndexedSeq[String]("boom!"), IndexedSeq[String]("hello")) should throw TestFailedException with correct stack depth and message when 'traversable should not contain' failed` {
    val xs = IndexedSeq(IndexedSeq[String]("hi"), IndexedSeq[String]("boom!"), IndexedSeq[String]("hello"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain "hi"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainGenTraversable[String](xs, "hi")) + ", " + getFirstContainGenTraversable[String](xs, "hi") + " contained element \"hi\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainGenTraversable[String](xs, "hi") + " contained element \"hi\"")
  }
  def `Vector(Vector[String]("hi"), Vector[String]("boom!"), Vector[String]("hello")) should throw TestFailedException with correct stack depth and message when 'traversable should have size' failed` {
    val xs = Vector(Vector[String]("hi"), Vector[String]("boom!"), Vector[String]("hello"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should have size 0
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeNotEqualGenTraversable[String](xs, 0)) + ", " + getFirstSizeNotEqualGenTraversable[String](xs, 0) + " had size " + getFirstSizeNotEqualGenTraversable[String](xs, 0).size + " instead of expected size 0 (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstSizeNotEqualGenTraversable[String](xs, 0) + " had size " + getFirstSizeNotEqualGenTraversable[String](xs, 0).size + " instead of expected size 0")
  }
  def `Vector(Vector[String]("hi"), Vector[String]("boom!"), Vector[String]("hello")) should throw TestFailedException with correct stack depth and message when 'traversable should not have size' failed` {
    val xs = Vector(Vector[String]("hi"), Vector[String]("boom!"), Vector[String]("hello"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not have size (1)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeEqualGenTraversable[String](xs, 1)) + ", " + getFirstSizeEqualGenTraversable[String](xs, 1) + " had size 1 (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstSizeEqualGenTraversable[String](xs, 1) + " had size 1")
  }
  def `Vector(Vector[String]("hi"), Vector[String]("boom!"), Vector[String]("hello")) should throw TestFailedException with correct stack depth and message when 'traversable should have length' failed` {
    val xs = Vector(Vector[String]("hi"), Vector[String]("boom!"), Vector[String]("hello"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should have length 0
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeNotEqualGenTraversable[String](xs, 0)) + ", " + getFirstSizeNotEqualGenTraversable[String](xs, 0) + " had length " + getFirstSizeNotEqualGenTraversable[String](xs, 0).size + " instead of expected length 0 (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstSizeNotEqualGenTraversable[String](xs, 0) + " had length " + getFirstSizeNotEqualGenTraversable[String](xs, 0).size + " instead of expected length 0")
  }
  def `Vector(Vector[String]("hi"), Vector[String]("boom!"), Vector[String]("hello")) should throw TestFailedException with correct stack depth and message when 'traversable should not have length' failed` {
    val xs = Vector(Vector[String]("hi"), Vector[String]("boom!"), Vector[String]("hello"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not have length (1)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeEqualGenTraversable[String](xs, 1)) + ", " + getFirstSizeEqualGenTraversable[String](xs, 1) + " had length 1 (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstSizeEqualGenTraversable[String](xs, 1) + " had length 1")
  }
  def `Vector(Vector[String]("hi"), Vector[String]("boom!"), Vector[String]("hello")) should throw TestFailedException with correct stack depth and message when 'traversable should contain' failed` {
    val xs = Vector(Vector[String]("hi"), Vector[String]("boom!"), Vector[String]("hello"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain ("hi")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainGenTraversable[String](xs, "hi")) + ", " + getFirstNotContainGenTraversable[String](xs, "hi") + " did not contain element \"hi\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainGenTraversable[String](xs, "hi") + " did not contain element \"hi\"")
  }
  def `Vector(Vector[String]("hi"), Vector[String]("boom!"), Vector[String]("hello")) should throw TestFailedException with correct stack depth and message when 'traversable should not contain' failed` {
    val xs = Vector(Vector[String]("hi"), Vector[String]("boom!"), Vector[String]("hello"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain "hi"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainGenTraversable[String](xs, "hi")) + ", " + getFirstContainGenTraversable[String](xs, "hi") + " contained element \"hi\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainGenTraversable[String](xs, "hi") + " contained element \"hi\"")
  }
  def `Set(Set[String]("hi").par, Set[String]("boom!").par, Set[String]("hello").par).par should throw TestFailedException with correct stack depth and message when 'traversable should have size' failed` {
    val xs = Set(Set[String]("hi").par, Set[String]("boom!").par, Set[String]("hello").par).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should have size 0
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeNotEqualGenTraversable[String](xs, 0)) + ", " + getFirstSizeNotEqualGenTraversable[String](xs, 0) + " had size " + getFirstSizeNotEqualGenTraversable[String](xs, 0).size + " instead of expected size 0 (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstSizeNotEqualGenTraversable[String](xs, 0) + " had size " + getFirstSizeNotEqualGenTraversable[String](xs, 0).size + " instead of expected size 0")
  }
  def `Set(Set[String]("hi").par, Set[String]("boom!").par, Set[String]("hello").par).par should throw TestFailedException with correct stack depth and message when 'traversable should not have size' failed` {
    val xs = Set(Set[String]("hi").par, Set[String]("boom!").par, Set[String]("hello").par).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not have size (1)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeEqualGenTraversable[String](xs, 1)) + ", " + getFirstSizeEqualGenTraversable[String](xs, 1) + " had size 1 (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstSizeEqualGenTraversable[String](xs, 1) + " had size 1")
  }
  def `Set(Set[String]("hi").par, Set[String]("boom!").par, Set[String]("hello").par).par should throw TestFailedException with correct stack depth and message when 'traversable should contain' failed` {
    val xs = Set(Set[String]("hi").par, Set[String]("boom!").par, Set[String]("hello").par).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain ("hi")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainGenTraversable[String](xs, "hi")) + ", " + getFirstNotContainGenTraversable[String](xs, "hi") + " did not contain element \"hi\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainGenTraversable[String](xs, "hi") + " did not contain element \"hi\"")
  }
  def `Set(Set[String]("hi").par, Set[String]("boom!").par, Set[String]("hello").par).par should throw TestFailedException with correct stack depth and message when 'traversable should not contain' failed` {
    val xs = Set(Set[String]("hi").par, Set[String]("boom!").par, Set[String]("hello").par).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain "hi"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainGenTraversable[String](xs, "hi")) + ", " + getFirstContainGenTraversable[String](xs, "hi") + " contained element \"hi\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainGenTraversable[String](xs, "hi") + " contained element \"hi\"")
  }
  def `List(List[String]("hi").par, List[String]("boom!").par, List[String]("hello").par).par should throw TestFailedException with correct stack depth and message when 'traversable should have size' failed` {
    val xs = List(List[String]("hi").par, List[String]("boom!").par, List[String]("hello").par).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should have size 0
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeNotEqualGenTraversable[String](xs, 0)) + ", " + getFirstSizeNotEqualGenTraversable[String](xs, 0) + " had size " + getFirstSizeNotEqualGenTraversable[String](xs, 0).size + " instead of expected size 0 (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstSizeNotEqualGenTraversable[String](xs, 0) + " had size " + getFirstSizeNotEqualGenTraversable[String](xs, 0).size + " instead of expected size 0")
  }
  def `List(List[String]("hi").par, List[String]("boom!").par, List[String]("hello").par).par should throw TestFailedException with correct stack depth and message when 'traversable should not have size' failed` {
    val xs = List(List[String]("hi").par, List[String]("boom!").par, List[String]("hello").par).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not have size (1)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeEqualGenTraversable[String](xs, 1)) + ", " + getFirstSizeEqualGenTraversable[String](xs, 1) + " had size 1 (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstSizeEqualGenTraversable[String](xs, 1) + " had size 1")
  }
  def `List(List[String]("hi").par, List[String]("boom!").par, List[String]("hello").par).par should throw TestFailedException with correct stack depth and message when 'traversable should have length' failed` {
    val xs = List(List[String]("hi").par, List[String]("boom!").par, List[String]("hello").par).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should have length 0
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeNotEqualGenTraversable[String](xs, 0)) + ", " + getFirstSizeNotEqualGenTraversable[String](xs, 0) + " had length " + getFirstSizeNotEqualGenTraversable[String](xs, 0).size + " instead of expected length 0 (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstSizeNotEqualGenTraversable[String](xs, 0) + " had length " + getFirstSizeNotEqualGenTraversable[String](xs, 0).size + " instead of expected length 0")
  }
  def `List(List[String]("hi").par, List[String]("boom!").par, List[String]("hello").par).par should throw TestFailedException with correct stack depth and message when 'traversable should not have length' failed` {
    val xs = List(List[String]("hi").par, List[String]("boom!").par, List[String]("hello").par).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not have length (1)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeEqualGenTraversable[String](xs, 1)) + ", " + getFirstSizeEqualGenTraversable[String](xs, 1) + " had length 1 (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstSizeEqualGenTraversable[String](xs, 1) + " had length 1")
  }
  def `List(List[String]("hi").par, List[String]("boom!").par, List[String]("hello").par).par should throw TestFailedException with correct stack depth and message when 'traversable should contain' failed` {
    val xs = List(List[String]("hi").par, List[String]("boom!").par, List[String]("hello").par).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain ("hi")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainGenTraversable[String](xs, "hi")) + ", " + getFirstNotContainGenTraversable[String](xs, "hi") + " did not contain element \"hi\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainGenTraversable[String](xs, "hi") + " did not contain element \"hi\"")
  }
  def `List(List[String]("hi").par, List[String]("boom!").par, List[String]("hello").par).par should throw TestFailedException with correct stack depth and message when 'traversable should not contain' failed` {
    val xs = List(List[String]("hi").par, List[String]("boom!").par, List[String]("hello").par).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain "hi"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainGenTraversable[String](xs, "hi")) + ", " + getFirstContainGenTraversable[String](xs, "hi") + " contained element \"hi\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainGenTraversable[String](xs, "hi") + " contained element \"hi\"")
  }
  def `Seq(Seq[String]("hi").par, Seq[String]("boom!").par, Seq[String]("hello").par).par should throw TestFailedException with correct stack depth and message when 'traversable should have size' failed` {
    val xs = Seq(Seq[String]("hi").par, Seq[String]("boom!").par, Seq[String]("hello").par).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should have size 0
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeNotEqualGenTraversable[String](xs, 0)) + ", " + getFirstSizeNotEqualGenTraversable[String](xs, 0) + " had size " + getFirstSizeNotEqualGenTraversable[String](xs, 0).size + " instead of expected size 0 (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstSizeNotEqualGenTraversable[String](xs, 0) + " had size " + getFirstSizeNotEqualGenTraversable[String](xs, 0).size + " instead of expected size 0")
  }
  def `Seq(Seq[String]("hi").par, Seq[String]("boom!").par, Seq[String]("hello").par).par should throw TestFailedException with correct stack depth and message when 'traversable should not have size' failed` {
    val xs = Seq(Seq[String]("hi").par, Seq[String]("boom!").par, Seq[String]("hello").par).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not have size (1)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeEqualGenTraversable[String](xs, 1)) + ", " + getFirstSizeEqualGenTraversable[String](xs, 1) + " had size 1 (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstSizeEqualGenTraversable[String](xs, 1) + " had size 1")
  }
  def `Seq(Seq[String]("hi").par, Seq[String]("boom!").par, Seq[String]("hello").par).par should throw TestFailedException with correct stack depth and message when 'traversable should have length' failed` {
    val xs = Seq(Seq[String]("hi").par, Seq[String]("boom!").par, Seq[String]("hello").par).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should have length 0
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeNotEqualGenTraversable[String](xs, 0)) + ", " + getFirstSizeNotEqualGenTraversable[String](xs, 0) + " had length " + getFirstSizeNotEqualGenTraversable[String](xs, 0).size + " instead of expected length 0 (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstSizeNotEqualGenTraversable[String](xs, 0) + " had length " + getFirstSizeNotEqualGenTraversable[String](xs, 0).size + " instead of expected length 0")
  }
  def `Seq(Seq[String]("hi").par, Seq[String]("boom!").par, Seq[String]("hello").par).par should throw TestFailedException with correct stack depth and message when 'traversable should not have length' failed` {
    val xs = Seq(Seq[String]("hi").par, Seq[String]("boom!").par, Seq[String]("hello").par).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not have length (1)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeEqualGenTraversable[String](xs, 1)) + ", " + getFirstSizeEqualGenTraversable[String](xs, 1) + " had length 1 (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstSizeEqualGenTraversable[String](xs, 1) + " had length 1")
  }
  def `Seq(Seq[String]("hi").par, Seq[String]("boom!").par, Seq[String]("hello").par).par should throw TestFailedException with correct stack depth and message when 'traversable should contain' failed` {
    val xs = Seq(Seq[String]("hi").par, Seq[String]("boom!").par, Seq[String]("hello").par).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain ("hi")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainGenTraversable[String](xs, "hi")) + ", " + getFirstNotContainGenTraversable[String](xs, "hi") + " did not contain element \"hi\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainGenTraversable[String](xs, "hi") + " did not contain element \"hi\"")
  }
  def `Seq(Seq[String]("hi").par, Seq[String]("boom!").par, Seq[String]("hello").par).par should throw TestFailedException with correct stack depth and message when 'traversable should not contain' failed` {
    val xs = Seq(Seq[String]("hi").par, Seq[String]("boom!").par, Seq[String]("hello").par).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain "hi"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainGenTraversable[String](xs, "hi")) + ", " + getFirstContainGenTraversable[String](xs, "hi") + " contained element \"hi\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainGenTraversable[String](xs, "hi") + " contained element \"hi\"")
  }
  def `IndexedSeq(IndexedSeq[String]("hi").par, IndexedSeq[String]("boom!").par, IndexedSeq[String]("hello").par).par should throw TestFailedException with correct stack depth and message when 'traversable should have size' failed` {
    val xs = IndexedSeq(IndexedSeq[String]("hi").par, IndexedSeq[String]("boom!").par, IndexedSeq[String]("hello").par).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should have size 0
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeNotEqualGenTraversable[String](xs, 0)) + ", " + getFirstSizeNotEqualGenTraversable[String](xs, 0) + " had size " + getFirstSizeNotEqualGenTraversable[String](xs, 0).size + " instead of expected size 0 (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstSizeNotEqualGenTraversable[String](xs, 0) + " had size " + getFirstSizeNotEqualGenTraversable[String](xs, 0).size + " instead of expected size 0")
  }
  def `IndexedSeq(IndexedSeq[String]("hi").par, IndexedSeq[String]("boom!").par, IndexedSeq[String]("hello").par).par should throw TestFailedException with correct stack depth and message when 'traversable should not have size' failed` {
    val xs = IndexedSeq(IndexedSeq[String]("hi").par, IndexedSeq[String]("boom!").par, IndexedSeq[String]("hello").par).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not have size (1)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeEqualGenTraversable[String](xs, 1)) + ", " + getFirstSizeEqualGenTraversable[String](xs, 1) + " had size 1 (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstSizeEqualGenTraversable[String](xs, 1) + " had size 1")
  }
  def `IndexedSeq(IndexedSeq[String]("hi").par, IndexedSeq[String]("boom!").par, IndexedSeq[String]("hello").par).par should throw TestFailedException with correct stack depth and message when 'traversable should have length' failed` {
    val xs = IndexedSeq(IndexedSeq[String]("hi").par, IndexedSeq[String]("boom!").par, IndexedSeq[String]("hello").par).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should have length 0
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeNotEqualGenTraversable[String](xs, 0)) + ", " + getFirstSizeNotEqualGenTraversable[String](xs, 0) + " had length " + getFirstSizeNotEqualGenTraversable[String](xs, 0).size + " instead of expected length 0 (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstSizeNotEqualGenTraversable[String](xs, 0) + " had length " + getFirstSizeNotEqualGenTraversable[String](xs, 0).size + " instead of expected length 0")
  }
  def `IndexedSeq(IndexedSeq[String]("hi").par, IndexedSeq[String]("boom!").par, IndexedSeq[String]("hello").par).par should throw TestFailedException with correct stack depth and message when 'traversable should not have length' failed` {
    val xs = IndexedSeq(IndexedSeq[String]("hi").par, IndexedSeq[String]("boom!").par, IndexedSeq[String]("hello").par).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not have length (1)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeEqualGenTraversable[String](xs, 1)) + ", " + getFirstSizeEqualGenTraversable[String](xs, 1) + " had length 1 (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstSizeEqualGenTraversable[String](xs, 1) + " had length 1")
  }
  def `IndexedSeq(IndexedSeq[String]("hi").par, IndexedSeq[String]("boom!").par, IndexedSeq[String]("hello").par).par should throw TestFailedException with correct stack depth and message when 'traversable should contain' failed` {
    val xs = IndexedSeq(IndexedSeq[String]("hi").par, IndexedSeq[String]("boom!").par, IndexedSeq[String]("hello").par).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain ("hi")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainGenTraversable[String](xs, "hi")) + ", " + getFirstNotContainGenTraversable[String](xs, "hi") + " did not contain element \"hi\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainGenTraversable[String](xs, "hi") + " did not contain element \"hi\"")
  }
  def `IndexedSeq(IndexedSeq[String]("hi").par, IndexedSeq[String]("boom!").par, IndexedSeq[String]("hello").par).par should throw TestFailedException with correct stack depth and message when 'traversable should not contain' failed` {
    val xs = IndexedSeq(IndexedSeq[String]("hi").par, IndexedSeq[String]("boom!").par, IndexedSeq[String]("hello").par).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain "hi"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainGenTraversable[String](xs, "hi")) + ", " + getFirstContainGenTraversable[String](xs, "hi") + " contained element \"hi\" (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainGenTraversable[String](xs, "hi") + " contained element \"hi\"")
  }
  def `collection.mutable.Set(collection.mutable.Set[String]("hi"), collection.mutable.Set[String]("boom!"), collection.mutable.Set[String]("hello")) should throw TestFailedException with correct stack depth and message when 'traversable should have size' failed` {
    val xs = collection.mutable.Set(collection.mutable.Set[String]("hi"), collection.mutable.Set[String]("boom!"), collection.mutable.Set[String]("hello"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should have size 0
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeNotEqualGenTraversable[String](xs, 0)) + ", " + getFirstSizeNotEqualGenTraversable[String](xs, 0) + " had size " + getFirstSizeNotEqualGenTraversable[String](xs, 0).size + " instead of expected size 0 (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstSizeNotEqualGenTraversable[String](xs, 0) + " had size " + getFirstSizeNotEqualGenTraversable[String](xs, 0).size + " instead of expected size 0")
  }
  def `collection.mutable.Set(collection.mutable.Set[String]("hi"), collection.mutable.Set[String]("boom!"), collection.mutable.Set[String]("hello")) should throw TestFailedException with correct stack depth and message when 'traversable should not have size' failed` {
    val xs = collection.mutable.Set(collection.mutable.Set[String]("hi"), collection.mutable.Set[String]("boom!"), collection.mutable.Set[String]("hello"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not have size (1)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec1.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeEqualGenTraversable[String](xs, 1)) + ", " + getFirstSizeEqualGenTraversable[String](xs, 1) + " had size 1 (InspectorShorthandsForAllFailedSpec1.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstSizeEqualGenTraversable[String](xs, 1) + " had size 1")
  }
}
