package org.scalatest.inspectors.all

import org.scalatest._
import SharedHelpers._
import org.scalatest.matchers.{BePropertyMatcher, BePropertyMatchResult, HavePropertyMatcher, HavePropertyMatchResult}
import collection.GenTraversable
import collection.GenMap
class InspectorShorthandsForAllFailedSpec2 extends Spec with Matchers {
  class EmptyBePropertyMatcher extends BePropertyMatcher[String] {
    def apply(left: String) = BePropertyMatchResult(left.isEmpty, "empty")
  }
  class StringLengthMatcher(expectedValue: Int) extends HavePropertyMatcher[String, Int] {
    def apply(value: String) = {
      new HavePropertyMatchResult(value.length == expectedValue, "length", expectedValue, value.length)
    }
  }
  val empty = new EmptyBePropertyMatcher()
  def plength(expectedValue: Int) = new StringLengthMatcher(expectedValue)
  val theInstance = "2"
  def arrayToString(xs: GenTraversable[_]): String = xs.toString
  def checkErrorAndCause(e: exceptions.TestFailedException, assertLineNumber: Int, fileName: String, errorMessage: String, causeErrorMessage: String) {
    assert(e.failedCodeFileName == Some(fileName), e.failedCodeFileName + " did not equal " + Some(fileName))
    assert(e.failedCodeLineNumber == Some(assertLineNumber), e.failedCodeLineNumber + " did not equal " + Some(assertLineNumber))
    assert(e.message == Some(errorMessage), e.message + " did not equal " + Some(
  errorMessage))
    e.getCause match {
      case tfe: exceptions.TestFailedException =>
        assert(tfe.failedCodeFileName == Some(fileName), tfe.failedCodeFileName + " did not equal " + Some(fileName))
        assert(tfe.failedCodeLineNumber == Some(assertLineNumber), tfe.failedCodeLineNumber + " did not equal " + Some(assertLineNumber))
        assert(tfe.message == Some(causeErrorMessage), tfe.message + " did not equal " + Some(causeErrorMessage))
        assert(tfe.getCause == null, tfe.getCause + " was not null")
      case other => fail("Expected cause to be TestFailedException, but got: " + other)
    }
  }
  def checkError(e: exceptions.TestFailedException, assertLineNumber: Int, fileName: String, errorMessage: String) {
    assert(e.failedCodeFileName == Some(fileName), e.failedCodeFileName + " did not equal " + Some(fileName))
    assert(e.failedCodeLineNumber == Some(assertLineNumber), e.failedCodeLineNumber + " did not equal " + Some(assertLineNumber))
    assert(e.message == Some(errorMessage), e.message + " did not equal " + Some(
  errorMessage))
  }
  def equal[T](left: T, right: T): Boolean = left == right
  def javaArrayList[T](valueList: List[T]): java.util.ArrayList[T] = {
    val col = new java.util.ArrayList[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaHashSet[T](valueList: List[T]): java.util.HashSet[T] = {
    val col = new java.util.HashSet[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaLinkedList[T](valueList: List[T]): java.util.LinkedList[T] = {
    val col = new java.util.LinkedList[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaStack[T](valueList: List[T]): java.util.Stack[T] = {
    val col = new java.util.Stack[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaTreeSet[T](valueList: List[T]): java.util.TreeSet[T] = {
    val col = new java.util.TreeSet[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaVector[T](valueList: List[T]): java.util.Vector[T] = {
    val col = new java.util.Vector[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaArrayBlockingQueue[T](valueList: List[T], size: Int): java.util.concurrent.ArrayBlockingQueue[T] = {
    val col = new java.util.concurrent.ArrayBlockingQueue[T](size)
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaArrayDeque[T](valueList: List[T]): java.util.ArrayDeque[T] = {
    val col = new java.util.ArrayDeque[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaConcurrentLinkedQueue[T](valueList: List[T]): java.util.concurrent.ConcurrentLinkedQueue[T] = {
    val col = new java.util.concurrent.ConcurrentLinkedQueue[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaConcurrentSkipListSet[T](valueList: List[T]): java.util.concurrent.ConcurrentSkipListSet[T] = {
    val col = new java.util.concurrent.ConcurrentSkipListSet[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaCopyOnWriteArrayList[T](valueList: List[T]): java.util.concurrent.CopyOnWriteArrayList[T] = {
    val col = new java.util.concurrent.CopyOnWriteArrayList[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaCopyOnWriteArraySet[T](valueList: List[T]): java.util.concurrent.CopyOnWriteArraySet[T] = {
    val col = new java.util.concurrent.CopyOnWriteArraySet[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaLinkedBlockingDeque[T](valueList: List[T]): java.util.concurrent.LinkedBlockingDeque[T] = {
    val col = new java.util.concurrent.LinkedBlockingDeque[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaLinkedBlockingQueue[T](valueList: List[T]): java.util.concurrent.LinkedBlockingQueue[T] = {
    val col = new java.util.concurrent.LinkedBlockingQueue[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaLinkedHashSet[T](valueList: List[T]): java.util.LinkedHashSet[T] = {
    val col = new java.util.LinkedHashSet[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaPriorityBlockingQueue[T](valueList: List[T]): java.util.concurrent.PriorityBlockingQueue[T] = {
    val col = new java.util.concurrent.PriorityBlockingQueue[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaPriorityQueue[T](valueList: List[T]): java.util.PriorityQueue[T] = {
    val col = new java.util.PriorityQueue[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaHashMap[K, V](valueMap: Map[K, V]): java.util.HashMap[K, V] = {
    val map = new java.util.HashMap[K, V]()
    for ((key, value) <- valueMap)
      map.put(key, value)
    map
  }
  def javaTreeMap[K, V](valueMap: Map[K, V]): java.util.TreeMap[K, V] = {
    val map = new java.util.TreeMap[K, V]()
    for ((key, value) <- valueMap)
      map.put(key, value)
    map
  }
  def javaHashtable[K, V](valueMap: Map[K, V]): java.util.Hashtable[K, V] = {
    val map = new java.util.Hashtable[K, V]()
    for ((key, value) <- valueMap)
      map.put(key, value)
    map
  }
  def javaConcurrentHashMap[K, V](valueMap: Map[K, V]): java.util.concurrent.ConcurrentHashMap[K, V] = {
    val map = new java.util.concurrent.ConcurrentHashMap[K, V]()
    for ((key, value) <- valueMap)
      map.put(key, value)
    map
  }
  def javaConcurrentSkipListMap[K, V](valueMap: Map[K, V]): java.util.concurrent.ConcurrentSkipListMap[K, V] = {
    val map = new java.util.concurrent.ConcurrentSkipListMap[K, V]()
    for ((key, value) <- valueMap)
      map.put(key, value)
    map
  }
  def javaLinkedHashMap[K, V](valueMap: Map[K, V]): java.util.LinkedHashMap[K, V] = {
    val map = new java.util.LinkedHashMap[K, V]()
    for ((key, value) <- valueMap)
      map.put(key, value)
    map
  }
  def javaWeakHashMap[K, V](valueMap: Map[K, V]): java.util.WeakHashMap[K, V] = {
    val map = new java.util.WeakHashMap[K, V]()
    for ((key, value) <- valueMap)
      map.put(key, value)
    map
  }
  def javaProperties(valueMap: Map[String, String]): java.util.Properties = {
    val map = new java.util.Properties()
    for ((key, value) <- valueMap)
      map.put(key, value)
    map
  }
  def `collection.mutable.Set(collection.mutable.Set[String]("hi"), collection.mutable.Set[String]("boom!"), collection.mutable.Set[String]("hello")) should throw TestFailedException with correct stack depth and message when 'traversable should contain' failed` {
    val xs = collection.mutable.Set(collection.mutable.Set[String]("hi"), collection.mutable.Set[String]("boom!"), collection.mutable.Set[String]("hello"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain ("hi")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainGenTraversable[String](xs, "hi")) + ", " + getFirstNotContainGenTraversable[String](xs, "hi") + " did not contain element \"hi\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainGenTraversable[String](xs, "hi") + " did not contain element \"hi\"")
  }
  def `collection.mutable.Set(collection.mutable.Set[String]("hi"), collection.mutable.Set[String]("boom!"), collection.mutable.Set[String]("hello")) should throw TestFailedException with correct stack depth and message when 'traversable should not contain' failed` {
    val xs = collection.mutable.Set(collection.mutable.Set[String]("hi"), collection.mutable.Set[String]("boom!"), collection.mutable.Set[String]("hello"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain "hi"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainGenTraversable[String](xs, "hi")) + ", " + getFirstContainGenTraversable[String](xs, "hi") + " contained element \"hi\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainGenTraversable[String](xs, "hi") + " contained element \"hi\"")
  }
  def `new collection.mutable.ListBuffer() ++ List(new collection.mutable.ListBuffer[String]() ++ List[String]("hi"), new collection.mutable.ListBuffer[String]() ++ List[String]("boom!"), new collection.mutable.ListBuffer[String]() ++ List[String]("hello")) should throw TestFailedException with correct stack depth and message when 'traversable should have size' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List(new collection.mutable.ListBuffer[String]() ++ List[String]("hi"), new collection.mutable.ListBuffer[String]() ++ List[String]("boom!"), new collection.mutable.ListBuffer[String]() ++ List[String]("hello"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should have size 0
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeNotEqualGenTraversable[String](xs, 0)) + ", " + getFirstSizeNotEqualGenTraversable[String](xs, 0) + " had size " + getFirstSizeNotEqualGenTraversable[String](xs, 0).size + " instead of expected size 0 (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstSizeNotEqualGenTraversable[String](xs, 0) + " had size " + getFirstSizeNotEqualGenTraversable[String](xs, 0).size + " instead of expected size 0")
  }
  def `new collection.mutable.ListBuffer() ++ List(new collection.mutable.ListBuffer[String]() ++ List[String]("hi"), new collection.mutable.ListBuffer[String]() ++ List[String]("boom!"), new collection.mutable.ListBuffer[String]() ++ List[String]("hello")) should throw TestFailedException with correct stack depth and message when 'traversable should not have size' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List(new collection.mutable.ListBuffer[String]() ++ List[String]("hi"), new collection.mutable.ListBuffer[String]() ++ List[String]("boom!"), new collection.mutable.ListBuffer[String]() ++ List[String]("hello"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not have size (1)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeEqualGenTraversable[String](xs, 1)) + ", " + getFirstSizeEqualGenTraversable[String](xs, 1) + " had size 1 (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstSizeEqualGenTraversable[String](xs, 1) + " had size 1")
  }
  def `new collection.mutable.ListBuffer() ++ List(new collection.mutable.ListBuffer[String]() ++ List[String]("hi"), new collection.mutable.ListBuffer[String]() ++ List[String]("boom!"), new collection.mutable.ListBuffer[String]() ++ List[String]("hello")) should throw TestFailedException with correct stack depth and message when 'traversable should have length' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List(new collection.mutable.ListBuffer[String]() ++ List[String]("hi"), new collection.mutable.ListBuffer[String]() ++ List[String]("boom!"), new collection.mutable.ListBuffer[String]() ++ List[String]("hello"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should have length 0
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeNotEqualGenTraversable[String](xs, 0)) + ", " + getFirstSizeNotEqualGenTraversable[String](xs, 0) + " had length " + getFirstSizeNotEqualGenTraversable[String](xs, 0).size + " instead of expected length 0 (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstSizeNotEqualGenTraversable[String](xs, 0) + " had length " + getFirstSizeNotEqualGenTraversable[String](xs, 0).size + " instead of expected length 0")
  }
  def `new collection.mutable.ListBuffer() ++ List(new collection.mutable.ListBuffer[String]() ++ List[String]("hi"), new collection.mutable.ListBuffer[String]() ++ List[String]("boom!"), new collection.mutable.ListBuffer[String]() ++ List[String]("hello")) should throw TestFailedException with correct stack depth and message when 'traversable should not have length' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List(new collection.mutable.ListBuffer[String]() ++ List[String]("hi"), new collection.mutable.ListBuffer[String]() ++ List[String]("boom!"), new collection.mutable.ListBuffer[String]() ++ List[String]("hello"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not have length (1)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeEqualGenTraversable[String](xs, 1)) + ", " + getFirstSizeEqualGenTraversable[String](xs, 1) + " had length 1 (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstSizeEqualGenTraversable[String](xs, 1) + " had length 1")
  }
  def `new collection.mutable.ListBuffer() ++ List(new collection.mutable.ListBuffer[String]() ++ List[String]("hi"), new collection.mutable.ListBuffer[String]() ++ List[String]("boom!"), new collection.mutable.ListBuffer[String]() ++ List[String]("hello")) should throw TestFailedException with correct stack depth and message when 'traversable should contain' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List(new collection.mutable.ListBuffer[String]() ++ List[String]("hi"), new collection.mutable.ListBuffer[String]() ++ List[String]("boom!"), new collection.mutable.ListBuffer[String]() ++ List[String]("hello"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain ("hi")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainGenTraversable[String](xs, "hi")) + ", " + getFirstNotContainGenTraversable[String](xs, "hi") + " did not contain element \"hi\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainGenTraversable[String](xs, "hi") + " did not contain element \"hi\"")
  }
  def `new collection.mutable.ListBuffer() ++ List(new collection.mutable.ListBuffer[String]() ++ List[String]("hi"), new collection.mutable.ListBuffer[String]() ++ List[String]("boom!"), new collection.mutable.ListBuffer[String]() ++ List[String]("hello")) should throw TestFailedException with correct stack depth and message when 'traversable should not contain' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List(new collection.mutable.ListBuffer[String]() ++ List[String]("hi"), new collection.mutable.ListBuffer[String]() ++ List[String]("boom!"), new collection.mutable.ListBuffer[String]() ++ List[String]("hello"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain "hi"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainGenTraversable[String](xs, "hi")) + ", " + getFirstContainGenTraversable[String](xs, "hi") + " contained element \"hi\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainGenTraversable[String](xs, "hi") + " contained element \"hi\"")
  }
  def `collection.mutable.Seq(collection.mutable.Seq[String]("hi"), collection.mutable.Seq[String]("boom!"), collection.mutable.Seq[String]("hello")) should throw TestFailedException with correct stack depth and message when 'traversable should have size' failed` {
    val xs = collection.mutable.Seq(collection.mutable.Seq[String]("hi"), collection.mutable.Seq[String]("boom!"), collection.mutable.Seq[String]("hello"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should have size 0
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeNotEqualGenTraversable[String](xs, 0)) + ", " + getFirstSizeNotEqualGenTraversable[String](xs, 0) + " had size " + getFirstSizeNotEqualGenTraversable[String](xs, 0).size + " instead of expected size 0 (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstSizeNotEqualGenTraversable[String](xs, 0) + " had size " + getFirstSizeNotEqualGenTraversable[String](xs, 0).size + " instead of expected size 0")
  }
  def `collection.mutable.Seq(collection.mutable.Seq[String]("hi"), collection.mutable.Seq[String]("boom!"), collection.mutable.Seq[String]("hello")) should throw TestFailedException with correct stack depth and message when 'traversable should not have size' failed` {
    val xs = collection.mutable.Seq(collection.mutable.Seq[String]("hi"), collection.mutable.Seq[String]("boom!"), collection.mutable.Seq[String]("hello"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not have size (1)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeEqualGenTraversable[String](xs, 1)) + ", " + getFirstSizeEqualGenTraversable[String](xs, 1) + " had size 1 (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstSizeEqualGenTraversable[String](xs, 1) + " had size 1")
  }
  def `collection.mutable.Seq(collection.mutable.Seq[String]("hi"), collection.mutable.Seq[String]("boom!"), collection.mutable.Seq[String]("hello")) should throw TestFailedException with correct stack depth and message when 'traversable should have length' failed` {
    val xs = collection.mutable.Seq(collection.mutable.Seq[String]("hi"), collection.mutable.Seq[String]("boom!"), collection.mutable.Seq[String]("hello"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should have length 0
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeNotEqualGenTraversable[String](xs, 0)) + ", " + getFirstSizeNotEqualGenTraversable[String](xs, 0) + " had length " + getFirstSizeNotEqualGenTraversable[String](xs, 0).size + " instead of expected length 0 (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstSizeNotEqualGenTraversable[String](xs, 0) + " had length " + getFirstSizeNotEqualGenTraversable[String](xs, 0).size + " instead of expected length 0")
  }
  def `collection.mutable.Seq(collection.mutable.Seq[String]("hi"), collection.mutable.Seq[String]("boom!"), collection.mutable.Seq[String]("hello")) should throw TestFailedException with correct stack depth and message when 'traversable should not have length' failed` {
    val xs = collection.mutable.Seq(collection.mutable.Seq[String]("hi"), collection.mutable.Seq[String]("boom!"), collection.mutable.Seq[String]("hello"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not have length (1)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeEqualGenTraversable[String](xs, 1)) + ", " + getFirstSizeEqualGenTraversable[String](xs, 1) + " had length 1 (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstSizeEqualGenTraversable[String](xs, 1) + " had length 1")
  }
  def `collection.mutable.Seq(collection.mutable.Seq[String]("hi"), collection.mutable.Seq[String]("boom!"), collection.mutable.Seq[String]("hello")) should throw TestFailedException with correct stack depth and message when 'traversable should contain' failed` {
    val xs = collection.mutable.Seq(collection.mutable.Seq[String]("hi"), collection.mutable.Seq[String]("boom!"), collection.mutable.Seq[String]("hello"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain ("hi")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainGenTraversable[String](xs, "hi")) + ", " + getFirstNotContainGenTraversable[String](xs, "hi") + " did not contain element \"hi\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainGenTraversable[String](xs, "hi") + " did not contain element \"hi\"")
  }
  def `collection.mutable.Seq(collection.mutable.Seq[String]("hi"), collection.mutable.Seq[String]("boom!"), collection.mutable.Seq[String]("hello")) should throw TestFailedException with correct stack depth and message when 'traversable should not contain' failed` {
    val xs = collection.mutable.Seq(collection.mutable.Seq[String]("hi"), collection.mutable.Seq[String]("boom!"), collection.mutable.Seq[String]("hello"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain "hi"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainGenTraversable[String](xs, "hi")) + ", " + getFirstContainGenTraversable[String](xs, "hi") + " contained element \"hi\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainGenTraversable[String](xs, "hi") + " contained element \"hi\"")
  }
  def `collection.mutable.IndexedSeq(collection.mutable.IndexedSeq[String]("hi"), collection.mutable.IndexedSeq[String]("boom!"), collection.mutable.IndexedSeq[String]("hello")) should throw TestFailedException with correct stack depth and message when 'traversable should have size' failed` {
    val xs = collection.mutable.IndexedSeq(collection.mutable.IndexedSeq[String]("hi"), collection.mutable.IndexedSeq[String]("boom!"), collection.mutable.IndexedSeq[String]("hello"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should have size 0
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeNotEqualGenTraversable[String](xs, 0)) + ", " + getFirstSizeNotEqualGenTraversable[String](xs, 0) + " had size " + getFirstSizeNotEqualGenTraversable[String](xs, 0).size + " instead of expected size 0 (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstSizeNotEqualGenTraversable[String](xs, 0) + " had size " + getFirstSizeNotEqualGenTraversable[String](xs, 0).size + " instead of expected size 0")
  }
  def `collection.mutable.IndexedSeq(collection.mutable.IndexedSeq[String]("hi"), collection.mutable.IndexedSeq[String]("boom!"), collection.mutable.IndexedSeq[String]("hello")) should throw TestFailedException with correct stack depth and message when 'traversable should not have size' failed` {
    val xs = collection.mutable.IndexedSeq(collection.mutable.IndexedSeq[String]("hi"), collection.mutable.IndexedSeq[String]("boom!"), collection.mutable.IndexedSeq[String]("hello"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not have size (1)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeEqualGenTraversable[String](xs, 1)) + ", " + getFirstSizeEqualGenTraversable[String](xs, 1) + " had size 1 (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstSizeEqualGenTraversable[String](xs, 1) + " had size 1")
  }
  def `collection.mutable.IndexedSeq(collection.mutable.IndexedSeq[String]("hi"), collection.mutable.IndexedSeq[String]("boom!"), collection.mutable.IndexedSeq[String]("hello")) should throw TestFailedException with correct stack depth and message when 'traversable should have length' failed` {
    val xs = collection.mutable.IndexedSeq(collection.mutable.IndexedSeq[String]("hi"), collection.mutable.IndexedSeq[String]("boom!"), collection.mutable.IndexedSeq[String]("hello"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should have length 0
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeNotEqualGenTraversable[String](xs, 0)) + ", " + getFirstSizeNotEqualGenTraversable[String](xs, 0) + " had length " + getFirstSizeNotEqualGenTraversable[String](xs, 0).size + " instead of expected length 0 (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstSizeNotEqualGenTraversable[String](xs, 0) + " had length " + getFirstSizeNotEqualGenTraversable[String](xs, 0).size + " instead of expected length 0")
  }
  def `collection.mutable.IndexedSeq(collection.mutable.IndexedSeq[String]("hi"), collection.mutable.IndexedSeq[String]("boom!"), collection.mutable.IndexedSeq[String]("hello")) should throw TestFailedException with correct stack depth and message when 'traversable should not have length' failed` {
    val xs = collection.mutable.IndexedSeq(collection.mutable.IndexedSeq[String]("hi"), collection.mutable.IndexedSeq[String]("boom!"), collection.mutable.IndexedSeq[String]("hello"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not have length (1)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeEqualGenTraversable[String](xs, 1)) + ", " + getFirstSizeEqualGenTraversable[String](xs, 1) + " had length 1 (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstSizeEqualGenTraversable[String](xs, 1) + " had length 1")
  }
  def `collection.mutable.IndexedSeq(collection.mutable.IndexedSeq[String]("hi"), collection.mutable.IndexedSeq[String]("boom!"), collection.mutable.IndexedSeq[String]("hello")) should throw TestFailedException with correct stack depth and message when 'traversable should contain' failed` {
    val xs = collection.mutable.IndexedSeq(collection.mutable.IndexedSeq[String]("hi"), collection.mutable.IndexedSeq[String]("boom!"), collection.mutable.IndexedSeq[String]("hello"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain ("hi")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainGenTraversable[String](xs, "hi")) + ", " + getFirstNotContainGenTraversable[String](xs, "hi") + " did not contain element \"hi\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainGenTraversable[String](xs, "hi") + " did not contain element \"hi\"")
  }
  def `collection.mutable.IndexedSeq(collection.mutable.IndexedSeq[String]("hi"), collection.mutable.IndexedSeq[String]("boom!"), collection.mutable.IndexedSeq[String]("hello")) should throw TestFailedException with correct stack depth and message when 'traversable should not contain' failed` {
    val xs = collection.mutable.IndexedSeq(collection.mutable.IndexedSeq[String]("hi"), collection.mutable.IndexedSeq[String]("boom!"), collection.mutable.IndexedSeq[String]("hello"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain "hi"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainGenTraversable[String](xs, "hi")) + ", " + getFirstContainGenTraversable[String](xs, "hi") + " contained element \"hi\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainGenTraversable[String](xs, "hi") + " contained element \"hi\"")
  }
  def `collection.mutable.Set(collection.mutable.Set[String]("hi").par, collection.mutable.Set[String]("boom!").par, collection.mutable.Set[String]("hello").par).par should throw TestFailedException with correct stack depth and message when 'traversable should have size' failed` {
    val xs = collection.mutable.Set(collection.mutable.Set[String]("hi").par, collection.mutable.Set[String]("boom!").par, collection.mutable.Set[String]("hello").par).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should have size 0
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeNotEqualGenTraversable[String](xs, 0)) + ", " + getFirstSizeNotEqualGenTraversable[String](xs, 0) + " had size " + getFirstSizeNotEqualGenTraversable[String](xs, 0).size + " instead of expected size 0 (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstSizeNotEqualGenTraversable[String](xs, 0) + " had size " + getFirstSizeNotEqualGenTraversable[String](xs, 0).size + " instead of expected size 0")
  }
  def `collection.mutable.Set(collection.mutable.Set[String]("hi").par, collection.mutable.Set[String]("boom!").par, collection.mutable.Set[String]("hello").par).par should throw TestFailedException with correct stack depth and message when 'traversable should not have size' failed` {
    val xs = collection.mutable.Set(collection.mutable.Set[String]("hi").par, collection.mutable.Set[String]("boom!").par, collection.mutable.Set[String]("hello").par).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not have size (1)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeEqualGenTraversable[String](xs, 1)) + ", " + getFirstSizeEqualGenTraversable[String](xs, 1) + " had size 1 (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstSizeEqualGenTraversable[String](xs, 1) + " had size 1")
  }
  def `collection.mutable.Set(collection.mutable.Set[String]("hi").par, collection.mutable.Set[String]("boom!").par, collection.mutable.Set[String]("hello").par).par should throw TestFailedException with correct stack depth and message when 'traversable should contain' failed` {
    val xs = collection.mutable.Set(collection.mutable.Set[String]("hi").par, collection.mutable.Set[String]("boom!").par, collection.mutable.Set[String]("hello").par).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain ("hi")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainGenTraversable[String](xs, "hi")) + ", " + getFirstNotContainGenTraversable[String](xs, "hi") + " did not contain element \"hi\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainGenTraversable[String](xs, "hi") + " did not contain element \"hi\"")
  }
  def `collection.mutable.Set(collection.mutable.Set[String]("hi").par, collection.mutable.Set[String]("boom!").par, collection.mutable.Set[String]("hello").par).par should throw TestFailedException with correct stack depth and message when 'traversable should not contain' failed` {
    val xs = collection.mutable.Set(collection.mutable.Set[String]("hi").par, collection.mutable.Set[String]("boom!").par, collection.mutable.Set[String]("hello").par).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain "hi"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainGenTraversable[String](xs, "hi")) + ", " + getFirstContainGenTraversable[String](xs, "hi") + " contained element \"hi\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainGenTraversable[String](xs, "hi") + " contained element \"hi\"")
  }
  def `(new collection.mutable.ListBuffer() ++ List((new collection.mutable.ListBuffer[String]() ++ List[String]("hi")).par, (new collection.mutable.ListBuffer[String]() ++ List[String]("boom!")).par, (new collection.mutable.ListBuffer[String]() ++ List[String]("hello")).par)).par should throw TestFailedException with correct stack depth and message when 'traversable should have size' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List((new collection.mutable.ListBuffer[String]() ++ List[String]("hi")).par, (new collection.mutable.ListBuffer[String]() ++ List[String]("boom!")).par, (new collection.mutable.ListBuffer[String]() ++ List[String]("hello")).par)).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should have size 0
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeNotEqualGenTraversable[String](xs, 0)) + ", " + getFirstSizeNotEqualGenTraversable[String](xs, 0) + " had size " + getFirstSizeNotEqualGenTraversable[String](xs, 0).size + " instead of expected size 0 (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstSizeNotEqualGenTraversable[String](xs, 0) + " had size " + getFirstSizeNotEqualGenTraversable[String](xs, 0).size + " instead of expected size 0")
  }
  def `(new collection.mutable.ListBuffer() ++ List((new collection.mutable.ListBuffer[String]() ++ List[String]("hi")).par, (new collection.mutable.ListBuffer[String]() ++ List[String]("boom!")).par, (new collection.mutable.ListBuffer[String]() ++ List[String]("hello")).par)).par should throw TestFailedException with correct stack depth and message when 'traversable should not have size' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List((new collection.mutable.ListBuffer[String]() ++ List[String]("hi")).par, (new collection.mutable.ListBuffer[String]() ++ List[String]("boom!")).par, (new collection.mutable.ListBuffer[String]() ++ List[String]("hello")).par)).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not have size (1)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeEqualGenTraversable[String](xs, 1)) + ", " + getFirstSizeEqualGenTraversable[String](xs, 1) + " had size 1 (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstSizeEqualGenTraversable[String](xs, 1) + " had size 1")
  }
  def `(new collection.mutable.ListBuffer() ++ List((new collection.mutable.ListBuffer[String]() ++ List[String]("hi")).par, (new collection.mutable.ListBuffer[String]() ++ List[String]("boom!")).par, (new collection.mutable.ListBuffer[String]() ++ List[String]("hello")).par)).par should throw TestFailedException with correct stack depth and message when 'traversable should have length' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List((new collection.mutable.ListBuffer[String]() ++ List[String]("hi")).par, (new collection.mutable.ListBuffer[String]() ++ List[String]("boom!")).par, (new collection.mutable.ListBuffer[String]() ++ List[String]("hello")).par)).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should have length 0
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeNotEqualGenTraversable[String](xs, 0)) + ", " + getFirstSizeNotEqualGenTraversable[String](xs, 0) + " had length " + getFirstSizeNotEqualGenTraversable[String](xs, 0).size + " instead of expected length 0 (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstSizeNotEqualGenTraversable[String](xs, 0) + " had length " + getFirstSizeNotEqualGenTraversable[String](xs, 0).size + " instead of expected length 0")
  }
  def `(new collection.mutable.ListBuffer() ++ List((new collection.mutable.ListBuffer[String]() ++ List[String]("hi")).par, (new collection.mutable.ListBuffer[String]() ++ List[String]("boom!")).par, (new collection.mutable.ListBuffer[String]() ++ List[String]("hello")).par)).par should throw TestFailedException with correct stack depth and message when 'traversable should not have length' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List((new collection.mutable.ListBuffer[String]() ++ List[String]("hi")).par, (new collection.mutable.ListBuffer[String]() ++ List[String]("boom!")).par, (new collection.mutable.ListBuffer[String]() ++ List[String]("hello")).par)).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not have length (1)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeEqualGenTraversable[String](xs, 1)) + ", " + getFirstSizeEqualGenTraversable[String](xs, 1) + " had length 1 (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstSizeEqualGenTraversable[String](xs, 1) + " had length 1")
  }
  def `(new collection.mutable.ListBuffer() ++ List((new collection.mutable.ListBuffer[String]() ++ List[String]("hi")).par, (new collection.mutable.ListBuffer[String]() ++ List[String]("boom!")).par, (new collection.mutable.ListBuffer[String]() ++ List[String]("hello")).par)).par should throw TestFailedException with correct stack depth and message when 'traversable should contain' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List((new collection.mutable.ListBuffer[String]() ++ List[String]("hi")).par, (new collection.mutable.ListBuffer[String]() ++ List[String]("boom!")).par, (new collection.mutable.ListBuffer[String]() ++ List[String]("hello")).par)).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain ("hi")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainGenTraversable[String](xs, "hi")) + ", " + getFirstNotContainGenTraversable[String](xs, "hi") + " did not contain element \"hi\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainGenTraversable[String](xs, "hi") + " did not contain element \"hi\"")
  }
  def `(new collection.mutable.ListBuffer() ++ List((new collection.mutable.ListBuffer[String]() ++ List[String]("hi")).par, (new collection.mutable.ListBuffer[String]() ++ List[String]("boom!")).par, (new collection.mutable.ListBuffer[String]() ++ List[String]("hello")).par)).par should throw TestFailedException with correct stack depth and message when 'traversable should not contain' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List((new collection.mutable.ListBuffer[String]() ++ List[String]("hi")).par, (new collection.mutable.ListBuffer[String]() ++ List[String]("boom!")).par, (new collection.mutable.ListBuffer[String]() ++ List[String]("hello")).par)).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain "hi"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainGenTraversable[String](xs, "hi")) + ", " + getFirstContainGenTraversable[String](xs, "hi") + " contained element \"hi\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainGenTraversable[String](xs, "hi") + " contained element \"hi\"")
  }
  def `collection.mutable.Seq(collection.mutable.Seq[String]("hi").par, collection.mutable.Seq[String]("boom!").par, collection.mutable.Seq[String]("hello").par).par should throw TestFailedException with correct stack depth and message when 'traversable should have size' failed` {
    val xs = collection.mutable.Seq(collection.mutable.Seq[String]("hi").par, collection.mutable.Seq[String]("boom!").par, collection.mutable.Seq[String]("hello").par).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should have size 0
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeNotEqualGenTraversable[String](xs, 0)) + ", " + getFirstSizeNotEqualGenTraversable[String](xs, 0) + " had size " + getFirstSizeNotEqualGenTraversable[String](xs, 0).size + " instead of expected size 0 (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstSizeNotEqualGenTraversable[String](xs, 0) + " had size " + getFirstSizeNotEqualGenTraversable[String](xs, 0).size + " instead of expected size 0")
  }
  def `collection.mutable.Seq(collection.mutable.Seq[String]("hi").par, collection.mutable.Seq[String]("boom!").par, collection.mutable.Seq[String]("hello").par).par should throw TestFailedException with correct stack depth and message when 'traversable should not have size' failed` {
    val xs = collection.mutable.Seq(collection.mutable.Seq[String]("hi").par, collection.mutable.Seq[String]("boom!").par, collection.mutable.Seq[String]("hello").par).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not have size (1)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeEqualGenTraversable[String](xs, 1)) + ", " + getFirstSizeEqualGenTraversable[String](xs, 1) + " had size 1 (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstSizeEqualGenTraversable[String](xs, 1) + " had size 1")
  }
  def `collection.mutable.Seq(collection.mutable.Seq[String]("hi").par, collection.mutable.Seq[String]("boom!").par, collection.mutable.Seq[String]("hello").par).par should throw TestFailedException with correct stack depth and message when 'traversable should have length' failed` {
    val xs = collection.mutable.Seq(collection.mutable.Seq[String]("hi").par, collection.mutable.Seq[String]("boom!").par, collection.mutable.Seq[String]("hello").par).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should have length 0
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeNotEqualGenTraversable[String](xs, 0)) + ", " + getFirstSizeNotEqualGenTraversable[String](xs, 0) + " had length " + getFirstSizeNotEqualGenTraversable[String](xs, 0).size + " instead of expected length 0 (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstSizeNotEqualGenTraversable[String](xs, 0) + " had length " + getFirstSizeNotEqualGenTraversable[String](xs, 0).size + " instead of expected length 0")
  }
  def `collection.mutable.Seq(collection.mutable.Seq[String]("hi").par, collection.mutable.Seq[String]("boom!").par, collection.mutable.Seq[String]("hello").par).par should throw TestFailedException with correct stack depth and message when 'traversable should not have length' failed` {
    val xs = collection.mutable.Seq(collection.mutable.Seq[String]("hi").par, collection.mutable.Seq[String]("boom!").par, collection.mutable.Seq[String]("hello").par).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not have length (1)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeEqualGenTraversable[String](xs, 1)) + ", " + getFirstSizeEqualGenTraversable[String](xs, 1) + " had length 1 (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstSizeEqualGenTraversable[String](xs, 1) + " had length 1")
  }
  def `collection.mutable.Seq(collection.mutable.Seq[String]("hi").par, collection.mutable.Seq[String]("boom!").par, collection.mutable.Seq[String]("hello").par).par should throw TestFailedException with correct stack depth and message when 'traversable should contain' failed` {
    val xs = collection.mutable.Seq(collection.mutable.Seq[String]("hi").par, collection.mutable.Seq[String]("boom!").par, collection.mutable.Seq[String]("hello").par).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain ("hi")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainGenTraversable[String](xs, "hi")) + ", " + getFirstNotContainGenTraversable[String](xs, "hi") + " did not contain element \"hi\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainGenTraversable[String](xs, "hi") + " did not contain element \"hi\"")
  }
  def `collection.mutable.Seq(collection.mutable.Seq[String]("hi").par, collection.mutable.Seq[String]("boom!").par, collection.mutable.Seq[String]("hello").par).par should throw TestFailedException with correct stack depth and message when 'traversable should not contain' failed` {
    val xs = collection.mutable.Seq(collection.mutable.Seq[String]("hi").par, collection.mutable.Seq[String]("boom!").par, collection.mutable.Seq[String]("hello").par).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain "hi"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainGenTraversable[String](xs, "hi")) + ", " + getFirstContainGenTraversable[String](xs, "hi") + " contained element \"hi\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainGenTraversable[String](xs, "hi") + " contained element \"hi\"")
  }
  def `collection.mutable.IndexedSeq(collection.mutable.IndexedSeq[String]("hi").par, collection.mutable.IndexedSeq[String]("boom!").par, collection.mutable.IndexedSeq[String]("hello").par).par should throw TestFailedException with correct stack depth and message when 'traversable should have size' failed` {
    val xs = collection.mutable.IndexedSeq(collection.mutable.IndexedSeq[String]("hi").par, collection.mutable.IndexedSeq[String]("boom!").par, collection.mutable.IndexedSeq[String]("hello").par).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should have size 0
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeNotEqualGenTraversable[String](xs, 0)) + ", " + getFirstSizeNotEqualGenTraversable[String](xs, 0) + " had size " + getFirstSizeNotEqualGenTraversable[String](xs, 0).size + " instead of expected size 0 (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstSizeNotEqualGenTraversable[String](xs, 0) + " had size " + getFirstSizeNotEqualGenTraversable[String](xs, 0).size + " instead of expected size 0")
  }
  def `collection.mutable.IndexedSeq(collection.mutable.IndexedSeq[String]("hi").par, collection.mutable.IndexedSeq[String]("boom!").par, collection.mutable.IndexedSeq[String]("hello").par).par should throw TestFailedException with correct stack depth and message when 'traversable should not have size' failed` {
    val xs = collection.mutable.IndexedSeq(collection.mutable.IndexedSeq[String]("hi").par, collection.mutable.IndexedSeq[String]("boom!").par, collection.mutable.IndexedSeq[String]("hello").par).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not have size (1)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeEqualGenTraversable[String](xs, 1)) + ", " + getFirstSizeEqualGenTraversable[String](xs, 1) + " had size 1 (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstSizeEqualGenTraversable[String](xs, 1) + " had size 1")
  }
  def `collection.mutable.IndexedSeq(collection.mutable.IndexedSeq[String]("hi").par, collection.mutable.IndexedSeq[String]("boom!").par, collection.mutable.IndexedSeq[String]("hello").par).par should throw TestFailedException with correct stack depth and message when 'traversable should have length' failed` {
    val xs = collection.mutable.IndexedSeq(collection.mutable.IndexedSeq[String]("hi").par, collection.mutable.IndexedSeq[String]("boom!").par, collection.mutable.IndexedSeq[String]("hello").par).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should have length 0
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeNotEqualGenTraversable[String](xs, 0)) + ", " + getFirstSizeNotEqualGenTraversable[String](xs, 0) + " had length " + getFirstSizeNotEqualGenTraversable[String](xs, 0).size + " instead of expected length 0 (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstSizeNotEqualGenTraversable[String](xs, 0) + " had length " + getFirstSizeNotEqualGenTraversable[String](xs, 0).size + " instead of expected length 0")
  }
  def `collection.mutable.IndexedSeq(collection.mutable.IndexedSeq[String]("hi").par, collection.mutable.IndexedSeq[String]("boom!").par, collection.mutable.IndexedSeq[String]("hello").par).par should throw TestFailedException with correct stack depth and message when 'traversable should not have length' failed` {
    val xs = collection.mutable.IndexedSeq(collection.mutable.IndexedSeq[String]("hi").par, collection.mutable.IndexedSeq[String]("boom!").par, collection.mutable.IndexedSeq[String]("hello").par).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not have length (1)
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstSizeEqualGenTraversable[String](xs, 1)) + ", " + getFirstSizeEqualGenTraversable[String](xs, 1) + " had length 1 (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstSizeEqualGenTraversable[String](xs, 1) + " had length 1")
  }
  def `collection.mutable.IndexedSeq(collection.mutable.IndexedSeq[String]("hi").par, collection.mutable.IndexedSeq[String]("boom!").par, collection.mutable.IndexedSeq[String]("hello").par).par should throw TestFailedException with correct stack depth and message when 'traversable should contain' failed` {
    val xs = collection.mutable.IndexedSeq(collection.mutable.IndexedSeq[String]("hi").par, collection.mutable.IndexedSeq[String]("boom!").par, collection.mutable.IndexedSeq[String]("hello").par).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain ("hi")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainGenTraversable[String](xs, "hi")) + ", " + getFirstNotContainGenTraversable[String](xs, "hi") + " did not contain element \"hi\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainGenTraversable[String](xs, "hi") + " did not contain element \"hi\"")
  }
  def `collection.mutable.IndexedSeq(collection.mutable.IndexedSeq[String]("hi").par, collection.mutable.IndexedSeq[String]("boom!").par, collection.mutable.IndexedSeq[String]("hello").par).par should throw TestFailedException with correct stack depth and message when 'traversable should not contain' failed` {
    val xs = collection.mutable.IndexedSeq(collection.mutable.IndexedSeq[String]("hi").par, collection.mutable.IndexedSeq[String]("boom!").par, collection.mutable.IndexedSeq[String]("hello").par).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain "hi"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainGenTraversable[String](xs, "hi")) + ", " + getFirstContainGenTraversable[String](xs, "hi") + " contained element \"hi\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainGenTraversable[String](xs, "hi") + " contained element \"hi\"")
  }
  def `Set(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = Set(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `Set(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = Set(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
  def `Set(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = Set(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainValue[String, String](xs, "two")) + ", " + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\"")
  }
  def `Set(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = Set(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainValue[String, String](xs, "two")) + ", " + getFirstContainValue[String, String](xs, "two") + " contained value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainValue[String, String](xs, "two") + " contained value \"two\"")
  }
  def `List(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = List(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `List(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = List(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
  def `List(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = List(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainValue[String, String](xs, "two")) + ", " + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\"")
  }
  def `List(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = List(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainValue[String, String](xs, "two")) + ", " + getFirstContainValue[String, String](xs, "two") + " contained value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainValue[String, String](xs, "two") + " contained value \"two\"")
  }
  def `Seq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = Seq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `Seq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = Seq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
  def `Seq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = Seq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainValue[String, String](xs, "two")) + ", " + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\"")
  }
  def `Seq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = Seq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainValue[String, String](xs, "two")) + ", " + getFirstContainValue[String, String](xs, "two") + " contained value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainValue[String, String](xs, "two") + " contained value \"two\"")
  }
  def `Array(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = Array(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + arrayToString(xs), "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `Array(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = Array(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + arrayToString(xs), "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
  def `Array(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = Array(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainValue[String, String](xs, "two")) + ", " + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + arrayToString(xs), "" + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\"")
  }
  def `Array(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = Array(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainValue[String, String](xs, "two")) + ", " + getFirstContainValue[String, String](xs, "two") + " contained value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + arrayToString(xs), "" + getFirstContainValue[String, String](xs, "two") + " contained value \"two\"")
  }
  def `IndexedSeq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = IndexedSeq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `IndexedSeq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = IndexedSeq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
  def `IndexedSeq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = IndexedSeq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainValue[String, String](xs, "two")) + ", " + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\"")
  }
  def `IndexedSeq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = IndexedSeq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainValue[String, String](xs, "two")) + ", " + getFirstContainValue[String, String](xs, "two") + " contained value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainValue[String, String](xs, "two") + " contained value \"two\"")
  }
  def `Vector(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = Vector(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `Vector(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = Vector(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
  def `Vector(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = Vector(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainValue[String, String](xs, "two")) + ", " + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\"")
  }
  def `Vector(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = Vector(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainValue[String, String](xs, "two")) + ", " + getFirstContainValue[String, String](xs, "two") + " contained value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainValue[String, String](xs, "two") + " contained value \"two\"")
  }
  def `Set(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = Set(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `Set(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = Set(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
  def `Set(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = Set(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainValue[String, String](xs, "two")) + ", " + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\"")
  }
  def `Set(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = Set(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainValue[String, String](xs, "two")) + ", " + getFirstContainValue[String, String](xs, "two") + " contained value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainValue[String, String](xs, "two") + " contained value \"two\"")
  }
  def `List(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = List(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `List(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = List(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
  def `List(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = List(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainValue[String, String](xs, "two")) + ", " + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\"")
  }
  def `List(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = List(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainValue[String, String](xs, "two")) + ", " + getFirstContainValue[String, String](xs, "two") + " contained value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainValue[String, String](xs, "two") + " contained value \"two\"")
  }
  def `Seq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = Seq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `Seq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = Seq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
  def `Seq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = Seq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainValue[String, String](xs, "two")) + ", " + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\"")
  }
  def `Seq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = Seq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainValue[String, String](xs, "two")) + ", " + getFirstContainValue[String, String](xs, "two") + " contained value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainValue[String, String](xs, "two") + " contained value \"two\"")
  }
  def `IndexedSeq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = IndexedSeq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `IndexedSeq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = IndexedSeq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
  def `IndexedSeq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = IndexedSeq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainValue[String, String](xs, "two")) + ", " + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\"")
  }
  def `IndexedSeq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = IndexedSeq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainValue[String, String](xs, "two")) + ", " + getFirstContainValue[String, String](xs, "two") + " contained value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainValue[String, String](xs, "two") + " contained value \"two\"")
  }
  def `collection.mutable.Set(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = collection.mutable.Set(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `collection.mutable.Set(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = collection.mutable.Set(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
  def `collection.mutable.Set(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = collection.mutable.Set(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainValue[String, String](xs, "two")) + ", " + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\"")
  }
  def `collection.mutable.Set(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = collection.mutable.Set(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainValue[String, String](xs, "two")) + ", " + getFirstContainValue[String, String](xs, "two") + " contained value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainValue[String, String](xs, "two") + " contained value \"two\"")
  }
  def `new collection.mutable.ListBuffer() ++ List(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `new collection.mutable.ListBuffer() ++ List(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
  def `new collection.mutable.ListBuffer() ++ List(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainValue[String, String](xs, "two")) + ", " + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\"")
  }
  def `new collection.mutable.ListBuffer() ++ List(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainValue[String, String](xs, "two")) + ", " + getFirstContainValue[String, String](xs, "two") + " contained value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainValue[String, String](xs, "two") + " contained value \"two\"")
  }
  def `collection.mutable.Seq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = collection.mutable.Seq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `collection.mutable.Seq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = collection.mutable.Seq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
  def `collection.mutable.Seq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = collection.mutable.Seq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainValue[String, String](xs, "two")) + ", " + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\"")
  }
  def `collection.mutable.Seq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = collection.mutable.Seq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainValue[String, String](xs, "two")) + ", " + getFirstContainValue[String, String](xs, "two") + " contained value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainValue[String, String](xs, "two") + " contained value \"two\"")
  }
  def `collection.mutable.IndexedSeq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = collection.mutable.IndexedSeq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `collection.mutable.IndexedSeq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = collection.mutable.IndexedSeq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
  def `collection.mutable.IndexedSeq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = collection.mutable.IndexedSeq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainValue[String, String](xs, "two")) + ", " + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\"")
  }
  def `collection.mutable.IndexedSeq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = collection.mutable.IndexedSeq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainValue[String, String](xs, "two")) + ", " + getFirstContainValue[String, String](xs, "two") + " contained value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainValue[String, String](xs, "two") + " contained value \"two\"")
  }
  def `collection.mutable.Set(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = collection.mutable.Set(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `collection.mutable.Set(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = collection.mutable.Set(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
  def `collection.mutable.Set(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = collection.mutable.Set(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainValue[String, String](xs, "two")) + ", " + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\"")
  }
  def `collection.mutable.Set(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = collection.mutable.Set(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainValue[String, String](xs, "two")) + ", " + getFirstContainValue[String, String](xs, "two") + " contained value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainValue[String, String](xs, "two") + " contained value \"two\"")
  }
  def `(new collection.mutable.ListBuffer() ++ List(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"))).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"))).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `(new collection.mutable.ListBuffer() ++ List(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"))).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"))).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
  def `(new collection.mutable.ListBuffer() ++ List(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"))).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"))).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainValue[String, String](xs, "two")) + ", " + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\"")
  }
  def `(new collection.mutable.ListBuffer() ++ List(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"))).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"))).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainValue[String, String](xs, "two")) + ", " + getFirstContainValue[String, String](xs, "two") + " contained value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainValue[String, String](xs, "two") + " contained value \"two\"")
  }
  def `collection.mutable.Seq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = collection.mutable.Seq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `collection.mutable.Seq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = collection.mutable.Seq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
  def `collection.mutable.Seq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = collection.mutable.Seq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainValue[String, String](xs, "two")) + ", " + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\"")
  }
  def `collection.mutable.Seq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = collection.mutable.Seq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainValue[String, String](xs, "two")) + ", " + getFirstContainValue[String, String](xs, "two") + " contained value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainValue[String, String](xs, "two") + " contained value \"two\"")
  }
  def `collection.mutable.IndexedSeq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = collection.mutable.IndexedSeq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `collection.mutable.IndexedSeq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = collection.mutable.IndexedSeq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
  def `collection.mutable.IndexedSeq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = collection.mutable.IndexedSeq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainValue[String, String](xs, "two")) + ", " + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\"")
  }
  def `collection.mutable.IndexedSeq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = collection.mutable.IndexedSeq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainValue[String, String](xs, "two")) + ", " + getFirstContainValue[String, String](xs, "two") + " contained value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainValue[String, String](xs, "two") + " contained value \"two\"")
  }
  def `Set(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = Set(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `Set(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = Set(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
  def `Set(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = Set(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainValue[String, String](xs, "two")) + ", " + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\"")
  }
  def `Set(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = Set(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainValue[String, String](xs, "two")) + ", " + getFirstContainValue[String, String](xs, "two") + " contained value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainValue[String, String](xs, "two") + " contained value \"two\"")
  }
  def `List(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = List(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `List(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = List(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
  def `List(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = List(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainValue[String, String](xs, "two")) + ", " + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\"")
  }
  def `List(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = List(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainValue[String, String](xs, "two")) + ", " + getFirstContainValue[String, String](xs, "two") + " contained value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainValue[String, String](xs, "two") + " contained value \"two\"")
  }
  def `Seq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = Seq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `Seq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = Seq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
  def `Seq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = Seq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainValue[String, String](xs, "two")) + ", " + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\"")
  }
  def `Seq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = Seq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainValue[String, String](xs, "two")) + ", " + getFirstContainValue[String, String](xs, "two") + " contained value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainValue[String, String](xs, "two") + " contained value \"two\"")
  }
  def `Array(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = Array(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + arrayToString(xs), "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `Array(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = Array(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + arrayToString(xs), "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
  def `Array(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = Array(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainValue[String, String](xs, "two")) + ", " + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + arrayToString(xs), "" + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\"")
  }
  def `Array(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = Array(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainValue[String, String](xs, "two")) + ", " + getFirstContainValue[String, String](xs, "two") + " contained value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + arrayToString(xs), "" + getFirstContainValue[String, String](xs, "two") + " contained value \"two\"")
  }
  def `IndexedSeq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = IndexedSeq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `IndexedSeq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = IndexedSeq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
  def `IndexedSeq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = IndexedSeq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainValue[String, String](xs, "two")) + ", " + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\"")
  }
  def `IndexedSeq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = IndexedSeq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainValue[String, String](xs, "two")) + ", " + getFirstContainValue[String, String](xs, "two") + " contained value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainValue[String, String](xs, "two") + " contained value \"two\"")
  }
  def `Vector(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = Vector(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `Vector(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = Vector(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
  def `Vector(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = Vector(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainValue[String, String](xs, "two")) + ", " + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\"")
  }
  def `Vector(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = Vector(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainValue[String, String](xs, "two")) + ", " + getFirstContainValue[String, String](xs, "two") + " contained value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainValue[String, String](xs, "two") + " contained value \"two\"")
  }
  def `Set(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = Set(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `Set(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = Set(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
  def `Set(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = Set(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainValue[String, String](xs, "two")) + ", " + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\"")
  }
  def `Set(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = Set(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainValue[String, String](xs, "two")) + ", " + getFirstContainValue[String, String](xs, "two") + " contained value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainValue[String, String](xs, "two") + " contained value \"two\"")
  }
  def `List(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = List(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `List(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = List(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
  def `List(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = List(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainValue[String, String](xs, "two")) + ", " + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\"")
  }
  def `List(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = List(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainValue[String, String](xs, "two")) + ", " + getFirstContainValue[String, String](xs, "two") + " contained value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainValue[String, String](xs, "two") + " contained value \"two\"")
  }
  def `Seq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = Seq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `Seq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = Seq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
  def `Seq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = Seq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainValue[String, String](xs, "two")) + ", " + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\"")
  }
  def `Seq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = Seq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainValue[String, String](xs, "two")) + ", " + getFirstContainValue[String, String](xs, "two") + " contained value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainValue[String, String](xs, "two") + " contained value \"two\"")
  }
  def `IndexedSeq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = IndexedSeq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `IndexedSeq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = IndexedSeq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
  def `IndexedSeq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = IndexedSeq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainValue[String, String](xs, "two")) + ", " + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\"")
  }
  def `IndexedSeq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = IndexedSeq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainValue[String, String](xs, "two")) + ", " + getFirstContainValue[String, String](xs, "two") + " contained value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainValue[String, String](xs, "two") + " contained value \"two\"")
  }
  def `collection.mutable.Set(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = collection.mutable.Set(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `collection.mutable.Set(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = collection.mutable.Set(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
  def `collection.mutable.Set(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = collection.mutable.Set(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainValue[String, String](xs, "two")) + ", " + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\"")
  }
  def `collection.mutable.Set(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = collection.mutable.Set(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainValue[String, String](xs, "two")) + ", " + getFirstContainValue[String, String](xs, "two") + " contained value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainValue[String, String](xs, "two") + " contained value \"two\"")
  }
  def `new collection.mutable.ListBuffer() ++ List(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `new collection.mutable.ListBuffer() ++ List(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
  def `new collection.mutable.ListBuffer() ++ List(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainValue[String, String](xs, "two")) + ", " + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\"")
  }
  def `new collection.mutable.ListBuffer() ++ List(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainValue[String, String](xs, "two")) + ", " + getFirstContainValue[String, String](xs, "two") + " contained value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainValue[String, String](xs, "two") + " contained value \"two\"")
  }
  def `collection.mutable.Seq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = collection.mutable.Seq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `collection.mutable.Seq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = collection.mutable.Seq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
  def `collection.mutable.Seq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = collection.mutable.Seq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainValue[String, String](xs, "two")) + ", " + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\"")
  }
  def `collection.mutable.Seq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = collection.mutable.Seq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainValue[String, String](xs, "two")) + ", " + getFirstContainValue[String, String](xs, "two") + " contained value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainValue[String, String](xs, "two") + " contained value \"two\"")
  }
  def `collection.mutable.IndexedSeq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = collection.mutable.IndexedSeq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `collection.mutable.IndexedSeq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = collection.mutable.IndexedSeq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
  def `collection.mutable.IndexedSeq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = collection.mutable.IndexedSeq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainValue[String, String](xs, "two")) + ", " + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\"")
  }
  def `collection.mutable.IndexedSeq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = collection.mutable.IndexedSeq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainValue[String, String](xs, "two")) + ", " + getFirstContainValue[String, String](xs, "two") + " contained value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainValue[String, String](xs, "two") + " contained value \"two\"")
  }
  def `collection.mutable.Set(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = collection.mutable.Set(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `collection.mutable.Set(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = collection.mutable.Set(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
  def `collection.mutable.Set(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = collection.mutable.Set(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainValue[String, String](xs, "two")) + ", " + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\"")
  }
  def `collection.mutable.Set(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = collection.mutable.Set(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainValue[String, String](xs, "two")) + ", " + getFirstContainValue[String, String](xs, "two") + " contained value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainValue[String, String](xs, "two") + " contained value \"two\"")
  }
  def `(new collection.mutable.ListBuffer() ++ List(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"))).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"))).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `(new collection.mutable.ListBuffer() ++ List(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"))).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"))).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
  def `(new collection.mutable.ListBuffer() ++ List(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"))).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"))).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainValue[String, String](xs, "two")) + ", " + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\"")
  }
  def `(new collection.mutable.ListBuffer() ++ List(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"))).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"))).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainValue[String, String](xs, "two")) + ", " + getFirstContainValue[String, String](xs, "two") + " contained value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainValue[String, String](xs, "two") + " contained value \"two\"")
  }
  def `collection.mutable.Seq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = collection.mutable.Seq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `collection.mutable.Seq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = collection.mutable.Seq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
  def `collection.mutable.Seq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = collection.mutable.Seq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainValue[String, String](xs, "two")) + ", " + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\"")
  }
  def `collection.mutable.Seq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = collection.mutable.Seq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainValue[String, String](xs, "two")) + ", " + getFirstContainValue[String, String](xs, "two") + " contained value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainValue[String, String](xs, "two") + " contained value \"two\"")
  }
  def `collection.mutable.IndexedSeq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = collection.mutable.IndexedSeq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `collection.mutable.IndexedSeq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = collection.mutable.IndexedSeq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
  def `collection.mutable.IndexedSeq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = collection.mutable.IndexedSeq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainValue[String, String](xs, "two")) + ", " + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\"")
  }
  def `collection.mutable.IndexedSeq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = collection.mutable.IndexedSeq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainValue[String, String](xs, "two")) + ", " + getFirstContainValue[String, String](xs, "two") + " contained value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainValue[String, String](xs, "two") + " contained value \"two\"")
  }
  def `Set(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = Set(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `Set(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = Set(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
  def `Set(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = Set(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainValue[String, String](xs, "two")) + ", " + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\"")
  }
  def `Set(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = Set(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainValue[String, String](xs, "two")) + ", " + getFirstContainValue[String, String](xs, "two") + " contained value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainValue[String, String](xs, "two") + " contained value \"two\"")
  }
  def `List(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = List(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `List(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = List(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
  def `List(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = List(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainValue[String, String](xs, "two")) + ", " + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\"")
  }
  def `List(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = List(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainValue[String, String](xs, "two")) + ", " + getFirstContainValue[String, String](xs, "two") + " contained value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainValue[String, String](xs, "two") + " contained value \"two\"")
  }
  def `Seq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = Seq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `Seq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = Seq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
  def `Seq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = Seq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainValue[String, String](xs, "two")) + ", " + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\"")
  }
  def `Seq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = Seq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainValue[String, String](xs, "two")) + ", " + getFirstContainValue[String, String](xs, "two") + " contained value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainValue[String, String](xs, "two") + " contained value \"two\"")
  }
  def `Array(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = Array(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + arrayToString(xs), "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `Array(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = Array(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + arrayToString(xs), "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
  def `Array(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = Array(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainValue[String, String](xs, "two")) + ", " + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + arrayToString(xs), "" + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\"")
  }
  def `Array(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = Array(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainValue[String, String](xs, "two")) + ", " + getFirstContainValue[String, String](xs, "two") + " contained value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + arrayToString(xs), "" + getFirstContainValue[String, String](xs, "two") + " contained value \"two\"")
  }
  def `IndexedSeq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = IndexedSeq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `IndexedSeq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = IndexedSeq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
  def `IndexedSeq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = IndexedSeq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainValue[String, String](xs, "two")) + ", " + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\"")
  }
  def `IndexedSeq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = IndexedSeq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainValue[String, String](xs, "two")) + ", " + getFirstContainValue[String, String](xs, "two") + " contained value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainValue[String, String](xs, "two") + " contained value \"two\"")
  }
  def `Vector(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = Vector(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `Vector(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = Vector(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
  def `Vector(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = Vector(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainValue[String, String](xs, "two")) + ", " + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\"")
  }
  def `Vector(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = Vector(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainValue[String, String](xs, "two")) + ", " + getFirstContainValue[String, String](xs, "two") + " contained value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainValue[String, String](xs, "two") + " contained value \"two\"")
  }
  def `Set(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = Set(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `Set(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = Set(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
  def `Set(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = Set(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainValue[String, String](xs, "two")) + ", " + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\"")
  }
  def `Set(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = Set(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainValue[String, String](xs, "two")) + ", " + getFirstContainValue[String, String](xs, "two") + " contained value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainValue[String, String](xs, "two") + " contained value \"two\"")
  }
  def `List(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = List(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `List(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = List(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
  def `List(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = List(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainValue[String, String](xs, "two")) + ", " + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\"")
  }
  def `List(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = List(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainValue[String, String](xs, "two")) + ", " + getFirstContainValue[String, String](xs, "two") + " contained value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainValue[String, String](xs, "two") + " contained value \"two\"")
  }
  def `Seq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = Seq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `Seq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = Seq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
  def `Seq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = Seq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainValue[String, String](xs, "two")) + ", " + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\"")
  }
  def `Seq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = Seq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainValue[String, String](xs, "two")) + ", " + getFirstContainValue[String, String](xs, "two") + " contained value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainValue[String, String](xs, "two") + " contained value \"two\"")
  }
  def `IndexedSeq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = IndexedSeq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `IndexedSeq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = IndexedSeq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
  def `IndexedSeq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = IndexedSeq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainValue[String, String](xs, "two")) + ", " + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\"")
  }
  def `IndexedSeq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = IndexedSeq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainValue[String, String](xs, "two")) + ", " + getFirstContainValue[String, String](xs, "two") + " contained value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainValue[String, String](xs, "two") + " contained value \"two\"")
  }
  def `collection.mutable.Set(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = collection.mutable.Set(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `collection.mutable.Set(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = collection.mutable.Set(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
  def `collection.mutable.Set(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = collection.mutable.Set(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainValue[String, String](xs, "two")) + ", " + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\"")
  }
  def `collection.mutable.Set(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = collection.mutable.Set(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainValue[String, String](xs, "two")) + ", " + getFirstContainValue[String, String](xs, "two") + " contained value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainValue[String, String](xs, "two") + " contained value \"two\"")
  }
  def `new collection.mutable.ListBuffer() ++ List(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `new collection.mutable.ListBuffer() ++ List(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
  def `new collection.mutable.ListBuffer() ++ List(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainValue[String, String](xs, "two")) + ", " + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\"")
  }
  def `new collection.mutable.ListBuffer() ++ List(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainValue[String, String](xs, "two")) + ", " + getFirstContainValue[String, String](xs, "two") + " contained value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainValue[String, String](xs, "two") + " contained value \"two\"")
  }
  def `collection.mutable.Seq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = collection.mutable.Seq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `collection.mutable.Seq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = collection.mutable.Seq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
  def `collection.mutable.Seq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = collection.mutable.Seq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainValue[String, String](xs, "two")) + ", " + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\"")
  }
  def `collection.mutable.Seq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = collection.mutable.Seq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainValue[String, String](xs, "two")) + ", " + getFirstContainValue[String, String](xs, "two") + " contained value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainValue[String, String](xs, "two") + " contained value \"two\"")
  }
  def `collection.mutable.IndexedSeq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = collection.mutable.IndexedSeq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `collection.mutable.IndexedSeq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = collection.mutable.IndexedSeq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
  def `collection.mutable.IndexedSeq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = collection.mutable.IndexedSeq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainValue[String, String](xs, "two")) + ", " + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\"")
  }
  def `collection.mutable.IndexedSeq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = collection.mutable.IndexedSeq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainValue[String, String](xs, "two")) + ", " + getFirstContainValue[String, String](xs, "two") + " contained value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainValue[String, String](xs, "two") + " contained value \"two\"")
  }
  def `collection.mutable.Set(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = collection.mutable.Set(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `collection.mutable.Set(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = collection.mutable.Set(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
  def `collection.mutable.Set(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = collection.mutable.Set(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainValue[String, String](xs, "two")) + ", " + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\"")
  }
  def `collection.mutable.Set(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = collection.mutable.Set(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainValue[String, String](xs, "two")) + ", " + getFirstContainValue[String, String](xs, "two") + " contained value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainValue[String, String](xs, "two") + " contained value \"two\"")
  }
  def `(new collection.mutable.ListBuffer() ++ List(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `(new collection.mutable.ListBuffer() ++ List(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
  def `(new collection.mutable.ListBuffer() ++ List(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainValue[String, String](xs, "two")) + ", " + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\"")
  }
  def `(new collection.mutable.ListBuffer() ++ List(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainValue[String, String](xs, "two")) + ", " + getFirstContainValue[String, String](xs, "two") + " contained value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainValue[String, String](xs, "two") + " contained value \"two\"")
  }
  def `collection.mutable.Seq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = collection.mutable.Seq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `collection.mutable.Seq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = collection.mutable.Seq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
  def `collection.mutable.Seq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = collection.mutable.Seq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainValue[String, String](xs, "two")) + ", " + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\"")
  }
  def `collection.mutable.Seq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = collection.mutable.Seq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainValue[String, String](xs, "two")) + ", " + getFirstContainValue[String, String](xs, "two") + " contained value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainValue[String, String](xs, "two") + " contained value \"two\"")
  }
  def `collection.mutable.IndexedSeq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = collection.mutable.IndexedSeq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `collection.mutable.IndexedSeq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = collection.mutable.IndexedSeq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
  def `collection.mutable.IndexedSeq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = collection.mutable.IndexedSeq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainValue[String, String](xs, "two")) + ", " + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\"")
  }
  def `collection.mutable.IndexedSeq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = collection.mutable.IndexedSeq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainValue[String, String](xs, "two")) + ", " + getFirstContainValue[String, String](xs, "two") + " contained value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainValue[String, String](xs, "two") + " contained value \"two\"")
  }
  def `Set(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = Set(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `Set(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = Set(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
  def `Set(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = Set(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainValue[String, String](xs, "two")) + ", " + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\"")
  }
  def `Set(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = Set(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainValue[String, String](xs, "two")) + ", " + getFirstContainValue[String, String](xs, "two") + " contained value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainValue[String, String](xs, "two") + " contained value \"two\"")
  }
  def `List(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = List(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `List(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = List(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
  def `List(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = List(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainValue[String, String](xs, "two")) + ", " + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\"")
  }
  def `List(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = List(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainValue[String, String](xs, "two")) + ", " + getFirstContainValue[String, String](xs, "two") + " contained value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainValue[String, String](xs, "two") + " contained value \"two\"")
  }
  def `Seq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = Seq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `Seq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = Seq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
  def `Seq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = Seq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainValue[String, String](xs, "two")) + ", " + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\"")
  }
  def `Seq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = Seq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainValue[String, String](xs, "two")) + ", " + getFirstContainValue[String, String](xs, "two") + " contained value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainValue[String, String](xs, "two") + " contained value \"two\"")
  }
  def `Array(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = Array(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + arrayToString(xs), "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `Array(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = Array(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + arrayToString(xs), "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
  def `Array(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = Array(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainValue[String, String](xs, "two")) + ", " + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + arrayToString(xs), "" + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\"")
  }
  def `Array(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = Array(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainValue[String, String](xs, "two")) + ", " + getFirstContainValue[String, String](xs, "two") + " contained value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + arrayToString(xs), "" + getFirstContainValue[String, String](xs, "two") + " contained value \"two\"")
  }
  def `IndexedSeq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = IndexedSeq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `IndexedSeq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = IndexedSeq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
  def `IndexedSeq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = IndexedSeq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainValue[String, String](xs, "two")) + ", " + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\"")
  }
  def `IndexedSeq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = IndexedSeq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainValue[String, String](xs, "two")) + ", " + getFirstContainValue[String, String](xs, "two") + " contained value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainValue[String, String](xs, "two") + " contained value \"two\"")
  }
  def `Vector(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = Vector(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `Vector(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = Vector(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
  def `Vector(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = Vector(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainValue[String, String](xs, "two")) + ", " + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\"")
  }
  def `Vector(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = Vector(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainValue[String, String](xs, "two")) + ", " + getFirstContainValue[String, String](xs, "two") + " contained value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainValue[String, String](xs, "two") + " contained value \"two\"")
  }
  def `Set(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = Set(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `Set(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = Set(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
  def `Set(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = Set(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainValue[String, String](xs, "two")) + ", " + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\"")
  }
  def `Set(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = Set(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainValue[String, String](xs, "two")) + ", " + getFirstContainValue[String, String](xs, "two") + " contained value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainValue[String, String](xs, "two") + " contained value \"two\"")
  }
  def `List(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = List(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `List(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = List(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
  def `List(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = List(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainValue[String, String](xs, "two")) + ", " + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\"")
  }
  def `List(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = List(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainValue[String, String](xs, "two")) + ", " + getFirstContainValue[String, String](xs, "two") + " contained value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainValue[String, String](xs, "two") + " contained value \"two\"")
  }
  def `Seq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = Seq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `Seq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = Seq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
  def `Seq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = Seq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainValue[String, String](xs, "two")) + ", " + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\"")
  }
  def `Seq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = Seq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainValue[String, String](xs, "two")) + ", " + getFirstContainValue[String, String](xs, "two") + " contained value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainValue[String, String](xs, "two") + " contained value \"two\"")
  }
  def `IndexedSeq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = IndexedSeq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `IndexedSeq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = IndexedSeq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
  def `IndexedSeq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = IndexedSeq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainValue[String, String](xs, "two")) + ", " + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\"")
  }
  def `IndexedSeq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = IndexedSeq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainValue[String, String](xs, "two")) + ", " + getFirstContainValue[String, String](xs, "two") + " contained value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainValue[String, String](xs, "two") + " contained value \"two\"")
  }
  def `collection.mutable.Set(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = collection.mutable.Set(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `collection.mutable.Set(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = collection.mutable.Set(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
  def `collection.mutable.Set(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = collection.mutable.Set(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainValue[String, String](xs, "two")) + ", " + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\"")
  }
  def `collection.mutable.Set(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = collection.mutable.Set(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainValue[String, String](xs, "two")) + ", " + getFirstContainValue[String, String](xs, "two") + " contained value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainValue[String, String](xs, "two") + " contained value \"two\"")
  }
  def `new collection.mutable.ListBuffer() ++ List(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `new collection.mutable.ListBuffer() ++ List(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
  def `new collection.mutable.ListBuffer() ++ List(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainValue[String, String](xs, "two")) + ", " + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\"")
  }
  def `new collection.mutable.ListBuffer() ++ List(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainValue[String, String](xs, "two")) + ", " + getFirstContainValue[String, String](xs, "two") + " contained value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainValue[String, String](xs, "two") + " contained value \"two\"")
  }
  def `collection.mutable.Seq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = collection.mutable.Seq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `collection.mutable.Seq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = collection.mutable.Seq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
  def `collection.mutable.Seq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = collection.mutable.Seq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainValue[String, String](xs, "two")) + ", " + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\"")
  }
  def `collection.mutable.Seq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = collection.mutable.Seq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainValue[String, String](xs, "two")) + ", " + getFirstContainValue[String, String](xs, "two") + " contained value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainValue[String, String](xs, "two") + " contained value \"two\"")
  }
  def `collection.mutable.IndexedSeq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = collection.mutable.IndexedSeq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `collection.mutable.IndexedSeq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = collection.mutable.IndexedSeq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
  def `collection.mutable.IndexedSeq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = collection.mutable.IndexedSeq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainValue[String, String](xs, "two")) + ", " + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\"")
  }
  def `collection.mutable.IndexedSeq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = collection.mutable.IndexedSeq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainValue[String, String](xs, "two")) + ", " + getFirstContainValue[String, String](xs, "two") + " contained value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainValue[String, String](xs, "two") + " contained value \"two\"")
  }
  def `collection.mutable.Set(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = collection.mutable.Set(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `collection.mutable.Set(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = collection.mutable.Set(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
  def `collection.mutable.Set(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = collection.mutable.Set(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainValue[String, String](xs, "two")) + ", " + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\"")
  }
  def `collection.mutable.Set(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = collection.mutable.Set(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainValue[String, String](xs, "two")) + ", " + getFirstContainValue[String, String](xs, "two") + " contained value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainValue[String, String](xs, "two") + " contained value \"two\"")
  }
  def `(new collection.mutable.ListBuffer() ++ List(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `(new collection.mutable.ListBuffer() ++ List(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
  def `(new collection.mutable.ListBuffer() ++ List(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainValue[String, String](xs, "two")) + ", " + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\"")
  }
  def `(new collection.mutable.ListBuffer() ++ List(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainValue[String, String](xs, "two")) + ", " + getFirstContainValue[String, String](xs, "two") + " contained value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainValue[String, String](xs, "two") + " contained value \"two\"")
  }
  def `collection.mutable.Seq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = collection.mutable.Seq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `collection.mutable.Seq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = collection.mutable.Seq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
  def `collection.mutable.Seq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = collection.mutable.Seq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainValue[String, String](xs, "two")) + ", " + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\"")
  }
  def `collection.mutable.Seq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = collection.mutable.Seq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainValue[String, String](xs, "two")) + ", " + getFirstContainValue[String, String](xs, "two") + " contained value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainValue[String, String](xs, "two") + " contained value \"two\"")
  }
  def `collection.mutable.IndexedSeq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = collection.mutable.IndexedSeq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `collection.mutable.IndexedSeq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = collection.mutable.IndexedSeq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
  def `collection.mutable.IndexedSeq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = collection.mutable.IndexedSeq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainValue[String, String](xs, "two")) + ", " + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\"")
  }
  def `collection.mutable.IndexedSeq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = collection.mutable.IndexedSeq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainValue[String, String](xs, "two")) + ", " + getFirstContainValue[String, String](xs, "two") + " contained value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainValue[String, String](xs, "two") + " contained value \"two\"")
  }
  def `Set(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = Set(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `Set(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = Set(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
  def `Set(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = Set(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainValue[String, String](xs, "two")) + ", " + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\"")
  }
  def `Set(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = Set(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainValue[String, String](xs, "two")) + ", " + getFirstContainValue[String, String](xs, "two") + " contained value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainValue[String, String](xs, "two") + " contained value \"two\"")
  }
  def `List(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = List(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `List(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = List(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
  def `List(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = List(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainValue[String, String](xs, "two")) + ", " + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\"")
  }
  def `List(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = List(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainValue[String, String](xs, "two")) + ", " + getFirstContainValue[String, String](xs, "two") + " contained value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainValue[String, String](xs, "two") + " contained value \"two\"")
  }
  def `Seq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = Seq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `Seq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = Seq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
  def `Seq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = Seq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainValue[String, String](xs, "two")) + ", " + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\"")
  }
  def `Seq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = Seq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainValue[String, String](xs, "two")) + ", " + getFirstContainValue[String, String](xs, "two") + " contained value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainValue[String, String](xs, "two") + " contained value \"two\"")
  }
  def `Array(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = Array(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + arrayToString(xs), "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `Array(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = Array(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + arrayToString(xs), "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
  def `Array(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = Array(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainValue[String, String](xs, "two")) + ", " + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + arrayToString(xs), "" + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\"")
  }
  def `Array(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = Array(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainValue[String, String](xs, "two")) + ", " + getFirstContainValue[String, String](xs, "two") + " contained value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + arrayToString(xs), "" + getFirstContainValue[String, String](xs, "two") + " contained value \"two\"")
  }
  def `IndexedSeq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = IndexedSeq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `IndexedSeq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = IndexedSeq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
  def `IndexedSeq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = IndexedSeq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainValue[String, String](xs, "two")) + ", " + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\"")
  }
  def `IndexedSeq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = IndexedSeq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainValue[String, String](xs, "two")) + ", " + getFirstContainValue[String, String](xs, "two") + " contained value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainValue[String, String](xs, "two") + " contained value \"two\"")
  }
  def `Vector(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = Vector(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `Vector(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = Vector(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
  def `Vector(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = Vector(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainValue[String, String](xs, "two")) + ", " + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\"")
  }
  def `Vector(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = Vector(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainValue[String, String](xs, "two")) + ", " + getFirstContainValue[String, String](xs, "two") + " contained value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainValue[String, String](xs, "two") + " contained value \"two\"")
  }
  def `Set(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = Set(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `Set(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = Set(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
  def `Set(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = Set(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainValue[String, String](xs, "two")) + ", " + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\"")
  }
  def `Set(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = Set(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainValue[String, String](xs, "two")) + ", " + getFirstContainValue[String, String](xs, "two") + " contained value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainValue[String, String](xs, "two") + " contained value \"two\"")
  }
  def `List(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = List(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `List(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = List(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
  def `List(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = List(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainValue[String, String](xs, "two")) + ", " + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\"")
  }
  def `List(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = List(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainValue[String, String](xs, "two")) + ", " + getFirstContainValue[String, String](xs, "two") + " contained value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainValue[String, String](xs, "two") + " contained value \"two\"")
  }
  def `Seq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = Seq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `Seq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = Seq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
  def `Seq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = Seq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainValue[String, String](xs, "two")) + ", " + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\"")
  }
  def `Seq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = Seq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainValue[String, String](xs, "two")) + ", " + getFirstContainValue[String, String](xs, "two") + " contained value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainValue[String, String](xs, "two") + " contained value \"two\"")
  }
  def `IndexedSeq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = IndexedSeq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `IndexedSeq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = IndexedSeq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
  def `IndexedSeq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = IndexedSeq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainValue[String, String](xs, "two")) + ", " + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\"")
  }
  def `IndexedSeq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = IndexedSeq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainValue[String, String](xs, "two")) + ", " + getFirstContainValue[String, String](xs, "two") + " contained value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainValue[String, String](xs, "two") + " contained value \"two\"")
  }
  def `collection.mutable.Set(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = collection.mutable.Set(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `collection.mutable.Set(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = collection.mutable.Set(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
  def `collection.mutable.Set(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = collection.mutable.Set(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainValue[String, String](xs, "two")) + ", " + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\"")
  }
  def `collection.mutable.Set(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = collection.mutable.Set(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainValue[String, String](xs, "two")) + ", " + getFirstContainValue[String, String](xs, "two") + " contained value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainValue[String, String](xs, "two") + " contained value \"two\"")
  }
  def `new collection.mutable.ListBuffer() ++ List(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `new collection.mutable.ListBuffer() ++ List(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
  def `new collection.mutable.ListBuffer() ++ List(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainValue[String, String](xs, "two")) + ", " + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\"")
  }
  def `new collection.mutable.ListBuffer() ++ List(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainValue[String, String](xs, "two")) + ", " + getFirstContainValue[String, String](xs, "two") + " contained value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainValue[String, String](xs, "two") + " contained value \"two\"")
  }
  def `collection.mutable.Seq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = collection.mutable.Seq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `collection.mutable.Seq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = collection.mutable.Seq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
  def `collection.mutable.Seq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = collection.mutable.Seq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainValue[String, String](xs, "two")) + ", " + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\"")
  }
  def `collection.mutable.Seq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = collection.mutable.Seq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainValue[String, String](xs, "two")) + ", " + getFirstContainValue[String, String](xs, "two") + " contained value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainValue[String, String](xs, "two") + " contained value \"two\"")
  }
  def `collection.mutable.IndexedSeq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = collection.mutable.IndexedSeq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `collection.mutable.IndexedSeq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = collection.mutable.IndexedSeq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
  def `collection.mutable.IndexedSeq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = collection.mutable.IndexedSeq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainValue[String, String](xs, "two")) + ", " + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\"")
  }
  def `collection.mutable.IndexedSeq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = collection.mutable.IndexedSeq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainValue[String, String](xs, "two")) + ", " + getFirstContainValue[String, String](xs, "two") + " contained value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainValue[String, String](xs, "two") + " contained value \"two\"")
  }
  def `collection.mutable.Set(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = collection.mutable.Set(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `collection.mutable.Set(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = collection.mutable.Set(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
  def `collection.mutable.Set(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = collection.mutable.Set(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainValue[String, String](xs, "two")) + ", " + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\"")
  }
  def `collection.mutable.Set(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = collection.mutable.Set(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainValue[String, String](xs, "two")) + ", " + getFirstContainValue[String, String](xs, "two") + " contained value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainValue[String, String](xs, "two") + " contained value \"two\"")
  }
  def `(new collection.mutable.ListBuffer() ++ List(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight"))).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight"))).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `(new collection.mutable.ListBuffer() ++ List(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight"))).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight"))).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
  def `(new collection.mutable.ListBuffer() ++ List(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight"))).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight"))).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainValue[String, String](xs, "two")) + ", " + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\"")
  }
  def `(new collection.mutable.ListBuffer() ++ List(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight"))).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight"))).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainValue[String, String](xs, "two")) + ", " + getFirstContainValue[String, String](xs, "two") + " contained value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainValue[String, String](xs, "two") + " contained value \"two\"")
  }
  def `collection.mutable.Seq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = collection.mutable.Seq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `collection.mutable.Seq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = collection.mutable.Seq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
  def `collection.mutable.Seq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = collection.mutable.Seq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainValue[String, String](xs, "two")) + ", " + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\"")
  }
  def `collection.mutable.Seq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = collection.mutable.Seq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainValue[String, String](xs, "two")) + ", " + getFirstContainValue[String, String](xs, "two") + " contained value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainValue[String, String](xs, "two") + " contained value \"two\"")
  }
  def `collection.mutable.IndexedSeq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = collection.mutable.IndexedSeq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `collection.mutable.IndexedSeq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = collection.mutable.IndexedSeq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
  def `collection.mutable.IndexedSeq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = collection.mutable.IndexedSeq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainValue[String, String](xs, "two")) + ", " + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\"")
  }
  def `collection.mutable.IndexedSeq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = collection.mutable.IndexedSeq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainValue[String, String](xs, "two")) + ", " + getFirstContainValue[String, String](xs, "two") + " contained value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainValue[String, String](xs, "two") + " contained value \"two\"")
  }
  def `Set(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = Set(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `Set(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = Set(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
  def `Set(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = Set(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainValue[String, String](xs, "two")) + ", " + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\"")
  }
  def `Set(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = Set(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainValue[String, String](xs, "two")) + ", " + getFirstContainValue[String, String](xs, "two") + " contained value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainValue[String, String](xs, "two") + " contained value \"two\"")
  }
  def `List(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = List(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `List(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = List(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
  def `List(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = List(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainValue[String, String](xs, "two")) + ", " + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\"")
  }
  def `List(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = List(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainValue[String, String](xs, "two")) + ", " + getFirstContainValue[String, String](xs, "two") + " contained value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainValue[String, String](xs, "two") + " contained value \"two\"")
  }
  def `Seq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = Seq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `Seq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = Seq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
  def `Seq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = Seq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainValue[String, String](xs, "two")) + ", " + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\"")
  }
  def `Seq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = Seq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainValue[String, String](xs, "two")) + ", " + getFirstContainValue[String, String](xs, "two") + " contained value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainValue[String, String](xs, "two") + " contained value \"two\"")
  }
  def `Array(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = Array(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + arrayToString(xs), "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `Array(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = Array(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + arrayToString(xs), "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
  def `Array(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = Array(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainValue[String, String](xs, "two")) + ", " + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + arrayToString(xs), "" + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\"")
  }
  def `Array(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = Array(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainValue[String, String](xs, "two")) + ", " + getFirstContainValue[String, String](xs, "two") + " contained value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + arrayToString(xs), "" + getFirstContainValue[String, String](xs, "two") + " contained value \"two\"")
  }
  def `IndexedSeq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = IndexedSeq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `IndexedSeq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = IndexedSeq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
  def `IndexedSeq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = IndexedSeq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainValue[String, String](xs, "two")) + ", " + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\"")
  }
  def `IndexedSeq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = IndexedSeq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainValue[String, String](xs, "two")) + ", " + getFirstContainValue[String, String](xs, "two") + " contained value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainValue[String, String](xs, "two") + " contained value \"two\"")
  }
  def `Vector(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = Vector(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `Vector(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = Vector(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
  def `Vector(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = Vector(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainValue[String, String](xs, "two")) + ", " + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\"")
  }
  def `Vector(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = Vector(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainValue[String, String](xs, "two")) + ", " + getFirstContainValue[String, String](xs, "two") + " contained value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainValue[String, String](xs, "two") + " contained value \"two\"")
  }
  def `Set(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = Set(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `Set(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = Set(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
  def `Set(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = Set(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainValue[String, String](xs, "two")) + ", " + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\"")
  }
  def `Set(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = Set(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainValue[String, String](xs, "two")) + ", " + getFirstContainValue[String, String](xs, "two") + " contained value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainValue[String, String](xs, "two") + " contained value \"two\"")
  }
  def `List(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = List(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `List(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = List(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
  def `List(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = List(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainValue[String, String](xs, "two")) + ", " + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\"")
  }
  def `List(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = List(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainValue[String, String](xs, "two")) + ", " + getFirstContainValue[String, String](xs, "two") + " contained value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainValue[String, String](xs, "two") + " contained value \"two\"")
  }
  def `Seq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = Seq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `Seq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = Seq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
  def `Seq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = Seq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainValue[String, String](xs, "two")) + ", " + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\"")
  }
  def `Seq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = Seq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainValue[String, String](xs, "two")) + ", " + getFirstContainValue[String, String](xs, "two") + " contained value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainValue[String, String](xs, "two") + " contained value \"two\"")
  }
  def `IndexedSeq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = IndexedSeq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `IndexedSeq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = IndexedSeq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
  def `IndexedSeq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = IndexedSeq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainValue[String, String](xs, "two")) + ", " + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\"")
  }
  def `IndexedSeq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = IndexedSeq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainValue[String, String](xs, "two")) + ", " + getFirstContainValue[String, String](xs, "two") + " contained value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainValue[String, String](xs, "two") + " contained value \"two\"")
  }
  def `collection.mutable.Set(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = collection.mutable.Set(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `collection.mutable.Set(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = collection.mutable.Set(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
  def `collection.mutable.Set(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = collection.mutable.Set(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainValue[String, String](xs, "two")) + ", " + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\"")
  }
  def `collection.mutable.Set(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = collection.mutable.Set(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainValue[String, String](xs, "two")) + ", " + getFirstContainValue[String, String](xs, "two") + " contained value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainValue[String, String](xs, "two") + " contained value \"two\"")
  }
  def `new collection.mutable.ListBuffer() ++ List(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `new collection.mutable.ListBuffer() ++ List(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
  def `new collection.mutable.ListBuffer() ++ List(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainValue[String, String](xs, "two")) + ", " + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\"")
  }
  def `new collection.mutable.ListBuffer() ++ List(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainValue[String, String](xs, "two")) + ", " + getFirstContainValue[String, String](xs, "two") + " contained value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainValue[String, String](xs, "two") + " contained value \"two\"")
  }
  def `collection.mutable.Seq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = collection.mutable.Seq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `collection.mutable.Seq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = collection.mutable.Seq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
  def `collection.mutable.Seq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = collection.mutable.Seq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainValue[String, String](xs, "two")) + ", " + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\"")
  }
  def `collection.mutable.Seq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = collection.mutable.Seq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainValue[String, String](xs, "two")) + ", " + getFirstContainValue[String, String](xs, "two") + " contained value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainValue[String, String](xs, "two") + " contained value \"two\"")
  }
  def `collection.mutable.IndexedSeq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = collection.mutable.IndexedSeq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `collection.mutable.IndexedSeq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = collection.mutable.IndexedSeq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
  def `collection.mutable.IndexedSeq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = collection.mutable.IndexedSeq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainValue[String, String](xs, "two")) + ", " + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\"")
  }
  def `collection.mutable.IndexedSeq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = collection.mutable.IndexedSeq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainValue[String, String](xs, "two")) + ", " + getFirstContainValue[String, String](xs, "two") + " contained value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainValue[String, String](xs, "two") + " contained value \"two\"")
  }
  def `collection.mutable.Set(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = collection.mutable.Set(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `collection.mutable.Set(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = collection.mutable.Set(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
  def `collection.mutable.Set(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = collection.mutable.Set(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainValue[String, String](xs, "two")) + ", " + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\"")
  }
  def `collection.mutable.Set(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = collection.mutable.Set(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainValue[String, String](xs, "two")) + ", " + getFirstContainValue[String, String](xs, "two") + " contained value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainValue[String, String](xs, "two") + " contained value \"two\"")
  }
  def `(new collection.mutable.ListBuffer() ++ List(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `(new collection.mutable.ListBuffer() ++ List(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
  def `(new collection.mutable.ListBuffer() ++ List(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainValue[String, String](xs, "two")) + ", " + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\"")
  }
  def `(new collection.mutable.ListBuffer() ++ List(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainValue[String, String](xs, "two")) + ", " + getFirstContainValue[String, String](xs, "two") + " contained value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainValue[String, String](xs, "two") + " contained value \"two\"")
  }
  def `collection.mutable.Seq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = collection.mutable.Seq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `collection.mutable.Seq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = collection.mutable.Seq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
  def `collection.mutable.Seq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = collection.mutable.Seq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainValue[String, String](xs, "two")) + ", " + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\"")
  }
  def `collection.mutable.Seq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = collection.mutable.Seq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainValue[String, String](xs, "two")) + ", " + getFirstContainValue[String, String](xs, "two") + " contained value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainValue[String, String](xs, "two") + " contained value \"two\"")
  }
  def `collection.mutable.IndexedSeq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = collection.mutable.IndexedSeq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `collection.mutable.IndexedSeq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = collection.mutable.IndexedSeq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
  def `collection.mutable.IndexedSeq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = collection.mutable.IndexedSeq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainValue[String, String](xs, "two")) + ", " + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\"")
  }
  def `collection.mutable.IndexedSeq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = collection.mutable.IndexedSeq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainValue[String, String](xs, "two")) + ", " + getFirstContainValue[String, String](xs, "two") + " contained value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainValue[String, String](xs, "two") + " contained value \"two\"")
  }
  def `Set(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = Set(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `Set(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = Set(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
  def `Set(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = Set(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainValue[String, String](xs, "two")) + ", " + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\"")
  }
  def `Set(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = Set(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainValue[String, String](xs, "two")) + ", " + getFirstContainValue[String, String](xs, "two") + " contained value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainValue[String, String](xs, "two") + " contained value \"two\"")
  }
  def `List(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = List(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `List(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = List(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
  def `List(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = List(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainValue[String, String](xs, "two")) + ", " + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\"")
  }
  def `List(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = List(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainValue[String, String](xs, "two")) + ", " + getFirstContainValue[String, String](xs, "two") + " contained value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainValue[String, String](xs, "two") + " contained value \"two\"")
  }
  def `Seq(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = Seq(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `Seq(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = Seq(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
  def `Seq(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = Seq(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainValue[String, String](xs, "two")) + ", " + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\"")
  }
  def `Seq(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = Seq(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainValue[String, String](xs, "two")) + ", " + getFirstContainValue[String, String](xs, "two") + " contained value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainValue[String, String](xs, "two") + " contained value \"two\"")
  }
  def `Array(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = Array(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + arrayToString(xs), "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `Array(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = Array(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + arrayToString(xs), "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
  def `Array(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = Array(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainValue[String, String](xs, "two")) + ", " + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + arrayToString(xs), "" + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\"")
  }
  def `Array(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = Array(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainValue[String, String](xs, "two")) + ", " + getFirstContainValue[String, String](xs, "two") + " contained value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + arrayToString(xs), "" + getFirstContainValue[String, String](xs, "two") + " contained value \"two\"")
  }
  def `IndexedSeq(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = IndexedSeq(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `IndexedSeq(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = IndexedSeq(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
  def `IndexedSeq(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = IndexedSeq(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainValue[String, String](xs, "two")) + ", " + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\"")
  }
  def `IndexedSeq(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = IndexedSeq(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainValue[String, String](xs, "two")) + ", " + getFirstContainValue[String, String](xs, "two") + " contained value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainValue[String, String](xs, "two") + " contained value \"two\"")
  }
  def `Vector(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = Vector(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `Vector(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = Vector(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
  def `Vector(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = Vector(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainValue[String, String](xs, "two")) + ", " + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainValue[String, String](xs, "two") + " did not contain value \"two\"")
  }
  def `Vector(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = Vector(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainValue[String, String](xs, "two")) + ", " + getFirstContainValue[String, String](xs, "two") + " contained value \"two\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainValue[String, String](xs, "two") + " contained value \"two\"")
  }
  def `Set(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = Set(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstNotContainKey[String, String](xs, "2")) + ", " + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstNotContainKey[String, String](xs, "2") + " did not contain key \"2\"")
  }
  def `Set(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = Set(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val e = intercept[exceptions.TestFailedException] {
      all(xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkErrorAndCause(e, assertLineNumber, "InspectorShorthandsForAllFailedSpec2.scala", "'all' inspection failed, because: \n" + 
  "  at index " + getIndex(xs, getFirstContainKey[String, String](xs, "2")) + ", " + getFirstContainKey[String, String](xs, "2") + " contained key \"2\" (InspectorShorthandsForAllFailedSpec2.scala:" + assertLineNumber + ") \n" + 
  "in " + xs, "" + getFirstContainKey[String, String](xs, "2") + " contained key \"2\"")
  }
}
