package org.scalatest.inspectors.all

import org.scalatest._
import SharedHelpers._
import org.scalatest.matchers.{BePropertyMatcher, BePropertyMatchResult, HavePropertyMatcher, HavePropertyMatchResult}
import collection.GenTraversable
import collection.GenMap
class InspectorShorthandsForAllSucceededSpec extends Spec with Matchers {
  def `all(Set(1, 2, 3)) should succeed when all elements succeeded` {
    all(Set(1, 2, 3)) should be < 4
  }
  def `all(List(1, 2, 3)) should succeed when all elements succeeded` {
    all(List(1, 2, 3)) should be < 4
  }
  def `all(Seq(1, 2, 3)) should succeed when all elements succeeded` {
    all(Seq(1, 2, 3)) should be < 4
  }
  def `all(Array(1, 2, 3)) should succeed when all elements succeeded` {
    all(Array(1, 2, 3)) should be < 4
  }
  def `all(IndexedSeq(1, 2, 3)) should succeed when all elements succeeded` {
    all(IndexedSeq(1, 2, 3)) should be < 4
  }
  def `all(Vector(1, 2, 3)) should succeed when all elements succeeded` {
    all(Vector(1, 2, 3)) should be < 4
  }
  def `all(Set(1, 2, 3).par) should succeed when all elements succeeded` {
    all(Set(1, 2, 3).par) should be < 4
  }
  def `all(List(1, 2, 3).par) should succeed when all elements succeeded` {
    all(List(1, 2, 3).par) should be < 4
  }
  def `all(Seq(1, 2, 3).par) should succeed when all elements succeeded` {
    all(Seq(1, 2, 3).par) should be < 4
  }
  def `all(IndexedSeq(1, 2, 3).par) should succeed when all elements succeeded` {
    all(IndexedSeq(1, 2, 3).par) should be < 4
  }
  def `all(collection.mutable.Set(1, 2, 3)) should succeed when all elements succeeded` {
    all(collection.mutable.Set(1, 2, 3)) should be < 4
  }
  def `all(new collection.mutable.ListBuffer() ++ List(1, 2, 3)) should succeed when all elements succeeded` {
    all(new collection.mutable.ListBuffer() ++ List(1, 2, 3)) should be < 4
  }
  def `all(collection.mutable.Seq(1, 2, 3)) should succeed when all elements succeeded` {
    all(collection.mutable.Seq(1, 2, 3)) should be < 4
  }
  def `all(collection.mutable.IndexedSeq(1, 2, 3)) should succeed when all elements succeeded` {
    all(collection.mutable.IndexedSeq(1, 2, 3)) should be < 4
  }
  def `all(collection.mutable.Set(1, 2, 3).par) should succeed when all elements succeeded` {
    all(collection.mutable.Set(1, 2, 3).par) should be < 4
  }
  def `all((new collection.mutable.ListBuffer() ++ List(1, 2, 3)).par) should succeed when all elements succeeded` {
    all((new collection.mutable.ListBuffer() ++ List(1, 2, 3)).par) should be < 4
  }
  def `all(collection.mutable.Seq(1, 2, 3).par) should succeed when all elements succeeded` {
    all(collection.mutable.Seq(1, 2, 3).par) should be < 4
  }
  def `all(collection.mutable.IndexedSeq(1, 2, 3).par) should succeed when all elements succeeded` {
    all(collection.mutable.IndexedSeq(1, 2, 3).par) should be < 4
  }
}
