package org.scalatest.inspectors.atLeast

import org.scalatest._
import SharedHelpers._
import org.scalatest.matchers.{BePropertyMatcher, BePropertyMatchResult, HavePropertyMatcher, HavePropertyMatchResult}
import collection.GenTraversable
import collection.GenMap
class InspectorShorthandsForAtLeastFailedSpec0 extends Spec with Matchers {
  class EmptyBePropertyMatcher extends BePropertyMatcher[String] {
    def apply(left: String) = BePropertyMatchResult(left.isEmpty, "empty")
  }
  class StringLengthMatcher(expectedValue: Int) extends HavePropertyMatcher[String, Int] {
    def apply(value: String) = {
      new HavePropertyMatchResult(value.length == expectedValue, "length", expectedValue, value.length)
    }
  }
  val empty = new EmptyBePropertyMatcher()
  def plength(expectedValue: Int) = new StringLengthMatcher(expectedValue)
  val theInstance = "2"
  def arrayToString(xs: GenTraversable[_]): String = xs.toString
  def checkErrorAndCause(e: exceptions.TestFailedException, assertLineNumber: Int, fileName: String, errorMessage: String, causeErrorMessage: String) {
    assert(e.failedCodeFileName == Some(fileName), e.failedCodeFileName + " did not equal " + Some(fileName))
    assert(e.failedCodeLineNumber == Some(assertLineNumber), e.failedCodeLineNumber + " did not equal " + Some(assertLineNumber))
    assert(e.message == Some(errorMessage), e.message + " did not equal " + Some(
  errorMessage))
    e.getCause match {
      case tfe: exceptions.TestFailedException =>
        assert(tfe.failedCodeFileName == Some(fileName), tfe.failedCodeFileName + " did not equal " + Some(fileName))
        assert(tfe.failedCodeLineNumber == Some(assertLineNumber), tfe.failedCodeLineNumber + " did not equal " + Some(assertLineNumber))
        assert(tfe.message == Some(causeErrorMessage), tfe.message + " did not equal " + Some(causeErrorMessage))
        assert(tfe.getCause == null, tfe.getCause + " was not null")
      case other => fail("Expected cause to be TestFailedException, but got: " + other)
    }
  }
  def checkError(e: exceptions.TestFailedException, assertLineNumber: Int, fileName: String, errorMessage: String) {
    assert(e.failedCodeFileName == Some(fileName), e.failedCodeFileName + " did not equal " + Some(fileName))
    assert(e.failedCodeLineNumber == Some(assertLineNumber), e.failedCodeLineNumber + " did not equal " + Some(assertLineNumber))
    assert(e.message == Some(errorMessage), e.message + " did not equal " + Some(
  errorMessage))
  }
  def equal[T](left: T, right: T): Boolean = left == right
  def javaArrayList[T](valueList: List[T]): java.util.ArrayList[T] = {
    val col = new java.util.ArrayList[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaHashSet[T](valueList: List[T]): java.util.HashSet[T] = {
    val col = new java.util.HashSet[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaLinkedList[T](valueList: List[T]): java.util.LinkedList[T] = {
    val col = new java.util.LinkedList[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaStack[T](valueList: List[T]): java.util.Stack[T] = {
    val col = new java.util.Stack[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaTreeSet[T](valueList: List[T]): java.util.TreeSet[T] = {
    val col = new java.util.TreeSet[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaVector[T](valueList: List[T]): java.util.Vector[T] = {
    val col = new java.util.Vector[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaArrayBlockingQueue[T](valueList: List[T], size: Int): java.util.concurrent.ArrayBlockingQueue[T] = {
    val col = new java.util.concurrent.ArrayBlockingQueue[T](size)
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaArrayDeque[T](valueList: List[T]): java.util.ArrayDeque[T] = {
    val col = new java.util.ArrayDeque[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaConcurrentLinkedQueue[T](valueList: List[T]): java.util.concurrent.ConcurrentLinkedQueue[T] = {
    val col = new java.util.concurrent.ConcurrentLinkedQueue[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaConcurrentSkipListSet[T](valueList: List[T]): java.util.concurrent.ConcurrentSkipListSet[T] = {
    val col = new java.util.concurrent.ConcurrentSkipListSet[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaCopyOnWriteArrayList[T](valueList: List[T]): java.util.concurrent.CopyOnWriteArrayList[T] = {
    val col = new java.util.concurrent.CopyOnWriteArrayList[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaCopyOnWriteArraySet[T](valueList: List[T]): java.util.concurrent.CopyOnWriteArraySet[T] = {
    val col = new java.util.concurrent.CopyOnWriteArraySet[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaLinkedBlockingDeque[T](valueList: List[T]): java.util.concurrent.LinkedBlockingDeque[T] = {
    val col = new java.util.concurrent.LinkedBlockingDeque[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaLinkedBlockingQueue[T](valueList: List[T]): java.util.concurrent.LinkedBlockingQueue[T] = {
    val col = new java.util.concurrent.LinkedBlockingQueue[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaLinkedHashSet[T](valueList: List[T]): java.util.LinkedHashSet[T] = {
    val col = new java.util.LinkedHashSet[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaPriorityBlockingQueue[T](valueList: List[T]): java.util.concurrent.PriorityBlockingQueue[T] = {
    val col = new java.util.concurrent.PriorityBlockingQueue[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaPriorityQueue[T](valueList: List[T]): java.util.PriorityQueue[T] = {
    val col = new java.util.PriorityQueue[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaHashMap[K, V](valueMap: Map[K, V]): java.util.HashMap[K, V] = {
    val map = new java.util.HashMap[K, V]()
    for ((key, value) <- valueMap)
      map.put(key, value)
    map
  }
  def javaTreeMap[K, V](valueMap: Map[K, V]): java.util.TreeMap[K, V] = {
    val map = new java.util.TreeMap[K, V]()
    for ((key, value) <- valueMap)
      map.put(key, value)
    map
  }
  def javaHashtable[K, V](valueMap: Map[K, V]): java.util.Hashtable[K, V] = {
    val map = new java.util.Hashtable[K, V]()
    for ((key, value) <- valueMap)
      map.put(key, value)
    map
  }
  def javaConcurrentHashMap[K, V](valueMap: Map[K, V]): java.util.concurrent.ConcurrentHashMap[K, V] = {
    val map = new java.util.concurrent.ConcurrentHashMap[K, V]()
    for ((key, value) <- valueMap)
      map.put(key, value)
    map
  }
  def javaConcurrentSkipListMap[K, V](valueMap: Map[K, V]): java.util.concurrent.ConcurrentSkipListMap[K, V] = {
    val map = new java.util.concurrent.ConcurrentSkipListMap[K, V]()
    for ((key, value) <- valueMap)
      map.put(key, value)
    map
  }
  def javaLinkedHashMap[K, V](valueMap: Map[K, V]): java.util.LinkedHashMap[K, V] = {
    val map = new java.util.LinkedHashMap[K, V]()
    for ((key, value) <- valueMap)
      map.put(key, value)
    map
  }
  def javaWeakHashMap[K, V](valueMap: Map[K, V]): java.util.WeakHashMap[K, V] = {
    val map = new java.util.WeakHashMap[K, V]()
    for ((key, value) <- valueMap)
      map.put(key, value)
    map
  }
  def javaProperties(valueMap: Map[String, String]): java.util.Properties = {
    val map = new java.util.Properties()
    for ((key, value) <- valueMap)
      map.put(key, value)
    map
  }
  def `Set(1, 2, 3) should throw TestFailedException with correct stack depth and message when at least one element failed` {
    val xs = Set(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should equal (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not equal 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not equal 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `Set(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should equal' failed` {
    val xs = Set(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should equal (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not equal 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not equal 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `Set(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should not equal' failed` {
    val xs = Set(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not equal 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} equaled 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `Set(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should be' failed` {
    val xs = Set(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `Set(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should not be' failed` {
    val xs = Set(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `Set(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should be less than comparison' failed` {
    val xs = Set(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be < 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not less than 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementMoreThanEqual(itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not less than 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementMoreThanEqual(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `Set(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should not be less than comparison' failed` {
    val xs = Set(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be < (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was less than 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLessThan(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `Set(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should be less than or equal comparison' failed` {
    val xs = Set(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be <= 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not less than or equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementMoreThan(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `Set(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should not be less than or equal comparison' failed` {
    val xs = Set(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be <= (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was less than or equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLessThanEqual(itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was less than or equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLessThanEqual(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `Set(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should be greater than comparison' failed` {
    val xs = Set(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be > 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not greater than 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLessThanEqual(itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not greater than 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLessThanEqual(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `Set(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should not be greater than comparison' failed` {
    val xs = Set(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be > (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was greater than 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementMoreThan(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `Set(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should be greater than or equal comparison' failed` {
    val xs = Set(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be >= 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not greater than or equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLessThan(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `Set(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should not be greater than or equal comparison' failed` {
    val xs = Set(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be >= (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was greater than or equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementMoreThanEqual(itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was greater than or equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementMoreThanEqual(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `Set(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should be ===' failed` {
    val xs = Set(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be === 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `Set(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should not be ===' failed` {
    val xs = Set(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be === (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `List(1, 2, 3) should throw TestFailedException with correct stack depth and message when at least one element failed` {
    val xs = List(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should equal (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not equal 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not equal 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `List(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should equal' failed` {
    val xs = List(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should equal (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not equal 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not equal 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `List(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should not equal' failed` {
    val xs = List(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not equal 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} equaled 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `List(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should be' failed` {
    val xs = List(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `List(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should not be' failed` {
    val xs = List(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `List(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should be less than comparison' failed` {
    val xs = List(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be < 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not less than 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementMoreThanEqual(itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not less than 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementMoreThanEqual(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `List(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should not be less than comparison' failed` {
    val xs = List(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be < (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was less than 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLessThan(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `List(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should be less than or equal comparison' failed` {
    val xs = List(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be <= 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not less than or equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementMoreThan(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `List(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should not be less than or equal comparison' failed` {
    val xs = List(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be <= (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was less than or equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLessThanEqual(itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was less than or equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLessThanEqual(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `List(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should be greater than comparison' failed` {
    val xs = List(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be > 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not greater than 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLessThanEqual(itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not greater than 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLessThanEqual(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `List(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should not be greater than comparison' failed` {
    val xs = List(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be > (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was greater than 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementMoreThan(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `List(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should be greater than or equal comparison' failed` {
    val xs = List(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be >= 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not greater than or equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLessThan(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `List(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should not be greater than or equal comparison' failed` {
    val xs = List(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be >= (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was greater than or equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementMoreThanEqual(itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was greater than or equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementMoreThanEqual(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `List(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should be ===' failed` {
    val xs = List(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be === 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `List(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should not be ===' failed` {
    val xs = List(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be === (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `Seq(1, 2, 3) should throw TestFailedException with correct stack depth and message when at least one element failed` {
    val xs = Seq(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should equal (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not equal 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not equal 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `Seq(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should equal' failed` {
    val xs = Seq(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should equal (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not equal 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not equal 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `Seq(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should not equal' failed` {
    val xs = Seq(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not equal 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} equaled 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `Seq(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should be' failed` {
    val xs = Seq(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `Seq(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should not be' failed` {
    val xs = Seq(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `Seq(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should be less than comparison' failed` {
    val xs = Seq(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be < 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not less than 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementMoreThanEqual(itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not less than 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementMoreThanEqual(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `Seq(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should not be less than comparison' failed` {
    val xs = Seq(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be < (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was less than 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLessThan(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `Seq(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should be less than or equal comparison' failed` {
    val xs = Seq(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be <= 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not less than or equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementMoreThan(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `Seq(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should not be less than or equal comparison' failed` {
    val xs = Seq(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be <= (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was less than or equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLessThanEqual(itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was less than or equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLessThanEqual(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `Seq(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should be greater than comparison' failed` {
    val xs = Seq(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be > 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not greater than 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLessThanEqual(itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not greater than 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLessThanEqual(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `Seq(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should not be greater than comparison' failed` {
    val xs = Seq(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be > (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was greater than 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementMoreThan(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `Seq(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should be greater than or equal comparison' failed` {
    val xs = Seq(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be >= 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not greater than or equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLessThan(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `Seq(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should not be greater than or equal comparison' failed` {
    val xs = Seq(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be >= (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was greater than or equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementMoreThanEqual(itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was greater than or equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementMoreThanEqual(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `Seq(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should be ===' failed` {
    val xs = Seq(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be === 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `Seq(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should not be ===' failed` {
    val xs = Seq(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be === (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `Array(1, 2, 3) should throw TestFailedException with correct stack depth and message when at least one element failed` {
    val xs = Array(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should equal (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not equal 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not equal 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + "WrappedArray(1, 2, 3)")
  }
  def `Array(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should equal' failed` {
    val xs = Array(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should equal (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not equal 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not equal 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + "WrappedArray(1, 2, 3)")
  }
  def `Array(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should not equal' failed` {
    val xs = Array(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not equal 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} equaled 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + "WrappedArray(1, 2, 3)")
  }
  def `Array(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should be' failed` {
    val xs = Array(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + "WrappedArray(1, 2, 3)")
  }
  def `Array(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should not be' failed` {
    val xs = Array(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + "WrappedArray(1, 2, 3)")
  }
  def `Array(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should be less than comparison' failed` {
    val xs = Array(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be < 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not less than 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementMoreThanEqual(itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not less than 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementMoreThanEqual(itr, xs, 2)) + " \n" + 
  "in " + "WrappedArray(1, 2, 3)")
  }
  def `Array(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should not be less than comparison' failed` {
    val xs = Array(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be < (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was less than 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLessThan(itr, xs, 2)) + " \n" + 
  "in " + "WrappedArray(1, 2, 3)")
  }
  def `Array(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should be less than or equal comparison' failed` {
    val xs = Array(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be <= 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not less than or equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementMoreThan(itr, xs, 2)) + " \n" + 
  "in " + "WrappedArray(1, 2, 3)")
  }
  def `Array(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should not be less than or equal comparison' failed` {
    val xs = Array(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be <= (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was less than or equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLessThanEqual(itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was less than or equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLessThanEqual(itr, xs, 2)) + " \n" + 
  "in " + "WrappedArray(1, 2, 3)")
  }
  def `Array(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should be greater than comparison' failed` {
    val xs = Array(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be > 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not greater than 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLessThanEqual(itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not greater than 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLessThanEqual(itr, xs, 2)) + " \n" + 
  "in " + "WrappedArray(1, 2, 3)")
  }
  def `Array(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should not be greater than comparison' failed` {
    val xs = Array(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be > (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was greater than 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementMoreThan(itr, xs, 2)) + " \n" + 
  "in " + "WrappedArray(1, 2, 3)")
  }
  def `Array(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should be greater than or equal comparison' failed` {
    val xs = Array(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be >= 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not greater than or equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLessThan(itr, xs, 2)) + " \n" + 
  "in " + "WrappedArray(1, 2, 3)")
  }
  def `Array(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should not be greater than or equal comparison' failed` {
    val xs = Array(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be >= (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was greater than or equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementMoreThanEqual(itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was greater than or equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementMoreThanEqual(itr, xs, 2)) + " \n" + 
  "in " + "WrappedArray(1, 2, 3)")
  }
  def `Array(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should be ===' failed` {
    val xs = Array(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be === 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + "WrappedArray(1, 2, 3)")
  }
  def `Array(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should not be ===' failed` {
    val xs = Array(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be === (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + "WrappedArray(1, 2, 3)")
  }
  def `IndexedSeq(1, 2, 3) should throw TestFailedException with correct stack depth and message when at least one element failed` {
    val xs = IndexedSeq(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should equal (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not equal 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not equal 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `IndexedSeq(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should equal' failed` {
    val xs = IndexedSeq(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should equal (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not equal 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not equal 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `IndexedSeq(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should not equal' failed` {
    val xs = IndexedSeq(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not equal 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} equaled 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `IndexedSeq(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should be' failed` {
    val xs = IndexedSeq(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `IndexedSeq(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should not be' failed` {
    val xs = IndexedSeq(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `IndexedSeq(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should be less than comparison' failed` {
    val xs = IndexedSeq(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be < 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not less than 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementMoreThanEqual(itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not less than 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementMoreThanEqual(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `IndexedSeq(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should not be less than comparison' failed` {
    val xs = IndexedSeq(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be < (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was less than 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLessThan(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `IndexedSeq(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should be less than or equal comparison' failed` {
    val xs = IndexedSeq(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be <= 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not less than or equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementMoreThan(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `IndexedSeq(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should not be less than or equal comparison' failed` {
    val xs = IndexedSeq(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be <= (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was less than or equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLessThanEqual(itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was less than or equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLessThanEqual(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `IndexedSeq(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should be greater than comparison' failed` {
    val xs = IndexedSeq(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be > 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not greater than 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLessThanEqual(itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not greater than 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLessThanEqual(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `IndexedSeq(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should not be greater than comparison' failed` {
    val xs = IndexedSeq(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be > (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was greater than 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementMoreThan(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `IndexedSeq(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should be greater than or equal comparison' failed` {
    val xs = IndexedSeq(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be >= 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not greater than or equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLessThan(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `IndexedSeq(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should not be greater than or equal comparison' failed` {
    val xs = IndexedSeq(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be >= (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was greater than or equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementMoreThanEqual(itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was greater than or equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementMoreThanEqual(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `IndexedSeq(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should be ===' failed` {
    val xs = IndexedSeq(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be === 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `IndexedSeq(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should not be ===' failed` {
    val xs = IndexedSeq(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be === (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `Vector(1, 2, 3) should throw TestFailedException with correct stack depth and message when at least one element failed` {
    val xs = Vector(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should equal (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not equal 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not equal 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `Vector(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should equal' failed` {
    val xs = Vector(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should equal (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not equal 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not equal 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `Vector(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should not equal' failed` {
    val xs = Vector(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not equal 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} equaled 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `Vector(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should be' failed` {
    val xs = Vector(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `Vector(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should not be' failed` {
    val xs = Vector(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `Vector(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should be less than comparison' failed` {
    val xs = Vector(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be < 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not less than 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementMoreThanEqual(itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not less than 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementMoreThanEqual(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `Vector(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should not be less than comparison' failed` {
    val xs = Vector(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be < (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was less than 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLessThan(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `Vector(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should be less than or equal comparison' failed` {
    val xs = Vector(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be <= 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not less than or equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementMoreThan(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `Vector(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should not be less than or equal comparison' failed` {
    val xs = Vector(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be <= (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was less than or equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLessThanEqual(itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was less than or equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLessThanEqual(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `Vector(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should be greater than comparison' failed` {
    val xs = Vector(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be > 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not greater than 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLessThanEqual(itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not greater than 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLessThanEqual(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `Vector(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should not be greater than comparison' failed` {
    val xs = Vector(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be > (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was greater than 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementMoreThan(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `Vector(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should be greater than or equal comparison' failed` {
    val xs = Vector(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be >= 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not greater than or equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLessThan(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `Vector(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should not be greater than or equal comparison' failed` {
    val xs = Vector(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be >= (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was greater than or equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementMoreThanEqual(itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was greater than or equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementMoreThanEqual(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `Vector(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should be ===' failed` {
    val xs = Vector(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be === 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `Vector(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should not be ===' failed` {
    val xs = Vector(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be === (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `Set(1, 2, 3).par should throw TestFailedException with correct stack depth and message when at least one element failed` {
    val xs = Set(1, 2, 3).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should equal (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not equal 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not equal 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `Set(1, 2, 3).par should throw TestFailedException with correct stack depth and message when 'should equal' failed` {
    val xs = Set(1, 2, 3).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should equal (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not equal 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not equal 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `Set(1, 2, 3).par should throw TestFailedException with correct stack depth and message when 'should not equal' failed` {
    val xs = Set(1, 2, 3).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not equal 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} equaled 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `Set(1, 2, 3).par should throw TestFailedException with correct stack depth and message when 'should be' failed` {
    val xs = Set(1, 2, 3).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `Set(1, 2, 3).par should throw TestFailedException with correct stack depth and message when 'should not be' failed` {
    val xs = Set(1, 2, 3).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `Set(1, 2, 3).par should throw TestFailedException with correct stack depth and message when 'should be less than comparison' failed` {
    val xs = Set(1, 2, 3).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be < 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not less than 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementMoreThanEqual(itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not less than 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementMoreThanEqual(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `Set(1, 2, 3).par should throw TestFailedException with correct stack depth and message when 'should not be less than comparison' failed` {
    val xs = Set(1, 2, 3).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be < (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was less than 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLessThan(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `Set(1, 2, 3).par should throw TestFailedException with correct stack depth and message when 'should be less than or equal comparison' failed` {
    val xs = Set(1, 2, 3).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be <= 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not less than or equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementMoreThan(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `Set(1, 2, 3).par should throw TestFailedException with correct stack depth and message when 'should not be less than or equal comparison' failed` {
    val xs = Set(1, 2, 3).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be <= (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was less than or equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLessThanEqual(itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was less than or equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLessThanEqual(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `Set(1, 2, 3).par should throw TestFailedException with correct stack depth and message when 'should be greater than comparison' failed` {
    val xs = Set(1, 2, 3).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be > 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not greater than 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLessThanEqual(itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not greater than 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLessThanEqual(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `Set(1, 2, 3).par should throw TestFailedException with correct stack depth and message when 'should not be greater than comparison' failed` {
    val xs = Set(1, 2, 3).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be > (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was greater than 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementMoreThan(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `Set(1, 2, 3).par should throw TestFailedException with correct stack depth and message when 'should be greater than or equal comparison' failed` {
    val xs = Set(1, 2, 3).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be >= 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not greater than or equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLessThan(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `Set(1, 2, 3).par should throw TestFailedException with correct stack depth and message when 'should not be greater than or equal comparison' failed` {
    val xs = Set(1, 2, 3).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be >= (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was greater than or equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementMoreThanEqual(itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was greater than or equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementMoreThanEqual(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `Set(1, 2, 3).par should throw TestFailedException with correct stack depth and message when 'should be ===' failed` {
    val xs = Set(1, 2, 3).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be === 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `Set(1, 2, 3).par should throw TestFailedException with correct stack depth and message when 'should not be ===' failed` {
    val xs = Set(1, 2, 3).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be === (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `List(1, 2, 3).par should throw TestFailedException with correct stack depth and message when at least one element failed` {
    val xs = List(1, 2, 3).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should equal (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not equal 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not equal 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `List(1, 2, 3).par should throw TestFailedException with correct stack depth and message when 'should equal' failed` {
    val xs = List(1, 2, 3).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should equal (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not equal 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not equal 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `List(1, 2, 3).par should throw TestFailedException with correct stack depth and message when 'should not equal' failed` {
    val xs = List(1, 2, 3).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not equal 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} equaled 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `List(1, 2, 3).par should throw TestFailedException with correct stack depth and message when 'should be' failed` {
    val xs = List(1, 2, 3).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `List(1, 2, 3).par should throw TestFailedException with correct stack depth and message when 'should not be' failed` {
    val xs = List(1, 2, 3).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `List(1, 2, 3).par should throw TestFailedException with correct stack depth and message when 'should be less than comparison' failed` {
    val xs = List(1, 2, 3).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be < 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not less than 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementMoreThanEqual(itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not less than 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementMoreThanEqual(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `List(1, 2, 3).par should throw TestFailedException with correct stack depth and message when 'should not be less than comparison' failed` {
    val xs = List(1, 2, 3).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be < (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was less than 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLessThan(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `List(1, 2, 3).par should throw TestFailedException with correct stack depth and message when 'should be less than or equal comparison' failed` {
    val xs = List(1, 2, 3).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be <= 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not less than or equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementMoreThan(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `List(1, 2, 3).par should throw TestFailedException with correct stack depth and message when 'should not be less than or equal comparison' failed` {
    val xs = List(1, 2, 3).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be <= (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was less than or equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLessThanEqual(itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was less than or equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLessThanEqual(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `List(1, 2, 3).par should throw TestFailedException with correct stack depth and message when 'should be greater than comparison' failed` {
    val xs = List(1, 2, 3).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be > 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not greater than 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLessThanEqual(itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not greater than 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLessThanEqual(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `List(1, 2, 3).par should throw TestFailedException with correct stack depth and message when 'should not be greater than comparison' failed` {
    val xs = List(1, 2, 3).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be > (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was greater than 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementMoreThan(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `List(1, 2, 3).par should throw TestFailedException with correct stack depth and message when 'should be greater than or equal comparison' failed` {
    val xs = List(1, 2, 3).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be >= 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not greater than or equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLessThan(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `List(1, 2, 3).par should throw TestFailedException with correct stack depth and message when 'should not be greater than or equal comparison' failed` {
    val xs = List(1, 2, 3).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be >= (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was greater than or equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementMoreThanEqual(itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was greater than or equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementMoreThanEqual(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `List(1, 2, 3).par should throw TestFailedException with correct stack depth and message when 'should be ===' failed` {
    val xs = List(1, 2, 3).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be === 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `List(1, 2, 3).par should throw TestFailedException with correct stack depth and message when 'should not be ===' failed` {
    val xs = List(1, 2, 3).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be === (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `Seq(1, 2, 3).par should throw TestFailedException with correct stack depth and message when at least one element failed` {
    val xs = Seq(1, 2, 3).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should equal (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not equal 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not equal 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `Seq(1, 2, 3).par should throw TestFailedException with correct stack depth and message when 'should equal' failed` {
    val xs = Seq(1, 2, 3).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should equal (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not equal 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not equal 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `Seq(1, 2, 3).par should throw TestFailedException with correct stack depth and message when 'should not equal' failed` {
    val xs = Seq(1, 2, 3).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not equal 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} equaled 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `Seq(1, 2, 3).par should throw TestFailedException with correct stack depth and message when 'should be' failed` {
    val xs = Seq(1, 2, 3).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `Seq(1, 2, 3).par should throw TestFailedException with correct stack depth and message when 'should not be' failed` {
    val xs = Seq(1, 2, 3).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `Seq(1, 2, 3).par should throw TestFailedException with correct stack depth and message when 'should be less than comparison' failed` {
    val xs = Seq(1, 2, 3).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be < 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not less than 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementMoreThanEqual(itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not less than 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementMoreThanEqual(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `Seq(1, 2, 3).par should throw TestFailedException with correct stack depth and message when 'should not be less than comparison' failed` {
    val xs = Seq(1, 2, 3).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be < (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was less than 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLessThan(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `Seq(1, 2, 3).par should throw TestFailedException with correct stack depth and message when 'should be less than or equal comparison' failed` {
    val xs = Seq(1, 2, 3).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be <= 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not less than or equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementMoreThan(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `Seq(1, 2, 3).par should throw TestFailedException with correct stack depth and message when 'should not be less than or equal comparison' failed` {
    val xs = Seq(1, 2, 3).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be <= (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was less than or equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLessThanEqual(itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was less than or equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLessThanEqual(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `Seq(1, 2, 3).par should throw TestFailedException with correct stack depth and message when 'should be greater than comparison' failed` {
    val xs = Seq(1, 2, 3).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be > 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not greater than 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLessThanEqual(itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not greater than 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLessThanEqual(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `Seq(1, 2, 3).par should throw TestFailedException with correct stack depth and message when 'should not be greater than comparison' failed` {
    val xs = Seq(1, 2, 3).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be > (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was greater than 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementMoreThan(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `Seq(1, 2, 3).par should throw TestFailedException with correct stack depth and message when 'should be greater than or equal comparison' failed` {
    val xs = Seq(1, 2, 3).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be >= 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not greater than or equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLessThan(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `Seq(1, 2, 3).par should throw TestFailedException with correct stack depth and message when 'should not be greater than or equal comparison' failed` {
    val xs = Seq(1, 2, 3).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be >= (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was greater than or equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementMoreThanEqual(itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was greater than or equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementMoreThanEqual(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `Seq(1, 2, 3).par should throw TestFailedException with correct stack depth and message when 'should be ===' failed` {
    val xs = Seq(1, 2, 3).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be === 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `Seq(1, 2, 3).par should throw TestFailedException with correct stack depth and message when 'should not be ===' failed` {
    val xs = Seq(1, 2, 3).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be === (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `IndexedSeq(1, 2, 3).par should throw TestFailedException with correct stack depth and message when at least one element failed` {
    val xs = IndexedSeq(1, 2, 3).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should equal (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not equal 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not equal 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `IndexedSeq(1, 2, 3).par should throw TestFailedException with correct stack depth and message when 'should equal' failed` {
    val xs = IndexedSeq(1, 2, 3).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should equal (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not equal 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not equal 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `IndexedSeq(1, 2, 3).par should throw TestFailedException with correct stack depth and message when 'should not equal' failed` {
    val xs = IndexedSeq(1, 2, 3).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not equal 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} equaled 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `IndexedSeq(1, 2, 3).par should throw TestFailedException with correct stack depth and message when 'should be' failed` {
    val xs = IndexedSeq(1, 2, 3).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `IndexedSeq(1, 2, 3).par should throw TestFailedException with correct stack depth and message when 'should not be' failed` {
    val xs = IndexedSeq(1, 2, 3).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `IndexedSeq(1, 2, 3).par should throw TestFailedException with correct stack depth and message when 'should be less than comparison' failed` {
    val xs = IndexedSeq(1, 2, 3).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be < 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not less than 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementMoreThanEqual(itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not less than 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementMoreThanEqual(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `IndexedSeq(1, 2, 3).par should throw TestFailedException with correct stack depth and message when 'should not be less than comparison' failed` {
    val xs = IndexedSeq(1, 2, 3).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be < (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was less than 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLessThan(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `IndexedSeq(1, 2, 3).par should throw TestFailedException with correct stack depth and message when 'should be less than or equal comparison' failed` {
    val xs = IndexedSeq(1, 2, 3).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be <= 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not less than or equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementMoreThan(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `IndexedSeq(1, 2, 3).par should throw TestFailedException with correct stack depth and message when 'should not be less than or equal comparison' failed` {
    val xs = IndexedSeq(1, 2, 3).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be <= (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was less than or equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLessThanEqual(itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was less than or equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLessThanEqual(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `IndexedSeq(1, 2, 3).par should throw TestFailedException with correct stack depth and message when 'should be greater than comparison' failed` {
    val xs = IndexedSeq(1, 2, 3).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be > 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not greater than 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLessThanEqual(itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not greater than 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLessThanEqual(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `IndexedSeq(1, 2, 3).par should throw TestFailedException with correct stack depth and message when 'should not be greater than comparison' failed` {
    val xs = IndexedSeq(1, 2, 3).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be > (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was greater than 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementMoreThan(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `IndexedSeq(1, 2, 3).par should throw TestFailedException with correct stack depth and message when 'should be greater than or equal comparison' failed` {
    val xs = IndexedSeq(1, 2, 3).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be >= 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not greater than or equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLessThan(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `IndexedSeq(1, 2, 3).par should throw TestFailedException with correct stack depth and message when 'should not be greater than or equal comparison' failed` {
    val xs = IndexedSeq(1, 2, 3).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be >= (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was greater than or equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementMoreThanEqual(itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was greater than or equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementMoreThanEqual(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `IndexedSeq(1, 2, 3).par should throw TestFailedException with correct stack depth and message when 'should be ===' failed` {
    val xs = IndexedSeq(1, 2, 3).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be === 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `IndexedSeq(1, 2, 3).par should throw TestFailedException with correct stack depth and message when 'should not be ===' failed` {
    val xs = IndexedSeq(1, 2, 3).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be === (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Set(1, 2, 3) should throw TestFailedException with correct stack depth and message when at least one element failed` {
    val xs = collection.mutable.Set(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should equal (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not equal 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not equal 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Set(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should equal' failed` {
    val xs = collection.mutable.Set(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should equal (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not equal 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not equal 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Set(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should not equal' failed` {
    val xs = collection.mutable.Set(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not equal 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} equaled 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Set(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should be' failed` {
    val xs = collection.mutable.Set(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Set(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should not be' failed` {
    val xs = collection.mutable.Set(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Set(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should be less than comparison' failed` {
    val xs = collection.mutable.Set(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be < 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not less than 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementMoreThanEqual(itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not less than 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementMoreThanEqual(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Set(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should not be less than comparison' failed` {
    val xs = collection.mutable.Set(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be < (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was less than 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLessThan(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Set(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should be less than or equal comparison' failed` {
    val xs = collection.mutable.Set(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be <= 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not less than or equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementMoreThan(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Set(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should not be less than or equal comparison' failed` {
    val xs = collection.mutable.Set(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be <= (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was less than or equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLessThanEqual(itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was less than or equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLessThanEqual(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Set(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should be greater than comparison' failed` {
    val xs = collection.mutable.Set(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be > 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not greater than 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLessThanEqual(itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not greater than 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLessThanEqual(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Set(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should not be greater than comparison' failed` {
    val xs = collection.mutable.Set(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be > (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was greater than 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementMoreThan(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Set(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should be greater than or equal comparison' failed` {
    val xs = collection.mutable.Set(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be >= 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not greater than or equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLessThan(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Set(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should not be greater than or equal comparison' failed` {
    val xs = collection.mutable.Set(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be >= (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was greater than or equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementMoreThanEqual(itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was greater than or equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementMoreThanEqual(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Set(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should be ===' failed` {
    val xs = collection.mutable.Set(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be === 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Set(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should not be ===' failed` {
    val xs = collection.mutable.Set(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be === (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List(1, 2, 3) should throw TestFailedException with correct stack depth and message when at least one element failed` {
    val xs = new collection.mutable.ListBuffer() ++ List(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should equal (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not equal 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not equal 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should equal' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should equal (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not equal 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not equal 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should not equal' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not equal 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} equaled 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should be' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should not be' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should be less than comparison' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be < 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not less than 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementMoreThanEqual(itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not less than 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementMoreThanEqual(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should not be less than comparison' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be < (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was less than 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLessThan(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should be less than or equal comparison' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be <= 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not less than or equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementMoreThan(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should not be less than or equal comparison' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be <= (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was less than or equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLessThanEqual(itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was less than or equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLessThanEqual(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should be greater than comparison' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be > 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not greater than 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLessThanEqual(itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not greater than 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLessThanEqual(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should not be greater than comparison' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be > (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was greater than 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementMoreThan(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should be greater than or equal comparison' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be >= 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not greater than or equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLessThan(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should not be greater than or equal comparison' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be >= (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was greater than or equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementMoreThanEqual(itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was greater than or equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementMoreThanEqual(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should be ===' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be === 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should not be ===' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be === (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Seq(1, 2, 3) should throw TestFailedException with correct stack depth and message when at least one element failed` {
    val xs = collection.mutable.Seq(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should equal (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not equal 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not equal 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Seq(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should equal' failed` {
    val xs = collection.mutable.Seq(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should equal (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not equal 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not equal 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Seq(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should not equal' failed` {
    val xs = collection.mutable.Seq(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not equal 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} equaled 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Seq(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should be' failed` {
    val xs = collection.mutable.Seq(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Seq(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should not be' failed` {
    val xs = collection.mutable.Seq(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Seq(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should be less than comparison' failed` {
    val xs = collection.mutable.Seq(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be < 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not less than 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementMoreThanEqual(itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not less than 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementMoreThanEqual(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Seq(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should not be less than comparison' failed` {
    val xs = collection.mutable.Seq(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be < (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was less than 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLessThan(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Seq(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should be less than or equal comparison' failed` {
    val xs = collection.mutable.Seq(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be <= 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not less than or equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementMoreThan(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Seq(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should not be less than or equal comparison' failed` {
    val xs = collection.mutable.Seq(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be <= (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was less than or equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLessThanEqual(itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was less than or equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLessThanEqual(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Seq(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should be greater than comparison' failed` {
    val xs = collection.mutable.Seq(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be > 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not greater than 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLessThanEqual(itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not greater than 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLessThanEqual(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Seq(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should not be greater than comparison' failed` {
    val xs = collection.mutable.Seq(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be > (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was greater than 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementMoreThan(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Seq(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should be greater than or equal comparison' failed` {
    val xs = collection.mutable.Seq(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be >= 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not greater than or equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLessThan(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Seq(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should not be greater than or equal comparison' failed` {
    val xs = collection.mutable.Seq(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be >= (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was greater than or equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementMoreThanEqual(itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was greater than or equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementMoreThanEqual(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Seq(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should be ===' failed` {
    val xs = collection.mutable.Seq(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be === 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Seq(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should not be ===' failed` {
    val xs = collection.mutable.Seq(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be === (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.IndexedSeq(1, 2, 3) should throw TestFailedException with correct stack depth and message when at least one element failed` {
    val xs = collection.mutable.IndexedSeq(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should equal (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not equal 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not equal 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.IndexedSeq(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should equal' failed` {
    val xs = collection.mutable.IndexedSeq(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should equal (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not equal 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not equal 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.IndexedSeq(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should not equal' failed` {
    val xs = collection.mutable.IndexedSeq(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not equal 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} equaled 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.IndexedSeq(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should be' failed` {
    val xs = collection.mutable.IndexedSeq(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.IndexedSeq(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should not be' failed` {
    val xs = collection.mutable.IndexedSeq(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.IndexedSeq(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should be less than comparison' failed` {
    val xs = collection.mutable.IndexedSeq(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be < 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not less than 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementMoreThanEqual(itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not less than 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementMoreThanEqual(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.IndexedSeq(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should not be less than comparison' failed` {
    val xs = collection.mutable.IndexedSeq(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be < (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was less than 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLessThan(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.IndexedSeq(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should be less than or equal comparison' failed` {
    val xs = collection.mutable.IndexedSeq(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be <= 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not less than or equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementMoreThan(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.IndexedSeq(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should not be less than or equal comparison' failed` {
    val xs = collection.mutable.IndexedSeq(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be <= (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was less than or equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLessThanEqual(itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was less than or equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLessThanEqual(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.IndexedSeq(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should be greater than comparison' failed` {
    val xs = collection.mutable.IndexedSeq(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be > 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not greater than 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLessThanEqual(itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not greater than 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLessThanEqual(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.IndexedSeq(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should not be greater than comparison' failed` {
    val xs = collection.mutable.IndexedSeq(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be > (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was greater than 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementMoreThan(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.IndexedSeq(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should be greater than or equal comparison' failed` {
    val xs = collection.mutable.IndexedSeq(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be >= 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not greater than or equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLessThan(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.IndexedSeq(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should not be greater than or equal comparison' failed` {
    val xs = collection.mutable.IndexedSeq(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be >= (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was greater than or equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementMoreThanEqual(itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was greater than or equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementMoreThanEqual(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.IndexedSeq(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should be ===' failed` {
    val xs = collection.mutable.IndexedSeq(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be === 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.IndexedSeq(1, 2, 3) should throw TestFailedException with correct stack depth and message when 'should not be ===' failed` {
    val xs = collection.mutable.IndexedSeq(1, 2, 3)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be === (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Set(1, 2, 3).par should throw TestFailedException with correct stack depth and message when at least one element failed` {
    val xs = collection.mutable.Set(1, 2, 3).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should equal (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not equal 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not equal 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Set(1, 2, 3).par should throw TestFailedException with correct stack depth and message when 'should equal' failed` {
    val xs = collection.mutable.Set(1, 2, 3).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should equal (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not equal 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not equal 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Set(1, 2, 3).par should throw TestFailedException with correct stack depth and message when 'should not equal' failed` {
    val xs = collection.mutable.Set(1, 2, 3).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not equal 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} equaled 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Set(1, 2, 3).par should throw TestFailedException with correct stack depth and message when 'should be' failed` {
    val xs = collection.mutable.Set(1, 2, 3).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Set(1, 2, 3).par should throw TestFailedException with correct stack depth and message when 'should not be' failed` {
    val xs = collection.mutable.Set(1, 2, 3).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Set(1, 2, 3).par should throw TestFailedException with correct stack depth and message when 'should be less than comparison' failed` {
    val xs = collection.mutable.Set(1, 2, 3).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be < 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not less than 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementMoreThanEqual(itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not less than 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementMoreThanEqual(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Set(1, 2, 3).par should throw TestFailedException with correct stack depth and message when 'should not be less than comparison' failed` {
    val xs = collection.mutable.Set(1, 2, 3).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be < (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was less than 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLessThan(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Set(1, 2, 3).par should throw TestFailedException with correct stack depth and message when 'should be less than or equal comparison' failed` {
    val xs = collection.mutable.Set(1, 2, 3).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be <= 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not less than or equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementMoreThan(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Set(1, 2, 3).par should throw TestFailedException with correct stack depth and message when 'should not be less than or equal comparison' failed` {
    val xs = collection.mutable.Set(1, 2, 3).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be <= (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was less than or equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLessThanEqual(itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was less than or equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLessThanEqual(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Set(1, 2, 3).par should throw TestFailedException with correct stack depth and message when 'should be greater than comparison' failed` {
    val xs = collection.mutable.Set(1, 2, 3).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be > 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not greater than 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLessThanEqual(itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not greater than 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLessThanEqual(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Set(1, 2, 3).par should throw TestFailedException with correct stack depth and message when 'should not be greater than comparison' failed` {
    val xs = collection.mutable.Set(1, 2, 3).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be > (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was greater than 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementMoreThan(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Set(1, 2, 3).par should throw TestFailedException with correct stack depth and message when 'should be greater than or equal comparison' failed` {
    val xs = collection.mutable.Set(1, 2, 3).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be >= 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not greater than or equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLessThan(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Set(1, 2, 3).par should throw TestFailedException with correct stack depth and message when 'should not be greater than or equal comparison' failed` {
    val xs = collection.mutable.Set(1, 2, 3).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be >= (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was greater than or equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementMoreThanEqual(itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was greater than or equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementMoreThanEqual(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Set(1, 2, 3).par should throw TestFailedException with correct stack depth and message when 'should be ===' failed` {
    val xs = collection.mutable.Set(1, 2, 3).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be === 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Set(1, 2, 3).par should throw TestFailedException with correct stack depth and message when 'should not be ===' failed` {
    val xs = collection.mutable.Set(1, 2, 3).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be === (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List(1, 2, 3)).par should throw TestFailedException with correct stack depth and message when at least one element failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List(1, 2, 3)).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should equal (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not equal 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not equal 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List(1, 2, 3)).par should throw TestFailedException with correct stack depth and message when 'should equal' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List(1, 2, 3)).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should equal (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not equal 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not equal 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List(1, 2, 3)).par should throw TestFailedException with correct stack depth and message when 'should not equal' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List(1, 2, 3)).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not equal 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} equaled 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List(1, 2, 3)).par should throw TestFailedException with correct stack depth and message when 'should be' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List(1, 2, 3)).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List(1, 2, 3)).par should throw TestFailedException with correct stack depth and message when 'should not be' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List(1, 2, 3)).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List(1, 2, 3)).par should throw TestFailedException with correct stack depth and message when 'should be less than comparison' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List(1, 2, 3)).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be < 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not less than 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementMoreThanEqual(itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not less than 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementMoreThanEqual(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List(1, 2, 3)).par should throw TestFailedException with correct stack depth and message when 'should not be less than comparison' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List(1, 2, 3)).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be < (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was less than 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLessThan(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List(1, 2, 3)).par should throw TestFailedException with correct stack depth and message when 'should be less than or equal comparison' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List(1, 2, 3)).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be <= 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not less than or equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementMoreThan(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List(1, 2, 3)).par should throw TestFailedException with correct stack depth and message when 'should not be less than or equal comparison' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List(1, 2, 3)).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be <= (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was less than or equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLessThanEqual(itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was less than or equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLessThanEqual(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List(1, 2, 3)).par should throw TestFailedException with correct stack depth and message when 'should be greater than comparison' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List(1, 2, 3)).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be > 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not greater than 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLessThanEqual(itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not greater than 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLessThanEqual(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List(1, 2, 3)).par should throw TestFailedException with correct stack depth and message when 'should not be greater than comparison' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List(1, 2, 3)).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be > (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was greater than 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementMoreThan(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List(1, 2, 3)).par should throw TestFailedException with correct stack depth and message when 'should be greater than or equal comparison' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List(1, 2, 3)).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be >= 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not greater than or equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLessThan(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List(1, 2, 3)).par should throw TestFailedException with correct stack depth and message when 'should not be greater than or equal comparison' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List(1, 2, 3)).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be >= (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was greater than or equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementMoreThanEqual(itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was greater than or equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementMoreThanEqual(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List(1, 2, 3)).par should throw TestFailedException with correct stack depth and message when 'should be ===' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List(1, 2, 3)).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be === 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List(1, 2, 3)).par should throw TestFailedException with correct stack depth and message when 'should not be ===' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List(1, 2, 3)).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be === (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Seq(1, 2, 3).par should throw TestFailedException with correct stack depth and message when at least one element failed` {
    val xs = collection.mutable.Seq(1, 2, 3).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should equal (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not equal 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not equal 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Seq(1, 2, 3).par should throw TestFailedException with correct stack depth and message when 'should equal' failed` {
    val xs = collection.mutable.Seq(1, 2, 3).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should equal (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not equal 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not equal 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Seq(1, 2, 3).par should throw TestFailedException with correct stack depth and message when 'should not equal' failed` {
    val xs = collection.mutable.Seq(1, 2, 3).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not equal 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} equaled 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Seq(1, 2, 3).par should throw TestFailedException with correct stack depth and message when 'should be' failed` {
    val xs = collection.mutable.Seq(1, 2, 3).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Seq(1, 2, 3).par should throw TestFailedException with correct stack depth and message when 'should not be' failed` {
    val xs = collection.mutable.Seq(1, 2, 3).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Seq(1, 2, 3).par should throw TestFailedException with correct stack depth and message when 'should be less than comparison' failed` {
    val xs = collection.mutable.Seq(1, 2, 3).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be < 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not less than 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementMoreThanEqual(itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not less than 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementMoreThanEqual(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Seq(1, 2, 3).par should throw TestFailedException with correct stack depth and message when 'should not be less than comparison' failed` {
    val xs = collection.mutable.Seq(1, 2, 3).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be < (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was less than 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLessThan(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Seq(1, 2, 3).par should throw TestFailedException with correct stack depth and message when 'should be less than or equal comparison' failed` {
    val xs = collection.mutable.Seq(1, 2, 3).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be <= 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not less than or equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementMoreThan(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Seq(1, 2, 3).par should throw TestFailedException with correct stack depth and message when 'should not be less than or equal comparison' failed` {
    val xs = collection.mutable.Seq(1, 2, 3).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be <= (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was less than or equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLessThanEqual(itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was less than or equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLessThanEqual(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Seq(1, 2, 3).par should throw TestFailedException with correct stack depth and message when 'should be greater than comparison' failed` {
    val xs = collection.mutable.Seq(1, 2, 3).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be > 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not greater than 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLessThanEqual(itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not greater than 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLessThanEqual(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Seq(1, 2, 3).par should throw TestFailedException with correct stack depth and message when 'should not be greater than comparison' failed` {
    val xs = collection.mutable.Seq(1, 2, 3).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be > (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was greater than 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementMoreThan(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Seq(1, 2, 3).par should throw TestFailedException with correct stack depth and message when 'should be greater than or equal comparison' failed` {
    val xs = collection.mutable.Seq(1, 2, 3).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be >= 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not greater than or equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLessThan(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Seq(1, 2, 3).par should throw TestFailedException with correct stack depth and message when 'should not be greater than or equal comparison' failed` {
    val xs = collection.mutable.Seq(1, 2, 3).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be >= (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was greater than or equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementMoreThanEqual(itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was greater than or equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementMoreThanEqual(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Seq(1, 2, 3).par should throw TestFailedException with correct stack depth and message when 'should be ===' failed` {
    val xs = collection.mutable.Seq(1, 2, 3).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be === 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Seq(1, 2, 3).par should throw TestFailedException with correct stack depth and message when 'should not be ===' failed` {
    val xs = collection.mutable.Seq(1, 2, 3).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be === (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.IndexedSeq(1, 2, 3).par should throw TestFailedException with correct stack depth and message when at least one element failed` {
    val xs = collection.mutable.IndexedSeq(1, 2, 3).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should equal (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not equal 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not equal 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.IndexedSeq(1, 2, 3).par should throw TestFailedException with correct stack depth and message when 'should equal' failed` {
    val xs = collection.mutable.IndexedSeq(1, 2, 3).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should equal (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not equal 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not equal 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.IndexedSeq(1, 2, 3).par should throw TestFailedException with correct stack depth and message when 'should not equal' failed` {
    val xs = collection.mutable.IndexedSeq(1, 2, 3).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not equal 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} equaled 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.IndexedSeq(1, 2, 3).par should throw TestFailedException with correct stack depth and message when 'should be' failed` {
    val xs = collection.mutable.IndexedSeq(1, 2, 3).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.IndexedSeq(1, 2, 3).par should throw TestFailedException with correct stack depth and message when 'should not be' failed` {
    val xs = collection.mutable.IndexedSeq(1, 2, 3).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.IndexedSeq(1, 2, 3).par should throw TestFailedException with correct stack depth and message when 'should be less than comparison' failed` {
    val xs = collection.mutable.IndexedSeq(1, 2, 3).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be < 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not less than 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementMoreThanEqual(itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not less than 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementMoreThanEqual(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.IndexedSeq(1, 2, 3).par should throw TestFailedException with correct stack depth and message when 'should not be less than comparison' failed` {
    val xs = collection.mutable.IndexedSeq(1, 2, 3).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be < (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was less than 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLessThan(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.IndexedSeq(1, 2, 3).par should throw TestFailedException with correct stack depth and message when 'should be less than or equal comparison' failed` {
    val xs = collection.mutable.IndexedSeq(1, 2, 3).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be <= 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not less than or equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementMoreThan(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.IndexedSeq(1, 2, 3).par should throw TestFailedException with correct stack depth and message when 'should not be less than or equal comparison' failed` {
    val xs = collection.mutable.IndexedSeq(1, 2, 3).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be <= (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was less than or equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLessThanEqual(itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was less than or equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLessThanEqual(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.IndexedSeq(1, 2, 3).par should throw TestFailedException with correct stack depth and message when 'should be greater than comparison' failed` {
    val xs = collection.mutable.IndexedSeq(1, 2, 3).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be > 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not greater than 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLessThanEqual(itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not greater than 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLessThanEqual(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.IndexedSeq(1, 2, 3).par should throw TestFailedException with correct stack depth and message when 'should not be greater than comparison' failed` {
    val xs = collection.mutable.IndexedSeq(1, 2, 3).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be > (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was greater than 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementMoreThan(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.IndexedSeq(1, 2, 3).par should throw TestFailedException with correct stack depth and message when 'should be greater than or equal comparison' failed` {
    val xs = collection.mutable.IndexedSeq(1, 2, 3).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be >= 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not greater than or equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLessThan(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.IndexedSeq(1, 2, 3).par should throw TestFailedException with correct stack depth and message when 'should not be greater than or equal comparison' failed` {
    val xs = collection.mutable.IndexedSeq(1, 2, 3).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be >= (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was greater than or equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementMoreThanEqual(itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was greater than or equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementMoreThanEqual(itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.IndexedSeq(1, 2, 3).par should throw TestFailedException with correct stack depth and message when 'should be ===' failed` {
    val xs = collection.mutable.IndexedSeq(1, 2, 3).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be === 2
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was not equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.IndexedSeq(1, 2, 3).par should throw TestFailedException with correct stack depth and message when 'should not be ===' failed` {
    val xs = collection.mutable.IndexedSeq(1, 2, 3).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be === (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} was equal to 2 (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementEqual[Int](itr, xs, 2)) + " \n" + 
  "in " + xs)
  }
  def `Set("1", null, "3") should throw TestFailedException with correct stack depth and message when 'should be null' failed` {
    val xs = Set("1", null, "3")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be (null)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not null (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[String](itr, xs, null)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not null (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[String](itr, xs, null)) + " \n" + 
  "in " + xs)
  }
  def `Set("1", null, "3") should throw TestFailedException with correct stack depth and message when 'should not be null' failed` {
    val xs = Set("1", null, "3")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be null
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, The reference was null (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementEqual[String](itr, xs, null)) + " \n" + 
  "in " + xs)
  }
  def `List("1", null, "3") should throw TestFailedException with correct stack depth and message when 'should be null' failed` {
    val xs = List("1", null, "3")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be (null)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not null (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[String](itr, xs, null)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not null (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[String](itr, xs, null)) + " \n" + 
  "in " + xs)
  }
  def `List("1", null, "3") should throw TestFailedException with correct stack depth and message when 'should not be null' failed` {
    val xs = List("1", null, "3")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be null
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, The reference was null (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementEqual[String](itr, xs, null)) + " \n" + 
  "in " + xs)
  }
  def `Seq("1", null, "3") should throw TestFailedException with correct stack depth and message when 'should be null' failed` {
    val xs = Seq("1", null, "3")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be (null)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not null (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[String](itr, xs, null)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not null (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[String](itr, xs, null)) + " \n" + 
  "in " + xs)
  }
  def `Seq("1", null, "3") should throw TestFailedException with correct stack depth and message when 'should not be null' failed` {
    val xs = Seq("1", null, "3")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be null
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, The reference was null (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementEqual[String](itr, xs, null)) + " \n" + 
  "in " + xs)
  }
  def `Array("1", null, "3") should throw TestFailedException with correct stack depth and message when 'should be null' failed` {
    val xs = Array("1", null, "3")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be (null)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not null (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[String](itr, xs, null)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not null (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[String](itr, xs, null)) + " \n" + 
  "in " + "WrappedArray(1, null, 3)")
  }
  def `Array("1", null, "3") should throw TestFailedException with correct stack depth and message when 'should not be null' failed` {
    val xs = Array("1", null, "3")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be null
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, The reference was null (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementEqual[String](itr, xs, null)) + " \n" + 
  "in " + "WrappedArray(1, null, 3)")
  }
  def `IndexedSeq("1", null, "3") should throw TestFailedException with correct stack depth and message when 'should be null' failed` {
    val xs = IndexedSeq("1", null, "3")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be (null)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not null (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[String](itr, xs, null)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not null (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[String](itr, xs, null)) + " \n" + 
  "in " + xs)
  }
  def `IndexedSeq("1", null, "3") should throw TestFailedException with correct stack depth and message when 'should not be null' failed` {
    val xs = IndexedSeq("1", null, "3")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be null
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, The reference was null (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementEqual[String](itr, xs, null)) + " \n" + 
  "in " + xs)
  }
  def `Vector("1", null, "3") should throw TestFailedException with correct stack depth and message when 'should be null' failed` {
    val xs = Vector("1", null, "3")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be (null)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not null (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[String](itr, xs, null)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not null (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[String](itr, xs, null)) + " \n" + 
  "in " + xs)
  }
  def `Vector("1", null, "3") should throw TestFailedException with correct stack depth and message when 'should not be null' failed` {
    val xs = Vector("1", null, "3")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be null
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, The reference was null (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementEqual[String](itr, xs, null)) + " \n" + 
  "in " + xs)
  }
  def `Set("1", null, "3").par should throw TestFailedException with correct stack depth and message when 'should be null' failed` {
    val xs = Set("1", null, "3").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be (null)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not null (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[String](itr, xs, null)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not null (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[String](itr, xs, null)) + " \n" + 
  "in " + xs)
  }
  def `Set("1", null, "3").par should throw TestFailedException with correct stack depth and message when 'should not be null' failed` {
    val xs = Set("1", null, "3").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be null
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, The reference was null (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementEqual[String](itr, xs, null)) + " \n" + 
  "in " + xs)
  }
  def `List("1", null, "3").par should throw TestFailedException with correct stack depth and message when 'should be null' failed` {
    val xs = List("1", null, "3").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be (null)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not null (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[String](itr, xs, null)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not null (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[String](itr, xs, null)) + " \n" + 
  "in " + xs)
  }
  def `List("1", null, "3").par should throw TestFailedException with correct stack depth and message when 'should not be null' failed` {
    val xs = List("1", null, "3").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be null
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, The reference was null (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementEqual[String](itr, xs, null)) + " \n" + 
  "in " + xs)
  }
  def `Seq("1", null, "3").par should throw TestFailedException with correct stack depth and message when 'should be null' failed` {
    val xs = Seq("1", null, "3").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be (null)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not null (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[String](itr, xs, null)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not null (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[String](itr, xs, null)) + " \n" + 
  "in " + xs)
  }
  def `Seq("1", null, "3").par should throw TestFailedException with correct stack depth and message when 'should not be null' failed` {
    val xs = Seq("1", null, "3").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be null
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, The reference was null (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementEqual[String](itr, xs, null)) + " \n" + 
  "in " + xs)
  }
  def `IndexedSeq("1", null, "3").par should throw TestFailedException with correct stack depth and message when 'should be null' failed` {
    val xs = IndexedSeq("1", null, "3").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be (null)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not null (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[String](itr, xs, null)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not null (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[String](itr, xs, null)) + " \n" + 
  "in " + xs)
  }
  def `IndexedSeq("1", null, "3").par should throw TestFailedException with correct stack depth and message when 'should not be null' failed` {
    val xs = IndexedSeq("1", null, "3").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be null
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, The reference was null (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementEqual[String](itr, xs, null)) + " \n" + 
  "in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List("1", null, "3") should throw TestFailedException with correct stack depth and message when 'should be null' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List("1", null, "3")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be (null)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not null (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[String](itr, xs, null)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not null (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[String](itr, xs, null)) + " \n" + 
  "in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List("1", null, "3") should throw TestFailedException with correct stack depth and message when 'should not be null' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List("1", null, "3")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be null
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, The reference was null (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementEqual[String](itr, xs, null)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Seq("1", null, "3") should throw TestFailedException with correct stack depth and message when 'should be null' failed` {
    val xs = collection.mutable.Seq("1", null, "3")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be (null)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not null (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[String](itr, xs, null)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not null (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[String](itr, xs, null)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Seq("1", null, "3") should throw TestFailedException with correct stack depth and message when 'should not be null' failed` {
    val xs = collection.mutable.Seq("1", null, "3")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be null
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, The reference was null (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementEqual[String](itr, xs, null)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.IndexedSeq("1", null, "3") should throw TestFailedException with correct stack depth and message when 'should be null' failed` {
    val xs = collection.mutable.IndexedSeq("1", null, "3")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be (null)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not null (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[String](itr, xs, null)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not null (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[String](itr, xs, null)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.IndexedSeq("1", null, "3") should throw TestFailedException with correct stack depth and message when 'should not be null' failed` {
    val xs = collection.mutable.IndexedSeq("1", null, "3")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be null
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, The reference was null (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementEqual[String](itr, xs, null)) + " \n" + 
  "in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List("1", null, "3")).par should throw TestFailedException with correct stack depth and message when 'should be null' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List("1", null, "3")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be (null)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not null (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[String](itr, xs, null)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not null (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[String](itr, xs, null)) + " \n" + 
  "in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List("1", null, "3")).par should throw TestFailedException with correct stack depth and message when 'should not be null' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List("1", null, "3")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be null
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, The reference was null (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementEqual[String](itr, xs, null)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Seq("1", null, "3").par should throw TestFailedException with correct stack depth and message when 'should be null' failed` {
    val xs = collection.mutable.Seq("1", null, "3").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be (null)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not null (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[String](itr, xs, null)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not null (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[String](itr, xs, null)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Seq("1", null, "3").par should throw TestFailedException with correct stack depth and message when 'should not be null' failed` {
    val xs = collection.mutable.Seq("1", null, "3").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be null
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, The reference was null (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementEqual[String](itr, xs, null)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.IndexedSeq("1", null, "3").par should throw TestFailedException with correct stack depth and message when 'should be null' failed` {
    val xs = collection.mutable.IndexedSeq("1", null, "3").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be (null)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not null (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[String](itr, xs, null)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not null (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementNotEqual[String](itr, xs, null)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.IndexedSeq("1", null, "3").par should throw TestFailedException with correct stack depth and message when 'should not be null' failed` {
    val xs = collection.mutable.IndexedSeq("1", null, "3").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be null
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, The reference was null (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementEqual[String](itr, xs, null)) + " \n" + 
  "in " + xs)
  }
  def `Set("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should be symbol' failed` {
    val xs = Set("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be ('empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `Set("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should not be symbol' failed` {
    val xs = Set("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `Set("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should be property' failed` {
    val xs = Set("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be (empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `Set("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should not be property' failed` {
    val xs = Set("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `Set("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should be a symbol' failed` {
    val xs = Set("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be a 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not a empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not a empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `Set("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should not be a symbol' failed` {
    val xs = Set("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be a ('empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was a empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `Set("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should be a property' failed` {
    val xs = Set("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be a empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not a empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not a empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `Set("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should not be a property' failed` {
    val xs = Set("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be a (empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was a empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `Set("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should be an symbol' failed` {
    val xs = Set("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be an 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not an empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not an empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `Set("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should not be an symbol' failed` {
    val xs = Set("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be an ('empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was an empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `Set("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should be an property' failed` {
    val xs = Set("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be an empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not an empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not an empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `Set("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should not be an property' failed` {
    val xs = Set("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be an (empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was an empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `Set("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should have property' failed` {
    val xs = Set("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should have (plength(0))
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, The length property had value {1}, instead of its expected value 0, on object \"{2}\" (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLengthNotEqualLength(itr, xs, 0)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, The length property had value {1}, instead of its expected value 0, on object \"{2}\" (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLengthNotEqualLength(itr, xs, 0)) + " \n" + 
  "in " + xs)
  }
  def `Set("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should not have property' failed` {
    val xs = Set("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not have plength(0)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, The length property had its expected value 0, on object \"{1}\" (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLengthEqual(itr, xs, 0)) + " \n" + 
  "in " + xs)
  }
  def `List("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should be symbol' failed` {
    val xs = List("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be ('empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `List("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should not be symbol' failed` {
    val xs = List("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `List("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should be property' failed` {
    val xs = List("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be (empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `List("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should not be property' failed` {
    val xs = List("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `List("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should be a symbol' failed` {
    val xs = List("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be a 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not a empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not a empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `List("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should not be a symbol' failed` {
    val xs = List("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be a ('empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was a empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `List("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should be a property' failed` {
    val xs = List("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be a empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not a empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not a empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `List("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should not be a property' failed` {
    val xs = List("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be a (empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was a empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `List("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should be an symbol' failed` {
    val xs = List("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be an 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not an empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not an empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `List("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should not be an symbol' failed` {
    val xs = List("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be an ('empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was an empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `List("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should be an property' failed` {
    val xs = List("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be an empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not an empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not an empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `List("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should not be an property' failed` {
    val xs = List("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be an (empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was an empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `List("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should have property' failed` {
    val xs = List("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should have (plength(0))
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, The length property had value {1}, instead of its expected value 0, on object \"{2}\" (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLengthNotEqualLength(itr, xs, 0)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, The length property had value {1}, instead of its expected value 0, on object \"{2}\" (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLengthNotEqualLength(itr, xs, 0)) + " \n" + 
  "in " + xs)
  }
  def `List("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should not have property' failed` {
    val xs = List("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not have plength(0)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, The length property had its expected value 0, on object \"{1}\" (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLengthEqual(itr, xs, 0)) + " \n" + 
  "in " + xs)
  }
  def `Seq("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should be symbol' failed` {
    val xs = Seq("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be ('empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `Seq("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should not be symbol' failed` {
    val xs = Seq("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `Seq("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should be property' failed` {
    val xs = Seq("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be (empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `Seq("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should not be property' failed` {
    val xs = Seq("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `Seq("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should be a symbol' failed` {
    val xs = Seq("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be a 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not a empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not a empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `Seq("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should not be a symbol' failed` {
    val xs = Seq("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be a ('empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was a empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `Seq("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should be a property' failed` {
    val xs = Seq("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be a empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not a empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not a empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `Seq("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should not be a property' failed` {
    val xs = Seq("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be a (empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was a empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `Seq("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should be an symbol' failed` {
    val xs = Seq("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be an 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not an empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not an empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `Seq("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should not be an symbol' failed` {
    val xs = Seq("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be an ('empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was an empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `Seq("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should be an property' failed` {
    val xs = Seq("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be an empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not an empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not an empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `Seq("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should not be an property' failed` {
    val xs = Seq("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be an (empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was an empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `Seq("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should have property' failed` {
    val xs = Seq("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should have (plength(0))
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, The length property had value {1}, instead of its expected value 0, on object \"{2}\" (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLengthNotEqualLength(itr, xs, 0)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, The length property had value {1}, instead of its expected value 0, on object \"{2}\" (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLengthNotEqualLength(itr, xs, 0)) + " \n" + 
  "in " + xs)
  }
  def `Seq("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should not have property' failed` {
    val xs = Seq("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not have plength(0)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, The length property had its expected value 0, on object \"{1}\" (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLengthEqual(itr, xs, 0)) + " \n" + 
  "in " + xs)
  }
  def `Array("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should be symbol' failed` {
    val xs = Array("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be ('empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + " \n" + 
  "in " + "WrappedArray(, boom!, hi)")
  }
  def `Array("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should not be symbol' failed` {
    val xs = Array("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsEmpty(itr, xs, "")) + " \n" + 
  "in " + "WrappedArray(, boom!, hi)")
  }
  def `Array("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should be property' failed` {
    val xs = Array("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be (empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + " \n" + 
  "in " + "WrappedArray(, boom!, hi)")
  }
  def `Array("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should not be property' failed` {
    val xs = Array("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsEmpty(itr, xs, "")) + " \n" + 
  "in " + "WrappedArray(, boom!, hi)")
  }
  def `Array("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should be a symbol' failed` {
    val xs = Array("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be a 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not a empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not a empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + " \n" + 
  "in " + "WrappedArray(, boom!, hi)")
  }
  def `Array("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should not be a symbol' failed` {
    val xs = Array("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be a ('empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was a empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsEmpty(itr, xs, "")) + " \n" + 
  "in " + "WrappedArray(, boom!, hi)")
  }
  def `Array("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should be a property' failed` {
    val xs = Array("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be a empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not a empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not a empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + " \n" + 
  "in " + "WrappedArray(, boom!, hi)")
  }
  def `Array("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should not be a property' failed` {
    val xs = Array("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be a (empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was a empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsEmpty(itr, xs, "")) + " \n" + 
  "in " + "WrappedArray(, boom!, hi)")
  }
  def `Array("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should be an symbol' failed` {
    val xs = Array("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be an 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not an empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not an empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + " \n" + 
  "in " + "WrappedArray(, boom!, hi)")
  }
  def `Array("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should not be an symbol' failed` {
    val xs = Array("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be an ('empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was an empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsEmpty(itr, xs, "")) + " \n" + 
  "in " + "WrappedArray(, boom!, hi)")
  }
  def `Array("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should be an property' failed` {
    val xs = Array("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be an empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not an empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not an empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + " \n" + 
  "in " + "WrappedArray(, boom!, hi)")
  }
  def `Array("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should not be an property' failed` {
    val xs = Array("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be an (empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was an empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsEmpty(itr, xs, "")) + " \n" + 
  "in " + "WrappedArray(, boom!, hi)")
  }
  def `Array("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should have property' failed` {
    val xs = Array("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should have (plength(0))
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, The length property had value {1}, instead of its expected value 0, on object \"{2}\" (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLengthNotEqualLength(itr, xs, 0)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, The length property had value {1}, instead of its expected value 0, on object \"{2}\" (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLengthNotEqualLength(itr, xs, 0)) + " \n" + 
  "in " + "WrappedArray(, boom!, hi)")
  }
  def `Array("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should not have property' failed` {
    val xs = Array("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not have plength(0)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, The length property had its expected value 0, on object \"{1}\" (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLengthEqual(itr, xs, 0)) + " \n" + 
  "in " + "WrappedArray(, boom!, hi)")
  }
  def `IndexedSeq("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should be symbol' failed` {
    val xs = IndexedSeq("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be ('empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `IndexedSeq("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should not be symbol' failed` {
    val xs = IndexedSeq("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `IndexedSeq("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should be property' failed` {
    val xs = IndexedSeq("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be (empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `IndexedSeq("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should not be property' failed` {
    val xs = IndexedSeq("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `IndexedSeq("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should be a symbol' failed` {
    val xs = IndexedSeq("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be a 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not a empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not a empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `IndexedSeq("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should not be a symbol' failed` {
    val xs = IndexedSeq("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be a ('empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was a empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `IndexedSeq("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should be a property' failed` {
    val xs = IndexedSeq("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be a empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not a empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not a empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `IndexedSeq("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should not be a property' failed` {
    val xs = IndexedSeq("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be a (empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was a empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `IndexedSeq("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should be an symbol' failed` {
    val xs = IndexedSeq("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be an 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not an empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not an empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `IndexedSeq("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should not be an symbol' failed` {
    val xs = IndexedSeq("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be an ('empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was an empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `IndexedSeq("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should be an property' failed` {
    val xs = IndexedSeq("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be an empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not an empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not an empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `IndexedSeq("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should not be an property' failed` {
    val xs = IndexedSeq("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be an (empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was an empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `IndexedSeq("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should have property' failed` {
    val xs = IndexedSeq("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should have (plength(0))
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, The length property had value {1}, instead of its expected value 0, on object \"{2}\" (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLengthNotEqualLength(itr, xs, 0)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, The length property had value {1}, instead of its expected value 0, on object \"{2}\" (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLengthNotEqualLength(itr, xs, 0)) + " \n" + 
  "in " + xs)
  }
  def `IndexedSeq("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should not have property' failed` {
    val xs = IndexedSeq("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not have plength(0)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, The length property had its expected value 0, on object \"{1}\" (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLengthEqual(itr, xs, 0)) + " \n" + 
  "in " + xs)
  }
  def `Vector("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should be symbol' failed` {
    val xs = Vector("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be ('empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `Vector("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should not be symbol' failed` {
    val xs = Vector("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `Vector("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should be property' failed` {
    val xs = Vector("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be (empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `Vector("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should not be property' failed` {
    val xs = Vector("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `Vector("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should be a symbol' failed` {
    val xs = Vector("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be a 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not a empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not a empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `Vector("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should not be a symbol' failed` {
    val xs = Vector("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be a ('empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was a empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `Vector("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should be a property' failed` {
    val xs = Vector("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be a empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not a empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not a empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `Vector("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should not be a property' failed` {
    val xs = Vector("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be a (empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was a empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `Vector("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should be an symbol' failed` {
    val xs = Vector("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be an 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not an empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not an empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `Vector("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should not be an symbol' failed` {
    val xs = Vector("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be an ('empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was an empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `Vector("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should be an property' failed` {
    val xs = Vector("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be an empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not an empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not an empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `Vector("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should not be an property' failed` {
    val xs = Vector("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be an (empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was an empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `Vector("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should have property' failed` {
    val xs = Vector("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should have (plength(0))
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, The length property had value {1}, instead of its expected value 0, on object \"{2}\" (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLengthNotEqualLength(itr, xs, 0)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, The length property had value {1}, instead of its expected value 0, on object \"{2}\" (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLengthNotEqualLength(itr, xs, 0)) + " \n" + 
  "in " + xs)
  }
  def `Vector("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should not have property' failed` {
    val xs = Vector("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not have plength(0)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, The length property had its expected value 0, on object \"{1}\" (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLengthEqual(itr, xs, 0)) + " \n" + 
  "in " + xs)
  }
  def `Set("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should be symbol' failed` {
    val xs = Set("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be ('empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `Set("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should not be symbol' failed` {
    val xs = Set("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `Set("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should be property' failed` {
    val xs = Set("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be (empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `Set("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should not be property' failed` {
    val xs = Set("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `Set("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should be a symbol' failed` {
    val xs = Set("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be a 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not a empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not a empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `Set("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should not be a symbol' failed` {
    val xs = Set("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be a ('empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was a empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `Set("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should be a property' failed` {
    val xs = Set("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be a empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not a empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not a empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `Set("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should not be a property' failed` {
    val xs = Set("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be a (empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was a empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `Set("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should be an symbol' failed` {
    val xs = Set("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be an 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not an empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not an empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `Set("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should not be an symbol' failed` {
    val xs = Set("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be an ('empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was an empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `Set("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should be an property' failed` {
    val xs = Set("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be an empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not an empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not an empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `Set("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should not be an property' failed` {
    val xs = Set("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be an (empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was an empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `Set("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should have property' failed` {
    val xs = Set("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should have (plength(0))
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, The length property had value {1}, instead of its expected value 0, on object \"{2}\" (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLengthNotEqualLength(itr, xs, 0)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, The length property had value {1}, instead of its expected value 0, on object \"{2}\" (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLengthNotEqualLength(itr, xs, 0)) + " \n" + 
  "in " + xs)
  }
  def `Set("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should not have property' failed` {
    val xs = Set("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not have plength(0)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, The length property had its expected value 0, on object \"{1}\" (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLengthEqual(itr, xs, 0)) + " \n" + 
  "in " + xs)
  }
  def `List("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should be symbol' failed` {
    val xs = List("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be ('empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `List("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should not be symbol' failed` {
    val xs = List("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `List("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should be property' failed` {
    val xs = List("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be (empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `List("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should not be property' failed` {
    val xs = List("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `List("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should be a symbol' failed` {
    val xs = List("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be a 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not a empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not a empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `List("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should not be a symbol' failed` {
    val xs = List("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be a ('empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was a empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `List("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should be a property' failed` {
    val xs = List("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be a empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not a empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not a empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `List("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should not be a property' failed` {
    val xs = List("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be a (empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was a empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `List("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should be an symbol' failed` {
    val xs = List("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be an 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not an empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not an empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `List("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should not be an symbol' failed` {
    val xs = List("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be an ('empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was an empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `List("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should be an property' failed` {
    val xs = List("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be an empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not an empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not an empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `List("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should not be an property' failed` {
    val xs = List("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be an (empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was an empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `List("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should have property' failed` {
    val xs = List("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should have (plength(0))
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, The length property had value {1}, instead of its expected value 0, on object \"{2}\" (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLengthNotEqualLength(itr, xs, 0)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, The length property had value {1}, instead of its expected value 0, on object \"{2}\" (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLengthNotEqualLength(itr, xs, 0)) + " \n" + 
  "in " + xs)
  }
  def `List("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should not have property' failed` {
    val xs = List("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not have plength(0)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, The length property had its expected value 0, on object \"{1}\" (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLengthEqual(itr, xs, 0)) + " \n" + 
  "in " + xs)
  }
  def `Seq("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should be symbol' failed` {
    val xs = Seq("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be ('empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `Seq("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should not be symbol' failed` {
    val xs = Seq("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `Seq("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should be property' failed` {
    val xs = Seq("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be (empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `Seq("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should not be property' failed` {
    val xs = Seq("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `Seq("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should be a symbol' failed` {
    val xs = Seq("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be a 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not a empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not a empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `Seq("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should not be a symbol' failed` {
    val xs = Seq("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be a ('empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was a empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `Seq("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should be a property' failed` {
    val xs = Seq("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be a empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not a empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not a empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `Seq("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should not be a property' failed` {
    val xs = Seq("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be a (empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was a empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `Seq("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should be an symbol' failed` {
    val xs = Seq("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be an 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not an empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not an empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `Seq("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should not be an symbol' failed` {
    val xs = Seq("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be an ('empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was an empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `Seq("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should be an property' failed` {
    val xs = Seq("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be an empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not an empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not an empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `Seq("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should not be an property' failed` {
    val xs = Seq("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be an (empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was an empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `Seq("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should have property' failed` {
    val xs = Seq("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should have (plength(0))
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, The length property had value {1}, instead of its expected value 0, on object \"{2}\" (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLengthNotEqualLength(itr, xs, 0)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, The length property had value {1}, instead of its expected value 0, on object \"{2}\" (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLengthNotEqualLength(itr, xs, 0)) + " \n" + 
  "in " + xs)
  }
  def `Seq("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should not have property' failed` {
    val xs = Seq("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not have plength(0)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, The length property had its expected value 0, on object \"{1}\" (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLengthEqual(itr, xs, 0)) + " \n" + 
  "in " + xs)
  }
  def `IndexedSeq("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should be symbol' failed` {
    val xs = IndexedSeq("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be ('empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `IndexedSeq("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should not be symbol' failed` {
    val xs = IndexedSeq("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `IndexedSeq("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should be property' failed` {
    val xs = IndexedSeq("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be (empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `IndexedSeq("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should not be property' failed` {
    val xs = IndexedSeq("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `IndexedSeq("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should be a symbol' failed` {
    val xs = IndexedSeq("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be a 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not a empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not a empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `IndexedSeq("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should not be a symbol' failed` {
    val xs = IndexedSeq("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be a ('empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was a empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `IndexedSeq("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should be a property' failed` {
    val xs = IndexedSeq("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be a empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not a empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not a empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `IndexedSeq("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should not be a property' failed` {
    val xs = IndexedSeq("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be a (empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was a empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `IndexedSeq("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should be an symbol' failed` {
    val xs = IndexedSeq("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be an 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not an empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not an empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `IndexedSeq("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should not be an symbol' failed` {
    val xs = IndexedSeq("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be an ('empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was an empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `IndexedSeq("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should be an property' failed` {
    val xs = IndexedSeq("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be an empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not an empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not an empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `IndexedSeq("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should not be an property' failed` {
    val xs = IndexedSeq("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be an (empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was an empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `IndexedSeq("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should have property' failed` {
    val xs = IndexedSeq("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should have (plength(0))
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, The length property had value {1}, instead of its expected value 0, on object \"{2}\" (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLengthNotEqualLength(itr, xs, 0)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, The length property had value {1}, instead of its expected value 0, on object \"{2}\" (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLengthNotEqualLength(itr, xs, 0)) + " \n" + 
  "in " + xs)
  }
  def `IndexedSeq("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should not have property' failed` {
    val xs = IndexedSeq("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not have plength(0)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, The length property had its expected value 0, on object \"{1}\" (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLengthEqual(itr, xs, 0)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Set("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should be symbol' failed` {
    val xs = collection.mutable.Set("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be ('empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Set("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should not be symbol' failed` {
    val xs = collection.mutable.Set("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Set("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should be property' failed` {
    val xs = collection.mutable.Set("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be (empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Set("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should not be property' failed` {
    val xs = collection.mutable.Set("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Set("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should be a symbol' failed` {
    val xs = collection.mutable.Set("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be a 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not a empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not a empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Set("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should not be a symbol' failed` {
    val xs = collection.mutable.Set("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be a ('empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was a empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Set("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should be a property' failed` {
    val xs = collection.mutable.Set("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be a empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not a empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not a empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Set("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should not be a property' failed` {
    val xs = collection.mutable.Set("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be a (empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was a empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Set("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should be an symbol' failed` {
    val xs = collection.mutable.Set("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be an 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not an empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not an empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Set("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should not be an symbol' failed` {
    val xs = collection.mutable.Set("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be an ('empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was an empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Set("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should be an property' failed` {
    val xs = collection.mutable.Set("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be an empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not an empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not an empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Set("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should not be an property' failed` {
    val xs = collection.mutable.Set("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be an (empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was an empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Set("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should have property' failed` {
    val xs = collection.mutable.Set("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should have (plength(0))
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, The length property had value {1}, instead of its expected value 0, on object \"{2}\" (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLengthNotEqualLength(itr, xs, 0)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, The length property had value {1}, instead of its expected value 0, on object \"{2}\" (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLengthNotEqualLength(itr, xs, 0)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Set("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should not have property' failed` {
    val xs = collection.mutable.Set("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not have plength(0)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, The length property had its expected value 0, on object \"{1}\" (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLengthEqual(itr, xs, 0)) + " \n" + 
  "in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should be symbol' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be ('empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should not be symbol' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should be property' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be (empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should not be property' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should be a symbol' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be a 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not a empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not a empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should not be a symbol' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be a ('empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was a empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should be a property' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be a empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not a empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not a empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should not be a property' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be a (empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was a empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should be an symbol' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be an 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not an empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not an empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should not be an symbol' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be an ('empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was an empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should be an property' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be an empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not an empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not an empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should not be an property' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be an (empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was an empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should have property' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should have (plength(0))
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, The length property had value {1}, instead of its expected value 0, on object \"{2}\" (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLengthNotEqualLength(itr, xs, 0)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, The length property had value {1}, instead of its expected value 0, on object \"{2}\" (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLengthNotEqualLength(itr, xs, 0)) + " \n" + 
  "in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should not have property' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not have plength(0)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, The length property had its expected value 0, on object \"{1}\" (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLengthEqual(itr, xs, 0)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Seq("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should be symbol' failed` {
    val xs = collection.mutable.Seq("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be ('empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Seq("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should not be symbol' failed` {
    val xs = collection.mutable.Seq("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Seq("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should be property' failed` {
    val xs = collection.mutable.Seq("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be (empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Seq("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should not be property' failed` {
    val xs = collection.mutable.Seq("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Seq("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should be a symbol' failed` {
    val xs = collection.mutable.Seq("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be a 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not a empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not a empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Seq("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should not be a symbol' failed` {
    val xs = collection.mutable.Seq("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be a ('empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was a empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Seq("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should be a property' failed` {
    val xs = collection.mutable.Seq("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be a empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not a empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not a empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Seq("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should not be a property' failed` {
    val xs = collection.mutable.Seq("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be a (empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was a empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Seq("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should be an symbol' failed` {
    val xs = collection.mutable.Seq("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be an 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not an empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not an empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Seq("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should not be an symbol' failed` {
    val xs = collection.mutable.Seq("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be an ('empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was an empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Seq("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should be an property' failed` {
    val xs = collection.mutable.Seq("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be an empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not an empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not an empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Seq("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should not be an property' failed` {
    val xs = collection.mutable.Seq("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be an (empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was an empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Seq("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should have property' failed` {
    val xs = collection.mutable.Seq("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should have (plength(0))
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, The length property had value {1}, instead of its expected value 0, on object \"{2}\" (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLengthNotEqualLength(itr, xs, 0)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, The length property had value {1}, instead of its expected value 0, on object \"{2}\" (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLengthNotEqualLength(itr, xs, 0)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Seq("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should not have property' failed` {
    val xs = collection.mutable.Seq("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not have plength(0)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, The length property had its expected value 0, on object \"{1}\" (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLengthEqual(itr, xs, 0)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.IndexedSeq("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should be symbol' failed` {
    val xs = collection.mutable.IndexedSeq("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be ('empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.IndexedSeq("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should not be symbol' failed` {
    val xs = collection.mutable.IndexedSeq("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.IndexedSeq("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should be property' failed` {
    val xs = collection.mutable.IndexedSeq("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be (empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.IndexedSeq("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should not be property' failed` {
    val xs = collection.mutable.IndexedSeq("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.IndexedSeq("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should be a symbol' failed` {
    val xs = collection.mutable.IndexedSeq("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be a 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not a empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not a empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.IndexedSeq("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should not be a symbol' failed` {
    val xs = collection.mutable.IndexedSeq("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be a ('empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was a empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.IndexedSeq("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should be a property' failed` {
    val xs = collection.mutable.IndexedSeq("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be a empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not a empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not a empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.IndexedSeq("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should not be a property' failed` {
    val xs = collection.mutable.IndexedSeq("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be a (empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was a empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.IndexedSeq("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should be an symbol' failed` {
    val xs = collection.mutable.IndexedSeq("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be an 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not an empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not an empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.IndexedSeq("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should not be an symbol' failed` {
    val xs = collection.mutable.IndexedSeq("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be an ('empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was an empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.IndexedSeq("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should be an property' failed` {
    val xs = collection.mutable.IndexedSeq("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be an empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not an empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not an empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.IndexedSeq("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should not be an property' failed` {
    val xs = collection.mutable.IndexedSeq("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be an (empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was an empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.IndexedSeq("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should have property' failed` {
    val xs = collection.mutable.IndexedSeq("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should have (plength(0))
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, The length property had value {1}, instead of its expected value 0, on object \"{2}\" (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLengthNotEqualLength(itr, xs, 0)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, The length property had value {1}, instead of its expected value 0, on object \"{2}\" (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLengthNotEqualLength(itr, xs, 0)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.IndexedSeq("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should not have property' failed` {
    val xs = collection.mutable.IndexedSeq("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not have plength(0)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, The length property had its expected value 0, on object \"{1}\" (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementLengthEqual(itr, xs, 0)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Set("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should be symbol' failed` {
    val xs = collection.mutable.Set("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should be ('empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 1 element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was not empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsNotEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Set("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should not be symbol' failed` {
    val xs = collection.mutable.Set("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atLeast(3, xs) should not be 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtLeastFailedSpec0.scala", "'atLeast(3)' inspection failed, because only 2 elements satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, \"{1}\" was empty (InspectorShorthandsForAtLeastFailedSpec0.scala:" + assertLineNumber + ")").format(indexElementIsEmpty(itr, xs, "")) + " \n" + 
  "in " + xs)
  }
}
