package org.scalatest.inspectors.atMost

import org.scalatest._
import SharedHelpers._
import org.scalatest.matchers.{BePropertyMatcher, BePropertyMatchResult, HavePropertyMatcher, HavePropertyMatchResult}
import collection.GenTraversable
import collection.GenMap
class InspectorShorthandsForAtMostFailedSpec0 extends Spec with Matchers {
  class EmptyBePropertyMatcher extends BePropertyMatcher[String] {
    def apply(left: String) = BePropertyMatchResult(left.isEmpty, "empty")
  }
  class StringLengthMatcher(expectedValue: Int) extends HavePropertyMatcher[String, Int] {
    def apply(value: String) = {
      new HavePropertyMatchResult(value.length == expectedValue, "length", expectedValue, value.length)
    }
  }
  val empty = new EmptyBePropertyMatcher()
  def plength(expectedValue: Int) = new StringLengthMatcher(expectedValue)
  val theInstance = "2"
  def arrayToString(xs: GenTraversable[_]): String = xs.toString
  def checkErrorAndCause(e: exceptions.TestFailedException, assertLineNumber: Int, fileName: String, errorMessage: String, causeErrorMessage: String) {
    assert(e.failedCodeFileName == Some(fileName), e.failedCodeFileName + " did not equal " + Some(fileName))
    assert(e.failedCodeLineNumber == Some(assertLineNumber), e.failedCodeLineNumber + " did not equal " + Some(assertLineNumber))
    assert(e.message == Some(errorMessage), e.message + " did not equal " + Some(
  errorMessage))
    e.getCause match {
      case tfe: exceptions.TestFailedException =>
        assert(tfe.failedCodeFileName == Some(fileName), tfe.failedCodeFileName + " did not equal " + Some(fileName))
        assert(tfe.failedCodeLineNumber == Some(assertLineNumber), tfe.failedCodeLineNumber + " did not equal " + Some(assertLineNumber))
        assert(tfe.message == Some(causeErrorMessage), tfe.message + " did not equal " + Some(causeErrorMessage))
        assert(tfe.getCause == null, tfe.getCause + " was not null")
      case other => fail("Expected cause to be TestFailedException, but got: " + other)
    }
  }
  def checkError(e: exceptions.TestFailedException, assertLineNumber: Int, fileName: String, errorMessage: String) {
    assert(e.failedCodeFileName == Some(fileName), e.failedCodeFileName + " did not equal " + Some(fileName))
    assert(e.failedCodeLineNumber == Some(assertLineNumber), e.failedCodeLineNumber + " did not equal " + Some(assertLineNumber))
    assert(e.message == Some(errorMessage), e.message + " did not equal " + Some(
  errorMessage))
  }
  def equal[T](left: T, right: T): Boolean = left == right
  def javaArrayList[T](valueList: List[T]): java.util.ArrayList[T] = {
    val col = new java.util.ArrayList[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaHashSet[T](valueList: List[T]): java.util.HashSet[T] = {
    val col = new java.util.HashSet[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaLinkedList[T](valueList: List[T]): java.util.LinkedList[T] = {
    val col = new java.util.LinkedList[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaStack[T](valueList: List[T]): java.util.Stack[T] = {
    val col = new java.util.Stack[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaTreeSet[T](valueList: List[T]): java.util.TreeSet[T] = {
    val col = new java.util.TreeSet[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaVector[T](valueList: List[T]): java.util.Vector[T] = {
    val col = new java.util.Vector[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaArrayBlockingQueue[T](valueList: List[T], size: Int): java.util.concurrent.ArrayBlockingQueue[T] = {
    val col = new java.util.concurrent.ArrayBlockingQueue[T](size)
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaArrayDeque[T](valueList: List[T]): java.util.ArrayDeque[T] = {
    val col = new java.util.ArrayDeque[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaConcurrentLinkedQueue[T](valueList: List[T]): java.util.concurrent.ConcurrentLinkedQueue[T] = {
    val col = new java.util.concurrent.ConcurrentLinkedQueue[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaConcurrentSkipListSet[T](valueList: List[T]): java.util.concurrent.ConcurrentSkipListSet[T] = {
    val col = new java.util.concurrent.ConcurrentSkipListSet[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaCopyOnWriteArrayList[T](valueList: List[T]): java.util.concurrent.CopyOnWriteArrayList[T] = {
    val col = new java.util.concurrent.CopyOnWriteArrayList[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaCopyOnWriteArraySet[T](valueList: List[T]): java.util.concurrent.CopyOnWriteArraySet[T] = {
    val col = new java.util.concurrent.CopyOnWriteArraySet[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaLinkedBlockingDeque[T](valueList: List[T]): java.util.concurrent.LinkedBlockingDeque[T] = {
    val col = new java.util.concurrent.LinkedBlockingDeque[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaLinkedBlockingQueue[T](valueList: List[T]): java.util.concurrent.LinkedBlockingQueue[T] = {
    val col = new java.util.concurrent.LinkedBlockingQueue[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaLinkedHashSet[T](valueList: List[T]): java.util.LinkedHashSet[T] = {
    val col = new java.util.LinkedHashSet[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaPriorityBlockingQueue[T](valueList: List[T]): java.util.concurrent.PriorityBlockingQueue[T] = {
    val col = new java.util.concurrent.PriorityBlockingQueue[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaPriorityQueue[T](valueList: List[T]): java.util.PriorityQueue[T] = {
    val col = new java.util.PriorityQueue[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaHashMap[K, V](valueMap: Map[K, V]): java.util.HashMap[K, V] = {
    val map = new java.util.HashMap[K, V]()
    for ((key, value) <- valueMap)
      map.put(key, value)
    map
  }
  def javaTreeMap[K, V](valueMap: Map[K, V]): java.util.TreeMap[K, V] = {
    val map = new java.util.TreeMap[K, V]()
    for ((key, value) <- valueMap)
      map.put(key, value)
    map
  }
  def javaHashtable[K, V](valueMap: Map[K, V]): java.util.Hashtable[K, V] = {
    val map = new java.util.Hashtable[K, V]()
    for ((key, value) <- valueMap)
      map.put(key, value)
    map
  }
  def javaConcurrentHashMap[K, V](valueMap: Map[K, V]): java.util.concurrent.ConcurrentHashMap[K, V] = {
    val map = new java.util.concurrent.ConcurrentHashMap[K, V]()
    for ((key, value) <- valueMap)
      map.put(key, value)
    map
  }
  def javaConcurrentSkipListMap[K, V](valueMap: Map[K, V]): java.util.concurrent.ConcurrentSkipListMap[K, V] = {
    val map = new java.util.concurrent.ConcurrentSkipListMap[K, V]()
    for ((key, value) <- valueMap)
      map.put(key, value)
    map
  }
  def javaLinkedHashMap[K, V](valueMap: Map[K, V]): java.util.LinkedHashMap[K, V] = {
    val map = new java.util.LinkedHashMap[K, V]()
    for ((key, value) <- valueMap)
      map.put(key, value)
    map
  }
  def javaWeakHashMap[K, V](valueMap: Map[K, V]): java.util.WeakHashMap[K, V] = {
    val map = new java.util.WeakHashMap[K, V]()
    for ((key, value) <- valueMap)
      map.put(key, value)
    map
  }
  def javaProperties(valueMap: Map[String, String]): java.util.Properties = {
    val map = new java.util.Properties()
    for ((key, value) <- valueMap)
      map.put(key, value)
    map
  }
  def `Set(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when more than max element succeeded` {
    val xs = Set(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not equal (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqual[Int](xs, 2, 2) + " in " + xs)
  }
  def `Set(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when 'should not equal' failed` {
    val xs = Set(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not equal 3
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqual[Int](xs, 3, 2) + " in " + xs)
  }
  def `Set(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when 'should not be' failed` {
    val xs = Set(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be 3
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqual[Int](xs, 3, 2) + " in " + xs)
  }
  def `Set(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when 'should be less than comparison' failed` {
    val xs = Set(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should be < 3
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLessThan(xs, 3, 2) + " in " + xs)
  }
  def `Set(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when 'should not be less than comparison' failed` {
    val xs = Set(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be < (3)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesMoreThanEqual(xs, 3, 2) + " in " + xs)
  }
  def `Set(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when 'should be less than or equal comparison' failed` {
    val xs = Set(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should be <= 3
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLessThanEqual(xs, 3, 2) + " in " + xs)
  }
  def `Set(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when 'should not be less than or equal comparison' failed` {
    val xs = Set(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be <= (3)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesMoreThan(xs, 3, 2) + " in " + xs)
  }
  def `Set(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when 'should be greater than comparison' failed` {
    val xs = Set(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should be > 3
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesMoreThan(xs, 3, 2) + " in " + xs)
  }
  def `Set(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when 'should not be greater than comparison' failed` {
    val xs = Set(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be > (3)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLessThanEqual(xs, 3, 2) + " in " + xs)
  }
  def `Set(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when 'should be greater than or equal comparison' failed` {
    val xs = Set(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should be >= 3
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesMoreThanEqual(xs, 3, 2) + " in " + xs)
  }
  def `Set(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when 'should not be greater than or equal comparison' failed` {
    val xs = Set(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be >= (3)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLessThan(xs, 3, 2) + " in " + xs)
  }
  def `Set(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when 'should not be ===' failed` {
    val xs = Set(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be === (3)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqual[Int](xs, 3, 2) + " in " + xs)
  }
  def `List(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when more than max element succeeded` {
    val xs = List(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not equal (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqual[Int](xs, 2, 2) + " in " + xs)
  }
  def `List(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when 'should not equal' failed` {
    val xs = List(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not equal 3
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqual[Int](xs, 3, 2) + " in " + xs)
  }
  def `List(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when 'should not be' failed` {
    val xs = List(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be 3
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqual[Int](xs, 3, 2) + " in " + xs)
  }
  def `List(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when 'should be less than comparison' failed` {
    val xs = List(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should be < 3
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLessThan(xs, 3, 2) + " in " + xs)
  }
  def `List(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when 'should not be less than comparison' failed` {
    val xs = List(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be < (3)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesMoreThanEqual(xs, 3, 2) + " in " + xs)
  }
  def `List(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when 'should be less than or equal comparison' failed` {
    val xs = List(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should be <= 3
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLessThanEqual(xs, 3, 2) + " in " + xs)
  }
  def `List(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when 'should not be less than or equal comparison' failed` {
    val xs = List(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be <= (3)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesMoreThan(xs, 3, 2) + " in " + xs)
  }
  def `List(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when 'should be greater than comparison' failed` {
    val xs = List(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should be > 3
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesMoreThan(xs, 3, 2) + " in " + xs)
  }
  def `List(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when 'should not be greater than comparison' failed` {
    val xs = List(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be > (3)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLessThanEqual(xs, 3, 2) + " in " + xs)
  }
  def `List(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when 'should be greater than or equal comparison' failed` {
    val xs = List(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should be >= 3
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesMoreThanEqual(xs, 3, 2) + " in " + xs)
  }
  def `List(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when 'should not be greater than or equal comparison' failed` {
    val xs = List(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be >= (3)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLessThan(xs, 3, 2) + " in " + xs)
  }
  def `List(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when 'should not be ===' failed` {
    val xs = List(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be === (3)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqual[Int](xs, 3, 2) + " in " + xs)
  }
  def `Seq(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when more than max element succeeded` {
    val xs = Seq(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not equal (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqual[Int](xs, 2, 2) + " in " + xs)
  }
  def `Seq(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when 'should not equal' failed` {
    val xs = Seq(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not equal 3
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqual[Int](xs, 3, 2) + " in " + xs)
  }
  def `Seq(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when 'should not be' failed` {
    val xs = Seq(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be 3
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqual[Int](xs, 3, 2) + " in " + xs)
  }
  def `Seq(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when 'should be less than comparison' failed` {
    val xs = Seq(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should be < 3
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLessThan(xs, 3, 2) + " in " + xs)
  }
  def `Seq(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when 'should not be less than comparison' failed` {
    val xs = Seq(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be < (3)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesMoreThanEqual(xs, 3, 2) + " in " + xs)
  }
  def `Seq(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when 'should be less than or equal comparison' failed` {
    val xs = Seq(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should be <= 3
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLessThanEqual(xs, 3, 2) + " in " + xs)
  }
  def `Seq(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when 'should not be less than or equal comparison' failed` {
    val xs = Seq(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be <= (3)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesMoreThan(xs, 3, 2) + " in " + xs)
  }
  def `Seq(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when 'should be greater than comparison' failed` {
    val xs = Seq(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should be > 3
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesMoreThan(xs, 3, 2) + " in " + xs)
  }
  def `Seq(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when 'should not be greater than comparison' failed` {
    val xs = Seq(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be > (3)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLessThanEqual(xs, 3, 2) + " in " + xs)
  }
  def `Seq(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when 'should be greater than or equal comparison' failed` {
    val xs = Seq(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should be >= 3
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesMoreThanEqual(xs, 3, 2) + " in " + xs)
  }
  def `Seq(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when 'should not be greater than or equal comparison' failed` {
    val xs = Seq(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be >= (3)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLessThan(xs, 3, 2) + " in " + xs)
  }
  def `Seq(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when 'should not be ===' failed` {
    val xs = Seq(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be === (3)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqual[Int](xs, 3, 2) + " in " + xs)
  }
  def `Array(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when more than max element succeeded` {
    val xs = Array(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not equal (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqual[Int](Array(1, 2, 3, 4, 5), 2, 2) + " in " + "WrappedArray(1, 2, 3, 4, 5)")
  }
  def `Array(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when 'should not equal' failed` {
    val xs = Array(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not equal 3
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqual[Int](Array(1, 2, 3, 4, 5), 3, 2) + " in " + "WrappedArray(1, 2, 3, 4, 5)")
  }
  def `Array(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when 'should not be' failed` {
    val xs = Array(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be 3
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqual[Int](Array(1, 2, 3, 4, 5), 3, 2) + " in " + "WrappedArray(1, 2, 3, 4, 5)")
  }
  def `Array(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when 'should be less than comparison' failed` {
    val xs = Array(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should be < 3
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLessThan(Array(1, 2, 3, 4, 5), 3, 2) + " in " + "WrappedArray(1, 2, 3, 4, 5)")
  }
  def `Array(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when 'should not be less than comparison' failed` {
    val xs = Array(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be < (3)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesMoreThanEqual(Array(1, 2, 3, 4, 5), 3, 2) + " in " + "WrappedArray(1, 2, 3, 4, 5)")
  }
  def `Array(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when 'should be less than or equal comparison' failed` {
    val xs = Array(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should be <= 3
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLessThanEqual(Array(1, 2, 3, 4, 5), 3, 2) + " in " + "WrappedArray(1, 2, 3, 4, 5)")
  }
  def `Array(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when 'should not be less than or equal comparison' failed` {
    val xs = Array(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be <= (3)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesMoreThan(Array(1, 2, 3, 4, 5), 3, 2) + " in " + "WrappedArray(1, 2, 3, 4, 5)")
  }
  def `Array(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when 'should be greater than comparison' failed` {
    val xs = Array(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should be > 3
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesMoreThan(Array(1, 2, 3, 4, 5), 3, 2) + " in " + "WrappedArray(1, 2, 3, 4, 5)")
  }
  def `Array(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when 'should not be greater than comparison' failed` {
    val xs = Array(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be > (3)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLessThanEqual(Array(1, 2, 3, 4, 5), 3, 2) + " in " + "WrappedArray(1, 2, 3, 4, 5)")
  }
  def `Array(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when 'should be greater than or equal comparison' failed` {
    val xs = Array(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should be >= 3
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesMoreThanEqual(Array(1, 2, 3, 4, 5), 3, 2) + " in " + "WrappedArray(1, 2, 3, 4, 5)")
  }
  def `Array(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when 'should not be greater than or equal comparison' failed` {
    val xs = Array(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be >= (3)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLessThan(Array(1, 2, 3, 4, 5), 3, 2) + " in " + "WrappedArray(1, 2, 3, 4, 5)")
  }
  def `Array(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when 'should not be ===' failed` {
    val xs = Array(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be === (3)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqual[Int](Array(1, 2, 3, 4, 5), 3, 2) + " in " + "WrappedArray(1, 2, 3, 4, 5)")
  }
  def `IndexedSeq(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when more than max element succeeded` {
    val xs = IndexedSeq(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not equal (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqual[Int](xs, 2, 2) + " in " + xs)
  }
  def `IndexedSeq(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when 'should not equal' failed` {
    val xs = IndexedSeq(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not equal 3
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqual[Int](xs, 3, 2) + " in " + xs)
  }
  def `IndexedSeq(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when 'should not be' failed` {
    val xs = IndexedSeq(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be 3
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqual[Int](xs, 3, 2) + " in " + xs)
  }
  def `IndexedSeq(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when 'should be less than comparison' failed` {
    val xs = IndexedSeq(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should be < 3
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLessThan(xs, 3, 2) + " in " + xs)
  }
  def `IndexedSeq(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when 'should not be less than comparison' failed` {
    val xs = IndexedSeq(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be < (3)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesMoreThanEqual(xs, 3, 2) + " in " + xs)
  }
  def `IndexedSeq(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when 'should be less than or equal comparison' failed` {
    val xs = IndexedSeq(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should be <= 3
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLessThanEqual(xs, 3, 2) + " in " + xs)
  }
  def `IndexedSeq(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when 'should not be less than or equal comparison' failed` {
    val xs = IndexedSeq(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be <= (3)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesMoreThan(xs, 3, 2) + " in " + xs)
  }
  def `IndexedSeq(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when 'should be greater than comparison' failed` {
    val xs = IndexedSeq(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should be > 3
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesMoreThan(xs, 3, 2) + " in " + xs)
  }
  def `IndexedSeq(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when 'should not be greater than comparison' failed` {
    val xs = IndexedSeq(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be > (3)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLessThanEqual(xs, 3, 2) + " in " + xs)
  }
  def `IndexedSeq(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when 'should be greater than or equal comparison' failed` {
    val xs = IndexedSeq(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should be >= 3
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesMoreThanEqual(xs, 3, 2) + " in " + xs)
  }
  def `IndexedSeq(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when 'should not be greater than or equal comparison' failed` {
    val xs = IndexedSeq(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be >= (3)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLessThan(xs, 3, 2) + " in " + xs)
  }
  def `IndexedSeq(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when 'should not be ===' failed` {
    val xs = IndexedSeq(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be === (3)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqual[Int](xs, 3, 2) + " in " + xs)
  }
  def `Vector(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when more than max element succeeded` {
    val xs = Vector(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not equal (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqual[Int](xs, 2, 2) + " in " + xs)
  }
  def `Vector(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when 'should not equal' failed` {
    val xs = Vector(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not equal 3
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqual[Int](xs, 3, 2) + " in " + xs)
  }
  def `Vector(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when 'should not be' failed` {
    val xs = Vector(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be 3
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqual[Int](xs, 3, 2) + " in " + xs)
  }
  def `Vector(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when 'should be less than comparison' failed` {
    val xs = Vector(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should be < 3
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLessThan(xs, 3, 2) + " in " + xs)
  }
  def `Vector(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when 'should not be less than comparison' failed` {
    val xs = Vector(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be < (3)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesMoreThanEqual(xs, 3, 2) + " in " + xs)
  }
  def `Vector(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when 'should be less than or equal comparison' failed` {
    val xs = Vector(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should be <= 3
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLessThanEqual(xs, 3, 2) + " in " + xs)
  }
  def `Vector(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when 'should not be less than or equal comparison' failed` {
    val xs = Vector(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be <= (3)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesMoreThan(xs, 3, 2) + " in " + xs)
  }
  def `Vector(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when 'should be greater than comparison' failed` {
    val xs = Vector(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should be > 3
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesMoreThan(xs, 3, 2) + " in " + xs)
  }
  def `Vector(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when 'should not be greater than comparison' failed` {
    val xs = Vector(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be > (3)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLessThanEqual(xs, 3, 2) + " in " + xs)
  }
  def `Vector(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when 'should be greater than or equal comparison' failed` {
    val xs = Vector(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should be >= 3
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesMoreThanEqual(xs, 3, 2) + " in " + xs)
  }
  def `Vector(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when 'should not be greater than or equal comparison' failed` {
    val xs = Vector(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be >= (3)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLessThan(xs, 3, 2) + " in " + xs)
  }
  def `Vector(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when 'should not be ===' failed` {
    val xs = Vector(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be === (3)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqual[Int](xs, 3, 2) + " in " + xs)
  }
  def `Set(1, 2, 3, 4, 5).par should throw TestFailedException with correct stack depth and message when more than max element succeeded` {
    val xs = Set(1, 2, 3, 4, 5).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not equal (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqual[Int](xs, 2, 2) + " in " + xs)
  }
  def `Set(1, 2, 3, 4, 5).par should throw TestFailedException with correct stack depth and message when 'should not equal' failed` {
    val xs = Set(1, 2, 3, 4, 5).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not equal 3
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqual[Int](xs, 3, 2) + " in " + xs)
  }
  def `Set(1, 2, 3, 4, 5).par should throw TestFailedException with correct stack depth and message when 'should not be' failed` {
    val xs = Set(1, 2, 3, 4, 5).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be 3
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqual[Int](xs, 3, 2) + " in " + xs)
  }
  def `Set(1, 2, 3, 4, 5).par should throw TestFailedException with correct stack depth and message when 'should be less than comparison' failed` {
    val xs = Set(1, 2, 3, 4, 5).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should be < 3
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLessThan(xs, 3, 2) + " in " + xs)
  }
  def `Set(1, 2, 3, 4, 5).par should throw TestFailedException with correct stack depth and message when 'should not be less than comparison' failed` {
    val xs = Set(1, 2, 3, 4, 5).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be < (3)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesMoreThanEqual(xs, 3, 2) + " in " + xs)
  }
  def `Set(1, 2, 3, 4, 5).par should throw TestFailedException with correct stack depth and message when 'should be less than or equal comparison' failed` {
    val xs = Set(1, 2, 3, 4, 5).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should be <= 3
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLessThanEqual(xs, 3, 2) + " in " + xs)
  }
  def `Set(1, 2, 3, 4, 5).par should throw TestFailedException with correct stack depth and message when 'should not be less than or equal comparison' failed` {
    val xs = Set(1, 2, 3, 4, 5).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be <= (3)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesMoreThan(xs, 3, 2) + " in " + xs)
  }
  def `Set(1, 2, 3, 4, 5).par should throw TestFailedException with correct stack depth and message when 'should be greater than comparison' failed` {
    val xs = Set(1, 2, 3, 4, 5).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should be > 3
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesMoreThan(xs, 3, 2) + " in " + xs)
  }
  def `Set(1, 2, 3, 4, 5).par should throw TestFailedException with correct stack depth and message when 'should not be greater than comparison' failed` {
    val xs = Set(1, 2, 3, 4, 5).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be > (3)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLessThanEqual(xs, 3, 2) + " in " + xs)
  }
  def `Set(1, 2, 3, 4, 5).par should throw TestFailedException with correct stack depth and message when 'should be greater than or equal comparison' failed` {
    val xs = Set(1, 2, 3, 4, 5).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should be >= 3
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesMoreThanEqual(xs, 3, 2) + " in " + xs)
  }
  def `Set(1, 2, 3, 4, 5).par should throw TestFailedException with correct stack depth and message when 'should not be greater than or equal comparison' failed` {
    val xs = Set(1, 2, 3, 4, 5).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be >= (3)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLessThan(xs, 3, 2) + " in " + xs)
  }
  def `Set(1, 2, 3, 4, 5).par should throw TestFailedException with correct stack depth and message when 'should not be ===' failed` {
    val xs = Set(1, 2, 3, 4, 5).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be === (3)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqual[Int](xs, 3, 2) + " in " + xs)
  }
  def `List(1, 2, 3, 4, 5).par should throw TestFailedException with correct stack depth and message when more than max element succeeded` {
    val xs = List(1, 2, 3, 4, 5).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not equal (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqual[Int](xs, 2, 2) + " in " + xs)
  }
  def `List(1, 2, 3, 4, 5).par should throw TestFailedException with correct stack depth and message when 'should not equal' failed` {
    val xs = List(1, 2, 3, 4, 5).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not equal 3
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqual[Int](xs, 3, 2) + " in " + xs)
  }
  def `List(1, 2, 3, 4, 5).par should throw TestFailedException with correct stack depth and message when 'should not be' failed` {
    val xs = List(1, 2, 3, 4, 5).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be 3
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqual[Int](xs, 3, 2) + " in " + xs)
  }
  def `List(1, 2, 3, 4, 5).par should throw TestFailedException with correct stack depth and message when 'should be less than comparison' failed` {
    val xs = List(1, 2, 3, 4, 5).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should be < 3
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLessThan(xs, 3, 2) + " in " + xs)
  }
  def `List(1, 2, 3, 4, 5).par should throw TestFailedException with correct stack depth and message when 'should not be less than comparison' failed` {
    val xs = List(1, 2, 3, 4, 5).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be < (3)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesMoreThanEqual(xs, 3, 2) + " in " + xs)
  }
  def `List(1, 2, 3, 4, 5).par should throw TestFailedException with correct stack depth and message when 'should be less than or equal comparison' failed` {
    val xs = List(1, 2, 3, 4, 5).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should be <= 3
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLessThanEqual(xs, 3, 2) + " in " + xs)
  }
  def `List(1, 2, 3, 4, 5).par should throw TestFailedException with correct stack depth and message when 'should not be less than or equal comparison' failed` {
    val xs = List(1, 2, 3, 4, 5).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be <= (3)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesMoreThan(xs, 3, 2) + " in " + xs)
  }
  def `List(1, 2, 3, 4, 5).par should throw TestFailedException with correct stack depth and message when 'should be greater than comparison' failed` {
    val xs = List(1, 2, 3, 4, 5).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should be > 3
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesMoreThan(xs, 3, 2) + " in " + xs)
  }
  def `List(1, 2, 3, 4, 5).par should throw TestFailedException with correct stack depth and message when 'should not be greater than comparison' failed` {
    val xs = List(1, 2, 3, 4, 5).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be > (3)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLessThanEqual(xs, 3, 2) + " in " + xs)
  }
  def `List(1, 2, 3, 4, 5).par should throw TestFailedException with correct stack depth and message when 'should be greater than or equal comparison' failed` {
    val xs = List(1, 2, 3, 4, 5).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should be >= 3
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesMoreThanEqual(xs, 3, 2) + " in " + xs)
  }
  def `List(1, 2, 3, 4, 5).par should throw TestFailedException with correct stack depth and message when 'should not be greater than or equal comparison' failed` {
    val xs = List(1, 2, 3, 4, 5).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be >= (3)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLessThan(xs, 3, 2) + " in " + xs)
  }
  def `List(1, 2, 3, 4, 5).par should throw TestFailedException with correct stack depth and message when 'should not be ===' failed` {
    val xs = List(1, 2, 3, 4, 5).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be === (3)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqual[Int](xs, 3, 2) + " in " + xs)
  }
  def `Seq(1, 2, 3, 4, 5).par should throw TestFailedException with correct stack depth and message when more than max element succeeded` {
    val xs = Seq(1, 2, 3, 4, 5).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not equal (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqual[Int](xs, 2, 2) + " in " + xs)
  }
  def `Seq(1, 2, 3, 4, 5).par should throw TestFailedException with correct stack depth and message when 'should not equal' failed` {
    val xs = Seq(1, 2, 3, 4, 5).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not equal 3
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqual[Int](xs, 3, 2) + " in " + xs)
  }
  def `Seq(1, 2, 3, 4, 5).par should throw TestFailedException with correct stack depth and message when 'should not be' failed` {
    val xs = Seq(1, 2, 3, 4, 5).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be 3
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqual[Int](xs, 3, 2) + " in " + xs)
  }
  def `Seq(1, 2, 3, 4, 5).par should throw TestFailedException with correct stack depth and message when 'should be less than comparison' failed` {
    val xs = Seq(1, 2, 3, 4, 5).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should be < 3
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLessThan(xs, 3, 2) + " in " + xs)
  }
  def `Seq(1, 2, 3, 4, 5).par should throw TestFailedException with correct stack depth and message when 'should not be less than comparison' failed` {
    val xs = Seq(1, 2, 3, 4, 5).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be < (3)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesMoreThanEqual(xs, 3, 2) + " in " + xs)
  }
  def `Seq(1, 2, 3, 4, 5).par should throw TestFailedException with correct stack depth and message when 'should be less than or equal comparison' failed` {
    val xs = Seq(1, 2, 3, 4, 5).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should be <= 3
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLessThanEqual(xs, 3, 2) + " in " + xs)
  }
  def `Seq(1, 2, 3, 4, 5).par should throw TestFailedException with correct stack depth and message when 'should not be less than or equal comparison' failed` {
    val xs = Seq(1, 2, 3, 4, 5).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be <= (3)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesMoreThan(xs, 3, 2) + " in " + xs)
  }
  def `Seq(1, 2, 3, 4, 5).par should throw TestFailedException with correct stack depth and message when 'should be greater than comparison' failed` {
    val xs = Seq(1, 2, 3, 4, 5).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should be > 3
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesMoreThan(xs, 3, 2) + " in " + xs)
  }
  def `Seq(1, 2, 3, 4, 5).par should throw TestFailedException with correct stack depth and message when 'should not be greater than comparison' failed` {
    val xs = Seq(1, 2, 3, 4, 5).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be > (3)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLessThanEqual(xs, 3, 2) + " in " + xs)
  }
  def `Seq(1, 2, 3, 4, 5).par should throw TestFailedException with correct stack depth and message when 'should be greater than or equal comparison' failed` {
    val xs = Seq(1, 2, 3, 4, 5).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should be >= 3
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesMoreThanEqual(xs, 3, 2) + " in " + xs)
  }
  def `Seq(1, 2, 3, 4, 5).par should throw TestFailedException with correct stack depth and message when 'should not be greater than or equal comparison' failed` {
    val xs = Seq(1, 2, 3, 4, 5).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be >= (3)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLessThan(xs, 3, 2) + " in " + xs)
  }
  def `Seq(1, 2, 3, 4, 5).par should throw TestFailedException with correct stack depth and message when 'should not be ===' failed` {
    val xs = Seq(1, 2, 3, 4, 5).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be === (3)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqual[Int](xs, 3, 2) + " in " + xs)
  }
  def `IndexedSeq(1, 2, 3, 4, 5).par should throw TestFailedException with correct stack depth and message when more than max element succeeded` {
    val xs = IndexedSeq(1, 2, 3, 4, 5).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not equal (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqual[Int](xs, 2, 2) + " in " + xs)
  }
  def `IndexedSeq(1, 2, 3, 4, 5).par should throw TestFailedException with correct stack depth and message when 'should not equal' failed` {
    val xs = IndexedSeq(1, 2, 3, 4, 5).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not equal 3
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqual[Int](xs, 3, 2) + " in " + xs)
  }
  def `IndexedSeq(1, 2, 3, 4, 5).par should throw TestFailedException with correct stack depth and message when 'should not be' failed` {
    val xs = IndexedSeq(1, 2, 3, 4, 5).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be 3
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqual[Int](xs, 3, 2) + " in " + xs)
  }
  def `IndexedSeq(1, 2, 3, 4, 5).par should throw TestFailedException with correct stack depth and message when 'should be less than comparison' failed` {
    val xs = IndexedSeq(1, 2, 3, 4, 5).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should be < 3
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLessThan(xs, 3, 2) + " in " + xs)
  }
  def `IndexedSeq(1, 2, 3, 4, 5).par should throw TestFailedException with correct stack depth and message when 'should not be less than comparison' failed` {
    val xs = IndexedSeq(1, 2, 3, 4, 5).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be < (3)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesMoreThanEqual(xs, 3, 2) + " in " + xs)
  }
  def `IndexedSeq(1, 2, 3, 4, 5).par should throw TestFailedException with correct stack depth and message when 'should be less than or equal comparison' failed` {
    val xs = IndexedSeq(1, 2, 3, 4, 5).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should be <= 3
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLessThanEqual(xs, 3, 2) + " in " + xs)
  }
  def `IndexedSeq(1, 2, 3, 4, 5).par should throw TestFailedException with correct stack depth and message when 'should not be less than or equal comparison' failed` {
    val xs = IndexedSeq(1, 2, 3, 4, 5).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be <= (3)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesMoreThan(xs, 3, 2) + " in " + xs)
  }
  def `IndexedSeq(1, 2, 3, 4, 5).par should throw TestFailedException with correct stack depth and message when 'should be greater than comparison' failed` {
    val xs = IndexedSeq(1, 2, 3, 4, 5).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should be > 3
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesMoreThan(xs, 3, 2) + " in " + xs)
  }
  def `IndexedSeq(1, 2, 3, 4, 5).par should throw TestFailedException with correct stack depth and message when 'should not be greater than comparison' failed` {
    val xs = IndexedSeq(1, 2, 3, 4, 5).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be > (3)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLessThanEqual(xs, 3, 2) + " in " + xs)
  }
  def `IndexedSeq(1, 2, 3, 4, 5).par should throw TestFailedException with correct stack depth and message when 'should be greater than or equal comparison' failed` {
    val xs = IndexedSeq(1, 2, 3, 4, 5).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should be >= 3
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesMoreThanEqual(xs, 3, 2) + " in " + xs)
  }
  def `IndexedSeq(1, 2, 3, 4, 5).par should throw TestFailedException with correct stack depth and message when 'should not be greater than or equal comparison' failed` {
    val xs = IndexedSeq(1, 2, 3, 4, 5).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be >= (3)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLessThan(xs, 3, 2) + " in " + xs)
  }
  def `IndexedSeq(1, 2, 3, 4, 5).par should throw TestFailedException with correct stack depth and message when 'should not be ===' failed` {
    val xs = IndexedSeq(1, 2, 3, 4, 5).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be === (3)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqual[Int](xs, 3, 2) + " in " + xs)
  }
  def `collection.mutable.Set(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when more than max element succeeded` {
    val xs = collection.mutable.Set(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not equal (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqual[Int](xs, 2, 2) + " in " + xs)
  }
  def `collection.mutable.Set(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when 'should not equal' failed` {
    val xs = collection.mutable.Set(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not equal 3
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqual[Int](xs, 3, 2) + " in " + xs)
  }
  def `collection.mutable.Set(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when 'should not be' failed` {
    val xs = collection.mutable.Set(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be 3
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqual[Int](xs, 3, 2) + " in " + xs)
  }
  def `collection.mutable.Set(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when 'should be less than comparison' failed` {
    val xs = collection.mutable.Set(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should be < 3
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLessThan(xs, 3, 2) + " in " + xs)
  }
  def `collection.mutable.Set(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when 'should not be less than comparison' failed` {
    val xs = collection.mutable.Set(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be < (3)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesMoreThanEqual(xs, 3, 2) + " in " + xs)
  }
  def `collection.mutable.Set(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when 'should be less than or equal comparison' failed` {
    val xs = collection.mutable.Set(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should be <= 3
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLessThanEqual(xs, 3, 2) + " in " + xs)
  }
  def `collection.mutable.Set(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when 'should not be less than or equal comparison' failed` {
    val xs = collection.mutable.Set(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be <= (3)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesMoreThan(xs, 3, 2) + " in " + xs)
  }
  def `collection.mutable.Set(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when 'should be greater than comparison' failed` {
    val xs = collection.mutable.Set(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should be > 3
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesMoreThan(xs, 3, 2) + " in " + xs)
  }
  def `collection.mutable.Set(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when 'should not be greater than comparison' failed` {
    val xs = collection.mutable.Set(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be > (3)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLessThanEqual(xs, 3, 2) + " in " + xs)
  }
  def `collection.mutable.Set(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when 'should be greater than or equal comparison' failed` {
    val xs = collection.mutable.Set(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should be >= 3
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesMoreThanEqual(xs, 3, 2) + " in " + xs)
  }
  def `collection.mutable.Set(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when 'should not be greater than or equal comparison' failed` {
    val xs = collection.mutable.Set(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be >= (3)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLessThan(xs, 3, 2) + " in " + xs)
  }
  def `collection.mutable.Set(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when 'should not be ===' failed` {
    val xs = collection.mutable.Set(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be === (3)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqual[Int](xs, 3, 2) + " in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when more than max element succeeded` {
    val xs = new collection.mutable.ListBuffer() ++ List(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not equal (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqual[Int](xs, 2, 2) + " in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when 'should not equal' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not equal 3
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqual[Int](xs, 3, 2) + " in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when 'should not be' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be 3
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqual[Int](xs, 3, 2) + " in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when 'should be less than comparison' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should be < 3
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLessThan(xs, 3, 2) + " in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when 'should not be less than comparison' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be < (3)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesMoreThanEqual(xs, 3, 2) + " in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when 'should be less than or equal comparison' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should be <= 3
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLessThanEqual(xs, 3, 2) + " in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when 'should not be less than or equal comparison' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be <= (3)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesMoreThan(xs, 3, 2) + " in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when 'should be greater than comparison' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should be > 3
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesMoreThan(xs, 3, 2) + " in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when 'should not be greater than comparison' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be > (3)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLessThanEqual(xs, 3, 2) + " in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when 'should be greater than or equal comparison' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should be >= 3
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesMoreThanEqual(xs, 3, 2) + " in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when 'should not be greater than or equal comparison' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be >= (3)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLessThan(xs, 3, 2) + " in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when 'should not be ===' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be === (3)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqual[Int](xs, 3, 2) + " in " + xs)
  }
  def `collection.mutable.Seq(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when more than max element succeeded` {
    val xs = collection.mutable.Seq(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not equal (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqual[Int](xs, 2, 2) + " in " + xs)
  }
  def `collection.mutable.Seq(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when 'should not equal' failed` {
    val xs = collection.mutable.Seq(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not equal 3
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqual[Int](xs, 3, 2) + " in " + xs)
  }
  def `collection.mutable.Seq(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when 'should not be' failed` {
    val xs = collection.mutable.Seq(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be 3
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqual[Int](xs, 3, 2) + " in " + xs)
  }
  def `collection.mutable.Seq(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when 'should be less than comparison' failed` {
    val xs = collection.mutable.Seq(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should be < 3
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLessThan(xs, 3, 2) + " in " + xs)
  }
  def `collection.mutable.Seq(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when 'should not be less than comparison' failed` {
    val xs = collection.mutable.Seq(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be < (3)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesMoreThanEqual(xs, 3, 2) + " in " + xs)
  }
  def `collection.mutable.Seq(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when 'should be less than or equal comparison' failed` {
    val xs = collection.mutable.Seq(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should be <= 3
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLessThanEqual(xs, 3, 2) + " in " + xs)
  }
  def `collection.mutable.Seq(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when 'should not be less than or equal comparison' failed` {
    val xs = collection.mutable.Seq(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be <= (3)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesMoreThan(xs, 3, 2) + " in " + xs)
  }
  def `collection.mutable.Seq(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when 'should be greater than comparison' failed` {
    val xs = collection.mutable.Seq(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should be > 3
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesMoreThan(xs, 3, 2) + " in " + xs)
  }
  def `collection.mutable.Seq(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when 'should not be greater than comparison' failed` {
    val xs = collection.mutable.Seq(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be > (3)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLessThanEqual(xs, 3, 2) + " in " + xs)
  }
  def `collection.mutable.Seq(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when 'should be greater than or equal comparison' failed` {
    val xs = collection.mutable.Seq(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should be >= 3
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesMoreThanEqual(xs, 3, 2) + " in " + xs)
  }
  def `collection.mutable.Seq(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when 'should not be greater than or equal comparison' failed` {
    val xs = collection.mutable.Seq(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be >= (3)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLessThan(xs, 3, 2) + " in " + xs)
  }
  def `collection.mutable.Seq(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when 'should not be ===' failed` {
    val xs = collection.mutable.Seq(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be === (3)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqual[Int](xs, 3, 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when more than max element succeeded` {
    val xs = collection.mutable.IndexedSeq(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not equal (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqual[Int](xs, 2, 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when 'should not equal' failed` {
    val xs = collection.mutable.IndexedSeq(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not equal 3
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqual[Int](xs, 3, 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when 'should not be' failed` {
    val xs = collection.mutable.IndexedSeq(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be 3
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqual[Int](xs, 3, 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when 'should be less than comparison' failed` {
    val xs = collection.mutable.IndexedSeq(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should be < 3
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLessThan(xs, 3, 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when 'should not be less than comparison' failed` {
    val xs = collection.mutable.IndexedSeq(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be < (3)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesMoreThanEqual(xs, 3, 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when 'should be less than or equal comparison' failed` {
    val xs = collection.mutable.IndexedSeq(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should be <= 3
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLessThanEqual(xs, 3, 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when 'should not be less than or equal comparison' failed` {
    val xs = collection.mutable.IndexedSeq(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be <= (3)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesMoreThan(xs, 3, 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when 'should be greater than comparison' failed` {
    val xs = collection.mutable.IndexedSeq(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should be > 3
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesMoreThan(xs, 3, 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when 'should not be greater than comparison' failed` {
    val xs = collection.mutable.IndexedSeq(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be > (3)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLessThanEqual(xs, 3, 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when 'should be greater than or equal comparison' failed` {
    val xs = collection.mutable.IndexedSeq(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should be >= 3
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesMoreThanEqual(xs, 3, 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when 'should not be greater than or equal comparison' failed` {
    val xs = collection.mutable.IndexedSeq(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be >= (3)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLessThan(xs, 3, 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq(1, 2, 3, 4, 5) should throw TestFailedException with correct stack depth and message when 'should not be ===' failed` {
    val xs = collection.mutable.IndexedSeq(1, 2, 3, 4, 5)
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be === (3)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqual[Int](xs, 3, 2) + " in " + xs)
  }
  def `collection.mutable.Set(1, 2, 3, 4, 5).par should throw TestFailedException with correct stack depth and message when more than max element succeeded` {
    val xs = collection.mutable.Set(1, 2, 3, 4, 5).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not equal (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqual[Int](xs, 2, 2) + " in " + xs)
  }
  def `collection.mutable.Set(1, 2, 3, 4, 5).par should throw TestFailedException with correct stack depth and message when 'should not equal' failed` {
    val xs = collection.mutable.Set(1, 2, 3, 4, 5).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not equal 3
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqual[Int](xs, 3, 2) + " in " + xs)
  }
  def `collection.mutable.Set(1, 2, 3, 4, 5).par should throw TestFailedException with correct stack depth and message when 'should not be' failed` {
    val xs = collection.mutable.Set(1, 2, 3, 4, 5).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be 3
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqual[Int](xs, 3, 2) + " in " + xs)
  }
  def `collection.mutable.Set(1, 2, 3, 4, 5).par should throw TestFailedException with correct stack depth and message when 'should be less than comparison' failed` {
    val xs = collection.mutable.Set(1, 2, 3, 4, 5).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should be < 3
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLessThan(xs, 3, 2) + " in " + xs)
  }
  def `collection.mutable.Set(1, 2, 3, 4, 5).par should throw TestFailedException with correct stack depth and message when 'should not be less than comparison' failed` {
    val xs = collection.mutable.Set(1, 2, 3, 4, 5).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be < (3)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesMoreThanEqual(xs, 3, 2) + " in " + xs)
  }
  def `collection.mutable.Set(1, 2, 3, 4, 5).par should throw TestFailedException with correct stack depth and message when 'should be less than or equal comparison' failed` {
    val xs = collection.mutable.Set(1, 2, 3, 4, 5).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should be <= 3
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLessThanEqual(xs, 3, 2) + " in " + xs)
  }
  def `collection.mutable.Set(1, 2, 3, 4, 5).par should throw TestFailedException with correct stack depth and message when 'should not be less than or equal comparison' failed` {
    val xs = collection.mutable.Set(1, 2, 3, 4, 5).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be <= (3)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesMoreThan(xs, 3, 2) + " in " + xs)
  }
  def `collection.mutable.Set(1, 2, 3, 4, 5).par should throw TestFailedException with correct stack depth and message when 'should be greater than comparison' failed` {
    val xs = collection.mutable.Set(1, 2, 3, 4, 5).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should be > 3
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesMoreThan(xs, 3, 2) + " in " + xs)
  }
  def `collection.mutable.Set(1, 2, 3, 4, 5).par should throw TestFailedException with correct stack depth and message when 'should not be greater than comparison' failed` {
    val xs = collection.mutable.Set(1, 2, 3, 4, 5).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be > (3)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLessThanEqual(xs, 3, 2) + " in " + xs)
  }
  def `collection.mutable.Set(1, 2, 3, 4, 5).par should throw TestFailedException with correct stack depth and message when 'should be greater than or equal comparison' failed` {
    val xs = collection.mutable.Set(1, 2, 3, 4, 5).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should be >= 3
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesMoreThanEqual(xs, 3, 2) + " in " + xs)
  }
  def `collection.mutable.Set(1, 2, 3, 4, 5).par should throw TestFailedException with correct stack depth and message when 'should not be greater than or equal comparison' failed` {
    val xs = collection.mutable.Set(1, 2, 3, 4, 5).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be >= (3)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLessThan(xs, 3, 2) + " in " + xs)
  }
  def `collection.mutable.Set(1, 2, 3, 4, 5).par should throw TestFailedException with correct stack depth and message when 'should not be ===' failed` {
    val xs = collection.mutable.Set(1, 2, 3, 4, 5).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be === (3)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqual[Int](xs, 3, 2) + " in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List(1, 2, 3, 4, 5)).par should throw TestFailedException with correct stack depth and message when more than max element succeeded` {
    val xs = (new collection.mutable.ListBuffer() ++ List(1, 2, 3, 4, 5)).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not equal (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqual[Int](xs, 2, 2) + " in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List(1, 2, 3, 4, 5)).par should throw TestFailedException with correct stack depth and message when 'should not equal' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List(1, 2, 3, 4, 5)).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not equal 3
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqual[Int](xs, 3, 2) + " in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List(1, 2, 3, 4, 5)).par should throw TestFailedException with correct stack depth and message when 'should not be' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List(1, 2, 3, 4, 5)).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be 3
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqual[Int](xs, 3, 2) + " in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List(1, 2, 3, 4, 5)).par should throw TestFailedException with correct stack depth and message when 'should be less than comparison' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List(1, 2, 3, 4, 5)).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should be < 3
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLessThan(xs, 3, 2) + " in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List(1, 2, 3, 4, 5)).par should throw TestFailedException with correct stack depth and message when 'should not be less than comparison' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List(1, 2, 3, 4, 5)).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be < (3)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesMoreThanEqual(xs, 3, 2) + " in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List(1, 2, 3, 4, 5)).par should throw TestFailedException with correct stack depth and message when 'should be less than or equal comparison' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List(1, 2, 3, 4, 5)).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should be <= 3
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLessThanEqual(xs, 3, 2) + " in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List(1, 2, 3, 4, 5)).par should throw TestFailedException with correct stack depth and message when 'should not be less than or equal comparison' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List(1, 2, 3, 4, 5)).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be <= (3)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesMoreThan(xs, 3, 2) + " in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List(1, 2, 3, 4, 5)).par should throw TestFailedException with correct stack depth and message when 'should be greater than comparison' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List(1, 2, 3, 4, 5)).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should be > 3
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesMoreThan(xs, 3, 2) + " in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List(1, 2, 3, 4, 5)).par should throw TestFailedException with correct stack depth and message when 'should not be greater than comparison' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List(1, 2, 3, 4, 5)).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be > (3)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLessThanEqual(xs, 3, 2) + " in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List(1, 2, 3, 4, 5)).par should throw TestFailedException with correct stack depth and message when 'should be greater than or equal comparison' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List(1, 2, 3, 4, 5)).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should be >= 3
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesMoreThanEqual(xs, 3, 2) + " in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List(1, 2, 3, 4, 5)).par should throw TestFailedException with correct stack depth and message when 'should not be greater than or equal comparison' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List(1, 2, 3, 4, 5)).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be >= (3)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLessThan(xs, 3, 2) + " in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List(1, 2, 3, 4, 5)).par should throw TestFailedException with correct stack depth and message when 'should not be ===' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List(1, 2, 3, 4, 5)).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be === (3)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqual[Int](xs, 3, 2) + " in " + xs)
  }
  def `collection.mutable.Seq(1, 2, 3, 4, 5).par should throw TestFailedException with correct stack depth and message when more than max element succeeded` {
    val xs = collection.mutable.Seq(1, 2, 3, 4, 5).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not equal (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqual[Int](xs, 2, 2) + " in " + xs)
  }
  def `collection.mutable.Seq(1, 2, 3, 4, 5).par should throw TestFailedException with correct stack depth and message when 'should not equal' failed` {
    val xs = collection.mutable.Seq(1, 2, 3, 4, 5).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not equal 3
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqual[Int](xs, 3, 2) + " in " + xs)
  }
  def `collection.mutable.Seq(1, 2, 3, 4, 5).par should throw TestFailedException with correct stack depth and message when 'should not be' failed` {
    val xs = collection.mutable.Seq(1, 2, 3, 4, 5).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be 3
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqual[Int](xs, 3, 2) + " in " + xs)
  }
  def `collection.mutable.Seq(1, 2, 3, 4, 5).par should throw TestFailedException with correct stack depth and message when 'should be less than comparison' failed` {
    val xs = collection.mutable.Seq(1, 2, 3, 4, 5).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should be < 3
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLessThan(xs, 3, 2) + " in " + xs)
  }
  def `collection.mutable.Seq(1, 2, 3, 4, 5).par should throw TestFailedException with correct stack depth and message when 'should not be less than comparison' failed` {
    val xs = collection.mutable.Seq(1, 2, 3, 4, 5).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be < (3)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesMoreThanEqual(xs, 3, 2) + " in " + xs)
  }
  def `collection.mutable.Seq(1, 2, 3, 4, 5).par should throw TestFailedException with correct stack depth and message when 'should be less than or equal comparison' failed` {
    val xs = collection.mutable.Seq(1, 2, 3, 4, 5).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should be <= 3
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLessThanEqual(xs, 3, 2) + " in " + xs)
  }
  def `collection.mutable.Seq(1, 2, 3, 4, 5).par should throw TestFailedException with correct stack depth and message when 'should not be less than or equal comparison' failed` {
    val xs = collection.mutable.Seq(1, 2, 3, 4, 5).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be <= (3)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesMoreThan(xs, 3, 2) + " in " + xs)
  }
  def `collection.mutable.Seq(1, 2, 3, 4, 5).par should throw TestFailedException with correct stack depth and message when 'should be greater than comparison' failed` {
    val xs = collection.mutable.Seq(1, 2, 3, 4, 5).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should be > 3
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesMoreThan(xs, 3, 2) + " in " + xs)
  }
  def `collection.mutable.Seq(1, 2, 3, 4, 5).par should throw TestFailedException with correct stack depth and message when 'should not be greater than comparison' failed` {
    val xs = collection.mutable.Seq(1, 2, 3, 4, 5).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be > (3)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLessThanEqual(xs, 3, 2) + " in " + xs)
  }
  def `collection.mutable.Seq(1, 2, 3, 4, 5).par should throw TestFailedException with correct stack depth and message when 'should be greater than or equal comparison' failed` {
    val xs = collection.mutable.Seq(1, 2, 3, 4, 5).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should be >= 3
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesMoreThanEqual(xs, 3, 2) + " in " + xs)
  }
  def `collection.mutable.Seq(1, 2, 3, 4, 5).par should throw TestFailedException with correct stack depth and message when 'should not be greater than or equal comparison' failed` {
    val xs = collection.mutable.Seq(1, 2, 3, 4, 5).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be >= (3)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLessThan(xs, 3, 2) + " in " + xs)
  }
  def `collection.mutable.Seq(1, 2, 3, 4, 5).par should throw TestFailedException with correct stack depth and message when 'should not be ===' failed` {
    val xs = collection.mutable.Seq(1, 2, 3, 4, 5).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be === (3)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqual[Int](xs, 3, 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq(1, 2, 3, 4, 5).par should throw TestFailedException with correct stack depth and message when more than max element succeeded` {
    val xs = collection.mutable.IndexedSeq(1, 2, 3, 4, 5).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not equal (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqual[Int](xs, 2, 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq(1, 2, 3, 4, 5).par should throw TestFailedException with correct stack depth and message when 'should not equal' failed` {
    val xs = collection.mutable.IndexedSeq(1, 2, 3, 4, 5).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not equal 3
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqual[Int](xs, 3, 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq(1, 2, 3, 4, 5).par should throw TestFailedException with correct stack depth and message when 'should not be' failed` {
    val xs = collection.mutable.IndexedSeq(1, 2, 3, 4, 5).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be 3
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqual[Int](xs, 3, 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq(1, 2, 3, 4, 5).par should throw TestFailedException with correct stack depth and message when 'should be less than comparison' failed` {
    val xs = collection.mutable.IndexedSeq(1, 2, 3, 4, 5).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should be < 3
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLessThan(xs, 3, 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq(1, 2, 3, 4, 5).par should throw TestFailedException with correct stack depth and message when 'should not be less than comparison' failed` {
    val xs = collection.mutable.IndexedSeq(1, 2, 3, 4, 5).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be < (3)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesMoreThanEqual(xs, 3, 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq(1, 2, 3, 4, 5).par should throw TestFailedException with correct stack depth and message when 'should be less than or equal comparison' failed` {
    val xs = collection.mutable.IndexedSeq(1, 2, 3, 4, 5).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should be <= 3
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLessThanEqual(xs, 3, 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq(1, 2, 3, 4, 5).par should throw TestFailedException with correct stack depth and message when 'should not be less than or equal comparison' failed` {
    val xs = collection.mutable.IndexedSeq(1, 2, 3, 4, 5).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be <= (3)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesMoreThan(xs, 3, 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq(1, 2, 3, 4, 5).par should throw TestFailedException with correct stack depth and message when 'should be greater than comparison' failed` {
    val xs = collection.mutable.IndexedSeq(1, 2, 3, 4, 5).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should be > 3
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesMoreThan(xs, 3, 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq(1, 2, 3, 4, 5).par should throw TestFailedException with correct stack depth and message when 'should not be greater than comparison' failed` {
    val xs = collection.mutable.IndexedSeq(1, 2, 3, 4, 5).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be > (3)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLessThanEqual(xs, 3, 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq(1, 2, 3, 4, 5).par should throw TestFailedException with correct stack depth and message when 'should be greater than or equal comparison' failed` {
    val xs = collection.mutable.IndexedSeq(1, 2, 3, 4, 5).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should be >= 3
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesMoreThanEqual(xs, 3, 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq(1, 2, 3, 4, 5).par should throw TestFailedException with correct stack depth and message when 'should not be greater than or equal comparison' failed` {
    val xs = collection.mutable.IndexedSeq(1, 2, 3, 4, 5).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be >= (3)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLessThan(xs, 3, 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq(1, 2, 3, 4, 5).par should throw TestFailedException with correct stack depth and message when 'should not be ===' failed` {
    val xs = collection.mutable.IndexedSeq(1, 2, 3, 4, 5).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be === (3)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqual[Int](xs, 3, 2) + " in " + xs)
  }
  def `Set("1", null, "3") should throw TestFailedException with correct stack depth and message when 'should not be null' failed` {
    val xs = Set("1", null, "3")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be null
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqual[String](xs, null, 2) + " in " + xs)
  }
  def `List("1", null, "3") should throw TestFailedException with correct stack depth and message when 'should not be null' failed` {
    val xs = List("1", null, "3")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be null
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqual[String](xs, null, 2) + " in " + xs)
  }
  def `Seq("1", null, "3") should throw TestFailedException with correct stack depth and message when 'should not be null' failed` {
    val xs = Seq("1", null, "3")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be null
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqual[String](xs, null, 2) + " in " + xs)
  }
  def `Array("1", null, "3") should throw TestFailedException with correct stack depth and message when 'should not be null' failed` {
    val xs = Array("1", null, "3")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be null
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqual[String](Array("1", null, "3"), null, 2) + " in " + "WrappedArray(1, null, 3)")
  }
  def `IndexedSeq("1", null, "3") should throw TestFailedException with correct stack depth and message when 'should not be null' failed` {
    val xs = IndexedSeq("1", null, "3")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be null
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqual[String](xs, null, 2) + " in " + xs)
  }
  def `Vector("1", null, "3") should throw TestFailedException with correct stack depth and message when 'should not be null' failed` {
    val xs = Vector("1", null, "3")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be null
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqual[String](xs, null, 2) + " in " + xs)
  }
  def `Set("1", null, "3").par should throw TestFailedException with correct stack depth and message when 'should not be null' failed` {
    val xs = Set("1", null, "3").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be null
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqual[String](xs, null, 2) + " in " + xs)
  }
  def `List("1", null, "3").par should throw TestFailedException with correct stack depth and message when 'should not be null' failed` {
    val xs = List("1", null, "3").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be null
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqual[String](xs, null, 2) + " in " + xs)
  }
  def `Seq("1", null, "3").par should throw TestFailedException with correct stack depth and message when 'should not be null' failed` {
    val xs = Seq("1", null, "3").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be null
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqual[String](xs, null, 2) + " in " + xs)
  }
  def `IndexedSeq("1", null, "3").par should throw TestFailedException with correct stack depth and message when 'should not be null' failed` {
    val xs = IndexedSeq("1", null, "3").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be null
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqual[String](xs, null, 2) + " in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List("1", null, "3") should throw TestFailedException with correct stack depth and message when 'should not be null' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List("1", null, "3")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be null
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqual[String](xs, null, 2) + " in " + xs)
  }
  def `collection.mutable.Seq("1", null, "3") should throw TestFailedException with correct stack depth and message when 'should not be null' failed` {
    val xs = collection.mutable.Seq("1", null, "3")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be null
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqual[String](xs, null, 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq("1", null, "3") should throw TestFailedException with correct stack depth and message when 'should not be null' failed` {
    val xs = collection.mutable.IndexedSeq("1", null, "3")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be null
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqual[String](xs, null, 2) + " in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List("1", null, "3")).par should throw TestFailedException with correct stack depth and message when 'should not be null' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List("1", null, "3")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be null
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqual[String](xs, null, 2) + " in " + xs)
  }
  def `collection.mutable.Seq("1", null, "3").par should throw TestFailedException with correct stack depth and message when 'should not be null' failed` {
    val xs = collection.mutable.Seq("1", null, "3").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be null
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqual[String](xs, null, 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq("1", null, "3").par should throw TestFailedException with correct stack depth and message when 'should not be null' failed` {
    val xs = collection.mutable.IndexedSeq("1", null, "3").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be null
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqual[String](xs, null, 2) + " in " + xs)
  }
  def `Set("", "boom!", "hi", "cool!", "great!") should throw TestFailedException with correct stack depth and message when 'should not be symbol' failed` {
    val xs = Set("", "boom!", "hi", "cool!", "great!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesIsNotEmpty(xs, "", 2) + " in " + xs)
  }
  def `Set("", "boom!", "hi", "cool!", "great!") should throw TestFailedException with correct stack depth and message when 'should not be property' failed` {
    val xs = Set("", "boom!", "hi", "cool!", "great!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesIsNotEmpty(xs, "", 2) + " in " + xs)
  }
  def `Set("", "boom!", "hi", "cool!", "great!") should throw TestFailedException with correct stack depth and message when 'should not be a symbol' failed` {
    val xs = Set("", "boom!", "hi", "cool!", "great!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be a ('empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesIsNotEmpty(xs, "", 2) + " in " + xs)
  }
  def `Set("", "boom!", "hi", "cool!", "great!") should throw TestFailedException with correct stack depth and message when 'should not be a property' failed` {
    val xs = Set("", "boom!", "hi", "cool!", "great!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be a (empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesIsNotEmpty(xs, "", 2) + " in " + xs)
  }
  def `Set("", "boom!", "hi", "cool!", "great!") should throw TestFailedException with correct stack depth and message when 'should not be an symbol' failed` {
    val xs = Set("", "boom!", "hi", "cool!", "great!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be an ('empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesIsNotEmpty(xs, "", 2) + " in " + xs)
  }
  def `Set("", "boom!", "hi", "cool!", "great!") should throw TestFailedException with correct stack depth and message when 'should not be an property' failed` {
    val xs = Set("", "boom!", "hi", "cool!", "great!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be an (empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesIsNotEmpty(xs, "", 2) + " in " + xs)
  }
  def `Set("", "boom!", "hi", "cool!", "great!") should throw TestFailedException with correct stack depth and message when 'should not have property' failed` {
    val xs = Set("", "boom!", "hi", "cool!", "great!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not have plength(5)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLengthNotEqual(xs, 5, 2) + " in " + xs)
  }
  def `List("", "boom!", "hi", "cool!", "great!") should throw TestFailedException with correct stack depth and message when 'should not be symbol' failed` {
    val xs = List("", "boom!", "hi", "cool!", "great!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesIsNotEmpty(xs, "", 2) + " in " + xs)
  }
  def `List("", "boom!", "hi", "cool!", "great!") should throw TestFailedException with correct stack depth and message when 'should not be property' failed` {
    val xs = List("", "boom!", "hi", "cool!", "great!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesIsNotEmpty(xs, "", 2) + " in " + xs)
  }
  def `List("", "boom!", "hi", "cool!", "great!") should throw TestFailedException with correct stack depth and message when 'should not be a symbol' failed` {
    val xs = List("", "boom!", "hi", "cool!", "great!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be a ('empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesIsNotEmpty(xs, "", 2) + " in " + xs)
  }
  def `List("", "boom!", "hi", "cool!", "great!") should throw TestFailedException with correct stack depth and message when 'should not be a property' failed` {
    val xs = List("", "boom!", "hi", "cool!", "great!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be a (empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesIsNotEmpty(xs, "", 2) + " in " + xs)
  }
  def `List("", "boom!", "hi", "cool!", "great!") should throw TestFailedException with correct stack depth and message when 'should not be an symbol' failed` {
    val xs = List("", "boom!", "hi", "cool!", "great!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be an ('empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesIsNotEmpty(xs, "", 2) + " in " + xs)
  }
  def `List("", "boom!", "hi", "cool!", "great!") should throw TestFailedException with correct stack depth and message when 'should not be an property' failed` {
    val xs = List("", "boom!", "hi", "cool!", "great!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be an (empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesIsNotEmpty(xs, "", 2) + " in " + xs)
  }
  def `List("", "boom!", "hi", "cool!", "great!") should throw TestFailedException with correct stack depth and message when 'should not have property' failed` {
    val xs = List("", "boom!", "hi", "cool!", "great!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not have plength(5)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLengthNotEqual(xs, 5, 2) + " in " + xs)
  }
  def `Seq("", "boom!", "hi", "cool!", "great!") should throw TestFailedException with correct stack depth and message when 'should not be symbol' failed` {
    val xs = Seq("", "boom!", "hi", "cool!", "great!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesIsNotEmpty(xs, "", 2) + " in " + xs)
  }
  def `Seq("", "boom!", "hi", "cool!", "great!") should throw TestFailedException with correct stack depth and message when 'should not be property' failed` {
    val xs = Seq("", "boom!", "hi", "cool!", "great!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesIsNotEmpty(xs, "", 2) + " in " + xs)
  }
  def `Seq("", "boom!", "hi", "cool!", "great!") should throw TestFailedException with correct stack depth and message when 'should not be a symbol' failed` {
    val xs = Seq("", "boom!", "hi", "cool!", "great!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be a ('empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesIsNotEmpty(xs, "", 2) + " in " + xs)
  }
  def `Seq("", "boom!", "hi", "cool!", "great!") should throw TestFailedException with correct stack depth and message when 'should not be a property' failed` {
    val xs = Seq("", "boom!", "hi", "cool!", "great!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be a (empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesIsNotEmpty(xs, "", 2) + " in " + xs)
  }
  def `Seq("", "boom!", "hi", "cool!", "great!") should throw TestFailedException with correct stack depth and message when 'should not be an symbol' failed` {
    val xs = Seq("", "boom!", "hi", "cool!", "great!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be an ('empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesIsNotEmpty(xs, "", 2) + " in " + xs)
  }
  def `Seq("", "boom!", "hi", "cool!", "great!") should throw TestFailedException with correct stack depth and message when 'should not be an property' failed` {
    val xs = Seq("", "boom!", "hi", "cool!", "great!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be an (empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesIsNotEmpty(xs, "", 2) + " in " + xs)
  }
  def `Seq("", "boom!", "hi", "cool!", "great!") should throw TestFailedException with correct stack depth and message when 'should not have property' failed` {
    val xs = Seq("", "boom!", "hi", "cool!", "great!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not have plength(5)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLengthNotEqual(xs, 5, 2) + " in " + xs)
  }
  def `Array("", "boom!", "hi", "cool!", "great!") should throw TestFailedException with correct stack depth and message when 'should not be symbol' failed` {
    val xs = Array("", "boom!", "hi", "cool!", "great!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesIsNotEmpty(Array("", "boom!", "hi", "cool!", "great!"), "", 2) + " in " + "WrappedArray(, boom!, hi, cool!, great!)")
  }
  def `Array("", "boom!", "hi", "cool!", "great!") should throw TestFailedException with correct stack depth and message when 'should not be property' failed` {
    val xs = Array("", "boom!", "hi", "cool!", "great!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesIsNotEmpty(Array("", "boom!", "hi", "cool!", "great!"), "", 2) + " in " + "WrappedArray(, boom!, hi, cool!, great!)")
  }
  def `Array("", "boom!", "hi", "cool!", "great!") should throw TestFailedException with correct stack depth and message when 'should not be a symbol' failed` {
    val xs = Array("", "boom!", "hi", "cool!", "great!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be a ('empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesIsNotEmpty(Array("", "boom!", "hi", "cool!", "great!"), "", 2) + " in " + "WrappedArray(, boom!, hi, cool!, great!)")
  }
  def `Array("", "boom!", "hi", "cool!", "great!") should throw TestFailedException with correct stack depth and message when 'should not be a property' failed` {
    val xs = Array("", "boom!", "hi", "cool!", "great!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be a (empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesIsNotEmpty(Array("", "boom!", "hi", "cool!", "great!"), "", 2) + " in " + "WrappedArray(, boom!, hi, cool!, great!)")
  }
  def `Array("", "boom!", "hi", "cool!", "great!") should throw TestFailedException with correct stack depth and message when 'should not be an symbol' failed` {
    val xs = Array("", "boom!", "hi", "cool!", "great!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be an ('empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesIsNotEmpty(Array("", "boom!", "hi", "cool!", "great!"), "", 2) + " in " + "WrappedArray(, boom!, hi, cool!, great!)")
  }
  def `Array("", "boom!", "hi", "cool!", "great!") should throw TestFailedException with correct stack depth and message when 'should not be an property' failed` {
    val xs = Array("", "boom!", "hi", "cool!", "great!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be an (empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesIsNotEmpty(Array("", "boom!", "hi", "cool!", "great!"), "", 2) + " in " + "WrappedArray(, boom!, hi, cool!, great!)")
  }
  def `Array("", "boom!", "hi", "cool!", "great!") should throw TestFailedException with correct stack depth and message when 'should not have property' failed` {
    val xs = Array("", "boom!", "hi", "cool!", "great!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not have plength(5)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLengthNotEqual(Array("", "boom!", "hi", "cool!", "great!"), 5, 2) + " in " + "WrappedArray(, boom!, hi, cool!, great!)")
  }
  def `IndexedSeq("", "boom!", "hi", "cool!", "great!") should throw TestFailedException with correct stack depth and message when 'should not be symbol' failed` {
    val xs = IndexedSeq("", "boom!", "hi", "cool!", "great!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesIsNotEmpty(xs, "", 2) + " in " + xs)
  }
  def `IndexedSeq("", "boom!", "hi", "cool!", "great!") should throw TestFailedException with correct stack depth and message when 'should not be property' failed` {
    val xs = IndexedSeq("", "boom!", "hi", "cool!", "great!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesIsNotEmpty(xs, "", 2) + " in " + xs)
  }
  def `IndexedSeq("", "boom!", "hi", "cool!", "great!") should throw TestFailedException with correct stack depth and message when 'should not be a symbol' failed` {
    val xs = IndexedSeq("", "boom!", "hi", "cool!", "great!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be a ('empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesIsNotEmpty(xs, "", 2) + " in " + xs)
  }
  def `IndexedSeq("", "boom!", "hi", "cool!", "great!") should throw TestFailedException with correct stack depth and message when 'should not be a property' failed` {
    val xs = IndexedSeq("", "boom!", "hi", "cool!", "great!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be a (empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesIsNotEmpty(xs, "", 2) + " in " + xs)
  }
  def `IndexedSeq("", "boom!", "hi", "cool!", "great!") should throw TestFailedException with correct stack depth and message when 'should not be an symbol' failed` {
    val xs = IndexedSeq("", "boom!", "hi", "cool!", "great!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be an ('empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesIsNotEmpty(xs, "", 2) + " in " + xs)
  }
  def `IndexedSeq("", "boom!", "hi", "cool!", "great!") should throw TestFailedException with correct stack depth and message when 'should not be an property' failed` {
    val xs = IndexedSeq("", "boom!", "hi", "cool!", "great!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be an (empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesIsNotEmpty(xs, "", 2) + " in " + xs)
  }
  def `IndexedSeq("", "boom!", "hi", "cool!", "great!") should throw TestFailedException with correct stack depth and message when 'should not have property' failed` {
    val xs = IndexedSeq("", "boom!", "hi", "cool!", "great!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not have plength(5)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLengthNotEqual(xs, 5, 2) + " in " + xs)
  }
  def `Vector("", "boom!", "hi", "cool!", "great!") should throw TestFailedException with correct stack depth and message when 'should not be symbol' failed` {
    val xs = Vector("", "boom!", "hi", "cool!", "great!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesIsNotEmpty(xs, "", 2) + " in " + xs)
  }
  def `Vector("", "boom!", "hi", "cool!", "great!") should throw TestFailedException with correct stack depth and message when 'should not be property' failed` {
    val xs = Vector("", "boom!", "hi", "cool!", "great!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesIsNotEmpty(xs, "", 2) + " in " + xs)
  }
  def `Vector("", "boom!", "hi", "cool!", "great!") should throw TestFailedException with correct stack depth and message when 'should not be a symbol' failed` {
    val xs = Vector("", "boom!", "hi", "cool!", "great!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be a ('empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesIsNotEmpty(xs, "", 2) + " in " + xs)
  }
  def `Vector("", "boom!", "hi", "cool!", "great!") should throw TestFailedException with correct stack depth and message when 'should not be a property' failed` {
    val xs = Vector("", "boom!", "hi", "cool!", "great!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be a (empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesIsNotEmpty(xs, "", 2) + " in " + xs)
  }
  def `Vector("", "boom!", "hi", "cool!", "great!") should throw TestFailedException with correct stack depth and message when 'should not be an symbol' failed` {
    val xs = Vector("", "boom!", "hi", "cool!", "great!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be an ('empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesIsNotEmpty(xs, "", 2) + " in " + xs)
  }
  def `Vector("", "boom!", "hi", "cool!", "great!") should throw TestFailedException with correct stack depth and message when 'should not be an property' failed` {
    val xs = Vector("", "boom!", "hi", "cool!", "great!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be an (empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesIsNotEmpty(xs, "", 2) + " in " + xs)
  }
  def `Vector("", "boom!", "hi", "cool!", "great!") should throw TestFailedException with correct stack depth and message when 'should not have property' failed` {
    val xs = Vector("", "boom!", "hi", "cool!", "great!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not have plength(5)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLengthNotEqual(xs, 5, 2) + " in " + xs)
  }
  def `Set("", "boom!", "hi", "cool!", "great!").par should throw TestFailedException with correct stack depth and message when 'should not be symbol' failed` {
    val xs = Set("", "boom!", "hi", "cool!", "great!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesIsNotEmpty(xs, "", 2) + " in " + xs)
  }
  def `Set("", "boom!", "hi", "cool!", "great!").par should throw TestFailedException with correct stack depth and message when 'should not be property' failed` {
    val xs = Set("", "boom!", "hi", "cool!", "great!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesIsNotEmpty(xs, "", 2) + " in " + xs)
  }
  def `Set("", "boom!", "hi", "cool!", "great!").par should throw TestFailedException with correct stack depth and message when 'should not be a symbol' failed` {
    val xs = Set("", "boom!", "hi", "cool!", "great!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be a ('empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesIsNotEmpty(xs, "", 2) + " in " + xs)
  }
  def `Set("", "boom!", "hi", "cool!", "great!").par should throw TestFailedException with correct stack depth and message when 'should not be a property' failed` {
    val xs = Set("", "boom!", "hi", "cool!", "great!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be a (empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesIsNotEmpty(xs, "", 2) + " in " + xs)
  }
  def `Set("", "boom!", "hi", "cool!", "great!").par should throw TestFailedException with correct stack depth and message when 'should not be an symbol' failed` {
    val xs = Set("", "boom!", "hi", "cool!", "great!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be an ('empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesIsNotEmpty(xs, "", 2) + " in " + xs)
  }
  def `Set("", "boom!", "hi", "cool!", "great!").par should throw TestFailedException with correct stack depth and message when 'should not be an property' failed` {
    val xs = Set("", "boom!", "hi", "cool!", "great!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be an (empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesIsNotEmpty(xs, "", 2) + " in " + xs)
  }
  def `Set("", "boom!", "hi", "cool!", "great!").par should throw TestFailedException with correct stack depth and message when 'should not have property' failed` {
    val xs = Set("", "boom!", "hi", "cool!", "great!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not have plength(5)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLengthNotEqual(xs, 5, 2) + " in " + xs)
  }
  def `List("", "boom!", "hi", "cool!", "great!").par should throw TestFailedException with correct stack depth and message when 'should not be symbol' failed` {
    val xs = List("", "boom!", "hi", "cool!", "great!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesIsNotEmpty(xs, "", 2) + " in " + xs)
  }
  def `List("", "boom!", "hi", "cool!", "great!").par should throw TestFailedException with correct stack depth and message when 'should not be property' failed` {
    val xs = List("", "boom!", "hi", "cool!", "great!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesIsNotEmpty(xs, "", 2) + " in " + xs)
  }
  def `List("", "boom!", "hi", "cool!", "great!").par should throw TestFailedException with correct stack depth and message when 'should not be a symbol' failed` {
    val xs = List("", "boom!", "hi", "cool!", "great!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be a ('empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesIsNotEmpty(xs, "", 2) + " in " + xs)
  }
  def `List("", "boom!", "hi", "cool!", "great!").par should throw TestFailedException with correct stack depth and message when 'should not be a property' failed` {
    val xs = List("", "boom!", "hi", "cool!", "great!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be a (empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesIsNotEmpty(xs, "", 2) + " in " + xs)
  }
  def `List("", "boom!", "hi", "cool!", "great!").par should throw TestFailedException with correct stack depth and message when 'should not be an symbol' failed` {
    val xs = List("", "boom!", "hi", "cool!", "great!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be an ('empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesIsNotEmpty(xs, "", 2) + " in " + xs)
  }
  def `List("", "boom!", "hi", "cool!", "great!").par should throw TestFailedException with correct stack depth and message when 'should not be an property' failed` {
    val xs = List("", "boom!", "hi", "cool!", "great!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be an (empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesIsNotEmpty(xs, "", 2) + " in " + xs)
  }
  def `List("", "boom!", "hi", "cool!", "great!").par should throw TestFailedException with correct stack depth and message when 'should not have property' failed` {
    val xs = List("", "boom!", "hi", "cool!", "great!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not have plength(5)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLengthNotEqual(xs, 5, 2) + " in " + xs)
  }
  def `Seq("", "boom!", "hi", "cool!", "great!").par should throw TestFailedException with correct stack depth and message when 'should not be symbol' failed` {
    val xs = Seq("", "boom!", "hi", "cool!", "great!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesIsNotEmpty(xs, "", 2) + " in " + xs)
  }
  def `Seq("", "boom!", "hi", "cool!", "great!").par should throw TestFailedException with correct stack depth and message when 'should not be property' failed` {
    val xs = Seq("", "boom!", "hi", "cool!", "great!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesIsNotEmpty(xs, "", 2) + " in " + xs)
  }
  def `Seq("", "boom!", "hi", "cool!", "great!").par should throw TestFailedException with correct stack depth and message when 'should not be a symbol' failed` {
    val xs = Seq("", "boom!", "hi", "cool!", "great!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be a ('empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesIsNotEmpty(xs, "", 2) + " in " + xs)
  }
  def `Seq("", "boom!", "hi", "cool!", "great!").par should throw TestFailedException with correct stack depth and message when 'should not be a property' failed` {
    val xs = Seq("", "boom!", "hi", "cool!", "great!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be a (empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesIsNotEmpty(xs, "", 2) + " in " + xs)
  }
  def `Seq("", "boom!", "hi", "cool!", "great!").par should throw TestFailedException with correct stack depth and message when 'should not be an symbol' failed` {
    val xs = Seq("", "boom!", "hi", "cool!", "great!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be an ('empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesIsNotEmpty(xs, "", 2) + " in " + xs)
  }
  def `Seq("", "boom!", "hi", "cool!", "great!").par should throw TestFailedException with correct stack depth and message when 'should not be an property' failed` {
    val xs = Seq("", "boom!", "hi", "cool!", "great!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be an (empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesIsNotEmpty(xs, "", 2) + " in " + xs)
  }
  def `Seq("", "boom!", "hi", "cool!", "great!").par should throw TestFailedException with correct stack depth and message when 'should not have property' failed` {
    val xs = Seq("", "boom!", "hi", "cool!", "great!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not have plength(5)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLengthNotEqual(xs, 5, 2) + " in " + xs)
  }
  def `IndexedSeq("", "boom!", "hi", "cool!", "great!").par should throw TestFailedException with correct stack depth and message when 'should not be symbol' failed` {
    val xs = IndexedSeq("", "boom!", "hi", "cool!", "great!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesIsNotEmpty(xs, "", 2) + " in " + xs)
  }
  def `IndexedSeq("", "boom!", "hi", "cool!", "great!").par should throw TestFailedException with correct stack depth and message when 'should not be property' failed` {
    val xs = IndexedSeq("", "boom!", "hi", "cool!", "great!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesIsNotEmpty(xs, "", 2) + " in " + xs)
  }
  def `IndexedSeq("", "boom!", "hi", "cool!", "great!").par should throw TestFailedException with correct stack depth and message when 'should not be a symbol' failed` {
    val xs = IndexedSeq("", "boom!", "hi", "cool!", "great!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be a ('empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesIsNotEmpty(xs, "", 2) + " in " + xs)
  }
  def `IndexedSeq("", "boom!", "hi", "cool!", "great!").par should throw TestFailedException with correct stack depth and message when 'should not be a property' failed` {
    val xs = IndexedSeq("", "boom!", "hi", "cool!", "great!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be a (empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesIsNotEmpty(xs, "", 2) + " in " + xs)
  }
  def `IndexedSeq("", "boom!", "hi", "cool!", "great!").par should throw TestFailedException with correct stack depth and message when 'should not be an symbol' failed` {
    val xs = IndexedSeq("", "boom!", "hi", "cool!", "great!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be an ('empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesIsNotEmpty(xs, "", 2) + " in " + xs)
  }
  def `IndexedSeq("", "boom!", "hi", "cool!", "great!").par should throw TestFailedException with correct stack depth and message when 'should not be an property' failed` {
    val xs = IndexedSeq("", "boom!", "hi", "cool!", "great!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be an (empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesIsNotEmpty(xs, "", 2) + " in " + xs)
  }
  def `IndexedSeq("", "boom!", "hi", "cool!", "great!").par should throw TestFailedException with correct stack depth and message when 'should not have property' failed` {
    val xs = IndexedSeq("", "boom!", "hi", "cool!", "great!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not have plength(5)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLengthNotEqual(xs, 5, 2) + " in " + xs)
  }
  def `collection.mutable.Set("", "boom!", "hi", "cool!", "great!") should throw TestFailedException with correct stack depth and message when 'should not be symbol' failed` {
    val xs = collection.mutable.Set("", "boom!", "hi", "cool!", "great!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesIsNotEmpty(xs, "", 2) + " in " + xs)
  }
  def `collection.mutable.Set("", "boom!", "hi", "cool!", "great!") should throw TestFailedException with correct stack depth and message when 'should not be property' failed` {
    val xs = collection.mutable.Set("", "boom!", "hi", "cool!", "great!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesIsNotEmpty(xs, "", 2) + " in " + xs)
  }
  def `collection.mutable.Set("", "boom!", "hi", "cool!", "great!") should throw TestFailedException with correct stack depth and message when 'should not be a symbol' failed` {
    val xs = collection.mutable.Set("", "boom!", "hi", "cool!", "great!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be a ('empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesIsNotEmpty(xs, "", 2) + " in " + xs)
  }
  def `collection.mutable.Set("", "boom!", "hi", "cool!", "great!") should throw TestFailedException with correct stack depth and message when 'should not be a property' failed` {
    val xs = collection.mutable.Set("", "boom!", "hi", "cool!", "great!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be a (empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesIsNotEmpty(xs, "", 2) + " in " + xs)
  }
  def `collection.mutable.Set("", "boom!", "hi", "cool!", "great!") should throw TestFailedException with correct stack depth and message when 'should not be an symbol' failed` {
    val xs = collection.mutable.Set("", "boom!", "hi", "cool!", "great!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be an ('empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesIsNotEmpty(xs, "", 2) + " in " + xs)
  }
  def `collection.mutable.Set("", "boom!", "hi", "cool!", "great!") should throw TestFailedException with correct stack depth and message when 'should not be an property' failed` {
    val xs = collection.mutable.Set("", "boom!", "hi", "cool!", "great!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be an (empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesIsNotEmpty(xs, "", 2) + " in " + xs)
  }
  def `collection.mutable.Set("", "boom!", "hi", "cool!", "great!") should throw TestFailedException with correct stack depth and message when 'should not have property' failed` {
    val xs = collection.mutable.Set("", "boom!", "hi", "cool!", "great!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not have plength(5)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLengthNotEqual(xs, 5, 2) + " in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List("", "boom!", "hi", "cool!", "great!") should throw TestFailedException with correct stack depth and message when 'should not be symbol' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List("", "boom!", "hi", "cool!", "great!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesIsNotEmpty(xs, "", 2) + " in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List("", "boom!", "hi", "cool!", "great!") should throw TestFailedException with correct stack depth and message when 'should not be property' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List("", "boom!", "hi", "cool!", "great!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesIsNotEmpty(xs, "", 2) + " in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List("", "boom!", "hi", "cool!", "great!") should throw TestFailedException with correct stack depth and message when 'should not be a symbol' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List("", "boom!", "hi", "cool!", "great!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be a ('empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesIsNotEmpty(xs, "", 2) + " in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List("", "boom!", "hi", "cool!", "great!") should throw TestFailedException with correct stack depth and message when 'should not be a property' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List("", "boom!", "hi", "cool!", "great!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be a (empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesIsNotEmpty(xs, "", 2) + " in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List("", "boom!", "hi", "cool!", "great!") should throw TestFailedException with correct stack depth and message when 'should not be an symbol' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List("", "boom!", "hi", "cool!", "great!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be an ('empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesIsNotEmpty(xs, "", 2) + " in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List("", "boom!", "hi", "cool!", "great!") should throw TestFailedException with correct stack depth and message when 'should not be an property' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List("", "boom!", "hi", "cool!", "great!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be an (empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesIsNotEmpty(xs, "", 2) + " in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List("", "boom!", "hi", "cool!", "great!") should throw TestFailedException with correct stack depth and message when 'should not have property' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List("", "boom!", "hi", "cool!", "great!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not have plength(5)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLengthNotEqual(xs, 5, 2) + " in " + xs)
  }
  def `collection.mutable.Seq("", "boom!", "hi", "cool!", "great!") should throw TestFailedException with correct stack depth and message when 'should not be symbol' failed` {
    val xs = collection.mutable.Seq("", "boom!", "hi", "cool!", "great!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesIsNotEmpty(xs, "", 2) + " in " + xs)
  }
  def `collection.mutable.Seq("", "boom!", "hi", "cool!", "great!") should throw TestFailedException with correct stack depth and message when 'should not be property' failed` {
    val xs = collection.mutable.Seq("", "boom!", "hi", "cool!", "great!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesIsNotEmpty(xs, "", 2) + " in " + xs)
  }
  def `collection.mutable.Seq("", "boom!", "hi", "cool!", "great!") should throw TestFailedException with correct stack depth and message when 'should not be a symbol' failed` {
    val xs = collection.mutable.Seq("", "boom!", "hi", "cool!", "great!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be a ('empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesIsNotEmpty(xs, "", 2) + " in " + xs)
  }
  def `collection.mutable.Seq("", "boom!", "hi", "cool!", "great!") should throw TestFailedException with correct stack depth and message when 'should not be a property' failed` {
    val xs = collection.mutable.Seq("", "boom!", "hi", "cool!", "great!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be a (empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesIsNotEmpty(xs, "", 2) + " in " + xs)
  }
  def `collection.mutable.Seq("", "boom!", "hi", "cool!", "great!") should throw TestFailedException with correct stack depth and message when 'should not be an symbol' failed` {
    val xs = collection.mutable.Seq("", "boom!", "hi", "cool!", "great!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be an ('empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesIsNotEmpty(xs, "", 2) + " in " + xs)
  }
  def `collection.mutable.Seq("", "boom!", "hi", "cool!", "great!") should throw TestFailedException with correct stack depth and message when 'should not be an property' failed` {
    val xs = collection.mutable.Seq("", "boom!", "hi", "cool!", "great!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be an (empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesIsNotEmpty(xs, "", 2) + " in " + xs)
  }
  def `collection.mutable.Seq("", "boom!", "hi", "cool!", "great!") should throw TestFailedException with correct stack depth and message when 'should not have property' failed` {
    val xs = collection.mutable.Seq("", "boom!", "hi", "cool!", "great!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not have plength(5)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLengthNotEqual(xs, 5, 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq("", "boom!", "hi", "cool!", "great!") should throw TestFailedException with correct stack depth and message when 'should not be symbol' failed` {
    val xs = collection.mutable.IndexedSeq("", "boom!", "hi", "cool!", "great!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesIsNotEmpty(xs, "", 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq("", "boom!", "hi", "cool!", "great!") should throw TestFailedException with correct stack depth and message when 'should not be property' failed` {
    val xs = collection.mutable.IndexedSeq("", "boom!", "hi", "cool!", "great!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesIsNotEmpty(xs, "", 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq("", "boom!", "hi", "cool!", "great!") should throw TestFailedException with correct stack depth and message when 'should not be a symbol' failed` {
    val xs = collection.mutable.IndexedSeq("", "boom!", "hi", "cool!", "great!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be a ('empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesIsNotEmpty(xs, "", 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq("", "boom!", "hi", "cool!", "great!") should throw TestFailedException with correct stack depth and message when 'should not be a property' failed` {
    val xs = collection.mutable.IndexedSeq("", "boom!", "hi", "cool!", "great!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be a (empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesIsNotEmpty(xs, "", 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq("", "boom!", "hi", "cool!", "great!") should throw TestFailedException with correct stack depth and message when 'should not be an symbol' failed` {
    val xs = collection.mutable.IndexedSeq("", "boom!", "hi", "cool!", "great!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be an ('empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesIsNotEmpty(xs, "", 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq("", "boom!", "hi", "cool!", "great!") should throw TestFailedException with correct stack depth and message when 'should not be an property' failed` {
    val xs = collection.mutable.IndexedSeq("", "boom!", "hi", "cool!", "great!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be an (empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesIsNotEmpty(xs, "", 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq("", "boom!", "hi", "cool!", "great!") should throw TestFailedException with correct stack depth and message when 'should not have property' failed` {
    val xs = collection.mutable.IndexedSeq("", "boom!", "hi", "cool!", "great!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not have plength(5)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLengthNotEqual(xs, 5, 2) + " in " + xs)
  }
  def `collection.mutable.Set("", "boom!", "hi", "cool!", "great!").par should throw TestFailedException with correct stack depth and message when 'should not be symbol' failed` {
    val xs = collection.mutable.Set("", "boom!", "hi", "cool!", "great!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesIsNotEmpty(xs, "", 2) + " in " + xs)
  }
  def `collection.mutable.Set("", "boom!", "hi", "cool!", "great!").par should throw TestFailedException with correct stack depth and message when 'should not be property' failed` {
    val xs = collection.mutable.Set("", "boom!", "hi", "cool!", "great!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesIsNotEmpty(xs, "", 2) + " in " + xs)
  }
  def `collection.mutable.Set("", "boom!", "hi", "cool!", "great!").par should throw TestFailedException with correct stack depth and message when 'should not be a symbol' failed` {
    val xs = collection.mutable.Set("", "boom!", "hi", "cool!", "great!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be a ('empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesIsNotEmpty(xs, "", 2) + " in " + xs)
  }
  def `collection.mutable.Set("", "boom!", "hi", "cool!", "great!").par should throw TestFailedException with correct stack depth and message when 'should not be a property' failed` {
    val xs = collection.mutable.Set("", "boom!", "hi", "cool!", "great!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be a (empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesIsNotEmpty(xs, "", 2) + " in " + xs)
  }
  def `collection.mutable.Set("", "boom!", "hi", "cool!", "great!").par should throw TestFailedException with correct stack depth and message when 'should not be an symbol' failed` {
    val xs = collection.mutable.Set("", "boom!", "hi", "cool!", "great!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be an ('empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesIsNotEmpty(xs, "", 2) + " in " + xs)
  }
  def `collection.mutable.Set("", "boom!", "hi", "cool!", "great!").par should throw TestFailedException with correct stack depth and message when 'should not be an property' failed` {
    val xs = collection.mutable.Set("", "boom!", "hi", "cool!", "great!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be an (empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesIsNotEmpty(xs, "", 2) + " in " + xs)
  }
  def `collection.mutable.Set("", "boom!", "hi", "cool!", "great!").par should throw TestFailedException with correct stack depth and message when 'should not have property' failed` {
    val xs = collection.mutable.Set("", "boom!", "hi", "cool!", "great!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not have plength(5)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLengthNotEqual(xs, 5, 2) + " in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List("", "boom!", "hi", "cool!", "great!")).par should throw TestFailedException with correct stack depth and message when 'should not be symbol' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List("", "boom!", "hi", "cool!", "great!")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesIsNotEmpty(xs, "", 2) + " in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List("", "boom!", "hi", "cool!", "great!")).par should throw TestFailedException with correct stack depth and message when 'should not be property' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List("", "boom!", "hi", "cool!", "great!")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesIsNotEmpty(xs, "", 2) + " in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List("", "boom!", "hi", "cool!", "great!")).par should throw TestFailedException with correct stack depth and message when 'should not be a symbol' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List("", "boom!", "hi", "cool!", "great!")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be a ('empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesIsNotEmpty(xs, "", 2) + " in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List("", "boom!", "hi", "cool!", "great!")).par should throw TestFailedException with correct stack depth and message when 'should not be a property' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List("", "boom!", "hi", "cool!", "great!")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be a (empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesIsNotEmpty(xs, "", 2) + " in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List("", "boom!", "hi", "cool!", "great!")).par should throw TestFailedException with correct stack depth and message when 'should not be an symbol' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List("", "boom!", "hi", "cool!", "great!")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be an ('empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesIsNotEmpty(xs, "", 2) + " in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List("", "boom!", "hi", "cool!", "great!")).par should throw TestFailedException with correct stack depth and message when 'should not be an property' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List("", "boom!", "hi", "cool!", "great!")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be an (empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesIsNotEmpty(xs, "", 2) + " in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List("", "boom!", "hi", "cool!", "great!")).par should throw TestFailedException with correct stack depth and message when 'should not have property' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List("", "boom!", "hi", "cool!", "great!")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not have plength(5)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLengthNotEqual(xs, 5, 2) + " in " + xs)
  }
  def `collection.mutable.Seq("", "boom!", "hi", "cool!", "great!").par should throw TestFailedException with correct stack depth and message when 'should not be symbol' failed` {
    val xs = collection.mutable.Seq("", "boom!", "hi", "cool!", "great!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesIsNotEmpty(xs, "", 2) + " in " + xs)
  }
  def `collection.mutable.Seq("", "boom!", "hi", "cool!", "great!").par should throw TestFailedException with correct stack depth and message when 'should not be property' failed` {
    val xs = collection.mutable.Seq("", "boom!", "hi", "cool!", "great!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesIsNotEmpty(xs, "", 2) + " in " + xs)
  }
  def `collection.mutable.Seq("", "boom!", "hi", "cool!", "great!").par should throw TestFailedException with correct stack depth and message when 'should not be a symbol' failed` {
    val xs = collection.mutable.Seq("", "boom!", "hi", "cool!", "great!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be a ('empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesIsNotEmpty(xs, "", 2) + " in " + xs)
  }
  def `collection.mutable.Seq("", "boom!", "hi", "cool!", "great!").par should throw TestFailedException with correct stack depth and message when 'should not be a property' failed` {
    val xs = collection.mutable.Seq("", "boom!", "hi", "cool!", "great!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be a (empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesIsNotEmpty(xs, "", 2) + " in " + xs)
  }
  def `collection.mutable.Seq("", "boom!", "hi", "cool!", "great!").par should throw TestFailedException with correct stack depth and message when 'should not be an symbol' failed` {
    val xs = collection.mutable.Seq("", "boom!", "hi", "cool!", "great!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be an ('empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesIsNotEmpty(xs, "", 2) + " in " + xs)
  }
  def `collection.mutable.Seq("", "boom!", "hi", "cool!", "great!").par should throw TestFailedException with correct stack depth and message when 'should not be an property' failed` {
    val xs = collection.mutable.Seq("", "boom!", "hi", "cool!", "great!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be an (empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesIsNotEmpty(xs, "", 2) + " in " + xs)
  }
  def `collection.mutable.Seq("", "boom!", "hi", "cool!", "great!").par should throw TestFailedException with correct stack depth and message when 'should not have property' failed` {
    val xs = collection.mutable.Seq("", "boom!", "hi", "cool!", "great!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not have plength(5)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLengthNotEqual(xs, 5, 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq("", "boom!", "hi", "cool!", "great!").par should throw TestFailedException with correct stack depth and message when 'should not be symbol' failed` {
    val xs = collection.mutable.IndexedSeq("", "boom!", "hi", "cool!", "great!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesIsNotEmpty(xs, "", 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq("", "boom!", "hi", "cool!", "great!").par should throw TestFailedException with correct stack depth and message when 'should not be property' failed` {
    val xs = collection.mutable.IndexedSeq("", "boom!", "hi", "cool!", "great!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesIsNotEmpty(xs, "", 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq("", "boom!", "hi", "cool!", "great!").par should throw TestFailedException with correct stack depth and message when 'should not be a symbol' failed` {
    val xs = collection.mutable.IndexedSeq("", "boom!", "hi", "cool!", "great!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be a ('empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesIsNotEmpty(xs, "", 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq("", "boom!", "hi", "cool!", "great!").par should throw TestFailedException with correct stack depth and message when 'should not be a property' failed` {
    val xs = collection.mutable.IndexedSeq("", "boom!", "hi", "cool!", "great!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be a (empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesIsNotEmpty(xs, "", 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq("", "boom!", "hi", "cool!", "great!").par should throw TestFailedException with correct stack depth and message when 'should not be an symbol' failed` {
    val xs = collection.mutable.IndexedSeq("", "boom!", "hi", "cool!", "great!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be an ('empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesIsNotEmpty(xs, "", 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq("", "boom!", "hi", "cool!", "great!").par should throw TestFailedException with correct stack depth and message when 'should not be an property' failed` {
    val xs = collection.mutable.IndexedSeq("", "boom!", "hi", "cool!", "great!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be an (empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesIsNotEmpty(xs, "", 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq("", "boom!", "hi", "cool!", "great!").par should throw TestFailedException with correct stack depth and message when 'should not have property' failed` {
    val xs = collection.mutable.IndexedSeq("", "boom!", "hi", "cool!", "great!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not have plength(5)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLengthNotEqual(xs, 5, 2) + " in " + xs)
  }
  def `Set("", "boom!", "hi", "cool!", "great!") should throw TestFailedException with correct stack depth and message when 'should have size' failed` {
    val xs = Set("", "boom!", "hi", "cool!", "great!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should have size 5
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeEqual(xs, 5, 2) + " in " + xs)
  }
  def `Set("", "boom!", "hi", "cool!", "great!") should throw TestFailedException with correct stack depth and message when 'should not have size' failed` {
    val xs = Set("", "boom!", "hi", "cool!", "great!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not have size (5)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeNotEqual(xs, 5, 2) + " in " + xs)
  }
  def `List("", "boom!", "hi", "cool!", "great!") should throw TestFailedException with correct stack depth and message when 'should have length' failed` {
    val xs = List("", "boom!", "hi", "cool!", "great!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should have length 5
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLengthEqual(xs, 5, 2) + " in " + xs)
  }
  def `List("", "boom!", "hi", "cool!", "great!") should throw TestFailedException with correct stack depth and message when 'should not have length' failed` {
    val xs = List("", "boom!", "hi", "cool!", "great!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not have length (5)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLengthNotEqual(xs, 5, 2) + " in " + xs)
  }
  def `List("", "boom!", "hi", "cool!", "great!") should throw TestFailedException with correct stack depth and message when 'should have size' failed` {
    val xs = List("", "boom!", "hi", "cool!", "great!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should have size 5
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeEqual(xs, 5, 2) + " in " + xs)
  }
  def `List("", "boom!", "hi", "cool!", "great!") should throw TestFailedException with correct stack depth and message when 'should not have size' failed` {
    val xs = List("", "boom!", "hi", "cool!", "great!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not have size (5)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeNotEqual(xs, 5, 2) + " in " + xs)
  }
  def `Seq("", "boom!", "hi", "cool!", "great!") should throw TestFailedException with correct stack depth and message when 'should have length' failed` {
    val xs = Seq("", "boom!", "hi", "cool!", "great!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should have length 5
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLengthEqual(xs, 5, 2) + " in " + xs)
  }
  def `Seq("", "boom!", "hi", "cool!", "great!") should throw TestFailedException with correct stack depth and message when 'should not have length' failed` {
    val xs = Seq("", "boom!", "hi", "cool!", "great!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not have length (5)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLengthNotEqual(xs, 5, 2) + " in " + xs)
  }
  def `Seq("", "boom!", "hi", "cool!", "great!") should throw TestFailedException with correct stack depth and message when 'should have size' failed` {
    val xs = Seq("", "boom!", "hi", "cool!", "great!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should have size 5
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeEqual(xs, 5, 2) + " in " + xs)
  }
  def `Seq("", "boom!", "hi", "cool!", "great!") should throw TestFailedException with correct stack depth and message when 'should not have size' failed` {
    val xs = Seq("", "boom!", "hi", "cool!", "great!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not have size (5)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeNotEqual(xs, 5, 2) + " in " + xs)
  }
  def `Array("", "boom!", "hi", "cool!", "great!") should throw TestFailedException with correct stack depth and message when 'should have length' failed` {
    val xs = Array("", "boom!", "hi", "cool!", "great!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should have length 5
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLengthEqual(Array("", "boom!", "hi", "cool!", "great!"), 5, 2) + " in " + "WrappedArray(, boom!, hi, cool!, great!)")
  }
  def `Array("", "boom!", "hi", "cool!", "great!") should throw TestFailedException with correct stack depth and message when 'should not have length' failed` {
    val xs = Array("", "boom!", "hi", "cool!", "great!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not have length (5)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLengthNotEqual(Array("", "boom!", "hi", "cool!", "great!"), 5, 2) + " in " + "WrappedArray(, boom!, hi, cool!, great!)")
  }
  def `Array("", "boom!", "hi", "cool!", "great!") should throw TestFailedException with correct stack depth and message when 'should have size' failed` {
    val xs = Array("", "boom!", "hi", "cool!", "great!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should have size 5
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeEqual(Array("", "boom!", "hi", "cool!", "great!"), 5, 2) + " in " + "WrappedArray(, boom!, hi, cool!, great!)")
  }
  def `Array("", "boom!", "hi", "cool!", "great!") should throw TestFailedException with correct stack depth and message when 'should not have size' failed` {
    val xs = Array("", "boom!", "hi", "cool!", "great!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not have size (5)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeNotEqual(Array("", "boom!", "hi", "cool!", "great!"), 5, 2) + " in " + "WrappedArray(, boom!, hi, cool!, great!)")
  }
  def `IndexedSeq("", "boom!", "hi", "cool!", "great!") should throw TestFailedException with correct stack depth and message when 'should have length' failed` {
    val xs = IndexedSeq("", "boom!", "hi", "cool!", "great!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should have length 5
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLengthEqual(xs, 5, 2) + " in " + xs)
  }
  def `IndexedSeq("", "boom!", "hi", "cool!", "great!") should throw TestFailedException with correct stack depth and message when 'should not have length' failed` {
    val xs = IndexedSeq("", "boom!", "hi", "cool!", "great!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not have length (5)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLengthNotEqual(xs, 5, 2) + " in " + xs)
  }
  def `IndexedSeq("", "boom!", "hi", "cool!", "great!") should throw TestFailedException with correct stack depth and message when 'should have size' failed` {
    val xs = IndexedSeq("", "boom!", "hi", "cool!", "great!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should have size 5
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeEqual(xs, 5, 2) + " in " + xs)
  }
  def `IndexedSeq("", "boom!", "hi", "cool!", "great!") should throw TestFailedException with correct stack depth and message when 'should not have size' failed` {
    val xs = IndexedSeq("", "boom!", "hi", "cool!", "great!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not have size (5)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeNotEqual(xs, 5, 2) + " in " + xs)
  }
  def `Vector("", "boom!", "hi", "cool!", "great!") should throw TestFailedException with correct stack depth and message when 'should have length' failed` {
    val xs = Vector("", "boom!", "hi", "cool!", "great!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should have length 5
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLengthEqual(xs, 5, 2) + " in " + xs)
  }
  def `Vector("", "boom!", "hi", "cool!", "great!") should throw TestFailedException with correct stack depth and message when 'should not have length' failed` {
    val xs = Vector("", "boom!", "hi", "cool!", "great!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not have length (5)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLengthNotEqual(xs, 5, 2) + " in " + xs)
  }
  def `Vector("", "boom!", "hi", "cool!", "great!") should throw TestFailedException with correct stack depth and message when 'should have size' failed` {
    val xs = Vector("", "boom!", "hi", "cool!", "great!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should have size 5
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeEqual(xs, 5, 2) + " in " + xs)
  }
  def `Vector("", "boom!", "hi", "cool!", "great!") should throw TestFailedException with correct stack depth and message when 'should not have size' failed` {
    val xs = Vector("", "boom!", "hi", "cool!", "great!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not have size (5)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeNotEqual(xs, 5, 2) + " in " + xs)
  }
  def `Set("", "boom!", "hi", "cool!", "great!").par should throw TestFailedException with correct stack depth and message when 'should have size' failed` {
    val xs = Set("", "boom!", "hi", "cool!", "great!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should have size 5
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeEqual(xs, 5, 2) + " in " + xs)
  }
  def `Set("", "boom!", "hi", "cool!", "great!").par should throw TestFailedException with correct stack depth and message when 'should not have size' failed` {
    val xs = Set("", "boom!", "hi", "cool!", "great!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not have size (5)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeNotEqual(xs, 5, 2) + " in " + xs)
  }
  def `List("", "boom!", "hi", "cool!", "great!").par should throw TestFailedException with correct stack depth and message when 'should have length' failed` {
    val xs = List("", "boom!", "hi", "cool!", "great!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should have length 5
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLengthEqual(xs, 5, 2) + " in " + xs)
  }
  def `List("", "boom!", "hi", "cool!", "great!").par should throw TestFailedException with correct stack depth and message when 'should not have length' failed` {
    val xs = List("", "boom!", "hi", "cool!", "great!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not have length (5)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLengthNotEqual(xs, 5, 2) + " in " + xs)
  }
  def `List("", "boom!", "hi", "cool!", "great!").par should throw TestFailedException with correct stack depth and message when 'should have size' failed` {
    val xs = List("", "boom!", "hi", "cool!", "great!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should have size 5
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeEqual(xs, 5, 2) + " in " + xs)
  }
  def `List("", "boom!", "hi", "cool!", "great!").par should throw TestFailedException with correct stack depth and message when 'should not have size' failed` {
    val xs = List("", "boom!", "hi", "cool!", "great!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not have size (5)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeNotEqual(xs, 5, 2) + " in " + xs)
  }
  def `Seq("", "boom!", "hi", "cool!", "great!").par should throw TestFailedException with correct stack depth and message when 'should have length' failed` {
    val xs = Seq("", "boom!", "hi", "cool!", "great!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should have length 5
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLengthEqual(xs, 5, 2) + " in " + xs)
  }
  def `Seq("", "boom!", "hi", "cool!", "great!").par should throw TestFailedException with correct stack depth and message when 'should not have length' failed` {
    val xs = Seq("", "boom!", "hi", "cool!", "great!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not have length (5)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLengthNotEqual(xs, 5, 2) + " in " + xs)
  }
  def `Seq("", "boom!", "hi", "cool!", "great!").par should throw TestFailedException with correct stack depth and message when 'should have size' failed` {
    val xs = Seq("", "boom!", "hi", "cool!", "great!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should have size 5
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeEqual(xs, 5, 2) + " in " + xs)
  }
  def `Seq("", "boom!", "hi", "cool!", "great!").par should throw TestFailedException with correct stack depth and message when 'should not have size' failed` {
    val xs = Seq("", "boom!", "hi", "cool!", "great!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not have size (5)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeNotEqual(xs, 5, 2) + " in " + xs)
  }
  def `IndexedSeq("", "boom!", "hi", "cool!", "great!").par should throw TestFailedException with correct stack depth and message when 'should have length' failed` {
    val xs = IndexedSeq("", "boom!", "hi", "cool!", "great!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should have length 5
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLengthEqual(xs, 5, 2) + " in " + xs)
  }
  def `IndexedSeq("", "boom!", "hi", "cool!", "great!").par should throw TestFailedException with correct stack depth and message when 'should not have length' failed` {
    val xs = IndexedSeq("", "boom!", "hi", "cool!", "great!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not have length (5)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLengthNotEqual(xs, 5, 2) + " in " + xs)
  }
  def `IndexedSeq("", "boom!", "hi", "cool!", "great!").par should throw TestFailedException with correct stack depth and message when 'should have size' failed` {
    val xs = IndexedSeq("", "boom!", "hi", "cool!", "great!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should have size 5
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeEqual(xs, 5, 2) + " in " + xs)
  }
  def `IndexedSeq("", "boom!", "hi", "cool!", "great!").par should throw TestFailedException with correct stack depth and message when 'should not have size' failed` {
    val xs = IndexedSeq("", "boom!", "hi", "cool!", "great!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not have size (5)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeNotEqual(xs, 5, 2) + " in " + xs)
  }
  def `collection.mutable.Set("", "boom!", "hi", "cool!", "great!") should throw TestFailedException with correct stack depth and message when 'should have size' failed` {
    val xs = collection.mutable.Set("", "boom!", "hi", "cool!", "great!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should have size 5
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeEqual(xs, 5, 2) + " in " + xs)
  }
  def `collection.mutable.Set("", "boom!", "hi", "cool!", "great!") should throw TestFailedException with correct stack depth and message when 'should not have size' failed` {
    val xs = collection.mutable.Set("", "boom!", "hi", "cool!", "great!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not have size (5)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeNotEqual(xs, 5, 2) + " in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List("", "boom!", "hi", "cool!", "great!") should throw TestFailedException with correct stack depth and message when 'should have length' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List("", "boom!", "hi", "cool!", "great!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should have length 5
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLengthEqual(xs, 5, 2) + " in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List("", "boom!", "hi", "cool!", "great!") should throw TestFailedException with correct stack depth and message when 'should not have length' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List("", "boom!", "hi", "cool!", "great!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not have length (5)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLengthNotEqual(xs, 5, 2) + " in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List("", "boom!", "hi", "cool!", "great!") should throw TestFailedException with correct stack depth and message when 'should have size' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List("", "boom!", "hi", "cool!", "great!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should have size 5
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeEqual(xs, 5, 2) + " in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List("", "boom!", "hi", "cool!", "great!") should throw TestFailedException with correct stack depth and message when 'should not have size' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List("", "boom!", "hi", "cool!", "great!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not have size (5)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeNotEqual(xs, 5, 2) + " in " + xs)
  }
  def `collection.mutable.Seq("", "boom!", "hi", "cool!", "great!") should throw TestFailedException with correct stack depth and message when 'should have length' failed` {
    val xs = collection.mutable.Seq("", "boom!", "hi", "cool!", "great!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should have length 5
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLengthEqual(xs, 5, 2) + " in " + xs)
  }
  def `collection.mutable.Seq("", "boom!", "hi", "cool!", "great!") should throw TestFailedException with correct stack depth and message when 'should not have length' failed` {
    val xs = collection.mutable.Seq("", "boom!", "hi", "cool!", "great!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not have length (5)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLengthNotEqual(xs, 5, 2) + " in " + xs)
  }
  def `collection.mutable.Seq("", "boom!", "hi", "cool!", "great!") should throw TestFailedException with correct stack depth and message when 'should have size' failed` {
    val xs = collection.mutable.Seq("", "boom!", "hi", "cool!", "great!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should have size 5
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeEqual(xs, 5, 2) + " in " + xs)
  }
  def `collection.mutable.Seq("", "boom!", "hi", "cool!", "great!") should throw TestFailedException with correct stack depth and message when 'should not have size' failed` {
    val xs = collection.mutable.Seq("", "boom!", "hi", "cool!", "great!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not have size (5)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeNotEqual(xs, 5, 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq("", "boom!", "hi", "cool!", "great!") should throw TestFailedException with correct stack depth and message when 'should have length' failed` {
    val xs = collection.mutable.IndexedSeq("", "boom!", "hi", "cool!", "great!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should have length 5
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLengthEqual(xs, 5, 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq("", "boom!", "hi", "cool!", "great!") should throw TestFailedException with correct stack depth and message when 'should not have length' failed` {
    val xs = collection.mutable.IndexedSeq("", "boom!", "hi", "cool!", "great!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not have length (5)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLengthNotEqual(xs, 5, 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq("", "boom!", "hi", "cool!", "great!") should throw TestFailedException with correct stack depth and message when 'should have size' failed` {
    val xs = collection.mutable.IndexedSeq("", "boom!", "hi", "cool!", "great!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should have size 5
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeEqual(xs, 5, 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq("", "boom!", "hi", "cool!", "great!") should throw TestFailedException with correct stack depth and message when 'should not have size' failed` {
    val xs = collection.mutable.IndexedSeq("", "boom!", "hi", "cool!", "great!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not have size (5)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeNotEqual(xs, 5, 2) + " in " + xs)
  }
  def `collection.mutable.Set("", "boom!", "hi", "cool!", "great!").par should throw TestFailedException with correct stack depth and message when 'should have size' failed` {
    val xs = collection.mutable.Set("", "boom!", "hi", "cool!", "great!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should have size 5
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeEqual(xs, 5, 2) + " in " + xs)
  }
  def `collection.mutable.Set("", "boom!", "hi", "cool!", "great!").par should throw TestFailedException with correct stack depth and message when 'should not have size' failed` {
    val xs = collection.mutable.Set("", "boom!", "hi", "cool!", "great!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not have size (5)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeNotEqual(xs, 5, 2) + " in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List("", "boom!", "hi", "cool!", "great!")).par should throw TestFailedException with correct stack depth and message when 'should have length' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List("", "boom!", "hi", "cool!", "great!")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should have length 5
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLengthEqual(xs, 5, 2) + " in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List("", "boom!", "hi", "cool!", "great!")).par should throw TestFailedException with correct stack depth and message when 'should not have length' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List("", "boom!", "hi", "cool!", "great!")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not have length (5)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLengthNotEqual(xs, 5, 2) + " in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List("", "boom!", "hi", "cool!", "great!")).par should throw TestFailedException with correct stack depth and message when 'should have size' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List("", "boom!", "hi", "cool!", "great!")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should have size 5
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeEqual(xs, 5, 2) + " in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List("", "boom!", "hi", "cool!", "great!")).par should throw TestFailedException with correct stack depth and message when 'should not have size' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List("", "boom!", "hi", "cool!", "great!")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not have size (5)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeNotEqual(xs, 5, 2) + " in " + xs)
  }
  def `collection.mutable.Seq("", "boom!", "hi", "cool!", "great!").par should throw TestFailedException with correct stack depth and message when 'should have length' failed` {
    val xs = collection.mutable.Seq("", "boom!", "hi", "cool!", "great!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should have length 5
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLengthEqual(xs, 5, 2) + " in " + xs)
  }
  def `collection.mutable.Seq("", "boom!", "hi", "cool!", "great!").par should throw TestFailedException with correct stack depth and message when 'should not have length' failed` {
    val xs = collection.mutable.Seq("", "boom!", "hi", "cool!", "great!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not have length (5)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLengthNotEqual(xs, 5, 2) + " in " + xs)
  }
  def `collection.mutable.Seq("", "boom!", "hi", "cool!", "great!").par should throw TestFailedException with correct stack depth and message when 'should have size' failed` {
    val xs = collection.mutable.Seq("", "boom!", "hi", "cool!", "great!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should have size 5
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeEqual(xs, 5, 2) + " in " + xs)
  }
  def `collection.mutable.Seq("", "boom!", "hi", "cool!", "great!").par should throw TestFailedException with correct stack depth and message when 'should not have size' failed` {
    val xs = collection.mutable.Seq("", "boom!", "hi", "cool!", "great!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not have size (5)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeNotEqual(xs, 5, 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq("", "boom!", "hi", "cool!", "great!").par should throw TestFailedException with correct stack depth and message when 'should have length' failed` {
    val xs = collection.mutable.IndexedSeq("", "boom!", "hi", "cool!", "great!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should have length 5
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLengthEqual(xs, 5, 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq("", "boom!", "hi", "cool!", "great!").par should throw TestFailedException with correct stack depth and message when 'should not have length' failed` {
    val xs = collection.mutable.IndexedSeq("", "boom!", "hi", "cool!", "great!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not have length (5)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesLengthNotEqual(xs, 5, 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq("", "boom!", "hi", "cool!", "great!").par should throw TestFailedException with correct stack depth and message when 'should have size' failed` {
    val xs = collection.mutable.IndexedSeq("", "boom!", "hi", "cool!", "great!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should have size 5
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeEqual(xs, 5, 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq("", "boom!", "hi", "cool!", "great!").par should throw TestFailedException with correct stack depth and message when 'should not have size' failed` {
    val xs = collection.mutable.IndexedSeq("", "boom!", "hi", "cool!", "great!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not have size (5)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeNotEqual(xs, 5, 2) + " in " + xs)
  }
  def `Set("1", theInstance, "3", "4", "5") should throw TestFailedException with correct stack depth and message when 'should not be theSameInstanceAs' failed` {
    val xs = Set("1", theInstance, "3", "4", "5")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be theSameInstanceAs (theInstance)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotRefEqual[String](xs, theInstance, 2) + " in " + xs)
  }
  def `List("1", theInstance, "3", "4", "5") should throw TestFailedException with correct stack depth and message when 'should not be theSameInstanceAs' failed` {
    val xs = List("1", theInstance, "3", "4", "5")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be theSameInstanceAs (theInstance)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotRefEqual[String](xs, theInstance, 2) + " in " + xs)
  }
  def `Seq("1", theInstance, "3", "4", "5") should throw TestFailedException with correct stack depth and message when 'should not be theSameInstanceAs' failed` {
    val xs = Seq("1", theInstance, "3", "4", "5")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be theSameInstanceAs (theInstance)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotRefEqual[String](xs, theInstance, 2) + " in " + xs)
  }
  def `Array("1", theInstance, "3", "4", "5") should throw TestFailedException with correct stack depth and message when 'should not be theSameInstanceAs' failed` {
    val xs = Array("1", theInstance, "3", "4", "5")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be theSameInstanceAs (theInstance)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotRefEqual[String](Array("1", "2", "3", "4", "5"), theInstance, 2) + " in " + "WrappedArray(1, 2, 3, 4, 5)")
  }
  def `IndexedSeq("1", theInstance, "3", "4", "5") should throw TestFailedException with correct stack depth and message when 'should not be theSameInstanceAs' failed` {
    val xs = IndexedSeq("1", theInstance, "3", "4", "5")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be theSameInstanceAs (theInstance)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotRefEqual[String](xs, theInstance, 2) + " in " + xs)
  }
  def `Vector("1", theInstance, "3", "4", "5") should throw TestFailedException with correct stack depth and message when 'should not be theSameInstanceAs' failed` {
    val xs = Vector("1", theInstance, "3", "4", "5")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be theSameInstanceAs (theInstance)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotRefEqual[String](xs, theInstance, 2) + " in " + xs)
  }
  def `Set("1", theInstance, "3", "4", "5").par should throw TestFailedException with correct stack depth and message when 'should not be theSameInstanceAs' failed` {
    val xs = Set("1", theInstance, "3", "4", "5").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be theSameInstanceAs (theInstance)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotRefEqual[String](xs, theInstance, 2) + " in " + xs)
  }
  def `List("1", theInstance, "3", "4", "5").par should throw TestFailedException with correct stack depth and message when 'should not be theSameInstanceAs' failed` {
    val xs = List("1", theInstance, "3", "4", "5").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be theSameInstanceAs (theInstance)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotRefEqual[String](xs, theInstance, 2) + " in " + xs)
  }
  def `Seq("1", theInstance, "3", "4", "5").par should throw TestFailedException with correct stack depth and message when 'should not be theSameInstanceAs' failed` {
    val xs = Seq("1", theInstance, "3", "4", "5").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be theSameInstanceAs (theInstance)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotRefEqual[String](xs, theInstance, 2) + " in " + xs)
  }
  def `IndexedSeq("1", theInstance, "3", "4", "5").par should throw TestFailedException with correct stack depth and message when 'should not be theSameInstanceAs' failed` {
    val xs = IndexedSeq("1", theInstance, "3", "4", "5").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be theSameInstanceAs (theInstance)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotRefEqual[String](xs, theInstance, 2) + " in " + xs)
  }
  def `collection.mutable.Set("1", theInstance, "3", "4", "5") should throw TestFailedException with correct stack depth and message when 'should not be theSameInstanceAs' failed` {
    val xs = collection.mutable.Set("1", theInstance, "3", "4", "5")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be theSameInstanceAs (theInstance)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotRefEqual[String](xs, theInstance, 2) + " in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List("1", theInstance, "3", "4", "5") should throw TestFailedException with correct stack depth and message when 'should not be theSameInstanceAs' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List("1", theInstance, "3", "4", "5")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be theSameInstanceAs (theInstance)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotRefEqual[String](xs, theInstance, 2) + " in " + xs)
  }
  def `collection.mutable.Seq("1", theInstance, "3", "4", "5") should throw TestFailedException with correct stack depth and message when 'should not be theSameInstanceAs' failed` {
    val xs = collection.mutable.Seq("1", theInstance, "3", "4", "5")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be theSameInstanceAs (theInstance)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotRefEqual[String](xs, theInstance, 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq("1", theInstance, "3", "4", "5") should throw TestFailedException with correct stack depth and message when 'should not be theSameInstanceAs' failed` {
    val xs = collection.mutable.IndexedSeq("1", theInstance, "3", "4", "5")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be theSameInstanceAs (theInstance)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotRefEqual[String](xs, theInstance, 2) + " in " + xs)
  }
  def `collection.mutable.Set("1", theInstance, "3", "4", "5").par should throw TestFailedException with correct stack depth and message when 'should not be theSameInstanceAs' failed` {
    val xs = collection.mutable.Set("1", theInstance, "3", "4", "5").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be theSameInstanceAs (theInstance)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotRefEqual[String](xs, theInstance, 2) + " in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List("1", theInstance, "3", "4", "5")).par should throw TestFailedException with correct stack depth and message when 'should not be theSameInstanceAs' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List("1", theInstance, "3", "4", "5")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be theSameInstanceAs (theInstance)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotRefEqual[String](xs, theInstance, 2) + " in " + xs)
  }
  def `collection.mutable.Seq("1", theInstance, "3", "4", "5").par should throw TestFailedException with correct stack depth and message when 'should not be theSameInstanceAs' failed` {
    val xs = collection.mutable.Seq("1", theInstance, "3", "4", "5").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be theSameInstanceAs (theInstance)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotRefEqual[String](xs, theInstance, 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq("1", theInstance, "3", "4", "5").par should throw TestFailedException with correct stack depth and message when 'should not be theSameInstanceAs' failed` {
    val xs = collection.mutable.IndexedSeq("1", theInstance, "3", "4", "5").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be theSameInstanceAs (theInstance)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotRefEqual[String](xs, theInstance, 2) + " in " + xs)
  }
  def `Set("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should startWith' failed` {
    val xs = Set("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should startWith ("hello")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesStartsWith(xs, "hello", 2) + " in " + xs)
  }
  def `Set("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should not startWith' failed` {
    val xs = Set("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not startWith ("hello")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotStartsWith(xs, "hello", 2) + " in " + xs)
  }
  def `Set("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should endWith' failed` {
    val xs = Set("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should endWith ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesEndsWith(xs, "!", 2) + " in " + xs)
  }
  def `Set("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should not endWith' failed` {
    val xs = Set("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not endWith ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEndsWith(xs, "!", 2) + " in " + xs)
  }
  def `Set("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should include' failed` {
    val xs = Set("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should include ("ell")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesInclude(xs, "ell", 2) + " in " + xs)
  }
  def `Set("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should not include' failed` {
    val xs = Set("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not include "ell"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotInclude(xs, "ell", 2) + " in " + xs)
  }
  def `Set("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should startWith regex' failed` {
    val xs = Set("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should startWith regex "hel*o"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesStartsWith(xs, "hello", 2) + " in " + xs)
  }
  def `Set("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should not startWith regex' failed` {
    val xs = Set("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not startWith regex ("hel*o")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotStartsWith(xs, "hello", 2) + " in " + xs)
  }
  def `Set("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should endWith regex' failed` {
    val xs = Set("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should endWith regex "!"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesEndsWith(xs, "!", 2) + " in " + xs)
  }
  def `Set("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should not endWith regex' failed` {
    val xs = Set("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not endWith regex ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEndsWith(xs, "!", 2) + " in " + xs)
  }
  def `Set("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should include regex' failed` {
    val xs = Set("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should include regex "ell"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesInclude(xs, "ell", 2) + " in " + xs)
  }
  def `Set("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should not include regex' failed` {
    val xs = Set("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not include regex ("ell")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotInclude(xs, "ell", 2) + " in " + xs)
  }
  def `Set("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should fullyMatch regex' failed` {
    val xs = Set("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should fullyMatch regex "h.*!"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesMatches(xs, "h.*!", 2) + " in " + xs)
  }
  def `Set("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should not fullyMatch regex' failed` {
    val xs = Set("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not fullyMatch regex ("h.*!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotMatches(xs, "h.*!", 2) + " in " + xs)
  }
  def `List("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should startWith' failed` {
    val xs = List("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should startWith ("hello")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesStartsWith(xs, "hello", 2) + " in " + xs)
  }
  def `List("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should not startWith' failed` {
    val xs = List("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not startWith ("hello")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotStartsWith(xs, "hello", 2) + " in " + xs)
  }
  def `List("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should endWith' failed` {
    val xs = List("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should endWith ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesEndsWith(xs, "!", 2) + " in " + xs)
  }
  def `List("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should not endWith' failed` {
    val xs = List("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not endWith ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEndsWith(xs, "!", 2) + " in " + xs)
  }
  def `List("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should include' failed` {
    val xs = List("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should include ("ell")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesInclude(xs, "ell", 2) + " in " + xs)
  }
  def `List("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should not include' failed` {
    val xs = List("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not include "ell"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotInclude(xs, "ell", 2) + " in " + xs)
  }
  def `List("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should startWith regex' failed` {
    val xs = List("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should startWith regex "hel*o"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesStartsWith(xs, "hello", 2) + " in " + xs)
  }
  def `List("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should not startWith regex' failed` {
    val xs = List("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not startWith regex ("hel*o")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotStartsWith(xs, "hello", 2) + " in " + xs)
  }
  def `List("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should endWith regex' failed` {
    val xs = List("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should endWith regex "!"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesEndsWith(xs, "!", 2) + " in " + xs)
  }
  def `List("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should not endWith regex' failed` {
    val xs = List("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not endWith regex ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEndsWith(xs, "!", 2) + " in " + xs)
  }
  def `List("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should include regex' failed` {
    val xs = List("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should include regex "ell"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesInclude(xs, "ell", 2) + " in " + xs)
  }
  def `List("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should not include regex' failed` {
    val xs = List("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not include regex ("ell")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotInclude(xs, "ell", 2) + " in " + xs)
  }
  def `List("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should fullyMatch regex' failed` {
    val xs = List("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should fullyMatch regex "h.*!"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesMatches(xs, "h.*!", 2) + " in " + xs)
  }
  def `List("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should not fullyMatch regex' failed` {
    val xs = List("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not fullyMatch regex ("h.*!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotMatches(xs, "h.*!", 2) + " in " + xs)
  }
  def `Seq("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should startWith' failed` {
    val xs = Seq("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should startWith ("hello")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesStartsWith(xs, "hello", 2) + " in " + xs)
  }
  def `Seq("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should not startWith' failed` {
    val xs = Seq("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not startWith ("hello")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotStartsWith(xs, "hello", 2) + " in " + xs)
  }
  def `Seq("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should endWith' failed` {
    val xs = Seq("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should endWith ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesEndsWith(xs, "!", 2) + " in " + xs)
  }
  def `Seq("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should not endWith' failed` {
    val xs = Seq("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not endWith ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEndsWith(xs, "!", 2) + " in " + xs)
  }
  def `Seq("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should include' failed` {
    val xs = Seq("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should include ("ell")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesInclude(xs, "ell", 2) + " in " + xs)
  }
  def `Seq("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should not include' failed` {
    val xs = Seq("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not include "ell"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotInclude(xs, "ell", 2) + " in " + xs)
  }
  def `Seq("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should startWith regex' failed` {
    val xs = Seq("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should startWith regex "hel*o"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesStartsWith(xs, "hello", 2) + " in " + xs)
  }
  def `Seq("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should not startWith regex' failed` {
    val xs = Seq("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not startWith regex ("hel*o")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotStartsWith(xs, "hello", 2) + " in " + xs)
  }
  def `Seq("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should endWith regex' failed` {
    val xs = Seq("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should endWith regex "!"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesEndsWith(xs, "!", 2) + " in " + xs)
  }
  def `Seq("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should not endWith regex' failed` {
    val xs = Seq("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not endWith regex ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEndsWith(xs, "!", 2) + " in " + xs)
  }
  def `Seq("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should include regex' failed` {
    val xs = Seq("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should include regex "ell"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesInclude(xs, "ell", 2) + " in " + xs)
  }
  def `Seq("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should not include regex' failed` {
    val xs = Seq("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not include regex ("ell")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotInclude(xs, "ell", 2) + " in " + xs)
  }
  def `Seq("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should fullyMatch regex' failed` {
    val xs = Seq("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should fullyMatch regex "h.*!"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesMatches(xs, "h.*!", 2) + " in " + xs)
  }
  def `Seq("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should not fullyMatch regex' failed` {
    val xs = Seq("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not fullyMatch regex ("h.*!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotMatches(xs, "h.*!", 2) + " in " + xs)
  }
  def `Array("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should startWith' failed` {
    val xs = Array("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should startWith ("hello")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesStartsWith(Array("hello A!", "hi B", "hello C!", "hi D", "hello E!"), "hello", 2) + " in " + "WrappedArray(hello A!, hi B, hello C!, hi D, hello E!)")
  }
  def `Array("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should not startWith' failed` {
    val xs = Array("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not startWith ("hello")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotStartsWith(Array("hello A!", "hi B", "hello C!", "hi D", "hello E!"), "hello", 2) + " in " + "WrappedArray(hello A!, hi B, hello C!, hi D, hello E!)")
  }
  def `Array("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should endWith' failed` {
    val xs = Array("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should endWith ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesEndsWith(Array("hello A!", "hi B", "hello C!", "hi D", "hello E!"), "!", 2) + " in " + "WrappedArray(hello A!, hi B, hello C!, hi D, hello E!)")
  }
  def `Array("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should not endWith' failed` {
    val xs = Array("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not endWith ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEndsWith(Array("hello A!", "hi B", "hello C!", "hi D", "hello E!"), "!", 2) + " in " + "WrappedArray(hello A!, hi B, hello C!, hi D, hello E!)")
  }
  def `Array("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should include' failed` {
    val xs = Array("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should include ("ell")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesInclude(Array("hello A!", "hi B", "hello C!", "hi D", "hello E!"), "ell", 2) + " in " + "WrappedArray(hello A!, hi B, hello C!, hi D, hello E!)")
  }
  def `Array("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should not include' failed` {
    val xs = Array("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not include "ell"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotInclude(Array("hello A!", "hi B", "hello C!", "hi D", "hello E!"), "ell", 2) + " in " + "WrappedArray(hello A!, hi B, hello C!, hi D, hello E!)")
  }
  def `Array("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should startWith regex' failed` {
    val xs = Array("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should startWith regex "hel*o"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesStartsWith(Array("hello A!", "hi B", "hello C!", "hi D", "hello E!"), "hello", 2) + " in " + "WrappedArray(hello A!, hi B, hello C!, hi D, hello E!)")
  }
  def `Array("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should not startWith regex' failed` {
    val xs = Array("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not startWith regex ("hel*o")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotStartsWith(Array("hello A!", "hi B", "hello C!", "hi D", "hello E!"), "hello", 2) + " in " + "WrappedArray(hello A!, hi B, hello C!, hi D, hello E!)")
  }
  def `Array("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should endWith regex' failed` {
    val xs = Array("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should endWith regex "!"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesEndsWith(Array("hello A!", "hi B", "hello C!", "hi D", "hello E!"), "!", 2) + " in " + "WrappedArray(hello A!, hi B, hello C!, hi D, hello E!)")
  }
  def `Array("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should not endWith regex' failed` {
    val xs = Array("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not endWith regex ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEndsWith(Array("hello A!", "hi B", "hello C!", "hi D", "hello E!"), "!", 2) + " in " + "WrappedArray(hello A!, hi B, hello C!, hi D, hello E!)")
  }
  def `Array("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should include regex' failed` {
    val xs = Array("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should include regex "ell"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesInclude(Array("hello A!", "hi B", "hello C!", "hi D", "hello E!"), "ell", 2) + " in " + "WrappedArray(hello A!, hi B, hello C!, hi D, hello E!)")
  }
  def `Array("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should not include regex' failed` {
    val xs = Array("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not include regex ("ell")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotInclude(Array("hello A!", "hi B", "hello C!", "hi D", "hello E!"), "ell", 2) + " in " + "WrappedArray(hello A!, hi B, hello C!, hi D, hello E!)")
  }
  def `Array("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should fullyMatch regex' failed` {
    val xs = Array("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should fullyMatch regex "h.*!"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesMatches(Array("hello A!", "hi B", "hello C!", "hi D", "hello E!"), "h.*!", 2) + " in " + "WrappedArray(hello A!, hi B, hello C!, hi D, hello E!)")
  }
  def `Array("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should not fullyMatch regex' failed` {
    val xs = Array("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not fullyMatch regex ("h.*!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotMatches(Array("hello A!", "hi B", "hello C!", "hi D", "hello E!"), "h.*!", 2) + " in " + "WrappedArray(hello A!, hi B, hello C!, hi D, hello E!)")
  }
  def `IndexedSeq("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should startWith' failed` {
    val xs = IndexedSeq("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should startWith ("hello")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesStartsWith(xs, "hello", 2) + " in " + xs)
  }
  def `IndexedSeq("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should not startWith' failed` {
    val xs = IndexedSeq("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not startWith ("hello")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotStartsWith(xs, "hello", 2) + " in " + xs)
  }
  def `IndexedSeq("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should endWith' failed` {
    val xs = IndexedSeq("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should endWith ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesEndsWith(xs, "!", 2) + " in " + xs)
  }
  def `IndexedSeq("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should not endWith' failed` {
    val xs = IndexedSeq("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not endWith ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec0.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEndsWith(xs, "!", 2) + " in " + xs)
  }
}
