package org.scalatest.inspectors.atMost

import org.scalatest._
import SharedHelpers._
import org.scalatest.matchers.{BePropertyMatcher, BePropertyMatchResult, HavePropertyMatcher, HavePropertyMatchResult}
import collection.GenTraversable
import collection.GenMap
class InspectorShorthandsForAtMostFailedSpec1 extends Spec with Matchers {
  class EmptyBePropertyMatcher extends BePropertyMatcher[String] {
    def apply(left: String) = BePropertyMatchResult(left.isEmpty, "empty")
  }
  class StringLengthMatcher(expectedValue: Int) extends HavePropertyMatcher[String, Int] {
    def apply(value: String) = {
      new HavePropertyMatchResult(value.length == expectedValue, "length", expectedValue, value.length)
    }
  }
  val empty = new EmptyBePropertyMatcher()
  def plength(expectedValue: Int) = new StringLengthMatcher(expectedValue)
  val theInstance = "2"
  def arrayToString(xs: GenTraversable[_]): String = xs.toString
  def checkErrorAndCause(e: exceptions.TestFailedException, assertLineNumber: Int, fileName: String, errorMessage: String, causeErrorMessage: String) {
    assert(e.failedCodeFileName == Some(fileName), e.failedCodeFileName + " did not equal " + Some(fileName))
    assert(e.failedCodeLineNumber == Some(assertLineNumber), e.failedCodeLineNumber + " did not equal " + Some(assertLineNumber))
    assert(e.message == Some(errorMessage), e.message + " did not equal " + Some(
  errorMessage))
    e.getCause match {
      case tfe: exceptions.TestFailedException =>
        assert(tfe.failedCodeFileName == Some(fileName), tfe.failedCodeFileName + " did not equal " + Some(fileName))
        assert(tfe.failedCodeLineNumber == Some(assertLineNumber), tfe.failedCodeLineNumber + " did not equal " + Some(assertLineNumber))
        assert(tfe.message == Some(causeErrorMessage), tfe.message + " did not equal " + Some(causeErrorMessage))
        assert(tfe.getCause == null, tfe.getCause + " was not null")
      case other => fail("Expected cause to be TestFailedException, but got: " + other)
    }
  }
  def checkError(e: exceptions.TestFailedException, assertLineNumber: Int, fileName: String, errorMessage: String) {
    assert(e.failedCodeFileName == Some(fileName), e.failedCodeFileName + " did not equal " + Some(fileName))
    assert(e.failedCodeLineNumber == Some(assertLineNumber), e.failedCodeLineNumber + " did not equal " + Some(assertLineNumber))
    assert(e.message == Some(errorMessage), e.message + " did not equal " + Some(
  errorMessage))
  }
  def equal[T](left: T, right: T): Boolean = left == right
  def javaArrayList[T](valueList: List[T]): java.util.ArrayList[T] = {
    val col = new java.util.ArrayList[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaHashSet[T](valueList: List[T]): java.util.HashSet[T] = {
    val col = new java.util.HashSet[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaLinkedList[T](valueList: List[T]): java.util.LinkedList[T] = {
    val col = new java.util.LinkedList[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaStack[T](valueList: List[T]): java.util.Stack[T] = {
    val col = new java.util.Stack[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaTreeSet[T](valueList: List[T]): java.util.TreeSet[T] = {
    val col = new java.util.TreeSet[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaVector[T](valueList: List[T]): java.util.Vector[T] = {
    val col = new java.util.Vector[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaArrayBlockingQueue[T](valueList: List[T], size: Int): java.util.concurrent.ArrayBlockingQueue[T] = {
    val col = new java.util.concurrent.ArrayBlockingQueue[T](size)
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaArrayDeque[T](valueList: List[T]): java.util.ArrayDeque[T] = {
    val col = new java.util.ArrayDeque[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaConcurrentLinkedQueue[T](valueList: List[T]): java.util.concurrent.ConcurrentLinkedQueue[T] = {
    val col = new java.util.concurrent.ConcurrentLinkedQueue[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaConcurrentSkipListSet[T](valueList: List[T]): java.util.concurrent.ConcurrentSkipListSet[T] = {
    val col = new java.util.concurrent.ConcurrentSkipListSet[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaCopyOnWriteArrayList[T](valueList: List[T]): java.util.concurrent.CopyOnWriteArrayList[T] = {
    val col = new java.util.concurrent.CopyOnWriteArrayList[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaCopyOnWriteArraySet[T](valueList: List[T]): java.util.concurrent.CopyOnWriteArraySet[T] = {
    val col = new java.util.concurrent.CopyOnWriteArraySet[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaLinkedBlockingDeque[T](valueList: List[T]): java.util.concurrent.LinkedBlockingDeque[T] = {
    val col = new java.util.concurrent.LinkedBlockingDeque[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaLinkedBlockingQueue[T](valueList: List[T]): java.util.concurrent.LinkedBlockingQueue[T] = {
    val col = new java.util.concurrent.LinkedBlockingQueue[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaLinkedHashSet[T](valueList: List[T]): java.util.LinkedHashSet[T] = {
    val col = new java.util.LinkedHashSet[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaPriorityBlockingQueue[T](valueList: List[T]): java.util.concurrent.PriorityBlockingQueue[T] = {
    val col = new java.util.concurrent.PriorityBlockingQueue[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaPriorityQueue[T](valueList: List[T]): java.util.PriorityQueue[T] = {
    val col = new java.util.PriorityQueue[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaHashMap[K, V](valueMap: Map[K, V]): java.util.HashMap[K, V] = {
    val map = new java.util.HashMap[K, V]()
    for ((key, value) <- valueMap)
      map.put(key, value)
    map
  }
  def javaTreeMap[K, V](valueMap: Map[K, V]): java.util.TreeMap[K, V] = {
    val map = new java.util.TreeMap[K, V]()
    for ((key, value) <- valueMap)
      map.put(key, value)
    map
  }
  def javaHashtable[K, V](valueMap: Map[K, V]): java.util.Hashtable[K, V] = {
    val map = new java.util.Hashtable[K, V]()
    for ((key, value) <- valueMap)
      map.put(key, value)
    map
  }
  def javaConcurrentHashMap[K, V](valueMap: Map[K, V]): java.util.concurrent.ConcurrentHashMap[K, V] = {
    val map = new java.util.concurrent.ConcurrentHashMap[K, V]()
    for ((key, value) <- valueMap)
      map.put(key, value)
    map
  }
  def javaConcurrentSkipListMap[K, V](valueMap: Map[K, V]): java.util.concurrent.ConcurrentSkipListMap[K, V] = {
    val map = new java.util.concurrent.ConcurrentSkipListMap[K, V]()
    for ((key, value) <- valueMap)
      map.put(key, value)
    map
  }
  def javaLinkedHashMap[K, V](valueMap: Map[K, V]): java.util.LinkedHashMap[K, V] = {
    val map = new java.util.LinkedHashMap[K, V]()
    for ((key, value) <- valueMap)
      map.put(key, value)
    map
  }
  def javaWeakHashMap[K, V](valueMap: Map[K, V]): java.util.WeakHashMap[K, V] = {
    val map = new java.util.WeakHashMap[K, V]()
    for ((key, value) <- valueMap)
      map.put(key, value)
    map
  }
  def javaProperties(valueMap: Map[String, String]): java.util.Properties = {
    val map = new java.util.Properties()
    for ((key, value) <- valueMap)
      map.put(key, value)
    map
  }
  def `IndexedSeq("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should include' failed` {
    val xs = IndexedSeq("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should include ("ell")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesInclude(xs, "ell", 2) + " in " + xs)
  }
  def `IndexedSeq("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should not include' failed` {
    val xs = IndexedSeq("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not include "ell"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotInclude(xs, "ell", 2) + " in " + xs)
  }
  def `IndexedSeq("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should startWith regex' failed` {
    val xs = IndexedSeq("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should startWith regex "hel*o"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesStartsWith(xs, "hello", 2) + " in " + xs)
  }
  def `IndexedSeq("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should not startWith regex' failed` {
    val xs = IndexedSeq("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not startWith regex ("hel*o")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotStartsWith(xs, "hello", 2) + " in " + xs)
  }
  def `IndexedSeq("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should endWith regex' failed` {
    val xs = IndexedSeq("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should endWith regex "!"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesEndsWith(xs, "!", 2) + " in " + xs)
  }
  def `IndexedSeq("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should not endWith regex' failed` {
    val xs = IndexedSeq("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not endWith regex ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEndsWith(xs, "!", 2) + " in " + xs)
  }
  def `IndexedSeq("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should include regex' failed` {
    val xs = IndexedSeq("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should include regex "ell"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesInclude(xs, "ell", 2) + " in " + xs)
  }
  def `IndexedSeq("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should not include regex' failed` {
    val xs = IndexedSeq("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not include regex ("ell")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotInclude(xs, "ell", 2) + " in " + xs)
  }
  def `IndexedSeq("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should fullyMatch regex' failed` {
    val xs = IndexedSeq("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should fullyMatch regex "h.*!"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesMatches(xs, "h.*!", 2) + " in " + xs)
  }
  def `IndexedSeq("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should not fullyMatch regex' failed` {
    val xs = IndexedSeq("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not fullyMatch regex ("h.*!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotMatches(xs, "h.*!", 2) + " in " + xs)
  }
  def `Vector("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should startWith' failed` {
    val xs = Vector("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should startWith ("hello")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesStartsWith(xs, "hello", 2) + " in " + xs)
  }
  def `Vector("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should not startWith' failed` {
    val xs = Vector("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not startWith ("hello")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotStartsWith(xs, "hello", 2) + " in " + xs)
  }
  def `Vector("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should endWith' failed` {
    val xs = Vector("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should endWith ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesEndsWith(xs, "!", 2) + " in " + xs)
  }
  def `Vector("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should not endWith' failed` {
    val xs = Vector("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not endWith ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEndsWith(xs, "!", 2) + " in " + xs)
  }
  def `Vector("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should include' failed` {
    val xs = Vector("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should include ("ell")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesInclude(xs, "ell", 2) + " in " + xs)
  }
  def `Vector("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should not include' failed` {
    val xs = Vector("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not include "ell"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotInclude(xs, "ell", 2) + " in " + xs)
  }
  def `Vector("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should startWith regex' failed` {
    val xs = Vector("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should startWith regex "hel*o"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesStartsWith(xs, "hello", 2) + " in " + xs)
  }
  def `Vector("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should not startWith regex' failed` {
    val xs = Vector("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not startWith regex ("hel*o")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotStartsWith(xs, "hello", 2) + " in " + xs)
  }
  def `Vector("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should endWith regex' failed` {
    val xs = Vector("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should endWith regex "!"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesEndsWith(xs, "!", 2) + " in " + xs)
  }
  def `Vector("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should not endWith regex' failed` {
    val xs = Vector("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not endWith regex ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEndsWith(xs, "!", 2) + " in " + xs)
  }
  def `Vector("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should include regex' failed` {
    val xs = Vector("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should include regex "ell"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesInclude(xs, "ell", 2) + " in " + xs)
  }
  def `Vector("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should not include regex' failed` {
    val xs = Vector("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not include regex ("ell")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotInclude(xs, "ell", 2) + " in " + xs)
  }
  def `Vector("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should fullyMatch regex' failed` {
    val xs = Vector("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should fullyMatch regex "h.*!"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesMatches(xs, "h.*!", 2) + " in " + xs)
  }
  def `Vector("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should not fullyMatch regex' failed` {
    val xs = Vector("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not fullyMatch regex ("h.*!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotMatches(xs, "h.*!", 2) + " in " + xs)
  }
  def `Set("hello A!", "hi B", "hello C!", "hi D", "hello E!").par should throw TestFailedException with correct stack depth and message when 'should startWith' failed` {
    val xs = Set("hello A!", "hi B", "hello C!", "hi D", "hello E!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should startWith ("hello")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesStartsWith(xs, "hello", 2) + " in " + xs)
  }
  def `Set("hello A!", "hi B", "hello C!", "hi D", "hello E!").par should throw TestFailedException with correct stack depth and message when 'should not startWith' failed` {
    val xs = Set("hello A!", "hi B", "hello C!", "hi D", "hello E!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not startWith ("hello")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotStartsWith(xs, "hello", 2) + " in " + xs)
  }
  def `Set("hello A!", "hi B", "hello C!", "hi D", "hello E!").par should throw TestFailedException with correct stack depth and message when 'should endWith' failed` {
    val xs = Set("hello A!", "hi B", "hello C!", "hi D", "hello E!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should endWith ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesEndsWith(xs, "!", 2) + " in " + xs)
  }
  def `Set("hello A!", "hi B", "hello C!", "hi D", "hello E!").par should throw TestFailedException with correct stack depth and message when 'should not endWith' failed` {
    val xs = Set("hello A!", "hi B", "hello C!", "hi D", "hello E!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not endWith ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEndsWith(xs, "!", 2) + " in " + xs)
  }
  def `Set("hello A!", "hi B", "hello C!", "hi D", "hello E!").par should throw TestFailedException with correct stack depth and message when 'should include' failed` {
    val xs = Set("hello A!", "hi B", "hello C!", "hi D", "hello E!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should include ("ell")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesInclude(xs, "ell", 2) + " in " + xs)
  }
  def `Set("hello A!", "hi B", "hello C!", "hi D", "hello E!").par should throw TestFailedException with correct stack depth and message when 'should not include' failed` {
    val xs = Set("hello A!", "hi B", "hello C!", "hi D", "hello E!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not include "ell"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotInclude(xs, "ell", 2) + " in " + xs)
  }
  def `Set("hello A!", "hi B", "hello C!", "hi D", "hello E!").par should throw TestFailedException with correct stack depth and message when 'should startWith regex' failed` {
    val xs = Set("hello A!", "hi B", "hello C!", "hi D", "hello E!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should startWith regex "hel*o"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesStartsWith(xs, "hello", 2) + " in " + xs)
  }
  def `Set("hello A!", "hi B", "hello C!", "hi D", "hello E!").par should throw TestFailedException with correct stack depth and message when 'should not startWith regex' failed` {
    val xs = Set("hello A!", "hi B", "hello C!", "hi D", "hello E!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not startWith regex ("hel*o")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotStartsWith(xs, "hello", 2) + " in " + xs)
  }
  def `Set("hello A!", "hi B", "hello C!", "hi D", "hello E!").par should throw TestFailedException with correct stack depth and message when 'should endWith regex' failed` {
    val xs = Set("hello A!", "hi B", "hello C!", "hi D", "hello E!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should endWith regex "!"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesEndsWith(xs, "!", 2) + " in " + xs)
  }
  def `Set("hello A!", "hi B", "hello C!", "hi D", "hello E!").par should throw TestFailedException with correct stack depth and message when 'should not endWith regex' failed` {
    val xs = Set("hello A!", "hi B", "hello C!", "hi D", "hello E!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not endWith regex ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEndsWith(xs, "!", 2) + " in " + xs)
  }
  def `Set("hello A!", "hi B", "hello C!", "hi D", "hello E!").par should throw TestFailedException with correct stack depth and message when 'should include regex' failed` {
    val xs = Set("hello A!", "hi B", "hello C!", "hi D", "hello E!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should include regex "ell"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesInclude(xs, "ell", 2) + " in " + xs)
  }
  def `Set("hello A!", "hi B", "hello C!", "hi D", "hello E!").par should throw TestFailedException with correct stack depth and message when 'should not include regex' failed` {
    val xs = Set("hello A!", "hi B", "hello C!", "hi D", "hello E!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not include regex ("ell")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotInclude(xs, "ell", 2) + " in " + xs)
  }
  def `Set("hello A!", "hi B", "hello C!", "hi D", "hello E!").par should throw TestFailedException with correct stack depth and message when 'should fullyMatch regex' failed` {
    val xs = Set("hello A!", "hi B", "hello C!", "hi D", "hello E!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should fullyMatch regex "h.*!"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesMatches(xs, "h.*!", 2) + " in " + xs)
  }
  def `Set("hello A!", "hi B", "hello C!", "hi D", "hello E!").par should throw TestFailedException with correct stack depth and message when 'should not fullyMatch regex' failed` {
    val xs = Set("hello A!", "hi B", "hello C!", "hi D", "hello E!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not fullyMatch regex ("h.*!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotMatches(xs, "h.*!", 2) + " in " + xs)
  }
  def `List("hello A!", "hi B", "hello C!", "hi D", "hello E!").par should throw TestFailedException with correct stack depth and message when 'should startWith' failed` {
    val xs = List("hello A!", "hi B", "hello C!", "hi D", "hello E!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should startWith ("hello")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesStartsWith(xs, "hello", 2) + " in " + xs)
  }
  def `List("hello A!", "hi B", "hello C!", "hi D", "hello E!").par should throw TestFailedException with correct stack depth and message when 'should not startWith' failed` {
    val xs = List("hello A!", "hi B", "hello C!", "hi D", "hello E!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not startWith ("hello")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotStartsWith(xs, "hello", 2) + " in " + xs)
  }
  def `List("hello A!", "hi B", "hello C!", "hi D", "hello E!").par should throw TestFailedException with correct stack depth and message when 'should endWith' failed` {
    val xs = List("hello A!", "hi B", "hello C!", "hi D", "hello E!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should endWith ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesEndsWith(xs, "!", 2) + " in " + xs)
  }
  def `List("hello A!", "hi B", "hello C!", "hi D", "hello E!").par should throw TestFailedException with correct stack depth and message when 'should not endWith' failed` {
    val xs = List("hello A!", "hi B", "hello C!", "hi D", "hello E!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not endWith ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEndsWith(xs, "!", 2) + " in " + xs)
  }
  def `List("hello A!", "hi B", "hello C!", "hi D", "hello E!").par should throw TestFailedException with correct stack depth and message when 'should include' failed` {
    val xs = List("hello A!", "hi B", "hello C!", "hi D", "hello E!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should include ("ell")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesInclude(xs, "ell", 2) + " in " + xs)
  }
  def `List("hello A!", "hi B", "hello C!", "hi D", "hello E!").par should throw TestFailedException with correct stack depth and message when 'should not include' failed` {
    val xs = List("hello A!", "hi B", "hello C!", "hi D", "hello E!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not include "ell"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotInclude(xs, "ell", 2) + " in " + xs)
  }
  def `List("hello A!", "hi B", "hello C!", "hi D", "hello E!").par should throw TestFailedException with correct stack depth and message when 'should startWith regex' failed` {
    val xs = List("hello A!", "hi B", "hello C!", "hi D", "hello E!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should startWith regex "hel*o"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesStartsWith(xs, "hello", 2) + " in " + xs)
  }
  def `List("hello A!", "hi B", "hello C!", "hi D", "hello E!").par should throw TestFailedException with correct stack depth and message when 'should not startWith regex' failed` {
    val xs = List("hello A!", "hi B", "hello C!", "hi D", "hello E!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not startWith regex ("hel*o")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotStartsWith(xs, "hello", 2) + " in " + xs)
  }
  def `List("hello A!", "hi B", "hello C!", "hi D", "hello E!").par should throw TestFailedException with correct stack depth and message when 'should endWith regex' failed` {
    val xs = List("hello A!", "hi B", "hello C!", "hi D", "hello E!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should endWith regex "!"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesEndsWith(xs, "!", 2) + " in " + xs)
  }
  def `List("hello A!", "hi B", "hello C!", "hi D", "hello E!").par should throw TestFailedException with correct stack depth and message when 'should not endWith regex' failed` {
    val xs = List("hello A!", "hi B", "hello C!", "hi D", "hello E!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not endWith regex ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEndsWith(xs, "!", 2) + " in " + xs)
  }
  def `List("hello A!", "hi B", "hello C!", "hi D", "hello E!").par should throw TestFailedException with correct stack depth and message when 'should include regex' failed` {
    val xs = List("hello A!", "hi B", "hello C!", "hi D", "hello E!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should include regex "ell"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesInclude(xs, "ell", 2) + " in " + xs)
  }
  def `List("hello A!", "hi B", "hello C!", "hi D", "hello E!").par should throw TestFailedException with correct stack depth and message when 'should not include regex' failed` {
    val xs = List("hello A!", "hi B", "hello C!", "hi D", "hello E!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not include regex ("ell")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotInclude(xs, "ell", 2) + " in " + xs)
  }
  def `List("hello A!", "hi B", "hello C!", "hi D", "hello E!").par should throw TestFailedException with correct stack depth and message when 'should fullyMatch regex' failed` {
    val xs = List("hello A!", "hi B", "hello C!", "hi D", "hello E!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should fullyMatch regex "h.*!"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesMatches(xs, "h.*!", 2) + " in " + xs)
  }
  def `List("hello A!", "hi B", "hello C!", "hi D", "hello E!").par should throw TestFailedException with correct stack depth and message when 'should not fullyMatch regex' failed` {
    val xs = List("hello A!", "hi B", "hello C!", "hi D", "hello E!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not fullyMatch regex ("h.*!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotMatches(xs, "h.*!", 2) + " in " + xs)
  }
  def `Seq("hello A!", "hi B", "hello C!", "hi D", "hello E!").par should throw TestFailedException with correct stack depth and message when 'should startWith' failed` {
    val xs = Seq("hello A!", "hi B", "hello C!", "hi D", "hello E!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should startWith ("hello")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesStartsWith(xs, "hello", 2) + " in " + xs)
  }
  def `Seq("hello A!", "hi B", "hello C!", "hi D", "hello E!").par should throw TestFailedException with correct stack depth and message when 'should not startWith' failed` {
    val xs = Seq("hello A!", "hi B", "hello C!", "hi D", "hello E!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not startWith ("hello")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotStartsWith(xs, "hello", 2) + " in " + xs)
  }
  def `Seq("hello A!", "hi B", "hello C!", "hi D", "hello E!").par should throw TestFailedException with correct stack depth and message when 'should endWith' failed` {
    val xs = Seq("hello A!", "hi B", "hello C!", "hi D", "hello E!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should endWith ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesEndsWith(xs, "!", 2) + " in " + xs)
  }
  def `Seq("hello A!", "hi B", "hello C!", "hi D", "hello E!").par should throw TestFailedException with correct stack depth and message when 'should not endWith' failed` {
    val xs = Seq("hello A!", "hi B", "hello C!", "hi D", "hello E!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not endWith ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEndsWith(xs, "!", 2) + " in " + xs)
  }
  def `Seq("hello A!", "hi B", "hello C!", "hi D", "hello E!").par should throw TestFailedException with correct stack depth and message when 'should include' failed` {
    val xs = Seq("hello A!", "hi B", "hello C!", "hi D", "hello E!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should include ("ell")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesInclude(xs, "ell", 2) + " in " + xs)
  }
  def `Seq("hello A!", "hi B", "hello C!", "hi D", "hello E!").par should throw TestFailedException with correct stack depth and message when 'should not include' failed` {
    val xs = Seq("hello A!", "hi B", "hello C!", "hi D", "hello E!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not include "ell"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotInclude(xs, "ell", 2) + " in " + xs)
  }
  def `Seq("hello A!", "hi B", "hello C!", "hi D", "hello E!").par should throw TestFailedException with correct stack depth and message when 'should startWith regex' failed` {
    val xs = Seq("hello A!", "hi B", "hello C!", "hi D", "hello E!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should startWith regex "hel*o"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesStartsWith(xs, "hello", 2) + " in " + xs)
  }
  def `Seq("hello A!", "hi B", "hello C!", "hi D", "hello E!").par should throw TestFailedException with correct stack depth and message when 'should not startWith regex' failed` {
    val xs = Seq("hello A!", "hi B", "hello C!", "hi D", "hello E!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not startWith regex ("hel*o")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotStartsWith(xs, "hello", 2) + " in " + xs)
  }
  def `Seq("hello A!", "hi B", "hello C!", "hi D", "hello E!").par should throw TestFailedException with correct stack depth and message when 'should endWith regex' failed` {
    val xs = Seq("hello A!", "hi B", "hello C!", "hi D", "hello E!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should endWith regex "!"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesEndsWith(xs, "!", 2) + " in " + xs)
  }
  def `Seq("hello A!", "hi B", "hello C!", "hi D", "hello E!").par should throw TestFailedException with correct stack depth and message when 'should not endWith regex' failed` {
    val xs = Seq("hello A!", "hi B", "hello C!", "hi D", "hello E!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not endWith regex ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEndsWith(xs, "!", 2) + " in " + xs)
  }
  def `Seq("hello A!", "hi B", "hello C!", "hi D", "hello E!").par should throw TestFailedException with correct stack depth and message when 'should include regex' failed` {
    val xs = Seq("hello A!", "hi B", "hello C!", "hi D", "hello E!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should include regex "ell"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesInclude(xs, "ell", 2) + " in " + xs)
  }
  def `Seq("hello A!", "hi B", "hello C!", "hi D", "hello E!").par should throw TestFailedException with correct stack depth and message when 'should not include regex' failed` {
    val xs = Seq("hello A!", "hi B", "hello C!", "hi D", "hello E!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not include regex ("ell")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotInclude(xs, "ell", 2) + " in " + xs)
  }
  def `Seq("hello A!", "hi B", "hello C!", "hi D", "hello E!").par should throw TestFailedException with correct stack depth and message when 'should fullyMatch regex' failed` {
    val xs = Seq("hello A!", "hi B", "hello C!", "hi D", "hello E!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should fullyMatch regex "h.*!"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesMatches(xs, "h.*!", 2) + " in " + xs)
  }
  def `Seq("hello A!", "hi B", "hello C!", "hi D", "hello E!").par should throw TestFailedException with correct stack depth and message when 'should not fullyMatch regex' failed` {
    val xs = Seq("hello A!", "hi B", "hello C!", "hi D", "hello E!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not fullyMatch regex ("h.*!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotMatches(xs, "h.*!", 2) + " in " + xs)
  }
  def `IndexedSeq("hello A!", "hi B", "hello C!", "hi D", "hello E!").par should throw TestFailedException with correct stack depth and message when 'should startWith' failed` {
    val xs = IndexedSeq("hello A!", "hi B", "hello C!", "hi D", "hello E!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should startWith ("hello")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesStartsWith(xs, "hello", 2) + " in " + xs)
  }
  def `IndexedSeq("hello A!", "hi B", "hello C!", "hi D", "hello E!").par should throw TestFailedException with correct stack depth and message when 'should not startWith' failed` {
    val xs = IndexedSeq("hello A!", "hi B", "hello C!", "hi D", "hello E!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not startWith ("hello")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotStartsWith(xs, "hello", 2) + " in " + xs)
  }
  def `IndexedSeq("hello A!", "hi B", "hello C!", "hi D", "hello E!").par should throw TestFailedException with correct stack depth and message when 'should endWith' failed` {
    val xs = IndexedSeq("hello A!", "hi B", "hello C!", "hi D", "hello E!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should endWith ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesEndsWith(xs, "!", 2) + " in " + xs)
  }
  def `IndexedSeq("hello A!", "hi B", "hello C!", "hi D", "hello E!").par should throw TestFailedException with correct stack depth and message when 'should not endWith' failed` {
    val xs = IndexedSeq("hello A!", "hi B", "hello C!", "hi D", "hello E!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not endWith ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEndsWith(xs, "!", 2) + " in " + xs)
  }
  def `IndexedSeq("hello A!", "hi B", "hello C!", "hi D", "hello E!").par should throw TestFailedException with correct stack depth and message when 'should include' failed` {
    val xs = IndexedSeq("hello A!", "hi B", "hello C!", "hi D", "hello E!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should include ("ell")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesInclude(xs, "ell", 2) + " in " + xs)
  }
  def `IndexedSeq("hello A!", "hi B", "hello C!", "hi D", "hello E!").par should throw TestFailedException with correct stack depth and message when 'should not include' failed` {
    val xs = IndexedSeq("hello A!", "hi B", "hello C!", "hi D", "hello E!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not include "ell"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotInclude(xs, "ell", 2) + " in " + xs)
  }
  def `IndexedSeq("hello A!", "hi B", "hello C!", "hi D", "hello E!").par should throw TestFailedException with correct stack depth and message when 'should startWith regex' failed` {
    val xs = IndexedSeq("hello A!", "hi B", "hello C!", "hi D", "hello E!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should startWith regex "hel*o"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesStartsWith(xs, "hello", 2) + " in " + xs)
  }
  def `IndexedSeq("hello A!", "hi B", "hello C!", "hi D", "hello E!").par should throw TestFailedException with correct stack depth and message when 'should not startWith regex' failed` {
    val xs = IndexedSeq("hello A!", "hi B", "hello C!", "hi D", "hello E!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not startWith regex ("hel*o")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotStartsWith(xs, "hello", 2) + " in " + xs)
  }
  def `IndexedSeq("hello A!", "hi B", "hello C!", "hi D", "hello E!").par should throw TestFailedException with correct stack depth and message when 'should endWith regex' failed` {
    val xs = IndexedSeq("hello A!", "hi B", "hello C!", "hi D", "hello E!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should endWith regex "!"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesEndsWith(xs, "!", 2) + " in " + xs)
  }
  def `IndexedSeq("hello A!", "hi B", "hello C!", "hi D", "hello E!").par should throw TestFailedException with correct stack depth and message when 'should not endWith regex' failed` {
    val xs = IndexedSeq("hello A!", "hi B", "hello C!", "hi D", "hello E!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not endWith regex ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEndsWith(xs, "!", 2) + " in " + xs)
  }
  def `IndexedSeq("hello A!", "hi B", "hello C!", "hi D", "hello E!").par should throw TestFailedException with correct stack depth and message when 'should include regex' failed` {
    val xs = IndexedSeq("hello A!", "hi B", "hello C!", "hi D", "hello E!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should include regex "ell"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesInclude(xs, "ell", 2) + " in " + xs)
  }
  def `IndexedSeq("hello A!", "hi B", "hello C!", "hi D", "hello E!").par should throw TestFailedException with correct stack depth and message when 'should not include regex' failed` {
    val xs = IndexedSeq("hello A!", "hi B", "hello C!", "hi D", "hello E!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not include regex ("ell")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotInclude(xs, "ell", 2) + " in " + xs)
  }
  def `IndexedSeq("hello A!", "hi B", "hello C!", "hi D", "hello E!").par should throw TestFailedException with correct stack depth and message when 'should fullyMatch regex' failed` {
    val xs = IndexedSeq("hello A!", "hi B", "hello C!", "hi D", "hello E!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should fullyMatch regex "h.*!"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesMatches(xs, "h.*!", 2) + " in " + xs)
  }
  def `IndexedSeq("hello A!", "hi B", "hello C!", "hi D", "hello E!").par should throw TestFailedException with correct stack depth and message when 'should not fullyMatch regex' failed` {
    val xs = IndexedSeq("hello A!", "hi B", "hello C!", "hi D", "hello E!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not fullyMatch regex ("h.*!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotMatches(xs, "h.*!", 2) + " in " + xs)
  }
  def `collection.mutable.Set("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should startWith' failed` {
    val xs = collection.mutable.Set("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should startWith ("hello")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesStartsWith(xs, "hello", 2) + " in " + xs)
  }
  def `collection.mutable.Set("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should not startWith' failed` {
    val xs = collection.mutable.Set("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not startWith ("hello")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotStartsWith(xs, "hello", 2) + " in " + xs)
  }
  def `collection.mutable.Set("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should endWith' failed` {
    val xs = collection.mutable.Set("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should endWith ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesEndsWith(xs, "!", 2) + " in " + xs)
  }
  def `collection.mutable.Set("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should not endWith' failed` {
    val xs = collection.mutable.Set("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not endWith ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEndsWith(xs, "!", 2) + " in " + xs)
  }
  def `collection.mutable.Set("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should include' failed` {
    val xs = collection.mutable.Set("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should include ("ell")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesInclude(xs, "ell", 2) + " in " + xs)
  }
  def `collection.mutable.Set("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should not include' failed` {
    val xs = collection.mutable.Set("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not include "ell"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotInclude(xs, "ell", 2) + " in " + xs)
  }
  def `collection.mutable.Set("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should startWith regex' failed` {
    val xs = collection.mutable.Set("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should startWith regex "hel*o"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesStartsWith(xs, "hello", 2) + " in " + xs)
  }
  def `collection.mutable.Set("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should not startWith regex' failed` {
    val xs = collection.mutable.Set("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not startWith regex ("hel*o")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotStartsWith(xs, "hello", 2) + " in " + xs)
  }
  def `collection.mutable.Set("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should endWith regex' failed` {
    val xs = collection.mutable.Set("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should endWith regex "!"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesEndsWith(xs, "!", 2) + " in " + xs)
  }
  def `collection.mutable.Set("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should not endWith regex' failed` {
    val xs = collection.mutable.Set("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not endWith regex ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEndsWith(xs, "!", 2) + " in " + xs)
  }
  def `collection.mutable.Set("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should include regex' failed` {
    val xs = collection.mutable.Set("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should include regex "ell"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesInclude(xs, "ell", 2) + " in " + xs)
  }
  def `collection.mutable.Set("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should not include regex' failed` {
    val xs = collection.mutable.Set("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not include regex ("ell")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotInclude(xs, "ell", 2) + " in " + xs)
  }
  def `collection.mutable.Set("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should fullyMatch regex' failed` {
    val xs = collection.mutable.Set("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should fullyMatch regex "h.*!"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesMatches(xs, "h.*!", 2) + " in " + xs)
  }
  def `collection.mutable.Set("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should not fullyMatch regex' failed` {
    val xs = collection.mutable.Set("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not fullyMatch regex ("h.*!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotMatches(xs, "h.*!", 2) + " in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should startWith' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should startWith ("hello")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesStartsWith(xs, "hello", 2) + " in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should not startWith' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not startWith ("hello")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotStartsWith(xs, "hello", 2) + " in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should endWith' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should endWith ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesEndsWith(xs, "!", 2) + " in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should not endWith' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not endWith ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEndsWith(xs, "!", 2) + " in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should include' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should include ("ell")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesInclude(xs, "ell", 2) + " in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should not include' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not include "ell"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotInclude(xs, "ell", 2) + " in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should startWith regex' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should startWith regex "hel*o"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesStartsWith(xs, "hello", 2) + " in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should not startWith regex' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not startWith regex ("hel*o")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotStartsWith(xs, "hello", 2) + " in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should endWith regex' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should endWith regex "!"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesEndsWith(xs, "!", 2) + " in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should not endWith regex' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not endWith regex ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEndsWith(xs, "!", 2) + " in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should include regex' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should include regex "ell"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesInclude(xs, "ell", 2) + " in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should not include regex' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not include regex ("ell")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotInclude(xs, "ell", 2) + " in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should fullyMatch regex' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should fullyMatch regex "h.*!"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesMatches(xs, "h.*!", 2) + " in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should not fullyMatch regex' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not fullyMatch regex ("h.*!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotMatches(xs, "h.*!", 2) + " in " + xs)
  }
  def `collection.mutable.Seq("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should startWith' failed` {
    val xs = collection.mutable.Seq("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should startWith ("hello")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesStartsWith(xs, "hello", 2) + " in " + xs)
  }
  def `collection.mutable.Seq("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should not startWith' failed` {
    val xs = collection.mutable.Seq("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not startWith ("hello")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotStartsWith(xs, "hello", 2) + " in " + xs)
  }
  def `collection.mutable.Seq("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should endWith' failed` {
    val xs = collection.mutable.Seq("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should endWith ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesEndsWith(xs, "!", 2) + " in " + xs)
  }
  def `collection.mutable.Seq("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should not endWith' failed` {
    val xs = collection.mutable.Seq("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not endWith ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEndsWith(xs, "!", 2) + " in " + xs)
  }
  def `collection.mutable.Seq("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should include' failed` {
    val xs = collection.mutable.Seq("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should include ("ell")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesInclude(xs, "ell", 2) + " in " + xs)
  }
  def `collection.mutable.Seq("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should not include' failed` {
    val xs = collection.mutable.Seq("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not include "ell"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotInclude(xs, "ell", 2) + " in " + xs)
  }
  def `collection.mutable.Seq("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should startWith regex' failed` {
    val xs = collection.mutable.Seq("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should startWith regex "hel*o"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesStartsWith(xs, "hello", 2) + " in " + xs)
  }
  def `collection.mutable.Seq("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should not startWith regex' failed` {
    val xs = collection.mutable.Seq("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not startWith regex ("hel*o")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotStartsWith(xs, "hello", 2) + " in " + xs)
  }
  def `collection.mutable.Seq("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should endWith regex' failed` {
    val xs = collection.mutable.Seq("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should endWith regex "!"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesEndsWith(xs, "!", 2) + " in " + xs)
  }
  def `collection.mutable.Seq("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should not endWith regex' failed` {
    val xs = collection.mutable.Seq("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not endWith regex ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEndsWith(xs, "!", 2) + " in " + xs)
  }
  def `collection.mutable.Seq("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should include regex' failed` {
    val xs = collection.mutable.Seq("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should include regex "ell"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesInclude(xs, "ell", 2) + " in " + xs)
  }
  def `collection.mutable.Seq("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should not include regex' failed` {
    val xs = collection.mutable.Seq("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not include regex ("ell")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotInclude(xs, "ell", 2) + " in " + xs)
  }
  def `collection.mutable.Seq("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should fullyMatch regex' failed` {
    val xs = collection.mutable.Seq("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should fullyMatch regex "h.*!"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesMatches(xs, "h.*!", 2) + " in " + xs)
  }
  def `collection.mutable.Seq("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should not fullyMatch regex' failed` {
    val xs = collection.mutable.Seq("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not fullyMatch regex ("h.*!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotMatches(xs, "h.*!", 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should startWith' failed` {
    val xs = collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should startWith ("hello")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesStartsWith(xs, "hello", 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should not startWith' failed` {
    val xs = collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not startWith ("hello")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotStartsWith(xs, "hello", 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should endWith' failed` {
    val xs = collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should endWith ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesEndsWith(xs, "!", 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should not endWith' failed` {
    val xs = collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not endWith ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEndsWith(xs, "!", 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should include' failed` {
    val xs = collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should include ("ell")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesInclude(xs, "ell", 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should not include' failed` {
    val xs = collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not include "ell"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotInclude(xs, "ell", 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should startWith regex' failed` {
    val xs = collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should startWith regex "hel*o"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesStartsWith(xs, "hello", 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should not startWith regex' failed` {
    val xs = collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not startWith regex ("hel*o")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotStartsWith(xs, "hello", 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should endWith regex' failed` {
    val xs = collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should endWith regex "!"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesEndsWith(xs, "!", 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should not endWith regex' failed` {
    val xs = collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not endWith regex ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEndsWith(xs, "!", 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should include regex' failed` {
    val xs = collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should include regex "ell"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesInclude(xs, "ell", 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should not include regex' failed` {
    val xs = collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not include regex ("ell")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotInclude(xs, "ell", 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should fullyMatch regex' failed` {
    val xs = collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should fullyMatch regex "h.*!"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesMatches(xs, "h.*!", 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!", "hi D", "hello E!") should throw TestFailedException with correct stack depth and message when 'should not fullyMatch regex' failed` {
    val xs = collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!", "hi D", "hello E!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not fullyMatch regex ("h.*!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotMatches(xs, "h.*!", 2) + " in " + xs)
  }
  def `collection.mutable.Set("hello A!", "hi B", "hello C!", "hi D", "hello E!").par should throw TestFailedException with correct stack depth and message when 'should startWith' failed` {
    val xs = collection.mutable.Set("hello A!", "hi B", "hello C!", "hi D", "hello E!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should startWith ("hello")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesStartsWith(xs, "hello", 2) + " in " + xs)
  }
  def `collection.mutable.Set("hello A!", "hi B", "hello C!", "hi D", "hello E!").par should throw TestFailedException with correct stack depth and message when 'should not startWith' failed` {
    val xs = collection.mutable.Set("hello A!", "hi B", "hello C!", "hi D", "hello E!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not startWith ("hello")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotStartsWith(xs, "hello", 2) + " in " + xs)
  }
  def `collection.mutable.Set("hello A!", "hi B", "hello C!", "hi D", "hello E!").par should throw TestFailedException with correct stack depth and message when 'should endWith' failed` {
    val xs = collection.mutable.Set("hello A!", "hi B", "hello C!", "hi D", "hello E!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should endWith ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesEndsWith(xs, "!", 2) + " in " + xs)
  }
  def `collection.mutable.Set("hello A!", "hi B", "hello C!", "hi D", "hello E!").par should throw TestFailedException with correct stack depth and message when 'should not endWith' failed` {
    val xs = collection.mutable.Set("hello A!", "hi B", "hello C!", "hi D", "hello E!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not endWith ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEndsWith(xs, "!", 2) + " in " + xs)
  }
  def `collection.mutable.Set("hello A!", "hi B", "hello C!", "hi D", "hello E!").par should throw TestFailedException with correct stack depth and message when 'should include' failed` {
    val xs = collection.mutable.Set("hello A!", "hi B", "hello C!", "hi D", "hello E!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should include ("ell")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesInclude(xs, "ell", 2) + " in " + xs)
  }
  def `collection.mutable.Set("hello A!", "hi B", "hello C!", "hi D", "hello E!").par should throw TestFailedException with correct stack depth and message when 'should not include' failed` {
    val xs = collection.mutable.Set("hello A!", "hi B", "hello C!", "hi D", "hello E!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not include "ell"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotInclude(xs, "ell", 2) + " in " + xs)
  }
  def `collection.mutable.Set("hello A!", "hi B", "hello C!", "hi D", "hello E!").par should throw TestFailedException with correct stack depth and message when 'should startWith regex' failed` {
    val xs = collection.mutable.Set("hello A!", "hi B", "hello C!", "hi D", "hello E!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should startWith regex "hel*o"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesStartsWith(xs, "hello", 2) + " in " + xs)
  }
  def `collection.mutable.Set("hello A!", "hi B", "hello C!", "hi D", "hello E!").par should throw TestFailedException with correct stack depth and message when 'should not startWith regex' failed` {
    val xs = collection.mutable.Set("hello A!", "hi B", "hello C!", "hi D", "hello E!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not startWith regex ("hel*o")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotStartsWith(xs, "hello", 2) + " in " + xs)
  }
  def `collection.mutable.Set("hello A!", "hi B", "hello C!", "hi D", "hello E!").par should throw TestFailedException with correct stack depth and message when 'should endWith regex' failed` {
    val xs = collection.mutable.Set("hello A!", "hi B", "hello C!", "hi D", "hello E!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should endWith regex "!"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesEndsWith(xs, "!", 2) + " in " + xs)
  }
  def `collection.mutable.Set("hello A!", "hi B", "hello C!", "hi D", "hello E!").par should throw TestFailedException with correct stack depth and message when 'should not endWith regex' failed` {
    val xs = collection.mutable.Set("hello A!", "hi B", "hello C!", "hi D", "hello E!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not endWith regex ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEndsWith(xs, "!", 2) + " in " + xs)
  }
  def `collection.mutable.Set("hello A!", "hi B", "hello C!", "hi D", "hello E!").par should throw TestFailedException with correct stack depth and message when 'should include regex' failed` {
    val xs = collection.mutable.Set("hello A!", "hi B", "hello C!", "hi D", "hello E!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should include regex "ell"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesInclude(xs, "ell", 2) + " in " + xs)
  }
  def `collection.mutable.Set("hello A!", "hi B", "hello C!", "hi D", "hello E!").par should throw TestFailedException with correct stack depth and message when 'should not include regex' failed` {
    val xs = collection.mutable.Set("hello A!", "hi B", "hello C!", "hi D", "hello E!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not include regex ("ell")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotInclude(xs, "ell", 2) + " in " + xs)
  }
  def `collection.mutable.Set("hello A!", "hi B", "hello C!", "hi D", "hello E!").par should throw TestFailedException with correct stack depth and message when 'should fullyMatch regex' failed` {
    val xs = collection.mutable.Set("hello A!", "hi B", "hello C!", "hi D", "hello E!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should fullyMatch regex "h.*!"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesMatches(xs, "h.*!", 2) + " in " + xs)
  }
  def `collection.mutable.Set("hello A!", "hi B", "hello C!", "hi D", "hello E!").par should throw TestFailedException with correct stack depth and message when 'should not fullyMatch regex' failed` {
    val xs = collection.mutable.Set("hello A!", "hi B", "hello C!", "hi D", "hello E!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not fullyMatch regex ("h.*!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotMatches(xs, "h.*!", 2) + " in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!", "hi D", "hello E!")).par should throw TestFailedException with correct stack depth and message when 'should startWith' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!", "hi D", "hello E!")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should startWith ("hello")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesStartsWith(xs, "hello", 2) + " in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!", "hi D", "hello E!")).par should throw TestFailedException with correct stack depth and message when 'should not startWith' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!", "hi D", "hello E!")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not startWith ("hello")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotStartsWith(xs, "hello", 2) + " in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!", "hi D", "hello E!")).par should throw TestFailedException with correct stack depth and message when 'should endWith' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!", "hi D", "hello E!")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should endWith ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesEndsWith(xs, "!", 2) + " in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!", "hi D", "hello E!")).par should throw TestFailedException with correct stack depth and message when 'should not endWith' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!", "hi D", "hello E!")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not endWith ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEndsWith(xs, "!", 2) + " in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!", "hi D", "hello E!")).par should throw TestFailedException with correct stack depth and message when 'should include' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!", "hi D", "hello E!")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should include ("ell")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesInclude(xs, "ell", 2) + " in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!", "hi D", "hello E!")).par should throw TestFailedException with correct stack depth and message when 'should not include' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!", "hi D", "hello E!")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not include "ell"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotInclude(xs, "ell", 2) + " in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!", "hi D", "hello E!")).par should throw TestFailedException with correct stack depth and message when 'should startWith regex' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!", "hi D", "hello E!")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should startWith regex "hel*o"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesStartsWith(xs, "hello", 2) + " in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!", "hi D", "hello E!")).par should throw TestFailedException with correct stack depth and message when 'should not startWith regex' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!", "hi D", "hello E!")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not startWith regex ("hel*o")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotStartsWith(xs, "hello", 2) + " in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!", "hi D", "hello E!")).par should throw TestFailedException with correct stack depth and message when 'should endWith regex' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!", "hi D", "hello E!")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should endWith regex "!"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesEndsWith(xs, "!", 2) + " in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!", "hi D", "hello E!")).par should throw TestFailedException with correct stack depth and message when 'should not endWith regex' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!", "hi D", "hello E!")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not endWith regex ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEndsWith(xs, "!", 2) + " in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!", "hi D", "hello E!")).par should throw TestFailedException with correct stack depth and message when 'should include regex' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!", "hi D", "hello E!")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should include regex "ell"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesInclude(xs, "ell", 2) + " in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!", "hi D", "hello E!")).par should throw TestFailedException with correct stack depth and message when 'should not include regex' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!", "hi D", "hello E!")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not include regex ("ell")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotInclude(xs, "ell", 2) + " in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!", "hi D", "hello E!")).par should throw TestFailedException with correct stack depth and message when 'should fullyMatch regex' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!", "hi D", "hello E!")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should fullyMatch regex "h.*!"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesMatches(xs, "h.*!", 2) + " in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!", "hi D", "hello E!")).par should throw TestFailedException with correct stack depth and message when 'should not fullyMatch regex' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!", "hi D", "hello E!")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not fullyMatch regex ("h.*!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotMatches(xs, "h.*!", 2) + " in " + xs)
  }
  def `collection.mutable.Seq("hello A!", "hi B", "hello C!", "hi D", "hello E!").par should throw TestFailedException with correct stack depth and message when 'should startWith' failed` {
    val xs = collection.mutable.Seq("hello A!", "hi B", "hello C!", "hi D", "hello E!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should startWith ("hello")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesStartsWith(xs, "hello", 2) + " in " + xs)
  }
  def `collection.mutable.Seq("hello A!", "hi B", "hello C!", "hi D", "hello E!").par should throw TestFailedException with correct stack depth and message when 'should not startWith' failed` {
    val xs = collection.mutable.Seq("hello A!", "hi B", "hello C!", "hi D", "hello E!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not startWith ("hello")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotStartsWith(xs, "hello", 2) + " in " + xs)
  }
  def `collection.mutable.Seq("hello A!", "hi B", "hello C!", "hi D", "hello E!").par should throw TestFailedException with correct stack depth and message when 'should endWith' failed` {
    val xs = collection.mutable.Seq("hello A!", "hi B", "hello C!", "hi D", "hello E!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should endWith ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesEndsWith(xs, "!", 2) + " in " + xs)
  }
  def `collection.mutable.Seq("hello A!", "hi B", "hello C!", "hi D", "hello E!").par should throw TestFailedException with correct stack depth and message when 'should not endWith' failed` {
    val xs = collection.mutable.Seq("hello A!", "hi B", "hello C!", "hi D", "hello E!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not endWith ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEndsWith(xs, "!", 2) + " in " + xs)
  }
  def `collection.mutable.Seq("hello A!", "hi B", "hello C!", "hi D", "hello E!").par should throw TestFailedException with correct stack depth and message when 'should include' failed` {
    val xs = collection.mutable.Seq("hello A!", "hi B", "hello C!", "hi D", "hello E!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should include ("ell")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesInclude(xs, "ell", 2) + " in " + xs)
  }
  def `collection.mutable.Seq("hello A!", "hi B", "hello C!", "hi D", "hello E!").par should throw TestFailedException with correct stack depth and message when 'should not include' failed` {
    val xs = collection.mutable.Seq("hello A!", "hi B", "hello C!", "hi D", "hello E!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not include "ell"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotInclude(xs, "ell", 2) + " in " + xs)
  }
  def `collection.mutable.Seq("hello A!", "hi B", "hello C!", "hi D", "hello E!").par should throw TestFailedException with correct stack depth and message when 'should startWith regex' failed` {
    val xs = collection.mutable.Seq("hello A!", "hi B", "hello C!", "hi D", "hello E!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should startWith regex "hel*o"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesStartsWith(xs, "hello", 2) + " in " + xs)
  }
  def `collection.mutable.Seq("hello A!", "hi B", "hello C!", "hi D", "hello E!").par should throw TestFailedException with correct stack depth and message when 'should not startWith regex' failed` {
    val xs = collection.mutable.Seq("hello A!", "hi B", "hello C!", "hi D", "hello E!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not startWith regex ("hel*o")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotStartsWith(xs, "hello", 2) + " in " + xs)
  }
  def `collection.mutable.Seq("hello A!", "hi B", "hello C!", "hi D", "hello E!").par should throw TestFailedException with correct stack depth and message when 'should endWith regex' failed` {
    val xs = collection.mutable.Seq("hello A!", "hi B", "hello C!", "hi D", "hello E!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should endWith regex "!"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesEndsWith(xs, "!", 2) + " in " + xs)
  }
  def `collection.mutable.Seq("hello A!", "hi B", "hello C!", "hi D", "hello E!").par should throw TestFailedException with correct stack depth and message when 'should not endWith regex' failed` {
    val xs = collection.mutable.Seq("hello A!", "hi B", "hello C!", "hi D", "hello E!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not endWith regex ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEndsWith(xs, "!", 2) + " in " + xs)
  }
  def `collection.mutable.Seq("hello A!", "hi B", "hello C!", "hi D", "hello E!").par should throw TestFailedException with correct stack depth and message when 'should include regex' failed` {
    val xs = collection.mutable.Seq("hello A!", "hi B", "hello C!", "hi D", "hello E!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should include regex "ell"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesInclude(xs, "ell", 2) + " in " + xs)
  }
  def `collection.mutable.Seq("hello A!", "hi B", "hello C!", "hi D", "hello E!").par should throw TestFailedException with correct stack depth and message when 'should not include regex' failed` {
    val xs = collection.mutable.Seq("hello A!", "hi B", "hello C!", "hi D", "hello E!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not include regex ("ell")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotInclude(xs, "ell", 2) + " in " + xs)
  }
  def `collection.mutable.Seq("hello A!", "hi B", "hello C!", "hi D", "hello E!").par should throw TestFailedException with correct stack depth and message when 'should fullyMatch regex' failed` {
    val xs = collection.mutable.Seq("hello A!", "hi B", "hello C!", "hi D", "hello E!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should fullyMatch regex "h.*!"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesMatches(xs, "h.*!", 2) + " in " + xs)
  }
  def `collection.mutable.Seq("hello A!", "hi B", "hello C!", "hi D", "hello E!").par should throw TestFailedException with correct stack depth and message when 'should not fullyMatch regex' failed` {
    val xs = collection.mutable.Seq("hello A!", "hi B", "hello C!", "hi D", "hello E!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not fullyMatch regex ("h.*!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotMatches(xs, "h.*!", 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!", "hi D", "hello E!").par should throw TestFailedException with correct stack depth and message when 'should startWith' failed` {
    val xs = collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!", "hi D", "hello E!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should startWith ("hello")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesStartsWith(xs, "hello", 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!", "hi D", "hello E!").par should throw TestFailedException with correct stack depth and message when 'should not startWith' failed` {
    val xs = collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!", "hi D", "hello E!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not startWith ("hello")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotStartsWith(xs, "hello", 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!", "hi D", "hello E!").par should throw TestFailedException with correct stack depth and message when 'should endWith' failed` {
    val xs = collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!", "hi D", "hello E!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should endWith ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesEndsWith(xs, "!", 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!", "hi D", "hello E!").par should throw TestFailedException with correct stack depth and message when 'should not endWith' failed` {
    val xs = collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!", "hi D", "hello E!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not endWith ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEndsWith(xs, "!", 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!", "hi D", "hello E!").par should throw TestFailedException with correct stack depth and message when 'should include' failed` {
    val xs = collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!", "hi D", "hello E!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should include ("ell")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesInclude(xs, "ell", 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!", "hi D", "hello E!").par should throw TestFailedException with correct stack depth and message when 'should not include' failed` {
    val xs = collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!", "hi D", "hello E!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not include "ell"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotInclude(xs, "ell", 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!", "hi D", "hello E!").par should throw TestFailedException with correct stack depth and message when 'should startWith regex' failed` {
    val xs = collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!", "hi D", "hello E!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should startWith regex "hel*o"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesStartsWith(xs, "hello", 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!", "hi D", "hello E!").par should throw TestFailedException with correct stack depth and message when 'should not startWith regex' failed` {
    val xs = collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!", "hi D", "hello E!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not startWith regex ("hel*o")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotStartsWith(xs, "hello", 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!", "hi D", "hello E!").par should throw TestFailedException with correct stack depth and message when 'should endWith regex' failed` {
    val xs = collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!", "hi D", "hello E!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should endWith regex "!"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesEndsWith(xs, "!", 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!", "hi D", "hello E!").par should throw TestFailedException with correct stack depth and message when 'should not endWith regex' failed` {
    val xs = collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!", "hi D", "hello E!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not endWith regex ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEndsWith(xs, "!", 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!", "hi D", "hello E!").par should throw TestFailedException with correct stack depth and message when 'should include regex' failed` {
    val xs = collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!", "hi D", "hello E!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should include regex "ell"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesInclude(xs, "ell", 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!", "hi D", "hello E!").par should throw TestFailedException with correct stack depth and message when 'should not include regex' failed` {
    val xs = collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!", "hi D", "hello E!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not include regex ("ell")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotInclude(xs, "ell", 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!", "hi D", "hello E!").par should throw TestFailedException with correct stack depth and message when 'should fullyMatch regex' failed` {
    val xs = collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!", "hi D", "hello E!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should fullyMatch regex "h.*!"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesMatches(xs, "h.*!", 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!", "hi D", "hello E!").par should throw TestFailedException with correct stack depth and message when 'should not fullyMatch regex' failed` {
    val xs = collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!", "hi D", "hello E!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not fullyMatch regex ("h.*!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotMatches(xs, "h.*!", 2) + " in " + xs)
  }
  def `Set(Set[String]("", "boom!", "great!"), Set[String](), Set[String]("hi", "cool!")) should throw TestFailedException with correct stack depth and message when 'traversable should not be symbol' failed` {
    val xs = Set(Set[String]("", "boom!", "great!"), Set[String](), Set[String]("hi", "cool!"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeNotEqualGenTraversable[String](xs, 0, 2) + " in " + xs)
  }
  def `List(List[String]("", "boom!", "great!"), List[String](), List[String]("hi", "cool!")) should throw TestFailedException with correct stack depth and message when 'traversable should not be symbol' failed` {
    val xs = List(List[String]("", "boom!", "great!"), List[String](), List[String]("hi", "cool!"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeNotEqualGenTraversable[String](xs, 0, 2) + " in " + xs)
  }
  def `Seq(Seq[String]("", "boom!", "great!"), Seq[String](), Seq[String]("hi", "cool!")) should throw TestFailedException with correct stack depth and message when 'traversable should not be symbol' failed` {
    val xs = Seq(Seq[String]("", "boom!", "great!"), Seq[String](), Seq[String]("hi", "cool!"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeNotEqualGenTraversable[String](xs, 0, 2) + " in " + xs)
  }
  def `Array[Array[String]](Array[String]("", "boom!", "great!"), Array[String](), Array[String]("hi", "cool!")) should throw TestFailedException with correct stack depth and message when 'traversable should not be symbol' failed` {
    val xs = Array[Array[String]](Array[String]("", "boom!", "great!"), Array[String](), Array[String]("hi", "cool!"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeNotEqualGenTraversableArray[String](xs, 0, 2) + " in " + arrayToString(xs))
  }
  def `IndexedSeq(IndexedSeq[String]("", "boom!", "great!"), IndexedSeq[String](), IndexedSeq[String]("hi", "cool!")) should throw TestFailedException with correct stack depth and message when 'traversable should not be symbol' failed` {
    val xs = IndexedSeq(IndexedSeq[String]("", "boom!", "great!"), IndexedSeq[String](), IndexedSeq[String]("hi", "cool!"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeNotEqualGenTraversable[String](xs, 0, 2) + " in " + xs)
  }
  def `Vector(Vector[String]("", "boom!", "great!"), Vector[String](), Vector[String]("hi", "cool!")) should throw TestFailedException with correct stack depth and message when 'traversable should not be symbol' failed` {
    val xs = Vector(Vector[String]("", "boom!", "great!"), Vector[String](), Vector[String]("hi", "cool!"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeNotEqualGenTraversable[String](xs, 0, 2) + " in " + xs)
  }
  def `Set(Set[String]("", "boom!", "great!").par, Set[String]().par, Set[String]("hi", "cool!").par).par should throw TestFailedException with correct stack depth and message when 'traversable should not be symbol' failed` {
    val xs = Set(Set[String]("", "boom!", "great!").par, Set[String]().par, Set[String]("hi", "cool!").par).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeNotEqualGenTraversable[String](xs, 0, 2) + " in " + xs)
  }
  def `List(List[String]("", "boom!", "great!").par, List[String]().par, List[String]("hi", "cool!").par).par should throw TestFailedException with correct stack depth and message when 'traversable should not be symbol' failed` {
    val xs = List(List[String]("", "boom!", "great!").par, List[String]().par, List[String]("hi", "cool!").par).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeNotEqualGenTraversable[String](xs, 0, 2) + " in " + xs)
  }
  def `Seq(Seq[String]("", "boom!", "great!").par, Seq[String]().par, Seq[String]("hi", "cool!").par).par should throw TestFailedException with correct stack depth and message when 'traversable should not be symbol' failed` {
    val xs = Seq(Seq[String]("", "boom!", "great!").par, Seq[String]().par, Seq[String]("hi", "cool!").par).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeNotEqualGenTraversable[String](xs, 0, 2) + " in " + xs)
  }
  def `IndexedSeq(IndexedSeq[String]("", "boom!", "great!").par, IndexedSeq[String]().par, IndexedSeq[String]("hi", "cool!").par).par should throw TestFailedException with correct stack depth and message when 'traversable should not be symbol' failed` {
    val xs = IndexedSeq(IndexedSeq[String]("", "boom!", "great!").par, IndexedSeq[String]().par, IndexedSeq[String]("hi", "cool!").par).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeNotEqualGenTraversable[String](xs, 0, 2) + " in " + xs)
  }
  def `collection.mutable.Set(collection.mutable.Set[String]("", "boom!", "great!"), collection.mutable.Set[String](), collection.mutable.Set[String]("hi", "cool!")) should throw TestFailedException with correct stack depth and message when 'traversable should not be symbol' failed` {
    val xs = collection.mutable.Set(collection.mutable.Set[String]("", "boom!", "great!"), collection.mutable.Set[String](), collection.mutable.Set[String]("hi", "cool!"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeNotEqualGenTraversable[String](xs, 0, 2) + " in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List(new collection.mutable.ListBuffer[String]() ++ List[String]("", "boom!", "great!"), new collection.mutable.ListBuffer[String]() ++ List[String](), new collection.mutable.ListBuffer[String]() ++ List[String]("hi", "cool!")) should throw TestFailedException with correct stack depth and message when 'traversable should not be symbol' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List(new collection.mutable.ListBuffer[String]() ++ List[String]("", "boom!", "great!"), new collection.mutable.ListBuffer[String]() ++ List[String](), new collection.mutable.ListBuffer[String]() ++ List[String]("hi", "cool!"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeNotEqualGenTraversable[String](xs, 0, 2) + " in " + xs)
  }
  def `collection.mutable.Seq(collection.mutable.Seq[String]("", "boom!", "great!"), collection.mutable.Seq[String](), collection.mutable.Seq[String]("hi", "cool!")) should throw TestFailedException with correct stack depth and message when 'traversable should not be symbol' failed` {
    val xs = collection.mutable.Seq(collection.mutable.Seq[String]("", "boom!", "great!"), collection.mutable.Seq[String](), collection.mutable.Seq[String]("hi", "cool!"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeNotEqualGenTraversable[String](xs, 0, 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq(collection.mutable.IndexedSeq[String]("", "boom!", "great!"), collection.mutable.IndexedSeq[String](), collection.mutable.IndexedSeq[String]("hi", "cool!")) should throw TestFailedException with correct stack depth and message when 'traversable should not be symbol' failed` {
    val xs = collection.mutable.IndexedSeq(collection.mutable.IndexedSeq[String]("", "boom!", "great!"), collection.mutable.IndexedSeq[String](), collection.mutable.IndexedSeq[String]("hi", "cool!"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeNotEqualGenTraversable[String](xs, 0, 2) + " in " + xs)
  }
  def `collection.mutable.Set(collection.mutable.Set[String]("", "boom!", "great!").par, collection.mutable.Set[String]().par, collection.mutable.Set[String]("hi", "cool!").par).par should throw TestFailedException with correct stack depth and message when 'traversable should not be symbol' failed` {
    val xs = collection.mutable.Set(collection.mutable.Set[String]("", "boom!", "great!").par, collection.mutable.Set[String]().par, collection.mutable.Set[String]("hi", "cool!").par).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeNotEqualGenTraversable[String](xs, 0, 2) + " in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List((new collection.mutable.ListBuffer[String]() ++ List[String]("", "boom!", "great!")).par, (new collection.mutable.ListBuffer[String]() ++ List[String]()).par, (new collection.mutable.ListBuffer[String]() ++ List[String]("hi", "cool!")).par)).par should throw TestFailedException with correct stack depth and message when 'traversable should not be symbol' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List((new collection.mutable.ListBuffer[String]() ++ List[String]("", "boom!", "great!")).par, (new collection.mutable.ListBuffer[String]() ++ List[String]()).par, (new collection.mutable.ListBuffer[String]() ++ List[String]("hi", "cool!")).par)).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeNotEqualGenTraversable[String](xs, 0, 2) + " in " + xs)
  }
  def `collection.mutable.Seq(collection.mutable.Seq[String]("", "boom!", "great!").par, collection.mutable.Seq[String]().par, collection.mutable.Seq[String]("hi", "cool!").par).par should throw TestFailedException with correct stack depth and message when 'traversable should not be symbol' failed` {
    val xs = collection.mutable.Seq(collection.mutable.Seq[String]("", "boom!", "great!").par, collection.mutable.Seq[String]().par, collection.mutable.Seq[String]("hi", "cool!").par).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeNotEqualGenTraversable[String](xs, 0, 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq(collection.mutable.IndexedSeq[String]("", "boom!", "great!").par, collection.mutable.IndexedSeq[String]().par, collection.mutable.IndexedSeq[String]("hi", "cool!").par).par should throw TestFailedException with correct stack depth and message when 'traversable should not be symbol' failed` {
    val xs = collection.mutable.IndexedSeq(collection.mutable.IndexedSeq[String]("", "boom!", "great!").par, collection.mutable.IndexedSeq[String]().par, collection.mutable.IndexedSeq[String]("hi", "cool!").par).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not be 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeNotEqualGenTraversable[String](xs, 0, 2) + " in " + xs)
  }
  def `Set(Set[String]("hi"), Set[String]("boom!"), Set[String]("hello"), Set[String]("boom!", "hi")) should throw TestFailedException with correct stack depth and message when 'traversable should have size' failed` {
    val xs = Set(Set[String]("hi"), Set[String]("boom!"), Set[String]("hello"), Set[String]("boom!", "hi"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should have size 1
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeEqualGenTraversable[String](xs, 1, 2) + " in " + xs)
  }
  def `Set(Set[String]("hi"), Set[String]("boom!"), Set[String]("hello"), Set[String]("boom!", "hi")) should throw TestFailedException with correct stack depth and message when 'traversable should not have size' failed` {
    val xs = Set(Set[String]("hi"), Set[String]("boom!"), Set[String]("hello"), Set[String]("boom!", "hi"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not have size (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeNotEqualGenTraversable[String](xs, 2, 2) + " in " + xs)
  }
  def `Set(Set[String]("hi"), Set[String]("boom!"), Set[String]("hello"), Set[String]("boom!", "hi")) should throw TestFailedException with correct stack depth and message when 'traversable should contain' failed` {
    val xs = Set(Set[String]("hi"), Set[String]("boom!"), Set[String]("hello"), Set[String]("boom!", "hi"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain ("hi")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainGenTraversable[String](xs, "hi", 2) + " in " + xs)
  }
  def `Set(Set[String]("hi"), Set[String]("boom!"), Set[String]("hello"), Set[String]("boom!", "hi")) should throw TestFailedException with correct stack depth and message when 'traversable should not contain' failed` {
    val xs = Set(Set[String]("hi"), Set[String]("boom!"), Set[String]("hello"), Set[String]("boom!", "hi"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain "hi"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainGenTraversable[String](xs, "hi", 2) + " in " + xs)
  }
  def `List(List[String]("hi"), List[String]("boom!"), List[String]("hello"), List[String]("boom!", "hi")) should throw TestFailedException with correct stack depth and message when 'traversable should have size' failed` {
    val xs = List(List[String]("hi"), List[String]("boom!"), List[String]("hello"), List[String]("boom!", "hi"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should have size 1
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeEqualGenTraversable[String](xs, 1, 2) + " in " + xs)
  }
  def `List(List[String]("hi"), List[String]("boom!"), List[String]("hello"), List[String]("boom!", "hi")) should throw TestFailedException with correct stack depth and message when 'traversable should not have size' failed` {
    val xs = List(List[String]("hi"), List[String]("boom!"), List[String]("hello"), List[String]("boom!", "hi"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not have size (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeNotEqualGenTraversable[String](xs, 2, 2) + " in " + xs)
  }
  def `List(List[String]("hi"), List[String]("boom!"), List[String]("hello"), List[String]("boom!", "hi")) should throw TestFailedException with correct stack depth and message when 'traversable should have length' failed` {
    val xs = List(List[String]("hi"), List[String]("boom!"), List[String]("hello"), List[String]("boom!", "hi"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should have length 1
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeEqualGenTraversable[String](xs, 1, 2) + " in " + xs)
  }
  def `List(List[String]("hi"), List[String]("boom!"), List[String]("hello"), List[String]("boom!", "hi")) should throw TestFailedException with correct stack depth and message when 'traversable should not have length' failed` {
    val xs = List(List[String]("hi"), List[String]("boom!"), List[String]("hello"), List[String]("boom!", "hi"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not have length (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeNotEqualGenTraversable[String](xs, 2, 2) + " in " + xs)
  }
  def `List(List[String]("hi"), List[String]("boom!"), List[String]("hello"), List[String]("boom!", "hi")) should throw TestFailedException with correct stack depth and message when 'traversable should contain' failed` {
    val xs = List(List[String]("hi"), List[String]("boom!"), List[String]("hello"), List[String]("boom!", "hi"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain ("hi")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainGenTraversable[String](xs, "hi", 2) + " in " + xs)
  }
  def `List(List[String]("hi"), List[String]("boom!"), List[String]("hello"), List[String]("boom!", "hi")) should throw TestFailedException with correct stack depth and message when 'traversable should not contain' failed` {
    val xs = List(List[String]("hi"), List[String]("boom!"), List[String]("hello"), List[String]("boom!", "hi"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain "hi"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainGenTraversable[String](xs, "hi", 2) + " in " + xs)
  }
  def `Seq(Seq[String]("hi"), Seq[String]("boom!"), Seq[String]("hello"), Seq[String]("boom!", "hi")) should throw TestFailedException with correct stack depth and message when 'traversable should have size' failed` {
    val xs = Seq(Seq[String]("hi"), Seq[String]("boom!"), Seq[String]("hello"), Seq[String]("boom!", "hi"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should have size 1
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeEqualGenTraversable[String](xs, 1, 2) + " in " + xs)
  }
  def `Seq(Seq[String]("hi"), Seq[String]("boom!"), Seq[String]("hello"), Seq[String]("boom!", "hi")) should throw TestFailedException with correct stack depth and message when 'traversable should not have size' failed` {
    val xs = Seq(Seq[String]("hi"), Seq[String]("boom!"), Seq[String]("hello"), Seq[String]("boom!", "hi"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not have size (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeNotEqualGenTraversable[String](xs, 2, 2) + " in " + xs)
  }
  def `Seq(Seq[String]("hi"), Seq[String]("boom!"), Seq[String]("hello"), Seq[String]("boom!", "hi")) should throw TestFailedException with correct stack depth and message when 'traversable should have length' failed` {
    val xs = Seq(Seq[String]("hi"), Seq[String]("boom!"), Seq[String]("hello"), Seq[String]("boom!", "hi"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should have length 1
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeEqualGenTraversable[String](xs, 1, 2) + " in " + xs)
  }
  def `Seq(Seq[String]("hi"), Seq[String]("boom!"), Seq[String]("hello"), Seq[String]("boom!", "hi")) should throw TestFailedException with correct stack depth and message when 'traversable should not have length' failed` {
    val xs = Seq(Seq[String]("hi"), Seq[String]("boom!"), Seq[String]("hello"), Seq[String]("boom!", "hi"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not have length (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeNotEqualGenTraversable[String](xs, 2, 2) + " in " + xs)
  }
  def `Seq(Seq[String]("hi"), Seq[String]("boom!"), Seq[String]("hello"), Seq[String]("boom!", "hi")) should throw TestFailedException with correct stack depth and message when 'traversable should contain' failed` {
    val xs = Seq(Seq[String]("hi"), Seq[String]("boom!"), Seq[String]("hello"), Seq[String]("boom!", "hi"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain ("hi")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainGenTraversable[String](xs, "hi", 2) + " in " + xs)
  }
  def `Seq(Seq[String]("hi"), Seq[String]("boom!"), Seq[String]("hello"), Seq[String]("boom!", "hi")) should throw TestFailedException with correct stack depth and message when 'traversable should not contain' failed` {
    val xs = Seq(Seq[String]("hi"), Seq[String]("boom!"), Seq[String]("hello"), Seq[String]("boom!", "hi"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain "hi"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainGenTraversable[String](xs, "hi", 2) + " in " + xs)
  }
  def `Array[Array[String]](Array[String]("hi"), Array[String]("boom!"), Array[String]("hello"), Array[String]("boom!", "hi")) should throw TestFailedException with correct stack depth and message when 'traversable should have size' failed` {
    val xs = Array[Array[String]](Array[String]("hi"), Array[String]("boom!"), Array[String]("hello"), Array[String]("boom!", "hi"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should have size 1
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeEqualGenTraversableArray[String](xs, 1, 2) + " in " + arrayToString(xs))
  }
  def `Array[Array[String]](Array[String]("hi"), Array[String]("boom!"), Array[String]("hello"), Array[String]("boom!", "hi")) should throw TestFailedException with correct stack depth and message when 'traversable should not have size' failed` {
    val xs = Array[Array[String]](Array[String]("hi"), Array[String]("boom!"), Array[String]("hello"), Array[String]("boom!", "hi"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not have size (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeNotEqualGenTraversableArray[String](xs, 2, 2) + " in " + arrayToString(xs))
  }
  def `Array[Array[String]](Array[String]("hi"), Array[String]("boom!"), Array[String]("hello"), Array[String]("boom!", "hi")) should throw TestFailedException with correct stack depth and message when 'traversable should have length' failed` {
    val xs = Array[Array[String]](Array[String]("hi"), Array[String]("boom!"), Array[String]("hello"), Array[String]("boom!", "hi"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should have length 1
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeEqualGenTraversableArray[String](xs, 1, 2) + " in " + arrayToString(xs))
  }
  def `Array[Array[String]](Array[String]("hi"), Array[String]("boom!"), Array[String]("hello"), Array[String]("boom!", "hi")) should throw TestFailedException with correct stack depth and message when 'traversable should not have length' failed` {
    val xs = Array[Array[String]](Array[String]("hi"), Array[String]("boom!"), Array[String]("hello"), Array[String]("boom!", "hi"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not have length (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeNotEqualGenTraversableArray[String](xs, 2, 2) + " in " + arrayToString(xs))
  }
  def `Array[Array[String]](Array[String]("hi"), Array[String]("boom!"), Array[String]("hello"), Array[String]("boom!", "hi")) should throw TestFailedException with correct stack depth and message when 'traversable should contain' failed` {
    val xs = Array[Array[String]](Array[String]("hi"), Array[String]("boom!"), Array[String]("hello"), Array[String]("boom!", "hi"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain ("hi")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainGenTraversableArray[String](xs, "hi", 2) + " in " + arrayToString(xs))
  }
  def `Array[Array[String]](Array[String]("hi"), Array[String]("boom!"), Array[String]("hello"), Array[String]("boom!", "hi")) should throw TestFailedException with correct stack depth and message when 'traversable should not contain' failed` {
    val xs = Array[Array[String]](Array[String]("hi"), Array[String]("boom!"), Array[String]("hello"), Array[String]("boom!", "hi"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain "hi"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainGenTraversableArray[String](xs, "hi", 2) + " in " + arrayToString(xs))
  }
  def `IndexedSeq(IndexedSeq[String]("hi"), IndexedSeq[String]("boom!"), IndexedSeq[String]("hello"), IndexedSeq[String]("boom!", "hi")) should throw TestFailedException with correct stack depth and message when 'traversable should have size' failed` {
    val xs = IndexedSeq(IndexedSeq[String]("hi"), IndexedSeq[String]("boom!"), IndexedSeq[String]("hello"), IndexedSeq[String]("boom!", "hi"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should have size 1
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeEqualGenTraversable[String](xs, 1, 2) + " in " + xs)
  }
  def `IndexedSeq(IndexedSeq[String]("hi"), IndexedSeq[String]("boom!"), IndexedSeq[String]("hello"), IndexedSeq[String]("boom!", "hi")) should throw TestFailedException with correct stack depth and message when 'traversable should not have size' failed` {
    val xs = IndexedSeq(IndexedSeq[String]("hi"), IndexedSeq[String]("boom!"), IndexedSeq[String]("hello"), IndexedSeq[String]("boom!", "hi"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not have size (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeNotEqualGenTraversable[String](xs, 2, 2) + " in " + xs)
  }
  def `IndexedSeq(IndexedSeq[String]("hi"), IndexedSeq[String]("boom!"), IndexedSeq[String]("hello"), IndexedSeq[String]("boom!", "hi")) should throw TestFailedException with correct stack depth and message when 'traversable should have length' failed` {
    val xs = IndexedSeq(IndexedSeq[String]("hi"), IndexedSeq[String]("boom!"), IndexedSeq[String]("hello"), IndexedSeq[String]("boom!", "hi"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should have length 1
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeEqualGenTraversable[String](xs, 1, 2) + " in " + xs)
  }
  def `IndexedSeq(IndexedSeq[String]("hi"), IndexedSeq[String]("boom!"), IndexedSeq[String]("hello"), IndexedSeq[String]("boom!", "hi")) should throw TestFailedException with correct stack depth and message when 'traversable should not have length' failed` {
    val xs = IndexedSeq(IndexedSeq[String]("hi"), IndexedSeq[String]("boom!"), IndexedSeq[String]("hello"), IndexedSeq[String]("boom!", "hi"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not have length (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeNotEqualGenTraversable[String](xs, 2, 2) + " in " + xs)
  }
  def `IndexedSeq(IndexedSeq[String]("hi"), IndexedSeq[String]("boom!"), IndexedSeq[String]("hello"), IndexedSeq[String]("boom!", "hi")) should throw TestFailedException with correct stack depth and message when 'traversable should contain' failed` {
    val xs = IndexedSeq(IndexedSeq[String]("hi"), IndexedSeq[String]("boom!"), IndexedSeq[String]("hello"), IndexedSeq[String]("boom!", "hi"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain ("hi")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainGenTraversable[String](xs, "hi", 2) + " in " + xs)
  }
  def `IndexedSeq(IndexedSeq[String]("hi"), IndexedSeq[String]("boom!"), IndexedSeq[String]("hello"), IndexedSeq[String]("boom!", "hi")) should throw TestFailedException with correct stack depth and message when 'traversable should not contain' failed` {
    val xs = IndexedSeq(IndexedSeq[String]("hi"), IndexedSeq[String]("boom!"), IndexedSeq[String]("hello"), IndexedSeq[String]("boom!", "hi"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain "hi"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainGenTraversable[String](xs, "hi", 2) + " in " + xs)
  }
  def `Vector(Vector[String]("hi"), Vector[String]("boom!"), Vector[String]("hello"), Vector[String]("boom!", "hi")) should throw TestFailedException with correct stack depth and message when 'traversable should have size' failed` {
    val xs = Vector(Vector[String]("hi"), Vector[String]("boom!"), Vector[String]("hello"), Vector[String]("boom!", "hi"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should have size 1
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeEqualGenTraversable[String](xs, 1, 2) + " in " + xs)
  }
  def `Vector(Vector[String]("hi"), Vector[String]("boom!"), Vector[String]("hello"), Vector[String]("boom!", "hi")) should throw TestFailedException with correct stack depth and message when 'traversable should not have size' failed` {
    val xs = Vector(Vector[String]("hi"), Vector[String]("boom!"), Vector[String]("hello"), Vector[String]("boom!", "hi"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not have size (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeNotEqualGenTraversable[String](xs, 2, 2) + " in " + xs)
  }
  def `Vector(Vector[String]("hi"), Vector[String]("boom!"), Vector[String]("hello"), Vector[String]("boom!", "hi")) should throw TestFailedException with correct stack depth and message when 'traversable should have length' failed` {
    val xs = Vector(Vector[String]("hi"), Vector[String]("boom!"), Vector[String]("hello"), Vector[String]("boom!", "hi"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should have length 1
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeEqualGenTraversable[String](xs, 1, 2) + " in " + xs)
  }
  def `Vector(Vector[String]("hi"), Vector[String]("boom!"), Vector[String]("hello"), Vector[String]("boom!", "hi")) should throw TestFailedException with correct stack depth and message when 'traversable should not have length' failed` {
    val xs = Vector(Vector[String]("hi"), Vector[String]("boom!"), Vector[String]("hello"), Vector[String]("boom!", "hi"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not have length (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeNotEqualGenTraversable[String](xs, 2, 2) + " in " + xs)
  }
  def `Vector(Vector[String]("hi"), Vector[String]("boom!"), Vector[String]("hello"), Vector[String]("boom!", "hi")) should throw TestFailedException with correct stack depth and message when 'traversable should contain' failed` {
    val xs = Vector(Vector[String]("hi"), Vector[String]("boom!"), Vector[String]("hello"), Vector[String]("boom!", "hi"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain ("hi")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainGenTraversable[String](xs, "hi", 2) + " in " + xs)
  }
  def `Vector(Vector[String]("hi"), Vector[String]("boom!"), Vector[String]("hello"), Vector[String]("boom!", "hi")) should throw TestFailedException with correct stack depth and message when 'traversable should not contain' failed` {
    val xs = Vector(Vector[String]("hi"), Vector[String]("boom!"), Vector[String]("hello"), Vector[String]("boom!", "hi"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain "hi"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainGenTraversable[String](xs, "hi", 2) + " in " + xs)
  }
  def `Set(Set[String]("hi").par, Set[String]("boom!").par, Set[String]("hello").par, Set[String]("boom!", "hi").par).par should throw TestFailedException with correct stack depth and message when 'traversable should have size' failed` {
    val xs = Set(Set[String]("hi").par, Set[String]("boom!").par, Set[String]("hello").par, Set[String]("boom!", "hi").par).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should have size 1
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeEqualGenTraversable[String](xs, 1, 2) + " in " + xs)
  }
  def `Set(Set[String]("hi").par, Set[String]("boom!").par, Set[String]("hello").par, Set[String]("boom!", "hi").par).par should throw TestFailedException with correct stack depth and message when 'traversable should not have size' failed` {
    val xs = Set(Set[String]("hi").par, Set[String]("boom!").par, Set[String]("hello").par, Set[String]("boom!", "hi").par).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not have size (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeNotEqualGenTraversable[String](xs, 2, 2) + " in " + xs)
  }
  def `Set(Set[String]("hi").par, Set[String]("boom!").par, Set[String]("hello").par, Set[String]("boom!", "hi").par).par should throw TestFailedException with correct stack depth and message when 'traversable should contain' failed` {
    val xs = Set(Set[String]("hi").par, Set[String]("boom!").par, Set[String]("hello").par, Set[String]("boom!", "hi").par).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain ("hi")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainGenTraversable[String](xs, "hi", 2) + " in " + xs)
  }
  def `Set(Set[String]("hi").par, Set[String]("boom!").par, Set[String]("hello").par, Set[String]("boom!", "hi").par).par should throw TestFailedException with correct stack depth and message when 'traversable should not contain' failed` {
    val xs = Set(Set[String]("hi").par, Set[String]("boom!").par, Set[String]("hello").par, Set[String]("boom!", "hi").par).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain "hi"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainGenTraversable[String](xs, "hi", 2) + " in " + xs)
  }
  def `List(List[String]("hi").par, List[String]("boom!").par, List[String]("hello").par, List[String]("boom!", "hi").par).par should throw TestFailedException with correct stack depth and message when 'traversable should have size' failed` {
    val xs = List(List[String]("hi").par, List[String]("boom!").par, List[String]("hello").par, List[String]("boom!", "hi").par).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should have size 1
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeEqualGenTraversable[String](xs, 1, 2) + " in " + xs)
  }
  def `List(List[String]("hi").par, List[String]("boom!").par, List[String]("hello").par, List[String]("boom!", "hi").par).par should throw TestFailedException with correct stack depth and message when 'traversable should not have size' failed` {
    val xs = List(List[String]("hi").par, List[String]("boom!").par, List[String]("hello").par, List[String]("boom!", "hi").par).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not have size (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeNotEqualGenTraversable[String](xs, 2, 2) + " in " + xs)
  }
  def `List(List[String]("hi").par, List[String]("boom!").par, List[String]("hello").par, List[String]("boom!", "hi").par).par should throw TestFailedException with correct stack depth and message when 'traversable should have length' failed` {
    val xs = List(List[String]("hi").par, List[String]("boom!").par, List[String]("hello").par, List[String]("boom!", "hi").par).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should have length 1
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeEqualGenTraversable[String](xs, 1, 2) + " in " + xs)
  }
  def `List(List[String]("hi").par, List[String]("boom!").par, List[String]("hello").par, List[String]("boom!", "hi").par).par should throw TestFailedException with correct stack depth and message when 'traversable should not have length' failed` {
    val xs = List(List[String]("hi").par, List[String]("boom!").par, List[String]("hello").par, List[String]("boom!", "hi").par).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not have length (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeNotEqualGenTraversable[String](xs, 2, 2) + " in " + xs)
  }
  def `List(List[String]("hi").par, List[String]("boom!").par, List[String]("hello").par, List[String]("boom!", "hi").par).par should throw TestFailedException with correct stack depth and message when 'traversable should contain' failed` {
    val xs = List(List[String]("hi").par, List[String]("boom!").par, List[String]("hello").par, List[String]("boom!", "hi").par).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain ("hi")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainGenTraversable[String](xs, "hi", 2) + " in " + xs)
  }
  def `List(List[String]("hi").par, List[String]("boom!").par, List[String]("hello").par, List[String]("boom!", "hi").par).par should throw TestFailedException with correct stack depth and message when 'traversable should not contain' failed` {
    val xs = List(List[String]("hi").par, List[String]("boom!").par, List[String]("hello").par, List[String]("boom!", "hi").par).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain "hi"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainGenTraversable[String](xs, "hi", 2) + " in " + xs)
  }
  def `Seq(Seq[String]("hi").par, Seq[String]("boom!").par, Seq[String]("hello").par, Seq[String]("boom!", "hi").par).par should throw TestFailedException with correct stack depth and message when 'traversable should have size' failed` {
    val xs = Seq(Seq[String]("hi").par, Seq[String]("boom!").par, Seq[String]("hello").par, Seq[String]("boom!", "hi").par).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should have size 1
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeEqualGenTraversable[String](xs, 1, 2) + " in " + xs)
  }
  def `Seq(Seq[String]("hi").par, Seq[String]("boom!").par, Seq[String]("hello").par, Seq[String]("boom!", "hi").par).par should throw TestFailedException with correct stack depth and message when 'traversable should not have size' failed` {
    val xs = Seq(Seq[String]("hi").par, Seq[String]("boom!").par, Seq[String]("hello").par, Seq[String]("boom!", "hi").par).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not have size (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeNotEqualGenTraversable[String](xs, 2, 2) + " in " + xs)
  }
  def `Seq(Seq[String]("hi").par, Seq[String]("boom!").par, Seq[String]("hello").par, Seq[String]("boom!", "hi").par).par should throw TestFailedException with correct stack depth and message when 'traversable should have length' failed` {
    val xs = Seq(Seq[String]("hi").par, Seq[String]("boom!").par, Seq[String]("hello").par, Seq[String]("boom!", "hi").par).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should have length 1
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeEqualGenTraversable[String](xs, 1, 2) + " in " + xs)
  }
  def `Seq(Seq[String]("hi").par, Seq[String]("boom!").par, Seq[String]("hello").par, Seq[String]("boom!", "hi").par).par should throw TestFailedException with correct stack depth and message when 'traversable should not have length' failed` {
    val xs = Seq(Seq[String]("hi").par, Seq[String]("boom!").par, Seq[String]("hello").par, Seq[String]("boom!", "hi").par).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not have length (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeNotEqualGenTraversable[String](xs, 2, 2) + " in " + xs)
  }
  def `Seq(Seq[String]("hi").par, Seq[String]("boom!").par, Seq[String]("hello").par, Seq[String]("boom!", "hi").par).par should throw TestFailedException with correct stack depth and message when 'traversable should contain' failed` {
    val xs = Seq(Seq[String]("hi").par, Seq[String]("boom!").par, Seq[String]("hello").par, Seq[String]("boom!", "hi").par).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain ("hi")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainGenTraversable[String](xs, "hi", 2) + " in " + xs)
  }
  def `Seq(Seq[String]("hi").par, Seq[String]("boom!").par, Seq[String]("hello").par, Seq[String]("boom!", "hi").par).par should throw TestFailedException with correct stack depth and message when 'traversable should not contain' failed` {
    val xs = Seq(Seq[String]("hi").par, Seq[String]("boom!").par, Seq[String]("hello").par, Seq[String]("boom!", "hi").par).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain "hi"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainGenTraversable[String](xs, "hi", 2) + " in " + xs)
  }
  def `IndexedSeq(IndexedSeq[String]("hi").par, IndexedSeq[String]("boom!").par, IndexedSeq[String]("hello").par, IndexedSeq[String]("boom!", "hi").par).par should throw TestFailedException with correct stack depth and message when 'traversable should have size' failed` {
    val xs = IndexedSeq(IndexedSeq[String]("hi").par, IndexedSeq[String]("boom!").par, IndexedSeq[String]("hello").par, IndexedSeq[String]("boom!", "hi").par).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should have size 1
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeEqualGenTraversable[String](xs, 1, 2) + " in " + xs)
  }
  def `IndexedSeq(IndexedSeq[String]("hi").par, IndexedSeq[String]("boom!").par, IndexedSeq[String]("hello").par, IndexedSeq[String]("boom!", "hi").par).par should throw TestFailedException with correct stack depth and message when 'traversable should not have size' failed` {
    val xs = IndexedSeq(IndexedSeq[String]("hi").par, IndexedSeq[String]("boom!").par, IndexedSeq[String]("hello").par, IndexedSeq[String]("boom!", "hi").par).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not have size (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeNotEqualGenTraversable[String](xs, 2, 2) + " in " + xs)
  }
  def `IndexedSeq(IndexedSeq[String]("hi").par, IndexedSeq[String]("boom!").par, IndexedSeq[String]("hello").par, IndexedSeq[String]("boom!", "hi").par).par should throw TestFailedException with correct stack depth and message when 'traversable should have length' failed` {
    val xs = IndexedSeq(IndexedSeq[String]("hi").par, IndexedSeq[String]("boom!").par, IndexedSeq[String]("hello").par, IndexedSeq[String]("boom!", "hi").par).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should have length 1
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeEqualGenTraversable[String](xs, 1, 2) + " in " + xs)
  }
  def `IndexedSeq(IndexedSeq[String]("hi").par, IndexedSeq[String]("boom!").par, IndexedSeq[String]("hello").par, IndexedSeq[String]("boom!", "hi").par).par should throw TestFailedException with correct stack depth and message when 'traversable should not have length' failed` {
    val xs = IndexedSeq(IndexedSeq[String]("hi").par, IndexedSeq[String]("boom!").par, IndexedSeq[String]("hello").par, IndexedSeq[String]("boom!", "hi").par).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not have length (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeNotEqualGenTraversable[String](xs, 2, 2) + " in " + xs)
  }
  def `IndexedSeq(IndexedSeq[String]("hi").par, IndexedSeq[String]("boom!").par, IndexedSeq[String]("hello").par, IndexedSeq[String]("boom!", "hi").par).par should throw TestFailedException with correct stack depth and message when 'traversable should contain' failed` {
    val xs = IndexedSeq(IndexedSeq[String]("hi").par, IndexedSeq[String]("boom!").par, IndexedSeq[String]("hello").par, IndexedSeq[String]("boom!", "hi").par).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain ("hi")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainGenTraversable[String](xs, "hi", 2) + " in " + xs)
  }
  def `IndexedSeq(IndexedSeq[String]("hi").par, IndexedSeq[String]("boom!").par, IndexedSeq[String]("hello").par, IndexedSeq[String]("boom!", "hi").par).par should throw TestFailedException with correct stack depth and message when 'traversable should not contain' failed` {
    val xs = IndexedSeq(IndexedSeq[String]("hi").par, IndexedSeq[String]("boom!").par, IndexedSeq[String]("hello").par, IndexedSeq[String]("boom!", "hi").par).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain "hi"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainGenTraversable[String](xs, "hi", 2) + " in " + xs)
  }
  def `collection.mutable.Set(collection.mutable.Set[String]("hi"), collection.mutable.Set[String]("boom!"), collection.mutable.Set[String]("hello"), collection.mutable.Set[String]("boom!", "hi")) should throw TestFailedException with correct stack depth and message when 'traversable should have size' failed` {
    val xs = collection.mutable.Set(collection.mutable.Set[String]("hi"), collection.mutable.Set[String]("boom!"), collection.mutable.Set[String]("hello"), collection.mutable.Set[String]("boom!", "hi"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should have size 1
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeEqualGenTraversable[String](xs, 1, 2) + " in " + xs)
  }
  def `collection.mutable.Set(collection.mutable.Set[String]("hi"), collection.mutable.Set[String]("boom!"), collection.mutable.Set[String]("hello"), collection.mutable.Set[String]("boom!", "hi")) should throw TestFailedException with correct stack depth and message when 'traversable should not have size' failed` {
    val xs = collection.mutable.Set(collection.mutable.Set[String]("hi"), collection.mutable.Set[String]("boom!"), collection.mutable.Set[String]("hello"), collection.mutable.Set[String]("boom!", "hi"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not have size (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeNotEqualGenTraversable[String](xs, 2, 2) + " in " + xs)
  }
  def `collection.mutable.Set(collection.mutable.Set[String]("hi"), collection.mutable.Set[String]("boom!"), collection.mutable.Set[String]("hello"), collection.mutable.Set[String]("boom!", "hi")) should throw TestFailedException with correct stack depth and message when 'traversable should contain' failed` {
    val xs = collection.mutable.Set(collection.mutable.Set[String]("hi"), collection.mutable.Set[String]("boom!"), collection.mutable.Set[String]("hello"), collection.mutable.Set[String]("boom!", "hi"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain ("hi")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainGenTraversable[String](xs, "hi", 2) + " in " + xs)
  }
  def `collection.mutable.Set(collection.mutable.Set[String]("hi"), collection.mutable.Set[String]("boom!"), collection.mutable.Set[String]("hello"), collection.mutable.Set[String]("boom!", "hi")) should throw TestFailedException with correct stack depth and message when 'traversable should not contain' failed` {
    val xs = collection.mutable.Set(collection.mutable.Set[String]("hi"), collection.mutable.Set[String]("boom!"), collection.mutable.Set[String]("hello"), collection.mutable.Set[String]("boom!", "hi"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain "hi"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainGenTraversable[String](xs, "hi", 2) + " in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List(new collection.mutable.ListBuffer[String]() ++ List[String]("hi"), new collection.mutable.ListBuffer[String]() ++ List[String]("boom!"), new collection.mutable.ListBuffer[String]() ++ List[String]("hello"), new collection.mutable.ListBuffer[String]() ++ List[String]("boom!", "hi")) should throw TestFailedException with correct stack depth and message when 'traversable should have size' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List(new collection.mutable.ListBuffer[String]() ++ List[String]("hi"), new collection.mutable.ListBuffer[String]() ++ List[String]("boom!"), new collection.mutable.ListBuffer[String]() ++ List[String]("hello"), new collection.mutable.ListBuffer[String]() ++ List[String]("boom!", "hi"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should have size 1
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeEqualGenTraversable[String](xs, 1, 2) + " in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List(new collection.mutable.ListBuffer[String]() ++ List[String]("hi"), new collection.mutable.ListBuffer[String]() ++ List[String]("boom!"), new collection.mutable.ListBuffer[String]() ++ List[String]("hello"), new collection.mutable.ListBuffer[String]() ++ List[String]("boom!", "hi")) should throw TestFailedException with correct stack depth and message when 'traversable should not have size' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List(new collection.mutable.ListBuffer[String]() ++ List[String]("hi"), new collection.mutable.ListBuffer[String]() ++ List[String]("boom!"), new collection.mutable.ListBuffer[String]() ++ List[String]("hello"), new collection.mutable.ListBuffer[String]() ++ List[String]("boom!", "hi"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not have size (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeNotEqualGenTraversable[String](xs, 2, 2) + " in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List(new collection.mutable.ListBuffer[String]() ++ List[String]("hi"), new collection.mutable.ListBuffer[String]() ++ List[String]("boom!"), new collection.mutable.ListBuffer[String]() ++ List[String]("hello"), new collection.mutable.ListBuffer[String]() ++ List[String]("boom!", "hi")) should throw TestFailedException with correct stack depth and message when 'traversable should have length' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List(new collection.mutable.ListBuffer[String]() ++ List[String]("hi"), new collection.mutable.ListBuffer[String]() ++ List[String]("boom!"), new collection.mutable.ListBuffer[String]() ++ List[String]("hello"), new collection.mutable.ListBuffer[String]() ++ List[String]("boom!", "hi"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should have length 1
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeEqualGenTraversable[String](xs, 1, 2) + " in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List(new collection.mutable.ListBuffer[String]() ++ List[String]("hi"), new collection.mutable.ListBuffer[String]() ++ List[String]("boom!"), new collection.mutable.ListBuffer[String]() ++ List[String]("hello"), new collection.mutable.ListBuffer[String]() ++ List[String]("boom!", "hi")) should throw TestFailedException with correct stack depth and message when 'traversable should not have length' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List(new collection.mutable.ListBuffer[String]() ++ List[String]("hi"), new collection.mutable.ListBuffer[String]() ++ List[String]("boom!"), new collection.mutable.ListBuffer[String]() ++ List[String]("hello"), new collection.mutable.ListBuffer[String]() ++ List[String]("boom!", "hi"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not have length (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeNotEqualGenTraversable[String](xs, 2, 2) + " in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List(new collection.mutable.ListBuffer[String]() ++ List[String]("hi"), new collection.mutable.ListBuffer[String]() ++ List[String]("boom!"), new collection.mutable.ListBuffer[String]() ++ List[String]("hello"), new collection.mutable.ListBuffer[String]() ++ List[String]("boom!", "hi")) should throw TestFailedException with correct stack depth and message when 'traversable should contain' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List(new collection.mutable.ListBuffer[String]() ++ List[String]("hi"), new collection.mutable.ListBuffer[String]() ++ List[String]("boom!"), new collection.mutable.ListBuffer[String]() ++ List[String]("hello"), new collection.mutable.ListBuffer[String]() ++ List[String]("boom!", "hi"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain ("hi")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainGenTraversable[String](xs, "hi", 2) + " in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List(new collection.mutable.ListBuffer[String]() ++ List[String]("hi"), new collection.mutable.ListBuffer[String]() ++ List[String]("boom!"), new collection.mutable.ListBuffer[String]() ++ List[String]("hello"), new collection.mutable.ListBuffer[String]() ++ List[String]("boom!", "hi")) should throw TestFailedException with correct stack depth and message when 'traversable should not contain' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List(new collection.mutable.ListBuffer[String]() ++ List[String]("hi"), new collection.mutable.ListBuffer[String]() ++ List[String]("boom!"), new collection.mutable.ListBuffer[String]() ++ List[String]("hello"), new collection.mutable.ListBuffer[String]() ++ List[String]("boom!", "hi"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain "hi"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainGenTraversable[String](xs, "hi", 2) + " in " + xs)
  }
  def `collection.mutable.Seq(collection.mutable.Seq[String]("hi"), collection.mutable.Seq[String]("boom!"), collection.mutable.Seq[String]("hello"), collection.mutable.Seq[String]("boom!", "hi")) should throw TestFailedException with correct stack depth and message when 'traversable should have size' failed` {
    val xs = collection.mutable.Seq(collection.mutable.Seq[String]("hi"), collection.mutable.Seq[String]("boom!"), collection.mutable.Seq[String]("hello"), collection.mutable.Seq[String]("boom!", "hi"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should have size 1
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeEqualGenTraversable[String](xs, 1, 2) + " in " + xs)
  }
  def `collection.mutable.Seq(collection.mutable.Seq[String]("hi"), collection.mutable.Seq[String]("boom!"), collection.mutable.Seq[String]("hello"), collection.mutable.Seq[String]("boom!", "hi")) should throw TestFailedException with correct stack depth and message when 'traversable should not have size' failed` {
    val xs = collection.mutable.Seq(collection.mutable.Seq[String]("hi"), collection.mutable.Seq[String]("boom!"), collection.mutable.Seq[String]("hello"), collection.mutable.Seq[String]("boom!", "hi"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not have size (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeNotEqualGenTraversable[String](xs, 2, 2) + " in " + xs)
  }
  def `collection.mutable.Seq(collection.mutable.Seq[String]("hi"), collection.mutable.Seq[String]("boom!"), collection.mutable.Seq[String]("hello"), collection.mutable.Seq[String]("boom!", "hi")) should throw TestFailedException with correct stack depth and message when 'traversable should have length' failed` {
    val xs = collection.mutable.Seq(collection.mutable.Seq[String]("hi"), collection.mutable.Seq[String]("boom!"), collection.mutable.Seq[String]("hello"), collection.mutable.Seq[String]("boom!", "hi"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should have length 1
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeEqualGenTraversable[String](xs, 1, 2) + " in " + xs)
  }
  def `collection.mutable.Seq(collection.mutable.Seq[String]("hi"), collection.mutable.Seq[String]("boom!"), collection.mutable.Seq[String]("hello"), collection.mutable.Seq[String]("boom!", "hi")) should throw TestFailedException with correct stack depth and message when 'traversable should not have length' failed` {
    val xs = collection.mutable.Seq(collection.mutable.Seq[String]("hi"), collection.mutable.Seq[String]("boom!"), collection.mutable.Seq[String]("hello"), collection.mutable.Seq[String]("boom!", "hi"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not have length (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeNotEqualGenTraversable[String](xs, 2, 2) + " in " + xs)
  }
  def `collection.mutable.Seq(collection.mutable.Seq[String]("hi"), collection.mutable.Seq[String]("boom!"), collection.mutable.Seq[String]("hello"), collection.mutable.Seq[String]("boom!", "hi")) should throw TestFailedException with correct stack depth and message when 'traversable should contain' failed` {
    val xs = collection.mutable.Seq(collection.mutable.Seq[String]("hi"), collection.mutable.Seq[String]("boom!"), collection.mutable.Seq[String]("hello"), collection.mutable.Seq[String]("boom!", "hi"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain ("hi")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainGenTraversable[String](xs, "hi", 2) + " in " + xs)
  }
  def `collection.mutable.Seq(collection.mutable.Seq[String]("hi"), collection.mutable.Seq[String]("boom!"), collection.mutable.Seq[String]("hello"), collection.mutable.Seq[String]("boom!", "hi")) should throw TestFailedException with correct stack depth and message when 'traversable should not contain' failed` {
    val xs = collection.mutable.Seq(collection.mutable.Seq[String]("hi"), collection.mutable.Seq[String]("boom!"), collection.mutable.Seq[String]("hello"), collection.mutable.Seq[String]("boom!", "hi"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain "hi"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainGenTraversable[String](xs, "hi", 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq(collection.mutable.IndexedSeq[String]("hi"), collection.mutable.IndexedSeq[String]("boom!"), collection.mutable.IndexedSeq[String]("hello"), collection.mutable.IndexedSeq[String]("boom!", "hi")) should throw TestFailedException with correct stack depth and message when 'traversable should have size' failed` {
    val xs = collection.mutable.IndexedSeq(collection.mutable.IndexedSeq[String]("hi"), collection.mutable.IndexedSeq[String]("boom!"), collection.mutable.IndexedSeq[String]("hello"), collection.mutable.IndexedSeq[String]("boom!", "hi"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should have size 1
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeEqualGenTraversable[String](xs, 1, 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq(collection.mutable.IndexedSeq[String]("hi"), collection.mutable.IndexedSeq[String]("boom!"), collection.mutable.IndexedSeq[String]("hello"), collection.mutable.IndexedSeq[String]("boom!", "hi")) should throw TestFailedException with correct stack depth and message when 'traversable should not have size' failed` {
    val xs = collection.mutable.IndexedSeq(collection.mutable.IndexedSeq[String]("hi"), collection.mutable.IndexedSeq[String]("boom!"), collection.mutable.IndexedSeq[String]("hello"), collection.mutable.IndexedSeq[String]("boom!", "hi"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not have size (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeNotEqualGenTraversable[String](xs, 2, 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq(collection.mutable.IndexedSeq[String]("hi"), collection.mutable.IndexedSeq[String]("boom!"), collection.mutable.IndexedSeq[String]("hello"), collection.mutable.IndexedSeq[String]("boom!", "hi")) should throw TestFailedException with correct stack depth and message when 'traversable should have length' failed` {
    val xs = collection.mutable.IndexedSeq(collection.mutable.IndexedSeq[String]("hi"), collection.mutable.IndexedSeq[String]("boom!"), collection.mutable.IndexedSeq[String]("hello"), collection.mutable.IndexedSeq[String]("boom!", "hi"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should have length 1
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeEqualGenTraversable[String](xs, 1, 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq(collection.mutable.IndexedSeq[String]("hi"), collection.mutable.IndexedSeq[String]("boom!"), collection.mutable.IndexedSeq[String]("hello"), collection.mutable.IndexedSeq[String]("boom!", "hi")) should throw TestFailedException with correct stack depth and message when 'traversable should not have length' failed` {
    val xs = collection.mutable.IndexedSeq(collection.mutable.IndexedSeq[String]("hi"), collection.mutable.IndexedSeq[String]("boom!"), collection.mutable.IndexedSeq[String]("hello"), collection.mutable.IndexedSeq[String]("boom!", "hi"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not have length (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeNotEqualGenTraversable[String](xs, 2, 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq(collection.mutable.IndexedSeq[String]("hi"), collection.mutable.IndexedSeq[String]("boom!"), collection.mutable.IndexedSeq[String]("hello"), collection.mutable.IndexedSeq[String]("boom!", "hi")) should throw TestFailedException with correct stack depth and message when 'traversable should contain' failed` {
    val xs = collection.mutable.IndexedSeq(collection.mutable.IndexedSeq[String]("hi"), collection.mutable.IndexedSeq[String]("boom!"), collection.mutable.IndexedSeq[String]("hello"), collection.mutable.IndexedSeq[String]("boom!", "hi"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain ("hi")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainGenTraversable[String](xs, "hi", 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq(collection.mutable.IndexedSeq[String]("hi"), collection.mutable.IndexedSeq[String]("boom!"), collection.mutable.IndexedSeq[String]("hello"), collection.mutable.IndexedSeq[String]("boom!", "hi")) should throw TestFailedException with correct stack depth and message when 'traversable should not contain' failed` {
    val xs = collection.mutable.IndexedSeq(collection.mutable.IndexedSeq[String]("hi"), collection.mutable.IndexedSeq[String]("boom!"), collection.mutable.IndexedSeq[String]("hello"), collection.mutable.IndexedSeq[String]("boom!", "hi"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain "hi"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainGenTraversable[String](xs, "hi", 2) + " in " + xs)
  }
  def `collection.mutable.Set(collection.mutable.Set[String]("hi").par, collection.mutable.Set[String]("boom!").par, collection.mutable.Set[String]("hello").par, collection.mutable.Set[String]("boom!", "hi").par).par should throw TestFailedException with correct stack depth and message when 'traversable should have size' failed` {
    val xs = collection.mutable.Set(collection.mutable.Set[String]("hi").par, collection.mutable.Set[String]("boom!").par, collection.mutable.Set[String]("hello").par, collection.mutable.Set[String]("boom!", "hi").par).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should have size 1
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeEqualGenTraversable[String](xs, 1, 2) + " in " + xs)
  }
  def `collection.mutable.Set(collection.mutable.Set[String]("hi").par, collection.mutable.Set[String]("boom!").par, collection.mutable.Set[String]("hello").par, collection.mutable.Set[String]("boom!", "hi").par).par should throw TestFailedException with correct stack depth and message when 'traversable should not have size' failed` {
    val xs = collection.mutable.Set(collection.mutable.Set[String]("hi").par, collection.mutable.Set[String]("boom!").par, collection.mutable.Set[String]("hello").par, collection.mutable.Set[String]("boom!", "hi").par).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not have size (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeNotEqualGenTraversable[String](xs, 2, 2) + " in " + xs)
  }
  def `collection.mutable.Set(collection.mutable.Set[String]("hi").par, collection.mutable.Set[String]("boom!").par, collection.mutable.Set[String]("hello").par, collection.mutable.Set[String]("boom!", "hi").par).par should throw TestFailedException with correct stack depth and message when 'traversable should contain' failed` {
    val xs = collection.mutable.Set(collection.mutable.Set[String]("hi").par, collection.mutable.Set[String]("boom!").par, collection.mutable.Set[String]("hello").par, collection.mutable.Set[String]("boom!", "hi").par).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain ("hi")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainGenTraversable[String](xs, "hi", 2) + " in " + xs)
  }
  def `collection.mutable.Set(collection.mutable.Set[String]("hi").par, collection.mutable.Set[String]("boom!").par, collection.mutable.Set[String]("hello").par, collection.mutable.Set[String]("boom!", "hi").par).par should throw TestFailedException with correct stack depth and message when 'traversable should not contain' failed` {
    val xs = collection.mutable.Set(collection.mutable.Set[String]("hi").par, collection.mutable.Set[String]("boom!").par, collection.mutable.Set[String]("hello").par, collection.mutable.Set[String]("boom!", "hi").par).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain "hi"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainGenTraversable[String](xs, "hi", 2) + " in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List((new collection.mutable.ListBuffer[String]() ++ List[String]("hi")).par, (new collection.mutable.ListBuffer[String]() ++ List[String]("boom!")).par, (new collection.mutable.ListBuffer[String]() ++ List[String]("hello")).par, (new collection.mutable.ListBuffer[String]() ++ List[String]("boom!", "hi")).par)).par should throw TestFailedException with correct stack depth and message when 'traversable should have size' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List((new collection.mutable.ListBuffer[String]() ++ List[String]("hi")).par, (new collection.mutable.ListBuffer[String]() ++ List[String]("boom!")).par, (new collection.mutable.ListBuffer[String]() ++ List[String]("hello")).par, (new collection.mutable.ListBuffer[String]() ++ List[String]("boom!", "hi")).par)).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should have size 1
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeEqualGenTraversable[String](xs, 1, 2) + " in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List((new collection.mutable.ListBuffer[String]() ++ List[String]("hi")).par, (new collection.mutable.ListBuffer[String]() ++ List[String]("boom!")).par, (new collection.mutable.ListBuffer[String]() ++ List[String]("hello")).par, (new collection.mutable.ListBuffer[String]() ++ List[String]("boom!", "hi")).par)).par should throw TestFailedException with correct stack depth and message when 'traversable should not have size' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List((new collection.mutable.ListBuffer[String]() ++ List[String]("hi")).par, (new collection.mutable.ListBuffer[String]() ++ List[String]("boom!")).par, (new collection.mutable.ListBuffer[String]() ++ List[String]("hello")).par, (new collection.mutable.ListBuffer[String]() ++ List[String]("boom!", "hi")).par)).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not have size (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeNotEqualGenTraversable[String](xs, 2, 2) + " in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List((new collection.mutable.ListBuffer[String]() ++ List[String]("hi")).par, (new collection.mutable.ListBuffer[String]() ++ List[String]("boom!")).par, (new collection.mutable.ListBuffer[String]() ++ List[String]("hello")).par, (new collection.mutable.ListBuffer[String]() ++ List[String]("boom!", "hi")).par)).par should throw TestFailedException with correct stack depth and message when 'traversable should have length' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List((new collection.mutable.ListBuffer[String]() ++ List[String]("hi")).par, (new collection.mutable.ListBuffer[String]() ++ List[String]("boom!")).par, (new collection.mutable.ListBuffer[String]() ++ List[String]("hello")).par, (new collection.mutable.ListBuffer[String]() ++ List[String]("boom!", "hi")).par)).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should have length 1
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeEqualGenTraversable[String](xs, 1, 2) + " in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List((new collection.mutable.ListBuffer[String]() ++ List[String]("hi")).par, (new collection.mutable.ListBuffer[String]() ++ List[String]("boom!")).par, (new collection.mutable.ListBuffer[String]() ++ List[String]("hello")).par, (new collection.mutable.ListBuffer[String]() ++ List[String]("boom!", "hi")).par)).par should throw TestFailedException with correct stack depth and message when 'traversable should not have length' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List((new collection.mutable.ListBuffer[String]() ++ List[String]("hi")).par, (new collection.mutable.ListBuffer[String]() ++ List[String]("boom!")).par, (new collection.mutable.ListBuffer[String]() ++ List[String]("hello")).par, (new collection.mutable.ListBuffer[String]() ++ List[String]("boom!", "hi")).par)).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not have length (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeNotEqualGenTraversable[String](xs, 2, 2) + " in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List((new collection.mutable.ListBuffer[String]() ++ List[String]("hi")).par, (new collection.mutable.ListBuffer[String]() ++ List[String]("boom!")).par, (new collection.mutable.ListBuffer[String]() ++ List[String]("hello")).par, (new collection.mutable.ListBuffer[String]() ++ List[String]("boom!", "hi")).par)).par should throw TestFailedException with correct stack depth and message when 'traversable should contain' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List((new collection.mutable.ListBuffer[String]() ++ List[String]("hi")).par, (new collection.mutable.ListBuffer[String]() ++ List[String]("boom!")).par, (new collection.mutable.ListBuffer[String]() ++ List[String]("hello")).par, (new collection.mutable.ListBuffer[String]() ++ List[String]("boom!", "hi")).par)).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain ("hi")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainGenTraversable[String](xs, "hi", 2) + " in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List((new collection.mutable.ListBuffer[String]() ++ List[String]("hi")).par, (new collection.mutable.ListBuffer[String]() ++ List[String]("boom!")).par, (new collection.mutable.ListBuffer[String]() ++ List[String]("hello")).par, (new collection.mutable.ListBuffer[String]() ++ List[String]("boom!", "hi")).par)).par should throw TestFailedException with correct stack depth and message when 'traversable should not contain' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List((new collection.mutable.ListBuffer[String]() ++ List[String]("hi")).par, (new collection.mutable.ListBuffer[String]() ++ List[String]("boom!")).par, (new collection.mutable.ListBuffer[String]() ++ List[String]("hello")).par, (new collection.mutable.ListBuffer[String]() ++ List[String]("boom!", "hi")).par)).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain "hi"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainGenTraversable[String](xs, "hi", 2) + " in " + xs)
  }
  def `collection.mutable.Seq(collection.mutable.Seq[String]("hi").par, collection.mutable.Seq[String]("boom!").par, collection.mutable.Seq[String]("hello").par, collection.mutable.Seq[String]("boom!", "hi").par).par should throw TestFailedException with correct stack depth and message when 'traversable should have size' failed` {
    val xs = collection.mutable.Seq(collection.mutable.Seq[String]("hi").par, collection.mutable.Seq[String]("boom!").par, collection.mutable.Seq[String]("hello").par, collection.mutable.Seq[String]("boom!", "hi").par).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should have size 1
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeEqualGenTraversable[String](xs, 1, 2) + " in " + xs)
  }
  def `collection.mutable.Seq(collection.mutable.Seq[String]("hi").par, collection.mutable.Seq[String]("boom!").par, collection.mutable.Seq[String]("hello").par, collection.mutable.Seq[String]("boom!", "hi").par).par should throw TestFailedException with correct stack depth and message when 'traversable should not have size' failed` {
    val xs = collection.mutable.Seq(collection.mutable.Seq[String]("hi").par, collection.mutable.Seq[String]("boom!").par, collection.mutable.Seq[String]("hello").par, collection.mutable.Seq[String]("boom!", "hi").par).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not have size (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeNotEqualGenTraversable[String](xs, 2, 2) + " in " + xs)
  }
  def `collection.mutable.Seq(collection.mutable.Seq[String]("hi").par, collection.mutable.Seq[String]("boom!").par, collection.mutable.Seq[String]("hello").par, collection.mutable.Seq[String]("boom!", "hi").par).par should throw TestFailedException with correct stack depth and message when 'traversable should have length' failed` {
    val xs = collection.mutable.Seq(collection.mutable.Seq[String]("hi").par, collection.mutable.Seq[String]("boom!").par, collection.mutable.Seq[String]("hello").par, collection.mutable.Seq[String]("boom!", "hi").par).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should have length 1
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeEqualGenTraversable[String](xs, 1, 2) + " in " + xs)
  }
  def `collection.mutable.Seq(collection.mutable.Seq[String]("hi").par, collection.mutable.Seq[String]("boom!").par, collection.mutable.Seq[String]("hello").par, collection.mutable.Seq[String]("boom!", "hi").par).par should throw TestFailedException with correct stack depth and message when 'traversable should not have length' failed` {
    val xs = collection.mutable.Seq(collection.mutable.Seq[String]("hi").par, collection.mutable.Seq[String]("boom!").par, collection.mutable.Seq[String]("hello").par, collection.mutable.Seq[String]("boom!", "hi").par).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not have length (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeNotEqualGenTraversable[String](xs, 2, 2) + " in " + xs)
  }
  def `collection.mutable.Seq(collection.mutable.Seq[String]("hi").par, collection.mutable.Seq[String]("boom!").par, collection.mutable.Seq[String]("hello").par, collection.mutable.Seq[String]("boom!", "hi").par).par should throw TestFailedException with correct stack depth and message when 'traversable should contain' failed` {
    val xs = collection.mutable.Seq(collection.mutable.Seq[String]("hi").par, collection.mutable.Seq[String]("boom!").par, collection.mutable.Seq[String]("hello").par, collection.mutable.Seq[String]("boom!", "hi").par).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain ("hi")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainGenTraversable[String](xs, "hi", 2) + " in " + xs)
  }
  def `collection.mutable.Seq(collection.mutable.Seq[String]("hi").par, collection.mutable.Seq[String]("boom!").par, collection.mutable.Seq[String]("hello").par, collection.mutable.Seq[String]("boom!", "hi").par).par should throw TestFailedException with correct stack depth and message when 'traversable should not contain' failed` {
    val xs = collection.mutable.Seq(collection.mutable.Seq[String]("hi").par, collection.mutable.Seq[String]("boom!").par, collection.mutable.Seq[String]("hello").par, collection.mutable.Seq[String]("boom!", "hi").par).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain "hi"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainGenTraversable[String](xs, "hi", 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq(collection.mutable.IndexedSeq[String]("hi").par, collection.mutable.IndexedSeq[String]("boom!").par, collection.mutable.IndexedSeq[String]("hello").par, collection.mutable.IndexedSeq[String]("boom!", "hi").par).par should throw TestFailedException with correct stack depth and message when 'traversable should have size' failed` {
    val xs = collection.mutable.IndexedSeq(collection.mutable.IndexedSeq[String]("hi").par, collection.mutable.IndexedSeq[String]("boom!").par, collection.mutable.IndexedSeq[String]("hello").par, collection.mutable.IndexedSeq[String]("boom!", "hi").par).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should have size 1
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeEqualGenTraversable[String](xs, 1, 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq(collection.mutable.IndexedSeq[String]("hi").par, collection.mutable.IndexedSeq[String]("boom!").par, collection.mutable.IndexedSeq[String]("hello").par, collection.mutable.IndexedSeq[String]("boom!", "hi").par).par should throw TestFailedException with correct stack depth and message when 'traversable should not have size' failed` {
    val xs = collection.mutable.IndexedSeq(collection.mutable.IndexedSeq[String]("hi").par, collection.mutable.IndexedSeq[String]("boom!").par, collection.mutable.IndexedSeq[String]("hello").par, collection.mutable.IndexedSeq[String]("boom!", "hi").par).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not have size (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeNotEqualGenTraversable[String](xs, 2, 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq(collection.mutable.IndexedSeq[String]("hi").par, collection.mutable.IndexedSeq[String]("boom!").par, collection.mutable.IndexedSeq[String]("hello").par, collection.mutable.IndexedSeq[String]("boom!", "hi").par).par should throw TestFailedException with correct stack depth and message when 'traversable should have length' failed` {
    val xs = collection.mutable.IndexedSeq(collection.mutable.IndexedSeq[String]("hi").par, collection.mutable.IndexedSeq[String]("boom!").par, collection.mutable.IndexedSeq[String]("hello").par, collection.mutable.IndexedSeq[String]("boom!", "hi").par).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should have length 1
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeEqualGenTraversable[String](xs, 1, 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq(collection.mutable.IndexedSeq[String]("hi").par, collection.mutable.IndexedSeq[String]("boom!").par, collection.mutable.IndexedSeq[String]("hello").par, collection.mutable.IndexedSeq[String]("boom!", "hi").par).par should throw TestFailedException with correct stack depth and message when 'traversable should not have length' failed` {
    val xs = collection.mutable.IndexedSeq(collection.mutable.IndexedSeq[String]("hi").par, collection.mutable.IndexedSeq[String]("boom!").par, collection.mutable.IndexedSeq[String]("hello").par, collection.mutable.IndexedSeq[String]("boom!", "hi").par).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not have length (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesSizeNotEqualGenTraversable[String](xs, 2, 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq(collection.mutable.IndexedSeq[String]("hi").par, collection.mutable.IndexedSeq[String]("boom!").par, collection.mutable.IndexedSeq[String]("hello").par, collection.mutable.IndexedSeq[String]("boom!", "hi").par).par should throw TestFailedException with correct stack depth and message when 'traversable should contain' failed` {
    val xs = collection.mutable.IndexedSeq(collection.mutable.IndexedSeq[String]("hi").par, collection.mutable.IndexedSeq[String]("boom!").par, collection.mutable.IndexedSeq[String]("hello").par, collection.mutable.IndexedSeq[String]("boom!", "hi").par).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain ("hi")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainGenTraversable[String](xs, "hi", 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq(collection.mutable.IndexedSeq[String]("hi").par, collection.mutable.IndexedSeq[String]("boom!").par, collection.mutable.IndexedSeq[String]("hello").par, collection.mutable.IndexedSeq[String]("boom!", "hi").par).par should throw TestFailedException with correct stack depth and message when 'traversable should not contain' failed` {
    val xs = collection.mutable.IndexedSeq(collection.mutable.IndexedSeq[String]("hi").par, collection.mutable.IndexedSeq[String]("boom!").par, collection.mutable.IndexedSeq[String]("hello").par, collection.mutable.IndexedSeq[String]("boom!", "hi").par).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain "hi"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainGenTraversable[String](xs, "hi", 2) + " in " + xs)
  }
  def `Set(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = Set(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainKey[String, String](xs, "2", 2) + " in " + xs)
  }
  def `Set(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = Set(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainKey[String, String](xs, "2", 2) + " in " + xs)
  }
  def `Set(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = Set(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainValue[String, String](xs, "two", 2) + " in " + xs)
  }
  def `Set(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = Set(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainValue[String, String](xs, "two", 2) + " in " + xs)
  }
  def `List(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = List(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainKey[String, String](xs, "2", 2) + " in " + xs)
  }
  def `List(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = List(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainKey[String, String](xs, "2", 2) + " in " + xs)
  }
  def `List(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = List(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainValue[String, String](xs, "two", 2) + " in " + xs)
  }
  def `List(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = List(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainValue[String, String](xs, "two", 2) + " in " + xs)
  }
  def `Seq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = Seq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainKey[String, String](xs, "2", 2) + " in " + xs)
  }
  def `Seq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = Seq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainKey[String, String](xs, "2", 2) + " in " + xs)
  }
  def `Seq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = Seq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainValue[String, String](xs, "two", 2) + " in " + xs)
  }
  def `Seq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = Seq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainValue[String, String](xs, "two", 2) + " in " + xs)
  }
  def `Array(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = Array(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainKey[String, String](xs, "2", 2) + " in " + arrayToString(xs))
  }
  def `Array(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = Array(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainKey[String, String](xs, "2", 2) + " in " + arrayToString(xs))
  }
  def `Array(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = Array(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainValue[String, String](xs, "two", 2) + " in " + arrayToString(xs))
  }
  def `Array(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = Array(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainValue[String, String](xs, "two", 2) + " in " + arrayToString(xs))
  }
  def `IndexedSeq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = IndexedSeq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainKey[String, String](xs, "2", 2) + " in " + xs)
  }
  def `IndexedSeq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = IndexedSeq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainKey[String, String](xs, "2", 2) + " in " + xs)
  }
  def `IndexedSeq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = IndexedSeq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainValue[String, String](xs, "two", 2) + " in " + xs)
  }
  def `IndexedSeq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = IndexedSeq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainValue[String, String](xs, "two", 2) + " in " + xs)
  }
  def `Vector(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = Vector(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainKey[String, String](xs, "2", 2) + " in " + xs)
  }
  def `Vector(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = Vector(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainKey[String, String](xs, "2", 2) + " in " + xs)
  }
  def `Vector(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = Vector(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainValue[String, String](xs, "two", 2) + " in " + xs)
  }
  def `Vector(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = Vector(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainValue[String, String](xs, "two", 2) + " in " + xs)
  }
  def `Set(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine")).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = Set(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainKey[String, String](xs, "2", 2) + " in " + xs)
  }
  def `Set(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine")).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = Set(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainKey[String, String](xs, "2", 2) + " in " + xs)
  }
  def `Set(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine")).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = Set(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainValue[String, String](xs, "two", 2) + " in " + xs)
  }
  def `Set(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine")).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = Set(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainValue[String, String](xs, "two", 2) + " in " + xs)
  }
  def `List(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine")).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = List(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainKey[String, String](xs, "2", 2) + " in " + xs)
  }
  def `List(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine")).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = List(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainKey[String, String](xs, "2", 2) + " in " + xs)
  }
  def `List(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine")).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = List(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainValue[String, String](xs, "two", 2) + " in " + xs)
  }
  def `List(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine")).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = List(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainValue[String, String](xs, "two", 2) + " in " + xs)
  }
  def `Seq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine")).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = Seq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainKey[String, String](xs, "2", 2) + " in " + xs)
  }
  def `Seq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine")).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = Seq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainKey[String, String](xs, "2", 2) + " in " + xs)
  }
  def `Seq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine")).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = Seq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainValue[String, String](xs, "two", 2) + " in " + xs)
  }
  def `Seq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine")).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = Seq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainValue[String, String](xs, "two", 2) + " in " + xs)
  }
  def `IndexedSeq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine")).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = IndexedSeq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainKey[String, String](xs, "2", 2) + " in " + xs)
  }
  def `IndexedSeq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine")).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = IndexedSeq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainKey[String, String](xs, "2", 2) + " in " + xs)
  }
  def `IndexedSeq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine")).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = IndexedSeq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainValue[String, String](xs, "two", 2) + " in " + xs)
  }
  def `IndexedSeq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine")).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = IndexedSeq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainValue[String, String](xs, "two", 2) + " in " + xs)
  }
  def `collection.mutable.Set(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = collection.mutable.Set(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainKey[String, String](xs, "2", 2) + " in " + xs)
  }
  def `collection.mutable.Set(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = collection.mutable.Set(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainKey[String, String](xs, "2", 2) + " in " + xs)
  }
  def `collection.mutable.Set(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = collection.mutable.Set(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainValue[String, String](xs, "two", 2) + " in " + xs)
  }
  def `collection.mutable.Set(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = collection.mutable.Set(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainValue[String, String](xs, "two", 2) + " in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainKey[String, String](xs, "2", 2) + " in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainKey[String, String](xs, "2", 2) + " in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainValue[String, String](xs, "two", 2) + " in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainValue[String, String](xs, "two", 2) + " in " + xs)
  }
  def `collection.mutable.Seq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = collection.mutable.Seq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainKey[String, String](xs, "2", 2) + " in " + xs)
  }
  def `collection.mutable.Seq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = collection.mutable.Seq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainKey[String, String](xs, "2", 2) + " in " + xs)
  }
  def `collection.mutable.Seq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = collection.mutable.Seq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainValue[String, String](xs, "two", 2) + " in " + xs)
  }
  def `collection.mutable.Seq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = collection.mutable.Seq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainValue[String, String](xs, "two", 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = collection.mutable.IndexedSeq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainKey[String, String](xs, "2", 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = collection.mutable.IndexedSeq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainKey[String, String](xs, "2", 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = collection.mutable.IndexedSeq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainValue[String, String](xs, "two", 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = collection.mutable.IndexedSeq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainValue[String, String](xs, "two", 2) + " in " + xs)
  }
  def `collection.mutable.Set(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine")).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = collection.mutable.Set(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainKey[String, String](xs, "2", 2) + " in " + xs)
  }
  def `collection.mutable.Set(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine")).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = collection.mutable.Set(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainKey[String, String](xs, "2", 2) + " in " + xs)
  }
  def `collection.mutable.Set(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine")).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = collection.mutable.Set(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainValue[String, String](xs, "two", 2) + " in " + xs)
  }
  def `collection.mutable.Set(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine")).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = collection.mutable.Set(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainValue[String, String](xs, "two", 2) + " in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine"))).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine"))).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainKey[String, String](xs, "2", 2) + " in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine"))).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine"))).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainKey[String, String](xs, "2", 2) + " in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine"))).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine"))).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainValue[String, String](xs, "two", 2) + " in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine"))).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine"))).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainValue[String, String](xs, "two", 2) + " in " + xs)
  }
  def `collection.mutable.Seq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine")).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = collection.mutable.Seq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainKey[String, String](xs, "2", 2) + " in " + xs)
  }
  def `collection.mutable.Seq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine")).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = collection.mutable.Seq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainKey[String, String](xs, "2", 2) + " in " + xs)
  }
  def `collection.mutable.Seq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine")).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = collection.mutable.Seq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainValue[String, String](xs, "two", 2) + " in " + xs)
  }
  def `collection.mutable.Seq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine")).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = collection.mutable.Seq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainValue[String, String](xs, "two", 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine")).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = collection.mutable.IndexedSeq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainKey[String, String](xs, "2", 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine")).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = collection.mutable.IndexedSeq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainKey[String, String](xs, "2", 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine")).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = collection.mutable.IndexedSeq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainValue[String, String](xs, "two", 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine")).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = collection.mutable.IndexedSeq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"), Map("7" -> "seven", "8" -> "eight", "9" -> "nine")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainValue[String, String](xs, "two", 2) + " in " + xs)
  }
  def `Set(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = Set(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainKey[String, String](xs, "2", 2) + " in " + xs)
  }
  def `Set(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = Set(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainKey[String, String](xs, "2", 2) + " in " + xs)
  }
  def `Set(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = Set(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainValue[String, String](xs, "two", 2) + " in " + xs)
  }
  def `Set(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = Set(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainValue[String, String](xs, "two", 2) + " in " + xs)
  }
  def `List(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = List(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainKey[String, String](xs, "2", 2) + " in " + xs)
  }
  def `List(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = List(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainKey[String, String](xs, "2", 2) + " in " + xs)
  }
  def `List(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = List(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainValue[String, String](xs, "two", 2) + " in " + xs)
  }
  def `List(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = List(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainValue[String, String](xs, "two", 2) + " in " + xs)
  }
  def `Seq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = Seq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainKey[String, String](xs, "2", 2) + " in " + xs)
  }
  def `Seq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = Seq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainKey[String, String](xs, "2", 2) + " in " + xs)
  }
  def `Seq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = Seq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainValue[String, String](xs, "two", 2) + " in " + xs)
  }
  def `Seq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = Seq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainValue[String, String](xs, "two", 2) + " in " + xs)
  }
  def `Array(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = Array(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainKey[String, String](xs, "2", 2) + " in " + arrayToString(xs))
  }
  def `Array(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = Array(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainKey[String, String](xs, "2", 2) + " in " + arrayToString(xs))
  }
  def `Array(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = Array(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainValue[String, String](xs, "two", 2) + " in " + arrayToString(xs))
  }
  def `Array(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = Array(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainValue[String, String](xs, "two", 2) + " in " + arrayToString(xs))
  }
  def `IndexedSeq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = IndexedSeq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainKey[String, String](xs, "2", 2) + " in " + xs)
  }
  def `IndexedSeq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = IndexedSeq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainKey[String, String](xs, "2", 2) + " in " + xs)
  }
  def `IndexedSeq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = IndexedSeq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainValue[String, String](xs, "two", 2) + " in " + xs)
  }
  def `IndexedSeq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = IndexedSeq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainValue[String, String](xs, "two", 2) + " in " + xs)
  }
  def `Vector(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = Vector(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainKey[String, String](xs, "2", 2) + " in " + xs)
  }
  def `Vector(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = Vector(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainKey[String, String](xs, "2", 2) + " in " + xs)
  }
  def `Vector(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = Vector(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainValue[String, String](xs, "two", 2) + " in " + xs)
  }
  def `Vector(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = Vector(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainValue[String, String](xs, "two", 2) + " in " + xs)
  }
  def `Set(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine")).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = Set(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainKey[String, String](xs, "2", 2) + " in " + xs)
  }
  def `Set(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine")).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = Set(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainKey[String, String](xs, "2", 2) + " in " + xs)
  }
  def `Set(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine")).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = Set(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainValue[String, String](xs, "two", 2) + " in " + xs)
  }
  def `Set(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine")).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = Set(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainValue[String, String](xs, "two", 2) + " in " + xs)
  }
  def `List(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine")).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = List(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainKey[String, String](xs, "2", 2) + " in " + xs)
  }
  def `List(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine")).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = List(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainKey[String, String](xs, "2", 2) + " in " + xs)
  }
  def `List(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine")).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = List(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainValue[String, String](xs, "two", 2) + " in " + xs)
  }
  def `List(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine")).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = List(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainValue[String, String](xs, "two", 2) + " in " + xs)
  }
  def `Seq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine")).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = Seq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainKey[String, String](xs, "2", 2) + " in " + xs)
  }
  def `Seq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine")).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = Seq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainKey[String, String](xs, "2", 2) + " in " + xs)
  }
  def `Seq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine")).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = Seq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainValue[String, String](xs, "two", 2) + " in " + xs)
  }
  def `Seq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine")).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = Seq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainValue[String, String](xs, "two", 2) + " in " + xs)
  }
  def `IndexedSeq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine")).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = IndexedSeq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainKey[String, String](xs, "2", 2) + " in " + xs)
  }
  def `IndexedSeq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine")).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = IndexedSeq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainKey[String, String](xs, "2", 2) + " in " + xs)
  }
  def `IndexedSeq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine")).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = IndexedSeq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainValue[String, String](xs, "two", 2) + " in " + xs)
  }
  def `IndexedSeq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine")).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = IndexedSeq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainValue[String, String](xs, "two", 2) + " in " + xs)
  }
  def `collection.mutable.Set(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = collection.mutable.Set(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainKey[String, String](xs, "2", 2) + " in " + xs)
  }
  def `collection.mutable.Set(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = collection.mutable.Set(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainKey[String, String](xs, "2", 2) + " in " + xs)
  }
  def `collection.mutable.Set(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = collection.mutable.Set(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainValue[String, String](xs, "two", 2) + " in " + xs)
  }
  def `collection.mutable.Set(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = collection.mutable.Set(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainValue[String, String](xs, "two", 2) + " in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainKey[String, String](xs, "2", 2) + " in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainKey[String, String](xs, "2", 2) + " in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainValue[String, String](xs, "two", 2) + " in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainValue[String, String](xs, "two", 2) + " in " + xs)
  }
  def `collection.mutable.Seq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = collection.mutable.Seq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainKey[String, String](xs, "2", 2) + " in " + xs)
  }
  def `collection.mutable.Seq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = collection.mutable.Seq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainKey[String, String](xs, "2", 2) + " in " + xs)
  }
  def `collection.mutable.Seq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = collection.mutable.Seq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainValue[String, String](xs, "two", 2) + " in " + xs)
  }
  def `collection.mutable.Seq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = collection.mutable.Seq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainValue[String, String](xs, "two", 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = collection.mutable.IndexedSeq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainKey[String, String](xs, "2", 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = collection.mutable.IndexedSeq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainKey[String, String](xs, "2", 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = collection.mutable.IndexedSeq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainValue[String, String](xs, "two", 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = collection.mutable.IndexedSeq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainValue[String, String](xs, "two", 2) + " in " + xs)
  }
  def `collection.mutable.Set(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine")).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = collection.mutable.Set(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainKey[String, String](xs, "2", 2) + " in " + xs)
  }
  def `collection.mutable.Set(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine")).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = collection.mutable.Set(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainKey[String, String](xs, "2", 2) + " in " + xs)
  }
  def `collection.mutable.Set(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine")).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = collection.mutable.Set(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainValue[String, String](xs, "two", 2) + " in " + xs)
  }
  def `collection.mutable.Set(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine")).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = collection.mutable.Set(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainValue[String, String](xs, "two", 2) + " in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine"))).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine"))).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainKey[String, String](xs, "2", 2) + " in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine"))).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine"))).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainKey[String, String](xs, "2", 2) + " in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine"))).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine"))).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainValue[String, String](xs, "two", 2) + " in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine"))).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine"))).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainValue[String, String](xs, "two", 2) + " in " + xs)
  }
  def `collection.mutable.Seq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine")).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = collection.mutable.Seq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainKey[String, String](xs, "2", 2) + " in " + xs)
  }
  def `collection.mutable.Seq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine")).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = collection.mutable.Seq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainKey[String, String](xs, "2", 2) + " in " + xs)
  }
  def `collection.mutable.Seq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine")).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = collection.mutable.Seq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainValue[String, String](xs, "two", 2) + " in " + xs)
  }
  def `collection.mutable.Seq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine")).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = collection.mutable.Seq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainValue[String, String](xs, "two", 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine")).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = collection.mutable.IndexedSeq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainKey[String, String](xs, "2", 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine")).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = collection.mutable.IndexedSeq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainKey[String, String](xs, "2", 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine")).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = collection.mutable.IndexedSeq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainValue[String, String](xs, "two", 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine")).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = collection.mutable.IndexedSeq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"), collection.mutable.Map("7" -> "seven", "8" -> "eight", "9" -> "nine")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainValue[String, String](xs, "two", 2) + " in " + xs)
  }
  def `Set(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.HashMap("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = Set(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.HashMap("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainKey[String, String](xs, "2", 2) + " in " + xs)
  }
  def `Set(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.HashMap("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = Set(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.HashMap("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainKey[String, String](xs, "2", 2) + " in " + xs)
  }
  def `Set(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.HashMap("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = Set(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.HashMap("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainValue[String, String](xs, "two", 2) + " in " + xs)
  }
  def `Set(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.HashMap("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = Set(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.HashMap("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainValue[String, String](xs, "two", 2) + " in " + xs)
  }
  def `List(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.HashMap("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = List(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.HashMap("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainKey[String, String](xs, "2", 2) + " in " + xs)
  }
  def `List(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.HashMap("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = List(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.HashMap("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainKey[String, String](xs, "2", 2) + " in " + xs)
  }
  def `List(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.HashMap("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = List(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.HashMap("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainValue[String, String](xs, "two", 2) + " in " + xs)
  }
  def `List(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.HashMap("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = List(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.HashMap("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainValue[String, String](xs, "two", 2) + " in " + xs)
  }
  def `Seq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.HashMap("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = Seq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.HashMap("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainKey[String, String](xs, "2", 2) + " in " + xs)
  }
  def `Seq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.HashMap("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = Seq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.HashMap("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainKey[String, String](xs, "2", 2) + " in " + xs)
  }
  def `Seq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.HashMap("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = Seq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.HashMap("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainValue[String, String](xs, "two", 2) + " in " + xs)
  }
  def `Seq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.HashMap("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = Seq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.HashMap("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainValue[String, String](xs, "two", 2) + " in " + xs)
  }
  def `Array(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.HashMap("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = Array(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.HashMap("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainKey[String, String](xs, "2", 2) + " in " + arrayToString(xs))
  }
  def `Array(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.HashMap("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = Array(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.HashMap("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainKey[String, String](xs, "2", 2) + " in " + arrayToString(xs))
  }
  def `Array(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.HashMap("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = Array(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.HashMap("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainValue[String, String](xs, "two", 2) + " in " + arrayToString(xs))
  }
  def `Array(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.HashMap("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = Array(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.HashMap("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainValue[String, String](xs, "two", 2) + " in " + arrayToString(xs))
  }
  def `IndexedSeq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.HashMap("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = IndexedSeq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.HashMap("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainKey[String, String](xs, "2", 2) + " in " + xs)
  }
  def `IndexedSeq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.HashMap("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = IndexedSeq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.HashMap("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainKey[String, String](xs, "2", 2) + " in " + xs)
  }
  def `IndexedSeq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.HashMap("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = IndexedSeq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.HashMap("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainValue[String, String](xs, "two", 2) + " in " + xs)
  }
  def `IndexedSeq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.HashMap("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = IndexedSeq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.HashMap("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainValue[String, String](xs, "two", 2) + " in " + xs)
  }
  def `Vector(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.HashMap("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = Vector(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.HashMap("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainKey[String, String](xs, "2", 2) + " in " + xs)
  }
  def `Vector(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.HashMap("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = Vector(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.HashMap("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainKey[String, String](xs, "2", 2) + " in " + xs)
  }
  def `Vector(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.HashMap("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = Vector(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.HashMap("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainValue[String, String](xs, "two", 2) + " in " + xs)
  }
  def `Vector(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.HashMap("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = Vector(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.HashMap("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainValue[String, String](xs, "two", 2) + " in " + xs)
  }
  def `Set(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.HashMap("7" -> "seven", "8" -> "eight", "9" -> "nine")).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = Set(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.HashMap("7" -> "seven", "8" -> "eight", "9" -> "nine")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainKey[String, String](xs, "2", 2) + " in " + xs)
  }
  def `Set(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.HashMap("7" -> "seven", "8" -> "eight", "9" -> "nine")).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = Set(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.HashMap("7" -> "seven", "8" -> "eight", "9" -> "nine")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainKey[String, String](xs, "2", 2) + " in " + xs)
  }
  def `Set(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.HashMap("7" -> "seven", "8" -> "eight", "9" -> "nine")).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = Set(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.HashMap("7" -> "seven", "8" -> "eight", "9" -> "nine")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainValue[String, String](xs, "two", 2) + " in " + xs)
  }
  def `Set(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.HashMap("7" -> "seven", "8" -> "eight", "9" -> "nine")).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = Set(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.HashMap("7" -> "seven", "8" -> "eight", "9" -> "nine")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainValue[String, String](xs, "two", 2) + " in " + xs)
  }
  def `List(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.HashMap("7" -> "seven", "8" -> "eight", "9" -> "nine")).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = List(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.HashMap("7" -> "seven", "8" -> "eight", "9" -> "nine")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainKey[String, String](xs, "2", 2) + " in " + xs)
  }
  def `List(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.HashMap("7" -> "seven", "8" -> "eight", "9" -> "nine")).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = List(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.HashMap("7" -> "seven", "8" -> "eight", "9" -> "nine")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainKey[String, String](xs, "2", 2) + " in " + xs)
  }
  def `List(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.HashMap("7" -> "seven", "8" -> "eight", "9" -> "nine")).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = List(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.HashMap("7" -> "seven", "8" -> "eight", "9" -> "nine")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainValue[String, String](xs, "two", 2) + " in " + xs)
  }
  def `List(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.HashMap("7" -> "seven", "8" -> "eight", "9" -> "nine")).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = List(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.HashMap("7" -> "seven", "8" -> "eight", "9" -> "nine")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainValue[String, String](xs, "two", 2) + " in " + xs)
  }
  def `Seq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.HashMap("7" -> "seven", "8" -> "eight", "9" -> "nine")).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = Seq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.HashMap("7" -> "seven", "8" -> "eight", "9" -> "nine")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainKey[String, String](xs, "2", 2) + " in " + xs)
  }
  def `Seq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.HashMap("7" -> "seven", "8" -> "eight", "9" -> "nine")).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = Seq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.HashMap("7" -> "seven", "8" -> "eight", "9" -> "nine")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainKey[String, String](xs, "2", 2) + " in " + xs)
  }
  def `Seq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.HashMap("7" -> "seven", "8" -> "eight", "9" -> "nine")).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = Seq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.HashMap("7" -> "seven", "8" -> "eight", "9" -> "nine")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainValue[String, String](xs, "two", 2) + " in " + xs)
  }
  def `Seq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.HashMap("7" -> "seven", "8" -> "eight", "9" -> "nine")).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = Seq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.HashMap("7" -> "seven", "8" -> "eight", "9" -> "nine")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainValue[String, String](xs, "two", 2) + " in " + xs)
  }
  def `IndexedSeq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.HashMap("7" -> "seven", "8" -> "eight", "9" -> "nine")).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = IndexedSeq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.HashMap("7" -> "seven", "8" -> "eight", "9" -> "nine")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainKey[String, String](xs, "2", 2) + " in " + xs)
  }
  def `IndexedSeq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.HashMap("7" -> "seven", "8" -> "eight", "9" -> "nine")).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = IndexedSeq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.HashMap("7" -> "seven", "8" -> "eight", "9" -> "nine")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainKey[String, String](xs, "2", 2) + " in " + xs)
  }
  def `IndexedSeq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.HashMap("7" -> "seven", "8" -> "eight", "9" -> "nine")).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = IndexedSeq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.HashMap("7" -> "seven", "8" -> "eight", "9" -> "nine")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainValue[String, String](xs, "two", 2) + " in " + xs)
  }
  def `IndexedSeq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.HashMap("7" -> "seven", "8" -> "eight", "9" -> "nine")).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = IndexedSeq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.HashMap("7" -> "seven", "8" -> "eight", "9" -> "nine")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainValue[String, String](xs, "two", 2) + " in " + xs)
  }
  def `collection.mutable.Set(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.HashMap("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = collection.mutable.Set(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.HashMap("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainKey[String, String](xs, "2", 2) + " in " + xs)
  }
  def `collection.mutable.Set(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.HashMap("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = collection.mutable.Set(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.HashMap("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainKey[String, String](xs, "2", 2) + " in " + xs)
  }
  def `collection.mutable.Set(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.HashMap("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = collection.mutable.Set(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.HashMap("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainValue[String, String](xs, "two", 2) + " in " + xs)
  }
  def `collection.mutable.Set(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.HashMap("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = collection.mutable.Set(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.HashMap("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainValue[String, String](xs, "two", 2) + " in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.HashMap("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.HashMap("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainKey[String, String](xs, "2", 2) + " in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.HashMap("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.HashMap("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec1.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainKey[String, String](xs, "2", 2) + " in " + xs)
  }
}
