package org.scalatest.inspectors.atMost

import org.scalatest._
import SharedHelpers._
import org.scalatest.matchers.{BePropertyMatcher, BePropertyMatchResult, HavePropertyMatcher, HavePropertyMatchResult}
import collection.GenTraversable
import collection.GenMap
class InspectorShorthandsForAtMostFailedSpec3 extends Spec with Matchers {
  class EmptyBePropertyMatcher extends BePropertyMatcher[String] {
    def apply(left: String) = BePropertyMatchResult(left.isEmpty, "empty")
  }
  class StringLengthMatcher(expectedValue: Int) extends HavePropertyMatcher[String, Int] {
    def apply(value: String) = {
      new HavePropertyMatchResult(value.length == expectedValue, "length", expectedValue, value.length)
    }
  }
  val empty = new EmptyBePropertyMatcher()
  def plength(expectedValue: Int) = new StringLengthMatcher(expectedValue)
  val theInstance = "2"
  def arrayToString(xs: GenTraversable[_]): String = xs.toString
  def checkErrorAndCause(e: exceptions.TestFailedException, assertLineNumber: Int, fileName: String, errorMessage: String, causeErrorMessage: String) {
    assert(e.failedCodeFileName == Some(fileName), e.failedCodeFileName + " did not equal " + Some(fileName))
    assert(e.failedCodeLineNumber == Some(assertLineNumber), e.failedCodeLineNumber + " did not equal " + Some(assertLineNumber))
    assert(e.message == Some(errorMessage), e.message + " did not equal " + Some(
  errorMessage))
    e.getCause match {
      case tfe: exceptions.TestFailedException =>
        assert(tfe.failedCodeFileName == Some(fileName), tfe.failedCodeFileName + " did not equal " + Some(fileName))
        assert(tfe.failedCodeLineNumber == Some(assertLineNumber), tfe.failedCodeLineNumber + " did not equal " + Some(assertLineNumber))
        assert(tfe.message == Some(causeErrorMessage), tfe.message + " did not equal " + Some(causeErrorMessage))
        assert(tfe.getCause == null, tfe.getCause + " was not null")
      case other => fail("Expected cause to be TestFailedException, but got: " + other)
    }
  }
  def checkError(e: exceptions.TestFailedException, assertLineNumber: Int, fileName: String, errorMessage: String) {
    assert(e.failedCodeFileName == Some(fileName), e.failedCodeFileName + " did not equal " + Some(fileName))
    assert(e.failedCodeLineNumber == Some(assertLineNumber), e.failedCodeLineNumber + " did not equal " + Some(assertLineNumber))
    assert(e.message == Some(errorMessage), e.message + " did not equal " + Some(
  errorMessage))
  }
  def equal[T](left: T, right: T): Boolean = left == right
  def javaArrayList[T](valueList: List[T]): java.util.ArrayList[T] = {
    val col = new java.util.ArrayList[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaHashSet[T](valueList: List[T]): java.util.HashSet[T] = {
    val col = new java.util.HashSet[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaLinkedList[T](valueList: List[T]): java.util.LinkedList[T] = {
    val col = new java.util.LinkedList[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaStack[T](valueList: List[T]): java.util.Stack[T] = {
    val col = new java.util.Stack[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaTreeSet[T](valueList: List[T]): java.util.TreeSet[T] = {
    val col = new java.util.TreeSet[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaVector[T](valueList: List[T]): java.util.Vector[T] = {
    val col = new java.util.Vector[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaArrayBlockingQueue[T](valueList: List[T], size: Int): java.util.concurrent.ArrayBlockingQueue[T] = {
    val col = new java.util.concurrent.ArrayBlockingQueue[T](size)
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaArrayDeque[T](valueList: List[T]): java.util.ArrayDeque[T] = {
    val col = new java.util.ArrayDeque[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaConcurrentLinkedQueue[T](valueList: List[T]): java.util.concurrent.ConcurrentLinkedQueue[T] = {
    val col = new java.util.concurrent.ConcurrentLinkedQueue[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaConcurrentSkipListSet[T](valueList: List[T]): java.util.concurrent.ConcurrentSkipListSet[T] = {
    val col = new java.util.concurrent.ConcurrentSkipListSet[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaCopyOnWriteArrayList[T](valueList: List[T]): java.util.concurrent.CopyOnWriteArrayList[T] = {
    val col = new java.util.concurrent.CopyOnWriteArrayList[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaCopyOnWriteArraySet[T](valueList: List[T]): java.util.concurrent.CopyOnWriteArraySet[T] = {
    val col = new java.util.concurrent.CopyOnWriteArraySet[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaLinkedBlockingDeque[T](valueList: List[T]): java.util.concurrent.LinkedBlockingDeque[T] = {
    val col = new java.util.concurrent.LinkedBlockingDeque[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaLinkedBlockingQueue[T](valueList: List[T]): java.util.concurrent.LinkedBlockingQueue[T] = {
    val col = new java.util.concurrent.LinkedBlockingQueue[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaLinkedHashSet[T](valueList: List[T]): java.util.LinkedHashSet[T] = {
    val col = new java.util.LinkedHashSet[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaPriorityBlockingQueue[T](valueList: List[T]): java.util.concurrent.PriorityBlockingQueue[T] = {
    val col = new java.util.concurrent.PriorityBlockingQueue[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaPriorityQueue[T](valueList: List[T]): java.util.PriorityQueue[T] = {
    val col = new java.util.PriorityQueue[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaHashMap[K, V](valueMap: Map[K, V]): java.util.HashMap[K, V] = {
    val map = new java.util.HashMap[K, V]()
    for ((key, value) <- valueMap)
      map.put(key, value)
    map
  }
  def javaTreeMap[K, V](valueMap: Map[K, V]): java.util.TreeMap[K, V] = {
    val map = new java.util.TreeMap[K, V]()
    for ((key, value) <- valueMap)
      map.put(key, value)
    map
  }
  def javaHashtable[K, V](valueMap: Map[K, V]): java.util.Hashtable[K, V] = {
    val map = new java.util.Hashtable[K, V]()
    for ((key, value) <- valueMap)
      map.put(key, value)
    map
  }
  def javaConcurrentHashMap[K, V](valueMap: Map[K, V]): java.util.concurrent.ConcurrentHashMap[K, V] = {
    val map = new java.util.concurrent.ConcurrentHashMap[K, V]()
    for ((key, value) <- valueMap)
      map.put(key, value)
    map
  }
  def javaConcurrentSkipListMap[K, V](valueMap: Map[K, V]): java.util.concurrent.ConcurrentSkipListMap[K, V] = {
    val map = new java.util.concurrent.ConcurrentSkipListMap[K, V]()
    for ((key, value) <- valueMap)
      map.put(key, value)
    map
  }
  def javaLinkedHashMap[K, V](valueMap: Map[K, V]): java.util.LinkedHashMap[K, V] = {
    val map = new java.util.LinkedHashMap[K, V]()
    for ((key, value) <- valueMap)
      map.put(key, value)
    map
  }
  def javaWeakHashMap[K, V](valueMap: Map[K, V]): java.util.WeakHashMap[K, V] = {
    val map = new java.util.WeakHashMap[K, V]()
    for ((key, value) <- valueMap)
      map.put(key, value)
    map
  }
  def javaProperties(valueMap: Map[String, String]): java.util.Properties = {
    val map = new java.util.Properties()
    for ((key, value) <- valueMap)
      map.put(key, value)
    map
  }
  def `collection.mutable.Set(collection.immutable.TreeMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.TreeMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.TreeMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.TreeMap("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = collection.mutable.Set(collection.immutable.TreeMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.TreeMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.TreeMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.TreeMap("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec3.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainValue[String, String](xs, "two", 2) + " in " + xs)
  }
  def `collection.mutable.Set(collection.immutable.TreeMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.TreeMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.TreeMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.TreeMap("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = collection.mutable.Set(collection.immutable.TreeMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.TreeMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.TreeMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.TreeMap("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec3.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainValue[String, String](xs, "two", 2) + " in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List(collection.immutable.TreeMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.TreeMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.TreeMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.TreeMap("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List(collection.immutable.TreeMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.TreeMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.TreeMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.TreeMap("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec3.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainKey[String, String](xs, "2", 2) + " in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List(collection.immutable.TreeMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.TreeMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.TreeMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.TreeMap("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List(collection.immutable.TreeMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.TreeMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.TreeMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.TreeMap("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec3.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainKey[String, String](xs, "2", 2) + " in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List(collection.immutable.TreeMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.TreeMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.TreeMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.TreeMap("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List(collection.immutable.TreeMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.TreeMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.TreeMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.TreeMap("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec3.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainValue[String, String](xs, "two", 2) + " in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List(collection.immutable.TreeMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.TreeMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.TreeMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.TreeMap("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List(collection.immutable.TreeMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.TreeMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.TreeMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.TreeMap("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec3.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainValue[String, String](xs, "two", 2) + " in " + xs)
  }
  def `collection.mutable.Seq(collection.immutable.TreeMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.TreeMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.TreeMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.TreeMap("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = collection.mutable.Seq(collection.immutable.TreeMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.TreeMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.TreeMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.TreeMap("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec3.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainKey[String, String](xs, "2", 2) + " in " + xs)
  }
  def `collection.mutable.Seq(collection.immutable.TreeMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.TreeMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.TreeMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.TreeMap("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = collection.mutable.Seq(collection.immutable.TreeMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.TreeMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.TreeMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.TreeMap("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec3.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainKey[String, String](xs, "2", 2) + " in " + xs)
  }
  def `collection.mutable.Seq(collection.immutable.TreeMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.TreeMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.TreeMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.TreeMap("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = collection.mutable.Seq(collection.immutable.TreeMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.TreeMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.TreeMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.TreeMap("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec3.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainValue[String, String](xs, "two", 2) + " in " + xs)
  }
  def `collection.mutable.Seq(collection.immutable.TreeMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.TreeMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.TreeMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.TreeMap("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = collection.mutable.Seq(collection.immutable.TreeMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.TreeMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.TreeMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.TreeMap("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec3.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainValue[String, String](xs, "two", 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq(collection.immutable.TreeMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.TreeMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.TreeMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.TreeMap("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = collection.mutable.IndexedSeq(collection.immutable.TreeMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.TreeMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.TreeMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.TreeMap("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec3.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainKey[String, String](xs, "2", 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq(collection.immutable.TreeMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.TreeMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.TreeMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.TreeMap("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = collection.mutable.IndexedSeq(collection.immutable.TreeMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.TreeMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.TreeMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.TreeMap("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec3.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainKey[String, String](xs, "2", 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq(collection.immutable.TreeMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.TreeMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.TreeMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.TreeMap("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = collection.mutable.IndexedSeq(collection.immutable.TreeMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.TreeMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.TreeMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.TreeMap("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec3.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainValue[String, String](xs, "two", 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq(collection.immutable.TreeMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.TreeMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.TreeMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.TreeMap("7" -> "seven", "8" -> "eight", "9" -> "nine")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = collection.mutable.IndexedSeq(collection.immutable.TreeMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.TreeMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.TreeMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.TreeMap("7" -> "seven", "8" -> "eight", "9" -> "nine"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec3.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainValue[String, String](xs, "two", 2) + " in " + xs)
  }
  def `collection.mutable.Set(collection.immutable.TreeMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.TreeMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.TreeMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.TreeMap("7" -> "seven", "8" -> "eight", "9" -> "nine")).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = collection.mutable.Set(collection.immutable.TreeMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.TreeMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.TreeMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.TreeMap("7" -> "seven", "8" -> "eight", "9" -> "nine")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec3.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainKey[String, String](xs, "2", 2) + " in " + xs)
  }
  def `collection.mutable.Set(collection.immutable.TreeMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.TreeMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.TreeMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.TreeMap("7" -> "seven", "8" -> "eight", "9" -> "nine")).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = collection.mutable.Set(collection.immutable.TreeMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.TreeMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.TreeMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.TreeMap("7" -> "seven", "8" -> "eight", "9" -> "nine")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec3.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainKey[String, String](xs, "2", 2) + " in " + xs)
  }
  def `collection.mutable.Set(collection.immutable.TreeMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.TreeMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.TreeMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.TreeMap("7" -> "seven", "8" -> "eight", "9" -> "nine")).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = collection.mutable.Set(collection.immutable.TreeMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.TreeMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.TreeMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.TreeMap("7" -> "seven", "8" -> "eight", "9" -> "nine")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec3.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainValue[String, String](xs, "two", 2) + " in " + xs)
  }
  def `collection.mutable.Set(collection.immutable.TreeMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.TreeMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.TreeMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.TreeMap("7" -> "seven", "8" -> "eight", "9" -> "nine")).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = collection.mutable.Set(collection.immutable.TreeMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.TreeMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.TreeMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.TreeMap("7" -> "seven", "8" -> "eight", "9" -> "nine")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec3.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainValue[String, String](xs, "two", 2) + " in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List(collection.immutable.TreeMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.TreeMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.TreeMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.TreeMap("7" -> "seven", "8" -> "eight", "9" -> "nine"))).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List(collection.immutable.TreeMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.TreeMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.TreeMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.TreeMap("7" -> "seven", "8" -> "eight", "9" -> "nine"))).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec3.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainKey[String, String](xs, "2", 2) + " in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List(collection.immutable.TreeMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.TreeMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.TreeMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.TreeMap("7" -> "seven", "8" -> "eight", "9" -> "nine"))).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List(collection.immutable.TreeMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.TreeMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.TreeMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.TreeMap("7" -> "seven", "8" -> "eight", "9" -> "nine"))).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec3.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainKey[String, String](xs, "2", 2) + " in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List(collection.immutable.TreeMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.TreeMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.TreeMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.TreeMap("7" -> "seven", "8" -> "eight", "9" -> "nine"))).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List(collection.immutable.TreeMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.TreeMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.TreeMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.TreeMap("7" -> "seven", "8" -> "eight", "9" -> "nine"))).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec3.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainValue[String, String](xs, "two", 2) + " in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List(collection.immutable.TreeMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.TreeMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.TreeMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.TreeMap("7" -> "seven", "8" -> "eight", "9" -> "nine"))).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List(collection.immutable.TreeMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.TreeMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.TreeMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.TreeMap("7" -> "seven", "8" -> "eight", "9" -> "nine"))).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec3.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainValue[String, String](xs, "two", 2) + " in " + xs)
  }
  def `collection.mutable.Seq(collection.immutable.TreeMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.TreeMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.TreeMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.TreeMap("7" -> "seven", "8" -> "eight", "9" -> "nine")).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = collection.mutable.Seq(collection.immutable.TreeMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.TreeMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.TreeMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.TreeMap("7" -> "seven", "8" -> "eight", "9" -> "nine")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec3.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainKey[String, String](xs, "2", 2) + " in " + xs)
  }
  def `collection.mutable.Seq(collection.immutable.TreeMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.TreeMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.TreeMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.TreeMap("7" -> "seven", "8" -> "eight", "9" -> "nine")).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = collection.mutable.Seq(collection.immutable.TreeMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.TreeMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.TreeMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.TreeMap("7" -> "seven", "8" -> "eight", "9" -> "nine")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec3.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainKey[String, String](xs, "2", 2) + " in " + xs)
  }
  def `collection.mutable.Seq(collection.immutable.TreeMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.TreeMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.TreeMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.TreeMap("7" -> "seven", "8" -> "eight", "9" -> "nine")).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = collection.mutable.Seq(collection.immutable.TreeMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.TreeMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.TreeMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.TreeMap("7" -> "seven", "8" -> "eight", "9" -> "nine")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec3.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainValue[String, String](xs, "two", 2) + " in " + xs)
  }
  def `collection.mutable.Seq(collection.immutable.TreeMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.TreeMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.TreeMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.TreeMap("7" -> "seven", "8" -> "eight", "9" -> "nine")).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = collection.mutable.Seq(collection.immutable.TreeMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.TreeMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.TreeMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.TreeMap("7" -> "seven", "8" -> "eight", "9" -> "nine")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec3.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainValue[String, String](xs, "two", 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq(collection.immutable.TreeMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.TreeMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.TreeMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.TreeMap("7" -> "seven", "8" -> "eight", "9" -> "nine")).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = collection.mutable.IndexedSeq(collection.immutable.TreeMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.TreeMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.TreeMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.TreeMap("7" -> "seven", "8" -> "eight", "9" -> "nine")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec3.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainKey[String, String](xs, "2", 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq(collection.immutable.TreeMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.TreeMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.TreeMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.TreeMap("7" -> "seven", "8" -> "eight", "9" -> "nine")).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = collection.mutable.IndexedSeq(collection.immutable.TreeMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.TreeMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.TreeMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.TreeMap("7" -> "seven", "8" -> "eight", "9" -> "nine")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec3.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainKey[String, String](xs, "2", 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq(collection.immutable.TreeMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.TreeMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.TreeMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.TreeMap("7" -> "seven", "8" -> "eight", "9" -> "nine")).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = collection.mutable.IndexedSeq(collection.immutable.TreeMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.TreeMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.TreeMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.TreeMap("7" -> "seven", "8" -> "eight", "9" -> "nine")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec3.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesContainValue[String, String](xs, "two", 2) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq(collection.immutable.TreeMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.TreeMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.TreeMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.TreeMap("7" -> "seven", "8" -> "eight", "9" -> "nine")).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = collection.mutable.IndexedSeq(collection.immutable.TreeMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.TreeMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.TreeMap("2" -> "two", "6" -> "six", "8" -> "eight"), collection.immutable.TreeMap("7" -> "seven", "8" -> "eight", "9" -> "nine")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      atMost(1, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForAtMostFailedSpec3.scala", "'atMost(1)' inspection failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotContainValue[String, String](xs, "two", 2) + " in " + xs)
  }
}
