package org.scalatest.inspectors.atMost

import org.scalatest._
import SharedHelpers._
import org.scalatest.matchers.{BePropertyMatcher, BePropertyMatchResult, HavePropertyMatcher, HavePropertyMatchResult}
import collection.GenTraversable
import collection.GenMap
class InspectorShorthandsForAtMostSucceededSpec extends Spec with Matchers {
  def `atMost(5, Set(1, 2, 3, 4, 5)) should succeed when elements succeeded count is equal to the max` {
    atMost(5, Set(1, 2, 3, 4, 5)) should be < 5
  }
  def `atMost(5, List(1, 2, 3, 4, 5)) should succeed when elements succeeded count is equal to the max` {
    atMost(5, List(1, 2, 3, 4, 5)) should be < 5
  }
  def `atMost(5, Seq(1, 2, 3, 4, 5)) should succeed when elements succeeded count is equal to the max` {
    atMost(5, Seq(1, 2, 3, 4, 5)) should be < 5
  }
  def `atMost(5, Array(1, 2, 3, 4, 5)) should succeed when elements succeeded count is equal to the max` {
    atMost(5, Array(1, 2, 3, 4, 5)) should be < 5
  }
  def `atMost(5, IndexedSeq(1, 2, 3, 4, 5)) should succeed when elements succeeded count is equal to the max` {
    atMost(5, IndexedSeq(1, 2, 3, 4, 5)) should be < 5
  }
  def `atMost(5, Vector(1, 2, 3, 4, 5)) should succeed when elements succeeded count is equal to the max` {
    atMost(5, Vector(1, 2, 3, 4, 5)) should be < 5
  }
  def `atMost(5, Set(1, 2, 3, 4, 5).par) should succeed when elements succeeded count is equal to the max` {
    atMost(5, Set(1, 2, 3, 4, 5).par) should be < 5
  }
  def `atMost(5, List(1, 2, 3, 4, 5).par) should succeed when elements succeeded count is equal to the max` {
    atMost(5, List(1, 2, 3, 4, 5).par) should be < 5
  }
  def `atMost(5, Seq(1, 2, 3, 4, 5).par) should succeed when elements succeeded count is equal to the max` {
    atMost(5, Seq(1, 2, 3, 4, 5).par) should be < 5
  }
  def `atMost(5, IndexedSeq(1, 2, 3, 4, 5).par) should succeed when elements succeeded count is equal to the max` {
    atMost(5, IndexedSeq(1, 2, 3, 4, 5).par) should be < 5
  }
  def `atMost(5, collection.mutable.Set(1, 2, 3, 4, 5)) should succeed when elements succeeded count is equal to the max` {
    atMost(5, collection.mutable.Set(1, 2, 3, 4, 5)) should be < 5
  }
  def `atMost(5, new collection.mutable.ListBuffer() ++ List(1, 2, 3, 4, 5)) should succeed when elements succeeded count is equal to the max` {
    atMost(5, new collection.mutable.ListBuffer() ++ List(1, 2, 3, 4, 5)) should be < 5
  }
  def `atMost(5, collection.mutable.Seq(1, 2, 3, 4, 5)) should succeed when elements succeeded count is equal to the max` {
    atMost(5, collection.mutable.Seq(1, 2, 3, 4, 5)) should be < 5
  }
  def `atMost(5, collection.mutable.IndexedSeq(1, 2, 3, 4, 5)) should succeed when elements succeeded count is equal to the max` {
    atMost(5, collection.mutable.IndexedSeq(1, 2, 3, 4, 5)) should be < 5
  }
  def `atMost(5, collection.mutable.Set(1, 2, 3, 4, 5).par) should succeed when elements succeeded count is equal to the max` {
    atMost(5, collection.mutable.Set(1, 2, 3, 4, 5).par) should be < 5
  }
  def `atMost(5, (new collection.mutable.ListBuffer() ++ List(1, 2, 3, 4, 5)).par) should succeed when elements succeeded count is equal to the max` {
    atMost(5, (new collection.mutable.ListBuffer() ++ List(1, 2, 3, 4, 5)).par) should be < 5
  }
  def `atMost(5, collection.mutable.Seq(1, 2, 3, 4, 5).par) should succeed when elements succeeded count is equal to the max` {
    atMost(5, collection.mutable.Seq(1, 2, 3, 4, 5).par) should be < 5
  }
  def `atMost(5, collection.mutable.IndexedSeq(1, 2, 3, 4, 5).par) should succeed when elements succeeded count is equal to the max` {
    atMost(5, collection.mutable.IndexedSeq(1, 2, 3, 4, 5).par) should be < 5
  }
}
