package org.scalatest.inspectors.between

import org.scalatest._
import SharedHelpers._
import org.scalatest.matchers.{BePropertyMatcher, BePropertyMatchResult, HavePropertyMatcher, HavePropertyMatchResult}
import collection.GenTraversable
import collection.GenMap
class InspectorShorthandsForBetweenSucceededSpec extends Spec with Matchers {
  def `between(2, 4, Set(1, 2, 3)) should succeed when elements succeeded count is in range` {
    between(2, 4, Set(1, 2, 3)) should be > 0
  }
  def `between(2, 4, List(1, 2, 3)) should succeed when elements succeeded count is in range` {
    between(2, 4, List(1, 2, 3)) should be > 0
  }
  def `between(2, 4, Seq(1, 2, 3)) should succeed when elements succeeded count is in range` {
    between(2, 4, Seq(1, 2, 3)) should be > 0
  }
  def `between(2, 4, Array(1, 2, 3)) should succeed when elements succeeded count is in range` {
    between(2, 4, Array(1, 2, 3)) should be > 0
  }
  def `between(2, 4, IndexedSeq(1, 2, 3)) should succeed when elements succeeded count is in range` {
    between(2, 4, IndexedSeq(1, 2, 3)) should be > 0
  }
  def `between(2, 4, Vector(1, 2, 3)) should succeed when elements succeeded count is in range` {
    between(2, 4, Vector(1, 2, 3)) should be > 0
  }
  def `between(2, 4, Set(1, 2, 3).par) should succeed when elements succeeded count is in range` {
    between(2, 4, Set(1, 2, 3).par) should be > 0
  }
  def `between(2, 4, List(1, 2, 3).par) should succeed when elements succeeded count is in range` {
    between(2, 4, List(1, 2, 3).par) should be > 0
  }
  def `between(2, 4, Seq(1, 2, 3).par) should succeed when elements succeeded count is in range` {
    between(2, 4, Seq(1, 2, 3).par) should be > 0
  }
  def `between(2, 4, IndexedSeq(1, 2, 3).par) should succeed when elements succeeded count is in range` {
    between(2, 4, IndexedSeq(1, 2, 3).par) should be > 0
  }
  def `between(2, 4, collection.mutable.Set(1, 2, 3)) should succeed when elements succeeded count is in range` {
    between(2, 4, collection.mutable.Set(1, 2, 3)) should be > 0
  }
  def `between(2, 4, new collection.mutable.ListBuffer() ++ List(1, 2, 3)) should succeed when elements succeeded count is in range` {
    between(2, 4, new collection.mutable.ListBuffer() ++ List(1, 2, 3)) should be > 0
  }
  def `between(2, 4, collection.mutable.Seq(1, 2, 3)) should succeed when elements succeeded count is in range` {
    between(2, 4, collection.mutable.Seq(1, 2, 3)) should be > 0
  }
  def `between(2, 4, collection.mutable.IndexedSeq(1, 2, 3)) should succeed when elements succeeded count is in range` {
    between(2, 4, collection.mutable.IndexedSeq(1, 2, 3)) should be > 0
  }
  def `between(2, 4, collection.mutable.Set(1, 2, 3).par) should succeed when elements succeeded count is in range` {
    between(2, 4, collection.mutable.Set(1, 2, 3).par) should be > 0
  }
  def `between(2, 4, (new collection.mutable.ListBuffer() ++ List(1, 2, 3)).par) should succeed when elements succeeded count is in range` {
    between(2, 4, (new collection.mutable.ListBuffer() ++ List(1, 2, 3)).par) should be > 0
  }
  def `between(2, 4, collection.mutable.Seq(1, 2, 3).par) should succeed when elements succeeded count is in range` {
    between(2, 4, collection.mutable.Seq(1, 2, 3).par) should be > 0
  }
  def `between(2, 4, collection.mutable.IndexedSeq(1, 2, 3).par) should succeed when elements succeeded count is in range` {
    between(2, 4, collection.mutable.IndexedSeq(1, 2, 3).par) should be > 0
  }
}
