package org.scalatest.inspectors.every

import org.scalatest._
import SharedHelpers._
import org.scalatest.matchers.{BePropertyMatcher, BePropertyMatchResult, HavePropertyMatcher, HavePropertyMatchResult}
import collection.GenTraversable
import collection.GenMap
class InspectorShorthandsForEverySucceededSpec extends Spec with Matchers {
  def `every(Set(1, 2, 3)) should succeed when all elements succeeded` {
    every(Set(1, 2, 3)) should be < 4
  }
  def `every(List(1, 2, 3)) should succeed when all elements succeeded` {
    every(List(1, 2, 3)) should be < 4
  }
  def `every(Seq(1, 2, 3)) should succeed when all elements succeeded` {
    every(Seq(1, 2, 3)) should be < 4
  }
  def `every(Array(1, 2, 3)) should succeed when all elements succeeded` {
    every(Array(1, 2, 3)) should be < 4
  }
  def `every(IndexedSeq(1, 2, 3)) should succeed when all elements succeeded` {
    every(IndexedSeq(1, 2, 3)) should be < 4
  }
  def `every(Vector(1, 2, 3)) should succeed when all elements succeeded` {
    every(Vector(1, 2, 3)) should be < 4
  }
  def `every(Set(1, 2, 3).par) should succeed when all elements succeeded` {
    every(Set(1, 2, 3).par) should be < 4
  }
  def `every(List(1, 2, 3).par) should succeed when all elements succeeded` {
    every(List(1, 2, 3).par) should be < 4
  }
  def `every(Seq(1, 2, 3).par) should succeed when all elements succeeded` {
    every(Seq(1, 2, 3).par) should be < 4
  }
  def `every(IndexedSeq(1, 2, 3).par) should succeed when all elements succeeded` {
    every(IndexedSeq(1, 2, 3).par) should be < 4
  }
  def `every(collection.mutable.Set(1, 2, 3)) should succeed when all elements succeeded` {
    every(collection.mutable.Set(1, 2, 3)) should be < 4
  }
  def `every(new collection.mutable.ListBuffer() ++ List(1, 2, 3)) should succeed when all elements succeeded` {
    every(new collection.mutable.ListBuffer() ++ List(1, 2, 3)) should be < 4
  }
  def `every(collection.mutable.Seq(1, 2, 3)) should succeed when all elements succeeded` {
    every(collection.mutable.Seq(1, 2, 3)) should be < 4
  }
  def `every(collection.mutable.IndexedSeq(1, 2, 3)) should succeed when all elements succeeded` {
    every(collection.mutable.IndexedSeq(1, 2, 3)) should be < 4
  }
  def `every(collection.mutable.Set(1, 2, 3).par) should succeed when all elements succeeded` {
    every(collection.mutable.Set(1, 2, 3).par) should be < 4
  }
  def `every((new collection.mutable.ListBuffer() ++ List(1, 2, 3)).par) should succeed when all elements succeeded` {
    every((new collection.mutable.ListBuffer() ++ List(1, 2, 3)).par) should be < 4
  }
  def `every(collection.mutable.Seq(1, 2, 3).par) should succeed when all elements succeeded` {
    every(collection.mutable.Seq(1, 2, 3).par) should be < 4
  }
  def `every(collection.mutable.IndexedSeq(1, 2, 3).par) should succeed when all elements succeeded` {
    every(collection.mutable.IndexedSeq(1, 2, 3).par) should be < 4
  }
}
