package org.scalatest.inspectors.exactly

import org.scalatest._
import SharedHelpers._
import org.scalatest.matchers.{BePropertyMatcher, BePropertyMatchResult, HavePropertyMatcher, HavePropertyMatchResult}
import collection.GenTraversable
import collection.GenMap
class InspectorShorthandsForExactlyFailedSpec2 extends Spec with Matchers {
  class EmptyBePropertyMatcher extends BePropertyMatcher[String] {
    def apply(left: String) = BePropertyMatchResult(left.isEmpty, "empty")
  }
  class StringLengthMatcher(expectedValue: Int) extends HavePropertyMatcher[String, Int] {
    def apply(value: String) = {
      new HavePropertyMatchResult(value.length == expectedValue, "length", expectedValue, value.length)
    }
  }
  val empty = new EmptyBePropertyMatcher()
  def plength(expectedValue: Int) = new StringLengthMatcher(expectedValue)
  val theInstance = "2"
  def arrayToString(xs: GenTraversable[_]): String = xs.toString
  def checkErrorAndCause(e: exceptions.TestFailedException, assertLineNumber: Int, fileName: String, errorMessage: String, causeErrorMessage: String) {
    assert(e.failedCodeFileName == Some(fileName), e.failedCodeFileName + " did not equal " + Some(fileName))
    assert(e.failedCodeLineNumber == Some(assertLineNumber), e.failedCodeLineNumber + " did not equal " + Some(assertLineNumber))
    assert(e.message == Some(errorMessage), e.message + " did not equal " + Some(
  errorMessage))
    e.getCause match {
      case tfe: exceptions.TestFailedException =>
        assert(tfe.failedCodeFileName == Some(fileName), tfe.failedCodeFileName + " did not equal " + Some(fileName))
        assert(tfe.failedCodeLineNumber == Some(assertLineNumber), tfe.failedCodeLineNumber + " did not equal " + Some(assertLineNumber))
        assert(tfe.message == Some(causeErrorMessage), tfe.message + " did not equal " + Some(causeErrorMessage))
        assert(tfe.getCause == null, tfe.getCause + " was not null")
      case other => fail("Expected cause to be TestFailedException, but got: " + other)
    }
  }
  def checkError(e: exceptions.TestFailedException, assertLineNumber: Int, fileName: String, errorMessage: String) {
    assert(e.failedCodeFileName == Some(fileName), e.failedCodeFileName + " did not equal " + Some(fileName))
    assert(e.failedCodeLineNumber == Some(assertLineNumber), e.failedCodeLineNumber + " did not equal " + Some(assertLineNumber))
    assert(e.message == Some(errorMessage), e.message + " did not equal " + Some(
  errorMessage))
  }
  def equal[T](left: T, right: T): Boolean = left == right
  def javaArrayList[T](valueList: List[T]): java.util.ArrayList[T] = {
    val col = new java.util.ArrayList[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaHashSet[T](valueList: List[T]): java.util.HashSet[T] = {
    val col = new java.util.HashSet[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaLinkedList[T](valueList: List[T]): java.util.LinkedList[T] = {
    val col = new java.util.LinkedList[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaStack[T](valueList: List[T]): java.util.Stack[T] = {
    val col = new java.util.Stack[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaTreeSet[T](valueList: List[T]): java.util.TreeSet[T] = {
    val col = new java.util.TreeSet[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaVector[T](valueList: List[T]): java.util.Vector[T] = {
    val col = new java.util.Vector[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaArrayBlockingQueue[T](valueList: List[T], size: Int): java.util.concurrent.ArrayBlockingQueue[T] = {
    val col = new java.util.concurrent.ArrayBlockingQueue[T](size)
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaArrayDeque[T](valueList: List[T]): java.util.ArrayDeque[T] = {
    val col = new java.util.ArrayDeque[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaConcurrentLinkedQueue[T](valueList: List[T]): java.util.concurrent.ConcurrentLinkedQueue[T] = {
    val col = new java.util.concurrent.ConcurrentLinkedQueue[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaConcurrentSkipListSet[T](valueList: List[T]): java.util.concurrent.ConcurrentSkipListSet[T] = {
    val col = new java.util.concurrent.ConcurrentSkipListSet[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaCopyOnWriteArrayList[T](valueList: List[T]): java.util.concurrent.CopyOnWriteArrayList[T] = {
    val col = new java.util.concurrent.CopyOnWriteArrayList[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaCopyOnWriteArraySet[T](valueList: List[T]): java.util.concurrent.CopyOnWriteArraySet[T] = {
    val col = new java.util.concurrent.CopyOnWriteArraySet[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaLinkedBlockingDeque[T](valueList: List[T]): java.util.concurrent.LinkedBlockingDeque[T] = {
    val col = new java.util.concurrent.LinkedBlockingDeque[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaLinkedBlockingQueue[T](valueList: List[T]): java.util.concurrent.LinkedBlockingQueue[T] = {
    val col = new java.util.concurrent.LinkedBlockingQueue[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaLinkedHashSet[T](valueList: List[T]): java.util.LinkedHashSet[T] = {
    val col = new java.util.LinkedHashSet[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaPriorityBlockingQueue[T](valueList: List[T]): java.util.concurrent.PriorityBlockingQueue[T] = {
    val col = new java.util.concurrent.PriorityBlockingQueue[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaPriorityQueue[T](valueList: List[T]): java.util.PriorityQueue[T] = {
    val col = new java.util.PriorityQueue[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaHashMap[K, V](valueMap: Map[K, V]): java.util.HashMap[K, V] = {
    val map = new java.util.HashMap[K, V]()
    for ((key, value) <- valueMap)
      map.put(key, value)
    map
  }
  def javaTreeMap[K, V](valueMap: Map[K, V]): java.util.TreeMap[K, V] = {
    val map = new java.util.TreeMap[K, V]()
    for ((key, value) <- valueMap)
      map.put(key, value)
    map
  }
  def javaHashtable[K, V](valueMap: Map[K, V]): java.util.Hashtable[K, V] = {
    val map = new java.util.Hashtable[K, V]()
    for ((key, value) <- valueMap)
      map.put(key, value)
    map
  }
  def javaConcurrentHashMap[K, V](valueMap: Map[K, V]): java.util.concurrent.ConcurrentHashMap[K, V] = {
    val map = new java.util.concurrent.ConcurrentHashMap[K, V]()
    for ((key, value) <- valueMap)
      map.put(key, value)
    map
  }
  def javaConcurrentSkipListMap[K, V](valueMap: Map[K, V]): java.util.concurrent.ConcurrentSkipListMap[K, V] = {
    val map = new java.util.concurrent.ConcurrentSkipListMap[K, V]()
    for ((key, value) <- valueMap)
      map.put(key, value)
    map
  }
  def javaLinkedHashMap[K, V](valueMap: Map[K, V]): java.util.LinkedHashMap[K, V] = {
    val map = new java.util.LinkedHashMap[K, V]()
    for ((key, value) <- valueMap)
      map.put(key, value)
    map
  }
  def javaWeakHashMap[K, V](valueMap: Map[K, V]): java.util.WeakHashMap[K, V] = {
    val map = new java.util.WeakHashMap[K, V]()
    for ((key, value) <- valueMap)
      map.put(key, value)
    map
  }
  def javaProperties(valueMap: Map[String, String]): java.util.Properties = {
    val map = new java.util.Properties()
    for ((key, value) <- valueMap)
      map.put(key, value)
    map
  }
  def `collection.mutable.IndexedSeq(collection.mutable.IndexedSeq[String]("hi"), collection.mutable.IndexedSeq[String]("boom!"), collection.mutable.IndexedSeq[String]("hello")) should throw TestFailedException with correct stack depth and message when 'traversable should contain' failed` {
    val xs = collection.mutable.IndexedSeq(collection.mutable.IndexedSeq[String]("hi"), collection.mutable.IndexedSeq[String]("boom!"), collection.mutable.IndexedSeq[String]("hello"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain ("hi")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesContainGenTraversable[String](xs, "hi") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain element \"hi\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainGenTraversable[String](itr, xs, "hi")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain element \"hi\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainGenTraversable[String](itr, xs, "hi")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.IndexedSeq(collection.mutable.IndexedSeq[String]("hi"), collection.mutable.IndexedSeq[String]("boom!"), collection.mutable.IndexedSeq[String]("hello")) should throw TestFailedException with correct stack depth and message when 'traversable should not contain' failed` {
    val xs = collection.mutable.IndexedSeq(collection.mutable.IndexedSeq[String]("hi"), collection.mutable.IndexedSeq[String]("boom!"), collection.mutable.IndexedSeq[String]("hello"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain "hi"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesNotContainGenTraversable[String](xs, "hi") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained element \"hi\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainGenTraversable[String](itr, xs, "hi")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Set(collection.mutable.Set[String]("hi").par, collection.mutable.Set[String]("boom!").par, collection.mutable.Set[String]("hello").par).par should throw TestFailedException with correct stack depth and message when 'traversable should have size' failed` {
    val xs = collection.mutable.Set(collection.mutable.Set[String]("hi").par, collection.mutable.Set[String]("boom!").par, collection.mutable.Set[String]("hello").par).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should have size 0
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because no element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} had size {2} instead of expected size 0 (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementSizeNotEqualGenTraversable[String](itr, xs, 0)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} had size {2} instead of expected size 0 (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementSizeNotEqualGenTraversable[String](itr, xs, 0)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} had size {2} instead of expected size 0 (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementSizeNotEqualGenTraversable[String](itr, xs, 0)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Set(collection.mutable.Set[String]("hi").par, collection.mutable.Set[String]("boom!").par, collection.mutable.Set[String]("hello").par).par should throw TestFailedException with correct stack depth and message when 'traversable should not have size' failed` {
    val xs = collection.mutable.Set(collection.mutable.Set[String]("hi").par, collection.mutable.Set[String]("boom!").par, collection.mutable.Set[String]("hello").par).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not have size (1)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because no element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} had size 1 (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementSizeEqualGenTraversable[String](itr, xs, 1)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} had size 1 (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementSizeEqualGenTraversable[String](itr, xs, 1)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} had size 1 (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementSizeEqualGenTraversable[String](itr, xs, 1)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Set(collection.mutable.Set[String]("hi").par, collection.mutable.Set[String]("boom!").par, collection.mutable.Set[String]("hello").par).par should throw TestFailedException with correct stack depth and message when 'traversable should contain' failed` {
    val xs = collection.mutable.Set(collection.mutable.Set[String]("hi").par, collection.mutable.Set[String]("boom!").par, collection.mutable.Set[String]("hello").par).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain ("hi")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesContainGenTraversable[String](xs, "hi") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain element \"hi\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainGenTraversable[String](itr, xs, "hi")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain element \"hi\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainGenTraversable[String](itr, xs, "hi")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Set(collection.mutable.Set[String]("hi").par, collection.mutable.Set[String]("boom!").par, collection.mutable.Set[String]("hello").par).par should throw TestFailedException with correct stack depth and message when 'traversable should not contain' failed` {
    val xs = collection.mutable.Set(collection.mutable.Set[String]("hi").par, collection.mutable.Set[String]("boom!").par, collection.mutable.Set[String]("hello").par).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain "hi"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesNotContainGenTraversable[String](xs, "hi") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained element \"hi\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainGenTraversable[String](itr, xs, "hi")) + " \n" + 
  "in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List((new collection.mutable.ListBuffer[String]() ++ List[String]("hi")).par, (new collection.mutable.ListBuffer[String]() ++ List[String]("boom!")).par, (new collection.mutable.ListBuffer[String]() ++ List[String]("hello")).par)).par should throw TestFailedException with correct stack depth and message when 'traversable should have size' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List((new collection.mutable.ListBuffer[String]() ++ List[String]("hi")).par, (new collection.mutable.ListBuffer[String]() ++ List[String]("boom!")).par, (new collection.mutable.ListBuffer[String]() ++ List[String]("hello")).par)).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should have size 0
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because no element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} had size {2} instead of expected size 0 (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementSizeNotEqualGenTraversable[String](itr, xs, 0)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} had size {2} instead of expected size 0 (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementSizeNotEqualGenTraversable[String](itr, xs, 0)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} had size {2} instead of expected size 0 (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementSizeNotEqualGenTraversable[String](itr, xs, 0)) + " \n" + 
  "in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List((new collection.mutable.ListBuffer[String]() ++ List[String]("hi")).par, (new collection.mutable.ListBuffer[String]() ++ List[String]("boom!")).par, (new collection.mutable.ListBuffer[String]() ++ List[String]("hello")).par)).par should throw TestFailedException with correct stack depth and message when 'traversable should not have size' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List((new collection.mutable.ListBuffer[String]() ++ List[String]("hi")).par, (new collection.mutable.ListBuffer[String]() ++ List[String]("boom!")).par, (new collection.mutable.ListBuffer[String]() ++ List[String]("hello")).par)).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not have size (1)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because no element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} had size 1 (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementSizeEqualGenTraversable[String](itr, xs, 1)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} had size 1 (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementSizeEqualGenTraversable[String](itr, xs, 1)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} had size 1 (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementSizeEqualGenTraversable[String](itr, xs, 1)) + " \n" + 
  "in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List((new collection.mutable.ListBuffer[String]() ++ List[String]("hi")).par, (new collection.mutable.ListBuffer[String]() ++ List[String]("boom!")).par, (new collection.mutable.ListBuffer[String]() ++ List[String]("hello")).par)).par should throw TestFailedException with correct stack depth and message when 'traversable should have length' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List((new collection.mutable.ListBuffer[String]() ++ List[String]("hi")).par, (new collection.mutable.ListBuffer[String]() ++ List[String]("boom!")).par, (new collection.mutable.ListBuffer[String]() ++ List[String]("hello")).par)).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should have length 0
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because no element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} had length {2} instead of expected length 0 (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementSizeNotEqualGenTraversable[String](itr, xs, 0)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} had length {2} instead of expected length 0 (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementSizeNotEqualGenTraversable[String](itr, xs, 0)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} had length {2} instead of expected length 0 (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementSizeNotEqualGenTraversable[String](itr, xs, 0)) + " \n" + 
  "in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List((new collection.mutable.ListBuffer[String]() ++ List[String]("hi")).par, (new collection.mutable.ListBuffer[String]() ++ List[String]("boom!")).par, (new collection.mutable.ListBuffer[String]() ++ List[String]("hello")).par)).par should throw TestFailedException with correct stack depth and message when 'traversable should not have length' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List((new collection.mutable.ListBuffer[String]() ++ List[String]("hi")).par, (new collection.mutable.ListBuffer[String]() ++ List[String]("boom!")).par, (new collection.mutable.ListBuffer[String]() ++ List[String]("hello")).par)).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not have length (1)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because no element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} had length 1 (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementSizeEqualGenTraversable[String](itr, xs, 1)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} had length 1 (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementSizeEqualGenTraversable[String](itr, xs, 1)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} had length 1 (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementSizeEqualGenTraversable[String](itr, xs, 1)) + " \n" + 
  "in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List((new collection.mutable.ListBuffer[String]() ++ List[String]("hi")).par, (new collection.mutable.ListBuffer[String]() ++ List[String]("boom!")).par, (new collection.mutable.ListBuffer[String]() ++ List[String]("hello")).par)).par should throw TestFailedException with correct stack depth and message when 'traversable should contain' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List((new collection.mutable.ListBuffer[String]() ++ List[String]("hi")).par, (new collection.mutable.ListBuffer[String]() ++ List[String]("boom!")).par, (new collection.mutable.ListBuffer[String]() ++ List[String]("hello")).par)).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain ("hi")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesContainGenTraversable[String](xs, "hi") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain element \"hi\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainGenTraversable[String](itr, xs, "hi")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain element \"hi\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainGenTraversable[String](itr, xs, "hi")) + " \n" + 
  "in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List((new collection.mutable.ListBuffer[String]() ++ List[String]("hi")).par, (new collection.mutable.ListBuffer[String]() ++ List[String]("boom!")).par, (new collection.mutable.ListBuffer[String]() ++ List[String]("hello")).par)).par should throw TestFailedException with correct stack depth and message when 'traversable should not contain' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List((new collection.mutable.ListBuffer[String]() ++ List[String]("hi")).par, (new collection.mutable.ListBuffer[String]() ++ List[String]("boom!")).par, (new collection.mutable.ListBuffer[String]() ++ List[String]("hello")).par)).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain "hi"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesNotContainGenTraversable[String](xs, "hi") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained element \"hi\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainGenTraversable[String](itr, xs, "hi")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Seq(collection.mutable.Seq[String]("hi").par, collection.mutable.Seq[String]("boom!").par, collection.mutable.Seq[String]("hello").par).par should throw TestFailedException with correct stack depth and message when 'traversable should have size' failed` {
    val xs = collection.mutable.Seq(collection.mutable.Seq[String]("hi").par, collection.mutable.Seq[String]("boom!").par, collection.mutable.Seq[String]("hello").par).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should have size 0
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because no element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} had size {2} instead of expected size 0 (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementSizeNotEqualGenTraversable[String](itr, xs, 0)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} had size {2} instead of expected size 0 (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementSizeNotEqualGenTraversable[String](itr, xs, 0)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} had size {2} instead of expected size 0 (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementSizeNotEqualGenTraversable[String](itr, xs, 0)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Seq(collection.mutable.Seq[String]("hi").par, collection.mutable.Seq[String]("boom!").par, collection.mutable.Seq[String]("hello").par).par should throw TestFailedException with correct stack depth and message when 'traversable should not have size' failed` {
    val xs = collection.mutable.Seq(collection.mutable.Seq[String]("hi").par, collection.mutable.Seq[String]("boom!").par, collection.mutable.Seq[String]("hello").par).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not have size (1)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because no element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} had size 1 (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementSizeEqualGenTraversable[String](itr, xs, 1)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} had size 1 (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementSizeEqualGenTraversable[String](itr, xs, 1)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} had size 1 (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementSizeEqualGenTraversable[String](itr, xs, 1)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Seq(collection.mutable.Seq[String]("hi").par, collection.mutable.Seq[String]("boom!").par, collection.mutable.Seq[String]("hello").par).par should throw TestFailedException with correct stack depth and message when 'traversable should have length' failed` {
    val xs = collection.mutable.Seq(collection.mutable.Seq[String]("hi").par, collection.mutable.Seq[String]("boom!").par, collection.mutable.Seq[String]("hello").par).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should have length 0
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because no element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} had length {2} instead of expected length 0 (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementSizeNotEqualGenTraversable[String](itr, xs, 0)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} had length {2} instead of expected length 0 (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementSizeNotEqualGenTraversable[String](itr, xs, 0)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} had length {2} instead of expected length 0 (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementSizeNotEqualGenTraversable[String](itr, xs, 0)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Seq(collection.mutable.Seq[String]("hi").par, collection.mutable.Seq[String]("boom!").par, collection.mutable.Seq[String]("hello").par).par should throw TestFailedException with correct stack depth and message when 'traversable should not have length' failed` {
    val xs = collection.mutable.Seq(collection.mutable.Seq[String]("hi").par, collection.mutable.Seq[String]("boom!").par, collection.mutable.Seq[String]("hello").par).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not have length (1)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because no element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} had length 1 (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementSizeEqualGenTraversable[String](itr, xs, 1)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} had length 1 (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementSizeEqualGenTraversable[String](itr, xs, 1)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} had length 1 (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementSizeEqualGenTraversable[String](itr, xs, 1)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Seq(collection.mutable.Seq[String]("hi").par, collection.mutable.Seq[String]("boom!").par, collection.mutable.Seq[String]("hello").par).par should throw TestFailedException with correct stack depth and message when 'traversable should contain' failed` {
    val xs = collection.mutable.Seq(collection.mutable.Seq[String]("hi").par, collection.mutable.Seq[String]("boom!").par, collection.mutable.Seq[String]("hello").par).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain ("hi")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesContainGenTraversable[String](xs, "hi") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain element \"hi\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainGenTraversable[String](itr, xs, "hi")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain element \"hi\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainGenTraversable[String](itr, xs, "hi")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Seq(collection.mutable.Seq[String]("hi").par, collection.mutable.Seq[String]("boom!").par, collection.mutable.Seq[String]("hello").par).par should throw TestFailedException with correct stack depth and message when 'traversable should not contain' failed` {
    val xs = collection.mutable.Seq(collection.mutable.Seq[String]("hi").par, collection.mutable.Seq[String]("boom!").par, collection.mutable.Seq[String]("hello").par).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain "hi"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesNotContainGenTraversable[String](xs, "hi") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained element \"hi\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainGenTraversable[String](itr, xs, "hi")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.IndexedSeq(collection.mutable.IndexedSeq[String]("hi").par, collection.mutable.IndexedSeq[String]("boom!").par, collection.mutable.IndexedSeq[String]("hello").par).par should throw TestFailedException with correct stack depth and message when 'traversable should have size' failed` {
    val xs = collection.mutable.IndexedSeq(collection.mutable.IndexedSeq[String]("hi").par, collection.mutable.IndexedSeq[String]("boom!").par, collection.mutable.IndexedSeq[String]("hello").par).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should have size 0
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because no element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} had size {2} instead of expected size 0 (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementSizeNotEqualGenTraversable[String](itr, xs, 0)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} had size {2} instead of expected size 0 (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementSizeNotEqualGenTraversable[String](itr, xs, 0)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} had size {2} instead of expected size 0 (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementSizeNotEqualGenTraversable[String](itr, xs, 0)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.IndexedSeq(collection.mutable.IndexedSeq[String]("hi").par, collection.mutable.IndexedSeq[String]("boom!").par, collection.mutable.IndexedSeq[String]("hello").par).par should throw TestFailedException with correct stack depth and message when 'traversable should not have size' failed` {
    val xs = collection.mutable.IndexedSeq(collection.mutable.IndexedSeq[String]("hi").par, collection.mutable.IndexedSeq[String]("boom!").par, collection.mutable.IndexedSeq[String]("hello").par).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not have size (1)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because no element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} had size 1 (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementSizeEqualGenTraversable[String](itr, xs, 1)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} had size 1 (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementSizeEqualGenTraversable[String](itr, xs, 1)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} had size 1 (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementSizeEqualGenTraversable[String](itr, xs, 1)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.IndexedSeq(collection.mutable.IndexedSeq[String]("hi").par, collection.mutable.IndexedSeq[String]("boom!").par, collection.mutable.IndexedSeq[String]("hello").par).par should throw TestFailedException with correct stack depth and message when 'traversable should have length' failed` {
    val xs = collection.mutable.IndexedSeq(collection.mutable.IndexedSeq[String]("hi").par, collection.mutable.IndexedSeq[String]("boom!").par, collection.mutable.IndexedSeq[String]("hello").par).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should have length 0
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because no element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} had length {2} instead of expected length 0 (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementSizeNotEqualGenTraversable[String](itr, xs, 0)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} had length {2} instead of expected length 0 (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementSizeNotEqualGenTraversable[String](itr, xs, 0)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} had length {2} instead of expected length 0 (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementSizeNotEqualGenTraversable[String](itr, xs, 0)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.IndexedSeq(collection.mutable.IndexedSeq[String]("hi").par, collection.mutable.IndexedSeq[String]("boom!").par, collection.mutable.IndexedSeq[String]("hello").par).par should throw TestFailedException with correct stack depth and message when 'traversable should not have length' failed` {
    val xs = collection.mutable.IndexedSeq(collection.mutable.IndexedSeq[String]("hi").par, collection.mutable.IndexedSeq[String]("boom!").par, collection.mutable.IndexedSeq[String]("hello").par).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not have length (1)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because no element satisfied the assertion block: \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} had length 1 (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementSizeEqualGenTraversable[String](itr, xs, 1)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} had length 1 (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementSizeEqualGenTraversable[String](itr, xs, 1)) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} had length 1 (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementSizeEqualGenTraversable[String](itr, xs, 1)) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.IndexedSeq(collection.mutable.IndexedSeq[String]("hi").par, collection.mutable.IndexedSeq[String]("boom!").par, collection.mutable.IndexedSeq[String]("hello").par).par should throw TestFailedException with correct stack depth and message when 'traversable should contain' failed` {
    val xs = collection.mutable.IndexedSeq(collection.mutable.IndexedSeq[String]("hi").par, collection.mutable.IndexedSeq[String]("boom!").par, collection.mutable.IndexedSeq[String]("hello").par).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain ("hi")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesContainGenTraversable[String](xs, "hi") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain element \"hi\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainGenTraversable[String](itr, xs, "hi")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain element \"hi\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainGenTraversable[String](itr, xs, "hi")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.IndexedSeq(collection.mutable.IndexedSeq[String]("hi").par, collection.mutable.IndexedSeq[String]("boom!").par, collection.mutable.IndexedSeq[String]("hello").par).par should throw TestFailedException with correct stack depth and message when 'traversable should not contain' failed` {
    val xs = collection.mutable.IndexedSeq(collection.mutable.IndexedSeq[String]("hi").par, collection.mutable.IndexedSeq[String]("boom!").par, collection.mutable.IndexedSeq[String]("hello").par).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain "hi"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesNotContainGenTraversable[String](xs, "hi") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained element \"hi\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainGenTraversable[String](itr, xs, "hi")) + " \n" + 
  "in " + xs)
  }
  def `Set(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = Set(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `Set(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = Set(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `Set(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = Set(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `Set(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = Set(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `List(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = List(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `List(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = List(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `List(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = List(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `List(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = List(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `Seq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = Seq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `Seq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = Seq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `Seq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = Seq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `Seq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = Seq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `Array(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = Array(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + arrayToString(xs))
  }
  def `Array(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = Array(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + arrayToString(xs))
  }
  def `Array(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = Array(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + arrayToString(xs))
  }
  def `Array(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = Array(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + arrayToString(xs))
  }
  def `IndexedSeq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = IndexedSeq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `IndexedSeq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = IndexedSeq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `IndexedSeq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = IndexedSeq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `IndexedSeq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = IndexedSeq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `Vector(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = Vector(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `Vector(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = Vector(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `Vector(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = Vector(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `Vector(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = Vector(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `Set(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = Set(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `Set(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = Set(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `Set(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = Set(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `Set(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = Set(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `List(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = List(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `List(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = List(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `List(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = List(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `List(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = List(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `Seq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = Seq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `Seq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = Seq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `Seq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = Seq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `Seq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = Seq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `IndexedSeq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = IndexedSeq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `IndexedSeq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = IndexedSeq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `IndexedSeq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = IndexedSeq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `IndexedSeq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = IndexedSeq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Set(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = collection.mutable.Set(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Set(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = collection.mutable.Set(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Set(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = collection.mutable.Set(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Set(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = collection.mutable.Set(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Seq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = collection.mutable.Seq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Seq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = collection.mutable.Seq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Seq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = collection.mutable.Seq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Seq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = collection.mutable.Seq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.IndexedSeq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = collection.mutable.IndexedSeq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.IndexedSeq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = collection.mutable.IndexedSeq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.IndexedSeq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = collection.mutable.IndexedSeq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.IndexedSeq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = collection.mutable.IndexedSeq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Set(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = collection.mutable.Set(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Set(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = collection.mutable.Set(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Set(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = collection.mutable.Set(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Set(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = collection.mutable.Set(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"))).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"))).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"))).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"))).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"))).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"))).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"))).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight"))).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Seq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = collection.mutable.Seq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Seq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = collection.mutable.Seq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Seq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = collection.mutable.Seq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Seq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = collection.mutable.Seq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.IndexedSeq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = collection.mutable.IndexedSeq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.IndexedSeq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = collection.mutable.IndexedSeq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.IndexedSeq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = collection.mutable.IndexedSeq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.IndexedSeq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = collection.mutable.IndexedSeq(Map("1" -> "one", "2" -> "two", "3" -> "three"), Map("4" -> "four", "5" -> "five", "6" -> "six"), Map("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `Set(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = Set(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `Set(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = Set(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `Set(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = Set(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `Set(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = Set(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `List(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = List(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `List(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = List(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `List(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = List(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `List(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = List(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `Seq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = Seq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `Seq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = Seq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `Seq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = Seq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `Seq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = Seq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `Array(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = Array(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + arrayToString(xs))
  }
  def `Array(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = Array(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + arrayToString(xs))
  }
  def `Array(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = Array(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + arrayToString(xs))
  }
  def `Array(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = Array(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + arrayToString(xs))
  }
  def `IndexedSeq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = IndexedSeq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `IndexedSeq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = IndexedSeq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `IndexedSeq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = IndexedSeq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `IndexedSeq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = IndexedSeq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `Vector(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = Vector(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `Vector(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = Vector(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `Vector(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = Vector(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `Vector(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = Vector(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `Set(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = Set(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `Set(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = Set(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `Set(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = Set(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `Set(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = Set(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `List(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = List(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `List(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = List(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `List(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = List(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `List(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = List(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `Seq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = Seq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `Seq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = Seq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `Seq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = Seq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `Seq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = Seq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `IndexedSeq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = IndexedSeq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `IndexedSeq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = IndexedSeq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `IndexedSeq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = IndexedSeq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `IndexedSeq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = IndexedSeq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Set(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = collection.mutable.Set(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Set(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = collection.mutable.Set(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Set(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = collection.mutable.Set(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Set(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = collection.mutable.Set(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Seq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = collection.mutable.Seq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Seq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = collection.mutable.Seq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Seq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = collection.mutable.Seq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Seq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = collection.mutable.Seq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.IndexedSeq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = collection.mutable.IndexedSeq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.IndexedSeq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = collection.mutable.IndexedSeq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.IndexedSeq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = collection.mutable.IndexedSeq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.IndexedSeq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = collection.mutable.IndexedSeq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Set(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = collection.mutable.Set(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Set(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = collection.mutable.Set(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Set(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = collection.mutable.Set(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Set(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = collection.mutable.Set(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"))).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"))).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"))).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"))).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"))).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"))).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"))).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight"))).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Seq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = collection.mutable.Seq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Seq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = collection.mutable.Seq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Seq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = collection.mutable.Seq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Seq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = collection.mutable.Seq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.IndexedSeq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = collection.mutable.IndexedSeq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.IndexedSeq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = collection.mutable.IndexedSeq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.IndexedSeq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = collection.mutable.IndexedSeq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.IndexedSeq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = collection.mutable.IndexedSeq(collection.mutable.Map("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.Map("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.Map("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `Set(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = Set(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `Set(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = Set(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `Set(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = Set(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `Set(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = Set(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `List(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = List(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `List(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = List(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `List(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = List(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `List(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = List(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `Seq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = Seq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `Seq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = Seq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `Seq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = Seq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `Seq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = Seq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `Array(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = Array(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + arrayToString(xs))
  }
  def `Array(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = Array(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + arrayToString(xs))
  }
  def `Array(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = Array(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + arrayToString(xs))
  }
  def `Array(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = Array(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + arrayToString(xs))
  }
  def `IndexedSeq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = IndexedSeq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `IndexedSeq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = IndexedSeq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `IndexedSeq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = IndexedSeq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `IndexedSeq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = IndexedSeq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `Vector(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = Vector(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `Vector(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = Vector(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `Vector(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = Vector(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `Vector(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = Vector(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `Set(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = Set(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `Set(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = Set(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `Set(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = Set(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `Set(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = Set(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `List(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = List(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `List(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = List(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `List(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = List(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `List(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = List(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `Seq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = Seq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `Seq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = Seq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `Seq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = Seq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `Seq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = Seq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `IndexedSeq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = IndexedSeq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `IndexedSeq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = IndexedSeq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `IndexedSeq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = IndexedSeq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `IndexedSeq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = IndexedSeq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Set(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = collection.mutable.Set(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Set(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = collection.mutable.Set(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Set(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = collection.mutable.Set(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Set(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = collection.mutable.Set(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Seq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = collection.mutable.Seq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Seq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = collection.mutable.Seq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Seq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = collection.mutable.Seq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Seq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = collection.mutable.Seq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.IndexedSeq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = collection.mutable.IndexedSeq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.IndexedSeq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = collection.mutable.IndexedSeq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.IndexedSeq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = collection.mutable.IndexedSeq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.IndexedSeq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = collection.mutable.IndexedSeq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Set(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = collection.mutable.Set(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Set(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = collection.mutable.Set(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Set(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = collection.mutable.Set(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Set(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = collection.mutable.Set(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Seq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = collection.mutable.Seq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Seq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = collection.mutable.Seq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Seq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = collection.mutable.Seq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Seq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = collection.mutable.Seq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.IndexedSeq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = collection.mutable.IndexedSeq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.IndexedSeq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = collection.mutable.IndexedSeq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.IndexedSeq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = collection.mutable.IndexedSeq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.IndexedSeq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = collection.mutable.IndexedSeq(collection.immutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `Set(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = Set(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `Set(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = Set(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `Set(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = Set(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `Set(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = Set(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `List(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = List(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `List(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = List(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `List(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = List(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `List(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = List(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `Seq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = Seq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `Seq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = Seq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `Seq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = Seq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `Seq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = Seq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `Array(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = Array(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + arrayToString(xs))
  }
  def `Array(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = Array(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + arrayToString(xs))
  }
  def `Array(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = Array(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + arrayToString(xs))
  }
  def `Array(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = Array(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + arrayToString(xs))
  }
  def `IndexedSeq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = IndexedSeq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `IndexedSeq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = IndexedSeq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `IndexedSeq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = IndexedSeq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `IndexedSeq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = IndexedSeq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `Vector(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = Vector(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `Vector(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = Vector(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `Vector(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = Vector(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `Vector(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = Vector(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `Set(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = Set(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `Set(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = Set(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `Set(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = Set(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `Set(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = Set(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `List(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = List(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `List(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = List(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `List(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = List(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `List(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = List(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `Seq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = Seq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `Seq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = Seq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `Seq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = Seq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `Seq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = Seq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `IndexedSeq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = IndexedSeq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `IndexedSeq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = IndexedSeq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `IndexedSeq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = IndexedSeq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `IndexedSeq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = IndexedSeq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Set(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = collection.mutable.Set(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Set(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = collection.mutable.Set(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Set(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = collection.mutable.Set(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Set(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = collection.mutable.Set(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Seq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = collection.mutable.Seq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Seq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = collection.mutable.Seq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Seq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = collection.mutable.Seq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Seq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = collection.mutable.Seq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.IndexedSeq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = collection.mutable.IndexedSeq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.IndexedSeq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = collection.mutable.IndexedSeq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.IndexedSeq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = collection.mutable.IndexedSeq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.IndexedSeq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = collection.mutable.IndexedSeq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Set(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = collection.mutable.Set(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Set(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = collection.mutable.Set(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Set(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = collection.mutable.Set(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Set(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = collection.mutable.Set(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight"))).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Seq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = collection.mutable.Seq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Seq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = collection.mutable.Seq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Seq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = collection.mutable.Seq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Seq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = collection.mutable.Seq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.IndexedSeq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = collection.mutable.IndexedSeq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.IndexedSeq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = collection.mutable.IndexedSeq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.IndexedSeq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = collection.mutable.IndexedSeq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.IndexedSeq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = collection.mutable.IndexedSeq(collection.mutable.HashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.HashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.HashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `Set(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = Set(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `Set(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = Set(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `Set(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = Set(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `Set(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = Set(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `List(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = List(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `List(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = List(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `List(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = List(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `List(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = List(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `Seq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = Seq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `Seq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = Seq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `Seq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = Seq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `Seq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = Seq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `Array(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = Array(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + arrayToString(xs))
  }
  def `Array(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = Array(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + arrayToString(xs))
  }
  def `Array(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = Array(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + arrayToString(xs))
  }
  def `Array(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = Array(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + arrayToString(xs))
  }
  def `IndexedSeq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = IndexedSeq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `IndexedSeq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = IndexedSeq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `IndexedSeq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = IndexedSeq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `IndexedSeq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = IndexedSeq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `Vector(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = Vector(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `Vector(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = Vector(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `Vector(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = Vector(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `Vector(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = Vector(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `Set(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = Set(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `Set(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = Set(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `Set(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = Set(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `Set(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = Set(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `List(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = List(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `List(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = List(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `List(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = List(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `List(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = List(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `Seq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = Seq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `Seq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = Seq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `Seq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = Seq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `Seq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = Seq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `IndexedSeq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = IndexedSeq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `IndexedSeq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = IndexedSeq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `IndexedSeq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = IndexedSeq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `IndexedSeq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = IndexedSeq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Set(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = collection.mutable.Set(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Set(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = collection.mutable.Set(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Set(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = collection.mutable.Set(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Set(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = collection.mutable.Set(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Seq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = collection.mutable.Seq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Seq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = collection.mutable.Seq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Seq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = collection.mutable.Seq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Seq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = collection.mutable.Seq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.IndexedSeq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = collection.mutable.IndexedSeq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.IndexedSeq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = collection.mutable.IndexedSeq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.IndexedSeq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = collection.mutable.IndexedSeq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.IndexedSeq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = collection.mutable.IndexedSeq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Set(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = collection.mutable.Set(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Set(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = collection.mutable.Set(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Set(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = collection.mutable.Set(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Set(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = collection.mutable.Set(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight"))).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight"))).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight"))).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight"))).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight"))).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight"))).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight"))).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight"))).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Seq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = collection.mutable.Seq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Seq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = collection.mutable.Seq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Seq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = collection.mutable.Seq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Seq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = collection.mutable.Seq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.IndexedSeq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = collection.mutable.IndexedSeq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.IndexedSeq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = collection.mutable.IndexedSeq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.IndexedSeq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = collection.mutable.IndexedSeq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.IndexedSeq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = collection.mutable.IndexedSeq(collection.mutable.LinkedHashMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.LinkedHashMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.LinkedHashMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `Set(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = Set(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `Set(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = Set(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `Set(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = Set(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `Set(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = Set(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `List(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = List(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `List(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = List(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `List(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = List(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `List(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = List(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `Seq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = Seq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `Seq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = Seq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `Seq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = Seq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `Seq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = Seq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `Array(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = Array(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + arrayToString(xs))
  }
  def `Array(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = Array(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + arrayToString(xs))
  }
  def `Array(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = Array(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + arrayToString(xs))
  }
  def `Array(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = Array(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + arrayToString(xs))
  }
  def `IndexedSeq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = IndexedSeq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `IndexedSeq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = IndexedSeq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `IndexedSeq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = IndexedSeq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `IndexedSeq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = IndexedSeq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `Vector(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = Vector(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `Vector(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = Vector(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `Vector(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = Vector(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `Vector(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = Vector(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `Set(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = Set(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `Set(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = Set(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `Set(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = Set(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `Set(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = Set(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `List(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = List(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `List(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = List(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `List(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = List(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `List(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = List(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `Seq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = Seq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `Seq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = Seq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `Seq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = Seq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `Seq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = Seq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `IndexedSeq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = IndexedSeq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `IndexedSeq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = IndexedSeq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `IndexedSeq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = IndexedSeq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `IndexedSeq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = IndexedSeq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Set(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = collection.mutable.Set(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Set(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = collection.mutable.Set(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Set(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = collection.mutable.Set(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Set(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = collection.mutable.Set(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Seq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = collection.mutable.Seq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Seq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = collection.mutable.Seq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Seq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = collection.mutable.Seq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Seq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = collection.mutable.Seq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.IndexedSeq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = collection.mutable.IndexedSeq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.IndexedSeq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = collection.mutable.IndexedSeq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.IndexedSeq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = collection.mutable.IndexedSeq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.IndexedSeq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = collection.mutable.IndexedSeq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Set(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = collection.mutable.Set(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Set(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = collection.mutable.Set(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Set(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = collection.mutable.Set(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Set(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = collection.mutable.Set(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Seq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = collection.mutable.Seq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Seq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = collection.mutable.Seq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Seq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = collection.mutable.Seq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Seq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = collection.mutable.Seq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.IndexedSeq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = collection.mutable.IndexedSeq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.IndexedSeq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = collection.mutable.IndexedSeq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.IndexedSeq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = collection.mutable.IndexedSeq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.IndexedSeq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = collection.mutable.IndexedSeq(collection.immutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.immutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.immutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `Set(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = Set(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `Set(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = Set(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `Set(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = Set(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `Set(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = Set(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `List(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = List(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `List(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = List(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `List(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = List(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `List(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = List(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `Seq(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = Seq(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `Seq(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = Seq(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `Seq(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = Seq(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `Seq(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = Seq(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `Array(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = Array(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + arrayToString(xs))
  }
  def `Array(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = Array(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + arrayToString(xs))
  }
  def `Array(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = Array(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + arrayToString(xs))
  }
  def `Array(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = Array(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + arrayToString(xs))
  }
  def `IndexedSeq(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = IndexedSeq(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `IndexedSeq(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = IndexedSeq(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `IndexedSeq(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = IndexedSeq(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `IndexedSeq(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = IndexedSeq(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `Vector(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = Vector(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `Vector(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = Vector(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `Vector(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = Vector(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `Vector(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = Vector(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `Set(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = Set(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `Set(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = Set(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `Set(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = Set(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `Set(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = Set(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `List(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = List(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `List(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = List(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `List(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = List(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `List(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = List(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `Seq(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = Seq(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `Seq(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = Seq(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `Seq(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = Seq(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `Seq(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = Seq(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `IndexedSeq(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = IndexedSeq(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `IndexedSeq(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = IndexedSeq(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `IndexedSeq(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = IndexedSeq(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `IndexedSeq(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = IndexedSeq(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Set(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain key' failed` {
    val xs = collection.mutable.Set(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain key "2"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Set(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain key' failed` {
    val xs = collection.mutable.Set(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain key ("2")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainKey[String, String](xs, "2") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained key \"2\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainKey[String, String](itr, xs, "2")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Set(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should contain value' failed` {
    val xs = collection.mutable.Set(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should contain value "two"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 2 elements satisfied the assertion block at " + succeededIndexesContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} did not contain value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementNotContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
  def `collection.mutable.Set(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight")) should throw TestFailedException with correct stack depth and message when 'map should not contain value' failed` {
    val xs = collection.mutable.Set(collection.mutable.ListMap("1" -> "one", "2" -> "two", "3" -> "three"), collection.mutable.ListMap("4" -> "four", "5" -> "five", "6" -> "six"), collection.mutable.ListMap("2" -> "two", "6" -> "six", "8" -> "eight"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      exactly(3, xs) should not contain value ("two")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForExactlyFailedSpec2.scala", "'exactly(3)' inspection failed, because only 1 element satisfied the assertion block at " + succeededIndexesNotContainValue[String, String](xs, "two") + ": \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + ", \n" + 
  "  " + new java.text.MessageFormat("at index {0}, {1} contained value \"two\" (InspectorShorthandsForExactlyFailedSpec2.scala:" + assertLineNumber + ")").format(indexElementContainValue[String, String](itr, xs, "two")) + " \n" + 
  "in " + xs)
  }
}
