package org.scalatest.inspectors.exactly

import org.scalatest._
import SharedHelpers._
import org.scalatest.matchers.{BePropertyMatcher, BePropertyMatchResult, HavePropertyMatcher, HavePropertyMatchResult}
import collection.GenTraversable
import collection.GenMap
class InspectorShorthandsForExactlySucceededSpec extends Spec with Matchers {
  def `atLeast(2, Set(1, 2, 3)) should succeed when elements succeeded count is exactly the same as specified` {
    exactly(3, Set(1, 2, 3)) should be < 4
  }
  def `atLeast(2, List(1, 2, 3)) should succeed when elements succeeded count is exactly the same as specified` {
    exactly(3, List(1, 2, 3)) should be < 4
  }
  def `atLeast(2, Seq(1, 2, 3)) should succeed when elements succeeded count is exactly the same as specified` {
    exactly(3, Seq(1, 2, 3)) should be < 4
  }
  def `atLeast(2, Array(1, 2, 3)) should succeed when elements succeeded count is exactly the same as specified` {
    exactly(3, Array(1, 2, 3)) should be < 4
  }
  def `atLeast(2, IndexedSeq(1, 2, 3)) should succeed when elements succeeded count is exactly the same as specified` {
    exactly(3, IndexedSeq(1, 2, 3)) should be < 4
  }
  def `atLeast(2, Vector(1, 2, 3)) should succeed when elements succeeded count is exactly the same as specified` {
    exactly(3, Vector(1, 2, 3)) should be < 4
  }
  def `atLeast(2, Set(1, 2, 3).par) should succeed when elements succeeded count is exactly the same as specified` {
    exactly(3, Set(1, 2, 3).par) should be < 4
  }
  def `atLeast(2, List(1, 2, 3).par) should succeed when elements succeeded count is exactly the same as specified` {
    exactly(3, List(1, 2, 3).par) should be < 4
  }
  def `atLeast(2, Seq(1, 2, 3).par) should succeed when elements succeeded count is exactly the same as specified` {
    exactly(3, Seq(1, 2, 3).par) should be < 4
  }
  def `atLeast(2, IndexedSeq(1, 2, 3).par) should succeed when elements succeeded count is exactly the same as specified` {
    exactly(3, IndexedSeq(1, 2, 3).par) should be < 4
  }
  def `atLeast(2, collection.mutable.Set(1, 2, 3)) should succeed when elements succeeded count is exactly the same as specified` {
    exactly(3, collection.mutable.Set(1, 2, 3)) should be < 4
  }
  def `atLeast(2, new collection.mutable.ListBuffer() ++ List(1, 2, 3)) should succeed when elements succeeded count is exactly the same as specified` {
    exactly(3, new collection.mutable.ListBuffer() ++ List(1, 2, 3)) should be < 4
  }
  def `atLeast(2, collection.mutable.Seq(1, 2, 3)) should succeed when elements succeeded count is exactly the same as specified` {
    exactly(3, collection.mutable.Seq(1, 2, 3)) should be < 4
  }
  def `atLeast(2, collection.mutable.IndexedSeq(1, 2, 3)) should succeed when elements succeeded count is exactly the same as specified` {
    exactly(3, collection.mutable.IndexedSeq(1, 2, 3)) should be < 4
  }
  def `atLeast(2, collection.mutable.Set(1, 2, 3).par) should succeed when elements succeeded count is exactly the same as specified` {
    exactly(3, collection.mutable.Set(1, 2, 3).par) should be < 4
  }
  def `atLeast(2, (new collection.mutable.ListBuffer() ++ List(1, 2, 3)).par) should succeed when elements succeeded count is exactly the same as specified` {
    exactly(3, (new collection.mutable.ListBuffer() ++ List(1, 2, 3)).par) should be < 4
  }
  def `atLeast(2, collection.mutable.Seq(1, 2, 3).par) should succeed when elements succeeded count is exactly the same as specified` {
    exactly(3, collection.mutable.Seq(1, 2, 3).par) should be < 4
  }
  def `atLeast(2, collection.mutable.IndexedSeq(1, 2, 3).par) should succeed when elements succeeded count is exactly the same as specified` {
    exactly(3, collection.mutable.IndexedSeq(1, 2, 3).par) should be < 4
  }
}
