package org.scalatest.inspectors.nested

import org.scalatest._
import SharedHelpers._
import collection.GenTraversable
class NestedInspectorsSpec extends Spec with Inspectors {
  def `forAll and forAll should nest without problem` {
    forAll(List(List(2, 4, 6), List(8, 10, 12))) { l =>
      forAll(l) { n =>
        assert(n % 2 == 0, n % 2 + " was not equal to 0")
      }
    }
  }
  def `forAll and forAtLeast should nest without problem` {
    forAll(List(List(2, 4, 6), List(8, 10, 12))) { l =>
      forAtLeast(3, l) { n =>
        assert(n % 2 == 0, n % 2 + " was not equal to 0")
      }
    }
  }
  def `forAll and forAtMost should nest without problem` {
    forAll(List(List(2, 4, 6), List(8, 10, 12))) { l =>
      forAtMost(3, l) { n =>
        assert(n % 2 == 0, n % 2 + " was not equal to 0")
      }
    }
  }
  def `forAll and forExactly should nest without problem` {
    forAll(List(List(2, 4, 6), List(8, 10, 12))) { l =>
      forExactly(3, l) { n =>
        assert(n % 2 == 0, n % 2 + " was not equal to 0")
      }
    }
  }
  def `forAll and forNo should nest without problem` {
    forAll(List(List(2, 4, 6), List(8, 10, 12))) { l =>
      forNo(l) { n =>
        assert(n % 2 == 1, n % 2 + " was not equal to 1")
      }
    }
  }
  def `forAll and forBetween should nest without problem` {
    forAll(List(List(2, 4, 6), List(8, 10, 12))) { l =>
      forBetween(2, 4, l) { n =>
        assert(n % 2 == 0, n % 2 + " was not equal to 0")
      }
    }
  }
  def `forAll and forEvery should nest without problem` {
    forAll(List(List(2, 4, 6), List(8, 10, 12))) { l =>
      forEvery(l) { n =>
        assert(n % 2 == 0, n % 2 + " was not equal to 0")
      }
    }
  }
  def `forAtLeast and forAll should nest without problem` {
    forAtLeast(2, List(List(2, 4, 6), List(8, 10, 12))) { l =>
      forAll(l) { n =>
        assert(n % 2 == 0, n % 2 + " was not equal to 0")
      }
    }
  }
  def `forAtLeast and forAtLeast should nest without problem` {
    forAtLeast(2, List(List(2, 4, 6), List(8, 10, 12))) { l =>
      forAtLeast(3, l) { n =>
        assert(n % 2 == 0, n % 2 + " was not equal to 0")
      }
    }
  }
  def `forAtLeast and forAtMost should nest without problem` {
    forAtLeast(2, List(List(2, 4, 6), List(8, 10, 12))) { l =>
      forAtMost(3, l) { n =>
        assert(n % 2 == 0, n % 2 + " was not equal to 0")
      }
    }
  }
  def `forAtLeast and forExactly should nest without problem` {
    forAtLeast(2, List(List(2, 4, 6), List(8, 10, 12))) { l =>
      forExactly(3, l) { n =>
        assert(n % 2 == 0, n % 2 + " was not equal to 0")
      }
    }
  }
  def `forAtLeast and forNo should nest without problem` {
    forAtLeast(2, List(List(2, 4, 6), List(8, 10, 12))) { l =>
      forNo(l) { n =>
        assert(n % 2 == 1, n % 2 + " was not equal to 1")
      }
    }
  }
  def `forAtLeast and forBetween should nest without problem` {
    forAtLeast(2, List(List(2, 4, 6), List(8, 10, 12))) { l =>
      forBetween(2, 4, l) { n =>
        assert(n % 2 == 0, n % 2 + " was not equal to 0")
      }
    }
  }
  def `forAtLeast and forEvery should nest without problem` {
    forAtLeast(2, List(List(2, 4, 6), List(8, 10, 12))) { l =>
      forEvery(l) { n =>
        assert(n % 2 == 0, n % 2 + " was not equal to 0")
      }
    }
  }
  def `forAtMost and forAll should nest without problem` {
    forAtMost(2, List(List(2, 4, 6), List(8, 10, 12))) { l =>
      forAll(l) { n =>
        assert(n % 2 == 0, n % 2 + " was not equal to 0")
      }
    }
  }
  def `forAtMost and forAtLeast should nest without problem` {
    forAtMost(2, List(List(2, 4, 6), List(8, 10, 12))) { l =>
      forAtLeast(3, l) { n =>
        assert(n % 2 == 0, n % 2 + " was not equal to 0")
      }
    }
  }
  def `forAtMost and forAtMost should nest without problem` {
    forAtMost(2, List(List(2, 4, 6), List(8, 10, 12))) { l =>
      forAtMost(3, l) { n =>
        assert(n % 2 == 0, n % 2 + " was not equal to 0")
      }
    }
  }
  def `forAtMost and forExactly should nest without problem` {
    forAtMost(2, List(List(2, 4, 6), List(8, 10, 12))) { l =>
      forExactly(3, l) { n =>
        assert(n % 2 == 0, n % 2 + " was not equal to 0")
      }
    }
  }
  def `forAtMost and forNo should nest without problem` {
    forAtMost(2, List(List(2, 4, 6), List(8, 10, 12))) { l =>
      forNo(l) { n =>
        assert(n % 2 == 1, n % 2 + " was not equal to 1")
      }
    }
  }
  def `forAtMost and forBetween should nest without problem` {
    forAtMost(2, List(List(2, 4, 6), List(8, 10, 12))) { l =>
      forBetween(2, 4, l) { n =>
        assert(n % 2 == 0, n % 2 + " was not equal to 0")
      }
    }
  }
  def `forAtMost and forEvery should nest without problem` {
    forAtMost(2, List(List(2, 4, 6), List(8, 10, 12))) { l =>
      forEvery(l) { n =>
        assert(n % 2 == 0, n % 2 + " was not equal to 0")
      }
    }
  }
  def `forExactly and forAll should nest without problem` {
    forExactly(2, List(List(2, 4, 6), List(8, 10, 12))) { l =>
      forAll(l) { n =>
        assert(n % 2 == 0, n % 2 + " was not equal to 0")
      }
    }
  }
  def `forExactly and forAtLeast should nest without problem` {
    forExactly(2, List(List(2, 4, 6), List(8, 10, 12))) { l =>
      forAtLeast(3, l) { n =>
        assert(n % 2 == 0, n % 2 + " was not equal to 0")
      }
    }
  }
  def `forExactly and forAtMost should nest without problem` {
    forExactly(2, List(List(2, 4, 6), List(8, 10, 12))) { l =>
      forAtMost(3, l) { n =>
        assert(n % 2 == 0, n % 2 + " was not equal to 0")
      }
    }
  }
  def `forExactly and forExactly should nest without problem` {
    forExactly(2, List(List(2, 4, 6), List(8, 10, 12))) { l =>
      forExactly(3, l) { n =>
        assert(n % 2 == 0, n % 2 + " was not equal to 0")
      }
    }
  }
  def `forExactly and forNo should nest without problem` {
    forExactly(2, List(List(2, 4, 6), List(8, 10, 12))) { l =>
      forNo(l) { n =>
        assert(n % 2 == 1, n % 2 + " was not equal to 1")
      }
    }
  }
  def `forExactly and forBetween should nest without problem` {
    forExactly(2, List(List(2, 4, 6), List(8, 10, 12))) { l =>
      forBetween(2, 4, l) { n =>
        assert(n % 2 == 0, n % 2 + " was not equal to 0")
      }
    }
  }
  def `forExactly and forEvery should nest without problem` {
    forExactly(2, List(List(2, 4, 6), List(8, 10, 12))) { l =>
      forEvery(l) { n =>
        assert(n % 2 == 0, n % 2 + " was not equal to 0")
      }
    }
  }
  def `forNo and forAll should nest without problem` {
    forNo(List(List(0, 2, 4, 6), List(8, 10, 12, 14))) { l =>
      forAll(l) { n =>
        assert(n % 2 == 1, n % 2 + " was not equal to 1")
      }
    }
  }
  def `forNo and forAtLeast should nest without problem` {
    forNo(List(List(0, 2, 4, 6), List(8, 10, 12, 14))) { l =>
      forAtLeast(3, l) { n =>
        assert(n % 2 == 1, n % 2 + " was not equal to 1")
      }
    }
  }
  def `forNo and forAtMost should nest without problem` {
    forNo(List(List(0, 2, 4, 6), List(8, 10, 12, 14))) { l =>
      forAtMost(3, l) { n =>
        assert(n % 2 == 0, n % 2 + " was not equal to 0")
      }
    }
  }
  def `forNo and forExactly should nest without problem` {
    forNo(List(List(0, 2, 4, 6), List(8, 10, 12, 14))) { l =>
      forExactly(3, l) { n =>
        assert(n % 2 == 1, n % 2 + " was not equal to 1")
      }
    }
  }
  def `forNo and forNo should nest without problem` {
    forNo(List(List(0, 2, 4, 6), List(8, 10, 12, 14))) { l =>
      forNo(l) { n =>
        assert(n % 2 == 0, n % 2 + " was not equal to 0")
      }
    }
  }
  def `forNo and forBetween should nest without problem` {
    forNo(List(List(0, 2, 4, 6), List(8, 10, 12, 14))) { l =>
      forBetween(2, 4, l) { n =>
        assert(n % 2 == 1, n % 2 + " was not equal to 1")
      }
    }
  }
  def `forNo and forEvery should nest without problem` {
    forNo(List(List(0, 2, 4, 6), List(8, 10, 12, 14))) { l =>
      forEvery(l) { n =>
        assert(n % 2 == 1, n % 2 + " was not equal to 1")
      }
    }
  }
  def `forBetween and forAll should nest without problem` {
    forBetween(2, 4, List(List(2, 4, 6), List(8, 10, 12))) { l =>
      forAll(l) { n =>
        assert(n % 2 == 0, n % 2 + " was not equal to 0")
      }
    }
  }
  def `forBetween and forAtLeast should nest without problem` {
    forBetween(2, 4, List(List(2, 4, 6), List(8, 10, 12))) { l =>
      forAtLeast(3, l) { n =>
        assert(n % 2 == 0, n % 2 + " was not equal to 0")
      }
    }
  }
  def `forBetween and forAtMost should nest without problem` {
    forBetween(2, 4, List(List(2, 4, 6), List(8, 10, 12))) { l =>
      forAtMost(3, l) { n =>
        assert(n % 2 == 0, n % 2 + " was not equal to 0")
      }
    }
  }
  def `forBetween and forExactly should nest without problem` {
    forBetween(2, 4, List(List(2, 4, 6), List(8, 10, 12))) { l =>
      forExactly(3, l) { n =>
        assert(n % 2 == 0, n % 2 + " was not equal to 0")
      }
    }
  }
  def `forBetween and forNo should nest without problem` {
    forBetween(2, 4, List(List(2, 4, 6), List(8, 10, 12))) { l =>
      forNo(l) { n =>
        assert(n % 2 == 1, n % 2 + " was not equal to 1")
      }
    }
  }
  def `forBetween and forBetween should nest without problem` {
    forBetween(2, 4, List(List(2, 4, 6), List(8, 10, 12))) { l =>
      forBetween(2, 4, l) { n =>
        assert(n % 2 == 0, n % 2 + " was not equal to 0")
      }
    }
  }
  def `forBetween and forEvery should nest without problem` {
    forBetween(2, 4, List(List(2, 4, 6), List(8, 10, 12))) { l =>
      forEvery(l) { n =>
        assert(n % 2 == 0, n % 2 + " was not equal to 0")
      }
    }
  }
  def `forEvery and forAll should nest without problem` {
    forEvery(List(List(2, 4, 6), List(8, 10, 12))) { l =>
      forAll(l) { n =>
        assert(n % 2 == 0, n % 2 + " was not equal to 0")
      }
    }
  }
  def `forEvery and forAtLeast should nest without problem` {
    forEvery(List(List(2, 4, 6), List(8, 10, 12))) { l =>
      forAtLeast(3, l) { n =>
        assert(n % 2 == 0, n % 2 + " was not equal to 0")
      }
    }
  }
  def `forEvery and forAtMost should nest without problem` {
    forEvery(List(List(2, 4, 6), List(8, 10, 12))) { l =>
      forAtMost(3, l) { n =>
        assert(n % 2 == 0, n % 2 + " was not equal to 0")
      }
    }
  }
  def `forEvery and forExactly should nest without problem` {
    forEvery(List(List(2, 4, 6), List(8, 10, 12))) { l =>
      forExactly(3, l) { n =>
        assert(n % 2 == 0, n % 2 + " was not equal to 0")
      }
    }
  }
  def `forEvery and forNo should nest without problem` {
    forEvery(List(List(2, 4, 6), List(8, 10, 12))) { l =>
      forNo(l) { n =>
        assert(n % 2 == 1, n % 2 + " was not equal to 1")
      }
    }
  }
  def `forEvery and forBetween should nest without problem` {
    forEvery(List(List(2, 4, 6), List(8, 10, 12))) { l =>
      forBetween(2, 4, l) { n =>
        assert(n % 2 == 0, n % 2 + " was not equal to 0")
      }
    }
  }
  def `forEvery and forEvery should nest without problem` {
    forEvery(List(List(2, 4, 6), List(8, 10, 12))) { l =>
      forEvery(l) { n =>
        assert(n % 2 == 0, n % 2 + " was not equal to 0")
      }
    }
  }
  def `forAll and forAll when nest should throw TestFailedException with correct stack depth and error message when failed` {
    val xs = List(List(2, 4, 6, 8), List(8, 10, 12, 16))
    val e = intercept[exceptions.TestFailedException] {
      forAll(xs) { l =>
        forAll(l) { n =>
          assert(n % 2 == 1, n % 2 + " was not equal to 1")
        }
      }
    }
    assert(e.failedCodeFileName == Some("NestedInspectorsSpec.scala"), e.failedCodeFileName + " did not equal " + Some("NestedInspectorsSpec.scala"))
    assert(e.failedCodeLineNumber == Some(thisLineNumber - 7), e.failedCodeLineNumber + " did not equal " + Some(thisLineNumber - 7))
    val outerForLineNumber = thisLineNumber - 8
    val innerForLineNumber = thisLineNumber - 8
    val assertLineNumber = thisLineNumber - 8
    assert(e.message == Some(
  "forAll failed, because: \n" + 
  "  at index 0, forAll failed, because: \n" + 
  "    at index 0, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + ") \n" + 
  "  in " + xs(0) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + ") \n" + 
  "in " + xs), e.message + " did not equal " + Some(
  "forAll failed, because: \n" + 
  "  at index 0, forAll failed, because: \n" + 
  "    at index 0, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + ") \n" + 
  "  in " + xs(0) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + ") \n" + 
  "in " + xs))
  }
  def `forAll and forAtLeast when nest should throw TestFailedException with correct stack depth and error message when failed` {
    val xs = List(List(2, 4, 6, 8), List(8, 10, 12, 16))
    val e = intercept[exceptions.TestFailedException] {
      forAll(xs) { l =>
        forAtLeast(3, l) { n =>
          assert(n % 2 == 1, n % 2 + " was not equal to 1")
        }
      }
    }
    assert(e.failedCodeFileName == Some("NestedInspectorsSpec.scala"), e.failedCodeFileName + " did not equal " + Some("NestedInspectorsSpec.scala"))
    assert(e.failedCodeLineNumber == Some(thisLineNumber - 7), e.failedCodeLineNumber + " did not equal " + Some(thisLineNumber - 7))
    val outerForLineNumber = thisLineNumber - 8
    val innerForLineNumber = thisLineNumber - 8
    val assertLineNumber = thisLineNumber - 8
    assert(e.message == Some(
  "forAll failed, because: \n" + 
  "  at index 0, forAtLeast(3) failed, because no element satisfied the assertion block: \n" + 
  "    at index 0, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 1, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 2, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 3, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + ") \n" + 
  "  in " + xs(0) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + ") \n" + 
  "in " + xs), e.message + " did not equal " + Some(
  "forAll failed, because: \n" + 
  "  at index 0, forAtLeast(3) failed, because no element satisfied the assertion block: \n" + 
  "    at index 0, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 1, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 2, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 3, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + ") \n" + 
  "  in " + xs(0) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + ") \n" + 
  "in " + xs))
  }
  def `forAll and forAtMost when nest should throw TestFailedException with correct stack depth and error message when failed` {
    val xs = List(List(2, 4, 6, 8), List(8, 10, 12, 16))
    val e = intercept[exceptions.TestFailedException] {
      forAll(xs) { l =>
        forAtMost(3, l) { n =>
          assert(n % 2 == 0, n % 2 + " was not equal to 0")
        }
      }
    }
    assert(e.failedCodeFileName == Some("NestedInspectorsSpec.scala"), e.failedCodeFileName + " did not equal " + Some("NestedInspectorsSpec.scala"))
    assert(e.failedCodeLineNumber == Some(thisLineNumber - 7), e.failedCodeLineNumber + " did not equal " + Some(thisLineNumber - 7))
    val outerForLineNumber = thisLineNumber - 8
    val innerForLineNumber = thisLineNumber - 8
    val assertLineNumber = thisLineNumber - 8
    assert(e.message == Some(
  "forAll failed, because: \n" + 
  "  at index 0, forAtMost(3) failed, because 4 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqualBoolean(xs(0), false, 4) + " in " + xs(0) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + ") \n" + 
  "in " + xs), e.message + " did not equal " + Some(
  "forAll failed, because: \n" + 
  "  at index 0, forAtMost(3) failed, because 4 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqualBoolean(xs(0), false, 4) + " in " + xs(0) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + ") \n" + 
  "in " + xs))
  }
  def `forAll and forExactly when nest should throw TestFailedException with correct stack depth and error message when failed` {
    val xs = List(List(2, 4, 6, 8), List(8, 10, 12, 16))
    val e = intercept[exceptions.TestFailedException] {
      forAll(xs) { l =>
        forExactly(4, l) { n =>
          assert(n % 2 == 1, n % 2 + " was not equal to 1")
        }
      }
    }
    assert(e.failedCodeFileName == Some("NestedInspectorsSpec.scala"), e.failedCodeFileName + " did not equal " + Some("NestedInspectorsSpec.scala"))
    assert(e.failedCodeLineNumber == Some(thisLineNumber - 7), e.failedCodeLineNumber + " did not equal " + Some(thisLineNumber - 7))
    val outerForLineNumber = thisLineNumber - 8
    val innerForLineNumber = thisLineNumber - 8
    val assertLineNumber = thisLineNumber - 8
    assert(e.message == Some(
  "forAll failed, because: \n" + 
  "  at index 0, forExactly(4) failed, because no element satisfied the assertion block: \n" + 
  "    at index 0, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 1, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 2, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 3, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + ") \n" + 
  "  in " + xs(0) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + ") \n" + 
  "in " + xs), e.message + " did not equal " + Some(
  "forAll failed, because: \n" + 
  "  at index 0, forExactly(4) failed, because no element satisfied the assertion block: \n" + 
  "    at index 0, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 1, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 2, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 3, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + ") \n" + 
  "  in " + xs(0) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + ") \n" + 
  "in " + xs))
  }
  def `forAll and forNo when nest should throw TestFailedException with correct stack depth and error message when failed` {
    val xs = List(List(2, 4, 6, 8), List(8, 10, 12, 16))
    val e = intercept[exceptions.TestFailedException] {
      forAll(xs) { l =>
        forNo(l) { n =>
          assert(n % 2 == 0, n % 2 + " was not equal to 0")
        }
      }
    }
    assert(e.failedCodeFileName == Some("NestedInspectorsSpec.scala"), e.failedCodeFileName + " did not equal " + Some("NestedInspectorsSpec.scala"))
    assert(e.failedCodeLineNumber == Some(thisLineNumber - 7), e.failedCodeLineNumber + " did not equal " + Some(thisLineNumber - 7))
    val outerForLineNumber = thisLineNumber - 8
    val innerForLineNumber = thisLineNumber - 8
    val assertLineNumber = thisLineNumber - 8
    assert(e.message == Some(
  "forAll failed, because: \n" + 
  "  at index 0, forNo failed, because 1 element satisfied the assertion block at index 0 in " + xs(0) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + ") \n" + 
  "in " + xs), e.message + " did not equal " + Some(
  "forAll failed, because: \n" + 
  "  at index 0, forNo failed, because 1 element satisfied the assertion block at index 0 in " + xs(0) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + ") \n" + 
  "in " + xs))
  }
  def `forAll and forBetween when nest should throw TestFailedException with correct stack depth and error message when failed` {
    val xs = List(List(2, 4, 6, 8), List(8, 10, 12, 16))
    val e = intercept[exceptions.TestFailedException] {
      forAll(xs) { l =>
        forBetween(2, 4, l) { n =>
          assert(n % 2 == 1, n % 2 + " was not equal to 1")
        }
      }
    }
    assert(e.failedCodeFileName == Some("NestedInspectorsSpec.scala"), e.failedCodeFileName + " did not equal " + Some("NestedInspectorsSpec.scala"))
    assert(e.failedCodeLineNumber == Some(thisLineNumber - 7), e.failedCodeLineNumber + " did not equal " + Some(thisLineNumber - 7))
    val outerForLineNumber = thisLineNumber - 8
    val innerForLineNumber = thisLineNumber - 8
    val assertLineNumber = thisLineNumber - 8
    assert(e.message == Some(
  "forAll failed, because: \n" + 
  "  at index 0, forBetween(2, 4) failed, because no element satisfied the assertion block: \n" + 
  "    at index 0, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 1, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 2, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 3, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + ") \n" + 
  "  in " + xs(0) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + ") \n" + 
  "in " + xs), e.message + " did not equal " + Some(
  "forAll failed, because: \n" + 
  "  at index 0, forBetween(2, 4) failed, because no element satisfied the assertion block: \n" + 
  "    at index 0, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 1, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 2, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 3, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + ") \n" + 
  "  in " + xs(0) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + ") \n" + 
  "in " + xs))
  }
  def `forAll and forEvery when nest should throw TestFailedException with correct stack depth and error message when failed` {
    val xs = List(List(2, 4, 6, 8), List(8, 10, 12, 16))
    val e = intercept[exceptions.TestFailedException] {
      forAll(xs) { l =>
        forEvery(l) { n =>
          assert(n % 2 == 1, n % 2 + " was not equal to 1")
        }
      }
    }
    assert(e.failedCodeFileName == Some("NestedInspectorsSpec.scala"), e.failedCodeFileName + " did not equal " + Some("NestedInspectorsSpec.scala"))
    assert(e.failedCodeLineNumber == Some(thisLineNumber - 7), e.failedCodeLineNumber + " did not equal " + Some(thisLineNumber - 7))
    val outerForLineNumber = thisLineNumber - 8
    val innerForLineNumber = thisLineNumber - 8
    val assertLineNumber = thisLineNumber - 8
    assert(e.message == Some(
  "forAll failed, because: \n" + 
  "  at index 0, forEvery failed, because: \n" + 
  "    at index 0, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 1, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 2, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 3, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + ") \n" + 
  "  in " + xs(0) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + ") \n" + 
  "in " + xs), e.message + " did not equal " + Some(
  "forAll failed, because: \n" + 
  "  at index 0, forEvery failed, because: \n" + 
  "    at index 0, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 1, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 2, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 3, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + ") \n" + 
  "  in " + xs(0) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + ") \n" + 
  "in " + xs))
  }
  def `forAtLeast and forAll when nest should throw TestFailedException with correct stack depth and error message when failed` {
    val xs = List(List(2, 4, 6, 8), List(8, 10, 12, 16))
    val e = intercept[exceptions.TestFailedException] {
      forAtLeast(3, xs) { l =>
        forAll(l) { n =>
          assert(n % 2 == 1, n % 2 + " was not equal to 1")
        }
      }
    }
    assert(e.failedCodeFileName == Some("NestedInspectorsSpec.scala"), e.failedCodeFileName + " did not equal " + Some("NestedInspectorsSpec.scala"))
    assert(e.failedCodeLineNumber == Some(thisLineNumber - 7), e.failedCodeLineNumber + " did not equal " + Some(thisLineNumber - 7))
    val outerForLineNumber = thisLineNumber - 8
    val innerForLineNumber = thisLineNumber - 8
    val assertLineNumber = thisLineNumber - 8
    assert(e.message == Some(
  "forAtLeast(3) failed, because no element satisfied the assertion block: \n" + 
  "  at index 0, forAll failed, because: \n" + 
  "    at index 0, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + ") \n" + 
  "  in " + xs(0) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + "), \n" + 
  "  at index 1, forAll failed, because: \n" + 
  "    at index 0, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + ") \n" + 
  "  in " + xs(1) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + ") \n" + 
  "in " + xs), e.message + " did not equal " + Some(
  "forAtLeast(3) failed, because no element satisfied the assertion block: \n" + 
  "  at index 0, forAll failed, because: \n" + 
  "    at index 0, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + ") \n" + 
  "  in " + xs(0) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + "), \n" + 
  "  at index 1, forAll failed, because: \n" + 
  "    at index 0, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + ") \n" + 
  "  in " + xs(1) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + ") \n" + 
  "in " + xs))
  }
  def `forAtLeast and forAtLeast when nest should throw TestFailedException with correct stack depth and error message when failed` {
    val xs = List(List(2, 4, 6, 8), List(8, 10, 12, 16))
    val e = intercept[exceptions.TestFailedException] {
      forAtLeast(3, xs) { l =>
        forAtLeast(3, l) { n =>
          assert(n % 2 == 1, n % 2 + " was not equal to 1")
        }
      }
    }
    assert(e.failedCodeFileName == Some("NestedInspectorsSpec.scala"), e.failedCodeFileName + " did not equal " + Some("NestedInspectorsSpec.scala"))
    assert(e.failedCodeLineNumber == Some(thisLineNumber - 7), e.failedCodeLineNumber + " did not equal " + Some(thisLineNumber - 7))
    val outerForLineNumber = thisLineNumber - 8
    val innerForLineNumber = thisLineNumber - 8
    val assertLineNumber = thisLineNumber - 8
    assert(e.message == Some(
  "forAtLeast(3) failed, because no element satisfied the assertion block: \n" + 
  "  at index 0, forAtLeast(3) failed, because no element satisfied the assertion block: \n" + 
  "    at index 0, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 1, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 2, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 3, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + ") \n" + 
  "  in " + xs(0) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + "), \n" + 
  "  at index 1, forAtLeast(3) failed, because no element satisfied the assertion block: \n" + 
  "    at index 0, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 1, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 2, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 3, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + ") \n" + 
  "  in " + xs(1) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + ") \n" + 
  "in " + xs), e.message + " did not equal " + Some(
  "forAtLeast(3) failed, because no element satisfied the assertion block: \n" + 
  "  at index 0, forAtLeast(3) failed, because no element satisfied the assertion block: \n" + 
  "    at index 0, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 1, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 2, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 3, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + ") \n" + 
  "  in " + xs(0) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + "), \n" + 
  "  at index 1, forAtLeast(3) failed, because no element satisfied the assertion block: \n" + 
  "    at index 0, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 1, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 2, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 3, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + ") \n" + 
  "  in " + xs(1) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + ") \n" + 
  "in " + xs))
  }
  def `forAtLeast and forAtMost when nest should throw TestFailedException with correct stack depth and error message when failed` {
    val xs = List(List(2, 4, 6, 8), List(8, 10, 12, 16))
    val e = intercept[exceptions.TestFailedException] {
      forAtLeast(3, xs) { l =>
        forAtMost(3, l) { n =>
          assert(n % 2 == 0, n % 2 + " was not equal to 0")
        }
      }
    }
    assert(e.failedCodeFileName == Some("NestedInspectorsSpec.scala"), e.failedCodeFileName + " did not equal " + Some("NestedInspectorsSpec.scala"))
    assert(e.failedCodeLineNumber == Some(thisLineNumber - 7), e.failedCodeLineNumber + " did not equal " + Some(thisLineNumber - 7))
    val outerForLineNumber = thisLineNumber - 8
    val innerForLineNumber = thisLineNumber - 8
    val assertLineNumber = thisLineNumber - 8
    assert(e.message == Some(
  "forAtLeast(3) failed, because no element satisfied the assertion block: \n" + 
  "  at index 0, forAtMost(3) failed, because 4 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqualBoolean(xs(0), false, 4) + " in " + xs(0) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + "), \n" + 
  "  at index 1, forAtMost(3) failed, because 4 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqualBoolean(xs(1), false, 4) + " in " + xs(1) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + ") \n" + 
  "in " + xs), e.message + " did not equal " + Some(
  "forAtLeast(3) failed, because no element satisfied the assertion block: \n" + 
  "  at index 0, forAtMost(3) failed, because 4 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqualBoolean(xs(0), false, 4) + " in " + xs(0) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + "), \n" + 
  "  at index 1, forAtMost(3) failed, because 4 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqualBoolean(xs(1), false, 4) + " in " + xs(1) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + ") \n" + 
  "in " + xs))
  }
  def `forAtLeast and forExactly when nest should throw TestFailedException with correct stack depth and error message when failed` {
    val xs = List(List(2, 4, 6, 8), List(8, 10, 12, 16))
    val e = intercept[exceptions.TestFailedException] {
      forAtLeast(3, xs) { l =>
        forExactly(4, l) { n =>
          assert(n % 2 == 1, n % 2 + " was not equal to 1")
        }
      }
    }
    assert(e.failedCodeFileName == Some("NestedInspectorsSpec.scala"), e.failedCodeFileName + " did not equal " + Some("NestedInspectorsSpec.scala"))
    assert(e.failedCodeLineNumber == Some(thisLineNumber - 7), e.failedCodeLineNumber + " did not equal " + Some(thisLineNumber - 7))
    val outerForLineNumber = thisLineNumber - 8
    val innerForLineNumber = thisLineNumber - 8
    val assertLineNumber = thisLineNumber - 8
    assert(e.message == Some(
  "forAtLeast(3) failed, because no element satisfied the assertion block: \n" + 
  "  at index 0, forExactly(4) failed, because no element satisfied the assertion block: \n" + 
  "    at index 0, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 1, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 2, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 3, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + ") \n" + 
  "  in " + xs(0) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + "), \n" + 
  "  at index 1, forExactly(4) failed, because no element satisfied the assertion block: \n" + 
  "    at index 0, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 1, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 2, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 3, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + ") \n" + 
  "  in " + xs(1) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + ") \n" + 
  "in " + xs), e.message + " did not equal " + Some(
  "forAtLeast(3) failed, because no element satisfied the assertion block: \n" + 
  "  at index 0, forExactly(4) failed, because no element satisfied the assertion block: \n" + 
  "    at index 0, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 1, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 2, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 3, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + ") \n" + 
  "  in " + xs(0) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + "), \n" + 
  "  at index 1, forExactly(4) failed, because no element satisfied the assertion block: \n" + 
  "    at index 0, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 1, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 2, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 3, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + ") \n" + 
  "  in " + xs(1) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + ") \n" + 
  "in " + xs))
  }
  def `forAtLeast and forNo when nest should throw TestFailedException with correct stack depth and error message when failed` {
    val xs = List(List(2, 4, 6, 8), List(8, 10, 12, 16))
    val e = intercept[exceptions.TestFailedException] {
      forAtLeast(3, xs) { l =>
        forNo(l) { n =>
          assert(n % 2 == 0, n % 2 + " was not equal to 0")
        }
      }
    }
    assert(e.failedCodeFileName == Some("NestedInspectorsSpec.scala"), e.failedCodeFileName + " did not equal " + Some("NestedInspectorsSpec.scala"))
    assert(e.failedCodeLineNumber == Some(thisLineNumber - 7), e.failedCodeLineNumber + " did not equal " + Some(thisLineNumber - 7))
    val outerForLineNumber = thisLineNumber - 8
    val innerForLineNumber = thisLineNumber - 8
    val assertLineNumber = thisLineNumber - 8
    assert(e.message == Some(
  "forAtLeast(3) failed, because no element satisfied the assertion block: \n" + 
  "  at index 0, forNo failed, because 1 element satisfied the assertion block at index 0 in " + xs(0) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + "), \n" + 
  "  at index 1, forNo failed, because 1 element satisfied the assertion block at index 0 in " + xs(1) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + ") \n" + 
  "in " + xs), e.message + " did not equal " + Some(
  "forAtLeast(3) failed, because no element satisfied the assertion block: \n" + 
  "  at index 0, forNo failed, because 1 element satisfied the assertion block at index 0 in " + xs(0) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + "), \n" + 
  "  at index 1, forNo failed, because 1 element satisfied the assertion block at index 0 in " + xs(1) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + ") \n" + 
  "in " + xs))
  }
  def `forAtLeast and forBetween when nest should throw TestFailedException with correct stack depth and error message when failed` {
    val xs = List(List(2, 4, 6, 8), List(8, 10, 12, 16))
    val e = intercept[exceptions.TestFailedException] {
      forAtLeast(3, xs) { l =>
        forBetween(2, 4, l) { n =>
          assert(n % 2 == 1, n % 2 + " was not equal to 1")
        }
      }
    }
    assert(e.failedCodeFileName == Some("NestedInspectorsSpec.scala"), e.failedCodeFileName + " did not equal " + Some("NestedInspectorsSpec.scala"))
    assert(e.failedCodeLineNumber == Some(thisLineNumber - 7), e.failedCodeLineNumber + " did not equal " + Some(thisLineNumber - 7))
    val outerForLineNumber = thisLineNumber - 8
    val innerForLineNumber = thisLineNumber - 8
    val assertLineNumber = thisLineNumber - 8
    assert(e.message == Some(
  "forAtLeast(3) failed, because no element satisfied the assertion block: \n" + 
  "  at index 0, forBetween(2, 4) failed, because no element satisfied the assertion block: \n" + 
  "    at index 0, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 1, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 2, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 3, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + ") \n" + 
  "  in " + xs(0) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + "), \n" + 
  "  at index 1, forBetween(2, 4) failed, because no element satisfied the assertion block: \n" + 
  "    at index 0, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 1, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 2, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 3, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + ") \n" + 
  "  in " + xs(1) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + ") \n" + 
  "in " + xs), e.message + " did not equal " + Some(
  "forAtLeast(3) failed, because no element satisfied the assertion block: \n" + 
  "  at index 0, forBetween(2, 4) failed, because no element satisfied the assertion block: \n" + 
  "    at index 0, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 1, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 2, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 3, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + ") \n" + 
  "  in " + xs(0) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + "), \n" + 
  "  at index 1, forBetween(2, 4) failed, because no element satisfied the assertion block: \n" + 
  "    at index 0, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 1, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 2, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 3, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + ") \n" + 
  "  in " + xs(1) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + ") \n" + 
  "in " + xs))
  }
  def `forAtLeast and forEvery when nest should throw TestFailedException with correct stack depth and error message when failed` {
    val xs = List(List(2, 4, 6, 8), List(8, 10, 12, 16))
    val e = intercept[exceptions.TestFailedException] {
      forAtLeast(3, xs) { l =>
        forEvery(l) { n =>
          assert(n % 2 == 1, n % 2 + " was not equal to 1")
        }
      }
    }
    assert(e.failedCodeFileName == Some("NestedInspectorsSpec.scala"), e.failedCodeFileName + " did not equal " + Some("NestedInspectorsSpec.scala"))
    assert(e.failedCodeLineNumber == Some(thisLineNumber - 7), e.failedCodeLineNumber + " did not equal " + Some(thisLineNumber - 7))
    val outerForLineNumber = thisLineNumber - 8
    val innerForLineNumber = thisLineNumber - 8
    val assertLineNumber = thisLineNumber - 8
    assert(e.message == Some(
  "forAtLeast(3) failed, because no element satisfied the assertion block: \n" + 
  "  at index 0, forEvery failed, because: \n" + 
  "    at index 0, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 1, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 2, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 3, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + ") \n" + 
  "  in " + xs(0) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + "), \n" + 
  "  at index 1, forEvery failed, because: \n" + 
  "    at index 0, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 1, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 2, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 3, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + ") \n" + 
  "  in " + xs(1) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + ") \n" + 
  "in " + xs), e.message + " did not equal " + Some(
  "forAtLeast(3) failed, because no element satisfied the assertion block: \n" + 
  "  at index 0, forEvery failed, because: \n" + 
  "    at index 0, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 1, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 2, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 3, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + ") \n" + 
  "  in " + xs(0) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + "), \n" + 
  "  at index 1, forEvery failed, because: \n" + 
  "    at index 0, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 1, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 2, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 3, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + ") \n" + 
  "  in " + xs(1) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + ") \n" + 
  "in " + xs))
  }
  def `forAtMost and forAll when nest should throw TestFailedException with correct stack depth and error message when failed` {
    val xs = List(List(2, 4, 6, 8), List(8, 10, 12, 16))
    val e = intercept[exceptions.TestFailedException] {
      forAtMost(1, xs) { l =>
        forAll(l) { n =>
          assert(n % 2 == 0, n % 2 + " was not equal to 0")
        }
      }
    }
    assert(e.failedCodeFileName == Some("NestedInspectorsSpec.scala"), e.failedCodeFileName + " did not equal " + Some("NestedInspectorsSpec.scala"))
    assert(e.failedCodeLineNumber == Some(thisLineNumber - 7), e.failedCodeLineNumber + " did not equal " + Some(thisLineNumber - 7))
    val outerForLineNumber = thisLineNumber - 8
    val innerForLineNumber = thisLineNumber - 8
    val assertLineNumber = thisLineNumber - 8
    assert(e.message == Some(
  "forAtMost(1) failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqualBoolean(xs, false, 2) + " in " + xs), e.message + " did not equal " + Some(
  "forAtMost(1) failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqualBoolean(xs, false, 2) + " in " + xs))
  }
  def `forAtMost and forAtLeast when nest should throw TestFailedException with correct stack depth and error message when failed` {
    val xs = List(List(2, 4, 6, 8), List(8, 10, 12, 16))
    val e = intercept[exceptions.TestFailedException] {
      forAtMost(1, xs) { l =>
        forAtLeast(3, l) { n =>
          assert(n % 2 == 0, n % 2 + " was not equal to 0")
        }
      }
    }
    assert(e.failedCodeFileName == Some("NestedInspectorsSpec.scala"), e.failedCodeFileName + " did not equal " + Some("NestedInspectorsSpec.scala"))
    assert(e.failedCodeLineNumber == Some(thisLineNumber - 7), e.failedCodeLineNumber + " did not equal " + Some(thisLineNumber - 7))
    val outerForLineNumber = thisLineNumber - 8
    val innerForLineNumber = thisLineNumber - 8
    val assertLineNumber = thisLineNumber - 8
    assert(e.message == Some(
  "forAtMost(1) failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqualBoolean(xs, false, 2) + " in " + xs), e.message + " did not equal " + Some(
  "forAtMost(1) failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqualBoolean(xs, false, 2) + " in " + xs))
  }
  def `forAtMost and forAtMost when nest should throw TestFailedException with correct stack depth and error message when failed` {
    val xs = List(List(2, 4, 6, 8), List(8, 10, 12, 16))
    val e = intercept[exceptions.TestFailedException] {
      forAtMost(1, xs) { l =>
        forAtMost(3, l) { n =>
          assert(n % 2 == 1, n % 2 + " was not equal to 1")
        }
      }
    }
    assert(e.failedCodeFileName == Some("NestedInspectorsSpec.scala"), e.failedCodeFileName + " did not equal " + Some("NestedInspectorsSpec.scala"))
    assert(e.failedCodeLineNumber == Some(thisLineNumber - 7), e.failedCodeLineNumber + " did not equal " + Some(thisLineNumber - 7))
    val outerForLineNumber = thisLineNumber - 8
    val innerForLineNumber = thisLineNumber - 8
    val assertLineNumber = thisLineNumber - 8
    assert(e.message == Some(
  "forAtMost(1) failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqualBoolean(xs, false, 2) + " in " + xs), e.message + " did not equal " + Some(
  "forAtMost(1) failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqualBoolean(xs, false, 2) + " in " + xs))
  }
  def `forAtMost and forExactly when nest should throw TestFailedException with correct stack depth and error message when failed` {
    val xs = List(List(2, 4, 6, 8), List(8, 10, 12, 16))
    val e = intercept[exceptions.TestFailedException] {
      forAtMost(1, xs) { l =>
        forExactly(4, l) { n =>
          assert(n % 2 == 0, n % 2 + " was not equal to 0")
        }
      }
    }
    assert(e.failedCodeFileName == Some("NestedInspectorsSpec.scala"), e.failedCodeFileName + " did not equal " + Some("NestedInspectorsSpec.scala"))
    assert(e.failedCodeLineNumber == Some(thisLineNumber - 7), e.failedCodeLineNumber + " did not equal " + Some(thisLineNumber - 7))
    val outerForLineNumber = thisLineNumber - 8
    val innerForLineNumber = thisLineNumber - 8
    val assertLineNumber = thisLineNumber - 8
    assert(e.message == Some(
  "forAtMost(1) failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqualBoolean(xs, false, 2) + " in " + xs), e.message + " did not equal " + Some(
  "forAtMost(1) failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqualBoolean(xs, false, 2) + " in " + xs))
  }
  def `forAtMost and forNo when nest should throw TestFailedException with correct stack depth and error message when failed` {
    val xs = List(List(2, 4, 6, 8), List(8, 10, 12, 16))
    val e = intercept[exceptions.TestFailedException] {
      forAtMost(1, xs) { l =>
        forNo(l) { n =>
          assert(n % 2 == 1, n % 2 + " was not equal to 1")
        }
      }
    }
    assert(e.failedCodeFileName == Some("NestedInspectorsSpec.scala"), e.failedCodeFileName + " did not equal " + Some("NestedInspectorsSpec.scala"))
    assert(e.failedCodeLineNumber == Some(thisLineNumber - 7), e.failedCodeLineNumber + " did not equal " + Some(thisLineNumber - 7))
    val outerForLineNumber = thisLineNumber - 8
    val innerForLineNumber = thisLineNumber - 8
    val assertLineNumber = thisLineNumber - 8
    assert(e.message == Some(
  "forAtMost(1) failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqualBoolean(xs, false, 2) + " in " + xs), e.message + " did not equal " + Some(
  "forAtMost(1) failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqualBoolean(xs, false, 2) + " in " + xs))
  }
  def `forAtMost and forBetween when nest should throw TestFailedException with correct stack depth and error message when failed` {
    val xs = List(List(2, 4, 6, 8), List(8, 10, 12, 16))
    val e = intercept[exceptions.TestFailedException] {
      forAtMost(1, xs) { l =>
        forBetween(2, 4, l) { n =>
          assert(n % 2 == 0, n % 2 + " was not equal to 0")
        }
      }
    }
    assert(e.failedCodeFileName == Some("NestedInspectorsSpec.scala"), e.failedCodeFileName + " did not equal " + Some("NestedInspectorsSpec.scala"))
    assert(e.failedCodeLineNumber == Some(thisLineNumber - 7), e.failedCodeLineNumber + " did not equal " + Some(thisLineNumber - 7))
    val outerForLineNumber = thisLineNumber - 8
    val innerForLineNumber = thisLineNumber - 8
    val assertLineNumber = thisLineNumber - 8
    assert(e.message == Some(
  "forAtMost(1) failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqualBoolean(xs, false, 2) + " in " + xs), e.message + " did not equal " + Some(
  "forAtMost(1) failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqualBoolean(xs, false, 2) + " in " + xs))
  }
  def `forAtMost and forEvery when nest should throw TestFailedException with correct stack depth and error message when failed` {
    val xs = List(List(2, 4, 6, 8), List(8, 10, 12, 16))
    val e = intercept[exceptions.TestFailedException] {
      forAtMost(1, xs) { l =>
        forEvery(l) { n =>
          assert(n % 2 == 0, n % 2 + " was not equal to 0")
        }
      }
    }
    assert(e.failedCodeFileName == Some("NestedInspectorsSpec.scala"), e.failedCodeFileName + " did not equal " + Some("NestedInspectorsSpec.scala"))
    assert(e.failedCodeLineNumber == Some(thisLineNumber - 7), e.failedCodeLineNumber + " did not equal " + Some(thisLineNumber - 7))
    val outerForLineNumber = thisLineNumber - 8
    val innerForLineNumber = thisLineNumber - 8
    val assertLineNumber = thisLineNumber - 8
    assert(e.message == Some(
  "forAtMost(1) failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqualBoolean(xs, false, 2) + " in " + xs), e.message + " did not equal " + Some(
  "forAtMost(1) failed, because 2 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqualBoolean(xs, false, 2) + " in " + xs))
  }
  def `forExactly and forAll when nest should throw TestFailedException with correct stack depth and error message when failed` {
    val xs = List(List(2, 4, 6, 8), List(8, 10, 12, 16))
    val e = intercept[exceptions.TestFailedException] {
      forExactly(1, xs) { l =>
        forAll(l) { n =>
          assert(n % 2 == 1, n % 2 + " was not equal to 1")
        }
      }
    }
    assert(e.failedCodeFileName == Some("NestedInspectorsSpec.scala"), e.failedCodeFileName + " did not equal " + Some("NestedInspectorsSpec.scala"))
    assert(e.failedCodeLineNumber == Some(thisLineNumber - 7), e.failedCodeLineNumber + " did not equal " + Some(thisLineNumber - 7))
    val outerForLineNumber = thisLineNumber - 8
    val innerForLineNumber = thisLineNumber - 8
    val assertLineNumber = thisLineNumber - 8
    assert(e.message == Some(
  "forExactly(1) failed, because no element satisfied the assertion block: \n" + 
  "  at index 0, forAll failed, because: \n" + 
  "    at index 0, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + ") \n" + 
  "  in " + xs(0) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + "), \n" + 
  "  at index 1, forAll failed, because: \n" + 
  "    at index 0, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + ") \n" + 
  "  in " + xs(1) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + ") \n" + 
  "in " + xs), e.message + " did not equal " + Some(
  "forExactly(1) failed, because no element satisfied the assertion block: \n" + 
  "  at index 0, forAll failed, because: \n" + 
  "    at index 0, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + ") \n" + 
  "  in " + xs(0) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + "), \n" + 
  "  at index 1, forAll failed, because: \n" + 
  "    at index 0, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + ") \n" + 
  "  in " + xs(1) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + ") \n" + 
  "in " + xs))
  }
  def `forExactly and forAtLeast when nest should throw TestFailedException with correct stack depth and error message when failed` {
    val xs = List(List(2, 4, 6, 8), List(8, 10, 12, 16))
    val e = intercept[exceptions.TestFailedException] {
      forExactly(1, xs) { l =>
        forAtLeast(3, l) { n =>
          assert(n % 2 == 1, n % 2 + " was not equal to 1")
        }
      }
    }
    assert(e.failedCodeFileName == Some("NestedInspectorsSpec.scala"), e.failedCodeFileName + " did not equal " + Some("NestedInspectorsSpec.scala"))
    assert(e.failedCodeLineNumber == Some(thisLineNumber - 7), e.failedCodeLineNumber + " did not equal " + Some(thisLineNumber - 7))
    val outerForLineNumber = thisLineNumber - 8
    val innerForLineNumber = thisLineNumber - 8
    val assertLineNumber = thisLineNumber - 8
    assert(e.message == Some(
  "forExactly(1) failed, because no element satisfied the assertion block: \n" + 
  "  at index 0, forAtLeast(3) failed, because no element satisfied the assertion block: \n" + 
  "    at index 0, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 1, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 2, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 3, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + ") \n" + 
  "  in " + xs(0) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + "), \n" + 
  "  at index 1, forAtLeast(3) failed, because no element satisfied the assertion block: \n" + 
  "    at index 0, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 1, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 2, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 3, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + ") \n" + 
  "  in " + xs(1) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + ") \n" + 
  "in " + xs), e.message + " did not equal " + Some(
  "forExactly(1) failed, because no element satisfied the assertion block: \n" + 
  "  at index 0, forAtLeast(3) failed, because no element satisfied the assertion block: \n" + 
  "    at index 0, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 1, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 2, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 3, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + ") \n" + 
  "  in " + xs(0) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + "), \n" + 
  "  at index 1, forAtLeast(3) failed, because no element satisfied the assertion block: \n" + 
  "    at index 0, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 1, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 2, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 3, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + ") \n" + 
  "  in " + xs(1) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + ") \n" + 
  "in " + xs))
  }
  def `forExactly and forAtMost when nest should throw TestFailedException with correct stack depth and error message when failed` {
    val xs = List(List(2, 4, 6, 8), List(8, 10, 12, 16))
    val e = intercept[exceptions.TestFailedException] {
      forExactly(1, xs) { l =>
        forAtMost(3, l) { n =>
          assert(n % 2 == 0, n % 2 + " was not equal to 0")
        }
      }
    }
    assert(e.failedCodeFileName == Some("NestedInspectorsSpec.scala"), e.failedCodeFileName + " did not equal " + Some("NestedInspectorsSpec.scala"))
    assert(e.failedCodeLineNumber == Some(thisLineNumber - 7), e.failedCodeLineNumber + " did not equal " + Some(thisLineNumber - 7))
    val outerForLineNumber = thisLineNumber - 8
    val innerForLineNumber = thisLineNumber - 8
    val assertLineNumber = thisLineNumber - 8
    assert(e.message == Some(
  "forExactly(1) failed, because no element satisfied the assertion block: \n" + 
  "  at index 0, forAtMost(3) failed, because 4 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqualBoolean(xs(0), false, 4) + " in " + xs(0) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + "), \n" + 
  "  at index 1, forAtMost(3) failed, because 4 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqualBoolean(xs(1), false, 4) + " in " + xs(1) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + ") \n" + 
  "in " + xs), e.message + " did not equal " + Some(
  "forExactly(1) failed, because no element satisfied the assertion block: \n" + 
  "  at index 0, forAtMost(3) failed, because 4 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqualBoolean(xs(0), false, 4) + " in " + xs(0) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + "), \n" + 
  "  at index 1, forAtMost(3) failed, because 4 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqualBoolean(xs(1), false, 4) + " in " + xs(1) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + ") \n" + 
  "in " + xs))
  }
  def `forExactly and forExactly when nest should throw TestFailedException with correct stack depth and error message when failed` {
    val xs = List(List(2, 4, 6, 8), List(8, 10, 12, 16))
    val e = intercept[exceptions.TestFailedException] {
      forExactly(1, xs) { l =>
        forExactly(4, l) { n =>
          assert(n % 2 == 1, n % 2 + " was not equal to 1")
        }
      }
    }
    assert(e.failedCodeFileName == Some("NestedInspectorsSpec.scala"), e.failedCodeFileName + " did not equal " + Some("NestedInspectorsSpec.scala"))
    assert(e.failedCodeLineNumber == Some(thisLineNumber - 7), e.failedCodeLineNumber + " did not equal " + Some(thisLineNumber - 7))
    val outerForLineNumber = thisLineNumber - 8
    val innerForLineNumber = thisLineNumber - 8
    val assertLineNumber = thisLineNumber - 8
    assert(e.message == Some(
  "forExactly(1) failed, because no element satisfied the assertion block: \n" + 
  "  at index 0, forExactly(4) failed, because no element satisfied the assertion block: \n" + 
  "    at index 0, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 1, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 2, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 3, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + ") \n" + 
  "  in " + xs(0) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + "), \n" + 
  "  at index 1, forExactly(4) failed, because no element satisfied the assertion block: \n" + 
  "    at index 0, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 1, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 2, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 3, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + ") \n" + 
  "  in " + xs(1) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + ") \n" + 
  "in " + xs), e.message + " did not equal " + Some(
  "forExactly(1) failed, because no element satisfied the assertion block: \n" + 
  "  at index 0, forExactly(4) failed, because no element satisfied the assertion block: \n" + 
  "    at index 0, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 1, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 2, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 3, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + ") \n" + 
  "  in " + xs(0) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + "), \n" + 
  "  at index 1, forExactly(4) failed, because no element satisfied the assertion block: \n" + 
  "    at index 0, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 1, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 2, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 3, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + ") \n" + 
  "  in " + xs(1) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + ") \n" + 
  "in " + xs))
  }
  def `forExactly and forNo when nest should throw TestFailedException with correct stack depth and error message when failed` {
    val xs = List(List(2, 4, 6, 8), List(8, 10, 12, 16))
    val e = intercept[exceptions.TestFailedException] {
      forExactly(1, xs) { l =>
        forNo(l) { n =>
          assert(n % 2 == 0, n % 2 + " was not equal to 0")
        }
      }
    }
    assert(e.failedCodeFileName == Some("NestedInspectorsSpec.scala"), e.failedCodeFileName + " did not equal " + Some("NestedInspectorsSpec.scala"))
    assert(e.failedCodeLineNumber == Some(thisLineNumber - 7), e.failedCodeLineNumber + " did not equal " + Some(thisLineNumber - 7))
    val outerForLineNumber = thisLineNumber - 8
    val innerForLineNumber = thisLineNumber - 8
    val assertLineNumber = thisLineNumber - 8
    assert(e.message == Some(
  "forExactly(1) failed, because no element satisfied the assertion block: \n" + 
  "  at index 0, forNo failed, because 1 element satisfied the assertion block at index 0 in " + xs(0) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + "), \n" + 
  "  at index 1, forNo failed, because 1 element satisfied the assertion block at index 0 in " + xs(1) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + ") \n" + 
  "in " + xs), e.message + " did not equal " + Some(
  "forExactly(1) failed, because no element satisfied the assertion block: \n" + 
  "  at index 0, forNo failed, because 1 element satisfied the assertion block at index 0 in " + xs(0) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + "), \n" + 
  "  at index 1, forNo failed, because 1 element satisfied the assertion block at index 0 in " + xs(1) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + ") \n" + 
  "in " + xs))
  }
  def `forExactly and forBetween when nest should throw TestFailedException with correct stack depth and error message when failed` {
    val xs = List(List(2, 4, 6, 8), List(8, 10, 12, 16))
    val e = intercept[exceptions.TestFailedException] {
      forExactly(1, xs) { l =>
        forBetween(2, 4, l) { n =>
          assert(n % 2 == 1, n % 2 + " was not equal to 1")
        }
      }
    }
    assert(e.failedCodeFileName == Some("NestedInspectorsSpec.scala"), e.failedCodeFileName + " did not equal " + Some("NestedInspectorsSpec.scala"))
    assert(e.failedCodeLineNumber == Some(thisLineNumber - 7), e.failedCodeLineNumber + " did not equal " + Some(thisLineNumber - 7))
    val outerForLineNumber = thisLineNumber - 8
    val innerForLineNumber = thisLineNumber - 8
    val assertLineNumber = thisLineNumber - 8
    assert(e.message == Some(
  "forExactly(1) failed, because no element satisfied the assertion block: \n" + 
  "  at index 0, forBetween(2, 4) failed, because no element satisfied the assertion block: \n" + 
  "    at index 0, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 1, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 2, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 3, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + ") \n" + 
  "  in " + xs(0) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + "), \n" + 
  "  at index 1, forBetween(2, 4) failed, because no element satisfied the assertion block: \n" + 
  "    at index 0, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 1, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 2, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 3, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + ") \n" + 
  "  in " + xs(1) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + ") \n" + 
  "in " + xs), e.message + " did not equal " + Some(
  "forExactly(1) failed, because no element satisfied the assertion block: \n" + 
  "  at index 0, forBetween(2, 4) failed, because no element satisfied the assertion block: \n" + 
  "    at index 0, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 1, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 2, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 3, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + ") \n" + 
  "  in " + xs(0) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + "), \n" + 
  "  at index 1, forBetween(2, 4) failed, because no element satisfied the assertion block: \n" + 
  "    at index 0, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 1, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 2, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 3, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + ") \n" + 
  "  in " + xs(1) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + ") \n" + 
  "in " + xs))
  }
  def `forExactly and forEvery when nest should throw TestFailedException with correct stack depth and error message when failed` {
    val xs = List(List(2, 4, 6, 8), List(8, 10, 12, 16))
    val e = intercept[exceptions.TestFailedException] {
      forExactly(1, xs) { l =>
        forEvery(l) { n =>
          assert(n % 2 == 1, n % 2 + " was not equal to 1")
        }
      }
    }
    assert(e.failedCodeFileName == Some("NestedInspectorsSpec.scala"), e.failedCodeFileName + " did not equal " + Some("NestedInspectorsSpec.scala"))
    assert(e.failedCodeLineNumber == Some(thisLineNumber - 7), e.failedCodeLineNumber + " did not equal " + Some(thisLineNumber - 7))
    val outerForLineNumber = thisLineNumber - 8
    val innerForLineNumber = thisLineNumber - 8
    val assertLineNumber = thisLineNumber - 8
    assert(e.message == Some(
  "forExactly(1) failed, because no element satisfied the assertion block: \n" + 
  "  at index 0, forEvery failed, because: \n" + 
  "    at index 0, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 1, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 2, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 3, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + ") \n" + 
  "  in " + xs(0) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + "), \n" + 
  "  at index 1, forEvery failed, because: \n" + 
  "    at index 0, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 1, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 2, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 3, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + ") \n" + 
  "  in " + xs(1) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + ") \n" + 
  "in " + xs), e.message + " did not equal " + Some(
  "forExactly(1) failed, because no element satisfied the assertion block: \n" + 
  "  at index 0, forEvery failed, because: \n" + 
  "    at index 0, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 1, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 2, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 3, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + ") \n" + 
  "  in " + xs(0) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + "), \n" + 
  "  at index 1, forEvery failed, because: \n" + 
  "    at index 0, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 1, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 2, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 3, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + ") \n" + 
  "  in " + xs(1) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + ") \n" + 
  "in " + xs))
  }
  def `forNo and forAll when nest should throw TestFailedException with correct stack depth and error message when failed` {
    val xs = List(List(2, 4, 6, 8), List(8, 10, 12, 16))
    val e = intercept[exceptions.TestFailedException] {
      forNo(xs) { l =>
        forAll(l) { n =>
          assert(n % 2 == 0, n % 2 + " was not equal to 0")
        }
      }
    }
    assert(e.failedCodeFileName == Some("NestedInspectorsSpec.scala"), e.failedCodeFileName + " did not equal " + Some("NestedInspectorsSpec.scala"))
    assert(e.failedCodeLineNumber == Some(thisLineNumber - 7), e.failedCodeLineNumber + " did not equal " + Some(thisLineNumber - 7))
    val outerForLineNumber = thisLineNumber - 8
    val innerForLineNumber = thisLineNumber - 8
    val assertLineNumber = thisLineNumber - 8
    assert(e.message == Some(
  "forNo failed, because 1 element satisfied the assertion block at index 0 in " + xs), e.message + " did not equal " + Some(
  "forNo failed, because 1 element satisfied the assertion block at index 0 in " + xs))
  }
  def `forNo and forAtLeast when nest should throw TestFailedException with correct stack depth and error message when failed` {
    val xs = List(List(2, 4, 6, 8), List(8, 10, 12, 16))
    val e = intercept[exceptions.TestFailedException] {
      forNo(xs) { l =>
        forAtLeast(3, l) { n =>
          assert(n % 2 == 0, n % 2 + " was not equal to 0")
        }
      }
    }
    assert(e.failedCodeFileName == Some("NestedInspectorsSpec.scala"), e.failedCodeFileName + " did not equal " + Some("NestedInspectorsSpec.scala"))
    assert(e.failedCodeLineNumber == Some(thisLineNumber - 7), e.failedCodeLineNumber + " did not equal " + Some(thisLineNumber - 7))
    val outerForLineNumber = thisLineNumber - 8
    val innerForLineNumber = thisLineNumber - 8
    val assertLineNumber = thisLineNumber - 8
    assert(e.message == Some(
  "forNo failed, because 1 element satisfied the assertion block at index 0 in " + xs), e.message + " did not equal " + Some(
  "forNo failed, because 1 element satisfied the assertion block at index 0 in " + xs))
  }
  def `forNo and forAtMost when nest should throw TestFailedException with correct stack depth and error message when failed` {
    val xs = List(List(2, 4, 6, 8), List(8, 10, 12, 16))
    val e = intercept[exceptions.TestFailedException] {
      forNo(xs) { l =>
        forAtMost(3, l) { n =>
          assert(n % 2 == 1, n % 2 + " was not equal to 1")
        }
      }
    }
    assert(e.failedCodeFileName == Some("NestedInspectorsSpec.scala"), e.failedCodeFileName + " did not equal " + Some("NestedInspectorsSpec.scala"))
    assert(e.failedCodeLineNumber == Some(thisLineNumber - 7), e.failedCodeLineNumber + " did not equal " + Some(thisLineNumber - 7))
    val outerForLineNumber = thisLineNumber - 8
    val innerForLineNumber = thisLineNumber - 8
    val assertLineNumber = thisLineNumber - 8
    assert(e.message == Some(
  "forNo failed, because 1 element satisfied the assertion block at index 0 in " + xs), e.message + " did not equal " + Some(
  "forNo failed, because 1 element satisfied the assertion block at index 0 in " + xs))
  }
  def `forNo and forExactly when nest should throw TestFailedException with correct stack depth and error message when failed` {
    val xs = List(List(2, 4, 6, 8), List(8, 10, 12, 16))
    val e = intercept[exceptions.TestFailedException] {
      forNo(xs) { l =>
        forExactly(4, l) { n =>
          assert(n % 2 == 0, n % 2 + " was not equal to 0")
        }
      }
    }
    assert(e.failedCodeFileName == Some("NestedInspectorsSpec.scala"), e.failedCodeFileName + " did not equal " + Some("NestedInspectorsSpec.scala"))
    assert(e.failedCodeLineNumber == Some(thisLineNumber - 7), e.failedCodeLineNumber + " did not equal " + Some(thisLineNumber - 7))
    val outerForLineNumber = thisLineNumber - 8
    val innerForLineNumber = thisLineNumber - 8
    val assertLineNumber = thisLineNumber - 8
    assert(e.message == Some(
  "forNo failed, because 1 element satisfied the assertion block at index 0 in " + xs), e.message + " did not equal " + Some(
  "forNo failed, because 1 element satisfied the assertion block at index 0 in " + xs))
  }
  def `forNo and forNo when nest should throw TestFailedException with correct stack depth and error message when failed` {
    val xs = List(List(2, 4, 6, 8), List(8, 10, 12, 16))
    val e = intercept[exceptions.TestFailedException] {
      forNo(xs) { l =>
        forNo(l) { n =>
          assert(n % 2 == 1, n % 2 + " was not equal to 1")
        }
      }
    }
    assert(e.failedCodeFileName == Some("NestedInspectorsSpec.scala"), e.failedCodeFileName + " did not equal " + Some("NestedInspectorsSpec.scala"))
    assert(e.failedCodeLineNumber == Some(thisLineNumber - 7), e.failedCodeLineNumber + " did not equal " + Some(thisLineNumber - 7))
    val outerForLineNumber = thisLineNumber - 8
    val innerForLineNumber = thisLineNumber - 8
    val assertLineNumber = thisLineNumber - 8
    assert(e.message == Some(
  "forNo failed, because 1 element satisfied the assertion block at index 0 in " + xs), e.message + " did not equal " + Some(
  "forNo failed, because 1 element satisfied the assertion block at index 0 in " + xs))
  }
  def `forNo and forBetween when nest should throw TestFailedException with correct stack depth and error message when failed` {
    val xs = List(List(2, 4, 6, 8), List(8, 10, 12, 16))
    val e = intercept[exceptions.TestFailedException] {
      forNo(xs) { l =>
        forBetween(2, 4, l) { n =>
          assert(n % 2 == 0, n % 2 + " was not equal to 0")
        }
      }
    }
    assert(e.failedCodeFileName == Some("NestedInspectorsSpec.scala"), e.failedCodeFileName + " did not equal " + Some("NestedInspectorsSpec.scala"))
    assert(e.failedCodeLineNumber == Some(thisLineNumber - 7), e.failedCodeLineNumber + " did not equal " + Some(thisLineNumber - 7))
    val outerForLineNumber = thisLineNumber - 8
    val innerForLineNumber = thisLineNumber - 8
    val assertLineNumber = thisLineNumber - 8
    assert(e.message == Some(
  "forNo failed, because 1 element satisfied the assertion block at index 0 in " + xs), e.message + " did not equal " + Some(
  "forNo failed, because 1 element satisfied the assertion block at index 0 in " + xs))
  }
  def `forNo and forEvery when nest should throw TestFailedException with correct stack depth and error message when failed` {
    val xs = List(List(2, 4, 6, 8), List(8, 10, 12, 16))
    val e = intercept[exceptions.TestFailedException] {
      forNo(xs) { l =>
        forEvery(l) { n =>
          assert(n % 2 == 0, n % 2 + " was not equal to 0")
        }
      }
    }
    assert(e.failedCodeFileName == Some("NestedInspectorsSpec.scala"), e.failedCodeFileName + " did not equal " + Some("NestedInspectorsSpec.scala"))
    assert(e.failedCodeLineNumber == Some(thisLineNumber - 7), e.failedCodeLineNumber + " did not equal " + Some(thisLineNumber - 7))
    val outerForLineNumber = thisLineNumber - 8
    val innerForLineNumber = thisLineNumber - 8
    val assertLineNumber = thisLineNumber - 8
    assert(e.message == Some(
  "forNo failed, because 1 element satisfied the assertion block at index 0 in " + xs), e.message + " did not equal " + Some(
  "forNo failed, because 1 element satisfied the assertion block at index 0 in " + xs))
  }
  def `forBetween and forAll when nest should throw TestFailedException with correct stack depth and error message when failed` {
    val xs = List(List(2, 4, 6, 8), List(8, 10, 12, 16))
    val e = intercept[exceptions.TestFailedException] {
      forBetween(2, 4, xs) { l =>
        forAll(l) { n =>
          assert(n % 2 == 1, n % 2 + " was not equal to 1")
        }
      }
    }
    assert(e.failedCodeFileName == Some("NestedInspectorsSpec.scala"), e.failedCodeFileName + " did not equal " + Some("NestedInspectorsSpec.scala"))
    assert(e.failedCodeLineNumber == Some(thisLineNumber - 7), e.failedCodeLineNumber + " did not equal " + Some(thisLineNumber - 7))
    val outerForLineNumber = thisLineNumber - 8
    val innerForLineNumber = thisLineNumber - 8
    val assertLineNumber = thisLineNumber - 8
    assert(e.message == Some(
  "forBetween(2, 4) failed, because no element satisfied the assertion block: \n" + 
  "  at index 0, forAll failed, because: \n" + 
  "    at index 0, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + ") \n" + 
  "  in " + xs(0) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + "), \n" + 
  "  at index 1, forAll failed, because: \n" + 
  "    at index 0, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + ") \n" + 
  "  in " + xs(1) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + ") \n" + 
  "in " + xs), e.message + " did not equal " + Some(
  "forBetween(2, 4) failed, because no element satisfied the assertion block: \n" + 
  "  at index 0, forAll failed, because: \n" + 
  "    at index 0, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + ") \n" + 
  "  in " + xs(0) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + "), \n" + 
  "  at index 1, forAll failed, because: \n" + 
  "    at index 0, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + ") \n" + 
  "  in " + xs(1) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + ") \n" + 
  "in " + xs))
  }
  def `forBetween and forAtLeast when nest should throw TestFailedException with correct stack depth and error message when failed` {
    val xs = List(List(2, 4, 6, 8), List(8, 10, 12, 16))
    val e = intercept[exceptions.TestFailedException] {
      forBetween(2, 4, xs) { l =>
        forAtLeast(3, l) { n =>
          assert(n % 2 == 1, n % 2 + " was not equal to 1")
        }
      }
    }
    assert(e.failedCodeFileName == Some("NestedInspectorsSpec.scala"), e.failedCodeFileName + " did not equal " + Some("NestedInspectorsSpec.scala"))
    assert(e.failedCodeLineNumber == Some(thisLineNumber - 7), e.failedCodeLineNumber + " did not equal " + Some(thisLineNumber - 7))
    val outerForLineNumber = thisLineNumber - 8
    val innerForLineNumber = thisLineNumber - 8
    val assertLineNumber = thisLineNumber - 8
    assert(e.message == Some(
  "forBetween(2, 4) failed, because no element satisfied the assertion block: \n" + 
  "  at index 0, forAtLeast(3) failed, because no element satisfied the assertion block: \n" + 
  "    at index 0, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 1, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 2, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 3, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + ") \n" + 
  "  in " + xs(0) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + "), \n" + 
  "  at index 1, forAtLeast(3) failed, because no element satisfied the assertion block: \n" + 
  "    at index 0, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 1, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 2, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 3, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + ") \n" + 
  "  in " + xs(1) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + ") \n" + 
  "in " + xs), e.message + " did not equal " + Some(
  "forBetween(2, 4) failed, because no element satisfied the assertion block: \n" + 
  "  at index 0, forAtLeast(3) failed, because no element satisfied the assertion block: \n" + 
  "    at index 0, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 1, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 2, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 3, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + ") \n" + 
  "  in " + xs(0) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + "), \n" + 
  "  at index 1, forAtLeast(3) failed, because no element satisfied the assertion block: \n" + 
  "    at index 0, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 1, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 2, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 3, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + ") \n" + 
  "  in " + xs(1) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + ") \n" + 
  "in " + xs))
  }
  def `forBetween and forAtMost when nest should throw TestFailedException with correct stack depth and error message when failed` {
    val xs = List(List(2, 4, 6, 8), List(8, 10, 12, 16))
    val e = intercept[exceptions.TestFailedException] {
      forBetween(2, 4, xs) { l =>
        forAtMost(3, l) { n =>
          assert(n % 2 == 0, n % 2 + " was not equal to 0")
        }
      }
    }
    assert(e.failedCodeFileName == Some("NestedInspectorsSpec.scala"), e.failedCodeFileName + " did not equal " + Some("NestedInspectorsSpec.scala"))
    assert(e.failedCodeLineNumber == Some(thisLineNumber - 7), e.failedCodeLineNumber + " did not equal " + Some(thisLineNumber - 7))
    val outerForLineNumber = thisLineNumber - 8
    val innerForLineNumber = thisLineNumber - 8
    val assertLineNumber = thisLineNumber - 8
    assert(e.message == Some(
  "forBetween(2, 4) failed, because no element satisfied the assertion block: \n" + 
  "  at index 0, forAtMost(3) failed, because 4 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqualBoolean(xs(0), false, 4) + " in " + xs(0) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + "), \n" + 
  "  at index 1, forAtMost(3) failed, because 4 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqualBoolean(xs(1), false, 4) + " in " + xs(1) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + ") \n" + 
  "in " + xs), e.message + " did not equal " + Some(
  "forBetween(2, 4) failed, because no element satisfied the assertion block: \n" + 
  "  at index 0, forAtMost(3) failed, because 4 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqualBoolean(xs(0), false, 4) + " in " + xs(0) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + "), \n" + 
  "  at index 1, forAtMost(3) failed, because 4 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqualBoolean(xs(1), false, 4) + " in " + xs(1) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + ") \n" + 
  "in " + xs))
  }
  def `forBetween and forExactly when nest should throw TestFailedException with correct stack depth and error message when failed` {
    val xs = List(List(2, 4, 6, 8), List(8, 10, 12, 16))
    val e = intercept[exceptions.TestFailedException] {
      forBetween(2, 4, xs) { l =>
        forExactly(4, l) { n =>
          assert(n % 2 == 1, n % 2 + " was not equal to 1")
        }
      }
    }
    assert(e.failedCodeFileName == Some("NestedInspectorsSpec.scala"), e.failedCodeFileName + " did not equal " + Some("NestedInspectorsSpec.scala"))
    assert(e.failedCodeLineNumber == Some(thisLineNumber - 7), e.failedCodeLineNumber + " did not equal " + Some(thisLineNumber - 7))
    val outerForLineNumber = thisLineNumber - 8
    val innerForLineNumber = thisLineNumber - 8
    val assertLineNumber = thisLineNumber - 8
    assert(e.message == Some(
  "forBetween(2, 4) failed, because no element satisfied the assertion block: \n" + 
  "  at index 0, forExactly(4) failed, because no element satisfied the assertion block: \n" + 
  "    at index 0, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 1, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 2, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 3, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + ") \n" + 
  "  in " + xs(0) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + "), \n" + 
  "  at index 1, forExactly(4) failed, because no element satisfied the assertion block: \n" + 
  "    at index 0, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 1, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 2, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 3, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + ") \n" + 
  "  in " + xs(1) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + ") \n" + 
  "in " + xs), e.message + " did not equal " + Some(
  "forBetween(2, 4) failed, because no element satisfied the assertion block: \n" + 
  "  at index 0, forExactly(4) failed, because no element satisfied the assertion block: \n" + 
  "    at index 0, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 1, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 2, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 3, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + ") \n" + 
  "  in " + xs(0) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + "), \n" + 
  "  at index 1, forExactly(4) failed, because no element satisfied the assertion block: \n" + 
  "    at index 0, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 1, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 2, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 3, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + ") \n" + 
  "  in " + xs(1) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + ") \n" + 
  "in " + xs))
  }
  def `forBetween and forNo when nest should throw TestFailedException with correct stack depth and error message when failed` {
    val xs = List(List(2, 4, 6, 8), List(8, 10, 12, 16))
    val e = intercept[exceptions.TestFailedException] {
      forBetween(2, 4, xs) { l =>
        forNo(l) { n =>
          assert(n % 2 == 0, n % 2 + " was not equal to 0")
        }
      }
    }
    assert(e.failedCodeFileName == Some("NestedInspectorsSpec.scala"), e.failedCodeFileName + " did not equal " + Some("NestedInspectorsSpec.scala"))
    assert(e.failedCodeLineNumber == Some(thisLineNumber - 7), e.failedCodeLineNumber + " did not equal " + Some(thisLineNumber - 7))
    val outerForLineNumber = thisLineNumber - 8
    val innerForLineNumber = thisLineNumber - 8
    val assertLineNumber = thisLineNumber - 8
    assert(e.message == Some(
  "forBetween(2, 4) failed, because no element satisfied the assertion block: \n" + 
  "  at index 0, forNo failed, because 1 element satisfied the assertion block at index 0 in " + xs(0) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + "), \n" + 
  "  at index 1, forNo failed, because 1 element satisfied the assertion block at index 0 in " + xs(1) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + ") \n" + 
  "in " + xs), e.message + " did not equal " + Some(
  "forBetween(2, 4) failed, because no element satisfied the assertion block: \n" + 
  "  at index 0, forNo failed, because 1 element satisfied the assertion block at index 0 in " + xs(0) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + "), \n" + 
  "  at index 1, forNo failed, because 1 element satisfied the assertion block at index 0 in " + xs(1) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + ") \n" + 
  "in " + xs))
  }
  def `forBetween and forBetween when nest should throw TestFailedException with correct stack depth and error message when failed` {
    val xs = List(List(2, 4, 6, 8), List(8, 10, 12, 16))
    val e = intercept[exceptions.TestFailedException] {
      forBetween(2, 4, xs) { l =>
        forBetween(2, 4, l) { n =>
          assert(n % 2 == 1, n % 2 + " was not equal to 1")
        }
      }
    }
    assert(e.failedCodeFileName == Some("NestedInspectorsSpec.scala"), e.failedCodeFileName + " did not equal " + Some("NestedInspectorsSpec.scala"))
    assert(e.failedCodeLineNumber == Some(thisLineNumber - 7), e.failedCodeLineNumber + " did not equal " + Some(thisLineNumber - 7))
    val outerForLineNumber = thisLineNumber - 8
    val innerForLineNumber = thisLineNumber - 8
    val assertLineNumber = thisLineNumber - 8
    assert(e.message == Some(
  "forBetween(2, 4) failed, because no element satisfied the assertion block: \n" + 
  "  at index 0, forBetween(2, 4) failed, because no element satisfied the assertion block: \n" + 
  "    at index 0, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 1, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 2, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 3, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + ") \n" + 
  "  in " + xs(0) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + "), \n" + 
  "  at index 1, forBetween(2, 4) failed, because no element satisfied the assertion block: \n" + 
  "    at index 0, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 1, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 2, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 3, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + ") \n" + 
  "  in " + xs(1) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + ") \n" + 
  "in " + xs), e.message + " did not equal " + Some(
  "forBetween(2, 4) failed, because no element satisfied the assertion block: \n" + 
  "  at index 0, forBetween(2, 4) failed, because no element satisfied the assertion block: \n" + 
  "    at index 0, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 1, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 2, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 3, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + ") \n" + 
  "  in " + xs(0) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + "), \n" + 
  "  at index 1, forBetween(2, 4) failed, because no element satisfied the assertion block: \n" + 
  "    at index 0, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 1, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 2, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 3, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + ") \n" + 
  "  in " + xs(1) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + ") \n" + 
  "in " + xs))
  }
  def `forBetween and forEvery when nest should throw TestFailedException with correct stack depth and error message when failed` {
    val xs = List(List(2, 4, 6, 8), List(8, 10, 12, 16))
    val e = intercept[exceptions.TestFailedException] {
      forBetween(2, 4, xs) { l =>
        forEvery(l) { n =>
          assert(n % 2 == 1, n % 2 + " was not equal to 1")
        }
      }
    }
    assert(e.failedCodeFileName == Some("NestedInspectorsSpec.scala"), e.failedCodeFileName + " did not equal " + Some("NestedInspectorsSpec.scala"))
    assert(e.failedCodeLineNumber == Some(thisLineNumber - 7), e.failedCodeLineNumber + " did not equal " + Some(thisLineNumber - 7))
    val outerForLineNumber = thisLineNumber - 8
    val innerForLineNumber = thisLineNumber - 8
    val assertLineNumber = thisLineNumber - 8
    assert(e.message == Some(
  "forBetween(2, 4) failed, because no element satisfied the assertion block: \n" + 
  "  at index 0, forEvery failed, because: \n" + 
  "    at index 0, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 1, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 2, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 3, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + ") \n" + 
  "  in " + xs(0) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + "), \n" + 
  "  at index 1, forEvery failed, because: \n" + 
  "    at index 0, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 1, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 2, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 3, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + ") \n" + 
  "  in " + xs(1) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + ") \n" + 
  "in " + xs), e.message + " did not equal " + Some(
  "forBetween(2, 4) failed, because no element satisfied the assertion block: \n" + 
  "  at index 0, forEvery failed, because: \n" + 
  "    at index 0, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 1, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 2, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 3, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + ") \n" + 
  "  in " + xs(0) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + "), \n" + 
  "  at index 1, forEvery failed, because: \n" + 
  "    at index 0, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 1, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 2, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 3, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + ") \n" + 
  "  in " + xs(1) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + ") \n" + 
  "in " + xs))
  }
  def `forEvery and forAll when nest should throw TestFailedException with correct stack depth and error message when failed` {
    val xs = List(List(2, 4, 6, 8), List(8, 10, 12, 16))
    val e = intercept[exceptions.TestFailedException] {
      forEvery(xs) { l =>
        forAll(l) { n =>
          assert(n % 2 == 1, n % 2 + " was not equal to 1")
        }
      }
    }
    assert(e.failedCodeFileName == Some("NestedInspectorsSpec.scala"), e.failedCodeFileName + " did not equal " + Some("NestedInspectorsSpec.scala"))
    assert(e.failedCodeLineNumber == Some(thisLineNumber - 7), e.failedCodeLineNumber + " did not equal " + Some(thisLineNumber - 7))
    val outerForLineNumber = thisLineNumber - 8
    val innerForLineNumber = thisLineNumber - 8
    val assertLineNumber = thisLineNumber - 8
    assert(e.message == Some(
  "forEvery failed, because: \n" + 
  "  at index 0, forAll failed, because: \n" + 
  "    at index 0, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + ") \n" + 
  "  in " + xs(0) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + "), \n" + 
  "  at index 1, forAll failed, because: \n" + 
  "    at index 0, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + ") \n" + 
  "  in " + xs(1) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + ") \n" + 
  "in " + xs), e.message + " did not equal " + Some(
  "forEvery failed, because: \n" + 
  "  at index 0, forAll failed, because: \n" + 
  "    at index 0, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + ") \n" + 
  "  in " + xs(0) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + "), \n" + 
  "  at index 1, forAll failed, because: \n" + 
  "    at index 0, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + ") \n" + 
  "  in " + xs(1) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + ") \n" + 
  "in " + xs))
  }
  def `forEvery and forAtLeast when nest should throw TestFailedException with correct stack depth and error message when failed` {
    val xs = List(List(2, 4, 6, 8), List(8, 10, 12, 16))
    val e = intercept[exceptions.TestFailedException] {
      forEvery(xs) { l =>
        forAtLeast(3, l) { n =>
          assert(n % 2 == 1, n % 2 + " was not equal to 1")
        }
      }
    }
    assert(e.failedCodeFileName == Some("NestedInspectorsSpec.scala"), e.failedCodeFileName + " did not equal " + Some("NestedInspectorsSpec.scala"))
    assert(e.failedCodeLineNumber == Some(thisLineNumber - 7), e.failedCodeLineNumber + " did not equal " + Some(thisLineNumber - 7))
    val outerForLineNumber = thisLineNumber - 8
    val innerForLineNumber = thisLineNumber - 8
    val assertLineNumber = thisLineNumber - 8
    assert(e.message == Some(
  "forEvery failed, because: \n" + 
  "  at index 0, forAtLeast(3) failed, because no element satisfied the assertion block: \n" + 
  "    at index 0, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 1, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 2, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 3, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + ") \n" + 
  "  in " + xs(0) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + "), \n" + 
  "  at index 1, forAtLeast(3) failed, because no element satisfied the assertion block: \n" + 
  "    at index 0, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 1, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 2, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 3, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + ") \n" + 
  "  in " + xs(1) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + ") \n" + 
  "in " + xs), e.message + " did not equal " + Some(
  "forEvery failed, because: \n" + 
  "  at index 0, forAtLeast(3) failed, because no element satisfied the assertion block: \n" + 
  "    at index 0, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 1, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 2, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 3, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + ") \n" + 
  "  in " + xs(0) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + "), \n" + 
  "  at index 1, forAtLeast(3) failed, because no element satisfied the assertion block: \n" + 
  "    at index 0, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 1, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 2, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 3, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + ") \n" + 
  "  in " + xs(1) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + ") \n" + 
  "in " + xs))
  }
  def `forEvery and forAtMost when nest should throw TestFailedException with correct stack depth and error message when failed` {
    val xs = List(List(2, 4, 6, 8), List(8, 10, 12, 16))
    val e = intercept[exceptions.TestFailedException] {
      forEvery(xs) { l =>
        forAtMost(3, l) { n =>
          assert(n % 2 == 0, n % 2 + " was not equal to 0")
        }
      }
    }
    assert(e.failedCodeFileName == Some("NestedInspectorsSpec.scala"), e.failedCodeFileName + " did not equal " + Some("NestedInspectorsSpec.scala"))
    assert(e.failedCodeLineNumber == Some(thisLineNumber - 7), e.failedCodeLineNumber + " did not equal " + Some(thisLineNumber - 7))
    val outerForLineNumber = thisLineNumber - 8
    val innerForLineNumber = thisLineNumber - 8
    val assertLineNumber = thisLineNumber - 8
    assert(e.message == Some(
  "forEvery failed, because: \n" + 
  "  at index 0, forAtMost(3) failed, because 4 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqualBoolean(xs(0), false, 4) + " in " + xs(0) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + "), \n" + 
  "  at index 1, forAtMost(3) failed, because 4 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqualBoolean(xs(1), false, 4) + " in " + xs(1) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + ") \n" + 
  "in " + xs), e.message + " did not equal " + Some(
  "forEvery failed, because: \n" + 
  "  at index 0, forAtMost(3) failed, because 4 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqualBoolean(xs(0), false, 4) + " in " + xs(0) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + "), \n" + 
  "  at index 1, forAtMost(3) failed, because 4 elements satisfied the assertion block at " + failEarlySucceededIndexesNotEqualBoolean(xs(1), false, 4) + " in " + xs(1) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + ") \n" + 
  "in " + xs))
  }
  def `forEvery and forExactly when nest should throw TestFailedException with correct stack depth and error message when failed` {
    val xs = List(List(2, 4, 6, 8), List(8, 10, 12, 16))
    val e = intercept[exceptions.TestFailedException] {
      forEvery(xs) { l =>
        forExactly(4, l) { n =>
          assert(n % 2 == 1, n % 2 + " was not equal to 1")
        }
      }
    }
    assert(e.failedCodeFileName == Some("NestedInspectorsSpec.scala"), e.failedCodeFileName + " did not equal " + Some("NestedInspectorsSpec.scala"))
    assert(e.failedCodeLineNumber == Some(thisLineNumber - 7), e.failedCodeLineNumber + " did not equal " + Some(thisLineNumber - 7))
    val outerForLineNumber = thisLineNumber - 8
    val innerForLineNumber = thisLineNumber - 8
    val assertLineNumber = thisLineNumber - 8
    assert(e.message == Some(
  "forEvery failed, because: \n" + 
  "  at index 0, forExactly(4) failed, because no element satisfied the assertion block: \n" + 
  "    at index 0, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 1, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 2, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 3, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + ") \n" + 
  "  in " + xs(0) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + "), \n" + 
  "  at index 1, forExactly(4) failed, because no element satisfied the assertion block: \n" + 
  "    at index 0, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 1, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 2, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 3, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + ") \n" + 
  "  in " + xs(1) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + ") \n" + 
  "in " + xs), e.message + " did not equal " + Some(
  "forEvery failed, because: \n" + 
  "  at index 0, forExactly(4) failed, because no element satisfied the assertion block: \n" + 
  "    at index 0, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 1, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 2, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 3, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + ") \n" + 
  "  in " + xs(0) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + "), \n" + 
  "  at index 1, forExactly(4) failed, because no element satisfied the assertion block: \n" + 
  "    at index 0, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 1, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 2, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 3, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + ") \n" + 
  "  in " + xs(1) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + ") \n" + 
  "in " + xs))
  }
  def `forEvery and forNo when nest should throw TestFailedException with correct stack depth and error message when failed` {
    val xs = List(List(2, 4, 6, 8), List(8, 10, 12, 16))
    val e = intercept[exceptions.TestFailedException] {
      forEvery(xs) { l =>
        forNo(l) { n =>
          assert(n % 2 == 0, n % 2 + " was not equal to 0")
        }
      }
    }
    assert(e.failedCodeFileName == Some("NestedInspectorsSpec.scala"), e.failedCodeFileName + " did not equal " + Some("NestedInspectorsSpec.scala"))
    assert(e.failedCodeLineNumber == Some(thisLineNumber - 7), e.failedCodeLineNumber + " did not equal " + Some(thisLineNumber - 7))
    val outerForLineNumber = thisLineNumber - 8
    val innerForLineNumber = thisLineNumber - 8
    val assertLineNumber = thisLineNumber - 8
    assert(e.message == Some(
  "forEvery failed, because: \n" + 
  "  at index 0, forNo failed, because 1 element satisfied the assertion block at index 0 in " + xs(0) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + "), \n" + 
  "  at index 1, forNo failed, because 1 element satisfied the assertion block at index 0 in " + xs(1) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + ") \n" + 
  "in " + xs), e.message + " did not equal " + Some(
  "forEvery failed, because: \n" + 
  "  at index 0, forNo failed, because 1 element satisfied the assertion block at index 0 in " + xs(0) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + "), \n" + 
  "  at index 1, forNo failed, because 1 element satisfied the assertion block at index 0 in " + xs(1) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + ") \n" + 
  "in " + xs))
  }
  def `forEvery and forBetween when nest should throw TestFailedException with correct stack depth and error message when failed` {
    val xs = List(List(2, 4, 6, 8), List(8, 10, 12, 16))
    val e = intercept[exceptions.TestFailedException] {
      forEvery(xs) { l =>
        forBetween(2, 4, l) { n =>
          assert(n % 2 == 1, n % 2 + " was not equal to 1")
        }
      }
    }
    assert(e.failedCodeFileName == Some("NestedInspectorsSpec.scala"), e.failedCodeFileName + " did not equal " + Some("NestedInspectorsSpec.scala"))
    assert(e.failedCodeLineNumber == Some(thisLineNumber - 7), e.failedCodeLineNumber + " did not equal " + Some(thisLineNumber - 7))
    val outerForLineNumber = thisLineNumber - 8
    val innerForLineNumber = thisLineNumber - 8
    val assertLineNumber = thisLineNumber - 8
    assert(e.message == Some(
  "forEvery failed, because: \n" + 
  "  at index 0, forBetween(2, 4) failed, because no element satisfied the assertion block: \n" + 
  "    at index 0, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 1, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 2, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 3, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + ") \n" + 
  "  in " + xs(0) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + "), \n" + 
  "  at index 1, forBetween(2, 4) failed, because no element satisfied the assertion block: \n" + 
  "    at index 0, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 1, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 2, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 3, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + ") \n" + 
  "  in " + xs(1) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + ") \n" + 
  "in " + xs), e.message + " did not equal " + Some(
  "forEvery failed, because: \n" + 
  "  at index 0, forBetween(2, 4) failed, because no element satisfied the assertion block: \n" + 
  "    at index 0, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 1, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 2, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 3, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + ") \n" + 
  "  in " + xs(0) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + "), \n" + 
  "  at index 1, forBetween(2, 4) failed, because no element satisfied the assertion block: \n" + 
  "    at index 0, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 1, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 2, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 3, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + ") \n" + 
  "  in " + xs(1) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + ") \n" + 
  "in " + xs))
  }
  def `forEvery and forEvery when nest should throw TestFailedException with correct stack depth and error message when failed` {
    val xs = List(List(2, 4, 6, 8), List(8, 10, 12, 16))
    val e = intercept[exceptions.TestFailedException] {
      forEvery(xs) { l =>
        forEvery(l) { n =>
          assert(n % 2 == 1, n % 2 + " was not equal to 1")
        }
      }
    }
    assert(e.failedCodeFileName == Some("NestedInspectorsSpec.scala"), e.failedCodeFileName + " did not equal " + Some("NestedInspectorsSpec.scala"))
    assert(e.failedCodeLineNumber == Some(thisLineNumber - 7), e.failedCodeLineNumber + " did not equal " + Some(thisLineNumber - 7))
    val outerForLineNumber = thisLineNumber - 8
    val innerForLineNumber = thisLineNumber - 8
    val assertLineNumber = thisLineNumber - 8
    assert(e.message == Some(
  "forEvery failed, because: \n" + 
  "  at index 0, forEvery failed, because: \n" + 
  "    at index 0, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 1, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 2, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 3, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + ") \n" + 
  "  in " + xs(0) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + "), \n" + 
  "  at index 1, forEvery failed, because: \n" + 
  "    at index 0, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 1, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 2, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 3, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + ") \n" + 
  "  in " + xs(1) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + ") \n" + 
  "in " + xs), e.message + " did not equal " + Some(
  "forEvery failed, because: \n" + 
  "  at index 0, forEvery failed, because: \n" + 
  "    at index 0, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 1, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 2, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 3, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + ") \n" + 
  "  in " + xs(0) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + "), \n" + 
  "  at index 1, forEvery failed, because: \n" + 
  "    at index 0, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 1, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 2, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + "), \n" + 
  "    at index 3, 0 was not equal to 1 (NestedInspectorsSpec.scala:" + assertLineNumber + ") \n" + 
  "  in " + xs(1) + " (NestedInspectorsSpec.scala:" + innerForLineNumber + ") \n" + 
  "in " + xs))
  }
}
