package org.scalatest.inspectors.no

import org.scalatest._
import SharedHelpers._
import org.scalatest.matchers.{BePropertyMatcher, BePropertyMatchResult, HavePropertyMatcher, HavePropertyMatchResult}
import collection.GenTraversable
import collection.GenMap
class InspectorShorthandsForNoFailedSpec1 extends Spec with Matchers {
  class EmptyBePropertyMatcher extends BePropertyMatcher[String] {
    def apply(left: String) = BePropertyMatchResult(left.isEmpty, "empty")
  }
  class StringLengthMatcher(expectedValue: Int) extends HavePropertyMatcher[String, Int] {
    def apply(value: String) = {
      new HavePropertyMatchResult(value.length == expectedValue, "length", expectedValue, value.length)
    }
  }
  val empty = new EmptyBePropertyMatcher()
  def plength(expectedValue: Int) = new StringLengthMatcher(expectedValue)
  val theInstance = "2"
  def arrayToString(xs: GenTraversable[_]): String = xs.toString
  def checkErrorAndCause(e: exceptions.TestFailedException, assertLineNumber: Int, fileName: String, errorMessage: String, causeErrorMessage: String) {
    assert(e.failedCodeFileName == Some(fileName), e.failedCodeFileName + " did not equal " + Some(fileName))
    assert(e.failedCodeLineNumber == Some(assertLineNumber), e.failedCodeLineNumber + " did not equal " + Some(assertLineNumber))
    assert(e.message == Some(errorMessage), e.message + " did not equal " + Some(
  errorMessage))
    e.getCause match {
      case tfe: exceptions.TestFailedException =>
        assert(tfe.failedCodeFileName == Some(fileName), tfe.failedCodeFileName + " did not equal " + Some(fileName))
        assert(tfe.failedCodeLineNumber == Some(assertLineNumber), tfe.failedCodeLineNumber + " did not equal " + Some(assertLineNumber))
        assert(tfe.message == Some(causeErrorMessage), tfe.message + " did not equal " + Some(causeErrorMessage))
        assert(tfe.getCause == null, tfe.getCause + " was not null")
      case other => fail("Expected cause to be TestFailedException, but got: " + other)
    }
  }
  def checkError(e: exceptions.TestFailedException, assertLineNumber: Int, fileName: String, errorMessage: String) {
    assert(e.failedCodeFileName == Some(fileName), e.failedCodeFileName + " did not equal " + Some(fileName))
    assert(e.failedCodeLineNumber == Some(assertLineNumber), e.failedCodeLineNumber + " did not equal " + Some(assertLineNumber))
    assert(e.message == Some(errorMessage), e.message + " did not equal " + Some(
  errorMessage))
  }
  def equal[T](left: T, right: T): Boolean = left == right
  def javaArrayList[T](valueList: List[T]): java.util.ArrayList[T] = {
    val col = new java.util.ArrayList[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaHashSet[T](valueList: List[T]): java.util.HashSet[T] = {
    val col = new java.util.HashSet[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaLinkedList[T](valueList: List[T]): java.util.LinkedList[T] = {
    val col = new java.util.LinkedList[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaStack[T](valueList: List[T]): java.util.Stack[T] = {
    val col = new java.util.Stack[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaTreeSet[T](valueList: List[T]): java.util.TreeSet[T] = {
    val col = new java.util.TreeSet[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaVector[T](valueList: List[T]): java.util.Vector[T] = {
    val col = new java.util.Vector[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaArrayBlockingQueue[T](valueList: List[T], size: Int): java.util.concurrent.ArrayBlockingQueue[T] = {
    val col = new java.util.concurrent.ArrayBlockingQueue[T](size)
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaArrayDeque[T](valueList: List[T]): java.util.ArrayDeque[T] = {
    val col = new java.util.ArrayDeque[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaConcurrentLinkedQueue[T](valueList: List[T]): java.util.concurrent.ConcurrentLinkedQueue[T] = {
    val col = new java.util.concurrent.ConcurrentLinkedQueue[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaConcurrentSkipListSet[T](valueList: List[T]): java.util.concurrent.ConcurrentSkipListSet[T] = {
    val col = new java.util.concurrent.ConcurrentSkipListSet[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaCopyOnWriteArrayList[T](valueList: List[T]): java.util.concurrent.CopyOnWriteArrayList[T] = {
    val col = new java.util.concurrent.CopyOnWriteArrayList[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaCopyOnWriteArraySet[T](valueList: List[T]): java.util.concurrent.CopyOnWriteArraySet[T] = {
    val col = new java.util.concurrent.CopyOnWriteArraySet[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaLinkedBlockingDeque[T](valueList: List[T]): java.util.concurrent.LinkedBlockingDeque[T] = {
    val col = new java.util.concurrent.LinkedBlockingDeque[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaLinkedBlockingQueue[T](valueList: List[T]): java.util.concurrent.LinkedBlockingQueue[T] = {
    val col = new java.util.concurrent.LinkedBlockingQueue[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaLinkedHashSet[T](valueList: List[T]): java.util.LinkedHashSet[T] = {
    val col = new java.util.LinkedHashSet[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaPriorityBlockingQueue[T](valueList: List[T]): java.util.concurrent.PriorityBlockingQueue[T] = {
    val col = new java.util.concurrent.PriorityBlockingQueue[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaPriorityQueue[T](valueList: List[T]): java.util.PriorityQueue[T] = {
    val col = new java.util.PriorityQueue[T]()
    for (value <- valueList)
      col.add(value)
    col
  }
  def javaHashMap[K, V](valueMap: Map[K, V]): java.util.HashMap[K, V] = {
    val map = new java.util.HashMap[K, V]()
    for ((key, value) <- valueMap)
      map.put(key, value)
    map
  }
  def javaTreeMap[K, V](valueMap: Map[K, V]): java.util.TreeMap[K, V] = {
    val map = new java.util.TreeMap[K, V]()
    for ((key, value) <- valueMap)
      map.put(key, value)
    map
  }
  def javaHashtable[K, V](valueMap: Map[K, V]): java.util.Hashtable[K, V] = {
    val map = new java.util.Hashtable[K, V]()
    for ((key, value) <- valueMap)
      map.put(key, value)
    map
  }
  def javaConcurrentHashMap[K, V](valueMap: Map[K, V]): java.util.concurrent.ConcurrentHashMap[K, V] = {
    val map = new java.util.concurrent.ConcurrentHashMap[K, V]()
    for ((key, value) <- valueMap)
      map.put(key, value)
    map
  }
  def javaConcurrentSkipListMap[K, V](valueMap: Map[K, V]): java.util.concurrent.ConcurrentSkipListMap[K, V] = {
    val map = new java.util.concurrent.ConcurrentSkipListMap[K, V]()
    for ((key, value) <- valueMap)
      map.put(key, value)
    map
  }
  def javaLinkedHashMap[K, V](valueMap: Map[K, V]): java.util.LinkedHashMap[K, V] = {
    val map = new java.util.LinkedHashMap[K, V]()
    for ((key, value) <- valueMap)
      map.put(key, value)
    map
  }
  def javaWeakHashMap[K, V](valueMap: Map[K, V]): java.util.WeakHashMap[K, V] = {
    val map = new java.util.WeakHashMap[K, V]()
    for ((key, value) <- valueMap)
      map.put(key, value)
    map
  }
  def javaProperties(valueMap: Map[String, String]): java.util.Properties = {
    val map = new java.util.Properties()
    for ((key, value) <- valueMap)
      map.put(key, value)
    map
  }
  def `collection.mutable.Set("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should be property' failed` {
    val xs = collection.mutable.Set("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should be (empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstIsEmpty(xs, "")) + " in " + xs)
  }
  def `collection.mutable.Set("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should not be property' failed` {
    val xs = collection.mutable.Set("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not be empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstIsNotEmpty(xs, "")) + " in " + xs)
  }
  def `collection.mutable.Set("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should be a symbol' failed` {
    val xs = collection.mutable.Set("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should be a 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstIsEmpty(xs, "")) + " in " + xs)
  }
  def `collection.mutable.Set("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should not be a symbol' failed` {
    val xs = collection.mutable.Set("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not be a ('empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstIsNotEmpty(xs, "")) + " in " + xs)
  }
  def `collection.mutable.Set("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should be a property' failed` {
    val xs = collection.mutable.Set("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should be a empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstIsEmpty(xs, "")) + " in " + xs)
  }
  def `collection.mutable.Set("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should not be a property' failed` {
    val xs = collection.mutable.Set("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not be a (empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstIsNotEmpty(xs, "")) + " in " + xs)
  }
  def `collection.mutable.Set("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should be an symbol' failed` {
    val xs = collection.mutable.Set("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should be an 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstIsEmpty(xs, "")) + " in " + xs)
  }
  def `collection.mutable.Set("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should not be an symbol' failed` {
    val xs = collection.mutable.Set("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not be an ('empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstIsNotEmpty(xs, "")) + " in " + xs)
  }
  def `collection.mutable.Set("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should be an property' failed` {
    val xs = collection.mutable.Set("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should be an empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstIsEmpty(xs, "")) + " in " + xs)
  }
  def `collection.mutable.Set("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should not be an property' failed` {
    val xs = collection.mutable.Set("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not be an (empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstIsNotEmpty(xs, "")) + " in " + xs)
  }
  def `collection.mutable.Set("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should have property' failed` {
    val xs = collection.mutable.Set("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should have (plength(0))
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstLengthEqual(xs, 0)) + " in " + xs)
  }
  def `collection.mutable.Set("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should not have property' failed` {
    val xs = collection.mutable.Set("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not have plength(0)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstLengthNotEqual(xs, 0)) + " in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List("", "boom!", "hi")).par should throw TestFailedException with correct stack depth and message when 'should be symbol' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List("", "boom!", "hi")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should be ('empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstIsEmpty(xs, "")) + " in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List("", "boom!", "hi")).par should throw TestFailedException with correct stack depth and message when 'should not be symbol' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List("", "boom!", "hi")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not be 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstIsNotEmpty(xs, "")) + " in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List("", "boom!", "hi")).par should throw TestFailedException with correct stack depth and message when 'should be property' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List("", "boom!", "hi")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should be (empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstIsEmpty(xs, "")) + " in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List("", "boom!", "hi")).par should throw TestFailedException with correct stack depth and message when 'should not be property' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List("", "boom!", "hi")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not be empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstIsNotEmpty(xs, "")) + " in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List("", "boom!", "hi")).par should throw TestFailedException with correct stack depth and message when 'should be a symbol' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List("", "boom!", "hi")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should be a 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstIsEmpty(xs, "")) + " in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List("", "boom!", "hi")).par should throw TestFailedException with correct stack depth and message when 'should not be a symbol' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List("", "boom!", "hi")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not be a ('empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstIsNotEmpty(xs, "")) + " in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List("", "boom!", "hi")).par should throw TestFailedException with correct stack depth and message when 'should be a property' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List("", "boom!", "hi")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should be a empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstIsEmpty(xs, "")) + " in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List("", "boom!", "hi")).par should throw TestFailedException with correct stack depth and message when 'should not be a property' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List("", "boom!", "hi")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not be a (empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstIsNotEmpty(xs, "")) + " in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List("", "boom!", "hi")).par should throw TestFailedException with correct stack depth and message when 'should be an symbol' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List("", "boom!", "hi")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should be an 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstIsEmpty(xs, "")) + " in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List("", "boom!", "hi")).par should throw TestFailedException with correct stack depth and message when 'should not be an symbol' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List("", "boom!", "hi")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not be an ('empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstIsNotEmpty(xs, "")) + " in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List("", "boom!", "hi")).par should throw TestFailedException with correct stack depth and message when 'should be an property' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List("", "boom!", "hi")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should be an empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstIsEmpty(xs, "")) + " in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List("", "boom!", "hi")).par should throw TestFailedException with correct stack depth and message when 'should not be an property' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List("", "boom!", "hi")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not be an (empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstIsNotEmpty(xs, "")) + " in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List("", "boom!", "hi")).par should throw TestFailedException with correct stack depth and message when 'should have property' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List("", "boom!", "hi")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should have (plength(0))
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstLengthEqual(xs, 0)) + " in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List("", "boom!", "hi")).par should throw TestFailedException with correct stack depth and message when 'should not have property' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List("", "boom!", "hi")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not have plength(0)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstLengthNotEqual(xs, 0)) + " in " + xs)
  }
  def `collection.mutable.Seq("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should be symbol' failed` {
    val xs = collection.mutable.Seq("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should be ('empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstIsEmpty(xs, "")) + " in " + xs)
  }
  def `collection.mutable.Seq("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should not be symbol' failed` {
    val xs = collection.mutable.Seq("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not be 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstIsNotEmpty(xs, "")) + " in " + xs)
  }
  def `collection.mutable.Seq("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should be property' failed` {
    val xs = collection.mutable.Seq("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should be (empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstIsEmpty(xs, "")) + " in " + xs)
  }
  def `collection.mutable.Seq("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should not be property' failed` {
    val xs = collection.mutable.Seq("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not be empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstIsNotEmpty(xs, "")) + " in " + xs)
  }
  def `collection.mutable.Seq("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should be a symbol' failed` {
    val xs = collection.mutable.Seq("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should be a 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstIsEmpty(xs, "")) + " in " + xs)
  }
  def `collection.mutable.Seq("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should not be a symbol' failed` {
    val xs = collection.mutable.Seq("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not be a ('empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstIsNotEmpty(xs, "")) + " in " + xs)
  }
  def `collection.mutable.Seq("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should be a property' failed` {
    val xs = collection.mutable.Seq("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should be a empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstIsEmpty(xs, "")) + " in " + xs)
  }
  def `collection.mutable.Seq("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should not be a property' failed` {
    val xs = collection.mutable.Seq("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not be a (empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstIsNotEmpty(xs, "")) + " in " + xs)
  }
  def `collection.mutable.Seq("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should be an symbol' failed` {
    val xs = collection.mutable.Seq("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should be an 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstIsEmpty(xs, "")) + " in " + xs)
  }
  def `collection.mutable.Seq("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should not be an symbol' failed` {
    val xs = collection.mutable.Seq("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not be an ('empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstIsNotEmpty(xs, "")) + " in " + xs)
  }
  def `collection.mutable.Seq("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should be an property' failed` {
    val xs = collection.mutable.Seq("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should be an empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstIsEmpty(xs, "")) + " in " + xs)
  }
  def `collection.mutable.Seq("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should not be an property' failed` {
    val xs = collection.mutable.Seq("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not be an (empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstIsNotEmpty(xs, "")) + " in " + xs)
  }
  def `collection.mutable.Seq("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should have property' failed` {
    val xs = collection.mutable.Seq("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should have (plength(0))
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstLengthEqual(xs, 0)) + " in " + xs)
  }
  def `collection.mutable.Seq("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should not have property' failed` {
    val xs = collection.mutable.Seq("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not have plength(0)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstLengthNotEqual(xs, 0)) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should be symbol' failed` {
    val xs = collection.mutable.IndexedSeq("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should be ('empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstIsEmpty(xs, "")) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should not be symbol' failed` {
    val xs = collection.mutable.IndexedSeq("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not be 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstIsNotEmpty(xs, "")) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should be property' failed` {
    val xs = collection.mutable.IndexedSeq("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should be (empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstIsEmpty(xs, "")) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should not be property' failed` {
    val xs = collection.mutable.IndexedSeq("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not be empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstIsNotEmpty(xs, "")) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should be a symbol' failed` {
    val xs = collection.mutable.IndexedSeq("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should be a 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstIsEmpty(xs, "")) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should not be a symbol' failed` {
    val xs = collection.mutable.IndexedSeq("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not be a ('empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstIsNotEmpty(xs, "")) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should be a property' failed` {
    val xs = collection.mutable.IndexedSeq("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should be a empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstIsEmpty(xs, "")) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should not be a property' failed` {
    val xs = collection.mutable.IndexedSeq("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not be a (empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstIsNotEmpty(xs, "")) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should be an symbol' failed` {
    val xs = collection.mutable.IndexedSeq("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should be an 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstIsEmpty(xs, "")) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should not be an symbol' failed` {
    val xs = collection.mutable.IndexedSeq("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not be an ('empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstIsNotEmpty(xs, "")) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should be an property' failed` {
    val xs = collection.mutable.IndexedSeq("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should be an empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstIsEmpty(xs, "")) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should not be an property' failed` {
    val xs = collection.mutable.IndexedSeq("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not be an (empty)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstIsNotEmpty(xs, "")) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should have property' failed` {
    val xs = collection.mutable.IndexedSeq("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should have (plength(0))
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstLengthEqual(xs, 0)) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should not have property' failed` {
    val xs = collection.mutable.IndexedSeq("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not have plength(0)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstLengthNotEqual(xs, 0)) + " in " + xs)
  }
  def `Set("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should have size' failed` {
    val xs = Set("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should have size 0
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstSizeEqual(xs, 0)) + " in " + xs)
  }
  def `Set("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should not have size' failed` {
    val xs = Set("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not have size (0)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstSizeNotEqual(xs, 0)) + " in " + xs)
  }
  def `List("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should have length' failed` {
    val xs = List("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should have length 0
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstLengthEqual(xs, 0)) + " in " + xs)
  }
  def `List("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should not have length' failed` {
    val xs = List("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not have length (0)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstLengthNotEqual(xs, 0)) + " in " + xs)
  }
  def `List("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should have size' failed` {
    val xs = List("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should have size 0
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstSizeEqual(xs, 0)) + " in " + xs)
  }
  def `List("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should not have size' failed` {
    val xs = List("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not have size (0)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstSizeNotEqual(xs, 0)) + " in " + xs)
  }
  def `Seq("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should have length' failed` {
    val xs = Seq("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should have length 0
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstLengthEqual(xs, 0)) + " in " + xs)
  }
  def `Seq("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should not have length' failed` {
    val xs = Seq("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not have length (0)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstLengthNotEqual(xs, 0)) + " in " + xs)
  }
  def `Seq("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should have size' failed` {
    val xs = Seq("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should have size 0
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstSizeEqual(xs, 0)) + " in " + xs)
  }
  def `Seq("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should not have size' failed` {
    val xs = Seq("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not have size (0)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstSizeNotEqual(xs, 0)) + " in " + xs)
  }
  def `Array("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should have length' failed` {
    val xs = Array("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should have length 0
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstLengthEqual(xs, 0)) + " in " + "WrappedArray(, boom!, hi)")
  }
  def `Array("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should not have length' failed` {
    val xs = Array("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not have length (0)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstLengthNotEqual(xs, 0)) + " in " + "WrappedArray(, boom!, hi)")
  }
  def `Array("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should have size' failed` {
    val xs = Array("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should have size 0
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstSizeEqual(xs, 0)) + " in " + "WrappedArray(, boom!, hi)")
  }
  def `Array("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should not have size' failed` {
    val xs = Array("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not have size (0)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstSizeNotEqual(xs, 0)) + " in " + "WrappedArray(, boom!, hi)")
  }
  def `IndexedSeq("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should have length' failed` {
    val xs = IndexedSeq("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should have length 0
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstLengthEqual(xs, 0)) + " in " + xs)
  }
  def `IndexedSeq("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should not have length' failed` {
    val xs = IndexedSeq("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not have length (0)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstLengthNotEqual(xs, 0)) + " in " + xs)
  }
  def `IndexedSeq("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should have size' failed` {
    val xs = IndexedSeq("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should have size 0
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstSizeEqual(xs, 0)) + " in " + xs)
  }
  def `IndexedSeq("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should not have size' failed` {
    val xs = IndexedSeq("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not have size (0)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstSizeNotEqual(xs, 0)) + " in " + xs)
  }
  def `Vector("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should have length' failed` {
    val xs = Vector("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should have length 0
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstLengthEqual(xs, 0)) + " in " + xs)
  }
  def `Vector("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should not have length' failed` {
    val xs = Vector("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not have length (0)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstLengthNotEqual(xs, 0)) + " in " + xs)
  }
  def `Vector("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should have size' failed` {
    val xs = Vector("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should have size 0
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstSizeEqual(xs, 0)) + " in " + xs)
  }
  def `Vector("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should not have size' failed` {
    val xs = Vector("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not have size (0)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstSizeNotEqual(xs, 0)) + " in " + xs)
  }
  def `Set("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should have size' failed` {
    val xs = Set("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should have size 0
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstSizeEqual(xs, 0)) + " in " + xs)
  }
  def `Set("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should not have size' failed` {
    val xs = Set("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not have size (0)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstSizeNotEqual(xs, 0)) + " in " + xs)
  }
  def `List("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should have length' failed` {
    val xs = List("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should have length 0
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstLengthEqual(xs, 0)) + " in " + xs)
  }
  def `List("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should not have length' failed` {
    val xs = List("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not have length (0)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstLengthNotEqual(xs, 0)) + " in " + xs)
  }
  def `List("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should have size' failed` {
    val xs = List("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should have size 0
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstSizeEqual(xs, 0)) + " in " + xs)
  }
  def `List("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should not have size' failed` {
    val xs = List("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not have size (0)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstSizeNotEqual(xs, 0)) + " in " + xs)
  }
  def `Seq("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should have length' failed` {
    val xs = Seq("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should have length 0
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstLengthEqual(xs, 0)) + " in " + xs)
  }
  def `Seq("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should not have length' failed` {
    val xs = Seq("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not have length (0)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstLengthNotEqual(xs, 0)) + " in " + xs)
  }
  def `Seq("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should have size' failed` {
    val xs = Seq("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should have size 0
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstSizeEqual(xs, 0)) + " in " + xs)
  }
  def `Seq("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should not have size' failed` {
    val xs = Seq("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not have size (0)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstSizeNotEqual(xs, 0)) + " in " + xs)
  }
  def `IndexedSeq("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should have length' failed` {
    val xs = IndexedSeq("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should have length 0
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstLengthEqual(xs, 0)) + " in " + xs)
  }
  def `IndexedSeq("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should not have length' failed` {
    val xs = IndexedSeq("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not have length (0)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstLengthNotEqual(xs, 0)) + " in " + xs)
  }
  def `IndexedSeq("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should have size' failed` {
    val xs = IndexedSeq("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should have size 0
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstSizeEqual(xs, 0)) + " in " + xs)
  }
  def `IndexedSeq("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should not have size' failed` {
    val xs = IndexedSeq("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not have size (0)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstSizeNotEqual(xs, 0)) + " in " + xs)
  }
  def `collection.mutable.Set("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should have size' failed` {
    val xs = collection.mutable.Set("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should have size 0
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstSizeEqual(xs, 0)) + " in " + xs)
  }
  def `collection.mutable.Set("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should not have size' failed` {
    val xs = collection.mutable.Set("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not have size (0)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstSizeNotEqual(xs, 0)) + " in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should have length' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should have length 0
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstLengthEqual(xs, 0)) + " in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should not have length' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not have length (0)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstLengthNotEqual(xs, 0)) + " in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should have size' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should have size 0
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstSizeEqual(xs, 0)) + " in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should not have size' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not have size (0)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstSizeNotEqual(xs, 0)) + " in " + xs)
  }
  def `collection.mutable.Seq("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should have length' failed` {
    val xs = collection.mutable.Seq("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should have length 0
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstLengthEqual(xs, 0)) + " in " + xs)
  }
  def `collection.mutable.Seq("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should not have length' failed` {
    val xs = collection.mutable.Seq("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not have length (0)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstLengthNotEqual(xs, 0)) + " in " + xs)
  }
  def `collection.mutable.Seq("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should have size' failed` {
    val xs = collection.mutable.Seq("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should have size 0
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstSizeEqual(xs, 0)) + " in " + xs)
  }
  def `collection.mutable.Seq("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should not have size' failed` {
    val xs = collection.mutable.Seq("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not have size (0)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstSizeNotEqual(xs, 0)) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should have length' failed` {
    val xs = collection.mutable.IndexedSeq("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should have length 0
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstLengthEqual(xs, 0)) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should not have length' failed` {
    val xs = collection.mutable.IndexedSeq("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not have length (0)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstLengthNotEqual(xs, 0)) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should have size' failed` {
    val xs = collection.mutable.IndexedSeq("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should have size 0
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstSizeEqual(xs, 0)) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq("", "boom!", "hi") should throw TestFailedException with correct stack depth and message when 'should not have size' failed` {
    val xs = collection.mutable.IndexedSeq("", "boom!", "hi")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not have size (0)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstSizeNotEqual(xs, 0)) + " in " + xs)
  }
  def `collection.mutable.Set("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should have size' failed` {
    val xs = collection.mutable.Set("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should have size 0
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstSizeEqual(xs, 0)) + " in " + xs)
  }
  def `collection.mutable.Set("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should not have size' failed` {
    val xs = collection.mutable.Set("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not have size (0)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstSizeNotEqual(xs, 0)) + " in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List("", "boom!", "hi")).par should throw TestFailedException with correct stack depth and message when 'should have length' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List("", "boom!", "hi")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should have length 0
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstLengthEqual(xs, 0)) + " in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List("", "boom!", "hi")).par should throw TestFailedException with correct stack depth and message when 'should not have length' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List("", "boom!", "hi")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not have length (0)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstLengthNotEqual(xs, 0)) + " in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List("", "boom!", "hi")).par should throw TestFailedException with correct stack depth and message when 'should have size' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List("", "boom!", "hi")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should have size 0
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstSizeEqual(xs, 0)) + " in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List("", "boom!", "hi")).par should throw TestFailedException with correct stack depth and message when 'should not have size' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List("", "boom!", "hi")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not have size (0)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstSizeNotEqual(xs, 0)) + " in " + xs)
  }
  def `collection.mutable.Seq("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should have length' failed` {
    val xs = collection.mutable.Seq("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should have length 0
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstLengthEqual(xs, 0)) + " in " + xs)
  }
  def `collection.mutable.Seq("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should not have length' failed` {
    val xs = collection.mutable.Seq("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not have length (0)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstLengthNotEqual(xs, 0)) + " in " + xs)
  }
  def `collection.mutable.Seq("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should have size' failed` {
    val xs = collection.mutable.Seq("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should have size 0
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstSizeEqual(xs, 0)) + " in " + xs)
  }
  def `collection.mutable.Seq("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should not have size' failed` {
    val xs = collection.mutable.Seq("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not have size (0)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstSizeNotEqual(xs, 0)) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should have length' failed` {
    val xs = collection.mutable.IndexedSeq("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should have length 0
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstLengthEqual(xs, 0)) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should not have length' failed` {
    val xs = collection.mutable.IndexedSeq("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not have length (0)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstLengthNotEqual(xs, 0)) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should have size' failed` {
    val xs = collection.mutable.IndexedSeq("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should have size 0
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstSizeEqual(xs, 0)) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq("", "boom!", "hi").par should throw TestFailedException with correct stack depth and message when 'should not have size' failed` {
    val xs = collection.mutable.IndexedSeq("", "boom!", "hi").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not have size (0)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstSizeNotEqual(xs, 0)) + " in " + xs)
  }
  def `Set("1", theInstance, "3") should throw TestFailedException with correct stack depth and message when 'should be theSameInstanceAs' failed` {
    val xs = Set("1", theInstance, "3")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should be theSameInstanceAs theInstance
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstRefEqual[String](xs, theInstance)) + " in " + xs)
  }
  def `Set("1", theInstance, "3") should throw TestFailedException with correct stack depth and message when 'should not be theSameInstanceAs' failed` {
    val xs = Set("1", theInstance, "3")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not be theSameInstanceAs (theInstance)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotRefEqual[String](xs, theInstance)) + " in " + xs)
  }
  def `List("1", theInstance, "3") should throw TestFailedException with correct stack depth and message when 'should be theSameInstanceAs' failed` {
    val xs = List("1", theInstance, "3")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should be theSameInstanceAs theInstance
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstRefEqual[String](xs, theInstance)) + " in " + xs)
  }
  def `List("1", theInstance, "3") should throw TestFailedException with correct stack depth and message when 'should not be theSameInstanceAs' failed` {
    val xs = List("1", theInstance, "3")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not be theSameInstanceAs (theInstance)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotRefEqual[String](xs, theInstance)) + " in " + xs)
  }
  def `Seq("1", theInstance, "3") should throw TestFailedException with correct stack depth and message when 'should be theSameInstanceAs' failed` {
    val xs = Seq("1", theInstance, "3")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should be theSameInstanceAs theInstance
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstRefEqual[String](xs, theInstance)) + " in " + xs)
  }
  def `Seq("1", theInstance, "3") should throw TestFailedException with correct stack depth and message when 'should not be theSameInstanceAs' failed` {
    val xs = Seq("1", theInstance, "3")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not be theSameInstanceAs (theInstance)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotRefEqual[String](xs, theInstance)) + " in " + xs)
  }
  def `Array("1", theInstance, "3") should throw TestFailedException with correct stack depth and message when 'should be theSameInstanceAs' failed` {
    val xs = Array("1", theInstance, "3")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should be theSameInstanceAs theInstance
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstRefEqual[String](xs, theInstance)) + " in " + "WrappedArray(1, 2, 3)")
  }
  def `Array("1", theInstance, "3") should throw TestFailedException with correct stack depth and message when 'should not be theSameInstanceAs' failed` {
    val xs = Array("1", theInstance, "3")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not be theSameInstanceAs (theInstance)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotRefEqual[String](xs, theInstance)) + " in " + "WrappedArray(1, 2, 3)")
  }
  def `IndexedSeq("1", theInstance, "3") should throw TestFailedException with correct stack depth and message when 'should be theSameInstanceAs' failed` {
    val xs = IndexedSeq("1", theInstance, "3")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should be theSameInstanceAs theInstance
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstRefEqual[String](xs, theInstance)) + " in " + xs)
  }
  def `IndexedSeq("1", theInstance, "3") should throw TestFailedException with correct stack depth and message when 'should not be theSameInstanceAs' failed` {
    val xs = IndexedSeq("1", theInstance, "3")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not be theSameInstanceAs (theInstance)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotRefEqual[String](xs, theInstance)) + " in " + xs)
  }
  def `Vector("1", theInstance, "3") should throw TestFailedException with correct stack depth and message when 'should be theSameInstanceAs' failed` {
    val xs = Vector("1", theInstance, "3")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should be theSameInstanceAs theInstance
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstRefEqual[String](xs, theInstance)) + " in " + xs)
  }
  def `Vector("1", theInstance, "3") should throw TestFailedException with correct stack depth and message when 'should not be theSameInstanceAs' failed` {
    val xs = Vector("1", theInstance, "3")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not be theSameInstanceAs (theInstance)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotRefEqual[String](xs, theInstance)) + " in " + xs)
  }
  def `Set("1", theInstance, "3").par should throw TestFailedException with correct stack depth and message when 'should be theSameInstanceAs' failed` {
    val xs = Set("1", theInstance, "3").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should be theSameInstanceAs theInstance
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstRefEqual[String](xs, theInstance)) + " in " + xs)
  }
  def `Set("1", theInstance, "3").par should throw TestFailedException with correct stack depth and message when 'should not be theSameInstanceAs' failed` {
    val xs = Set("1", theInstance, "3").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not be theSameInstanceAs (theInstance)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotRefEqual[String](xs, theInstance)) + " in " + xs)
  }
  def `List("1", theInstance, "3").par should throw TestFailedException with correct stack depth and message when 'should be theSameInstanceAs' failed` {
    val xs = List("1", theInstance, "3").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should be theSameInstanceAs theInstance
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstRefEqual[String](xs, theInstance)) + " in " + xs)
  }
  def `List("1", theInstance, "3").par should throw TestFailedException with correct stack depth and message when 'should not be theSameInstanceAs' failed` {
    val xs = List("1", theInstance, "3").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not be theSameInstanceAs (theInstance)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotRefEqual[String](xs, theInstance)) + " in " + xs)
  }
  def `Seq("1", theInstance, "3").par should throw TestFailedException with correct stack depth and message when 'should be theSameInstanceAs' failed` {
    val xs = Seq("1", theInstance, "3").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should be theSameInstanceAs theInstance
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstRefEqual[String](xs, theInstance)) + " in " + xs)
  }
  def `Seq("1", theInstance, "3").par should throw TestFailedException with correct stack depth and message when 'should not be theSameInstanceAs' failed` {
    val xs = Seq("1", theInstance, "3").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not be theSameInstanceAs (theInstance)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotRefEqual[String](xs, theInstance)) + " in " + xs)
  }
  def `IndexedSeq("1", theInstance, "3").par should throw TestFailedException with correct stack depth and message when 'should be theSameInstanceAs' failed` {
    val xs = IndexedSeq("1", theInstance, "3").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should be theSameInstanceAs theInstance
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstRefEqual[String](xs, theInstance)) + " in " + xs)
  }
  def `IndexedSeq("1", theInstance, "3").par should throw TestFailedException with correct stack depth and message when 'should not be theSameInstanceAs' failed` {
    val xs = IndexedSeq("1", theInstance, "3").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not be theSameInstanceAs (theInstance)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotRefEqual[String](xs, theInstance)) + " in " + xs)
  }
  def `collection.mutable.Set("1", theInstance, "3") should throw TestFailedException with correct stack depth and message when 'should be theSameInstanceAs' failed` {
    val xs = collection.mutable.Set("1", theInstance, "3")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should be theSameInstanceAs theInstance
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstRefEqual[String](xs, theInstance)) + " in " + xs)
  }
  def `collection.mutable.Set("1", theInstance, "3") should throw TestFailedException with correct stack depth and message when 'should not be theSameInstanceAs' failed` {
    val xs = collection.mutable.Set("1", theInstance, "3")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not be theSameInstanceAs (theInstance)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotRefEqual[String](xs, theInstance)) + " in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List("1", theInstance, "3") should throw TestFailedException with correct stack depth and message when 'should be theSameInstanceAs' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List("1", theInstance, "3")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should be theSameInstanceAs theInstance
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstRefEqual[String](xs, theInstance)) + " in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List("1", theInstance, "3") should throw TestFailedException with correct stack depth and message when 'should not be theSameInstanceAs' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List("1", theInstance, "3")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not be theSameInstanceAs (theInstance)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotRefEqual[String](xs, theInstance)) + " in " + xs)
  }
  def `collection.mutable.Seq("1", theInstance, "3") should throw TestFailedException with correct stack depth and message when 'should be theSameInstanceAs' failed` {
    val xs = collection.mutable.Seq("1", theInstance, "3")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should be theSameInstanceAs theInstance
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstRefEqual[String](xs, theInstance)) + " in " + xs)
  }
  def `collection.mutable.Seq("1", theInstance, "3") should throw TestFailedException with correct stack depth and message when 'should not be theSameInstanceAs' failed` {
    val xs = collection.mutable.Seq("1", theInstance, "3")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not be theSameInstanceAs (theInstance)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotRefEqual[String](xs, theInstance)) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq("1", theInstance, "3") should throw TestFailedException with correct stack depth and message when 'should be theSameInstanceAs' failed` {
    val xs = collection.mutable.IndexedSeq("1", theInstance, "3")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should be theSameInstanceAs theInstance
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstRefEqual[String](xs, theInstance)) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq("1", theInstance, "3") should throw TestFailedException with correct stack depth and message when 'should not be theSameInstanceAs' failed` {
    val xs = collection.mutable.IndexedSeq("1", theInstance, "3")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not be theSameInstanceAs (theInstance)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotRefEqual[String](xs, theInstance)) + " in " + xs)
  }
  def `collection.mutable.Set("1", theInstance, "3").par should throw TestFailedException with correct stack depth and message when 'should be theSameInstanceAs' failed` {
    val xs = collection.mutable.Set("1", theInstance, "3").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should be theSameInstanceAs theInstance
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstRefEqual[String](xs, theInstance)) + " in " + xs)
  }
  def `collection.mutable.Set("1", theInstance, "3").par should throw TestFailedException with correct stack depth and message when 'should not be theSameInstanceAs' failed` {
    val xs = collection.mutable.Set("1", theInstance, "3").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not be theSameInstanceAs (theInstance)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotRefEqual[String](xs, theInstance)) + " in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List("1", theInstance, "3")).par should throw TestFailedException with correct stack depth and message when 'should be theSameInstanceAs' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List("1", theInstance, "3")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should be theSameInstanceAs theInstance
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstRefEqual[String](xs, theInstance)) + " in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List("1", theInstance, "3")).par should throw TestFailedException with correct stack depth and message when 'should not be theSameInstanceAs' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List("1", theInstance, "3")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not be theSameInstanceAs (theInstance)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotRefEqual[String](xs, theInstance)) + " in " + xs)
  }
  def `collection.mutable.Seq("1", theInstance, "3").par should throw TestFailedException with correct stack depth and message when 'should be theSameInstanceAs' failed` {
    val xs = collection.mutable.Seq("1", theInstance, "3").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should be theSameInstanceAs theInstance
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstRefEqual[String](xs, theInstance)) + " in " + xs)
  }
  def `collection.mutable.Seq("1", theInstance, "3").par should throw TestFailedException with correct stack depth and message when 'should not be theSameInstanceAs' failed` {
    val xs = collection.mutable.Seq("1", theInstance, "3").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not be theSameInstanceAs (theInstance)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotRefEqual[String](xs, theInstance)) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq("1", theInstance, "3").par should throw TestFailedException with correct stack depth and message when 'should be theSameInstanceAs' failed` {
    val xs = collection.mutable.IndexedSeq("1", theInstance, "3").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should be theSameInstanceAs theInstance
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstRefEqual[String](xs, theInstance)) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq("1", theInstance, "3").par should throw TestFailedException with correct stack depth and message when 'should not be theSameInstanceAs' failed` {
    val xs = collection.mutable.IndexedSeq("1", theInstance, "3").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not be theSameInstanceAs (theInstance)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotRefEqual[String](xs, theInstance)) + " in " + xs)
  }
  def `Set("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should startWith' failed` {
    val xs = Set("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should startWith ("hello")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstStartsWith(xs, "hello")) + " in " + xs)
  }
  def `Set("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not startWith' failed` {
    val xs = Set("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not startWith ("hello")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotStartsWith(xs, "hello")) + " in " + xs)
  }
  def `Set("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should endWith' failed` {
    val xs = Set("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should endWith ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstEndsWith(xs, "!")) + " in " + xs)
  }
  def `Set("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not endWith' failed` {
    val xs = Set("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not endWith ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotEndsWith(xs, "!")) + " in " + xs)
  }
  def `Set("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should include' failed` {
    val xs = Set("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should include ("ell")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstInclude(xs, "ell")) + " in " + xs)
  }
  def `Set("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not include' failed` {
    val xs = Set("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not include "ell"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotInclude(xs, "ell")) + " in " + xs)
  }
  def `Set("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should startWith regex' failed` {
    val xs = Set("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should startWith regex "hel*o"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstStartsWith(xs, "hello")) + " in " + xs)
  }
  def `Set("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not startWith regex' failed` {
    val xs = Set("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not startWith regex ("hel*o")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotStartsWith(xs, "hello")) + " in " + xs)
  }
  def `Set("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should endWith regex' failed` {
    val xs = Set("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should endWith regex "!"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstEndsWith(xs, "!")) + " in " + xs)
  }
  def `Set("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not endWith regex' failed` {
    val xs = Set("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not endWith regex ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotEndsWith(xs, "!")) + " in " + xs)
  }
  def `Set("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should include regex' failed` {
    val xs = Set("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should include regex "ell"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstInclude(xs, "ell")) + " in " + xs)
  }
  def `Set("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not include regex' failed` {
    val xs = Set("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not include regex ("ell")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotInclude(xs, "ell")) + " in " + xs)
  }
  def `Set("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should fullyMatch regex' failed` {
    val xs = Set("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should fullyMatch regex "h.*!"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstMatches(xs, "h.*!")) + " in " + xs)
  }
  def `Set("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not fullyMatch regex' failed` {
    val xs = Set("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not fullyMatch regex ("h.*!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotMatches(xs, "h.*!")) + " in " + xs)
  }
  def `List("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should startWith' failed` {
    val xs = List("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should startWith ("hello")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstStartsWith(xs, "hello")) + " in " + xs)
  }
  def `List("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not startWith' failed` {
    val xs = List("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not startWith ("hello")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotStartsWith(xs, "hello")) + " in " + xs)
  }
  def `List("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should endWith' failed` {
    val xs = List("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should endWith ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstEndsWith(xs, "!")) + " in " + xs)
  }
  def `List("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not endWith' failed` {
    val xs = List("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not endWith ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotEndsWith(xs, "!")) + " in " + xs)
  }
  def `List("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should include' failed` {
    val xs = List("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should include ("ell")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstInclude(xs, "ell")) + " in " + xs)
  }
  def `List("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not include' failed` {
    val xs = List("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not include "ell"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotInclude(xs, "ell")) + " in " + xs)
  }
  def `List("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should startWith regex' failed` {
    val xs = List("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should startWith regex "hel*o"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstStartsWith(xs, "hello")) + " in " + xs)
  }
  def `List("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not startWith regex' failed` {
    val xs = List("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not startWith regex ("hel*o")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotStartsWith(xs, "hello")) + " in " + xs)
  }
  def `List("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should endWith regex' failed` {
    val xs = List("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should endWith regex "!"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstEndsWith(xs, "!")) + " in " + xs)
  }
  def `List("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not endWith regex' failed` {
    val xs = List("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not endWith regex ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotEndsWith(xs, "!")) + " in " + xs)
  }
  def `List("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should include regex' failed` {
    val xs = List("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should include regex "ell"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstInclude(xs, "ell")) + " in " + xs)
  }
  def `List("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not include regex' failed` {
    val xs = List("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not include regex ("ell")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotInclude(xs, "ell")) + " in " + xs)
  }
  def `List("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should fullyMatch regex' failed` {
    val xs = List("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should fullyMatch regex "h.*!"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstMatches(xs, "h.*!")) + " in " + xs)
  }
  def `List("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not fullyMatch regex' failed` {
    val xs = List("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not fullyMatch regex ("h.*!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotMatches(xs, "h.*!")) + " in " + xs)
  }
  def `Seq("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should startWith' failed` {
    val xs = Seq("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should startWith ("hello")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstStartsWith(xs, "hello")) + " in " + xs)
  }
  def `Seq("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not startWith' failed` {
    val xs = Seq("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not startWith ("hello")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotStartsWith(xs, "hello")) + " in " + xs)
  }
  def `Seq("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should endWith' failed` {
    val xs = Seq("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should endWith ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstEndsWith(xs, "!")) + " in " + xs)
  }
  def `Seq("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not endWith' failed` {
    val xs = Seq("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not endWith ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotEndsWith(xs, "!")) + " in " + xs)
  }
  def `Seq("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should include' failed` {
    val xs = Seq("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should include ("ell")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstInclude(xs, "ell")) + " in " + xs)
  }
  def `Seq("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not include' failed` {
    val xs = Seq("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not include "ell"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotInclude(xs, "ell")) + " in " + xs)
  }
  def `Seq("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should startWith regex' failed` {
    val xs = Seq("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should startWith regex "hel*o"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstStartsWith(xs, "hello")) + " in " + xs)
  }
  def `Seq("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not startWith regex' failed` {
    val xs = Seq("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not startWith regex ("hel*o")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotStartsWith(xs, "hello")) + " in " + xs)
  }
  def `Seq("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should endWith regex' failed` {
    val xs = Seq("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should endWith regex "!"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstEndsWith(xs, "!")) + " in " + xs)
  }
  def `Seq("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not endWith regex' failed` {
    val xs = Seq("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not endWith regex ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotEndsWith(xs, "!")) + " in " + xs)
  }
  def `Seq("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should include regex' failed` {
    val xs = Seq("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should include regex "ell"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstInclude(xs, "ell")) + " in " + xs)
  }
  def `Seq("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not include regex' failed` {
    val xs = Seq("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not include regex ("ell")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotInclude(xs, "ell")) + " in " + xs)
  }
  def `Seq("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should fullyMatch regex' failed` {
    val xs = Seq("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should fullyMatch regex "h.*!"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstMatches(xs, "h.*!")) + " in " + xs)
  }
  def `Seq("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not fullyMatch regex' failed` {
    val xs = Seq("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not fullyMatch regex ("h.*!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotMatches(xs, "h.*!")) + " in " + xs)
  }
  def `Array("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should startWith' failed` {
    val xs = Array("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should startWith ("hello")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstStartsWith(xs, "hello")) + " in " + "WrappedArray(hello A!, hi B, hello C!)")
  }
  def `Array("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not startWith' failed` {
    val xs = Array("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not startWith ("hello")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotStartsWith(xs, "hello")) + " in " + "WrappedArray(hello A!, hi B, hello C!)")
  }
  def `Array("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should endWith' failed` {
    val xs = Array("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should endWith ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstEndsWith(xs, "!")) + " in " + "WrappedArray(hello A!, hi B, hello C!)")
  }
  def `Array("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not endWith' failed` {
    val xs = Array("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not endWith ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotEndsWith(xs, "!")) + " in " + "WrappedArray(hello A!, hi B, hello C!)")
  }
  def `Array("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should include' failed` {
    val xs = Array("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should include ("ell")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstInclude(xs, "ell")) + " in " + "WrappedArray(hello A!, hi B, hello C!)")
  }
  def `Array("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not include' failed` {
    val xs = Array("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not include "ell"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotInclude(xs, "ell")) + " in " + "WrappedArray(hello A!, hi B, hello C!)")
  }
  def `Array("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should startWith regex' failed` {
    val xs = Array("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should startWith regex "hel*o"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstStartsWith(xs, "hello")) + " in " + "WrappedArray(hello A!, hi B, hello C!)")
  }
  def `Array("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not startWith regex' failed` {
    val xs = Array("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not startWith regex ("hel*o")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotStartsWith(xs, "hello")) + " in " + "WrappedArray(hello A!, hi B, hello C!)")
  }
  def `Array("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should endWith regex' failed` {
    val xs = Array("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should endWith regex "!"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstEndsWith(xs, "!")) + " in " + "WrappedArray(hello A!, hi B, hello C!)")
  }
  def `Array("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not endWith regex' failed` {
    val xs = Array("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not endWith regex ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotEndsWith(xs, "!")) + " in " + "WrappedArray(hello A!, hi B, hello C!)")
  }
  def `Array("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should include regex' failed` {
    val xs = Array("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should include regex "ell"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstInclude(xs, "ell")) + " in " + "WrappedArray(hello A!, hi B, hello C!)")
  }
  def `Array("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not include regex' failed` {
    val xs = Array("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not include regex ("ell")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotInclude(xs, "ell")) + " in " + "WrappedArray(hello A!, hi B, hello C!)")
  }
  def `Array("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should fullyMatch regex' failed` {
    val xs = Array("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should fullyMatch regex "h.*!"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstMatches(xs, "h.*!")) + " in " + "WrappedArray(hello A!, hi B, hello C!)")
  }
  def `Array("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not fullyMatch regex' failed` {
    val xs = Array("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not fullyMatch regex ("h.*!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotMatches(xs, "h.*!")) + " in " + "WrappedArray(hello A!, hi B, hello C!)")
  }
  def `IndexedSeq("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should startWith' failed` {
    val xs = IndexedSeq("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should startWith ("hello")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstStartsWith(xs, "hello")) + " in " + xs)
  }
  def `IndexedSeq("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not startWith' failed` {
    val xs = IndexedSeq("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not startWith ("hello")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotStartsWith(xs, "hello")) + " in " + xs)
  }
  def `IndexedSeq("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should endWith' failed` {
    val xs = IndexedSeq("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should endWith ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstEndsWith(xs, "!")) + " in " + xs)
  }
  def `IndexedSeq("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not endWith' failed` {
    val xs = IndexedSeq("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not endWith ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotEndsWith(xs, "!")) + " in " + xs)
  }
  def `IndexedSeq("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should include' failed` {
    val xs = IndexedSeq("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should include ("ell")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstInclude(xs, "ell")) + " in " + xs)
  }
  def `IndexedSeq("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not include' failed` {
    val xs = IndexedSeq("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not include "ell"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotInclude(xs, "ell")) + " in " + xs)
  }
  def `IndexedSeq("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should startWith regex' failed` {
    val xs = IndexedSeq("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should startWith regex "hel*o"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstStartsWith(xs, "hello")) + " in " + xs)
  }
  def `IndexedSeq("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not startWith regex' failed` {
    val xs = IndexedSeq("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not startWith regex ("hel*o")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotStartsWith(xs, "hello")) + " in " + xs)
  }
  def `IndexedSeq("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should endWith regex' failed` {
    val xs = IndexedSeq("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should endWith regex "!"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstEndsWith(xs, "!")) + " in " + xs)
  }
  def `IndexedSeq("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not endWith regex' failed` {
    val xs = IndexedSeq("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not endWith regex ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotEndsWith(xs, "!")) + " in " + xs)
  }
  def `IndexedSeq("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should include regex' failed` {
    val xs = IndexedSeq("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should include regex "ell"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstInclude(xs, "ell")) + " in " + xs)
  }
  def `IndexedSeq("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not include regex' failed` {
    val xs = IndexedSeq("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not include regex ("ell")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotInclude(xs, "ell")) + " in " + xs)
  }
  def `IndexedSeq("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should fullyMatch regex' failed` {
    val xs = IndexedSeq("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should fullyMatch regex "h.*!"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstMatches(xs, "h.*!")) + " in " + xs)
  }
  def `IndexedSeq("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not fullyMatch regex' failed` {
    val xs = IndexedSeq("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not fullyMatch regex ("h.*!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotMatches(xs, "h.*!")) + " in " + xs)
  }
  def `Vector("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should startWith' failed` {
    val xs = Vector("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should startWith ("hello")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstStartsWith(xs, "hello")) + " in " + xs)
  }
  def `Vector("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not startWith' failed` {
    val xs = Vector("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not startWith ("hello")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotStartsWith(xs, "hello")) + " in " + xs)
  }
  def `Vector("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should endWith' failed` {
    val xs = Vector("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should endWith ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstEndsWith(xs, "!")) + " in " + xs)
  }
  def `Vector("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not endWith' failed` {
    val xs = Vector("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not endWith ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotEndsWith(xs, "!")) + " in " + xs)
  }
  def `Vector("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should include' failed` {
    val xs = Vector("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should include ("ell")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstInclude(xs, "ell")) + " in " + xs)
  }
  def `Vector("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not include' failed` {
    val xs = Vector("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not include "ell"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotInclude(xs, "ell")) + " in " + xs)
  }
  def `Vector("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should startWith regex' failed` {
    val xs = Vector("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should startWith regex "hel*o"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstStartsWith(xs, "hello")) + " in " + xs)
  }
  def `Vector("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not startWith regex' failed` {
    val xs = Vector("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not startWith regex ("hel*o")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotStartsWith(xs, "hello")) + " in " + xs)
  }
  def `Vector("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should endWith regex' failed` {
    val xs = Vector("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should endWith regex "!"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstEndsWith(xs, "!")) + " in " + xs)
  }
  def `Vector("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not endWith regex' failed` {
    val xs = Vector("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not endWith regex ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotEndsWith(xs, "!")) + " in " + xs)
  }
  def `Vector("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should include regex' failed` {
    val xs = Vector("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should include regex "ell"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstInclude(xs, "ell")) + " in " + xs)
  }
  def `Vector("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not include regex' failed` {
    val xs = Vector("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not include regex ("ell")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotInclude(xs, "ell")) + " in " + xs)
  }
  def `Vector("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should fullyMatch regex' failed` {
    val xs = Vector("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should fullyMatch regex "h.*!"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstMatches(xs, "h.*!")) + " in " + xs)
  }
  def `Vector("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not fullyMatch regex' failed` {
    val xs = Vector("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not fullyMatch regex ("h.*!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotMatches(xs, "h.*!")) + " in " + xs)
  }
  def `Set("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should startWith' failed` {
    val xs = Set("hello A!", "hi B", "hello C!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should startWith ("hello")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstStartsWith(xs, "hello")) + " in " + xs)
  }
  def `Set("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should not startWith' failed` {
    val xs = Set("hello A!", "hi B", "hello C!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not startWith ("hello")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotStartsWith(xs, "hello")) + " in " + xs)
  }
  def `Set("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should endWith' failed` {
    val xs = Set("hello A!", "hi B", "hello C!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should endWith ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstEndsWith(xs, "!")) + " in " + xs)
  }
  def `Set("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should not endWith' failed` {
    val xs = Set("hello A!", "hi B", "hello C!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not endWith ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotEndsWith(xs, "!")) + " in " + xs)
  }
  def `Set("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should include' failed` {
    val xs = Set("hello A!", "hi B", "hello C!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should include ("ell")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstInclude(xs, "ell")) + " in " + xs)
  }
  def `Set("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should not include' failed` {
    val xs = Set("hello A!", "hi B", "hello C!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not include "ell"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotInclude(xs, "ell")) + " in " + xs)
  }
  def `Set("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should startWith regex' failed` {
    val xs = Set("hello A!", "hi B", "hello C!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should startWith regex "hel*o"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstStartsWith(xs, "hello")) + " in " + xs)
  }
  def `Set("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should not startWith regex' failed` {
    val xs = Set("hello A!", "hi B", "hello C!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not startWith regex ("hel*o")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotStartsWith(xs, "hello")) + " in " + xs)
  }
  def `Set("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should endWith regex' failed` {
    val xs = Set("hello A!", "hi B", "hello C!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should endWith regex "!"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstEndsWith(xs, "!")) + " in " + xs)
  }
  def `Set("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should not endWith regex' failed` {
    val xs = Set("hello A!", "hi B", "hello C!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not endWith regex ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotEndsWith(xs, "!")) + " in " + xs)
  }
  def `Set("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should include regex' failed` {
    val xs = Set("hello A!", "hi B", "hello C!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should include regex "ell"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstInclude(xs, "ell")) + " in " + xs)
  }
  def `Set("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should not include regex' failed` {
    val xs = Set("hello A!", "hi B", "hello C!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not include regex ("ell")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotInclude(xs, "ell")) + " in " + xs)
  }
  def `Set("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should fullyMatch regex' failed` {
    val xs = Set("hello A!", "hi B", "hello C!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should fullyMatch regex "h.*!"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstMatches(xs, "h.*!")) + " in " + xs)
  }
  def `Set("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should not fullyMatch regex' failed` {
    val xs = Set("hello A!", "hi B", "hello C!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not fullyMatch regex ("h.*!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotMatches(xs, "h.*!")) + " in " + xs)
  }
  def `List("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should startWith' failed` {
    val xs = List("hello A!", "hi B", "hello C!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should startWith ("hello")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstStartsWith(xs, "hello")) + " in " + xs)
  }
  def `List("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should not startWith' failed` {
    val xs = List("hello A!", "hi B", "hello C!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not startWith ("hello")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotStartsWith(xs, "hello")) + " in " + xs)
  }
  def `List("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should endWith' failed` {
    val xs = List("hello A!", "hi B", "hello C!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should endWith ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstEndsWith(xs, "!")) + " in " + xs)
  }
  def `List("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should not endWith' failed` {
    val xs = List("hello A!", "hi B", "hello C!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not endWith ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotEndsWith(xs, "!")) + " in " + xs)
  }
  def `List("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should include' failed` {
    val xs = List("hello A!", "hi B", "hello C!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should include ("ell")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstInclude(xs, "ell")) + " in " + xs)
  }
  def `List("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should not include' failed` {
    val xs = List("hello A!", "hi B", "hello C!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not include "ell"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotInclude(xs, "ell")) + " in " + xs)
  }
  def `List("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should startWith regex' failed` {
    val xs = List("hello A!", "hi B", "hello C!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should startWith regex "hel*o"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstStartsWith(xs, "hello")) + " in " + xs)
  }
  def `List("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should not startWith regex' failed` {
    val xs = List("hello A!", "hi B", "hello C!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not startWith regex ("hel*o")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotStartsWith(xs, "hello")) + " in " + xs)
  }
  def `List("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should endWith regex' failed` {
    val xs = List("hello A!", "hi B", "hello C!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should endWith regex "!"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstEndsWith(xs, "!")) + " in " + xs)
  }
  def `List("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should not endWith regex' failed` {
    val xs = List("hello A!", "hi B", "hello C!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not endWith regex ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotEndsWith(xs, "!")) + " in " + xs)
  }
  def `List("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should include regex' failed` {
    val xs = List("hello A!", "hi B", "hello C!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should include regex "ell"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstInclude(xs, "ell")) + " in " + xs)
  }
  def `List("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should not include regex' failed` {
    val xs = List("hello A!", "hi B", "hello C!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not include regex ("ell")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotInclude(xs, "ell")) + " in " + xs)
  }
  def `List("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should fullyMatch regex' failed` {
    val xs = List("hello A!", "hi B", "hello C!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should fullyMatch regex "h.*!"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstMatches(xs, "h.*!")) + " in " + xs)
  }
  def `List("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should not fullyMatch regex' failed` {
    val xs = List("hello A!", "hi B", "hello C!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not fullyMatch regex ("h.*!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotMatches(xs, "h.*!")) + " in " + xs)
  }
  def `Seq("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should startWith' failed` {
    val xs = Seq("hello A!", "hi B", "hello C!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should startWith ("hello")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstStartsWith(xs, "hello")) + " in " + xs)
  }
  def `Seq("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should not startWith' failed` {
    val xs = Seq("hello A!", "hi B", "hello C!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not startWith ("hello")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotStartsWith(xs, "hello")) + " in " + xs)
  }
  def `Seq("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should endWith' failed` {
    val xs = Seq("hello A!", "hi B", "hello C!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should endWith ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstEndsWith(xs, "!")) + " in " + xs)
  }
  def `Seq("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should not endWith' failed` {
    val xs = Seq("hello A!", "hi B", "hello C!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not endWith ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotEndsWith(xs, "!")) + " in " + xs)
  }
  def `Seq("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should include' failed` {
    val xs = Seq("hello A!", "hi B", "hello C!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should include ("ell")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstInclude(xs, "ell")) + " in " + xs)
  }
  def `Seq("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should not include' failed` {
    val xs = Seq("hello A!", "hi B", "hello C!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not include "ell"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotInclude(xs, "ell")) + " in " + xs)
  }
  def `Seq("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should startWith regex' failed` {
    val xs = Seq("hello A!", "hi B", "hello C!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should startWith regex "hel*o"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstStartsWith(xs, "hello")) + " in " + xs)
  }
  def `Seq("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should not startWith regex' failed` {
    val xs = Seq("hello A!", "hi B", "hello C!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not startWith regex ("hel*o")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotStartsWith(xs, "hello")) + " in " + xs)
  }
  def `Seq("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should endWith regex' failed` {
    val xs = Seq("hello A!", "hi B", "hello C!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should endWith regex "!"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstEndsWith(xs, "!")) + " in " + xs)
  }
  def `Seq("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should not endWith regex' failed` {
    val xs = Seq("hello A!", "hi B", "hello C!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not endWith regex ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotEndsWith(xs, "!")) + " in " + xs)
  }
  def `Seq("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should include regex' failed` {
    val xs = Seq("hello A!", "hi B", "hello C!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should include regex "ell"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstInclude(xs, "ell")) + " in " + xs)
  }
  def `Seq("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should not include regex' failed` {
    val xs = Seq("hello A!", "hi B", "hello C!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not include regex ("ell")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotInclude(xs, "ell")) + " in " + xs)
  }
  def `Seq("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should fullyMatch regex' failed` {
    val xs = Seq("hello A!", "hi B", "hello C!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should fullyMatch regex "h.*!"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstMatches(xs, "h.*!")) + " in " + xs)
  }
  def `Seq("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should not fullyMatch regex' failed` {
    val xs = Seq("hello A!", "hi B", "hello C!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not fullyMatch regex ("h.*!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotMatches(xs, "h.*!")) + " in " + xs)
  }
  def `IndexedSeq("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should startWith' failed` {
    val xs = IndexedSeq("hello A!", "hi B", "hello C!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should startWith ("hello")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstStartsWith(xs, "hello")) + " in " + xs)
  }
  def `IndexedSeq("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should not startWith' failed` {
    val xs = IndexedSeq("hello A!", "hi B", "hello C!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not startWith ("hello")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotStartsWith(xs, "hello")) + " in " + xs)
  }
  def `IndexedSeq("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should endWith' failed` {
    val xs = IndexedSeq("hello A!", "hi B", "hello C!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should endWith ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstEndsWith(xs, "!")) + " in " + xs)
  }
  def `IndexedSeq("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should not endWith' failed` {
    val xs = IndexedSeq("hello A!", "hi B", "hello C!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not endWith ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotEndsWith(xs, "!")) + " in " + xs)
  }
  def `IndexedSeq("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should include' failed` {
    val xs = IndexedSeq("hello A!", "hi B", "hello C!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should include ("ell")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstInclude(xs, "ell")) + " in " + xs)
  }
  def `IndexedSeq("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should not include' failed` {
    val xs = IndexedSeq("hello A!", "hi B", "hello C!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not include "ell"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotInclude(xs, "ell")) + " in " + xs)
  }
  def `IndexedSeq("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should startWith regex' failed` {
    val xs = IndexedSeq("hello A!", "hi B", "hello C!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should startWith regex "hel*o"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstStartsWith(xs, "hello")) + " in " + xs)
  }
  def `IndexedSeq("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should not startWith regex' failed` {
    val xs = IndexedSeq("hello A!", "hi B", "hello C!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not startWith regex ("hel*o")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotStartsWith(xs, "hello")) + " in " + xs)
  }
  def `IndexedSeq("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should endWith regex' failed` {
    val xs = IndexedSeq("hello A!", "hi B", "hello C!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should endWith regex "!"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstEndsWith(xs, "!")) + " in " + xs)
  }
  def `IndexedSeq("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should not endWith regex' failed` {
    val xs = IndexedSeq("hello A!", "hi B", "hello C!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not endWith regex ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotEndsWith(xs, "!")) + " in " + xs)
  }
  def `IndexedSeq("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should include regex' failed` {
    val xs = IndexedSeq("hello A!", "hi B", "hello C!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should include regex "ell"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstInclude(xs, "ell")) + " in " + xs)
  }
  def `IndexedSeq("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should not include regex' failed` {
    val xs = IndexedSeq("hello A!", "hi B", "hello C!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not include regex ("ell")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotInclude(xs, "ell")) + " in " + xs)
  }
  def `IndexedSeq("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should fullyMatch regex' failed` {
    val xs = IndexedSeq("hello A!", "hi B", "hello C!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should fullyMatch regex "h.*!"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstMatches(xs, "h.*!")) + " in " + xs)
  }
  def `IndexedSeq("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should not fullyMatch regex' failed` {
    val xs = IndexedSeq("hello A!", "hi B", "hello C!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not fullyMatch regex ("h.*!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotMatches(xs, "h.*!")) + " in " + xs)
  }
  def `collection.mutable.Set("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should startWith' failed` {
    val xs = collection.mutable.Set("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should startWith ("hello")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstStartsWith(xs, "hello")) + " in " + xs)
  }
  def `collection.mutable.Set("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not startWith' failed` {
    val xs = collection.mutable.Set("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not startWith ("hello")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotStartsWith(xs, "hello")) + " in " + xs)
  }
  def `collection.mutable.Set("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should endWith' failed` {
    val xs = collection.mutable.Set("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should endWith ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstEndsWith(xs, "!")) + " in " + xs)
  }
  def `collection.mutable.Set("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not endWith' failed` {
    val xs = collection.mutable.Set("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not endWith ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotEndsWith(xs, "!")) + " in " + xs)
  }
  def `collection.mutable.Set("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should include' failed` {
    val xs = collection.mutable.Set("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should include ("ell")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstInclude(xs, "ell")) + " in " + xs)
  }
  def `collection.mutable.Set("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not include' failed` {
    val xs = collection.mutable.Set("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not include "ell"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotInclude(xs, "ell")) + " in " + xs)
  }
  def `collection.mutable.Set("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should startWith regex' failed` {
    val xs = collection.mutable.Set("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should startWith regex "hel*o"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstStartsWith(xs, "hello")) + " in " + xs)
  }
  def `collection.mutable.Set("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not startWith regex' failed` {
    val xs = collection.mutable.Set("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not startWith regex ("hel*o")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotStartsWith(xs, "hello")) + " in " + xs)
  }
  def `collection.mutable.Set("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should endWith regex' failed` {
    val xs = collection.mutable.Set("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should endWith regex "!"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstEndsWith(xs, "!")) + " in " + xs)
  }
  def `collection.mutable.Set("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not endWith regex' failed` {
    val xs = collection.mutable.Set("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not endWith regex ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotEndsWith(xs, "!")) + " in " + xs)
  }
  def `collection.mutable.Set("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should include regex' failed` {
    val xs = collection.mutable.Set("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should include regex "ell"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstInclude(xs, "ell")) + " in " + xs)
  }
  def `collection.mutable.Set("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not include regex' failed` {
    val xs = collection.mutable.Set("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not include regex ("ell")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotInclude(xs, "ell")) + " in " + xs)
  }
  def `collection.mutable.Set("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should fullyMatch regex' failed` {
    val xs = collection.mutable.Set("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should fullyMatch regex "h.*!"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstMatches(xs, "h.*!")) + " in " + xs)
  }
  def `collection.mutable.Set("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not fullyMatch regex' failed` {
    val xs = collection.mutable.Set("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not fullyMatch regex ("h.*!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotMatches(xs, "h.*!")) + " in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should startWith' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should startWith ("hello")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstStartsWith(xs, "hello")) + " in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not startWith' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not startWith ("hello")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotStartsWith(xs, "hello")) + " in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should endWith' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should endWith ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstEndsWith(xs, "!")) + " in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not endWith' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not endWith ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotEndsWith(xs, "!")) + " in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should include' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should include ("ell")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstInclude(xs, "ell")) + " in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not include' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not include "ell"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotInclude(xs, "ell")) + " in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should startWith regex' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should startWith regex "hel*o"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstStartsWith(xs, "hello")) + " in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not startWith regex' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not startWith regex ("hel*o")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotStartsWith(xs, "hello")) + " in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should endWith regex' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should endWith regex "!"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstEndsWith(xs, "!")) + " in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not endWith regex' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not endWith regex ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotEndsWith(xs, "!")) + " in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should include regex' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should include regex "ell"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstInclude(xs, "ell")) + " in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not include regex' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not include regex ("ell")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotInclude(xs, "ell")) + " in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should fullyMatch regex' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should fullyMatch regex "h.*!"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstMatches(xs, "h.*!")) + " in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not fullyMatch regex' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not fullyMatch regex ("h.*!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotMatches(xs, "h.*!")) + " in " + xs)
  }
  def `collection.mutable.Seq("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should startWith' failed` {
    val xs = collection.mutable.Seq("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should startWith ("hello")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstStartsWith(xs, "hello")) + " in " + xs)
  }
  def `collection.mutable.Seq("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not startWith' failed` {
    val xs = collection.mutable.Seq("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not startWith ("hello")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotStartsWith(xs, "hello")) + " in " + xs)
  }
  def `collection.mutable.Seq("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should endWith' failed` {
    val xs = collection.mutable.Seq("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should endWith ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstEndsWith(xs, "!")) + " in " + xs)
  }
  def `collection.mutable.Seq("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not endWith' failed` {
    val xs = collection.mutable.Seq("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not endWith ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotEndsWith(xs, "!")) + " in " + xs)
  }
  def `collection.mutable.Seq("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should include' failed` {
    val xs = collection.mutable.Seq("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should include ("ell")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstInclude(xs, "ell")) + " in " + xs)
  }
  def `collection.mutable.Seq("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not include' failed` {
    val xs = collection.mutable.Seq("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not include "ell"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotInclude(xs, "ell")) + " in " + xs)
  }
  def `collection.mutable.Seq("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should startWith regex' failed` {
    val xs = collection.mutable.Seq("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should startWith regex "hel*o"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstStartsWith(xs, "hello")) + " in " + xs)
  }
  def `collection.mutable.Seq("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not startWith regex' failed` {
    val xs = collection.mutable.Seq("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not startWith regex ("hel*o")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotStartsWith(xs, "hello")) + " in " + xs)
  }
  def `collection.mutable.Seq("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should endWith regex' failed` {
    val xs = collection.mutable.Seq("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should endWith regex "!"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstEndsWith(xs, "!")) + " in " + xs)
  }
  def `collection.mutable.Seq("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not endWith regex' failed` {
    val xs = collection.mutable.Seq("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not endWith regex ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotEndsWith(xs, "!")) + " in " + xs)
  }
  def `collection.mutable.Seq("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should include regex' failed` {
    val xs = collection.mutable.Seq("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should include regex "ell"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstInclude(xs, "ell")) + " in " + xs)
  }
  def `collection.mutable.Seq("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not include regex' failed` {
    val xs = collection.mutable.Seq("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not include regex ("ell")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotInclude(xs, "ell")) + " in " + xs)
  }
  def `collection.mutable.Seq("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should fullyMatch regex' failed` {
    val xs = collection.mutable.Seq("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should fullyMatch regex "h.*!"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstMatches(xs, "h.*!")) + " in " + xs)
  }
  def `collection.mutable.Seq("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not fullyMatch regex' failed` {
    val xs = collection.mutable.Seq("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not fullyMatch regex ("h.*!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotMatches(xs, "h.*!")) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should startWith' failed` {
    val xs = collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should startWith ("hello")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstStartsWith(xs, "hello")) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not startWith' failed` {
    val xs = collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not startWith ("hello")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotStartsWith(xs, "hello")) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should endWith' failed` {
    val xs = collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should endWith ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstEndsWith(xs, "!")) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not endWith' failed` {
    val xs = collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not endWith ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotEndsWith(xs, "!")) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should include' failed` {
    val xs = collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should include ("ell")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstInclude(xs, "ell")) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not include' failed` {
    val xs = collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not include "ell"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotInclude(xs, "ell")) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should startWith regex' failed` {
    val xs = collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should startWith regex "hel*o"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstStartsWith(xs, "hello")) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not startWith regex' failed` {
    val xs = collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not startWith regex ("hel*o")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotStartsWith(xs, "hello")) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should endWith regex' failed` {
    val xs = collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should endWith regex "!"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstEndsWith(xs, "!")) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not endWith regex' failed` {
    val xs = collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not endWith regex ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotEndsWith(xs, "!")) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should include regex' failed` {
    val xs = collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should include regex "ell"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstInclude(xs, "ell")) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not include regex' failed` {
    val xs = collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not include regex ("ell")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotInclude(xs, "ell")) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should fullyMatch regex' failed` {
    val xs = collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should fullyMatch regex "h.*!"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstMatches(xs, "h.*!")) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!") should throw TestFailedException with correct stack depth and message when 'should not fullyMatch regex' failed` {
    val xs = collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!")
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not fullyMatch regex ("h.*!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotMatches(xs, "h.*!")) + " in " + xs)
  }
  def `collection.mutable.Set("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should startWith' failed` {
    val xs = collection.mutable.Set("hello A!", "hi B", "hello C!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should startWith ("hello")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstStartsWith(xs, "hello")) + " in " + xs)
  }
  def `collection.mutable.Set("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should not startWith' failed` {
    val xs = collection.mutable.Set("hello A!", "hi B", "hello C!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not startWith ("hello")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotStartsWith(xs, "hello")) + " in " + xs)
  }
  def `collection.mutable.Set("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should endWith' failed` {
    val xs = collection.mutable.Set("hello A!", "hi B", "hello C!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should endWith ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstEndsWith(xs, "!")) + " in " + xs)
  }
  def `collection.mutable.Set("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should not endWith' failed` {
    val xs = collection.mutable.Set("hello A!", "hi B", "hello C!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not endWith ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotEndsWith(xs, "!")) + " in " + xs)
  }
  def `collection.mutable.Set("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should include' failed` {
    val xs = collection.mutable.Set("hello A!", "hi B", "hello C!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should include ("ell")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstInclude(xs, "ell")) + " in " + xs)
  }
  def `collection.mutable.Set("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should not include' failed` {
    val xs = collection.mutable.Set("hello A!", "hi B", "hello C!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not include "ell"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotInclude(xs, "ell")) + " in " + xs)
  }
  def `collection.mutable.Set("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should startWith regex' failed` {
    val xs = collection.mutable.Set("hello A!", "hi B", "hello C!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should startWith regex "hel*o"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstStartsWith(xs, "hello")) + " in " + xs)
  }
  def `collection.mutable.Set("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should not startWith regex' failed` {
    val xs = collection.mutable.Set("hello A!", "hi B", "hello C!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not startWith regex ("hel*o")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotStartsWith(xs, "hello")) + " in " + xs)
  }
  def `collection.mutable.Set("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should endWith regex' failed` {
    val xs = collection.mutable.Set("hello A!", "hi B", "hello C!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should endWith regex "!"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstEndsWith(xs, "!")) + " in " + xs)
  }
  def `collection.mutable.Set("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should not endWith regex' failed` {
    val xs = collection.mutable.Set("hello A!", "hi B", "hello C!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not endWith regex ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotEndsWith(xs, "!")) + " in " + xs)
  }
  def `collection.mutable.Set("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should include regex' failed` {
    val xs = collection.mutable.Set("hello A!", "hi B", "hello C!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should include regex "ell"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstInclude(xs, "ell")) + " in " + xs)
  }
  def `collection.mutable.Set("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should not include regex' failed` {
    val xs = collection.mutable.Set("hello A!", "hi B", "hello C!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not include regex ("ell")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotInclude(xs, "ell")) + " in " + xs)
  }
  def `collection.mutable.Set("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should fullyMatch regex' failed` {
    val xs = collection.mutable.Set("hello A!", "hi B", "hello C!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should fullyMatch regex "h.*!"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstMatches(xs, "h.*!")) + " in " + xs)
  }
  def `collection.mutable.Set("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should not fullyMatch regex' failed` {
    val xs = collection.mutable.Set("hello A!", "hi B", "hello C!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not fullyMatch regex ("h.*!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotMatches(xs, "h.*!")) + " in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!")).par should throw TestFailedException with correct stack depth and message when 'should startWith' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should startWith ("hello")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstStartsWith(xs, "hello")) + " in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!")).par should throw TestFailedException with correct stack depth and message when 'should not startWith' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not startWith ("hello")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotStartsWith(xs, "hello")) + " in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!")).par should throw TestFailedException with correct stack depth and message when 'should endWith' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should endWith ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstEndsWith(xs, "!")) + " in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!")).par should throw TestFailedException with correct stack depth and message when 'should not endWith' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not endWith ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotEndsWith(xs, "!")) + " in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!")).par should throw TestFailedException with correct stack depth and message when 'should include' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should include ("ell")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstInclude(xs, "ell")) + " in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!")).par should throw TestFailedException with correct stack depth and message when 'should not include' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not include "ell"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotInclude(xs, "ell")) + " in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!")).par should throw TestFailedException with correct stack depth and message when 'should startWith regex' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should startWith regex "hel*o"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstStartsWith(xs, "hello")) + " in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!")).par should throw TestFailedException with correct stack depth and message when 'should not startWith regex' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not startWith regex ("hel*o")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotStartsWith(xs, "hello")) + " in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!")).par should throw TestFailedException with correct stack depth and message when 'should endWith regex' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should endWith regex "!"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstEndsWith(xs, "!")) + " in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!")).par should throw TestFailedException with correct stack depth and message when 'should not endWith regex' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not endWith regex ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotEndsWith(xs, "!")) + " in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!")).par should throw TestFailedException with correct stack depth and message when 'should include regex' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should include regex "ell"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstInclude(xs, "ell")) + " in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!")).par should throw TestFailedException with correct stack depth and message when 'should not include regex' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not include regex ("ell")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotInclude(xs, "ell")) + " in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!")).par should throw TestFailedException with correct stack depth and message when 'should fullyMatch regex' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should fullyMatch regex "h.*!"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstMatches(xs, "h.*!")) + " in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!")).par should throw TestFailedException with correct stack depth and message when 'should not fullyMatch regex' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List("hello A!", "hi B", "hello C!")).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not fullyMatch regex ("h.*!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotMatches(xs, "h.*!")) + " in " + xs)
  }
  def `collection.mutable.Seq("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should startWith' failed` {
    val xs = collection.mutable.Seq("hello A!", "hi B", "hello C!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should startWith ("hello")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstStartsWith(xs, "hello")) + " in " + xs)
  }
  def `collection.mutable.Seq("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should not startWith' failed` {
    val xs = collection.mutable.Seq("hello A!", "hi B", "hello C!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not startWith ("hello")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotStartsWith(xs, "hello")) + " in " + xs)
  }
  def `collection.mutable.Seq("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should endWith' failed` {
    val xs = collection.mutable.Seq("hello A!", "hi B", "hello C!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should endWith ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstEndsWith(xs, "!")) + " in " + xs)
  }
  def `collection.mutable.Seq("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should not endWith' failed` {
    val xs = collection.mutable.Seq("hello A!", "hi B", "hello C!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not endWith ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotEndsWith(xs, "!")) + " in " + xs)
  }
  def `collection.mutable.Seq("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should include' failed` {
    val xs = collection.mutable.Seq("hello A!", "hi B", "hello C!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should include ("ell")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstInclude(xs, "ell")) + " in " + xs)
  }
  def `collection.mutable.Seq("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should not include' failed` {
    val xs = collection.mutable.Seq("hello A!", "hi B", "hello C!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not include "ell"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotInclude(xs, "ell")) + " in " + xs)
  }
  def `collection.mutable.Seq("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should startWith regex' failed` {
    val xs = collection.mutable.Seq("hello A!", "hi B", "hello C!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should startWith regex "hel*o"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstStartsWith(xs, "hello")) + " in " + xs)
  }
  def `collection.mutable.Seq("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should not startWith regex' failed` {
    val xs = collection.mutable.Seq("hello A!", "hi B", "hello C!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not startWith regex ("hel*o")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotStartsWith(xs, "hello")) + " in " + xs)
  }
  def `collection.mutable.Seq("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should endWith regex' failed` {
    val xs = collection.mutable.Seq("hello A!", "hi B", "hello C!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should endWith regex "!"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstEndsWith(xs, "!")) + " in " + xs)
  }
  def `collection.mutable.Seq("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should not endWith regex' failed` {
    val xs = collection.mutable.Seq("hello A!", "hi B", "hello C!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not endWith regex ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotEndsWith(xs, "!")) + " in " + xs)
  }
  def `collection.mutable.Seq("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should include regex' failed` {
    val xs = collection.mutable.Seq("hello A!", "hi B", "hello C!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should include regex "ell"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstInclude(xs, "ell")) + " in " + xs)
  }
  def `collection.mutable.Seq("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should not include regex' failed` {
    val xs = collection.mutable.Seq("hello A!", "hi B", "hello C!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not include regex ("ell")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotInclude(xs, "ell")) + " in " + xs)
  }
  def `collection.mutable.Seq("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should fullyMatch regex' failed` {
    val xs = collection.mutable.Seq("hello A!", "hi B", "hello C!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should fullyMatch regex "h.*!"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstMatches(xs, "h.*!")) + " in " + xs)
  }
  def `collection.mutable.Seq("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should not fullyMatch regex' failed` {
    val xs = collection.mutable.Seq("hello A!", "hi B", "hello C!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not fullyMatch regex ("h.*!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotMatches(xs, "h.*!")) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should startWith' failed` {
    val xs = collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should startWith ("hello")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstStartsWith(xs, "hello")) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should not startWith' failed` {
    val xs = collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not startWith ("hello")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotStartsWith(xs, "hello")) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should endWith' failed` {
    val xs = collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should endWith ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstEndsWith(xs, "!")) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should not endWith' failed` {
    val xs = collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not endWith ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotEndsWith(xs, "!")) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should include' failed` {
    val xs = collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should include ("ell")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstInclude(xs, "ell")) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should not include' failed` {
    val xs = collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not include "ell"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotInclude(xs, "ell")) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should startWith regex' failed` {
    val xs = collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should startWith regex "hel*o"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstStartsWith(xs, "hello")) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should not startWith regex' failed` {
    val xs = collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not startWith regex ("hel*o")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotStartsWith(xs, "hello")) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should endWith regex' failed` {
    val xs = collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should endWith regex "!"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstEndsWith(xs, "!")) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should not endWith regex' failed` {
    val xs = collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not endWith regex ("!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotEndsWith(xs, "!")) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should include regex' failed` {
    val xs = collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should include regex "ell"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstInclude(xs, "ell")) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should not include regex' failed` {
    val xs = collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not include regex ("ell")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotInclude(xs, "ell")) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should fullyMatch regex' failed` {
    val xs = collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should fullyMatch regex "h.*!"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstMatches(xs, "h.*!")) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!").par should throw TestFailedException with correct stack depth and message when 'should not fullyMatch regex' failed` {
    val xs = collection.mutable.IndexedSeq("hello A!", "hi B", "hello C!").par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not fullyMatch regex ("h.*!")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotMatches(xs, "h.*!")) + " in " + xs)
  }
  def `Set(Set[String]("hi"), Set[String]("boom!"), Set[String]()) should throw TestFailedException with correct stack depth and message when 'traversable should not be symbol' failed` {
    val xs = Set(Set[String]("hi"), Set[String]("boom!"), Set[String]())
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not be 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstSizeNotEqualGenTraversable[String](xs, 0)) + " in " + xs)
  }
  def `List(List[String]("hi"), List[String]("boom!"), List[String]()) should throw TestFailedException with correct stack depth and message when 'traversable should not be symbol' failed` {
    val xs = List(List[String]("hi"), List[String]("boom!"), List[String]())
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not be 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstSizeNotEqualGenTraversable[String](xs, 0)) + " in " + xs)
  }
  def `Seq(Seq[String]("hi"), Seq[String]("boom!"), Seq[String]()) should throw TestFailedException with correct stack depth and message when 'traversable should not be symbol' failed` {
    val xs = Seq(Seq[String]("hi"), Seq[String]("boom!"), Seq[String]())
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not be 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstSizeNotEqualGenTraversable[String](xs, 0)) + " in " + xs)
  }
  def `Array[Array[String]](Array[String]("hi"), Array[String]("boom!"), Array[String]()) should throw TestFailedException with correct stack depth and message when 'traversable should not be symbol' failed` {
    val xs = Array[Array[String]](Array[String]("hi"), Array[String]("boom!"), Array[String]())
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not be 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstSizeNotEqualGenTraversableArray[String](xs, 0)) + " in " + arrayToString(xs))
  }
  def `IndexedSeq(IndexedSeq[String]("hi"), IndexedSeq[String]("boom!"), IndexedSeq[String]()) should throw TestFailedException with correct stack depth and message when 'traversable should not be symbol' failed` {
    val xs = IndexedSeq(IndexedSeq[String]("hi"), IndexedSeq[String]("boom!"), IndexedSeq[String]())
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not be 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstSizeNotEqualGenTraversable[String](xs, 0)) + " in " + xs)
  }
  def `Vector(Vector[String]("hi"), Vector[String]("boom!"), Vector[String]()) should throw TestFailedException with correct stack depth and message when 'traversable should not be symbol' failed` {
    val xs = Vector(Vector[String]("hi"), Vector[String]("boom!"), Vector[String]())
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not be 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstSizeNotEqualGenTraversable[String](xs, 0)) + " in " + xs)
  }
  def `Set(Set[String]("hi").par, Set[String]("boom!").par, Set[String]().par).par should throw TestFailedException with correct stack depth and message when 'traversable should not be symbol' failed` {
    val xs = Set(Set[String]("hi").par, Set[String]("boom!").par, Set[String]().par).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not be 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstSizeNotEqualGenTraversable[String](xs, 0)) + " in " + xs)
  }
  def `List(List[String]("hi").par, List[String]("boom!").par, List[String]().par).par should throw TestFailedException with correct stack depth and message when 'traversable should not be symbol' failed` {
    val xs = List(List[String]("hi").par, List[String]("boom!").par, List[String]().par).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not be 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstSizeNotEqualGenTraversable[String](xs, 0)) + " in " + xs)
  }
  def `Seq(Seq[String]("hi").par, Seq[String]("boom!").par, Seq[String]().par).par should throw TestFailedException with correct stack depth and message when 'traversable should not be symbol' failed` {
    val xs = Seq(Seq[String]("hi").par, Seq[String]("boom!").par, Seq[String]().par).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not be 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstSizeNotEqualGenTraversable[String](xs, 0)) + " in " + xs)
  }
  def `IndexedSeq(IndexedSeq[String]("hi").par, IndexedSeq[String]("boom!").par, IndexedSeq[String]().par).par should throw TestFailedException with correct stack depth and message when 'traversable should not be symbol' failed` {
    val xs = IndexedSeq(IndexedSeq[String]("hi").par, IndexedSeq[String]("boom!").par, IndexedSeq[String]().par).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not be 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstSizeNotEqualGenTraversable[String](xs, 0)) + " in " + xs)
  }
  def `collection.mutable.Set(collection.mutable.Set[String]("hi"), collection.mutable.Set[String]("boom!"), collection.mutable.Set[String]()) should throw TestFailedException with correct stack depth and message when 'traversable should not be symbol' failed` {
    val xs = collection.mutable.Set(collection.mutable.Set[String]("hi"), collection.mutable.Set[String]("boom!"), collection.mutable.Set[String]())
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not be 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstSizeNotEqualGenTraversable[String](xs, 0)) + " in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List(new collection.mutable.ListBuffer[String]() ++ List[String]("hi"), new collection.mutable.ListBuffer[String]() ++ List[String]("boom!"), new collection.mutable.ListBuffer[String]() ++ List[String]()) should throw TestFailedException with correct stack depth and message when 'traversable should not be symbol' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List(new collection.mutable.ListBuffer[String]() ++ List[String]("hi"), new collection.mutable.ListBuffer[String]() ++ List[String]("boom!"), new collection.mutable.ListBuffer[String]() ++ List[String]())
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not be 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstSizeNotEqualGenTraversable[String](xs, 0)) + " in " + xs)
  }
  def `collection.mutable.Seq(collection.mutable.Seq[String]("hi"), collection.mutable.Seq[String]("boom!"), collection.mutable.Seq[String]()) should throw TestFailedException with correct stack depth and message when 'traversable should not be symbol' failed` {
    val xs = collection.mutable.Seq(collection.mutable.Seq[String]("hi"), collection.mutable.Seq[String]("boom!"), collection.mutable.Seq[String]())
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not be 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstSizeNotEqualGenTraversable[String](xs, 0)) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq(collection.mutable.IndexedSeq[String]("hi"), collection.mutable.IndexedSeq[String]("boom!"), collection.mutable.IndexedSeq[String]()) should throw TestFailedException with correct stack depth and message when 'traversable should not be symbol' failed` {
    val xs = collection.mutable.IndexedSeq(collection.mutable.IndexedSeq[String]("hi"), collection.mutable.IndexedSeq[String]("boom!"), collection.mutable.IndexedSeq[String]())
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not be 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstSizeNotEqualGenTraversable[String](xs, 0)) + " in " + xs)
  }
  def `collection.mutable.Set(collection.mutable.Set[String]("hi").par, collection.mutable.Set[String]("boom!").par, collection.mutable.Set[String]().par).par should throw TestFailedException with correct stack depth and message when 'traversable should not be symbol' failed` {
    val xs = collection.mutable.Set(collection.mutable.Set[String]("hi").par, collection.mutable.Set[String]("boom!").par, collection.mutable.Set[String]().par).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not be 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstSizeNotEqualGenTraversable[String](xs, 0)) + " in " + xs)
  }
  def `(new collection.mutable.ListBuffer() ++ List((new collection.mutable.ListBuffer[String]() ++ List[String]("hi")).par, (new collection.mutable.ListBuffer[String]() ++ List[String]("boom!")).par, (new collection.mutable.ListBuffer[String]() ++ List[String]()).par)).par should throw TestFailedException with correct stack depth and message when 'traversable should not be symbol' failed` {
    val xs = (new collection.mutable.ListBuffer() ++ List((new collection.mutable.ListBuffer[String]() ++ List[String]("hi")).par, (new collection.mutable.ListBuffer[String]() ++ List[String]("boom!")).par, (new collection.mutable.ListBuffer[String]() ++ List[String]()).par)).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not be 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstSizeNotEqualGenTraversable[String](xs, 0)) + " in " + xs)
  }
  def `collection.mutable.Seq(collection.mutable.Seq[String]("hi").par, collection.mutable.Seq[String]("boom!").par, collection.mutable.Seq[String]().par).par should throw TestFailedException with correct stack depth and message when 'traversable should not be symbol' failed` {
    val xs = collection.mutable.Seq(collection.mutable.Seq[String]("hi").par, collection.mutable.Seq[String]("boom!").par, collection.mutable.Seq[String]().par).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not be 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstSizeNotEqualGenTraversable[String](xs, 0)) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq(collection.mutable.IndexedSeq[String]("hi").par, collection.mutable.IndexedSeq[String]("boom!").par, collection.mutable.IndexedSeq[String]().par).par should throw TestFailedException with correct stack depth and message when 'traversable should not be symbol' failed` {
    val xs = collection.mutable.IndexedSeq(collection.mutable.IndexedSeq[String]("hi").par, collection.mutable.IndexedSeq[String]("boom!").par, collection.mutable.IndexedSeq[String]().par).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not be 'empty
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstSizeNotEqualGenTraversable[String](xs, 0)) + " in " + xs)
  }
  def `Set(Set[String]("hi"), Set[String]("boom!"), Set[String]("hello")) should throw TestFailedException with correct stack depth and message when 'traversable should have size' failed` {
    val xs = Set(Set[String]("hi"), Set[String]("boom!"), Set[String]("hello"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should have size 1
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstSizeEqualGenTraversable[String](xs, 1)) + " in " + xs)
  }
  def `Set(Set[String]("hi"), Set[String]("boom!"), Set[String]("hello")) should throw TestFailedException with correct stack depth and message when 'traversable should not have size' failed` {
    val xs = Set(Set[String]("hi"), Set[String]("boom!"), Set[String]("hello"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not have size (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstSizeNotEqualGenTraversable[String](xs, 2)) + " in " + xs)
  }
  def `Set(Set[String]("hi"), Set[String]("boom!"), Set[String]("hello")) should throw TestFailedException with correct stack depth and message when 'traversable should contain' failed` {
    val xs = Set(Set[String]("hi"), Set[String]("boom!"), Set[String]("hello"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should contain ("hi")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstContainGenTraversable[String](xs, "hi")) + " in " + xs)
  }
  def `Set(Set[String]("hi"), Set[String]("boom!"), Set[String]("hello")) should throw TestFailedException with correct stack depth and message when 'traversable should not contain' failed` {
    val xs = Set(Set[String]("hi"), Set[String]("boom!"), Set[String]("hello"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not contain "hi"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotContainGenTraversable[String](xs, "hi")) + " in " + xs)
  }
  def `List(List[String]("hi"), List[String]("boom!"), List[String]("hello")) should throw TestFailedException with correct stack depth and message when 'traversable should have size' failed` {
    val xs = List(List[String]("hi"), List[String]("boom!"), List[String]("hello"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should have size 1
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstSizeEqualGenTraversable[String](xs, 1)) + " in " + xs)
  }
  def `List(List[String]("hi"), List[String]("boom!"), List[String]("hello")) should throw TestFailedException with correct stack depth and message when 'traversable should not have size' failed` {
    val xs = List(List[String]("hi"), List[String]("boom!"), List[String]("hello"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not have size (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstSizeNotEqualGenTraversable[String](xs, 2)) + " in " + xs)
  }
  def `List(List[String]("hi"), List[String]("boom!"), List[String]("hello")) should throw TestFailedException with correct stack depth and message when 'traversable should have length' failed` {
    val xs = List(List[String]("hi"), List[String]("boom!"), List[String]("hello"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should have length 1
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstSizeEqualGenTraversable[String](xs, 1)) + " in " + xs)
  }
  def `List(List[String]("hi"), List[String]("boom!"), List[String]("hello")) should throw TestFailedException with correct stack depth and message when 'traversable should not have length' failed` {
    val xs = List(List[String]("hi"), List[String]("boom!"), List[String]("hello"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not have length (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstSizeNotEqualGenTraversable[String](xs, 2)) + " in " + xs)
  }
  def `List(List[String]("hi"), List[String]("boom!"), List[String]("hello")) should throw TestFailedException with correct stack depth and message when 'traversable should contain' failed` {
    val xs = List(List[String]("hi"), List[String]("boom!"), List[String]("hello"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should contain ("hi")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstContainGenTraversable[String](xs, "hi")) + " in " + xs)
  }
  def `List(List[String]("hi"), List[String]("boom!"), List[String]("hello")) should throw TestFailedException with correct stack depth and message when 'traversable should not contain' failed` {
    val xs = List(List[String]("hi"), List[String]("boom!"), List[String]("hello"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not contain "hi"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotContainGenTraversable[String](xs, "hi")) + " in " + xs)
  }
  def `Seq(Seq[String]("hi"), Seq[String]("boom!"), Seq[String]("hello")) should throw TestFailedException with correct stack depth and message when 'traversable should have size' failed` {
    val xs = Seq(Seq[String]("hi"), Seq[String]("boom!"), Seq[String]("hello"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should have size 1
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstSizeEqualGenTraversable[String](xs, 1)) + " in " + xs)
  }
  def `Seq(Seq[String]("hi"), Seq[String]("boom!"), Seq[String]("hello")) should throw TestFailedException with correct stack depth and message when 'traversable should not have size' failed` {
    val xs = Seq(Seq[String]("hi"), Seq[String]("boom!"), Seq[String]("hello"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not have size (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstSizeNotEqualGenTraversable[String](xs, 2)) + " in " + xs)
  }
  def `Seq(Seq[String]("hi"), Seq[String]("boom!"), Seq[String]("hello")) should throw TestFailedException with correct stack depth and message when 'traversable should have length' failed` {
    val xs = Seq(Seq[String]("hi"), Seq[String]("boom!"), Seq[String]("hello"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should have length 1
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstSizeEqualGenTraversable[String](xs, 1)) + " in " + xs)
  }
  def `Seq(Seq[String]("hi"), Seq[String]("boom!"), Seq[String]("hello")) should throw TestFailedException with correct stack depth and message when 'traversable should not have length' failed` {
    val xs = Seq(Seq[String]("hi"), Seq[String]("boom!"), Seq[String]("hello"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not have length (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstSizeNotEqualGenTraversable[String](xs, 2)) + " in " + xs)
  }
  def `Seq(Seq[String]("hi"), Seq[String]("boom!"), Seq[String]("hello")) should throw TestFailedException with correct stack depth and message when 'traversable should contain' failed` {
    val xs = Seq(Seq[String]("hi"), Seq[String]("boom!"), Seq[String]("hello"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should contain ("hi")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstContainGenTraversable[String](xs, "hi")) + " in " + xs)
  }
  def `Seq(Seq[String]("hi"), Seq[String]("boom!"), Seq[String]("hello")) should throw TestFailedException with correct stack depth and message when 'traversable should not contain' failed` {
    val xs = Seq(Seq[String]("hi"), Seq[String]("boom!"), Seq[String]("hello"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not contain "hi"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotContainGenTraversable[String](xs, "hi")) + " in " + xs)
  }
  def `Array[Array[String]](Array[String]("hi"), Array[String]("boom!"), Array[String]("hello")) should throw TestFailedException with correct stack depth and message when 'traversable should have size' failed` {
    val xs = Array[Array[String]](Array[String]("hi"), Array[String]("boom!"), Array[String]("hello"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should have size 1
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstSizeEqualGenTraversableArray[String](xs, 1)) + " in " + arrayToString(xs))
  }
  def `Array[Array[String]](Array[String]("hi"), Array[String]("boom!"), Array[String]("hello")) should throw TestFailedException with correct stack depth and message when 'traversable should not have size' failed` {
    val xs = Array[Array[String]](Array[String]("hi"), Array[String]("boom!"), Array[String]("hello"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not have size (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstSizeNotEqualGenTraversableArray[String](xs, 2)) + " in " + arrayToString(xs))
  }
  def `Array[Array[String]](Array[String]("hi"), Array[String]("boom!"), Array[String]("hello")) should throw TestFailedException with correct stack depth and message when 'traversable should have length' failed` {
    val xs = Array[Array[String]](Array[String]("hi"), Array[String]("boom!"), Array[String]("hello"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should have length 1
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstSizeEqualGenTraversableArray[String](xs, 1)) + " in " + arrayToString(xs))
  }
  def `Array[Array[String]](Array[String]("hi"), Array[String]("boom!"), Array[String]("hello")) should throw TestFailedException with correct stack depth and message when 'traversable should not have length' failed` {
    val xs = Array[Array[String]](Array[String]("hi"), Array[String]("boom!"), Array[String]("hello"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not have length (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstSizeNotEqualGenTraversableArray[String](xs, 2)) + " in " + arrayToString(xs))
  }
  def `Array[Array[String]](Array[String]("hi"), Array[String]("boom!"), Array[String]("hello")) should throw TestFailedException with correct stack depth and message when 'traversable should contain' failed` {
    val xs = Array[Array[String]](Array[String]("hi"), Array[String]("boom!"), Array[String]("hello"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should contain ("hi")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstContainGenTraversableArray[String](xs, "hi")) + " in " + arrayToString(xs))
  }
  def `Array[Array[String]](Array[String]("hi"), Array[String]("boom!"), Array[String]("hello")) should throw TestFailedException with correct stack depth and message when 'traversable should not contain' failed` {
    val xs = Array[Array[String]](Array[String]("hi"), Array[String]("boom!"), Array[String]("hello"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not contain "hi"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotContainGenTraversableArray[String](xs, "hi")) + " in " + arrayToString(xs))
  }
  def `IndexedSeq(IndexedSeq[String]("hi"), IndexedSeq[String]("boom!"), IndexedSeq[String]("hello")) should throw TestFailedException with correct stack depth and message when 'traversable should have size' failed` {
    val xs = IndexedSeq(IndexedSeq[String]("hi"), IndexedSeq[String]("boom!"), IndexedSeq[String]("hello"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should have size 1
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstSizeEqualGenTraversable[String](xs, 1)) + " in " + xs)
  }
  def `IndexedSeq(IndexedSeq[String]("hi"), IndexedSeq[String]("boom!"), IndexedSeq[String]("hello")) should throw TestFailedException with correct stack depth and message when 'traversable should not have size' failed` {
    val xs = IndexedSeq(IndexedSeq[String]("hi"), IndexedSeq[String]("boom!"), IndexedSeq[String]("hello"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not have size (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstSizeNotEqualGenTraversable[String](xs, 2)) + " in " + xs)
  }
  def `IndexedSeq(IndexedSeq[String]("hi"), IndexedSeq[String]("boom!"), IndexedSeq[String]("hello")) should throw TestFailedException with correct stack depth and message when 'traversable should have length' failed` {
    val xs = IndexedSeq(IndexedSeq[String]("hi"), IndexedSeq[String]("boom!"), IndexedSeq[String]("hello"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should have length 1
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstSizeEqualGenTraversable[String](xs, 1)) + " in " + xs)
  }
  def `IndexedSeq(IndexedSeq[String]("hi"), IndexedSeq[String]("boom!"), IndexedSeq[String]("hello")) should throw TestFailedException with correct stack depth and message when 'traversable should not have length' failed` {
    val xs = IndexedSeq(IndexedSeq[String]("hi"), IndexedSeq[String]("boom!"), IndexedSeq[String]("hello"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not have length (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstSizeNotEqualGenTraversable[String](xs, 2)) + " in " + xs)
  }
  def `IndexedSeq(IndexedSeq[String]("hi"), IndexedSeq[String]("boom!"), IndexedSeq[String]("hello")) should throw TestFailedException with correct stack depth and message when 'traversable should contain' failed` {
    val xs = IndexedSeq(IndexedSeq[String]("hi"), IndexedSeq[String]("boom!"), IndexedSeq[String]("hello"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should contain ("hi")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstContainGenTraversable[String](xs, "hi")) + " in " + xs)
  }
  def `IndexedSeq(IndexedSeq[String]("hi"), IndexedSeq[String]("boom!"), IndexedSeq[String]("hello")) should throw TestFailedException with correct stack depth and message when 'traversable should not contain' failed` {
    val xs = IndexedSeq(IndexedSeq[String]("hi"), IndexedSeq[String]("boom!"), IndexedSeq[String]("hello"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not contain "hi"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotContainGenTraversable[String](xs, "hi")) + " in " + xs)
  }
  def `Vector(Vector[String]("hi"), Vector[String]("boom!"), Vector[String]("hello")) should throw TestFailedException with correct stack depth and message when 'traversable should have size' failed` {
    val xs = Vector(Vector[String]("hi"), Vector[String]("boom!"), Vector[String]("hello"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should have size 1
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstSizeEqualGenTraversable[String](xs, 1)) + " in " + xs)
  }
  def `Vector(Vector[String]("hi"), Vector[String]("boom!"), Vector[String]("hello")) should throw TestFailedException with correct stack depth and message when 'traversable should not have size' failed` {
    val xs = Vector(Vector[String]("hi"), Vector[String]("boom!"), Vector[String]("hello"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not have size (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstSizeNotEqualGenTraversable[String](xs, 2)) + " in " + xs)
  }
  def `Vector(Vector[String]("hi"), Vector[String]("boom!"), Vector[String]("hello")) should throw TestFailedException with correct stack depth and message when 'traversable should have length' failed` {
    val xs = Vector(Vector[String]("hi"), Vector[String]("boom!"), Vector[String]("hello"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should have length 1
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstSizeEqualGenTraversable[String](xs, 1)) + " in " + xs)
  }
  def `Vector(Vector[String]("hi"), Vector[String]("boom!"), Vector[String]("hello")) should throw TestFailedException with correct stack depth and message when 'traversable should not have length' failed` {
    val xs = Vector(Vector[String]("hi"), Vector[String]("boom!"), Vector[String]("hello"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not have length (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstSizeNotEqualGenTraversable[String](xs, 2)) + " in " + xs)
  }
  def `Vector(Vector[String]("hi"), Vector[String]("boom!"), Vector[String]("hello")) should throw TestFailedException with correct stack depth and message when 'traversable should contain' failed` {
    val xs = Vector(Vector[String]("hi"), Vector[String]("boom!"), Vector[String]("hello"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should contain ("hi")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstContainGenTraversable[String](xs, "hi")) + " in " + xs)
  }
  def `Vector(Vector[String]("hi"), Vector[String]("boom!"), Vector[String]("hello")) should throw TestFailedException with correct stack depth and message when 'traversable should not contain' failed` {
    val xs = Vector(Vector[String]("hi"), Vector[String]("boom!"), Vector[String]("hello"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not contain "hi"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotContainGenTraversable[String](xs, "hi")) + " in " + xs)
  }
  def `Set(Set[String]("hi").par, Set[String]("boom!").par, Set[String]("hello").par).par should throw TestFailedException with correct stack depth and message when 'traversable should have size' failed` {
    val xs = Set(Set[String]("hi").par, Set[String]("boom!").par, Set[String]("hello").par).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should have size 1
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstSizeEqualGenTraversable[String](xs, 1)) + " in " + xs)
  }
  def `Set(Set[String]("hi").par, Set[String]("boom!").par, Set[String]("hello").par).par should throw TestFailedException with correct stack depth and message when 'traversable should not have size' failed` {
    val xs = Set(Set[String]("hi").par, Set[String]("boom!").par, Set[String]("hello").par).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not have size (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstSizeNotEqualGenTraversable[String](xs, 2)) + " in " + xs)
  }
  def `Set(Set[String]("hi").par, Set[String]("boom!").par, Set[String]("hello").par).par should throw TestFailedException with correct stack depth and message when 'traversable should contain' failed` {
    val xs = Set(Set[String]("hi").par, Set[String]("boom!").par, Set[String]("hello").par).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should contain ("hi")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstContainGenTraversable[String](xs, "hi")) + " in " + xs)
  }
  def `Set(Set[String]("hi").par, Set[String]("boom!").par, Set[String]("hello").par).par should throw TestFailedException with correct stack depth and message when 'traversable should not contain' failed` {
    val xs = Set(Set[String]("hi").par, Set[String]("boom!").par, Set[String]("hello").par).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not contain "hi"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotContainGenTraversable[String](xs, "hi")) + " in " + xs)
  }
  def `List(List[String]("hi").par, List[String]("boom!").par, List[String]("hello").par).par should throw TestFailedException with correct stack depth and message when 'traversable should have size' failed` {
    val xs = List(List[String]("hi").par, List[String]("boom!").par, List[String]("hello").par).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should have size 1
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstSizeEqualGenTraversable[String](xs, 1)) + " in " + xs)
  }
  def `List(List[String]("hi").par, List[String]("boom!").par, List[String]("hello").par).par should throw TestFailedException with correct stack depth and message when 'traversable should not have size' failed` {
    val xs = List(List[String]("hi").par, List[String]("boom!").par, List[String]("hello").par).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not have size (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstSizeNotEqualGenTraversable[String](xs, 2)) + " in " + xs)
  }
  def `List(List[String]("hi").par, List[String]("boom!").par, List[String]("hello").par).par should throw TestFailedException with correct stack depth and message when 'traversable should have length' failed` {
    val xs = List(List[String]("hi").par, List[String]("boom!").par, List[String]("hello").par).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should have length 1
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstSizeEqualGenTraversable[String](xs, 1)) + " in " + xs)
  }
  def `List(List[String]("hi").par, List[String]("boom!").par, List[String]("hello").par).par should throw TestFailedException with correct stack depth and message when 'traversable should not have length' failed` {
    val xs = List(List[String]("hi").par, List[String]("boom!").par, List[String]("hello").par).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not have length (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstSizeNotEqualGenTraversable[String](xs, 2)) + " in " + xs)
  }
  def `List(List[String]("hi").par, List[String]("boom!").par, List[String]("hello").par).par should throw TestFailedException with correct stack depth and message when 'traversable should contain' failed` {
    val xs = List(List[String]("hi").par, List[String]("boom!").par, List[String]("hello").par).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should contain ("hi")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstContainGenTraversable[String](xs, "hi")) + " in " + xs)
  }
  def `List(List[String]("hi").par, List[String]("boom!").par, List[String]("hello").par).par should throw TestFailedException with correct stack depth and message when 'traversable should not contain' failed` {
    val xs = List(List[String]("hi").par, List[String]("boom!").par, List[String]("hello").par).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not contain "hi"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotContainGenTraversable[String](xs, "hi")) + " in " + xs)
  }
  def `Seq(Seq[String]("hi").par, Seq[String]("boom!").par, Seq[String]("hello").par).par should throw TestFailedException with correct stack depth and message when 'traversable should have size' failed` {
    val xs = Seq(Seq[String]("hi").par, Seq[String]("boom!").par, Seq[String]("hello").par).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should have size 1
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstSizeEqualGenTraversable[String](xs, 1)) + " in " + xs)
  }
  def `Seq(Seq[String]("hi").par, Seq[String]("boom!").par, Seq[String]("hello").par).par should throw TestFailedException with correct stack depth and message when 'traversable should not have size' failed` {
    val xs = Seq(Seq[String]("hi").par, Seq[String]("boom!").par, Seq[String]("hello").par).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not have size (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstSizeNotEqualGenTraversable[String](xs, 2)) + " in " + xs)
  }
  def `Seq(Seq[String]("hi").par, Seq[String]("boom!").par, Seq[String]("hello").par).par should throw TestFailedException with correct stack depth and message when 'traversable should have length' failed` {
    val xs = Seq(Seq[String]("hi").par, Seq[String]("boom!").par, Seq[String]("hello").par).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should have length 1
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstSizeEqualGenTraversable[String](xs, 1)) + " in " + xs)
  }
  def `Seq(Seq[String]("hi").par, Seq[String]("boom!").par, Seq[String]("hello").par).par should throw TestFailedException with correct stack depth and message when 'traversable should not have length' failed` {
    val xs = Seq(Seq[String]("hi").par, Seq[String]("boom!").par, Seq[String]("hello").par).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not have length (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstSizeNotEqualGenTraversable[String](xs, 2)) + " in " + xs)
  }
  def `Seq(Seq[String]("hi").par, Seq[String]("boom!").par, Seq[String]("hello").par).par should throw TestFailedException with correct stack depth and message when 'traversable should contain' failed` {
    val xs = Seq(Seq[String]("hi").par, Seq[String]("boom!").par, Seq[String]("hello").par).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should contain ("hi")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstContainGenTraversable[String](xs, "hi")) + " in " + xs)
  }
  def `Seq(Seq[String]("hi").par, Seq[String]("boom!").par, Seq[String]("hello").par).par should throw TestFailedException with correct stack depth and message when 'traversable should not contain' failed` {
    val xs = Seq(Seq[String]("hi").par, Seq[String]("boom!").par, Seq[String]("hello").par).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not contain "hi"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotContainGenTraversable[String](xs, "hi")) + " in " + xs)
  }
  def `IndexedSeq(IndexedSeq[String]("hi").par, IndexedSeq[String]("boom!").par, IndexedSeq[String]("hello").par).par should throw TestFailedException with correct stack depth and message when 'traversable should have size' failed` {
    val xs = IndexedSeq(IndexedSeq[String]("hi").par, IndexedSeq[String]("boom!").par, IndexedSeq[String]("hello").par).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should have size 1
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstSizeEqualGenTraversable[String](xs, 1)) + " in " + xs)
  }
  def `IndexedSeq(IndexedSeq[String]("hi").par, IndexedSeq[String]("boom!").par, IndexedSeq[String]("hello").par).par should throw TestFailedException with correct stack depth and message when 'traversable should not have size' failed` {
    val xs = IndexedSeq(IndexedSeq[String]("hi").par, IndexedSeq[String]("boom!").par, IndexedSeq[String]("hello").par).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not have size (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstSizeNotEqualGenTraversable[String](xs, 2)) + " in " + xs)
  }
  def `IndexedSeq(IndexedSeq[String]("hi").par, IndexedSeq[String]("boom!").par, IndexedSeq[String]("hello").par).par should throw TestFailedException with correct stack depth and message when 'traversable should have length' failed` {
    val xs = IndexedSeq(IndexedSeq[String]("hi").par, IndexedSeq[String]("boom!").par, IndexedSeq[String]("hello").par).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should have length 1
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstSizeEqualGenTraversable[String](xs, 1)) + " in " + xs)
  }
  def `IndexedSeq(IndexedSeq[String]("hi").par, IndexedSeq[String]("boom!").par, IndexedSeq[String]("hello").par).par should throw TestFailedException with correct stack depth and message when 'traversable should not have length' failed` {
    val xs = IndexedSeq(IndexedSeq[String]("hi").par, IndexedSeq[String]("boom!").par, IndexedSeq[String]("hello").par).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not have length (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstSizeNotEqualGenTraversable[String](xs, 2)) + " in " + xs)
  }
  def `IndexedSeq(IndexedSeq[String]("hi").par, IndexedSeq[String]("boom!").par, IndexedSeq[String]("hello").par).par should throw TestFailedException with correct stack depth and message when 'traversable should contain' failed` {
    val xs = IndexedSeq(IndexedSeq[String]("hi").par, IndexedSeq[String]("boom!").par, IndexedSeq[String]("hello").par).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should contain ("hi")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstContainGenTraversable[String](xs, "hi")) + " in " + xs)
  }
  def `IndexedSeq(IndexedSeq[String]("hi").par, IndexedSeq[String]("boom!").par, IndexedSeq[String]("hello").par).par should throw TestFailedException with correct stack depth and message when 'traversable should not contain' failed` {
    val xs = IndexedSeq(IndexedSeq[String]("hi").par, IndexedSeq[String]("boom!").par, IndexedSeq[String]("hello").par).par
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not contain "hi"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotContainGenTraversable[String](xs, "hi")) + " in " + xs)
  }
  def `collection.mutable.Set(collection.mutable.Set[String]("hi"), collection.mutable.Set[String]("boom!"), collection.mutable.Set[String]("hello")) should throw TestFailedException with correct stack depth and message when 'traversable should have size' failed` {
    val xs = collection.mutable.Set(collection.mutable.Set[String]("hi"), collection.mutable.Set[String]("boom!"), collection.mutable.Set[String]("hello"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should have size 1
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstSizeEqualGenTraversable[String](xs, 1)) + " in " + xs)
  }
  def `collection.mutable.Set(collection.mutable.Set[String]("hi"), collection.mutable.Set[String]("boom!"), collection.mutable.Set[String]("hello")) should throw TestFailedException with correct stack depth and message when 'traversable should not have size' failed` {
    val xs = collection.mutable.Set(collection.mutable.Set[String]("hi"), collection.mutable.Set[String]("boom!"), collection.mutable.Set[String]("hello"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not have size (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstSizeNotEqualGenTraversable[String](xs, 2)) + " in " + xs)
  }
  def `collection.mutable.Set(collection.mutable.Set[String]("hi"), collection.mutable.Set[String]("boom!"), collection.mutable.Set[String]("hello")) should throw TestFailedException with correct stack depth and message when 'traversable should contain' failed` {
    val xs = collection.mutable.Set(collection.mutable.Set[String]("hi"), collection.mutable.Set[String]("boom!"), collection.mutable.Set[String]("hello"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should contain ("hi")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstContainGenTraversable[String](xs, "hi")) + " in " + xs)
  }
  def `collection.mutable.Set(collection.mutable.Set[String]("hi"), collection.mutable.Set[String]("boom!"), collection.mutable.Set[String]("hello")) should throw TestFailedException with correct stack depth and message when 'traversable should not contain' failed` {
    val xs = collection.mutable.Set(collection.mutable.Set[String]("hi"), collection.mutable.Set[String]("boom!"), collection.mutable.Set[String]("hello"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not contain "hi"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotContainGenTraversable[String](xs, "hi")) + " in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List(new collection.mutable.ListBuffer[String]() ++ List[String]("hi"), new collection.mutable.ListBuffer[String]() ++ List[String]("boom!"), new collection.mutable.ListBuffer[String]() ++ List[String]("hello")) should throw TestFailedException with correct stack depth and message when 'traversable should have size' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List(new collection.mutable.ListBuffer[String]() ++ List[String]("hi"), new collection.mutable.ListBuffer[String]() ++ List[String]("boom!"), new collection.mutable.ListBuffer[String]() ++ List[String]("hello"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should have size 1
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstSizeEqualGenTraversable[String](xs, 1)) + " in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List(new collection.mutable.ListBuffer[String]() ++ List[String]("hi"), new collection.mutable.ListBuffer[String]() ++ List[String]("boom!"), new collection.mutable.ListBuffer[String]() ++ List[String]("hello")) should throw TestFailedException with correct stack depth and message when 'traversable should not have size' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List(new collection.mutable.ListBuffer[String]() ++ List[String]("hi"), new collection.mutable.ListBuffer[String]() ++ List[String]("boom!"), new collection.mutable.ListBuffer[String]() ++ List[String]("hello"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not have size (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstSizeNotEqualGenTraversable[String](xs, 2)) + " in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List(new collection.mutable.ListBuffer[String]() ++ List[String]("hi"), new collection.mutable.ListBuffer[String]() ++ List[String]("boom!"), new collection.mutable.ListBuffer[String]() ++ List[String]("hello")) should throw TestFailedException with correct stack depth and message when 'traversable should have length' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List(new collection.mutable.ListBuffer[String]() ++ List[String]("hi"), new collection.mutable.ListBuffer[String]() ++ List[String]("boom!"), new collection.mutable.ListBuffer[String]() ++ List[String]("hello"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should have length 1
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstSizeEqualGenTraversable[String](xs, 1)) + " in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List(new collection.mutable.ListBuffer[String]() ++ List[String]("hi"), new collection.mutable.ListBuffer[String]() ++ List[String]("boom!"), new collection.mutable.ListBuffer[String]() ++ List[String]("hello")) should throw TestFailedException with correct stack depth and message when 'traversable should not have length' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List(new collection.mutable.ListBuffer[String]() ++ List[String]("hi"), new collection.mutable.ListBuffer[String]() ++ List[String]("boom!"), new collection.mutable.ListBuffer[String]() ++ List[String]("hello"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not have length (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstSizeNotEqualGenTraversable[String](xs, 2)) + " in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List(new collection.mutable.ListBuffer[String]() ++ List[String]("hi"), new collection.mutable.ListBuffer[String]() ++ List[String]("boom!"), new collection.mutable.ListBuffer[String]() ++ List[String]("hello")) should throw TestFailedException with correct stack depth and message when 'traversable should contain' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List(new collection.mutable.ListBuffer[String]() ++ List[String]("hi"), new collection.mutable.ListBuffer[String]() ++ List[String]("boom!"), new collection.mutable.ListBuffer[String]() ++ List[String]("hello"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should contain ("hi")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstContainGenTraversable[String](xs, "hi")) + " in " + xs)
  }
  def `new collection.mutable.ListBuffer() ++ List(new collection.mutable.ListBuffer[String]() ++ List[String]("hi"), new collection.mutable.ListBuffer[String]() ++ List[String]("boom!"), new collection.mutable.ListBuffer[String]() ++ List[String]("hello")) should throw TestFailedException with correct stack depth and message when 'traversable should not contain' failed` {
    val xs = new collection.mutable.ListBuffer() ++ List(new collection.mutable.ListBuffer[String]() ++ List[String]("hi"), new collection.mutable.ListBuffer[String]() ++ List[String]("boom!"), new collection.mutable.ListBuffer[String]() ++ List[String]("hello"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not contain "hi"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotContainGenTraversable[String](xs, "hi")) + " in " + xs)
  }
  def `collection.mutable.Seq(collection.mutable.Seq[String]("hi"), collection.mutable.Seq[String]("boom!"), collection.mutable.Seq[String]("hello")) should throw TestFailedException with correct stack depth and message when 'traversable should have size' failed` {
    val xs = collection.mutable.Seq(collection.mutable.Seq[String]("hi"), collection.mutable.Seq[String]("boom!"), collection.mutable.Seq[String]("hello"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should have size 1
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstSizeEqualGenTraversable[String](xs, 1)) + " in " + xs)
  }
  def `collection.mutable.Seq(collection.mutable.Seq[String]("hi"), collection.mutable.Seq[String]("boom!"), collection.mutable.Seq[String]("hello")) should throw TestFailedException with correct stack depth and message when 'traversable should not have size' failed` {
    val xs = collection.mutable.Seq(collection.mutable.Seq[String]("hi"), collection.mutable.Seq[String]("boom!"), collection.mutable.Seq[String]("hello"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not have size (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstSizeNotEqualGenTraversable[String](xs, 2)) + " in " + xs)
  }
  def `collection.mutable.Seq(collection.mutable.Seq[String]("hi"), collection.mutable.Seq[String]("boom!"), collection.mutable.Seq[String]("hello")) should throw TestFailedException with correct stack depth and message when 'traversable should have length' failed` {
    val xs = collection.mutable.Seq(collection.mutable.Seq[String]("hi"), collection.mutable.Seq[String]("boom!"), collection.mutable.Seq[String]("hello"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should have length 1
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstSizeEqualGenTraversable[String](xs, 1)) + " in " + xs)
  }
  def `collection.mutable.Seq(collection.mutable.Seq[String]("hi"), collection.mutable.Seq[String]("boom!"), collection.mutable.Seq[String]("hello")) should throw TestFailedException with correct stack depth and message when 'traversable should not have length' failed` {
    val xs = collection.mutable.Seq(collection.mutable.Seq[String]("hi"), collection.mutable.Seq[String]("boom!"), collection.mutable.Seq[String]("hello"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not have length (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstSizeNotEqualGenTraversable[String](xs, 2)) + " in " + xs)
  }
  def `collection.mutable.Seq(collection.mutable.Seq[String]("hi"), collection.mutable.Seq[String]("boom!"), collection.mutable.Seq[String]("hello")) should throw TestFailedException with correct stack depth and message when 'traversable should contain' failed` {
    val xs = collection.mutable.Seq(collection.mutable.Seq[String]("hi"), collection.mutable.Seq[String]("boom!"), collection.mutable.Seq[String]("hello"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should contain ("hi")
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstContainGenTraversable[String](xs, "hi")) + " in " + xs)
  }
  def `collection.mutable.Seq(collection.mutable.Seq[String]("hi"), collection.mutable.Seq[String]("boom!"), collection.mutable.Seq[String]("hello")) should throw TestFailedException with correct stack depth and message when 'traversable should not contain' failed` {
    val xs = collection.mutable.Seq(collection.mutable.Seq[String]("hi"), collection.mutable.Seq[String]("boom!"), collection.mutable.Seq[String]("hello"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not contain "hi"
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstNotContainGenTraversable[String](xs, "hi")) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq(collection.mutable.IndexedSeq[String]("hi"), collection.mutable.IndexedSeq[String]("boom!"), collection.mutable.IndexedSeq[String]("hello")) should throw TestFailedException with correct stack depth and message when 'traversable should have size' failed` {
    val xs = collection.mutable.IndexedSeq(collection.mutable.IndexedSeq[String]("hi"), collection.mutable.IndexedSeq[String]("boom!"), collection.mutable.IndexedSeq[String]("hello"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should have size 1
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstSizeEqualGenTraversable[String](xs, 1)) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq(collection.mutable.IndexedSeq[String]("hi"), collection.mutable.IndexedSeq[String]("boom!"), collection.mutable.IndexedSeq[String]("hello")) should throw TestFailedException with correct stack depth and message when 'traversable should not have size' failed` {
    val xs = collection.mutable.IndexedSeq(collection.mutable.IndexedSeq[String]("hi"), collection.mutable.IndexedSeq[String]("boom!"), collection.mutable.IndexedSeq[String]("hello"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not have size (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstSizeNotEqualGenTraversable[String](xs, 2)) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq(collection.mutable.IndexedSeq[String]("hi"), collection.mutable.IndexedSeq[String]("boom!"), collection.mutable.IndexedSeq[String]("hello")) should throw TestFailedException with correct stack depth and message when 'traversable should have length' failed` {
    val xs = collection.mutable.IndexedSeq(collection.mutable.IndexedSeq[String]("hi"), collection.mutable.IndexedSeq[String]("boom!"), collection.mutable.IndexedSeq[String]("hello"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should have length 1
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstSizeEqualGenTraversable[String](xs, 1)) + " in " + xs)
  }
  def `collection.mutable.IndexedSeq(collection.mutable.IndexedSeq[String]("hi"), collection.mutable.IndexedSeq[String]("boom!"), collection.mutable.IndexedSeq[String]("hello")) should throw TestFailedException with correct stack depth and message when 'traversable should not have length' failed` {
    val xs = collection.mutable.IndexedSeq(collection.mutable.IndexedSeq[String]("hi"), collection.mutable.IndexedSeq[String]("boom!"), collection.mutable.IndexedSeq[String]("hello"))
    val itr = xs.toIterator
    val e = intercept[exceptions.TestFailedException] {
      no(xs) should not have length (2)
    }
    val assertLineNumber = thisLineNumber - 2
    checkError(e, assertLineNumber, "InspectorShorthandsForNoFailedSpec1.scala", "'no' inspection failed, because 1 element satisfied the assertion block at index " + getIndex(xs, getFirstSizeNotEqualGenTraversable[String](xs, 2)) + " in " + xs)
  }
}
