package org.scalatest.inspectors.no

import org.scalatest._
import SharedHelpers._
import org.scalatest.matchers.{BePropertyMatcher, BePropertyMatchResult, HavePropertyMatcher, HavePropertyMatchResult}
import collection.GenTraversable
import collection.GenMap
class InspectorShorthandsForNoSucceededSpec extends Spec with Matchers {
  def `no(Set(1, 2, 3)) should succeed when no elements succeeded` {
    every(Set(1, 2, 3)) should be > 0
  }
  def `no(List(1, 2, 3)) should succeed when no elements succeeded` {
    every(List(1, 2, 3)) should be > 0
  }
  def `no(Seq(1, 2, 3)) should succeed when no elements succeeded` {
    every(Seq(1, 2, 3)) should be > 0
  }
  def `no(Array(1, 2, 3)) should succeed when no elements succeeded` {
    every(Array(1, 2, 3)) should be > 0
  }
  def `no(IndexedSeq(1, 2, 3)) should succeed when no elements succeeded` {
    every(IndexedSeq(1, 2, 3)) should be > 0
  }
  def `no(Vector(1, 2, 3)) should succeed when no elements succeeded` {
    every(Vector(1, 2, 3)) should be > 0
  }
  def `no(Set(1, 2, 3).par) should succeed when no elements succeeded` {
    every(Set(1, 2, 3).par) should be > 0
  }
  def `no(List(1, 2, 3).par) should succeed when no elements succeeded` {
    every(List(1, 2, 3).par) should be > 0
  }
  def `no(Seq(1, 2, 3).par) should succeed when no elements succeeded` {
    every(Seq(1, 2, 3).par) should be > 0
  }
  def `no(IndexedSeq(1, 2, 3).par) should succeed when no elements succeeded` {
    every(IndexedSeq(1, 2, 3).par) should be > 0
  }
  def `no(collection.mutable.Set(1, 2, 3)) should succeed when no elements succeeded` {
    every(collection.mutable.Set(1, 2, 3)) should be > 0
  }
  def `no(new collection.mutable.ListBuffer() ++ List(1, 2, 3)) should succeed when no elements succeeded` {
    every(new collection.mutable.ListBuffer() ++ List(1, 2, 3)) should be > 0
  }
  def `no(collection.mutable.Seq(1, 2, 3)) should succeed when no elements succeeded` {
    every(collection.mutable.Seq(1, 2, 3)) should be > 0
  }
  def `no(collection.mutable.IndexedSeq(1, 2, 3)) should succeed when no elements succeeded` {
    every(collection.mutable.IndexedSeq(1, 2, 3)) should be > 0
  }
  def `no(collection.mutable.Set(1, 2, 3).par) should succeed when no elements succeeded` {
    every(collection.mutable.Set(1, 2, 3).par) should be > 0
  }
  def `no((new collection.mutable.ListBuffer() ++ List(1, 2, 3)).par) should succeed when no elements succeeded` {
    every((new collection.mutable.ListBuffer() ++ List(1, 2, 3)).par) should be > 0
  }
  def `no(collection.mutable.Seq(1, 2, 3).par) should succeed when no elements succeeded` {
    every(collection.mutable.Seq(1, 2, 3).par) should be > 0
  }
  def `no(collection.mutable.IndexedSeq(1, 2, 3).par) should succeed when no elements succeeded` {
    every(collection.mutable.IndexedSeq(1, 2, 3).par) should be > 0
  }
}
