/*
 * Copyright 2001-2013 Artima, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.scalatest.tools.scalasbt

import org.scalatest._

class SuiteWithNestedSuites extends FunSuite {
  
  test("test 1") {}
  test("test 2") {}
  test("test 3") {}
  
  @DoNotDiscover
  class NestedDoNotDiscoverSuite extends FunSuite {
    override def suiteId = "nested 2"
          
    test("nested 2 test 1") {}
    test("nested 2 test 2") {}
    test("nested 2 test 3") {}
  }
  
  override def nestedSuites = 
    collection.immutable.IndexedSeq(
      new FunSuite() {
        override def suiteId = "nested 1"
          
        test("nested 1 test 1") {}
        test("nested 1 test 2") {}
        test("nested 1 test 3") {}
      }, 
      new NestedDoNotDiscoverSuite
    )
}
